set feedback off
set echo off
set term off
set verify off
set arraysize 2    
set heading off
-- removes the leading newline before the report
set embedded on
set pagesize 0
set long 900000
set linesize 2000
set trimspool on
set timing off

spool spool/oehr_ref_constraints.sql

SELECT dbms_metadata.get_dependent_ddl('REF_CONSTRAINT', table_name)
FROM user_tables t
WHERE table_name IN ('OEHR_ORDERS', 'OEHR_CUSTOMERS')
AND EXISTS (SELECT 1
FROM user_constraints
WHERE table_name = t.table_name
AND constraint_type = 'R');

spool off
host open ../spool/oehr_ref_constraints.sql

set term on
set feedback on
set verify on
set echo on

