set define off verify off feedback off
whenever sqlerror exit sql.sqlcode rollback

prompt --application/set_environment
prompt --application/delete_application
prompt --application/ui_types
prompt --application/create_application

begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_display_id=>nvl(wwv_flow_application_install.get_application_id,102)
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APPSTORE')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Sample Database Application')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'102')
,p_application_group=>20225228355874868
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
);
end;
/
prompt --application/shared_components/navigation/lists
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(716999994211876852)
,p_name=>'Application Navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(717000062629876852)
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(717000147386876852)
);

prompt --application/shared_components/files
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := 'FFD8FFE000104A46494600010001006000600000FFFE001F4C45414420546563686E6F6C6F6769657320496E632E2056312E303100FFDB008400020202020202020202020202020202020202020202020202020202020202020202020202030302020302';
wwv_flow_api.g_varchar2_table(2) := '020203040303030304040402030404040404030404030102020202020202020202030202020303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303FFC401A2000001050101010101';
wwv_flow_api.g_varchar2_table(3) := '0100000000000000000102030405060708090A0B0100030101010101010101010000000000000102030405060708090A0B100002010303020403050504040000017D01020300041105122131410613516107227114328191A1082342B1C11552D1F02433';
wwv_flow_api.g_varchar2_table(4) := '627282090A161718191A25262728292A3435363738393A434445464748494A535455565758595A636465666768696A737475767778797A838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2';
wwv_flow_api.g_varchar2_table(5) := 'D3D4D5D6D7D8D9DAE1E2E3E4E5E6E7E8E9EAF1F2F3F4F5F6F7F8F9FA1100020102040403040705040400010277000102031104052131061241510761711322328108144291A1B1C109233352F0156272D10A162434E125F11718191A262728292A353637';
wwv_flow_api.g_varchar2_table(6) := '38393A434445464748494A535455565758595A636465666768696A737475767778797A82838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE2E3E4E5E6E7E8E9EAF2F3';
wwv_flow_api.g_varchar2_table(7) := 'F4F5F6F7F8F9FAFFC000110800A6008B03011100021101031101FFDA000C03010002110311003F00FDFCA002800A002800A002800A002800A002800A002800A002800A002800A002800A002802B4975145F2E72DFDD18E3EA7803F1C5349BF85068BC8A5';
null;
end;
/
begin
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(66014713725081923)
,p_file_name=>'keyvisual.jpg'
,p_mime_type=>'image/jpeg'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
null;
end;
/
set verify on feedback on define on
prompt  ...done
