set define off
set verify off
set feedback off
WHENEVER SQLERROR EXIT SQL.SQLCODE ROLLBACK
begin wwv_flow.g_import_in_progress := true; end;
/
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
begin
select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';
execute immediate 'alter session set nls_numeric_characters=''.,''';
end;
/
prompt  WORKSPACE 2541800981839247
--
-- Workspace, User Group, User, and Team Development Export:
--   Date and Time:   17:11 Donnerstag August 20, 2015
--   Exported By:     SYSTEM
--   Export Type:     Workspace Export
--   Version:         4.2.5.00.08
--   Instance ID:     63126117280962
--
-- Import:
--   Using Instance Administration / Manage Workspaces
--   or
--   Using SQL*Plus as the Oracle user APEX_040200
 
begin
    wwv_flow_api.set_security_group_id(p_security_group_id=>2541800981839247);
end;
/
----------------
-- W O R K S P A C E
-- Creating a workspace will not create database schemas or objects.
-- This API creates only the meta data for this APEX workspace
prompt  Creating workspace WEBSHOP...
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
end;
/
begin
wwv_flow_fnd_user_api.create_company (
  p_id => 2542014767839305
 ,p_provisioning_company_id => 2541800981839247
 ,p_short_name => 'WEBSHOP'
 ,p_display_name => 'WEBSHOP'
 ,p_first_schema_provisioned => 'WEBSHOP'
 ,p_company_schemas => 'WEBSHOP'
 ,p_account_status => 'ASSIGNED'
 ,p_allow_plsql_editing => 'Y'
 ,p_allow_app_building_yn => 'Y'
 ,p_allow_sql_workshop_yn => 'Y'
 ,p_allow_websheet_dev_yn => 'Y'
 ,p_allow_team_development_yn => 'Y'
 ,p_allow_to_be_purged_yn => 'Y'
 ,p_allow_restful_services_yn => 'Y'
 ,p_source_identifier => 'WEBSHOP'
 ,p_path_prefix => 'WEBSHOP'
 ,p_workspace_image => wwv_flow_api.g_varchar2_table
);
end;
/
----------------
-- G R O U P S
--
prompt  Creating Groups...
----------------
-- U S E R S
-- User repository for use with APEX cookie-based authentication.
--
prompt  Creating Users...
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id      => '2542715940859559',
  p_user_name    => 'DENES.KUBICEK',
  p_first_name   => 'Denes',
  p_last_name    => 'Kubicek',
  p_description  => '',
  p_email_address=> 'deneskubicek@yahoo.de',
  p_web_password => 'C48DC7C54F837F5AB4FE4787F27FCC1A',
  p_web_password_format => 'HEX_ENCODED_DIGEST_V2',
  p_group_ids                    => '',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'WEBSHOP',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201506191035','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id      => '2541705960839247',
  p_user_name    => 'WEBSHOP',
  p_first_name   => 'Michael',
  p_last_name    => 'Geisler',
  p_description  => '',
  p_email_address=> 'michael.geisler@hepart.ch',
  p_web_password => '0E965531C44306DEC6FA54709A09E003',
  p_web_password_format => 'HEX_ENCODED_DIGEST_V2',
  p_group_ids                    => '',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'WEBSHOP',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201505270903','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
----------------
--Application Builder Preferences
--
----------------
--Click Count Logs
--
----------------
--csv data loading
--
----------------
--mail
--
----------------
--mail log
--
----------------
--app models
--
----------------
--password history
--
begin
  wwv_flow_api.create_password_history (
    p_id => 2542114554839314,
    p_user_id => 2541705960839247,
    p_password => 'F1D9375F458D31CEF2FEBB6D6A5BC5CA');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 2542827717859560,
    p_user_id => 2542715940859559,
    p_password => '3A804070467A8DBF7AE3F3D0748D93EE');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 2710816612103492,
    p_user_id => 2542715940859559,
    p_password => '08C417B81C2D0C4A0B7B79D4F01E2504');
end;
/
----------------
--preferences
--
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2726101270282042,
    p_user_id => 'BRIGITTE.NEIDHART@HEPART.CH',
    p_preference_name => 'FSP_IR_300_P410_W12381331914330915',
    p_attribute_value => '12382431214330930____12382431214330930');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2726304211282726,
    p_user_id => 'BRIGITTE.NEIDHART@HEPART.CH',
    p_preference_name => 'FSP_IR_300_P411_W12548515127391710',
    p_attribute_value => '12550301332408102____12550301332408102');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6685130858292749,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'ADVISOR_CHECKS',
    p_attribute_value => 'VALID_SQL_PLSQL_CODE:DML_PROCESSES');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2724402378334721,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FB_FLOW_ID',
    p_attribute_value => '300');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10636810862211735,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP4000_P34_R77549119545304597_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6685407440295409,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP4000_P385_R543179732397973700_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6685306401295100,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP4000_P4761_R746836409020161499_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6670830814334369,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP4000_P591_R168263311862841256_SORT',
    p_attribute_value => 'fsp_sort_3');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2711115511115303,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP_IR_4000_P1500_W3519715528105919',
    p_attribute_value => '3521529006112497____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10641510446192915,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP_IR_4000_P19_W451745617575288584',
    p_attribute_value => '451746507039288843____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2724302244334675,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP_IR_4000_P1_W3326806401130228',
    p_attribute_value => '3328003692130542____3328003692130542');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10636332008209062,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP_IR_4000_P4005_W48422219241609962',
    p_attribute_value => '48424005315623443____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10636728989210458,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP_IR_4000_P4050_W10642116325440827',
    p_attribute_value => '10643624462441172____10643624462441172');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10636530714209698,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP_IR_4000_P405_W3852329031687921',
    p_attribute_value => '3853503855690337____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10637721441213914,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP_IR_4000_P4101_W47836204953827708',
    p_attribute_value => '47837809399835130____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10635217935304788,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP_IR_4000_P4207_W47814307723191364',
    p_attribute_value => '47815210532192150____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10642512267194695,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'FSP_IR_4000_P939_W451352700445603348',
    p_attribute_value => '451353909559603360____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2724219060334601,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'PERSISTENT_ITEM_P1_DISPLAY_MODE',
    p_attribute_value => 'ICONS');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10636912593212274,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'PERSISTENT_ITEM_P34_ROWS',
    p_attribute_value => '50');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2724517052342978,
    p_user_id => 'DENES.KUBICEK',
    p_preference_name => 'USE_TREE_ON_P4150',
    p_attribute_value => 'N');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2724701783372998,
    p_user_id => 'DENESKUBICEK@YAHOO.DE',
    p_preference_name => 'FSP_IR_300_P27_W5964315983024690',
    p_attribute_value => '5966410934024697____5966410934024697');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10644508414956185,
    p_user_id => 'DENESKUBICEK@YAHOO.DE',
    p_preference_name => 'FSP_IR_300_P31_W3711226927213703',
    p_attribute_value => '3714424659228953____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10644706689956894,
    p_user_id => 'DENESKUBICEK@YAHOO.DE',
    p_preference_name => 'FSP_IR_300_P33_W5903303456696330',
    p_attribute_value => '5904324625701821____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6671109862346386,
    p_user_id => 'DENESKUBICEK@YAHOO.DE',
    p_preference_name => 'FSP_IR_300_P400_W6246224051046241',
    p_attribute_value => '6248004452046313____6248004452046313');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10643813991725646,
    p_user_id => 'DENESKUBICEK@YAHOO.DE',
    p_preference_name => 'FSP_IR_300_P40_W3394523831154124',
    p_attribute_value => '3395705188154945____3395705188154945');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10640830972327656,
    p_user_id => 'DENESKUBICEK@YAHOO.DE',
    p_preference_name => 'FSP_IR_300_P410_W12381331914330915',
    p_attribute_value => '12382431214330930____12382431214330930');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10643201021503769,
    p_user_id => 'DENESKUBICEK@YAHOO.DE',
    p_preference_name => 'FSP_IR_300_P42_W3414421042011988',
    p_attribute_value => '3415517739011993____3415517739011993');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6670214631313748,
    p_user_id => 'DENESKUBICEK@YAHOO.DE',
    p_preference_name => 'FSP_IR_300_P45_W4437004128011735',
    p_attribute_value => '4438629992011741____4438629992011741');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10644130017900516,
    p_user_id => 'MICHAEL.GEISLER@HEPART.CH',
    p_preference_name => 'FSP_IR_300_P31_W3711226927213703',
    p_attribute_value => '3714424659228953____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10644314274907844,
    p_user_id => 'MICHAEL.GEISLER@HEPART.CH',
    p_preference_name => 'FSP_IR_300_P33_W5903303456696330',
    p_attribute_value => '5904324625701821____5904324625701821');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10645228027962240,
    p_user_id => 'MICHAEL.GEISLER@HEPART.CH',
    p_preference_name => 'FSP_IR_300_P42_W3414421042011988',
    p_attribute_value => '3415517739011993____3415517739011993');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10644901082959530,
    p_user_id => 'MICHAEL.GEISLER@HEPART.CH',
    p_preference_name => 'FSP_IR_300_P45_W4437004128011735',
    p_attribute_value => '4438629992011741____4438629992011741');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2725405829062196,
    p_user_id => 'WEBSHOP',
    p_preference_name => 'FB_FLOW_ID',
    p_attribute_value => '300');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2725825950081059,
    p_user_id => 'WEBSHOP',
    p_preference_name => 'FSP4000_P385_R543179732397973700_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2725532267063961,
    p_user_id => 'WEBSHOP',
    p_preference_name => 'FSP4000_P4761_R746836409020161499_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2712313962937887,
    p_user_id => 'WEBSHOP',
    p_preference_name => 'FSP_IR_4000_P1500_W3519715528105919',
    p_attribute_value => '3521529006112497____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2725325873062165,
    p_user_id => 'WEBSHOP',
    p_preference_name => 'FSP_IR_4000_P1_W3326806401130228',
    p_attribute_value => '3328003692130542____3328003692130542');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2725717958078802,
    p_user_id => 'WEBSHOP',
    p_preference_name => 'FSP_IR_4000_P4751_W30840414634229054',
    p_attribute_value => '30841408940231502____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2542517162849182,
    p_user_id => 'WEBSHOP',
    p_preference_name => 'FSP_IR_4350_P55_W10236304983033455',
    p_attribute_value => '10238325656034902____10238325656034902');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2725221205062146,
    p_user_id => 'WEBSHOP',
    p_preference_name => 'PERSISTENT_ITEM_P1_DISPLAY_MODE',
    p_attribute_value => 'ICONS');
end;
/
----------------
--service mods
--
----------------
--query builder
--
----------------
--sql scripts
--
----------------
--sql commands
--
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 10676724829433439
 ,p_command => 
'ALTER USER WEBSHOP IDENTIFIED BY "99*Programme+1"'
    ,p_created_by => 'DENES.KUBICEK'
    ,p_created_on => to_date('201508161115','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'WEBSHOP');
end;
/
----------------
--user access log
--
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'DENES.KUBICEK',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508151110','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'DENES.KUBICEK',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508161114','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'DENES.KUBICEK',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508161201','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'WEBSHOP',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508161007','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508141037','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 1,
    p_custom_status_text => 'Invalid Login Credentials');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'WEBSHOP',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508141037','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'DENES.KUBICEK',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508141627','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'DENESKUBICEK@YAHOO.DE',
    p_auth_method => 'Hepart Webshop Custom',
    p_app => 300,
    p_owner => 'WEBSHOP',
    p_access_date => to_date('201508141628','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'DENES.KUBICEK',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508141825','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'DENESKUBICEK@YAHOO.DE',
    p_auth_method => 'Hepart Webshop Custom',
    p_app => 300,
    p_owner => 'WEBSHOP',
    p_access_date => to_date('201508171010','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'DENESKUBICEK@YAHOO.DE',
    p_auth_method => 'Hepart Webshop Custom',
    p_app => 300,
    p_owner => 'WEBSHOP',
    p_access_date => to_date('201508171029','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'DENES.KUBICEK',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508171008','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'DENES.KUBICEK',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508171013','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'DENES.KUBICEK',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508171138','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
 
prompt ...RESTful Services
 
-- SET SCHEMA
 
begin
 
   wwv_flow_api.g_id_offset := 0;
   wwv_flow_hint.g_schema   := 'WEBSHOP';
   wwv_flow_hint.check_schema_privs;
 
end;
/

 
--------------------------------------------------------------------
prompt  SCHEMA WEBSHOP - User Interface Defaults, Table Defaults
--
-- Import using sqlplus as the Oracle user: APEX_040200
-- Exported 17:11 Donnerstag August 20, 2015 by: 
--
 
--------------------------------------------------------------------
prompt User Interface Defaults, Attribute Dictionary
--
-- Exported 17:11 Donnerstag August 20, 2015 by: 
--
-- SHOW EXPORTING WORKSPACE
 
begin
 
   wwv_flow_api.g_id_offset := 0;
   wwv_flow_hint.g_exp_workspace := 'WEBSHOP';
 
end;
/

commit;
begin
execute immediate 'begin sys.dbms_session.set_nls( param => ''NLS_NUMERIC_CHARACTERS'', value => '''''''' || replace(wwv_flow_api.g_nls_numeric_chars,'''''''','''''''''''') || ''''''''); end;';
end;
/
set verify on
set feedback on
set define on
prompt  ...done
