set define off
set verify off
set feedback off
WHENEVER SQLERROR EXIT SQL.SQLCODE ROLLBACK
begin wwv_flow.g_import_in_progress := true; end;
/
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
begin
select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';
execute immediate 'alter session set nls_numeric_characters=''.,''';
end;
/
prompt  WORKSPACE 2031917327559678
--
-- Workspace, User Group, User, and Team Development Export:
--   Date and Time:   17:11 Donnerstag August 20, 2015
--   Exported By:     SYSTEM
--   Export Type:     Workspace Export
--   Version:         4.2.5.00.08
--   Instance ID:     63126117280962
--
-- Import:
--   Using Instance Administration / Manage Workspaces
--   or
--   Using SQL*Plus as the Oracle user APEX_040200
 
begin
    wwv_flow_api.set_security_group_id(p_security_group_id=>2031917327559678);
end;
/
----------------
-- W O R K S P A C E
-- Creating a workspace will not create database schemas or objects.
-- This API creates only the meta data for this APEX workspace
prompt  Creating workspace FRAGE_WKS...
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
end;
/
begin
wwv_flow_fnd_user_api.create_company (
  p_id => 2032006144559720
 ,p_provisioning_company_id => 2031917327559678
 ,p_short_name => 'FRAGE_WKS'
 ,p_display_name => 'FRAGE_WKS'
 ,p_first_schema_provisioned => 'FRGBG'
 ,p_company_schemas => 'FRGBG'
 ,p_account_status => 'ASSIGNED'
 ,p_allow_plsql_editing => 'Y'
 ,p_allow_app_building_yn => 'Y'
 ,p_allow_sql_workshop_yn => 'Y'
 ,p_allow_websheet_dev_yn => 'Y'
 ,p_allow_team_development_yn => 'Y'
 ,p_allow_to_be_purged_yn => 'Y'
 ,p_allow_restful_services_yn => 'Y'
 ,p_source_identifier => 'FRAGE_WK'
 ,p_path_prefix => 'FRAGE_WKS'
 ,p_builder_notification_message => '<h1 style="font-size:30px;">!!! TEST !!!</h1>'
 ,p_workspace_image => wwv_flow_api.g_varchar2_table
);
end;
/
----------------
-- G R O U P S
--
prompt  Creating Groups...
----------------
-- U S E R S
-- User repository for use with APEX cookie-based authentication.
--
prompt  Creating Users...
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id      => '2031829602559678',
  p_user_name    => 'ADMIN',
  p_first_name   => 'Michael',
  p_last_name    => 'Geisler',
  p_description  => '',
  p_email_address=> 'michael.geisler@goi.ch',
  p_web_password => 'D697F310B1C0813B5E3558AB61D6C914',
  p_web_password_format => 'HEX_ENCODED_DIGEST_V2',
  p_group_ids                    => '',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'FRGBG',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201209201026','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'N',
  p_first_password_use_occurred  => 'N',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id      => '2045627434584434',
  p_user_name    => 'BRIGITTE.NEIDHART',
  p_first_name   => 'Brigitte',
  p_last_name    => 'Neidhart',
  p_description  => '',
  p_email_address=> 'Brigitte@boelle-neidhart.de',
  p_web_password => '09B65547B50E16D0DF9FCC80B3368EB1',
  p_web_password_format => 'HEX_ENCODED_DIGEST_V2',
  p_group_ids                    => '',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'FRGBG',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201409251255','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id      => '6019210247887489',
  p_user_name    => 'DENES.KUBICEK',
  p_first_name   => 'Denes',
  p_last_name    => 'Kubicek',
  p_description  => 'Entwicklung Webshop',
  p_email_address=> 'deneskubicek@yahoo.de',
  p_web_password => 'D5785D5CDB40E42C55ADD3E97FAE6BFE',
  p_web_password_format => 'HEX_ENCODED_DIGEST_V2',
  p_group_ids                    => '',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'FRGBG',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201504120000','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id      => '2237302692307109',
  p_user_name    => 'DIETMAR.AUST',
  p_first_name   => 'Dietmar',
  p_last_name    => 'Aust',
  p_description  => '',
  p_email_address=> 'dietmar.aust@opal-consulting.de',
  p_web_password => '8EFC78D8AEAB907B0D749EE777688ECA',
  p_web_password_format => 'HEX_ENCODED_DIGEST_V2',
  p_group_ids                    => '',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'FRGBG',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201301071411','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id      => '2420931745556929',
  p_user_name    => 'MARK.KLATT',
  p_first_name   => 'Mark',
  p_last_name    => 'Klatt',
  p_description  => '',
  p_email_address=> 'mark.klatt@hepart.ch',
  p_web_password => '4E6ACC7CE28EAF0289AD6CB760D81682',
  p_web_password_format => 'HEX_ENCODED_DIGEST_V2',
  p_group_ids                    => '',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'FRGBG',
  p_account_locked               => 'Y',
  p_account_expiry               => to_date('201410300000','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'N',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id      => '2046112674589632',
  p_user_name    => 'MICHAEL.GEISLER',
  p_first_name   => 'Michael',
  p_last_name    => 'Geisler',
  p_description  => '',
  p_email_address=> 'michael.geisler@goi.ch',
  p_web_password => 'D9A2A420354D1CA65978318BFFEE6B2C',
  p_web_password_format => 'HEX_ENCODED_DIGEST_V2',
  p_group_ids                    => '',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'frgbg',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201407091135','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id      => '4195116705078882',
  p_user_name    => 'SASCHA.LENZ',
  p_first_name   => 'Sascha',
  p_last_name    => 'Lenz',
  p_description  => '',
  p_email_address=> 'sascha.lenz@hepart.ch',
  p_web_password => 'C03B9858CBB13098403998DDAAE3B6B7',
  p_web_password_format => 'HEX_ENCODED_DIGEST_V2',
  p_group_ids                    => '',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'FRGBG',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201409011418','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
----------------
--Application Builder Preferences
--
----------------
--Click Count Logs
--
----------------
--csv data loading
--
----------------
--mail
--
----------------
--mail log
--
----------------
--app models
--
----------------
--password history
--
begin
  wwv_flow_api.create_password_history (
    p_id => 2421011499557003,
    p_user_id => 2420931745556929,
    p_password => '83F5E6E7B94890EA00338DFEA0718333');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 3942806399247345,
    p_user_id => 2046112674589632,
    p_password => '9E9628D5468BB8F03A9121EDD69E253A');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 4667503940893051,
    p_user_id => 4195116705078882,
    p_password => '276EAE3F07A9A7CA2FD5C387933215F8');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 6022818012218826,
    p_user_id => 6019210247887489,
    p_password => 'C02168A1727103877EE4D7BB375CA51D');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 6280516997980006,
    p_user_id => 6019210247887489,
    p_password => 'C02168A1727103877EE4D7BB375CA51D');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 6376228413236768,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 3802823751346003,
    p_user_id => 2237302692307109,
    p_password => '29BF1372BBEA473DECF2F9B5CF777F61');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 3921910653059901,
    p_user_id => 2237302692307109,
    p_password => '29BF1372BBEA473DECF2F9B5CF777F61');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 3922317233061777,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 3923221304081846,
    p_user_id => 2237302692307109,
    p_password => 'C4936996F2CFF3A449D9B56C4759A09E');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 3936804731605805,
    p_user_id => 2046112674589632,
    p_password => '9E9628D5468BB8F03A9121EDD69E253A');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 4197707374383510,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 4302906836895707,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 4349532312092242,
    p_user_id => 4195116705078882,
    p_password => '276EAE3F07A9A7CA2FD5C387933215F8');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 5701431704895312,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 6085730220635346,
    p_user_id => 4195116705078882,
    p_password => '276EAE3F07A9A7CA2FD5C387933215F8');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 6113117164831572,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 6288706516382711,
    p_user_id => 4195116705078882,
    p_password => '276EAE3F07A9A7CA2FD5C387933215F8');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 3990814406588955,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 4037011495877141,
    p_user_id => 2046112674589632,
    p_password => '9E9628D5468BB8F03A9121EDD69E253A');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 5024012800292788,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 5039621148604277,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 3811324668562694,
    p_user_id => 2031829602559678,
    p_password => '9E9628D5468BB8F03A9121EDD69E253A');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 3864120004362429,
    p_user_id => 2045627434584434,
    p_password => '46302D7003C1C5E29569D7A8D19F73C2');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 4721409386888103,
    p_user_id => 2045627434584434,
    p_password => '28CA3150598EC873231A46DBF236335F');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 4195219000078893,
    p_user_id => 4195116705078882,
    p_password => '20CE6A2459FB58F7CBB7CD7EC153ACA1');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 4195512774143954,
    p_user_id => 4195116705078882,
    p_password => '276EAE3F07A9A7CA2FD5C387933215F8');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 5042031180523646,
    p_user_id => 4195116705078882,
    p_password => '276EAE3F07A9A7CA2FD5C387933215F8');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 6018922798872241,
    p_user_id => 2046112674589632,
    p_password => '9E9628D5468BB8F03A9121EDD69E253A');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 6019325625887490,
    p_user_id => 6019210247887489,
    p_password => '71D136B41F1075579B5A7815038359D7');
end;
/
begin
  wwv_flow_api.create_password_history (
    p_id => 2540223540710341,
    p_user_id => 6019210247887489,
    p_password => 'D9A440A2EB3EE3C600539AD0ED478968');
end;
/
----------------
--preferences
--
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2536218402168173,
    p_user_id => 'ADRIJANA.SADIKI',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10653907975307018,
    p_user_id => 'ADRIJANA.SADIKI',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2516216935621434,
    p_user_id => 'ALEXANDRA.SCHMID',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2516115765611638,
    p_user_id => 'ALEXANDRA.SCHMID',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_16_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4408914222430939,
    p_user_id => 'ANGELIKA.SCHMIDT',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4409013660440283,
    p_user_id => 'ANGELIKA.SCHMIDT',
    p_preference_name => 'FSP102_P203_R2054113594054535_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4408615373115421,
    p_user_id => 'ANGELIKA.SCHMIDT',
    p_preference_name => 'FSP_IR_102_P400_W6053825163343768',
    p_attribute_value => '6055506144380624____6055506144380624');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4112925387397415,
    p_user_id => 'BETTINA.ZAHND',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4954212132218116,
    p_user_id => 'BETTINA.ZAHND',
    p_preference_name => 'FSP102_P323_R5254217516215655_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4954412042218128,
    p_user_id => 'BETTINA.ZAHND',
    p_preference_name => 'FSP102_P323_R5259623815397283_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4954320305218125,
    p_user_id => 'BETTINA.ZAHND',
    p_preference_name => 'FSP102_P323_R5544926418582789_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5260819080526075,
    p_user_id => 'BETTINA.ZAHND',
    p_preference_name => 'FSP102_P326_R8330813148402781_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4113126020520226,
    p_user_id => 'BETTINA.ZAHND',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4953902263135377,
    p_user_id => 'BETTINA.ZAHND',
    p_preference_name => 'FSP_IR_102_P322_W5143800403959482',
    p_attribute_value => '5145827447959499____5145827447959499');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4954130009213587,
    p_user_id => 'BETTINA.ZAHND',
    p_preference_name => 'FSP_IR_102_P324_W5515630770830681',
    p_attribute_value => '5518615736830975____5518615736830975');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6116602412297670,
    p_user_id => 'BETTINA.ZAHND',
    p_preference_name => 'FSP_IR_102_P327_W10241801125416319',
    p_attribute_value => '10242510593416509____10242510593416509');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5916416413710208,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2433824922161596,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP102_P306_R3108001207234471_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5856611201139452,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5856711201139452,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2433929995229302,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP118_P10_R3529932272560795_SORT',
    p_attribute_value => 'fsp_sort_3');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6025902687051584,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP118_P71_R1567731520790407_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2523829649389950,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP118_P77_R9361216807648462_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5856415588136657,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____4293704567261241');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2518911259118675,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP_IR_118_P24_W4465303097569284',
    p_attribute_value => '4465902357569581____4465902357569581');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2524411010640715,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP_IR_118_P300_W6130821010107710',
    p_attribute_value => '6132722890108828____6132722890108828');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6025610921045340,
    p_user_id => 'BLERIM.KRESNIQI',
    p_preference_name => 'FSP_IR_118_P70_W1556022197771347',
    p_attribute_value => '1558917519771357_N___1558917519771357');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3802401625292263,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'ADVISOR_CHECKS',
    p_attribute_value => 'SUBSTITUTION_SYNTAX:COLUMN_SYNTAX:BIND_VARIABLE_SYNTAX:APPL_PAGE_ITEM_REF:PAGE_NUMBER_EXISTS:VALID_SQL_PLSQL_CODE:DML_PROCESSES:BRANCH_SEQUENCE:WHEN_BUTTON_PRESSED:BUTTON_DA_COMPATIBLE:TARGET_PAGE_AUTH:SQL_INJECTION:IS_ITEM_OF_TARGET_PAGE:PAGE_ITEM_REF_AS_STRING:CLEAR_CACHE_PAGE_NUMBER:ITEM_NAME_LENGTH:BUTTON_DA_INCONSISTENT_REFS:V_FUNCTION_IN_SQL:HARDCODED_APPLICATION_ID:REPORT_DEFAULT_ORDER:HAS_HELP_TEXT:VALIDATION_ASSOCIATED_ITEM');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3776708266908666,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FB_FLOW_ID',
    p_attribute_value => '118');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3801315206201619,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4725804828228714,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4875909063597760,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP102_P306_R3108001207234471_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3801028234195955,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4243831887485240,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP102_P323_R5254217516215655_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4244012442485248,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP102_P323_R5259623815397283_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4243902321485245,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP102_P323_R5544926418582789_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2523724210358331,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP102_P326_R8330813148402781_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3926111136945795,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP102_P355_R5387209796749941_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3925523753760179,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP104_P3_R5386709695634321_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3801412744248199,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P150_R3132828433335317_SORT',
    p_attribute_value => 'fsp_sort_3');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4162014039450506,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P232_R4097432284791774_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4162106729495744,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P233_R4296509304753586_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4162208461496201,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P234_R4422304505103435_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2625912049921488,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P26_R12703203921580260_SORT',
    p_attribute_value => 'fsp_sort_2_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3802109759256814,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P30_R4605827708767335_SORT',
    p_attribute_value => 'fsp_sort_9_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3801720363250415,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P71_R1567731520790407_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5318920829453857,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P72_R5027005515342360_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5318710075299279,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P76_R8065119316035761_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3801824519251577,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P81_R1905125714038958_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3801924519251634,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P82_R1821905451094681_SORT',
    p_attribute_value => 'fsp_sort_5');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5037402357908957,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P82_R4613526145327235_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3802031791253756,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P84_R1979101420524084_SORT',
    p_attribute_value => 'fsp_sort_18_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3933731585870730,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP118_P900_R3960131884214678_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3856830096575795,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP302_P1_R5157324976021759_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6370616880382322,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP4000_P300_R25453825731390673_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2305910828921793,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP4000_P4200_R98042408475113688_SORT',
    p_attribute_value => 'fsp_sort_2_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6370718958382914,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP4000_P423_R172114705298474212_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5386027231228502,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP4000_P4410_R29873113508481210_SORT',
    p_attribute_value => 'fsp_sort_2_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6370515841381994,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP4000_P532_R177170600254216246_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3923407545134695,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP4000_P591_R168263311862841256_SORT',
    p_attribute_value => 'fsp_sort_3');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5014621738394304,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP4000_P596_R228200813219345309_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6370822421383948,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP4000_P653_R172116901966482713_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6370929693386034,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP4000_P675_R172118613741486068_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3800900179195404,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____4293704567261241');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4243703615484647,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_102_P322_W5143800403959482',
    p_attribute_value => '5145827447959499____5145827447959499');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4243408144482516,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_102_P324_W5515630770830681',
    p_attribute_value => '5518615736830975____5518615736830975');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3801228850197316,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_102_P350_W4836418624282487',
    p_attribute_value => '4837827546282493____4837827546282493');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6372718233019031,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P142_W6464805390244333',
    p_attribute_value => '6472215206258295____6472215206258295');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6372916724019665,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P143_W6488421670121560',
    p_attribute_value => '6490227476122887____6490227476122887');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2625813522919151,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P24_W4465303097569284',
    p_attribute_value => '4465902357569581____4465902357569581');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4349417607959080,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P34_W5780715497452523',
    p_attribute_value => '5783129923453321____5783129923453321');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4161908781425121,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P36_W2682023645608081',
    p_attribute_value => '2684810502610589____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2511405854927989,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P430_W9402323752784425',
    p_attribute_value => '9402918845784439____9402918845784439');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2511207580927232,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P433_W10131108482690634',
    p_attribute_value => '10133902132698507____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3802315429264296,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P51_W2611410755155531',
    p_attribute_value => '2613411732156066____2613411732156066');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2520910676980095,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P62_W5582520906556701',
    p_attribute_value => '5584326515563080____5584326515563080');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3801614795249441,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P70_W1556022197771347',
    p_attribute_value => '1558917519771357____1558917519771357');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3924004689622450,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P74_W7967723203934748',
    p_attribute_value => '7969031269934756____7969031269934756');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5317415401666858,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_118_P86_W8823408315894606',
    p_attribute_value => '8827313540894633____8827313540894633');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3747422377878478,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P1500_W3519715528105919',
    p_attribute_value => '3521529006112497____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3856021462743570,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P19_W451745617575288584',
    p_attribute_value => '451746507039288843____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3776610495908650,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P1_W3326806401130228',
    p_attribute_value => '3328003692130542____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3818221013906572,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P4070_W47949429235486335',
    p_attribute_value => '47951124794493113____47951124794493113');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3777811138914035,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P4100_W3727618522871356',
    p_attribute_value => '3728530690872449____3728530690872449');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3929511591004547,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P4207_W47814307723191364',
    p_attribute_value => '47815210532192150____47815210532192150');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5385904407227403,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P4400_W27796519609844319',
    p_attribute_value => '27798220762844327____27798220762844327');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3817713706879570,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P801_W47918412797645641',
    p_attribute_value => '47921608032702994____47921608032702994');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3783211532959488,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P89_W444642604334435028',
    p_attribute_value => '444643031700435663____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2343112045656555,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4000_P959_W483659607062898467',
    p_attribute_value => '483660631524898748____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5042906413536492,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4350_P53_W34954404769221837',
    p_attribute_value => '34956410007247564____34956410007247564');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3802707604343892,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'FSP_IR_4350_P55_W10236304983033455',
    p_attribute_value => '10238325656034902____10238325656034902');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3776906737912381,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'P4150_GET_STARTED_CONFIRMED',
    p_attribute_value => 'Y');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3776426692908628,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'PERSISTENT_ITEM_P1_DISPLAY_MODE',
    p_attribute_value => 'ICONS');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3777007776912664,
    p_user_id => 'BRIGITTE.NEIDHART',
    p_preference_name => 'USE_TREE_ON_P4150',
    p_attribute_value => 'N');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5595503642903997,
    p_user_id => 'CLAUDIA.ALDER',
    p_preference_name => 'FSP102_P306_R3108001207234471_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3934027476897918,
    p_user_id => 'CLAUDIA.GOLDSTEIN.2',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5388608641481588,
    p_user_id => 'CORINNA.GÖHLER.1',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5392212679260919,
    p_user_id => 'CORINNA.GÖHLER.1',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5392103219260128,
    p_user_id => 'CORINNA.GÖHLER.1',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____4293704567261241');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6059900974082261,
    p_user_id => 'DENES',
    p_preference_name => 'FB_FLOW_ID',
    p_attribute_value => '102');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6086511632905822,
    p_user_id => 'DENES',
    p_preference_name => 'FSP4000_P34_R77549119545304597_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6023329169219627,
    p_user_id => 'DENES',
    p_preference_name => 'FSP_IR_4000_P1500_W3519715528105919',
    p_attribute_value => '3521529006112497____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6061407964385915,
    p_user_id => 'DENES',
    p_preference_name => 'FSP_IR_4000_P19_W451745617575288584',
    p_attribute_value => '451746507039288843____X');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6059831795082241,
    p_user_id => 'DENES',
    p_preference_name => 'FSP_IR_4000_P1_W3326806401130228',
    p_attribute_value => '3328003692130542____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6060730505344084,
    p_user_id => 'DENES',
    p_preference_name => 'FSP_IR_4000_P4070_W47949429235486335',
    p_attribute_value => '47951124794493113____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6060830289344084,
    p_user_id => 'DENES',
    p_preference_name => 'FSP_IR_4000_P4070_W47949429235486335',
    p_attribute_value => '47951124794493113____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6061026826360965,
    p_user_id => 'DENES',
    p_preference_name => 'FSP_IR_4000_P4100_W3727618522871356',
    p_attribute_value => '3728530690872449____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6060405513325270,
    p_user_id => 'DENES',
    p_preference_name => 'FSP_IR_4000_P801_W47918412797645641',
    p_attribute_value => '47921608032702994____47921608032702994');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6061904170386632,
    p_user_id => 'DENES',
    p_preference_name => 'FSP_IR_4000_P939_W451352700445603348',
    p_attribute_value => '451353909559603360____451353909559603360');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6060018304084233,
    p_user_id => 'DENES',
    p_preference_name => 'P4150_GET_STARTED_CONFIRMED',
    p_attribute_value => 'Y');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6059705280082192,
    p_user_id => 'DENES',
    p_preference_name => 'PERSISTENT_ITEM_P1_DISPLAY_MODE',
    p_attribute_value => 'ICONS');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6086615010925777,
    p_user_id => 'DENES',
    p_preference_name => 'PERSISTENT_ITEM_P34_ROWS',
    p_attribute_value => '15');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6060118997084402,
    p_user_id => 'DENES',
    p_preference_name => 'USE_TREE_ON_P4150',
    p_attribute_value => 'N');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3803804835350029,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'ADVISOR_CHECKS',
    p_attribute_value => 'SUBSTITUTION_SYNTAX:COLUMN_SYNTAX:BIND_VARIABLE_SYNTAX:APPL_PAGE_ITEM_REF:PAGE_NUMBER_EXISTS:VALID_SQL_PLSQL_CODE:DML_PROCESSES:BRANCH_SEQUENCE:WHEN_BUTTON_PRESSED:BUTTON_DA_COMPATIBLE:TARGET_PAGE_AUTH:SQL_INJECTION:IS_ITEM_OF_TARGET_PAGE:PAGE_ITEM_REF_AS_STRING:CLEAR_CACHE_PAGE_NUMBER:ITEM_NAME_LENGTH:BUTTON_DA_INCONSISTENT_REFS:V_FUNCTION_IN_SQL:HARDCODED_APPLICATION_ID:REPORT_DEFAULT_ORDER:HAS_HELP_TEXT:VALIDATION_ASSOCIATED_ITEM');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3803702662349018,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'FB_FLOW_ID',
    p_attribute_value => '102');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3935316288930211,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'FSP4000_P4200_R98042408475113688_SORT',
    p_attribute_value => 'fsp_sort_2_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3924313882982809,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'FSP_IR_100_P2_W10240224442889982',
    p_attribute_value => '10241119383890160____10241119383890160');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3803329804348812,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'FSP_IR_4000_P1500_W3519715528105919',
    p_attribute_value => '3521529006112497____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3803617517349009,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'FSP_IR_4000_P1_W3326806401130228',
    p_attribute_value => '3328003692130542____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3815517808750499,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'FSP_IR_4000_P801_W47918412797645641',
    p_attribute_value => '47921608032702994____47921608032702994');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3923102115076607,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'FSP_IR_4350_P55_W10236304983033455',
    p_attribute_value => '10238325656034902____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3815213212682389,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'P4150_GET_STARTED_CONFIRMED',
    p_attribute_value => 'Y');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3803529373348998,
    p_user_id => 'DIETMAR.AUST',
    p_preference_name => 'PERSISTENT_ITEM_P1_DISPLAY_MODE',
    p_attribute_value => 'ICONS');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3934405116052263,
    p_user_id => 'DIRK.HAEFNER',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3934117265932827,
    p_user_id => 'DORIS.CICHON',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 14609920873544911,
    p_user_id => 'EILEEN.SCHATZ',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4295222960614491,
    p_user_id => 'FAS-TRAINING',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4295109670601262,
    p_user_id => 'FAS-TRAINING',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6377815919168769,
    p_user_id => 'FAS-TRAINING',
    p_preference_name => 'FSP102_P306_R3108001207234471_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3923812018609072,
    p_user_id => 'GOI.B',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3923701683608661,
    p_user_id => 'GOI.B',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____4293704567261241');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4820129130589454,
    p_user_id => 'GREGORY.BROWN',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3933928730888867,
    p_user_id => 'GUENTER.HARTNER',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3934212594969283,
    p_user_id => 'HEIKE.PETERS',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3933804489881867,
    p_user_id => 'HERMANN.GUGGEMOOS',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4788704752628919,
    p_user_id => 'JENNIFER.WITT',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4875000398769158,
    p_user_id => 'JENNIFER.WITT',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5766413219691463,
    p_user_id => 'JENNIFER.WITT',
    p_preference_name => 'FSP102_P203_R2054113594054535_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5023701766617828,
    p_user_id => 'JENNIFER.WITT',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5857229835315147,
    p_user_id => 'JENNIFER.WITT',
    p_preference_name => 'FSP118_P81_R1905125714038958_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5857329835315209,
    p_user_id => 'JENNIFER.WITT',
    p_preference_name => 'FSP118_P82_R1821905451094681_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5857410573319041,
    p_user_id => 'JENNIFER.WITT',
    p_preference_name => 'FSP118_P84_R1979101420524084_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5023603011617150,
    p_user_id => 'JENNIFER.WITT',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____4293704567261241');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5857127678314414,
    p_user_id => 'JENNIFER.WITT',
    p_preference_name => 'FSP_IR_118_P86_W8823408315894606',
    p_attribute_value => '8827313540894633____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6376111136484235,
    p_user_id => 'JENNIFER.WITT.6',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6121117995641180,
    p_user_id => 'JENNY.WITT',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3934323938991538,
    p_user_id => 'KALTHOFF',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10652703132366594,
    p_user_id => 'KATJA.MEYERHOFER',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10652631818332013,
    p_user_id => 'KATJA.MEYERHOFER',
    p_preference_name => 'FSP_IR_102_P400_W6053825163343768',
    p_attribute_value => '6055506144380624____6055506144380624');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2516308408628387,
    p_user_id => 'LAURA.BONANNO',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2516413519648849,
    p_user_id => 'LAURA.BONANNO',
    p_preference_name => 'FSP102_P203_R2054113594054535_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10654414740472731,
    p_user_id => 'LAVDIM.DJAFERI',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10654028874596891,
    p_user_id => 'LAVDIM.DJAFERI',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4036719546460253,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4788808140724584,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4407528379488041,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP102_P203_R2054113594054535_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4407732665498708,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP102_P217_R2752419312826784_SORT',
    p_attribute_value => 'fsp_sort_7_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4876606274163129,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP102_P306_R3108001207234471_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4112215576724659,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4064505048346632,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP118_P71_R1567731520790407_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4115221965944672,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP118_P72_R5027005515342360_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6272826170081888,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP118_P77_R9361216807648462_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6272929633082818,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP118_P78_R9370226847648506_SORT',
    p_attribute_value => 'fsp_sort_7_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4036308708324741,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP118_P81_R1905125714038958_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4036409054324783,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP118_P82_R1821905451094681_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4036631311388019,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP118_P82_R4613526145327235_SORT',
    p_attribute_value => 'fsp_sort_3_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4036511478325469,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP118_P84_R1979101420524084_SORT',
    p_attribute_value => 'fsp_sort_18_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4112108336570045,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____4293704567261241');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4408428327562397,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP_IR_102_P400_W6053825163343768',
    p_attribute_value => '6055506144380624____6055506144380624');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4986417493410107,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP_IR_118_P143_W6488421670121560',
    p_attribute_value => '6490227476122887____6490227476122887');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4036930684577322,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP_IR_118_P70_W1556022197771347',
    p_attribute_value => '1558917519771357____1558917519771357');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5702211412904425,
    p_user_id => 'LILIAN.NUTZ',
    p_preference_name => 'FSP_IR_118_P86_W8823408315894606',
    p_attribute_value => '8827313540894633____8827313540894633');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6120532758535414,
    p_user_id => 'LILIAN.NUTZ.3',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2508701475705086,
    p_user_id => 'MARK.KLATT',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2509803141875826,
    p_user_id => 'MARK.KLATT',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2509924658260531,
    p_user_id => 'MARK.KLATT',
    p_preference_name => 'FSP118_P900_R3960131884214678_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3825307159412898,
    p_user_id => 'MELANIE-ZETTLMAIER',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5700912859810288,
    p_user_id => 'MELANIE-ZETTLMAIER',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3933232765606170,
    p_user_id => 'MELANIE-ZETTLMAIER',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3930018541924380,
    p_user_id => 'MELANIE-ZETTLMAIER',
    p_preference_name => 'FSP104_P3_R5386709695634321_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4819623339894115,
    p_user_id => 'MELANIE-ZETTLMAIER',
    p_preference_name => 'FSP118_P71_R1567731520790407_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3933112231605699,
    p_user_id => 'MELANIE-ZETTLMAIER',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____4293704567261241');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4819524052892250,
    p_user_id => 'MELANIE-ZETTLMAIER',
    p_preference_name => 'FSP_IR_118_P70_W1556022197771347',
    p_attribute_value => '1558917519771357____1558917519771357');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3930304605939307,
    p_user_id => 'MELANIE.ZETTLMAIER@EOVITAL.EU',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3930200389937183,
    p_user_id => 'MELANIE.ZETTLMAIER@EOVITAL.EU',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____4293704567261241');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3814629179652186,
    p_user_id => 'MICHAEL.GEISLER',
    p_preference_name => 'FB_FLOW_ID',
    p_attribute_value => '302');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3816311105505040,
    p_user_id => 'MICHAEL.GEISLER',
    p_preference_name => 'FSP302_P1_R5157324976021759_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3814201505651726,
    p_user_id => 'MICHAEL.GEISLER',
    p_preference_name => 'FSP_IR_4000_P1500_W3519715528105919',
    p_attribute_value => '3521529006112497____3521529006112497');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3814826940655115,
    p_user_id => 'MICHAEL.GEISLER',
    p_preference_name => 'FSP_IR_4000_P1800_W15698721914328105',
    p_attribute_value => '15700317824328377____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3814510536652173,
    p_user_id => 'MICHAEL.GEISLER',
    p_preference_name => 'FSP_IR_4000_P1_W3326806401130228',
    p_attribute_value => '3328003692130542____3328003692130542');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3815023058656975,
    p_user_id => 'MICHAEL.GEISLER',
    p_preference_name => 'FSP_IR_4000_P40_W48117227188266087',
    p_attribute_value => '48118623144274016____48118623144274016');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3811216977447026,
    p_user_id => 'MICHAEL.GEISLER',
    p_preference_name => 'FSP_IR_4350_P55_W10236304983033455',
    p_attribute_value => '10238325656034902____10238325656034902');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3815121261665816,
    p_user_id => 'MICHAEL.GEISLER',
    p_preference_name => 'P4150_GET_STARTED_CONFIRMED',
    p_attribute_value => 'Y');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3814400642652164,
    p_user_id => 'MICHAEL.GEISLER',
    p_preference_name => 'PERSISTENT_ITEM_P1_DISPLAY_MODE',
    p_attribute_value => 'ICONS');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5392631031366846,
    p_user_id => 'MILOS.PLAKALOVIC',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2512112187241492,
    p_user_id => 'MILOS.PLAKALOVIC',
    p_preference_name => 'FSP102_P203_R2054113594054535_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2522731616919366,
    p_user_id => 'MILOS.PLAKALOVIC',
    p_preference_name => 'FSP118_P81_R1905125714038958_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2522831963919445,
    p_user_id => 'MILOS.PLAKALOVIC',
    p_preference_name => 'FSP118_P82_R1821905451094681_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2522631673916384,
    p_user_id => 'MILOS.PLAKALOVIC',
    p_preference_name => 'FSP_IR_118_P70_W1556022197771347',
    p_attribute_value => '1558917519771357____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3804822421799758,
    p_user_id => 'PIS',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3860102845665009,
    p_user_id => 'PIS',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4985200908230295,
    p_user_id => 'PIS',
    p_preference_name => 'FSP102_P306_R3108001207234471_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3987203496287269,
    p_user_id => 'PIS',
    p_preference_name => 'FSP102_P321_R4295730780315781_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6378301728571367,
    p_user_id => 'PIS',
    p_preference_name => 'FSP118_P900_R3960131884214678_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2426016850128217,
    p_user_id => 'PIS',
    p_preference_name => 'FSP_IR_102_P136_W7407909918691456',
    p_attribute_value => '7409522778694796____7409522778694796');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 3987114890284458,
    p_user_id => 'PIS',
    p_preference_name => 'FSP_IR_102_P320_W4291131512260920',
    p_attribute_value => '4293704567261241____4293704567261241');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4407931945761665,
    p_user_id => 'PIS',
    p_preference_name => 'FSP_IR_102_P350_W4836418624282487',
    p_attribute_value => '4837827546282493____4837827546282493');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4408126122764370,
    p_user_id => 'PIS',
    p_preference_name => 'FSP_IR_102_P400_W6053825163343768',
    p_attribute_value => '6055506144380624____6055506144380624');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5100913741988485,
    p_user_id => 'PIS',
    p_preference_name => 'FSP_IR_118_P24_W4465303097569284',
    p_attribute_value => '4465902357569581____4465902357569581');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 10650132641056525,
    p_user_id => 'PIS',
    p_preference_name => 'FSP_IR_118_P300_W6130821010107710',
    p_attribute_value => '6132722890108828____6132722890108828');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 14608112286220277,
    p_user_id => 'PIS',
    p_preference_name => 'FSP_IR_118_P36_W2682023645608081',
    p_attribute_value => '2684810502610589____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6188630124085026,
    p_user_id => 'PIS',
    p_preference_name => 'FSP_IR_118_P430_W9402323752784425',
    p_attribute_value => '9402918845784439____9402918845784439');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2521206351997317,
    p_user_id => 'PIS',
    p_preference_name => 'FSP_IR_118_P62_W5582520906556701',
    p_attribute_value => '5584326515563080____5584326515563080');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2523918767798083,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2627205965080558,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP118_P10_R3529932272560795_SORT',
    p_attribute_value => 'fsp_sort_3_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2626003925032726,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP118_P26_R12703203921580260_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2626309119034236,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP118_P71_R1567731520790407_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2626919293046591,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP118_P77_R9361216807648462_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2627103625060997,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP118_P78_R9370226847648506_SORT',
    p_attribute_value => 'fsp_sort_7_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2628322812151689,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP118_P81_R1905125714038958_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2628423159151757,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP118_P82_R1821905451094681_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2628008913119261,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP118_P96_R8717009108043340_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2626228950033471,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP_IR_118_P70_W1556022197771347',
    p_attribute_value => '1558917519771357____1558917519771357');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2626809328044836,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP_IR_118_P86_W8823408315894606',
    p_attribute_value => '8827313540894633____8827313540894633');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2627910126118237,
    p_user_id => 'RALF.PRESCHER',
    p_preference_name => 'FSP_IR_118_P95_W8626111673678640',
    p_attribute_value => '8627013994679346____8627013994679346');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4111831752266956,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4407210101407595,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4875110207980167,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP102_P306_R3108001207234471_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5171726900431375,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP102_P323_R5254217516215655_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5171910172431383,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP102_P323_R5259623815397283_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5171826678431380,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP102_P323_R5544926418582789_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5227215621006699,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP102_P326_R8330813148402781_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2416308000118847,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP102_P97_R5316215857889322_SORT',
    p_attribute_value => 'fsp_sort_3');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5598831275650947,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP104_P3_R5386709695634321_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4821823597781462,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P232_R4097432284791774_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4821924982781893,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P233_R4296509304753586_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4822128445782945,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P234_R4422304505103435_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4822232254783961,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P235_R4637310131557741_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2433011317242231,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P425_R9689508219513583_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6289428698540518,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P440_R10457907558771322_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2509208195792113,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P53_R2642426623513325_SORT',
    p_attribute_value => 'fsp_sort_5_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2509612744821879,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P64_R6692819000982489_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2509725957821893,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P64_R6705426693240207_SORT',
    p_attribute_value => 'fsp_sort_2_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4788607694491400,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P71_R1567731520790407_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5318007981046819,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P72_R5027005515342360_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5317906942046503,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P76_R8065119316035761_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5857615085763601,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P81_R1905125714038958_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5857715431763670,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P82_R1821905451094681_SORT',
    p_attribute_value => '');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5009111809013698,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP118_P900_R3960131884214678_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5171627541430966,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_102_P322_W5143800403959482',
    p_attribute_value => '5145827447959499____5145827447959499');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5172104391532889,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_102_P324_W5515630770830681',
    p_attribute_value => '5518615736830975____5518615736830975');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6116401581994205,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_102_P327_W10241801125416319',
    p_attribute_value => '10242510593416509____10242510593416509');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4407115092400896,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_102_P350_W4836418624282487',
    p_attribute_value => '4837827546282493____4837827546282493');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4407406138541789,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_102_P400_W6053825163343768',
    p_attribute_value => '6055506144380624____6055506144380624');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2415817793360308,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_102_P402_W6452431423536140',
    p_attribute_value => '6453802451556143____6453802451556143');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2416015420361390,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_102_P403_W6455123867607799',
    p_attribute_value => '6456617089617087____6456617089617087');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6016605360663236,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P140_W8300929559535098',
    p_attribute_value => '8301806607535984____8301806607535984');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6016824757669495,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P142_W6464805390244333',
    p_attribute_value => '6472215206258295____6472215206258295');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6017021738670878,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P143_W6488421670121560',
    p_attribute_value => '6490227476122887____6490227476122887');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4461523891143532,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P300_W6130821010107710',
    p_attribute_value => '6132722890108828____6132722890108828');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4907823792415633,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P36_W2682023645608081',
    p_attribute_value => '2684810502610589____2684810502610589');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4930203580880876,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P371_W7605311129345579',
    p_attribute_value => '7605906375345859____7605906375345859');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6281624453369214,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P403_W9672802697078335',
    p_attribute_value => '9673826163078540____9673826163078540');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6289008039407188,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P404_W9681728429570919',
    p_attribute_value => '9683027698589958____9683027698589958');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6289206529407890,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P426_W9696824783872423',
    p_attribute_value => '9699729934894918____9699729934894918');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6110305661489467,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P430_W9402323752784425',
    p_attribute_value => '9402918845784439____9402918845784439');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2417011770055281,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P433_W10131108482690634',
    p_attribute_value => '10133902132698507____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2416519657899644,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P434_W10135715480732604',
    p_attribute_value => '10137120104732606____10137120104732606');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2509000115788302,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P51_W2611410755155531',
    p_attribute_value => '2613411732156066____2613411732156066');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 2509427466821147,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P63_W6674323679810233',
    p_attribute_value => '6677228032862150____6677228032862150');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4788305642488298,
    p_user_id => 'SASCHA-LENZ-CH',
    p_preference_name => 'FSP_IR_118_P70_W1556022197771347',
    p_attribute_value => '1558917519771357____1558917519771357');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4196126844145494,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FB_FLOW_ID',
    p_attribute_value => '102');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4665912602780494,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP302_P11_R4973605145398981_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4409911073071350,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP302_P1_R5157324976021759_SORT',
    p_attribute_value => 'fsp_sort_4_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5010422733592687,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP4000_P300_R25453825731390673_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5010525157593325,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP4000_P423_R172114705298474212_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4196631128149228,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP4000_P4410_R29873113508481210_SORT',
    p_attribute_value => 'fsp_sort_2_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5010322040592490,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP4000_P532_R177170600254216246_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5011416509666548,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP4000_P591_R168263311862841256_SORT',
    p_attribute_value => 'fsp_sort_3');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5010630698594965,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP4000_P653_R172116901966482713_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5010703125596500,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP4000_P675_R172118613741486068_SORT',
    p_attribute_value => 'fsp_sort_1_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6372214856886200,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP4000_P73_R78240013758270704_SORT',
    p_attribute_value => 'fsp_sort_2_desc');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5562124123289076,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_115_P2_W8934520176885182',
    p_attribute_value => '8937628391886356____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4195707736144880,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4000_P1500_W3519715528105919',
    p_attribute_value => '3521529006112497____ICON');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4196003583145477,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4000_P1_W3326806401130228',
    p_attribute_value => '3328003692130542____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5103905444136454,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4000_P37_W48062924521220825',
    p_attribute_value => '48064021067223306____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4663927282909615,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4000_P4047_W184800502564237029',
    p_attribute_value => '184804717913266027____184804717913266027');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5102527220868101,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4000_P40_W48117227188266087',
    p_attribute_value => '48118623144274016____REPORT');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4196303423146867,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4000_P4400_W27796519609844319',
    p_attribute_value => '27798220762844327____27798220762844327');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5703118575625369,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4350_P150_W168470000722916319',
    p_attribute_value => '168471214372916491____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5703308223630229,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4350_P16_W10298231278245880',
    p_attribute_value => '10299903771249069____');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5702827417621247,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4350_P53_W34954404769221837',
    p_attribute_value => '34956410007247564____34956410007247564');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5260606442640516,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4350_P55_W10236304983033455',
    p_attribute_value => '10238325656034902____10238325656034902');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 5043711145549522,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'FSP_IR_4350_P7_W9412205627285339',
    p_attribute_value => '9413006316285546____9413006316285546');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4244301269559106,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'P4150_GET_STARTED_CONFIRMED',
    p_attribute_value => 'Y');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4195906442145437,
    p_user_id => 'SASCHA.LENZ',
    p_preference_name => 'PERSISTENT_ITEM_P1_DISPLAY_MODE',
    p_attribute_value => 'ICONS');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4244606688626922,
    p_user_id => 'STEFAN.WAGNER',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 4819316591229836,
    p_user_id => 'W.KRONISCH',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6024430862875497,
    p_user_id => 'WILFRIED.BRENDLE',
    p_preference_name => 'FSP102_P140_R5377325249460687_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
begin
  wwv_flow_api.create_preferences$ (
    p_id => 6086700250931020,
    p_user_id => 'WILFRIED.BRENDLE',
    p_preference_name => 'FSP102_P141_R6566417694810781_SORT',
    p_attribute_value => 'fsp_sort_2');
end;
/
----------------
--service mods
--
----------------
--query builder
--
----------------
--sql scripts
--
----------------
--sql commands
--
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 3934608438318237
 ,p_command => 
'select * from v$instance;'
    ,p_created_by => 'DIETMAR.AUST'
    ,p_created_on => to_date('201301081837','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'FRGBG');
end;
/
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 6060214541111568
 ,p_command => 
'select count (*) from user_tables'
    ,p_created_by => 'DENES'
    ,p_created_on => to_date('201407141430','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'FRGBG');
end;
/
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 6065726230251802
 ,p_command => 
'SELECT count (*) FROM apex_application_page_items WHERE application_id = 102 AND page_id = 110'
    ,p_created_by => 'DENES'
    ,p_created_on => to_date('201407151020','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'FRGBG');
end;
/
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 6065831771253401
 ,p_command => 
'SELECT * FROM apex_application_page_items WHERE application_id = 102 AND page_id = 110'
    ,p_created_by => 'DENES'
    ,p_created_on => to_date('201407151020','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'FRGBG');
end;
/
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 6065911123256891
 ,p_command => 
'SELECT COUNT (*)'||chr(10)||
'  FROM apex_application_page_items'||chr(10)||
' WHERE application_id = 102 AND page_id = 110 AND display_as = ''Hidden'''
    ,p_created_by => 'DENES'
    ,p_created_on => to_date('201407151020','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'FRGBG');
end;
/
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 6086813185218599
 ,p_command => 
'SELECT fas_synch.get_tab_uebersetzung'||chr(10)||
'                             (''ARTGRUPPEN.BEZEICHNUNG'',             -- Artikel'||chr(10)||
'                              ID,'||chr(10)||
'                              :fas_sprache_id'||chr(10)||
'                             ) bezeichnung,'||chr(10)||
'       kuerzel, ID, sort,'||chr(10)||
'       CASE'||chr(10)||
'          WHEN dokument_id IS NOT NULL'||chr(10)||
'             THEN    ''<img src="#OWNER#.frgbg_t.display_thumb?p_bild_id='''||chr(10)||
'        '||
'          || NVL (dokument_id, 0)'||chr(10)||
'                  || ''&p_sprache_id='''||chr(10)||
'                  || :fas_sprache_id'||chr(10)||
'                  -- || ''" height="'''||chr(10)||
'                  -- || 90'||chr(10)||
'                  -- || ''" width="'''||chr(10)||
'                  -- || 90'||chr(10)||
'                  || ''" />'''||chr(10)||
'          ELSE NULL'||chr(10)||
'       END img'||chr(10)||
'  FROM artgruppen'||chr(10)||
' WHERE :p300_wk_artikeltyp_flag IN (2)'
    ,p_created_by => 'DENES'
    ,p_created_on => to_date('201407170927','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'FRGBG');
end;
/
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 6088109563331101
 ,p_command => 
'select * from PERSONENSTAMM'
    ,p_created_by => 'DENES'
    ,p_created_on => to_date('201407170946','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'FRGBG');
end;
/
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 6088214757332590
 ,p_command => 
'select * from PERSONENSTAMM'||chr(10)||
'where user_account like ''WIL%'''
    ,p_created_by => 'DENES'
    ,p_created_on => to_date('201407170946','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'FRGBG');
end;
/
begin
  wwv_flow_api.create_sw_sql_cmds (
    p_id => 6088326185335824
 ,p_command => 
'select * from PERSONENSTAMM'||chr(10)||
'where user_account like ''WILFRIED.BRENDLE%'''
    ,p_created_by => 'DENES'
    ,p_created_on => to_date('201407170947','YYYYMMDDHH24MI')
    ,p_parsed_schema => 'FRGBG');
end;
/
----------------
--user access log
--
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'LAVDIM.DJAFERI',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508131210','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 1,
    p_custom_status_text => 'Invalid Login Credentials');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'LAVDIM.DJAFERI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508131354','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508031010','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 4,
    p_custom_status_text => 'Invalid Login Credentials');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508031010','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 4,
    p_custom_status_text => 'Invalid Login Credentials');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508031010','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'ADRIJANA.SADIKI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508131040','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'ADRIJANA.SADIKI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508131045','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'LAVDIM.DJAFERI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 118,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508131128','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'LAVDIM.DJAFERI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508131129','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508131203','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508131204','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'LAVDIM.DJAFERI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508131211','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'LAVDIM.DJAFERI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508140939','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'PIS',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508040853','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508040957','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 4,
    p_custom_status_text => 'Invalid Login Credentials');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508040957','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'KATJA.MEYERHOFER',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508040958','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'KATJA.MEYERHOFER',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508041012','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508041209','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508041210','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log1$ (
    p_login_name => 'SASCHA-LENZ-CH',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508121434','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'PIS',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508170745','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'KATJA.MEYERHOFER',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508170754','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'KATJA.MEYERHOFER',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508170756','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'PIS',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508171708','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'KATJA.MEYERHOFER',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508180910','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'PIS',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508181135','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'KATJA.MEYERHOFER',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508181208','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'ADRIJANA.SADIKI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508200803','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'ADRIJANA.SADIKI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508200804','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'ADRIJANA.SADIKI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508200949','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'EILEEN.SCHATZ',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508201244','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'EILEEN.SCHATZ',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508201509','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'EILEEN.SCHATZ',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508201619','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'ADRIJANA.SADIKI',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 102,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508201657','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'PIS',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 118,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508170744','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 118,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508171000','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'PIS',
    p_auth_method => 'AUTH_FRGBG',
    p_app => 118,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508181240','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'MICHAEL.GEISLER',
    p_auth_method => 'Application Express',
    p_app => 302,
    p_owner => 'FRGBG',
    p_access_date => to_date('201508181252','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'BRIGITTE.NEIDHART',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508170959','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
begin
  wwv_flow_api.create_user_access_log2$ (
    p_login_name => 'MICHAEL.GEISLER',
    p_auth_method => 'Internal Authentication',
    p_app => 4500,
    p_owner => 'APEX_040200',
    p_access_date => to_date('201508181250','YYYYMMDDHH24MI'),
    p_ip_address => '127.0.0.1',
    p_remote_user => 'APEX_PUBLIC_USER',
    p_auth_result => 0,
    p_custom_status_text => '');
end;
/
 
prompt ...RESTful Services
 
-- SET SCHEMA
 
begin
 
   wwv_flow_api.g_id_offset := 0;
   wwv_flow_hint.g_schema   := 'FRGBG';
   wwv_flow_hint.check_schema_privs;
 
end;
/

 
--------------------------------------------------------------------
prompt  SCHEMA FRGBG - User Interface Defaults, Table Defaults
--
-- Import using sqlplus as the Oracle user: APEX_040200
-- Exported 17:11 Donnerstag August 20, 2015 by: 
--
 
--------------------------------------------------------------------
prompt User Interface Defaults, Attribute Dictionary
--
-- Exported 17:11 Donnerstag August 20, 2015 by: 
--
-- SHOW EXPORTING WORKSPACE
 
begin
 
   wwv_flow_api.g_id_offset := 0;
   wwv_flow_hint.g_exp_workspace := 'FRAGE_WKS';
 
end;
/

commit;
begin
execute immediate 'begin sys.dbms_session.set_nls( param => ''NLS_NUMERIC_CHARACTERS'', value => '''''''' || replace(wwv_flow_api.g_nls_numeric_chars,'''''''','''''''''''') || ''''''''); end;';
end;
/
set verify on
set feedback on
set define on
prompt  ...done
