set define off
set verify off
set feedback off
WHENEVER SQLERROR EXIT SQL.SQLCODE ROLLBACK
begin wwv_flow.g_import_in_progress := true; end;
/
 
 
--application/set_environment
prompt  APPLICATION 118 - FAS Verwaltung
--
-- Application Export:
--   Application:     118
--   Name:            FAS Verwaltung
--   Date and Time:   10:53 Montag Oktober 26, 2015
--   Exported By:     SYSTEM
--   Flashback:       0
--   Export Type:     Application Export
--   Version:         4.2.5.00.08
--   Instance ID:     63126117280962
--
-- Import:
--   Using Application Builder
--   or
--   Using SQL*Plus as the Oracle user APEX_040200 or as the owner (parsing schema) of the application
 
-- Application Statistics:
--   Pages:                    179
--     Items:                1,561
--     Computations:             7
--     Validations:            367
--     Processes:              630
--     Regions:                406
--     Buttons:                677
--     Dynamic Actions:        149
--   Shared Components:
--     Logic:
--       Items:                 28
--       Processes:              6
--       Build Options:          1
--     Navigation:
--       Tab Sets:               1
--         Tabs:                14
--       Breadcrumbs:            2
--         Entries:            119
--       Trees:                  1
--       NavBar Entries:         2
--     Security:
--       Authentication:         4
--       Authorization:          2
--     User Interface:
--       Themes:                 1
--       Templates:
--         Page:                 9
--         Region:              22
--         Label:                5
--         List:                16
--         Popup LOV:            1
--         Calendar:             3
--         Breadcrumb:           2
--         Button:               4
--         Report:               7
--       LOVs:                   1
--       Shortcuts:              5
--       Plug-ins:               7
--     Globalization:
--     Reports:
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_040200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>nvl(wwv_flow_application_install.get_workspace_id,2031917327559678));
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2012.01.01');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := nvl(wwv_flow_application_install.get_application_id,118);
   wwv_flow_api.g_id_offset := nvl(wwv_flow_application_install.get_offset,0);
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(nvl(wwv_flow_application_install.get_application_id,118));
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(nvl(wwv_flow_application_install.get_application_id,118));
null;
 
end;
/

prompt  ...ui types
--
 
begin
 
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => nvl(wwv_flow_application_install.get_application_id,118),
  p_display_id=> nvl(wwv_flow_application_install.get_application_id,118),
  p_owner => nvl(wwv_flow_application_install.get_schema,'FRGBG'),
  p_name  => nvl(wwv_flow_application_install.get_application_name,'FAS Verwaltung'),
  p_alias => nvl(wwv_flow_application_install.get_application_alias,'F118'),
  p_page_view_logging => 'YES',
  p_page_protection_enabled_y_n=> 'Y',
  p_checksum_salt_last_reset => '20150930075643',
  p_max_session_length_sec=> 21600,
  p_compatibility_mode=> '4.0',
  p_html_escaping_mode=> 'B',
  p_flow_language=> 'de-ch',
  p_flow_language_derived_from=> 'ITEM_PREFERENCE',
  p_allow_feedback_yn=> 'N',
  p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,''),
  p_publish_yn=> 'N',
  p_documentation_banner=> '',
  p_authentication=> 'PLUGIN',
  p_authentication_id=> 3093401067558604 + wwv_flow_api.g_id_offset,
  p_logout_url=> 'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&amp;p_next_flow_page_sess=118:101',
  p_application_tab_set=> 1,
  p_logo_image => '/i/themes/&FAS_THEME_NAME./logo.jpg',
  p_public_url_prefix => '',
  p_public_user=> 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server=> nvl(wwv_flow_application_install.get_proxy,''),
  p_cust_authentication_process=> '',
  p_cust_authentication_page=> '',
  p_flow_version=> 'Release 1.0',
  p_flow_status=> 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'Diese Anwendung ist aktuell nicht verfügbar.',
  p_build_status=> 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_browser_cache=>'Y',
  p_browser_frame=>'A',
  p_deep_linking=>'Y',
  p_vpd=> '',
  p_vpd_teardown_code=> '',
  p_authorize_public_pages_yn=>'Y',
  p_csv_encoding=> 'Y',
  p_auto_time_zone=> 'N',
  p_include_legacy_javascript=> 'Y',
  p_default_error_display_loc=> 'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_last_updated_by => 'BRIGITTE.NEIDHART',
  p_last_upd_yyyymmddhh24miss=> '20150930075643',
  p_ui_type_name => null,
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

----------------
--package app map
--
prompt  ...user interfaces
--
 
begin
 
--application/user interface/desktop
wwv_flow_api.create_user_interface (
  p_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_ui_type_name => 'DESKTOP'
 ,p_display_name => 'Desktop'
 ,p_display_seq => 10
 ,p_use_auto_detect => true
 ,p_is_default => true
 ,p_theme_id => 1
 ,p_home_url => 'f?p=&APP_ID.:100:&SESSION.'
 ,p_global_page_id => 0
  );
null;
 
end;
/

prompt  ...plug-in settings
--
 
begin
 
--application/plug-in setting/item_type_native_yes_no
wwv_flow_api.create_plugin_setting (
  p_id => 2664332052889433 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'ITEM TYPE'
 ,p_plugin => 'NATIVE_YES_NO'
 ,p_attribute_01 => 'Y'
 ,p_attribute_03 => 'N'
  );
--application/plug-in setting/item_type_plugin_com_skillbuilders_super_lov
wwv_flow_api.create_plugin_setting (
  p_id => 7088808168592785 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'ITEM TYPE'
 ,p_plugin => 'PLUGIN_COM_SKILLBUILDERS_SUPER_LOV'
 ,p_attribute_01 => 'CONTAINS_IGNORE'
 ,p_attribute_03 => 'DEFAULT'
 ,p_attribute_04 => 'drip-circle'
 ,p_attribute_06 => '400'
 ,p_attribute_07 => 'N'
 ,p_attribute_08 => 'Your search returned no results.'
  );
--application/plug-in setting/dynamic_action_plugin_com_enkitec_clob_load
wwv_flow_api.create_plugin_setting (
  p_id => 64293271625916435 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'DYNAMIC ACTION'
 ,p_plugin => 'PLUGIN_COM_ENKITEC_CLOB_LOAD'
 ,p_attribute_01 => 'Y'
 ,p_attribute_02 => 'Please wait...'
 ,p_attribute_03 => 'DEFAULT'
  );
--application/plug-in setting/dynamic_action_plugin_com_skillbuilders_modal_page
wwv_flow_api.create_plugin_setting (
  p_id => 34420758943217175373 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'DYNAMIC ACTION'
 ,p_plugin => 'PLUGIN_COM_SKILLBUILDERS_MODAL_PAGE'
 ,p_attribute_01 => '1'
 ,p_attribute_02 => '.5'
 ,p_attribute_03 => 'Y'
 ,p_attribute_04 => 'none'
 ,p_attribute_05 => '100'
 ,p_attribute_06 => '300'
 ,p_attribute_07 => 'Y'
  );
null;
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
--application/shared_components/security/authorization/check_page_access
wwv_flow_api.create_security_scheme (
  p_id => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'check_page_access'
 ,p_scheme_type => 'NATIVE_FUNCTION_BODY'
 ,p_attribute_01 => 'DECLARE'||unistr('\000a')||
'   v_anz           NUMBER;'||unistr('\000a')||
'   v_fehlerseite   NUMBER := 130;'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--mel.p(''Check Zugriff 1: %1,%2,%3,%4,%5,%6'',v_prot_id,''Info'',''118/authorization check_zugriff'',:fas_schema_id,:FAS_LOGIN_PERSONENSTAMM_ID,:FAS_IDENTITAET_PERSSTAMM_ID,:APP_ID,:APP_PAGE_ID,:FAS_AUFGERUFEN_VON);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Gibt es spezielle Zugriffsdefinitionen?'||unistr('\000a')||
'   SELECT count(*) INTO v_anz'||unistr('\000a')||
'   FROM fas_app_menus'||unistr('\000a')||
'   WHERE satz_kennzeichen is null'||unistr('\000a')||
'     AND app_id = :APP_ID'||unistr('\000a')||
'     AND page_id = :APP_PAGE_ID;'||unistr('\000a')||
'   IF v_anz = 0 THEN -- Keine speziellen Berechtigungen definiert => Zugriff möglich, falls FAS-VERWALTUNG-Zugang'||unistr('\000a')||
'      IF :fas_aufgerufen_von = ''FAS-VERWALTUNG'' THEN'||unistr('\000a')||
'         RETURN TRUE;'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         RETURN FALSE;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'--mel.p(''Check Zugriff 2: %1,%2,%3,%4,%5,%6,t:%7'',v_prot_id,''Info'',''118/authorization check_page_access'',:fas_schema_id,:FAS_LOGIN_PERSONENSTAMM_ID,:FAS_IDENTITAET_PERSSTAMM_ID,:APP_ID,:APP_PAGE_ID,:FAS_AUFGERUFEN_VON,:FAS_ZUGRIFF_TEXT);'||unistr('\000a')||
'   -- Check spezieller Zugriff'||unistr('\000a')||
'   IF frgbg_t.CHECK_FAS_APP_ZUGRIFF(:FAS_LOGIN_PERSONENSTAMM_ID,'||unistr('\000a')||
'                                    :FAS_IDENTITAET_PERSSTAMM_ID,:APP_ID,:APP_PAGE_ID) >= 1 '||unistr('\000a')||
'   THEN  -- Zugriff erlaubt'||unistr('\000a')||
'      return TRUE;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      return FALSE;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'END;'
 ,p_error_message => '&FAS_ZUGRIFF_TEXT.'
 ,p_caching => 'BY_USER_BY_PAGE_VIEW'
  );
--application/shared_components/security/authorization/check_page_access_test
wwv_flow_api.create_security_scheme (
  p_id => 3907510118925931 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'check_page_access_test'
 ,p_scheme_type => 'NATIVE_FUNCTION_BODY'
 ,p_attribute_01 => 'BEGIN'||unistr('\000a')||
'   IF UPPER(:APP_USER) in (''BRIGITTE.NEIDHART'') THEN'||unistr('\000a')||
'      RETURN true;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      RETURN false;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;'
 ,p_error_message => '&FAS_ZUGRIFF_TEXT.'
 ,p_caching => 'BY_USER_BY_SESSION'
  );
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id => 5943711535826976 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_icon_sequence=> 10,
  p_icon_image => '',
  p_icon_subtext=> 'Version',
  p_icon_target=> 'f?p=&APP_ID.:998:&SESSION.::&DEBUG.::P998_ZURUECK_ZUR_SEITE:&APP_PAGE_ID.:',
  p_icon_image_alt=> '',
  p_icon_height=> null,
  p_icon_width=> null,
  p_icon_height2=> null,
  p_icon_width2=> null,
  p_nav_entry_is_feedback_yn => 'N',
  p_icon_bar_disp_cond=> '',
  p_icon_bar_disp_cond_type=> 'NEVER',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
wwv_flow_api.create_icon_bar_item(
  p_id => 3051427009431639 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_icon_sequence=> 20,
  p_icon_image => '',
  p_icon_subtext=> '&FAS_ABMELDEN_TEXT.',
  p_icon_target=> 'f?p=&APP_ID.:999:&SESSION.::&DEBUG.::P999_LOGIN_PAGE:&FAS_LOGIN_PAGE.:',
  p_icon_image_alt=> '&FAS_ABMELDEN_TEXT.',
  p_icon_height=> 32,
  p_icon_width=> 32,
  p_icon_height2=> 24,
  p_icon_width2=> 24,
  p_nav_entry_is_feedback_yn => 'N',
  p_icon_bar_disp_cond=> 'DECLARE'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'IF :APP_PAGE_ID not in (999) AND :FAS_AUFGERUFEN_VON != ''PIS'' THEN'||unistr('\000a')||
' --  MEL.P (''Navi true page_id:%1, aufruf:%2|'', v_prot_id,''ERROR'',''fas-navi'','||unistr('\000a')||
' --         :APP_PAGE_ID,:fas_AUFGERUFEN_VON);'||unistr('\000a')||
'  RETURN(TRUE);'||unistr('\000a')||
'ELSE'||unistr('\000a')||
' --  MEL.P (''Navi false page_id:%1, aufruf:%2|'', v_prot_id,''ERROR'',''fas-navi'','||unistr('\000a')||
' --         :APP_PAGE_ID,:fas_AUFGERUFEN_VON);'||unistr('\000a')||
'  RETURN (FALSE);'||unistr('\000a')||
'END IF;'||unistr('\000a')||
'END;',
  p_icon_bar_disp_cond_type=> 'NEVER',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
 
end;
/

prompt  ...application processes
--
--application/shared_components/logic/application_processes/init_scrollregion_height
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_prot_id   NUMBER;'||unistr('\000a')||
'   v_user      personenstamm.user_account%TYPE;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :FAS_SCROLLREGION_HEIGHT_MAX:= frgbg_s.get_pers_option(:APP_USER,4);'||unistr('\000a')||
'   IF :FAS_SCROLLREGION_HEIGHT_MAX IS NULL THEN'||unistr('\000a')||
'      :FAS_SCROLLREGION_HEIGHT_MAX := 500;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'MEL.P (''Scrollheigth!''||:FAS_SCROLLREGION_HEIGHT_MAX||'' (user=''||:APP_USER||'' USer:''||:P101_USERNAME||'')! [init_scrollregion,30]'', v_PROT_ID';

p:=p||', ''ERROR'', ''118/101:init_scrollregion,30'');'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 3093020478548226 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/set_fas_texte
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_prot_id   number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :fas_abmelden_text :=   '||unistr('\000a')||
'      frgbg_s.holen_uebersetzung(174,:fas_sprache_id);'||unistr('\000a')||
'   :fas_keine_daten_text := '||unistr('\000a')||
'      frgbg_s.holen_uebersetzung(759,:fas_sprache_id);'||unistr('\000a')||
'   :fas_loeschabfrage_text :=  '||unistr('\000a')||
'      frgbg_s.holen_uebersetzung(2195,:fas_sprache_id);'||unistr('\000a')||
'   :FAS_ZUGRIFF_TEXT :=  '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(3110,:fas_sprache_id);'||unistr('\000a')||
'--mel.p(''set_fas_texte %';

p:=p||'1'',v_prot_id,''TEST'',''set_fas_texte'',:FAS_ZUGRIFF_TEXT);  '||unistr('\000a')||
'       '||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 3093230867551267 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_fas_texte',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/init_fas_session
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprachcode app_sprachen.sprachcode%TYPE;'||unistr('\000a')||
'   v_prot_id    NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT s.sprachcode into v_sprachcode'||unistr('\000a')||
'   FROM app_sprachen s, personenstamm p'||unistr('\000a')||
'   WHERE s.id = p.app_sprache_id'||unistr('\000a')||
'     AND p.id = :fas_login_personenstamm_id;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Für die Zahlennotation ,. (Dezimaltrenner)'||unistr('\000a')||
'   :FSP_LANGUAGE_PREFERENCE := v_sprachcode;'||unistr('\000a')||
'--MEL.P (''nachher Sprachcode = %1,%2,%3'', v_PROT_ID, ''Info'', ''';

p:=p||'init_fas_session'',:fas_login_personenstamm_id,v_sprachcode,:FSP_LANGUAGE_PREFERENCE);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Setzen der absoluten BAsissprache FAS => 357'||unistr('\000a')||
'   :FAS_BASIS_SPRACHE_ID := uebersetzung.GET_ABS_BASIS_SPRACHE_ID;'||unistr('\000a')||
''||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN others THEN'||unistr('\000a')||
'   :FSP_LANGUAGE_PREFERENCE  := ''de-ch'';'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 3927700981231943 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_fas_session',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/getworkflowmapdisplay
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'begin'||unistr('\000a')||
''||unistr('\000a')||
'   HRV_VERWALTUNG.DRAW_HRV_WORKFLOW_MAP('||unistr('\000a')||
'        p_hrv_workflow_id => :P614_HRV_WORKFLOW_ID,'||unistr('\000a')||
'        p_hrv_workflow_item_id => :P614_HRV_WORKFLOW_ITEM_ID,'||unistr('\000a')||
'        p_hrv_workflow_item_id_start => :P614_HRV_WORKFL_ITEM_ID_START,'||unistr('\000a')||
'        p_proc_kachel_element => :P614_PROC_KACHEL_ELEMENT,'||unistr('\000a')||
'        p_proc_kachel_verbindung => :P614_PROC_KACHEL_VERBINDUNG,'||unistr('\000a')||
'        p_select_type => NVL(:P614_SELEC';

p:=p||'T_TYPE,0),'||unistr('\000a')||
'        p_hrv_wf_param_def_id_start => :P614_HRV_WF_PARAM_DEF_ID_ST'||unistr('\000a')||
'    );'||unistr('\000a')||
''||unistr('\000a')||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 7006019342351191 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'GetWorkflowMapDisplay',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/setloveh
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'  l_sql VARCHAR2(32700);'||unistr('\000a')||
'  v_prot_id  number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'mel.p(''In set_lov_eh_p244 G_TEMP: lsql:''||l_sql||'',v_prot_id,''TEST'',''118/set_lov_eh_p244'');'||unistr('\000a')||
''||unistr('\000a')||
'  IF APEX_APPLICATION.G_x01 IS NOT NULL THEN'||unistr('\000a')||
'    APEX_UTIL.SET_SESSION_STATE(''G_TEMP'', APEX_APPLICATION.G_x01);'||unistr('\000a')||
'    mel.p(''G_TEMP:''||:G_TEMP||'', lsql:''||l_sql||'',v_prot_id,''TEST'',''118/set_lov_eh_p244'');'||unistr('\000a')||
'       /*select fas_synch.get_tab_uebersetzu';

p:=p||'ng(''EINHEITEN.EH_ZEICHEN'',id,:fas_sprache_id)  RET, id DIS */'||unistr('\000a')||
'    l_sql := '''||unistr('\000a')||
'      select id RET, eh_zeichen DIS'||unistr('\000a')||
'      from einheiten '||unistr('\000a')||
'      where physeh_id in (select physeh_id '||unistr('\000a')||
'                    from einheiten e, inh_eh_umrs i '||unistr('\000a')||
'                    where e.id = i.einheit_id '||unistr('\000a')||
'                      and i.inhstoff_id = :G_TEMP '||unistr('\000a')||
'                   ) '||unistr('\000a')||
'      order by physeh_id desc'||unistr('\000a')||
'    '';'||unistr('\000a')||
'    mel.p(''';

p:=p||'G_TEMP:''||:G_TEMP||'', lsql:''||l_sql||'',v_prot_id,''TEST'',''118/set_lov_eh_p244'');'||unistr('\000a')||
'    APEX_UTIL.JSON_FROM_SQL(l_sql);'||unistr('\000a')||
'  ELSE'||unistr('\000a')||
'    mel.p(''G_TEMP:ist leer!''||:G_TEMP||'', lsql:''||l_sql||'',v_prot_id,''TEST'',''118/set_lov_eh_p244'');'||unistr('\000a')||
'    HTP.prn(''{"row":[]}'');'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
'  APEX_UTIL.SET_SESSION_STATE(''G_TEMP'', NULL);'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 8113010051727111 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'SETLOVEH',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/checkmnrdetails
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_mn_menge_tag_max            NUMBER;'||unistr('\000a')||
'   v_mn_menge_tag_min            NUMBER;'||unistr('\000a')||
'   v_mn_einheit_id_tag_max       NUMBER;'||unistr('\000a')||
'   v_mn_einheit_id_tag_min       NUMBER;'||unistr('\000a')||
'   v_bezeichnung                 varchar2(100);'||unistr('\000a')||
'   v_menge_input                 varchar2(2000);'||unistr('\000a')||
'   v_zahl                        NUMBER;'||unistr('\000a')||
'   v_min                         NUMBER;'||unistr('\000a')||
'   v_max                         NUMBER;'||unistr('\000a')||
'   v_spr';

p:=p||'ache_id                  number := frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'   v_fehlertext                  VARCHAR2(4000)  := NULL;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'-- Liefert einen Fehlertext, die erste Stelle markiert die Gewichtigkeit '||unistr('\000a')||
'-- des Fehlers 1= Warnung, 2= Fehler'||unistr('\000a')||
''||unistr('\000a')||
'--MEL.P (''Menge = %1,%2,%3'', v_PROT_ID, ''TEST'', ''CheckMnrDetails'','||unistr('\000a')||
'--            :P75_MENGE_INPUT,:P75_ID_INPUT,:P75_EINHEIT_ID_INPUT';

p:=p||');'||unistr('\000a')||
''||unistr('\000a')||
'--v_fehlertext:= ''Wert:''||NVL(:P75_MENGE_INPUT,-1)||'' id:''||:P75_ID_INPUT||'||unistr('\000a')||
'-- '' eh-id:''||:P75_EINHEIT_ID_INPUT;'||unistr('\000a')||
'   v_menge_input := trim(:P75_MENGE_INPUT);'||unistr('\000a')||
'   IF v_menge_input IS NOT NULL  THEN'||unistr('\000a')||
'      -- Check Eingabe ist Zahl'||unistr('\000a')||
'      v_zahl := NULL;'||unistr('\000a')||
'      v_zahl := rezepte.convert_to_number(v_menge_input,'||unistr('\000a')||
'                                            ''999G999G999D99999'');'||unistr('\000a')||
'      IF v_zahl is NULL ';

p:=p||'THEN'||unistr('\000a')||
'         v_fehlertext := ''2''||frgbg_s.holen_uebersetzung(551,v_sprache_id,'||unistr('\000a')||
'                        v_menge_input,v_bezeichnung);  '||unistr('\000a')||
'      ELSIF v_zahl is not null AND v_zahl <> 0 THEN'||unistr('\000a')||
'         -- Prüfung Eingabe nur max. 1 Nachkommastelle'||unistr('\000a')||
'         IF trunc(v_zahl,1) != v_zahl THEN'||unistr('\000a')||
'            v_fehlertext := ''2''||frgbg_s.holen_uebersetzung(2150,v_sprache_id,'||unistr('\000a')||
'                        v_menge_inp';

p:=p||'ut,v_bezeichnung);  '||unistr('\000a')||
'         ELSE '||unistr('\000a')||
'            v_fehlertext := rezepte.check_mnr_inhgrenzwert(:P75_id,'||unistr('\000a')||
'                           :P75_id_input,'||unistr('\000a')||
'                           v_zahl,:P75_EINHEIT_ID_INPUT'||unistr('\000a')||
'                      );'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      '||unistr('\000a')||
'      END IF; -- Zahl?'||unistr('\000a')||
''||unistr('\000a')||
'   END IF; -- Wert eingegeben?  '||unistr('\000a')||
'--MEL.P (''EH = %1,%2,%3'', v_PROT_ID, ''TEST'', ''CheckMnrDetails'',:P75_EINHEIT_ID_INPUT,v_fehle';

p:=p||'rtext);'||unistr('\000a')||
'   htp.prn(trim(v_fehlertext));'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN'||unistr('\000a')||
'   MEL.P (''Fehler bei Zugriff aufg_f04 =''||SQLERRM, v_PROT_ID, ''ERROR'', ''CheckMnrDetails'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 8194429517688419 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'checkMnrDetails',
  p_process_sql_clob=> p,
  p_process_error_message=> 'test',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

prompt  ...application items
--
--application/shared_components/logic/application_items/fas_abmelden_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3089428087474673 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_ABMELDEN_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_aenderungwarnung_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3089802591476867 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_AENDERUNGWARNUNG_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_aufgerufen_von
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3089631204475643 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_AUFGERUFEN_VON'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_basis_sprache_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 6816425555682722 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_BASIS_SPRACHE_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
 ,p_item_comment => 'Absolute Basissprache, die in allen Übersetzungen vorhanden sein muss. Wenn keine andere Sprache vorhanden ist, fällt die Übersetzung auf diese zurück i.R. 357'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_identitaet
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3090008825478571 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_IDENTITAET'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_identitaet_persstamm_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3090423716482921 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_IDENTITAET_PERSSTAMM_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_keine_daten_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3092623117539515 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_KEINE_DATEN_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_loeschabfrage_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3092831775541975 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOESCHABFRAGE_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_login_page
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3092224240520893 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOGIN_PAGE'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_login_personenstamm_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3090217829481176 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOGIN_PERSONENSTAMM_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_login_user_account
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3091808310516326 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOGIN_USER_ACCOUNT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_modus_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4220301429232057 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_MODUS_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_pers_aenderbar
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 6199031058012660 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_PERS_AENDERBAR'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_pers_schema_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 6198625040001487 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_PERS_SCHEMA_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_preislisten_set_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 6198822400010218 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_PREISLISTEN_SET_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_schema_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3089223931473542 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SCHEMA_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_scrollregion_height_max
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3092420000538612 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SCROLLREGION_HEIGHT_MAX'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_sprache_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3092015929518473 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SPRACHE_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_theme_name
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 6309012794211723 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_THEME_NAME'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_zugriff_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3905603644238579 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_ZUGRIFF_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3100624240871001 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_AFTER_LOGIN_URL'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_language_preference
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3928210809244232 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_LANGUAGE_PREFERENCE'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3057331988450117
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3094019748595309 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3057331988450117'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3065711353461487
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3090713804489565 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3065711353461487'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3204622153539084
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3210514310820678 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3204622153539084'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_4199300377836834
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4223314426030150 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_4199300377836834'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_4299313709962092
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4349032272957118 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_4299313709962092'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/g_temp
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 8112719354701433 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'G_TEMP'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/standard/t_preislisten_verwaltung
wwv_flow_api.create_tab (
  p_id=> 3401508833714975 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 20,
  p_tab_name=> 'T_PREISLISTEN-VERWALTUNG',
  p_tab_text => 'Preislisten-Verwaltung',
  p_tab_step => 5,
  p_tab_also_current_for_pages => '6',
  p_tab_parent_tabset=>'',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/grenzwert_verwaltung
wwv_flow_api.create_tab (
  p_id=> 4451716147542254 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 25,
  p_tab_name=> 'Grenzwert-Verwaltung',
  p_tab_text => 'Grenzwert-Verwaltung',
  p_tab_step => 24,
  p_tab_also_current_for_pages => '26,23,25',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'frgbg_s.check_fas_rolle(:APP_USER,''GRENZWERTVERWALTUNG'') > 0',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_inhaltsstoffeverwalten
wwv_flow_api.create_tab (
  p_id=> 5361527850645779 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 27,
  p_tab_name=> 'T_INHALTSSTOFFEVERWALTEN',
  p_tab_text => 'Inhaltsstoffverwaltung',
  p_tab_step => 34,
  p_tab_also_current_for_pages => '33',
  p_tab_parent_tabset=>'',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_login_freigabe
wwv_flow_api.create_tab (
  p_id=> 3401821300718589 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 30,
  p_tab_name=> 'T_LOGIN-FREIGABE',
  p_tab_text => 'Login-Freigabe',
  p_tab_step => 8,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/adressen_transfer
wwv_flow_api.create_tab (
  p_id=> 3414208811203292 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 50,
  p_tab_name=> 'Adressen-Transfer',
  p_tab_text => 'Adressen-Transfer',
  p_tab_step => 17,
  p_tab_also_current_for_pages => '18',
  p_tab_parent_tabset=>'',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/fragebogen_verwaltung
wwv_flow_api.create_tab (
  p_id=> 4605716964767334 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 60,
  p_tab_name=> 'Fragebogen-Verwaltung',
  p_tab_text => 'FB-Verwaltung',
  p_tab_step => 30,
  p_tab_also_current_for_pages => '32',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>':APP_USER in (''PIS'',''LABOR'',''MEISSNER APOTHEKE'',''BRIGITTE.NEIDHART'',''LILIAN.NUTZ'')',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_fb_auswertung
wwv_flow_api.create_tab (
  p_id=> 5370629462475275 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 70,
  p_tab_name=> 'T_FB-AUSWERTUNG',
  p_tab_text => 'FB-Auswertung',
  p_tab_step => 51,
  p_tab_also_current_for_pages => '52,53',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>':APP_USER in (''PIS'',''LABOR'',''MEISSNER APOTHEKE'',''BRIGITTE.NEIDHART'')',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_labortest_verwaltung
wwv_flow_api.create_tab (
  p_id=> 5404925642448779 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 80,
  p_tab_name=> 'T_LABORTEST-VERWALTUNG',
  p_tab_text => 'Labortest-Verwaltung',
  p_tab_step => 40,
  p_tab_also_current_for_pages => '41,42',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>':APP_USER in (''PIS'',''LABOR'',''MEISSNER APOTHEKE'',''BRIGITTE.NEIDHART'')',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/laborwert_verwaltung
wwv_flow_api.create_tab (
  p_id=> 5635223106174939 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 90,
  p_tab_name=> 'Laborwert-Verwaltung',
  p_tab_text => 'Laborwert-Verwaltung',
  p_tab_step => 36,
  p_tab_also_current_for_pages => '37',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>':APP_USER in (''PIS'',''LABOR'',''MEISSNER APOTHEKE'',''BRIGITTE.NEIDHART'',''LILIAN.NUTZ'')',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_identitätenbaum
wwv_flow_api.create_tab (
  p_id=> 1238412027391307 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 100,
  p_tab_name=> 'T_IDENTITÄTENBAUM',
  p_tab_text => 'Identitätenbaum',
  p_tab_step => 60,
  p_tab_also_current_for_pages => '61',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>':APP_USER in (''PIS'',''MEISSNER APOTHEKE'',''BRIGITTE.NEIDHART'')',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_artikelverwaltung
wwv_flow_api.create_tab (
  p_id=> 1549207635771332 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 110,
  p_tab_name=> 'T_ARTIKELVERWALTUNG',
  p_tab_text => 'Artikelverwaltung',
  p_tab_step => 70,
  p_tab_also_current_for_pages => '71',
  p_tab_parent_tabset=>'',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/sortimente
wwv_flow_api.create_tab (
  p_id=> 1791604526280466 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 120,
  p_tab_name=> 'Sortimente',
  p_tab_text => 'Sortimente',
  p_tab_step => 81,
  p_tab_also_current_for_pages => '81,83,84,85',
  p_tab_parent_tabset=>'',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/provisionsabrechnung
wwv_flow_api.create_tab (
  p_id=> 3133316919335457 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 130,
  p_tab_name=> 'Provisionsabrechnung',
  p_tab_text => 'Provisionsabrechnung',
  p_tab_step => 150,
  p_tab_also_current_for_pages => '151',
  p_tab_parent_tabset=>'',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/personentyp_verwaltung
wwv_flow_api.create_tab (
  p_id=> 3452105011467766 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 140,
  p_tab_name=> 'Personentyp-Verwaltung',
  p_tab_text => 'Personentyp-Verwaltung',
  p_tab_step => 10,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_display_condition_type=> 'NEVER',
  p_tab_comment  => '');
 
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/lov_therapeuten
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5605013134753089 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOV_THERAPEUTEN',
  p_lov_query=> 'select name||'' ''||vorname d, id r'||unistr('\000a')||
'from   personenstamm'||unistr('\000a')||
'where satzkennzeichen is null'||unistr('\000a')||
'order by 1');
 
null;
 
end;
/

prompt  ...Application Trees
--
--application/shared_components/navigation/trees/identitaetenbaum
 
begin
 
wwv_flow_api.create_tree (
  p_id=> 6400726550534581 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Identitaetenbaum',
  p_type=>'DYNAMIC',
  p_item=>'P60_TREE_ROOT',
  p_query=>'select "PERSSTAMM_ID_IDENTITAET" id, '||unistr('\000a')||
'       "PERSSTAMM_ID_OBERIDENTITAET" pid, '||unistr('\000a')||
'       "NAME"||'' ''||"VORNAME"||'' ''||"PLZ"||'' '' '||unistr('\000a')||
'             ||"ORT"||'' (''||"PERSSTAMM_ID_IDENTITAET"||'')'' '||unistr('\000a')||
'             ||DECODE(BETREUER||STANDARD,''JJ'',''*'','' '')'||unistr('\000a')||
'             name, '||unistr('\000a')||
'       null link, '||unistr('\000a')||
'       null a1, '||unistr('\000a')||
'       null a2 '||unistr('\000a')||
'from "#OWNER#"."V_IDENT_HIERARCHIE"'||unistr('\000a')||
'order by name',
  p_levels=>10,
  p_unexpanded_parent=> '<td><a href="#DRILL_DOWN#"><img src="#IMAGE_PREFIX#Fndtre02.gif" width="16" height="22" border="0"></a></td>',
  p_unexpanded_parent_last=> '<td><a href="#DRILL_DOWN#"><img src="#IMAGE_PREFIX#Fndtre03.gif" width="16" height="22" border="0"></a></td>',
  p_expanded_parent=>'<td><a href="#DRILL_DOWN#"><img src="#IMAGE_PREFIX#Fndtre05.gif" width="16" height="22" border="0"></td>',
  p_expanded_parent_last=>'<td><a href="#DRILL_DOWN#"><img src="#IMAGE_PREFIX#Fndtre06.gif" width="16" height="22" border="0"></a></td>',
  p_leaf_node=>'<td align="left"><img src="#IMAGE_PREFIX#Fndtre07.gif" width="16" height="22" border="0"></td>',
  p_leaf_node_last=>'<td align="left"><img src="#IMAGE_PREFIX#Fndtre08.gif" width="16" height="22" border="0"></td>',
  p_name_link_anchor_tag=>'<a href="#LINK#">#NAME#</a>',
  p_name_link_not_anchor_tag=>'#NAME#',
  p_indent_vertical_line=>'<td><img src="#IMAGE_PREFIX#Fndtre09.gif" width="16" height="22" border="0"></td>',
  p_indent_vertical_line_last=>'<td><img src="#IMAGE_PREFIX#Fndtre10.gif" width="16" height="22" border="0"></td>',
  p_drill_up=>'&nbsp;(up)',
  p_before_tree=>'<table border="0" cellspacing="0" cellpadding="0">',
  p_after_tree=>'</table>',
  p_level_1_template=>'<tr>#INDENT#<td colspan="#COLSPAN#" valign="CENTER" class="tiny">#NAME##A1##A2# #DRILL_UP#</td></tr>',
  p_level_2_template=>'<tr>#INDENT#<td colspan="#COLSPAN#" valign="CENTER" class="tiny">#NAME##A1##A2#</td></tr>');
null;
 
end;
/

--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_00000
prompt  ...PAGE 0: 0
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 0
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_name => '0'
 ,p_step_title => '0'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20141128160724'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT x.ID ID,'||unistr('\000a')||
'       x.FAS_APP_MENU_ID PID,'||unistr('\000a')||
'       x.BEZEICHNUNG NAME,'||unistr('\000a')||
'       CASE substr(x.URL,1,4) when ''f?p='''||unistr('\000a')||
'       THEN APEX_UTIL.PREPARE_URL(frgbg_t.replace_var_in_wert(x.URL))'||unistr('\000a')||
'       ELSE ''#'''||unistr('\000a')||
'       END link,'||unistr('\000a')||
'       level'||unistr('\000a')||
'--from fas_app_menus x'||unistr('\000a')||
'--where x.id in'||unistr('\000a')||
'from (select distinct b.id,b.FAS_APP_MENU_ID,'||unistr('\000a')||
'      NVL(frgbg_s.holen_uebersetzung(b.bezeichnung_text_id,:fas_sprache_id),b.BEZEIC';

s:=s||'HNUNG ) bezeichnung,'||unistr('\000a')||
'      b.URL,b.sortierung    -- Gesamthierarchie mit Oberelemente mit zugriffbaren Blattelementen: von unten nach oben LOOP'||unistr('\000a')||
'      FROM "FAS_APP_MENUS" b'||unistr('\000a')||
'      WHERE b.app_id = :APP_ID'||unistr('\000a')||
'        and b.aktiv in (1,2)'||unistr('\000a')||
'      START WITH b.ID in (SELECT m.id     -- alle zugreifbaren Blattelemente'||unistr('\000a')||
'                          from fas_app_menus m'||unistr('\000a')||
'                          WHERE m.id not in';

s:=s||' (SELECT d.fas_app_menu_id       -- Oberelemente'||unistr('\000a')||
'                                             from fas_app_menus d'||unistr('\000a')||
'                                             WHERE d.app_id = :app_id'||unistr('\000a')||
'                                               and d.satz_kennzeichen is null'||unistr('\000a')||
'                                               and d.fas_app_menu_id is not null'||unistr('\000a')||
'                                            )'||unistr('\000a')||
'          ';

s:=s||'                  and m.page_id is not null'||unistr('\000a')||
'                            and m.app_id = :APP_ID'||unistr('\000a')||
'                            and m.SATZ_KENNZEICHEN is null'||unistr('\000a')||
'                            --  Aktuelle Page soll nicht im Menü auftauchen wg. verhindern doppeltem Aufruf'||unistr('\000a')||
'                            and m.page_id != :APP_PAGE_ID --Klappt merkwürdigerweise in APP 118 nicht ohne UNION s.u.'||unistr('\000a')||
'                    ';

s:=s||'        -- Zugriffsberechtigung inkl. Auswertung aktiv-Flag'||unistr('\000a')||
'                            and frgbg_t.CHECK_FAS_APP_ZUGRIFF(:FAS_LOGIN_PERSONENSTAMM_ID,:FAS_IDENTITAET_PERSSTAMM_ID,m.app_id,m.page_id,:FAS_AUFGERUFEN_VON) > 0'||unistr('\000a')||
'                            -- Menüpunkt überhaupt auf akt. Seite anzeigen'||unistr('\000a')||
'                            and (m.menu_visible_page_id is NULL OR instr(m.menu_visible_page_id,'';''||:';

s:=s||'APP_PAGE_ID||'';'') > 0)'||unistr('\000a')||
'                           )'||unistr('\000a')||
'       CONNECT BY PRIOR b.FAS_APP_MENU_ID = b.ID          -- von unten nach oben'||unistr('\000a')||
'              and prior b.app_id = :APP_ID'||unistr('\000a')||
'       UNION  -- NEI 25.10.13 muss sein damit "and m.page_id != :APP_PAGE_ID" auch in 118 klappt, das Plugin scheint sonst das Menü nicht in allen Fällen richtig aufzubauen'||unistr('\000a')||
'       SELECT -1,null,'''',''#'',9000000'||unistr('\000a')||
'       from du';

s:=s||'al'||unistr('\000a')||
'      ) x'||unistr('\000a')||
'START WITH x.FAS_APP_MENU_ID is null'||unistr('\000a')||
'CONNECT BY PRIOR x.ID=x.FAS_APP_MENU_ID        -- von oben nach unten'||unistr('\000a')||
'order siblings by x.SORTIERUNG'||unistr('\000a')||
'';

wwv_flow_api.create_page_plug (
  p_id=> 3272101447764378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 0,
  p_plug_name=> 'Menü',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'PLUGIN_COM.JWILSON.APEX.DROP_MENU',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'EXISTS',
  p_plug_display_when_condition => 'SELECT *'||unistr('\000a')||
'FROM APEX_APPLICATION_PAGES'||unistr('\000a')||
'WHERE '||unistr('\000a')||
'    :APP_PAGE_ID not in (100,101,       -- Login-Pages'||unistr('\000a')||
'                     38,82,132,999,144,345,76,238,48,'||unistr('\000a')||
'                     550,406,411,412,413, 407,408,416,417,418,550,431,432,      -- Inline-Page, Popup-Pages'||unistr('\000a')||
'                     409,414,419,422,402,433,434,427,441,442,603, '||unistr('\000a')||
'                     613, 39, 50, 614, 603, 631, 622, 608'||unistr('\000a')||
'                    )'||unistr('\000a')||
'    AND APPLICATION_ID = :APP_ID'||unistr('\000a')||
'    AND PAGE_ID = :APP_PAGE_ID'||unistr('\000a')||
'    AND (PAGE_TEMPLATE is null OR PAGE_TEMPLATE <> ''Popup'')',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_attribute_01=> '0',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<iframe id="jobliste_iframe" src ="f?p=&APP_ID.:550:&SESSION."  scrolling="no" style="height:100%; width:100%; border:0px; overflow:hidden; border-radius: 6px;">'||unistr('\000a')||
'</iframe>';

wwv_flow_api.create_page_plug (
  p_id=> 8782506976911664 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 0,
  p_plug_name=> 'Job Liste',
  p_region_name=>'',
  p_escape_on_http_output=>'Y',
  p_plug_template=> 3046215628431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'EXISTS',
  p_plug_display_when_condition => 'select  a.ID'||unistr('\000a')||
'from FRGBG.APP_JOBS a'||unistr('\000a')||
'where'||unistr('\000a')||
'  :APP_PAGE_ID not in (100,101,       -- Login-Pages'||unistr('\000a')||
'                     38,82,132,999,144,345,76,238,48,'||unistr('\000a')||
'                     550,406,411,412,413, 407,408,416,417,418,550,431,432,      -- Inline-Page, Popup-Pages'||unistr('\000a')||
'                     409,414,419,422,402,433,434,427, 441, 442,603, '||unistr('\000a')||
'                     613, 39, 603, 50,614, 631, 622, 608'||unistr('\000a')||
'  )'||unistr('\000a')||
'  AND :APP_PAGE_ID IN('||unistr('\000a')||
'      SELECT PAGE_ID'||unistr('\000a')||
'      FROM APEX_APPLICATION_PAGES'||unistr('\000a')||
'      WHERE '||unistr('\000a')||
'         APPLICATION_ID = :APP_ID'||unistr('\000a')||
'         AND PAGE_ID = :APP_PAGE_ID'||unistr('\000a')||
'         AND (PAGE_TEMPLATE is null OR PAGE_TEMPLATE <> ''Popup'')'||unistr('\000a')||
'  )'||unistr('\000a')||
'  and app_id = :APP_ID'||unistr('\000a')||
'  and USER_ACCOUNT = :APP_USER'||unistr('\000a')||
'  and a.MUTDAT > sysdate - 24/60 -- Maximal 60 Minuten halten'||unistr('\000a')||
'  and a.satz_kennzeichen is null'||unistr('\000a')||
'  and a.visible = 1'||unistr('\000a')||
'  and (a.STATUS_ID = 1 and a.JOB_ID in (select JOB from dba_jobs_running) or a.STATUS_ID <> 1)',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> '<div id="jobliste" style="position:absolute; top:40px; right:10px; width:340px;  background-color:#404040; padding:0px 0px 1px 10px; border-radius: 6px; border:1px solid #000; height:85px;">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 0
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00002
prompt  ...PAGE 2: Startseite der FAS-Verwaltung
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 2
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Startseite der FAS-Verwaltung'
 ,p_step_title => 'Startseite der FAS-Verwaltung'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_step_template => 3044128941431621 + wwv_flow_api.g_id_offset
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'N'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20111103125024'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3574102824087260 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2,
  p_plug_name=> 'START',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046215628431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_1',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<div style="max-width: 800px; ">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3574029920076209 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 28-SEP-2011 10:17 by BRIGITTE.NEIDHART');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3688704954541008 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2,
  p_name=>'P2_HINWEIS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3574102824087260+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Hinweis',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 4000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_read_only_when_type=>'ALWAYS',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   IF :p2_hinweis is not null THEN'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.p(''alert("''||:p2_hinweis||''");'');'||unistr('\000a')||
'      :p2_hinweis := NULL;'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;'||unistr('\000a')||
'';

wwv_flow_api.create_page_process(
  p_id     => 3690911503278875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'fehlerausgabe',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 2
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00003
prompt  ...PAGE 3: test html editor
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 3
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_name => 'test html editor'
 ,p_step_title => 'test html editor'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_help_text => 
'No help is available for this page.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20140918085300'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3563408458284181 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3,
  p_plug_name=> 'editor',
  p_region_name=>'',
  p_escape_on_http_output=>'Y',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => true,
  p_plug_new_grid_column  => true,
  p_plug_display_column=> null,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3563703346299337 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3,
  p_name=>'P3_HTMLTEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3563408458284181+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Htmltext',
  p_source=>'select u.text'||unistr('\000a')||
'from uebersetzungen u'||unistr('\000a')||
'where satz_kennzeichen is null'||unistr('\000a')||
'   and text_id = 10384'||unistr('\000a')||
'   and sprache_id = 357',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_RICH_TEXT_EDITOR',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 4000,
  p_cHeight=> 10,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_field_template=> 3049813415431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'CKEDITOR3',
  p_attribute_03 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 3
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00005
prompt  ...PAGE 5: xxxPreislisten
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 5
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'xxxPreislisten'
 ,p_step_title => 'Preislisten'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Preislisten'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_step_template => 3044128941431621 + wwv_flow_api.g_id_offset
 ,p_required_role => 3907510118925931 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20111104101027'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT p.id,p.id id_disp,'||unistr('\000a')||
'  p.TYP,to_char(DECODE(p.typ,1,''Endkunden'',2,''Grosskunden'',''Unbekannt'')) typ_bez,'||unistr('\000a')||
'  sp.sortiment_ID,s.bezeichnung sortiment_bezeichnung,'||unistr('\000a')||
'  p.WAEHRUNG_ID, NVL(w.zeichen,w.code), '||unistr('\000a')||
'  p.LAND_ID,l.land,sp.standard,'||unistr('\000a')||
'  p.BEZEICHNUNG,'||unistr('\000a')||
'  p.BEMERKUNG'||unistr('\000a')||
'FROM preislisten p,sortiment_preislisten sp,sortimente s,waehrungen w, laender l'||unistr('\000a')||
'WHERE p.satz_kennzeichen is null'||unistr('\000a')||
'  and p.ID = sp.pre';

s:=s||'isliste_id'||unistr('\000a')||
'  and sp.sortiment_id = s.id'||unistr('\000a')||
'  and p.waehrung_id = w.id'||unistr('\000a')||
'  and p.land_id = l.id'||unistr('\000a')||
'  -- Nur Preislisten aus dem Sortiment der eingeloggten Person'||unistr('\000a')||
'  and (sp.sortiment_id = rezepte.GET_sortiment(:FAS_LOGIN_PERSONENSTAMM_ID,''BETREUER'')'||unistr('\000a')||
'       OR'||unistr('\000a')||
'       frgbg_s.check_fas_rolle(:APP_USER,''FAS_VERWALTUNG_MASTER'') > 0'||unistr('\000a')||
'      )'||unistr('\000a')||
'/*  -- Standard-PL sowie private PL'||unistr('\000a')||
'  and (p.persstamm_id_owner is null ';

s:=s||'-- Standard-PL '||unistr('\000a')||
'       OR'||unistr('\000a')||
'       p.persstamm_id_owner=        -- private PL '||unistr('\000a')||
'             frgbg_s.GET_IDENT_2OBERSTE(NULL,:FAS_LOGIN_PERSONENSTAMM_ID)'||unistr('\000a')||
'       )'||unistr('\000a')||
'*/'||unistr('\000a')||
'and 1=1';

wwv_flow_api.create_page_plug (
  p_id=> 4442125483478526 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_plug_name=> '&P5_PAGE_TITEL_PREISLISTE.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'DYNAMIC_QUERY',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<div style="height:&P5_HEIGHT_PREISLISTE.px;padding-right:20px; overflow:auto; ">'||unistr('\000a')||
'',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'SELECT p.id,p.id id_disp,'||unistr('\000a')||
'  p.TYP,to_char(DECODE(p.typ,1,''Endkunden'',2,''Grosskunden'',''Unbekannt'')) typ_bez,'||unistr('\000a')||
'  sp.sortiment_ID,s.bezeichnung sortiment_bezeichnung,'||unistr('\000a')||
'  p.WAEHRUNG_ID, NVL(w.zeichen,w.code), '||unistr('\000a')||
'  p.LAND_ID,l.land,sp.standard,'||unistr('\000a')||
'  p.BEZEICHNUNG,'||unistr('\000a')||
'  p.BEMERKUNG'||unistr('\000a')||
'FROM preislisten p,sortiment_preislisten sp,sortimente s,waehrungen w, laender l'||unistr('\000a')||
'WHERE p.satz_kennzeichen is null'||unistr('\000a')||
'  and p.ID = sp.pre';

a1:=a1||'isliste_id'||unistr('\000a')||
'  and sp.sortiment_id = s.id'||unistr('\000a')||
'  and p.waehrung_id = w.id'||unistr('\000a')||
'  and p.land_id = l.id'||unistr('\000a')||
'  -- Nur Preislisten aus dem Sortiment der eingeloggten Person'||unistr('\000a')||
'  and (sp.sortiment_id = rezepte.GET_sortiment(:FAS_LOGIN_PERSONENSTAMM_ID,''BETREUER'')'||unistr('\000a')||
'       OR'||unistr('\000a')||
'       frgbg_s.check_fas_rolle(:APP_USER,''FAS_VERWALTUNG_MASTER'') > 0'||unistr('\000a')||
'      )'||unistr('\000a')||
'/*  -- Standard-PL sowie private PL'||unistr('\000a')||
'  and (p.persstamm_id_owner is null ';

a1:=a1||'-- Standard-PL '||unistr('\000a')||
'       OR'||unistr('\000a')||
'       p.persstamm_id_owner=        -- private PL '||unistr('\000a')||
'             frgbg_s.GET_IDENT_2OBERSTE(NULL,:FAS_LOGIN_PERSONENSTAMM_ID)'||unistr('\000a')||
'       )'||unistr('\000a')||
'*/'||unistr('\000a')||
'and 1=1';

wwv_flow_api.create_worksheet(
  p_id=> 4442329690478529+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_region_id=> 4442125483478526+wwv_flow_api.g_id_offset,
  p_name=> 'Preislisten',
  p_folder_id=> null, 
  p_alias=> '',
  p_report_id_item=> '',
  p_max_row_count=> '10000',
  p_max_row_count_message=> 'Diese Abfrage gibt über 10,000 Zeilen zurück. Filtern Sie die Daten, um vollständige Ergebnisse zu gewährleisten.',
  p_no_data_found_message=> 'Keine Daten gefunden.',
  p_max_rows_per_page=>'',
  p_search_button_label=>'',
  p_sort_asc_image=>'',
  p_sort_asc_image_attr=>'',
  p_sort_desc_image=>'',
  p_sort_desc_image_attr=>'',
  p_sql_query => a1,
  p_status=>'AVAILABLE_FOR_OWNER',
  p_allow_report_saving=>'Y',
  p_allow_save_rpt_public=>'N',
  p_allow_report_categories=>'N',
  p_show_nulls_as=>'-',
  p_pagination_type=>'ROWS_X_TO_Y_OF_Z',
  p_pagination_display_pos=>'TOP_RIGHT',
  p_show_finder_drop_down=>'Y',
  p_show_display_row_count=>'N',
  p_show_search_bar=>'Y',
  p_show_search_textbox=>'Y',
  p_show_actions_menu=>'Y',
  p_report_list_mode=>'TABS',
  p_show_detail_link=>'C',
  p_show_select_columns=>'Y',
  p_show_rows_per_page=>'Y',
  p_show_filter=>'Y',
  p_show_sort=>'Y',
  p_show_control_break=>'Y',
  p_show_highlight=>'Y',
  p_show_computation=>'Y',
  p_show_aggregate=>'Y',
  p_show_chart=>'Y',
  p_show_group_by=>'Y',
  p_show_notify=>'N',
  p_show_calendar=>'N',
  p_show_flashback=>'Y',
  p_show_reset=>'Y',
  p_show_download=>'Y',
  p_show_help=>'Y',
  p_download_formats=>'CSV',
  p_detail_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::P6_ID,P6_ARTIKEL_ERFASSEN,P6_SORTIMENT_ID:#ID#,0,#SORTIMENT_ID#',
  p_detail_link_text=>'<img src="#IMAGE_PREFIX#edit_big.gif" alt="">',
  p_allow_exclude_null_values=>'N',
  p_allow_hide_extra_columns=>'N',
  p_icon_view_enabled_yn=>'N',
  p_icon_view_use_custom=>'N',
  p_icon_view_columns_per_row=>1,
  p_detail_view_enabled_yn=>'N',
  p_owner=>'FRGBG',
  p_internal_uid=> 1);
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4442419207478540+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'TYP',
  p_display_order          =>3,
  p_column_identifier      =>'A',
  p_column_label           =>'Typ',
  p_report_label           =>'Typ',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4443212264478545+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'TYP_BEZ',
  p_display_order          =>4,
  p_column_identifier      =>'L',
  p_column_label           =>'Typ Bez',
  p_report_label           =>'Typ Bez',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4442524014478543+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'WAEHRUNG_ID',
  p_display_order          =>5,
  p_column_identifier      =>'C',
  p_column_label           =>'Waehrung Id',
  p_report_label           =>'Waehrung Id',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4442912560478545+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'NVL(W.ZEICHEN,W.CODE)',
  p_display_order          =>6,
  p_column_identifier      =>'I',
  p_column_label           =>'Währung',
  p_report_label           =>'Währung',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4442604845478543+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'LAND_ID',
  p_display_order          =>7,
  p_column_identifier      =>'D',
  p_column_label           =>'Land Id',
  p_report_label           =>'Land Id',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4443017488478545+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'LAND',
  p_display_order          =>8,
  p_column_identifier      =>'J',
  p_column_label           =>'Land',
  p_report_label           =>'Land',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4442711502478543+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'BEZEICHNUNG',
  p_display_order          =>9,
  p_column_identifier      =>'E',
  p_column_label           =>'Bezeichnung',
  p_report_label           =>'Bezeichnung',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'WITHOUT_MODIFICATION',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4442811809478543+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'BEMERKUNG',
  p_display_order          =>10,
  p_column_identifier      =>'F',
  p_column_label           =>'Bemerkung',
  p_report_label           =>'Bemerkung',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'WITHOUT_MODIFICATION',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4443119029478545+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ID',
  p_display_order          =>11,
  p_column_identifier      =>'K',
  p_column_label           =>'Id',
  p_report_label           =>'Id',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:RP::',
  p_column_linktext        =>'#ID#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'WITHOUT_MODIFICATION',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4443529956478545+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'STANDARD',
  p_display_order          =>14,
  p_column_identifier      =>'O',
  p_column_label           =>'Standard',
  p_report_label           =>'Standard',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 1699813748708790+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'SORTIMENT_ID',
  p_display_order          =>15,
  p_column_identifier      =>'P',
  p_column_label           =>'Sortiment Id',
  p_report_label           =>'Sortiment Id',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_tz_dependent           =>'N',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 1699913385708797+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'SORTIMENT_BEZEICHNUNG',
  p_display_order          =>16,
  p_column_identifier      =>'Q',
  p_column_label           =>'Bezeichnung',
  p_report_label           =>'Bezeichnung',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_tz_dependent           =>'N',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 1704511852610229+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ID_DISP',
  p_display_order          =>17,
  p_column_identifier      =>'R',
  p_column_label           =>'Preisliste Id',
  p_report_label           =>'Preisliste Id',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_tz_dependent           =>'N',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
declare
    rc1 varchar2(32767) := null;
begin
rc1:=rc1||'SORTIMENT_ID:SORTIMENT_BEZEICHNUNG:ID:NVL(W.ZEICHEN,W.CODE):LAND:TYP_BEZ:STANDARD:BEZEICHNUNG:BEMERKUNG';

wwv_flow_api.create_worksheet_rpt(
  p_id => 4443624442478548+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_worksheet_id => 4442329690478529+wwv_flow_api.g_id_offset,
  p_session_id  => null,
  p_base_report_id  => null+wwv_flow_api.g_id_offset,
  p_application_user => 'APXWS_DEFAULT',
  p_report_seq              =>10,
  p_report_alias            =>'1241015879669868',
  p_status                  =>'PUBLIC',
  p_category_id             =>null+wwv_flow_api.g_id_offset,
  p_is_default              =>'Y',
  p_display_rows            =>15,
  p_report_columns          =>rc1,
  p_sort_column_1           =>'SORTIMENT_ID',
  p_sort_direction_1        =>'ASC',
  p_flashback_enabled       =>'N',
  p_calendar_display_column =>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4443921120478553 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 4444412472478554 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 10,
  p_button_plug_id => 4442125483478526+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P5_BL_ERSTELLEN.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:6::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1195200697646406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_NV_PREISLISTEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 4442125483478526+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Preislisten',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4444611295478554 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_PAGE_TITEL_PREISLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 4442125483478526+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Preisliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4444825204478554 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_BL_ERSTELLEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 4442125483478526+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Erstellen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4445017998478554 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_HEIGHT_PREISLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 4442125483478526+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Preisliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049813415431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P5_HEIGHT_preisliste := :FAS_SCROLLREGION_HEIGHT_MAX * 0.78;'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4445409917478556 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p5_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p5_page_titel_preisliste := frgbg_s.holen_uebersetzung(3549,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :P5_NV_PREISLISTEN := frgbg_s.holen_uebersetzung(4418,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4445226772478554 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 5
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00006
prompt  ...PAGE 6: xxxPreislisten-Details
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 6
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'xxxPreislisten-Details'
 ,p_step_title => 'Preislisten-Details'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Preislisten-Details'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_html_page_header => 
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'||unistr('\000a')||
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_ch_message=''"OK_TO_GET_NEXT_PREV_PK_VALUE"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_required_role => 3907510118925931 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20111104101047'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3074614043468453 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6,
  p_plug_name=> '&P6_PAGE_TITEL_PREISLISTE.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p6_artikel_erfassen = 0',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select'||unistr('\000a')||
'd.ID,'||unistr('\000a')||
'd.PREISLISTE_ID,'||unistr('\000a')||
'd.MENGENART_ID,'||unistr('\000a')||
'fas_synch.get_tab_uebersetzung(''MENGENARTS.KUERZEL'',d.mengenart_id,:fas_sprache_id) mart_kuerzel,'||unistr('\000a')||
'fas_synch.get_tab_uebersetzung(''MN_REZEPTE.BEZEICHNUNG'',mnr.id,:fas_sprache_id) mn_rezept_bezeichnung,'||unistr('\000a')||
'd.PREIS,'||unistr('\000a')||
'd.MIN_MENGE,'||unistr('\000a')||
'd.MAX_MENGE,'||unistr('\000a')||
'd.GUELTIG_AB,'||unistr('\000a')||
'd.GUELTIG_BIS,'||unistr('\000a')||
'd.art_mwst_typ_id,'||unistr('\000a')||
'd.SATZ_KENNZEICHEN,'||unistr('\000a')||
'd.ERFDAT,'||unistr('\000a')||
'd.ERFUSER,'||unistr('\000a')||
'd.MUTDAT,'||unistr('\000a')||
'd.MUTUSER'||unistr('\000a')||
'from PREI';

s:=s||'SLISTEN_DETAILS d, mn_rezepte mnr, mengenarts a'||unistr('\000a')||
'where d.PREISLISTE_ID = :P6_ID'||unistr('\000a')||
'  and d.mengenart_id = a.id'||unistr('\000a')||
'  and a.mn_rezept_id = mnr.id (+) '||unistr('\000a')||
'  and  --Preisansicht'||unistr('\000a')||
'      ( (d.GUELTIG_AB <= SYSDATE AND  d.GUELTIG_BIS >=SYSDATE '||unistr('\000a')||
'          AND instr('':''||:p6_preisansicht||'':'','':1:'') > 0) -- aktuelle Preise'||unistr('\000a')||
'     OR (d.GUELTIG_ab > SYSDATE '||unistr('\000a')||
'          AND instr('':''||:p6_preisansicht||'':'','':2:'') > 0) -- ';

s:=s||'zukünftige Preise'||unistr('\000a')||
'     OR (d.GUELTIG_bis < SYSDATE '||unistr('\000a')||
'          AND instr('':''||:p6_preisansicht||'':'','':0:'') > 0) -- alte Preise'||unistr('\000a')||
'      )'||unistr('\000a')||
'';

wwv_flow_api.create_report_region (
  p_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6,
  p_name=> '&P6_PAGE_TITEL_PREISE.',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_display_when_condition=> ':P6_ID is not null and :p6_artikel_erfassen = 0',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P6_HEIGHT_ARTIKELLISTE.px;padding-right:20px; overflow:auto;">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3519,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '100',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3076307083468457 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CHECK$01',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'NEVER',
  p_display_as=>'CHECKBOX',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_derived_column=> 'Y',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075006763468454 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source_type=> 'T',
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075104539468456 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PREISLISTE_ID',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_default=> 'P6_ID',
  p_column_default_type=> 'ITEM',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'PREISLISTE_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075218198468456 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'MENGENART_ID',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'MENGENART_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3120802799787276 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'MART_KUERZEL',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4302117663028909 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'MN_REZEPT_BEZEICHNUNG',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075316848468456 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'PREIS',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_format=> '990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '6',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'PREIS',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075427747468456 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'MIN_MENGE',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '8',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'MIN_MENGE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075507547468456 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'MAX_MENGE',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '8',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'MAX_MENGE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075610997468456 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'GUELTIG_AB',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_format=> 'DD.MM.YYYY',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '8',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'GUELTIG_AB',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075728370468457 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'GUELTIG_BIS',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_format=> 'DD.MM.YYYY',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '8',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'GUELTIG_BIS',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4363804362564782 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'ART_MWST_TYP_ID',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'SELECT_LIST_FROM_QUERY',
  p_inline_lov=> 'SELECT fas_synch.get_tab_uebersetzung(''ART_MWST_TYPEN.BEZEICHNUNG'',id,'||unistr('\000a')||
'                                      :fas_sprache_id) a, id b'||unistr('\000a')||
'from art_mwst_typen'||unistr('\000a')||
'where satz_kennzeichen is null',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075820139468457 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'SATZ_KENNZEICHEN',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'SATZ_KENNZEICHEN',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3075917666468457 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'ERFDAT',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '7',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'ERFDAT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3076013170468457 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'ERFUSER',
  p_column_display_sequence=> 15,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'ERFUSER',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3076111553468457 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'MUTDAT',
  p_column_display_sequence=> 16,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '7',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'MUTDAT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3076200548468457 + wwv_flow_api.g_id_offset,
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'MUTUSER',
  p_column_display_sequence=> 17,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PREISLISTEN_DETAILS',
  p_ref_column_name=> 'MUTUSER',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3146618560178468 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3196308077468803 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6,
  p_plug_name=> '&P6_PAGE_TITEL_ARTIKEL.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p6_artikel_erfassen = 1',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3077030915468459 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 30,
  p_button_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P6_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> ':P6_ID is not null',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3196513893468803 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 30,
  p_button_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE_ARTIKEL',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P6_BL_IN_AKT_PREISLISTE.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3865103631086320 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 30,
  p_button_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_PREISANPASS',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P6_BL_PREISANPASS.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3078014774468460 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 40,
  p_button_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_ADD',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P6_BL_ARTIKEL_ERF.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3077421902468460 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 50,
  p_button_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_PREVIOUS_ID',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&lt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_PREVIOUS_ID'')',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P6_ID_PREV is not null',
  p_button_condition_type=> 'NEVER',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3077612318468460 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 60,
  p_button_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_NEXT_ID',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&gt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_NEXT_ID'')',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P6_ID_NEXT is not null',
  p_button_condition_type=> 'NEVER',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3696616681591300 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 70,
  p_button_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE_ARTIKEL_ALLE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P6_BL_IN_ALLE_PREISLISTE.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3076610284468457 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 10,
  p_button_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P6_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:6::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3196706435468803 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 10,
  p_button_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL_ARTIKEL',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P6_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3077213436468459 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 40,
  p_button_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P6_BL_ERSTELLEN.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P6_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3076832487468459 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 20,
  p_button_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P6_BL_LOESCHEN.',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> ':P6_ID is not null',
  p_button_condition_type=> 'NEVER',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3077825619468460 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 20,
  p_button_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_MRD',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Markierte Elemente löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''APPLY_CHANGES_MRD'');',
  p_button_condition=> '/* EXIST */'||unistr('\000a')||
'select 1 '||unistr('\000a')||
'from "PIS"."PREISLISTEN_DETAILS"'||unistr('\000a')||
'where "PREISLISTE_ID" = :P6_ID',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3085918854468473 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::P6_ID:&P6_ID_NEXT.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3077612318468460+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
wwv_flow_api.create_page_branch(
  p_id=>3086123902468473 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::P6_ID:&P6_ID_PREV.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3077421902468460+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
wwv_flow_api.create_page_branch(
  p_id=>3085726311468473 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 30,
  p_branch_condition_type=> 'REQUEST_IN_CONDITION',
  p_branch_condition=> 'DELETE',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>3086325668468473 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:6:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 40,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1194716365632074 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_NV_PREISLISTEN_DETAILS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 320,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Preislisten Details',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1390720806953924 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_SATZ_KENNZEICHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'SATZ_KENNZEICHEN',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3078204416468460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 52,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Preislistentyp (z.B. Grosskunde/Endkunde)';

wwv_flow_api.create_page_item(
  p_id=>3078412582468462 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_TYP',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'TYP',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT ''Endkunden'' a,1 b FROM DUAL'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Grosskunden'', 2 FROM DUAL',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p6_id is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3078930243468465 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_SORTIMENT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'SORTIMENT_ID',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT bezeichnung a, id b'||unistr('\000a')||
'from sortimente'||unistr('\000a')||
'where satz_kennzeichen is null',
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'Neues Sortiment',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p6_id is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3079110752468465 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_WAEHRUNG_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '27',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_post_element_text=>'&#160 &#160 &#160',
  p_source=>'WAEHRUNG_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select NVL(zeichen,code) a, id b'||unistr('\000a')||
'from waehrungen'||unistr('\000a')||
'WHERE id in (27,44)'||unistr('\000a')||
'order by 1 '||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p6_id is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3079318402468465 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_LAND_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '198',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_pre_element_text=>'    ',
  p_post_element_text=>'&#160 &#160 &#160',
  p_source=>'LAND_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select land a , id b from laender where id = 198 order by 1'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p6_id is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3082011118468468 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_ID_NEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'P6_ID_NEXT',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3082213324468468 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_ID_PREV',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'P6_ID_PREV',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3082418865468468 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_ID_COUNT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 17,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'class="fielddata"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3109702234382596 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BEZEICHNUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'BEZEICHNUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 31,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3110129939390560 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'BEMERKUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3136707762177181 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_HEIGHT_ARTIKELLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Artikelliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049608974431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3197715944468823 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_MENGENART_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select fas_synch.get_tab_uebersetzung(''MENGENARTS.KUERZEL'',d.id,:fas_sprache_id)'||unistr('\000a')||
'     ||'' ''||fas_synch.get_tab_uebersetzung(''MN_REZEPTE.BEZEICHNUNG'',mnr.id,'||unistr('\000a')||
'                                    :fas_sprache_id) a, d.id b'||unistr('\000a')||
'FROM mengenarts d, mn_rezepte mnr, mengenarts a'||unistr('\000a')||
'where d.satz_kennzeichen is null '||unistr('\000a')||
'  and d.artikel_id Is null /* keine HCK-individuell */'||unistr('\000a')||
'  /*and d.rezeptartikel = ''R''*/'||unistr('\000a')||
'  and d.id = a.id'||unistr('\000a')||
'  and a.mn_rezept_id = mnr.id (+) '||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3198121076468823 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_PREIS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3198504960468823 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_MIN_MENGE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3198928952468825 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_MAX_MENGE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3199317384468825 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_GUELTIG_AB',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_format_mask=>'DD.MM.YYYY',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DATE_PICKER_CLASSIC',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3199727472468825 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_GUELTIG_BIS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_format_mask=>'DD.MM.YYYY',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DATE_PICKER_CLASSIC',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3200111046468826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_PLDBEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> 4,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3201032318475793 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_ARTIKEL_ERFASSEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Artikel Erfassen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049608974431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3279204385714725 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_SORTIMENT_BEZEICHNUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 16,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3284200950940901 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_STANDARD',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 55,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'STANDARD',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_CHECKBOX',
  p_lov=> 'STATIC2:;1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => '1',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3311922848736760 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_ID_ALTER_STANDARD_IM_SET',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Id Alter Standard Im Set',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3924930914051346 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_PREISANPASSUNG_TYP',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 180,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Preisanpassung',
  p_post_element_text=>'&#160&#160&#160&#160&#160&#160',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(3570,:fas_sprache_id) a, 0 b'||unistr('\000a')||
'from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(3569,:fas_sprache_id),1'||unistr('\000a')||
'from dual'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3925229659060370 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_PREISFAKTOR',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 190,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Preisfaktor',
  p_format_mask=>'990D00',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 4,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3925400139070796 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_ANPASSUNG_GUELTIG_AB',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 200,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'to_char(sysdate,''DD.MM.YYYY'')',
  p_item_default_type=> 'PLSQL_EXPRESSION',
  p_prompt=>'Gültig ab',
  p_format_mask=>'DD.MM.YYYY',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DATE_PICKER_CLASSIC',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 10,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3994209714255901 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_ART_MWST_TYP_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 81,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT fas_synch.get_tab_uebersetzung(''ART_MWST_TYPEN.BEZEICHNUNG'','||unistr('\000a')||
'                                      ID,:fas_sprache_id) a, id b '||unistr('\000a')||
'FROM art_mwst_typen'||unistr('\000a')||
'where satz_kennzeichen is null',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4241531808583582 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_PAGE_TITEL_PREISLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 210,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Preisliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4241708736586443 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BL_ERSTELLEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 220,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Erstellen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4242721943618646 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BL_LOESCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 230,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Loeschen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4242932332621621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BL_SPEICHERN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 240,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Speichern',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4243109261624378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BL_ABBRECHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 250,
  p_item_plug_id => 3074614043468453+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Abbrechen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4246912087729281 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BL_PREISANPASS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 260,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Preisanpass',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4247123515732601 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BL_ARTIKEL_ERF',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 270,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Artikel Erf',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4247410271747725 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_PAGE_TITEL_PREISE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 280,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Preise',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4250828953951764 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_PAGE_TITEL_ARTIKEL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 290,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Preise',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4251319865968148 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BL_IN_AKT_PREISLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 300,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl In Akt Preisliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4251530600971190 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_BL_IN_ALLE_PREISLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 310,
  p_item_plug_id => 3196308077468803+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl In Alle Preisliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4331123545847937 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_name=>'P6_PREISANSICHT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 3074819693468454+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Preisansicht',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_CHECKBOX',
  p_lov=> 'SELECT ''Alte Preise'' a, 0 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Aktuelle Preise'' a, 1 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Zukünftige Preise'' a, 2 b from dual'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onChange="javascript:doSubmit('''') "',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => '3',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3082701328468470 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_TYP not null',
  p_validation_sequence=> 1,
  p_validation => 'P6_TYP',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Typ Name muss einen Wert haben.',
  p_associated_item=> 3078412582468462 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3082929707468470 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_SORTIMENT_ID not null',
  p_validation_sequence=> 2,
  p_validation => 'P6_SORTIMENT_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Die PREISLISTEN_SET_ID muss einen Wert haben.',
  p_always_execute=>'N',
  p_associated_item=> 3078930243468465 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3281505358885320 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_BEZEICHNUNG',
  p_validation_sequence=> 3,
  p_validation => 'P6_BEZEICHNUNG',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Preislisten-Bezeichnung muss angegeben werden.',
  p_associated_item=> 3109702234382596 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3083100016468470 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_WAEHRUNG_ID not null',
  p_validation_sequence=> 4,
  p_validation => 'P6_WAEHRUNG_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Waehrung Id Name muss einen Wert haben.',
  p_associated_item=> 3079110752468465 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3083301241468470 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_LAND_ID not null',
  p_validation_sequence=> 5,
  p_validation => 'P6_LAND_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Land Id Name muss einen Wert haben.',
  p_associated_item=> 3079318402468465 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3198005393468823 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_MENGENART_ID not null',
  p_validation_sequence=> 30,
  p_validation => 'P6_MENGENART_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Mengenart Id Name muss einen Wert haben.',
  p_validation_condition=> ':request in (''SAVE_ARTIKEL_ALLE'',''SAVE_ARTIKEL'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 3197715944468823 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3198415416468823 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_PREIS not null',
  p_validation_sequence=> 40,
  p_validation => 'P6_PREIS',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Preis Name muss einen Wert haben.',
  p_validation_condition=> ':request in (''SAVE_ARTIKEL_ALLE'',''SAVE_ARTIKEL'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 3198121076468823 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3198828728468825 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_MIN_MENGE not null',
  p_validation_sequence=> 50,
  p_validation => 'P6_MIN_MENGE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Min Menge Name muss einen Wert haben.',
  p_validation_condition=> ':request in (''SAVE_ARTIKEL_ALLE'',''SAVE_ARTIKEL'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 3198504960468823 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3199209245468825 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_MAX_MENGE not null',
  p_validation_sequence=> 60,
  p_validation => 'P6_MAX_MENGE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Max Menge Name muss einen Wert haben.',
  p_validation_condition=> ':request in (''SAVE_ARTIKEL_ALLE'',''SAVE_ARTIKEL'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 3198928952468825 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3199604995468825 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_GUELTIG_AB not null',
  p_validation_sequence=> 70,
  p_validation => 'P6_GUELTIG_AB',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Gueltig Ab Name muss einen Wert haben.',
  p_validation_condition=> ':request in (''SAVE_ARTIKEL_ALLE'',''SAVE_ARTIKEL'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 3199317384468825 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3200027111468826 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_GUELTIG_BIS not null',
  p_validation_sequence=> 80,
  p_validation => 'P6_GUELTIG_BIS',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Gueltig Bis Name muss einen Wert haben.',
  p_validation_condition=> ':request in (''SAVE_ARTIKEL_ALLE'',''SAVE_ARTIKEL'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 3199727472468825 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3926228368116764 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_PREISFAKTOR',
  p_validation_sequence=> 90,
  p_validation => 'BEGIN'||unistr('\000a')||
'   IF :p6_preisfaktor <= 0 THEN'||unistr('\000a')||
'      RETURN (''Der Preisfaktor muss positiv sein!'');'||unistr('\000a')||
'   ELSIF :p6_preisfaktor is null THEN'||unistr('\000a')||
'      RETURN (''Der Preisfaktor ist eingabepflichtig!(> 1 Preiserhöhung, < 1 Preissenkung, = 1 unveränderter Preis'');'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_when_button_pressed=> 3865103631086320 + wwv_flow_api.g_id_offset,
  p_associated_item=> 3925229659060370 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3926411792140443 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P6_ANPASSUNG_GUELTIG_AB',
  p_validation_sequence=> 100,
  p_validation => 'BEGIN'||unistr('\000a')||
'   IF :p6_anpassung_gueltig_ab is null THEN'||unistr('\000a')||
'      RETURN (''Das Feld "Gültig ab" ist eingabepflichtig!'');'||unistr('\000a')||
'   ELSIF to_date(:p6_anpassung_gueltig_ab,''DD.MM.YYYY'') < trunc(sysdate,''DD'') THEN'||unistr('\000a')||
'      RETURN (''Das Feld "Gültig ab" muss grösser oder gleich dem Tagesdatum sein!'');   '||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_when_button_pressed=> 3865103631086320 + wwv_flow_api.g_id_offset,
  p_associated_item=> 3925400139070796 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|PIS:PREISLISTEN:P6_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 3084232536468471 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from PREISLISTEN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Abrufen von Zeile nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_return_key_into_item1=>'P6_ID',
  p_runtime_where_clause=>'satz_kennzeichen is null',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:PREISLISTEN:ID::::P6_ID:P6_ID_NEXT:P6_ID_PREV::::P6_ID_COUNT:satz_kennzeichen is null';

wwv_flow_api.create_page_process(
  p_id     => 3084612064468471 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'GET_NEXT_OR_PREV_PK',
  p_process_name=> 'Nächsten oder vorherigen Primärschlüsselwert abrufen',
  p_process_sql_clob => p,
  p_process_error_message=> 'Ausführen von Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--mel.p(''Option %1'',v_prot_id,''test'',''118/6 switch_bearbeiten_erfassen'',:p6_preisansicht);'||unistr('\000a')||
'IF :request in (''APPLY_CHANGES_ADD'') THEN'||unistr('\000a')||
'   --:p6_preisliste_id := :p6_id;'||unistr('\000a')||
'   :p6_artikel_erfassen := 1;'||unistr('\000a')||
'ELSE'||unistr('\000a')||
'   :p6_artikel_erfassen := 0;'||unistr('\000a')||
'END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3201411240498067 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'switch_bearbeiten_erfassen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'IF :request = ''DELETE'' THEN'||unistr('\000a')||
'   :p6_satz_kennzeichen := ''geloescht am ''||'||unistr('\000a')||
'               to_char(sysdate,''DD.MM.YYYY hh24:mi'')||'' von ''||:APP_USER;'||unistr('\000a')||
'END IF;';

wwv_flow_api.create_page_process(
  p_id     => 3107011707968948 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 5,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'preisliste_loeschkennz_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3076832487468459 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'    v_prot_id    NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :P6_SORTIMENT_ID <> 0 THEN'||unistr('\000a')||
'      IF :p6_SORTIMENT_bezeichnung IS NOT NULL THEN'||unistr('\000a')||
'         UPDATE sortimente'||unistr('\000a')||
'         SET bezeichnung = :p6_sortiment_bezeichnung '||unistr('\000a')||
'         WHERE id = :p6_sortiment_id;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      select sortiment_seq.nextval into :P6_sortiment_ID from dual;'||unistr('\000a')||
'      INSERT INTO sortimente (id,bezeichnung)'||unistr('\000a')||
'      VALUES (:P6_sor';

p:=p||'timent_ID,'||unistr('\000a')||
'              NVL(:p6_sortiment_bezeichnung,''Sortiment ''||:P6_sortiment_ID)'||unistr('\000a')||
'             );'||unistr('\000a')||
'      :p6_standard := 1;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'/*mel.p(''Neues Sortiment %1'',v_prot_id,''Info'',''plset speichern'',:P6_sortiment_ID); */'||unistr('\000a')||
'   :p6_sortiment_bezeichnung := NULL;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3280017114737340 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 6,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sortiment_speichern',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''CREATE'',''SAVE'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p6_standard := NVL(:p6_standard,0);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3309429803615801 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 7,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'preislisten_std_null',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :request = ''CREATE'' THEN'||unistr('\000a')||
'      -- Alter Standard merken, da beim Details erzeugen im FALL CREATE darauf zurückgegriffen wird,'||unistr('\000a')||
'      -- wg. Kopie der Details'||unistr('\000a')||
'      SELECT min (id) into :p6_id_alter_standard_im_set'||unistr('\000a')||
'      FROM sortiment_preislisten'||unistr('\000a')||
'      WHERE ((preisliste_id != :p6_id and :p6_id is not null) OR '||unistr('\000a')||
'              :p6_id is null)  -- nicht aktu';

p:=p||'eller Satz'||unistr('\000a')||
'        AND standard = 1'||unistr('\000a')||
'        AND sortiment_id = :p6_sortiment_id;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   IF :p6_standard = 1 THEN'||unistr('\000a')||
'--mel.p(''id %1,std %2,set %3'',v_prot_id,''testinfo'',''118/6'',:p6_id,:p6_standard,:p6_preislisten_set_id);'||unistr('\000a')||
'      -- Alter Standard im Set zurücksetzen'||unistr('\000a')||
'      UPDATE sortiment_preislisten'||unistr('\000a')||
'      SET standard = 0'||unistr('\000a')||
'      WHERE (id != :p6_id and :p6_id is not null OR :p6_id is null)       ';

p:=p||'-- nicht aktueller Satz'||unistr('\000a')||
'        AND standard = 1'||unistr('\000a')||
'        AND sortiment_id = :p6_sortiment_id;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3284827493014793 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 8,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'preislisten_std_verwalten',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SAVE'',''CREATE'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:PREISLISTEN:P6_ID:ID|IU';

wwv_flow_api.create_page_process(
  p_id     => 3084417771468471 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of PREISLISTEN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Zeile der Tabelle PREISLISTEN nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request not in (''SAVE_ARTIKEL'',''SAVE_ARTIKEL_ALLE'');',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_return_key_into_item1=>'P6_ID',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:PREISLISTEN_DETAILS:ID';

wwv_flow_api.create_page_process(
  p_id     => 3085000660468471 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_UPDATE',
  p_process_name=> 'ApplyMRU',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Aktualisierung nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'APPLY_CHANGES_ADD,SAVE',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:PREISLISTEN_DETAILS:ID';

wwv_flow_api.create_page_process(
  p_id     => 3084831414468471 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_DELETE',
  p_process_name=> 'ApplyMRD',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Löschvorgang nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'request in (''APPLY_CHANGES_MRD'',''SAVE'')',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '#MRD_COUNT#-Zeile(n) gelöscht.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'1';

wwv_flow_api.create_page_process(
  p_id     => 3085429093468473 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 3074819693468454 + wwv_flow_api.g_id_offset,
  p_process_type=> 'ADD_ROWS_TO_TABULAR_FORM',
  p_process_name=> 'AddRows',
  p_process_sql_clob => p,
  p_process_error_message=> 'Hinzufügen von Zeilen nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_preisliste_id  preislisten.id%TYPE;'||unistr('\000a')||
'   v_preislisten_details   preislisten_details%ROWTYPE;'||unistr('\000a')||
'   v_prot_id        NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :request = ''CREATE'' THEN'||unistr('\000a')||
'      IF :p6_id_alter_standard_im_set is not null THEN'||unistr('\000a')||
'         v_preisliste_id := :p6_id_alter_standard_im_set;'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         v_preisliste_id := 1;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'      :p6_id_alter_standard_im_set:= NULL;'||unistr('\000a')||
'--mel.p(''Preislist';

p:=p||'e %1'',v_prot_id,''testinfo'',''118/6'',v_preisliste_id );'||unistr('\000a')||
'      INSERT INTO preislisten_details ('||unistr('\000a')||
'            PREISLISTE_ID ,'||unistr('\000a')||
'            MENGENART_ID ,'||unistr('\000a')||
'            PREIS,'||unistr('\000a')||
'            MIN_MENGE ,'||unistr('\000a')||
'            MAX_MENGE,'||unistr('\000a')||
'            GUELTIG_AB ,'||unistr('\000a')||
'            GUELTIG_BIS ,'||unistr('\000a')||
'            BEMERKUNG ,'||unistr('\000a')||
'            art_mwst_typ_id'||unistr('\000a')||
'           )'||unistr('\000a')||
'        SELECT '||unistr('\000a')||
'            :p6_ID ,'||unistr('\000a')||
'            MENGENART_ID ,'||unistr('\000a')||
'     ';

p:=p||'       PREIS,'||unistr('\000a')||
'            MIN_MENGE ,'||unistr('\000a')||
'            MAX_MENGE,'||unistr('\000a')||
'            GUELTIG_AB ,'||unistr('\000a')||
'            GUELTIG_BIS ,'||unistr('\000a')||
'            BEMERKUNG ,'||unistr('\000a')||
'            art_mwst_typ_id'||unistr('\000a')||
'        FROM preislisten_details'||unistr('\000a')||
'        WHERE preisliste_id = v_preisliste_id'||unistr('\000a')||
'          AND satz_kennzeichen is null                        -- keine gelöschten Preis'||unistr('\000a')||
'          AND GUELTIG_AB <= to_date(to_char(SYSDATE,''DD.MM.YYYY''),''DD';

p:=p||'.MM.YYYY'') -- nur akt.Preise'||unistr('\000a')||
'          AND GUELTIG_BIS >= to_date(to_char(SYSDATE,''DD.MM.YYYY''),''DD.MM.YYYY'');'||unistr('\000a')||
'    '||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   :p6_id_alter_standard_im_set:= NULL;'||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 3107528301096795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 60,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Standard_Preislisten_details_erzeugen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3077213436468459 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   IF :request = ''SAVE_ARTIKEL_ALLE'' THEN'||unistr('\000a')||
'      INSERT INTO preislisten_details('||unistr('\000a')||
'          PREISLISTE_ID ,'||unistr('\000a')||
'          MENGENART_ID ,'||unistr('\000a')||
'          PREIS,'||unistr('\000a')||
'          MIN_MENGE ,'||unistr('\000a')||
'          MAX_MENGE,'||unistr('\000a')||
'          GUELTIG_AB ,'||unistr('\000a')||
'          GUELTIG_BIS ,'||unistr('\000a')||
'          BEMERKUNG'||unistr('\000a')||
'          )'||unistr('\000a')||
'      SELECT                            -- Artikel wird in alle Preislisten aufgenommen'||unistr('\000a')||
'           id ,'||unistr('\000a')||
'           :p6_MENG';

p:=p||'ENART_ID ,'||unistr('\000a')||
'           :p6_PREIS ,'||unistr('\000a')||
'           :p6_MIN_MENGE ,'||unistr('\000a')||
'           :p6_MAX_MENGE,'||unistr('\000a')||
'           to_date(:p6_GUELTIG_AB,''DD.MM.RRRR'') ,'||unistr('\000a')||
'           to_date(:p6_GUELTIG_BIS,''DD.MM.RRRR'') ,'||unistr('\000a')||
'           :p6_pldBEMERKUNG'||unistr('\000a')||
'      from preislisten'||unistr('\000a')||
'    ;'||unistr('\000a')||
'  ELSIF :request = ''SAVE_ARTIKEL'' THEN'||unistr('\000a')||
'      INSERT INTO preislisten_details('||unistr('\000a')||
'          PREISLISTE_ID ,'||unistr('\000a')||
'          MENGENART_ID ,'||unistr('\000a')||
'          PREIS,'||unistr('\000a')||
'         ';

p:=p||' MIN_MENGE ,'||unistr('\000a')||
'          MAX_MENGE,'||unistr('\000a')||
'          GUELTIG_AB ,'||unistr('\000a')||
'          GUELTIG_BIS ,'||unistr('\000a')||
'          BEMERKUNG'||unistr('\000a')||
'          )'||unistr('\000a')||
'      VALUES -- Artikel nur in aktuelle Preislisten aufnehmen'||unistr('\000a')||
'          (:p6_id ,'||unistr('\000a')||
'           :p6_MENGENART_ID ,'||unistr('\000a')||
'           :p6_PREIS ,'||unistr('\000a')||
'           :p6_MIN_MENGE ,'||unistr('\000a')||
'           :p6_MAX_MENGE,'||unistr('\000a')||
'           to_date(:p6_GUELTIG_AB,''DD.MM.RRRR'') ,'||unistr('\000a')||
'           to_date(:p6_GUELTIG_BIS,''DD.MM.RRRR'') ';

p:=p||','||unistr('\000a')||
'           :p6_pldBEMERKUNG'||unistr('\000a')||
'          );'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 3212631812939215 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 70,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert_neuer_artikel',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SAVE_ARTIKEL_ALLE'',''SAVE_ARTIKEL'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_datum                date;'||unistr('\000a')||
'   v_preislisten_id       number;'||unistr('\000a')||
'   v_prot_id              number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :P6_PREISANPASSUNG_TYP = 1 THEN'||unistr('\000a')||
'      v_preislisten_id := :p6_id;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      v_preislisten_id := NULL;  -- alle Preislisten'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'/*mel.p(''Faktor %1, Gueltig ab %2, Preisliste %3, FSP %4, typ %5'', v_prot_id,''test'',''preisanpassung 118/6'',:p6_preisfaktor,:p6_anpassung_guelt';

p:=p||'ig_ab,v_preislisten_id,:FSP_LANGUAGE_PREFERENCE,:P6_PREISANPASSUNG_TYP);*/'||unistr('\000a')||
'   v_datum := to_date(:p6_anpassung_gueltig_ab,''DD.MM.YYYY'');'||unistr('\000a')||
'   REZEPTE.FAS_PREISLISTE_SPLIT (v_datum,:p6_preisfaktor, v_preislisten_id);'||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 3865530344122400 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 80,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'preisanpassung',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3865103631086320 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'6';

wwv_flow_api.create_page_process(
  p_id     => 3085217255468473 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 100,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3076832487468459 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P6_HEIGHT_artikelliste := :FAS_SCROLLREGION_HEIGHT_MAX * 0.6;'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3136405207166979 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 5,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p6_artikel_erfassen := 0;';

wwv_flow_api.create_page_process(
  p_id     => 3204622153539084 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_maske',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'Y',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p6_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
'   :p6_bl_abbrechen := frgbg_s.holen_uebersetzung(510,v_sprache_id);'||unistr('\000a')||
'   :p6_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'   :p6_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
'   :p6_bl_preisanpass  := frgbg_s.holen_uebersetzung(3557,v_sprache';

p:=p||'_id);'||unistr('\000a')||
'   :p6_bl_artikel_erf := frgbg_s.holen_uebersetzung(3556,v_sprache_id);'||unistr('\000a')||
'   :P6_BL_IN_AKT_PREISLISTE:= frgbg_s.holen_uebersetzung(3567,v_sprache_id);'||unistr('\000a')||
'   :P6_BL_IN_ALLE_PREISLISTE:= frgbg_s.holen_uebersetzung(3568,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p6_page_titel_preisliste := frgbg_s.holen_uebersetzung(3550,v_sprache_id);'||unistr('\000a')||
'   :p6_page_titel_preise := frgbg_s.holen_uebersetzung(3560,v_sprache_id);'||unistr('\000a')||
'   :p6_page_';

p:=p||'titel_artikel := frgbg_s.holen_uebersetzung(3562,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :P6_NV_PREISLISTEN_DETAILS := frgbg_s.holen_uebersetzung(4419,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4241007127519689 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 6
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00008
prompt  ...PAGE 8: Login-Entsperren
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 8
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Login-Entsperren'
 ,p_step_title => 'Login-Entsperren'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'PERSONENSTAMM'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20111104101126'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3328107824473456 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT distinct'||unistr('\000a')||
'   p."ID" "ID", '||unistr('\000a')||
'   p."USER_ACCOUNT" "USER_ACCOUNT", '||unistr('\000a')||
'   p."EMAIL" "EMAIL", '||unistr('\000a')||
'   p."PASSWORT" "PASSWORT",'||unistr('\000a')||
'   frgbg_s.get_pers_adresse(p.id) adresse, '||unistr('\000a')||
'   p."NAME" "NAME", '||unistr('\000a')||
'   p."VORNAME" "VORNAME", '||unistr('\000a')||
'   p."STRASSE" "STRASSE", '||unistr('\000a')||
'   p."NR" "NR", '||unistr('\000a')||
'   p."PLZ" "PLZ", '||unistr('\000a')||
'   p."ORT" "ORT", '||unistr('\000a')||
'   p."GEBURTSDATUM" "GEBURTSDATUM", '||unistr('\000a')||
'   p."PIS_ADRESSE_ID" "PIS_ADRESSE_ID", '||unistr('\000a')||
'   p."BETREUER" "BETREUER",';

s:=s||' '||unistr('\000a')||
'   DECODE(p.BETREUER,''N'',''Kunde'',''J'',''Betreuer'',''I'',''Identität'',''unbekannt'') betreuer_bez,'||unistr('\000a')||
'   p."LOGIN_FEHLVERSUCHE" "LOGIN_FEHLVERSUCHE", '||unistr('\000a')||
'   p."LAND_ID" "LAND_ID",'||unistr('\000a')||
'   p.id id_disp'||unistr('\000a')||
'FROM PERSONENSTAMM p , v_perslisten_betreuer pb'||unistr('\000a')||
'where p.id = pb.PERSONENSTAMM_ID(+) '||unistr('\000a')||
'  and p.satzkennzeichen is null'||unistr('\000a')||
'  and p.login_fehlversuche != 9999.002  /* Anonyme Endkunden */'||unistr('\000a')||
'  and'||unistr('\000a')||
'    ((p.login_fehlversuche>=:';

s:=s||'p8_login_fehlversuche_betreuer and p.betreuer<>''N'')'||unistr('\000a')||
'     OR'||unistr('\000a')||
'     (p.login_fehlversuche >= :p8_login_fehlversuche_kunde and p.betreuer= ''N'')'||unistr('\000a')||
'    )'||unistr('\000a')||
'  AND pb.betreuerart in (1,2)'||unistr('\000a')||
'  AND '||unistr('\000a')||
'   ('||unistr('\000a')||
'       (frgbg_s.get_pers_option(:APP_USER,31) = 2/* 2te Oberidentzugriff*/'||unistr('\000a')||
'        AND'||unistr('\000a')||
'        pb.personenstamm_id_betreuer in /* Personen unterhalb der 2.obersten Ident vorausgesetzt Stdzugriff */'||unistr('\000a')||
'           (se';

s:=s||'lect persstamm_id_identitaet -- Ident unterhalb der Vorgabe-Ident'||unistr('\000a')||
'            from pers_identitaeten'||unistr('\000a')||
'            where persstamm_id_identitaet not in '||unistr('\000a')||
'             (SELECT persstamm_id_oberidentitaet -- Nur Blattident sind relevant'||unistr('\000a')||
'              from pers_identitaeten'||unistr('\000a')||
'              where persstamm_id_oberidentitaet is not null'||unistr('\000a')||
'              )'||unistr('\000a')||
'            start with persstamm_id_identitaet = '||unistr('\000a')||
'     ';

s:=s||'                                    :p8_ident_persstamm_id_start'||unistr('\000a')||
'            connect by prior  persstamm_id_identitaet='||unistr('\000a')||
'                              persstamm_id_oberidentitaet'||unistr('\000a')||
'            ) '||unistr('\000a')||
'       )'||unistr('\000a')||
'     OR '||unistr('\000a')||
'       (frgbg_s.get_pers_option(:APP_USER,31) = 1  /* IABC-Betreuerzugriff */'||unistr('\000a')||
'        AND pb.personenstamm_id_betreuer = :FAS_LOGIN_PERSONENSTAMM_ID '||unistr('\000a')||
'       )'||unistr('\000a')||
'     OR(frgbg_s.get_pers_optio';

s:=s||'n(:APP_USER,31) = 0 /* normaler Identzugriff */'||unistr('\000a')||
'           AND '||unistr('\000a')||
'           pb.personenstamm_id_betreuer in /*nur f.Betreuer sichbare Personen*/'||unistr('\000a')||
'           (SELECT pz.persstamm_id_betreuerzugriff '||unistr('\000a')||
'            FROM pers_zugriffe pz'||unistr('\000a')||
'            WHERE pz.persstamm_id_betreuer = :FAS_LOGIN_PERSONENSTAMM_ID'||unistr('\000a')||
'           )'||unistr('\000a')||
'       )'||unistr('\000a')||
'     OR /* falls berechtigt alle Personen*/'||unistr('\000a')||
'        frgbg_s.check_fas_rolle';

s:=s||'(:APP_USER,''FAS_VERWALTUNG_MASTER'') > 0'||unistr('\000a')||
'   )'||unistr('\000a')||
'order by user_account';

wwv_flow_api.create_report_region (
  p_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8,
  p_name=> '&P8_PAGE_TITEL_LOGINS.',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P8_HEIGHT_PERSLISTE.px;padding-right:20px; overflow:auto; ">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 11,
  p_plug_query_max_columns=> 60,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3575,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '500',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '1000',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3333904630473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_link=>'f?p=&APP_ID.:8:&SESSION.:ENTSPERREN:&DEBUG.:8:P8_ID,P8_PASSWORT_AENDERN:#ID#,&P8_PASSWORT_AENDERN.',
  p_column_linktext=>'<img src="#IMAGE_PREFIX#e2.gif"  border="0">',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3334111607473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'USER_ACCOUNT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'USER_ACCOUNT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3334312427473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'EMAIL',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'EMAIL',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3334529641473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PASSWORT',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'PASSWORT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4234605648112387 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ADRESSE',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3334713762473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'NAME',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3334930599473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'VORNAME',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'VORNAME',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3335106674473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'STRASSE',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'STRASSE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3335303774473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'NR',
  p_column_display_sequence=> 15,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'NR',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3335527173473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'PLZ',
  p_column_display_sequence=> 16,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'PLZ',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3335729984473532 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'ORT',
  p_column_display_sequence=> 17,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'ORT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3336925817473534 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'GEBURTSDATUM',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_format=> 'DD.MM.YYYY',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'GEBURTSDATUM',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3337701647473534 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'PIS_ADRESSE_ID',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'PIS_ADRESSE_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3337909218473534 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'BETREUER',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'BETREUER',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3395024595407340 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'BETREUER_BEZ',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3338125510473535 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'LOGIN_FEHLVERSUCHE',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'LOGIN_FEHLVERSUCHE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3339306599473535 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'LAND_ID',
  p_column_display_sequence=> 18,
  p_column_heading=> '',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'LAND_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5846622123337632 + wwv_flow_api.g_id_offset,
  p_region_id=> 3328707726473459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'ID_DISP',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1197919453755923 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_name=>'P8_NV_LOGIN_FREIGABE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 3328707726473459+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Login Freigabe',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1198131920759527 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_name=>'P8_PAGE_TITEL_LOGINS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 3328707726473459+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Logins',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3391412251569395 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_name=>'P8_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3328707726473459+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3391825737190020 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_name=>'P8_LOGIN_FEHLVERSUCHE_KUNDE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3328707726473459+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Login Fehlversuche Kunde',
  p_source=>'SELECT NVL(min(parameter),10) '||unistr('\000a')||
'      FROM sysareas_frgbg'||unistr('\000a')||
'      WHERE id = 4;',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3392007167194084 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_name=>'P8_LOGIN_FEHLVERSUCHE_BETREUER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3328707726473459+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Login Fehlversuche Betreuer',
  p_source=>'SELECT NVL(min(parameter),5)'||unistr('\000a')||
'      FROM sysareas_frgbg'||unistr('\000a')||
'      WHERE id = 3;',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3395611959441500 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_name=>'P8_PASSWORT_AENDERN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 3328707726473459+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> 'DECLARE'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--   MEL.P (''aktive Ident %1'','||unistr('\000a')||
'--v_prot_id,''Fehler'',''118/login entsperren'',:fas_identitaet);'||unistr('\000a')||
''||unistr('\000a')||
'   IF frgbg_s.get_pers_option(:APP_USER,30)= 1 THEN -- Entsperrhinweis per Mail'||unistr('\000a')||
'      RETURN 1;'||unistr('\000a')||
'   ELSE                                             '||unistr('\000a')||
'      RETURN 0;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_item_default_type=> 'PLSQL_FUNCTION_BODY',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_RADIOGROUP',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(3573,:fas_sprache_id) a, 0 b'||unistr('\000a')||
'from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(3574,:fas_sprache_id),1'||unistr('\000a')||
'from dual'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => '1',
  p_attribute_02 => 'REDIRECT_SET_VALUE',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3407521917813354 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_name=>'P8_HEIGHT_PERSLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 3328707726473459+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Persliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6403717976863306 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_name=>'P8_IDENT_PERSSTAMM_ID_START',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 3328707726473459+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Ident Persstamm Id Start',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P8_HEIGHT_persliste := :FAS_SCROLLREGION_HEIGHT_MAX * 0.8;'||unistr('\000a')||
'--MEL.P (''Aktive Identität %1 [init_scrollregion_height]'',v_prot_id,''Fehler'',''init_scrollregion_height'',:fas_identitaet_persstamm_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3407603348817482 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_id          personenstamm.id%TYPE;'||unistr('\000a')||
'   v_passwort    personenstamm.passwort%TYPE;'||unistr('\000a')||
'   v_aendern     number;'||unistr('\000a')||
'   v_return      number;'||unistr('\000a')||
'   v_prot_id     NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   v_id := :p8_id;'||unistr('\000a')||
'   :p8_id:= NULL;'||unistr('\000a')||
'   v_aendern := :p8_passwort_aendern;'||unistr('\000a')||
'   :p8_passwort_aendern := null;'||unistr('\000a')||
'   IF v_aendern = 1 THEN'||unistr('\000a')||
'      v_passwort := frgbg_s.gen_passwort;'||unistr('\000a')||
'      savepoint freigabe;'||unistr('\000a')||
'      UPDATE personensta';

p:=p||'mm'||unistr('\000a')||
'      SET login_fehlversuche = 0,'||unistr('\000a')||
'          passwort= v_passwort'||unistr('\000a')||
'      WHERE  id = v_id;'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      IF frgbg_s.get_pers_option(:APP_USER,30) = 1 THEN -- PW per Mail'||unistr('\000a')||
'         v_return := frgbg_s.MAIL_NEUES_PASSWORT(NULL,v_id,  -- Zielperson'||unistr('\000a')||
'                                                 3779,3778,                -- Betreff-/Mail';

p:=p||'texte'||unistr('\000a')||
'                                                 :FAS_IDENTITAET_PERSSTAMM_ID,-- Absender'||unistr('\000a')||
'                                                 0,0,  -- keine neue PW-Vergabe,no_reply-adresse'||unistr('\000a')||
'                                                 1);  -- ggf. Notfallemail schicken'||unistr('\000a')||
'    '||unistr('\000a')||
'         IF v_return < 0 THEN  -- Keine Freigabe'||unistr('\000a')||
'            htp.p(''alert("''||frgbg_s.holen_uebersetzung(3780,:fas_spr';

p:=p||'ache_id,v_id)||'||unistr('\000a')||
'                  ''");'');'||unistr('\000a')||
'            rollback to savepoint freigabe;'||unistr('\000a')||
'         ELSIF v_return = 0 THEN -- Notfallemail'||unistr('\000a')||
'            htp.p(''alert("''||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(3781,:fas_sprache_id,v_id)||'||unistr('\000a')||
'                  ''");'');'||unistr('\000a')||
'         ELSE  -- Email abgesendet'||unistr('\000a')||
'            htp.p(''alert("''||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(3782,:fas_sprache_id,v_';

p:=p||'id)||'||unistr('\000a')||
'                  ''");'');'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         htp.p(''alert("''||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(3783,:fas_sprache_id,v_id,v_passwort)||'||unistr('\000a')||
'                  ''");'');'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      UPDATE personenstamm'||unistr('\000a')||
'      SET login_fehlversuche = 0'||unistr('\000a')||
'      WHERE  id = v_id;'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script t';

p:=p||'ype="text/javascript">'');'||unistr('\000a')||
'      htp.p(''alert("''||frgbg_s.holen_uebersetzung(3784,:fas_sprache_id,v_id)||''");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3390909003559045 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8,
  p_process_sequence=> 5,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'entsperren',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request = ''ENTSPERREN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'  /*'||unistr('\000a')||
'  select PERSSTAMM_ID_IDENTITAET -- Sucht die für eine Vorgabe-Identitaet zweitoberste Identitaet'||unistr('\000a')||
'  INTO :P8_IDENT_PERSSTAMM_ID_START'||unistr('\000a')||
'  from pers_identitaeten'||unistr('\000a')||
'  where level ='||unistr('\000a')||
'         (select max(level)'||unistr('\000a')||
'          from pers_identitaeten'||unistr('\000a')||
'          where PERSSTAMM_ID_OBERIDENTITAET is not null'||unistr('\000a')||
'          start with persstamm_id_identitaet = :FAS_IDENTITAET_PERSSTAMM_ID'||unistr('\000a')||
'          connect by ';

p:=p||'prior persstamm_id_oberidentitaet = persstamm_id_identitaet'||unistr('\000a')||
'          )'||unistr('\000a')||
'  start with persstamm_id_identitaet = :FAS_IDENTITAET_PERSSTAMM_ID'||unistr('\000a')||
'  connect by prior persstamm_id_oberidentitaet = persstamm_id_identitaet        ;'||unistr('\000a')||
'  */'||unistr('\000a')||
'  :P8_IDENT_PERSSTAMM_ID_START := frgbg_s.get_ident_2oberste(:FAS_IDENTITAET_PERSSTAMM_ID,NULL);'||unistr('\000a')||
'  IF :P8_IDENT_PERSSTAMM_ID_START <= 0 THEN'||unistr('\000a')||
'     :P8_IDENT_PERSSTAMM_ID_STAR';

p:=p||'T := NULL;'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 6403826419875217 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_ident_persstamm_id_start',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'   :p25_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_abbrechen := frgbg_s.holen_uebersetzung(510,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
'   :P25_BL_ELEMENT_LOESCHEN := frgbg_s.holen_uebersetzung(35';

p:=p||'91,v_sprache_id);'||unistr('\000a')||
'   :P25_BL_INH_GRENZWERT_ERF:= frgbg_s.holen_uebersetzung(3593,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p25_page_titel_grenzwertliste := frgbg_s.holen_uebersetzung(3585,v_sprache_id);'||unistr('\000a')||
'   :p25_page_titel_grenzwert_erf := frgbg_s.holen_uebersetzung(3594,v_sprache_id);'||unistr('\000a')||
'*/'||unistr('\000a')||
'   :P8_PAGE_TITEL_LOGINS := frgbg_s.holen_uebersetzung(4489,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :P8_NV_LOGIN_FREIGABE := frgbg_s.holen_uebersetzung(44';

p:=p||'23,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1197222869728490 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8,
  p_process_sequence=> 140,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 8
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00010
prompt  ...PAGE 10: Update PERSONENSTAMM
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 10
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Update PERSONENSTAMM'
 ,p_step_title => 'Update PERSONENSTAMM'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'No help is available for this page.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20111107100411'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select                                      /* Identitaetenzugriff pers_opt_id=28 => 0 */'||unistr('\000a')||
'"ID",'||unistr('\000a')||
'"USER_ACCOUNT",'||unistr('\000a')||
'frgbg_s.GET_PERS_ADRESSE(id) adresse,'||unistr('\000a')||
'"NAME",'||unistr('\000a')||
'"VORNAME",'||unistr('\000a')||
'"STRASSE",'||unistr('\000a')||
'"NR",'||unistr('\000a')||
'"PLZ",'||unistr('\000a')||
'"ORT",'||unistr('\000a')||
'"GEBURTSDATUM",'||unistr('\000a')||
'"GESCHLECHT",'||unistr('\000a')||
'"PIS_ADRESSE_ID",'||unistr('\000a')||
'"BETREUER",'||unistr('\000a')||
'"ANREDE_ID",'||unistr('\000a')||
'"LAND_ID",'||unistr('\000a')||
'"PERS_TYP_ID",'||unistr('\000a')||
'substr(fas_synch.get_tab_uebersetzung(''LAND.LAND'',land_id,:fas_sprache_id),1,27) land'||unistr('\000a')||
'from "#OWNER#".';

s:=s||'"PERSONENSTAMM"'||unistr('\000a')||
'where satzkennzeichen is null    /* keine gelöschten */'||unistr('\000a')||
'  and betreuer = ''I''             /* nur Identitaeten */'||unistr('\000a')||
'  and :p10_pers_opt_28_modus = 0 /* Identitaetenzugriff */'||unistr('\000a')||
'  and id in (                    /* Ident unterhalb der Vorgabe-Ident 4 */'||unistr('\000a')||
'            select persstamm_id_identitaet  '||unistr('\000a')||
'            from pers_identitaeten'||unistr('\000a')||
'            where persstamm_id_identitaet not in'||unistr('\000a')||
'         ';

s:=s||'    (SELECT persstamm_id_oberidentitaet -- Nur Blattident sind relevant'||unistr('\000a')||
'              from pers_identitaeten'||unistr('\000a')||
'              where persstamm_id_oberidentitaet is not null'||unistr('\000a')||
'              )'||unistr('\000a')||
'            start with persstamm_id_identitaet =  :P10_VORGABE_PERSSTAMM_ID_IDENT'||unistr('\000a')||
'            connect by prior  persstamm_id_identitaet='||unistr('\000a')||
'                              persstamm_id_oberidentitaet'||unistr('\000a')||
'            )'||unistr('\000a')||
'  and ';

s:=s||'((:p10_land_filter in (53,198) and land_id = :p10_land_filter ) /* Land je nach Auswahl CH/D */'||unistr('\000a')||
'       OR '||unistr('\000a')||
'       (:p10_land_filter = -1 and land_id not in (53,198) )           /* Land weder CH noch D */'||unistr('\000a')||
'       OR '||unistr('\000a')||
'        :p10_land_filter not in (53,198,-1)                           /* bel. */'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and ((:p10_apo_filter =0 and UPPER(name) not like ''%APOTHEKE%'' ) /* Kein Apotheke im Namen */'||unistr('\000a')||
'';

s:=s||'       OR '||unistr('\000a')||
'       (:p10_apo_filter = 1 and UPPER(name) like ''%APOTHEKE%'' )    /* Apotheke im Namen */'||unistr('\000a')||
'       OR '||unistr('\000a')||
'        :p10_apo_filter not in (0,1)                               /* bel. */'||unistr('\000a')||
'      )'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT'||unistr('\000a')||
'p."ID",'||unistr('\000a')||
'p."USER_ACCOUNT",'||unistr('\000a')||
'frgbg_s.GET_PERS_ADRESSE(p.id) adresse,'||unistr('\000a')||
'p."NAME",'||unistr('\000a')||
'p."VORNAME",'||unistr('\000a')||
'p."STRASSE",'||unistr('\000a')||
'p."NR",'||unistr('\000a')||
'p."PLZ",'||unistr('\000a')||
'p."ORT",'||unistr('\000a')||
'p."GEBURTSDATUM",'||unistr('\000a')||
'p."GESCHLECHT",'||unistr('\000a')||
'p."PIS_ADRESSE_ID",'||unistr('\000a')||
'p."BET';

s:=s||'REUER",'||unistr('\000a')||
'p."ANREDE_ID",'||unistr('\000a')||
'p."LAND_ID",'||unistr('\000a')||
'p."PERS_TYP_ID",'||unistr('\000a')||
'substr(fas_synch.get_tab_uebersetzung(''LAND.LAND'',p.land_id,:fas_sprache_id),1,27) land'||unistr('\000a')||
'FROM PERSONENSTAMM p , v_perslisten_betreuer pb'||unistr('\000a')||
'where p.id = pb.PERSONENSTAMM_ID(+)'||unistr('\000a')||
'  and p.satzkennzeichen is null  /* Keine geloeschten */'||unistr('\000a')||
'  AND pb.betreuerart in (1,2)    /* Bevorzugte oder sonstige Betreuer */'||unistr('\000a')||
'  AND p.betreuer = ''J''           /* Betreuer ';

s:=s||'*/'||unistr('\000a')||
'  AND :p10_pers_opt_28_modus = 1 /* Betreuerzugriff */'||unistr('\000a')||
'  AND pb.personenstamm_id_betreuer in /* Personen unterhalb der 2.obersten Ident vorausgesetzt Stdzugriff */'||unistr('\000a')||
'           (select persstamm_id_identitaet -- Ident unterhalb der Vorgabe-Ident'||unistr('\000a')||
'            from pers_identitaeten'||unistr('\000a')||
'            where persstamm_id_identitaet not in'||unistr('\000a')||
'             (SELECT persstamm_id_oberidentitaet -- Nur Blattident si';

s:=s||'nd relevant'||unistr('\000a')||
'              from pers_identitaeten'||unistr('\000a')||
'              where persstamm_id_oberidentitaet is not null'||unistr('\000a')||
'              )'||unistr('\000a')||
'            start with persstamm_id_identitaet ='||unistr('\000a')||
'                                         :P10_VORGABE_PERSSTAMM_ID_IDENT'||unistr('\000a')||
'            connect by prior  persstamm_id_identitaet='||unistr('\000a')||
'                              persstamm_id_oberidentitaet'||unistr('\000a')||
'            )'||unistr('\000a')||
'  and ((:p10_land_filter i';

s:=s||'n (53,198) and land_id = :p10_land_filter ) /* Land je nach Auswahl CH/D */'||unistr('\000a')||
'       OR '||unistr('\000a')||
'       (:p10_land_filter = -1 and land_id not in (53,198) )           /* Land weder CH noch D */'||unistr('\000a')||
'       OR '||unistr('\000a')||
'        :p10_land_filter not in (53,198,-1)                           /* bel. */'||unistr('\000a')||
'      )'||unistr('\000a')||
'';

wwv_flow_api.create_report_region (
  p_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10,
  p_name=> 'Personenstamm',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 25,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P10_HEIGHT_PERSLISTE.px;padding-right:20px; overflow:auto; ">'||unistr('\000a')||
'',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 11,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'No data found.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'apex/builder/dup.gif',
  p_query_asc_image_attr=> 'width="16" height="16" alt="" ',
  p_query_desc_image=> 'apex/builder/ddown.gif',
  p_query_desc_image_attr=> 'width="16" height="16" alt="" ',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3531006720560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'FAS-Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'DISPLAY_AND_SAVE',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source_type=> 'T',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3530232105560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'USER_ACCOUNT',
  p_column_display_sequence=> 8,
  p_column_heading=> 'User Account',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3530327681560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ADRESSE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Adresse',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3530428485560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Name',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3530526886560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'VORNAME',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Vorname',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3530610835560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'STRASSE',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Strasse',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3530725201560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'NR',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Nr',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3530823371560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'PLZ',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Plz',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3530925889560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'ORT',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Ort',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3531108154560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'GEBURTSDATUM',
  p_column_display_sequence=> 14,
  p_column_heading=> 'Geburtsdatum',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3531207216560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'GESCHLECHT',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Geschlecht',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3531301785560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'PIS_ADRESSE_ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'PIS-Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3531418818560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'BETREUER',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Betreuer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3531508569560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'ANREDE_ID',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Anrede Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3531625925560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'LAND_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Land',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_inline_lov=> 'select substr(fas_synch.get_tab_uebersetzung(''LAND.LAND'',id,:fas_sprache_id),1,27)  a, id b'||unistr('\000a')||
'from v_laender'||unistr('\000a')||
'order by sort'||unistr('\000a')||
'',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3530112131560798 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'PERS_TYP_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Typ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'SELECT_LIST_FROM_QUERY',
  p_inline_lov=> 'SELECT bezeichnung a, id b'||unistr('\000a')||
'from pers_typen'||unistr('\000a')||
'where satz_kennzeichen is null'||unistr('\000a')||
'order by sortierung',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENSTAMM',
  p_ref_column_name=> 'PERS_TYP_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3549716821662141 + wwv_flow_api.g_id_offset,
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'LAND',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Land',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3454211912467788 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10,
  p_button_sequence=> 30,
  p_button_plug_id => 3529932272560795+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Speichren',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3455306944467801 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:10:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3470229366606604 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10,
  p_name=>'P10_HEIGHT_PERSLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3529932272560795+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3503725836125989 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10,
  p_name=>'P10_LAND_FILTER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3529932272560795+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Suchkriterien:      ',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_RADIOGROUP',
  p_lov=> 'SELECT ''Alle Länder'', 0 from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Deutschland'', 53 from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Schweiz'',198 from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'Select ''Weder Deutschland noch Schweiz'', -1 from dual',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => '1',
  p_attribute_02 => 'SUBMIT',
  p_attribute_03 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3506229487240553 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10,
  p_name=>'P10_APO_FILTER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3529932272560795+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_RADIOGROUP',
  p_lov=> 'SELECT ''Apotheke im Name'' a, 1 b FROM DUAL'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Apotheke nicht im Namen'', 0 FROM dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Alle'' , 2 from dual',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_display_when=>':P10_PERS_OPT_28_MODUS = 0',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => '1',
  p_attribute_02 => 'SUBMIT',
  p_attribute_03 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3564320084638073 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10,
  p_name=>'P10_VORGABE_PERSSTAMM_ID_IDENT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 3529932272560795+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Vorgabeidentität',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3566715198684009 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10,
  p_name=>'P10_PERS_OPT_28_MODUS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 3529932272560795+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT ''Identitätenzugriff'' a, 0 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Betreuerzugriff'' a, 1 b from dual',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_read_only_when_type=>'ALWAYS',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3575627945208111 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10,
  p_name=>'P10_NAME',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 45,
  p_item_plug_id => 3529932272560795+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'SELECT name FROM personenstamm where id = :p10_vorgabe_persstamm_id_ident',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:PERSONENSTAMM:ID';

wwv_flow_api.create_page_process(
  p_id     => 3526605476543614 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 3529932272560795 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_UPDATE',
  p_process_name=> 'ApplyMRU',
  p_process_sql_clob => p,
  p_process_error_message=> 'Unable to process update.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3454211912467788 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '#MRU_COUNT# Zeile(n) geändert.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P10_HEIGHT_PERSLISTE     := :FAS_SCROLLREGION_HEIGHT_MAX * 0.8;'||unistr('\000a')||
'--MEL.P (''Height %1 [init_scrollregion_height]'',v_prot_id,''TRACE'',''init_scrollregion_height 118/10'',:fas_identitaet_persstamm_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3470309411610298 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   :p10_apo_filter  := NVL(:p10_apo_filter,0);'||unistr('\000a')||
'   :p10_land_filter := NVL(:p10_land_filter,0);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3578405950513926 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_maske',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_return  NUMBER;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Ermittle die 2oberste Identität zur Vorgabe, welche Blattidentitäten geholt werden sollen'||unistr('\000a')||
'   :P10_VORGABE_PERSSTAMM_ID_IDENT := frgbg_s.GET_IDENT_2OBERSTE'||unistr('\000a')||
'                   (:FAS_IDENTITAET_PERSSTAMM_ID,NULL );'||unistr('\000a')||
'   IF :P10_VORGABE_PERSSTAMM_ID_IDENT <= 0 THEN'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      h';

p:=p||'tp.p(''alert("Die Vorgabe-Identität konnte nicht bestimmt werden!");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   -- Setze Maskenmodus gemaess pers_opt_id = 28 für die Identität '||unistr('\000a')||
'   -- (pers_opt_28_Modus: Betreuer =1 bzw. Identzugriff=0)'||unistr('\000a')||
'   :p10_pers_opt_28_modus:= frgbg_s.get_pers_option(NULL,28,:FAS_IDENTITAET_PERSSTAMM_ID,0);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3563827094621187 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'get_vorgabe_persstamm_id_ident',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 10
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00017
prompt  ...PAGE 17: Transfervorgänge
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 17
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Transfervorgänge'
 ,p_step_title => 'Transfervorgänge'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_html_page_header => 
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'N'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20121127105005'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.ID, '||unistr('\000a')||
'"NAME",'||unistr('\000a')||
'"VORNAME",'||unistr('\000a')||
'"STRASSE",'||unistr('\000a')||
'"NR",'||unistr('\000a')||
'"PLZ",'||unistr('\000a')||
'"ORT",'||unistr('\000a')||
'"LAND_ID",l.iso3_id Land,'||unistr('\000a')||
'"GEBURTSDATUM",'||unistr('\000a')||
'"TELEFON",'||unistr('\000a')||
'"MOBILTELEFON",'||unistr('\000a')||
'"EMAIL",'||unistr('\000a')||
'"GEWICHT",'||unistr('\000a')||
'"GROESSE",'||unistr('\000a')||
'"APP_SPRACHE_ID",'||unistr('\000a')||
'"ANREDE_ID",'||unistr('\000a')||
'a.BEMERKUNG,a.ext_person_id,'||unistr('\000a')||
'"STATUS",decode(status,10,''bereit'',20,''zuordnen'',30,''übernommen'',90,''abgelehnt'',''unbekannt'') status_bez,'||unistr('\000a')||
'"MELDUNG",'||unistr('\000a')||
'"PERSSTAMM_ID",'||unistr('\000a')||
'CASE'||unistr('\000a')||
'  /* Link Personenstamm-Zuordnung */'||unistr('\000a')||
'  ';

s:=s||'WHEN STATUS = 20'||unistr('\000a')||
'  THEN ''<a href="'''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL(''f?p=''||:APP_ID||'':20:''||:APP_SESSION||''::&DEBUG.::'''||unistr('\000a')||
'||''P20_TRANSFER_ADRESSE_ID,P20_TRANSFER_VORGANG_ID:'''||unistr('\000a')||
'||to_char(a.ID)||'',''||to_char(a.transfer_vorgang_ID))'||unistr('\000a')||
'|| ''">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#fb_exp.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '||unistr('\000a')||
'    '' '''||unistr('\000a')||
'END LINK_STATUS'||unistr('\000a')||
'from "#OWNER#"."TRANSFER_ADRESSEN" a, laender l'||unistr('\000a')||
'where transfer_vorgang_id = :p17_id'||unistr('\000a')||
'  and ';

s:=s||'l.id (+)= a.land_id'||unistr('\000a')||
'  '||unistr('\000a')||
'';

wwv_flow_api.create_page_plug (
  p_id=> 3435203076644479 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_plug_name=> 'Adressen',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'DYNAMIC_QUERY',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p17_id is not null',
  p_plug_header=> '<div style="height:&P17_HEIGHT_ADRESSLISTE.px;padding-right:20px; overflow:auto; ">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'select a.ID, '||unistr('\000a')||
'"NAME",'||unistr('\000a')||
'"VORNAME",'||unistr('\000a')||
'"STRASSE",'||unistr('\000a')||
'"NR",'||unistr('\000a')||
'"PLZ",'||unistr('\000a')||
'"ORT",'||unistr('\000a')||
'"LAND_ID",l.iso3_id Land,'||unistr('\000a')||
'"GEBURTSDATUM",'||unistr('\000a')||
'"TELEFON",'||unistr('\000a')||
'"MOBILTELEFON",'||unistr('\000a')||
'"EMAIL",'||unistr('\000a')||
'"GEWICHT",'||unistr('\000a')||
'"GROESSE",'||unistr('\000a')||
'"APP_SPRACHE_ID",'||unistr('\000a')||
'"ANREDE_ID",'||unistr('\000a')||
'a.BEMERKUNG,a.ext_person_id,'||unistr('\000a')||
'"STATUS",decode(status,10,''bereit'',20,''zuordnen'',30,''übernommen'',90,''abgelehnt'',''unbekannt'') status_bez,'||unistr('\000a')||
'"MELDUNG",'||unistr('\000a')||
'"PERSSTAMM_ID",'||unistr('\000a')||
'CASE'||unistr('\000a')||
'  /* Link Personenstamm-Zuordnung */'||unistr('\000a')||
'  ';

a1:=a1||'WHEN STATUS = 20'||unistr('\000a')||
'  THEN ''<a href="'''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL(''f?p=''||:APP_ID||'':20:''||:APP_SESSION||''::&DEBUG.::'''||unistr('\000a')||
'||''P20_TRANSFER_ADRESSE_ID,P20_TRANSFER_VORGANG_ID:'''||unistr('\000a')||
'||to_char(a.ID)||'',''||to_char(a.transfer_vorgang_ID))'||unistr('\000a')||
'|| ''">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#fb_exp.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '||unistr('\000a')||
'    '' '''||unistr('\000a')||
'END LINK_STATUS'||unistr('\000a')||
'from "#OWNER#"."TRANSFER_ADRESSEN" a, laender l'||unistr('\000a')||
'where transfer_vorgang_id = :p17_id'||unistr('\000a')||
'  and ';

a1:=a1||'l.id (+)= a.land_id'||unistr('\000a')||
'  '||unistr('\000a')||
'';

wwv_flow_api.create_worksheet(
  p_id=> 3435413855644481+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_region_id=> 3435203076644479+wwv_flow_api.g_id_offset,
  p_name=> 'Report on TRANSFER_ADRESSEN',
  p_folder_id=> null, 
  p_alias=> '',
  p_report_id_item=> '',
  p_max_row_count=> '10000',
  p_max_row_count_message=> 'Diese Abfrage gibt über 10,000 Zeilen zurück. Filtern Sie die Daten, um vollständige Ergebnisse zu gewährleisten.',
  p_no_data_found_message=> 'Keine Daten gefunden.',
  p_max_rows_per_page=>'',
  p_search_button_label=>'',
  p_sort_asc_image=>'',
  p_sort_asc_image_attr=>'',
  p_sort_desc_image=>'',
  p_sort_desc_image_attr=>'',
  p_sql_query => a1,
  p_status=>'AVAILABLE_FOR_OWNER',
  p_allow_report_saving=>'Y',
  p_allow_save_rpt_public=>'N',
  p_allow_report_categories=>'N',
  p_show_nulls_as=>'-',
  p_pagination_type=>'ROWS_X_TO_Y_OF_Z',
  p_pagination_display_pos=>'TOP_RIGHT',
  p_show_finder_drop_down=>'Y',
  p_show_display_row_count=>'N',
  p_show_search_bar=>'Y',
  p_show_search_textbox=>'Y',
  p_show_actions_menu=>'Y',
  p_report_list_mode=>'TABS',
  p_show_detail_link=>'C',
  p_show_select_columns=>'Y',
  p_show_rows_per_page=>'Y',
  p_show_filter=>'Y',
  p_show_sort=>'Y',
  p_show_control_break=>'Y',
  p_show_highlight=>'Y',
  p_show_computation=>'Y',
  p_show_aggregate=>'Y',
  p_show_chart=>'Y',
  p_show_group_by=>'Y',
  p_show_notify=>'N',
  p_show_calendar=>'N',
  p_show_flashback=>'Y',
  p_show_reset=>'Y',
  p_show_download=>'Y',
  p_show_help=>'Y',
  p_download_formats=>'CSV',
  p_detail_link=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:18:P18_ID:#ID#',
  p_detail_link_text=>'<img src="#IMAGE_PREFIX#edit_big.gif"  border="0">',
  p_allow_exclude_null_values=>'N',
  p_allow_hide_extra_columns=>'N',
  p_icon_view_enabled_yn=>'N',
  p_icon_view_use_custom=>'N',
  p_detail_view_enabled_yn=>'N',
  p_owner=>'FRGBG',
  p_internal_uid=> 1);
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3435517982644482+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ID',
  p_display_order          =>1,
  p_column_identifier      =>'A',
  p_column_label           =>'Id',
  p_report_label           =>'Id',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'N',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3435602537644484+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'NAME',
  p_display_order          =>2,
  p_column_identifier      =>'B',
  p_column_label           =>'Name',
  p_report_label           =>'Name',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3435726929644484+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'VORNAME',
  p_display_order          =>3,
  p_column_identifier      =>'C',
  p_column_label           =>'Vorname',
  p_report_label           =>'Vorname',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3435821092644484+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'STRASSE',
  p_display_order          =>4,
  p_column_identifier      =>'D',
  p_column_label           =>'Strasse',
  p_report_label           =>'Strasse',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3435900047644484+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'NR',
  p_display_order          =>5,
  p_column_identifier      =>'E',
  p_column_label           =>'Nr',
  p_report_label           =>'Nr',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436016605644484+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PLZ',
  p_display_order          =>6,
  p_column_identifier      =>'F',
  p_column_label           =>'Plz',
  p_report_label           =>'Plz',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436117016644484+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ORT',
  p_display_order          =>7,
  p_column_identifier      =>'G',
  p_column_label           =>'Ort',
  p_report_label           =>'Ort',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3574907457653714+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> null,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'LAND',
  p_display_order          =>8,
  p_column_identifier      =>'Y',
  p_column_label           =>'Land',
  p_report_label           =>'Land',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436313616644485+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'GEBURTSDATUM',
  p_display_order          =>9,
  p_column_identifier      =>'I',
  p_column_label           =>'Geb.dat.',
  p_report_label           =>'Geb.dat.',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'DATE',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_format_mask            =>'DD.MM.YYYY',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436220756644484+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'LAND_ID',
  p_display_order          =>10,
  p_column_identifier      =>'H',
  p_column_label           =>'Land Id',
  p_report_label           =>'Land Id',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436425180644485+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'TELEFON',
  p_display_order          =>11,
  p_column_identifier      =>'J',
  p_column_label           =>'Telefon',
  p_report_label           =>'Telefon',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436501803644485+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'MOBILTELEFON',
  p_display_order          =>12,
  p_column_identifier      =>'K',
  p_column_label           =>'Mobil',
  p_report_label           =>'Mobil',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436601506644485+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'EMAIL',
  p_display_order          =>13,
  p_column_identifier      =>'L',
  p_column_label           =>'Email',
  p_report_label           =>'Email',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436727499644485+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'GEWICHT',
  p_display_order          =>14,
  p_column_identifier      =>'M',
  p_column_label           =>'Gewicht',
  p_report_label           =>'Gewicht',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436818390644485+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'GROESSE',
  p_display_order          =>15,
  p_column_identifier      =>'N',
  p_column_label           =>'Groesse',
  p_report_label           =>'Groesse',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3436929720644487+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'APP_SPRACHE_ID',
  p_display_order          =>16,
  p_column_identifier      =>'O',
  p_column_label           =>'App Spr.',
  p_report_label           =>'App Spr.',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3437004975644487+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ANREDE_ID',
  p_display_order          =>17,
  p_column_identifier      =>'P',
  p_column_label           =>'Anrede Id',
  p_report_label           =>'Anrede Id',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3437106114644487+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'BEMERKUNG',
  p_display_order          =>18,
  p_column_identifier      =>'Q',
  p_column_label           =>'Bemerkung',
  p_report_label           =>'Bemerkung',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3437206649644487+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'STATUS',
  p_display_order          =>20,
  p_column_identifier      =>'R',
  p_column_label           =>'Status',
  p_report_label           =>'Status',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3574601131629098+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> null,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'STATUS_BEZ',
  p_display_order          =>21,
  p_column_identifier      =>'X',
  p_column_label           =>'Status',
  p_report_label           =>'Status',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3437302504644487+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'MELDUNG',
  p_display_order          =>22,
  p_column_identifier      =>'S',
  p_column_label           =>'Meldung',
  p_report_label           =>'Meldung',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3446200528956785+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> null,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'LINK_STATUS',
  p_display_order          =>23,
  p_column_identifier      =>'U',
  p_column_label           =>'Zuordnen',
  p_report_label           =>'Zuordnen',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'N',
  p_allow_filtering        =>'N',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'N',
  p_allow_aggregations     =>'N',
  p_allow_computations     =>'N',
  p_allow_charting         =>'N',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'WITHOUT_MODIFICATION',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'N',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3753708453886951+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> null,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PERSSTAMM_ID',
  p_display_order          =>24,
  p_column_identifier      =>'Z',
  p_column_label           =>'FAS-ID',
  p_report_label           =>'FAS-ID',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 3890516450102246+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> null,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'EXT_PERSON_ID',
  p_display_order          =>25,
  p_column_identifier      =>'AA',
  p_column_label           =>'Ext. ID',
  p_report_label           =>'Ext. ID',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
declare
    rc1 varchar2(32767) := null;
begin
rc1:=rc1||'ID:NAME:VORNAME:STRASSE:NR:PLZ:ORT:LAND:GEBURTSDATUM:BEMERKUNG:STATUS_BEZ:MELDUNG:PERSSTAMM_ID:LINK_STATUS';

wwv_flow_api.create_worksheet_rpt(
  p_id => 3438502091644918+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_worksheet_id => 3435413855644481+wwv_flow_api.g_id_offset,
  p_session_id  => null,
  p_base_report_id  => null+wwv_flow_api.g_id_offset,
  p_application_user => 'APXWS_DEFAULT',
  p_report_seq              =>10,
  p_report_alias            =>'1240529212669868',
  p_status                  =>'PUBLIC',
  p_category_id             =>null+wwv_flow_api.g_id_offset,
  p_is_default              =>'Y',
  p_display_rows            =>15,
  p_report_columns          =>rc1,
  p_sort_column_1           =>'ID',
  p_sort_direction_1        =>'ASC',
  p_flashback_enabled       =>'N',
  p_calendar_display_column =>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3437717273644489 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3520306870335229 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17,
  p_plug_name=> 'Übernahmevorgänge',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3520619359335245 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17,
  p_button_sequence=> 30,
  p_button_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Änderungen anwenden',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P17_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3520903959335246 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17,
  p_button_sequence=> 10,
  p_button_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3922322839022367 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17,
  p_button_sequence=> 60,
  p_button_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_button_name    => 'IMPORTDATEN_BEREITSTELLEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Importdaten bereitstellen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'p17_id',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3520524297335245 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17,
  p_button_sequence=> 40,
  p_button_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Vorgang erstellen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P17_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3520715140335245 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17,
  p_button_sequence=> 20,
  p_button_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> 'P17_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3857826812596793 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17,
  p_button_sequence=> 5,
  p_button_plug_id => 3435203076644479+wwv_flow_api.g_id_offset,
  p_button_name    => 'REZEPT_START',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Rezeptübernahme starten',
  p_button_position=> 'RIGHT_OF_IR_SEARCH_BAR',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:17:&SESSION.:REZEPT_START:&DEBUG.:::',
  p_button_condition=> 'DECLARE'||unistr('\000a')||
'   v_anz    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT count(*) into v_anz'||unistr('\000a')||
'   FROM transfer_adressen'||unistr('\000a')||
'   WHERE status = 30 '||unistr('\000a')||
'     AND transfer_vorgang_id = :p17_id'||unistr('\000a')||
'     AND persstamm_id is not null;'||unistr('\000a')||
'   IF v_anz = 0 THEN'||unistr('\000a')||
'      RETURN false;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      RETURN true;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_button_condition_type=> 'FUNCTION_BODY',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3440707819760143 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17,
  p_button_sequence=> 10,
  p_button_plug_id => 3435203076644479+wwv_flow_api.g_id_offset,
  p_button_name    => 'STARTEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Adressübernahme starten',
  p_button_position=> 'RIGHT_OF_IR_SEARCH_BAR',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:17:&SESSION.:STARTEN:&DEBUG.:::',
  p_button_condition=> 'DECLARE'||unistr('\000a')||
'   v_anz    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT count(*) into v_anz'||unistr('\000a')||
'   FROM transfer_adressen'||unistr('\000a')||
'   WHERE status = 10 '||unistr('\000a')||
'     AND transfer_vorgang_id = :p17_id;'||unistr('\000a')||
'   IF v_anz = 0 THEN'||unistr('\000a')||
'      RETURN false;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      RETURN true;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_button_condition_type=> 'FUNCTION_BODY',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3437603969644489 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17,
  p_button_sequence=> 30,
  p_button_plug_id => 3435203076644479+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE_ADR',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Neue Adresse erstellen',
  p_button_position=> 'RIGHT_OF_IR_SEARCH_BAR',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:18:P18_TRANSFER_VORGANG_ID:&P17_ID.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3509407584668482 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17,
  p_button_sequence=> 50,
  p_button_plug_id => 3435203076644479+wwv_flow_api.g_id_offset,
  p_button_name    => 'Zuordnen',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Adressen zuordnen',
  p_button_position=> 'RIGHT_OF_IR_SEARCH_BAR',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:20:&SESSION.::&DEBUG.::P20_TRANSFER_VORGANG_ID:&P17_ID.',
  p_button_condition=> 'DECLARE'||unistr('\000a')||
'   v_anz    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT count(*) into v_anz'||unistr('\000a')||
'   FROM transfer_adressen'||unistr('\000a')||
'   WHERE status = 20'||unistr('\000a')||
'     AND transfer_vorgang_id = :p17_id;'||unistr('\000a')||
'   IF v_anz = 0 THEN'||unistr('\000a')||
'      RETURN false;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      RETURN true;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_button_condition_type=> 'FUNCTION_BODY',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3702703645412100 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:20:&SESSION.::&DEBUG.::P20_TRANSFER_VORGANG_ID:&P17_ID.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3509407584668482+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 5,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':p17_id is not null',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 26-OKT-2009 09:39 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>3441019872760143 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1198631490778328 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_NV_TRANS_ADR_UEBESICHT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 3435203076644479+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Trans Adr Liste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3521710891335259 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Vorgang',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3521908747335268 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_BEZEICHNUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bezeichnung',
  p_source=>'BEZEICHNUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3522331893335276 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bemerkung',
  p_source=>'BEMERKUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3522529299335276 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_ART',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '2',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Übernahme',
  p_source=>'ART',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT ''nur in PIS'' a,1 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''nur in FAS'' a,2 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''in PIS/FAS'' a,3 b from dual'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p17_id is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3522911260335276 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_TYP',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Typ',
  p_source=>'TYP',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT ''Adressen'' a,1 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Adressen mit Betreuereinschränkung'' a,2 b from dual'||unistr('\000a')||
''||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p17_id is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3523324117335278 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_PERSSTAMM_ID_BETREUER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Betreuende Identität',
  p_source=>'PERSSTAMM_ID_BETREUER',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT p.name||'',''||p.PIS_ADRESSE_ID a, p.id b'||unistr('\000a')||
'FROM personenstamm p, pers_identitaeten i'||unistr('\000a')||
'WHERE p.id = i.persstamm_id_identitaet'||unistr('\000a')||
'and p.betreuer = ''I'' '||unistr('\000a')||
'and i.PERSSTAMM_ID_IDENTITAET not in '||unistr('\000a')||
'              (select pi2.PERSSTAMM_ID_OBERIDENTITAET'||unistr('\000a')||
'               from pers_identitaeten pi2'||unistr('\000a')||
'               where  pi2.PERSSTAMM_ID_OBERIDENTITAET is not null'||unistr('\000a')||
'              )'||unistr('\000a')||
'and p.pis_adresse_id is not null  /* damit in prov_bers Eintrag machbar ist */'||unistr('\000a')||
'order by 1'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p17_id is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3533727639615659 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_ID_WAHL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Vorgang',
  p_source=>'''f?p=''||:APP_ID||'':17:''||:APP_SESSION||''::::''||''P17_ID:''||:P17_ID',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT bezeichnung a, '||unistr('\000a')||
'       ''f?p=''||:APP_ID||'':17:''||:APP_SESSION||''::::''||'||unistr('\000a')||
'                             ''P17_ID:''||ID b'||unistr('\000a')||
'from transfer_vorgaenge'||unistr('\000a')||
'where satz_kennzeichen is null'||unistr('\000a')||
'UNION '||unistr('\000a')||
'select ''Neuer Vorgang'' , ''f?p=''||:APP_ID||'':17:''||:APP_SESSION||''::::''||'||unistr('\000a')||
'                             ''P17_ID:'''||unistr('\000a')||
'from dual'||unistr('\000a')||
''||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'REDIRECT_URL',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3543919786821554 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_SATZ_KENNZEICHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 3520306870335229+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Satz Kennzeichen',
  p_source=>'SATZ_KENNZEICHEN',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3809417873679512 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17,
  p_name=>'P17_HEIGHT_ADRESSLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 3435203076644479+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Adressliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3522222957335273 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P17_BEZEICHNUNG not null',
  p_validation_sequence=> 20,
  p_validation => 'P17_BEZEICHNUNG',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Bezeichnung Name muss einen Wert haben.',
  p_associated_item=> 3521908747335268 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3522802572335276 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P17_ART not null',
  p_validation_sequence=> 40,
  p_validation => 'P17_ART',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Art Name muss einen Wert haben.',
  p_associated_item=> 3522529299335276 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3523210546335278 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P17_TYP not null',
  p_validation_sequence=> 50,
  p_validation => 'P17_TYP',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Typ Name muss einen Wert haben.',
  p_associated_item=> 3522911260335276 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3523603451335278 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P17_PERSSTAMM_ID_BETREUER not null',
  p_validation_sequence=> 60,
  p_validation => 'P17_PERSSTAMM_ID_BETREUER',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Persstamm Id Betreuer Name muss einen Wert haben.',
  p_associated_item=> 3523324117335278 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:TRANSFER_VORGAENGE:P17_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 3523832424335279 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from TRANSFER_VORGAENGE',
  p_process_sql_clob => p,
  p_process_error_message=> 'Abrufen von Zeile nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':p17_id is not null and :p17_id !=0',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_return_key_into_item1=>'P17_ID',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   :p17_satz_kennzeichen := ''gelöscht von ''||:APP_USER||'' am ''||'||unistr('\000a')||
'               to_char(sysdate,''DD.MM.YYYY hh24:mi:ss'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3543327966814476 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'vorgang_loeschen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3520715140335245 + wwv_flow_api.g_id_offset,
  p_process_when=>':p17_id is not null',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:TRANSFER_VORGAENGE:P17_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 3524010443335284 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of TRANSFER_VORGAENGE',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Zeile der Tabelle TRANSFER_VORGAENGE nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SAVE'',''DELETE'',''CREATE'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> 'Aktion wurde verarbeitet.',
  p_process_is_stateful_y_n=>'N',
  p_return_key_into_item1=>'P17_ID',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   fas_synch.archiv_rez_vitaimp(:p17_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3922700245034839 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'importdaten_bereitstellen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''CREATE'',''IMPORTDATEN_BEREITSTELLEN'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'17';

wwv_flow_api.create_page_process(
  p_id     => 3524204421335284 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_process_sequence=> 100,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3520715140335245 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_art     transfer_vorgaenge.art%type;'||unistr('\000a')||
'   v_typ     transfer_vorgaenge.typ%type;'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'   v_return number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
''||unistr('\000a')||
'   SELECT min(art), min(typ) into v_art, v_typ'||unistr('\000a')||
'   FROM transfer_vorgaenge'||unistr('\000a')||
'   WHERE id = :p17_id;'||unistr('\000a')||
'/*MEL.P (''transfer_adressen_starten:%1, %2,%3'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''App118/17'','||unistr('\000a')||
'           v_art,:p17_id'||unistr('\000a')||
'          ); '||unistr('\000a')||
'*/'||unistr('\000a')||
'   IF v_art not in (2) THEN'||unistr('\000a')||
'  ';

p:=p||'    htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.p(''alert("Unbekannte Transfer-Art zu Vorgang ''||to_char(:p17_id)||'||unistr('\000a')||
'            ''! Transfer-Art noch nicht implementiert.");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'      RETURN;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   IF v_typ not in (1,2) THEN'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.p(''alert';

p:=p||'("Unbekannte Transfer-Typ zu Vorgang ''||to_char(:p17_id)||'||unistr('\000a')||
'            ''! Transfer-Typ noch nicht implementiert.");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'      RETURN;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   IF v_art = 2 AND v_typ in (1,2) THEN -- FAS-Adressübernahme'||unistr('\000a')||
'      v_return := frgbg_s.TRANSFER_FAS_START(:p17_id);'||unistr('\000a')||
'/*    htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.p(''aler';

p:=p||'t("Transfer Adressen zu Vorgang ''||to_char(:p17_id)||'||unistr('\000a')||
'            '' starten!");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'*/'||unistr('\000a')||
'      IF v_return = 0 THEN'||unistr('\000a')||
'         htp.p(''<body>'');'||unistr('\000a')||
'         htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'         htp.p(''alert("Transfer Adressen zu Vorgang ''||to_char(:p17_id)||'||unistr('\000a')||
'               '' wurde erfolgreich ausgeführt!");'');'||unistr('\000a')||
'         htp.p(''</script>'');'||unistr('\000a')||
'    ';

p:=p||'     htp.p(''</body>'');'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         htp.p(''<body>'');'||unistr('\000a')||
'         htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'         htp.p(''alert("Transfer Adressen zu Vorgang ''||to_char(:p17_id)||'||unistr('\000a')||
'               '' wurde mit Fehler ausgeführt!");'');'||unistr('\000a')||
'         htp.p(''</script>'');'||unistr('\000a')||
'         htp.p(''</body>'');'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3764727749354346 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_process_sequence=> 110,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'transfer_adressen_starten',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3440707819760143 + wwv_flow_api.g_id_offset,
  p_process_when=>':p17_id is not null and :request = ''STARTEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_art     transfer_vorgaenge.art%type;'||unistr('\000a')||
'   v_persstamm_id_betreuer   personenstamm.id%TYPE;-- NEI 14.02.2011 Sortimentseinfuehrung  '||unistr('\000a')||
'   v_IDENTITAET_PERSSTAMM_ID personenstamm.id%TYPE;-- NEI 14.02.2011 Sortimentseinfuehrung   '||unistr('\000a')||
'   v_sortiment_id            sortimente.id%TYPE;   -- NEI 14.02.2011 Sortimentseinfuehrung'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'   v_return number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      SELECT art';

p:=p||',PERSSTAMM_ID_BETREUER '||unistr('\000a')||
'      into   '||unistr('\000a')||
'             v_art,v_PERSSTAMM_ID_BETREUER'||unistr('\000a')||
'      FROM transfer_vorgaenge'||unistr('\000a')||
'      WHERE id = :p17_id;'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN others then'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.p(''alert("Unbekannter Transfer-Vorgang ''||to_char(:p17_id)||''!");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'      RETURN;'||unistr('\000a')||
'   END;'||unistr('\000a')||
'   IF v_';

p:=p||'art not in (2) THEN'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.p(''alert("Unbekannte Transfer-Art zu Vorgang ''||to_char(:p17_id)||'||unistr('\000a')||
'            ''! Transfer-Art noch nicht implementiert.");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      IF v_art = 2 THEN -- FAS-Adressübernahme => FAS-Rezepte'||unistr('\000a')||
'         -- NEI 14.02.2011 Sortimentseinfuehrung '||unistr('\000a')||
'  ';

p:=p||'       -- Sortiment-ID der Default-Identitaet des angegebenen Betreuers'||unistr('\000a')||
'         v_SORTIMENT_ID:= rezepte.get_sortiment(v_persstamm_id_betreuer,''BETREUER'');'||unistr('\000a')||
'         IF v_SORTIMENT_ID <= 0 OR '||unistr('\000a')||
'            v_SORTIMENT_ID is NULL'||unistr('\000a')||
'         THEN '||unistr('\000a')||
'            v_SORTIMENT_ID := '''';'||unistr('\000a')||
'            --v_fehlertext := frgbg_s.holen_uebersetzung(3518,:fas_sprache_id);'||unistr('\000a')||
'            htp.p(''<body>'');'||unistr('\000a')||
'            ht';

p:=p||'p.p(''<script type="text/javascript">'');'||unistr('\000a')||
'            htp.p(''alert("Transfer Rezepte zu Vorgang ''||to_char(:p17_id)||'||unistr('\000a')||
'                  '' wurde erfolgreich ausgeführt!");'');'||unistr('\000a')||
'            htp.p(''</script>'');'||unistr('\000a')||
'            htp.p(''</body>'');'||unistr('\000a')||
'         ELSE'||unistr('\000a')||
'            v_return := frgbg_s.TRANSFER_rezepte_FAS(:p17_id,v_sortiment_id);'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      END IF; '||unistr('\000a')||
'      IF v_return = 0 THEN'||unistr('\000a')||
'         htp.p(';

p:=p||'''<body>'');'||unistr('\000a')||
'         htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'         htp.p(''alert("Transfer Rezepte zu Vorgang ''||to_char(:p17_id)||'||unistr('\000a')||
'               '' wurde erfolgreich ausgeführt!");'');'||unistr('\000a')||
'         htp.p(''</script>'');'||unistr('\000a')||
'         htp.p(''</body>'');'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         htp.p(''<body>'');'||unistr('\000a')||
'         htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'         htp.p(''alert("Transfer Rezepte zu Vorgang ''||to_char(:p17_i';

p:=p||'d)||'||unistr('\000a')||
'               '' wurde mit Fehler ausgeführt!");'');'||unistr('\000a')||
'         htp.p(''</script>'');'||unistr('\000a')||
'         htp.p(''</body>'');'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3860530284673454 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_process_sequence=> 120,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'transfer_rezepte_starten',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':p17_id is not null and :request = ''REZEPT_START''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P17_HEIGHT_ADRESSLISTE := :FAS_SCROLLREGION_HEIGHT_MAX * 0.9;'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3809104367675609 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_process_sequence=> 130,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'   :p25_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_abbrechen := frgbg_s.holen_uebersetzung(510,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
'   :P25_BL_ELEMENT_LOESCHEN := frgbg_s.holen_uebersetzung(35';

p:=p||'91,v_sprache_id);'||unistr('\000a')||
'   :P25_BL_INH_GRENZWERT_ERF:= frgbg_s.holen_uebersetzung(3593,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p25_page_titel_grenzwertliste := frgbg_s.holen_uebersetzung(3585,v_sprache_id);'||unistr('\000a')||
'   :p25_page_titel_grenzwert_erf := frgbg_s.holen_uebersetzung(3594,v_sprache_id);'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'   :P17_NV_TRANS_ADR_UEBESICHT := frgbg_s.holen_uebersetzung(4424,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1198723656785559 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17,
  p_process_sequence=> 150,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 17
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00018
prompt  ...PAGE 18: Adressen bearbeiten
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 18
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Adressen bearbeiten'
 ,p_step_title => 'Adressen bearbeiten'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_welcome_text => '<script type="text/javascript">'||unistr('\000a')||
''||unistr('\000a')||
'function f_getVal_popup(pThis)'||unistr('\000a')||
'{ '||unistr('\000a')||
'  var get = new htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=keinProzess'',0);'||unistr('\000a')||
'  get.add($x(pThis).id,$x(pThis).value);'||unistr('\000a')||
'  //alert (''Sie haben '' + $x(pThis).value + '' gewaehlt!'');'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'}'||unistr('\000a')||
''||unistr('\000a')||
'</script>'
 ,p_autocomplete_on_off => 'ON'
 ,p_html_page_header => 
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20140909152017'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3427513015644437 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18,
  p_plug_name=> 'Transfer-Adresse',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045811532431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3437930582644489 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||unistr('\000a')||
'  ID ,'||unistr('\000a')||
'  TRANSFER_ADRESSE_ID,'||unistr('\000a')||
'  REZEPT_ID ,'||unistr('\000a')||
'  HERKUNFT ,'||unistr('\000a')||
'  MN_REZEPT_ID ,'||unistr('\000a')||
'  STATUS ,'||unistr('\000a')||
'  MELDUNG'||unistr('\000a')||
'from transfer_rezepte'||unistr('\000a')||
'where transfer_adresse_id = :p18_id';

wwv_flow_api.create_report_region (
  p_id=> 3900709475053385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18,
  p_name=> 'Transfer-Rezepte',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_when_condition=> 'DECLARE'||unistr('\000a')||
'   V_ANZ number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'SELECT count(*) INTO v_anz'||unistr('\000a')||
'from transfer_rezepte'||unistr('\000a')||
'where transfer_adresse_id = :p18_id;'||unistr('\000a')||
'IF v_anz > 0 THEN RETURN true;'||unistr('\000a')||
'ELSE ReTURN false;'||unistr('\000a')||
'END IF;'||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P18_HEIGHT_REZEPTLISTE.px;padding-right:20px; overflow:auto; ">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3901013564053420 + wwv_flow_api.g_id_offset,
  p_region_id=> 3900709475053385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3901107565053421 + wwv_flow_api.g_id_offset,
  p_region_id=> 3900709475053385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TRANSFER_ADRESSE_ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Transfer Adresse Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3901208812053421 + wwv_flow_api.g_id_offset,
  p_region_id=> 3900709475053385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'REZEPT_ID',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Rezept ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3901302109053421 + wwv_flow_api.g_id_offset,
  p_region_id=> 3900709475053385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'HERKUNFT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Herkunft',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3901408941053421 + wwv_flow_api.g_id_offset,
  p_region_id=> 3900709475053385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'MN_REZEPT_ID',
  p_column_display_sequence=> 5,
  p_column_heading=> 'MN-Rezept-ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3901505435053421 + wwv_flow_api.g_id_offset,
  p_region_id=> 3900709475053385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Status',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3901603263053421 + wwv_flow_api.g_id_offset,
  p_region_id=> 3900709475053385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'MELDUNG',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Meldung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3427811915644439 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18,
  p_button_sequence=> 30,
  p_button_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Speichern',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P18_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3827601022477079 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18,
  p_button_sequence=> 50,
  p_button_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE_ZUORD',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Speichern mit zuordnen',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P18_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3428102816644439 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18,
  p_button_sequence=> 10,
  p_button_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:18::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3427724847644439 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18,
  p_button_sequence=> 40,
  p_button_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Erstellen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P18_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3427921589644439 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18,
  p_button_sequence=> 20,
  p_button_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> 'P18_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3428719766644442 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:17:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1201729599891313 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_NV_TRANS_ADR_BEARBEITEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 230,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'P18 Nv Trans Adr Bearbeiten',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3428929501644445 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 51,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Id',
  p_post_element_text=>'&#160;&#160;&#160;&#160;',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'B',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3429116066644450 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_NAME',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Name',
  p_source=>'NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3429527798644457 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_VORNAME',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Vorname',
  p_source=>'VORNAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3429709302644457 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_STRASSE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Strasse',
  p_source=>'STRASSE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3429902950644459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_NR',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Nr',
  p_source=>'NR',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3430127094644459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_PLZ',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Plz',
  p_source=>'PLZ',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_POPUP_LOV',
  p_lov=> '         SELECT distinct o.ort||'' ''||o.plz a, o.plz b'||unistr('\000a')||
'         FROM   orte o,  laender l, gebiete  g'||unistr('\000a')||
'         WHERE  o.id_gebiet = g.id'||unistr('\000a')||
'           AND  g.id_land = l.id'||unistr('\000a')||
'           AND  (l.ID = :P18_LAND_ID or :P18_LAND_ID is null)'||unistr('\000a')||
'           and  o.satz_kennzeichen is null '||unistr('\000a')||
'           and  l.satz_kennzeichen is null'||unistr('\000a')||
'           and  g.satz_kennzeichen is null'||unistr('\000a')||
'		   and (l.iso3_id not in (''CHE'',''LIE'') or'||unistr('\000a')||
'   	                (l.iso3_id in (''CHE'',''LIE'') and o.onrp is not null)'||unistr('\000a')||
'                       )'||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'Y',
  p_cSize=> 32,
  p_cMaxlength=> 10,
  p_cHeight=> null,
  p_tag_attributes  => 'onchange="f_getVal_popup(this)" ;',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'ENTERABLE',
  p_attribute_02 => 'FIRST_ROWSET_FILTER',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3430512710644460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_ORT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Ort',
  p_source=>'ORT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_POPUP_LOV',
  p_lov=> '         SELECT distinct o.ort ||'' ''||o.PLZ a, o.ort b'||unistr('\000a')||
'         FROM   orte o,  laender l, gebiete  g'||unistr('\000a')||
'         WHERE  o.id_gebiet = g.id'||unistr('\000a')||
'           AND  g.id_land = l.id'||unistr('\000a')||
'           AND  (l.ID = :P18_LAND_ID OR :P18_land_id is null)'||unistr('\000a')||
'           AND  (o.plz like :P18_PLZ||''%'' OR :P18_plz is null)'||unistr('\000a')||
'           and  o.satz_kennzeichen is null '||unistr('\000a')||
'           and  l.satz_kennzeichen is null'||unistr('\000a')||
'           and  g.satz_kennzeichen is null'||unistr('\000a')||
'		   and (l.iso3_id not in (''CHE'',''LIE'') '||unistr('\000a')||
'	        		 or'||unistr('\000a')||
'	           (l.iso3_id in (''CHE'',''LIE'') and o.onrp is not null))'||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'ENTERABLE',
  p_attribute_02 => 'FIRST_ROWSET_FILTER',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3430701804644460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_LAND_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 59,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Land',
  p_source=>'LAND_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select substr(fas_synch.get_tab_uebersetzung(''LAND.LAND'',id,:fas_sprache_id),1,30)  a, id b'||unistr('\000a')||
'from v_laender'||unistr('\000a')||
'order by sort',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="f_getVal_popup(this)" ;',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3431101465644460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_GEBURTSDATUM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 32,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Geburtsdatum',
  p_format_mask=>'DD.MM.YYYY',
  p_source=>'GEBURTSDATUM',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DATE_PICKER_CLASSIC',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3431322428644460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_TELEFON',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Telefon',
  p_source=>'TELEFON',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3431519159644462 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_MOBILTELEFON',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Mobil',
  p_source=>'MOBILTELEFON',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3431707551644462 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_EMAIL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Email',
  p_source=>'EMAIL',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3431905128644462 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_GEWICHT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Gewicht',
  p_source=>'GEWICHT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3432118743644462 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_GROESSE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Grösse',
  p_source=>'GROESSE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3432321339644462 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_APP_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'App Sprache Id',
  p_source=>'APP_SPRACHE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select s.sprache display_value, s.ID return_value'||unistr('\000a')||
'from app_sprachen s, fas_schemas fs  , transfer_vorgaenge tv'||unistr('\000a')||
'where fs.id = frgbg_s.get_fas_schema(tv.persstamm_id_betreuer,''IDENTITAET'')  /* Schema der betreuenden Identitaet */'||unistr('\000a')||
'  AND fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'  and tv.id = :p18_transfer_vorgang_id'||unistr('\000a')||
'  AND s.aktiv=1  -- NEI 09.09.2014'||unistr('\000a')||
'  -- and s.sprache_id in (select sprache_id from uebersetzungen)-- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf '||unistr('\000a')||
'order by 1'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3432722879644462 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_ANREDE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anrede',
  p_source=>'ANREDE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select  '||unistr('\000a')||
' fas_synch.get_tab_uebersetzung(''ANREDEN_FRGBG.CODE'',ID,:fas_sprache_id) a,'||unistr('\000a')||
' id b'||unistr('\000a')||
'from anreden_frgbg',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3433130494644464 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bemerkung',
  p_source=>'BEMERKUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3433316055644464 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_STATUS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 180,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '10',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Status',
  p_source=>'STATUS',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT ''bereit'' a, 10 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''zuordnen'' a, 20 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''übernommen'' a, 30 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''abgelehnt'' a, 90 b from dual',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3433704459644464 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_MELDUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 201,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Meldung',
  p_source=>'MELDUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3433931503644464 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_PERSSTAMM_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 200,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'FAS-ID',
  p_source=>'PERSSTAMM_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3545418279887314 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_TRANSFER_VORGANG_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 210,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Trans Vorgang Id',
  p_source=>'TRANSFER_VORGANG_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3902525414133726 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_HEIGHT_REZEPTLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 220,
  p_item_plug_id => 3900709475053385+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Rezeptliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3910610785498514 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18,
  p_name=>'P18_EXT_PERSON_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 52,
  p_item_plug_id => 3427513015644437+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ext. Person-ID',
  p_pre_element_text=>'&#160;&#160;',
  p_post_element_text=>'&#160;&#160;&#160;&#160;',
  p_source=>'EXT_PERSON_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3429417073644454 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P18_NAME not null',
  p_validation_sequence=> 20,
  p_validation => 'P18_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Name Name muss einen Wert haben.',
  p_associated_item=> 3429116066644450 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3431000859644460 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P18_LAND_ID not null',
  p_validation_sequence=> 80,
  p_validation => 'P18_LAND_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Land Id Name muss einen Wert haben.',
  p_associated_item=> 3430701804644460 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3432624669644462 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P18_APP_SPRACHE_ID not null',
  p_validation_sequence=> 150,
  p_validation => 'P18_APP_SPRACHE_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'App Sprache Id Name muss einen Wert haben.',
  p_associated_item=> 3432321339644462 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3433024114644464 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P18_ANREDE_ID not null',
  p_validation_sequence=> 160,
  p_validation => 'P18_ANREDE_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Anrede Id Name muss einen Wert haben.',
  p_associated_item=> 3432722879644462 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3433629698644464 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P18_STATUS not null',
  p_validation_sequence=> 180,
  p_validation => 'P18_STATUS',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Status Name muss einen Wert haben.',
  p_associated_item=> 3433316055644464 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3875017342773129 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P18_PLZ_ORT',
  p_validation_sequence=> 190,
  p_validation => 'IF NOT(:p18_plz is null and :p18_ort is null) THEN'||unistr('\000a')||
'   IF :p18_plz is null THEN'||unistr('\000a')||
'      RETURN (''PLZ muss eingegeben werden!'');'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END IF;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_associated_item=> 3430127094644459 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:TRANSFER_ADRESSEN:P18_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 3434213574644465 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from TRANSFER_ADRESSEN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Abrufen von Zeile nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   IF :request = ''SAVE_ZUORD'' THEN'||unistr('\000a')||
'      :p18_status :=20;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3827721454483068 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_status_zuordnen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3827601022477079 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   :p18_meldung := ''Adresse wurde von ''||:APP_USER||'' manuell aus der Verarbeitung genommen!'';'||unistr('\000a')||
'   :p18_status := 90;'||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 3553510725064976 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'adresse_loeschen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3427921589644439 + wwv_flow_api.g_id_offset,
  p_process_when=>':p18_id is not null',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:TRANSFER_ADRESSEN:P18_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 3434428675644465 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of TRANSFER_ADRESSEN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Zeile der Tabelle TRANSFER_ADRESSEN nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> 'Aktion wurde verarbeitet.',
  p_process_is_stateful_y_n=>'N',
  p_return_key_into_item1=>'P18_ID',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'18';

wwv_flow_api.create_page_process(
  p_id     => 3434623445644465 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3427921589644439 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P17_HEIGHT_ADRESSLISTE := :FAS_SCROLLREGION_HEIGHT_MAX * 0.6;'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3902600265135882 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_process_sequence=> 140,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'   :p25_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_abbrechen := frgbg_s.holen_uebersetzung(510,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
'   :P25_BL_ELEMENT_LOESCHEN := frgbg_s.holen_uebersetzung(35';

p:=p||'91,v_sprache_id);'||unistr('\000a')||
'   :P25_BL_INH_GRENZWERT_ERF:= frgbg_s.holen_uebersetzung(3593,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p25_page_titel_grenzwertliste := frgbg_s.holen_uebersetzung(3585,v_sprache_id);'||unistr('\000a')||
'   :p25_page_titel_grenzwert_erf := frgbg_s.holen_uebersetzung(3594,v_sprache_id);'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'   :P18_NV_TRANS_ADR_BEARBEITEN := frgbg_s.holen_uebersetzung(4490,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1200230067825186 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18,
  p_process_sequence=> 160,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 18
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00020
prompt  ...PAGE 20: Adresszuordnung
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 20
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Adresszuordnung'
 ,p_step_title => 'Adresszuordnung'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_html_page_header => 
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20140909152035'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3451015084081415 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3460002670081492 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20,
  p_plug_name=> 'Transfer-Adresse',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'ID,FAS_PERSSTAMM_ID,PIS_ADRESSE_ID,'||unistr('\000a')||
'NVL(to_char(FAS_PERSSTAMM_ID),''---'')    ||''|''||to_char(id)'||unistr('\000a')||
'||'' ''||to_char("FAS_GEBURTSDATUM",''(DD.MM.YYYY)'')'||unistr('\000a')||
'||DECODE(FAS_PERSSTAMM_ID,NULL,NULL,''<br/>'')||frgbg_s.get_pers_adresse(FAS_PERSSTAMM_ID)'||unistr('\000a')||
'||''<br/>''||NVL(to_char(PIS_ADRESSE_ID),''---'')'||unistr('\000a')||
'||'' ''||to_char("PIS_GEBURTSDATUM",''(DD.MM.YYYY)'')'||unistr('\000a')||
'||''<br/>''||rezepte.get_adresse(PIS_ADRESSE_ID)'||unistr('\000a')||
' adresse,'||unistr('\000a')||
'frgbg';

s:=s||'_s.get_betreuer_liste(id,1)||''<br/>''||frgbg_s.get_betreuer_liste(id,2) betreuer,'||unistr('\000a')||
'''ohne Betr.'' xob,''mit Betr.'' xb,''mit bev. Betr.'' xbv,''ohne Betr.'' yob,''mit Betr.'' yb,''mit bev. Betr.'' ybv'||unistr('\000a')||
'from PERSONENLISTEN'||unistr('\000a')||
'where normname  '||unistr('\000a')||
'         like ''%''||frgbg_t.NORMSTRING(:p20_name||'' ''||:p20_vorname,2)||''%'' '||unistr('\000a')||
'       '||unistr('\000a')||
'and :p20_id is not null'||unistr('\000a')||
'and (:p20_name is not null or :p20_vorname is not null)';

wwv_flow_api.create_report_region (
  p_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20,
  p_name=> 'Gefundene Adressen',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_display_when_condition=> 'P20_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P20_HEIGHT_ADRESSLISTE.px;padding-right:20px; overflow:auto; ">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 11,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '1000',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3471611152081529 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CHECK$01',
  p_column_display_sequence=> 4,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'CHECKBOX',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_derived_column=> 'Y',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3468321717081525 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source_type=> 'T',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'PERSONENLISTEN',
  p_ref_column_name=> 'ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3665912351384657 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FAS_PERSSTAMM_ID',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Fas Persstamm Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3666011340384659 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PIS_ADRESSE_ID',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Pis Adresse Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3582928685986110 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ADRESSE',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Adresse FAS/PIS',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3670425783558628 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'BETREUER',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Betreuer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3728201218981673 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'XOB',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Änderung',
  p_column_link=>'f?p=&APP_ID.:20:&SESSION.:TRANSFER:&DEBUG.:20:P20_PERSLISTE_ID,P20_ID,P20_TRANSFER_VORGANG_ID,P20_MODE:#ID#,&P20_ID.,&P20_TRANSFER_VORGANG_ID.,1',
  p_column_linktext=>'#XOB#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3728326699981675 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'XB',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Änderung ',
  p_column_link=>'f?p=&APP_ID.:20:&SESSION.:TRANSFER:&DEBUG.:20:P20_PERSLISTE_ID,P20_ID,P20_TRANSFER_VORGANG_ID,P20_MODE:#ID#,&P20_ID.,&P20_TRANSFER_VORGANG_ID.,2',
  p_column_linktext=>'#XB#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3728407072981675 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'XBV',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Änderung',
  p_column_link=>'f?p=&APP_ID.:20:&SESSION.:TRANSFER:&DEBUG.:20:P20_PERSLISTE_ID,P20_ID,P20_TRANSFER_VORGANG_ID,P20_MODE:#ID#,&P20_ID.,&P20_TRANSFER_VORGANG_ID.,3',
  p_column_linktext=>'#XBV#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3728526038981675 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'YOB',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Zuordnung',
  p_column_link=>'f?p=&APP_ID.:20:&SESSION.:TRANSFER:&DEBUG.:20:P20_PERSLISTE_ID,P20_ID,P20_TRANSFER_VORGANG_ID,P20_MODE:#ID#,&P20_ID.,&P20_TRANSFER_VORGANG_ID.,4',
  p_column_linktext=>'#YOB#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3728607720981675 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'YB',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Zuordnung',
  p_column_link=>'f?p=&APP_ID.:20:&SESSION.:TRANSFER:&DEBUG.:20:P20_PERSLISTE_ID,P20_ID,P20_TRANSFER_VORGANG_ID,P20_MODE:#ID#,&P20_ID.,&P20_TRANSFER_VORGANG_ID.,5',
  p_column_linktext=>'#YB#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3728730899981675 + wwv_flow_api.g_id_offset,
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'YBV',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Zuordnung',
  p_column_link=>'f?p=&APP_ID.:20:&SESSION.:TRANSFER:&DEBUG.:20:P20_PERSLISTE_ID,P20_ID,P20_TRANSFER_VORGANG_ID,P20_MODE:#ID#,&P20_ID.,&P20_TRANSFER_VORGANG_ID.,6',
  p_column_linktext=>'#YBV#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3460322310081492 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20,
  p_button_sequence=> 30,
  p_button_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Transfer-Adressänderungen anwenden',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P20_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3470623931081528 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20,
  p_button_sequence=> 40,
  p_button_plug_id => 3468005675081520+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_ADD',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Zeile hinzufügen',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3484526613172425 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20,
  p_button_sequence=> 50,
  p_button_plug_id => 3468005675081520+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEU_EINTRAGEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Transferadresse neu eintragen',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3485109213186376 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20,
  p_button_sequence=> 60,
  p_button_plug_id => 3468005675081520+wwv_flow_api.g_id_offset,
  p_button_name    => 'ABLEHNEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Übernahme ablehnen',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3460606151081493 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20,
  p_button_sequence=> 10,
  p_button_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:20::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3460222157081492 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20,
  p_button_sequence=> 40,
  p_button_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Erstellen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> ':P20_ID is null',
  p_button_condition_type=> 'NEVER',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3460407409081492 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20,
  p_button_sequence=> 20,
  p_button_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> 'P20_ID',
  p_button_condition_type=> 'NEVER',
  p_database_action=>'DELETE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3470531205081528 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20,
  p_button_sequence=> 20,
  p_button_plug_id => 3468005675081520+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_MRD',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Markierte Elemente löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''APPLY_CHANGES_MRD'');',
  p_button_condition=> 'exists (SQL-Abfrage gibt mindestens eine Zeile zurück)'||unistr('\000a')||
'select 1 '||unistr('\000a')||
'from "#OWNER#"."PERSONENLISTEN"'||unistr('\000a')||
'where "NORMNAME" = :P20_NAME',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3747410099998801 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:20:&SESSION.:TRANSFER:&DEBUG.:20:P20_PERSLISTE_ID,P20_ID,P20_TRANSFER_VORGANG_ID,P20_MODE:0,&P20_ID.,&P20_TRANSFER_VORGANG_ID.,90',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3485109213186376+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 5,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 27-OKT-2009 09:30 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>3747620835001900 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:20:&SESSION.:TRANSFER:&DEBUG.:20:P20_PERSLISTE_ID,P20_ID,P20_TRANSFER_VORGANG_ID,P20_MODE:0,&P20_ID.,&P20_TRANSFER_VORGANG_ID.,0',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3484526613172425+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 27-OKT-2009 09:30 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>3472112665081531 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:20:&SESSION.:NOTNEXT:&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1200907473837682 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_NV_ADRESSZUORDNUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 810,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Adresszuordnung',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3461231179081493 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 61,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Id',
  p_post_element_text=>'&#160;&#160;&#160;&#160;',
  p_source=>'ID',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3461410943081498 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_NAME',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Name',
  p_source=>'NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3461806017081500 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_VORNAME',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Vorname',
  p_source=>'VORNAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3462015695081500 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_STRASSE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Strasse',
  p_source=>'STRASSE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3462228828081500 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_NR',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nr',
  p_source=>'NR',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3462414400081500 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_PLZ',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Plz',
  p_source=>'PLZ',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_POPUP_LOV',
  p_lov=> ' SELECT to_char(orte.plz||'' ''||orte.ort) a, to_char(orte.plz) b'||unistr('\000a')||
'         FROM   pis.orte,  pis.laender l, pis.gebiete  g'||unistr('\000a')||
'         WHERE  orte.id_gebiet = g.id'||unistr('\000a')||
'           AND  g.id_land = l.id'||unistr('\000a')||
'           /*AND  l.ID = :P20_LAND_ID */'||unistr('\000a')||
'           and  orte.satz_kennzeichen is null'||unistr('\000a')||
'           and  l.satz_kennzeichen is null'||unistr('\000a')||
'           and  g.satz_kennzeichen is null'||unistr('\000a')||
'           and (l.iso3_id not in (''CHE'',''LIE'') or'||unistr('\000a')||
'                       (l.iso3_id in (''CHE'',''LIE'') and orte.onrp is not null)'||unistr('\000a')||
'                       )'||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 30,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_attribute_01 => 'ENTERABLE',
  p_attribute_02 => 'FIRST_ROWSET_FILTER',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3462810219081500 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_ORT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Ort',
  p_source=>'ORT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_POPUP_LOV',
  p_lov=> '         SELECT o.ort ||'' ''||o.PLZ a, o.ort b'||unistr('\000a')||
'         FROM   orte o,  laender l, gebiete  g'||unistr('\000a')||
'         WHERE  o.id_gebiet = g.id'||unistr('\000a')||
'           AND  g.id_land = l.id'||unistr('\000a')||
'           /*AND  l.ID = :P20_LAND_ID */'||unistr('\000a')||
'           and  o.satz_kennzeichen is null '||unistr('\000a')||
'           and  l.satz_kennzeichen is null'||unistr('\000a')||
'           and  g.satz_kennzeichen is null'||unistr('\000a')||
'		   and (l.iso3_id not in (''CHE'',''LIE'') '||unistr('\000a')||
'	        		 or'||unistr('\000a')||
'	           (l.iso3_id in (''CHE'',''LIE'') and o.onrp is not null))'||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'ENTERABLE',
  p_attribute_02 => 'FIRST_ROWSET_FILTER',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3463001729081501 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_LAND_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Land',
  p_source=>'LAND_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select substr(fas_synch.get_tab_uebersetzung(''LAND.LAND'',id,:fas_sprache_id),1,30)  a, id b'||unistr('\000a')||
'from v_laender'||unistr('\000a')||
'order by sort',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3463415245081501 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_GEBURTSDATUM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Geburtsdatum',
  p_format_mask=>'DD.MM.YYYY',
  p_source=>'GEBURTSDATUM',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DATE_PICKER_CLASSIC',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 10,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3463616536081501 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_TELEFON',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Telefon',
  p_source=>'TELEFON',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3463804092081501 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_MOBILTELEFON',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Mobil',
  p_source=>'MOBILTELEFON',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3464020926081503 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_EMAIL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Email',
  p_source=>'EMAIL',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3464222401081504 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_GEWICHT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Gewicht',
  p_source=>'GEWICHT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 30,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3464407817081504 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_GROESSE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Grösse',
  p_source=>'GROESSE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 30,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3464620920081504 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_APP_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Sprache',
  p_source=>'APP_SPRACHE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select s.sprache display_value, s.ID return_value'||unistr('\000a')||
'from app_sprachen s , fas_schemas fs , transfer_vorgaenge tv'||unistr('\000a')||
'where fs.id = frgbg_s.get_fas_schema(tv.persstamm_id_betreuer,''IDENTITAET'')  /* Schema der betreuenden Identitaet */'||unistr('\000a')||
'  AND fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'  and tv.id = :p20_transfer_vorgang_id'||unistr('\000a')||
'  AND s.aktiv=1  -- NEI 09.09.2014'||unistr('\000a')||
'-- and s.sprache_id in (select sprache_id from uebersetzungen)-- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf '||unistr('\000a')||
'order by 1'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Aus Anrede wird geschlecht genieriert M/W/J';

wwv_flow_api.create_page_item(
  p_id=>3465006835081504 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_ANREDE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anrede',
  p_source=>'ANREDE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select  '||unistr('\000a')||
' fas_synch.get_tab_uebersetzung(''ANREDEN_FRGBG.CODE'',ID,:fas_sprache_id) a,'||unistr('\000a')||
' id b'||unistr('\000a')||
'from anreden_frgbg',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text=> h,
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3465600622081515 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bemerkung',
  p_source=>'BEMERKUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'10=unbearbeitet, 20= uebernommen, 90=Uebernahme mit Fehler abgebrochen';

wwv_flow_api.create_page_item(
  p_id=>3465811201081515 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_STATUS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 62,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Status',
  p_pre_element_text=>'&#160;&#160;',
  p_source=>'STATUS',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT ''bereit'' a, 10 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''zuordnen'' a, 20 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''übernommen'' a, 30 b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''abgelehnt'' a, 90 b from dual',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when_type=>'ALWAYS',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text=> h,
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Meldungen/Fehlermeldungen beim ¿bernahmevorgang';

wwv_flow_api.create_page_item(
  p_id=>3466511574081517 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_MELDUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 200,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Meldung',
  p_source=>'MELDUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when=>':p20_meldung is not null',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3467006423081517 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_PERSSTAMM_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 220,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Fas Id',
  p_source=>'PERSSTAMM_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3572131380537551 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_TRANSFER_VORGANG_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 300,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Transfer Vorgang Id',
  p_source=>'TRANSFER_VORGANG_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3683502167713550 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_BETREUENDE_IDENTITAET',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Identität',
  p_source=>'select name'||unistr('\000a')||
'from personenstamm p, transfer_vorgaenge t'||unistr('\000a')||
'where t.PERSSTAMM_ID_BETREUER = p.id'||unistr('\000a')||
'  and t.id = :p20_transfer_vorgang_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3709125958579425 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_TRANSFER_ADRESSE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 400,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Transfer Adresse Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3734030420378503 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_MODE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 500,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Mode',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3747030700966884 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_PERSLISTE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 3468005675081520+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Persliste Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3771030517523567 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_HEIGHT_ADRESSLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 3468005675081520+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Adressliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3783716461583804 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_FLAG_NEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 800,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Flag Notnext',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3909312469470548 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20,
  p_name=>'P20_EXT_PERSON_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 62,
  p_item_plug_id => 3460002670081492+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ext. Person-ID',
  p_pre_element_text=>'&#160;&#160;',
  p_post_element_text=>'&#160;&#160;&#160;&#160;',
  p_source=>'EXT_PERSON_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3461726331081498 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P20_NAME not null',
  p_validation_sequence=> 2,
  p_validation => 'P20_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Name Name muss einen Wert haben.',
  p_associated_item=> 3461410943081498 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3463302751081501 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P20_LAND_ID not null',
  p_validation_sequence=> 8,
  p_validation => 'P20_LAND_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Land Id Name muss einen Wert haben.',
  p_associated_item=> 3463001729081501 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3464903498081504 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P20_APP_SPRACHE_ID not null',
  p_validation_sequence=> 15,
  p_validation => 'P20_APP_SPRACHE_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'App Sprache Id Name muss einen Wert haben.',
  p_associated_item=> 3464620920081504 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3465504094081515 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P20_ANREDE_ID not null',
  p_validation_sequence=> 16,
  p_validation => 'P20_ANREDE_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Anrede Id Name muss einen Wert haben.',
  p_associated_item=> 3465006835081504 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3466405068081515 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P20_STATUS not null',
  p_validation_sequence=> 18,
  p_validation => 'P20_STATUS',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Status Name muss einen Wert haben.',
  p_associated_item=> 3465811201081515 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3875929510805037 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P20_PLZ_ort',
  p_validation_sequence=> 28,
  p_validation => 'IF NOT(:p20_plz is null and :p20_ort is null) THEN'||unistr('\000a')||
'   IF :p20_plz is null THEN'||unistr('\000a')||
'      RETURN (''PLZ muss eingegeben werden!'');'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END IF;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_associated_item=> 3462414400081500 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:TRANSFER_ADRESSEN:P20_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 3835902630175265 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 60,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'get_transfer_adresse',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':p20_id is not null',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_return_key_into_item1=>'P20_ID',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:TRANSFER_ADRESSEN:P20_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 3467521862081518 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of TRANSFER_ADRESSEN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Zeile der Tabelle TRANSFER_ADRESSEN nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:PERSONENLISTEN:ID';

wwv_flow_api.create_page_process(
  p_id     => 3471720219081529 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_UPDATE',
  p_process_name=> 'ApplyMRU',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Aktualisierung nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3470623931081528 + wwv_flow_api.g_id_offset,
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '#MRU_COUNT#-Zeile(n) wurde(n) aktualisiert, #MRI_COUNT#-Zeile(n) wurde(n) eingefügt.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:PERSONENLISTEN:ID';

wwv_flow_api.create_page_process(
  p_id     => 3471411999081529 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_DELETE',
  p_process_name=> 'ApplyMRD',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Löschvorgang nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3470531205081528 + wwv_flow_api.g_id_offset,
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '#MRD_COUNT#-Zeile(n) gelöscht.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'20';

wwv_flow_api.create_page_process(
  p_id     => 3467711776081518 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3460407409081492 + wwv_flow_api.g_id_offset,
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'1';

wwv_flow_api.create_page_process(
  p_id     => 3471912927081529 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 3468005675081520 + wwv_flow_api.g_id_offset,
  p_process_type=> 'ADD_ROWS_TO_TABULAR_FORM',
  p_process_name=> 'AddRows',
  p_process_sql_clob => p,
  p_process_error_message=> 'Hinzufügen von Zeilen nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3470623931081528 + wwv_flow_api.g_id_offset,
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_return  NUMBER;'||unistr('\000a')||
'   v_fehlertext VARCHAR2(2000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
''||unistr('\000a')||
'   v_return := frgbg_s.transfer_fas(:p20_mode,:p20_id,:p20_persliste_id,v_fehlertext);'||unistr('\000a')||
'/*mel.p(''Page 118 adr ueber %1, %2, %3,%4,%5'' ,v_prot_id,''TEST'',''transfer_fas'',:p20_mode,:p20_id,:p20_id_next,:p20_persliste_id,v_return);   '||unistr('\000a')||
'*/'||unistr('\000a')||
'   IF v_return > 0 THEN  -- zugeordnete Personenstamm_id'||unistr('\000a')||
'      htp.p(''<body>'')';

p:=p||';'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.p(''alert("Transfer ''||to_char(:p20_id)||''/''||to_char(:p20_transfer_vorgang_id)||'||unistr('\000a')||
'            ''/''||to_char(:p20_mode)||''/''||to_char(:p20_persliste_id)||'' ausgeführt!");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'      :p20_flag_next := 1;'||unistr('\000a')||
'   ELSIF v_return is null  THEN  -- Zuordnung manuell abgelehnt '||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'    ';

p:=p||'  htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.p(''alert("Transfer ''||to_char(:p20_id)||''/''||to_char(:p20_transfer_vorgang_id)||'||unistr('\000a')||
'            ''/''||to_char(:p20_mode)||''/''||to_char(:p20_persliste_id)||'' manuell abgelehnt!");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'      :p20_flag_next := 1;   '||unistr('\000a')||
'   ELSIF v_return = 0 THEN'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javasc';

p:=p||'ript">'');'||unistr('\000a')||
'      htp.p(''alert("Transfer ''||to_char(:p20_id)||''/''||to_char(:p20_transfer_vorgang_id)||'||unistr('\000a')||
'            ''/''||to_char(:p20_mode)||''/''||to_char(:p20_persliste_id)||'' mit Fehler ausgeführt! '''||unistr('\000a')||
'            ||v_fehlertext||''");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'      :p20_flag_next := 0;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.';

p:=p||'p(''alert("Transfer ''||to_char(:p20_id)||''/''||to_char(:p20_transfer_vorgang_id)||'||unistr('\000a')||
'            ''/''||to_char(:p20_persliste_id)||''/''||to_char(:p20_mode)||'||unistr('\000a')||
'            '' wurde mit Fehler abgebrochen!");'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'      :p20_flag_next := 1;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'/*mel.p(''Transfer ''||to_char(:p20_id)||''/''||to_char(:p20_transfer_adresse_id)||'||unistr('\000a')||
'            ''/''||to_char(:p20_';

p:=p||'mode)||''/''||to_char(:p20_id),v_prot_id,''INFO'',''adressen transfer'');'||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3733125394339225 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 15,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'adressen_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request= ''TRANSFER'' and :p20_mode is not null and :p20_id is not null and :p20_persliste_id is not null',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF NVL(:p20_flag_next,1) = 1 THEN'||unistr('\000a')||
'      IF :p20_transfer_adresse_id is not null THEN'||unistr('\000a')||
'         :p20_id  := :p20_transfer_adresse_id;'||unistr('\000a')||
'         :p20_transfer_adresse_id := NULL;'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         SELECT min(id) INTO :p20_id '||unistr('\000a')||
'         FROM transfer_adressen'||unistr('\000a')||
'         WHERE transfer_vorgang_id = :p20_transfer_vorgang_id'||unistr('\000a')||
'           AND status = 20'||unistr('\000a')||
'         ;'||unistr('\000a')||
'   ';

p:=p||'   END IF;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :p20_flag_next := 1;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'/*mel.p(''nach select naechste %1, ta %2,%3,%4'' ,v_prot_id,''test'',''get_next_adresse'',:p20_flag_next,:p20_transfer_adresse_id,:p20_id,   :p20_id_next );*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3694008943904706 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'get_next_adresse',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request != ''NOTNEXT'' or :request is null',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id    NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P20_HEIGHT_ADRESSLISTE := :FAS_SCROLLREGION_HEIGHT_MAX * 0.5;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3771103636525289 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 120,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'   :p25_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_abbrechen := frgbg_s.holen_uebersetzung(510,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
'   :P25_BL_ELEMENT_LOESCHEN := frgbg_s.holen_uebersetzung(35';

p:=p||'91,v_sprache_id);'||unistr('\000a')||
'   :P25_BL_INH_GRENZWERT_ERF:= frgbg_s.holen_uebersetzung(3593,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p25_page_titel_grenzwertliste := frgbg_s.holen_uebersetzung(3585,v_sprache_id);'||unistr('\000a')||
'   :p25_page_titel_grenzwert_erf := frgbg_s.holen_uebersetzung(3594,v_sprache_id);'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'   :P20_NV_ADRESSZUORDNUNG := frgbg_s.holen_uebersetzung(4426,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1200403186826911 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20,
  p_process_sequence=> 160,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 20
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00024
prompt  ...PAGE 24: Mnr Regeln Grenzwerte
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 24
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Mnr Regeln Grenzwerte'
 ,p_step_title => 'Mnr Regeln Grenzwerte'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Mnr Regeln Grenzwerte'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20150319123954'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4464804964569282 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT ID,'||unistr('\000a')||
'       FAS_SCHEMA_ID ,'||unistr('\000a')||
'       BEZEICHNUNG ,'||unistr('\000a')||
'       BEMERKUNG'||unistr('\000a')||
'FROM mnr_regeln'||unistr('\000a')||
'WHERE satz_kennzeichen is null'||unistr('\000a')||
'  -- Nur MNR-Regeln des FAS-Schemas der eingeloggten Person'||unistr('\000a')||
'  and (fas_schema_id = :FAS_SCHEMA_ID'||unistr('\000a')||
'       OR'||unistr('\000a')||
'       frgbg_s.check_fas_rolle(:APP_USER,''FAS_VERWALTUNG_MASTER'') > 0'||unistr('\000a')||
'      );';

wwv_flow_api.create_page_plug (
  p_id=> 4465201368569284 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24,
  p_plug_name=> '&P24_PAGE_TITEL_MNR_REGELN.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'DYNAMIC_QUERY',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'SELECT ID,'||unistr('\000a')||
'       FAS_SCHEMA_ID ,'||unistr('\000a')||
'       BEZEICHNUNG ,'||unistr('\000a')||
'       BEMERKUNG'||unistr('\000a')||
'FROM mnr_regeln'||unistr('\000a')||
'WHERE satz_kennzeichen is null'||unistr('\000a')||
'  -- Nur MNR-Regeln des FAS-Schemas der eingeloggten Person'||unistr('\000a')||
'  and (fas_schema_id = :FAS_SCHEMA_ID'||unistr('\000a')||
'       OR'||unistr('\000a')||
'       frgbg_s.check_fas_rolle(:APP_USER,''FAS_VERWALTUNG_MASTER'') > 0'||unistr('\000a')||
'      );';

wwv_flow_api.create_worksheet(
  p_id=> 4465303097569284+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24,
  p_region_id=> 4465201368569284+wwv_flow_api.g_id_offset,
  p_name=> 'Bericht 1',
  p_folder_id=> null, 
  p_alias=> '',
  p_report_id_item=> '',
  p_max_row_count=> '10000',
  p_max_row_count_message=> 'Diese Abfrage gibt über 10,000 Zeilen zurück. Filtern Sie die Daten, um vollständige Ergebnisse zu gewährleisten.',
  p_no_data_found_message=> 'Keine Daten gefunden.',
  p_max_rows_per_page=>'',
  p_search_button_label=>'',
  p_sort_asc_image=>'',
  p_sort_asc_image_attr=>'',
  p_sort_desc_image=>'',
  p_sort_desc_image_attr=>'',
  p_sql_query => a1,
  p_status=>'AVAILABLE_FOR_OWNER',
  p_allow_report_saving=>'Y',
  p_allow_save_rpt_public=>'N',
  p_allow_report_categories=>'N',
  p_show_nulls_as=>'-',
  p_pagination_type=>'ROWS_X_TO_Y',
  p_pagination_display_pos=>'TOP_RIGHT',
  p_show_finder_drop_down=>'Y',
  p_show_display_row_count=>'N',
  p_show_search_bar=>'Y',
  p_show_search_textbox=>'Y',
  p_show_actions_menu=>'Y',
  p_report_list_mode=>'TABS',
  p_show_detail_link=>'C',
  p_show_select_columns=>'Y',
  p_show_rows_per_page=>'Y',
  p_show_filter=>'Y',
  p_show_sort=>'Y',
  p_show_control_break=>'Y',
  p_show_highlight=>'Y',
  p_show_computation=>'Y',
  p_show_aggregate=>'Y',
  p_show_chart=>'Y',
  p_show_group_by=>'Y',
  p_show_notify=>'N',
  p_show_calendar=>'N',
  p_show_flashback=>'Y',
  p_show_reset=>'Y',
  p_show_download=>'Y',
  p_show_help=>'Y',
  p_download_formats=>'CSV',
  p_detail_link=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::P25_ID,P25_INH_GRENZWERT_ERFASSEN:#ID#,0',
  p_detail_link_text=>'<img src="#IMAGE_PREFIX#edit_big.gif" alt="">',
  p_allow_exclude_null_values=>'N',
  p_allow_hide_extra_columns=>'N',
  p_icon_view_enabled_yn=>'N',
  p_icon_view_use_custom=>'N',
  p_icon_view_columns_per_row=>1,
  p_detail_view_enabled_yn=>'N',
  p_owner=>'FRGBG',
  p_internal_uid=> 1);
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4465505614569285+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24,
  p_worksheet_id => 4465303097569284+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ID',
  p_display_order          =>1,
  p_column_identifier      =>'A',
  p_column_label           =>'ID',
  p_report_label           =>'ID',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'WITHOUT_MODIFICATION',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4465629114569285+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24,
  p_worksheet_id => 4465303097569284+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FAS_SCHEMA_ID',
  p_display_order          =>2,
  p_column_identifier      =>'B',
  p_column_label           =>'FAS-Schema-ID',
  p_report_label           =>'FAS-Schema-ID',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'WITHOUT_MODIFICATION',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4465732644569285+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24,
  p_worksheet_id => 4465303097569284+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'BEZEICHNUNG',
  p_display_order          =>3,
  p_column_identifier      =>'C',
  p_column_label           =>'Bezeichnung',
  p_report_label           =>'Bezeichnung',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'WITHOUT_MODIFICATION',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 4465824046569285+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24,
  p_worksheet_id => 4465303097569284+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'BEMERKUNG',
  p_display_order          =>4,
  p_column_identifier      =>'D',
  p_column_label           =>'Bemerkung',
  p_report_label           =>'Bemerkung',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_highlighting     =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_allow_group_by         =>'Y',
  p_allow_hide             =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'WITHOUT_MODIFICATION',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
declare
    rc1 varchar2(32767) := null;
begin
rc1:=rc1||'ID:FAS_SCHEMA_ID:BEZEICHNUNG:BEMERKUNG';

wwv_flow_api.create_worksheet_rpt(
  p_id => 4465902357569581+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24,
  p_worksheet_id => 4465303097569284+wwv_flow_api.g_id_offset,
  p_session_id  => null,
  p_base_report_id  => null+wwv_flow_api.g_id_offset,
  p_application_user => 'APXWS_DEFAULT',
  p_report_seq              =>10,
  p_report_alias            =>'1241122346669868',
  p_status                  =>'PUBLIC',
  p_category_id             =>null+wwv_flow_api.g_id_offset,
  p_is_default              =>'Y',
  p_display_rows            =>15,
  p_report_columns          =>rc1,
  p_flashback_enabled       =>'N',
  p_calendar_display_column =>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12707316768023766 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 24,
  p_button_sequence=> 10,
  p_button_plug_id => 4465201368569284+wwv_flow_api.g_id_offset,
  p_button_name    => 'BUT_EXP_INHGRENZWERTE',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Export Grenzwerte',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:26:P26_ZURUECK_ZUR_SEITE:&APP_PAGE_ID.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1196111217658898 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24,
  p_name=>'P24_NV_MNR_REGELN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 4465201368569284+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Mnr Regeln',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4571229588212543 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24,
  p_name=>'P24_PAGE_TITEL_MNR_REGELN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 4465201368569284+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Mnr Regeln',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12714105281363360 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24,
  p_name=>'P24_EXPORT_URL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 4465201368569284+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 4000,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--mel.p(''Check Zugriff %1'',v_prot_id,''Info'',''P999 logout'',:fas_schema_id);'||unistr('\000a')||
'   IF frgbg_t.CHECK_FAS_APP_ZUGRIFF(:FAS_LOGIN_PERSONENSTAMM_ID,'||unistr('\000a')||
'                                    :FAS_IDENTITAET_PERSSTAMM_ID,:APP_ID,:APP_PAGE_ID) <= 0'||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      owa_util.redirect_url('||unistr('\000a')||
'                  ''f?p=''||:APP_ID||'':2:''||:APP_SESSION||''::::P2_HINWEIS:'''||unistr('\000a')||
'                ||frgb';

p:=p||'g_s.holen_uebersetzung(4912,:fas_sprache_id)); --- Redirect'||unistr('\000a')||
'      apex_application.g_unrecoverable_error := true;   --- stops all further page processing'||unistr('\000a')||
''||unistr('\000a')||
'/*'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      --htp.p(''alert("''||frgbg_s.holen_uebersetzung(4912,:fas_sprache_id)||''");'');'||unistr('\000a')||
'htp.p(''if (TRUE)) {'' );'||unistr('\000a')||
'htp.p(''redirect("f?p=&APP_ID.:2:&APP_SESSION.")'');'||unistr('\000a')||
'htp.p(''}'');'||unistr('\000a')||
' ';

p:=p||'     --htp.p(''redirect("f?p=''||:APP_ID||'':2:''||:APP_SESSION||''");'');'||unistr('\000a')||
'     -- htp.p(''redirect("f?p=&APP_ID.:2:&APP_SESSION.")'');'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'*/'||unistr('\000a')||
'mel.p(''Check Zugriff %1'',v_prot_id,''Info'',''P998 logout'',:fas_schema_id);'||unistr('\000a')||
''||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'/*   '||unistr('\000a')||
'   IF frgbg_s.check_fas_rolle(:APP_USER,''GRENZWERTVERWALTUNG'') <= 0 THEN '||unistr('\000a')||
'      -- Zugriff verweigern durch automatisches Auslog';

p:=p||'gen'||unistr('\000a')||
'      apex_application.g_unrecoverable_error := true; '||unistr('\000a')||
'      wwv_flow_custom_auth_std.logout('||unistr('\000a')||
'            p_this_flow=>:APP_ID,'||unistr('\000a')||
'              p_next_flow_page_sess=> '||unistr('\000a')||
'                     :APP_ID||'':''||:P999_LOGIN_PAGE||'':::::FAS_SCHEMA_ID:''||:FAS_SCHEMA_ID);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3302712952250170 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 24,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'check_zugriff',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p24_page_titel_mnr_regeln := frgbg_s.holen_uebersetzung(3584,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :P24_NV_MNR_REGELN := frgbg_s.holen_uebersetzung(4421,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4570915736208595 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 24,
  p_process_sequence=> 130,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 24
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00025
prompt  ...PAGE 25: Mnr-Regeln Grenzwerte-Details
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 25
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Mnr-Regeln Grenzwerte-Details'
 ,p_step_title => 'Mnr Regeln Grenzwerte-Details'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_html_page_header => 
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'||unistr('\000a')||
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_ch_message=''"OK_TO_GET_NEXT_PREV_PK_VALUE"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20150205114125'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4526832008449320 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4530018128449371 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25,
  p_plug_name=> '&P25_PAGE_TITEL_MNR_REGELN.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p25_inh_grenzwert_erfassen = 0',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'"ID",'||unistr('\000a')||
'"MNR_REGEL_ID",'||unistr('\000a')||
'"INH_GWTYP_ID",'||unistr('\000a')||
'fas_synch.get_tab_uebersetzung(''INH_GRENZWERTTYPEN.BEZEICHNUNG'',INH_GWTYP_ID,:fas_sprache_id) inh_gwtyp_bez,'||unistr('\000a')||
'"INHSTOFF_ID",'||unistr('\000a')||
'fas_synch.get_tab_uebersetzung(''INHSTOFFE.BEZEICHNUNG'',INHSTOFF_ID,:fas_sprache_id) inhstoff_bez,'||unistr('\000a')||
'"WERT",'||unistr('\000a')||
'"BEMERKUNG"'||unistr('\000a')||
'from "PIS"."INH_GRENZWERTE"'||unistr('\000a')||
'where "MNR_REGEL_ID" = :P25_ID'||unistr('\000a')||
'  and satz_kennzeichen is null'||unistr('\000a')||
'order by inhstoff_bez,';

s:=s||' inh_gwtyp_id';

wwv_flow_api.create_report_region (
  p_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25,
  p_name=> '&P25_PAGE_TITEL_GRENZWERTLISTE.',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 2,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_display_when_condition=> ':P25_ID is not null and :P25_INH_GRENZWERT_ERFASSEN = 0',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P25_HEIGHT_GRENZWERTLISTE.px;padding-right:20px; overflow:auto; ">'||unistr('\000a')||
'',
  p_footer=> '</div>'||unistr('\000a')||
'',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3586,:fas_sprache_id));'||unistr('\000a')||
'',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4537824406449398 + wwv_flow_api.g_id_offset,
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CHECK$01',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'CHECKBOX',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_derived_column=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4535905277449393 + wwv_flow_api.g_id_offset,
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source_type=> 'T',
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_GRENZWERTE',
  p_ref_column_name=> 'ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4536013779449393 + wwv_flow_api.g_id_offset,
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'MNR_REGEL_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_default=> 'P25_ID',
  p_column_default_type=> 'ITEM',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_GRENZWERTE',
  p_ref_column_name=> 'MNR_REGEL_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4536102125449393 + wwv_flow_api.g_id_offset,
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'INH_GWTYP_ID',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_GRENZWERTE',
  p_ref_column_name=> 'INH_GWTYP_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4551110529589570 + wwv_flow_api.g_id_offset,
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'INH_GWTYP_BEZ',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4536203684449393 + wwv_flow_api.g_id_offset,
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'INHSTOFF_ID',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_GRENZWERTE',
  p_ref_column_name=> 'INHSTOFF_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4551216895589570 + wwv_flow_api.g_id_offset,
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'INHSTOFF_BEZ',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4536331924449395 + wwv_flow_api.g_id_offset,
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'WERT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '10',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_GRENZWERTE',
  p_ref_column_name=> 'WERT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4536405394449395 + wwv_flow_api.g_id_offset,
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'BEMERKUNG',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '50',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_GRENZWERTE',
  p_ref_column_name=> 'BEMERKUNG',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4542629112502801 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25,
  p_plug_name=> '&P25_PAGE_TITEL_GRENZWERT_ERF.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p25_inh_grenzwert_erfassen = 1',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 4530329355449371 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 30,
  p_button_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P25_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P25_ID is not null and frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4536818340449396 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 40,
  p_button_plug_id => 4535628082449390+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_ADD',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P25_BL_INH_GRENZWERT_ERF.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4533104160449379 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 50,
  p_button_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_PREVIOUS_ID',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&lt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_PREVIOUS_ID'')',
  p_button_condition=> 'P25_ID_PREV',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4533022671449379 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 60,
  p_button_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_NEXT_ID',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&gt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_NEXT_ID'')',
  p_button_condition=> 'P25_ID_NEXT',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4569103176148175 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 70,
  p_button_plug_id => 4535628082449390+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P25_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P25_ID is not null and frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4530621700449371 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 10,
  p_button_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P25_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:25::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4544629423502809 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 10,
  p_button_plug_id => 4542629112502801+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P25_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4530201966449371 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 40,
  p_button_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P25_BL_ERSTELLEN.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P25_ID is null and frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4544411906502809 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 40,
  p_button_plug_id => 4542629112502801+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE_GRENZWERT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P25_BL_ERSTELLEN.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P25_INH_GRENZWERT_ID is null and frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4530419546449371 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 20,
  p_button_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P25_BL_LOESCHEN.',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> ':P25_ID is not null',
  p_button_condition_type=> 'NEVER',
  p_database_action=>'DELETE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4536731415449396 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25,
  p_button_sequence=> 20,
  p_button_plug_id => 4535628082449390+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_MRD',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P25_BL_ELEMENT_LOESCHEN.',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''APPLY_CHANGES_MRD'');',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'DECLARE'||unistr('\000a')||
'   v_anz NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   select count(*) into v_anz'||unistr('\000a')||
'   from "PIS"."INH_GRENZWERTE"'||unistr('\000a')||
'   where "MNR_REGEL_ID" = :P25_ID;'||unistr('\000a')||
'   IF v_anz > 0 AND frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz THEN'||unistr('\000a')||
'      RETURN TRUE;'||unistr('\000a')||
'   ELSE '||unistr('\000a')||
'      RETURN FALSE;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_button_condition_type=> 'FUNCTION_BODY',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>4534801198449384 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::P25_ID:&P25_ID_NEXT.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>4533022671449379+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
wwv_flow_api.create_page_branch(
  p_id=>4535029980449384 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::P25_ID:&P25_ID_PREV.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>4533104160449379+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
wwv_flow_api.create_page_branch(
  p_id=>4576119122744714 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::P25_wert,P25_INH_GW_BEMERKUNG,P25_INH_GWTYP_ID,P25_INH_GRENZWERT_ERFASSEN:,,,0',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 26,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':request in (''CREATE_GRENZWERT'',''CANCEL'')',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 11-MRZ-2010 11:49 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>4532829439449379 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:25::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 30,
  p_branch_condition_type=> 'REQUEST_IN_CONDITION',
  p_branch_condition=> 'DELETE',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>4538331244449398 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:25:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 40,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1196700397674704 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_NV_INHSTOFFE_GRENZWERTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 214,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Inhstoffe Grenzwerte',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4531200427449376 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 12,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4531414623449378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_FAS_SCHEMA_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_post_element_text=>'&#160&#160&#160&#160&#160',
  p_source=>'FAS_SCHEMA_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4531616420449378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_BEZEICHNUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 11,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'BEZEICHNUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4532004791449378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 13,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'BEMERKUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 4000,
  p_cHeight=> 8,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4533801139449382 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_ID_NEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 14,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'P25_ID_NEXT',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4534025090449382 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_ID_PREV',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 24,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'P25_ID_PREV',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4534232406449382 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_ID_COUNT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'class="fielddata"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4542915150502806 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_INH_GRENZWERT_ERFASSEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 104,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Inh Grenzwert Erfassen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4543103332502806 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_INH_GRENZWERT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 4542629112502801+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4543305473502806 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_INH_GWTYP_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 4542629112502801+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Inh Gwtyp Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select fas_synch.get_tab_uebersetzung(''INH_GRENZWERTTYPEN.BEZEICHNUNG'','||unistr('\000a')||
'                   ID,:fas_sprache_id) a, id b'||unistr('\000a')||
'from inh_grenzwerttypen'||unistr('\000a')||
'where satz_kennzeichen is null',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'SUBMIT',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4543512046502807 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_INHSTOFF_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 4,
  p_item_plug_id => 4542629112502801+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Inhstoff Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select fas_synch.get_tab_uebersetzung(''INHSTOFFE.BEZEICHNUNG'',i.ID,:fas_sprache_id) a, i.id b '||unistr('\000a')||
'from inhstoffe  i'||unistr('\000a')||
'where i.inh_typ in (''W'') and i.hck != ''N'' and i.satz_kennzeichen is NULL'||unistr('\000a')||
'  and i.id not in (SELECT inhstoff_id '||unistr('\000a')||
'                   FROM inh_grenzwerte'||unistr('\000a')||
'                   WHERE INH_GWTYP_ID = :p25_INH_GWTYP_ID'||unistr('\000a')||
'                     and MNR_REGEL_ID = :p25_id'||unistr('\000a')||
'                     and satz_kennzeichen is null'||unistr('\000a')||
'                  )'||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Angabe immer in mg des Inhstoffs';

wwv_flow_api.create_page_item(
  p_id=>4543719622502807 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_WERT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 4542629112502801+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Wert in mg',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 30,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4544215583502807 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_INH_GW_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 6,
  p_item_plug_id => 4542629112502801+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bemerkung',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 4000,
  p_cHeight=> 4,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4548430113550351 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_BL_ERSTELLEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 114,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Erstellen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4548612236554653 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_BL_ABBRECHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 124,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Abbrechen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4548820548557051 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_BL_LOESCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 134,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Loeschen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4549028167559254 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_BL_SPEICHERN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 144,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Speichern',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4549418255565831 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_PAGE_TITEL_GRENZWERTLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 154,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Grenzwertliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4549629336569107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_HEIGHT_GRENZWERTLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 164,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Grenzwertliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4549807304572173 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_PAGE_TITEL_MNR_REGELN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 174,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Mnr Regeln',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4558802512674882 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_FAS_SCHEMA_BEZ',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'SELECT min(beschreibung)'||unistr('\000a')||
'from fas_schemas'||unistr('\000a')||
'where id = :p25_fas_schema_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4560730310739689 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_BL_ELEMENT_LOESCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 184,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Element Loeschen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4561706592770643 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_BL_INH_GRENZWERT_ERF',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 194,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Inh Grenzwert Erf',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4568801875128920 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25,
  p_name=>'P25_PAGE_TITEL_GRENZWERT_ERF',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 204,
  p_item_plug_id => 4530018128449371+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Grenzwert Erf',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4531929114449378 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P25_BEZEICHNUNG not null',
  p_validation_sequence=> 3,
  p_validation => 'P25_BEZEICHNUNG',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Bezeichnung Name muss einen Wert haben.',
  p_associated_item=> 4531616420449378 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4566928400051406 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P25_WERT',
  p_validation_sequence=> 13,
  p_validation => 'IF :p25_wert is NULL  THEN'||unistr('\000a')||
'   RETURN (frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'              frgbg_s.holen_uebersetzung(252,:fas_sprache_id))'||unistr('\000a')||
'           );'||unistr('\000a')||
'ELSIF :p25_wert <=0 THEN'||unistr('\000a')||
'   RETURN (frgbg_s.holen_uebersetzung(2973,:fas_sprache_id,'||unistr('\000a')||
'              frgbg_s.holen_uebersetzung(252,:fas_sprache_id),''>0'')'||unistr('\000a')||
'           );'||unistr('\000a')||
'END IF;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_when_button_pressed=> 4544411906502809 + wwv_flow_api.g_id_offset,
  p_associated_item=> 4543719622502807 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|PIS:MNR_REGELN:P25_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 4532330574449378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from MNR_REGELN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Abrufen von Zeile nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_runtime_where_clause=>'satz_kennzeichen is null',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:MNR_REGELN:ID::::P25_ID:P25_ID_NEXT:P25_ID_PREV::::P25_ID_COUNT:';

wwv_flow_api.create_page_process(
  p_id     => 4534603713449384 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'GET_NEXT_OR_PREV_PK',
  p_process_name=> 'Nächsten oder vorherigen Primärschlüsselwert abrufen',
  p_process_sql_clob => p,
  p_process_error_message=> 'Ausführen von Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--mel.p(''Option %1'',v_prot_id,''test'',''118/6 switch_bearbeiten_erfassen'');'||unistr('\000a')||
'   IF :request in (''APPLY_CHANGES_ADD'') THEN'||unistr('\000a')||
'      :p25_inh_grenzwert_erfassen := 1;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :p25_inh_grenzwert_erfassen := 0;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4544709850506687 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'switch_bearbeiten_erfassen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>4536818340449396 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:MNR_REGELN:P25_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 4532532481449379 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of MNR_REGELN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Zeile der Tabelle MNR_REGELN nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:INH_GRENZWERTE:ID';

wwv_flow_api.create_page_process(
  p_id     => 4537923970449398 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_UPDATE',
  p_process_name=> 'ApplyMRU',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Aktualisierung nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'APPLY_CHANGES_ADD,SAVE',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:INH_GRENZWERTE:ID';

wwv_flow_api.create_page_process(
  p_id     => 4537619563449398 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_DELETE',
  p_process_name=> 'ApplyMRD',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Löschvorgang nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''APPLY_CHANGES_MRD'',''SAVE'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'25';

wwv_flow_api.create_page_process(
  p_id     => 4532729278449379 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>4530419546449371 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'1';

wwv_flow_api.create_page_process(
  p_id     => 4538128205449398 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 4535628082449390 + wwv_flow_api.g_id_offset,
  p_process_type=> 'ADD_ROWS_TO_TABULAR_FORM',
  p_process_name=> 'AddRows',
  p_process_sql_clob => p,
  p_process_error_message=> 'Hinzufügen von Zeilen nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>4536818340449396 + wwv_flow_api.g_id_offset,
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'      INSERT INTO inh_grenzwerte('||unistr('\000a')||
'          MNR_REGEL_ID ,'||unistr('\000a')||
'          INH_GWTYP_ID,'||unistr('\000a')||
'          INHSTOFF_ID ,'||unistr('\000a')||
'          WERT ,'||unistr('\000a')||
'          BEMERKUNG'||unistr('\000a')||
'          )'||unistr('\000a')||
'      VALUES                           '||unistr('\000a')||
'         (:p25_ID ,'||unistr('\000a')||
'          :p25_INH_GWTYP_ID,'||unistr('\000a')||
'          :p25_INHSTOFF_ID ,'||unistr('\000a')||
'          :p25_WERT ,'||unistr('\000a')||
'          :p25_inh_gw_BEMERKUNG'||unistr('\000a')||
'         );'||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4544925434511203 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 120,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert_neuer_grenzwert',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>4544411906502809 + wwv_flow_api.g_id_offset,
  p_process_when=>':request in (''CREATE_GRENZWERT'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P25_HEIGHT_grenzwertliste := :FAS_SCROLLREGION_HEIGHT_MAX * 0.80;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4545131667512921 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p25_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_abbrechen := frgbg_s.holen_uebersetzung(510,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'   :p25_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
'   :P25_BL_ELEMENT_LOESCHEN := frgbg_s.holen_uebersetzung(3591,';

p:=p||'v_sprache_id);'||unistr('\000a')||
'   :P25_BL_INH_GRENZWERT_ERF:= frgbg_s.holen_uebersetzung(3593,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p25_page_titel_mnr_regeln := frgbg_s.holen_uebersetzung(3584,v_sprache_id);'||unistr('\000a')||
'   :p25_page_titel_grenzwertliste := frgbg_s.holen_uebersetzung(3585,v_sprache_id);'||unistr('\000a')||
'   :p25_page_titel_grenzwert_erf := frgbg_s.holen_uebersetzung(3594,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :P25_NV_INHSTOFFE_GRENZWERTE := frgbg_s.holen_uebersetz';

p:=p||'ung(4422,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4545305479514868 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 120,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'IF :P25_INH_GRENZWERT_ERFASSEN is null THEN'||unistr('\000a')||
'   :P25_INH_GRENZWERT_ERFASSEN := 0;'||unistr('\000a')||
'END IF;';

wwv_flow_api.create_page_process(
  p_id     => 4576630728785985 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25,
  p_process_sequence=> 130,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_maske',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 25
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00026
prompt  ...PAGE 26: Inhstoff-Grenzwert-Report
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 26
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Inhstoff-Grenzwert-Report'
 ,p_step_title => 'Inhstoff-Grenzwert-Report'
 ,p_step_sub_title => 'Inhstoff-Grenzwert-Report'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_help_text => 
'No help is available for this page.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20150320090051'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT *'||unistr('\000a')||
'from'||unistr('\000a')||
'  (Select'||unistr('\000a')||
'      ig.INHSTOFF_ID,'||unistr('\000a')||
'      inh_gwtyp_id,'||unistr('\000a')||
'      fas_synch.get_tab_uebersetzung(''INHSTOFFE.BEZEICHNUNG'',ig.INHSTOFF_ID,357) inhstoff_bez,'||unistr('\000a')||
'      ig.wert'||unistr('\000a')||
'      from INH_GRENZWERTE ig , inhstoffe i'||unistr('\000a')||
'      where ig.MNR_REGEL_ID = :P26_MNR_REGEL_ID'||unistr('\000a')||
'        and ig.satz_kennzeichen is null'||unistr('\000a')||
'        and ig.INHSTOFF_ID = i.id'||unistr('\000a')||
'        and i.SATZ_KENNZEICHEN is null'||unistr('\000a')||
'  )'||unistr('\000a')||
'  PIVOT'||unistr('\000a')||
'   ( min(';

s:=s||'to_char(wert,''FM999G999G9990D0999'')||'' mg'')   --Verordnung Heilpraktiker nötig'||unistr('\000a')||
'     FOR INH_GWTYP_ID'||unistr('\000a')||
'     in (5 "Warngrenze", 4 "Arztrezept erforderlich",2 "Max.Grenze(autom.Rezeptieren)",1 as "Max.Grenze(man. Rezeptieren)")'||unistr('\000a')||
'    )'||unistr('\000a')||
'';

wwv_flow_api.create_report_region (
  p_id=> 12703203921580260 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26,
  p_name=> 'Inhaltstoff-Grenzwerte',
  p_region_name=>'118_26_1',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_new_grid         => false,
  p_new_grid_row     => true,
  p_new_grid_column  => true,
  p_display_column=> null,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P26_HEIGHT_LISTE.px;padding-right:20px; overflow:auto; ">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 12,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'No data found.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_AND_BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'CSV Export',
  p_query_asc_image=> 'apex/builder/dup.gif',
  p_query_asc_image_attr=> 'width="16" height="16" alt="" ',
  p_query_desc_image=> 'apex/builder/ddown.gif',
  p_query_desc_image_attr=> 'width="16" height="16" alt="" ',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12703531877580270 + wwv_flow_api.g_id_offset,
  p_region_id=> 12703203921580260 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'INHSTOFF_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12703600047580273 + wwv_flow_api.g_id_offset,
  p_region_id=> 12703203921580260 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'INHSTOFF_BEZ',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Inhaltsstoff',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12703707982580273 + wwv_flow_api.g_id_offset,
  p_region_id=> 12703203921580260 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'Warngrenze',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Warngrenze',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12703811834580274 + wwv_flow_api.g_id_offset,
  p_region_id=> 12703203921580260 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'Arztrezept erforderlich',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Arztrezept erforderlich',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12703929604580274 + wwv_flow_api.g_id_offset,
  p_region_id=> 12703203921580260 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'Max.Grenze(autom.Rezeptieren)',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Max.Grenze(autom.Rezeptieren)',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12704007952580274 + wwv_flow_api.g_id_offset,
  p_region_id=> 12703203921580260 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'Max.Grenze(man. Rezeptieren)',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Max.Grenze(man. Rezeptieren)',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 12711618582188602 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => true,
  p_plug_new_grid_column  => true,
  p_plug_display_column=> null,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p26_zurueck_zur_seite is not null',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12712918422302093 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 26,
  p_button_sequence=> 20,
  p_button_plug_id => 12703203921580260+wwv_flow_api.g_id_offset,
  p_button_name    => 'BUT_EXPORT',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'CSV-Export',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '&P26_URL.',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 12706106302948450 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 26,
  p_button_sequence=> 10,
  p_button_plug_id => 12703203921580260+wwv_flow_api.g_id_offset,
  p_button_name    => 'BUT_ABBRECHEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Zurück',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P26_ZURUECK_ZUR_SEITE.:&SESSION.::&DEBUG.:26::',
  p_button_condition=> ':p26_zurueck_zur_seite is not null',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12704215616583692 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26,
  p_name=>'P26_MNR_REGEL_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 12703203921580260+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'MNR-Regel',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT bezeichnung a, id b'||unistr('\000a')||
'from mnr_regeln'||unistr('\000a')||
'where satz_kennzeichen is null',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'SUBMIT',
  p_attribute_03 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12706626953958294 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26,
  p_name=>'P26_ZURUECK_ZUR_SEITE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 12703203921580260+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 4000,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12708026879049441 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26,
  p_name=>'P26_HEIGHT_LISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 12703203921580260+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Artliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12712731426290409 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26,
  p_name=>'P26_URL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 12703203921580260+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P26_HEIGHT_LISTE := :FAS_SCROLLREGION_HEIGHT_MAX *0.8;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 12708111207053919 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 26,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'  v_preference VARCHAR2(255);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'  :p26_mnr_regel_id := 1;'||unistr('\000a')||
'  SELECT ''f?p=''||:APP_ID||'':''||:APP_PAGE_ID||'':''||:SESSION||'':FLOW_EXCEL_OUTPUT_R''||region_id||''_de'''||unistr('\000a')||
'  INTO :p26_url'||unistr('\000a')||
'  FROM apex_application_page_regions'||unistr('\000a')||
'  WHERE static_id = ''118_26_1'' -- zur Ermittlung der region_id. static_id kann bei der Definition des Reports angegeben werden.'||unistr('\000a')||
'    AND application_id = :APP_ID'||unistr('\000a')||
'    AND page_id';

p:=p||' = :APP_PAGE_ID'||unistr('\000a')||
'    ;'||unistr('\000a')||
'  '||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 12711301482174118 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 26,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mnr_regel',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_only_for_changed_rows=> 'Y',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 26
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00030
prompt  ...PAGE 30: Fragebogen
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 30
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Fragebogen'
 ,p_step_title => 'Fragebogen'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Fragenbogen'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20150119123424'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT f.FKATEGORIE_ID ,'||unistr('\000a')||
'       f.id,'||unistr('\000a')||
'       f.TEXT_ID text_id_hilfe, frgbg_s.holen_uebersetzung(f.text_id,:fas_sprache_id) hilfetext,       --u1.text hilfetext,'||unistr('\000a')||
'       f.TEXT_ID_FRAGETEXT, frgbg_s.holen_uebersetzung(f.TEXT_ID_FRAGETEXT,:fas_sprache_id) fragetext, --u2.text fragetext,'||unistr('\000a')||
'       f.KURZBEZEICHNUNG kurzbezeichnung,'||unistr('\000a')||
'       f.TEXT_ID_SUCHTEXT , frgbg_s.holen_uebersetzung(f.TEXT_ID_suchtex';

s:=s||'t,:fas_sprache_id) suchtext,  -- u3.text suchtext,'||unistr('\000a')||
'       f.sort,f.datengruppe,'||unistr('\000a')||
'       case when f.eingabepflichtig = 1 '||unistr('\000a')||
'       THEN'||unistr('\000a')||
'            frgbg_s.holen_uebersetzung(76,:fas_sprache_id) '||unistr('\000a')||
'       ELSE frgbg_s.holen_uebersetzung(77,:fas_sprache_id)'||unistr('\000a')||
'       END eingabepflichtig,'||unistr('\000a')||
'       f.anzeigetyp_id,'||unistr('\000a')||
'       case when f.anzeigetyp_id = 5 '||unistr('\000a')||
'       THEN'||unistr('\000a')||
'            frgbg_s.holen_uebersetzung(3668,:';

s:=s||'fas_sprache_id) '||unistr('\000a')||
'       ELSE frgbg_s.holen_uebersetzung(3669,:fas_sprache_id) '||unistr('\000a')||
'       END anzeigetyp ,'||unistr('\000a')||
'       f.fragelevel ,'||unistr('\000a')||
'       f.id id_disp,'||unistr('\000a')||
'       f.berechnungstyp berechnungstyp,'||unistr('\000a')||
'       f.inhstoff_id'||unistr('\000a')||
'from fragen f  ,    --, uebersetzungen u1, uebersetzungen u2, uebersetzungen u3,-- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'     fkategorien k'||unistr('\000a')||
'where f.anzeigetyp_id in (5,3,4';

s:=s||') /* NUM1-Antwort-Fragen, Radio als LOV-Ausw.*/'||unistr('\000a')||
'  --and f.FRAGELEVEL = 0         /* keine Metafragen */'||unistr('\000a')||
'  and f.fkategorie_id = k.id'||unistr('\000a')||
'  and f.fkategorie_id = :p30_fkategorie_id'||unistr('\000a')||
'  and k.fragebogen_id = :p30_fragebogen_id'||unistr('\000a')||
'  and f.satz_kennzeichen is null'||unistr('\000a')||
'  and k.satz_kennzeichen is null'||unistr('\000a')||
'  and (:P30_SEARCH is null or lower(f.kurzbezeichnung) like ''%'' || replace(lower(:P30_SEARCH),'' '', ''%'') || ''%'')'||unistr('\000a')||
'  /';

s:=s||'*    f.text_id  = u1.text_id (+)'||unistr('\000a')||
'  --and u1.sprache_id (+)= :fas_sprache_id'||unistr('\000a')||
'  --and f.TEXT_ID_FRAGETEXT = u2.text_id (+)'||unistr('\000a')||
'  --and u2.sprache_id (+)= :fas_sprache_id'||unistr('\000a')||
'  --and f.TEXT_ID_suchtext = u3.text_id (+)'||unistr('\000a')||
'  --and u3.sprache_id (+)= :fas_sprache_id  '||unistr('\000a')||
'  */';

wwv_flow_api.create_report_region (
  p_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30,
  p_name=> '&P30_PAGE_TITEL_FRAGEBOGEN.',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P30_HEIGHT_FRAGENLISTE.px;padding-right:20px;overflow:auto;">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3667,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '1000',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4606123996767339 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_ID',
  p_column_display_sequence=> 17,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4606221699767339 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_link=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:RP,32:P32_ID:#ID#',
  p_column_linktext=>'<img src="#IMAGE_PREFIX#edit_big.gif" alt="Edit">',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4607721564785867 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'TEXT_ID_HILFE',
  p_column_display_sequence=> 15,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4607804169785867 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'HILFETEXT',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4606506392767339 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'TEXT_ID_FRAGETEXT',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4607903796785867 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGETEXT',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '40',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5426727720098464 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'KURZBEZEICHNUNG',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5027330933222515 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'TEXT_ID_SUCHTEXT',
  p_column_display_sequence=> 16,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5027411637222515 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'SUCHTEXT',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4609022088823879 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'SORT',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5191626173629350 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'DATENGRUPPE',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4606724012767339 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'EINGABEPFLICHTIG',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_inline_lov=> 'SELECT frgbg_s.holen_uebersetzung(76,:fas_sprache_id) a,1 b'||unistr('\000a')||
'from dual'||unistr('\000a')||
'union'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(77,:fas_sprache_id) a,0 b'||unistr('\000a')||
'from dual',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5027103313195654 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'ANZEIGETYP_ID',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5029529988279042 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'ANZEIGETYP',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5503905948750587 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGELEVEL',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6296230838235806 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'ID_DISP',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5124525866310364 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'BERECHNUNGSTYP',
  p_column_display_sequence=> 18,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5463422210385399 + wwv_flow_api.g_id_offset,
  p_region_id=> 4605827708767335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'INHSTOFF_ID',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5410608608614201 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 5034100243573246 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 30,
  p_button_sequence=> 10,
  p_button_plug_id => 4605827708767335+wwv_flow_api.g_id_offset,
  p_button_name    => 'FRAGE_ERSTELLEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P30_BL_FRAGE_ERSTELLEN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> ':P30_FRAGEBOGEN_ID is not null '||unistr('\000a')||
'and :p30_fkategorie_id is not null',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>4613430623592837 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:30:P30_fragebogen_ID,p30_fkategorie_id:&P30_FRAGEBOGEN_ID.,',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 5,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':request = ''P30_FRAGEBOGEN_ID''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 22-MRZ-2010 13:27 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>5034408980573262 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:32:&SESSION.::&DEBUG.::P32_FKATEGORIE_ID:&P30_FKATEGORIE_ID.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>5034100243573246+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>4610409069905273 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 90,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 22-MRZ-2010 11:32 by FRGBG');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1202719666214509 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_name=>'P30_NV_FB_VERWALTUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 4605827708767335+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Fb Verwaltung',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4609816987879182 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_name=>'P30_FRAGEBOGEN_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 4605827708767335+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT frgbg_s.HOLEN_UEBERSETZUNG(text_id,:fas_sprache_id)||'||unistr('\000a')||
'       '' ''||frgbg_s.HOLEN_UEBERSETZUNG(519,:fas_sprache_id)||'||unistr('\000a')||
'       '' ''||version||DECODE(aktiv,''J'',''*'',NULL) a,'||unistr('\000a')||
'       id b'||unistr('\000a')||
'FROM fragebogen'||unistr('\000a')||
'order by kurzname',
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'SUBMIT',
  p_attribute_03 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4610012055896756 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_name=>'P30_FKATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 4605827708767335+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT /*frgbg_s.HOLEN_UEBERSETZUNG(fk.text_id,:fas_sprache_id)*/ fk.kurzbezeichnung a, fk.id b'||unistr('\000a')||
'FROM fkategorien fk'||unistr('\000a')||
'WHERE fragebogen_id = :p30_fragebogen_id'||unistr('\000a')||
'  and fk.art = 2   /* Labortab */'||unistr('\000a')||
'/*  and (select count(*) from fantworten fa , fragen f '||unistr('\000a')||
'                       where f.fkategorie_id = fk.id'||unistr('\000a')||
'                         and f.id = fa.frage_id'||unistr('\000a')||
'                         and f.anzeigetyp_id in (5,3,4)'||unistr('\000a')||
'                         and f.FRAGELEVEL = 0'||unistr('\000a')||
'       ) > 0'||unistr('\000a')||
'*/ '||unistr('\000a')||
'order by sort',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'SUBMIT',
  p_attribute_03 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5169020494629682 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_name=>'P30_HEIGHT_FRAGENLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 4605827708767335+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Fragenliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5443004342883957 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_name=>'P30_PAGE_TITEL_FRAGEBOGEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 4605827708767335+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Fragebogen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5443216809887570 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_name=>'P30_BL_FRAGE_ERSTELLEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 4605827708767335+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Frage Erstellen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7385918967221963 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30,
  p_name=>'P30_SEARCH',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 4605827708767335+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Suche',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_field_template=> 3049813415431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'     CURSOR c_fkat IS '||unistr('\000a')||
'        SELECT kurzbezeichnung, id'||unistr('\000a')||
'        FROM fkategorien fk'||unistr('\000a')||
'        WHERE fragebogen_id = :p30_fragebogen_id'||unistr('\000a')||
'          and fk.art = 2 -- Labortab'||unistr('\000a')||
'/*'||unistr('\000a')||
'          and (select count(*) '||unistr('\000a')||
'               from fantworten fa , fragen f '||unistr('\000a')||
'               where f.fkategorie_id = fk.id'||unistr('\000a')||
'                 and f.id = fa.frage_id'||unistr('\000a')||
'                 and f.anzeigetyp_id in (5,3,4)'||unistr('\000a')||
'     ';

p:=p||'            and f.FRAGELEVEL = 0'||unistr('\000a')||
'               ) > 0'||unistr('\000a')||
'*/'||unistr('\000a')||
'      order by  sort;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :p30_fragebogen_id is NOT NULL and :p30_fkategorie_id is null THEN'||unistr('\000a')||
'      FOR r_fkat in c_fkat LOOP'||unistr('\000a')||
'         :p30_fkategorie_id:= r_fkat.id;'||unistr('\000a')||
'         exit;'||unistr('\000a')||
'      END LOOP;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5169815871694606 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 30,
  p_process_sequence=> 5,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_fb_fkategorie_id',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
''||unistr('\000a')||
'   :p30_bl_frage_erstellen := frgbg_s.holen_uebersetzung(3670,v_sprache_id);'||unistr('\000a')||
'--   :p30_bl_abbrechen := frgbg_s.holen_uebersetzung(510,v_sprache_id);'||unistr('\000a')||
'--   :p30_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'--   :p30_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p30_page_titel_fragebogen := frgbg_s.holen_u';

p:=p||'ebersetzung(3073,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :P30_NV_FB_VERWALTUNG := frgbg_s.holen_uebersetzung(4427,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5439313318659421 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 30,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P30_HEIGHT_FRAGENLISTE  := :FAS_SCROLLREGION_HEIGHT_MAX * 0.75;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5168602833624612 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 30,
  p_process_sequence=> 50,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 30
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00031
prompt  ...PAGE 31: Texte/Uebersetzungen verwalten
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 31
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Texte/Uebersetzungen verwalten'
 ,p_step_title => 'Form basierend auf UEBERSETZUNGEN'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_html_page_header => 
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20131203125114'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5171604874746100 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31,
  p_plug_name=> '&P31_PAGE_TITEL_TEXTE.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045811532431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 5171929799746103 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31,
  p_button_sequence=> 30,
  p_button_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P31_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> ':P31_ID is not null and :p31_text_id is not null',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5172210777746103 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31,
  p_button_sequence=> 10,
  p_button_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P31_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P31_ZURUECK_ZUR_SEITE.:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5171829092746103 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31,
  p_button_sequence=> 40,
  p_button_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Erstellen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P31_ID',
  p_button_condition_type=> 'NEVER',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5172004176746103 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31,
  p_button_sequence=> 20,
  p_button_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> 'P31_ID',
  p_button_condition_type=> 'NEVER',
  p_database_action=>'DELETE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>5172823163746107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P31_ZURUECK_ZUR_SEITE.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5173030526746109 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Id',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5173209098746117 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TEXT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'TEXT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5173612297746120 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Sprache Id',
  p_source=>'SPRACHE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5174016312746120 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'TEXT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 150,
  p_cMaxlength=> 2000,
  p_cHeight=> 20,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5174400198746121 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TSTATUS_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'TSTATUS_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5174813822746121 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_ERFDAT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_pre_element_text=>'&#160&#160&#160&#160',
  p_format_mask=>'DD.MM.YYYY HH24:MI:SS',
  p_source=>'ERFDAT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5175229454746121 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_ERFUSER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'ERFUSER',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5175624888746123 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_MUTDAT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_pre_element_text=>'&#160&#160&#160&#160',
  p_format_mask=>'DD.MM.YYYY HH24:MI:SS',
  p_source=>'MUTDAT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5176021519746123 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_MUTUSER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'MUTUSER',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5412000801848498 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_ZURUECK_ZUR_SEITE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Zurueck Zur Seite',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5480123210483031 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_BL_SPEICHERN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Speichern',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5480307065487823 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_BL_ABBRECHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Abbrechen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5480609666526443 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_PAGE_TITEL_TEXTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 5171604874746100+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Texte',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5173527647746120 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P31_TEXT_ID not null',
  p_validation_sequence=> 2,
  p_validation => 'P31_TEXT_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Text Id Name muss einen Wert haben.',
  p_associated_item=> 5173209098746117 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5174309949746120 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P31_TEXT not null',
  p_validation_sequence=> 4,
  p_validation => 'P31_TEXT',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Text Name muss einen Wert haben.',
  p_associated_item=> 5174016312746120 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:UEBERSETZUNGEN:P31_TEXT_ID:TEXT_ID:P31_SPRACHE_ID:SPRACHE_ID';

wwv_flow_api.create_page_process(
  p_id     => 5176524844746123 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from UEBERSETZUNGEN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Abrufen von Zeile nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:UEBERSETZUNGEN:P31_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 5176700028746125 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of UEBERSETZUNGEN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Zeile der Tabelle UEBERSETZUNGEN nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> 'Aktion wurde verarbeitet.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'31';

wwv_flow_api.create_page_process(
  p_id     => 5176932275746125 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>5172004176746103 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--:p31_text_id := 46;'||unistr('\000a')||
':p31_sprache_id := :FAS_BASIS_SPRACHE_ID;'||unistr('\000a')||
'--mel.p(''Basissprache %1'',v_prot_id,''TEST'',''118/31:init_id'',:FAS_BASIS_SPRACHE_ID);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5177023583753656 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 5,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_id',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p31_bl_abbrechen := frgbg_s.holen_uebersetzung(510,v_sprache_id);'||unistr('\000a')||
'   :p31_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p31_page_titel_texte:= frgbg_s.holen_uebersetzung(3697,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5439600636665293 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 31
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00032
prompt  ...PAGE 32: Fragen-Bearbeitung
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 32
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Fragen-Bearbeitung'
 ,p_step_title => 'Fragen-Bearbeitung'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Fragen-Bearbeitung'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_html_page_header => 
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'||unistr('\000a')||
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_ch_message=''"OK_TO_GET_NEXT_PREV_PK_VALUE"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_javascript_code => 
'var htmldb_ch_message=''"OK_TO_GET_NEXT_PREV_PK_VALUE"'';'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20131205095531'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4683424693939862 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_plug_name=> '&P32_PAGE_TITEL_FRAGE.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_1',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<div style="max-width: 800px; ">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4685221554939867 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||unistr('\000a')||
'    fan.wert1 wert1,'||unistr('\000a')||
'    CASE '||unistr('\000a')||
'    WHEN fan.id = :P32_MAX_FANTNORMBEREICH THEN'||unistr('\000a')||
'         apex_item.text(32,fan.wert2,8,8)'||unistr('\000a')||
'    ELSE'||unistr('\000a')||
'         apex_item.hidden(32,fan.wert2)|| '||unistr('\000a')||
'         fan.wert2 '||unistr('\000a')||
'    END wert2,'||unistr('\000a')||
'    apex_item.hidden(31,fan.id)||'||unistr('\000a')||
'    apex_item.text(34,fan.bezeichnung,70,100) bezeichnung,'||unistr('\000a')||
'    CASE '||unistr('\000a')||
'    WHEN fan.id = :P32_MAX_FANTNORMBEREICH AND '||unistr('\000a')||
'         :p32_drucktyp = 1 -- Bas';

s:=s||'isfrage/Balkengrafik'||unistr('\000a')||
'    THEN'||unistr('\000a')||
'         apex_item.select_list_from_query(33,fan.normwert,''select fas_synch.get_tab_uebersetzung(''''NORMIERUNGSKLASSEN.BEZEICHNUNG'''',ID,:fas_sprache_id)||teilbereich, teilbereich from normierungsklassen '''||unistr('\000a')||
'/*where teilbereich in (select min(teilbereich) from normierungsklassen)'' '||unistr('\000a')||
'where teilbereich not in (select normwert from fantwort_normwerte where frage_id = ''||:p32_';

s:=s||'id||'||unistr('\000a')||
''' and id != ''|| fan.id||'' and version=frgbg_s.GET_FANORMW_AKT_VERS(''||:p32_id ||'') and satz_kennzeichen is null) and bereich not in (select bereich from fantwort_normwerte fn, normierungsklassen n where fn.normwert = n.teilbereich and fn.frage_id = ''||:p32_id ||'' and fn.sort in (select max(sort) from fantwort_normwerte where frage_id = ''||:p32_id||'' and version=frgbg_s.GET_FANORMW_AKT_VERS(''|';

s:=s||'|:p32_id ||'') and satz_kennzeichen is null and id != ''||fan.id||'')) group by bereich)'''||unistr('\000a')||
'*/'||unistr('\000a')||
',''NO'',NULL,NULL)'||unistr('\000a')||
'    WHEN fan.id = :P32_MAX_FANTNORMBEREICH AND '||unistr('\000a')||
'         :p32_drucktyp!=1 THEN -- Ergklasse'||unistr('\000a')||
'         apex_item.text(33,fan.normwert,5,5)'||unistr('\000a')||
'    WHEN fan.id != :P32_MAX_FANTNORMBEREICH AND'||unistr('\000a')||
'         :p32_drucktyp!=1 THEN -- Ergklasse'||unistr('\000a')||
'         apex_item.display_and_save(33,fan.normwert)'||unistr('\000a')||
'    ELSE'||unistr('\000a')||
'  ';

s:=s||'       apex_item.hidden(33,fan.normwert)||'||unistr('\000a')||
'         (select NVL(min(fas_synch.get_tab_uebersetzung(''NORMIERUNGSKLASSEN.BEZEICHNUNG'',ID,:fas_sprache_id)'||unistr('\000a')||
'),fan.normwert) from normierungsklassen where teilbereich = fan.normwert)'||unistr('\000a')||
'    END normwert,'||unistr('\000a')||
'    fan.sort,fan.id'||unistr('\000a')||
'from fantwort_normwerte fan,fantworten fa'||unistr('\000a')||
'where fan.frage_id = :p32_id'||unistr('\000a')||
'  and fan.frage_id = fa.frage_id'||unistr('\000a')||
'  and fan.satz_kennzeichen is nu';

s:=s||'ll'||unistr('\000a')||
'  and fan.version = frgbg_s.GET_FANORMW_AKT_VERS(:p32_id)'||unistr('\000a')||
'order by fan.wert1';

wwv_flow_api.create_report_region (
  p_id=> 4694819676011757 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_name=> '&P32_PAGE_TITEL_NORMBEREICHE.',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 25,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 2,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_when_condition=> '(select count(*)'||unistr('\000a')||
' from fantwort_normwerte'||unistr('\000a')||
' where frage_id = :p32_id'||unistr('\000a')||
'   and :p32_anzeigetyp_id = 5'||unistr('\000a')||
'   and satz_kennzeichen is null ) > 0',
  p_display_condition_type=> 'SQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P32_HEIGHT_NORMLISTE.px;padding-right:10px; overflow:auto; ">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3687,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '50',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4695113604011762 + wwv_flow_api.g_id_offset,
  p_region_id=> 4694819676011757 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'WERT1',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4695228406011765 + wwv_flow_api.g_id_offset,
  p_region_id=> 4694819676011757 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'WERT2',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4697603642224796 + wwv_flow_api.g_id_offset,
  p_region_id=> 4694819676011757 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'BEZEICHNUNG',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5456312578262323 + wwv_flow_api.g_id_offset,
  p_region_id=> 4694819676011757 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'NORMWERT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4695405822011765 + wwv_flow_api.g_id_offset,
  p_region_id=> 4694819676011757 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'SORT',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4695531539011765 + wwv_flow_api.g_id_offset,
  p_region_id=> 4694819676011757 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT'||unistr('\000a')||
'apex_item.hidden(18,f.id)|| '||unistr('\000a')||
'apex_item.hidden(19,f.anzeigetyp_id)|| '||unistr('\000a')||
'apex_item.hidden(20,fa.id)|| '||unistr('\000a')||
'apex_item.text(21,formatmask,16,16) formatmask,'||unistr('\000a')||
'--apex_item.text(24,formatmask_1,10,10) formatmask_1,NEI 16.11.10 Formatmask'||unistr('\000a')||
'apex_item.text(22,to_char(min_wert,formatmask),6,6) min_wert,'||unistr('\000a')||
'apex_item.text(26,to_char(min_messwert,formatmask),6,6) min_messwert,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'  /* bearbeitbare Version */'||unistr('\000a')||
'  W';

s:=s||'HEN min_messwert_text_id is not null -- Link zu text'||unistr('\000a')||
'  THEN '||unistr('\000a')||
'apex_item.hidden(27,min_messwert_text_id,6,6)'||unistr('\000a')||
'||frgbg_s.holen_uebersetzung(min_messwert_text_id,:fas_sprache_id)'||unistr('\000a')||
'||''<a href="'''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL(''f?p=''||:APP_ID||'':31:''||:APP_SESSION||''::&DEBUG.::'''||unistr('\000a')||
'||''P31_TEXT_ID,P31_ZURUECK_ZUR_SEITE:'''||unistr('\000a')||
'||to_char(min_messwert_text_id)||'',''||:app_page_id)'||unistr('\000a')||
'|| ''">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#ed-item.';

s:=s||'gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE /* Kein Text  */'||unistr('\000a')||
'   apex_item.text(27,NULL,6,6)'||unistr('\000a')||
'END min_messwert_text_id,'||unistr('\000a')||
'apex_item.text(23,to_char(max_wert,formatmask),6,6) max_wert,'||unistr('\000a')||
'apex_item.text(28,to_char(max_messwert,formatmask),6,6) max_messwert,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'  /* bearbeitbare Version */'||unistr('\000a')||
'  WHEN max_messwert_text_id is not null -- Link zu text'||unistr('\000a')||
'  THEN '||unistr('\000a')||
'apex_item.hidden(29,max_messwert_text_id,6,6)'||unistr('\000a')||
'||frgbg_s.holen_uebersetzung';

s:=s||'(max_messwert_text_id,:fas_sprache_id)'||unistr('\000a')||
'||''<a href="'''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL(''f?p=''||:APP_ID||'':31:''||:APP_SESSION||''::&DEBUG.::'''||unistr('\000a')||
'||''P31_TEXT_ID,P31_ZURUECK_ZUR_SEITE:'''||unistr('\000a')||
'||to_char(max_messwert_text_id)||'',''||:app_page_id)'||unistr('\000a')||
'|| ''">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#ed-item.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE /* Kein Text  */'||unistr('\000a')||
'   apex_item.text(29,NULL,6,6)'||unistr('\000a')||
'END max_messwert_text_id,'||unistr('\000a')||
'fa.id'||unistr('\000a')||
'from fantworten fa, fragen f'||unistr('\000a')||
'wher';

s:=s||'e fa.FRAGE_ID = :P32_ID'||unistr('\000a')||
'  and fa.frage_id = f.id'||unistr('\000a')||
'  and (select count(*)'||unistr('\000a')||
'       from fantworten'||unistr('\000a')||
'       where frage_id = :p32_id'||unistr('\000a')||
'         and satz_kennzeichen is null ) > 0'||unistr('\000a')||
'  and fa.satz_kennzeichen is null'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT'||unistr('\000a')||
'apex_item.hidden(18,f.id)|| '||unistr('\000a')||
'apex_item.hidden(19,f.anzeigetyp_id)|| '||unistr('\000a')||
'apex_item.hidden(20,NULL)|| '||unistr('\000a')||
'apex_item.text(21,''FM999990D099999'',16,16) formatmask,'||unistr('\000a')||
'--apex_item.text(24,''9999D9'',';

s:=s||'10,10) formatmask_1,'||unistr('\000a')||
'apex_item.text(22,0,6,6) min_wert,'||unistr('\000a')||
'apex_item.text(26,NULL,6,6) min_messwert,'||unistr('\000a')||
'apex_item.text(27,NULL,6,6) min_messwert_text_id,'||unistr('\000a')||
'apex_item.text(23,9999,6,6) max_wert,'||unistr('\000a')||
'apex_item.text(28,NULL,6,6) max_messwert,'||unistr('\000a')||
'apex_item.text(29,NULL,6,6) max_messwert_text_id,'||unistr('\000a')||
'null'||unistr('\000a')||
'FROM fragen f'||unistr('\000a')||
'where (select count(*)'||unistr('\000a')||
'       from fantworten'||unistr('\000a')||
'       where frage_id = :p32_id'||unistr('\000a')||
'         and satz_kennzei';

s:=s||'chen is null'||unistr('\000a')||
'      )= 0'||unistr('\000a')||
'and f.id = :p32_id'||unistr('\000a')||
'';

wwv_flow_api.create_report_region (
  p_id=> 4728828646466406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_name=> '&P32_PAGE_TITEL_ANTWORT.',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 16,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_when_condition=> ':P32_ID is not null and :P32_anzeigetyp_ID = 5',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3686,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4729102066466412 + wwv_flow_api.g_id_offset,
  p_region_id=> 4728828646466406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FORMATMASK',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4729213527466412 + wwv_flow_api.g_id_offset,
  p_region_id=> 4728828646466406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'MIN_WERT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5760016598954503 + wwv_flow_api.g_id_offset,
  p_region_id=> 4728828646466406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'MIN_MESSWERT',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5760118292954504 + wwv_flow_api.g_id_offset,
  p_region_id=> 4728828646466406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'MIN_MESSWERT_TEXT_ID',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4729306838466412 + wwv_flow_api.g_id_offset,
  p_region_id=> 4728828646466406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'MAX_WERT',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5760215842954506 + wwv_flow_api.g_id_offset,
  p_region_id=> 4728828646466406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'MAX_MESSWERT',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5760321058954506 + wwv_flow_api.g_id_offset,
  p_region_id=> 4728828646466406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'MAX_MESSWERT_TEXT_ID',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5127211837738121 + wwv_flow_api.g_id_offset,
  p_region_id=> 4728828646466406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT fa.bemerkung ,frgbg_s.HOLEN_UEBERSETZUNG(fa.text_id,:FAS_BASIS_SPRACHE_ID) --,u.text'||unistr('\000a')||
'||''<a href="'''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL(''f?p=''||:APP_ID||'':31:''||:APP_SESSION||''::&DEBUG.::'''||unistr('\000a')||
'||''P31_TEXT_ID,P31_ZURUECK_ZUR_SEITE:'''||unistr('\000a')||
'||to_char(fa.TEXT_ID)||'',''||:app_page_id)'||unistr('\000a')||
'|| ''">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#ed-item.gif">'''||unistr('\000a')||
'|| ''</a>''||''</br>'''||unistr('\000a')||
'--|| APEX_ITEM.POPUP_FROM_QUERY(21,fa.text_id,''Select text, text_i';

s:=s||'d from uebersetzungen u, texte t where t.id = u.text_id and u.sprache_id = ''||:fas_sprache_id||'' and t.textkategorie_id in (10) order by 1'',8)'||unistr('\000a')||
'|| APEX_ITEM.POPUP_FROM_QUERY(21,fa.text_id,''Select frgbg_s.HOLEN_UEBERSETZUNG(t.id,''||:fas_basissprache_id||''), t.id from texte t where t.textkategorie_id in (10) order by 1'',8)'||unistr('\000a')||
'|| apex_item.text(24,NULL) '||unistr('\000a')||
' text,'||unistr('\000a')||
'       apex_item.hidden(18,f.id)|| '||unistr('\000a')||
'       ';

s:=s||'apex_item.hidden(19,f.anzeigetyp_id)|| '||unistr('\000a')||
'       apex_item.hidden(20,fa.id)||'||unistr('\000a')||
'       apex_item.text(25,fa.sort,5,5) sort,'||unistr('\000a')||
'       fa.id, fa.sort sort1'||unistr('\000a')||
'from fantworten fa,fragen f --, uebersetzungen u -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'where fa.FRAGE_ID = :P32_ID'||unistr('\000a')||
'  --and fa.text_id = u.text_id'||unistr('\000a')||
'  --and u.sprache_id = 357'||unistr('\000a')||
'  and fa.satz_kennzeichen is null'||unistr('\000a')||
'  and fa.frage_id = ';

s:=s||'f.id'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT NULL,'||unistr('\000a')||
'       -- APEX_ITEM.POPUP_FROM_QUERY(21,null,''Select text, text_id from uebersetzungen u, texte t where t.id = u.text_id and u.sprache_id = ''||:fas_sprache_id||''  and t.textkategorie_id in (1)'',8)'||unistr('\000a')||
'       APEX_ITEM.POPUP_FROM_QUERY(21,null,''Select frgbg_s.HOLEN_UEBERSETZUNG(t.id,''||:fas_basissprache_id||''), t.id from texte t where t.textkategorie_id in (10) order by 1'',8)'||unistr('\000a')||
'  ';

s:=s||'  || apex_item.text(24,NULL) text,'||unistr('\000a')||
'       apex_item.hidden(18,f.id)|| '||unistr('\000a')||
'       apex_item.hidden(19,f.anzeigetyp_id)|| '||unistr('\000a')||
'       apex_item.hidden(20,NULL)|| '||unistr('\000a')||
'       apex_item.text(25,(SELECT NVL(max(sort)+1,1) '||unistr('\000a')||
'                          from fantworten '||unistr('\000a')||
'                          where frage_id = :p32_id'||unistr('\000a')||
'                            and satz_kennzeichen is null'||unistr('\000a')||
'                      ),5,5),'||unistr('\000a')||
'       NULL,';

s:=s||' null '||unistr('\000a')||
'from fragen f'||unistr('\000a')||
'where id = :p32_id'||unistr('\000a')||
'order by sort1 asc';

wwv_flow_api.create_report_region (
  p_id=> 5051117011607584 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_name=> '&P32_PAGE_TITEL_ANTWORTAUSWAHL.',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 17,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_when_condition=> ':P32_ID is not null and :P32_anzeigetyp_ID != 5',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P32_HEIGHT_ANTLOVLISTE.px;padding-right:20px; overflow:auto; min-width: 500px; ">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3692,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5159730813508571 + wwv_flow_api.g_id_offset,
  p_region_id=> 5051117011607584 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'BEMERKUNG',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5157815953212709 + wwv_flow_api.g_id_offset,
  p_region_id=> 5051117011607584 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TEXT',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '100',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5054131789753781 + wwv_flow_api.g_id_offset,
  p_region_id=> 5051117011607584 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SORT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5140809514851528 + wwv_flow_api.g_id_offset,
  p_region_id=> 5051117011607584 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5454424306887221 + wwv_flow_api.g_id_offset,
  p_region_id=> 5051117011607584 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'SORT1',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Sort1',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'apex_item.display_and_save(41,ID)                                      id,'||unistr('\000a')||
'apex_item.POPUP_FROM_QUERY(42,FRAGE_ID,'||unistr('\000a')||
'''SELECT f.kurzbezeichnung, f.id '||unistr('\000a')||
'    FROM fragen f, fkategorien fk, fkategorien fk1 '||unistr('\000a')||
'    WHERE f.fkategorie_id = fk.id AND f.satz_kennzeichen is null '||unistr('\000a')||
'        AND f.fragelevel < ''||:p32_fragelevel||'' '||unistr('\000a')||
'        AND fk.satz_kennzeichen is null '||unistr('\000a')||
'        AND fk.fragebogen_id = fk1.';

s:=s||'fragebogen_id '||unistr('\000a')||
'        AND fk1.id = ''||:p32_fkategorie_id,8,8)                        frage_id,'||unistr('\000a')||
'apex_item.SELECT_LIST(43,param_pos,''1,2,3,4,5,6,7,8,9,10'')             param_pos,'||unistr('\000a')||
'param_pos                                                              param_pos1,'||unistr('\000a')||
'BEMERKUNG                                                             bemerkung,'||unistr('\000a')||
'apex_item.POPUP_FROM_QUERY(44,FANTWORT_ID,'||unistr('\000a')||
'''SELECT fa.beme';

s:=s||'rkung, fa.id '||unistr('\000a')||
'  FROM fantworten fa'||unistr('\000a')||
'  WHERE fa.frage_id = '' || FRAGE_ID || '' AND fa.satz_kennzeichen is null'||unistr('\000a')||
'        AND fa.frage_id IS NOT NULL'',8,8)                              fantwort_id'||unistr('\000a')||
'from FRAGEN_METADETAILS'||unistr('\000a')||
'WHERE frage_id_meta = :p32_id'||unistr('\000a')||
'  and satz_kennzeichen is null'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT'||unistr('\000a')||
'apex_item.display_and_save(41,NULL) id,'||unistr('\000a')||
'apex_item.POPUP_FROM_QUERY(42,NULL,'||unistr('\000a')||
'''SELECT f.kurzbezeichnung, f.id '||unistr('\000a')||
'  ';

s:=s||' FROM fragen f, fkategorien fk, fkategorien fk1 '||unistr('\000a')||
'   WHERE f.fkategorie_id = fk.id AND f.satz_kennzeichen is null '||unistr('\000a')||
'       AND f.fragelevel < ''||:p32_fragelevel||'' '||unistr('\000a')||
'       AND fk.satz_kennzeichen is null '||unistr('\000a')||
'       AND fk.fragebogen_id = fk1.fragebogen_id '||unistr('\000a')||
'       AND fk1.id = ''||:p32_fkategorie_id,8,8)                         frage_id,'||unistr('\000a')||
'apex_item.SELECT_LIST(43,NULL ,''1,2,3,4,5,6,7,8,9,10'')             ';

s:=s||'    param_pos,'||unistr('\000a')||
'NULL                                                                   param_pos1,'||unistr('\000a')||
'NULL                                                                   bemerkung,'||unistr('\000a')||
'null                            fantwort_id'||unistr('\000a')||
'FROM DUAL'||unistr('\000a')||
'order by param_pos1';

wwv_flow_api.create_report_region (
  p_id=> 5578505363477107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_name=> '&P32_PAGE_TITEL_METADETAILS.',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 35,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 2,
  p_display_point=> 'BODY_1',
  p_item_display_point=> 'BELOW',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_when_condition=> 'NVL(:p32_fragelevel,0) > 0 and'||unistr('\000a')||
':p32_id is not null',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(4407,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5579113529479210 + wwv_flow_api.g_id_offset,
  p_region_id=> 5578505363477107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5581828790550190 + wwv_flow_api.g_id_offset,
  p_region_id=> 5578505363477107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5579317033479210 + wwv_flow_api.g_id_offset,
  p_region_id=> 5578505363477107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PARAM_POS',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_inline_lov=> '1,2,3,4,5,6,7,8,9,10',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5595816594991407 + wwv_flow_api.g_id_offset,
  p_region_id=> 5578505363477107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PARAM_POS1',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5579417645479210 + wwv_flow_api.g_id_offset,
  p_region_id=> 5578505363477107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'BEMERKUNG',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5109915389982153 + wwv_flow_api.g_id_offset,
  p_region_id=> 5578505363477107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 6374626501186332 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 19,
  p_button_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_button_name    => 'KOMPLEXFRAGE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_KOMPLEXFRAGE.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'DECLARE'||unistr('\000a')||
'   v_anz    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT count(*) into v_anz'||unistr('\000a')||
'   FROM fantwort_normwerte '||unistr('\000a')||
'   where frage_id = :p32_id '||unistr('\000a')||
'     and satz_kennzeichen is null;'||unistr('\000a')||
'   IF :p32_id is not null and v_anz = 0 and'||unistr('\000a')||
'      :p32_bezug_frage_id is null'||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      RETURN TRUE;'||unistr('\000a')||
'   ELSE '||unistr('\000a')||
'      RETURN FALSE;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_button_condition_type=> 'FUNCTION_BODY',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4685629362939868 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 28,
  p_button_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_LOESCHEN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> ':P32_ID is not null',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4685823892939868 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 30,
  p_button_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P32_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5557100294779865 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 30,
  p_button_plug_id => 5578505363477107+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4686217925939868 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 50,
  p_button_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_PREVIOUS_ID2',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&lt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_PREVIOUS_ID'')',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'P32_ID_PREV',
  p_button_condition_type=> 'NEVER',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4686420826939868 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 60,
  p_button_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_NEXT_ID2',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&gt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_NEXT_ID'')',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'P32_ID_NEXT',
  p_button_condition_type=> 'NEVER',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 6360630488130803 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 85,
  p_button_plug_id => 4728828646466406+wwv_flow_api.g_id_offset,
  p_button_name    => 'NORMIEREN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_NORMIEREN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> '(select count(*)'||unistr('\000a')||
' from fantworten'||unistr('\000a')||
' where frage_id = :p32_id'||unistr('\000a')||
'   and satz_kennzeichen is null ) > 0'||unistr('\000a')||
'and '||unistr('\000a')||
'(select count(*)'||unistr('\000a')||
' from fantwort_normwerte'||unistr('\000a')||
' where frage_id = :p32_id'||unistr('\000a')||
'   and satz_kennzeichen is null ) = 0',
  p_button_condition_type=> 'SQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4730213372509223 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 90,
  p_button_plug_id => 4728828646466406+wwv_flow_api.g_id_offset,
  p_button_name    => 'ANT_SPEICHERN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5433920116286036 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 110,
  p_button_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_PREVIOUS_ID',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&lt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_PREVIOUS_ID'')',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'P32_ID_PREV',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5433822029286036 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 120,
  p_button_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_NEXT_ID',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&gt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_NEXT_ID'')',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'P32_ID_NEXT',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4685424309939867 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 10,
  p_button_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P32_ZURUECK_ZUR_SEITE.:&SESSION.::&DEBUG.:32::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4686021616939868 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 40,
  p_button_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_ERSTELLEN.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P32_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4699602407385304 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 70,
  p_button_plug_id => 4694819676011757+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERSION',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_NEUE_VERSION.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4700013488388495 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 80,
  p_button_plug_id => 4694819676011757+wwv_flow_api.g_id_offset,
  p_button_name    => 'BEREICH',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_NEUER_BEREICH.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5160903034595114 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 80,
  p_button_plug_id => 5051117011607584+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERSION_ANT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_NEUE_VERSION.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5051813477607592 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 90,
  p_button_plug_id => 5051117011607584+wwv_flow_api.g_id_offset,
  p_button_name    => 'ANT_SPEICHERN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P32_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4940800991065970 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 100,
  p_button_plug_id => 4694819676011757+wwv_flow_api.g_id_offset,
  p_button_name    => 'NORMWERTE_LOESCHEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Alle Normwerte löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>4693700143939882 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:32:&SESSION.::&DEBUG.::P32_ID:&P32_ID_NEXT.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>4686420826939868+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 5,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
wwv_flow_api.create_page_branch(
  p_id=>4693918526939882 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:32:&SESSION.::&DEBUG.::P32_ID:&P32_ID_PREV.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>4686217925939868+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 6,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
wwv_flow_api.create_page_branch(
  p_id=>6360923145130804 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>4685629362939868+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>6374917529186343 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:35:&SESSION.::&DEBUG.::P35_BEZUG_FRAGE_ID:&P32_ID.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>6374626501186332+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>4694126665939882 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 40,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>5437306961286049 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:32:&SESSION.::&DEBUG.::P32_ID:&P32_ID_NEXT.',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>5433822029286036+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
wwv_flow_api.create_page_branch(
  p_id=>5437501428286052 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:32:&SESSION.::&DEBUG.::P32_ID:&P32_ID_PREV.',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>5433920116286036+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1220128457688635 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_NV_FRAGEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 540,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Fragen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1220319761733441 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BL_NORMIEREN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 550,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Normieren',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1220530151736379 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BL_KOMPLEXFRAGE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 560,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Komplexfrage',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1220708811739708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_PAGE_TITEL_METADETAILS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 570,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Metadetails',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4687017467939871 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_post_element_text=>'&#160&#160&#160',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4687225611939871 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_SORT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 17,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'DECLARE '||unistr('\000a')||
'   v_sort    NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*   SELECT nvl(max(sort),0) + 1 into v_sort'||unistr('\000a')||
'   FROM fragen'||unistr('\000a')||
'   WHERE fkategorie_id = :p32_fkategorie_id'||unistr('\000a')||
'     and ( (fragelevel = 0 and :p32_fragelevel=0) '||unistr('\000a')||
'        OR (fragelevel > 0 and :p32_fragelevel>0)'||unistr('\000a')||
'         );'||unistr('\000a')||
'*/'||unistr('\000a')||
'      SELECT CASE WHEN max(sort) is null AND :p32_fragelevel > 0 THEN 900'||unistr('\000a')||
'                  WHEN max(sort) is null AND :p32_fragelevel = 0 THEN 1'||unistr('\000a')||
'                  ELSE max(sort)+1'||unistr('\000a')||
'             END'||unistr('\000a')||
'      INTO v_sort'||unistr('\000a')||
'      FROM fragen'||unistr('\000a')||
'      WHERE fkategorie_id = :p32_fkategorie_id'||unistr('\000a')||
'        and ( (fragelevel = 0 and :p32_fragelevel=0)'||unistr('\000a')||
'           OR (fragelevel > 0 and :p32_fragelevel>0)'||unistr('\000a')||
'            )'||unistr('\000a')||
'        and satz_kennzeichen is null;'||unistr('\000a')||
'   RETURN v_sort;'||unistr('\000a')||
'END;  ',
  p_item_default_type=> 'PLSQL_FUNCTION_BODY',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'SORT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 5,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4687402804939873 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_KURZBEZEICHNUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 113,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Kurzbezeichnung',
  p_source=>'KURZBEZEICHNUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4687622285939873 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'BEMERKUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4687816496939873 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_TEXT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 131,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'TEXT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4688001997939873 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_FKATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 180,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> ':P30_FKATEGORIE_ID',
  p_item_default_type=> 'PLSQL_EXPRESSION',
  p_prompt=>'Fkategorie Id',
  p_source=>'FKATEGORIE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3050021180431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4688211628939873 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_TEXT_ID_FRAGETEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 103,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'TEXT_ID_FRAGETEXT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4688422551939873 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_ANZEIGETYP_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 19,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '5',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'ANZEIGETYP_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT frgbg_s.HOLEN_UEBERSETZUNG(3668,:fas_sprache_id) a, 5 b '||unistr('\000a')||
'FROM DUAL /*Werteingabe*/'||unistr('\000a')||
'UNION '||unistr('\000a')||
'SELECT frgbg_s.HOLEN_UEBERSETZUNG(3669,:fas_sprache_id) , 3 '||unistr('\000a')||
'FROM DUAL /*Auswahlliste*/'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'NVL(:p32_fragelevel,1) != 0 OR /* Metafrage */'||unistr('\000a')||
':p32_id is not null            /* Fragedef. vorhanden */',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4688607814939875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_TEXTHOEHE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 210,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Texthoehe',
  p_source=>'TEXTHOEHE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049813415431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4688819986939875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_TEXTBREITE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 240,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '10',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Textbreite',
  p_source=>'TEXTBREITE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049813415431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4689009279939875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_EINGABEPFLICHTIG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 18,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'EINGABEPFLICHTIG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(76,:fas_sprache_id) a,1 b'||unistr('\000a')||
'from dual'||unistr('\000a')||
'union'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(77,:fas_sprache_id) a,0 b'||unistr('\000a')||
'from dual',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4689218161939875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_FRAGELEVEL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'FRAGELEVEL',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'STATIC2:0,1,2,3,4,5,6,7,8,9,10',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p32_id is not null ',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_attribute_01 => 'REDIRECT_SET_VALUE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4689428326939875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BERECHNUNGSTYP',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'BERECHNUNGSTYP',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT berechnungstyp a, berechnungstyp  b'||unistr('\000a')||
'FROM berechnungstypen'||unistr('\000a')||
'order by sort',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'NVL(:p32_fragelevel,0) > 0',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4690232696939876 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_FRAGETEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 62,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'frgbg_s.holen_uebersetzung(:p32_text_id_fragetext,357)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4690430410939876 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_HILFETEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'frgbg_s.holen_uebersetzung(:p32_text_id,357)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4735409196056889 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_MAX_FANTNORMBEREICH',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 4694819676011757+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Max Fantnormbereich',
  p_source=>'SELECT id'||unistr('\000a')||
'FROM fantwort_normwerte'||unistr('\000a')||
'WHERE wert1 ='||unistr('\000a')||
'  ( SELECT max(wert1)'||unistr('\000a')||
'   from fantwort_normwerte'||unistr('\000a')||
'   where frage_id = :p32_id'||unistr('\000a')||
'     and version = frgbg_s.GET_FANORMW_AKT_VERS(:p32_id)  -- NEI 14.05.13'||unistr('\000a')||
'   )'||unistr('\000a')||
'AND frage_id = :p32_id'||unistr('\000a')||
'and version = frgbg_s.GET_FANORMW_AKT_VERS(:p32_id)       -- NEI 14.05.13',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5030216660313007 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_TEXT_ID_SUCHTEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 135,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'TEXT_ID_SUCHTEXT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5030508133320026 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_SUCHTEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 134,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'frgbg_s.holen_uebersetzung(:p32_text_id_suchtext,357)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5033024128504468 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_INHSTOFF_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 6,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'INHSTOFF_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT fas_synch.get_tab_uebersetzung(''INHSTOFFE.BEZEICHNUNG'','||unistr('\000a')||
'                   ID,:fas_sprache_id) a, id b'||unistr('\000a')||
'FROM inhstoffe'||unistr('\000a')||
'WHERE inh_typ = ''LW'''||unistr('\000a')||
'  and satz_kennzeichen is null'||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'NVL(:p32_fragelevel,0) = 0 /* Basisfrage */',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_read_only_when=>':p32_id is not null     /* Frage vorhanden */'||unistr('\000a')||
'',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_attribute_01 => 'REDIRECT_SET_VALUE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5033809546547506 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BEZUG_EINHEIT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 7,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'DECLARE'||unistr('\000a')||
'   v_bezug_einheit_id    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT  e.bezug_einheit_id into v_bezug_einheit_id'||unistr('\000a')||
'   FROM inh_eh_disps e'||unistr('\000a')||
'   WHERE e.inhstoff_id = :p32_inhstoff_id'||unistr('\000a')||
'     and e.satz_kennzeichen is null'||unistr('\000a')||
'     and e.standard = 1;'||unistr('\000a')||
'   return  v_bezug_einheit_id;'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN others THEN NULL;'||unistr('\000a')||
'END',
  p_item_default_type=> 'PLSQL_FUNCTION_BODY',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'BEZUG_EINHEIT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT rezepte.get_bezug_eh_bez(e.bezug_einheit_id,:fas_sprache_id) a, '||unistr('\000a')||
'       e.bezug_einheit_id b'||unistr('\000a')||
'FROM inh_eh_disps e'||unistr('\000a')||
'WHERE e.inhstoff_id = :p32_inhstoff_id'||unistr('\000a')||
'  and e.satz_kennzeichen is null',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'NVL(:p32_fragelevel,0) = 0 /* Basisfrage */',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_read_only_when=>'NVL(:p32_aktiv,1) = 1   /* Antworten zur Frage vorhanden */'||unistr('\000a')||
''||unistr('\000a')||
'',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5039818893718715 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BEZUG_EINHEIT_ID_EINGABE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 8,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'SELECT  e.bezug_einheit_id'||unistr('\000a')||
'FROM inh_eh_disps e'||unistr('\000a')||
'WHERE e.inhstoff_id = :p32_inhstoff_id'||unistr('\000a')||
'  and e.satz_kennzeichen is null'||unistr('\000a')||
'  and e.standard= 1',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT rezepte.get_bezug_eh_bez(e.bezug_einheit_id,:fas_sprache_id) a,'||unistr('\000a')||
'       e.bezug_einheit_id b'||unistr('\000a')||
'FROM inh_eh_disps e'||unistr('\000a')||
'WHERE e.inhstoff_id = :p32_inhstoff_id'||unistr('\000a')||
'  and e.satz_kennzeichen is null'||unistr('\000a')||
'  ',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'NVL(:p32_fragelevel,0) = 0 /* Basisfrage */',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_read_only_when_type=>'ALWAYS',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5117731713603376 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_DATENGRUPPE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 4,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> 'NULL',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'DATENGRUPPE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'STATIC2:1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50'||unistr('\000a')||
'',
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'---',
  p_lov_null_value=> 'NULL',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5117914182607757 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_DRUCKTYP',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'DRUCKTYP',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(3609,:fas_sprache_id) a,1 b'||unistr('\000a')||
'from dual'||unistr('\000a')||
'UNION '||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(3806,:fas_sprache_id) a,2 b'||unistr('\000a')||
'from dual',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5120206984861120 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_MUTDAT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 320,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Mutdat',
  p_format_mask=>'DD.MM.YYYY HH24:MI:SS',
  p_source=>'MUTDAT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5122614375965550 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_AKTIV',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'SELECT CASE'||unistr('\000a')||
'    WHEN count(*)>0 THEN'||unistr('\000a')||
'         1 /*frgbg_s.holen_uebersetzung(76,:fas_sprache_id) ja*/'||unistr('\000a')||
'    ELSE'||unistr('\000a')||
'         0 /* frgbg_s.holen_uebersetzung(77,:fas_sprache_id)/ *nein*/'||unistr('\000a')||
'    END'||unistr('\000a')||
'FROM persantworten'||unistr('\000a')||
'WHERE frage_id = :p32_id'||unistr('\000a')||
'  AND satz_kennzeichen is null',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(76,:fas_sprache_id) a,1 b'||unistr('\000a')||
'from dual'||unistr('\000a')||
'union'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(77,:fas_sprache_id) a,0 b'||unistr('\000a')||
'from dual',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when_type=>'ALWAYS',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5124207879294820 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_FEHLERTEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 330,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Fehlertext',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5133405841223179 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_HEIGHT_NORMLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 200,
  p_item_plug_id => 4694819676011757+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Normliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5168331876604676 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_HEIGHT_ANTLOVLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 210,
  p_item_plug_id => 5051117011607584+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Antlovliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5318331545232345 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_SATZ_KENNZEICHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 145,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Satz Kennzeichen',
  p_source=>'SATZ_KENNZEICHEN',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5436324394286040 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_ID_NEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 580,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'P32_ID_NEXT',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5436528187286040 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_ID_PREV',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 590,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'P32_ID_PREV',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5436724044286041 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_ID_COUNT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 600,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddata"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5444729182184459 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_PAGE_TITEL_NORMBEREICHE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 370,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Normbereiche',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5444909228188156 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_PAGE_TITEL_FRAGE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 380,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Frage',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5445119617191178 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_PAGE_TITEL_ANTWORT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 390,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel antwort',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5445326889193309 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_PAGE_TITEL_ANTWORTAUSWAHL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 420,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel antwortauswahl',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5445509012197559 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BL_SPEICHERN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 430,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Speichern',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5445721826201251 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BL_ABBRECHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 440,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Abbrechen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5445903256205378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BL_LOESCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 450,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Löschen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5446507889216184 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BL_NEUE_VERSION',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 480,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Neue Version',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5446718625219276 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BL_NEUER_BEREICH',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 490,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Neuer Bereich',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5447918110256982 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BL_ERSTELLEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 500,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Erstellen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5598623754485492 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_LABORTEST_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 21,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'LABORTEST_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT bezeichnung||'', ''||kuerzel a, id b'||unistr('\000a')||
'FROM labortests'||unistr('\000a')||
'WHERE satz_kennzeichen is null',
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'---',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'NVL(:p32_fragelevel,0) > 0',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5920306126134662 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_FRAGEBOGEN_DISP',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'SELECT ''(''||'||unistr('\000a')||
'  frgbg_s.holen_uebersetzung(f.text_id,:fas_sprache_id)||''/''||'||unistr('\000a')||
'  frgbg_s.holen_uebersetzung(fk.text_id,:fas_sprache_id)||'')'''||unistr('\000a')||
'FROM fragen fa, fkategorien fk, fragebogen f'||unistr('\000a')||
'WHERE fa.id = :p32_id'||unistr('\000a')||
'  AND fa.fkategorie_id = fk.id'||unistr('\000a')||
'  AND fk.fragebogen_id=f.id'||unistr('\000a')||
'  AND :p32_id is not null'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''(''||'||unistr('\000a')||
'  frgbg_s.holen_uebersetzung(f.text_id,:fas_sprache_id)||''/''||'||unistr('\000a')||
'  frgbg_s.holen_uebersetzung(fk.text_id,:fas_sprache_id)||'')'''||unistr('\000a')||
'FROM fkategorien fk, fragebogen f'||unistr('\000a')||
'WHERE fk.id = :p32_fkategorie_id'||unistr('\000a')||
'  AND fk.fragebogen_id=f.id '||unistr('\000a')||
'  AND :p32_id is null',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6510306268127762 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_EINGABE_FORMAT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 9,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'SELECT  e.formatmask'||unistr('\000a')||
'FROM inh_eh_disps e'||unistr('\000a')||
'WHERE e.inhstoff_id = :p32_inhstoff_id'||unistr('\000a')||
'  and e.satz_kennzeichen is null'||unistr('\000a')||
'  and e.standard= 1',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'NVL(:p32_fragelevel,0) = 0 /* Basisfrage */',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6548800664153704 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_BEZUG_FRAGE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 510,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bezug Frage Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6549028368161754 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_ZURUECK_ZUR_SEITE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 520,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Zurueck Zur Seite',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6553608681761198 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_KOMPLEX_META_FRAGE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 530,
  p_item_plug_id => 4683424693939862+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Komlex Meta Frage Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5324400552873303 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P32_INHSTOFF_ID',
  p_validation_sequence=> 1,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF (:p32_inhstoff_id is null OR :p32_inhstoff_id = ''%'') AND '||unistr('\000a')||
'      NVL(:p32_fragelevel,0)=0'||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      RETURN (''Der Laborparameter muss angegeben werden!'');'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'--mel.p(''Ende val p32_inhstoff_id'',v_prot_id,''INFO'',''118/32:val p32_inhstoff_id'');'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 5033024128504468 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4690728455939878 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P32_SORT not null',
  p_validation_sequence=> 20,
  p_validation => 'P32_SORT',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Sort Name muss einen Wert haben.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 4687225611939871 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4691128963939878 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P32_FKATEGORIE_ID not null',
  p_validation_sequence=> 60,
  p_validation => 'P32_FKATEGORIE_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Fkategorie Id muss einen Wert haben.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 4688001997939873 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4691305697939878 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P32_FRAGETEXT not null',
  p_validation_sequence=> 70,
  p_validation => 'P32_FRAGETEXT',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Fragetext muss einen Wert haben.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 4690232696939876 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4691500215939878 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P32_ANZEIGETYP_ID not null',
  p_validation_sequence=> 80,
  p_validation => 'P32_ANZEIGETYP_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Anzeigetyp muss einen Wert haben.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 4688422551939873 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4691727849939879 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P32_EINGABEPFLICHTIG not null',
  p_validation_sequence=> 110,
  p_validation => 'P32_EINGABEPFLICHTIG',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Das Feld eingabepflichtig muss einen Wert haben.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 4689009279939875 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4691908135939879 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P32_FRAGELEVEL not null',
  p_validation_sequence=> 120,
  p_validation => 'P32_FRAGELEVEL',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Fragelevel muss einen Wert haben.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 4689218161939875 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5509918030151454 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P32_BERECHNUNGSTYP',
  p_validation_sequence=> 121,
  p_validation => 'P32_BERECHNUNGSTYP',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Der Berechnungstyp ist eingabepflichtig!',
  p_always_execute=>'N',
  p_validation_condition=> 'NVL(:p32_fragelevel,0) > 0 and'||unistr('\000a')||
':request in (''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 4689428326939875 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5120817167949262 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_fantworten',
  p_validation_sequence=> 130,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_change  NUMBER := 0;'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'MEL.P(''Fantworten validieren 1 i=%1'',v_prot_id,''Info'',''Fantworten validieren'',apex_application.g_f20.count);'||unistr('\000a')||
'   v_change := frgbg_s.fbv_check_fant(v_fehlertext);'||unistr('\000a')||
'   :p32_fehlertext := v_fehlertext;'||unistr('\000a')||
'--MEL.P(''Fantworten validieren 2 i=%1,%2'',v_prot_id,''Info'',''Fantworten validieren'',apex_application.g_f20.count,:p32_fehlertext);'||unistr('\000a')||
'   IF v_change = 0 THEN  -- Keine Daten geändert'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(2020,v_sprache_id ));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   RETURN NULL;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 5051813477607592 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5149129970953179 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_fantwort_normwerte',
  p_validation_sequence=> 140,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_change  NUMBER := 0;'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Fantwort_normwerte validieren 1 i=%1'',v_prot_id,''Info'',''Fantwort_normwerte validieren'',apex_application.g_f20.count);'||unistr('\000a')||
'   v_change := frgbg_s.fbv_check_fantnorm(v_fehlertext);'||unistr('\000a')||
'   :p32_fehlertext := v_fehlertext;'||unistr('\000a')||
'--MEL.P(''Fantwort_normwerte validieren 2 i=%1,%2'',v_prot_id,''Info'',''Fantwort_normwerte validieren'',apex_application.g_f20.count,:p32_fehlertext);'||unistr('\000a')||
'   IF v_change = 0 THEN  -- Keine Daten geändert'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(2020,v_sprache_id ));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   RETURN NULL;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 4700013488388495 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:FRAGEN:ID::SORT::P32_ID:P32_ID_NEXT:P32_ID_PREV::::P32_ID_COUNT:fkategorie_id = 116';

wwv_flow_api.create_page_process(
  p_id     => 5437115136286047 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'GET_NEXT_OR_PREV_PK',
  p_process_name=> 'Nächsten oder vorherigen Primärschlüsselwert abrufen',
  p_process_sql_clob => p,
  p_process_error_message=> 'Unable to run Get Next or Previous Primary Key Value process.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:FRAGEN:P32_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 4692007771939879 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from FRAGEN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Abrufen von Zeile nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_prot_id    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :p32_inhstoff_id = ''%'' THEN'||unistr('\000a')||
'      :p32_inhstoff_id := null;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   IF :p32_fragelevel is null THEN'||unistr('\000a')||
'      :p32_fragelevel := 0;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   IF :p32_fragelevel = 0 THEN'||unistr('\000a')||
'      :p32_berechnungstyp := NULL;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :p32_inhstoff_id := null;'||unistr('\000a')||
'      :p32_bezug_einheit_id := Null;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'--mel.p(''Ende init_inhstoff'',v_prot_id, ''INFO'',''118/32: ';

p:=p||'init_inhstoff'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5324622154889089 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_inhstoff',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_prot_id    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
''||unistr('\000a')||
'mel.p(''Ende trace_info'',v_prot_id, ''INFO'',''118/32: trace_info'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1400432746737501 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'trace_info',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   IF NVL(:p32_fragelevel,0) > 0 and :request in (''CREATE'') THEN'||unistr('\000a')||
'      IF instr(:P32_FRAGETEXT,''MF''||:p32_fragelevel) = 0 THEN'||unistr('\000a')||
'         :P32_FRAGETEXT:= ''MF''||:p32_fragelevel||'':''||:P32_FRAGETEXT;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- LEN 14.07.13'||unistr('\000a')||
'   :P32_KURZBEZEICHNUNG := NVL(:P32_KURZBEZEICHNUNG,:P32_FRAGETEXT);'||unistr('\000a')||
'   '||unistr('\000a')||
'   if NVL(:p32_fragelevel,0) > 0 and substr(:P32_KURZBEZEICHNUNG,1,2) <> ''MF'''||unistr('\000a')||
' ';

p:=p||'        and :P32_KURZBEZEICHNUNG is not null then'||unistr('\000a')||
'      :P32_KURZBEZEICHNUNG:= ''MF''||:p32_fragelevel||'': ''||:P32_KURZBEZEICHNUNG;'||unistr('\000a')||
'   end if;'||unistr('\000a')||
''||unistr('\000a')||
'/* NEI 15.05.13'||unistr('\000a')||
'IF NVL(:p32_fragelevel,0) > 0  THEN'||unistr('\000a')||
'     :P32_KURZBEZEICHNUNG:= ''MF''||:p32_fragelevel||'': ''||:P32_FRAGETEXT;'||unistr('\000a')||
'ELSE'||unistr('\000a')||
'  :P32_KURZBEZEICHNUNG := :P32_FRAGETEXT;'||unistr('\000a')||
'END IF;'||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5046722796126678 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 25,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_frage_kurzbezeichnung',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''CREATE'',''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_fehlertext  varchar2(2000);'||unistr('\000a')||
'   v_return      number;'||unistr('\000a')||
'   v_prot_id     number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Fragetext'||unistr('\000a')||
'   v_return := uebersetzung.admin_basistext(:P32_TEXT_ID_FRAGETEXT,:P32_FRAGETEXT,1,10);'||unistr('\000a')||
'   IF v_return < 0 THEN'||unistr('\000a')||
'      v_fehlertext := frgbg_s.holen_uebersetzung(3646,:FAS_SPRACHE_ID,'||unistr('\000a')||
'                            :P32_TEXT_ID_FRAGETEXT,:P32_FRAGETEXT)||'' ''||SQLERRM;'||unistr('\000a')||
'      mel.p(v_fehlert';

p:=p||'ext,v_prot_id,''Fehler'',''App118/32:gen_fragetext_id'');'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   :P32_TEXT_ID_FRAGETEXT := v_return;'||unistr('\000a')||
'--mel.p(''Nach genfragetext'',v_prot_id,''Info'',''App118/32:gen_fragetext_id'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5047430255242446 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'gen_fragetext_id',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''CREATE'',''SAVE'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'IF :p32_labortest_id = ''NULL'' THEN'||unistr('\000a')||
'   :p32_labortest_id := NULL;'||unistr('\000a')||
'END IF;';

wwv_flow_api.create_page_process(
  p_id     => 5599212719510689 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_labortest_id',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''CREATE'',''SAVE'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'IF :p32_datengruppe = ''NULL'' THEN'||unistr('\000a')||
'   :p32_datengruppe := NULL;'||unistr('\000a')||
'END IF;';

wwv_flow_api.create_page_process(
  p_id     => 5597300523251637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_datengruppe',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''CREATE'',''SAVE'',''DELETE'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p32_satz_kennzeichen := ''gelöscht am ''||to_char(sysdate,''DD.MM.YYYY hh24:mi:ss'')||'' von ''||:APP_USER;';

wwv_flow_api.create_page_process(
  p_id     => 5318000031223218 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 80,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_satz_kennzeichen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>4685629362939868 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:FRAGEN:P32_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 4692229459939879 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 90,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of FRAGEN',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Zeile der Tabelle FRAGEN nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''CREATE'',''SAVE'',''DELETE'',''INSERT'')'||unistr('\000a')||
'or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_return_key_into_item1=>'P32_ID',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   UPDATE komplex_meta_fragen'||unistr('\000a')||
'   set meta_frage_id = :p32_id'||unistr('\000a')||
'   WHERE id = :p32_komplex_meta_frage_id;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 6552502747731103 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 100,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'update_komplex_meta_fragen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request = ''CREATE_AGAIN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_return     number;'||unistr('\000a')||
'   v_fehlertext varchar2(2000);'||unistr('\000a')||
'   v_prot_id    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Hilfetext'||unistr('\000a')||
'   -- Neuanlegen oder Speichern des Hilfetextes'||unistr('\000a')||
'   v_return := uebersetzung.admin_basistext(:P32_TEXT_ID,:P32_HILFETEXT,1,10);'||unistr('\000a')||
'   IF v_return < 0 THEN'||unistr('\000a')||
'      v_fehlertext := frgbg_s.holen_uebersetzung(3646,:FAS_SPRACHE_ID,'||unistr('\000a')||
'                            :P32_TEXT_ID,:P32_HILFETEXT)||'' ''||SQLER';

p:=p||'RM;'||unistr('\000a')||
'      mel.p(v_fehlertext,v_prot_id,''Fehler'',''App118/32:gen_such_hilftext_id'');'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   IF :P32_TEXT_ID is null THEN  -- Text neuangelegt'||unistr('\000a')||
'      :P32_TEXT_ID := v_return;'||unistr('\000a')||
'      UPDATE fragen'||unistr('\000a')||
'      SET text_id = :P32_TEXT_ID'||unistr('\000a')||
'      WHERE id = :p32_id;'||unistr('\000a')||
'   ELSIF :P32_TEXT_ID is not null THEN --Text vorher vorhanden+oben geändert od.soll gel';

p:=p||'öscht werden'||unistr('\000a')||
'      IF :P32_HILFETEXT is NULL THEN   -- Löschen des Textes'||unistr('\000a')||
'         UPDATE fragen'||unistr('\000a')||
'         SET text_id = NULL'||unistr('\000a')||
'         WHERE id = :p32_id;'||unistr('\000a')||
'         /* -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'         DELETE uebersetzungen'||unistr('\000a')||
'         WHERE text_id = :p32_text_id;'||unistr('\000a')||
'         DELETE texte'||unistr('\000a')||
'         WHERE id = :P32_TEXT_ID;'||unistr('\000a')||
'         */'||unistr('\000a')||
'         uebersetzung.delete_text';

p:=p||'(p_id => :P32_TEXT_ID);'||unistr('\000a')||
'         :P32_TEXT_ID := NULL;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Suchtext'||unistr('\000a')||
'   -- Neuanlegen oder Speichern des Suchtext'||unistr('\000a')||
'--mel.p(''Info Suchtext =''||to_char(:P32_TEXT_ID_SUCHTEXT)||''/''||:P32_SUCHTEXT||'')!'',v_prot_id,''Test'',''App118/32:gen_such_hilftext_id'');'||unistr('\000a')||
'   v_return := uebersetzung.admin_basistext(:P32_TEXT_ID_SUCHTEXT,:P32_SUCHTEXT,1,10);'||unistr('\000a')||
'   IF v_return < 0 THEN'||unistr('\000a')||
'      v_fehl';

p:=p||'ertext := frgbg_s.holen_uebersetzung(3646,:FAS_SPRACHE_ID,'||unistr('\000a')||
'                            :P32_TEXT_ID_SUCHTEXT,:P32_SUCHTEXT)||'' ''||SQLERRM;'||unistr('\000a')||
'      mel.p(v_fehlertext,v_prot_id,''Fehler'',''App118/32:gen_such_hilftext_id'');'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   IF :P32_TEXT_ID_SUCHTEXT is null THEN  -- Text neuangelegt'||unistr('\000a')||
'      :P32_TEXT_ID_SUCHTEXT := v_return;'||unistr('\000a')||
'      UPDATE f';

p:=p||'ragen'||unistr('\000a')||
'      SET TEXT_ID_SUCHTEXT = :P32_TEXT_ID_SUCHTEXT'||unistr('\000a')||
'      WHERE id = :p32_id;'||unistr('\000a')||
'   ELSIF :P32_TEXT_ID_SUCHTEXT is not null THEN --Text da +oben geändert od.soll gelöscht werden'||unistr('\000a')||
'      IF :P32_SUCHTEXT is NULL THEN   -- Löschen des Textes'||unistr('\000a')||
'         UPDATE fragen'||unistr('\000a')||
'         SET TEXT_ID_SUCHTEXT = NULL'||unistr('\000a')||
'         WHERE id = :p32_id;'||unistr('\000a')||
'         /* -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallb';

p:=p||'ack         '||unistr('\000a')||
'         DELETE uebersetzungen'||unistr('\000a')||
'         WHERE text_id = :P32_TEXT_ID_SUCHTEXT;'||unistr('\000a')||
'         DELETE texte'||unistr('\000a')||
'         WHERE id = :P32_TEXT_ID_SUCHTEXT;'||unistr('\000a')||
'         */'||unistr('\000a')||
'mel.p(''step1 delete_text %1'',v_prot_id,''TEST'',''118/32:gen_such_hilfetext_id'',:P32_TEXT_ID_SUCHTEXT);'||unistr('\000a')||
''||unistr('\000a')||
'         uebersetzung.delete_text(p_id => :P32_TEXT_ID_SUCHTEXT);'||unistr('\000a')||
'         :P32_TEXT_ID_SUCHTEXT := NULL;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF';

p:=p||';'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5129121249439220 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 110,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'gen_such_hilfetext_id',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''CREATE'',''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_kurzbezeichnung fragen.kurzbezeichnung%TYPE;'||unistr('\000a')||
'   v_fantwort_normwert_id fantworten.fantwort_normwert_id%TYPE;'||unistr('\000a')||
'   v_normwert       fantwort_normwerte.normwert%TYPE;'||unistr('\000a')||
'   v_sort           fantwort_normwerte.sort%TYPE;'||unistr('\000a')||
'   v_version        fantwort_normwerte.version%TYPE;'||unistr('\000a')||
'   v_text_id        fantworten.text_id%TYPE; '||unistr('\000a')||
'   v_min_messwert_text_id_db   fantworten.min_messwert_text_id%TYPE; '||unistr('\000a')||
'   v_';

p:=p||'max_messwert_text_id_db   fantworten.max_messwert_text_id%TYPE; '||unistr('\000a')||
'   v_mutdat         varchar2(50);'||unistr('\000a')||
'   v_fehlertext     varchar2(2000);'||unistr('\000a')||
'   v_count          number;'||unistr('\000a')||
'   v_return         number;'||unistr('\000a')||
'   v_prot_id        number;'||unistr('\000a')||
'   --v_sprache_id     number := :fas_sprache_id;'||unistr('\000a')||
'   v_zahl           number;'||unistr('\000a')||
'   v_anz            number;'||unistr('\000a')||
'   v_min            number;'||unistr('\000a')||
'   v_max            number;'||unistr('\000a')||
'   v_fehler         ';

p:=p||'exception;'||unistr('\000a')||
'begin'||unistr('\000a')||
'/* Doku:'||unistr('\000a')||
'   ,apex_application.g_f20(v_count)        -- id fantworten'||unistr('\000a')||
'   ,apex_application.g_f21(v_count)        -- formatmask '||unistr('\000a')||
'   ,apex_application.g_f22(v_count)        -- min_wert'||unistr('\000a')||
'   ,apex_application.g_f23(v_count)        -- max_wert'||unistr('\000a')||
'   --,apex_application.g_f24(v_count)        -- formatmask Eingabe !!!!entfällt => inh_eh_disp '||unistr('\000a')||
''||unistr('\000a')||
'*/'||unistr('\000a')||
'   IF :p32_fehlertext IS NOT NULL THEN'||unistr('\000a')||
'      R';

p:=p||'AISE_APPLICATION_ERROR (-20000,:p32_fehlertext);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Prüfen, ob Rezept zwischenzeitlich geändert wurde'||unistr('\000a')||
'   SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'   FROM fragen'||unistr('\000a')||
'   WHERE  id = :p32_id;'||unistr('\000a')||
'   IF v_mutdat != :p32_mutdat THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,:fas_sprache_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'--MEL.P(''Antworten  speichern 1 Nr %1'',v_pro';

p:=p||'t_id,''Info'',''Antworten speichern'',apex_application.g_f20.count);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Details speichern'||unistr('\000a')||
'   for i in 1..apex_application.g_f20.count'||unistr('\000a')||
'   loop '||unistr('\000a')||
'/*MEL.P(''Antworten speichern 2 f20 %1, f21 %2, f22 %3,f23 %4,  ANz: %6'','||unistr('\000a')||
'           v_prot_id,''Info'',''Fantworten 118/32 speichern'','||unistr('\000a')||
'           apex_application.g_f20(i),apex_application.g_f21(i),apex_application.g_f22(i),'||unistr('\000a')||
'           apex_application.g_f23(i';

p:=p||'),to_char(i));'||unistr('\000a')||
'*/'||unistr('\000a')||
'     Begin'||unistr('\000a')||
'        IF APEX_APPLICATION.G_F19(1) = 5 THEN -- Textfeld/Labor-Werteingabe'||unistr('\000a')||
'           -- Normierungsbereich verkleinert/vergrössert?'||unistr('\000a')||
'           SELECT count(*), min(wert1),max(wert2) into v_anz, v_min, v_max'||unistr('\000a')||
'           FROM fantwort_normwerte'||unistr('\000a')||
'           WHERE frage_id = APEX_APPLICATION.G_F18(i)'||unistr('\000a')||
'             and satz_kennzeichen is null;'||unistr('\000a')||
'--MEL.P(''Fantworten speichern ';

p:=p||'3 v_anz=%1,frage %2,max_norm %3,max %4'',v_prot_id,''Info'',''Fantworten 118/32 speichern'',v_anz,APEX_APPLICATION.G_F18(i),v_max,APEX_APPLICATION.G_F23(i));'||unistr('\000a')||
'           IF v_anz > 0 THEN'||unistr('\000a')||
'              IF APEX_APPLICATION.G_F22(i) > v_min OR APEX_APPLICATION.G_F23(i) < v_max THEN '||unistr('\000a')||
'                 -- Normierungsbereich verkleinert => Fehler'||unistr('\000a')||
'                 v_fehlertext := frgbg_s.holen_uebersetzung(361';

p:=p||'3,:fas_sprache_id);'||unistr('\000a')||
'                 RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'                 /* Normierung neu festlegen nur wenn bisher keine Patientenantwort vorhanden'||unistr('\000a')||
'                 UPDATE fantwort_normwerte '||unistr('\000a')||
'                 SET satz_kennzeichen = ''Normierungsbereich verkleinert => gelöscht durch (''|| '||unistr('\000a')||
'                                   p_app_user||'' am ''||to_char(sysdate,''DD.MM.YYY';

p:=p||'Y hh24:mi'')||'')'''||unistr('\000a')||
'                 WHERE frage_id = APEX_APPLICATION.G_F18(i)'||unistr('\000a')||
'                   and satz_kennzeichen is null;  '||unistr('\000a')||
'                 -- Auswertung löschen'||unistr('\000a')||
'                 UPDATE fauswertung_antworten'||unistr('\000a')||
'                 SET satz_kennzeichen = ''Normierungsbereich verkleinert => gelöscht durch (''|| '||unistr('\000a')||
'                                   p_app_user||'' am ''||to_char(sysdate,''DD.MM.YYYY hh24:mi''';

p:=p||')||'')'''||unistr('\000a')||
'                 WHERE fantwort_normwert_id in ( SELECT id '||unistr('\000a')||
'                            FROM fantwort_normwerte'||unistr('\000a')||
'                            WHERE frage_id = APEX_APPLICATION.G_F18(i)'||unistr('\000a')||
'                              and satz_kennzeichen is null;'||unistr('\000a')||
'                          );'||unistr('\000a')||
'                 */            '||unistr('\000a')||
'              END IF;   '||unistr('\000a')||
'              -- Falls Normierungsbereich erweitert wurde => Nor';

p:=p||'mierungsgrenzen aktualisieren'||unistr('\000a')||
'              IF APEX_APPLICATION.G_F22(i) < v_min THEN '||unistr('\000a')||
'                 UPDATE fantwort_normwerte '||unistr('\000a')||
'                 SET  wert1 = APEX_APPLICATION.G_F22(i)'||unistr('\000a')||
'                 WHERE frage_id = APEX_APPLICATION.G_F18(i) '||unistr('\000a')||
'                   AND wert1 = v_min'||unistr('\000a')||
'                   and satz_kennzeichen is null;'||unistr('\000a')||
'              END IF; '||unistr('\000a')||
'              IF APEX_APPLICATION.G_F23(i) ';

p:=p||'> v_max THEN     '||unistr('\000a')||
'                 UPDATE fantwort_normwerte '||unistr('\000a')||
'                 SET  wert2 = APEX_APPLICATION.G_F23(i)'||unistr('\000a')||
'                 WHERE frage_id = APEX_APPLICATION.G_F18(i) '||unistr('\000a')||
'                   AND wert2 = v_max'||unistr('\000a')||
'                   and satz_kennzeichen is null;'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'           END IF;'||unistr('\000a')||
''||unistr('\000a')||
'           -- Messwerttexte verwalten'||unistr('\000a')||
'           SELECT min(min_messwert_text_id),min(max_mes';

p:=p||'swert_text_id)   --wg. nodatafound'||unistr('\000a')||
'           INTO v_min_messwert_text_id_db,v_max_messwert_text_id_db'||unistr('\000a')||
'           from fantworten'||unistr('\000a')||
'           WHERE id =apex_application.g_f20(i); '||unistr('\000a')||
'           IF v_min_messwert_text_id_db is null AND '||unistr('\000a')||
'              apex_application.g_f27(i) is not null AND apex_application.g_f26(i) is not null '||unistr('\000a')||
'           THEN'||unistr('\000a')||
'              -- Neuer Text'||unistr('\000a')||
'              v_return := ueb';

p:=p||'ersetzung.admin_basistext(NULL,APEX_APPLICATION.G_F27(i),10,10);'||unistr('\000a')||
'              IF NVL(v_return,0) <= 0 THEN'||unistr('\000a')||
'                 -- Text kann nicht angelegt werden'||unistr('\000a')||
'                 v_fehlertext := frgbg_s.holen_uebersetzung('||unistr('\000a')||
'                                  3646,:fas_SPRACHE_ID,NULL,APEX_APPLICATION.G_F27(i));  '||unistr('\000a')||
'                 RAISE v_fehler;  '||unistr('\000a')||
'              ELSE                    '||unistr('\000a')||
'               ';

p:=p||'  apex_application.g_f27(i) := v_return;'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'           END IF;'||unistr('\000a')||
'           IF v_max_messwert_text_id_db is null AND '||unistr('\000a')||
'              apex_application.g_f29(i) is not null and apex_application.g_f28(i) is not null '||unistr('\000a')||
'           THEN'||unistr('\000a')||
'              -- Neuer Text'||unistr('\000a')||
'              v_return := uebersetzung.admin_basistext(NULL,APEX_APPLICATION.G_F29(i),10,10);'||unistr('\000a')||
'              IF NVL(v_return,0)';

p:=p||' <= 0 THEN'||unistr('\000a')||
'                 -- Text kann nicht angelegt werden'||unistr('\000a')||
'                 v_fehlertext := frgbg_s.holen_uebersetzung('||unistr('\000a')||
'                                         3646,:fas_SPRACHE_ID,NULL,APEX_APPLICATION.G_F29(i));'||unistr('\000a')||
'                 RAISE v_fehler;'||unistr('\000a')||
'              ELSE'||unistr('\000a')||
'                 apex_application.g_f29(i) := v_return;'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'           END IF; '||unistr('\000a')||
'   '||unistr('\000a')||
'           IF apex_applicat';

p:=p||'ion.g_f20(i) is NULL THEN -- Neuer Satz'||unistr('\000a')||
'              SELECT kurzbezeichnung INTO v_kurzbezeichnung '||unistr('\000a')||
'              FROM fragen '||unistr('\000a')||
'              WHERE id = APEX_APPLICATION.G_F18(i);'||unistr('\000a')||
'--MEL.P(''Fantworten speichern 4 v_anz=%1,frage %2,bez %3, %4'',v_prot_id,''Info'',''Fantworten 118/32 speichern'',v_anz,APEX_APPLICATION.G_F18(i),v_kurzbezeichnung);'||unistr('\000a')||
'              INSERT INTO fantworten (frage_id, sort,bemerk';

p:=p||'ung,flag,'||unistr('\000a')||
'                                      formatmask, '||unistr('\000a')||
'                                      -- formatmask_1,NEI 16.11.10 Formatmask Eingabe=> inh_eh_disp '||unistr('\000a')||
'                                      min_wert, max_wert,normierungstyp,'||unistr('\000a')||
'                                      min_messwert,min_messwert_text_id,'||unistr('\000a')||
'                                      max_messwert,max_messwert_text_id)'||unistr('\000a')||
'              VALUE';

p:=p||'S (APEX_APPLICATION.G_F18(i),1,v_kurzbezeichnung,''NUM1'','||unistr('\000a')||
'                      apex_application.g_f21(i), '||unistr('\000a')||
'                      -- apex_application.g_f24(i),NEI 16.11.10 Formatmask Eingabe => inh_eh_disp'||unistr('\000a')||
'                      apex_application.g_f22(i),apex_application.g_f23(i),''BEREICH'','||unistr('\000a')||
'                      apex_application.g_f26(i),apex_application.g_f27(i),'||unistr('\000a')||
'                      apex_applicat';

p:=p||'ion.g_f28(i),apex_application.g_f29(i)'||unistr('\000a')||
'                     );'||unistr('\000a')||
'              /* geändert jetzt extra Button'||unistr('\000a')||
'              -- 1. Normwertbereich festlegen'||unistr('\000a')||
'              INSERT INTO fantwort_normwerte ('||unistr('\000a')||
'                          FRAGE_ID,NORMWERT,BEZEICHNUNG,SORT,'||unistr('\000a')||
'                          WERT1,WERT2)'||unistr('\000a')||
'              VALUES (APEX_APPLICATION.G_F18(i),0,v_kurzbezeichnung||'':0'',10,'||unistr('\000a')||
'                    ';

p:=p||' apex_application.g_f22(i),apex_application.g_f23(i));'||unistr('\000a')||
'              */'||unistr('\000a')||
'           ELSE'||unistr('\000a')||
'              UPDATE fantworten'||unistr('\000a')||
'              SET formatmask = apex_application.g_f21(i),'||unistr('\000a')||
'                  --formatmask_1 = apex_application.g_f24(i),NEI 16.11.10 Formatmask Eingabe'||unistr('\000a')||
'                  min_wert   = apex_application.g_f22(i),'||unistr('\000a')||
'                  max_wert   = apex_application.g_f23(i),'||unistr('\000a')||
'             ';

p:=p||'     min_messwert = apex_application.g_f26(i),'||unistr('\000a')||
'                  min_messwert_text_id = apex_application.g_f27(i),'||unistr('\000a')||
'                  max_messwert = apex_application.g_f28(i),'||unistr('\000a')||
'                  max_messwert_text_id = apex_application.g_f29(i)'||unistr('\000a')||
'              WHERE id = apex_application.g_f20(i);'||unistr('\000a')||
'              -- evt. Messwert Texte löschen'||unistr('\000a')||
'              IF apex_application.g_f27(i) is null AND v_min_';

p:=p||'messwert_text_id_db is not null THEN'||unistr('\000a')||
'                 -- alter Text löschen, da kein Messwert  mehr'||unistr('\000a')||
'                 /* -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'                 DELETE FROM uebersetzungen WHERE text_id = v_min_messwert_text_id_db;'||unistr('\000a')||
'                 DELETE FROM texte where id = v_min_messwert_text_id_db;'||unistr('\000a')||
'                 */'||unistr('\000a')||
'                 uebersetzung.delete_';

p:=p||'text(p_id => v_min_messwert_text_id_db);'||unistr('\000a')||
'              END IF; '||unistr('\000a')||
'              IF apex_application.g_f29(i) is null AND v_max_messwert_text_id_db is not null THEN'||unistr('\000a')||
'                 -- alter Text löschen, da kein Messwert  mehr'||unistr('\000a')||
'                 /* -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'                 DELETE FROM uebersetzungen WHERE text_id = v_max_messwert_text_id_db;'||unistr('\000a')||
'     ';

p:=p||'            DELETE FROM texte where id = v_max_messwert_text_id_db;'||unistr('\000a')||
'                 */'||unistr('\000a')||
'                 uebersetzung.delete_text(p_id => v_max_messwert_text_id_db);'||unistr('\000a')||
'              END IF; '||unistr('\000a')||
'           END IF;'||unistr('\000a')||
'        ELSIF APEX_APPLICATION.G_F19(1) in (3,4) THEN -- Radio/LOV-Auswahl'||unistr('\000a')||
'           IF APEX_APPLICATION.G_F24(i) is not NULL THEN -- Text neu'||unistr('\000a')||
'              -- Text einfügen'||unistr('\000a')||
'              v_r';

p:=p||'eturn := uebersetzung.admin_basistext(NULL,APEX_APPLICATION.G_F24(i),10,10);'||unistr('\000a')||
'              IF v_return < 0 THEN'||unistr('\000a')||
'                 v_fehlertext := frgbg_s.holen_uebersetzung(3646,:fas_SPRACHE_ID,'||unistr('\000a')||
'                            NULL,APEX_APPLICATION.G_F24(i));'||unistr('\000a')||
'                 RAISE v_fehler;'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'              v_text_id := v_return;'||unistr('\000a')||
'           ELSE'||unistr('\000a')||
'              v_text_id := APEX_APPLI';

p:=p||'CATION.G_F21(i);'||unistr('\000a')||
'           END IF; '||unistr('\000a')||
'      '||unistr('\000a')||
'           IF APEX_APPLICATION.G_F20(i) is NULL THEN -- neue Antwort'||unistr('\000a')||
'              IF v_text_id IS NOT NULL THEN'||unistr('\000a')||
'                 -- Neuer Normwert erzeugen'||unistr('\000a')||
'                 select NVL(max(normwert),-1)+1,NVL(max(sort),0)+10,'||unistr('\000a')||
'                        frgbg_s.GET_FANORMW_akt_VERS(APEX_APPLICATION.G_F18(1))'||unistr('\000a')||
'                 into v_normwert, v_sort, v_versio';

p:=p||'n'||unistr('\000a')||
'                 from fantwort_normwerte'||unistr('\000a')||
'                 where frage_id = APEX_APPLICATION.G_F18(1)'||unistr('\000a')||
'                   and version=frgbg_s.GET_FANORMW_akt_VERS(APEX_APPLICATION.G_F18(1))'||unistr('\000a')||
'                   and satz_kennzeichen is null;'||unistr('\000a')||
'                 -- Falls neue Frage oder Frage ohne gültige Antwort => max(version)+1'||unistr('\000a')||
'                 IF v_version is null THEN'||unistr('\000a')||
'                    SELECT NVL(';

p:=p||'max(version),0) + 1 into v_version'||unistr('\000a')||
'                    FROM fantwort_normwerte'||unistr('\000a')||
'                    WHERE frage_id = APEX_APPLICATION.G_F18(1);'||unistr('\000a')||
'                 END IF;'||unistr('\000a')||
'                 SELECT kurzbezeichnung INTO v_kurzbezeichnung '||unistr('\000a')||
'                 FROM fragen '||unistr('\000a')||
'                 WHERE id = APEX_APPLICATION.G_F18(i);'||unistr('\000a')||
'                 /* -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'';

p:=p||'                 SELECT v_kurzbezeichnung||'': ''||text into v_kurzbezeichnung'||unistr('\000a')||
'                 FROM uebersetzungen'||unistr('\000a')||
'                 WHERE text_id = v_text_id'||unistr('\000a')||
'                   and sprache_id = v_sprache_id;'||unistr('\000a')||
'                 */'||unistr('\000a')||
'                 v_kurzbezeichnung := frgbg_s.HOLEN_UEBERSETZUNG(v_text_id,:fas_basissprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'                 select fant_norm_seq.nextval into v_fantwort_normwert_id ';

p:=p||'from dual;'||unistr('\000a')||
'                 v_fantwort_normwert_id := frgbg_s.fb_gen_id_seq(v_fantwort_normwert_id,'||unistr('\000a')||
'                                                                 APEX_APPLICATION.G_F18(1));'||unistr('\000a')||
'                 IF v_fantwort_normwert_id < 0 THEN'||unistr('\000a')||
'                    v_fehlertext := ''Fehler: Die neue ID konnte nicht generiert werden! ''; '||unistr('\000a')||
'                    RAISE v_fehler;'||unistr('\000a')||
'                 END IF;'||unistr('\000a')||
'  ';

p:=p||'               INSERT INTO fantwort_normwerte ( id,'||unistr('\000a')||
'                                                FRAGE_ID,'||unistr('\000a')||
'                                                NORMWERT ,'||unistr('\000a')||
'                                                BEZEICHNUNG ,'||unistr('\000a')||
'                                                VERSION ,'||unistr('\000a')||
'                                                SORT)'||unistr('\000a')||
'                 VALUES (v_fantwort_normwert_id,'||unistr('\000a')||
'        ';

p:=p||'                 APEX_APPLICATION.G_F18(1),v_normwert,v_kurzbezeichnung,v_version,v_sort);'||unistr('\000a')||
'                 '||unistr('\000a')||
'                 /*SELECT id INTO v_fantwort_normwert_id'||unistr('\000a')||
'                 FROM fantwort_normwerte'||unistr('\000a')||
'                 WHERE frage_id = APEX_APPLICATION.G_F18(1)'||unistr('\000a')||
'                   and version = v_version'||unistr('\000a')||
'                   and sort = v_sort'||unistr('\000a')||
'                   and normwert = v_normwert '||unistr('\000a')||
'       ';

p:=p||'            and satz_kennzeichen is null;'||unistr('\000a')||
'                 */'||unistr('\000a')||
''||unistr('\000a')||
'                 INSERT INTO fantworten (frage_id, text_id, sort, bemerkung, '||unistr('\000a')||
'                                         normierungstyp,fantwort_normwert_id)'||unistr('\000a')||
'                 VALUES (APEX_APPLICATION.G_F18(1),  -- frage_id'||unistr('\000a')||
'                         v_text_id,'||unistr('\000a')||
'                         APEX_APPLICATION.G_F25(i),  -- sort,'||unistr('\000a')||
'                  ';

p:=p||'       v_kurzbezeichnung,'||unistr('\000a')||
'                         ''DIREKT'','||unistr('\000a')||
'                         v_fantwort_normwert_id);'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'           ELSE -- Antwort korrigieren'||unistr('\000a')||
'              IF v_text_id IS NOT NULL THEN'||unistr('\000a')||
'                 -- Bezeichnung korrekt setzen'||unistr('\000a')||
'                 SELECT kurzbezeichnung INTO v_kurzbezeichnung '||unistr('\000a')||
'                 FROM fragen '||unistr('\000a')||
'                 WHERE id = APEX_APPLICATIO';

p:=p||'N.G_F18(i);'||unistr('\000a')||
'                 /* -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback '||unistr('\000a')||
'                 SELECT v_kurzbezeichnung||'': ''||text into v_kurzbezeichnung'||unistr('\000a')||
'                 FROM uebersetzungen'||unistr('\000a')||
'                 WHERE text_id = v_text_id'||unistr('\000a')||
'                   and sprache_id = v_sprache_id;'||unistr('\000a')||
'                 */'||unistr('\000a')||
'                 v_kurzbezeichnung := frgbg_s.HOLEN_UEBERSETZUNG(v_text_id,:f';

p:=p||'as_basissprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'                 -- Antwort ändern'||unistr('\000a')||
'                 UPDATE fantworten '||unistr('\000a')||
'                 SET sort = APEX_APPLICATION.G_F25(i),'||unistr('\000a')||
'                     bemerkung = v_kurzbezeichnung,'||unistr('\000a')||
'                     text_id = v_text_id'||unistr('\000a')||
'                 WHERE id = APEX_APPLICATION.G_F20(i);'||unistr('\000a')||
'                 -- Normwertbezeichnung anpassen'||unistr('\000a')||
'                 SELECT min(fa.fantwort_normwert_id ) i';

p:=p||'nto v_fantwort_normwert_id'||unistr('\000a')||
'                 FROM fantworten fa'||unistr('\000a')||
'                 WHERE id = APEX_APPLICATION.G_F20(i);'||unistr('\000a')||
'                 UPDATE fantwort_normwerte'||unistr('\000a')||
'                 SET bezeichnung = v_kurzbezeichnung'||unistr('\000a')||
'                 WHERE id = v_fantwort_normwert_id;'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'           END IF;        '||unistr('\000a')||
'        END IF;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN v_fehler THEN'||unistr('\000a')||
'          v_fehlertext := fr';

p:=p||'gbg_s.holen_uebersetzung(487,:fas_sprache_id)||'': ''||v_fehlertext;'||unistr('\000a')||
'          RAISE_APPLICATION_ERROR (-20003,v_fehlertext );'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'          v_fehlertext := frgbg_s.holen_uebersetzung(487,:fas_sprache_id)||'': ''||SQLERRM;'||unistr('\000a')||
'          RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'      END;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4730023630502729 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 120,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'antworten_speichern',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''ANT_SPEICHERN'',''NORMIEREN'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_version        fantwort_normwerte.version%TYPE;'||unistr('\000a')||
'   v_mutdat         varchar2(50);'||unistr('\000a')||
'   v_fehlertext     varchar2(2000);'||unistr('\000a')||
'   v_prot_id        number;'||unistr('\000a')||
'   v_sprache_id     number := :fas_sprache_id;'||unistr('\000a')||
'begin'||unistr('\000a')||
''||unistr('\000a')||
'   -- Prüfen, ob Rezept zwischenzeitlich geändert wurde'||unistr('\000a')||
'   SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'   FROM fragen'||unistr('\000a')||
'   WHERE  id = :p32_id;'||unistr('\000a')||
'   IF v_mutdat != :p32_mutda';

p:=p||'t THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'MEL.P(''Antworten  version 1 Nr %1'',v_prot_id,''Info'',''Antworten neue version'',apex_application.g_f20.count);'||unistr('\000a')||
'   Begin'||unistr('\000a')||
'         v_version := frgbg_s.GET_FANORMW_AKT_VERS (:p32_id);'||unistr('\000a')||
'         UPDATE fantwort_normwerte'||unistr('\000a')||
'         SET satz_kennzeichen=''GELOESCHT von ''||:APP_USER||'' am ''||to_char(sysdat';

p:=p||'e,''DD.MM.YYYY hh24:mi'')'||unistr('\000a')||
'         WHERE frage_id = :p32_id'||unistr('\000a')||
'           and version = v_version'||unistr('\000a')||
'           and satz_kennzeichen is null;'||unistr('\000a')||
'         UPDATE fantworten '||unistr('\000a')||
'         SET satz_kennzeichen = ''GELOESCHT von ''||:APP_USER||'' am ''||to_char(sysdate,''DD.MM.YYYY hh24:mi'')'||unistr('\000a')||
'         WHERE frage_id = :p32_id'||unistr('\000a')||
'           and satz_kennzeichen is null;'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN others THEN'||unistr('\000a')||
'       v_fehlertext := ';

p:=p||'frgbg_s.holen_uebersetzung(487,v_sprache_id)||'': ''||SQLERRM;'||unistr('\000a')||
'       RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'   END;'||unistr('\000a')||
' '||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5161313554607665 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 130,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'neue_antworten_version',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>5160903034595114 + wwv_flow_api.g_id_offset,
  p_process_when=>':p32_anzeigetyp_id in (3,4) /* Radio/LOV-Auswahl */'||unistr('\000a')||
'',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_kurzbezeichnung   fragen.kurzbezeichnung%TYPE;'||unistr('\000a')||
'   v_fehlertext        VARCHAR2(2000);'||unistr('\000a')||
'   v_sprache_id        NUMBER := :fas_sprache_id;'||unistr('\000a')||
'   v_prot_id           number;'||unistr('\000a')||
'   v_fehler            EXCEPTION;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT kurzbezeichnung INTO v_kurzbezeichnung '||unistr('\000a')||
'   FROM fragen '||unistr('\000a')||
'   WHERE id = :p32_id;'||unistr('\000a')||
''||unistr('\000a')||
'   -- 1. Normwertbereich festlegen'||unistr('\000a')||
'   INSERT INTO fantwort_normwerte ('||unistr('\000a')||
'          FRAGE_ID,';

p:=p||'NORMWERT,BEZEICHNUNG,SORT,WERT1,WERT2)'||unistr('\000a')||
'   VALUES (:p32_id,0,v_kurzbezeichnung||'':#0'',10,'||unistr('\000a')||
'           apex_application.g_f22(1),apex_application.g_f23(1)'||unistr('\000a')||
'           );'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN v_fehler THEN'||unistr('\000a')||
'     v_fehlertext := frgbg_s.holen_uebersetzung(487,v_sprache_id)||'': ''||v_fehlertext;'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20003,v_fehlertext );'||unistr('\000a')||
'WHEN others THEN'||unistr('\000a')||
'     v_fehlertext := frgbg_s.holen_uebersetzung(';

p:=p||'487,v_sprache_id)||'': ''||SQLERRM;'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 6361508334200185 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 140,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_erster_normbereich',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>6360630488130803 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_version     fantwort_normwerte.version%TYPE;'||unistr('\000a')||
'   v_version_neu fantwort_normwerte.version%TYPE;'||unistr('\000a')||
'   v_min_wert    fantwort_normwerte.wert1%TYPE;'||unistr('\000a')||
'   v_max_wert    fantwort_normwerte.wert2%TYPE;'||unistr('\000a')||
'   v_bezeichnung fantwort_normwerte.bezeichnung%TYPE;'||unistr('\000a')||
'   v_mutdat      varchar2(20);'||unistr('\000a')||
'   v_fehlertext  varchar2(2000);'||unistr('\000a')||
'   v_sprache_id  number := :fas_sprache_id;'||unistr('\000a')||
'   v_prot_id     number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   ';

p:=p||'-- Prüfen, ob Frage zwischenzeitlich geändert wurde'||unistr('\000a')||
'   SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'   FROM fragen'||unistr('\000a')||
'   WHERE  id = :p32_id;'||unistr('\000a')||
'   IF v_mutdat != :p32_mutdat THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      -- Höchste Fant_Normwert Version holen'||unistr('\000a')||
'      v_version := frgbg_s.GET_FANORMW_AKT_VERS (:p32_id);'||unistr('\000a')||
'';

p:=p||'      -- Aktuelle Version auf gelöscht setzen'||unistr('\000a')||
'      UPDATE fantwort_normwerte'||unistr('\000a')||
'      SET satz_kennzeichen=''GELOESCHT von ''||:APP_USER||'' am ''||to_char(sysdate,''DD.MM.YYYY hh24:mi'')'||unistr('\000a')||
'      WHERE frage_id = :p32_id'||unistr('\000a')||
'        and version = v_version'||unistr('\000a')||
'        and satz_kennzeichen is null;'||unistr('\000a')||
'      -- Werte neu bestimmen'||unistr('\000a')||
'      SELECT fa.min_wert, fa.max_wert,f.kurzbezeichnung into v_min_wert, v_max_wert, v_bez';

p:=p||'eichnung'||unistr('\000a')||
'      FROM fantworten fa, fragen f'||unistr('\000a')||
'      WHERE fa.frage_id = :p32_id'||unistr('\000a')||
'        and fa.frage_id = f.id'||unistr('\000a')||
'        and fa.satz_kennzeichen is null;'||unistr('\000a')||
'      SELECT max(version)+1 into v_version_neu'||unistr('\000a')||
'      FROM fantwort_normwerte '||unistr('\000a')||
'      WHERE frage_id = :p32_id;'||unistr('\000a')||
'      -- 1. Bereich der neuen Version festlegen'||unistr('\000a')||
'      INSERT INTO fantwort_normwerte ('||unistr('\000a')||
'               FRAGE_ID,NORMWERT,BEZEICHNUNG,SORT,WER';

p:=p||'T1,WERT2,version)'||unistr('\000a')||
'      VALUES (:p32_id,0,v_bezeichnung||'':0'',10,v_min_wert, v_max_wert,v_version_neu);'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN others THEN'||unistr('\000a')||
'       v_fehlertext := frgbg_s.holen_uebersetzung(487,v_sprache_id)||'': ''||SQLERRM;'||unistr('\000a')||
'       RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'   END;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5135908516285326 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 150,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'neue_normwert_version',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>4699602407385304 + wwv_flow_api.g_id_offset,
  p_process_when=>':p32_anzeigetyp_id in (5)  /* Textfeld/Labor-Werteingabe */',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_version   NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   /*   Sollte nur übergangsweise zur Ersterfassung benutzt werden, sonst sollte die Funktion'||unistr('\000a')||
'        neue Version der Normwerte benutzt werden; wg. Referenzierung in bereits vorhandenen'||unistr('\000a')||
'        persantworten'||unistr('\000a')||
'   */'||unistr('\000a')||
'   v_version := frgbg_s.GET_FANORMW_AKT_VERS (:p32_id);'||unistr('\000a')||
'   DELETE fantwort_normwerte'||unistr('\000a')||
'   WHERE frage_id = :p32_id'||unistr('\000a')||
'     and version = v_version'||unistr('\000a')||
'     a';

p:=p||'nd satz_kennzeichen is null;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4940130502979882 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 155,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'normwerte_löschen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_when_button_id=>4940800991065970 + wwv_flow_api.g_id_offset,
  p_only_for_changed_rows=> 'Y',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_wert1           fantwort_normwerte.wert1%TYPE;'||unistr('\000a')||
'   v_normwert        fantwort_normwerte.normwert%TYPE;'||unistr('\000a')||
'   v_sort_db         fantwort_normwerte.sort%TYPE;'||unistr('\000a')||
'   v_bezeichnung_db  fantwort_normwerte.bezeichnung%TYPE;'||unistr('\000a')||
'   v_frage_kurzbez   fragen.kurzbezeichnung%TYPE;'||unistr('\000a')||
'   v_version_db      fantwort_normwerte.version%TYPE;'||unistr('\000a')||
'   v_version_db_meta fantwort_normwerte.version%TYPE;'||unistr('\000a')||
'   v_fragelevel   ';

p:=p||'   fragen.fragelevel%TYPE;'||unistr('\000a')||
'   v_fragelevel_meta fragen.fragelevel%TYPE;'||unistr('\000a')||
'   v_drucktyp        fragen.drucktyp%TYPE;'||unistr('\000a')||
'   v_norm_bez        normierungsklassen.bezeichnung%TYPE;'||unistr('\000a')||
'   v_fragetext_id    texte.id%type;'||unistr('\000a')||
'   v_mutdat          varchar2(20);'||unistr('\000a')||
'   v_sort            number;'||unistr('\000a')||
'   v_last            number;'||unistr('\000a')||
'   v_anz             number;'||unistr('\000a')||
'   v_frage_id        number;'||unistr('\000a')||
'   v_id              number;'||unistr('\000a')||
'   v_return';

p:=p||'          number;'||unistr('\000a')||
'   v_fehlertext      varchar2(2000);'||unistr('\000a')||
'   v_fehler          exception;'||unistr('\000a')||
'   v_sprache_id      number := :fas_sprache_id;'||unistr('\000a')||
'   v_prot_id         number;      '||unistr('\000a')||
'/* Doku:                                Texteingabe               '||unistr('\000a')||
'   ,apex_application.g_f18(1)        -- frage_id '||unistr('\000a')||
'   ,apex_application.g_f19(1)        -- anzeigetyp_id '||unistr('\000a')||
'   ,apex_application.g_f20(1)        -- id fantworten'||unistr('\000a')||
'   ,';

p:=p||'apex_application.g_f21(1)        -- formatmask               '||unistr('\000a')||
'   ,apex_application.g_f22(1)        -- min_wert                '||unistr('\000a')||
'   ,apex_application.g_f23(1)        -- max_wert                '||unistr('\000a')||
'Fantwort_normwerte - Tabelle'||unistr('\000a')||
'   ,apex_application.g_f31(i)        -- fantwort_normwert.id'||unistr('\000a')||
'   ,apex_application.g_f32(i)        -- fantwort_normwert.wert2'||unistr('\000a')||
'   ,apex_application.g_f33(i)        -- fantwort_normw';

p:=p||'ert.normwert'||unistr('\000a')||
'   ,apex_application.g_f34(i)        -- fantwort_normwert.bezeichnung'||unistr('\000a')||
''||unistr('\000a')||
'*/ '||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Normwerte speichern 1 i=%1'',v_prot_id,''Info'',''118,p32/normwerte_speichern'',apex_application.g_f31.count);'||unistr('\000a')||
''||unistr('\000a')||
'   IF :p32_fehlertext IS NOT NULL THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,:p32_fehlertext);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Prüfen, ob Rezept zwischenzeitlich geändert wurde; per DB-Trigger wird fragen';

p:=p||'.mutdat geändert '||unistr('\000a')||
'   SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'   FROM fragen'||unistr('\000a')||
'   WHERE  id = :p32_id;'||unistr('\000a')||
'   IF v_mutdat != :p32_mutdat THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   '||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      -- Frageninfo holen'||unistr('\000a')||
'      SELECT f.fragelevel,f.drucktyp,f.kurzbezeichnung'||unistr('\000a')||
'      into  v_fragelevel,v_drucktyp,v_frage_kurzbez'||unistr('\000a')||
'  ';

p:=p||'    FROM fragen f'||unistr('\000a')||
'      WHERE id = :p32_id;'||unistr('\000a')||
''||unistr('\000a')||
'      -- Details speichern: '||unistr('\000a')||
'      -- Änderung der Bezeichnung generell möglich'||unistr('\000a')||
'      -- Bezeichnung für alle Sätze ohne letzten speichern'||unistr('\000a')||
'      v_last := apex_application.g_f31.count;'||unistr('\000a')||
'      FOR i in 1..apex_application.g_f31.count LOOP'||unistr('\000a')||
'          IF i < v_last  THEN -- letzter Satz wird nachfolgend gesondert verarbeitet'||unistr('\000a')||
'             v_bezeichnung_db := ';

p:=p||' '||unistr('\000a')||
'                   NVL(substr(APEX_APPLICATION.G_F34(i),1,'||unistr('\000a')||
'                              instr(APEX_APPLICATION.G_F34(i),'':#'',-1)-1)'||unistr('\000a')||
'                       ,APEX_APPLICATION.G_F34(i))||'':#'';'||unistr('\000a')||
'             IF v_drucktyp = 1 THEN -- Balkengrafik'||unistr('\000a')||
'                SELECT bezeichnung into v_norm_bez'||unistr('\000a')||
'                from normierungsklassen'||unistr('\000a')||
'                WHERE teilbereich = APEX_APPLICATION.G_F33(i);'||unistr('\000a')||
' ';

p:=p||'            ELSE'||unistr('\000a')||
'                v_norm_bez := '''';'||unistr('\000a')||
'             END IF;'||unistr('\000a')||
'             UPDATE fantwort_normwerte'||unistr('\000a')||
'             SET bezeichnung = v_bezeichnung_db||'' ''||v_norm_bez||APEX_APPLICATION.G_F33(i)'||unistr('\000a')||
'             WHERE id = APEX_APPLICATION.G_F31(i);             '||unistr('\000a')||
'          END IF;'||unistr('\000a')||
'      END LOOP;'||unistr('\000a')||
'      -- Änderungen bzgl. Normwert nur im letzten Satz möglich'||unistr('\000a')||
'      -- Änderungen des letzten Satz';

p:=p||'es speichern'||unistr('\000a')||
'      IF APEX_APPLICATION.G_F31.EXISTS(v_last) THEN'||unistr('\000a')||
'        SELECT fan.sort,'||unistr('\000a')||
'               --NVL(substr(fan.bezeichnung,1,instr(fan.bezeichnung,'':'',-1)),fan.bezeichnung||'':''),'||unistr('\000a')||
'               fan.version'||unistr('\000a')||
'               --,f.kurzbezeichnung,f.fragelevel,f.drucktyp'||unistr('\000a')||
'        into  v_sort_db,/*v_bezeichnung_db,*/v_version_db --,v_frage_kurzbez,v_fragelevel,v_drucktyp'||unistr('\000a')||
'        FROM fantwort_';

p:=p||'normwerte fan, fragen f'||unistr('\000a')||
'        WHERE fan.id = APEX_APPLICATION.G_F31(v_last)'||unistr('\000a')||
'          AND fan.frage_id = f.id;'||unistr('\000a')||
''||unistr('\000a')||
'        v_bezeichnung_db:= '||unistr('\000a')||
'          NVL(substr(APEX_APPLICATION.G_F34(v_last),1,instr(APEX_APPLICATION.G_F34(v_last),'':#'',-1)-1)'||unistr('\000a')||
'               ,APEX_APPLICATION.G_F34(v_last))||'':#'';'||unistr('\000a')||
''||unistr('\000a')||
'        IF v_drucktyp = 1 THEN -- Balkengrafik'||unistr('\000a')||
'           SELECT bezeichnung into v_norm_bez'||unistr('\000a')||
'      ';

p:=p||'     from normierungsklassen'||unistr('\000a')||
'           WHERE teilbereich = APEX_APPLICATION.G_F33(v_last);'||unistr('\000a')||
'        ELSE'||unistr('\000a')||
'           v_norm_bez := '''';'||unistr('\000a')||
'        END IF;'||unistr('\000a')||
''||unistr('\000a')||
'        UPDATE fantwort_normwerte'||unistr('\000a')||
'        SET wert2 = APEX_APPLICATION.G_F32(v_last),'||unistr('\000a')||
'            normwert = APEX_APPLICATION.G_F33(v_last),'||unistr('\000a')||
'            bezeichnung = v_bezeichnung_db||'' ''||v_norm_bez||APEX_APPLICATION.G_F33(v_last)'||unistr('\000a')||
'        WHERE id';

p:=p||' = APEX_APPLICATION.G_F31(v_last);'||unistr('\000a')||
'       '||unistr('\000a')||
'        IF to_number(APEX_APPLICATION.G_F32(v_last)) = to_number(apex_application.g_f23(1)) THEN'||unistr('\000a')||
'           -- Keine neue Zeile'||unistr('\000a')||
'           null;'||unistr('\000a')||
'        ELSE'||unistr('\000a')||
'--MEL.P(''Normwerte speichern 2 i=%1,normw %2,wert2 %3,drucktyp %4, frage %5'', v_prot_id,''Info'', ''118,p32/normwerte_speichern'',v_last,apex_application.g_f33(v_last),apex_application.g_f32(v_last),v_dr';

p:=p||'ucktyp,APEX_APPLICATION.G_F18(1));'||unistr('\000a')||
'           -- neuer Normwertbereich festlegen'||unistr('\000a')||
'           -- MIN-Wert für neuen Normwertbereich berechnen'||unistr('\000a')||
'           v_wert1 := frgbg_s.FBV_GET_NORM_WERT(APEX_APPLICATION.G_F32(v_last),'||unistr('\000a')||
'                                                APEX_APPLICATION.G_F21(1));'||unistr('\000a')||
'           IF v_drucktyp = 1 THEN  -- Balkengrafik'||unistr('\000a')||
'--MEL.P(''Normwerte speichern 2a i=%1,normw %2,wert2 %';

p:=p||'3,drucktyp %4, frage %5'', v_prot_id,''Info'', ''118,p32/normwerte_speichern'',v_last,apex_application.g_f33(v_last),apex_application.g_f32(v_last),v_drucktyp,APEX_APPLICATION.G_F18(1));'||unistr('\000a')||
'              -- Normwert festlegen    '||unistr('\000a')||
'              select min(teilbereich) into v_normwert'||unistr('\000a')||
'              from normierungsklassen'||unistr('\000a')||
'              where teilbereich not in'||unistr('\000a')||
'                   (select normwert'||unistr('\000a')||
'           ';

p:=p||'         from fantwort_normwerte'||unistr('\000a')||
'                    where frage_id = APEX_APPLICATION.G_F18(1)'||unistr('\000a')||
'                      and version=v_version_db '||unistr('\000a')||
'                      and satz_kennzeichen is null'||unistr('\000a')||
'                   )'||unistr('\000a')||
'                and bereich not in ('||unistr('\000a')||
'                                 select bereich'||unistr('\000a')||
'                                 from fantwort_normwerte fan, normierungsklassen n'||unistr('\000a')||
'                ';

p:=p||'                 where fan.normwert = n.teilbereich'||unistr('\000a')||
'                                   and frage_id = APEX_APPLICATION.G_F18(1)'||unistr('\000a')||
'                                   and fan.sort in '||unistr('\000a')||
'                                        (select max(sort) '||unistr('\000a')||
'                                         from fantwort_normwerte '||unistr('\000a')||
'                                         where frage_id = APEX_APPLICATION.G_F18(1)'||unistr('\000a')||
'           ';

p:=p||'                                and version=v_version_db '||unistr('\000a')||
'                                           and satz_kennzeichen is null'||unistr('\000a')||
'                                        )'||unistr('\000a')||
'                                 ); '||unistr('\000a')||
'              SELECT bezeichnung into v_norm_bez'||unistr('\000a')||
'              from normierungsklassen'||unistr('\000a')||
'              WHERE teilbereich = v_normwert;      '||unistr('\000a')||
'           ELSE'||unistr('\000a')||
'--MEL.P(''Normwerte speichern 2b i=%1';

p:=p||',normw %2,wert2 %3,drucktyp %4, frage %5'', v_prot_id,''Info'', ''118,p32/normwerte_speichern'',v_last,apex_application.g_f33(v_last),apex_application.g_f32(v_last),v_drucktyp,APEX_APPLICATION.G_F18(1));'||unistr('\000a')||
'              v_norm_bez := NULL;'||unistr('\000a')||
'              select max(normwert) + 1 into v_normwert'||unistr('\000a')||
'              from fantwort_normwerte'||unistr('\000a')||
'              where frage_id = APEX_APPLICATION.G_F18(1)'||unistr('\000a')||
'                a';

p:=p||'nd version=v_version_db '||unistr('\000a')||
'                and satz_kennzeichen is null;'||unistr('\000a')||
'           END IF;         '||unistr('\000a')||
'--MEL.P(''Normwerte speichern 3 i=%1, normw %2, frage_id %3'', v_prot_id,''Info'',''118,p32/normwerte_speichern'',apex_application.g_f20.count,v_normwert,APEX_APPLICATION.G_F18(1));'||unistr('\000a')||
'           INSERT INTO fantwort_normwerte ('||unistr('\000a')||
'                       FRAGE_ID,NORMWERT,BEZEICHNUNG,SORT,'||unistr('\000a')||
'                      ';

p:=p||' WERT1,WERT2,version)'||unistr('\000a')||
'           VALUES (APEX_APPLICATION.G_F18(1),v_normwert,'||unistr('\000a')||
'                   v_bezeichnung_db||'' ''||v_norm_bez||v_normwert,v_sort_db+10,'||unistr('\000a')||
'                   v_wert1,apex_application.g_f23(1),v_version_db);'||unistr('\000a')||
'--MEL.P(''Normwerte speichern 4 i=%1, normw %2'',v_prot_id,''Info'',''118,p32/normwerte_speichern'',apex_application.g_f20.count,v_normwert);'||unistr('\000a')||
'        END IF;'||unistr('\000a')||
'/* NEI 10.07.13 Labork';

p:=p||'lassifikation zum Zusammenführen mehrere gleicher Teilbereiche wird nicht mehr benötigt'||unistr('\000a')||
'        -- Prüfen, ob Metafrage notwendig, wenn mehrere Teilbereiche eines Bereichs definiert sind'||unistr('\000a')||
'        select count(distinct bereich) into v_anz'||unistr('\000a')||
'        from normierungsklassen '||unistr('\000a')||
'        where bereich in ('||unistr('\000a')||
'               select bereich'||unistr('\000a')||
'               from fantwort_normwerte fan, normierungsklassen n'||unistr('\000a')||
'        ';

p:=p||'       where fan.frage_id = APEX_APPLICATION.G_F18(1)'||unistr('\000a')||
'                 and fan.satz_kennzeichen is null'||unistr('\000a')||
'                 and fan.version = v_version_db'||unistr('\000a')||
'                 and fan.normwert = n.TEILBEREICH'||unistr('\000a')||
'               group by n.bereich'||unistr('\000a')||
'               having count(*) >1)  ;      '||unistr('\000a')||
'        '||unistr('\000a')||
'        IF v_anz > 0 AND  -- nur falls mehr als ein Teilbereich für eine Normierungsklasse'||unistr('\000a')||
'           v_druckty';

p:=p||'p = 1 --nur bei Balkengrafik'||unistr('\000a')||
'        THEN  '||unistr('\000a')||
'           -- Prüfen, ob bereits eine Metafrage vorhanden ist'||unistr('\000a')||
'           SELECT count(*), min(frage_id_meta) into v_anz, v_frage_id'||unistr('\000a')||
'           FROM fragen_metadetails fmd, fragen f, fragen fmeta'||unistr('\000a')||
'           WHERE f.id = APEX_APPLICATION.G_F18(1) '||unistr('\000a')||
'             AND fmd.frage_id = f.id'||unistr('\000a')||
'             AND fmd.satz_kennzeichen is null'||unistr('\000a')||
'             AND f.satz_ken';

p:=p||'nzeichen is null'||unistr('\000a')||
'             AND fmd.param_pos = 1'||unistr('\000a')||
'             AND fmd.frage_id_meta = fmeta.id'||unistr('\000a')||
'             and fmeta.berechnungstyp = ''LABOR_KLASSIFIKATION'';'||unistr('\000a')||
'           IF v_anz = 0 THEN -- Metafrage/Antwort/Normierung anlegen'||unistr('\000a')||
'              select frage_seq.nextval into v_frage_id from dual;'||unistr('\000a')||
'              v_frage_id := frgbg_s.fb_gen_id_seq(v_frage_id,'||unistr('\000a')||
'                                         ';

p:=p||'      APEX_APPLICATION.G_F18(1));'||unistr('\000a')||
'              IF v_frage_id < 0 THEN'||unistr('\000a')||
'                 v_fehlertext := ''Fehler: Die neue ID konnte nicht generiert werden! ''; '||unistr('\000a')||
'                 RAISE v_fehler;'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'              -- Metafrage generieren'||unistr('\000a')||
'              SELECT nvl(max(sort),999) + 1 into v_sort'||unistr('\000a')||
'              FROM fragen'||unistr('\000a')||
'              WHERE fkategorie_id = :p32_fkategorie_id'||unistr('\000a')||
'          ';

p:=p||'      and fragelevel > 0;'||unistr('\000a')||
'              v_fragelevel_meta:= v_fragelevel+1;'||unistr('\000a')||
'              v_return := uebersetzung.admin_basistext(NULL,''MF''||v_fragelevel_meta||'': ''||v_frage_kurzbez,1,30);'||unistr('\000a')||
'              IF v_return < 0 THEN'||unistr('\000a')||
'                 v_fehlertext := frgbg_s.holen_uebersetzung(3646,v_SPRACHE_ID,'||unistr('\000a')||
'                            NULL,''MF''||v_fragelevel_meta||'': ''||v_frage_kurzbez);'||unistr('\000a')||
'              ';

p:=p||'   RAISE v_fehler ;'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'              v_fragetext_id := v_return;'||unistr('\000a')||
'              INSERT INTO fragen (id,SORT ,KURZBEZEICHNUNG ,BEMERKUNG , TEXT_ID ,'||unistr('\000a')||
'                               FKATEGORIE_ID ,TEXT_ID_FRAGETEXT ,ANZEIGETYP_ID ,drucktyp,'||unistr('\000a')||
'                               TEXTHOEHE ,TEXTBREITE ,EINGABEPFLICHTIG , FRAGELEVEL ,'||unistr('\000a')||
'                               BERECHNUNGSTYP)'||unistr('\000a')||
'           ';

p:=p||'             SELECT v_frage_id,v_sort ,''MF''||v_fragelevel_meta||'': ''||KURZBEZEICHNUNG ,'||unistr('\000a')||
'                               BEMERKUNG , NULL ,'||unistr('\000a')||
'                               FKATEGORIE_ID ,v_FRAGETEXT_id ,5 ,2,'||unistr('\000a')||
'                               1 ,8 ,0 , v_fragelevel_meta ,'||unistr('\000a')||
'                               ''LABOR_KLASSIFIKATION'''||unistr('\000a')||
'                        FROM fragen'||unistr('\000a')||
'                        WHERE id = APEX_APP';

p:=p||'LICATION.G_F18(1);'||unistr('\000a')||
'             -- Antwort generieren '||unistr('\000a')||
'             INSERT INTO fantworten '||unistr('\000a')||
'                    (frage_id, sort,bemerkung,flag,normierungstyp,min_wert,max_wert,formatmask'||unistr('\000a')||
'                                    --,formatmask_1 NEI 16.11.10 Formatmask Eingabe=> inh_eh_disp'||unistr('\000a')||
'                                    )    '||unistr('\000a')||
'             VALUES (v_frage_id,1,''MF''||v_fragelevel_meta||'': ''||v_frage_';

p:=p||'kurzbez,'||unistr('\000a')||
'                     ''NUM1'',''BEREICH'',0,99,99'||unistr('\000a')||
'                     -- ,99 NEI 16.11.10 Formatmask Eingabe=> inh_eh_disp'||unistr('\000a')||
'                    );'||unistr('\000a')||
'             -- Metafrage zur Basisfrage zuordnen'||unistr('\000a')||
'             INSERT INTO fragen_metadetails (frage_id_meta,frage_id,param_pos,bemerkung)'||unistr('\000a')||
'             VALUES (v_frage_id,APEX_APPLICATION.G_F18(1),1,''LABOR_KLASSIFIKATION: ''||v_frage_kurzbez);'||unistr('\000a')||
'     ';

p:=p||'      ELSIF v_anz = 1 THEN -- Normierung evt. ergänzen'||unistr('\000a')||
'              NULL;'||unistr('\000a')||
'           ELSE '||unistr('\000a')||
'              -- Fehler '||unistr('\000a')||
'              v_fehlertext := ''Fehler: Die Metrafrage konnte nicht generiert werden! ''; '||unistr('\000a')||
'              RAISE v_fehler;'||unistr('\000a')||
'           END IF;'||unistr('\000a')||
'           -- Normierungen eintragen/ergänzen'||unistr('\000a')||
'--MEL.P(''Normwerte speichern 5 i=%1, normw %2, meta frage %3'',v_prot_id,''Info'',''118,p32/normwerte_s';

p:=p||'peichern'',apex_application.g_f20.count,v_normwert, v_frage_id);'||unistr('\000a')||
'           v_version_db_meta := frgbg_s.GET_FANORMW_AKT_VERS(v_frage_id);'||unistr('\000a')||
'           INSERT INTO fantwort_normwerte ('||unistr('\000a')||
'                             NORMWERT,FRAGE_ID,BEZEICHNUNG,SORT,'||unistr('\000a')||
'                             WERT1,WERT2)'||unistr('\000a')||
'               SELECT distinct bereich,v_frage_id,'||unistr('\000a')||
'                     ''MF''||v_fragelevel_meta||'': ''||v_frage_';

p:=p||'kurzbez ||'':# ''||bezeichnung,'||unistr('\000a')||
'                     bereich,'||unistr('\000a')||
'                     bereich, bereich'||unistr('\000a')||
'               FROM normierungsklassen'||unistr('\000a')||
'               WHERE bereich not in '||unistr('\000a')||
'                          (-- Bereiche, die in fant_norm der Metafrage noch nicht vorkommen'||unistr('\000a')||
'                           SELECT normwert'||unistr('\000a')||
'                           FROM fantwort_normwerte'||unistr('\000a')||
'                           WHERE frage_i';

p:=p||'d = v_frage_id'||unistr('\000a')||
'                             and satz_kennzeichen is null'||unistr('\000a')||
'                             and version = v_version_db_meta'||unistr('\000a')||
'                           )'||unistr('\000a')||
'                 and bereich in -- nur Bereiche wozu es in der Basisfrage auch Teilbereiche gibt'||unistr('\000a')||
'                           (SELECT bereich  '||unistr('\000a')||
'                            FROM fantwort_normwerte,normierungsklassen'||unistr('\000a')||
'                        ';

p:=p||'    WHERE frage_id = APEX_APPLICATION.G_F18(1)'||unistr('\000a')||
'                              and satz_kennzeichen is null'||unistr('\000a')||
'                              and version = v_version_db'||unistr('\000a')||
'                              and normwert=teilbereich'||unistr('\000a')||
'                           );'||unistr('\000a')||
'--MEL.P(''Normwerte speichern 6 i=%1, normw %2'',v_prot_id,''Info'',''118,p32/normwerte_speichern'',apex_application.g_f20.count,v_normwert);'||unistr('\000a')||
'        END IF; ';

p:=p||'-- drucktyp=1 Metafrage wg. Normierungsklassen'||unistr('\000a')||
'*/'||unistr('\000a')||
'      END IF; -- Aenderungen im letzten Satz'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN v_fehler THEN'||unistr('\000a')||
'        v_fehlertext := frgbg_s.holen_uebersetzung(181,v_sprache_id,v_fehlertext,''118/32: normwerte_speichern'');'||unistr('\000a')||
'        mel.p(v_fehlertext,v_prot_id,''Fehler'',''118/32: normwerte_speichern'');'||unistr('\000a')||
'        RAISE_APPLICATION_ERROR (-20001,v_fehlertext );'||unistr('\000a')||
'   WHEN others THEN'||unistr('\000a')||
'   ';

p:=p||'     v_fehlertext := frgbg_s.holen_uebersetzung(181,v_sprache_id,SQLERRM,''118/32: normwerte_speichern'');'||unistr('\000a')||
'        mel.p(v_fehlertext,v_prot_id,''Fehler'',''118/32: normwerte_speichern'');'||unistr('\000a')||
'        RAISE_APPLICATION_ERROR (-20002,v_fehlertext );   '||unistr('\000a')||
'   END ;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5136614815466879 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 160,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'normwerte_speichern',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>4700013488388495 + wwv_flow_api.g_id_offset,
  p_process_when=>':P32_ANZEIGETYP_ID = 5  /*Textfeld/Labor-Werteingabe*/'||unistr('\000a')||
'',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_kurzbezeichnung fragen.kurzbezeichnung%TYPE;'||unistr('\000a')||
'   v_kurzbezeichnung_meta fragen.kurzbezeichnung%TYPE;'||unistr('\000a')||
'   v_param_pos      fragen_metadetails.param_pos%TYPE;'||unistr('\000a')||
'   v_mutdat         varchar2(50);'||unistr('\000a')||
'   v_fehlertext     varchar2(2000);'||unistr('\000a')||
'   v_prot_id        number;'||unistr('\000a')||
'   v_sprache_id     number := :fas_sprache_id;'||unistr('\000a')||
'   v_fehler         exception;'||unistr('\000a')||
'begin'||unistr('\000a')||
'/* Doku:'||unistr('\000a')||
'   ,apex_application.g_f40(v_count)      ';

p:=p||'  -- checkbox mit id'||unistr('\000a')||
'   ,apex_application.g_f41(v_count)        -- id metadetails'||unistr('\000a')||
'   ,apex_application.g_f42(v_count)        -- frage_id'||unistr('\000a')||
'   ,apex_application.g_f43(v_count)        -- param_pos'||unistr('\000a')||
'   ,apex_application.g_f44(v_count)        -- bemerkung'||unistr('\000a')||
'*/'||unistr('\000a')||
'   IF :p32_fehlertext IS NOT NULL THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,:p32_fehlertext);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Prüfen, ob Rezept zwischenzeitlich ';

p:=p||'geändert wurde'||unistr('\000a')||
'   SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'   FROM fragen'||unistr('\000a')||
'   WHERE  id = :p32_id;'||unistr('\000a')||
'   IF v_mutdat != :p32_mutdat THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'--MEL.P(''Metadetails speichern 1 Nr %1'',v_prot_id,''Info'',''Antworten speichern'',apex_application.g_f20.count);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Details speichern'||unistr('\000a')||
'   for i in 1..';

p:=p||'apex_application.g_f41.count'||unistr('\000a')||
'   loop '||unistr('\000a')||
'/*MEL.P(''Metadetails speichern 2 f41 %1, f42 %2, f43 %3,f44 %4, ANz: %5'','||unistr('\000a')||
'           v_prot_id,''Info'',''Fantworten 118/32 speichern'','||unistr('\000a')||
'           apex_application.g_f41(i),apex_application.g_f42(i),apex_application.g_f43(i),'||unistr('\000a')||
'           apex_application.g_f44(i),to_char(i));'||unistr('\000a')||
'*/'||unistr('\000a')||
'     Begin'||unistr('\000a')||
'           SELECT kurzbezeichnung INTO v_kurzbezeichnung_meta '||unistr('\000a')||
'           F';

p:=p||'ROM fragen '||unistr('\000a')||
'           WHERE id = :p32_id;'||unistr('\000a')||
'           SELECT min(kurzbezeichnung) INTO v_kurzbezeichnung '||unistr('\000a')||
'           FROM fragen'||unistr('\000a')||
'           WHERE id = apex_application.g_f42(i);'||unistr('\000a')||
'           IF apex_application.g_f41(i) is NULL THEN -- Neuer Satz'||unistr('\000a')||
'--MEL.P(''Metadetails speichern 4 v_anz=%1,id %2, %3, %4'',v_prot_id,''Info'',''Metadetails speichern'',v_anz,APEX_APPLICATION.G_F40(i));'||unistr('\000a')||
'              IF apex_a';

p:=p||'pplication.g_f42(i) is not NULL THEN'||unistr('\000a')||
'                 IF apex_application.g_f43(i) IS NULL THEN -- ParamPos bestimmen'||unistr('\000a')||
'                    SELECT NVL(MAX(param_pos)+1,1) INTO v_param_pos'||unistr('\000a')||
'                    FROM fragen_metadetails'||unistr('\000a')||
'                    WHERE frage_id_meta = :p32_id'||unistr('\000a')||
'                      AND satz_kennzeichen is null;'||unistr('\000a')||
'                 ELSE'||unistr('\000a')||
'                    v_param_pos := apex_applic';

p:=p||'ation.g_f43(i);'||unistr('\000a')||
'                 END IF;'||unistr('\000a')||
'                 INSERT INTO fragen_metadetails(FRAGE_ID_META,FRAGE_ID ,'||unistr('\000a')||
'                                                PARAM_POS ,BEMERKUNG )'||unistr('\000a')||
'                 VALUES (:p32_id,apex_application.g_f42(i),'||unistr('\000a')||
'                         v_param_pos,v_kurzbezeichnung_meta||'': ''||v_kurzbezeichnung);'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'           ELSE'||unistr('\000a')||
'              IF apex_applicat';

p:=p||'ion.g_f42(i) IS NOT NULL THEN'||unistr('\000a')||
'                 IF apex_application.g_f43(i) IS NULL THEN -- ParamPos bestimmen'||unistr('\000a')||
'                    SELECT NVL(MAX(param_pos)+1,1) INTO v_param_pos'||unistr('\000a')||
'                    FROM fragen_metadetails'||unistr('\000a')||
'                    WHERE frage_id_meta = :p32_id'||unistr('\000a')||
'                      AND satz_kennzeichen is null;'||unistr('\000a')||
'                 ELSE'||unistr('\000a')||
'                    v_param_pos := apex_application.g';

p:=p||'_f43(i);'||unistr('\000a')||
'                 END IF;'||unistr('\000a')||
'                 UPDATE fragen_metadetails'||unistr('\000a')||
'                 SET frage_id= apex_application.g_f42(i),'||unistr('\000a')||
'                     param_pos = v_param_pos,'||unistr('\000a')||
'                     bemerkung = v_kurzbezeichnung_meta||'': ''||v_kurzbezeichnung,'||unistr('\000a')||
'                     fantwort_id = apex_application.g_f44(i)'||unistr('\000a')||
'                 WHERE id = apex_application.g_f41(i);'||unistr('\000a')||
'              ELSE'||unistr('\000a')||
'  ';

p:=p||'               DELETE FROM fragen_metadetails'||unistr('\000a')||
'                 WHERE id = apex_application.g_f41(i);'||unistr('\000a')||
'              END IF;'||unistr('\000a')||
'           END IF;'||unistr('\000a')||
''||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN v_fehler THEN'||unistr('\000a')||
'          v_fehlertext := frgbg_s.holen_uebersetzung(487,v_sprache_id)||'': ''||v_fehlertext;'||unistr('\000a')||
'          RAISE_APPLICATION_ERROR (-20003,v_fehlertext );'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'          v_fehlertext := frgbg_s.holen_ueb';

p:=p||'ersetzung(487,v_sprache_id)||'': ''||SQLERRM;'||unistr('\000a')||
'          RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'      END;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5571225358957904 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 180,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'metadetails_speichern',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>5557100294779865 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'32';

wwv_flow_api.create_page_process(
  p_id     => 4692416816939879 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 400,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>4685629362939868 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'IF :p32_bezug_frage_id is null THEN'||unistr('\000a')||
'   :p32_zurueck_zur_seite := 30;'||unistr('\000a')||
'ELSE'||unistr('\000a')||
'   :p32_zurueck_zur_seite := 35;'||unistr('\000a')||
'END IF;';

wwv_flow_api.create_page_process(
  p_id     => 6549123651169848 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 5,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_page',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P33_HEIGHT_EHLISTE  := :FAS_SCROLLREGION_HEIGHT_MAX * 0.6;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5133518654226885 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 15,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_id                 fragen.id%TYPE;'||unistr('\000a')||
'   v_kurzbezeichnung    fragen.bemerkung%TYPE;'||unistr('\000a')||
'   v_fkategorie_id      fragen.fkategorie_id%TYPE;'||unistr('\000a')||
'   v_fragelevel         fragen.fragelevel%TYPE;'||unistr('\000a')||
'   v_sort               fragen.sort%TYPE;'||unistr('\000a')||
'   v_text_id_fragetext  fragen.text_id_fragetext%TYPE;'||unistr('\000a')||
'   v_text_id_fragetext_bezug  fragen.text_id_fragetext%TYPE;'||unistr('\000a')||
'   v_bezug_frage_id     fragen.id%TYPE;'||unistr('\000a')||
'   v_fb_';

p:=p||'nummer          NUMBER;'||unistr('\000a')||
'   v_fb_version         NUMBER;'||unistr('\000a')||
'   v_return             NUMBER;'||unistr('\000a')||
'   v_fehlertext         VARCHAR2(2000);'||unistr('\000a')||
'   v_fehlernummer       NUMBER;'||unistr('\000a')||
'   v_fehler             EXCEPTION;'||unistr('\000a')||
'   v_prot_id            number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--mel.p('':P32_KOMPLEX_META_FRAGE_ID=%1,%2'',v_prot_id,''TRACE'',''118/32:gen_metafrage'',:P32_KOMPLEX_META_FRAGE_ID,:request);'||unistr('\000a')||
'   IF :P32_KOMPLEX_META_FRAGE_ID is not null ';

p:=p||'THEN'||unistr('\000a')||
'      -- Fragenbezeichnung holen'||unistr('\000a')||
'      SELECT frgbg_s.holen_uebersetzung(f.text_id_fragetext,:fas_sprache_id)||''; ''|| '||unistr('\000a')||
'             frgbg_s.fbv_get_komp_mf_det(kmf.id),f.fkategorie_id,'||unistr('\000a')||
'             f.text_id_fragetext,kmf.bezug_frage_id'||unistr('\000a')||
'      INTO v_kurzbezeichnung , v_fkategorie_id,v_text_id_fragetext_bezug,v_bezug_frage_id '||unistr('\000a')||
'      FROM komplex_meta_fragen kmf, fragen f'||unistr('\000a')||
'      WHERE kmf.id = :';

p:=p||'P32_KOMPLEX_META_FRAGE_ID'||unistr('\000a')||
'        and kmf.bezug_frage_id = f.id;'||unistr('\000a')||
''||unistr('\000a')||
'      -- Level holen'||unistr('\000a')||
'      SELECT max(f.fragelevel) + 1 '||unistr('\000a')||
'      INTO v_fragelevel'||unistr('\000a')||
'      FROM komplex_meta_frage_details kmfd, fantwort_normwerte fan,fragen f'||unistr('\000a')||
'      WHERE kmfd.komplex_meta_frage_id = :P32_KOMPLEX_META_FRAGE_ID'||unistr('\000a')||
'        AND kmfd.fantwort_normwert_id = fan.id'||unistr('\000a')||
'        and fan.frage_id = f.id;'||unistr('\000a')||
''||unistr('\000a')||
'      -- Kurzbezeichnung erg';

p:=p||'aenzen'||unistr('\000a')||
'      v_kurzbezeichnung := ''MF''||v_fragelevel||'': ''||v_kurzbezeichnung;'||unistr('\000a')||
'      -- Sort holen'||unistr('\000a')||
'      SELECT CASE WHEN max(sort) is null AND v_fragelevel > 0 THEN 900'||unistr('\000a')||
'                  WHEN max(sort) is null AND v_fragelevel = 0 THEN 1'||unistr('\000a')||
'                  ELSE max(sort)+1'||unistr('\000a')||
'             END'||unistr('\000a')||
'      INTO v_sort'||unistr('\000a')||
'      FROM fragen'||unistr('\000a')||
'      WHERE fkategorie_id = v_fkategorie_id'||unistr('\000a')||
'        and ( (fragelevel = 0';

p:=p||' and v_fragelevel=0)'||unistr('\000a')||
'           OR (fragelevel > 0 and v_fragelevel>0)'||unistr('\000a')||
'            )'||unistr('\000a')||
'        and satz_kennzeichen is null'||unistr('\000a')||
'      ;'||unistr('\000a')||
''||unistr('\000a')||
'      -- Fragetext-ID generieren'||unistr('\000a')||
'      v_text_id_fragetext := uebersetzung.admin_basistext(NULL,v_kurzbezeichnung,1,30);'||unistr('\000a')||
''||unistr('\000a')||
'      -- FRAGE-ID erzeugen'||unistr('\000a')||
'     select frage_SEQ.nextval into v_id from dual;'||unistr('\000a')||
'     v_return := frgbg_s.FB_GET_VERS_NR(v_fkategorie_id,v_fb_nummer,v';

p:=p||'_fb_version);'||unistr('\000a')||
'     IF v_return < 0 THEN -- Fehler'||unistr('\000a')||
'        v_fehlertext := frgbg_s.holen_uebersetzung(1915,:fas_sprache_id,'||unistr('\000a')||
'                                                 frgbg_s.holen_uebersetzung(4269,:fas_sprache_id)||'||unistr('\000a')||
'                                                 ''(''||10||'')'');'||unistr('\000a')||
'        RAISE v_fehler;'||unistr('\000a')||
'     END IF;'||unistr('\000a')||
'     v_id := frgbg_s.FB_GEN_ID_VERS_NR(v_id,v_fb_version);'||unistr('\000a')||
'     IF v_id  < 0';

p:=p||' THEN -- Fehler'||unistr('\000a')||
'        v_fehlertext := frgbg_s.holen_uebersetzung(1915,:fas_sprache_id,'||unistr('\000a')||
'                                                 frgbg_s.holen_uebersetzung(4269,:fas_sprache_id)||'||unistr('\000a')||
'                                                 ''(''||20||'')'');'||unistr('\000a')||
'        RAISE v_fehler;'||unistr('\000a')||
'     END IF;'||unistr('\000a')||
''||unistr('\000a')||
'      -- Metafrage erzeugen'||unistr('\000a')||
'      INSERT INTO fragen (id,'||unistr('\000a')||
'                          SORT ,'||unistr('\000a')||
'                  ';

p:=p||'        KURZBEZEICHNUNG ,'||unistr('\000a')||
'                          FKATEGORIE_ID,'||unistr('\000a')||
'                          text_id_fragetext,'||unistr('\000a')||
'                          ANZEIGETYP_ID ,'||unistr('\000a')||
'                          drucktyp,'||unistr('\000a')||
'                          TEXTHOEHE,'||unistr('\000a')||
'                          TEXTBREITE,'||unistr('\000a')||
'                          EINGABEPFLICHTIG ,'||unistr('\000a')||
'                          FRAGELEVEL ,'||unistr('\000a')||
'                          BERECHNUNGSTYP '||unistr('\000a')||
'         ';

p:=p||'                )'||unistr('\000a')||
'      VALUES (            v_id,'||unistr('\000a')||
'                          v_sort,'||unistr('\000a')||
'                          v_KURZBEZEICHNUNG ,'||unistr('\000a')||
'                          v_FKATEGORIE_ID,'||unistr('\000a')||
'                          v_text_id_fragetext,'||unistr('\000a')||
'                          5, -- ANZEIGETYP_ID'||unistr('\000a')||
'                          1, -- Drucktyp (Balkengrafik)'||unistr('\000a')||
'                          1, -- TEXTHOEHE'||unistr('\000a')||
'                          10,-- TEXT';

p:=p||'BREITE,'||unistr('\000a')||
'                          0, -- EINGABEPFLICHTIG ,'||unistr('\000a')||
'                          v_FRAGELEVEL ,'||unistr('\000a')||
'                          ''SUM_WERTE'' --BERECHNUNGSTYP ,'||unistr('\000a')||
'                    );'||unistr('\000a')||
'      -- Metadetails generieren'||unistr('\000a')||
'      INSERT into fragen_metadetails (frage_id_meta,frage_id,param_pos,bemerkung)'||unistr('\000a')||
'      VALUES (v_id,v_bezug_frage_id,1,substr(v_kurzbezeichnung||'||unistr('\000a')||
'              '': ''||frgbg_s.holen_ueberse';

p:=p||'tzung(v_text_id_fragetext_bezug,:fas_sprache_id),1,2000));'||unistr('\000a')||
''||unistr('\000a')||
'      -- Referenz in Komplex_meta_fragen eintragen'||unistr('\000a')||
'      UPDATE komplex_meta_fragen'||unistr('\000a')||
'      SET meta_frage_id = v_id'||unistr('\000a')||
'      WHERE id = :P32_KOMPLEX_META_FRAGE_ID;'||unistr('\000a')||
''||unistr('\000a')||
'      :p32_id := v_id;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN v_fehler THEN'||unistr('\000a')||
'   mel.p(v_fehlertext,v_prot_id,''ERROR'',''APP118/32:gen_metfrage'');'||unistr('\000a')||
'   RAISE_APPLICATION_ERROR(-20020,v_fehlertext );';

p:=p||''||unistr('\000a')||
'WHEN others THEN'||unistr('\000a')||
'   v_fehlertext := frgbg_s.holen_uebersetzung(1915,:fas_sprache_id,'||unistr('\000a')||
'                                                 frgbg_s.holen_uebersetzung(4269,:fas_sprache_id)||'||unistr('\000a')||
'                                                 ''(''||99||'')''||SQLERRM);'||unistr('\000a')||
'   mel.p(v_fehlertext,v_prot_id,''ERROR'',''APP118/32:gen_metfrage'');'||unistr('\000a')||
'   RAISE_APPLICATION_ERROR(-20040,v_fehlertext);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 6550613730450778 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 15,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'gen_metafrage',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':P32_KOMPLEX_META_FRAGE_ID is not null and :request =''METAGEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p32_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
'   :p32_bl_abbrechen := frgbg_s.holen_uebersetzung(161,v_sprache_id);'||unistr('\000a')||
'   :p32_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'   :p32_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
'   :P32_BL_NEUE_VERSION := frgbg_s.holen_uebersetzung(3684,v_sp';

p:=p||'rache_id);'||unistr('\000a')||
'   :P32_BL_NEUER_BEREICH:= frgbg_s.holen_uebersetzung(3685,v_sprache_id);'||unistr('\000a')||
'   :P32_BL_NORMIEREN:= frgbg_s.holen_uebersetzung(4404,v_sprache_id);'||unistr('\000a')||
'   :P32_BL_KOMPLEXFRAGE:= frgbg_s.holen_uebersetzung(4405,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :P32_PAGE_TITEL_ANTWORT := frgbg_s.holen_uebersetzung(3682,v_sprache_id);'||unistr('\000a')||
'   :P32_PAGE_TITEL_ANTWORTAUSWAHL := frgbg_s.holen_uebersetzung(3690,v_sprache_id);'||unistr('\000a')||
'   :P32_PA';

p:=p||'GE_TITEL_NORMBEREICHE := frgbg_s.holen_uebersetzung(3683,v_sprache_id);'||unistr('\000a')||
'   :P32_PAGE_TITEL_frage := frgbg_s.holen_uebersetzung(3671,v_sprache_id);'||unistr('\000a')||
'   :P32_PAGE_TITEL_metadetails := frgbg_s.holen_uebersetzung(4406,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :P32_NV_FRAGEN := frgbg_s.holen_uebersetzung(4428,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5759027193872437 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 32
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00033
prompt  ...PAGE 33: Inhaltsstoffe verwalten
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 33
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Inhaltsstoffe verwalten'
 ,p_step_title => 'Inhaltsstoffe verwalten'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Inhaltsstoffe verwalten'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_html_page_header => 
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'||unistr('\000a')||
'<script language="JavaScript" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
''||unistr('\000a')||
' htmldb_ch_message=''"OK_TO_GET_NEXT_PREV_PK_VALUE"'';'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20150205113636'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5272705902200870 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33,
  p_plug_name=> '&P33_PAGE_TITEL_INHSTOFFE.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'"ID",'||unistr('\000a')||
'"INHSTOFF_ID",'||unistr('\000a')||
'"TYP",'||unistr('\000a')||
'"UMR_FAKTOR",'||unistr('\000a')||
'"EINHEIT_ID",'||unistr('\000a')||
'"BEMERKUNG",'||unistr('\000a')||
'"ERFDAT",'||unistr('\000a')||
'"ERFUSER",'||unistr('\000a')||
'"MUTDAT",'||unistr('\000a')||
'"MUTUSER",'||unistr('\000a')||
'"SATZ_KENNZEICHEN"'||unistr('\000a')||
'from "PIS"."INH_EH_UMRS"'||unistr('\000a')||
'where "INHSTOFF_ID" = :P33_ID'||unistr('\000a')||
'';

wwv_flow_api.create_report_region (
  p_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33,
  p_name=> '&P33_PAGE_TITEL_EINHEITEN.',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_display_when_condition=> 'P33_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P33_HEIGHT_EHLISTE.px;padding-right:20px; overflow:auto; ">'||unistr('\000a')||
'',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3705,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '10',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5274208771200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CHECK$01',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'CHECKBOX',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_derived_column=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s:=s||'INH_EH_UMR_SEQ';

wwv_flow_api.create_report_columns (
  p_id=> 5273132528200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source_type=> 'S',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5273230496200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'INHSTOFF_ID',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_default=> 'P33_ID',
  p_column_default_type=> 'ITEM',
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'INHSTOFF_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5273301915200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'TYP',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'SELECT_LIST_FROM_QUERY',
  p_inline_lov=> 'SELECT frgbg_s.holen_uebersetzung(3706,:fas_sprache_id) a,''B'' b from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(3707,:fas_sprache_id) a,''a'' b from dual'||unistr('\000a')||
'',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'NO',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'TYP',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5273429661200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'UMR_FAKTOR',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '5',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'UMR_FAKTOR',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5273531941200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'EINHEIT_ID',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'SELECT_LIST_FROM_QUERY',
  p_inline_lov=> 'SELECT EINHEIT2.EH_ZEICHEN ||'' (''||EINHEIT2.EH_NAME||'', ''||L_PHYSEH.PHYS_GROESSE ||'' )'','||unistr('\000a')||
'       EINHEIT2.ID ID'||unistr('\000a')||
'FROM EINHEITEN EINHEIT2,'||unistr('\000a')||
'     PHYSEHS L_PHYSEH'||unistr('\000a')||
'WHERE EINHEIT2.PHYSEH_ID = L_PHYSEH.ID'||unistr('\000a')||
'ORDER BY PHYSEH_ID,'||unistr('\000a')||
'         BASIS_FAKTOR',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'NO',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'EINHEIT_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5273603638200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'BEMERKUNG',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '30',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'BEMERKUNG',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5273718427200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'ERFDAT',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '7',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'ERFDAT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5273832532200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'ERFUSER',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'ERFUSER',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5273917798200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'MUTDAT',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '7',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'MUTDAT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5274019456200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'MUTUSER',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'MUTUSER',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5274107551200875 + wwv_flow_api.g_id_offset,
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'SATZ_KENNZEICHEN',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'INH_EH_UMRS',
  p_ref_column_name=> 'SATZ_KENNZEICHEN',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5274313302200875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3045322719431623+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(3052523458431642 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 3050102033431628+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 5274909851200879 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 30,
  p_button_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P33_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P33_ID is not null and frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5275924635200881 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 40,
  p_button_plug_id => 5272902666200875+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_ADD',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P33_BL_NEUE_EINHEIT.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5275320984200879 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 50,
  p_button_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_PREVIOUS_ID',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&lt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_PREVIOUS_ID'')',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P33_ID_PREV is not null and'||unistr('\000a')||
'(:p33_inh_typ_default !=''L'' OR :p33_inh_typ_default is null)',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5275523100200881 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 60,
  p_button_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_button_name    => 'GET_NEXT_ID',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&gt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:htmldb_goSubmit(''GET_NEXT_ID'')',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P33_ID_NEXT is not null and '||unistr('\000a')||
'(:p33_inh_typ_default !=''L'' OR :p33_inh_typ_default is null)',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_button_comment=>'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5321016033745314 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 70,
  p_button_plug_id => 5272902666200875+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE_EH',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P33_BL_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P33_ID is not null and frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5274523581200876 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 10,
  p_button_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P33_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P33_ZURUECK_ZUR_SEITE.:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5275118793200879 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 40,
  p_button_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P33_BL_ERSTELLEN.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P33_ID is null and frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5274731925200878 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 20,
  p_button_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P33_BL_LOESCHEN.',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P33_ID is not null and frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5275703088200881 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 20,
  p_button_plug_id => 5272902666200875+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_MRD',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(3044700277431623+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P33_BL_ELEMENT_LOESCHEN.',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''APPLY_CHANGES_MRD'');',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'DECLARE'||unistr('\000a')||
'   v_anz NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   select count(*) into v_anz'||unistr('\000a')||
'   from "PIS"."INH_EH_UMRS"'||unistr('\000a')||
'   where "INHSTOFF_ID" = :P33_ID;'||unistr('\000a')||
'   IF v_anz > 0 AND frgbg_t.GET_DBINSTANZ = frgbg_s.c_entw_dbinstanz THEN'||unistr('\000a')||
'      RETURN TRUE;'||unistr('\000a')||
'   ELSE '||unistr('\000a')||
'      RETURN FALSE;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_button_condition_type=> 'FUNCTION_BODY',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>5289303641200898 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&FLOW_ID.:33:&SESSION.::&DEBUG.::P33_ID:&P33_ID_NEXT.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>5275523100200881+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
wwv_flow_api.create_page_branch(
  p_id=>5289527797200898 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&FLOW_ID.:33:&SESSION.::&DEBUG.::P33_ID:&P33_ID_PREV.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>5275320984200879+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
wwv_flow_api.create_page_branch(
  p_id=>5289103440200896 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:34:&SESSION.::&DEBUG.:33::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 30,
  p_branch_condition_type=> 'REQUEST_IN_CONDITION',
  p_branch_condition=> 'DELETE,CREATE',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>5289716141200898 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:33:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 40,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5276107628200881 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sortierung, wenn in Liste';

wwv_flow_api.create_page_item(
  p_id=>5276303622200882 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_SORT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'SORT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_POPUP_LOV',
  p_lov=> 'SELECT sort||'' ''||bezeichnung a, sort b'||unistr('\000a')||
'from inhstoffe'||unistr('\000a')||
'where satz_kennzeichen is null'||unistr('\000a')||
'order by sort',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 10,
  p_cMaxlength=> 30,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3050021180431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_help_text=> h,
  p_attribute_01 => 'ENTERABLE',
  p_attribute_02 => 'FIRST_ROWSET',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Langtext (druckreif)';

wwv_flow_api.create_page_item(
  p_id=>5276806003200882 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BEZEICHNUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_post_element_text=>'&P33_BEZEICHNUNG_TEXT_ID.',
  p_source=>'BEZEICHNUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 63,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 4,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3050021180431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Kurztext (druckreif)';

wwv_flow_api.create_page_item(
  p_id=>5277326291200882 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_KUERZEL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'KUERZEL',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 63,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3050021180431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5278027269200884 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_post_element_text=>'&P33_BEMERKUNG_TEXT_ID.',
  p_source=>'BEMERKUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 4000,
  p_cHeight=> 4,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Übergeordneter Datensatz in der Struktur';

wwv_flow_api.create_page_item(
  p_id=>5280715024200885 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_INHSTOFF_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'IF :p33_inh_typ_default =''L'' THEN -- Laborparameter'||unistr('\000a')||
'      RETURN (117);'||unistr('\000a')||
'END IF;',
  p_item_default_type=> 'PLSQL_FUNCTION_BODY',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'INHSTOFF_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select bezeichnung a, id'||unistr('\000a')||
'from inhstoffe '||unistr('\000a')||
'where inh_typ in (''H'',''G'')'||unistr('\000a')||
'  and satz_kennzeichen is null'||unistr('\000a')||
'order by 1'||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 5,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p33_inh_typ_default =''L''',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Ist dies nur eine Gruppierung ?';

wwv_flow_api.create_page_item(
  p_id=>5281706711200887 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_INH_TYP',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 53,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '''W'''||unistr('\000a')||
''||unistr('\000a')||
'',
  p_item_default_type=> 'PLSQL_EXPRESSION',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'INH_TYP',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(3708,:fas_sprache_id)a,''W'' b '||unistr('\000a')||
'FROM DUAL /*Wert*/'||unistr('\000a')||
'UNION SELECT frgbg_s.holen_uebersetzung(3709,:fas_sprache_id),''G'' '||unistr('\000a')||
'FROM DUAL /* Gruppe */'||unistr('\000a')||
'UNION SELECT frgbg_s.holen_uebersetzung(3710,:fas_sprache_id),''H'' '||unistr('\000a')||
'FROM DUAL /* Hauptgruppe */'||unistr('\000a')||
'UNION SELECT frgbg_s.holen_uebersetzung(3711,:fas_sprache_id), ''S'' '||unistr('\000a')||
'FROM DUAL /* Subwert */'||unistr('\000a')||
'UNION SELECT frgbg_s.holen_uebersetzung(3673,:fas_sprache_id),''LW'' '||unistr('\000a')||
'FROM DUAL /* Laborwert*/'||unistr('\000a')||
'UNION SELECT frgbg_s.holen_uebersetzung(3743,:fas_sprache_id),''LG'' '||unistr('\000a')||
'FROM DUAL /* LaborGruppe */'||unistr('\000a')||
'UNION SELECT frgbg_s.holen_uebersetzung(3744,:fas_sprache_id),''LH'' '||unistr('\000a')||
'FROM DUAL /* LaborHauptgruppe */',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p33_id is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3050021180431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Rezeptierbar ?';

wwv_flow_api.create_page_item(
  p_id=>5282207444200887 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_HCK',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> ':p33_hck_default'||unistr('\000a')||
'',
  p_item_default_type=> 'PLSQL_EXPRESSION',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'HCK',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(3712,:fas_sprache_id) a,''H'' b '||unistr('\000a')||
'FROM DUAL UNION /*HCK rezeptierbar*/'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(3713,:fas_sprache_id),''R''   '||unistr('\000a')||
'FROM DUAL UNION /*sonst rezeptierbar*/'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(3714,:fas_sprache_id),''N''   '||unistr('\000a')||
'FROM DUAL /*nicht rezeptierbar*/',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>':p33_hck_default is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3050021180431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_help_text=> h,
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5284115509200889 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BEZEICHNUNG_TEXT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'BEZEICHNUNG_TEXT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5284320852200889 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_ID_PREV',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 410,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'P33_ID_PREV',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5284513603200889 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_ID_COUNT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 18,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'class="fielddata"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5285216790200890 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_ID_NEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 310,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'P33_ID_NEXT',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => 'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5296527410281856 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_INH_TYP_DEFAULT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Inh Typ Default',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5296701915284023 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_HCK_DEFAULT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 52,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Inh Typ Default',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5316032398718559 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_ZURUECK_ZUR_SEITE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 610,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '2',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Zurueck Zur Seite',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5323829071815312 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_SATZ_KENNZEICHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 710,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Satz Kennzeichen',
  p_source=>'SATZ_KENNZEICHEN',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5482107944601668 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BL_ABBRECHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 720,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Abbrechen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5482317641604492 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BL_SPEICHERN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 730,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Speichern',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5482530108608035 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BL_ERSTELLEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 740,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Erstellen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5482714309612923 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BL_LOESCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 750,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Loeschen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5482924352615818 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_PAGE_TITEL_INHSTOFFE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 760,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Inhstoffe',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5488224539729414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BL_ELEMENT_LOESCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 770,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Element Loeschen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5488502637742096 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BL_NEUE_EINHEIT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 780,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Neue Einheit',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5490218137765432 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_PAGE_TITEL_EINHEITEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 790,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Einheiten',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5495819334002335 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_HEIGHT_EHLISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 800,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Ehliste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5617828677486682 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_ENTNAHMEMATERIAL_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Material',
  p_source=>'ENTNAHMEMATERIAL_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'Select fas_synch.get_tab_uebersetzung(''ENTNAHMEMATERIALIEN.BEZEICHNUNG'',id,:fas_sprache_id)||'' ''|| kuerzel a, id b'||unistr('\000a')||
'from entnahmematerialien'||unistr('\000a')||
'where satz_kennzeichen is null',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when_type=>'NEVER',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5785813401981423 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_ANTEIL_TAGMISCHUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Faktor Tagmischung',
  p_format_mask=>'0D00',
  p_source=>'ANTEIL_TAGMISCHUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 5,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_display_when=>':P33_INH_TYP=''W''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => '0',
  p_attribute_02 => '1',
  p_attribute_03 => 'right',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5792711397936498 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_MNREZLEVEL_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 85,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Level',
  p_source=>'MNREZLEVEL_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT ''Basis'' a, 1 b from DUAL'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Basis Plus'', 2 from DUAL'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT ''Comfort'', 3 from DUAL',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_field_template=> 3049909211431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6222611193134675 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_BEMERKUNG_TEXT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 115,
  p_item_plug_id => 5272705902200870+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_pre_element_text=>'&#160',
  p_source=>'BEMERKUNG_TEXT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_field_template=> 3049710276431628+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5285531495200892 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P33_SORT not null',
  p_validation_sequence=> 2,
  p_validation => 'P33_SORT',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Sort Name muss einen Wert haben.',
  p_associated_item=> 5276303622200882 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5285705961200892 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P33_BEZEICHNUNG not null',
  p_validation_sequence=> 3,
  p_validation => 'P33_BEZEICHNUNG',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Bezeichnung Name muss einen Wert haben.',
  p_associated_item=> 5276806003200882 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5285911147200892 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P33_KUERZEL not null',
  p_validation_sequence=> 4,
  p_validation => 'P33_KUERZEL',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Kuerzel Name muss einen Wert haben.',
  p_associated_item=> 5277326291200882 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5286930097200893 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P33_INH_TYP not null',
  p_validation_sequence=> 14,
  p_validation => 'P33_INH_TYP',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Inh Typ Name muss einen Wert haben.',
  p_associated_item=> 5281706711200887 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5287113254200893 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P33_HCK not null',
  p_validation_sequence=> 15,
  p_validation => 'P33_HCK',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Hck Name muss einen Wert haben.',
  p_associated_item=> 5282207444200887 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5618307730518528 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P33_ENTNAHMEMATERIAL_ID',
  p_validation_sequence=> 25,
  p_validation => 'P33_ENTNAHMEMATERIAL_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Wert muss angegeben werden.',
  p_validation_condition=> ':P33_INH_TYP =''L''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 5617828677486682 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|PIS:INHSTOFFE:P33_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 5287605116200893 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from INHSTOFFE',
  p_process_sql_clob => p,
  p_process_error_message=> 'Abrufen von Zeile nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':p33_id is not null',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:INHSTOFFE:ID::KUERZEL::P33_ID:P33_ID_NEXT:P33_ID_PREV::::P33_ID_COUNT:inh_typ in (''W'',''G'',''H'')'||unistr('\000a')||
'  and satz_kennzeichen is null';

wwv_flow_api.create_page_process(
  p_id     => 5288215898200895 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'GET_NEXT_OR_PREV_PK',
  p_process_name=> 'Nächsten oder vorherigen Primärschlüsselwert abrufen',
  p_process_sql_clob => p,
  p_process_error_message=> 'Ausführen von Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   :p33_satz_kennzeichen := ''gelöscht am ''||to_char(sysdate,''DD.MM.YYYY hh24:mi:ss'')||'' von ''||:APP_USER;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5323402059807521 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 5,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_inhstoff_geloescht',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>5274731925200878 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_fehlertext  varchar2(2000);'||unistr('\000a')||
'   v_return      number;'||unistr('\000a')||
'   v_prot_id     number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Bezeichnungs-Text generieren/ändern'||unistr('\000a')||
'   v_return := uebersetzung.admin_basistext(:P33_bezeichnung_TEXT_ID,:P33_bezeichnung,6,10);'||unistr('\000a')||
'   IF v_return < 0 THEN'||unistr('\000a')||
'      v_fehlertext := frgbg_s.holen_uebersetzung(3646,:FAS_SPRACHE_ID,'||unistr('\000a')||
'                            :P33_bezeichnung_TEXT_ID,:P33_bezeichnung)||''';

p:=p||' ''||SQLERRM;'||unistr('\000a')||
'      mel.p(v_fehlertext,v_prot_id,''Fehler'',''App118/33:gen_text_id'');'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   :P33_bezeichnung_TEXT_ID := v_return;'||unistr('\000a')||
'   -- Bemerkungs-Text generieren/ändern'||unistr('\000a')||
'   v_return := uebersetzung.admin_basistext(:P33_bemerkung_TEXT_ID,:P33_bemerkung,6,10);'||unistr('\000a')||
'   IF v_return < 0 THEN'||unistr('\000a')||
'      v_fehlertext := frgbg_s.holen_uebersetzung(3646,:FAS';

p:=p||'_SPRACHE_ID,'||unistr('\000a')||
'                            :P33_bemerkung_TEXT_ID,:P33_bemerkung)||'' ''||SQLERRM;'||unistr('\000a')||
'      mel.p(v_fehlertext,v_prot_id,''Fehler'',''App118/33:gen_text_id'');'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20002,v_fehlertext );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   :P33_bemerkung_TEXT_ID := v_return;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5325628528976043 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 6,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'gen_text_id',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:INHSTOFFE:P33_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 5287815346200895 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of INHSTOFFE',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Zeile der Tabelle INHSTOFFE nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_return_key_into_item1=>'P33_ID',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:INH_EH_UMRS:ID';

wwv_flow_api.create_page_process(
  p_id     => 5288629824200896 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_UPDATE',
  p_process_name=> 'ApplyMRU',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Aktualisierung nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'APPLY_CHANGES_ADD,SAVE,SAVE_EH',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> '#MRU_COUNT#-Zeile(n) wurde(n) aktualisiert, #MRI_COUNT#-Zeile(n) wurde(n) eingefügt.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'PIS:INH_EH_UMRS:ID';

wwv_flow_api.create_page_process(
  p_id     => 5288409091200896 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_DELETE',
  p_process_name=> 'ApplyMRD',
  p_process_sql_clob => p,
  p_process_error_message=> 'Verarbeiten von Löschvorgang nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'APPLY_CHANGES_MRD',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> '#MRD_COUNT#-Zeile(n) gelöscht.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'1';

wwv_flow_api.create_page_process(
  p_id     => 5288800684200896 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 5272902666200875 + wwv_flow_api.g_id_offset,
  p_process_type=> 'ADD_ROWS_TO_TABULAR_FORM',
  p_process_name=> 'AddRows',
  p_process_sql_clob => p,
  p_process_error_message=> 'Hinzufügen von Zeilen nicht möglich.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>5275924635200881 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p33_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
'   :p33_bl_abbrechen := frgbg_s.holen_uebersetzung(161,v_sprache_id);'||unistr('\000a')||
'   :p33_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'   :p33_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
'   :P33_BL_NEUE_EINHEIT := frgbg_s.holen_uebersetzung(3703,v_sp';

p:=p||'rache_id);'||unistr('\000a')||
'   :P33_BL_ELEMENT_LOESCHEN:= frgbg_s.holen_uebersetzung(3591,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   IF :P33_INH_TYP_DEFAULT = ''L'' THEN'||unistr('\000a')||
'      :p33_page_titel_inhstoffe := frgbg_s.holen_uebersetzung(3673,v_sprache_id);'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :p33_page_titel_inhstoffe := frgbg_s.holen_uebersetzung(3702,v_sprache_id);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   :p33_page_titel_einheiten := frgbg_s.holen_uebersetzung(3704,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5440003884675698 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P33_HEIGHT_EHLISTE  := :FAS_SCROLLREGION_HEIGHT_MAX * 0.4;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5495927646004681 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 50,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 33
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00034
prompt  ...PAGE 34: INHSTOFFE
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 34
 ,p_user_interface_id => 64611772194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'INHSTOFFE'
 ,p_step_title => 'INHSTOFFE'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'INHSTOFFE'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3905320351224497 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20150205113004'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||unistr('\000a')||
'   "INHSTOFFE"."ID" "ID", '||unistr('\000a')||
'   "INHSTOFFE"."SORT" "SORT", '||unistr('\000a')||
'   "INHSTOFFE"."BEZEICHNUNG" "BEZEICHNUNG", '||unistr('\000a')||
'   "INHSTOFFE"."KUERZEL" "KUERZEL", '||unistr('\000a')||
'   "INHSTOFFE"."ID_HERKUNFT" "ID_HERKUNFT", '||unistr('\000a')||
'   "INHSTOFFE"."BEMERKUNG" "BEMERKUNG", '||unistr('\000a')||
'   "INHSTOFFE"."ERFDAT" "ERFDAT", '||unistr('\000a')||
'   "INHSTOFFE"."ERFUSER" "ERFUSER", '||unistr('\000a')||
'   "INHSTOFFE"."MUTDAT" "MUTDAT", '||unistr('\000a')||
'   "INHSTOFFE"."MUTUSER" "MUTUSER", '||unistr('\000a')||
'   "INHSTOFFE"."SATZ_K';

s:=s||'ENNZEICHEN" "SATZ_KENNZEICHEN", '||unistr('\000a')||
'   "INHSTOFFE"."INHSTOFF_ID" "INHSTOFF_ID", '||unistr('\000a')||
'   "INHSTOFFE"."SPEZ" "SPEZ", '||unistr('\000a')||
'   "INHSTOFFE"."INH_TYP" "INH_TYP", '||unistr('\000a')||
'   "INHSTOFFE"."HCK" "HCK", '||unistr('\000a')||
'   "INHSTOFFE"."MNREZLEVEL_ID" "MNREZLEVEL_ID", '||unistr('\000a')||
'   "INHSTOFFE"."XMAXIMALWERT" "XMAXIMALWERT", '||unistr('\000a')||
'   "INHSTOFFE"."XSICHERHEITSGRENZE" "XSICHERHEITSGRENZE", '||unistr('\000a')||
'   "INHSTOFFE"."VITARAN_REFERENZ" "VITARAN_REFERENZ", '||unistr('\000a')||
'   "INHSTOFFE".';

s:=s||'"BEZEICHNUNG_TEXT_ID" "BEZEICHNUNG_TEXT_ID", '||unistr('\000a')||
'   "INHSTOFFE"."SUB_PROZ" "SUB_PROZ"'||unistr('\000a')||
'FROM '||unistr('\000a')||
'   "PIS"."INHSTOFFE" "INHSTOFFE"'||unistr('\000a')||
'';

wwv_flow_api.create_report_region (
  p_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34,
  p_name=> '&P34_PAGE_TITEL_INHSTOFFE. - Disabled',
  p_region_name=>'',
  p_template=> 3046603970431625+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'STRUCTURED_QUERY',
  p_display_condition_type=> 'NEVER',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="height:&P34_HEIGHT_INHLISTE.px;padding-right:20px; overflow:auto; ">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3718,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '500',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'TOP_AND_BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5354802146604645 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_link=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:RP,33:P33_ID,P33_ZURUECK_ZUR_SEITE:#ID#,&APP_PAGE_ID.',
  p_column_linktext=>'<img src="#IMAGE_PREFIX#e2.gif"  border="0">',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5354908890604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SORT',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'SORT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355015494604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'BEZEICHNUNG',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'BEZEICHNUNG',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355114493604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'KUERZEL',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'KUERZEL',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355211859604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ID_HERKUNFT',
  p_column_display_sequence=> 21,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'ID_HERKUNFT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355314975604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'BEMERKUNG',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'BEMERKUNG',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355412831604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'ERFDAT',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'ERFDAT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355502045604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'ERFUSER',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'ERFUSER',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355603922604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'MUTDAT',
  p_column_display_sequence=> 15,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'MUTDAT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355703827604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'MUTUSER',
  p_column_display_sequence=> 17,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'MUTUSER',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355805359604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'SATZ_KENNZEICHEN',
  p_column_display_sequence=> 16,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'SATZ_KENNZEICHEN',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5355929113604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'INHSTOFF_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'INHSTOFF_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5356017858604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'SPEZ',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'PIS',
  p_ref_table_name=> 'INHSTOFFE',
  p_ref_column_name=> 'SPEZ',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5356111788604646 + wwv_flow_api.g_id_offset,
  p_region_id=> 5354608589604637 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> 