set define off
set verify off
set feedback off
WHENEVER SQLERROR EXIT SQL.SQLCODE ROLLBACK
begin wwv_flow.g_import_in_progress := true; end;
/
 
 
--application/set_environment
prompt  APPLICATION 104 - Auftragsdisposition
--
-- Application Export:
--   Application:     104
--   Name:            Auftragsdisposition
--   Date and Time:   10:52 Montag Oktober 26, 2015
--   Exported By:     SYSTEM
--   Flashback:       0
--   Export Type:     Application Export
--   Version:         4.2.5.00.08
--   Instance ID:     63126117280962
--
-- Import:
--   Using Application Builder
--   or
--   Using SQL*Plus as the Oracle user APEX_040200 or as the owner (parsing schema) of the application
 
-- Application Statistics:
--   Pages:                     12
--     Items:                   86
--     Validations:             11
--     Processes:               50
--     Regions:                 15
--     Buttons:                 15
--     Dynamic Actions:          5
--   Shared Components:
--     Logic:
--       Items:                 20
--       Processes:              2
--     Navigation:
--       Tab Sets:               1
--         Tabs:                 1
--       Breadcrumbs:            1
--       NavBar Entries:         1
--     Security:
--       Authentication:         4
--       Authorization:          1
--     User Interface:
--       Themes:                 1
--       Templates:
--         Page:                 9
--         Region:              22
--         Label:                5
--         List:                16
--         Popup LOV:            1
--         Calendar:             3
--         Breadcrumb:           2
--         Button:               4
--         Report:               7
--       Shortcuts:              4
--       Plug-ins:               3
--     Globalization:
--     Reports:
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_040200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>nvl(wwv_flow_application_install.get_workspace_id,2031917327559678));
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2012.01.01');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := nvl(wwv_flow_application_install.get_application_id,104);
   wwv_flow_api.g_id_offset := nvl(wwv_flow_application_install.get_offset,0);
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(nvl(wwv_flow_application_install.get_application_id,104));
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(nvl(wwv_flow_application_install.get_application_id,104));
null;
 
end;
/

prompt  ...ui types
--
 
begin
 
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => nvl(wwv_flow_application_install.get_application_id,104),
  p_display_id=> nvl(wwv_flow_application_install.get_application_id,104),
  p_owner => nvl(wwv_flow_application_install.get_schema,'FRGBG'),
  p_name  => nvl(wwv_flow_application_install.get_application_name,'Auftragsdisposition'),
  p_alias => nvl(wwv_flow_application_install.get_application_alias,'F104'),
  p_page_view_logging => 'YES',
  p_page_protection_enabled_y_n=> 'Y',
  p_checksum_salt_last_reset => '20141007101838',
  p_max_session_length_sec=> 28800,
  p_compatibility_mode=> '4.0',
  p_html_escaping_mode=> 'B',
  p_flow_language=> 'de-ch',
  p_flow_language_derived_from=> '',
  p_allow_feedback_yn=> 'N',
  p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,''),
  p_publish_yn=> 'N',
  p_documentation_banner=> '',
  p_authentication=> 'PLUGIN',
  p_authentication_id=> 3852328165872065 + wwv_flow_api.g_id_offset,
  p_logout_url=> 'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&amp;p_next_flow_page_sess=102:101',
  p_application_tab_set=> 1,
  p_logo_image => '/i/themes/&FAS_THEME_NAME./logo.jpg',
  p_public_url_prefix => '',
  p_public_user=> 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server=> nvl(wwv_flow_application_install.get_proxy,''),
  p_cust_authentication_process=> '',
  p_cust_authentication_page=> '',
  p_flow_version=> 'Release 1.0',
  p_flow_status=> 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'Diese Anwendung ist aktuell nicht verfügbar.',
  p_build_status=> 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_browser_cache=>'Y',
  p_browser_frame=>'A',
  p_deep_linking=>'Y',
  p_vpd=> '',
  p_vpd_teardown_code=> '',
  p_authorize_public_pages_yn=>'Y',
  p_csv_encoding=> 'Y',
  p_include_legacy_javascript=> 'Y',
  p_default_error_display_loc=> 'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_last_updated_by => 'FRGBG',
  p_last_upd_yyyymmddhh24miss=> '20141007101838',
  p_ui_type_name => null,
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

----------------
--package app map
--
prompt  ...user interfaces
--
 
begin
 
--application/user interface/desktop
wwv_flow_api.create_user_interface (
  p_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_ui_type_name => 'DESKTOP'
 ,p_display_name => 'Desktop'
 ,p_display_seq => 10
 ,p_use_auto_detect => true
 ,p_is_default => true
 ,p_theme_id => 1
 ,p_home_url => 'f?p=&APP_ID.:100:&SESSION.'
 ,p_global_page_id => 0
  );
null;
 
end;
/

prompt  ...plug-in settings
--
 
begin
 
--application/plug-in setting/item_type_native_yes_no
wwv_flow_api.create_plugin_setting (
  p_id => 2259906726896563 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'ITEM TYPE'
 ,p_plugin => 'NATIVE_YES_NO'
 ,p_attribute_01 => 'Y'
 ,p_attribute_03 => 'N'
  );
--application/plug-in setting/dynamic_action_plugin_com_skillbuilders_modal_page
wwv_flow_api.create_plugin_setting (
  p_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'DYNAMIC ACTION'
 ,p_plugin => 'PLUGIN_COM_SKILLBUILDERS_MODAL_PAGE'
 ,p_attribute_01 => '1'
 ,p_attribute_02 => '.5'
 ,p_attribute_03 => 'Y'
 ,p_attribute_04 => 'none'
 ,p_attribute_05 => '100'
 ,p_attribute_06 => '300'
 ,p_attribute_07 => 'Y'
  );
null;
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
--application/shared_components/security/authorization/check_page_access
wwv_flow_api.create_security_scheme (
  p_id => 3979322781387567 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'check_page_access'
 ,p_scheme_type => 'NATIVE_FUNCTION_BODY'
 ,p_attribute_01 => 'DECLARE'||unistr('\000a')||
'   v_anz           NUMBER;'||unistr('\000a')||
'   v_fehlerseite   NUMBER := 130;'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--mel.p(''Check Zugriff 1: %1,%2,%3,%4,%5,%6'',v_prot_id,''Info'',''102/0 dynamic action check_zugriff'',:fas_schema_id,:FAS_LOGIN_PERSONENSTAMM_ID,:FAS_IDENTITAET_PERSSTAMM_ID,:APP_ID,:APP_PAGE_ID,:FAS_AUFGERUFEN_VON);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Gibt es spezielle Zugriffsdefinitionen?'||unistr('\000a')||
'   SELECT count(*) INTO v_anz'||unistr('\000a')||
'   FROM fas_app_menus'||unistr('\000a')||
'   WHERE satz_kennzeichen is null'||unistr('\000a')||
'     AND app_id = :APP_ID'||unistr('\000a')||
'     AND page_id = :APP_PAGE_ID;'||unistr('\000a')||
'   IF v_anz = 0 THEN -- Keine speziellen Berechtigungen definiert => Zugriff möglich, falls Betreuerzugang'||unistr('\000a')||
'      IF :fas_aufgerufen_von in (''PRODAUFDISPO'',''PRODAUFBEARB'') THEN'||unistr('\000a')||
'         RETURN TRUE;'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         RETURN FALSE;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   -- Check spezieller Zugriff'||unistr('\000a')||
'   IF frgbg_t.CHECK_FAS_APP_ZUGRIFF(:FAS_LOGIN_PERSONENSTAMM_ID,'||unistr('\000a')||
'                                    :FAS_LOGIN_PERSONENSTAMM_ID, -- :FAS_IDENTITAET_PERSSTAMM_ID,'||unistr('\000a')||
'                                    :APP_ID,:APP_PAGE_ID) = 1 '||unistr('\000a')||
'   THEN  -- Zugriff erlaubt'||unistr('\000a')||
'      return TRUE;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      return FALSE;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'--mel.p(''Check Zugriff 2: %1,%2,%3,%4,%5,%6'',v_prot_id,''Info'',''102/authorization check_page_access'',:fas_schema_id,:FAS_LOGIN_PERSONENSTAMM_ID,:FAS_IDENTITAET_PERSSTAMM_ID,:APP_ID,:APP_PAGE_ID,:FAS_AUFGERUFEN_VON);'||unistr('\000a')||
''||unistr('\000a')||
'END;'
 ,p_error_message => '&FAS_ZUGRIFF_TEXT.'
 ,p_caching => 'BY_USER_BY_PAGE_VIEW'
  );
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id => 3823808909727412 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_icon_sequence=> 200,
  p_icon_image => '',
  p_icon_subtext=> '&FAS_ABMELDEN_TEXT.',
  p_icon_target=> 'f?p=&APP_ID.:999:&SESSION.:&SESSION.:&DEBUG.:&DEBUG.:P999_LOGIN_PAGE:&FAS_LOGIN_PAGE.:',
  p_icon_image_alt=> '',
  p_icon_height=> 32,
  p_icon_width=> 32,
  p_icon_height2=> 24,
  p_icon_width2=> 24,
  p_nav_entry_is_feedback_yn => 'N',
  p_icon_bar_disp_cond=> 'DECLARE'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'IF :APP_PAGE_ID not in (999) AND :FAS_AUFGERUFEN_VON != ''PIS'' THEN'||unistr('\000a')||
' --  MEL.P (''Navi true page_id:%1, aufruf:%2|'', v_prot_id,''ERROR'',''fas-navi'','||unistr('\000a')||
' --         :APP_PAGE_ID,:fas_AUFGERUFEN_VON);'||unistr('\000a')||
' -- 215: Popup-Drucken, 105 = Registrierung, 104 = Benutzer vergessen,102=Popup PW ändern'||unistr('\000a')||
'  RETURN(TRUE);'||unistr('\000a')||
'ELSE'||unistr('\000a')||
' --  MEL.P (''Navi false page_id:%1, aufruf:%2|'', v_prot_id,''ERROR'',''fas-navi'','||unistr('\000a')||
' --         :APP_PAGE_ID,:fas_AUFGERUFEN_VON);'||unistr('\000a')||
'  RETURN (FALSE);'||unistr('\000a')||
'END IF;'||unistr('\000a')||
'END;',
  p_icon_bar_disp_cond_type=> 'NEVER',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '--Condition'||unistr('\000a')||
'DECLARE'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'IF :APP_PAGE_ID not in (999) AND :FAS_AUFGERUFEN_VON != ''PIS'' THEN'||unistr('\000a')||
' --  MEL.P (''Navi true page_id:%1, aufruf:%2|'', v_prot_id,''ERROR'',''fas-navi'','||unistr('\000a')||
' --         :APP_PAGE_ID,:fas_AUFGERUFEN_VON);'||unistr('\000a')||
' -- 215: Popup-Drucken, 105 = Registrierung, 104 = Benutzer vergessen,102=Popup PW ändern'||unistr('\000a')||
'  RETURN(TRUE);'||unistr('\000a')||
'ELSE'||unistr('\000a')||
' --  MEL.P (''Navi false page_id:%1, aufruf:%2|'', v_prot_id,''ERROR'',''fas-navi'','||unistr('\000a')||
' --         :APP_PAGE_ID,:fas_AUFGERUFEN_VON);'||unistr('\000a')||
'  RETURN (FALSE);'||unistr('\000a')||
'END IF;'||unistr('\000a')||
'END;');
 
 
end;
/

prompt  ...application processes
--
--application/shared_components/logic/application_processes/init_scrollregion_height
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_prot_id   NUMBER;'||unistr('\000a')||
'   v_user      personenstamm.user_account%TYPE;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :FAS_SCROLLREGION_HEIGHT_MAX:= frgbg_s.get_pers_option(:APP_USER,4);'||unistr('\000a')||
'   IF :FAS_SCROLLREGION_HEIGHT_MAX IS NULL THEN'||unistr('\000a')||
'      :FAS_SCROLLREGION_HEIGHT_MAX := 500;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'/* MEL.P (''Scrollheigth!''||:FAS_SCROLLREGION_HEIGHT_MAX||'' (user=''||:APP_USER||'' USer:''||:P121_USERNAME||'')! [init_scrollregion,30]'', v_PROT';

p:=p||'_ID, ''ERROR'', ''init_scrollregion,30'');'||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 3850813200612214 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'AFTER_AUTHENTICATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Fehler beim Setzen der fas_scrollregion_height in Anwendungsprozess init_scrollregion_height!',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/set_fas_texte
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_sprache_id NUMBER := v(''FAS_SPRACHE_ID'');  '||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   v_sprache_id := v(''FAS_SPRACHE_ID''); '||unistr('\000a')||
'   :fas_abmelden_text := '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(174,v_sprache_id);'||unistr('\000a')||
'   :fas_keine_daten_text := '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(759,v_sprache_id);'||unistr('\000a')||
'   /*:FAS_AENDERUNGWARNUNG_TEXT :=  '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(3068,v_sprache_id); '||unistr('\000a')||
'   */'||unistr('\000a')||
'   :FAS_LOESCHABFRAGE_TEXT := '||unistr('\000a')||
'  ';

p:=p||'      frgbg_s.holen_uebersetzung(2195,v_sprache_id);'||unistr('\000a')||
'   :FAS_ZUGRIFF_TEXT :=  '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(3110,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 2179930787869762 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_fas_texte',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Fehler beim Setzen der fas_texte in Anwendungsprozess set_fas_texte!',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

prompt  ...application items
--
--application/shared_components/logic/application_items/fas_abmelden_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3851125236634590 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_ABMELDEN_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_aufgerufen_von
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3851312900640495 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_AUFGERUFEN_VON'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_identitaet_persstamm_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 1378523597425590 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_IDENTITAET_PERSSTAMM_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_keine_daten_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3851518441642092 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_KEINE_DATEN_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_loeschabfrage_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 2179718189856696 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOESCHABFRAGE_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_login_page
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3851722250643245 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOGIN_PAGE'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_login_personenstamm_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3853115268887265 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOGIN_PERSONENSTAMM_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_login_user_account
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3851927445644739 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOGIN_USER_ACCOUNT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_modus_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4219809825215626 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_MODUS_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_schema_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 2774928800740656 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SCHEMA_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_scrollregion_height_max
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3850604411600201 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SCROLLREGION_HEIGHT_MAX'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_sortiment_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 1485214092231904 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SORTIMENT_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_sprache_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3850425751596943 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SPRACHE_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
 ,p_item_comment => 'Anzeigesprache (sprache_id) für FAS abhängig vom eingeloggten Benutzer, d.h. entweder die Betreuer-Sprache beim Betreuer-Login oder sonst ist es die Patientensprache.'||unistr('\000a')||
'Wird gesetzt bei allen Login-Masken und bei den Patientenstamm-Masken 1 und 110, da dort die Sprache geändert werden kann.'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_theme_name
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 6310120984280307 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_THEME_NAME'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_zugriff_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3991821037479496 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_ZUGRIFF_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3847414473404418 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_AFTER_LOGIN_URL'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3836319686755373
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3847823739426025 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3836319686755373'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3974014954058925
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3985723014400978 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3974014954058925'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_4793301536509046
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4796107854607115 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_4793301536509046'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_5888122729874879
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3990615739345538 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_5888122729874879'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/standard/t_seite_1
wwv_flow_api.create_tab (
  p_id=> 3825207472727464 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 10,
  p_tab_name=> 'T_SEITE_1',
  p_tab_text => 'Seite 1',
  p_tab_step => 1,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_comment  => '');
 
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_00000
prompt  ...PAGE 0: 0
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 0
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => '0'
 ,p_step_title => '0'
 ,p_step_sub_title => '0'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20140617094823'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT x.ID ID,'||unistr('\000a')||
'       x.FAS_APP_MENU_ID PID,'||unistr('\000a')||
'       x.BEZEICHNUNG NAME,'||unistr('\000a')||
'       CASE substr(x.URL,1,4) when ''f?p='''||unistr('\000a')||
'       THEN APEX_UTIL.PREPARE_URL(frgbg_t.replace_var_in_wert(x.URL))'||unistr('\000a')||
'       ELSE ''#'''||unistr('\000a')||
'       END link,'||unistr('\000a')||
'       level'||unistr('\000a')||
'--from fas_app_menus x'||unistr('\000a')||
'--where x.id in'||unistr('\000a')||
'from (select distinct b.id,b.FAS_APP_MENU_ID,'||unistr('\000a')||
'             NVL(frgbg_s.holen_uebersetzung(b.bezeichnung_text_id,:fas_sprache_id),b';

s:=s||'.BEZEICHNUNG ) bezeichnung,'||unistr('\000a')||
'             b.URL,b.sortierung    -- Gesamthierarchie mit Oberelemente mit zugriffbaren Blattelementen: von unten nach oben LOOP'||unistr('\000a')||
'      FROM "FAS_APP_MENUS" b'||unistr('\000a')||
'      WHERE b.app_id = :APP_ID'||unistr('\000a')||
'        and b.aktiv in (1,2)'||unistr('\000a')||
'      START WITH b.ID in (SELECT m.id     -- alle zugreifbaren Blattelemente'||unistr('\000a')||
'                          from fas_app_menus m'||unistr('\000a')||
'                          WHE';

s:=s||'RE m.id not in (SELECT d.fas_app_menu_id       -- Oberelemente'||unistr('\000a')||
'                                             from fas_app_menus d'||unistr('\000a')||
'                                             WHERE d.app_id = :app_id'||unistr('\000a')||
'                                               and d.satz_kennzeichen is null'||unistr('\000a')||
'                                               and d.fas_app_menu_id is not null'||unistr('\000a')||
'                                          ';

s:=s||'  )'||unistr('\000a')||
'                            and m.page_id is not null'||unistr('\000a')||
'                            and m.app_id = :APP_ID'||unistr('\000a')||
'                            and m.SATZ_KENNZEICHEN is null'||unistr('\000a')||
'                            --  Aktuelle Page soll nicht im Menü auftauchen wg. verhindern doppeltem Aufruf'||unistr('\000a')||
'                            and m.page_id != :APP_PAGE_ID --Klappt merkwürdigerweise in APP 118 nicht ohne UNION s.u.'||unistr('\000a')||
'      ';

s:=s||'                      -- Zugriffsberechtigung inkl. Auswertung aktiv-Flag'||unistr('\000a')||
'                            and frgbg_t.CHECK_FAS_APP_ZUGRIFF(:FAS_LOGIN_PERSONENSTAMM_ID,:FAS_IDENTITAET_PERSSTAMM_ID,m.app_id,m.page_id,:FAS_AUFGERUFEN_VON) > 0'||unistr('\000a')||
'                            -- Menüpunkt überhaupt auf akt. Seite anzeigen'||unistr('\000a')||
'                            and (m.menu_visible_page_id is NULL OR instr(m.menu_visible_';

s:=s||'page_id,'';''||:APP_PAGE_ID||'';'') > 0)'||unistr('\000a')||
'                           )'||unistr('\000a')||
'       CONNECT BY PRIOR b.FAS_APP_MENU_ID = b.ID          -- von unten nach oben'||unistr('\000a')||
'              and prior b.app_id = :APP_ID'||unistr('\000a')||
'      UNION  -- NEI 25.10.13 muss sein damit "and m.page_id != :APP_PAGE_ID" auch in 118 klappt, das Plugin sein sonst das Menü nicht in allen Fällen richtig aufzubauen'||unistr('\000a')||
'       SELECT -1,null,'''',''#'',9000000'||unistr('\000a')||
'    ';

s:=s||'   from dual'||unistr('\000a')||
'     ) x'||unistr('\000a')||
'START WITH x.FAS_APP_MENU_ID is null'||unistr('\000a')||
'CONNECT BY PRIOR x.ID=x.FAS_APP_MENU_ID        -- von oben nach unten'||unistr('\000a')||
'order siblings by x.SORTIERUNG';

wwv_flow_api.create_page_plug (
  p_id=> 3986321804248465 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 0,
  p_plug_name=> 'Menü',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'PLUGIN_COM.JWILSON.APEX.DROP_MENU',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':APP_PAGE_ID not in (100,101,102  /* Login-Seiten */'||unistr('\000a')||
'                                  /* PW anfordern vor Login */'||unistr('\000a')||
'                     ,999,550 /* Alle Popups */'||unistr('\000a')||
'                    )',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_attribute_01=> '0',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<iframe id="jobliste_iframe" src ="f?p=&APP_ID.:550:&SESSION."  scrolling="no" style="height:100%; width:100%; border:0px; overflow:hidden; border-radius: 6px;">'||unistr('\000a')||
'</iframe>';

wwv_flow_api.create_page_plug (
  p_id=> 9107810704859691 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 0,
  p_plug_name=> 'Job Liste',
  p_region_name=>'',
  p_escape_on_http_output=>'Y',
  p_plug_template=> 3818608283727362+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'EXISTS',
  p_plug_display_when_condition => 'select  a.ID'||unistr('\000a')||
'from FRGBG.APP_JOBS a'||unistr('\000a')||
'where'||unistr('\000a')||
''||unistr('\000a')||
'  (:APP_PAGE_ID < 100 or :APP_PAGE_ID >= 130) '||unistr('\000a')||
'  and :APP_PAGE_ID not in(215,98,550)'||unistr('\000a')||
'  and app_id = :APP_ID'||unistr('\000a')||
'  and USER_ACCOUNT = :APP_USER'||unistr('\000a')||
'  and a.MUTDAT > sysdate - 24/60 -- Maximal 60 Minuten halten'||unistr('\000a')||
'  and a.satz_kennzeichen is null'||unistr('\000a')||
'  and a.visible = 1'||unistr('\000a')||
'  and (a.STATUS_ID = 1 and a.JOB_ID in (select JOB from dba_jobs_running) or a.STATUS_ID <> 1)',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> '<div id="jobliste" style="position:absolute; top:40px; right:10px; width:340px;  background-color:#404040; padding:0px 0px 1px 10px; border-radius: 6px; border:1px solid #000; height:85px;">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 0
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00002
prompt  ...PAGE 2: Startseite der FAS-Auftragsverwaltung
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 2
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Startseite der FAS-Auftragsverwaltung'
 ,p_step_title => 'Startseite der FAS-Auftragsverwaltung'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Startseite der FAS-Auftragsverwaltung'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_step_template => 3816501748727348 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20111115104622'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3982204238214716 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2,
  p_plug_name=> 'START',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3818608283727362+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_1',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<div style="max-width: 800px; ">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3982923165214731 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 28-SEP-2011 10:17 by BRIGITTE.NEIDHART');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3982412990214724 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2,
  p_name=>'P2_HINWEIS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3982204238214716+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Hinweis',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 4000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_read_only_when_type=>'ALWAYS',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   IF :p2_hinweis is not null THEN'||unistr('\000a')||
'      htp.p(''<body>'');'||unistr('\000a')||
'      htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'      htp.p(''alert("''||:p2_hinweis||''");'');'||unistr('\000a')||
'      :p2_hinweis := NULL;'||unistr('\000a')||
'      htp.p(''</script>'');'||unistr('\000a')||
'      htp.p(''</body>'');'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;'||unistr('\000a')||
'';

wwv_flow_api.create_page_process(
  p_id     => 3982614678214730 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'fehlerausgabe',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 2
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00003
prompt  ...PAGE 3: dokumentendruck
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 3
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'dokumentendruck'
 ,p_step_title => 'dokumentendruck'
 ,p_step_sub_title => 'dokumentendruck'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'FRGBG'
 ,p_last_upd_yyyymmddhh24miss => '20090728103815'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT beschreibung,id,'||unistr('\000a')||
'       ''<a href="'''||unistr('\000a')||
'        ||''dokumenten_druck.download_file?p_id='''||unistr('\000a')||
'        ||to_char(id)'||unistr('\000a')||
'        || ''">'''||unistr('\000a')||
'        || ''<img src="#IMAGE_PREFIX#FNDPRINT.gif">'''||unistr('\000a')||
'        || ''</a>'' link'||unistr('\000a')||
'FROM store_blob'||unistr('\000a')||
'WHERE referenz_id = :p3_referenz_id';

wwv_flow_api.create_report_region (
  p_id=> 5386709695634321 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3,
  p_name=> '&P3_REGION_TITEL_DOKUMENTE.',
  p_region_name=>'',
  p_template=> 3819021965727364+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P4_HEIGHT_LISTE.px;">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(3066,:fas_sprache_id));',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5387114811634343 + wwv_flow_api.g_id_offset,
  p_region_id=> 5386709695634321 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'BESCHREIBUNG',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5387024772634340 + wwv_flow_api.g_id_offset,
  p_region_id=> 5386709695634321 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5391230461188887 + wwv_flow_api.g_id_offset,
  p_region_id=> 5386709695634321 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 5393820567047132 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3,
  p_button_sequence=> 10,
  p_button_plug_id => 5386709695634321+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P3_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>5394116440047137 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P3_PAGE.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2039008710282004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3,
  p_name=>'P3_PAGE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 5386709695634321+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822217926727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5387427710639293 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3,
  p_name=>'P3_REFERENZ_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 5386709695634321+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Referenz Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822217926727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5393421475037956 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3,
  p_name=>'P3_HEIGHT_LISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 5386709695634321+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Liste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5395024769076734 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3,
  p_name=>'P3_BL_ABBRECHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 5386709695634321+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Abbrechen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5395213126082840 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3,
  p_name=>'P3_REGION_TITEL_DOKUMENTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 5386709695634321+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Region Titel Dokument',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'CLOSE_WINDOW';

wwv_flow_api.create_page_process(
  p_id     => 5394228186049346 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLOSE_WINDOW',
  p_process_name=> 'Fenster schließen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>5393820567047132 + wwv_flow_api.g_id_offset,
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p3_bl_abbrechen := frgbg_s.holen_uebersetzung(161,v_sprache_id);'||unistr('\000a')||
'  '||unistr('\000a')||
'   :p3_region_titel_dokumente := frgbg_s.holen_uebersetzung(3065,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5392902774032518 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3,
  p_process_sequence=> 110,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Komplette Höhe ausnutzen (100% des Maximums)'||unistr('\000a')||
'   :P3_HEIGHT_Liste := :FAS_SCROLLREGION_HEIGHT_MAX * 1;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5393112125035237 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3,
  p_process_sequence=> 110,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'scrollheight_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 3
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00004
prompt  ...PAGE 4: Auftragsdisposition
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 4
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Auftragsdisposition'
 ,p_step_title => 'Auftragsdisposition'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Auftragsdisposition'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3979322781387567 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20140617111904'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT'||unistr('\000a')||
'  APEX_ITEM.hidden(1,b.id) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(3,to_char(b.plandatum,''dd.mm.yyyy'')) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(4,b.persstamm_id) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(5,b.p_rezept_id) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(7,to_char(b.mutdat,''DD.MM.YYYY HH24:MI:SS'')) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(8,p.name||'' ''||p.vorname) ||'||unistr('\000a')||
'  trim(p.name || '' '' || p.vorname) || '||unistr('\000a')||
'  -- Flag fuer mehr als 1 Mischung'||unistr('\000a')||
'  CASE WHEN (select count(*)'||unistr('\000a')||
'       ';

s:=s||'      from warenkorb_details'||unistr('\000a')||
'             where warenkorb_id in ('||unistr('\000a')||
'                     select warenkorb_id'||unistr('\000a')||
'                     from warenkorb_details'||unistr('\000a')||
'                     where id = b.warenkorb_detail_id )'||unistr('\000a')||
'               and (mengenart_id is NULL or mengenart_id <> 101)'||unistr('\000a')||
'               and wk_status_id < 90) > 1 '||unistr('\000a')||
'  THEN'||unistr('\000a')||
'      '' <a onmouseover="javascript:toolTip_enable(event,this,'''''''||unistr('\000a')||
'--     ||frgb';

s:=s||'g_s.holen_uebersetzung(4890,:fas_sprache_id)||'''''')" </a>'''||unistr('\000a')||
'       ||''Die Bestellung enthält mehr als eine Mischung!''||'''''')" </a>'''||unistr('\000a')||
'       ||''  <img src="#IMAGE_PREFIX#red_flag.gif">'''||unistr('\000a')||
'  ELSE NULL'||unistr('\000a')||
'  END suchname,'||unistr('\000a')||
'  to_char(p.geburtsdatum,''DD.MM.YYYY'') geburtsdatum,'||unistr('\000a')||
'  trim(l.iso3_id||'' ''||p.PLZ||'' ''||p.ORT||'' ''||'||unistr('\000a')||
'       p.STRASSE||'' ''||P.NR)  suchadresse,'||unistr('\000a')||
'  b.PERSSTAMM_ID ,'||unistr('\000a')||
'  b.BEMERKUNG ,'||unistr('\000a')||
'  b.REZEPT_N';

s:=s||'R ,'||unistr('\000a')||
'  b.VERSION ,'||unistr('\000a')||
'  b.persstamm_id_betreuer fas_betreuer_id,'||unistr('\000a')||
'  pb.name ||'' ''||pb.vorname fas_betreuer_name,'||unistr('\000a')||
'  DECODE(p.PIS_ADRESSE_ID,NULL,NULL,    -- bevorzugter Betreuer d.akt.patakte'||unistr('\000a')||
'         mailingauftraege_s.GET_BEV_BETREUER(p.PIS_ADRESSE_ID,2)) '||unistr('\000a')||
'         pis_betreuer_adresse_id,'||unistr('\000a')||
'  ad.name||'' ''||ad.vorname pis_betreuer_name,'||unistr('\000a')||
'  CASE'||unistr('\000a')||
'  WHEN frgbg_s.check_fas_rolle(:fas_login_user_account,'||unistr('\000a')||
'    ';

s:=s||'                           ''PRODAUFDISPO_SPEICHERN'') != 0'||unistr('\000a')||
'  THEN'||unistr('\000a')||
'      APEX_ITEM.text(6,to_char(b.plandatum,''dd.mm.yyyy''),10)'||unistr('\000a')||
'  ELSE'||unistr('\000a')||
'      to_char(b.plandatum,''dd.mm.yyyy'')'||unistr('\000a')||
'  END plandatum,'||unistr('\000a')||
'  CASE'||unistr('\000a')||
'  WHEN :P4_toggle_markieren = 1 AND'||unistr('\000a')||
'    (frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STORNO'') != 0'||unistr('\000a')||
' OR frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'')!= 0'||unistr('\000a')||
' OR fr';

s:=s||'gbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_SPEICHERN'')!=0'||unistr('\000a')||
'       )'||unistr('\000a')||
'  THEN'||unistr('\000a')||
'      APEX_ITEM.CHECKBOX(2,b.id,''CHECKED'')'||unistr('\000a')||
'  WHEN :P4_toggle_markieren = 0 AND'||unistr('\000a')||
'    (frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STORNO'') != 0'||unistr('\000a')||
' OR frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0'||unistr('\000a')||
' OR frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_SP';

s:=s||'EICHERN'')!=0'||unistr('\000a')||
'       )'||unistr('\000a')||
'  THEN'||unistr('\000a')||
'     APEX_ITEM.CHECKBOX(2,b.id)'||unistr('\000a')||
'  ELSE '' '''||unistr('\000a')||
'  END markierung,'||unistr('\000a')||
'  b.id,'||unistr('\000a')||
'  NVL(b.plandatum,to_date(''01.01.1800'',''DD.MM.YYYY'') ) plandatum_sort'||unistr('\000a')||
'from bestellungen b, personenstamm p, v_laender l,personenstamm pb,'||unistr('\000a')||
'     adressen ad, mn_rezepte mnr, prodr_verweise pv'||unistr('\000a')||
'     ,prod_rezepte pr  -- NEI 14.02.2011 Sortimentseinfuehrung'||unistr('\000a')||
'where b.persstamm_id = p.id'||unistr('\000a')||
'  and p.LAND_id = l.i';

s:=s||'d (+)'||unistr('\000a')||
'  -- Bestellungen nur für Default Produzierende Apotheke des Betreuers'||unistr('\000a')||
'  and (b.PERSSTAMM_ID_PROD_APO = '||unistr('\000a')||
'           frgbg_s.get_pers_option(:fas_login_user_account,'||unistr('\000a')||
'                 21,frgbg_s.GET_IDENTITAET_BETR(:fas_login_personenstamm_id))'||unistr('\000a')||
'      )'||unistr('\000a')||
'  -- Evt. nur für ausgewählte Identitaet'||unistr('\000a')||
'  and (:p4_persstamm_id_identitaet = 0 OR   -- alle'||unistr('\000a')||
'       b.persstamm_id_identitaet = :p4_persstamm_i';

s:=s||'d_identitaet -- spez.Identit.'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and b.persstamm_id = p.id'||unistr('\000a')||
'  and p.LAND_id = l.id (+)'||unistr('\000a')||
'  /* Alle Bestellungen sollen nun zugreifbar sein, von prod. Apotheke'||unistr('\000a')||
'  -- Falls Rolle ''Prodaufdispo_starten'', dann alle Bestellungen,'||unistr('\000a')||
'  -- sonst nur die des Betreuers + die von zugeordneten Betreuern'||unistr('\000a')||
'  and ( frgbg_s.check_fas_rolle(:fas_login_user_account,'||unistr('\000a')||
'                                ''PRODAUFDISPO_STA';

s:=s||'RTEN'') != 0'||unistr('\000a')||
'        OR  '||unistr('\000a')||
'        b.PERSSTAMM_ID_BETREUER in'||unistr('\000a')||
'           (SELECT persstamm_id_betreuerzugriff'||unistr('\000a')||
'            FROM pers_zugriffe'||unistr('\000a')||
'            WHERE persstamm_id_betreuer = :fas_login_personenstamm_id'||unistr('\000a')||
'           )'||unistr('\000a')||
'      )'||unistr('\000a')||
'   */'||unistr('\000a')||
'  and b.istdatum is null and b.stornodatum is null'||unistr('\000a')||
'  and ( b.plandatum is null OR '||unistr('\000a')||
'        b.plandatum < '||unistr('\000a')||
'        to_date(to_char(NVL(to_date(:p4_such_plandatum,''DD';

s:=s||'.MM.YYYY''),SYSDATE)+1,'||unistr('\000a')||
'                        ''DD.MM.YYYY''),'||unistr('\000a')||
'                ''DD.MM.YYYY'') '||unistr('\000a')||
'      )'||unistr('\000a')||
'  -- bevorzugter Betreuer aus PIS akt. Patakte'||unistr('\000a')||
'  and ad.id(+) =  mailingauftraege_s.GET_BEV_BETREUER(p.PIS_ADRESSE_ID,2)'||unistr('\000a')||
'  -- Betreuername FAS'||unistr('\000a')||
'  and pb.id (+) = b.persstamm_id_betreuer '||unistr('\000a')||
'  -- Toggle gleiche Rezepturen auswerten'||unistr('\000a')||
'  and b.p_rezept_id = pr.id-- NEI 14.02.2011 Sortiment bei Sammelauftrag';

s:=s||' berück.'||unistr('\000a')||
'  and b.mn_rezept_id = mnr.id'||unistr('\000a')||
'  and mnr.rezept_nr_orig = pv.rezept_nr (+)'||unistr('\000a')||
'  and ((:p4_toggle_gleiche_rezepturen = 1 AND'||unistr('\000a')||
'        pv.basis_prodr_verw_id = :p4_basis_prodr_verw_id '||unistr('\000a')||
'        and pr.sortiment_id in '||unistr('\000a')||
'                  ( SELECT pr1.sortiment_id'||unistr('\000a')||
'/*                                FROM v_prod_rezepte pr1, prodr_verweise pv1'||unistr('\000a')||
'                                WHERE pv1.id = :p4_basis_pr';

s:=s||'odr_verw_id '||unistr('\000a')||
'                                  AND pr1.rezept_nr = pv1.rezept_nr'||unistr('\000a')||
'                                  and pr1.AKT_VERSION =1'||unistr('\000a')||
'*/'||unistr('\000a')||
'                    FROM v_mn_rezepte mn1, prod_rezepte pr1, prodr_verweise pv1'||unistr('\000a')||
'                    WHERE pv1.id = :p4_basis_prodr_verw_id '||unistr('\000a')||
'                      and mn1.rezept_nr = pv1.REZEPT_NR'||unistr('\000a')||
'                      and mn1.akt_version = 1'||unistr('\000a')||
'                 ';

s:=s||'     and mn1.rezept_nr = pr1.rezept_nr'||unistr('\000a')||
'                      and mn1.version = pr1.version'||unistr('\000a')||
'                  )'||unistr('\000a')||
'       ) OR'||unistr('\000a')||
'        :p4_toggle_gleiche_rezepturen = 0'||unistr('\000a')||
'      )'||unistr('\000a')||
''||unistr('\000a')||
'/*'||unistr('\000a')||
'  and ((:p4_rezept_nr_orig is not null and'||unistr('\000a')||
'        mnr.rezept_nr_orig = :p4_rezept_nr_orig and'||unistr('\000a')||
'        mnr.version_orig = :p4_version_orig'||unistr('\000a')||
'        ) OR'||unistr('\000a')||
'       (:p4_rezept_nr_orig is null '||unistr('\000a')||
'       )'||unistr('\000a')||
'      )'||unistr('\000a')||
'*/'||unistr('\000a')||
'order by planda';

s:=s||'tum_sort ';

wwv_flow_api.create_report_region (
  p_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_name=> '&P4_REGION_TITEL_AUFTRAGSDISPO.',
  p_region_name=>'',
  p_template=> 3819021965727364+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P4_HEIGHT_LISTE.px;">'||unistr('\000a')||
'',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(1767,frgbg_s.get_sprache_id(:APP_USER)));'||unistr('\000a')||
'',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3859913124056957 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SUCHNAME',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3864918890124823 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'GEBURTSDATUM',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3861917542077115 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SUCHADRESSE',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3862006047077115 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PERSSTAMM_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3862325981077115 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'BEMERKUNG',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3862123379077115 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'REZEPT_NR',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3862223632077115 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'VERSION',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3894821836795003 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'FAS_BETREUER_ID',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3894902512795004 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'FAS_BETREUER_NAME',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3895009385795004 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'PIS_BETREUER_ADRESSE_ID',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3895131796795006 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'PIS_BETREUER_NAME',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3862410821077115 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'PLANDATUM',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_format=> 'DD.MM.YYYY',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3871626880754601 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'MARKIERUNG',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'PLSQL_EXPRESSION',
  p_display_when_condition=> 'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STORNO'') != 0    OR '||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0 OR'||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_SPEICHERN'') != 0 ',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3905022386041618 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3977726159278895 + wwv_flow_api.g_id_offset,
  p_region_id=> 3855426274984970 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'PLANDATUM_SORT',
  p_column_display_sequence=> 15,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3885814270184395 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 10,
  p_button_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUCHEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P4_BL_SUCHEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3882117032059175 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 20,
  p_button_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_button_name    => 'STORNO',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P4_BL_STORNO.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STORNO'') != 0',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3881632139054095 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 40,
  p_button_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_button_name    => 'SPEICHERN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P4_BL_PLANDATEN_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_SPEICHERN'') != 0',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3882503311064698 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 50,
  p_button_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_button_name    => 'STARTEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P4_BL_AUFTRAG_STARTEN.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>5392514025997893 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:3:&SESSION.::&DEBUG.::P3_REFERENZ_ID,P3_PAGE:&P4_SERIENNUMMER.,4',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3882503311064698+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 2,
  p_branch_condition_type=> 'NEVER',
  p_branch_condition=> ':p4_seriennummer > 0 AND FALSE',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 05-MRZ-2009 14:45 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>4632018485508651 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:4:&SESSION.:FEHLERAUSGABE:&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3882503311064698+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 6,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':p4_fehlertext is not null',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 14-OKT-2008 11:56 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>3873327853343164 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 18-JUN-2008 10:12 by FRGBG');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2063912229318365 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_DRUCKOPTION',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> 'DECLARE'||unistr('\000a')||
'   v_text   VARCHAR2(100);'||unistr('\000a')||
'   CURSOR c_opt is'||unistr('\000a')||
'     select wert'||unistr('\000a')||
'     from optionswerte'||unistr('\000a')||
'     where opttyp_id = 19'||unistr('\000a')||
'       and standard = 1'||unistr('\000a')||
'     order by sortierung desc;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_opt in c_opt LOOP'||unistr('\000a')||
'       v_text := r_opt.wert||'':''||v_text;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   RETURN v_text;'||unistr('\000a')||
'END;'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'',
  p_item_default_type=> 'PLSQL_FUNCTION_BODY',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_CHECKBOX',
  p_lov=> 'SELECT '||unistr('\000a')||
'fas_synch.get_tab_uebersetzung(''OPTIONSWERTE.BEZEICHNUNG'',ID,:fas_sprache_id) a,'||unistr('\000a')||
'wert b'||unistr('\000a')||
'FROM optionswerte'||unistr('\000a')||
'where opttyp_id = 19 /* Auftragsbearb.Druckoptionen */'||unistr('\000a')||
'order by sortierung'||unistr('\000a')||
''||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'CENTER',
  p_display_when=>'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0 AND'||unistr('\000a')||
':p4_druckart != 0 /* Kein Druck */',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => '2',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2662400310127420 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_PERSSTAMM_ID_IDENTITAET',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(511,:fas_sprache_id) a, 0 b'||unistr('\000a')||
'from dual'||unistr('\000a')||
'UNION '||unistr('\000a')||
'select distinct substr(p.name,1,30)||'', ''||substr(p.ort,1,30)||'', ''||p.id, wk.persstamm_id_identitaet'||unistr('\000a')||
'from bestellungen b,'||unistr('\000a')||
'     warenkoerbe wk, warenkorb_details wkd,personenstamm p'||unistr('\000a')||
'where b.istdatum is null'||unistr('\000a')||
'  and b.WARENKORB_DETAIL_ID = wkd.id'||unistr('\000a')||
'  and wkd.warenkorb_id = wk.id'||unistr('\000a')||
'  /* Bestellungen nur für Default Produzierende Apotheke des Betreuers */'||unistr('\000a')||
'  and (wk.PERSSTAMM_ID_PROD_APO ='||unistr('\000a')||
'           frgbg_s.get_pers_option(:fas_login_user_account,'||unistr('\000a')||
'                 21,frgbg_s.GET_IDENTITAET_BETR(:fas_login_personenstamm_id))'||unistr('\000a')||
'       or'||unistr('\000a')||
'       wk.PERSSTAMM_ID_PROD_APO is null'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and wk.PERSSTAMM_ID_IDENTITAET = p.id'||unistr('\000a')||
'  and b.istdatum is null and b.stornodatum is null'||unistr('\000a')||
'  and ( b.plandatum is null OR '||unistr('\000a')||
'        b.plandatum < '||unistr('\000a')||
'        to_date(to_char(NVL(to_date(:p4_such_plandatum,''DD.MM.YYYY''),SYSDATE)+1,'||unistr('\000a')||
'                        ''DD.MM.YYYY''),'||unistr('\000a')||
'                ''DD.MM.YYYY'') '||unistr('\000a')||
'      )'||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'SUBMIT',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3864323822107351 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_HEIGHT_LISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Liste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3865815913209121 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_TOGGLE_MARKIEREN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_RADIOGROUP',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(1769,:fas_sprache_id) a,0 b'||unistr('\000a')||
'FROM DUAL'||unistr('\000a')||
'UNION '||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(1768,:fas_sprache_id) , 1 '||unistr('\000a')||
'FROM DUAL'||unistr('\000a')||
'order by 2',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STORNO'') != 0 OR'||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0 or'||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_SPEICHERN'') != 0',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => '1',
  p_attribute_02 => 'SUBMIT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3875327403560659 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_SUCH_PLANDATUM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> 'to_char(sysdate,''DD.MM.YYYY'')',
  p_item_default_type=> 'PLSQL_EXPRESSION',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 10,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3877406213724904 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_ANZAHL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 35,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'DECLARE'||unistr('\000a')||
'   v_optwert_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   v_optwert_id := frgbg_s.get_pers_option(:APP_USER,5);'||unistr('\000a')||
'   RETURN (v_optwert_id);'||unistr('\000a')||
'END;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0 AND'||unistr('\000a')||
':p4_druckart != 0 /* Kein Druck */',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3889115605324910 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_FEHLERTEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Fehlertext',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3991719716530628 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_BL_PLANDATEN_SPEICHERN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Plandaten Speichern',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3991924218532009 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_BL_STORNO',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Storno',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3992132183534251 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_BL_AUFTRAG_STARTEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Auftrag Starten',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3992726212551489 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_REGION_TITEL_AUFTRAGSDISPO',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Region Titel Auftragsdispo',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3993621888588096 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_BL_SUCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Suchen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4221118492435728 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_SERIENNUMMER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Seriennummer',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4553931588937159 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_DRUCKART',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'frgbg_s.get_pers_option(:APP_USER,15);',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT fas_synch.get_tab_uebersetzung(''OPTIONSWERTE.BEZEICHNUNG'','||unistr('\000a')||
'                               ow.ID,:fas_sprache_id) a,'||unistr('\000a')||
'       ow.wert b'||unistr('\000a')||
'FROM optionswerte ow, pers_optionen po, optionstypen ot    /* Subsetzugriff */'||unistr('\000a')||
'where ow.opttyp_id = ot.id  /* JOIN OT */'||unistr('\000a')||
'  and ot.art = 1        /* Subset */'||unistr('\000a')||
'  and ow.opttyp_id = 15 /* Druckart */'||unistr('\000a')||
'  and ow.opttyp_id = po.opttyp_id'||unistr('\000a')||
'  and ow.wert = po.wert'||unistr('\000a')||
'  and po.persstamm_id ='||unistr('\000a')||
'      frgbg_s.GET_PERS_OPT_PERS_ID(:FAS_LOGIN_PERSONENSTAMM_ID,ow.opttyp_id,'||unistr('\000a')||
'          :fas_identitaet_persstamm_id) /*Persid des Subsets sonst null */'||unistr('\000a')||
'UNION'||unistr('\000a')||
'/* Zugriff auf Optionswerte, da keine Subsetdef. od. da Def.wertverwaltg*/'||unistr('\000a')||
'SELECT fas_synch.get_tab_uebersetzung(''OPTIONSWERTE.BEZEICHNUNG'','||unistr('\000a')||
'                                      ow.ID,:fas_sprache_id) a,'||unistr('\000a')||
'       ow.wert b'||unistr('\000a')||
'FROM optionswerte ow, optionstypen ot'||unistr('\000a')||
'where ow.opttyp_id = 15 /* Druckart */'||unistr('\000a')||
'  and ow.opttyp_id = ot.id  /* JOIN OT */'||unistr('\000a')||
'  and (ot.art = 1 and /* Subset und keine Subsetdefinition gefunden*/'||unistr('\000a')||
'       frgbg_s.GET_PERS_OPT_PERS_ID(:FAS_LOGIN_PERSONENSTAMM_ID,ow.opttyp_id,'||unistr('\000a')||
'                 :fas_identitaet_persstamm_id) IS NULL'||unistr('\000a')||
'       OR'||unistr('\000a')||
'       ot.art != 1  /* Kein Subset */'||unistr('\000a')||
'      )'||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'frgbg_s.check_fas_rolle(:APP_USER,''DRUCKART_AENDERN'')> 0',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'SUBMIT',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4617219701102301 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_TOGGLE_GLEICHE_REZEPTUREN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 24,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'0',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_RADIOGROUP',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(2331,:fas_sprache_id)||'||unistr('\000a')||
'       DECODE(:p4_basis_prodr_verw_id,NULL,NULL,'||unistr('\000a')||
'              '' ''||:p4_kuerzel_waage)||'||unistr('\000a')||
'       ''&nbsp;&nbsp;&nbsp;'' a,'||unistr('\000a')||
'       1 b'||unistr('\000a')||
'from dual'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(1936,:fas_sprache_id)||'||unistr('\000a')||
'       ''&nbsp;&nbsp;&nbsp;'' a, 0 b'||unistr('\000a')||
'from dual',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'CENTER',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => '1',
  p_attribute_02 => 'SUBMIT',
  p_attribute_03 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4697319455738759 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_BASIS_PRODR_VERW_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Basis Prodr Verw Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4700824452251104 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_KUERZEL_WAAGE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 180,
  p_item_plug_id => 3855426274984970+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Kuerzel Waage',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3887924751362440 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_eingabe_plandatum',
  p_validation_sequence=> 10,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_mutdat      VARCHAR2(25);'||unistr('\000a')||
'   v_datum       DATE;'||unistr('\000a')||
'   v_neue_zeile  varchar2(10) := ''<br/>'';--chr(13)||chr(10); '||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id     NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Eingaben validieren Anzahl=%1'',v_prot_id,''Info'','||unistr('\000a')||
'-- ''Eingaben  validieren'',apex_application.g_f02.count);'||unistr('\000a')||
'   FOR j in 1..apex_application.g_f02.count  LOOP'||unistr('\000a')||
'      FOR i in 1..apex_application.g_f01.count  LOOP'||unistr('\000a')||
'          IF apex_application.g_f01(i) = apex_application.g_f02(j) THEN'||unistr('\000a')||
'             IF NVL(apex_application.G_F03(i),''1'') != '||unistr('\000a')||
'                NVL(apex_application.G_F06(i),''1'') '||unistr('\000a')||
'             THEN  -- geänderte Plandaten prüfen'||unistr('\000a')||
'                -- Prüfen, ob Bestellung zwischenzeitlich geändert wurde'||unistr('\000a')||
'                SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') '||unistr('\000a')||
'                INTO v_mutdat'||unistr('\000a')||
'                FROM bestellungen'||unistr('\000a')||
'                WHERE  id = apex_application.g_f01(i);'||unistr('\000a')||
'                IF v_mutdat != apex_application.g_f07(i) THEN'||unistr('\000a')||
'                   v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                    -- ''Datensätze bereits anderweitig geändert wurden!....'||unistr('\000a')||
'                      frgbg_s.holen_uebersetzung(1791,:fas_sprache_id,'||unistr('\000a')||
'                      ''(''||apex_application.g_f08(i)||'')'');'||unistr('\000a')||
'                END IF;'||unistr('\000a')||
''||unistr('\000a')||
'                -- Check Istzeit'||unistr('\000a')||
'                BEGIN'||unistr('\000a')||
'                   v_datum := to_date(apex_application.g_f06(i),'||unistr('\000a')||
'                                  ''DD.MM.RRRR'');'||unistr('\000a')||
'                EXCEPTION'||unistr('\000a')||
'                WHEN OTHERS THEN'||unistr('\000a')||
'                   v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                      --''Kein gültige Datum/Uhrzeit der Form TT.MM.JJJJ ...'||unistr('\000a')||
'                      frgbg_s.holen_uebersetzung(1792,:fas_sprache_id,'||unistr('\000a')||
'                      ''(''||apex_application.g_f08(i)||'')'');'||unistr('\000a')||
'                END;'||unistr('\000a')||
'                -- Istzeit >= Tagesdatum'||unistr('\000a')||
'                IF v_datum < to_date(sysdate,''DD.MM.RRRR'') THEN'||unistr('\000a')||
'                   v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                      --''Das Plandatum muss grösser oder gleich Tagesdatum ...'||unistr('\000a')||
'                      frgbg_s.holen_uebersetzung(1811,:fas_sprache_id,'||unistr('\000a')||
'                      ''(''||apex_application.g_f08(i)||'')'');'||unistr('\000a')||
'                END IF;'||unistr('\000a')||
'             END IF;'||unistr('\000a')||
'             EXIT;'||unistr('\000a')||
'          END IF;'||unistr('\000a')||
'      END LOOP;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   -- Fehlertext wird erst am Anfang vom Speichern ausgewertet und mit Raise angezeigt, damit keine refresh der Daten durchführt wird'||unistr('\000a')||
'   :p4_fehlertext := substr(v_fehlertext,length(v_neue_zeile)+1);'||unistr('\000a')||
'   RETURN NULL;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 3881632139054095 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3897624353902789 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_change_by_another_user',
  p_validation_sequence=> 20,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_mutdat      VARCHAR2(25);'||unistr('\000a')||
'   v_datum       DATE;'||unistr('\000a')||
'   v_neue_zeile  varchar2(10) := ''<br/>''; '||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id     NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Eingaben validieren Anzahl=%1'',v_prot_id,''Info'','||unistr('\000a')||
'-- ''Eingaben  validieren'',apex_application.g_f02.count);'||unistr('\000a')||
'   FOR j in 1..apex_application.g_f02.count  LOOP'||unistr('\000a')||
'      FOR i in 1..apex_application.g_f01.count  LOOP'||unistr('\000a')||
'          IF apex_application.g_f01(i) = apex_application.g_f02(j) THEN'||unistr('\000a')||
'                -- Prüfen, ob Bestellung zwischenzeitlich geändert wurde'||unistr('\000a')||
'                SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') '||unistr('\000a')||
'                INTO v_mutdat'||unistr('\000a')||
'                FROM bestellungen'||unistr('\000a')||
'                WHERE  id = apex_application.g_f01(i);'||unistr('\000a')||
'                IF v_mutdat != apex_application.g_f07(i) THEN'||unistr('\000a')||
'                   v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                    -- 1791''Die Eingaben können nicht gespeichert werden , da die Datensätze bereits anderweitig geändert wurden!....'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(1791,:fas_sprache_id,'||unistr('\000a')||
'                     ''(''||apex_application.g_f08(i)||'')'');'||unistr('\000a')||
'                END IF;'||unistr('\000a')||
''||unistr('\000a')||
'             EXIT;'||unistr('\000a')||
'          END IF;'||unistr('\000a')||
'      END LOOP;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   -- Fehlertext wird erst am Anfang vom Speichern ausgewertet und mit Raise angezeigt, damit keine refresh der Daten durchführt wird'||unistr('\000a')||
'   :p4_fehlertext := substr(v_fehlertext,length(v_neue_zeile)+1);'||unistr('\000a')||
'   RETURN NULL;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''STARTEN'',''STORNO'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_fehlertext varchar2(4000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :fas_identitaet_persstamm_id:= :p4_persstamm_id_identitaet ;'||unistr('\000a')||
'/*mel.p(''Ident: %1, %2'',v_prot_id,''INFO'',''104/4:set_fas_ident'',:fas_identitaet_persstamm_id,:p4_persstamm_id_identitaet);'||unistr('\000a')||
'*/'||unistr('\000a')||
'   -- Sortiment-ID der aktiven Identitaet '||unistr('\000a')||
'   -- NEI 14.02.2011 Sortimentseinfuehrung   '||unistr('\000a')||
'   :FAS_SORTIMENT_ID:= rezepte.get_sortiment(:FAS_IDENT';

p:=p||'ITAET_PERSSTAMM_ID,''IDENTITAET'');'||unistr('\000a')||
'   IF :FAS_SORTIMENT_ID <= 0 OR '||unistr('\000a')||
'      :FAS_SORTIMENT_ID is NULL'||unistr('\000a')||
'   THEN '||unistr('\000a')||
'      :FAS_SORTIMENT_ID := '''';'||unistr('\000a')||
'      v_fehlertext := frgbg_s.holen_uebersetzung(3518,:fas_sprache_id);'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,v_fehlertext );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1378628015445725 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 5,
  p_process_point=> 'AFTER_FOOTER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_fas_ident',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request = ''P4_PERSSTAMM_ID_IDENTITAET'' ',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_return  NUMBER;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Plandatum speichern %1, %2, %3, %4, %5'', v_prot_id,''Info'',''Auftragsdispo'', :request);'||unistr('\000a')||
'   IF :p4_fehlertext IS NOT NULL THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,:p4_fehlertext);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   '||unistr('\000a')||
'   v_return := auftragsdispo.ad_save_plandatum(:APP_USER); '||unistr('\000a')||
'   IF v_return < 0 THEN -- Fehler beim Speichern der markierten Bestellungen!'||unistr('\000a')||
'   ';

p:=p||'   RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(1812,:fas_sprache_id,'||unistr('\000a')||
'                                                                 to_char(v_return))'||unistr('\000a')||
'                              );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
' END;';

wwv_flow_api.create_page_process(
  p_id     => 3888101904431503 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ad_plandatum_speichern',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3881632139054095 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_return  NUMBER;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Plandatum speichern %1, %2, %3, %4, %5'', v_prot_id,''Info'',''Auftragsdispo'', :request);'||unistr('\000a')||
'   IF :p4_fehlertext IS NOT NULL THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,:p4_fehlertext);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   '||unistr('\000a')||
'   v_return := auftragsdispo.ad_bestell_storno(:APP_USER); '||unistr('\000a')||
'   IF v_return < 0 THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_ueber';

p:=p||'setzung(1812,:fas_sprache_id,'||unistr('\000a')||
'                                                                 to_char(v_return))'||unistr('\000a')||
'                              );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
' END;';

wwv_flow_api.create_page_process(
  p_id     => 3890309474455585 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'bestellung_stornieren',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3882117032059175 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_return  NUMBER;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'   v_parameter VARCHAR2(50);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
''||unistr('\000a')||
'--MEL.P(''Dispo starten %1, %2, %3, %4, %5'', v_prot_id,''Info'',''Auftragsdispo'', :request);'||unistr('\000a')||
'   IF :p4_fehlertext IS NOT NULL THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,:p4_fehlertext);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   :p4_fehlertext := NULL;  -- initialisieren damit Folgefehler bei ad_gen_prod erkannt werden'||unistr('\000a')||
''||unistr('\000a')||
'   IF apex_application.G_';

p:=p||'F02.COUNT > 0 THEN'||unistr('\000a')||
''||unistr('\000a')||
'      -- Aufträge erzeugen => Seriennur'||unistr('\000a')||
'      :p4_seriennummer := null;'||unistr('\000a')||
'      IF :p4_toggle_gleiche_rezepturen = 1 THEN  -- Sammelauftrag'||unistr('\000a')||
'         v_return := auftragsdispo.ad_gen_prodauftrag_sammel(:APP_USER,'||unistr('\000a')||
'                                                        :fas_login_personenstamm_id,'||unistr('\000a')||
'                                                        :p4_basis_prodr_verw_id'||unistr('\000a')||
'     ';

p:=p||'                                                  ); '||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         v_return := auftragsdispo.ad_gen_prodauftrag(:APP_USER); '||unistr('\000a')||
'      END IF;'||unistr('\000a')||
''||unistr('\000a')||
'      IF v_return = 0 THEN  '||unistr('\000a')||
'         -- gesamter Auftrag konnte nicht ausgeführt werden'||unistr('\000a')||
'         -- mit raise bleibt man in dem Zustand stehen'||unistr('\000a')||
'         RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(1812,:fas_sprache_id,'||unistr('\000a')||
'                   ';

p:=p||'                                                 to_char(v_return))'||unistr('\000a')||
'                                 );'||unistr('\000a')||
'      elsif v_return < 0 THEN  -- Nicht alle Bestellungen bearbeitet; einige fehlerhaft'||unistr('\000a')||
'          -- Fehlermeldung wird im Seitenaufbau bearbeitet und ausgegeben'||unistr('\000a')||
'          :p4_fehlertext := frgbg_s.holen_uebersetzung(2332,:fas_sprache_id);'||unistr('\000a')||
'         v_return := -v_return; '||unistr('\000a')||
'      END IF;'||unistr('\000a')||
''||unistr('\000a')||
'      --';

p:=p||' Formulardruck'||unistr('\000a')||
'      IF v_return > 0   and     -- seriennr für Druck vorhanden'||unistr('\000a')||
'         :p4_druckart != 0              -- Druck erwünscht'||unistr('\000a')||
'      THEN -- seriennr für Druck vorhanden'||unistr('\000a')||
'         -- NEI 14.04.09 p4_anzahl ausgeblendet => immer 1 '||unistr('\000a')||
'         :p4_anzahl := 1; '||unistr('\000a')||
'--MEL.P(''Dispodruck starten für Serie %1 mit Anz %2, opt %3, art %4'', --v_prot_id,''Info'',''Auftragsdispo'', v_return, :p4_anzahl,:p4_d';

p:=p||'ruckoption,:p4_druckart);'||unistr('\000a')||
'         IF NVL(:p4_anzahl,0) > 0 THEN'||unistr('\000a')||
'            :p4_seriennummer := v_return;'||unistr('\000a')||
' /* alt           DOKUMENTEN_DRUCK.auftragsdispo_druck(v_return,:p4_prod_auftrag_anzahl,'||unistr('\000a')||
'                                             --  :p4_etikettentyp,:p4_etikettenanzahl,'||unistr('\000a')||
'                                              NULL,:p4_etikettenanzahl,'||unistr('\000a')||
'                                             ';

p:=p||' 0,:p4_zusatzformular_anzahl'||unistr('\000a')||
'                                              );'||unistr('\000a')||
'*/'||unistr('\000a')||
'            FRGBG_JOBS.START_JOB('||unistr('\000a')||
'               p_what => ''IREPORT.auftragsdispo_druck('' || NVL(to_char(:p4_seriennummer),''NULL'') ||'','||unistr('\000a')||
'                                                 NULL,    -- auftrag_id innerhalb der Serie'||unistr('\000a')||
'                                                 '' || NVL(to_char(:p4_anzahl),''NULL'') || '',';

p:=p||''||unistr('\000a')||
'                                                 '''':''||:p4_druckoption||'':'''','||unistr('\000a')||
'                                                 NULL --:p4_druckart'||unistr('\000a')||
'                                              );'','||unistr('\000a')||
'               p_beschreibung           => ''Drucke Auftragsdispo'','||unistr('\000a')||
'               p_max_jobs_same          => 1,'||unistr('\000a')||
'               p_max_jobs_total         => 1,'||unistr('\000a')||
'               p_visible                =>';

p:=p||' 1,'||unistr('\000a')||
'               p_valid_days             => 1,'||unistr('\000a')||
'               p_hide_by_complete       => 1,'||unistr('\000a')||
'               p_umleitung_url          => CASE WHEN '||unistr('\000a')||
'                  :p4_seriennummer > 0 THEN ''f?p='' || :APP_ID || '':3:'' '||unistr('\000a')||
'                  || :APP_SESSION || ''::::P3_REFERENZ_ID,P3_PAGE:'' ||:P4_SERIENNUMMER || '',4'' '||unistr('\000a')||
'                 ELSE null '||unistr('\000a')||
'                 END'||unistr('\000a')||
'            );'||unistr('\000a')||
''||unistr('\000a')||
'/*'||unistr('\000a')||
'            IRE';

p:=p||'PORT.auftragsdispo_druck(:p4_seriennummer,-- seriennr'||unistr('\000a')||
'                                                 NULL,    -- auftrag_id innerhalb der Serie'||unistr('\000a')||
'                                                 :p4_anzahl,'||unistr('\000a')||
'                                                 '':''||:p4_druckoption||'':'','||unistr('\000a')||
'                                                 NULL --:p4_druckart'||unistr('\000a')||
'                                              );';

p:=p||''||unistr('\000a')||
'*/'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      END IF; '||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :p4_fehlertext := frgbg_s.holen_uebersetzung(2352,:fas_sprache_id);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
' END;';

wwv_flow_api.create_page_process(
  p_id     => 3904018821557979 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 25,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'auftragsdisp_starten',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3882503311064698 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_mutdat      VARCHAR2(25);'||unistr('\000a')||
'   v_datum       DATE;'||unistr('\000a')||
'   v_neue_zeile  varchar2(10) := ''<br/>'';--chr(13)||chr(10); '||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id     NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Init gleiche Rezepturen Anzahl=%1'',v_prot_id,''Info'','||unistr('\000a')||
'-- ''gleiche Rezepturen'',apex_application.g_f02.count);'||unistr('\000a')||
'   IF :p4_toggle_gleiche_rezepturen = 1 THEN -- Gleiche Rezepturen gewünscht'||unistr('\000a')||
'      IF apex_appl';

p:=p||'ication.g_f02.count > 0 THEN'||unistr('\000a')||
'         -- Setze Rezept_nr/version original'||unistr('\000a')||
'         BEGIN'||unistr('\000a')||
'            SELECT NVL(pv.basis_prodr_verw_id,pv.id), kuerzel_waage'||unistr('\000a')||
'            INTO   :p4_basis_prodr_verw_id, :p4_kuerzel_waage'||unistr('\000a')||
'            FROM bestellungen b, mn_rezepte mnr, prodr_verweise pv'||unistr('\000a')||
'            WHERE b.id = apex_application.g_f02(1)            -- 1. markierte Bestellung'||unistr('\000a')||
'              and b.mn_re';

p:=p||'zept_id = mnr.id'||unistr('\000a')||
'              and mnr.rezept_nr_orig = pv.rezept_nr'||unistr('\000a')||
'              and pv.satz_kennzeichen is null;'||unistr('\000a')||
'         EXCEPTION'||unistr('\000a')||
'         WHEN others THEN'||unistr('\000a')||
'            :p4_basis_prodr_verw_id := NULL;'||unistr('\000a')||
'            :p4_kuerzel_waage := NULL;'||unistr('\000a')||
'         END ;'||unistr('\000a')||
'         IF :p4_basis_prodr_verw_id IS NOT NULL THEN'||unistr('\000a')||
'            :p4_toggle_gleiche_rezepturen := 1;'||unistr('\000a')||
'         ELSE'||unistr('\000a')||
'            :p4_basis_pro';

p:=p||'dr_verw_id := NULL;'||unistr('\000a')||
'            :p4_kuerzel_waage := NULL;'||unistr('\000a')||
'            :p4_toggle_gleiche_rezepturen := 0;'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         :p4_basis_prodr_verw_id := NULL;'||unistr('\000a')||
'         :p4_kuerzel_waage := NULL;'||unistr('\000a')||
'         :p4_toggle_gleiche_rezepturen := 0;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'     :p4_basis_prodr_verw_id := NULL;'||unistr('\000a')||
'     :p4_kuerzel_waage := NULL;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4615832496954645 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'gleiche_rezepturen_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request = ''P4_TOGGLE_GLEICHE_REZEPTUREN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p4_toggle_markieren := 0;';

wwv_flow_api.create_page_process(
  p_id     => 3890619433477345 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 90,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'markierung_zurücksetzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SPEICHERN'',''STARTEN'',''STORNO'',''P4_TOGGLE_GLEICHE_REZEPTUREN'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Komplette Höhe ausnutzen (100% des Maximums)'||unistr('\000a')||
'   :P4_HEIGHT_Liste := :FAS_SCROLLREGION_HEIGHT_MAX * 1;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3864014472104610 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'scrollheight_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p4_bl_storno := frgbg_s.holen_uebersetzung(1945,v_sprache_id);'||unistr('\000a')||
'   :p4_bl_plandaten_speichern := frgbg_s.holen_uebersetzung(1942,v_sprache_id);'||unistr('\000a')||
'   :p4_bl_auftrag_starten   := frgbg_s.holen_uebersetzung(1943,v_sprache_id);'||unistr('\000a')||
'   :p4_bl_suchen := frgbg_s.holen_uebersetzung(481,v_sprache_id);'||unistr('\000a')||
'  '||unistr('\000a')||
'   :p4_regi';

p:=p||'on_titel_auftragsdispo := frgbg_s.holen_uebersetzung(1944,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3991412659519139 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'htp.p(''<body>'');'||unistr('\000a')||
'htp.p(''<script type="text/javascript">'');'||unistr('\000a')||
'htp.p(''alert("''||:p4_fehlertext||''");'');'||unistr('\000a')||
'htp.p(''</script>'');'||unistr('\000a')||
'htp.p(''</body>'');'||unistr('\000a')||
':p4_fehlertext := NULL;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4631716276498545 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 100,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'fehlerausgabe_nach_start',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':p4_fehlertext is not null and :request = ''FEHLERAUSGABE''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 4
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00005
prompt  ...PAGE 5: Produktionsauftragsbearbeitung
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 5
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Produktionsauftragsbearbeitung'
 ,p_step_title => 'Produktionsauftragsbearbeitung'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Produktionsauftragsbearbeitung'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3979322781387567 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20140617112651'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT'||unistr('\000a')||
'  APEX_ITEM.hidden(1,pa.id) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(3,pa.sort) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(4,b.persstamm_id) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(5,b.p_rezept_id) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(7,to_char(pa.mutdat,''DD.MM.YYYY HH24:MI:SS'')) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(8,p.name||'' ''||p.vorname) ||'||unistr('\000a')||
'  APEX_ITEM.hidden(9,pa.serien_nr) ||'||unistr('\000a')||
'  trim(p.name || '' '' || p.vorname) suchname,'||unistr('\000a')||
'  to_char(p.geburtsdatum,''DD.MM.YYYY'') geburtsdatum';

s:=s||','||unistr('\000a')||
'  trim(l.iso3_id||'' ''||p.PLZ||'' ''||p.ORT||'' ''||'||unistr('\000a')||
'       p.STRASSE||'' ''||P.NR)  suchadresse,'||unistr('\000a')||
'  b.PERSSTAMM_ID ,'||unistr('\000a')||
'  b.BEMERKUNG ,'||unistr('\000a')||
'  b.REZEPT_NR ,'||unistr('\000a')||
'  b.VERSION ,'||unistr('\000a')||
'  b.persstamm_id_betreuer fas_betreuer_id,'||unistr('\000a')||
'  pb.name ||'' ''||pb.vorname fas_betreuer_name,'||unistr('\000a')||
'  DECODE(p.PIS_ADRESSE_ID,NULL,NULL,    -- bevorzugter Betreuer d.akt.patakte'||unistr('\000a')||
'         mailingauftraege_s.GET_BEV_BETREUER(p.PIS_ADRESSE_ID,2)) '||unistr('\000a')||
'       ';

s:=s||'  pis_betreuer_adresse_id,'||unistr('\000a')||
'  ad.name||'' ''||ad.vorname pis_betreuer_name,'||unistr('\000a')||
'  CASE'||unistr('\000a')||
'  WHEN frgbg_s.check_fas_rolle(:fas_login_user_account,'||unistr('\000a')||
'                               ''PRODAUFBEARB_SPEICHERN'') != 0 AND'||unistr('\000a')||
'     pa.status in (0,4)'||unistr('\000a')||
'  THEN'||unistr('\000a')||
'     APEX_ITEM.text(6,to_char(pa.sort),7)'||unistr('\000a')||
'  ELSE'||unistr('\000a')||
'     APEX_ITEM.hidden(6,to_char(pa.sort))||'||unistr('\000a')||
'     to_char(pa.sort)'||unistr('\000a')||
'  END pa_sort,'||unistr('\000a')||
'  CASE'||unistr('\000a')||
'  WHEN :P5_toggle_markieren = ';

s:=s||'1 AND'||unistr('\000a')||
'    (frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STORNO'') != 0'||unistr('\000a')||
' OR frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STARTEN'')!= 0'||unistr('\000a')||
' OR frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_SPEICHERN'')!=0'||unistr('\000a')||
'       ) AND'||unistr('\000a')||
'     pa.status in (0,2,4)    '||unistr('\000a')||
'  THEN'||unistr('\000a')||
'      APEX_ITEM.CHECKBOX(2,pa.id,''CHECKED'')'||unistr('\000a')||
'  WHEN :P5_toggle_markieren = 0 AND'||unistr('\000a')||
'    (frgbg_s.check_fas';

s:=s||'_rolle(:fas_login_user_account,''PRODAUFBEARB_STORNO'') != 0'||unistr('\000a')||
' OR frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STARTEN'') != 0'||unistr('\000a')||
' OR frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_SPEICHERN'')!=0'||unistr('\000a')||
'       ) AND'||unistr('\000a')||
'     pa.status in (0,2,4) '||unistr('\000a')||
'  THEN'||unistr('\000a')||
'     APEX_ITEM.CHECKBOX(2,pa.id)'||unistr('\000a')||
'  ELSE '' '''||unistr('\000a')||
'  END markierung,'||unistr('\000a')||
'  pa.id auftrag_id,'||unistr('\000a')||
'  pa.status,pa.serien_nr,'||unistr('\000a')||
'  pa.sort    -- zur Sort';

s:=s||'ierung'||unistr('\000a')||
'from bestellungen b, personenstamm p, v_laender l,personenstamm pb,'||unistr('\000a')||
'     adressen ad,'||unistr('\000a')||
'     auftraege pa'||unistr('\000a')||
'where pa.bestell_id = b.id  '||unistr('\000a')||
'  and pa.status not in (3)'||unistr('\000a')||
'  and b.istdatum is not null and b.stornodatum is null'||unistr('\000a')||
'  and ( (:p5_toggle_status = 1 AND pa.status != 2)  OR  -- nicht abgeschlossen'||unistr('\000a')||
'        (:p5_toggle_status = 2)                     OR  -- alle'||unistr('\000a')||
'        (:p5_toggle_status = 3 AND ';

s:=s||'pa.status = 2)       -- abgeschlossene'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and (:p5_such_datum is null OR '||unistr('\000a')||
'        pa.erfdat >= to_date(:p5_such_datum,''DD.MM.YYYY'')'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and b.persstamm_id = p.id'||unistr('\000a')||
'  and p.LAND_id = l.id (+)'||unistr('\000a')||
'/*  -- Bestellungen nur für Default Produzierende Apotheke des Betreuers'||unistr('\000a')||
'  and (b.PERSSTAMM_ID_PROD_APO = '||unistr('\000a')||
'           frgbg_s.get_pers_option(:fas_login_user_account,'||unistr('\000a')||
'                 21,frgbg_s.GET';

s:=s||'_IDENTITAET_BETR(:fas_login_personenstamm_id))'||unistr('\000a')||
'      )'||unistr('\000a')||
'*/'||unistr('\000a')||
'  -- Bestellungen für alle produzierenden Apotheken des Betreuers, damit auch'||unistr('\000a')||
'  -- Aufträge ehemaliger Prod. Apotheke sichtbar bleiben (Biogena) 15.10.10'||unistr('\000a')||
'  and (b.PERSSTAMM_ID_PROD_APO in ('||unistr('\000a')||
'          select wert      '||unistr('\000a')||
'          from pers_optionen'||unistr('\000a')||
'          where opttyp_id = 21'||unistr('\000a')||
'            and persstamm_id in ('||unistr('\000a')||
'               select frgbg_s.';

s:=s||'GET_PERS_OPT_PERS_ID( :fas_login_personenstamm_id,'||unistr('\000a')||
'                    21,frgbg_s.GET_IDENTITAET_BETR(:fas_login_personenstamm_id))'||unistr('\000a')||
'               from dual)       '||unistr('\000a')||
'          )'||unistr('\000a')||
'     ) '||unistr('\000a')||
''||unistr('\000a')||
'/*'||unistr('\000a')||
'  Umgestellt auf produzierende Apotheke des Betreuers'||unistr('\000a')||
'  -- Falls Rolle ''Prodaufbearb_starten'', dann alle Bestellungen,'||unistr('\000a')||
'  -- sonst nur die des Betreuers + die von zugeordneten Betreuern'||unistr('\000a')||
'  and ( frgbg_s.check_fas_';

s:=s||'rolle(:fas_login_user_account,'||unistr('\000a')||
'                                ''PRODAUFBEARB_STARTEN'') != 0'||unistr('\000a')||
'        OR  '||unistr('\000a')||
'        b.PERSSTAMM_ID_BETREUER in'||unistr('\000a')||
'           (SELECT persstamm_id_betreuerzugriff'||unistr('\000a')||
'            FROM pers_zugriffe'||unistr('\000a')||
'            WHERE persstamm_id_betreuer = :fas_login_personenstamm_id'||unistr('\000a')||
'           )'||unistr('\000a')||
'      )'||unistr('\000a')||
'*/'||unistr('\000a')||
'  -- bevorzugter Betreuer aus PIS akt. Patakte'||unistr('\000a')||
'  and ad.id(+) =  mailingauftraege_s.GET';

s:=s||'_BEV_BETREUER(p.PIS_ADRESSE_ID,2)'||unistr('\000a')||
'  -- Betreuername FAS'||unistr('\000a')||
'  and pb.id (+) = b.persstamm_id_betreuer '||unistr('\000a')||
'order by  sort ';

wwv_flow_api.create_report_region (
  p_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_name=> '&P5_REGION_TITEL_AUFTRAGSBEARB.',
  p_region_name=>'',
  p_template=> 3819021965727364+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P5_HEIGHT_LISTE.px;">'||unistr('\000a')||
'',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(1940,frgbg_s.get_sprache_id(:APP_USER)));'||unistr('\000a')||
'',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '100',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3980101789363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SUCHNAME',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3980020200363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'GEBURTSDATUM',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3979400738363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SUCHADRESSE',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3979510454363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PERSSTAMM_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3979822938363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'BEMERKUNG',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3979612036363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'REZEPT_NR',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3979726393363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'VERSION',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3980213357363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'FAS_BETREUER_ID',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3980324690363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'FAS_BETREUER_NAME',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3980417511363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'PIS_BETREUER_ADRESSE_ID',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3980507190363831 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'PIS_BETREUER_NAME',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3987812147738496 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'PA_SORT',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3988727300761765 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'MARKIERUNG',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'PLSQL_EXPRESSION',
  p_display_when_condition=> '(frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STORNO'') != 0  OR '||unistr('\000a')||
' frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STARTEN'') != 0 OR'||unistr('\000a')||
' frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_SPEICHERN'') != 0 '||unistr('\000a')||
') ',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4063800226273132 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'AUFTRAG_ID',
  p_column_display_sequence=> 16,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4064800605094592 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 17,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2038117621227801 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'SERIEN_NR',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3989606830803162 + wwv_flow_api.g_id_offset,
  p_region_id=> 3979211734363826 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'SORT',
  p_column_display_sequence=> 15,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3981530163363834 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 10,
  p_button_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUCHEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P5_BL_SUCHEN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3981129936363834 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 20,
  p_button_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_button_name    => 'STORNO',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P5_BL_STORNO.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STORNO'') != 0',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3980928967363832 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 40,
  p_button_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_button_name    => 'SPEICHERN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P5_BL_SORT_SPEICHERN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_SPEICHERN'') != 0',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3981328016363834 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 50,
  p_button_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_button_name    => 'STARTEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P5_BL_AUFTRAG_ABSCHLIESSEN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STARTEN'') != 0',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2035226466993831 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 60,
  p_button_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_button_name    => 'EINZELDRUCK',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P5_BL_EINZELDRUCK.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0 OR'||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_SPEICHERN'') != 0',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2036418463038871 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 70,
  p_button_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAMMELDRUCK',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P5_BL_SAMMELDRUCK.',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0 OR'||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_SPEICHERN'') != 0',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>2038207840243928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:3:&SESSION.::&DEBUG.::P3_REFERENZ_ID,P3_PAGE:&P5_SERIENNUMMER.,5',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 5,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':p5_seriennummer > 0 and :request in (''SAMMELDRUCK'',''EINZELDRUCK'') AND NVL(:P5_DRUCK_JOB_GESTARTET,0) = 0',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 05-MRZ-2009 14:45 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>3984808133363843 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 18-JUN-2008 10:12 by FRGBG');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2032804069845403 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_BL_SAMMELDRUCK',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Sammeldruck',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2033010648847340 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_BL_EINZELDRUCK',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Einzeldruck',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2038714204255209 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_SERIENNUMMER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 180,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Seriennummer',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2071801334778846 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_DRUCKOPTION',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> 'DECLARE'||unistr('\000a')||
'   v_text   VARCHAR2(100);'||unistr('\000a')||
'   CURSOR c_opt is'||unistr('\000a')||
'     select wert'||unistr('\000a')||
'     from optionswerte'||unistr('\000a')||
'     where opttyp_id = 19'||unistr('\000a')||
'       and standard = 1'||unistr('\000a')||
'     order by sortierung desc;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_opt in c_opt LOOP'||unistr('\000a')||
'       v_text := r_opt.wert||'':''||v_text;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   RETURN v_text;'||unistr('\000a')||
'END;'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'',
  p_item_default_type=> 'PLSQL_FUNCTION_BODY',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_CHECKBOX',
  p_lov=> 'SELECT '||unistr('\000a')||
'fas_synch.get_tab_uebersetzung(''OPTIONSWERTE.BEZEICHNUNG'',ID,:fas_sprache_id) a,'||unistr('\000a')||
'wert b'||unistr('\000a')||
'FROM optionswerte'||unistr('\000a')||
'where opttyp_id = 19 /* Auftragsbearb.Druckoptionen */'||unistr('\000a')||
'order by sortierung'||unistr('\000a')||
''||unistr('\000a')||
'',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'CENTER',
  p_display_when=>'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0 OR'||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_SPEICHERN'') != 0 ',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => '2',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2072007221780543 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_ANZAHL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'DECLARE'||unistr('\000a')||
'   v_optwert_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   v_optwert_id := frgbg_s.get_pers_option(:APP_USER,5);'||unistr('\000a')||
'   RETURN (v_optwert_id);'||unistr('\000a')||
'END;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0 OR'||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_SPEICHERN'') != 0',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2073102813836125 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_AUFTRAG_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 190,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Auftrag Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3981703305363834 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_HEIGHT_LISTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Height Liste',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3982106043363835 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_FERTIGDATUM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> 'to_char(sysdate,''DD.MM.YYYY'')',
  p_item_default_type=> 'PLSQL_EXPRESSION',
  p_prompt=>'<tab>"SET_ITEM_LABEL"',
  p_post_element_text=>'&nbsp;&nbsp;&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 10,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STARTEN'') != 0 ',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3983125899363837 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_FEHLERTEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Fehlertext',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822217926727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3988126345742617 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_TOGGLE_MARKIEREN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 12,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_RADIOGROUP',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(1769,:fas_sprache_id) a,0 b'||unistr('\000a')||
'FROM DUAL'||unistr('\000a')||
'UNION '||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(1768,:fas_sprache_id) , 1 '||unistr('\000a')||
'FROM DUAL'||unistr('\000a')||
'order by 2',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STORNO'') != 0  OR '||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_STARTEN'') != 0 OR'||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFBEARB_SPEICHERN'') != 0 ',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => '1',
  p_attribute_02 => 'SUBMIT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3988312970748178 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_TOGGLE_STATUS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 13,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '1',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_RADIOGROUP',
  p_lov=> 'SELECT frgbg_s.holen_uebersetzung(1938,:fas_sprache_id) a , 3 b'||unistr('\000a')||
'FROM DUAL '||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(1937,:fas_sprache_id) ,1'||unistr('\000a')||
'FROM DUAL'||unistr('\000a')||
'UNION'||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(1936,:fas_sprache_id)  , 2'||unistr('\000a')||
'FROM DUAL'||unistr('\000a')||
'order by 2',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_display_when=>'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STORNO'') != 0 OR'||unistr('\000a')||
'frgbg_s.check_fas_rolle(:fas_login_user_account,''PRODAUFDISPO_STARTEN'') != 0',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => '1',
  p_attribute_02 => 'SUBMIT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3994115223605034 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_BL_SORT_SPEICHERN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'P5_BL_UMSORTIEREN',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3994323188607370 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_BL_STORNO',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Storno',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3994529768609315 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_BL_AUFTRAG_ABSCHLIESSEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Auftrag Starten',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3994707736612368 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_REGION_TITEL_AUFTRAGSBEARB',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Region Titel Auftragsdispo',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3995700987648232 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_BL_SUCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Suchen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4008317853220864 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_SUCH_DATUM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> 'to_char(sysdate - 60,''DD.MM.YYYY'')',
  p_item_default_type=> 'PLSQL_EXPRESSION',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 10,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>9127929684735589 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_DRUCK_JOB_GESTARTET',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 200,
  p_item_plug_id => 3979211734363826+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 4000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4010421474158703 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_eingabe_such_datum',
  p_validation_sequence=> 5,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_datum       DATE;'||unistr('\000a')||
'   v_fehlertext  VARCHAR2(2000);'||unistr('\000a')||
'   v_prot_id     NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Eingaben validieren Anzahl=%1'',v_prot_id,''Info'','||unistr('\000a')||
'-- ''Eingaben  validieren'',apex_application.g_f02.count);'||unistr('\000a')||
'   IF :p5_such_datum IS NULL THEN'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(1948,:fas_sprache_id)));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Check Datum'||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      v_datum := to_date(:p5_such_datum,''DD.MM.RRRR'');'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN OTHERS THEN'||unistr('\000a')||
'        --''Kein gültige Datum/Uhrzeit der Form TT.MM.JJJJ ...'||unistr('\000a')||
'        RETURN(frgbg_s.holen_uebersetzung(1792,:fas_sprache_id,'||unistr('\000a')||
'                    ''(''||:p5_such_datum||'')''));'||unistr('\000a')||
'   END;'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_validation_condition=> ':request in (''SUCHEN'',''P5_TOGGLE_MARKIEREN'',''P5_TOGGLE_STATUS'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 3982106043363835 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3983614647363839 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_eingabe_fertigdatum',
  p_validation_sequence=> 10,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_datum       DATE;'||unistr('\000a')||
'   v_prot_id     NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'MEL.P(''Eingaben validieren Fertigdatum =%1'',v_prot_id,''Info'','||unistr('\000a')||
' ''Eingaben  validieren'',:p5_fertigdatum);'||unistr('\000a')||
'   IF :p5_fertigdatum IS NULL THEN'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(1939,:fas_sprache_id)));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Check Datum'||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      v_datum := to_date(:p5_fertigdatum,''DD.MM.RRRR'');'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN OTHERS THEN'||unistr('\000a')||
'        --''Kein gültige Datum/Uhrzeit der Form TT.MM.JJJJ ...'||unistr('\000a')||
'        RETURN(frgbg_s.holen_uebersetzung(1792,:fas_sprache_id,'||unistr('\000a')||
'                    ''(''||:p5_fertigdatum||'')''));'||unistr('\000a')||
'   END;'||unistr('\000a')||
'MEL.P(''Eingaben validieren Fertigdatum =%1'',v_prot_id,''Info'','||unistr('\000a')||
' ''Eingaben  validieren'',:p5_fertigdatum);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Fertigdatum >= Tagesdatum'||unistr('\000a')||
'   IF v_datum < to_date(sysdate,''DD.MM.RRRR'') THEN'||unistr('\000a')||
'      --''Das Fertigdatum muss grösser oder gleich Tagesdatum ...'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(1811,:fas_sprache_id,'||unistr('\000a')||
'                      ''(''||:p5_fertigdatum||'')''));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_when_button_pressed=> 3981328016363834 + wwv_flow_api.g_id_offset,
  p_associated_item=> 3982106043363835 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4020111918472142 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_eingabe_sortierung',
  p_validation_sequence=> 15,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_mutdat      VARCHAR2(25);'||unistr('\000a')||
'   v_sort        NUMBER;'||unistr('\000a')||
'   v_neue_zeile  varchar2(10) := ''<br/>'';--chr(13)||chr(10); '||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id     NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Eingaben validieren Anzahl=%1'',v_prot_id,''Info'','||unistr('\000a')||
'-- ''Eingaben  validieren'',apex_application.g_f02.count);'||unistr('\000a')||
'   FOR j in 1..apex_application.g_f02.count  LOOP'||unistr('\000a')||
'      FOR i in 1..apex_application.g_f01.count  LOOP'||unistr('\000a')||
'          IF apex_application.g_f01(i) = apex_application.g_f02(j) THEN'||unistr('\000a')||
'             IF NVL(to_char(apex_application.G_F03(i)),''-1'') != '||unistr('\000a')||
'                NVL(to_char(apex_application.G_F06(i)),''-1'') '||unistr('\000a')||
'             THEN  -- geänderte Sortierung prüfen'||unistr('\000a')||
'                -- Prüfen, ob Bestellung zwischenzeitlich geändert wurde'||unistr('\000a')||
'                SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') '||unistr('\000a')||
'                INTO v_mutdat'||unistr('\000a')||
'                FROM auftraege'||unistr('\000a')||
'                WHERE  id = apex_application.g_f01(i);'||unistr('\000a')||
'                IF v_mutdat != apex_application.g_f07(i) THEN'||unistr('\000a')||
'                   v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                    -- ''Datensätze bereits anderweitig geändert wurden!....'||unistr('\000a')||
'                      frgbg_s.holen_uebersetzung(1791,:fas_sprache_id,'||unistr('\000a')||
'                      ''(''||apex_application.g_f08(i)||'')'');'||unistr('\000a')||
'                END IF;'||unistr('\000a')||
''||unistr('\000a')||
'                -- Eingabepflichtig'||unistr('\000a')||
'                IF apex_application.g_f06(i) is null THEN'||unistr('\000a')||
'                   v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                      --''Keine Sortierung eingegeben ...'||unistr('\000a')||
'                      frgbg_s.holen_uebersetzung(1961,:fas_sprache_id,'||unistr('\000a')||
'                      ''(''||apex_application.g_f08(i)||'')'');'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                   -- Check Sort'||unistr('\000a')||
'                   BEGIN'||unistr('\000a')||
'                      v_sort:= to_number(apex_application.g_f06(i));'||unistr('\000a')||
'                   EXCEPTION'||unistr('\000a')||
'                   WHEN OTHERS THEN'||unistr('\000a')||
'                      v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                         --''Keine gültige Sortierung ...'||unistr('\000a')||
'                         frgbg_s.holen_uebersetzung(1960,:fas_sprache_id,'||unistr('\000a')||
'                         ''''''''||apex_application.g_f06(i)||'''''''','||unistr('\000a')||
'                         ''(''||apex_application.g_f08(i)||'')'');'||unistr('\000a')||
'                   END;'||unistr('\000a')||
'                END IF;'||unistr('\000a')||
'             END IF;'||unistr('\000a')||
'             EXIT;'||unistr('\000a')||
'          END IF;'||unistr('\000a')||
'      END LOOP;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   -- Fehlertext wird erst am Anfang vom Speichern ausgewertet und mit Raise angezeigt, damit keine refresh der Daten durchführt wird'||unistr('\000a')||
'   :p5_fehlertext := substr(v_fehlertext,length(v_neue_zeile)+1);'||unistr('\000a')||
'   RETURN NULL;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 3980928967363832 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3983407628363837 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_change_by_another_user',
  p_validation_sequence=> 20,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_mutdat      VARCHAR2(25);'||unistr('\000a')||
'   v_datum       DATE;'||unistr('\000a')||
'   v_neue_zeile  varchar2(10) := ''<br/>''; '||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id     NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Eingaben validieren Anzahl=%1'',v_prot_id,''Info'','||unistr('\000a')||
'-- ''Eingaben  validieren'',apex_application.g_f02.count);'||unistr('\000a')||
'   FOR j in 1..apex_application.g_f02.count  LOOP'||unistr('\000a')||
'      FOR i in 1..apex_application.g_f01.count  LOOP'||unistr('\000a')||
'          IF apex_application.g_f01(i) = apex_application.g_f02(j) THEN'||unistr('\000a')||
'                -- Prüfen, ob Bestellung zwischenzeitlich geändert wurde'||unistr('\000a')||
'                SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') '||unistr('\000a')||
'                INTO v_mutdat'||unistr('\000a')||
'                FROM auftraege'||unistr('\000a')||
'                WHERE  id = apex_application.g_f01(i);'||unistr('\000a')||
'                IF v_mutdat != apex_application.g_f07(i) THEN'||unistr('\000a')||
'                   v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                    -- 1791''Die Eingaben können nicht gespeichert werden , da die Datensätze bereits anderweitig geändert wurden!....'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(1791,:fas_sprache_id,'||unistr('\000a')||
'                     ''(''||apex_application.g_f08(i)||'')'');'||unistr('\000a')||
'                END IF;'||unistr('\000a')||
''||unistr('\000a')||
'             EXIT;'||unistr('\000a')||
'          END IF;'||unistr('\000a')||
'      END LOOP;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   -- Fehlertext wird erst am Anfang vom Speichern ausgewertet und mit Raise angezeigt, damit keine refresh der Daten durchführt wird'||unistr('\000a')||
'   :p5_fehlertext := substr(v_fehlertext,length(v_neue_zeile)+1);'||unistr('\000a')||
'   RETURN NULL;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''STARTEN'',''STORNO'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_return  NUMBER;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Sortierung speichern %1, %2, %3, %4, %5'', v_prot_id,''Info'',''Auftragsbearb'', :request);'||unistr('\000a')||
'   IF :p5_fehlertext IS NOT NULL THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,:p5_fehlertext);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   '||unistr('\000a')||
'   v_return := auftragsbearb.ab_save_sortierung(:APP_USER); '||unistr('\000a')||
'   IF v_return < 0 THEN -- Fehler beim Speichern der markierten Bestellungen!'||unistr('\000a')||
' ';

p:=p||'     RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(1812,:fas_sprache_id,'||unistr('\000a')||
'                                                                 to_char(v_return))'||unistr('\000a')||
'                              );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
' END;';

wwv_flow_api.create_page_process(
  p_id     => 3983714330363840 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sortierung_speichern',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3980928967363832 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_return  NUMBER;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P(''Storno %1, %2, %3, %4, %5'', v_prot_id,''Info'',''Auftragsdispo'', :request);'||unistr('\000a')||
'   IF :p5_fehlertext IS NOT NULL THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,:p5_fehlertext);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   '||unistr('\000a')||
'   v_return := auftragsbearb.ab_storno_auftrag(:APP_USER); '||unistr('\000a')||
'   IF v_return < 0 THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(1812,';

p:=p||':fas_sprache_id,'||unistr('\000a')||
'                                                                 to_char(v_return))'||unistr('\000a')||
'                              );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
' END;';

wwv_flow_api.create_page_process(
  p_id     => 3983915271363842 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'auftrag_stornieren',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3981129936363834 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_return  NUMBER;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'   v_parameter VARCHAR2(50);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'MEL.P(''Dispo starten %1, %2, %3, %4, %5'', v_prot_id,''Info'',''Auftragsdispo'', :request,:p5_fertigdatum);'||unistr('\000a')||
'   IF :p5_fehlertext IS NOT NULL THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,:p5_fehlertext);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   '||unistr('\000a')||
'   -- Aufträge erzeugen => Seriennur'||unistr('\000a')||
'   v_return := auftragsbearb.ab_close_auftrag(:APP_USER,to_date(:p5';

p:=p||'_fertigdatum,''DD.MM.RRRR'')); '||unistr('\000a')||
'   IF v_return < 0 THEN'||unistr('\000a')||
'      RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(1812,:fas_sprache_id,'||unistr('\000a')||
'                                                                 to_char(v_return))'||unistr('\000a')||
'                              );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Formulardruck'||unistr('\000a')||
'/* NEI 27.05.09 '||unistr('\000a')||
'   IF v_return is not null THEN -- seriennr für Druck vorhanden'||unistr('\000a')||
'      --Aufbau:"Anzahl Produk';

p:=p||'tionsauftrag|Etikettentyp|Anzahl Etiketten|Formulartyp|Formularanzahl|"'||unistr('\000a')||
'      --v_parameter := to_char(:p5_prod_auftrag_anzahl)||''|''||'||unistr('\000a')||
'      --               to_char(:p5_etikettentyp)||''|''||to_char(:p5_etikettenanzahl)||''|''||'||unistr('\000a')||
'      --               to_char(NULL)||''|''||to_char(:p5_zusatzformular_anzahl);'||unistr('\000a')||
'      --'||unistr('\000a')||
'--MEL.P(''Dispodruck starten für Serie %1 mit %2'', v_prot_id,''Info'',''Auftragsdispo'', v_';

p:=p||'return, --v_parameter);'||unistr('\000a')||
'      -- DOKUMENTEN_DRUCK.auftragsdispo_druck(v_return,v_parameter);'||unistr('\000a')||
'      -- Achtung Schnittstelle geändert'||unistr('\000a')||
'      -- DOKUMENTEN_DRUCK.auftragsdispo_druck(v_return,:p5_prod_auftrag_anzahl,'||unistr('\000a')||
'                                           :p5_etikettentyp,:p5_etikettenanzahl,'||unistr('\000a')||
'                                           NULL,:p5_zusatzformular_anzahl'||unistr('\000a')||
'                                ';

p:=p||'           );'||unistr('\000a')||
'   END IF; '||unistr('\000a')||
'*/'||unistr('\000a')||
' END;';

wwv_flow_api.create_page_process(
  p_id     => 3984310806363842 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 25,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'auftrag_abschliessen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>3981328016363834 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_return       number;'||unistr('\000a')||
'   v_druckoption_blob store_blob.druckoption%TYPE;'||unistr('\000a')||
'   v_serien_nr    auftraege.serien_nr%TYPE;'||unistr('\000a')||
'   v_prot_id      number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p5_seriennummer := NULL;'||unistr('\000a')||
'   -- NEI 14.04.09 Anzahl nicht eingeblendet => immer 1'||unistr('\000a')||
'   :p5_anzahl := 1; '||unistr('\000a')||
'   :P5_DRUCK_JOB_GESTARTET := 0;'||unistr('\000a')||
'   IF :p5_anzahl> 0 THEN'||unistr('\000a')||
''||unistr('\000a')||
'      FOR j in REVERSE 1..apex_application.g_f02.count  LOOP'||unistr('\000a')||
'         FOR ';

p:=p||'i in 1..apex_application.g_f01.count  LOOP'||unistr('\000a')||
'             IF apex_application.g_f01(i) = apex_application.g_f02(j) THEN'||unistr('\000a')||
'                v_serien_nr := apex_application.g_f09(i);'||unistr('\000a')||
'                IF :request = ''EINZELDRUCK'' THEN'||unistr('\000a')||
'                   :p5_auftrag_id := apex_application.g_f01(i);'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                   :p5_auftrag_id := NULL;'||unistr('\000a')||
'                END IF;'||unistr('\000a')||
'                EXIT;  ';

p:=p||' -- Erste Markierung liefert bereits die Seriennummer'||unistr('\000a')||
'             END IF;'||unistr('\000a')||
'         END LOOP;'||unistr('\000a')||
'      END LOOP;'||unistr('\000a')||
'--MEL.P(''Auftrag nachdrucken %1, %2, %3, %4, %5'', v_prot_id,''Info'',''Auftragsdispo'', :request,'||unistr('\000a')||
'--       v_serien_nr,:p5_anzahl,:p5_druckoption,:p5_auftrag_id );'||unistr('\000a')||
''||unistr('\000a')||
'      IF v_serien_nr is not null THEN'||unistr('\000a')||
'         :p5_seriennummer := v_serien_nr;'||unistr('\000a')||
'         -- NEI 14.04.09 '||unistr('\000a')||
'         -- Nur noch ne';

p:=p||'u aufbereiten, wenn nicht schon in entsprechendem Umfang vorhanden */'||unistr('\000a')||
'         SELECT max(druckoption)  -- längste Druckoption u. wg. nodatafound'||unistr('\000a')||
'         INTO v_druckoption_blob'||unistr('\000a')||
'         FROM store_blob'||unistr('\000a')||
'         WHERE referenz_id = v_serien_nr;'||unistr('\000a')||
'         v_return := frgbg_s.check_druckoption(v_druckoption_blob,:p5_druckoption,1);'||unistr('\000a')||
'         IF v_return = 0 THEN -- Neu aufbereiten'||unistr('\000a')||
'            IF :p5_';

p:=p||'auftrag_id IS not null THEN -- Einzeldruck'||unistr('\000a')||
'               :p5_seriennummer := v_serien_nr||''.''||:p5_auftrag_id;'||unistr('\000a')||
'            END IF;'||unistr('\000a')||
'            -- evt. vorhandener alter Eintrag löschen'||unistr('\000a')||
'            DELETE from store_blob'||unistr('\000a')||
'            WHERE referenz_id = :p5_seriennummer;'||unistr('\000a')||
''||unistr('\000a')||
'/* alt      DOKUMENTEN_DRUCK.auftragsdispo_druck(v_serien_nr,:p5_prod_auftrag_anzahl,'||unistr('\000a')||
'                                          ';

p:=p||'    NULL,:p5_etikettenanzahl,'||unistr('\000a')||
'                                              0,:p5_zusatzformular_anzahl'||unistr('\000a')||
'                                             );'||unistr('\000a')||
'*/'||unistr('\000a')||
'            :P5_DRUCK_JOB_GESTARTET := 1;'||unistr('\000a')||
''||unistr('\000a')||
'            FRGBG_JOBS.START_JOB('||unistr('\000a')||
'               p_what => ''IREPORT.auftragsdispo_druck('' || NVL(to_char(v_serien_nr),''NULL'') ||'','||unistr('\000a')||
'                                                 '' || NVL(to_char(:p5_a';

p:=p||'uftrag_id),''NULL'') || '',    -- auftrag_id innerhalb der Serie'||unistr('\000a')||
'                                                 '' || NVL(to_char(:p5_anzahl),''NULL'') || '','||unistr('\000a')||
'                                                 '''':''||:p5_druckoption||'':'''','||unistr('\000a')||
'                                                 NULL --:p5_druckart'||unistr('\000a')||
'                                              );'','||unistr('\000a')||
'               p_beschreibung           => ''Druc';

p:=p||'ke Auftragsdispo'','||unistr('\000a')||
'               p_max_jobs_same          => 1,'||unistr('\000a')||
'               p_max_jobs_total         => 1,'||unistr('\000a')||
'               p_visible                => 1,'||unistr('\000a')||
'               p_valid_days             => 1,'||unistr('\000a')||
'               p_hide_by_complete       => 1,'||unistr('\000a')||
'               p_umleitung_url          => CASE WHEN'||unistr('\000a')||
'                  :p5_seriennummer > 0 THEN ''f?p='' || :APP_ID || '':3:'' '||unistr('\000a')||
'                  || :APP_';

p:=p||'SESSION || ''::::P3_REFERENZ_ID,P3_PAGE:'' ||:P5_SERIENNUMMER || '',5'' '||unistr('\000a')||
'                 ELSE null '||unistr('\000a')||
'                 END'||unistr('\000a')||
'            );'||unistr('\000a')||
'            --IREPORT.auftragsdispo_druck( v_serien_nr,-- seriennr'||unistr('\000a')||
'            --                                  :p5_auftrag_id, -- auftrag_id innerhalb der Serie'||unistr('\000a')||
'            --                                  :p5_anzahl,'||unistr('\000a')||
'            --                            ';

p:=p||'      '':''||:p5_druckoption||'':'','||unistr('\000a')||
'            --                                  NULL --:p4_druckart'||unistr('\000a')||
'            --                                  );'||unistr('\000a')||
'            '||unistr('\000a')||
''||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 2031807354808510 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 27,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'auftrag_nachdrucken',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SAMMELDRUCK'',''EINZELDRUCK'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p5_toggle_markieren := 0;';

wwv_flow_api.create_page_process(
  p_id     => 3984114821363842 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'markierung_zurücksetzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SPEICHERN'',''STARTEN'',''STORNO'',''SAMMELDRUCK'',''EINZELDRUCK'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Komplette Höhe ausnutzen (100% des Maximums)'||unistr('\000a')||
'   :P5_HEIGHT_Liste := :FAS_SCROLLREGION_HEIGHT_MAX * 1;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3984501157363843 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'scrollheight_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p5_bl_storno := frgbg_s.holen_uebersetzung(1945,v_sprache_id);'||unistr('\000a')||
'   :p5_bl_sort_speichern := frgbg_s.holen_uebersetzung(1947,v_sprache_id);'||unistr('\000a')||
'   :P5_BL_AUFTRAG_ABSCHLIESSEN:= frgbg_s.holen_uebersetzung(1941,v_sprache_id);'||unistr('\000a')||
'   :p5_bl_suchen := frgbg_s.holen_uebersetzung(481,v_sprache_id);'||unistr('\000a')||
'   :p5_bl_sammeld';

p:=p||'ruck := frgbg_s.holen_uebersetzung(3069,v_sprache_id);'||unistr('\000a')||
'   :p5_bl_einzeldruck := frgbg_s.holen_uebersetzung(3070,v_sprache_id);'||unistr('\000a')||
'  '||unistr('\000a')||
'   :p5_region_titel_auftragsbearb := frgbg_s.holen_uebersetzung(1946,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3993823750598031 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 50,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 5
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00100
prompt  ...PAGE 100: Loginverteiler
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 100
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Loginverteiler'
 ,p_step_title => 'Loginverteiler'
 ,p_step_sub_title => 'Loginverteiler'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_step_template => 3816220719727340 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20140909151516'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4791716111509014 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 100,
  p_plug_name=> '&P100_PAGE_TITEL_LOGIN.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3819521468727365+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'BODY_1',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 4791904743509028 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 100,
  p_button_sequence=> 10,
  p_button_plug_id => 4791716111509014+wwv_flow_api.g_id_offset,
  p_button_name    => 'DISPO_LOGIN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P100_BL_DISPO_LOGIN.',
  p_button_position=> 'TOP',
  p_button_alignment=> 'LEFT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4792113283509032 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 100,
  p_button_sequence=> 20,
  p_button_plug_id => 4791716111509014+wwv_flow_api.g_id_offset,
  p_button_name    => 'BEARB_LOGIN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P100_BL_BEARB_LOGIN.',
  p_button_position=> 'TOP',
  p_button_alignment=> 'LEFT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>4793829065509062 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:101:P101_APP_SPRACHE_ID_PARAM:&P100_APP_SPRACHE_ID.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>4791904743509028+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 5,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>4794214575509067 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:102:&SESSION.::&DEBUG.:102:P102_APP_SPRACHE_ID_PARAM:&P100_APP_SPRACHE_ID.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>4792113283509032+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>4794028320509067 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 18-NOV-2008 15:08 by FRGBG');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2774325422720745 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_name=>'XP100_PERS_OPT_PERSSTAMM_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 4791716111509014+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Pers Opt Persstamm Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3420915088960408 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_name=>'P100_WARTUNG_FLAG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 4791716111509014+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4792310015509034 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_name=>'P100_APP_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 4791716111509014+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL_LOGIN_VERTEILER"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT s.sprache, s.id'||unistr('\000a')||
'FROM app_sprachen s, fas_schemas fs'||unistr('\000a')||
'WHERE fs.id = :fas_schema_id'||unistr('\000a')||
'  AND fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'  AND s.aktiv=1  -- NEI 09.09.2014'||unistr('\000a')||
'order by 1'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'/*SELECT sprache, '||unistr('\000a')||
'       ow.id b'||unistr('\000a')||
'FROM app_sprachen ow, pers_optionen po , optionstypen ot    /* Subsetzugriff * /'||unistr('\000a')||
'where po.opttyp_id = ot.id  /* JOIN OT * /'||unistr('\000a')||
'  and ot.art = 1        /* Subset * /'||unistr('\000a')||
'  and po.opttyp_id = 23  /* Sprachen * /'||unistr('\000a')||
'  and ow.id = po.wert'||unistr('\000a')||
'  /* Persid des Subsets sonst null * / '||unistr('\000a')||
'  and po.persstamm_id = :p100_pers_opt_persstamm_id '||unistr('\000a')||
'UNION'||unistr('\000a')||
'/* Zugriff auf Appsprachen (statt Optionswerte), da keine Subsetdef. od. da Def.wertverwaltg* /'||unistr('\000a')||
'SELECT sprache,'||unistr('\000a')||
'       ow.id b'||unistr('\000a')||
'FROM app_sprachen ow, optionstypen ot'||unistr('\000a')||
'where ot.id = 23 /* Sprachen* /'||unistr('\000a')||
'  and (ot.art = 1 and /* Subset und keine Subsetdefinition gefunden* /'||unistr('\000a')||
'       :p100_pers_opt_persstamm_id  IS NULL'||unistr('\000a')||
'       OR'||unistr('\000a')||
'       ot.art != 1  /* Kein Subset * /'||unistr('\000a')||
'      )'||unistr('\000a')||
'order by 1  '||unistr('\000a')||
'*/',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'REDIRECT_SET_VALUE',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4792515762509043 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_name=>'P100_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 4791716111509014+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Sprache Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4792720537509043 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_name=>'P100_BL_DISPO_LOGIN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 4791716111509014+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Betreuer Login',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4792924969509043 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_name=>'P100_BL_BEARB_LOGIN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 4791716111509014+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Kunden Login',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4793101265509043 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 100,
  p_name=>'P100_PAGE_TITEL_LOGIN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 4791716111509014+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Login',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3420703314957046 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 100,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_wartung',
  p_validation_sequence=> 10,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_text   varchar2(4000);'||unistr('\000a')||
'   v_liste  varchar2(4000);'||unistr('\000a')||
'   v_flag   NUMBER;'||unistr('\000a')||
'   v_prot_id  NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p100_wartung_flag := 0;'||unistr('\000a')||
'   SELECT to_number(parameter) INTO v_flag'||unistr('\000a')||
'   FROM sysareas_frgbg'||unistr('\000a')||
'   WHERE id = 10;'||unistr('\000a')||
'   SELECT parameter INTO v_liste'||unistr('\000a')||
'   FROM sysareas_frgbg'||unistr('\000a')||
'   WHERE id = 11;'||unistr('\000a')||
'--mel.p(''Wartungsflag:%1, Text %2'',v_prot_id,''INFO'',''FAS104/100: check_wartung'',v_flag,:P100_HINWEIS);'||unistr('\000a')||
'   IF v_flag = 1 and  -- Generelles Wartungsflag'||unistr('\000a')||
'      -- Check USER, die während der Wartung arbeiten dürfen '||unistr('\000a')||
'      instr(UPPER(v_liste),'';''||UPPER(:p100_username)||'';'') = 0 and  '||unistr('\000a')||
'      -- Check Applikation, die gewartet werden'||unistr('\000a')||
'      instr(UPPER(v_liste),'';''||UPPER(:APP_ID)||'';'') = 0    '||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      :p100_wartung_flag := 1;'||unistr('\000a')||
'      v_text := frgbg_s.holen_uebersetzung(10,:p100_sprache_id);'||unistr('\000a')||
'      IF v_text is null or v_text = ''.'' THEN'||unistr('\000a')||
'         v_text := ''System is not available because of system maintaince! Please try again later.'';'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'      RETURN v_text;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :p100_wartung_flag := 0;'||unistr('\000a')||
'      RETURN null;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_anz      NUMBER;'||unistr('\000a')||
'   v_prot_id  NUMBER;'||unistr('\000a')||
'BEGIN   '||unistr('\000a')||
'/*MEL.P (''1 Schema setzen:%1, pers %2'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''Prozessüberwachung'','||unistr('\000a')||
'           :fas_schema_id,:fas_schema_persstamm_id'||unistr('\000a')||
'          );      '||unistr('\000a')||
'*/'||unistr('\000a')||
'   IF :fas_schema_id is NULL THEN'||unistr('\000a')||
'      -- FAS-Schema über Servername ermitteln'||unistr('\000a')||
'      :fas_schema_id := frgbg_s.get_fas_schema_srv;'||unistr('\000a')||
'   ELSE -- Check gültiges Schemaangabe?'||unistr('\000a')||
'  ';

p:=p||'    BEGIN'||unistr('\000a')||
'         SELECT count(*) INTO v_anz'||unistr('\000a')||
'         FROM fas_schemas'||unistr('\000a')||
'         WHERE id = :fas_schema_id;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'          v_anz := 0;'||unistr('\000a')||
'      END ;'||unistr('\000a')||
''||unistr('\000a')||
'      IF v_anz = 0 THEN -- FAlls ungültig über Servername ermitteln'||unistr('\000a')||
'         :fas_schema_id := frgbg_s.get_fas_schema_srv;           '||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   :FAS_THEME_NAME:= ''fas_theme_''||:fas_schema_id;'||unistr('\000a')||
''||unistr('\000a')||
'   -- ';

p:=p||'Holen der Persstamm_id für das FAS-Schema'||unistr('\000a')||
'   --:fas_schema_persstamm_id := frgbg_s.get_pers_fas_schema(:fas_schema_id);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Fas-Modus setzen abhängig vom Schema'||unistr('\000a')||
'   SELECT fas_modus_id into :fas_modus_id'||unistr('\000a')||
'   FROM fas_schemas'||unistr('\000a')||
'   WHERE id = :fas_schema_id;'||unistr('\000a')||
''||unistr('\000a')||
'/* NEI 24.09.09 FAS-Schema über Servername ermitteln'||unistr('\000a')||
'   IF :fas_schema_id is NULL THEN'||unistr('\000a')||
'      :fas_schema_id := frgbg_s.get_fas_schema_std;'||unistr('\000a')||
'   E';

p:=p||'ND IF;'||unistr('\000a')||
'   -- Holen der Persstamm_id für das FAS-Schema'||unistr('\000a')||
'   :fas_schema_persstamm_id := frgbg_s.get_pers_fas_schema(:fas_schema_id);'||unistr('\000a')||
'   -- Holen der Persstamm_id für die entsprechende Pers_option des Sprachen-Subsets'||unistr('\000a')||
'   :P100_PERS_OPT_PERSSTAMM_ID := '||unistr('\000a')||
'                  frgbg_s.GET_PERS_OPT_PERS_ID(:fas_schema_persstamm_id,23,'||unistr('\000a')||
'                                               :fas_schema_persstamm_id);'||unistr('\000a')||
'';

p:=p||'*/'||unistr('\000a')||
'/*MEL.P (''Schema setzen:%1, pers %2,%3'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''Prozessüberwachung'','||unistr('\000a')||
'           :fas_schema_id,:fas_schema_persstamm_id'||unistr('\000a')||
'          );      '||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 2774414125726971 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 100,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_fas_schema_fas_modus',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_sprache varchar2(50);'||unistr('\000a')||
'   v_anz        NUMBER;'||unistr('\000a')||
'   c owa_cookie.cookie;'||unistr('\000a')||
'   v_sprache_id NUMBER;'||unistr('\000a')||
'   v_prot_id    NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'MEL.P (''0 app_sprache_setzen: Appsp %1, sprache %2, appsp param %3, owa %4,pos %5'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''Page 121'','||unistr('\000a')||
'           to_char(:p121_app_sprache_id),'||unistr('\000a')||
'           to_char(v_sprache_id),:p121_app_sprache_id_param,'||unistr('\000a')||
'           owa_util.get_cgi_env';

p:=p||'(''HTTP_ACCEPT_LANGUAGE''),'||unistr('\000a')||
'          instr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''),'','')'||unistr('\000a')||
'          );'||unistr('\000a')||
'*/'||unistr('\000a')||
'   -- Zunaechst aus Cookie                          -- NEI 6.6.11 '||unistr('\000a')||
'   BEGIN                                            '||unistr('\000a')||
'        c := owa_cookie.get(''FAS_SPRACHE_COOKIE'');    '||unistr('\000a')||
'        -- Check, ob Sprache zum Schema passt, sonst Sprache ungueltig => Browsersprache'||unistr('\000a')||
'        SELECT count(*) into';

p:=p||' v_anz'||unistr('\000a')||
'        FROM app_sprachen s, fas_schemas fs'||unistr('\000a')||
'        WHERE fs.id = :fas_schema_id'||unistr('\000a')||
'          AND fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'          AND s.id =c.vals(1)'||unistr('\000a')||
'          AND s.aktiv=1;  -- NEI 09.09.2014'||unistr('\000a')||
'        IF v_anz > 0 THEN'||unistr('\000a')||
'           :P100_APP_SPRACHE_ID:= c.vals(1);          '||unistr('\000a')||
'        ELSE'||unistr('\000a')||
'           :P100_APP_SPRACHE_ID:=NULL;'||unistr('\000a')||
'        END IF;'||unistr('\000a')||
'   exception '||unistr('\000a')||
'   when others t';

p:=p||'hen '||unistr('\000a')||
'        :P100_APP_SPRACHE_ID:=NULL;               '||unistr('\000a')||
'   end;                                             -- NEI 6.6.11'||unistr('\000a')||
'   IF :P100_APP_SPRACHE_ID IS NULL THEN             -- NEI 6.6.11 '||unistr('\000a')||
'      -- Browsersprache holen und abgleichen mit App-Sprachen für das Schema'||unistr('\000a')||
'      v_sprache := substr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''), 1,'||unistr('\000a')||
'                     instr(owa_util.get_cgi_env(''HTTP_ACCEP';

p:=p||'T_LANGUAGE''), '','')-1);'||unistr('\000a')||
'      :p100_app_sprache_id := frgbg_s.get_browser_sprache(v_sprache);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
' /* NEI 24.09.09 Kein Optionstyp für Sprachen mehr sondern über Schema in app_sprachen'||unistr('\000a')||
'     IF :fas_schema_id = 2 THEN  -- Biogena '||unistr('\000a')||
'        -- Default des Sprachsubsets entsprechend der Schemavorgabe'||unistr('\000a')||
'        :p100_app_sprache_id := '||unistr('\000a')||
'                frgbg_s.get_pers_option(NULL,23,:fas_schema_per';

p:=p||'sstamm_id,  '||unistr('\000a')||
'                                                :fas_schema_persstamm_id);'||unistr('\000a')||
'     ELSE '||unistr('\000a')||
'        -- Abgleich der Browser-Sprache mit dem entsprechenden Sprachsubset'||unistr('\000a')||
'        v_sprache := substr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''), 1,'||unistr('\000a')||
'                        instr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''), '','')-1);'||unistr('\000a')||
'        :p100_app_sprache_id := frgbg_s.get_browser_sprache(v_s';

p:=p||'prache, :P100_PERS_OPT_PERSSTAMM_ID);'||unistr('\000a')||
'     END IF;'||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4793301536509046 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 100,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'app_sprache_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'Y',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   SELECT sprache_id into :p100_sprache_id '||unistr('\000a')||
'   FROM app_sprachen'||unistr('\000a')||
'   WHERE id = :p100_app_sprache_id;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1206019975611909 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 100,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sprache_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   /* NEI 24.09.09 Defaultsprache obsolet, da schemaspezif. App-sprachen'||unistr('\000a')||
'   IF :p100_app_sprache_id IS NULL THEN'||unistr('\000a')||
'      SELECT NVL(min(parameter),3) into :p100_app_sprache_id '||unistr('\000a')||
'      from sysareas_frgbg'||unistr('\000a')||
'      where id = 5; -- Default App-Sprache'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'*/'||unistr('\000a')||
'/*'||unistr('\000a')||
'   SELECT sprache_id into :p100_sprache_id '||unistr('\000a')||
'   FROM app_sprachen'||unistr('\000a')||
'   WHERE id = :p100_app_sprache_id;'||unistr('\000a')||
'*/   '||unistr('\000a')||
'   :p100_bl_dispo_login :=';

p:=p||' frgbg_s.holen_uebersetzung(2465,:p100_sprache_id);'||unistr('\000a')||
'   :p100_bl_bearb_login := frgbg_s.holen_uebersetzung(2466,:p100_sprache_id);'||unistr('\000a')||
'   :p100_page_titel_login := frgbg_s.holen_uebersetzung(2464,:p100_sprache_id);'||unistr('\000a')||
' END;';

wwv_flow_api.create_page_process(
  p_id     => 4793508845509054 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 100,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 100
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00101
prompt  ...PAGE 101: Anmelden Auftragsdisposition
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 101
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Anmelden Auftragsdisposition'
 ,p_step_title => 'Anmelden Auftragsdisposition'
 ,p_step_sub_title => 'Anmelden Produktionsauftrag'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_step_template => 3816220719727340 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'Y'
 ,p_protection_level => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20140909151622'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3833717951755368 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 101,
  p_plug_name=> '&P101_PAGE_TITEL_ANMELDUNG.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3819021965727364+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5891602872880164 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 101,
  p_plug_name=> '&P101_PAGE_TITEL_HINWEIS.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3819627096727365+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => 'frgbg_s.holen_uebersetzung(10,:p101_sprache_id) !=''.''',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3837011312755375 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 100,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 28-AUG-2007 11:09 by FRGBG');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2773020957672178 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'XP101_PERS_OPT_PERSSTAMM_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Pers Opt Persstamm Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3423030774097482 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_WARTUNG_FLAG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 181,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3833903539755370 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_APP_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL_LOGIN"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT s.sprache, s.id'||unistr('\000a')||
'FROM app_sprachen s, fas_schemas fs'||unistr('\000a')||
'WHERE fs.id = :fas_schema_id'||unistr('\000a')||
'  AND fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'  AND s.aktiv=1  -- NEI 09.09.2014'||unistr('\000a')||
'order by 1'||unistr('\000a')||
''||unistr('\000a')||
'/*'||unistr('\000a')||
'SELECT sprache, '||unistr('\000a')||
'       ow.id b'||unistr('\000a')||
'FROM app_sprachen ow, pers_optionen po , optionstypen ot    /* Subsetzugriff * /'||unistr('\000a')||
'where po.opttyp_id = ot.id  /* JOIN OT * /'||unistr('\000a')||
'  and ot.art = 1        /* Subset * /'||unistr('\000a')||
'  and po.opttyp_id = 23  /* Sprachen * /'||unistr('\000a')||
'  and ow.id = po.wert'||unistr('\000a')||
'  /* Persid des Subsets sonst null * /'||unistr('\000a')||
'  and po.persstamm_id = :p101_pers_opt_persstamm_id '||unistr('\000a')||
'UNION'||unistr('\000a')||
'/* Zugriff auf Appsprachen (statt Optionswerte), da keine Subsetdef. od. da Def.wertverwaltg* /'||unistr('\000a')||
'SELECT sprache,'||unistr('\000a')||
'       ow.id b'||unistr('\000a')||
'FROM app_sprachen ow, optionstypen ot'||unistr('\000a')||
'where ot.id = 23 /* Sprachen* /'||unistr('\000a')||
'  and (ot.art = 1 and /* Subset und keine Subsetdefinition gefunden* /'||unistr('\000a')||
'       :p101_pers_opt_persstamm_id  IS NULL'||unistr('\000a')||
'       OR'||unistr('\000a')||
'       ot.art != 1  /* Kein Subset * /'||unistr('\000a')||
'      )'||unistr('\000a')||
'order by 1  '||unistr('\000a')||
'*/',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'REDIRECT_SET_VALUE',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3834127838755370 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_PAGE_TITEL_ANMELDUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3834316202755370 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3834519218755370 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_BL_LOGIN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3834706929755370 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_USERNAME',
  p_data_type=> '',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL_LOGIN"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 2,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3834918924755370 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_PASSWORD',
  p_data_type=> '',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL_LOGIN"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_PASSWORD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_encrypt_session_state_yn=> 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3835121521755371 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_LOGIN',
  p_data_type=> '',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> '',
  p_item_default=> 'LOGIN',
  p_prompt=>'&P101_BL_LOGIN.',
  p_source=>'LOGIN',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'template:'||to_char(3817106493727350 + wwv_flow_api.g_id_offset),
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'S',
  p_button_action => 'SUBMIT',
  p_button_is_hot=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4799414031854931 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_APP_SPRACHE_ID_PARAM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'App Sprache Id Param',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5891927996880165 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_HINWEIS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 171,
  p_item_plug_id => 5891602872880164+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'frgbg_s.holen_uebersetzung(10,:p101_sprache_id)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 70,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'1=1',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5892117417884368 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_PAGE_TITEL_HINWEIS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 141,
  p_item_plug_id => 3833717951755368+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Hinweis',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3422322332085514 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_wartung',
  p_validation_sequence=> 5,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_text   varchar2(4000);'||unistr('\000a')||
'   v_liste  varchar2(4000);'||unistr('\000a')||
'   v_flag   NUMBER;'||unistr('\000a')||
'   v_prot_id  NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p101_wartung_flag := 0;'||unistr('\000a')||
'   SELECT to_number(parameter) INTO v_flag'||unistr('\000a')||
'   FROM sysareas_frgbg'||unistr('\000a')||
'   WHERE id = 10;'||unistr('\000a')||
'   SELECT parameter INTO v_liste'||unistr('\000a')||
'   FROM sysareas_frgbg'||unistr('\000a')||
'   WHERE id = 11;'||unistr('\000a')||
'--mel.p(''Wartungsflag:%1, Text %2'',v_prot_id,''INFO'',''FAS102/101: check_wartung'',v_flag,:P101_HINWEIS);'||unistr('\000a')||
'   IF v_flag = 1 and  -- Generelles Wartungsflag'||unistr('\000a')||
'      -- Check USER, die während der Wartung arbeiten dürfen '||unistr('\000a')||
'      instr(UPPER(v_liste),'';''||UPPER(:p101_username)||'';'') = 0 and  '||unistr('\000a')||
'      -- Check Applikation, die gewartet werden'||unistr('\000a')||
'      instr(UPPER(v_liste),'';''||UPPER(:APP_ID)||'';'') = 0    '||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      :p101_wartung_flag := 1;'||unistr('\000a')||
'      v_text := frgbg_s.holen_uebersetzung(10,:p101_sprache_id);'||unistr('\000a')||
'      IF v_text is null or v_text = ''.'' THEN'||unistr('\000a')||
'         v_text := ''System is not available because of system maintaince! Please try again later.'';'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'      RETURN v_text;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :p101_wartung_flag := 0;'||unistr('\000a')||
'      RETURN null;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3835431542755371 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_gueltiges_login',
  p_validation_sequence=> 10,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_anz_login        personenstamm.login_fehlversuche%TYPE;'||unistr('\000a')||
'   v_anz_max_login    personenstamm.login_fehlversuche%TYPE;'||unistr('\000a')||
'   v_personenstamm_id personenstamm.id%TYPE;'||unistr('\000a')||
'   v_fas_schema_id_pers  personenstamm.id%TYPE;'||unistr('\000a')||
'   v_betreuer         personenstamm.betreuer%TYPE;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
''||unistr('\000a')||
'   -- Sperren des Logins nach n Fehlversuchen'||unistr('\000a')||
'   :p101_username:=TRIM(UPPER (:p101_username));'||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      SELECT NVL(min(parameter),5) INTO v_anz_max_login'||unistr('\000a')||
'      FROM sysareas_frgbg'||unistr('\000a')||
'      WHERE id = 3;'||unistr('\000a')||
'      SELECT login_fehlversuche,id,betreuer'||unistr('\000a')||
'      INTO v_anz_login, v_personenstamm_id, v_betreuer'||unistr('\000a')||
'      FROM personenstamm'||unistr('\000a')||
'      WHERE user_account = TRIM(UPPER (:p101_username));'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN OTHERS THEN '||unistr('\000a')||
'       NULL;'||unistr('\000a')||
'   END;'||unistr('\000a')||
'   IF v_anz_login >= v_anz_max_login THEN'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(477,:p101_sprache_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Schema-Prüfung'||unistr('\000a')||
'   v_fas_schema_id_pers:= frgbg_s.get_fas_schema(v_personenstamm_id,''BETREUER'');'||unistr('\000a')||
'--mel.p(''Auftragsdispo schema %1'',v_prot_id,''TEST'',''104/101:check_gueltiges_login'',v_fas_schema_id_pers);'||unistr('\000a')||
'   IF v_fas_schema_id_pers = :fas_schema_id THEN'||unistr('\000a')||
'      NULL; -- alles ok'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(476,:p101_sprache_id));   '||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   -- Betreuer-User muss valid sein + Rolle mind. PRODAUFDISPO_ANZEIGEN besitzen'||unistr('\000a')||
'   IF frgbg_s.VALID_USER (:p101_username,:p101_password) AND '||unistr('\000a')||
'      v_betreuer = ''J'' AND '||unistr('\000a')||
'      /* NEI 15.11.11        '||unistr('\000a')||
'      ( frgbg_s.check_fas_rolle(:P101_USERNAME,''PRODAUFDISPO_ANZEIGEN'') != 0 OR'||unistr('\000a')||
'        frgbg_s.check_fas_rolle(:P101_USERNAME,''PRODAUFDISPO_STORNO'') != 0 OR'||unistr('\000a')||
'        frgbg_s.check_fas_rolle(:P101_USERNAME,''PRODAUFDISPO_SPEICHERN'') != 0 OR'||unistr('\000a')||
'        frgbg_s.check_fas_rolle(:P101_USERNAME,''PRODAUFDISPO_STARTEN'') != 0 '||unistr('\000a')||
'      )'||unistr('\000a')||
'      */'||unistr('\000a')||
'      (-- Zugriffberechtigung für Dispo '||unistr('\000a')||
'      frgbg_t.CHECK_FAS_APP_ZUGRIFF(:FAS_LOGIN_PERSONENSTAMM_ID,'||unistr('\000a')||
'                                    :FAS_LOGIN_PERSONENSTAMM_ID, -- :FAS_IDENTITAET_PERSSTAMM_ID,'||unistr('\000a')||
'                                    :APP_ID,4) = 1  '||unistr('\000a')||
'      )'||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         UPDATE personenstamm'||unistr('\000a')||
'         SET app_sprache_id = :p101_app_sprache_id,'||unistr('\000a')||
'             login_fehlversuche = 0'||unistr('\000a')||
'         WHERE id = v_personenstamm_id;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN OTHERS THEN '||unistr('\000a')||
'          NULL;'||unistr('\000a')||
'      END;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         UPDATE personenstamm'||unistr('\000a')||
'         SET login_fehlversuche = login_fehlversuche +1'||unistr('\000a')||
'         WHERE id = v_personenstamm_id;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN OTHERS THEN '||unistr('\000a')||
'          NULL;'||unistr('\000a')||
'      END;'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(476,:p101_sprache_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':p101_WARTUNG_FLAG = 0',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||unistr('\000a')||
'   owa_util.mime_header(''text/html'', FALSE);'||unistr('\000a')||
'   owa_cookie.send('||unistr('\000a')||
'       name=>''FAS_LOGIN_USERNAME_COOKIE'','||unistr('\000a')||
'       value=>utl_url.escape(lower(:P101_USERNAME), true,''AL32UTF8''));'||unistr('\000a')||
'   owa_cookie.send('||unistr('\000a')||
'       name=>''FAS_SPRACHE_COOKIE'','||unistr('\000a')||
'       value=>:P101_APP_SPRACHE_ID);'||unistr('\000a')||
'exception '||unistr('\000a')||
'when others then '||unistr('\000a')||
'   null;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3835710208755371 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Benutzername-Cookie festlegen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':fas_aufgerufen_von := ''PRODAUFDISPO'';'||unistr('\000a')||
':fas_login_page := :APP_PAGE_ID;'||unistr('\000a')||
':fas_sprache_id:= :p101_sprache_id;'||unistr('\000a')||
':FAS_LOGIN_USER_ACCOUNT := :P101_USERNAME;'||unistr('\000a')||
'/* NEI 20.04.09 Anwendungsprozedur'||unistr('\000a')||
':fas_abmelden_text := frgbg_s.holen_uebersetzung(174,:p101_sprache_id);'||unistr('\000a')||
':fas_keine_daten_text := frgbg_s.holen_uebersetzung(759,:p101_sprache_id);'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'wwv_flow_custom_auth_std.login('||unistr('\000a')||
'    P_UNAME       => v(''P101_US';

p:=p||'ERNAME''),'||unistr('\000a')||
'    P_PASSWORD    => v(''P101_PASSWORD''),'||unistr('\000a')||
'    P_SESSION_ID  => v(''APP_SESSION''),'||unistr('\000a')||
'    P_FLOW_PAGE   => :APP_ID||'':4'','||unistr('\000a')||
'    P_PRESERVE_CASE => TRUE'||unistr('\000a')||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 3835930586755373 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Login',
  p_process_sql_clob => p,
  p_process_error_message=> 'Ungültiges Login',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'2179930787869762';

wwv_flow_api.create_page_process(
  p_id     => 2180208539882237 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'set_fas_texte',
  p_process_sql_clob => 2179930787869762 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'12151422924614296';

wwv_flow_api.create_page_process(
  p_id     => 3836511836755373 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => 12151422924614296 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_anz      NUMBER;'||unistr('\000a')||
'   v_prot_id  NUMBER;'||unistr('\000a')||
'BEGIN   '||unistr('\000a')||
'/*MEL.P (''1 Schema setzen:%1, pers %2'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''Prozessüberwachung'','||unistr('\000a')||
'           :fas_schema_id,:fas_schema_persstamm_id'||unistr('\000a')||
'          );      '||unistr('\000a')||
'*/'||unistr('\000a')||
'   IF :fas_schema_id is NULL THEN'||unistr('\000a')||
'      -- FAS-Schema über Servername ermitteln'||unistr('\000a')||
'      :fas_schema_id := frgbg_s.get_fas_schema_srv;'||unistr('\000a')||
'   ELSE -- Check gültiges Schemaangabe?'||unistr('\000a')||
'  ';

p:=p||'    BEGIN'||unistr('\000a')||
'         SELECT count(*) INTO v_anz'||unistr('\000a')||
'         FROM fas_schemas'||unistr('\000a')||
'         WHERE id = :fas_schema_id;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'          v_anz := 0;'||unistr('\000a')||
'      END ;'||unistr('\000a')||
''||unistr('\000a')||
'      IF v_anz = 0 THEN -- FAlls ungültig über Servername ermitteln'||unistr('\000a')||
'         :fas_schema_id := frgbg_s.get_fas_schema_srv;           '||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   :FAS_THEME_NAME:= ''fas_theme_''||:fas_schema_id;'||unistr('\000a')||
''||unistr('\000a')||
'   -- ';

p:=p||'Holen der Persstamm_id für das FAS-Schema'||unistr('\000a')||
'   --:fas_schema_persstamm_id := frgbg_s.get_pers_fas_schema(:fas_schema_id);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Fas-Modus setzen abhängig vom Schema'||unistr('\000a')||
'   SELECT fas_modus_id into :fas_modus_id'||unistr('\000a')||
'   FROM fas_schemas'||unistr('\000a')||
'   WHERE id = :fas_schema_id;'||unistr('\000a')||
''||unistr('\000a')||
'/* NEI 24.09.09 FAS-Schema über Servername ermitteln'||unistr('\000a')||
'   IF :fas_schema_id is NULL THEN'||unistr('\000a')||
'      :fas_schema_id := frgbg_s.get_fas_schema_std;'||unistr('\000a')||
'   E';

p:=p||'ND IF;'||unistr('\000a')||
'   -- Holen der Persstamm_id für das FAS-Schema'||unistr('\000a')||
'   :fas_schema_persstamm_id := frgbg_s.get_pers_fas_schema(:fas_schema_id);'||unistr('\000a')||
'   -- Holen der Persstamm_id für die entsprechende Pers_option des Sprachen-Subsets'||unistr('\000a')||
'   :P101_PERS_OPT_PERSSTAMM_ID := '||unistr('\000a')||
'                  frgbg_s.GET_PERS_OPT_PERS_ID(:fas_schema_persstamm_id,23,'||unistr('\000a')||
'                                               :fas_schema_persstamm_id);'||unistr('\000a')||
'';

p:=p||'*/'||unistr('\000a')||
'/*MEL.P (''Schema setzen:%1, pers %2,%3'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''Prozessüberwachung'','||unistr('\000a')||
'           :fas_schema_id,:fas_schema_persstamm_id'||unistr('\000a')||
'          );      '||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 2773105851677328 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_fas_schema_fas_modus',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'    c owa_cookie.cookie;'||unistr('\000a')||
'begin'||unistr('\000a')||
'   c := owa_cookie.get(''FAS_LOGIN_USERNAME_COOKIE'');'||unistr('\000a')||
'   :P101_USERNAME := utl_url.unescape(c.vals(1),''AL32UTF8''); '||unistr('\000a')||
'exception '||unistr('\000a')||
'when others then '||unistr('\000a')||
'    null;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3836107295755373 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Benutzername-Cookie abrufen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_sprache varchar2(50);'||unistr('\000a')||
'   v_anz        NUMBER;'||unistr('\000a')||
'   c owa_cookie.cookie;'||unistr('\000a')||
'   v_sprache_id NUMBER;'||unistr('\000a')||
'   v_prot_id    NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'MEL.P (''0 app_sprache_setzen: Appsp %1, sprache %2, appsp param %3, owa %4,pos %5'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''Page 101'','||unistr('\000a')||
'           to_char(:p101_app_sprache_id),'||unistr('\000a')||
'           to_char(v_sprache_id),:p101_app_sprache_id_param,'||unistr('\000a')||
'           owa_util.get_cgi_env';

p:=p||'(''HTTP_ACCEPT_LANGUAGE''),'||unistr('\000a')||
'          instr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''),'','')'||unistr('\000a')||
'          );'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'  IF :p101_app_sprache_id_param IS NULL THEN'||unistr('\000a')||
'     -- Zunaechst aus Cookie                          -- NEI 6.6.11 '||unistr('\000a')||
'     BEGIN                                            '||unistr('\000a')||
'        c := owa_cookie.get(''FAS_SPRACHE_COOKIE'');    '||unistr('\000a')||
'        -- Check, ob Sprache zum Schema passt, sonst Sprache unguel';

p:=p||'tig => Browsersprache'||unistr('\000a')||
'        SELECT count(*) into v_anz'||unistr('\000a')||
'        FROM app_sprachen s, fas_schemas fs'||unistr('\000a')||
'        WHERE fs.id = :fas_schema_id'||unistr('\000a')||
'          AND fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'          AND s.id =c.vals(1)'||unistr('\000a')||
'          AND s.aktiv=1;  -- NEI 09.09.2014'||unistr('\000a')||
'        IF v_anz > 0 THEN'||unistr('\000a')||
'           :P101_APP_SPRACHE_ID:= c.vals(1);          '||unistr('\000a')||
'        ELSE'||unistr('\000a')||
'           :P101_APP_SPRACHE_ID:=NU';

p:=p||'LL;'||unistr('\000a')||
'        END IF;'||unistr('\000a')||
'     exception '||unistr('\000a')||
'     when others then '||unistr('\000a')||
'           :P101_APP_SPRACHE_ID:=NULL;               '||unistr('\000a')||
'     end;                                             -- NEI 6.6.11'||unistr('\000a')||
'     IF :P101_APP_SPRACHE_ID IS NULL THEN             -- NEI 6.6.11 '||unistr('\000a')||
''||unistr('\000a')||
'        -- Browsersprache holen und abgleichen mit App-Sprachen für das Schema'||unistr('\000a')||
'        v_sprache := substr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE';

p:=p||'''), 1,'||unistr('\000a')||
'                     instr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''), '','')-1);'||unistr('\000a')||
'        :p101_app_sprache_id := frgbg_s.get_browser_sprache(v_sprache);'||unistr('\000a')||
'     END IF;'||unistr('\000a')||
'  ELSE'||unistr('\000a')||
'     :p101_app_sprache_id := :p101_app_sprache_id_param;'||unistr('\000a')||
'     :p101_app_sprache_id_param := NULL;'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' /* NEI 24.09.09 Kein Optionstyp für Sprachen mehr sondern über Schema in app_sprachen'||unistr('\000a')||
'  IF :p101_app_sprache_';

p:=p||'id_param IS NULL THEN'||unistr('\000a')||
'--MEL.P (''1 app_sprache_setzen:%1, Browser %2'',v_prot_id,''Fehler'',''Page 121'');'||unistr('\000a')||
'     IF :fas_schema_id = 2 THEN  -- Biogena '||unistr('\000a')||
'        -- Default des Sprachsubsets entsprechend der Schemavorgabe'||unistr('\000a')||
'        :p101_app_sprache_id := '||unistr('\000a')||
'                frgbg_s.get_pers_option(NULL,23,:fas_schema_persstamm_id,  '||unistr('\000a')||
'                                                :fas_schema_persstamm_id);'||unistr('\000a')||
'  ';

p:=p||'   ELSE '||unistr('\000a')||
'        -- Abgleich der Browser-Sprache mit dem entsprechenden Sprachsubset'||unistr('\000a')||
'        v_sprache := substr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''), 1,'||unistr('\000a')||
'                        instr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''), '','')-1);'||unistr('\000a')||
'        :p101_app_sprache_id := frgbg_s.get_browser_sprache(v_sprache, :P101_PERS_OPT_PERSSTAMM_ID);'||unistr('\000a')||
'     END IF;'||unistr('\000a')||
'  ELSE'||unistr('\000a')||
'     :p101_app_sprache_id := :p1';

p:=p||'01_app_sprache_id_param;'||unistr('\000a')||
'     :p101_app_sprache_id_param := NULL;'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3836319686755373 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'app_sprache_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'Y',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   SELECT sprache_id into :p101_sprache_id '||unistr('\000a')||
'   FROM app_sprachen'||unistr('\000a')||
'   WHERE id = :p101_app_sprache_id;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1205229409595752 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sprache_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'  -- MEL.P (''Login buttonlabels: Language =''||to_char(:p101_app_sprache_id )||'')! [Loginpage 101]'' --||SQLERRM, v_PROT_ID, ''ERROR'', ''get_mnr_max_version'');'||unistr('\000a')||
'   /* NEI 24.09.09 Default-Sprache obsolet, da Schemaspezif. App-sprachen'||unistr('\000a')||
'   IF :p101_app_sprache_id IS NULL THEN'||unistr('\000a')||
'      SELECT NVL(min(parameter),3) into :p101_app_sprache_id '||unistr('\000a')||
'      from sysareas_frgbg'||unistr('\000a')||
'      w';

p:=p||'here id = 5; -- Default App-Sprache'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'*/'||unistr('\000a')||
'/*'||unistr('\000a')||
'   SELECT sprache_id into :p101_sprache_id '||unistr('\000a')||
'   FROM app_sprachen'||unistr('\000a')||
'   WHERE id = :p101_app_sprache_id;'||unistr('\000a')||
'*/'||unistr('\000a')||
'   :p101_bl_login := frgbg_s.holen_uebersetzung(430,:p101_sprache_id);'||unistr('\000a')||
'   :p101_page_titel_anmeldung := frgbg_s.holen_uebersetzung(1747,:p101_sprache_id);'||unistr('\000a')||
'   :p101_page_titel_hinweis := frgbg_s.holen_uebersetzung(3786,:p101_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3835506011755371 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 50,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   SELECT id INTO :FAS_LOGIN_PERSONENSTAMM_ID'||unistr('\000a')||
'   FROM personenstamm'||unistr('\000a')||
'   WHERE user_account = TRIM(UPPER (:p101_username));'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN '||unistr('\000a')||
'    NULL;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3836721260755373 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 50,
  p_process_point=> 'ON_SUBMIT_BEFORE_COMPUTATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FAS_LOGIN_PERSONENSTAMM_ID_SETZEN',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 101
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00102
prompt  ...PAGE 102: Anmelden Produktionsauftragsbearbeitung
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 102
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Anmelden Produktionsauftragsbearbeitung'
 ,p_step_title => 'Anmelden Produktionsauftragsbearbeitung'
 ,p_step_sub_title => 'Anmelden Produktionsauftragsbearbeitung'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_step_template => 3816220719727340 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'Y'
 ,p_protection_level => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20140909151708'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3971620053058893 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 102,
  p_plug_name=> '&P102_PAGE_TITEL_ANMELDUNG.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3819021965727364+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6265322702577220 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 102,
  p_plug_name=> '&P102_PAGE_TITEL_HINWEIS.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3819627096727365+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => 'frgbg_s.holen_uebersetzung(10,:p102_sprache_id) !=''.''',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3974902340058928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:102:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 100,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 28-AUG-2007 11:09 by FRGBG');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2773727930702564 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'XP102_PERS_OPT_PERSSTAMM_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Pers Opt Persstamm Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3422813113092328 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_WARTUNG_FLAG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 191,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> '0',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3971814145058906 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_APP_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL_LOGIN_102"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'SELECT s.sprache, s.id'||unistr('\000a')||
'FROM app_sprachen s, fas_schemas fs'||unistr('\000a')||
'WHERE fs.id = :fas_schema_id'||unistr('\000a')||
'  AND fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'  AND s.aktiv=1  -- NEI 09.09.2014'||unistr('\000a')||
'order by 1'||unistr('\000a')||
''||unistr('\000a')||
'/*'||unistr('\000a')||
'SELECT sprache, '||unistr('\000a')||
'       ow.id b'||unistr('\000a')||
'FROM app_sprachen ow, pers_optionen po , optionstypen ot    /* Subsetzugriff * /'||unistr('\000a')||
'where po.opttyp_id = ot.id  /* JOIN OT * /'||unistr('\000a')||
'  and ot.art = 1        /* Subset * /'||unistr('\000a')||
'  and po.opttyp_id = 23  /* Sprachen * /'||unistr('\000a')||
'  and ow.id = po.wert'||unistr('\000a')||
'  /* Persid des Subsets sonst null * /'||unistr('\000a')||
'  and po.persstamm_id = :p102_pers_opt_persstamm_id '||unistr('\000a')||
'UNION'||unistr('\000a')||
'/* Zugriff auf Appsprachen (statt Optionswerte), da keine Subsetdef. od. da Def.wertverwaltg* /'||unistr('\000a')||
'SELECT sprache,'||unistr('\000a')||
'       ow.id b'||unistr('\000a')||
'FROM app_sprachen ow, optionstypen ot'||unistr('\000a')||
'where ot.id = 23 /* Sprachen* /'||unistr('\000a')||
'  and (ot.art = 1 and /* Subset und keine Subsetdefinition gefunden* /'||unistr('\000a')||
'       :p102_pers_opt_persstamm_id  IS NULL'||unistr('\000a')||
'       OR'||unistr('\000a')||
'       ot.art != 1  /* Kein Subset * /'||unistr('\000a')||
'      )'||unistr('\000a')||
'order by 1  '||unistr('\000a')||
'*/',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'REDIRECT_SET_VALUE',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3972006258058910 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_PAGE_TITEL_ANMELDUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3972223498058910 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3972427962058910 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_BL_LOGIN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3972632736058910 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_USERNAME',
  p_data_type=> '',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL_LOGIN_102"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 100,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 2,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3972817344058912 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_PASSWORD',
  p_data_type=> '',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL_LOGIN_102"',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_PASSWORD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 100,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_encrypt_session_state_yn=> 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3973023244058912 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_LOGIN',
  p_data_type=> '',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> '',
  p_item_default=> 'LOGIN',
  p_prompt=>'&P102_BL_LOGIN.',
  p_source=>'LOGIN',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'template:'||to_char(3817106493727350 + wwv_flow_api.g_id_offset),
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'S',
  p_button_action => 'SUBMIT',
  p_button_is_hot=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4798911906825998 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_APP_SPRACHE_ID_PARAM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'App Sprache Id Param',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6265603846577231 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_HINWEIS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 171,
  p_item_plug_id => 6265322702577220+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'frgbg_s.holen_uebersetzung(10,:p102_sprache_id)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 70,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'1=1',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6265909804592420 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 102,
  p_name=>'P102_PAGE_TITEL_HINWEIS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 181,
  p_item_plug_id => 3971620053058893+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Titel Hinweis',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3422031065993456 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_wartung',
  p_validation_sequence=> 5,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_text   varchar2(4000);'||unistr('\000a')||
'   v_liste  varchar2(4000);'||unistr('\000a')||
'   v_flag   NUMBER;'||unistr('\000a')||
'   v_prot_id  NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p102_wartung_flag := 0;'||unistr('\000a')||
'   SELECT to_number(parameter) INTO v_flag'||unistr('\000a')||
'   FROM sysareas_frgbg'||unistr('\000a')||
'   WHERE id = 10;'||unistr('\000a')||
'   SELECT parameter INTO v_liste'||unistr('\000a')||
'   FROM sysareas_frgbg'||unistr('\000a')||
'   WHERE id = 11;'||unistr('\000a')||
'--mel.p(''Wartungsflag:%1, Text %2'',v_prot_id,''INFO'',''FAS104/102: check_wartung'',v_flag,:P101_HINWEIS);'||unistr('\000a')||
'   IF v_flag = 1 and  -- Generelles Wartungsflag'||unistr('\000a')||
'      -- Check USER, die während der Wartung arbeiten dürfen '||unistr('\000a')||
'      instr(UPPER(v_liste),'';''||UPPER(:p102_username)||'';'') = 0 and  '||unistr('\000a')||
'      -- Check Applikation, die gewartet werden'||unistr('\000a')||
'      instr(UPPER(v_liste),'';''||UPPER(:APP_ID)||'';'') = 0    '||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      :p102_wartung_flag := 1;'||unistr('\000a')||
'      v_text := frgbg_s.holen_uebersetzung(10,:p101_sprache_id);'||unistr('\000a')||
'      IF v_text is null or v_text = ''.'' THEN'||unistr('\000a')||
'         v_text := ''System is not available because of system maintaince! Please try again later.'';'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'      RETURN v_text;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :p102_wartung_flag := 0;'||unistr('\000a')||
'      RETURN null;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3973314586058914 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_gueltiges_login',
  p_validation_sequence=> 10,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_anz_login        personenstamm.login_fehlversuche%TYPE;'||unistr('\000a')||
'   v_anz_max_login    personenstamm.login_fehlversuche%TYPE;'||unistr('\000a')||
'   v_personenstamm_id personenstamm.id%TYPE;'||unistr('\000a')||
'   v_fas_schema_id_pers  personenstamm.id%TYPE;'||unistr('\000a')||
'   v_betreuer         personenstamm.betreuer%TYPE;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
''||unistr('\000a')||
'   -- Sperren des Logins nach n Fehlversuchen'||unistr('\000a')||
'   :p102_username:=TRIM(UPPER (:p102_username));'||unistr('\000a')||
''||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      SELECT NVL(min(parameter),5) INTO v_anz_max_login'||unistr('\000a')||
'      FROM sysareas_frgbg'||unistr('\000a')||
'      WHERE id = 3;'||unistr('\000a')||
'      SELECT login_fehlversuche,id,betreuer'||unistr('\000a')||
'      INTO v_anz_login, v_personenstamm_id, v_betreuer'||unistr('\000a')||
'      FROM personenstamm'||unistr('\000a')||
'      WHERE user_account = TRIM(UPPER (:p102_username));'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN OTHERS THEN '||unistr('\000a')||
'       NULL;'||unistr('\000a')||
'   END;'||unistr('\000a')||
'   IF v_anz_login >= v_anz_max_login THEN'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(477,:p102_sprache_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Schema-Prüfung'||unistr('\000a')||
'   v_fas_schema_id_pers:= frgbg_s.get_fas_schema(v_personenstamm_id,''BETREUER'');'||unistr('\000a')||
'   IF v_fas_schema_id_pers = :fas_schema_id THEN'||unistr('\000a')||
'      NULL; -- alles ok'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(476,:p102_sprache_id));   '||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Betreuer-User muss valid sein + Rolle mind. PRODAUFBEARB_ANZEIGEN besitzen'||unistr('\000a')||
'   IF frgbg_s.VALID_USER (:p102_username,:p102_password) AND '||unistr('\000a')||
'      v_betreuer = ''J'' AND'||unistr('\000a')||
'      /*         '||unistr('\000a')||
'      ( frgbg_s.check_fas_rolle(:P102_USERNAME,''PRODAUFBEARB_ANZEIGEN'') != 0 OR'||unistr('\000a')||
'        frgbg_s.check_fas_rolle(:P102_USERNAME,''PRODAUFBEARB_STORNO'') != 0 OR'||unistr('\000a')||
'        frgbg_s.check_fas_rolle(:P102_USERNAME,''PRODAUFBEARB_SPEICHERN'') != 0 OR'||unistr('\000a')||
'        frgbg_s.check_fas_rolle(:P102_USERNAME,''PRODAUFBEARB_STARTEN'') != 0 '||unistr('\000a')||
'      )'||unistr('\000a')||
'      */'||unistr('\000a')||
'      (-- Zugriffberechtigung für Bearbeitung'||unistr('\000a')||
'       frgbg_t.CHECK_FAS_APP_ZUGRIFF(:FAS_LOGIN_PERSONENSTAMM_ID,'||unistr('\000a')||
'                                     :FAS_LOGIN_PERSONENSTAMM_ID, -- :FAS_IDENTITAET_PERSSTAMM_ID,'||unistr('\000a')||
'                                     :APP_ID,5) = 1 '||unistr('\000a')||
'      )'||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         UPDATE personenstamm'||unistr('\000a')||
'         SET app_sprache_id = :p102_app_sprache_id,'||unistr('\000a')||
'             login_fehlversuche = 0'||unistr('\000a')||
'         WHERE id = v_personenstamm_id;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN OTHERS THEN '||unistr('\000a')||
'          NULL;'||unistr('\000a')||
'      END;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         UPDATE personenstamm'||unistr('\000a')||
'         SET login_fehlversuche = login_fehlversuche +1'||unistr('\000a')||
'         WHERE id = v_personenstamm_id;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN OTHERS THEN '||unistr('\000a')||
'          NULL;'||unistr('\000a')||
'      END;'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(476,:p102_sprache_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':p102_WARTUNG_FLAG = 0',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||unistr('\000a')||
'   owa_util.mime_header(''text/html'', FALSE);'||unistr('\000a')||
'   owa_cookie.send('||unistr('\000a')||
'       name=>''FAS_LOGIN_USERNAME_COOKIE'','||unistr('\000a')||
'       value=>utl_url.escape(lower(:P102_USERNAME), true,''AL32UTF8''));'||unistr('\000a')||
'   owa_cookie.send('||unistr('\000a')||
'       name=>''FAS_SPRACHE_COOKIE'','||unistr('\000a')||
'       value=>:P102_APP_SPRACHE_ID);'||unistr('\000a')||
'exception '||unistr('\000a')||
'when others then '||unistr('\000a')||
'   null;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3973419439058918 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Benutzername-Cookie festlegen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':fas_aufgerufen_von := ''PRODAUFBEARB'';'||unistr('\000a')||
':fas_login_page := :APP_PAGE_ID;'||unistr('\000a')||
':fas_sprache_id:= :p102_sprache_id;'||unistr('\000a')||
':FAS_LOGIN_USER_ACCOUNT := :P102_USERNAME;'||unistr('\000a')||
'/* NEI 20.04.09 in Anwendungsprozess'||unistr('\000a')||
':fas_abmelden_text := frgbg_s.holen_uebersetzung(174,:p102_sprache_id);'||unistr('\000a')||
':fas_keine_daten_text := frgbg_s.holen_uebersetzung(759,:p102_sprache_id);'||unistr('\000a')||
'*/'||unistr('\000a')||
'wwv_flow_custom_auth_std.login('||unistr('\000a')||
'    P_UNAME       => v(''P102_U';

p:=p||'SERNAME''),'||unistr('\000a')||
'    P_PASSWORD    => v(''P102_PASSWORD''),'||unistr('\000a')||
'    P_SESSION_ID  => v(''APP_SESSION''),'||unistr('\000a')||
'    P_FLOW_PAGE   => :APP_ID||'':5'','||unistr('\000a')||
'    P_PRESERVE_CASE => TRUE'||unistr('\000a')||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 3973603663058925 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Login',
  p_process_sql_clob => p,
  p_process_error_message=> 'Ungültiges Login',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'2179930787869762';

wwv_flow_api.create_page_process(
  p_id     => 2180524123886796 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'set_fas_texte',
  p_process_sql_clob => 2179930787869762 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'12151422924614296';

wwv_flow_api.create_page_process(
  p_id     => 3974207705058925 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob => 12151422924614296 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_anz      NUMBER;'||unistr('\000a')||
'   v_prot_id  NUMBER;'||unistr('\000a')||
'BEGIN   '||unistr('\000a')||
'/*MEL.P (''1 Schema setzen:%1, pers %2'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''Prozessüberwachung'','||unistr('\000a')||
'           :fas_schema_id,:fas_schema_persstamm_id'||unistr('\000a')||
'          );      '||unistr('\000a')||
'*/'||unistr('\000a')||
'   IF :fas_schema_id is NULL THEN'||unistr('\000a')||
'      -- FAS-Schema über Servername ermitteln'||unistr('\000a')||
'      :fas_schema_id := frgbg_s.get_fas_schema_srv;'||unistr('\000a')||
'   ELSE -- Check gültiges Schemaangabe?'||unistr('\000a')||
'  ';

p:=p||'    BEGIN'||unistr('\000a')||
'         SELECT count(*) INTO v_anz'||unistr('\000a')||
'         FROM fas_schemas'||unistr('\000a')||
'         WHERE id = :fas_schema_id;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'          v_anz := 0;'||unistr('\000a')||
'      END ;'||unistr('\000a')||
''||unistr('\000a')||
'      IF v_anz = 0 THEN -- FAlls ungültig über Servername ermitteln'||unistr('\000a')||
'         :fas_schema_id := frgbg_s.get_fas_schema_srv;           '||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   :FAS_THEME_NAME:= ''fas_theme_''||:fas_schema_id;'||unistr('\000a')||
''||unistr('\000a')||
'   -- ';

p:=p||'Holen der Persstamm_id für das FAS-Schema'||unistr('\000a')||
'   --:fas_schema_persstamm_id := frgbg_s.get_pers_fas_schema(:fas_schema_id);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Fas-Modus setzen abhängig vom Schema'||unistr('\000a')||
'   SELECT fas_modus_id into :fas_modus_id'||unistr('\000a')||
'   FROM fas_schemas'||unistr('\000a')||
'   WHERE id = :fas_schema_id;'||unistr('\000a')||
''||unistr('\000a')||
'/* NEI 24.09.09 FAS-Schema über Servername ermitteln'||unistr('\000a')||
'   IF :fas_schema_id is NULL THEN'||unistr('\000a')||
'      :fas_schema_id := frgbg_s.get_fas_schema_std;'||unistr('\000a')||
'   E';

p:=p||'ND IF;'||unistr('\000a')||
'   -- Holen der Persstamm_id für das FAS-Schema'||unistr('\000a')||
'   :fas_schema_persstamm_id := frgbg_s.get_pers_fas_schema(:fas_schema_id);'||unistr('\000a')||
'   -- Holen der Persstamm_id für die entsprechende Pers_option des Sprachen-Subsets'||unistr('\000a')||
'   :P102_PERS_OPT_PERSSTAMM_ID := '||unistr('\000a')||
'                  frgbg_s.GET_PERS_OPT_PERS_ID(:fas_schema_persstamm_id,23,'||unistr('\000a')||
'                                               :fas_schema_persstamm_id);'||unistr('\000a')||
'';

p:=p||'*/'||unistr('\000a')||
'/*MEL.P (''Schema setzen:%1, pers %2,%3'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''Prozessüberwachung'','||unistr('\000a')||
'           :fas_schema_id,:fas_schema_persstamm_id'||unistr('\000a')||
'          );      '||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 2773809707706746 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_fas_schema_fas_modus',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'    c owa_cookie.cookie;'||unistr('\000a')||
'begin'||unistr('\000a')||
'   c := owa_cookie.get(''FAS_LOGIN_USERNAME_COOKIE'');'||unistr('\000a')||
'   :P102_USERNAME := utl_url.unescape(c.vals(1),''AL32UTF8''); '||unistr('\000a')||
'exception '||unistr('\000a')||
'when others then '||unistr('\000a')||
'    null;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3973830371058925 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Benutzername-Cookie abrufen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_sprache varchar2(50);'||unistr('\000a')||
'   v_anz        NUMBER;'||unistr('\000a')||
'   c owa_cookie.cookie;'||unistr('\000a')||
'   v_sprache_id NUMBER;'||unistr('\000a')||
'   v_prot_id    NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'MEL.P (''0 app_sprache_setzen: Appsp %1, sprache %2, appsp param %3, owa %4,pos %5'','||unistr('\000a')||
'           v_prot_id,''Fehler'',''Page 121'','||unistr('\000a')||
'           to_char(:p121_app_sprache_id),'||unistr('\000a')||
'           to_char(v_sprache_id),:p121_app_sprache_id_param,'||unistr('\000a')||
'           owa_util.get_cgi_env';

p:=p||'(''HTTP_ACCEPT_LANGUAGE''),'||unistr('\000a')||
'          instr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''),'','')'||unistr('\000a')||
'          );'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'  IF :p102_app_sprache_id_param IS NULL THEN'||unistr('\000a')||
'     -- Zunaechst aus Cookie                          -- NEI 6.6.11 '||unistr('\000a')||
'     BEGIN                                            '||unistr('\000a')||
'        c := owa_cookie.get(''FAS_SPRACHE_COOKIE'');    '||unistr('\000a')||
'        -- Check, ob Sprache zum Schema passt, sonst Sprache unguel';

p:=p||'tig => Browsersprache'||unistr('\000a')||
'        SELECT count(*) into v_anz'||unistr('\000a')||
'        FROM app_sprachen s, fas_schemas fs'||unistr('\000a')||
'        WHERE fs.id = :fas_schema_id'||unistr('\000a')||
'          AND fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'          AND s.id =c.vals(1)'||unistr('\000a')||
'          AND s.aktiv=1;  -- NEI 09.09.2014'||unistr('\000a')||
'        IF v_anz > 0 THEN'||unistr('\000a')||
'           :P102_APP_SPRACHE_ID:= c.vals(1);          '||unistr('\000a')||
'        ELSE'||unistr('\000a')||
'           :P102_APP_SPRACHE_ID:=NU';

p:=p||'LL;'||unistr('\000a')||
'        END IF;'||unistr('\000a')||
'     exception '||unistr('\000a')||
'     when others then '||unistr('\000a')||
'           :P102_APP_SPRACHE_ID:=NULL;               '||unistr('\000a')||
'     end;                                             -- NEI 6.6.11'||unistr('\000a')||
'     IF :P102_APP_SPRACHE_ID IS NULL THEN             -- NEI 6.6.11 '||unistr('\000a')||
'        -- Browsersprache holen und abgleichen mit App-Sprachen für das Schema'||unistr('\000a')||
'        v_sprache := substr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''';

p:=p||'), 1,'||unistr('\000a')||
'                     instr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''), '','')-1);'||unistr('\000a')||
'        :p102_app_sprache_id := frgbg_s.get_browser_sprache(v_sprache);'||unistr('\000a')||
'     END IF;'||unistr('\000a')||
'  ELSE'||unistr('\000a')||
'     :p102_app_sprache_id := :p102_app_sprache_id_param;'||unistr('\000a')||
'     :p102_app_sprache_id_param := NULL;'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
'--MEL.P (''app_sprache_setzen:App_sp_param:%1,App_sp:%2'',v_prot_id,''Fehler'', ''104/102:app_sprache_setzen'', :p102_';

p:=p||'app_sprache_id_param,:p102_app_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
' /* NEI 24.09.09 Kein Optionstyp für Sprachen mehr sondern über Schema in app_sprachen'||unistr('\000a')||
'  IF :p102_app_sprache_id_param IS NULL THEN'||unistr('\000a')||
'--MEL.P (''1 app_sprache_setzen:%1, Browser %2'',v_prot_id,''Fehler'',''Page 121'');'||unistr('\000a')||
'     IF :fas_schema_id = 2 THEN  -- Biogena '||unistr('\000a')||
'        -- Default des Sprachsubsets entsprechend der Schemavorgabe'||unistr('\000a')||
'        :p102_app_sprache_id :=';

p:=p||' '||unistr('\000a')||
'                frgbg_s.get_pers_option(NULL,23,:fas_schema_persstamm_id,  '||unistr('\000a')||
'                                                :fas_schema_persstamm_id);'||unistr('\000a')||
'     ELSE '||unistr('\000a')||
'        -- Abgleich der Browser-Sprache mit dem entsprechenden Sprachsubset'||unistr('\000a')||
'        v_sprache := substr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''), 1,'||unistr('\000a')||
'                        instr(owa_util.get_cgi_env(''HTTP_ACCEPT_LANGUAGE''), '','')-1)';

p:=p||';'||unistr('\000a')||
'        :p102_app_sprache_id := frgbg_s.get_browser_sprache(v_sprache, :P102_PERS_OPT_PERSSTAMM_ID);'||unistr('\000a')||
'     END IF;'||unistr('\000a')||
'  ELSE'||unistr('\000a')||
'     :p102_app_sprache_id := :p102_app_sprache_id_param;'||unistr('\000a')||
'     :p102_app_sprache_id_param := NULL;'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3974014954058925 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'app_sprache_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'Y',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   SELECT sprache_id into :p102_sprache_id '||unistr('\000a')||
'   FROM app_sprachen'||unistr('\000a')||
'   WHERE id = :p102_app_sprache_id;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1205630925605677 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sprache_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'  -- MEL.P (''Login buttonlabels: Language =''||to_char(:p102_app_sprache_id )||'')! [Loginpage 101]'' --||SQLERRM, v_PROT_ID, ''ERROR'', ''get_mnr_max_version'');'||unistr('\000a')||
'   /* NEI 24.09.09 Defaultsprache obsolet, da schemaspezif. App-Sprachen'||unistr('\000a')||
'   IF :p102_app_sprache_id IS NULL THEN'||unistr('\000a')||
'      SELECT NVL(min(parameter),3) into :p102_app_sprache_id '||unistr('\000a')||
'      from sysareas_frgbg'||unistr('\000a')||
'      wh';

p:=p||'ere id = 5; -- Default App-Sprache'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'*/'||unistr('\000a')||
'/*'||unistr('\000a')||
'   SELECT sprache_id into :p102_sprache_id '||unistr('\000a')||
'   FROM app_sprachen'||unistr('\000a')||
'   WHERE id = :p102_app_sprache_id;'||unistr('\000a')||
'*/'||unistr('\000a')||
'   :p102_bl_login := frgbg_s.holen_uebersetzung(430,:p102_sprache_id);'||unistr('\000a')||
'   :p102_page_titel_anmeldung := frgbg_s.holen_uebersetzung(1935,:p102_sprache_id);'||unistr('\000a')||
'   :p102_page_titel_hinweis := frgbg_s.holen_uebersetzung(3786,:p102_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3974610388058926 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 50,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   SELECT id INTO :FAS_LOGIN_PERSONENSTAMM_ID'||unistr('\000a')||
'   FROM personenstamm'||unistr('\000a')||
'   WHERE user_account = TRIM(UPPER (:p102_username));'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN '||unistr('\000a')||
'    NULL;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3974409464058925 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 102,
  p_process_sequence=> 50,
  p_process_point=> 'ON_SUBMIT_BEFORE_COMPUTATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FAS_LOGIN_PERSONENSTAMM_ID_SETZEN',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 102
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00550
prompt  ...PAGE 550: Job Liste
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 550
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Job Liste'
 ,p_step_title => 'Job Liste'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Job Liste'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_step_template => 3816709855727350 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'N'
 ,p_cache_page_yn => 'N'
 ,p_help_text => 
'No help is available for this page.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20140620143837'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select'||unistr('\000a')||
'           CASE WHEN NVL(aufgabe_aktuell,beschreibung) is not NULL THEN'||unistr('\000a')||
'              ''<div style="height:20px; font-weight:bold;">'''||unistr('\000a')||
'              || CASE WHEN LENGTH(NVL(aufgabe_aktuell,beschreibung)) > 35 THEN'||unistr('\000a')||
'                    DBMS_LOB.SUBSTR(NVL(aufgabe_aktuell,beschreibung),35,1) || ''...'''||unistr('\000a')||
'                 ELSE'||unistr('\000a')||
'                    NVL(aufgabe_aktuell,beschreibung)'||unistr('\000a')||
'                 END';

s:=s||''||unistr('\000a')||
'               || ''</div>'''||unistr('\000a')||
'           ELSE'||unistr('\000a')||
'              '''''||unistr('\000a')||
'           END'||unistr('\000a')||
'           ||'||unistr('\000a')||
'           FRGBG_T.HTML_CREATE_GRAPH (fortschritt,'||unistr('\000a')||
'              case WHEN STATUS_ID = 1'||unistr('\000a')||
'                then trim(to_char(fortschritt,''990D9'')) || '' %'''||unistr('\000a')||
'              WHEN STATUS_ID = 4'||unistr('\000a')||
'                then'||unistr('\000a')||
'                  frgbg_s.HOLEN_UEBERSETZUNG(TEXT_ID,:FAS_SPRACHE_ID) ||'||unistr('\000a')||
'                  case when fe';

s:=s||'hlermeldung is not null then'||unistr('\000a')||
'                     '' (<a href="javascript:alert('''''' || FRGBG_T.JSON_ESCAPE_TEXT(fehlermeldung) || '' '''');">?</a>)'''||unistr('\000a')||
'                  else'||unistr('\000a')||
'                     '''''||unistr('\000a')||
'                  end'||unistr('\000a')||
'              ELSE'||unistr('\000a')||
'                  frgbg_s.HOLEN_UEBERSETZUNG(TEXT_ID,:FAS_SPRACHE_ID)'||unistr('\000a')||
'              END'||unistr('\000a')||
'              || CASE WHEN DOWNLOAD_DATEI IS NOT NULL THEN'||unistr('\000a')||
'               '' (<a';

s:=s||' href="javascript:apex.submit({request:''''DOWNLOAD_FILE'' || a.ID || ''''''});">'''||unistr('\000a')||
'                 || FRGBG_S.holen_uebersetzung(8026,:FAS_SPRACHE_ID) || ''</a>)'''||unistr('\000a')||
'              ELSE'||unistr('\000a')||
'                '''''||unistr('\000a')||
'              END'||unistr('\000a')||
'             ,280,20,''cccccc'','||unistr('\000a')||
'                  case when fortschritt <= 30'||unistr('\000a')||
'                     THEN ''BF381A'''||unistr('\000a')||
'                  when fortschritt > 30 and fortschritt <= 70'||unistr('\000a')||
'             ';

s:=s||'        then ''DF7401'' --''EFD13B'''||unistr('\000a')||
'                  when fortschritt > 70'||unistr('\000a')||
'                     then ''7DC24B'''||unistr('\000a')||
'                  else'||unistr('\000a')||
'                     ''5069B3'''||unistr('\000a')||
'                  end'||unistr('\000a')||
'              ,''000000'',''ffffff'''||unistr('\000a')||
'        ) FORTSCHRITT_GRAFIK'||unistr('\000a')||
'        , -- Löschbutton'||unistr('\000a')||
'        CASE WHEN NVL(aufgabe_aktuell,beschreibung) is not NULL'||unistr('\000a')||
'          THEN ''<div style="height:20px;">&nbsp;</div>'''||unistr('\000a')||
'          ';

s:=s||'ELSE '''''||unistr('\000a')||
'        END'||unistr('\000a')||
'        || ''<input type="button" style="height:20px; margin-bottom:1px;" value="X"'''||unistr('\000a')||
'        || '' onclick="javascript:apex.submit({request:''''DEL_JOB'' || a.ID || ''''''});" />'''||unistr('\000a')||
'        DEL'||unistr('\000a')||
''||unistr('\000a')||
'    from FRGBG.APP_JOBS a, FRGBG.APP_JOB_STATUS s'||unistr('\000a')||
'    where'||unistr('\000a')||
'      app_id = :APP_ID'||unistr('\000a')||
'      and USER_ACCOUNT = :APP_USER'||unistr('\000a')||
'      --and status_ID not in(STATUS_CANCELED)'||unistr('\000a')||
'      and a.MUTDAT > sysdate - ';

s:=s||'24/60 -- Maximal 60 Minuten halten'||unistr('\000a')||
'      and a.satz_kennzeichen is null'||unistr('\000a')||
'      and a.visible = 1'||unistr('\000a')||
'      and a.STATUS_ID = s.id'||unistr('\000a')||
'      and (a.STATUS_ID = 1 and a.JOB_ID in (select JOB from dba_jobs_running) or a.STATUS_ID <> 1)'||unistr('\000a')||
'    order by a.ERFDAT ASC';

wwv_flow_api.create_report_region (
  p_id=> 9177131268812286 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 550,
  p_name=> 'App Jobs',
  p_region_name=>'',
  p_template=> 3818608283727362+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 12,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'apex/builder/dup.gif',
  p_query_asc_image_attr=> 'width="16" height="16" alt="" ',
  p_query_desc_image=> 'apex/builder/ddown.gif',
  p_query_desc_image_attr=> 'width="16" height="16" alt="" ',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9177324266812287 + wwv_flow_api.g_id_offset,
  p_region_id=> 9177131268812286 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FORTSCHRITT_GRAFIK',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9177430079812287 + wwv_flow_api.g_id_offset,
  p_region_id=> 9177131268812286 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DEL',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>9181827643812295 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 550,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:550:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 15-MAY-2014 18:28 by SASCHA.LENZ');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>9177517994812287 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 550,
  p_name=>'P550_REQUEST',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 9177131268812286+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>9177715033812288 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 550,
  p_name=>'P550_ANZAHL_JOBS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 9177131268812286+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select  COUNT(*)'||unistr('\000a')||
'from FRGBG.APP_JOBS a, FRGBG.APP_JOB_STATUS s'||unistr('\000a')||
'where'||unistr('\000a')||
'  app_id = :APP_ID'||unistr('\000a')||
'  and USER_ACCOUNT = :APP_USER'||unistr('\000a')||
'  --and status_ID not in(STATUS_CANCELED)'||unistr('\000a')||
'  and a.MUTDAT > sysdate - 24/60 -- Maximal 60 Minuten halten'||unistr('\000a')||
'  and a.satz_kennzeichen is null'||unistr('\000a')||
'  and a.visible = 1'||unistr('\000a')||
'  and a.STATUS_ID = s.id'||unistr('\000a')||
'  and (a.STATUS_ID = 1 and a.JOB_ID in (select JOB from dba_jobs_running) or a.STATUS_ID <> 1)',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>9177923864812288 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 550,
  p_name=>'P550_DOWNLOAD_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 9177131268812286+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => 'Wird verwendet um automatisch den Download anzubieten');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>9178128931812288 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 550,
  p_name=>'P550_UMLEITUNG_URL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 9177131268812286+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 9180706474812293 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_name => 'Starte Aktualisierungstimer'
 ,p_event_sequence => 10
 ,p_bind_type => 'bind'
 ,p_bind_event_type => 'ready'
  );
wwv_flow_api.create_page_da_action (
  p_id => 9181219879812294 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_event_id => 9180706474812293 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'PLUGIN_COM.ORACLE.APEX.TIMER'
 ,p_affected_elements_type => 'REGION'
 ,p_affected_region_id => 9177131268812286 + wwv_flow_api.g_id_offset
 ,p_attribute_01 => 'add'
 ,p_attribute_02 => 'REFRESHER'
 ,p_attribute_04 => '2000'
 ,p_attribute_05 => 'infinite'
 ,p_stop_execution_on_error => 'Y'
 );
wwv_flow_api.create_page_da_action (
  p_id => 9181006998812294 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_event_id => 9180706474812293 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 20
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_JAVASCRIPT_CODE'
 ,p_attribute_01 => '$(document).ready(function() {'||unistr('\000a')||
' '||unistr('\000a')||
'  if(parent && parent.document) {'||unistr('\000a')||
'    parent.$( "#jobliste").draggable();'||unistr('\000a')||
'  }'||unistr('\000a')||
''||unistr('\000a')||
'});'
 ,p_stop_execution_on_error => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 9178900646812291 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_name => 'Job Liste Aktualisieren'
 ,p_event_sequence => 20
 ,p_triggering_element_type => 'REGION'
 ,p_triggering_region_id => 9177131268812286 + wwv_flow_api.g_id_offset
 ,p_bind_type => 'bind'
 ,p_bind_event_type => 'PLUGIN_COM.ORACLE.APEX.TIMER|DYNAMIC ACTION|timer_expired'
  );
wwv_flow_api.create_page_da_action (
  p_id => 9179630477812292 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_event_id => 9178900646812291 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_REFRESH'
 ,p_affected_elements_type => 'REGION'
 ,p_affected_region_id => 9177131268812286 + wwv_flow_api.g_id_offset
 ,p_stop_execution_on_error => 'Y'
 );
wwv_flow_api.create_page_da_action (
  p_id => 9179810461812292 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_event_id => 9178900646812291 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 20
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_EXECUTE_PLSQL_CODE'
 ,p_attribute_01 => 'begin'||unistr('\000a')||
'select  NVL(COUNT(*),0) into :P550_ANZAHL_JOBS'||unistr('\000a')||
'from FRGBG.APP_JOBS a, FRGBG.APP_JOB_STATUS s'||unistr('\000a')||
'where'||unistr('\000a')||
'  app_id = :APP_ID'||unistr('\000a')||
'  and USER_ACCOUNT = :APP_USER'||unistr('\000a')||
'  --and status_ID not in(STATUS_CANCELED)'||unistr('\000a')||
'  and a.MUTDAT > sysdate - 24/60 -- Maximal 60 Minuten halten'||unistr('\000a')||
'  and a.satz_kennzeichen is null'||unistr('\000a')||
'  and a.visible = 1'||unistr('\000a')||
'  and a.STATUS_ID = s.id'||unistr('\000a')||
'  and (a.STATUS_ID = 1 and a.JOB_ID in (select JOB from dba_jobs_running) or a.STATUS_ID <> 1)'||unistr('\000a')||
';'||unistr('\000a')||
''||unistr('\000a')||
'end;'
 ,p_attribute_02 => 'P550_ANZAHL_JOBS'
 ,p_attribute_03 => 'P550_ANZAHL_JOBS'
 ,p_attribute_04 => 'N'
 ,p_stop_execution_on_error => 'Y'
 ,p_wait_for_result => 'Y'
 );
wwv_flow_api.create_page_da_action (
  p_id => 9179220175812291 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_event_id => 9178900646812291 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 30
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_JAVASCRIPT_CODE'
 ,p_attribute_01 => 'if(parent && parent.$) {'||unistr('\000a')||
''||unistr('\000a')||
'   var anzahl_jobs = $v(''P550_ANZAHL_JOBS'');'||unistr('\000a')||
''||unistr('\000a')||
'   if(anzahl_jobs == ''0'') {'||unistr('\000a')||
'     '||unistr('\000a')||
'      // Entferne den iFrame, da kein Job mehr angezeigt wird'||unistr('\000a')||
'      parent.$(''#jobliste'').fadeOut(2000,function() { parent.$(''#jobliste'').remove(); }); '||unistr('\000a')||
''||unistr('\000a')||
'   } else if(anzahl_jobs !== null) {'||unistr('\000a')||
'      var listhoehe = parseInt(anzahl_jobs)*47 + 38;'||unistr('\000a')||
''||unistr('\000a')||
'      if(parent.$(''#jobliste'').height() <10) { // Beim Seitenaufruf keine Animation'||unistr('\000a')||
'          parent.$(''#jobliste'').css({ height: listhoehe.toString() + ''px'' }); '||unistr('\000a')||
'      } else {'||unistr('\000a')||
'          if(listhoehe  < parent.$(''#jobliste'').height()-5 || listhoehe > parent.$(''#jobliste'').height()+5) { // Nur Animieren wenn auch ein unterschied ist, da sonst das Fenster flackert'||unistr('\000a')||
'            //Ändere die Größe des Fensters abhängig von der Anzahl der Jobs'||unistr('\000a')||
'            parent.$(''#jobliste'').animate({ height: listhoehe.toString() + ''px'' },500); '||unistr('\000a')||
'          }'||unistr('\000a')||
'      }'||unistr('\000a')||
'   }'||unistr('\000a')||
'}'
 ,p_stop_execution_on_error => 'Y'
 );
wwv_flow_api.create_page_da_action (
  p_id => 9179429759812292 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_event_id => 9178900646812291 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 40
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_EXECUTE_PLSQL_CODE'
 ,p_attribute_01 => 'declare'||unistr('\000a')||
''||unistr('\000a')||
'    v_PROT_ID number;'||unistr('\000a')||
'    v_ERROR varchar2(32767);'||unistr('\000a')||
'    v_ERRNR number;'||unistr('\000a')||
''||unistr('\000a')||
'    c_PROD constant varchar2(100) := ''APP 102, Page 550 Dynamic Action: Job Liste Aktualisieren'';'||unistr('\000a')||
''||unistr('\000a')||
'    e_ERROR EXCEPTION;'||unistr('\000a')||
'    c_ERRNR constant number := -20100;'||unistr('\000a')||
''||unistr('\000a')||
'    PRAGMA EXCEPTION_INIT(e_ERROR,-20100);'||unistr('\000a')||
''||unistr('\000a')||
'    -- Exception, die bewirkt das durchgereichte Exceptions einfach weitergegeben werden.'||unistr('\000a')||
'    e_ERROR_D EXCEPTION;'||unistr('\000a')||
'    c_ERRNR_D constant number := -20101;'||unistr('\000a')||
'    PRAGMA EXCEPTION_INIT(e_ERROR_D,-20101);'||unistr('\000a')||
''||unistr('\000a')||
'  -- Alle aktiven Jobs, die einen Status wechsel hatten'||unistr('\000a')||
'  cursor c_job is '||unistr('\000a')||
'      select * from APP_JOBS a'||unistr('\000a')||
'      where'||unistr('\000a')||
'       app_id = :APP_ID'||unistr('\000a')||
'       and USER_ACCOUNT = :APP_USER'||unistr('\000a')||
'       and a.MUTDAT > sysdate - 24/60 -- Maximal 60 Minuten halten'||unistr('\000a')||
'       and a.satz_kennzeichen is null'||unistr('\000a')||
'       and a.visible = 1'||unistr('\000a')||
'       and (a.STATUS_ID = FRGBG_JOBS.STATUS_RUNNING and a.JOB_ID in (select JOB from dba_jobs_running) or a.STATUS_ID <> FRGBG_JOBS.STATUS_RUNNING)'||unistr('\000a')||
'       and a.STATUS_ID <> a.STATUS_ID_LAST'||unistr('\000a')||
'  ;'||unistr('\000a')||
'  '||unistr('\000a')||
'  v_exit boolean := true;'||unistr('\000a')||
'begin'||unistr('\000a')||
'  :P550_DOWNLOAD_ID := NULL;'||unistr('\000a')||
'  :P550_UMLEITUNG_URL := NULL;'||unistr('\000a')||
''||unistr('\000a')||
'  for v_job in c_job loop'||unistr('\000a')||
''||unistr('\000a')||
'    if(v_job.DOWNLOAD_DATEI is not NULL AND v_job.STATUS_ID = FRGBG_JOBS.STATUS_COMPLETE) THEN'||unistr('\000a')||
'        :P550_DOWNLOAD_ID := v_job.ID;'||unistr('\000a')||
''||unistr('\000a')||
'        v_exit := true;'||unistr('\000a')||
'        '||unistr('\000a')||
''||unistr('\000a')||
'    end if;'||unistr('\000a')||
''||unistr('\000a')||
'    if(v_job.UMLEITUNG_URL is not null AND v_job.STATUS_ID = FRGBG_JOBS.STATUS_COMPLETE) THEN'||unistr('\000a')||
'      '||unistr('\000a')||
'        :P550_UMLEITUNG_URL := apex_util.prepare_url(v_job.UMLEITUNG_URL);'||unistr('\000a')||
''||unistr('\000a')||
'        v_exit := true;'||unistr('\000a')||
''||unistr('\000a')||
'    end if;'||unistr('\000a')||
''||unistr('\000a')||
'    if v_exit then'||unistr('\000a')||
''||unistr('\000a')||
'        begin'||unistr('\000a')||
'          -- Damit es beim nächsten Durchlauf nicht mehr gezogen wird. (Nur einmal zum Download anbieten.'||unistr('\000a')||
'          UPDATE APP_JOBS SET'||unistr('\000a')||
'             STATUS_ID_LAST = STATUS_ID'||unistr('\000a')||
'          WHERE'||unistr('\000a')||
'             ID = v_job.ID;'||unistr('\000a')||
'        exception'||unistr('\000a')||
'          when others then'||unistr('\000a')||
'            v_error := ''Fehler beim aktualisieren des letzten Job-Status '' || sqlerrm;'||unistr('\000a')||
'            v_errnr := -10;'||unistr('\000a')||
'            raise e_error;'||unistr('\000a')||
'        end;'||unistr('\000a')||
''||unistr('\000a')||
'        exit; -- Immer nur eins zum Dowload anbieten'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'    end if;'||unistr('\000a')||
'  end loop;'||unistr('\000a')||
''||unistr('\000a')||
'  begin'||unistr('\000a')||
'    UPDATE APP_JOBS SET'||unistr('\000a')||
'      VISIBLE = 0'||unistr('\000a')||
'    WHERE'||unistr('\000a')||
'     app_id = :APP_ID'||unistr('\000a')||
'     and USER_ACCOUNT = :APP_USER'||unistr('\000a')||
'     and VISIBLE = 1'||unistr('\000a')||
'     and SATZ_KENNZEICHEN is null'||unistr('\000a')||
'     and ((HIDE_BY_COMPLETE = 1 AND STATUS_ID = FRGBG_JOBS.STATUS_COMPLETE) '||unistr('\000a')||
'         OR STATUS_ID IN (FRGBG_JOBS.STATUS_KILLED,FRGBG_JOBS.STATUS_CANCELED)'||unistr('\000a')||
'     );'||unistr('\000a')||
'  exception'||unistr('\000a')||
'    when others then'||unistr('\000a')||
'      v_error := ''Fehler beim Entfernen von fertigen Jobs mit Auto-Hide. SQLERRM: '' || SQLERRM;'||unistr('\000a')||
'      v_errnr := -20;'||unistr('\000a')||
'      raise e_error;'||unistr('\000a')||
'  end;'||unistr('\000a')||
''||unistr('\000a')||
'exception'||unistr('\000a')||
'        when e_ERROR then'||unistr('\000a')||
'            MEL.P (c_PROD ||  ''('' || v_ERRNR || ''): '' || v_error, v_PROT_ID, ''ERROR'', dbms_utility.format_error_backtrace);'||unistr('\000a')||
'            raise_application_error(c_ERRNR_D, v_ERROR);'||unistr('\000a')||
'            raise;'||unistr('\000a')||
'        when e_ERROR_D then'||unistr('\000a')||
'            raise; -- Einfach durchreichen'||unistr('\000a')||
'        when others then'||unistr('\000a')||
'            v_ERROR := ''Unbekannter Fehler in '' || c_PROD || '' SQLERRM:'' || SQLERRM;'||unistr('\000a')||
'            MEL.P (c_PROD || '': '' || v_error, v_PROT_ID, ''ERROR'', dbms_utility.format_error_backtrace);'||unistr('\000a')||
'            raise_application_error(c_ERRNR_D, v_ERROR);'||unistr('\000a')||
'            raise;'||unistr('\000a')||
''||unistr('\000a')||
'end;'
 ,p_attribute_03 => 'P550_DOWNLOAD_ID,P550_UMLEITUNG_URL'
 ,p_attribute_04 => 'N'
 ,p_stop_execution_on_error => 'Y'
 ,p_wait_for_result => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 9179914550812292 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_name => 'Beende Aktualisierung'
 ,p_event_sequence => 30
 ,p_triggering_element_type => 'ITEM'
 ,p_triggering_element => 'P550_ANZAHL_JOBS'
 ,p_triggering_condition_type => 'EQUALS'
 ,p_triggering_expression => '0'
 ,p_bind_type => 'bind'
 ,p_bind_event_type => 'change'
  );
wwv_flow_api.create_page_da_action (
  p_id => 9180226401812293 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_event_id => 9179914550812292 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'PLUGIN_COM.ORACLE.APEX.TIMER'
 ,p_affected_elements_type => 'REGION'
 ,p_affected_region_id => 9177131268812286 + wwv_flow_api.g_id_offset
 ,p_attribute_01 => 'remove'
 ,p_attribute_03 => 'REFRESHER'
 ,p_attribute_05 => 'infinite'
 ,p_stop_execution_on_error => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 9180305123812293 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_name => 'Starte Download automatisch'
 ,p_event_sequence => 40
 ,p_triggering_element_type => 'ITEM'
 ,p_triggering_element => 'P550_DOWNLOAD_ID'
 ,p_triggering_condition_type => 'JAVASCRIPT_EXPRESSION'
 ,p_triggering_expression => '$v(''P550_DOWNLOAD_ID'').length > 0'
 ,p_bind_type => 'bind'
 ,p_bind_event_type => 'change'
  );
wwv_flow_api.create_page_da_action (
  p_id => 9180624417812293 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_event_id => 9180305123812293 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_JAVASCRIPT_CODE'
 ,p_attribute_01 => 'if($v(''P550_DOWNLOAD_ID'').length > 0) {'||unistr('\000a')||
'  // Download automatisch starten '||unistr('\000a')||
'  apex.submit({request: ''DOWNLOAD_FILE'' + $v(''P550_DOWNLOAD_ID'')});'||unistr('\000a')||
''||unistr('\000a')||
'}'
 ,p_stop_execution_on_error => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 9181316394812294 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_name => 'Auto-Umleitung'
 ,p_event_sequence => 50
 ,p_triggering_element_type => 'ITEM'
 ,p_triggering_element => 'P550_UMLEITUNG_URL'
 ,p_triggering_condition_type => 'JAVASCRIPT_EXPRESSION'
 ,p_triggering_expression => '$v(''P550_UMLEITUNG_URL'').length > 0'
 ,p_bind_type => 'bind'
 ,p_bind_event_type => 'change'
  );
wwv_flow_api.create_page_da_action (
  p_id => 9181625532812294 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 550
 ,p_event_id => 9181316394812294 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_JAVASCRIPT_CODE'
 ,p_attribute_01 => 'if(parent.window) {'||unistr('\000a')||
'    parent.window.location.href = $v(''P550_UMLEITUNG_URL'');'||unistr('\000a')||
'}'
 ,p_stop_execution_on_error => 'Y'
 );
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||unistr('\000a')||
''||unistr('\000a')||
'  :P550_REQUEST := :REQUEST;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 9178732518812291 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 550,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set download request',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'  c_PROD constant varchar2(2000) := ''app:'' || :APP_ID || '' page: '' ||:APP_PAGE_ID || '' Process: Entferne Job'';'||unistr('\000a')||
'  -- Globale Variablen'||unistr('\000a')||
'  v_PROT_ID number;'||unistr('\000a')||
'  v_ERROR varchar2(32767);'||unistr('\000a')||
'  v_ERRNR number;'||unistr('\000a')||
''||unistr('\000a')||
'  c_PACKAGE constant varchar2(100) := ''UTIL_DATEIEN'';'||unistr('\000a')||
''||unistr('\000a')||
'  e_ERROR EXCEPTION;'||unistr('\000a')||
'  c_ERRNR constant number := -20100;'||unistr('\000a')||
''||unistr('\000a')||
'  PRAGMA EXCEPTION_INIT(e_ERROR,-20100);'||unistr('\000a')||
''||unistr('\000a')||
'  -- Exception, die bewirkt das durc';

p:=p||'hgereichte Exceptions einfach weitergegeben werden.'||unistr('\000a')||
'  e_ERROR_D EXCEPTION;'||unistr('\000a')||
'  c_ERRNR_D constant number := -20101;'||unistr('\000a')||
'  PRAGMA EXCEPTION_INIT(e_ERROR_D,-20101);'||unistr('\000a')||
''||unistr('\000a')||
'  v_status number;'||unistr('\000a')||
'  v_job_id number;'||unistr('\000a')||
'  '||unistr('\000a')||
''||unistr('\000a')||
'begin'||unistr('\000a')||
''||unistr('\000a')||
'   begin '||unistr('\000a')||
'      v_job_id := to_number(substr(:REQUEST,length(''DEL_JOB'') + 1));'||unistr('\000a')||
'   exception'||unistr('\000a')||
'      when others then'||unistr('\000a')||
'        v_error := ''Die Job ID konnte nicht aus der Anfrage '' ||:REQUEST '||unistr('\000a')||
'    ';

p:=p||'       || '' ermittelt werden. SQLERRM:'' || sqlerrm;'||unistr('\000a')||
'        v_errnr := -10;'||unistr('\000a')||
'        raise e_error;'||unistr('\000a')||
'   end;'||unistr('\000a')||
''||unistr('\000a')||
'   FRGBG_JOBS.REMOVE_JOB(v_job_id);'||unistr('\000a')||
''||unistr('\000a')||
'exception'||unistr('\000a')||
'        when e_ERROR then'||unistr('\000a')||
'            MEL.P (c_PROD ||  ''('' || v_ERRNR || ''): '' || v_error, v_PROT_ID, ''ERROR'', dbms_utility.format_error_backtrace);'||unistr('\000a')||
'            raise_application_error(c_ERRNR_D, v_ERROR);'||unistr('\000a')||
'            raise;'||unistr('\000a')||
'        when e_ERRO';

p:=p||'R_D then'||unistr('\000a')||
'            raise; -- Einfach durchreichen'||unistr('\000a')||
'        when others then'||unistr('\000a')||
'            v_ERROR := ''Unbekannter Fehler in '' || c_PROD || '' SQLERRM:'' || SQLERRM;'||unistr('\000a')||
'            MEL.P (c_PROD || '': '' || v_error, v_PROT_ID, ''ERROR'', dbms_utility.format_error_backtrace);'||unistr('\000a')||
'            raise_application_error(c_ERRNR_D, v_ERROR);'||unistr('\000a')||
'            raise;'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 9178317434812289 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 550,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Job Abbrechen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_when=>':REQUEST is not null and SUBSTR(:REQUEST,1,length(''DEL_JOB'')) = ''DEL_JOB''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_only_for_changed_rows=> 'Y',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_blob blob;'||unistr('\000a')||
'   v_dateiname varchar2(100);'||unistr('\000a')||
'   v_size number;'||unistr('\000a')||
'   v_lastchange date;'||unistr('\000a')||
'   v_id number;'||unistr('\000a')||
'   v_mimetype varchar2(100);'||unistr('\000a')||
''||unistr('\000a')||
'   v_PROT_ID number;'||unistr('\000a')||
'    v_ERROR varchar2(32767);'||unistr('\000a')||
'    v_ERRNR number;'||unistr('\000a')||
''||unistr('\000a')||
'    c_PROD constant varchar2(100) := ''APP 102, Page 550 Process: Download Datei'';'||unistr('\000a')||
''||unistr('\000a')||
'    e_ERROR EXCEPTION;'||unistr('\000a')||
'    c_ERRNR constant number := -20100;'||unistr('\000a')||
''||unistr('\000a')||
'    PRAGMA EXCEPTION_INIT(e_ERROR,-20100);'||unistr('\000a')||
'';

p:=p||''||unistr('\000a')||
'    -- Exception, die bewirkt das durchgereichte Exceptions einfach weitergegeben werden.'||unistr('\000a')||
'    e_ERROR_D EXCEPTION;'||unistr('\000a')||
'    c_ERRNR_D constant number := -20101;'||unistr('\000a')||
'    PRAGMA EXCEPTION_INIT(e_ERROR_D,-20101);'||unistr('\000a')||
''||unistr('\000a')||
'begin'||unistr('\000a')||
''||unistr('\000a')||
'   begin'||unistr('\000a')||
'   -- Hole Blob content'||unistr('\000a')||
'   select DOWNLOAD_DATEI,'||unistr('\000a')||
'          dbms_lob.getlength(DOWNLOAD_DATEI),'||unistr('\000a')||
'          mutdat,'||unistr('\000a')||
'          id,'||unistr('\000a')||
'          DOWNLOAD_DATEINAME'||unistr('\000a')||
'   into v_blob,'||unistr('\000a')||
'        ';

p:=p||'v_size,'||unistr('\000a')||
'        v_lastchange,'||unistr('\000a')||
'        v_id,'||unistr('\000a')||
'        v_dateiname'||unistr('\000a')||
'   from APP_JOBS'||unistr('\000a')||
'   where id = to_number(substr(:P550_REQUEST,length(''DOWNLOAD_FILE'') + 1)) -- Die ID steht direkt nach dem Request namen'||unistr('\000a')||
'         and app_id = :APP_ID'||unistr('\000a')||
'         and USER_ACCOUNT = :APP_USER'||unistr('\000a')||
'         and satz_kennzeichen is null;'||unistr('\000a')||
'   exception'||unistr('\000a')||
'    when no_data_found then '||unistr('\000a')||
'      v_blob := null;'||unistr('\000a')||
'   end;'||unistr('\000a')||
''||unistr('\000a')||
'   if(v_blob is no';

p:=p||'t null) then'||unistr('\000a')||
'    v_mimetype := ''application/octet'';'||unistr('\000a')||
'    '||unistr('\000a')||
'    -- Im HTTP-Header wird der Dateityp gesetzt. Damit erkennt der Browser'||unistr('\000a')||
'    -- welche Applikation (bspw. MS Word) zu starten ist'||unistr('\000a')||
'    owa_util.mime_header(NVL(v_mimetype,''application/octet''),false);'||unistr('\000a')||
''||unistr('\000a')||
'    -- Die Dateigröße wird dem Browser ebenfalls mitgeteilt'||unistr('\000a')||
'    htp.p(''Content-length:''|| v_size);'||unistr('\000a')||
''||unistr('\000a')||
'    -- Das Datum (LETZTE_AENDERUNG) wird ';

p:=p||'ebenfalls als HTTP-Header gesetzt'||unistr('\000a')||
'    htp.p(''Date:''||to_char(v_lastchange,''Dy, DD Mon RRRR hh24:mi:ss'')||'' CET'');'||unistr('\000a')||
''||unistr('\000a')||
'    -- Der Parameter p_display steuert, ob die Datei direkt dargestellt oder'||unistr('\000a')||
'    -- ob dem Anwender ein Download-Dialog angeboten werden soll. Wie man sehen'||unistr('\000a')||
'    -- kann, richtet sich der Browser nach den Feldern im HTTP Header.'||unistr('\000a')||
'    htp.p(''Content-Disposition: attachment; filename="''||';

p:=p||'v_dateiname || ''"'');'||unistr('\000a')||
''||unistr('\000a')||
'    -- Der Browser soll die Datei unter keinen Umständen aus dem Cache holen.'||unistr('\000a')||
'    htp.p(''Cache-Control: must-revalidate, max-age=0'');'||unistr('\000a')||
'    htp.p(''Expires: Thu, 01 Jan 1970 01:00:00 CET'');'||unistr('\000a')||
''||unistr('\000a')||
'    -- Die Datei bekommt eine ID - damit kann der Browser sie eindeutig erkennen.'||unistr('\000a')||
'    htp.p(''Etag: TAB_DATEIEN...''||v_id||''...''||to_char(v_lastchange, ''JHH24MISS''));'||unistr('\000a')||
''||unistr('\000a')||
'    -- Alle HTTP-Header';

p:=p||'-Felder sind gesetzt'||unistr('\000a')||
'    owa_util.http_header_close;'||unistr('\000a')||
''||unistr('\000a')||
'    -- Dieser kurze Aufruf führt den eigentlichen Datei-Download durch.'||unistr('\000a')||
'    wpg_docload.download_file(v_blob);'||unistr('\000a')||
''||unistr('\000a')||
'    :P550_REQUEST := null;'||unistr('\000a')||
'    -- Damit Apex nicht die Oberfläche darstellt'||unistr('\000a')||
'    apex_application.g_unrecoverable_error := true;'||unistr('\000a')||
''||unistr('\000a')||
'  end if;'||unistr('\000a')||
'exception'||unistr('\000a')||
'        when e_ERROR then'||unistr('\000a')||
'            MEL.P (c_PROD ||  ''('' || v_ERRNR || ''): '' || v_';

p:=p||'error, v_PROT_ID, ''ERROR'', dbms_utility.format_error_backtrace);'||unistr('\000a')||
'            raise_application_error(c_ERRNR_D, v_ERROR);'||unistr('\000a')||
'            raise;'||unistr('\000a')||
'        when e_ERROR_D then'||unistr('\000a')||
'            raise; -- Einfach durchreichen'||unistr('\000a')||
'        when others then'||unistr('\000a')||
'            v_ERROR := ''Unbekannter Fehler in '' || c_PROD || '' SQLERRM:'' || SQLERRM;'||unistr('\000a')||
'            MEL.P (c_PROD || '': '' || v_error, v_PROT_ID, ''ERROR'', dbms_utility';

p:=p||'.format_error_backtrace);'||unistr('\000a')||
'            raise_application_error(c_ERRNR_D, v_ERROR);'||unistr('\000a')||
'            raise;'||unistr('\000a')||
''||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 9178512279812290 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 550,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Download Datei',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'upper(substr(:P550_REQUEST,1,length(''DOWNLOAD_FILE''))) = ''DOWNLOAD_FILE''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_only_for_changed_rows=> 'Y',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 550
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00997
prompt  ...PAGE 997: Datenschutz
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 997
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Datenschutz'
 ,p_step_title => 'Datenschutz'
 ,p_step_sub_title => 'Datenschutz'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20140210100548'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||unistr('\000a')||
'   uebersetzung.holen_uebersetzung_clob(9451,:fas_sprache_id) text'||unistr('\000a')||
'FROM dual'||unistr('\000a')||
'';

wwv_flow_api.create_report_region (
  p_id=> 7495812183405978 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 997,
  p_name=> '&P997_REGION_TITEL_DATENSCHUTZ.',
  p_region_name=>'',
  p_template=> 3819021965727364+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="max-width: 900px;">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 11,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(519,:fas_sprache_id))',
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'no data found',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'apex/builder/dup.gif',
  p_query_asc_image_attr=> 'width="16" height="16" alt="" ',
  p_query_desc_image=> 'apex/builder/ddown.gif',
  p_query_desc_image_attr=> 'width="16" height="16" alt="" ',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7496018080405980 + wwv_flow_api.g_id_offset,
  p_region_id=> 7495812183405978 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_css_style=>'font-weight:normal;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 7496116339405981 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 997,
  p_button_sequence=> 10,
  p_button_plug_id => 7495812183405978+wwv_flow_api.g_id_offset,
  p_button_name    => 'SCHLIESSEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P997_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>7497428817405989 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 997,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P997_ZURUECK_ZUR_SEITE.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>7496116339405981+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7496328743405982 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 997,
  p_name=>'P997_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 7495812183405978+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'frgbg_s.holen_uebersetzung(9400,:fas_sprache_id)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_RICH_TEXT_EDITOR',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 100,
  p_cMaxlength=> 2000,
  p_cHeight=> 20,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when_type=>'NEVER',
  p_read_only_when_type=>'ALWAYS',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'CKEDITOR3',
  p_attribute_03 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7496510421405986 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 997,
  p_name=>'P997_ZURUECK_ZUR_SEITE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 7495812183405978+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Zurueck Zur Seite',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7496722630405986 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 997,
  p_name=>'P997_BL_ABBRECHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 7495812183405978+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Abbrechen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7496927216405987 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 997,
  p_name=>'P997_REGION_TITEL_DATENSCHUTZ',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 7495812183405978+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p997_bl_abbrechen := frgbg_s.holen_uebersetzung(161,v_sprache_id);'||unistr('\000a')||
'   :P997_REGION_TITEL_DATENSCHUTZ := '||unistr('\000a')||
'                      frgbg_s.holen_uebersetzung(9449,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 7497130064405987 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 997,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 997
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00998
prompt  ...PAGE 998: Versionsinformation
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 998
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Versionsinformation'
 ,p_step_title => 'Versionsinformation'
 ,p_step_sub_title => 'Versionsinformation'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20140210100645'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||unistr('\000a')||
'to_char(version,''FM999.99'')||'' ''||CASE WHEN status = 0 THEN '||unistr('\000a')||
'''<span style="text-decoration:underline; font-weight:bold;">''|| frgbg_s.holen_uebersetzung(8029,:fas_sprache_id) ||''</span> '' else frgbg_s.holen_uebersetzung(8030,:fas_sprache_id) ||'' '' END ||'||unistr('\000a')||
'to_char(datum,''DD.MM.YYYY'') info,'||unistr('\000a')||
'--replace(frgbg_s.holen_uebersetzung(text_id,:fas_sprache_id),chr(10),''<br/>'') text,'||unistr('\000a')||
'uebersetzung.holen_';

s:=s||'uebersetzung_clob(text_id,:fas_sprache_id) text,'||unistr('\000a')||
'id,version,text_id, status,datum,bemerkung'||unistr('\000a')||
'FROM FAS_VERSIONEN'||unistr('\000a')||
'where satz_kennzeichen is null'||unistr('\000a')||
'order by version desc';

wwv_flow_api.create_report_region (
  p_id=> 6258918529839303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 998,
  p_name=> '&P998_REGION_TITEL_VERSION.',
  p_region_name=>'',
  p_template=> 3819021965727364+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="max-width: 900px;">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 3,
  p_query_headings=> 'RETURN(frgbg_s.holen_uebersetzung(519,:fas_sprache_id))',
  p_query_headings_type=> 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'no data found',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'apex/builder/dup.gif',
  p_query_asc_image_attr=> 'width="16" height="16" alt="" ',
  p_query_desc_image=> 'apex/builder/ddown.gif',
  p_query_desc_image_attr=> 'width="16" height="16" alt="" ',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6259824832839304 + wwv_flow_api.g_id_offset,
  p_region_id=> 6258918529839303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'INFO',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6259430189839304 + wwv_flow_api.g_id_offset,
  p_region_id=> 6258918529839303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TEXT',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_css_style=>'font-weight:normal;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6259130939839303 + wwv_flow_api.g_id_offset,
  p_region_id=> 6258918529839303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6259206704839304 + wwv_flow_api.g_id_offset,
  p_region_id=> 6258918529839303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'VERSION',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6259327389839304 + wwv_flow_api.g_id_offset,
  p_region_id=> 6258918529839303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'TEXT_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6259520874839304 + wwv_flow_api.g_id_offset,
  p_region_id=> 6258918529839303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6259609974839304 + wwv_flow_api.g_id_offset,
  p_region_id=> 6258918529839303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'DATUM',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6259710354839304 + wwv_flow_api.g_id_offset,
  p_region_id=> 6258918529839303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'BEMERKUNG',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 6259918991839304 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 998,
  p_button_sequence=> 10,
  p_button_plug_id => 6258918529839303+wwv_flow_api.g_id_offset,
  p_button_name    => 'SCHLIESSEN',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(3817106493727350+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P998_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>6261425589839307 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 998,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P998_ZURUECK_ZUR_SEITE.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>6259918991839304+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6260117653839305 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 998,
  p_name=>'P998_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 6258918529839303+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'frgbg_s.holen_uebersetzung(1000,:fas_sprache_id)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 100,
  p_cMaxlength=> 2000,
  p_cHeight=> 20,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when_type=>'NEVER',
  p_read_only_when_type=>'ALWAYS',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6260314898839305 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 998,
  p_name=>'P998_ZURUECK_ZUR_SEITE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 6258918529839303+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Zurueck Zur Seite',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6260530110839305 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 998,
  p_name=>'P998_BL_ABBRECHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 6258918529839303+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Abbrechen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822128434727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6260710960839305 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 998,
  p_name=>'P998_REGION_TITEL_VERSION',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 6258918529839303+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6260926792839306 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 998,
  p_name=>'P998_VERSION_LABEL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 6258918529839303+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 4000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id NUMBER := frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p998_bl_abbrechen := frgbg_s.holen_uebersetzung(161,v_sprache_id);'||unistr('\000a')||
'   :P998_REGION_TITEL_VERSION := '||unistr('\000a')||
'                      frgbg_s.holen_uebersetzung(8028,v_sprache_id);'||unistr('\000a')||
'   :P998_version_label := frgbg_s.holen_uebersetzung(519,v_sprache_id);'||unistr('\000a')||
'   --:P998_NV_PATIENTENLISTE := frgbg_s.holen_uebersetzung(3833,v_sprache_id);'||unistr('\000a')||
'';

p:=p||'END;';

wwv_flow_api.create_page_process(
  p_id     => 6261118957839306 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 998,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 998
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00999
prompt  ...PAGE 999: Logout
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 999
 ,p_user_interface_id => 65019089194770 + wwv_flow_api.g_id_offset
 ,p_name => 'Logout'
 ,p_step_title => 'Logout'
 ,p_step_sub_title => 'Logout'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'FRGBG'
 ,p_last_upd_yyyymmddhh24miss => '20100123171432'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4005219941175384 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 999,
  p_plug_name=> 'Logout',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 3819021965727364+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4005402108175392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 999,
  p_name=>'P999_LOGIN_PAGE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 4005219941175384+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Login Page',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 3822217926727382+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   apex_application.g_unrecoverable_error := true; '||unistr('\000a')||
'   wwv_flow_custom_auth_std.logout('||unistr('\000a')||
'            p_this_flow=>:APP_ID,'||unistr('\000a')||
'--            p_next_flow_page_sess=>''&APP_ID.:&P999_LOGIN_PAGE.:&SESSION.:LOGOUT'');'||unistr('\000a')||
'              p_next_flow_page_sess=>''&APP_ID.:&P999_LOGIN_PAGE.:::::FAS_SCHEMA_ID:&FAS_SCHEMA_ID.'');'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4005619239175393 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 999,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'logout',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 999
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
 
begin
 
wwv_flow_api.create_menu (
  p_id=> 3824912549727453 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> ' Navigationspfad');
 
null;
 
end;
/

prompt  ...page templates for application: 104
--
--application/shared_components/user_interface/templates/page/login
prompt  ......Page template 3816220719727340
 
begin
 
wwv_flow_api.create_template (
  p_id => 3816220719727340 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_theme_id => 1
 ,p_name => 'Login'
 ,p_is_popup => false
 ,p_header_template => '<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||unistr('\000a')||
'<head>'||unistr('\000a')||
'<title>#TITLE#</title>'||unistr('\000a')||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./theme_3_1.css" type="text/css" />'||unistr('\000a')||
'#APEX_CSS#'||unistr('\000a')||
'#TEMPLATE_CSS#'||unistr('\000a')||
'#THEME_CSS#'||unistr('\000a')||
'#PAGE_CSS#'||unistr('\000a')||
'#APEX_JAVASCRIPT#'||unistr('\000a')||
'#TEMPLATE_JAVASCRIPT#'||unistr('\000a')||
'#APPLICATION_JAVASCRIPT#'||unistr('\000a')||
'#PAGE_JAVASCRIPT#'||unistr('\000a')||
'#HEAD#'||unistr('\000a')||
'</head>'||unistr('\000a')||
'<body #ONLOAD#>#FORM_OPEN#'
 ,p_box => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td valign="top" class="t1Logo">#LOGO#</td>'||unistr('\000a')||
'    <td align="right" valign="top"><br /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./top_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1topbarMiddle"><br '||
'/></td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./top_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td width="100%" valign="top" class="t1PageBody"><div c'||
'lass="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
''
 ,p_footer_template => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./bot_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><br /></td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./bot_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<br />'||unistr('\000a')||
'#FORM_CLOSE# '||unistr('\000a')||
'#DEVELOPER_TOOLBAR#'||unistr('\000a')||
'#GENERATED_CSS#'||unistr('\000a')||
'#GENERATED_JAVASCRIPT#'||
''||unistr('\000a')||
'</body>'||unistr('\000a')||
'</html>'
 ,p_success_message => '<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
 ,p_notification_message => '<div class="t1notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
 ,p_region_table_cattributes => ' summary="" cellpadding="0" border="0" cellspacing="0"'
 ,p_theme_class_id => 6
 ,p_grid_type => 'TABLE'
 ,p_has_edit_links => true
 ,p_translate_this_template => 'N'
 ,p_template_comment => '18'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs
prompt  ......Page template 3816318532727346
 
begin
 
wwv_flow_api.create_template (
  p_id => 3816318532727346 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_theme_id => 1
 ,p_name => 'No Tabs'
 ,p_is_popup => false
 ,p_header_template => '<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||unistr('\000a')||
'<head>'||unistr('\000a')||
'<title>#TITLE#</title>'||unistr('\000a')||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_3_1.css" type="text/css" />'||unistr('\000a')||
'#APEX_CSS#'||unistr('\000a')||
'#TEMPLATE_CSS#'||unistr('\000a')||
'#THEME_CSS#'||unistr('\000a')||
'#PAGE_CSS#'||unistr('\000a')||
'#APEX_JAVASCRIPT#'||unistr('\000a')||
'#TEMPLATE_JAVASCRIPT#'||unistr('\000a')||
'#APPLICATION_JAVASCRIPT#'||unistr('\000a')||
'#PAGE_JAVASCRIPT#'||unistr('\000a')||
'#HEAD#'||unistr('\000a')||
'</head>'||unistr('\000a')||
'<body #ONLOAD#>#FORM_OPEN#'
 ,p_box => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||unistr('\000a')||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||unistr('\000a')||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><img src='||
'"#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1topbarMiddle"><br />#REGION_POSITION_01#</td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadd'||
'ing="0" width="100%" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||unistr('\000a')||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
''
 ,p_footer_template => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/th'||
'eme_1/bot_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<br />'||unistr('\000a')||
'#REGION_POSITION_05#'||unistr('\000a')||
'#FORM_CLOSE# '||unistr('\000a')||
'#DEVELOPER_TOOLBAR#'||unistr('\000a')||
'#GENERATED_CSS#'||unistr('\000a')||
'#GENERATED_JAVASCRIPT#'||unistr('\000a')||
'</body>'||unistr('\000a')||
'</html>'
 ,p_success_message => '<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
 ,p_notification_message => '<div class="t1Notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
 ,p_navigation_bar => '<div class="t1NavigationBar">#BAR_BODY#</div>'
 ,p_navbar_entry => '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
 ,p_region_table_cattributes => ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
 ,p_sidebar_def_reg_pos => 'REGION_POSITION_02'
 ,p_breadcrumb_def_reg_pos => 'REGION_POSITION_01'
 ,p_theme_class_id => 3
 ,p_grid_type => 'TABLE'
 ,p_has_edit_links => true
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_with_side_bar
prompt  ......Page template 3816409184727346
 
begin
 
wwv_flow_api.create_template (
  p_id => 3816409184727346 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_theme_id => 1
 ,p_name => 'No Tabs with Side Bar'
 ,p_is_popup => false
 ,p_header_template => '<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||unistr('\000a')||
'<head>'||unistr('\000a')||
'<title>#TITLE#</title>'||unistr('\000a')||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_3_1.css" type="text/css" />'||unistr('\000a')||
'#APEX_CSS#'||unistr('\000a')||
'#TEMPLATE_CSS#'||unistr('\000a')||
'#THEME_CSS#'||unistr('\000a')||
'#PAGE_CSS#'||unistr('\000a')||
'#APEX_JAVASCRIPT#'||unistr('\000a')||
'#TEMPLATE_JAVASCRIPT#'||unistr('\000a')||
'#APPLICATION_JAVASCRIPT#'||unistr('\000a')||
'#PAGE_JAVASCRIPT#'||unistr('\000a')||
'#HEAD#'||unistr('\000a')||
'</head>'||unistr('\000a')||
'<body #ONLOAD#>#FORM_OPEN#'
 ,p_box => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||unistr('\000a')||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||unistr('\000a')||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    '||
'<td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||unistr('\000a')||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_1.png" alt="" /></td>'||unistr('\000a')||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||unistr('\000a')||
'    <td class'||
'="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||unistr('\000a')||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REG'||
'ION_POSITION_02#</td>'||unistr('\000a')||
'    <td><br /></td>'||unistr('\000a')||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||unistr('\000a')||
'<td valign="top">#REGION_POSITION_03'||
'#<br /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'
 ,p_footer_template => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/th'||
'eme_1/bot_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<br />'||unistr('\000a')||
'#REGION_POSITION_05#'||unistr('\000a')||
'#FORM_CLOSE# '||unistr('\000a')||
'#DEVELOPER_TOOLBAR#'||unistr('\000a')||
'#GENERATED_CSS#'||unistr('\000a')||
'#GENERATED_JAVASCRIPT#'||unistr('\000a')||
'</body>'||unistr('\000a')||
'</html>'
 ,p_success_message => '<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
 ,p_notification_message => '<div class="t1notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
 ,p_navigation_bar => '<div class="t1NavigationBar">#BAR_BODY#</div>'
 ,p_navbar_entry => '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
 ,p_region_table_cattributes => 'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
 ,p_sidebar_def_reg_pos => 'REGION_POSITION_02'
 ,p_breadcrumb_def_reg_pos => 'REGION_POSITION_01'
 ,p_theme_class_id => 17
 ,p_grid_type => 'TABLE'
 ,p_has_edit_links => true
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs
prompt  ......Page template 3816501748727348
 
begin
 
wwv_flow_api.create_template (
  p_id => 3816501748727348 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_theme_id => 1
 ,p_name => 'One Level Tabs'
 ,p_is_popup => false
 ,p_header_template => '<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||unistr('\000a')||
'<head>'||unistr('\000a')||
'<title>#TITLE#</title>'||unistr('\000a')||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./theme_3_1.css" type="text/css" />'||unistr('\000a')||
'#APEX_CSS#'||unistr('\000a')||
'#TEMPLATE_CSS#'||unistr('\000a')||
'#THEME_CSS#'||unistr('\000a')||
'#PAGE_CSS#'||unistr('\000a')||
'#APEX_JAVASCRIPT#'||unistr('\000a')||
'#TEMPLATE_JAVASCRIPT#'||unistr('\000a')||
'#APPLICATION_JAVASCRIPT#'||unistr('\000a')||
'#PAGE_JAVASCRIPT#'||unistr('\000a')||
'#HEAD#'||unistr('\000a')||
'</head>'||unistr('\000a')||
'<body #ONLOAD#>#FORM_OPEN#'
 ,p_box => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||unistr('\000a')||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||unistr('\000a')||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    '||
'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./top_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td h'||
'eight="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>'||unistr('\000a')||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./top_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td><br /></td>'||unistr('\000a')||
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td width="100%" valign="top" c'||
'lass="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||unistr('\000a')||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_footer_template => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./bot_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#'||
'themes/&FAS_THEME_NAME./bot_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<br />'||unistr('\000a')||
'#REGION_POSITION_05#'||unistr('\000a')||
'#FORM_CLOSE# '||unistr('\000a')||
'#DEVELOPER_TOOLBAR#'||unistr('\000a')||
'#GENERATED_CSS#'||unistr('\000a')||
'#GENERATED_JAVASCRIPT#'||unistr('\000a')||
'</body>'||unistr('\000a')||
'</html>'
 ,p_success_message => '<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
 ,p_current_tab => '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||unistr('\000a')||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||unistr('\000a')||
''||unistr('\000a')||
''
 ,p_non_current_tab => '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||unistr('\000a')||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||unistr('\000a')||
''
 ,p_notification_message => '<div class="t1notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
 ,p_navigation_bar => '<div class="t1NavigationBar">#BAR_BODY#</div>'
 ,p_navbar_entry => '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
 ,p_region_table_cattributes => ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
 ,p_breadcrumb_def_reg_pos => 'REGION_POSITION_01'
 ,p_theme_class_id => 1
 ,p_grid_type => 'TABLE'
 ,p_has_edit_links => true
 ,p_translate_this_template => 'N'
 ,p_template_comment => '12'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_with_side_bar
prompt  ......Page template 3816624433727348
 
begin
 
wwv_flow_api.create_template (
  p_id => 3816624433727348 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_theme_id => 1
 ,p_name => 'One Level Tabs with Side Bar'
 ,p_is_popup => false
 ,p_header_template => '<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||unistr('\000a')||
'<head>'||unistr('\000a')||
'<title>#TITLE#</title>'||unistr('\000a')||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_3_1.css" type="text/css" />'||unistr('\000a')||
'#APEX_CSS#'||unistr('\000a')||
'#TEMPLATE_CSS#'||unistr('\000a')||
'#THEME_CSS#'||unistr('\000a')||
'#PAGE_CSS#'||unistr('\000a')||
'#APEX_JAVASCRIPT#'||unistr('\000a')||
'#TEMPLATE_JAVASCRIPT#'||unistr('\000a')||
'#APPLICATION_JAVASCRIPT#'||unistr('\000a')||
'#PAGE_JAVASCRIPT#'||unistr('\000a')||
'#HEAD#'||unistr('\000a')||
'</head>'||unistr('\000a')||
'<body #ONLOAD#>#FORM_OPEN#'
 ,p_box => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||unistr('\000a')||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||unistr('\000a')||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    '||
'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||unistr('\000a')||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/t'||
'heme_1/top_barleft2_1.png" alt="" /></td>'||unistr('\000a')||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table'||
'></td>'||unistr('\000a')||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||unistr('\000a')||
'    <td><br /></td>'||unistr('\000a')||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td width="100%" valign="t'||
'op" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||unistr('\000a')||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'
 ,p_footer_template => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/th'||
'eme_1/bot_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<br />'||unistr('\000a')||
'#REGION_POSITION_05#'||unistr('\000a')||
'#FORM_CLOSE# '||unistr('\000a')||
'#DEVELOPER_TOOLBAR#'||unistr('\000a')||
'#GENERATED_CSS#'||unistr('\000a')||
'#GENERATED_JAVASCRIPT#'||unistr('\000a')||
'</body>'||unistr('\000a')||
'</html>'
 ,p_success_message => '<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
 ,p_current_tab => '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||unistr('\000a')||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||unistr('\000a')||
''
 ,p_non_current_tab => '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||unistr('\000a')||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||unistr('\000a')||
''
 ,p_notification_message => '<div class="t2notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
 ,p_navigation_bar => '<div class="t1NavigationBar">#BAR_BODY#</div>'
 ,p_navbar_entry => '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
 ,p_region_table_cattributes => ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
 ,p_sidebar_def_reg_pos => 'REGION_POSITION_02'
 ,p_breadcrumb_def_reg_pos => 'REGION_POSITION_01'
 ,p_theme_class_id => 16
 ,p_grid_type => 'TABLE'
 ,p_has_edit_links => true
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/page/popup
prompt  ......Page template 3816709855727350
 
begin
 
wwv_flow_api.create_template (
  p_id => 3816709855727350 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_theme_id => 1
 ,p_name => 'Popup'
 ,p_is_popup => false
 ,p_header_template => '<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||unistr('\000a')||
'<head>'||unistr('\000a')||
'<title>#TITLE#</title>'||unistr('\000a')||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./theme_3_1.css" type="text/css" />'||unistr('\000a')||
'#APEX_CSS#'||unistr('\000a')||
'#TEMPLATE_CSS#'||unistr('\000a')||
'#THEME_CSS#'||unistr('\000a')||
'#PAGE_CSS#'||unistr('\000a')||
'#APEX_JAVASCRIPT#'||unistr('\000a')||
'#TEMPLATE_JAVASCRIPT#'||unistr('\000a')||
'#APPLICATION_JAVASCRIPT#'||unistr('\000a')||
'#PAGE_JAVASCRIPT#'||unistr('\000a')||
'#HEAD#'||unistr('\000a')||
'</head>'||unistr('\000a')||
'<body #ONLOAD#>#FORM_OPEN#'
 ,p_box => 
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td width="100%" valign="top"><div class="t1messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_01##REGION_POSITION_02##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||unistr('\000a')||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_footer_template => 
'#FORM_CLOSE##DEVELOPER_TOOLBAR#'||unistr('\000a')||
'#GENERATED_CSS#'||unistr('\000a')||
'#GENERATED_JAVASCRIPT#'||unistr('\000a')||
'</body>'||unistr('\000a')||
'</html>'
 ,p_success_message => '<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
 ,p_notification_message => '<div class="t1notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
 ,p_navigation_bar => '#BAR_BODY#'
 ,p_navbar_entry => '<a href="#LINK#">#TEXT#</a>'
 ,p_region_table_cattributes => ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
 ,p_theme_class_id => 4
 ,p_grid_type => 'TABLE'
 ,p_has_edit_links => true
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/page/printer_friendly
prompt  ......Page template 3816825562727350
 
begin
 
wwv_flow_api.create_template (
  p_id => 3816825562727350 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_theme_id => 1
 ,p_name => 'Printer Friendly'
 ,p_is_popup => false
 ,p_header_template => '<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||unistr('\000a')||
'<head>'||unistr('\000a')||
'<title>#TITLE#</title>'||unistr('\000a')||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./theme_3_1.css" type="text/css" />'||unistr('\000a')||
'#APEX_CSS#'||unistr('\000a')||
'#TEMPLATE_CSS#'||unistr('\000a')||
'#THEME_CSS#'||unistr('\000a')||
'#PAGE_CSS#'||unistr('\000a')||
'#APEX_JAVASCRIPT#'||unistr('\000a')||
'#TEMPLATE_JAVASCRIPT#'||unistr('\000a')||
'#APPLICATION_JAVASCRIPT#'||unistr('\000a')||
'#PAGE_JAVASCRIPT#'||unistr('\000a')||
'#HEAD#'||unistr('\000a')||
'</head>'||unistr('\000a')||
'<body #ONLOAD#>#FORM_OPEN#'
 ,p_box => 
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td width="100%" valign="top">'||unistr('\000a')||
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>'||unistr('\000a')||
'#BOX_BODY##REGION_POSITION_04#</td>'||unistr('\000a')||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_footer_template => 
'#FORM_CLOSE##DEVELOPER_TOOLBAR#'||unistr('\000a')||
'#GENERATED_CSS#'||unistr('\000a')||
'#GENERATED_JAVASCRIPT#'||unistr('\000a')||
'</body>'||unistr('\000a')||
'</html>'
 ,p_region_table_cattributes => ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
 ,p_theme_class_id => 5
 ,p_grid_type => 'TABLE'
 ,p_has_edit_links => true
 ,p_translate_this_template => 'N'
 ,p_template_comment => '3'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs
prompt  ......Page template 3816932491727350
 
begin
 
wwv_flow_api.create_template (
  p_id => 3816932491727350 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_theme_id => 1
 ,p_name => 'Two Level Tabs'
 ,p_is_popup => false
 ,p_header_template => '<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||unistr('\000a')||
'<head>'||unistr('\000a')||
'<title>#TITLE#</title>'||unistr('\000a')||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_3_1.css" type="text/css" />'||unistr('\000a')||
'#APEX_CSS#'||unistr('\000a')||
'#TEMPLATE_CSS#'||unistr('\000a')||
'#THEME_CSS#'||unistr('\000a')||
'#PAGE_CSS#'||unistr('\000a')||
'#APEX_JAVASCRIPT#'||unistr('\000a')||
'#TEMPLATE_JAVASCRIPT#'||unistr('\000a')||
'#APPLICATION_JAVASCRIPT#'||unistr('\000a')||
'#PAGE_JAVASCRIPT#'||unistr('\000a')||
'#HEAD#'||unistr('\000a')||
'</head>'||unistr('\000a')||
'<body #ONLOAD#>#FORM_OPEN#'
 ,p_box => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||unistr('\000a')||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||unistr('\000a')||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    '||
'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td align="right" class="t1topbarLeft"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left2.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1topbarMiddle" valign="top"><table border="0" cellpadding="0" cellspacing="0" su'||
'mmary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td height="20">#REGION_POSITION_01#</td></tr></table></td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><br /></td>'||unistr('\000a')||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td width="100%" valign'||
'="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||unistr('\000a')||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'
 ,p_footer_template => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/th'||
'eme_1/bot_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<br />'||unistr('\000a')||
'#REGION_POSITION_05#'||unistr('\000a')||
'#FORM_CLOSE# '||unistr('\000a')||
'#DEVELOPER_TOOLBAR#'||unistr('\000a')||
'#GENERATED_CSS#'||unistr('\000a')||
'#GENERATED_JAVASCRIPT#'||unistr('\000a')||
'</body>'||unistr('\000a')||
'</html>'
 ,p_success_message => '<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
 ,p_current_tab => '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#'
 ,p_non_current_tab => '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#'
 ,p_top_current_tab => '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||unistr('\000a')||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'
 ,p_top_non_curr_tab => '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||unistr('\000a')||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'
 ,p_notification_message => '<div class="t1notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
 ,p_navigation_bar => '<div class="t1NavigationBar">#BAR_BODY#</div>'
 ,p_navbar_entry => '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
 ,p_region_table_cattributes => ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
 ,p_breadcrumb_def_reg_pos => 'REGION_POSITION_01'
 ,p_theme_class_id => 2
 ,p_grid_type => 'TABLE'
 ,p_has_edit_links => true
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_with_side_bar
prompt  ......Page template 3817023679727350
 
begin
 
wwv_flow_api.create_template (
  p_id => 3817023679727350 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_theme_id => 1
 ,p_name => 'Two Level Tabs with Side Bar'
 ,p_is_popup => false
 ,p_header_template => '<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||unistr('\000a')||
'<head>'||unistr('\000a')||
'<title>#TITLE#</title>'||unistr('\000a')||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_3_1.css" type="text/css" />'||unistr('\000a')||
'#APEX_CSS#'||unistr('\000a')||
'#TEMPLATE_CSS#'||unistr('\000a')||
'#THEME_CSS#'||unistr('\000a')||
'#PAGE_CSS#'||unistr('\000a')||
'#APEX_JAVASCRIPT#'||unistr('\000a')||
'#TEMPLATE_JAVASCRIPT#'||unistr('\000a')||
'#APPLICATION_JAVASCRIPT#'||unistr('\000a')||
'#PAGE_JAVASCRIPT#'||unistr('\000a')||
'#HEAD#'||unistr('\000a')||
'</head>'||unistr('\000a')||
'<body #ONLOAD#>#FORM_OPEN#'
 ,p_box => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||unistr('\000a')||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||unistr('\000a')||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    '||
'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/'||
'top_barleft2_1.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||unistr('\000a')||
'    <td v'||
'align="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||unistr('\000a')||
'    <td><br /></td>'||unistr('\000a')||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td width="100%" valign="top" class="t1Pag'||
'eBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||unistr('\000a')||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'
 ,p_footer_template => 
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'  <tr>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||unistr('\000a')||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||unistr('\000a')||
'    <td><img src="#IMAGE_PREFIX#themes/th'||
'eme_1/bot_bar_right.png" alt="" /></td>'||unistr('\000a')||
'  </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<br />'||unistr('\000a')||
'#REGION_POSITION_05#'||unistr('\000a')||
'#FORM_CLOSE# '||unistr('\000a')||
'#DEVELOPER_TOOLBAR#'||unistr('\000a')||
'#GENERATED_CSS#'||unistr('\000a')||
'#GENERATED_JAVASCRIPT#'||unistr('\000a')||
'</body>'||unistr('\000a')||
'</html>'
 ,p_success_message => '<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
 ,p_current_tab => '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#'
 ,p_non_current_tab => '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#'
 ,p_top_current_tab => '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||unistr('\000a')||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'
 ,p_top_non_curr_tab => '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||unistr('\000a')||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'
 ,p_notification_message => '<div class="t1notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
 ,p_navigation_bar => '<div class="t1NavigationBar">#BAR_BODY#</div>'
 ,p_navbar_entry => '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
 ,p_region_table_cattributes => ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
 ,p_sidebar_def_reg_pos => 'REGION_POSITION_02'
 ,p_breadcrumb_def_reg_pos => 'REGION_POSITION_01'
 ,p_theme_class_id => 18
 ,p_grid_type => 'TABLE'
 ,p_has_edit_links => true
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

prompt  ...button templates
--
--application/shared_components/user_interface/templates/button/button
prompt  ......Button Template 3817106493727350
 
begin
 
wwv_flow_api.create_button_templates (
  p_id => 3817106493727350 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_template_name => 'Button'
 ,p_template => 
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>'||unistr('\000a')||
'<td class="t1C"><a href="#LINK#">#LABEL#</a></td>'||unistr('\000a')||
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>'||unistr('\000a')||
'</tr'||
'>'||unistr('\000a')||
'</table>'
 ,p_translate_this_template => 'N'
 ,p_theme_class_id => 1
 ,p_theme_id => 1
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/button/button_alternative_1
prompt  ......Button Template 3817230961727354
 
begin
 
wwv_flow_api.create_button_templates (
  p_id => 3817230961727354 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_template_name => 'Button, Alternative 1'
 ,p_template => 
'<table class="t1ButtonAlternative1" cellspacing="0" cellpadding="0" border="0"  summary="">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_alt1_left.gif" alt="" width="11" height="20" /></a></td>'||unistr('\000a')||
'<td class="t1C"><a href="#LINK#">#LABEL#</a></td>'||unistr('\000a')||
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_alt1_right.gif" width="11" height="20"'||
' alt="" /></a></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_translate_this_template => 'N'
 ,p_theme_class_id => 4
 ,p_theme_id => 1
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/button/button_alternative_2
prompt  ......Button Template 3817323344727354
 
begin
 
wwv_flow_api.create_button_templates (
  p_id => 3817323344727354 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_template_name => 'Button, Alternative 2'
 ,p_template => 
'<table class="t1ButtonAlternative2" cellspacing="0" cellpadding="0" border="0"  summary="">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_alt2_left.gif" alt="" width="11" height="20" /></a></td>'||unistr('\000a')||
'<td class="t1C"><a href="#LINK#">#LABEL#</a></td>'||unistr('\000a')||
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_alt2_right.gif" width="11" height="20"'||
' alt="" /></a></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_translate_this_template => 'N'
 ,p_theme_class_id => 5
 ,p_template_comment => 'XP Square FFFFFF'
 ,p_theme_id => 1
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/button/button_alternative_3
prompt  ......Button Template 3817432397727354
 
begin
 
wwv_flow_api.create_button_templates (
  p_id => 3817432397727354 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_template_name => 'Button, Alternative 3'
 ,p_template => 
'<table class="t1ButtonAlternative3" cellspacing="0" cellpadding="0" border="0"  summary="">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_alt3_left.gif" alt="" width="6" height="25" /></a></td>'||unistr('\000a')||
'<td class="t1C"><a href="#LINK#">#LABEL#</a></td>'||unistr('\000a')||
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_alt3_right.gif" width="6" height="25" a'||
'lt="" /></a></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_translate_this_template => 'N'
 ,p_theme_class_id => 2
 ,p_template_comment => 'Standard Button'
 ,p_theme_id => 1
  );
null;
 
end;
/

---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/borderless_region
prompt  ......region template 3817524231727354
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3817524231727354 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BorderlessRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body" colspan="2">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Borderless Region'
 ,p_theme_id => 1
 ,p_theme_class_id => 7
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Use this region template when you want to contain content without a border.'||unistr('\000a')||
''||unistr('\000a')||
'TITLE=YES'||unistr('\000a')||
'BUTTONS=YES'||unistr('\000a')||
'100% WIDTH=NO'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/bracketed_region
prompt  ......region template 3817618639727359
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3817618639727359 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BracketedRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" wi'||
'dth="100%">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||unistr('\000a')||
'<td rowspan="3" class="t1Body">#BODY#</td>'||unistr('\000a')||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||unistr('\000a')||
'<td><img sr'||
'c="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||unistr('\000a')||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Bracketed Region'
 ,p_theme_id => 1
 ,p_theme_class_id => 18
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Use this region template when you want to contain content with a bracket UI.'||unistr('\000a')||
''||unistr('\000a')||
'TITLE=YES'||unistr('\000a')||
'BUTTONS=YES'||unistr('\000a')||
'100% WIDTH=NO'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/breadcrumb_region
prompt  ......region template 3817723870727359
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3817723870727359 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<div class="t1BreadcrumbRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
 ,p_page_plug_template_name => 'Breadcrumb Region'
 ,p_theme_id => 1
 ,p_theme_class_id => 6
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_with_title
prompt  ......region template 3817817838727360
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3817817838727360 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithTitle" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr><td class="t1RegionHeader">#TITLE#</td></tr>'||unistr('\000a')||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##COPY##EXPAND##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" styl'||
'e="display:block;" alt="" /></td></tr>'||unistr('\000a')||
'</table>#BODY#'||unistr('\000a')||
''
 ,p_page_plug_template_name => 'Button Region with Title'
 ,p_theme_id => 1
 ,p_theme_class_id => 4
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_without_title
prompt  ......region template 3817916039727360
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3817916039727360 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithoutTitle" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td></tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'#BODY#'
 ,p_page_plug_template_name => 'Button Region without Title'
 ,p_theme_id => 1
 ,p_theme_class_id => 17
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_list
prompt  ......region template 3818030883727360
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818030883727360 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr><t'||
'd valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/chart.gif" alt=""/></td>'||unistr('\000a')||
'<td>#BODY#</td></tr></table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Chart List'
 ,p_plug_table_bgcolor => '#ffffff'
 ,p_theme_id => 1
 ,p_theme_class_id => 29
 ,p_plug_heading_bgcolor => '#ffffff'
 ,p_plug_font_size => '-1'
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Red Theme'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_region
prompt  ......region template 3818119956727360
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818119956727360 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ChartRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<t'||
'd class="t1Body">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Chart Region'
 ,p_plug_table_bgcolor => '#ffffff'
 ,p_theme_id => 1
 ,p_theme_class_id => 30
 ,p_plug_heading_bgcolor => '#ffffff'
 ,p_plug_font_size => '-1'
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Red Theme'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/form_region
prompt  ......region template 3818225130727360
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818225130727360 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1FormRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="400" alt="" /><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVI'||
'OUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body">#BODY#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Form Region'
 ,p_plug_table_bgcolor => '#f7f7e7'
 ,p_theme_id => 1
 ,p_theme_class_id => 8
 ,p_plug_heading_bgcolor => '#f7f7e7'
 ,p_plug_font_size => '-1'
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Red Theme'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/hide_and_show_region
prompt  ......region template 3818321148727360
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818321148727360 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1HideandShowRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#<a style="margin-left:5px;" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#themes/theme_1/ro'||
'llup_plus_dgray.gif'',''#IMAGE_PREFIX#themes/theme_1/rollup_minus_dgray.gif'');" class="t1HideandShowRegionLink"><img src="#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif" '||unistr('\000a')||
'  id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a></td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body"><div class="t1H'||
'ide" id="region#REGION_SEQUENCE_ID#">#BODY#</div></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Hide and Show Region'
 ,p_theme_id => 1
 ,p_theme_class_id => 1
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Gray Head, white body'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region
prompt  ......region template 3818408918727362
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818408918727362 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<div class="t1NavigationRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
 ,p_page_plug_template_name => 'Navigation Region'
 ,p_theme_id => 1
 ,p_theme_class_id => 5
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region_alternative_1
prompt  ......region template 3818525952727362
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818525952727362 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1NavigationRegionAlternative1" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Navigation Region, Alternative 1'
 ,p_theme_id => 1
 ,p_theme_class_id => 16
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_buttons_and_titles
prompt  ......region template 3818608283727362
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818608283727362 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table summary="" cellpadding="0" cellspacing="0" border="0" class="t1RegionwithoutButtonsandTitles" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
''||unistr('\000a')||
''
 ,p_page_plug_template_name => 'Region without Buttons and Titles'
 ,p_theme_id => 1
 ,p_theme_class_id => 19
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_title
prompt  ......region template 3818724893727362
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818724893727362 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1RegionwithoutTitle" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Region without Title'
 ,p_theme_id => 1
 ,p_theme_class_id => 11
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/report_filter_single_row
prompt  ......region template 3818810253727362
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818810253727362 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table class="apex_finderbar" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tbody>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="apex_finderbar_left_top" valign="top"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="8" alt=""  class="spacer" alt="" /></td>'||unistr('\000a')||
'<td class="apex_finderbar_middle" rowspan="3" valign="middle"><img src="#IMAGE_PREFIX#htmldb/builder/builder_f'||
'ind.png" /></td>'||unistr('\000a')||
'<td class="apex_finderbar_middle" rowspan="3" valign="middle" style="">#BODY#</td>'||unistr('\000a')||
'<td class="apex_finderbar_left" rowspan="3" width="10"><br /></td>'||unistr('\000a')||
'<td class="apex_finderbar_buttons" rowspan="3" valign="middle" nowrap="nowrap"><span class="apex_close">#CLOSE#</span><span>#EDIT##CHANGE##DELETE##CREATE##CREATE2##COPY##PREVIOUS##NEXT##EXPAND##HELP#</span></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr><td class="'||
'apex_finderbar_left_middle"><br /></td></tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="apex_finderbar_left_bottom" valign="bottom"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="8"  class="spacer" alt="" /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</tbody>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Report Filter - Single Row'
 ,p_theme_id => 1
 ,p_theme_class_id => 31
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/report_list
prompt  ......region template 3818922248727364
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3818922248727364 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr>'||unistr('\000a')||
'<'||
'td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/report.gif" alt=""/></td>'||unistr('\000a')||
'<td>#BODY#</td></tr></table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Report List'
 ,p_plug_table_bgcolor => '#ffffff'
 ,p_theme_id => 1
 ,p_theme_class_id => 29
 ,p_plug_heading_bgcolor => '#ffffff'
 ,p_plug_font_size => '-1'
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Red Theme'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region
prompt  ......region template 3819021965727364
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3819021965727364 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body" colspan="2">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Reports Region'
 ,p_plug_table_bgcolor => '#ffffff'
 ,p_theme_id => 1
 ,p_theme_class_id => 9
 ,p_plug_heading_bgcolor => '#ffffff'
 ,p_plug_font_size => '-1'
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Red Theme'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_100_width
prompt  ......region template 3819132139727364
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3819132139727364 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion100Width" width="100%" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body" colspan="2">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Reports Region 100% Width'
 ,p_plug_table_bgcolor => '#ffffff'
 ,p_theme_id => 1
 ,p_theme_class_id => 13
 ,p_plug_heading_bgcolor => '#ffffff'
 ,p_plug_font_size => '-1'
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Red Theme'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_alternative_1
prompt  ......region template 3819214175727364
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3819214175727364 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegionAlternative1" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body" colspan="2">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Reports Region, Alternative 1'
 ,p_plug_table_bgcolor => '#ffffff'
 ,p_theme_id => 1
 ,p_theme_class_id => 10
 ,p_plug_heading_bgcolor => '#ffffff'
 ,p_plug_font_size => '-1'
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => 'Red Theme'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region
prompt  ......region template 3819319898727364
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3819319898727364 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegion" summary="" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# align="right">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_cur'||
've.gif" width="10" height="20" alt="" /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td colspan="3" class="t1Body">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table><br />'
 ,p_page_plug_template_name => 'Sidebar Region'
 ,p_plug_table_bgcolor => '#f7f7e7'
 ,p_theme_id => 1
 ,p_theme_class_id => 2
 ,p_plug_heading_bgcolor => '#f7f7e7'
 ,p_plug_font_size => '-1'
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
 ,p_template_comment => '<table border="0" cellpadding="0" cellspacing="0">'||unistr('\000a')||
'        <tr>'||unistr('\000a')||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tl_img.gif" border="0" width="4" height="18" alt="" /></td>'||unistr('\000a')||
'          <td bgcolor="#000000" height="1"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||unistr('\000a')||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tr_img.gif" border="0" width="4" height="18" alt="" /></td>'||unistr('\000a')||
'        </tr>'||unistr('\000a')||
'        <tr>'||unistr('\000a')||
'          <td bgcolor="#FF0000" height="16">'||unistr('\000a')||
'            <table border="0" cellpadding="0" cellspacing="0" width="100%">'||unistr('\000a')||
'              <tr>'||unistr('\000a')||
'                <td align=middle valign="top">'||unistr('\000a')||
'                  <div align="center">'||unistr('\000a')||
'                     <font color="#ffffff" face="Arial, Helvetica, sans-serif" size="1">'||unistr('\000a')||
'                      <b>#TITLE# </b></font></div>'||unistr('\000a')||
'                </td>'||unistr('\000a')||
'              </tr>'||unistr('\000a')||
'            </table>'||unistr('\000a')||
'          </td>'||unistr('\000a')||
'        </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<table border="0" cellpadding="0" cellspacing="0">'||unistr('\000a')||
'   <tr>'||unistr('\000a')||
'   <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||unistr('\000a')||
'   <td valign="top" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="146" height="1" border="0" alt="" /><br />'||unistr('\000a')||
'            <table border="0" cellpadding="1" cellspacing="0" width="146" summary="">'||unistr('\000a')||
'              <tr>'||unistr('\000a')||
'                <td colspan="2">'||unistr('\000a')||
'                  <table border="0" cellpadding="2" cellspacing="0" width="124" summary="">'||unistr('\000a')||
'                    <tr>'||unistr('\000a')||
'                      <td>&nbsp;</td>'||unistr('\000a')||
'                      <td valign="top" width="106">'||unistr('\000a')||
'                        <P><FONT face="arial, helvetica" size="1">'||unistr('\000a')||
'                            #BODY#'||unistr('\000a')||
'                           </font>'||unistr('\000a')||
'                        </P>'||unistr('\000a')||
'                      </td>'||unistr('\000a')||
'                    </tr>'||unistr('\000a')||
'                  </table>'||unistr('\000a')||
'            </table>'||unistr('\000a')||
'          </td>'||unistr('\000a')||
'          <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||unistr('\000a')||
'          <td bgcolor="#9a9c9a" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||unistr('\000a')||
'          <td bgcolor="#b3b4b3" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||unistr('\000a')||
'        </tr>'||unistr('\000a')||
'      </table>'||unistr('\000a')||
'      <table border="0" cellpadding="0" cellspacing="0">'||unistr('\000a')||
'        <tr>'||unistr('\000a')||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#bl_img.gif" border="0" width="4" height="6" alt="" /></td>'||unistr('\000a')||
'          <td bgcolor="#ffffff" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||unistr('\000a')||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#br_img.gif" border="0" width="4" height="6" alt="" /></td>'||unistr('\000a')||
'        </tr>'||unistr('\000a')||
'        <tr>'||unistr('\000a')||
'          <td bgcolor="#000000" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||unistr('\000a')||
'        </tr>'||unistr('\000a')||
'        <tr>'||unistr('\000a')||
'          <td bgcolor="#9a9c9a" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||unistr('\000a')||
'        </tr>'||unistr('\000a')||
'        <tr>'||unistr('\000a')||
'          <td bgcolor="#b3b4b3" width="1" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||unistr('\000a')||
'        </tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
''
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region_alternative_1
prompt  ......region template 3819402965727365
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3819402965727365 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegionAlternative1" summary="" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# align="right">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme'||
'_1/right_curve.gif" width="10" height="20" alt="" /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td colspan="3" class="t1Body">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table><br />'
 ,p_page_plug_template_name => 'Sidebar Region, Alternative 1'
 ,p_plug_table_bgcolor => '#f7f7e7'
 ,p_theme_id => 1
 ,p_theme_class_id => 3
 ,p_plug_heading_bgcolor => '#f7f7e7'
 ,p_plug_font_size => '-1'
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region
prompt  ......region template 3819521468727365
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3819521468727365 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body" colspan="2">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Wizard Region'
 ,p_theme_id => 1
 ,p_theme_class_id => 12
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region_with_icon
prompt  ......region template 3819627096727365
 
begin
 
wwv_flow_api.create_plug_template (
  p_id => 3819627096727365 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_layout => 'TABLE'
 ,p_template => 
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegionwithIcon" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1RegionHeader">#TITLE#</td>'||unistr('\000a')||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1Body" colspan="2"><table summary="" cellpadding="0" cellspacing="0" border="0">'||unistr('\000a')||
'<tr>'||
''||unistr('\000a')||
'<td valign="top"><img src="#IMAGE_PREFIX#alert_warning.gif" alt=""/></td>'||unistr('\000a')||
'<td width="100%" valign="top">#BODY#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'
 ,p_page_plug_template_name => 'Wizard Region with Icon'
 ,p_theme_id => 1
 ,p_theme_class_id => 20
 ,p_default_label_alignment => 'RIGHT'
 ,p_default_field_alignment => 'LEFT'
 ,p_translate_this_template => 'N'
  );
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/button_list
prompt  ......list template 3819725974727365
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left_hl.gif" alt="" /></td>'||unistr('\000a')||
'<td class="t1C"><a href="#LINK#" style="color:#FFFFFF;">#TEXT#</a></td>'||unistr('\000a')||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right_hl.gif" alt="" /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>';

t2:=t2||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left.gif" alt="" /></td>'||unistr('\000a')||
'<td class="t1NC"><a href="#LINK#">#TEXT#</a></td>'||unistr('\000a')||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right.gif" alt="" /></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3819725974727365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Button List',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_list_template_before_rows=>'<div class="t1ButtonList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/hierarchical_expanded
prompt  ......list template 3819825074727370
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>3819825074727370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Hierarchical Expanded',
  p_theme_id  => 1,
  p_theme_class_id => 23,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/hierarchical_expanding
prompt  ......list template 3819920772727370
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>3819920772727370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Hierarchical Expanding',
  p_theme_id  => 1,
  p_theme_class_id => 22,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_images_with_label_list
prompt  ......list template 3820003374727370
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ><br />#TEXT#</td>';

t2:=t2||'<td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></a><br /><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3820003374727370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Images with Label List',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="t1HorizontalImageswithLabelList" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_links_list
prompt  ......list template 3820127419727370
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1current">#TEXT#</a>';

t2:=t2||'<a href="#LINK#">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3820127419727370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Links List',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_list_template_before_rows=>'<div class="t1HorizontalLinksList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/pull_down_menu
prompt  ......list template 3820226915727370
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t6:=t6||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>3820226915727370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Pull Down Menu',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/pull_down_menu_with_image
prompt  ......list template 3820304231727370
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt="" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t2:=t2||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt=""  /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t3:=t3||'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt=""  class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t6:=t6||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt=""  class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>';

wwv_flow_api.create_list_template (
  p_id=>3820304231727370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Pull Down Menu with Image',
  p_theme_id  => 1,
  p_theme_class_id => 21,
  p_list_template_before_rows=>'<div class="dhtmlMenuLG">',
  p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/pull_down_menu_with_image_custom_1
prompt  ......list template 3820431170727371
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t2:=t2||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t3:=t3||'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t6:=t6||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>';

wwv_flow_api.create_list_template (
  p_id=>3820431170727371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Pull Down Menu with Image (Custom 1)',
  p_theme_id  => 1,
  p_theme_class_id => 9,
  p_list_template_before_rows=>'<div class="dhtmlMenuLG">',
  p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/tabbed_navigation_list
prompt  ......list template 3820529232727371
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a class="t1current" href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3820529232727371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Tabbed Navigation List',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_list_template_before_rows=>'<ul class="t1TabbedNavigationList">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_images_list
prompt  ......list template 3820627528727371
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</td></tr>';

t2:=t2||'<tr><td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3820627528727371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Images List',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_list_template_before_rows=>'<table cellpadding="0" cellspacing="0" border="0" summary="0" class="t1VerticalImagesList">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_images_list_custom_2
prompt  ......list template 3820715133727371
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td align="left"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></td><td align="left"><a href="#LINK#">#TEXT#</a></td></tr>'||unistr('\000a')||
'';

t2:=t2||'<tr><td align="left"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></td><td align="left"><a href="#LINK#">#TEXT#</a></td></tr>'||unistr('\000a')||
'';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3820715133727371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Images List (Custom 2)',
  p_theme_id  => 1,
  p_theme_class_id => 10,
  p_list_template_before_rows=>'<table border="0" cellpadding="0" cellspacing="5" summary="" >',
  p_list_template_after_rows=>'</table>'||unistr('\000a')||
'',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_ordered_list
prompt  ......list template 3820804058727371
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3820804058727371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Ordered List',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_list_template_before_rows=>'<ol class="t1VerticalOrderedList">',
  p_list_template_after_rows=>'</ol>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_sidebar_list
prompt  ......list template 3820902611727371
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1navcurrent">#TEXT#</a>';

t2:=t2||'<a href="#LINK#" class="t1nav">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3820902611727371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Sidebar List',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_list_template_before_rows=>'<div class="t1VerticalSidebarList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
prompt  ......list template 3821025852727371
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3821025852727371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List with Bullets',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_without_bullet
prompt  ......list template 3821117924727371
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3821117924727371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List without Bullet',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithoutBullet">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/wizard_progress_list
prompt  ......list template 3821214366727371
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td><div class="t1current">#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t2:=t2||'<tr><td><div>#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>3821214366727371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Wizard Progress List',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_list_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" class="t1WizardProgressList">',
  p_list_template_after_rows=>'<tr><td>&DONE.</td></tr>'||unistr('\000a')||
'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
--application/shared_components/user_interface/templates/report/borderless
prompt  ......report template 3821308262727371
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 3821308262727371 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Borderless',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#<tr>'||unistr('\000a')||
'<td><table class="t1borderless" cellpadding="0" border="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'#PAGINATION#'||unistr('\000a')||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#ccc',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 3821308262727371 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/horizontal_border
prompt  ......report template 3821409073727378
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 3821409073727378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Horizontal Border',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td><table cellpadding="0" cellspacing="0" border="0" class="t1HorizontalBorder" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'#PAGINATION#'||unistr('\000a')||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||unistr('\000a')||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#ccc',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 3821409073727378 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/one_column_unordered_list
prompt  ......report template 3821515020727378
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<li>#COLUMN_VALUE#</li>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 3821515020727378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'One Column Unordered List',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">'||unistr('\000a')||
'#TOP_PAGINATION#'||unistr('\000a')||
'<tr><td><ul class="t1OneColumnUnorderedList">',
  p_row_template_after_rows =>'</ul><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>'||unistr('\000a')||
'#PAGINATION#'||unistr('\000a')||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'NOT_CONDITIONAL',
  p_row_template_display_cond2=>'NOT_CONDITIONAL',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'NOT_CONDITIONAL',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 3821515020727378 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'OMIT');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard
prompt  ......report template 3821600848727378
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 3821600848727378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'#PAGINATION#'||unistr('\000a')||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#ccc',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 3821600848727378 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_ppr
prompt  ......report template 3821722808727378
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 3821722808727378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard (PPR)',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'#PAGINATION#'||unistr('\000a')||
'</table>'||unistr('\000a')||
'<script language=JavaScript type=text/javascript>'||unistr('\000a')||
'<!--'||unistr('\000a')||
'init_htmlPPRReport(''#REGION_ID#'');'||unistr('\000a')||
''||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'||unistr('\000a')||
'</htmldb:#REGION_ID#>'||unistr('\000a')||
'</div>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_translate_this_template => 'N',
  p_row_template_comment=> 'This is a deprecated template.'||unistr('\000a')||
''||unistr('\000a')||
'Reports using this template should be switched to to a standard template and the Enable Partial Page Refresh attribute should be enabled.');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 3821722808727378 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_alternating_row_colors
prompt  ......report template 3821819662727378
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="t1data"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="t1dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 3821819662727378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard, Alternating Row Colors',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">'||unistr('\000a')||
'#TOP_PAGINATION#'||unistr('\000a')||
'<tr><td><table border="0" cellpadding="0" cellspacing="0" summary="" class="t1standardalternatingrowcolors">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'#PAGINATION#'||unistr('\000a')||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||unistr('\000a')||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#ccc',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 3821819662727378 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/value_attribute_pairs
prompt  ......report template 3821930047727378
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<tr><th class="t1header">#COLUMN_HEADER#</th><td class="t1data">#COLUMN_VALUE#</td></tr>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 3821930047727378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Value Attribute Pairs',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#<tr><td><table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ValueAttributePairs">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>#PAGINATION#</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/no_label
prompt  ......label template 3822017744727378
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 3822017744727378 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'No Label',
  p_template_body1=>'<span class="t1NoLabel">',
  p_template_body2=>'</span>',
  p_before_item=>'',
  p_after_item=>'',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optional
prompt  ......label template 3822128434727382
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 3822128434727382 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><span class="t1Optional">',
  p_template_body2=>'</span></label>',
  p_before_item=>'',
  p_after_item=>'',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optional_with_help
prompt  ......label template 3822217926727382
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 3822217926727382 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_before_item=>'',
  p_after_item=>'',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required
prompt  ......label template 3822301551727382
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 3822301551727382 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><span class="t1Required">',
  p_template_body2=>'</span></label>',
  p_before_item=>'',
  p_after_item=>'',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required_with_help
prompt  ......label template 3822418255727382
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 3822418255727382 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><a class="t1RequiredwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_before_item=>'',
  p_after_item=>'',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
prompt  ......template 3822524772727382
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 3822524772727382 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Breadcrumb Menu',
  p_before_first=>'<div class="t1BreadcrumbMenu">',
  p_current_page_option=>'<span class="t1current">#NAME#</span>',
  p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>',
  p_menu_link_attributes=>'',
  p_between_levels=>'&nbsp;&gt;&nbsp;',
  p_after_last=>'</div>',
  p_max_levels=>12,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
prompt  ......template 3822614201727385
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 3822614201727385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Hierarchical Menu',
  p_before_first=>'<ul class="t1HierarchicalMenu">',
  p_current_page_option=>'<li class="t1current">#NAME#</li>',
  p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>',
  p_menu_link_attributes=>'',
  p_between_levels=>'',
  p_after_last=>'</ul>',
  p_max_levels=>11,
  p_start_with_node=>'CHILD_MENU',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 3823303730727392
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 3823303730727392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif',
  p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'Search Dialog',
  p_page_html_head=>'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_3_1.css" type="text/css">'||unistr('\000a')||
''||unistr('\000a')||
'#THEME_CSS#',
  p_page_body_attr=>'onload="first_field()" style="margin:0;"',
  p_before_field_text=>'<div class="t1PopupHead">',
  p_page_heading_text=>'',
  p_page_footer_text =>'',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'Search',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'Close',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'Next >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< Previous',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'450',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>',
  p_result_rows_per_pg=>500,
  p_before_result_set=>'<div class="t1PopupBody">',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
--application/shared_components/user_interface/templates/calendar/calendar
prompt  ......template 3822708036727385
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 3822708036727385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarHolder"> '||unistr('\000a')||
' <tr>'||unistr('\000a')||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||unistr('\000a')||
' </tr>'||unistr('\000a')||
' <tr>'||unistr('\000a')||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">',
  p_month_close_format=> '</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarHolder">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1WeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'||unistr('\000a')||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="0" summary="0" class="t1DayCalendar">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_cust_month_title_format => '',
  p_cust_day_of_week_format => '',
  p_cust_month_open_format => '',
  p_cust_month_close_format => '',
  p_cust_week_title_format => '',
  p_cust_week_open_format => '',
  p_cust_week_close_format => '',
  p_cust_day_title_format => '',
  p_cust_day_open_format => '',
  p_cust_day_close_format => '',
  p_cust_today_open_format => '',
  p_cust_daily_title_format => '',
  p_cust_daily_open_format => '',
  p_cust_daily_close_format => '',
  p_cust_nonday_title_format => '',
  p_cust_nonday_open_format => '',
  p_cust_nonday_close_format => '',
  p_cust_weekend_title_format => '',
  p_cust_weekend_open_format => '',
  p_cust_weekend_close_format => '',
  p_cust_hour_open_format => '',
  p_cust_hour_close_format => '',
  p_cust_time_title_format => '',
  p_cust_time_open_format => '',
  p_cust_time_close_format => '',
  p_cust_wk_month_title_format => '',
  p_cust_wk_day_of_week_format => '',
  p_cust_wk_month_open_format => '',
  p_cust_wk_month_close_format => '',
  p_cust_wk_week_title_format => '',
  p_cust_wk_week_open_format => '',
  p_cust_wk_week_close_format => '',
  p_cust_wk_day_title_format => '',
  p_cust_wk_day_open_format => '',
  p_cust_wk_day_close_format => '',
  p_cust_wk_today_open_format => '',
  p_cust_wk_weekend_title_format => '',
  p_cust_wk_weekend_open_format => '',
  p_cust_wk_weekend_close_format => '',
  p_cust_month_day_height_pix => '',
  p_cust_month_day_height_per => '',
  p_cust_week_day_width_pix => '',
  p_cust_week_day_width_per => '',
  p_agenda_format => '',
  p_agenda_past_day_format => '',
  p_agenda_today_day_format => '',
  p_agenda_future_day_format => '',
  p_agenda_past_entry_format => '',
  p_agenda_today_entry_format => '',
  p_agenda_future_entry_format => '',
  p_month_data_format => '#DAYS#',
  p_month_data_entry_format => '#DATA#',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar_alternative_1
prompt  ......template 3822931630727390
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 3822931630727390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar, Alternative 1',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th valign="bottom" class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarAlternative1Holder"> '||unistr('\000a')||
' <tr>'||unistr('\000a')||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||unistr('\000a')||
' </tr>'||unistr('\000a')||
' <tr>'||unistr('\000a')||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">',
  p_month_close_format=> '</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>'||unistr('\000a')||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarAlternative1Holder">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1WeekCalendarAlternative1">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>'||unistr('\000a')||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="2" summary="0" class="t1DayCalendarAlternative1">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_cust_month_title_format => '',
  p_cust_day_of_week_format => '',
  p_cust_month_open_format => '',
  p_cust_month_close_format => '',
  p_cust_week_title_format => '',
  p_cust_week_open_format => '',
  p_cust_week_close_format => '',
  p_cust_day_title_format => '',
  p_cust_day_open_format => '',
  p_cust_day_close_format => '',
  p_cust_today_open_format => '',
  p_cust_daily_title_format => '',
  p_cust_daily_open_format => '',
  p_cust_daily_close_format => '',
  p_cust_nonday_title_format => '',
  p_cust_nonday_open_format => '',
  p_cust_nonday_close_format => '',
  p_cust_weekend_title_format => '',
  p_cust_weekend_open_format => '',
  p_cust_weekend_close_format => '',
  p_cust_hour_open_format => '',
  p_cust_hour_close_format => '',
  p_cust_time_title_format => '',
  p_cust_time_open_format => '',
  p_cust_time_close_format => '',
  p_cust_wk_month_title_format => '',
  p_cust_wk_day_of_week_format => '',
  p_cust_wk_month_open_format => '',
  p_cust_wk_month_close_format => '',
  p_cust_wk_week_title_format => '',
  p_cust_wk_week_open_format => '',
  p_cust_wk_week_close_format => '',
  p_cust_wk_day_title_format => '',
  p_cust_wk_day_open_format => '',
  p_cust_wk_day_close_format => '',
  p_cust_wk_today_open_format => '',
  p_cust_wk_weekend_title_format => '',
  p_cust_wk_weekend_open_format => '',
  p_cust_wk_weekend_close_format => '',
  p_cust_month_day_height_pix => '',
  p_cust_month_day_height_per => '',
  p_cust_week_day_width_pix => '',
  p_cust_week_day_width_per => '',
  p_agenda_format => '',
  p_agenda_past_day_format => '',
  p_agenda_today_day_format => '',
  p_agenda_future_day_format => '',
  p_agenda_past_entry_format => '',
  p_agenda_today_entry_format => '',
  p_agenda_future_entry_format => '',
  p_month_data_format => '#DAYS#',
  p_month_data_entry_format => '#DATA#',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/small_calendar
prompt  ......template 3823116390727390
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 3823116390727390 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Small Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#DY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallCalendarHolder"> '||unistr('\000a')||
' <tr>'||unistr('\000a')||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||unistr('\000a')||
' </tr>'||unistr('\000a')||
' <tr>'||unistr('\000a')||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="1" summary="" class="t1SmallCalendar">',
  p_month_close_format=> '</table></td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'</table>',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallWeekCalendarHolder">'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||unistr('\000a')||
'</tr>'||unistr('\000a')||
'<tr>'||unistr('\000a')||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="1" summary="0" class="t1SmallWeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>'||unistr('\000a')||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="1" summary="0" class="t1SmallDayCalendar">',
  p_daily_month_close_format => '</table></td></tr></table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_cust_month_title_format => '',
  p_cust_day_of_week_format => '',
  p_cust_month_open_format => '',
  p_cust_month_close_format => '',
  p_cust_week_title_format => '',
  p_cust_week_open_format => '',
  p_cust_week_close_format => '',
  p_cust_day_title_format => '',
  p_cust_day_open_format => '',
  p_cust_day_close_format => '',
  p_cust_today_open_format => '',
  p_cust_daily_title_format => '',
  p_cust_daily_open_format => '',
  p_cust_daily_close_format => '',
  p_cust_nonday_title_format => '',
  p_cust_nonday_open_format => '',
  p_cust_nonday_close_format => '',
  p_cust_weekend_title_format => '',
  p_cust_weekend_open_format => '',
  p_cust_weekend_close_format => '',
  p_cust_hour_open_format => '',
  p_cust_hour_close_format => '',
  p_cust_time_title_format => '',
  p_cust_time_open_format => '',
  p_cust_time_close_format => '',
  p_cust_wk_month_title_format => '',
  p_cust_wk_day_of_week_format => '',
  p_cust_wk_month_open_format => '',
  p_cust_wk_month_close_format => '',
  p_cust_wk_week_title_format => '',
  p_cust_wk_week_open_format => '',
  p_cust_wk_week_close_format => '',
  p_cust_wk_day_title_format => '',
  p_cust_wk_day_open_format => '',
  p_cust_wk_day_close_format => '',
  p_cust_wk_today_open_format => '',
  p_cust_wk_weekend_title_format => '',
  p_cust_wk_weekend_open_format => '',
  p_cust_wk_weekend_close_format => '',
  p_cust_month_day_height_pix => '',
  p_cust_month_day_height_per => '',
  p_cust_week_day_width_pix => '',
  p_cust_week_day_width_per => '',
  p_agenda_format => '',
  p_agenda_past_day_format => '',
  p_agenda_today_day_format => '',
  p_agenda_future_day_format => '',
  p_agenda_past_entry_format => '',
  p_agenda_today_entry_format => '',
  p_agenda_future_entry_format => '',
  p_month_data_format => '#DAYS#',
  p_month_data_entry_format => '#DATA#',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_reference_id=> null);
end;
null;
 
end;
/

prompt  ...application themes
--
--application/shared_components/user_interface/themes/red
prompt  ......theme 3823431890727393
begin
wwv_flow_api.create_theme (
  p_id =>3823431890727393 + wwv_flow_api.g_id_offset,
  p_flow_id =>wwv_flow.g_flow_id,
  p_theme_id  => 1,
  p_theme_name=>'Red',
  p_ui_type_name=>'DESKTOP',
  p_is_locked=>false,
  p_default_page_template=>3816501748727348 + wwv_flow_api.g_id_offset,
  p_error_template=>3816501748727348 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=>3816825562727350 + wwv_flow_api.g_id_offset,
  p_breadcrumb_display_point=>'REGION_POSITION_01',
  p_sidebar_display_point=>'REGION_POSITION_02',
  p_login_template=>3816220719727340 + wwv_flow_api.g_id_offset,
  p_default_button_template=>3817106493727350 + wwv_flow_api.g_id_offset,
  p_default_region_template=>3819021965727364 + wwv_flow_api.g_id_offset,
  p_default_chart_template =>3818119956727360 + wwv_flow_api.g_id_offset,
  p_default_form_template  =>3818225130727360 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>3819021965727364 + wwv_flow_api.g_id_offset,
  p_default_tabform_template=>3819021965727364 + wwv_flow_api.g_id_offset,
  p_default_wizard_template=>3819521468727365 + wwv_flow_api.g_id_offset,
  p_default_menur_template=>3817723870727359 + wwv_flow_api.g_id_offset,
  p_default_listr_template=>3818030883727360 + wwv_flow_api.g_id_offset,
  p_default_irr_template=>null + wwv_flow_api.g_id_offset,
  p_default_report_template   =>3821600848727378 + wwv_flow_api.g_id_offset,
  p_default_label_template=>3822217926727382 + wwv_flow_api.g_id_offset,
  p_default_menu_template=>3822524772727382 + wwv_flow_api.g_id_offset,
  p_default_calendar_template=>3822708036727385 + wwv_flow_api.g_id_offset,
  p_default_list_template=>3821025852727371 + wwv_flow_api.g_id_offset,
  p_default_option_label=>3822217926727382 + wwv_flow_api.g_id_offset,
  p_default_header_template=>null + wwv_flow_api.g_id_offset,
  p_default_footer_template=>null + wwv_flow_api.g_id_offset,
  p_default_page_transition=>'NONE',
  p_default_popup_transition=>'NONE',
  p_default_required_label=>3822418255727382 + wwv_flow_api.g_id_offset);
end;
/
 
prompt  ...theme styles
--
 
begin
 
null;
 
end;
/

prompt  ...theme display points
--
 
begin
 
null;
 
end;
/

prompt  ...build options
--
 
begin
 
null;
 
end;
/

--application/shared_components/globalization/language
prompt  ...Language Maps for Application 104
--
 
begin
 
null;
 
end;
/

--application/shared_components/globalization/messages
prompt  ...text messages
--
--application/shared_components/globalization/dyntranslations
prompt  ...dynamic translations
--
prompt  ...Shortcuts
--
--application/shared_components/user_interface/shortcuts/set_item_label_login_102
 
begin
 
declare
  c1 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'DECLARE'||unistr('\000a')||
'   v_sprache  NUMBER ; '||unistr('\000a')||
'   v_de_id    NUMBER := 357;'||unistr('\000a')||
'   v_en_id    NUMBER := 333;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'  IF :p101_app_sprache_id IS NULL THEN'||unistr('\000a')||
'     :p101_app_sprache_id := 1; -- Deutsch'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
'  SELECT sprache_id into :p101_sprache_id '||unistr('\000a')||
'  FROM app_sprachen'||unistr('\000a')||
'  WHERE id = :p101_app_sprache_id;'||unistr('\000a')||
'*/'||unistr('\000a')||
'  v_sprache  := :p102_sprache_id;'||unistr('\000a')||
'  if ''#CURRENT_ITEM_NAME#'' in (''P102_USERNAME'') then'||unistr('\000a')||
'     return(frgbg_s.h';

c1:=c1||'olen_uebersetzung(202,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P102_PASSWORD'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(215,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P102_APP_SPRACHE_ID'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(214,v_sprache));'||unistr('\000a')||
'  ELSE  -- Fehler Feld unbekannt'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(217,v_sprache));'||unistr('\000a')||
'  end if; '||unistr('\000a')||
'END;';

wwv_flow_api.create_shortcut (
 p_id=> 1965823546449641 + wwv_flow_api.g_id_offset,
 p_flow_id=> wwv_flow.g_flow_id,
 p_shortcut_name=> 'SET_ITEM_LABEL_LOGIN_102',
 p_shortcut_type=> 'FUNCTION_BODY',
 p_shortcut=> c1);
end;
null;
 
end;
/

--application/shared_components/user_interface/shortcuts/set_item_label
 
begin
 
declare
  c1 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'DECLARE'||unistr('\000a')||
'   v_sprache  NUMBER ; '||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'  v_sprache := frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'  if ''#CURRENT_ITEM_NAME#'' in (''P4_SUCH_PLANDATUM'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(1787,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P4_DRUCKART'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(2310,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P4_PERSSTAMM_ID_IDENTITAET'') then'||unistr('\000a')||
'     return(frgbg_';

c1:=c1||'s.holen_uebersetzung(3101,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P4_DRUCKOPTION'','||unistr('\000a')||
'                                  ''P5_DRUCKOPTION'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(1521,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P4_ANZAHL'','||unistr('\000a')||
'                                  ''P5_ANZAHL'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(2157,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P5_F';

c1:=c1||'ERTIGDATUM'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(1939,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P5_SUCH_DATUM'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(1948,v_sprache));'||unistr('\000a')||
''||unistr('\000a')||
'  ELSE  -- Fehler Feld unbekannt'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(217,v_sprache));'||unistr('\000a')||
'  end if; '||unistr('\000a')||
'END;';

wwv_flow_api.create_shortcut (
 p_id=> 3848423389444481 + wwv_flow_api.g_id_offset,
 p_flow_id=> wwv_flow.g_flow_id,
 p_shortcut_name=> 'SET_ITEM_LABEL',
 p_shortcut_type=> 'FUNCTION_BODY',
 p_shortcut=> c1);
end;
null;
 
end;
/

--application/shared_components/user_interface/shortcuts/set_item_label_login
 
begin
 
declare
  c1 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'DECLARE'||unistr('\000a')||
'   v_sprache  NUMBER ; '||unistr('\000a')||
'   v_de_id    NUMBER := 357;'||unistr('\000a')||
'   v_en_id    NUMBER := 333;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'  IF :p101_app_sprache_id IS NULL THEN'||unistr('\000a')||
'     :p101_app_sprache_id := 1; -- Deutsch'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
'  SELECT sprache_id into :p101_sprache_id '||unistr('\000a')||
'  FROM app_sprachen'||unistr('\000a')||
'  WHERE id = :p101_app_sprache_id;'||unistr('\000a')||
'*/'||unistr('\000a')||
'  v_sprache  := :p101_sprache_id;'||unistr('\000a')||
'  if ''#CURRENT_ITEM_NAME#'' in (''P101_USERNAME'',''P102_USERNAME'') then'||unistr('\000a')||
'     ';

c1:=c1||'return(frgbg_s.holen_uebersetzung(202,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P101_PASSWORD'',''P102_PASSWORD'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(215,v_sprache));'||unistr('\000a')||
'  elsif ''#CURRENT_ITEM_NAME#'' in (''P101_APP_SPRACHE_ID'',''P100_APP_SPRACHE_ID'','||unistr('\000a')||
'                                  ''P102_APP_SPRACHE_ID'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(214,v_sprache));'||unistr('\000a')||
'  ELSE  -- Fehler Feld u';

c1:=c1||'nbekannt'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(217,v_sprache));'||unistr('\000a')||
'  end if; '||unistr('\000a')||
'END;';

wwv_flow_api.create_shortcut (
 p_id=> 3848612007444484 + wwv_flow_api.g_id_offset,
 p_flow_id=> wwv_flow.g_flow_id,
 p_shortcut_name=> 'SET_ITEM_LABEL_LOGIN',
 p_shortcut_type=> 'FUNCTION_BODY',
 p_shortcut=> c1);
end;
null;
 
end;
/

--application/shared_components/user_interface/shortcuts/set_item_label_login_verteiler
 
begin
 
declare
  c1 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'DECLARE'||unistr('\000a')||
'   v_sprache  NUMBER ; '||unistr('\000a')||
'   v_de_id    NUMBER := 357;'||unistr('\000a')||
'   v_en_id    NUMBER := 333;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'/*  '||unistr('\000a')||
'  SELECT sprache_id into :p100_sprache_id '||unistr('\000a')||
'  FROM app_sprachen'||unistr('\000a')||
'  WHERE id = :p100_app_sprache_id;'||unistr('\000a')||
'*/'||unistr('\000a')||
'  v_sprache  := :p100_sprache_id;'||unistr('\000a')||
'  if ''#CURRENT_ITEM_NAME#'' in (''P100_APP_SPRACHE_ID'') then'||unistr('\000a')||
'     return(frgbg_s.holen_uebersetzung(214,v_sprache));'||unistr('\000a')||
'  ELSE  -- Fehler Feld unbekannt'||unistr('\000a')||
'     return(frgb';

c1:=c1||'g_s.holen_uebersetzung(217,v_sprache));'||unistr('\000a')||
'  end if; '||unistr('\000a')||
'END;';

wwv_flow_api.create_shortcut (
 p_id=> 4797409473749535 + wwv_flow_api.g_id_offset,
 p_flow_id=> wwv_flow.g_flow_id,
 p_shortcut_name=> 'SET_ITEM_LABEL_LOGIN_VERTEILER',
 p_shortcut_type=> 'FUNCTION_BODY',
 p_shortcut=> c1);
end;
null;
 
end;
/

prompt  ...web services (9iR2 or better)
--
prompt  ...shared queries
--
prompt  ...report layouts
--
prompt  ...authentication schemes
--
--application/shared_components/security/authentication/application_express
prompt  ......authentication 3823500552727409
 
begin
 
wwv_flow_api.create_authentication (
  p_id => 3823500552727409 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'Application Express'
 ,p_scheme_type => 'NATIVE_APEX_ACCOUNTS'
 ,p_attribute_15 => '3823500552727409'
 ,p_invalid_session_type => 'URL'
 ,p_invalid_session_url => 'f?p=&APP_ID.:101:&SESSION.'
 ,p_logout_url => 'f?p=&APP_ID.:1'
 ,p_use_secure_cookie_yn => 'N'
 ,p_comments => 'ID-Daten von internem Application Express Account und Anmeldeseite in dieser Anwendung verwenden.'
  );
null;
 
end;
/

--application/shared_components/security/authentication/database
prompt  ......authentication 3823625397727410
 
begin
 
wwv_flow_api.create_authentication (
  p_id => 3823625397727410 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'DATABASE'
 ,p_scheme_type => 'NATIVE_DAD'
 ,p_attribute_15 => '3823625397727410'
 ,p_invalid_session_type => 'LOGIN'
 ,p_use_secure_cookie_yn => 'N'
 ,p_comments => 'Datenbank-Authentifizierung verwenden (Benutzer von DAD identifiziert).'
  );
null;
 
end;
/

--application/shared_components/security/authentication/database_account
prompt  ......authentication 3823720954727412
 
begin
 
wwv_flow_api.create_authentication (
  p_id => 3823720954727412 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'DATABASE ACCOUNT'
 ,p_scheme_type => 'NATIVE_DB_ACCOUNTS'
 ,p_attribute_15 => '3823720954727412'
 ,p_invalid_session_type => 'URL'
 ,p_invalid_session_url => 'f?p=&APP_ID.:101:&SESSION.'
 ,p_logout_url => 'f?p=&APP_ID.:1'
 ,p_use_secure_cookie_yn => 'N'
 ,p_comments => 'Verwenden Sie Datenbank-Account-ID-Daten.'
  );
null;
 
end;
/

--application/shared_components/security/authentication/auth_frgbg
prompt  ......authentication 3852328165872065
 
begin
 
wwv_flow_api.create_authentication (
  p_id => 3852328165872065 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'AUTH_FRGBG'
 ,p_scheme_type => 'NATIVE_CUSTOM'
 ,p_attribute_03 => 'frgbg_s.valid_user'
 ,p_attribute_05 => 'N'
 ,p_attribute_15 => '3852328165872065'
 ,p_invalid_session_type => 'URL'
 ,p_invalid_session_url => 'f?p=&APP_ID.:100:&SESSION.'
 ,p_logout_url => 'f?p=102:101'
 ,p_use_secure_cookie_yn => 'N'
  );
null;
 
end;
/

prompt  ...ui types
--
 
begin
 
null;
 
end;
/

prompt  ...plugins
--
--application/shared_components/plugins/region_type/com_jwilson_apex_drop_menu
 
begin
 
wwv_flow_api.create_plugin (
  p_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'REGION TYPE'
 ,p_name => 'COM.JWILSON.APEX.DROP_MENU'
 ,p_display_name => 'DropDownMenu'
 ,p_supported_ui_types => 'DESKTOP'
 ,p_image_prefix => '#PLUGIN_PREFIX#'
 ,p_plsql_code => 
'function render_dropdown_menu ('||unistr('\000a')||
'      p_region              in apex_plugin.t_region,'||unistr('\000a')||
'      p_plugin              in apex_plugin.t_plugin,'||unistr('\000a')||
'      p_is_printer_friendly in boolean '||unistr('\000a')||
') return apex_plugin.t_region_render_result'||unistr('\000a')||
'is'||unistr('\000a')||
'    -- It''s better to have named variables instead of using the generic ones,'||unistr('\000a')||
'    -- makes the code more readable'||unistr('\000a')||
'    l_skip_level        NUMBER := nvl(p_region.attribute_01, '||
'0);'||unistr('\000a')||
'    '||unistr('\000a')||
'    l_sql_handler       apex_plugin_util.t_sql_handler;'||unistr('\000a')||
'    l_column_value_list apex_plugin_util.t_column_value_list;'||unistr('\000a')||
'    l_id	        NUMBER :=0;'||unistr('\000a')||
'    l_parent_id         NUMBER :=0;'||unistr('\000a')||
'    l_label             VARCHAR2(32767) := '''';'||unistr('\000a')||
'    l_link              VARCHAR2(32767) := '''';'||unistr('\000a')||
'    l_level             NUMBER :=0; '||unistr('\000a')||
'    l_prev_id	        NUMBER;'||unistr('\000a')||
'    l_prev_parent_id    NUMBER;'||unistr('\000a')||
'    l_prev_labe'||
'l        VARCHAR2(32767);'||unistr('\000a')||
'    l_prev_link         VARCHAR2(32767);'||unistr('\000a')||
'    l_prev_level        NUMBER;   '||unistr('\000a')||
'    l_fut_dir		NUMBER :=0;'||unistr('\000a')||
'    l_prev_dir		NUMBER;'||unistr('\000a')||
'    '||unistr('\000a')||
'begin'||unistr('\000a')||
'    -- Register the javascript library the plug-in uses.'||unistr('\000a')||
'    apex_javascript.add_library ('||unistr('\000a')||
'            p_name      => ''stuHover'','||unistr('\000a')||
'            p_directory => p_plugin.file_prefix,'||unistr('\000a')||
'            p_version   => null );'||unistr('\000a')||
''||unistr('\000a')||
'    apex_css.add_file'||
' ('||unistr('\000a')||
'        p_name      => ''pro_dropdown_3jw'','||unistr('\000a')||
'        p_directory =>p_plugin.file_prefix,'||unistr('\000a')||
'        p_version   => null );   '||unistr('\000a')||
''||unistr('\000a')||
'    -- check sql statement, it has to be in the format "label", "link" and "value"'||unistr('\000a')||
'    begin'||unistr('\000a')||
'        l_sql_handler := apex_plugin_util.get_sql_handler ('||unistr('\000a')||
'                             p_sql_statement  => p_region.source,'||unistr('\000a')||
'                             p_min_columns    => 5,'||unistr('\000a')||
'    '||
'                         p_max_columns    => 5,'||unistr('\000a')||
'                             p_component_name => p_region.static_id );'||unistr('\000a')||
'                             '||unistr('\000a')||
'        -- column "value" has to be of type NUMBER for columns 1 ,2, and 5'||unistr('\000a')||
'        if l_sql_handler.column_list(1).col_type <> dbms_types.TYPECODE_NUMBER then '||unistr('\000a')||
'            raise_application_error(-20000, ''First column in select list must be of type NU'||
'MBER'');'||unistr('\000a')||
'        end if;'||unistr('\000a')||
'        '||unistr('\000a')||
'        if l_sql_handler.column_list(2).col_type <> dbms_types.TYPECODE_NUMBER then '||unistr('\000a')||
'	    raise_application_error(-20000, ''Second column in select list must be of type NUMBER'');'||unistr('\000a')||
'        end if;'||unistr('\000a')||
'      '||unistr('\000a')||
'        if l_sql_handler.column_list(5).col_type <> dbms_types.TYPECODE_NUMBER then '||unistr('\000a')||
'		    raise_application_error(-20000, ''Fifth column in select list must be of typ'||
'e NUMBER'');'||unistr('\000a')||
'        end if;'||unistr('\000a')||
'        '||unistr('\000a')||
''||unistr('\000a')||
'        apex_plugin_util.free_sql_handler(l_sql_handler);'||unistr('\000a')||
'    exception when others then'||unistr('\000a')||
'        apex_plugin_util.free_sql_handler(l_sql_handler);'||unistr('\000a')||
'        raise;'||unistr('\000a')||
'    end;'||unistr('\000a')||
'    '||unistr('\000a')||
'    -- get data based on our new sql statement'||unistr('\000a')||
'    l_column_value_list := apex_plugin_util.get_data ('||unistr('\000a')||
'                               p_sql_statement  => p_region.source,'||unistr('\000a')||
'                '||
'               p_min_columns    => 5,'||unistr('\000a')||
'                               p_max_columns    => 5,'||unistr('\000a')||
'                               p_component_name => p_region.static_id );'||unistr('\000a')||
'                               '||unistr('\000a')||
'  --Start the menu code'||unistr('\000a')||
'  sys.htp.prn(''<ul id="nav" style="display:none">'');'||unistr('\000a')||
''||unistr('\000a')||
'  -- print menu based on the result set'||unistr('\000a')||
'  FOR i in 1 .. l_column_value_list(1).count /* label */'||unistr('\000a')||
'  LOOP'||unistr('\000a')||
'	l_prev_id	:= l_id;'||unistr('\000a')||
' '||
'       l_prev_parent_id:= l_parent_id;'||unistr('\000a')||
'        l_prev_label	:= l_label;'||unistr('\000a')||
'        l_prev_link	:= l_link;'||unistr('\000a')||
'        l_prev_level	:= l_level;  '||unistr('\000a')||
'        l_prev_dir	:= l_fut_dir;'||unistr('\000a')||
'	l_id		:= l_column_value_list(1)(i);'||unistr('\000a')||
'        l_parent_id	:= l_column_value_list(2)(i);'||unistr('\000a')||
'        l_label		:= l_column_value_list(3)(i);'||unistr('\000a')||
'        l_link		:= l_column_value_list(4)(i);'||unistr('\000a')||
'        l_level		:= l_column_value_list(5)(i);'||unistr('\000a')||
'  '||
'      '||unistr('\000a')||
'        /********************************************'||unistr('\000a')||
'        First check which direction the level is going'||unistr('\000a')||
'        Positive = downward'||unistr('\000a')||
'        Zero = equal'||unistr('\000a')||
'        Negative = upward'||unistr('\000a')||
'        **********************************************/'||unistr('\000a')||
'        l_fut_dir := l_level-l_prev_level;     '||unistr('\000a')||
'        '||unistr('\000a')||
'          '||unistr('\000a')||
'        /* Need to work with the previous record at all times so we can determine if '||
'the '||unistr('\000a')||
'        current record is a child.  We''ll print the last record at the end.'||unistr('\000a')||
'        */'||unistr('\000a')||
'        IF l_prev_id = 0 THEN'||unistr('\000a')||
'          --Skip the first time through'||unistr('\000a')||
'          NULL;'||unistr('\000a')||
'	ELSIF l_prev_level = l_skip_level THEN'||unistr('\000a')||
'	  --Do Nothing'||unistr('\000a')||
'	  NULL;  '||unistr('\000a')||
'	ELSE'||unistr('\000a')||
'	  --End any prior menus started'||unistr('\000a')||
'	  IF l_prev_dir < 0 THEN'||unistr('\000a')||
'	    FOR i IN 1..(-1 * l_prev_dir) LOOP'||unistr('\000a')||
'		sys.htp.prn(''</ul></li>'');'||unistr('\000a')||
' 	    END LOOP;'||unistr('\000a')||
' 	  E'||
'ND IF;'||unistr('\000a')||
'		'||unistr('\000a')||
'	  --Check to see if this is a top level record'||unistr('\000a')||
'	  IF l_prev_level = l_skip_level + 1 THEN    '||unistr('\000a')||
'	    --Check to see if this has a child record'||unistr('\000a')||
'	    IF l_fut_dir >= 1 THEN'||unistr('\000a')||
'	      --Print the top level structure with the down arrow'||unistr('\000a')||
'	      sys.htp.prn(''<li class="top" onmousemove="$(this).find(''''ul:first'''').addClass(''''showmenu'''')" onmouseout="$(this).find(''''ul:first'''').removeClass(''''showmenu'||
''''')"><a href= "''||'||unistr('\000a')||
'	      l_prev_link ||''" id= "'' || l_prev_id ||''" class="top_link"><span class="down">''||'||unistr('\000a')||
'	      l_prev_label ||''</span></a>'');	    '||unistr('\000a')||
'	    ELSE'||unistr('\000a')||
'	      --Print the top level structure with no down arrow'||unistr('\000a')||
'	      sys.htp.prn(''<li class="top"><a href= "''||'||unistr('\000a')||
'	      l_prev_link ||''" id= "'' || l_prev_id ||''" class="top_link"><span>''||'||unistr('\000a')||
'	      l_prev_label ||''</span></a></li>''); '||unistr('\000a')||
'	    END IF'||
';'||unistr('\000a')||
'	    '||unistr('\000a')||
'	  --Check to see if this is a second level record '||unistr('\000a')||
'	  ELSIF l_prev_level = l_skip_level + 2 THEN'||unistr('\000a')||
'	    IF l_prev_dir >= 1 THEN'||unistr('\000a')||
'	      --Start the sub-menu'||unistr('\000a')||
'	      sys.htp.prn(''<ul class="sub">'');'||unistr('\000a')||
'	    END IF;    '||unistr('\000a')||
'	      '||unistr('\000a')||
'	    --Check to see if this has a child record'||unistr('\000a')||
'	    IF l_fut_dir >= 1 THEN'||unistr('\000a')||
'	      --Print the second level structure with the flyout'||unistr('\000a')||
'	      sys.htp.prn(''<li onmousemove="$('||
'this).find(''''ul:first'''').addClass(''''showmenu'''')" onmouseout="$(this).find(''''ul:first'''').removeClass(''''showmenu'''')"><a href="''||l_prev_link ||''" class="fly">''||l_prev_label ||''</a>'');	    '||unistr('\000a')||
'	    ELSE'||unistr('\000a')||
'	      --Print the second level structure with no flyout'||unistr('\000a')||
'	      sys.htp.prn(''<li><a href="''||l_prev_link ||''">''||l_prev_label ||''</a></li>'');'||unistr('\000a')||
'	    END IF;'||unistr('\000a')||
'  '||unistr('\000a')||
'	  --Check to see if this is a third level r'||
'ecord '||unistr('\000a')||
'	  ELSIF l_prev_level = l_skip_level + 3 THEN'||unistr('\000a')||
'	    IF l_prev_dir >= 1 THEN'||unistr('\000a')||
'	      --Start the sub-menu'||unistr('\000a')||
'	      sys.htp.prn(''<ul>'');'||unistr('\000a')||
'	    END IF;    '||unistr('\000a')||
'	      '||unistr('\000a')||
'	    sys.htp.prn(''<li><a href="''||l_prev_link ||''">''||l_prev_label ||''</a></li>'');	    '||unistr('\000a')||
'  '||unistr('\000a')||
'	  END IF;'||unistr('\000a')||
'	END IF;'||unistr('\000a')||
'   end loop;'||unistr('\000a')||
'   '||unistr('\000a')||
'  --Finish off the last item'||unistr('\000a')||
'   IF l_level = l_skip_level + 1 THEN'||unistr('\000a')||
'    IF l_fut_dir = -1 THEN'||unistr('\000a')||
'      --End the'||
' sub-menu'||unistr('\000a')||
'      sys.htp.prn(''</ul><li>'');'||unistr('\000a')||
'    END IF; '||unistr('\000a')||
'      sys.htp.prn(''<li class="top"><a href= "''||'||unistr('\000a')||
'      l_link ||''" id= "'' || l_id ||''" class="top_link"><span>''||'||unistr('\000a')||
'      l_label ||''</span></a></li>'');    '||unistr('\000a')||
'   '||unistr('\000a')||
'   ELSIF l_level = l_skip_level + 2 THEN'||unistr('\000a')||
'    IF l_fut_dir = 1 THEN'||unistr('\000a')||
'      --Start the sub-menu'||unistr('\000a')||
'      sys.htp.prn(''<ul class="sub">'');'||unistr('\000a')||
'    END IF;'||unistr('\000a')||
'    IF l_fut_dir = -1 THEN'||unistr('\000a')||
'      --End th'||
'e sub-menu'||unistr('\000a')||
'      sys.htp.prn(''</ul></li>'');'||unistr('\000a')||
'    END IF;   '||unistr('\000a')||
'    sys.htp.prn(''<li><a href="''||l_link ||''">''||l_label ||''</a></li></ul></li>'');   '||unistr('\000a')||
'   '||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'    IF l_fut_dir = 1 THEN'||unistr('\000a')||
'      --Start the sub-menu'||unistr('\000a')||
'      sys.htp.prn(''<ul>'');'||unistr('\000a')||
'    END IF;'||unistr('\000a')||
'    IF l_fut_dir = -1 THEN'||unistr('\000a')||
'      --End the sub-menu'||unistr('\000a')||
'      sys.htp.prn(''</ul></li>'');'||unistr('\000a')||
'    END IF;	   	'||unistr('\000a')||
'   	sys.htp.prn(''<li><a href="''||l_link ||''">''||l_'||
'label ||''</a></li></ul></li></ul></li>'');'||unistr('\000a')||
'   '||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'    '||unistr('\000a')||
'  --End the menu'||unistr('\000a')||
'  sys.htp.prn(''</ul>'');'||unistr('\000a')||
''||unistr('\000a')||
'  sys.htp.prn(''<script type="text/javascript"> $(document).ready(function() { $("#nav").css("display","block"); }); </script>'');'||unistr('\000a')||
'    return null;'||unistr('\000a')||
'end render_dropdown_menu;'
 ,p_render_function => 'render_dropdown_menu'
 ,p_standard_attributes => 'SOURCE_SQL:SOURCE_REQUIRED'
 ,p_sql_min_column_count => 5
 ,p_sql_max_column_count => 5
 ,p_sql_examples => 'select "M_APPLICATION_NUM" id, '||unistr('\000a')||
'	"PARENT_M_APP_NUM" pid, '||unistr('\000a')||
'	"DESCRIPTION" name, '||unistr('\000a')||
'	nvl("URL",''f?p=&APP_ID.:1'') || '||unistr('\000a')||
'	case substr(URL,1,4) when ''f?p='' then '||unistr('\000a')||
'		'':'' ||v(session_id) '||unistr('\000a')||
'	else null '||unistr('\000a')||
'	end link, level'||unistr('\000a')||
'from "M_APPLICATIONS"'||unistr('\000a')||
'where in_use = ''Y'''||unistr('\000a')||
'start with PARENT_M_APP_NUM is null'||unistr('\000a')||
'connect by prior M_APPLICATION_NUM = PARENT_M_APP_NUM'
 ,p_substitute_attributes => true
 ,p_subscribe_plugin_settings => true
 ,p_help_text => '<p>'||unistr('\000a')||
'	This region plug-in provides an elegant drop-down menu using css and javascript.&nbsp; It takes a source query that provides a menu_id, a parent_id, a menu_name, and a link. This menu region is ideally used on page 0 to create a uniform menu throughout your application.&nbsp; Modification of the page template is suggested to get the menu exactly where you want it.</p>'||unistr('\000a')||
''
 ,p_version_identifier => '1.0'
 ,p_plugin_comment => 'Credit goes to Stu Nicholls for providing the great drop-down menu code and to Tony Jedlinski who had a great example of a menu framework that I used for the back-end menu table.  '||unistr('\000a')||
'http://www.stunicholls.com/'||unistr('\000a')||
'http://www.oracle.com/technetwork/issue-archive/2006/06-may/o36apex-086847.html'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 3887971040969597194 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 1
 ,p_display_sequence => 10
 ,p_prompt => 'Skip Level'
 ,p_attribute_type => 'NUMBER'
 ,p_is_required => false
 ,p_default_value => '0'
 ,p_display_length => 5
 ,p_max_length => 5
 ,p_is_translatable => false
 ,p_help_text => 'If there is a top level that you want to skip, enter that level number.'
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2A203D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D200D0A5468697320636F70797269676874206E6F74696365206D75737420626520';
wwv_flow_api.g_varchar2_table(2) := '6B65707420756E746F756368656420696E20746865207374796C657368656574206174200D0A616C6C2074696D65732E0D0A0D0A546865206F726967696E616C2076657273696F6E206F6620746869732073637269707420616E6420746865206173736F';
wwv_flow_api.g_varchar2_table(3) := '6369617465642028782968746D6C0D0A697320617661696C61626C6520617420687474703A2F2F7777772E7374756E6963686F6C6C732E636F6D2F6D656E752F70726F5F64726F705F312E68746D6C0D0A436F707972696768742028632920323030352D';
wwv_flow_api.g_varchar2_table(4) := '3230303720537475204E6963686F6C6C732E20416C6C207269676874732072657365727665642E0D0A546869732073637269707420616E6420746865206173736F6369617465642028782968746D6C206D6179206265206D6F64696669656420696E2061';
wwv_flow_api.g_varchar2_table(5) := '6E79200D0A77617920746F2066697420796F757220726571756972656D656E74732E0D0A3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D';
wwv_flow_api.g_varchar2_table(6) := '3D3D3D202A2F0D0A737475486F766572203D2066756E6374696F6E2829207B0D0A097661722063737352756C653B0D0A09766172206E657753656C6563746F723B0D0A092F2A0D0A09666F7220287661722069203D20303B2069203C20646F63756D656E';
wwv_flow_api.g_varchar2_table(7) := '742E7374796C655368656574732E6C656E6774683B20692B2B290D0A0909666F7220287661722078203D20303B2078203C20646F63756D656E742E7374796C655368656574735B695D2E72756C65732E6C656E677468203B20782B2B290D0A0909097B0D';
wwv_flow_api.g_varchar2_table(8) := '0A09090963737352756C65203D20646F63756D656E742E7374796C655368656574735B695D2E72756C65735B785D3B0D0A0909096966202863737352756C652E73656C6563746F72546578742E696E6465784F6628224C493A686F766572222920213D20';
wwv_flow_api.g_varchar2_table(9) := '2D31290D0A0909097B0D0A09090909206E657753656C6563746F72203D2063737352756C652E73656C6563746F72546578742E7265706C616365282F4C493A686F7665722F67692C20224C492E6965686F76657222293B0D0A09090909646F63756D656E';
wwv_flow_api.g_varchar2_table(10) := '742E7374796C655368656574735B695D2E61646452756C65286E657753656C6563746F72202C2063737352756C652E7374796C652E63737354657874293B0D0A0909097D0D0A09097D0D0A0976617220676574456C6D203D20646F63756D656E742E6765';
wwv_flow_api.g_varchar2_table(11) := '74456C656D656E744279496428226E617622292E676574456C656D656E747342795461674E616D6528224C4922293B0D0A09666F72202876617220693D303B20693C676574456C6D2E6C656E6774683B20692B2B29207B0D0A0909676574456C6D5B695D';
wwv_flow_api.g_varchar2_table(12) := '2E6F6E6D6F7573656F7665723D66756E6374696F6E2829207B0D0A090909746869732E636C6173734E616D652B3D22206965686F766572223B0D0A09097D0D0A0909676574456C6D5B695D2E6F6E6D6F7573656F75743D66756E6374696F6E2829207B0D';
wwv_flow_api.g_varchar2_table(13) := '0A090909746869732E636C6173734E616D653D746869732E636C6173734E616D652E7265706C616365286E6577205265674578702822206965686F7665725C5C6222292C202222293B0D0A09097D0D0A097D2A2F0D0A7D0D0A6966202877696E646F772E';
wwv_flow_api.g_varchar2_table(14) := '6174746163684576656E74292077696E646F772E6174746163684576656E7428226F6E6C6F6164222C20737475486F766572293B0D0A0D0A';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 13399805891127429 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_file_name => 'stuHover.js'
 ,p_mime_type => 'application/javascript'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2A203D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D200D0A5468697320636F70797269676874206E6F74696365206D75737420626520';
wwv_flow_api.g_varchar2_table(2) := '6B65707420756E746F756368656420696E20746865207374796C657368656574206174200D0A616C6C2074696D65732E0D0A0D0A546865206F726967696E616C2076657273696F6E206F662074686973207374796C65736865657420616E642074686520';
wwv_flow_api.g_varchar2_table(3) := '6173736F6369617465642028782968746D6C0D0A697320617661696C61626C6520617420687474703A2F2F7777772E7374756E6963686F6C6C732E636F6D2F6D656E752F70726F5F64726F70646F776E5F332E68746D6C0D0A436F707972696768742028';
wwv_flow_api.g_varchar2_table(4) := '632920323030352D3230303720537475204E6963686F6C6C732E20416C6C207269676874732072657365727665642E0D0A54686973207374796C65736865657420616E6420746865206173736F6369617465642028782968746D6C206D6179206265206D';
wwv_flow_api.g_varchar2_table(5) := '6F64696669656420696E20616E79200D0A77617920746F2066697420796F757220726571756972656D656E74732E0D0A3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D';
wwv_flow_api.g_varchar2_table(6) := '3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D202A2F0D0A0D0A2E7072656C6F616431207B6261636B67726F756E643A2075726C2823504C5547494E5F5052454649582374687265655F30612E676966293B7D0D0A2E7072656C6F616432207B6261636B67726F75';
wwv_flow_api.g_varchar2_table(7) := '6E643A2075726C2823504C5547494E5F5052454649582374687265655F31612E676966293B7D0D0A0D0A236E6176207B70616464696E673A303B206D617267696E3A303B206C6973742D7374796C653A6E6F6E653B206865696768743A333870783B2062';
wwv_flow_api.g_varchar2_table(8) := '61636B67726F756E643A236666662075726C2823504C5547494E5F5052454649582374687265655F302E67696629207265706561742D783B20706F736974696F6E3A72656C61746976653B207A2D696E6465783A3530303B20666F6E742D66616D696C79';
wwv_flow_api.g_varchar2_table(9) := '3A617269616C2C2076657264616E612C2073616E732D73657269663B20646973706C61793A6E6F6E653B202F2A206869646520756E74696C20636F6D706C6574656C79206C6F61646564202A2F7D0D0A236E6176206C692E746F70207B646973706C6179';
wwv_flow_api.g_varchar2_table(10) := '3A626C6F636B3B20666C6F61743A6C6566743B7D0D0A236E6176206C6920612E746F705F6C696E6B207B646973706C61793A626C6F636B3B20666C6F61743A6C6566743B206865696768743A333570783B206C696E652D6865696768743A333370783B20';
wwv_flow_api.g_varchar2_table(11) := '636F6C6F723A236363633B20746578742D6465636F726174696F6E3A6E6F6E653B20666F6E742D73697A653A313170783B20666F6E742D7765696768743A626F6C643B2070616464696E673A302030203020313270783B20637572736F723A706F696E74';
wwv_flow_api.g_varchar2_table(12) := '65723B6261636B67726F756E643A2075726C2823504C5547494E5F5052454649582374687265655F302E676966293B7D0D0A236E6176206C6920612E746F705F6C696E6B207370616E207B666C6F61743A6C6566743B20646973706C61793A626C6F636B';
wwv_flow_api.g_varchar2_table(13) := '3B2070616464696E673A302032347078203020313270783B206865696768743A333570783B206261636B67726F756E643A2075726C2823504C5547494E5F5052454649582374687265655F302E6769662920726967687420746F70206E6F2D7265706561';
wwv_flow_api.g_varchar2_table(14) := '743B7D0D0A236E6176206C6920612E746F705F6C696E6B207370616E2E646F776E207B666C6F61743A6C6566743B20646973706C61793A626C6F636B3B2070616464696E673A302032347078203020313270783B206865696768743A333570783B206261';
wwv_flow_api.g_varchar2_table(15) := '636B67726F756E643A2075726C2823504C5547494E5F5052454649582374687265655F30612E67696629206E6F2D72657065617420726967687420746F703B7D0D0A0D0A236E6176206C693A686F76657220612E746F705F6C696E6B207B636F6C6F723A';
wwv_flow_api.g_varchar2_table(16) := '236666663B206261636B67726F756E643A2075726C2823504C5547494E5F5052454649582374687265655F312E67696629206E6F2D7265706561743B7D0D0A236E6176206C693A686F76657220612E746F705F6C696E6B207370616E207B6261636B6772';
wwv_flow_api.g_varchar2_table(17) := '6F756E643A75726C2823504C5547494E5F5052454649582374687265655F312E67696629206E6F2D72657065617420726967687420746F703B7D0D0A236E6176206C693A686F76657220612E746F705F6C696E6B207370616E2E646F776E207B6261636B';
wwv_flow_api.g_varchar2_table(18) := '67726F756E643A75726C2823504C5547494E5F5052454649582374687265655F31612E67696629206E6F2D72657065617420726967687420746F703B2070616464696E672D626F74746F6D3A3370783B7D0D0A0D0A2F2A2044656661756C74206C697374';
wwv_flow_api.g_varchar2_table(19) := '207374796C696E67202A2F0D0A0D0A236E6176206C693A686F766572207B706F736974696F6E3A72656C61746976653B207A2D696E6465783A3230303B7D0D0A0D0A236E6176206C693A686F76657220756C2E7375622C20236E6176206C6920756C2E73';
wwv_flow_api.g_varchar2_table(20) := '686F776D656E750D0A7B6C6566743A3170783B20746F703A333470783B206261636B67726F756E643A20234346453046313B2070616464696E673A3370783B20626F726465723A31707820736F6C696420233062346439373B2077686974652D73706163';
wwv_flow_api.g_varchar2_table(21) := '653A6E6F777261703B2077696474683A31323570783B206865696768743A6175746F3B207A2D696E6465783A3330303B7D0D0A236E6176206C693A686F76657220756C2E737562206C692C20236E6176206C6920756C2E73686F776D656E75206C690D0A';
wwv_flow_api.g_varchar2_table(22) := '7B646973706C61793A626C6F636B3B206865696768743A323070783B20706F736974696F6E3A72656C61746976653B20666C6F61743A6C6566743B2077696474683A31323570783B20666F6E742D7765696768743A6E6F726D616C3B7D0D0A236E617620';
wwv_flow_api.g_varchar2_table(23) := '6C693A686F76657220756C2E737562206C6920612C20236E6176206C6920756C2E73686F776D656E75206C6920610D0A7B646973706C61793A626C6F636B3B20666F6E742D73697A653A313170783B206865696768743A313870783B2077696474683A31';
wwv_flow_api.g_varchar2_table(24) := '323570783B206C696E652D6865696768743A313870783B20746578742D696E64656E743A3570783B20636F6C6F723A233030303B20746578742D6465636F726174696F6E3A6E6F6E653B626F726465723A31707820736F6C696420234346453046313B7D';
wwv_flow_api.g_varchar2_table(25) := '0D0A236E6176206C6920756C2E737562206C6920612E666C790D0A7B6261636B67726F756E643A234346453046312075726C2823504C5547494E5F505245464958236172726F772E6769662920313230707820367078206E6F2D7265706561743B7D0D0A';
wwv_flow_api.g_varchar2_table(26) := '236E6176206C693A686F76657220756C2E737562206C6920613A686F7665722C20236E6176206C6920756C2E73686F776D656E75206C6920613A686F76657220200D0A7B6261636B67726F756E643A233366393661393B20636F6C6F723A236666663B20';
wwv_flow_api.g_varchar2_table(27) := '626F726465722D636F6C6F723A236666663B7D0D0A236E6176206C693A686F76657220756C2E737562206C6920612E666C793A686F7665722C20236E6176206C6920756C2E73686F776D656E75206C6920612E666C793A686F7665720D0A7B6261636B67';
wwv_flow_api.g_varchar2_table(28) := '726F756E643A233366393661392075726C2823504C5547494E5F505245464958236172726F775F6F7665722E6769662920313230707820367078206E6F2D7265706561743B20636F6C6F723A236666663B7D0D0A0D0A236E6176206C692062207B646973';
wwv_flow_api.g_varchar2_table(29) := '706C61793A626C6F636B3B20666F6E742D73697A653A313170783B206865696768743A313870783B2077696474683A383870783B206C696E652D6865696768743A313870783B206D617267696E2D626F74746F6D3A3370783B20746578742D696E64656E';
wwv_flow_api.g_varchar2_table(30) := '743A3670783B20636F6C6F723A236666363B20626F726465722D626F74746F6D3A31707820736F6C696420236666363B20637572736F723A64656661756C743B7D0D0A0D0A236E6176206C693A686F766572206C693A686F76657220756C2C0D0A236E61';
wwv_flow_api.g_varchar2_table(31) := '76206C6920756C2E73686F776D656E75206C692020756C2E73686F776D656E752C0D0A236E6176206C693A686F766572206C693A686F766572206C693A686F76657220756C2C0D0A236E6176206C6920756C2E73686F776D656E75206C6920756C2E7368';
wwv_flow_api.g_varchar2_table(32) := '6F776D656E75206C6920756C2E73686F776D656E752C0D0A236E6176206C693A686F766572206C693A686F766572206C693A686F766572206C693A686F76657220756C2C0D0A236E6176206C6920756C2E73686F776D656E75206C6920756C2E73686F77';
wwv_flow_api.g_varchar2_table(33) := '6D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E752C0D0A236E6176206C693A686F766572206C693A686F766572206C693A686F766572206C693A686F766572206C693A686F76657220756C2C0D0A236E6176206C6920';
wwv_flow_api.g_varchar2_table(34) := '756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E750D0A7B6C6566743A31323570783B20746F703A2D3470783B206261636B';
wwv_flow_api.g_varchar2_table(35) := '67726F756E643A20234346453046313B2070616464696E673A3370783B20626F726465723A31707820736F6C696420233062346439373B2077686974652D73706163653A6E6F777261703B2077696474683A31323570783B207A2D696E6465783A343030';
wwv_flow_api.g_varchar2_table(36) := '3B206865696768743A6175746F3B7D0D0A0D0A0D0A236E617620756C2C200D0A236E6176206C693A686F76657220756C20756C2C0D0A236E6176206C693A686F766572206C693A686F76657220756C20756C2C0D0A236E6176206C693A686F766572206C';
wwv_flow_api.g_varchar2_table(37) := '693A686F766572206C693A686F76657220756C20756C2C0D0A236E6176206C693A686F766572206C693A686F766572206C693A686F766572206C693A686F76657220756C20756C2C0D0A236E6176206C6920756C2E73686F776D656E7520756C2C0D0A23';
wwv_flow_api.g_varchar2_table(38) := '6E6176206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E7520756C2C0D0A236E6176206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E7520756C2C0D0A236E6176206C';
wwv_flow_api.g_varchar2_table(39) := '6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E7520756C0D0A7B706F736974696F6E3A6162736F6C7574653B206C6566743A2D3939393970783B20746F70';
wwv_flow_api.g_varchar2_table(40) := '3A2D3939393970783B2077696474683A303B206865696768743A303B206D617267696E3A303B2070616464696E673A303B206C6973742D7374796C653A6E6F6E653B7D0D0A0D0A236E6176206C693A686F766572206C693A686F76657220612E666C792C';
wwv_flow_api.g_varchar2_table(41) := '0D0A236E6176206C693A686F766572206C693A686F766572206C693A686F76657220612E666C792C0D0A236E6176206C693A686F766572206C693A686F766572206C693A686F766572206C693A686F76657220612E666C792C0D0A236E6176206C693A68';
wwv_flow_api.g_varchar2_table(42) := '6F766572206C693A686F766572206C693A686F766572206C693A686F766572206C693A686F76657220612E666C790D0A2F2A236E6176206C6920756C2E73686F776D656E75206C6920612E666C792C0D0A236E6176206C6920756C2E73686F776D656E75';
wwv_flow_api.g_varchar2_table(43) := '206C6920756C2E73686F776D656E75206C692020756C2E73686F776D656E7520612E666C792C0D0A236E6176206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920612E666C792C0D';
wwv_flow_api.g_varchar2_table(44) := '0A236E6176206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920612E666C792A2F0D0A7B6261636B67726F756E643A23336639366139207572';
wwv_flow_api.g_varchar2_table(45) := '6C2823504C5547494E5F505245464958236172726F775F6F7665722E6769662920313230707820367078206E6F2D7265706561743B20636F6C6F723A236666663B20626F726465722D636F6C6F723A236666663B7D200D0A0D0A236E6176206C6920756C';
wwv_flow_api.g_varchar2_table(46) := '2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920612E666C792C0D0A236E6176206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920612E666C792C0D0A236E61';
wwv_flow_api.g_varchar2_table(47) := '76206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920756C2E73686F776D656E75206C6920612E666C790D0A7B6261636B67726F756E643A234346453046312075726C2823504C55';
wwv_flow_api.g_varchar2_table(48) := '47494E5F505245464958236172726F772E67696629203830707820367078206E6F2D7265706561743B20636F6C6F723A233030303B20626F726465722D636F6C6F723A234346453046313B7D200D0A2F2A2A2F';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 15818012079122669 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_file_name => 'pro_dropdown_3jw.css'
 ,p_mime_type => 'text/css'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '47494638396104000700800000FFFFFF00000021F90401070000002C00000000040007000002080C1E0669ECAB1428003B';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 3887845738485531296 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_file_name => 'arrow.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '47494638396104000700800000FFFFFFFF000021F90401070001002C0000000004000700000208440E1669ECAB5428003B';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 3887848136329532297 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_file_name => 'arrow_over.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '4749463837612C0123004400002C000000002C012300841A1C1D181A1B181A1C191B1C94959517191A8182828788887B7C7D6F70707576779A9A9A9798988F90908B8C8CC1C2C2696A6A17191B191B1D17181A1213141618193A3C3D6262626465665E5E';
wwv_flow_api.g_varchar2_table(2) := '5F52545457595900000000000000000000000005FFE0258E64699E68AAAE6CEBBE702CCF746DDFF8A3EF7CEFFFC0A070482C1A8FC8A472C96C3A9FD085744AAD5AAFD8AC76CBED7ABFE0B0784C2E9BCF68867ACD6EBBDFF0B87C4EAFDBEFF8BC7ECFEFFB';
wwv_flow_api.g_varchar2_table(3) := 'FF800482838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2850DA5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABB0EBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D307D5D6D7D8D9DADBDCDDDEDFE0E1E2';
wwv_flow_api.g_varchar2_table(4) := 'E3E4E5E6E7E8E9EAEB06EDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF00030A1C88A0A0C18308132A5CC8B0A1C38710234A9C48B1A2C58B18336ADCA8A0A3C78F20438A1C49B2A4C9932853FFAA5CC9B2A5CB973063CA9C99A0A6CD9B3873EADCC9B3A7';
wwv_flow_api.g_varchar2_table(5) := 'CF9F40830A1D4AB4A8D1A348932A5D0AA1A9D3A750A34A9D4AB5AAD5AB58B36ADDCAB5ABD7AF60C38A1D8BA1ACD9B368D3AA5DCBB6ADDBB770E3CA9D4BB7AEDDBB78F3EADD9BA1AFDFBF80030B1E4CB8B0E1C388132B5ECCB8B1E3C790234B9EBCA1B2E5';
wwv_flow_api.g_varchar2_table(6) := 'CB98336BDECCB9B3E7CFA0438B1E4DBAB4E9D3A853AB5EADA1B5EBD7B063CB9E4DBBB6EDDBB873EBDECDBBB7EFDFC0830B1F6EA1B8F1E3C8932B5FCEBCB9F3E7D0A34B9F4EBDBAF5EBD8B36BDF0EA0BBF7EFE0C38B1F4FBEBCF9F3E8D3AB5FCFBEBDFBF7';
wwv_flow_api.g_varchar2_table(7) := 'F0E3CB9F4FBFBEFDFBF8F3EBDFCFBFBFFFFF000628E080040A28C1810826A8E0FF820C36E8E083104628E184145668E1851866A8E1861C7638C087208628E288249668E28928A6A8E28A2CB6E8E28B30C628E38C34D668E38D38E6A8E38E3CF6E8E38F22';
wwv_flow_api.g_varchar2_table(8) := '0A20E490441669E4914826A9E4924C36E9E493504629E594545669E5955866A9E5965C76E9E5976086296691019469E69968A6A9E69A6CB6E9E69B70C629E79C74D669E79D78E6A9E79E7CF6E9E79F80062AE8A084168A66048826AAE8A28C36EAE8A390';
wwv_flow_api.g_varchar2_table(9) := '462AE9A494566AE9A59866AAE9A69C76EA6901A0862AEAA8A4966AEAA9A8A6AAEAAAACB6EAEAABB0C62AEBACB4D66AEBADB8E6AAEBAEBCF6EAEBAFC08E3AC1B0C4166BECB1C826ABECB2CC36EBECB3D0462BEDB4D4566BED41B5D8665BC1B6DC76EBEDB7';
wwv_flow_api.g_varchar2_table(10) := 'E0862BEEB8E4966BEEB9E8A6ABEEBAECB6EBEEBBF0C64BC1BCF4D66BEFBDF8E6ABEFBEFCF6EBEFBF00072CF0C004176CF0C108271C02003B';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 3887850333525533512 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_file_name => 'three_0.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '4749463839612C012300C40000C1C2C29A9A9A9798989495958F90908B8C8C8788888182827B7C7D7576776F7070696A6A6465666262625E5E5F5759595254543A3C3D1A1C1D191B1C191B1D181A1C181A1B17191A17191B16181917181A121314000000';
wwv_flow_api.g_varchar2_table(2) := '00000000000000000021F904000700FF002C000000002C0123000005FF60238E64699E68AAAE6CEBBE702CCF746DDF38A0EF7CEFFFC0A070482C1A8FC8A472C96C3A9FD080744AAD5AAFD8AC76CBED7ABFE0B0784C2E9BCF68817ACD6EBBDFF0B87C4EAF';
wwv_flow_api.g_varchar2_table(3) := 'DBEFF8BC7ECFEFFBFF800382838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A28504A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABB05BDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D306D5D6D7D8D9DA';
wwv_flow_api.g_varchar2_table(4) := 'DBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEB07EDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF00030A1C88A0A0C18308132A5CC8B0A1C38710234A9C48B1A2C58B18336ADC98A0A3C78F20438A1C49B2A4C9932853FFAA5CC9B2A5CB973063CA9CA9A0A6CD';
wwv_flow_api.g_varchar2_table(5) := '9B3873EADCC9B3A7CF9F40830A1D4AB4A8D1A348932A5DBAA0A9D3A750A34A9D4AB5AAD5AB58B36ADDCAB5ABD7AF60C38A1DCBA0ACD9B368D3AA5DCBB6ADDBB770E3CA9D4BB7AEDDBB78F3EADDEBA0AFDFBF80030B1E4CB8B0E1C388132B5ECCB8B1E3C7';
wwv_flow_api.g_varchar2_table(6) := '90234B9EFCA0B2E5CB98336BDECCB9B3E7CFA0438B1E4DBAB4E9D3A853AB5E0DA1B5EBD7B063CB9E4DBBB6EDDBB873EBDECDBBB7EFDFC0830B87FDE37684E3C8932B5FCEBCB9F3E7D0A34B9F4EBDBAF5EBD8B36BDFCE7D790FE912C28B1F4FBEBCF9F3E8';
wwv_flow_api.g_varchar2_table(7) := 'D3AB5FCFBEBDFBF7F0E3CB9F4FBFBE7DF33BEEEBDFCFBFBFFFFF000628207B000C68E0810826A8E0FF820CBA47C183104628E184145668E1851866A8E1861C76E8E187208628E288249638C18928A6A8E28A2CB6E8E28B30C628E38C34D668E38D38E6A8';
wwv_flow_api.g_varchar2_table(8) := 'E38E3CF6E8E38F400629E490441669E4912A56A0E4924C36E9E493504629E594545669E5955866A9E5965C76E9E597608629E698649669E69968A6A9669316B4E9E69B70C629E79C74D669E79D78E6A9E79E7CF6E9E79F80062AE8A084166AE8A18826AA';
wwv_flow_api.g_varchar2_table(9) := 'E8A28C360A270690462AE9A494566AE9A59866AAE9A69C76EAE9A7A0862AEAA8A4966AEA05A8A6AAEAAAACB6EAEAABB0C62AEBACB4D66AEBADB8E6AAEBAEBCF6EAEBAFC0062BECB0C4166BECB1C8AEAAC1B2CC36EBECB3D0462BEDB4D4566BED4BB5D866';
wwv_flow_api.g_varchar2_table(10) := 'ABEDB6DC76EBEDB7E0869BC1B8E4966BEEB9E8A6ABEEBAECB6EBEEBBF0C62BEFBCF4D66BEFBDF8E6BBC1BEFCF6EBEFBF00072CF0C004176CF0C10827ACF0C20C37ECF0C310471C02003B';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 3887851831369534581 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_file_name => 'three_0a.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '4749463837612C0123007700002C000000002C012300873333334CA1B2626262121314C1C2C235373818768E19778F116F8A1B788F0060A40000000D5C6C2B869A207B922781970B4F800B4E5B0B4E6E0B515A0B4D970B4E630B50850B4E690B505A0B4F';
wwv_flow_api.g_varchar2_table(2) := '740B4E8E0B4F890B4F7B4CA1B1449CAD328AA03F96A93990A450B5D0328A9F3F96A83990A3449CAC50B5CF4BA0B10C4E690C4E6E0C4E630C50850C4F740C4F800C4F7B0C4D970C4E8E0C4F890C515A0B4D5A0B4F590C4E5B0B4D620C505A0B50594FB4CF';
wwv_flow_api.g_varchar2_table(3) := '3E95A8388FA30B4E7A0B4D8D0B4F84318A9F0B4E7F0B4E88439BAC0B4D6D0B4E730B4C960B4D680B4E80207B912781962B86990D5B6C0B4D690B4D8E0B4E890B4E740B4E7B0B4F850B4C970B4D6E1618191A1C1D383838383A3B4DB2CC36383917191A17';
wwv_flow_api.g_varchar2_table(4) := '181A36383A181A1C191B1C181A1BB2B3B3B5B6B637393A9495958788889A9A9A005FA40A4C960A4E730A5059010101439BAD0A4D620A4D680A4D6D0303030404040A4D8D4EB3CD0C5B6C1A778F1F7A912A859931899F2680960A4D5A3636360A4F590A4E';
wwv_flow_api.g_varchar2_table(5) := '880A4E7A0A4E7F1D1D1D0A4F848182824DB1CA4DB0CA4EB3CE4FB4CE828384A5A6A6020202A9AAAA060606050505045D77035D7B055C729FA0A0999A9B17191B373737353739191B1D3535353434343A3C3DADAEAE3A3A3A37393B3939397B7C7D7C7C7D';
wwv_flow_api.g_varchar2_table(6) := '757777707272757677035E808D8E8E8B8C8C8F9090035F86939495525454575959525252979898515151646566696A6A6F7070585A5B5E5E5F44A5BA48ADC748ACC74DB2CD4DB2CB40A5C040A4C044A9C344A8C3035F8B005F9E136D7F035F8A005F9F00';
wwv_flow_api.g_varchar2_table(7) := '609300609401608F016090126D7F00486E065C6B1E1E1E00486C075C6B095F6A0A5F6A085E6A095E6A0060973297B33398B32D91AD2E92AD369BB73BA0BC44A4B9379CB73B9FBC2A8EA82184A12285A10060980060A5268AA5288CA6298DA8278BA5278B';
wwv_flow_api.g_varchar2_table(8) := 'A600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008FF0005081C48B0A0';
wwv_flow_api.g_varchar2_table(9) := 'C18308132A5CC8B0A1C38710234A9C48B1A2C58B180968DCC8B1A3C78F20438A1C49B2A4C9932853AA5CC9B2A5CB9730CD9811A34A13809B3873EADCC9B3A7CF9F40830A1D4AB4A8D1A348932A5DCA14C0A54B962CED993A69D2952B9C3869522546E62A';
wwv_flow_api.g_varchar2_table(10) := '31ACAAD91241B6ACD9B368D3AA5DCB96AD0E1D27E09E984BB76E5CB872EDDA6DCB77EDDBB87A030B16FC36EFE0137D139F2D7CB831E1BF8E158B28ACC390A14285E668AE95A5736759ACC4AC2213E6CAA000A853AB5ECDBAB5EBD7B063A340D1817687DB';
wwv_flow_api.g_varchar2_table(11) := 'B873D7A66D5BB7EED8C05FCFAEEDBBB871E3B37B1FEF10BCF9EAE4CBA3231F2EDDB975D484AE842143DAF4F5EFE0810FFF573E9D78F4F0E2794B5F9F1B7A75F4B0DDB35F2F7F39FCD8D9B797CA04609687FF000628E080041668E081080E3184090B9AE0';
wwv_flow_api.g_varchar2_table(12) := 'E0831032B86083114688E085062AC860851C76D8A182147A680286240A08A288287EA8618A257AC0C68B24D2024026A590A20800B980A0E38E3CF6E8E38F400629E4903BEC4082912424A9E492471A8924934C0E296590451E09E595586259E493599230';
wwv_flow_api.g_varchar2_table(13) := 'E5973D6ED9E5985A564926982088492609BA00A00829652002C02D21D469E79D78E6A9E79E7CF6E9270F3C9410680984166AA8A0810E7AE8A17E36CA27A0822E2AE9A49302AA28A52538AA299E9662EA69A5907EBA69089D7E5A022E0020528620900040';
wwv_flow_api.g_varchar2_table(14) := 'CD07B0C6FF2AEBACB4D66AEBADB8E60A041023F03AC2AFC006DB2BAFBE0A2B6CAEC8DEBA6BAFC636EBACB3BB16FBEC08C9563B6BB4D3660BEDB2DA5AFB011EE06AFBEB3500402248279100604D03ECB6EBEEBBF0C62BEFBCF4D66BEFBDF8E6ABEFBEFCF6';
wwv_flow_api.g_varchar2_table(15) := 'EBEFBF00037CC7C04B146CF0C1074F0340249D84720A00D03C20F1C414576CF1C51867ACF1C61C77ECF1C720872CF2C824976CB2C979A4ACC4CA2CB7DCF233009C12CA2BA300208D0338E7ACF3CE3CF7ECF3CF40072DF4D044176DF4D14827ADF4D24C33';
wwv_flow_api.g_varchar2_table(16) := '6DC7D349442DF5D4534703C028AFB8520600D824E0F5D760872DF6D864976DF6D968A7ADF6DA6CB7EDF6DB70C72DB7DC75D4ADF6370094E14A2B8700FFE0CD0180072EF8E084176EF8E18827AEF8E28C37EEF8E390472EF9E49457EE7838001CD24A2C9E';
wwv_flow_api.g_varchar2_table(17) := '00008E01A0872EFAE8A4976EFAE9A8A7AEFAEAACB7EEFAEBB0C72EFBECB4D7EE7A370078124B2A9F00A00D02C0072FFCF0C4176FFCF1C827AFFCF2CC37EFFCF3D0472FFDF4D457EF7C36007C920A2AA000D00B03E0872FFEF8E4976FFEF9E8A7AFFEFAEC';
wwv_flow_api.g_varchar2_table(18) := 'B7EFFEFBF0C72FFFFCF4D34FC7FD4CE4AFFFFEFB13030028A8C0042C00B08C0918F080084CA00217C8C0063AF08139C8C1042408410952F08118CCA0022338C10CCEE083200CA1086710C10B6AF084192CA10747C8C20FAA10851854830C4B48C31A4650';
wwv_flow_api.g_varchar2_table(19) := '1900800526AC800500340303400CA210FF8748C4221AF188484C620D6A8001262A91894E4CA214A748C42536718A38C8A216B7C8451C2C318A540CE314BF88C52E9A318B6414A314F9C0C62FBAF18D4B640600B060051E02201911C8A31EF7C8C73EFAF1';
wwv_flow_api.g_varchar2_table(20) := '8F800CA42069408308147290853CA42017C9C83E12D2908CB481242749C94ADA80908A6CA4261989C9485AF29392ECE42617A9875262F294A824A431E658C71E3EA202B08CA52C6749CB5ADAF296B8CCE50D6E50015EEA9297BECCA5308749CB5DF67298';
wwv_flow_api.g_varchar2_table(21) := '2B48A63297C9CC15EC3298C48CE6309F89CC665A3399D494A630DBC0CD677AF39BBB7C042B2BB1090034E202E84CA73AD7C9CE76BAF39DF08CE7118E70017ACA939EF68CA73EF7C9FFCE79D6739F2908A840074AD014CC339FFC4CE83E0F0AD0823A34A0';
wwv_flow_api.g_varchar2_table(22) := '0C55A83EDD40D12658F4A218C5682300B0894A7C610C00708404464AD2929AF4A4284DA94A57CA52221041022F6DE94B63CAD29ADAF4A42E85A94D55C0D39EFAF4A72A70294D6F4A549B0A75A7404D2A4F8F5AD49ABEE1A95488AA54A73A554700600C5F';
wwv_flow_api.g_varchar2_table(23) := 'F82800449181AE7AF5AB600DAB58C74AD6B29AB50845C8405ACF9AD6B59AF5AD700D2B5AD50AD716D8F5AE78CD6B0BD0EAD6B8FA15AE7CADAB5E076BD7C0FEF5AD69482C1416CBD8C636561457FD8217BA00005370E0B298CDAC6637CBD9CE7AF6B3A0ED';
wwv_flow_api.g_varchar2_table(24) := '410F3830DAD08EB6B4A04DAD6A372B5AD2AAF605B08DAD6C67FB02D1FFA276B5B855AD6D5F4BDBDEC276B7B94DAD1F861B85E21AF7B8C7350500BAE085C90260171088AE74A74BDDEA5AF7BAD8CDAE76831004087477BBDDFDAE76C74BDEEA72D7BBE475';
wwv_flow_api.g_varchar2_table(25) := '817AD7CBDEF6BA80BBE22DAF7CC90BDFF4BAF7BEEAADEF7CC7FB87FE22E1BF000E70807DB15C2F80410B0018860516CCE0063BF8C1108EB084274CE11FFCC00217AEF085334CE10E7BF8C116C6B0875940E2129BF8C42CB030873FCC620FAB78C4288E31';
wwv_flow_api.g_varchar2_table(26) := '895FDCE20E07E2C652C8B18E77BC636100400B6038300082B181221BF9C8484EB29297CCE4263B590842D840949F1CE5293BF9CA584E3294A58C651978F9CB600EB30CA06CE52C9B19CB64EEB298D7ECE5349FF9FFCA7D88F313E64CE73AD719183F0683';
wwv_flow_api.g_varchar2_table(27) := '242801806D68E0CF800EB4A0074DE8421BFAD088F6810F34B0E8442FBAD1888EB4A407AD68464B3A0698CEB4A6371D0345437AD2A096B4A72FCDE952637AD4A18EB41C56ED8456BBFAD5AF7606002821892D140000BFA080AE77CDEB5EFBFAD7C00EB6B0';
wwv_flow_api.g_varchar2_table(28) := '876D042350C0D8C43636B287CDEC66FBBAD8C76E360CA64DED6A5B1B06C55EB6B3B7DDEC6C4BFBDAE09EB6B7B9CD6C34987B0AE84EB7BAD5CD0B0014600BB63E06321440EF7ADBFBDEF8CEB7BEF7CDEF7EFBFBDF000FB8C0074EF0821BFCE00847F81916';
wwv_flow_api.g_varchar2_table(29) := 'FE6F6E140310EFE602170A0088452CE0E218CFB8C637CEF18E7BFCE3200FB9C8474EF2929BFCE428624FB9CA57CEF205ACE1E58948041C661E879A3382118B80B8C4ABC0F302F8FCE7400FBAD0874EF4A21BFDE8484FBAD297CEF4A63BFDE9508FBAD4A7';
wwv_flow_api.g_varchar2_table(30) := 'EE749E57610058CFBAD6B7CEF5AE7BFDEB600FBBD8C74EF6B29BFDEC684FBBDAD7CEF6B6BB3D20003B';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 3887906612163558629 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_file_name => 'three_1.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '4749463839612C012300F70000FFFFFFC1C2C2B5B6B6B2B3B3ADAEAEA9AAAAA5A6A650B5CF50B5D04FB4CF4FB4CE9FA0A04EB3CE4EB3CD4DB2CD4DB2CB4DB2CC4DB1CA4DB0CA9A9A9A48ADC7999A9B48ACC797989844A9C394959544A8C393949540A5C0';
wwv_flow_api.g_varchar2_table(2) := '44A4B944A5BA40A4C04CA1B24CA1B14BA0B18F90908D8E8E3BA0BC8B8C8C3B9FBC449CAC449CAD439BAD439BAC379CB7878888369BB73F96A83398B33F96A93297B33E95A88283848182823990A43990A32E92AD388FA32D91AD7C7C7D7B7C7D2A8EA829';
wwv_flow_api.g_varchar2_table(3) := '8DA8288CA6328AA0328A9F318A9F278BA6278BA531899F757777268AA57576772B86992B869A2A85997072722285A12184A12781976F7070278196268096696A6A207B92207B911F7A911B788F64656619778F1A778F18768E6262625E5E5F116F8A136D';
wwv_flow_api.g_varchar2_table(4) := '7F126D7F585A5B5759595254545252525151510060A50060A4006093005F9F005F9E00609700609801608F006094005FA4016090035F86035F8A035F8B0A5F6A095F6A035E80095E6A035D7B0D5C6C085E6A0D5B6C055C72045D770C5B6C075C6B065C6B';
wwv_flow_api.g_varchar2_table(5) := '0C50850B50850B4D970C4F800B4E8E0B4E890C4F890B4F890A4F840B4F800B4F840B4F850C4E8E0C4D970A4E7F0A4E880B4E7F0B4E800B4E880B4F7B0A4C960A4D8D0C4F740B4C960B4C970B4D8D0B4D8E0B4F740C4F7B0B515A0B505A0A4E7A0C505A0C';
wwv_flow_api.g_varchar2_table(6) := '4E6E0B4E730B4E7B0B4E6E0B4E740B4E7A0C515A0A4E730B4D6D0B4D6E0A4D6D0B4F590A50590B4E690A4F590C4E690C4E630B50590B4E630C4E5B0B4D690A4D680A4D620B4D680B4D620B4E5B0A4D5A0B4D5A00486E3A3C3D00486C3A3A3A383A3B3939';
wwv_flow_api.g_varchar2_table(7) := '3938383837393B37393A36383936383A3737373537383636363537393535353434343333331E1E1E1D1D1D1A1C1D191B1D191B1C181A1C181A1B17191B17191A16181917181A121314060606050505040404030303020202010101000000000000000000';
wwv_flow_api.g_varchar2_table(8) := '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000021F904000700FF002C000000002C0123000008';
wwv_flow_api.g_varchar2_table(9) := 'FF00B9081C48B0A0C18308132A5CC8B0A1C38710234A9C48B1A2C58B180368DCC8B1A3C78F20438A1C49B2A4C9932853AA5CC9B2A5CB9730274C104026D8B39B3873EADCC9B3A7CF9F40830A1D4AB4A8D1A348932A5DCA54E7B2A750970D9B4A4680CC99';
wwv_flow_api.g_varchar2_table(10) := '653A3C40C0B5ABD7AF60C38A1D4BB66CD70368D3AA5DCBB6ADD9B765DBCA9DBB36815DBA69E1EAED6A3701DEBF6CFB02DEDBB7708206881B4058BCD843190117320C20160184E5CB98336BDECCB9B3E7CF9843881E4DBAB4E9D3A0537F3ECDBA756911B0';
wwv_flow_api.g_varchar2_table(11) := '5D8F564DFB326C11B2739BBEADBBB66F09C40664904CD9B7F1E3B5752B0F813CF972DDBC7337FF1CFDB9ECEAAEA77F062E7C048167145288FF1F4FBEBCF9F3E8D3AB5F4F1E85FBF7F0E3CB9FCFBEFEFAF9F8F3C75FC15FFF7BFB008EC7DF0AFE1528DF80';
wwv_flow_api.g_varchar2_table(12) := '0606A8C282F659F00C01239850C03318C460E1851866A8E1861C76E8E18718BE20E288249668E28920A6F8E1892CB658E20C30BA38A28A345E08E30C32E668E28D3AD6C8A38E1A3C5380092D18F00C073624A9E4924C36E9E493504629E592375469E595';
wwv_flow_api.g_varchar2_table(13) := '5866A9E5945C4AA9E597606299C398615AD9E5994A8E9943996C66A9669B68BED9E607CF18D0420D0B3C5302107CF6E9E79F80062AE8A08416EA67108826AAE8A28C366AE8A385362AE9A48B0A6129A58942AA699F960A81E9A78C760AEAA645940A6A10';
wwv_flow_api.g_varchar2_table(14) := '273CB3400D3C54F00C0B4AC4FF2AEBACB4D66AEBADB8E6AAEBAEBCF6EAEBAFC0062BECB0C4165BEC12C826A1ECB2CC32EBC23315F080C406CFC0F0C4B5D866ABEDB6DC76EBEDB7E0862BEEB8E4966BEEB9E8A6ABEEBAEB4AE16E14F0C62BAFBC323CB301';
wwv_flow_api.g_varchar2_table(15) := '125090F00C0E54F4EBEFBF00072CF0C004176CF0C10827ACF0C20C37ECF0C310471CB115145761F1C51863ACC333244031450BCFF470C5C824976CF2C928A7ACF2CA2CB7ECF2CB30C72CF3CC34D76CF3CD376BA1F3CB3E3CD3C21458D0F0CC0F59146DF4';
wwv_flow_api.g_varchar2_table(16) := 'D14827ADF4D24C37EDF4D350472DF5D454576DF5D55867ADF5D4433C4303165DECF00C115B946DF6D968A7ADF6DA6CB7EDF6DB70C72DF7DC74D76DF7DD78E7ADF7DC473CFFB343176218F14C135E146EF8E18827AEF8E28C37EEF8E390472EF9E494576E';
wwv_flow_api.g_varchar2_table(17) := 'F9E59867AEF9E44E3C6384186330F1CC1779946EFAE9A8A7AEFAEAACB7EEFAEBB0C72EFBECB4D76EFBEDB8E7AE7B1E00F4EE3B007B042F7CF0603CC3C418BF84F10C1D9E34EFFCF3D0472FFDF4D4576FFDF5D867AFFDF6D6A3E2FDF7E0878FCA2CE4736F';
wwv_flow_api.g_varchar2_table(18) := '7EF5E4CF82BDF8EC7F9FFEF9D5BB22FFEF00A46F3FF9753C13C62FD208F3CC1D9F08A0000748C0021AF080084CA00217C8C0063AF0810A0C85042748C10A86A2151884A0061388C15630D082209C600737984058981016BEEBA00A3BA8876708431AFD7B';
wwv_flow_api.g_varchar2_table(19) := 'C61F7641C31ADAF08638CCA10E77C8C31EFAF087400CA210FF7B588B221AF18848AC452F9638C426F27089BDF86112A76844283A9187BCC862160100C52E7611102E84A1FFF8408B329AF18C684CA31AD7C8C636BAF18D708CA31CE7E84659D8F18E78CC';
wwv_flow_api.g_varchar2_table(20) := 'A32C74C1473AFAB18D7CD4051CF548C83B06F28F6DC4852203C9C846F2910F619446319ED1875758F29298CCA42637C9C94E7AF293A00CA5284749CA4FC6E294A84CA52A63918B5696F2959E6C652E42B9CA5AA25296B0F4E42D76698B5EFAF297BFECC3';
wwv_flow_api.g_varchar2_table(21) := '338A318D6918E3197828853297C9CC663AF399D08CA634A749CD6A5AF39AD89CA628B6C9CD6E7A5314AA086736C729CD70AAA29ADF4C2737CD494E69B2E29DAB88A73CE7394F3C3CC318D4A0C631EDC0FF897EFAF39F000DA840074AD0821AF4A0084DA8';
wwv_flow_api.g_varchar2_table(22) := '42176AD04B38F4A1108DE825464151865AB4A0141D054225CAD18766F4A2054D85484D41D2929AD4A476B8673E91F18C3850E2A5308DA94C674AD39ADAF4A638CDA94E77CAD39EE2B413400DAA5087DA895318D5A748BDA9514FA153A23A35A84B4DEA4D';
wwv_flow_api.g_varchar2_table(23) := '4141555258F5AA58C56A1C9E818C6A5483A573508458C74AD6B29AF5AC684DAB5AD7CAD6B6BAF5AD705D2B21E64AD7BADA951091C86B5CF7AAD6BC46A2AD770D2C5DFDCA57B53EE2B09248AC6217BB583970D5ABC778061C0441D9CA5AF6B298CDAC6637';
wwv_flow_api.g_varchar2_table(24) := 'CBD9CE7AF6B3A00DAD683B1B88D29AF6B4A80DC422563BDAD67276B58BF86C6A676B5AD8FFBA96B389C82D2376CBDBDEF6B60DCF388635AC11593720E2B8C84DAE7297CBDCE63AF7B9D08DAE74A74BDDEA42F710D8CDAE76B77B884978D7BAE07DAE7727';
wwv_flow_api.g_varchar2_table(25) := '215DEE9A37BBE30DEF7321C15E43B8F7BDF0852F1A823B5C663C830D85C8AF7EF7CBDFFEFAF7BF000EB080074CE0021BF8C0026E848217CCE0063742131046B084030C614D10D8C1185E7085271C604B787813200EB18845BC866730E31AD750C633D230';
wwv_flow_api.g_varchar2_table(26) := '8816BBF8C5308EB18C674CE31ADBF8C638CEB18E776C6347F8F8C7400EB2233041641E1BB9C644C6048E85CCE41F27F9C835AE84943341E52A5BD9CA6A788632B0810D654003186708B398C74CE6329BF9CC684EB39AD7CCE636BBF992CD708EB39CE74C';
wwv_flow_api.g_varchar2_table(27) := 'E73AD7F90D786EB32FA2B1652E2B231ADC1087A0074DE8421BFAD0884EB4A217CDE8463BFAD1908EB4A4274DE94A5BFAD2E20887A635FD8D4E7BE3D3A0E6B336B4918D522BE3D4A84EB5AA57CDEA56BBFAD5B08EB5AC674DEB5ADBFAD6B8CEB5AE77CDEB';
wwv_flow_api.g_varchar2_table(28) := '5B973A1BDB08B6B0874DEC621BFBD8C84EB6B297CDEC663BFBD9D08EB6B4A74DED6A5BFBDA0101003B';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 3887909210006559640 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 3887661924936460108 + wwv_flow_api.g_id_offset
 ,p_file_name => 'three_1a.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

--application/shared_components/plugins/dynamic_action/com_oracle_apex_timer
 
begin
 
wwv_flow_api.create_plugin (
  p_id => 4037132680479198394 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'DYNAMIC ACTION'
 ,p_name => 'COM.ORACLE.APEX.TIMER'
 ,p_display_name => 'Timer'
 ,p_category => 'INIT'
 ,p_supported_ui_types => 'DESKTOP'
 ,p_image_prefix => '#PLUGIN_PREFIX#'
 ,p_plsql_code => 
'function render_timer ('||unistr('\000a')||
'    p_dynamic_action  in apex_plugin.t_dynamic_action,'||unistr('\000a')||
'    p_plugin          in apex_plugin.t_plugin )'||unistr('\000a')||
'    return apex_plugin.t_dynamic_action_render_result'||unistr('\000a')||
'is'||unistr('\000a')||
'    l_action     varchar2(10) := nvl(p_dynamic_action.attribute_01, ''add'');'||unistr('\000a')||
'    l_timer_name varchar2(20) := substr(nvl(case l_action'||unistr('\000a')||
'                                              when ''add''    then p_dynamic_action.'||
'attribute_02'||unistr('\000a')||
'                                              when ''remove'' then p_dynamic_action.attribute_03'||unistr('\000a')||
'                                            end, p_dynamic_action.id), 1, 20);'||unistr('\000a')||
'    l_expire_in  number       := nvl(p_dynamic_action.attribute_04, 1000);'||unistr('\000a')||
'    l_occurrence varchar2(10) := nvl(p_dynamic_action.attribute_05, ''infinite'');'||unistr('\000a')||
''||unistr('\000a')||
'    l_result apex_plugin.t_dynamic_action_render_result;'||
''||unistr('\000a')||
'begin'||unistr('\000a')||
'    apex_javascript.add_library ('||unistr('\000a')||
'        p_name      => ''com_oracle_apex_timer.min'','||unistr('\000a')||
'        p_directory => p_plugin.file_prefix,'||unistr('\000a')||
'        p_version   => null );'||unistr('\000a')||
''||unistr('\000a')||
'    l_result.javascript_function := ''com_oracle_apex_timer.init'';'||unistr('\000a')||
'    l_result.attribute_01        := l_action;'||unistr('\000a')||
'    l_result.attribute_02        := l_timer_name;'||unistr('\000a')||
'    l_result.attribute_03        := l_expire_in;'||unistr('\000a')||
'    l_result.attrib'||
'ute_04        := l_occurrence;'||unistr('\000a')||
'    return l_result;'||unistr('\000a')||
'end render_timer;'
 ,p_render_function => 'render_timer'
 ,p_standard_attributes => 'ITEM:REGION:DOM_OBJECT:JQUERY_SELECTOR:TRIGGERING_ELEMENT:EVENT_SOURCE:REQUIRED'
 ,p_substitute_attributes => true
 ,p_subscribe_plugin_settings => true
 ,p_help_text => '<p>'||unistr('\000a')||
'	&nbsp;</p>'||unistr('\000a')||
'<div id="cke_pastebin">'||unistr('\000a')||
'	This plug-in is a dynamic action which allows to periodically fire other dynamic actions in the browser.&nbsp;For example to refresh a region. But you can perform any action you want, because the plug-in just provides&nbsp;the infrastructure so that you can hook up your own actions which you want to execute periodically.</div>'||unistr('\000a')||
'<div>'||unistr('\000a')||
'	&nbsp;</div>'||unistr('\000a')||
'<ol>'||unistr('\000a')||
'	<li>'||unistr('\000a')||
'		Create a dynamic action with the &quot;Timer&quot; plug-in which sets up the periodic timer</li>'||unistr('\000a')||
'	<li>'||unistr('\000a')||
'		Create a dynamic action for the event &quot;Timer Expired [Plug-in]&quot; where you execute your periodic actions.</li>'||unistr('\000a')||
'</ol>'||unistr('\000a')||
''
 ,p_version_identifier => '1.0'
 ,p_about_url => 'http://www.oracleapex.info/'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 4037133183726208771 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 4037132680479198394 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 1
 ,p_display_sequence => 10
 ,p_prompt => 'Action'
 ,p_attribute_type => 'SELECT LIST'
 ,p_is_required => true
 ,p_default_value => 'add'
 ,p_is_translatable => false
 ,p_help_text => 'Specify if you want to <strong>add</strong> or <strong>remove</strong> a timer. If you add a timer with the same name again, the existing one will be removed and created again. If you remove an existing timer, you have to specify a name when you add the timer so that you are able to identify it when you remove it.'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 4037133791692211050 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 4037133183726208771 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 10
 ,p_display_value => 'Add Timer'
 ,p_return_value => 'add'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 4037134178317216724 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 4037133183726208771 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 20
 ,p_display_value => 'Remove Timer'
 ,p_return_value => 'remove'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 4037134491570277309 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 4037132680479198394 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 2
 ,p_display_sequence => 20
 ,p_prompt => 'Timer Name'
 ,p_attribute_type => 'TEXT'
 ,p_is_required => false
 ,p_display_length => 20
 ,p_max_length => 20
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 4037133183726208771 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'EQUALS'
 ,p_depending_on_expression => 'add'
 ,p_help_text => 'If you want to remove a timer with the "Remove Timer" action you have to specify a name for the timer when you create it. If you just want to create a timer you don''t have to specify a timer name.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 4037134979580283299 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 4037132680479198394 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 3
 ,p_display_sequence => 30
 ,p_prompt => 'Timer Name'
 ,p_attribute_type => 'TEXT'
 ,p_is_required => true
 ,p_display_length => 20
 ,p_max_length => 20
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 4037133183726208771 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'EQUALS'
 ,p_depending_on_expression => 'remove'
 ,p_help_text => 'Name of the timer you want to remove. Use the same name you used when you created the timer.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 4037135475686301036 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 4037132680479198394 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 4
 ,p_display_sequence => 40
 ,p_prompt => 'Expire in x Milliseconds'
 ,p_attribute_type => 'INTEGER'
 ,p_is_required => true
 ,p_display_length => 10
 ,p_max_length => 10
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 4037133183726208771 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'EQUALS'
 ,p_depending_on_expression => 'add'
 ,p_help_text => 'Specify the number of milliseconds after which the timer should expire. There are 1000 milliseconds in one second.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 4037135964389307245 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 4037132680479198394 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 5
 ,p_display_sequence => 50
 ,p_prompt => 'Occurrence'
 ,p_attribute_type => 'SELECT LIST'
 ,p_is_required => true
 ,p_default_value => 'infinite'
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 4037133183726208771 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'EQUALS'
 ,p_depending_on_expression => 'add'
 ,p_help_text => 'Specify how often the timer should fire. The timer can be fired just <strong>once</strong> or <strong>infinite</strong> until you remove it with the "Remove Timer" action.'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 4037136572701309672 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 4037135964389307245 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 10
 ,p_display_value => 'Once'
 ,p_return_value => 'once'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 4037136977895311169 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 4037135964389307245 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 20
 ,p_display_value => 'Infinite'
 ,p_return_value => 'infinite'
  );
wwv_flow_api.create_plugin_event (
  p_id => 4037132965026203415 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 4037132680479198394 + wwv_flow_api.g_id_offset
 ,p_name => 'timer_expired'
 ,p_display_name => 'Timer Expired'
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '636F6D5F6F7261636C655F617065785F74696D65723D7B6372656174656454696D6572733A7B7D2C696E69743A66756E6374696F6E28297B76617220613D746869732E616374696F6E2E61747472696275746530312C663D746869732E616374696F6E2E';
wwv_flow_api.g_varchar2_table(2) := '61747472696275746530322C653D7061727365496E7428746869732E616374696F6E2E61747472696275746530332C3130292C633D746869732E616374696F6E2E61747472696275746530342C643D746869732E6166666563746564456C656D656E7473';
wwv_flow_api.g_varchar2_table(3) := '3B66756E6374696F6E206228297B696628633D3D3D22696E66696E69746522297B636F6D5F6F7261636C655F617065785F74696D65722E6372656174656454696D6572735B665D3D73657454696D656F757428622C65297D656C73657B64656C65746520';
wwv_flow_api.g_varchar2_table(4) := '636F6D5F6F7261636C655F617065785F74696D65722E6372656174656454696D6572735B665D7D642E74726967676572282274696D65725F657870697265642E434F4D5F4F5241434C455F415045585F54494D4552222C66297D696628613D3D3D226164';
wwv_flow_api.g_varchar2_table(5) := '6422297B696628636F6D5F6F7261636C655F617065785F74696D65722E6372656174656454696D6572735B665D297B636C65617254696D656F757428636F6D5F6F7261636C655F617065785F74696D65722E6372656174656454696D6572735B665D297D';
wwv_flow_api.g_varchar2_table(6) := '636F6D5F6F7261636C655F617065785F74696D65722E6372656174656454696D6572735B665D3D73657454696D656F757428622C65297D656C73657B696628613D3D3D2272656D6F766522297B696628636F6D5F6F7261636C655F617065785F74696D65';
wwv_flow_api.g_varchar2_table(7) := '722E6372656174656454696D6572735B665D297B636C65617254696D656F757428636F6D5F6F7261636C655F617065785F74696D65722E6372656174656454696D6572735B665D293B64656C65746520636F6D5F6F7261636C655F617065785F74696D65';
wwv_flow_api.g_varchar2_table(8) := '722E6372656174656454696D6572735B665D7D7D7D7D7D3B';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 4037146368774530190 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 4037132680479198394 + wwv_flow_api.g_id_offset
 ,p_file_name => 'com_oracle_apex_timer.min.js'
 ,p_mime_type => 'text/javascript'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

--application/shared_components/plugins/dynamic_action/com_skillbuilders_modal_page
 
begin
 
wwv_flow_api.create_plugin (
  p_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'DYNAMIC ACTION'
 ,p_name => 'COM_SKILLBUILDERS_MODAL_PAGE'
 ,p_display_name => 'SkillBuilders Modal Page (2.0.0)'
 ,p_category => 'EFFECT'
 ,p_supported_ui_types => 'DESKTOP'
 ,p_image_prefix => '#PLUGIN_PREFIX#'
 ,p_plsql_code => 
'FUNCTION apex_modal_page_render ('||unistr('\000a')||
'   p_dynamic_action IN APEX_PLUGIN.T_DYNAMIC_ACTION,'||unistr('\000a')||
'   p_plugin         IN APEX_PLUGIN.T_PLUGIN '||unistr('\000a')||
')'||unistr('\000a')||
''||unistr('\000a')||
'   RETURN APEX_PLUGIN.T_DYNAMIC_ACTION_RENDER_RESULT'||unistr('\000a')||
'   '||unistr('\000a')||
'IS'||unistr('\000a')||
''||unistr('\000a')||
'   l_result             APEX_PLUGIN.T_DYNAMIC_ACTION_RENDER_RESULT;'||unistr('\000a')||
'   l_dialog_title       VARCHAR2(4000) := p_dynamic_action.attribute_01;'||unistr('\000a')||
'   l_url_location       VARCHAR2(50) := NVL(p_dynamic_action.at'||
'tribute_02, ''STATIC'');'||unistr('\000a')||
'   l_static_url         VARCHAR2(4000) := p_dynamic_action.attribute_03;'||unistr('\000a')||
'   l_attr_name          VARCHAR2(4000) := NVL(p_dynamic_action.attribute_05, ''data-url'');'||unistr('\000a')||
'   l_close_sel          VARCHAR2(4000) := NVL(p_dynamic_action.attribute_06, ''div#success-message'');'||unistr('\000a')||
'   l_hw_mode            VARCHAR2(4000) := NVL(p_dynamic_action.attribute_07, ''AUTO'');'||unistr('\000a')||
'   l_height             VAR'||
'CHAR2(4000) := p_dynamic_action.attribute_08;'||unistr('\000a')||
'   l_width              VARCHAR2(4000) := p_dynamic_action.attribute_09;'||unistr('\000a')||
'   l_modal_page_id      VARCHAR2(4000) := p_dynamic_action.attribute_10;'||unistr('\000a')||
'   l_theme              NUMBER := NVL(p_plugin.attribute_01, 3);'||unistr('\000a')||
'   l_overlay_opacity    NUMBER := NVL(TO_NUMBER(p_plugin.attribute_02, ''999.99'', ''NLS_NUMERIC_CHARACTERS = ''''.,''''''), .5);'||unistr('\000a')||
'   l_scrolling       '||
'   VARCHAR2(1) := NVL(p_plugin.attribute_03, ''N'');'||unistr('\000a')||
'   l_transition         VARCHAR2(50) := NVL(p_plugin.attribute_04, ''none'');'||unistr('\000a')||
'   l_initial_height     NUMBER := NVL(p_plugin.attribute_05, 100);'||unistr('\000a')||
'   l_initial_width      NUMBER := NVL(p_plugin.attribute_06, 100);'||unistr('\000a')||
'   l_draggable          VARCHAR2(1) := NVL(p_plugin.attribute_07, ''Y'');'||unistr('\000a')||
'   l_custom_css_path    VARCHAR2(4000) := p_plugin.attribute_08;'||unistr('\000a')||
'  '||
' l_custom_css_file    VARCHAR2(4000) := p_plugin.attribute_09;'||unistr('\000a')||
'   l_loading_image_src  VARCHAR2(32767);'||unistr('\000a')||
'   l_onload_code        VARCHAR2(32767);'||unistr('\000a')||
'   l_crlf               CHAR(2) := CHR(13)||CHR(10);'||unistr('\000a')||
''||unistr('\000a')||
'BEGIN'||unistr('\000a')||
''||unistr('\000a')||
'   IF apex_application.g_debug'||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      apex_plugin_util.debug_dynamic_action('||unistr('\000a')||
'         p_plugin         => p_plugin,'||unistr('\000a')||
'         p_dynamic_action => p_dynamic_action '||unistr('\000a')||
'      );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   '||unistr('\000a')||
''||
'   IF l_theme = 6 --User selected custom theme'||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      apex_css.add_file('||unistr('\000a')||
'         p_name      => RTRIM(RTRIM(l_custom_css_file,''.css''),''.CSS''),'||unistr('\000a')||
'         p_directory => wwv_flow.do_substitutions(l_custom_css_path),'||unistr('\000a')||
'         p_version   => NULL'||unistr('\000a')||
'      );'||unistr('\000a')||
'   ELSE '||unistr('\000a')||
'      apex_css.add_file('||unistr('\000a')||
'         p_name      => ''t'' || l_theme || ''colorbox'','||unistr('\000a')||
'         p_directory => p_plugin.file_prefix,'||unistr('\000a')||
'       '||
'  p_version   => NULL'||unistr('\000a')||
'      );'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   apex_javascript.add_library('||unistr('\000a')||
'      p_name      => ''jquery.colorbox-min'','||unistr('\000a')||
'      p_directory => p_plugin.file_prefix,'||unistr('\000a')||
'      p_version   => NULL'||unistr('\000a')||
'   );'||unistr('\000a')||
'   '||unistr('\000a')||
'   apex_javascript.add_library('||unistr('\000a')||
'      p_name      => ''apex_modal_page.min'','||unistr('\000a')||
'      p_directory => p_plugin.file_prefix,'||unistr('\000a')||
'      p_version   => NULL '||unistr('\000a')||
'   );'||unistr('\000a')||
''||unistr('\000a')||
'   l_onload_code := ''apex.jQuery(document).apex_m'||
'odal_page({'' || l_crlf'||unistr('\000a')||
'      || ''   '' || apex_javascript.add_attribute(''transition'',  l_transition) || l_crlf'||unistr('\000a')||
'      || ''   '' || apex_javascript.add_attribute(''draggable'',  '||unistr('\000a')||
'         CASE l_draggable'||unistr('\000a')||
'            WHEN ''Y'' THEN TRUE'||unistr('\000a')||
'            ELSE FALSE'||unistr('\000a')||
'         END'||unistr('\000a')||
'      ) || l_crlf'||unistr('\000a')||
'      || ''   '' || apex_javascript.add_attribute(''initialHeight'',  l_initial_height) || l_crlf'||unistr('\000a')||
'      || ''   '' || apex'||
'_javascript.add_attribute(''initialWidth'',  l_initial_width) || l_crlf'||unistr('\000a')||
'      || ''   '' || apex_javascript.add_attribute(''overlayOpacity'',  l_overlay_opacity) || l_crlf'||unistr('\000a')||
'      || ''   '' || apex_javascript.add_attribute(''scrolling'',  '||unistr('\000a')||
'         CASE l_scrolling'||unistr('\000a')||
'            WHEN ''Y'' THEN TRUE'||unistr('\000a')||
'            ELSE FALSE'||unistr('\000a')||
'         END'||unistr('\000a')||
'      ) || l_crlf'||unistr('\000a')||
'      || ''   '' || apex_javascript.add_attribute(''loadingImag'||
'eSrc'', l_loading_image_src, FALSE, FALSE) || l_crlf'||unistr('\000a')||
'      || ''});'';'||unistr('\000a')||
'      '||unistr('\000a')||
'   apex_javascript.add_onload_code('||unistr('\000a')||
'      p_code => l_onload_code'||unistr('\000a')||
'   ); '||unistr('\000a')||
''||unistr('\000a')||
'   l_result.javascript_function := '||unistr('\000a')||
'      ''function(){'' || l_crlf ||'||unistr('\000a')||
'      ''   if (this.browserEvent !== ''''load''''){'' || l_crlf ||'||unistr('\000a')||
'      ''      apex.jQuery(document).apex_modal_page(''''openPageFromApexThis'''', this);'' || l_crlf ||'||unistr('\000a')||
'      ''   }'' || l_crlf '||
'||'||unistr('\000a')||
'      ''}'';'||unistr('\000a')||
''||unistr('\000a')||
'   l_result.attribute_01 := l_dialog_title;'||unistr('\000a')||
'   l_result.attribute_02 := l_url_location;'||unistr('\000a')||
'   l_result.attribute_03 := l_static_url;'||unistr('\000a')||
'   l_result.attribute_05 := l_attr_name;'||unistr('\000a')||
'   l_result.attribute_06 := l_close_sel;'||unistr('\000a')||
'   l_result.attribute_07 := l_hw_mode;'||unistr('\000a')||
'   l_result.attribute_08 := l_height;'||unistr('\000a')||
'   l_result.attribute_09 := l_width;'||unistr('\000a')||
'   l_result.attribute_10 := l_modal_page_id;'||unistr('\000a')||
''||unistr('\000a')||
'   RETURN l_r'||
'esult;'||unistr('\000a')||
'    '||unistr('\000a')||
'END apex_modal_page_render;'
 ,p_render_function => 'apex_modal_page_render'
 ,p_substitute_attributes => true
 ,p_subscribe_plugin_settings => true
 ,p_help_text => '<br />'||unistr('\000a')||
''
 ,p_version_identifier => '2.0.0'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 16845559475987683 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'APPLICATION'
 ,p_attribute_sequence => 1
 ,p_display_sequence => 10
 ,p_prompt => 'Theme'
 ,p_attribute_type => 'SELECT LIST'
 ,p_is_required => true
 ,p_default_value => '3'
 ,p_is_translatable => false
 ,p_help_text => 'The Theme setting is used to change the look and feel of the modal window. The ColorBox website includes 5 example themes which have been included with this plug-in. Simply select a number from 1 to 5 to use one of these themes. The themes demonstrate the flexibility of the plug-in and can be used without making any changes. However, a custom option exists that, when selected, exposes two additional fields that allow for a custom CSS file to be defined. It is recommended that you start with an existing theme and make small changes to it until you are comfortable working with the CSS.'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 16846061553988316 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 16845559475987683 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 10
 ,p_display_value => '1'
 ,p_return_value => '1'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 16846463285988779 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 16845559475987683 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 20
 ,p_display_value => '2'
 ,p_return_value => '2'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 16846865362989361 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 16845559475987683 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 30
 ,p_display_value => '3'
 ,p_return_value => '3'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 16847267094989866 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 16845559475987683 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 40
 ,p_display_value => '4'
 ,p_return_value => '4'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 16847669518990535 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 16845559475987683 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 50
 ,p_display_value => '5'
 ,p_return_value => '5'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 16848038828991163 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 16845559475987683 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 60
 ,p_display_value => 'Custom'
 ,p_return_value => '6'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 16848837837018925 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'APPLICATION'
 ,p_attribute_sequence => 2
 ,p_display_sequence => 20
 ,p_prompt => 'Overlay Opacity'
 ,p_attribute_type => 'NUMBER'
 ,p_is_required => true
 ,p_default_value => '.5'
 ,p_display_length => 3
 ,p_max_length => 3
 ,p_is_translatable => false
 ,p_help_text => 'The Overlay Opacity setting is used to adjust the darkness of the overlay behind the modal dialog. Specify a number between 0 and 1 where 0 is transparent and 1 is completely obscured. The default value of .5 is in the middle and allows the users to see the screen behind but focuses their attention on the modal dialog.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 16849341216038784 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'APPLICATION'
 ,p_attribute_sequence => 3
 ,p_display_sequence => 17
 ,p_prompt => 'Scrolling'
 ,p_attribute_type => 'CHECKBOX'
 ,p_is_required => false
 ,p_default_value => 'Y'
 ,p_is_translatable => false
 ,p_help_text => 'The Scrolling setting is used to specify whether or not the modal can include scroll bars across the top and bottom of the modal to allow users to see all of the content in the page. When set to No, any overflow cotent will be hidden from view.<br /> '||unistr('\000a')||
'<br />'||unistr('\000a')||
'This setting must be used in conjunction with the Height and Width settings in the component settings. A later version of this plug-in will move this setting to the component settings.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 16849863033044992 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'APPLICATION'
 ,p_attribute_sequence => 4
 ,p_display_sequence => 15
 ,p_prompt => 'Transition'
 ,p_attribute_type => 'SELECT LIST'
 ,p_is_required => true
 ,p_default_value => 'none'
 ,p_is_translatable => false
 ,p_help_text => 'The Transition setting can be used to apply some effects to the opening and closing of the modal dialog. '
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 16850366496046004 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 16849863033044992 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 10
 ,p_display_value => 'None'
 ,p_return_value => 'none'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 16850739746057115 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 16849863033044992 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 20
 ,p_display_value => 'Elastic'
 ,p_return_value => 'elastic'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 16851144594058546 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 16849863033044992 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 30
 ,p_display_value => 'Fade'
 ,p_return_value => 'fade'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 10312666039640939443 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'APPLICATION'
 ,p_attribute_sequence => 5
 ,p_display_sequence => 50
 ,p_prompt => 'Initial Height'
 ,p_attribute_type => 'INTEGER'
 ,p_is_required => true
 ,p_default_value => '100'
 ,p_display_length => 2
 ,p_max_length => 3
 ,p_is_translatable => false
 ,p_help_text => 'The Initial Height setting is used to specify the initial height (in pixels) of the modal page when it opens but before the main content loads. '
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 10312667222109943868 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'APPLICATION'
 ,p_attribute_sequence => 6
 ,p_display_sequence => 60
 ,p_prompt => 'Initial Width'
 ,p_attribute_type => 'INTEGER'
 ,p_is_required => true
 ,p_default_value => '300'
 ,p_display_length => 2
 ,p_max_length => 3
 ,p_is_translatable => false
 ,p_help_text => 'The Initial Width setting is used to specify the initial width (in pixels) of the modal page when it opens but before the main content loads.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 16852765157073867 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'APPLICATION'
 ,p_attribute_sequence => 7
 ,p_display_sequence => 18
 ,p_prompt => 'Draggable'
 ,p_attribute_type => 'CHECKBOX'
 ,p_is_required => false
 ,p_default_value => 'Y'
 ,p_is_translatable => false
 ,p_help_text => 'The Draggable setting is used to specify whether or not the user should be able to move the modal dialog around on the screen.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 16853650182088337 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'APPLICATION'
 ,p_attribute_sequence => 8
 ,p_display_sequence => 12
 ,p_prompt => 'Custom CSS Path'
 ,p_attribute_type => 'TEXT'
 ,p_is_required => false
 ,p_display_length => 50
 ,p_max_length => 500
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 16845559475987683 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'EQUALS'
 ,p_depending_on_expression => '6'
 ,p_help_text => 'The Custom CSS Path setting is used to specify the path to a custom CSS file for the theme. This setting is only displayed when the Theme is set to custom. See Optional Performance Upgrade for additional information.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 16854158971100316 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'APPLICATION'
 ,p_attribute_sequence => 9
 ,p_display_sequence => 13
 ,p_prompt => 'Custom CSS Filename'
 ,p_attribute_type => 'TEXT'
 ,p_is_required => false
 ,p_display_length => 50
 ,p_max_length => 500
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 16845559475987683 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'EQUALS'
 ,p_depending_on_expression => '6'
 ,p_help_text => 'The Custom CSS Filename setting is used to specify the name of the file that contains custom CSS for the theme. Only the name of the file should be included with this setting as it is assumed the extension will be â.cssâ. This setting is only displayed when the Theme is set to custom.  See Optional Performance Upgrade for additional information.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 27709717032498710430 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 1
 ,p_display_sequence => 10
 ,p_prompt => 'Dialog Title'
 ,p_attribute_type => 'TEXT'
 ,p_is_required => false
 ,p_display_length => 30
 ,p_max_length => 50
 ,p_is_translatable => false
 ,p_help_text => 'Use this attribute to specify the title displayed in the modal page.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 27709709843318694620 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 2
 ,p_display_sequence => 20
 ,p_prompt => 'URL Location'
 ,p_attribute_type => 'SELECT LIST'
 ,p_is_required => true
 ,p_default_value => 'STATIC'
 ,p_is_translatable => false
 ,p_help_text => 'Use this attribute to specify whether the URL for the modal page is static or dynamic. '
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 27709712125441698860 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 27709709843318694620 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 10
 ,p_display_value => 'Statically Defined'
 ,p_return_value => 'STATIC'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 27709713237908702481 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 27709709843318694620 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 20
 ,p_display_value => 'Attribute of Triggering Element'
 ,p_return_value => 'TRIG_ELEMENT_ATTR'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 27709704122886688687 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 3
 ,p_display_sequence => 30
 ,p_prompt => 'Static URL'
 ,p_attribute_type => 'TEXT'
 ,p_is_required => true
 ,p_default_value => 'f?p=&APP_ID.:1:&APP_SESSION.:::1:::'
 ,p_display_length => 50
 ,p_max_length => 500
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 27709709843318694620 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'EQUALS'
 ,p_depending_on_expression => 'STATIC'
 ,p_help_text => 'Use this attribute to specify a static URL for the modal page.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 35774412659025188965 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 5
 ,p_display_sequence => 50
 ,p_prompt => 'Attribute Name'
 ,p_attribute_type => 'TEXT'
 ,p_is_required => true
 ,p_default_value => 'href'
 ,p_display_length => 30
 ,p_max_length => 50
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 27709709843318694620 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'EQUALS'
 ,p_depending_on_expression => 'TRIG_ELEMENT_ATTR'
 ,p_help_text => 'Use this attribute to specify which attribute of the triggering element contains the URL for the modal page. This is often the href attribute of anchor elements.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 35774542657490377735 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 6
 ,p_display_sequence => 60
 ,p_prompt => 'Auto-close On Element Selector'
 ,p_attribute_type => 'TEXT'
 ,p_is_required => false
 ,p_default_value => 'div#success-message'
 ,p_display_length => 30
 ,p_max_length => 500
 ,p_is_translatable => false
 ,p_help_text => 'Use this attribute to specify a jQuery selector used to close the modal page automatically. The selector is executed when the modal page is loaded. If the selector selects anything, the modal page will close and the Auto Close event will be triggered. Typically this is only used for modal pages that are submitted for processing where the success message is used to auto-close the modal page.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 13106283141787369393 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 7
 ,p_display_sequence => 70
 ,p_prompt => 'Dialog Height/Width Mode'
 ,p_attribute_type => 'SELECT LIST'
 ,p_is_required => true
 ,p_default_value => 'AUTO'
 ,p_is_translatable => false
 ,p_help_text => 'Use this attribute to control the size of the modal page. The default value of "Auto" will try to automatically determine the appropriate size of the page based on the content. However, if you need more control, this attribute allows you set the height and width as a percentage of the total window size or by a fixed number of pixels.'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 13106321730836375685 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 13106283141787369393 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 1
 ,p_display_value => 'Auto'
 ,p_return_value => 'AUTO'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 13106284946635370782 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 13106283141787369393 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 10
 ,p_display_value => 'Static by percent of window'
 ,p_return_value => 'STATIC_%'
  );
wwv_flow_api.create_plugin_attr_value (
  p_id => 13106285516291371442 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_attribute_id => 13106283141787369393 + wwv_flow_api.g_id_offset
 ,p_display_sequence => 20
 ,p_display_value => 'Static by pixels'
 ,p_return_value => 'STATIC_PX'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 13106505018378447724 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 8
 ,p_display_sequence => 80
 ,p_prompt => 'Height'
 ,p_attribute_type => 'INTEGER'
 ,p_is_required => true
 ,p_display_length => 2
 ,p_max_length => 3
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 13106283141787369393 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'IN_LIST'
 ,p_depending_on_expression => 'STATIC_%,STATIC_PX'
 ,p_help_text => 'Use this attribute to set the height of the modal page. This value can be used to specify a percentage of the total screen or specific number of pixels which is determined by the Dialog Height/Width Mode attribute.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 13106507331538451536 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 9
 ,p_display_sequence => 90
 ,p_prompt => 'Width'
 ,p_attribute_type => 'INTEGER'
 ,p_is_required => true
 ,p_display_length => 2
 ,p_max_length => 3
 ,p_is_translatable => false
 ,p_depending_on_attribute_id => 13106283141787369393 + wwv_flow_api.g_id_offset
 ,p_depending_on_condition_type => 'IN_LIST'
 ,p_depending_on_expression => 'STATIC_%,STATIC_PX'
 ,p_help_text => 'Use this attribute to set the width of the modal page. This value can be used to specify a percentage of the total screen or specific number of pixels which is determined by the Dialog Height/Width Mode attribute.'
  );
wwv_flow_api.create_plugin_attribute (
  p_id => 13106549022712486810 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_attribute_scope => 'COMPONENT'
 ,p_attribute_sequence => 10
 ,p_display_sequence => 100
 ,p_prompt => 'Modal Page ID'
 ,p_attribute_type => 'TEXT'
 ,p_is_required => false
 ,p_display_length => 30
 ,p_max_length => 50
 ,p_is_translatable => false
 ,p_help_text => 'Use this attribute to associate an identifier, such as "create-customer-page", with the modal page that has been opened. When the modal page closes this identifier will be passed back with the event object so that the closing of one modal page can be differentiated from another. The value can be accessed from the data object of "this" in a Dynamic Action with: this.data.modalPageId'
  );
wwv_flow_api.create_plugin_event (
  p_id => 35711951543462725903 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_name => 'modalpageautoclose'
 ,p_display_name => 'Auto Close'
  );
wwv_flow_api.create_plugin_event (
  p_id => 10312234628513557837 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_name => 'modalpageclose'
 ,p_display_name => 'Close'
  );
wwv_flow_api.create_plugin_event (
  p_id => 16885138004635898 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_name => 'modalpageendopen'
 ,p_display_name => 'End Open'
  );
wwv_flow_api.create_plugin_event (
  p_id => 16885543199637429 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_name => 'modalpagemanualclose'
 ,p_display_name => 'Manual Close'
  );
wwv_flow_api.create_plugin_event (
  p_id => 16885848739639029 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_name => 'modalpagestartopen'
 ,p_display_name => 'Start Open'
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2A0D0A20202020436F6C6F72426F7820436F7265205374796C653A0D0A2020202054686520666F6C6C6F77696E672043535320697320636F6E73697374656E74206265747765656E206578616D706C65207468656D657320616E642073686F756C6420';
wwv_flow_api.g_varchar2_table(2) := '6E6F7420626520616C74657265642E0D0A2A2F0D0A23636F6C6F72626F782C202363626F784F7665726C61792C202363626F78577261707065727B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B207A2D696E646578';
wwv_flow_api.g_varchar2_table(3) := '3A393939393B206F766572666C6F773A68696464656E3B7D0D0A2363626F784F7665726C61797B706F736974696F6E3A66697865643B2077696474683A313030253B206865696768743A313030253B7D0D0A2363626F784D6964646C654C6566742C2023';
wwv_flow_api.g_varchar2_table(4) := '63626F78426F74746F6D4C6566747B636C6561723A6C6566743B7D0D0A2363626F78436F6E74656E747B706F736974696F6E3A72656C61746976653B7D0D0A2363626F784C6F61646564436F6E74656E747B6F766572666C6F773A6175746F3B7D0D0A23';
wwv_flow_api.g_varchar2_table(5) := '63626F785469746C657B6D617267696E3A303B7D0D0A2363626F784C6F6164696E674F7665726C61792C202363626F784C6F6164696E67477261706869637B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B20776964';
wwv_flow_api.g_varchar2_table(6) := '74683A313030253B206865696768743A313030253B7D0D0A2363626F7850726576696F75732C202363626F784E6578742C202363626F78436C6F73652C202363626F78536C69646573686F777B637572736F723A706F696E7465723B7D0D0A2E63626F78';
wwv_flow_api.g_varchar2_table(7) := '50686F746F7B666C6F61743A6C6566743B206D617267696E3A6175746F3B20626F726465723A303B20646973706C61793A626C6F636B3B7D0D0A2E63626F78496672616D657B77696474683A313030253B206865696768743A313030253B20646973706C';
wwv_flow_api.g_varchar2_table(8) := '61793A626C6F636B3B20626F726465723A303B7D0D0A0D0A2F2A200D0A2020202055736572205374796C653A0D0A202020204368616E67652074686520666F6C6C6F77696E67207374796C657320746F206D6F646966792074686520617070656172616E';
wwv_flow_api.g_varchar2_table(9) := '6365206F6620436F6C6F72426F782E202054686579206172650D0A202020206F72646572656420262074616262656420696E206120776179207468617420726570726573656E747320746865206E657374696E67206F66207468652067656E6572617465';
wwv_flow_api.g_varchar2_table(10) := '642048544D4C2E0D0A2A2F0D0A2363626F784F7665726C61797B6261636B67726F756E643A75726C2823504C5547494E5F5052454649582374316F7665726C61792E706E672920726570656174203020303B7D0D0A23636F6C6F72626F787B7D0D0A2020';
wwv_flow_api.g_varchar2_table(11) := '20202363626F78546F704C6566747B77696474683A323170783B206865696768743A323170783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237431636F6E74726F6C732E706E6729206E6F2D726570656174202D313031';
wwv_flow_api.g_varchar2_table(12) := '707820303B7D0D0A202020202363626F78546F7052696768747B77696474683A323170783B206865696768743A323170783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237431636F6E74726F6C732E706E6729206E6F2D';
wwv_flow_api.g_varchar2_table(13) := '726570656174202D313330707820303B7D0D0A202020202363626F78426F74746F6D4C6566747B77696474683A323170783B206865696768743A323170783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237431636F6E74';
wwv_flow_api.g_varchar2_table(14) := '726F6C732E706E6729206E6F2D726570656174202D3130317078202D323970783B7D0D0A202020202363626F78426F74746F6D52696768747B77696474683A323170783B206865696768743A323170783B206261636B67726F756E643A75726C2823504C';
wwv_flow_api.g_varchar2_table(15) := '5547494E5F505245464958237431636F6E74726F6C732E706E6729206E6F2D726570656174202D3133307078202D323970783B7D0D0A202020202363626F784D6964646C654C6566747B77696474683A323170783B206261636B67726F756E643A75726C';
wwv_flow_api.g_varchar2_table(16) := '2823504C5547494E5F505245464958237431636F6E74726F6C732E706E6729206C65667420746F70207265706561742D793B7D0D0A202020202363626F784D6964646C6552696768747B77696474683A323170783B206261636B67726F756E643A75726C';
wwv_flow_api.g_varchar2_table(17) := '2823504C5547494E5F505245464958237431636F6E74726F6C732E706E672920726967687420746F70207265706561742D793B7D0D0A202020202363626F78546F7043656E7465727B6865696768743A323170783B206261636B67726F756E643A75726C';
wwv_flow_api.g_varchar2_table(18) := '2823504C5547494E5F505245464958237431626F726465722E706E672920302030207265706561742D783B7D0D0A202020202363626F78426F74746F6D43656E7465727B6865696768743A323170783B206261636B67726F756E643A75726C2823504C55';
wwv_flow_api.g_varchar2_table(19) := '47494E5F505245464958237431626F726465722E706E67292030202D32397078207265706561742D783B7D0D0A202020202363626F78436F6E74656E747B6261636B67726F756E643A236666663B206F766572666C6F773A68696464656E3B7D0D0A2020';
wwv_flow_api.g_varchar2_table(20) := '2020202020202E63626F78496672616D657B6261636B67726F756E643A236666663B7D0D0A20202020202020202363626F784572726F727B70616464696E673A353070783B20626F726465723A31707820736F6C696420236363633B7D0D0A2020202020';
wwv_flow_api.g_varchar2_table(21) := '2020202363626F784C6F61646564436F6E74656E747B6D617267696E2D626F74746F6D3A323870783B7D0D0A20202020202020202363626F785469746C657B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A3470783B206C6566743A30';
wwv_flow_api.g_varchar2_table(22) := '3B20746578742D616C69676E3A63656E7465723B2077696474683A313030253B20636F6C6F723A233934393439343B7D0D0A20202020202020202363626F7843757272656E747B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A347078';
wwv_flow_api.g_varchar2_table(23) := '3B206C6566743A353870783B20636F6C6F723A233934393439343B7D0D0A20202020202020202363626F78536C69646573686F777B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A3470783B2072696768743A333070783B20636F6C6F';
wwv_flow_api.g_varchar2_table(24) := '723A233030393265663B7D0D0A20202020202020202363626F7850726576696F75737B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A303B206C6566743A303B206261636B67726F756E643A75726C2823504C5547494E5F5052454649';
wwv_flow_api.g_varchar2_table(25) := '58237431636F6E74726F6C732E706E6729206E6F2D726570656174202D3735707820303B2077696474683A323570783B206865696768743A323570783B20746578742D696E64656E743A2D3939393970783B7D0D0A20202020202020202363626F785072';
wwv_flow_api.g_varchar2_table(26) := '6576696F75733A686F7665727B6261636B67726F756E642D706F736974696F6E3A2D37357078202D323570783B7D0D0A20202020202020202363626F784E6578747B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A303B206C6566743A';
wwv_flow_api.g_varchar2_table(27) := '323770783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237431636F6E74726F6C732E706E6729206E6F2D726570656174202D3530707820303B2077696474683A323570783B206865696768743A323570783B2074657874';
wwv_flow_api.g_varchar2_table(28) := '2D696E64656E743A2D3939393970783B7D0D0A20202020202020202363626F784E6578743A686F7665727B6261636B67726F756E642D706F736974696F6E3A2D35307078202D323570783B7D0D0A20202020202020202363626F784C6F6164696E674F76';
wwv_flow_api.g_varchar2_table(29) := '65726C61797B6261636B67726F756E643A75726C2823504C5547494E5F5052454649582374316C6F6164696E675F6261636B67726F756E642E706E6729206E6F2D7265706561742063656E7465722063656E7465723B7D0D0A2020202020202020236362';
wwv_flow_api.g_varchar2_table(30) := '6F784C6F6164696E67477261706869637B6261636B67726F756E643A75726C2823504C5547494E5F5052454649582374316C6F6164696E672E67696629206E6F2D7265706561742063656E7465722063656E7465723B7D0D0A2020202020202020236362';
wwv_flow_api.g_varchar2_table(31) := '6F78436C6F73657B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A303B2072696768743A303B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237431636F6E74726F6C732E706E6729206E6F2D7265706561';
wwv_flow_api.g_varchar2_table(32) := '74202D3235707820303B2077696474683A323570783B206865696768743A323570783B20746578742D696E64656E743A2D3939393970783B7D0D0A20202020202020202363626F78436C6F73653A686F7665727B6261636B67726F756E642D706F736974';
wwv_flow_api.g_varchar2_table(33) := '696F6E3A2D32357078202D323570783B7D0D0A0D0A2F2A0D0A202054686520666F6C6C6F77696E6720666978657320612070726F626C656D2077686572652049453720616E6420494538207265706C616365206120504E47277320616C70686120747261';
wwv_flow_api.g_varchar2_table(34) := '6E73706172656E63792077697468206120626C61636B2066696C6C0D0A20207768656E20616E20616C7068612066696C74657220286F706163697479206368616E67652920697320736574206F6E2074686520656C656D656E74206F7220616E63657374';
wwv_flow_api.g_varchar2_table(35) := '6F7220656C656D656E742E202054686973207374796C65206973206E6F74206170706C69656420746F206F72206E656564656420696E204945392E0D0A20205365653A20687474703A2F2F6A61636B6C6D6F6F72652E636F6D2F6E6F7465732F69652D74';
wwv_flow_api.g_varchar2_table(36) := '72616E73706172656E63792D70726F626C656D732F0D0A2A2F0D0A2E63626F784945202363626F78546F704C6566742C0D0A2E63626F784945202363626F78546F7043656E7465722C0D0A2E63626F784945202363626F78546F7052696768742C0D0A2E';
wwv_flow_api.g_varchar2_table(37) := '63626F784945202363626F78426F74746F6D4C6566742C0D0A2E63626F784945202363626F78426F74746F6D43656E7465722C0D0A2E63626F784945202363626F78426F74746F6D52696768742C0D0A2E63626F784945202363626F784D6964646C654C';
wwv_flow_api.g_varchar2_table(38) := '6566742C0D0A2E63626F784945202363626F784D6964646C655269676874207B0D0A2020202066696C7465723A2070726F6769643A4458496D6167655472616E73666F726D2E4D6963726F736F66742E6772616469656E74287374617274436F6C6F7273';
wwv_flow_api.g_varchar2_table(39) := '74723D2330304646464646462C656E64436F6C6F727374723D233030464646464646293B0D0A7D0D0A0D0A2F2A0D0A202054686520666F6C6C6F77696E672070726F766964657320504E47207472616E73706172656E637920737570706F727420666F72';
wwv_flow_api.g_varchar2_table(40) := '204945360D0A20204665656C206672656520746F2072656D6F7665207468697320616E6420746865202F6965362F206469726563746F727920696620796F7520686176652064726F707065642049453620737570706F72742E0D0A2A2F0D0A2E63626F78';
wwv_flow_api.g_varchar2_table(41) := '494536202363626F78546F704C6566747B6261636B67726F756E643A75726C2823504C5547494E5F505245464958237431626F72646572546F704C6566742E706E67293B7D0D0A2E63626F78494536202363626F78546F7043656E7465727B6261636B67';
wwv_flow_api.g_varchar2_table(42) := '726F756E643A75726C2823504C5547494E5F505245464958237431626F72646572546F7043656E7465722E706E67293B7D0D0A2E63626F78494536202363626F78546F7052696768747B6261636B67726F756E643A75726C2823504C5547494E5F505245';
wwv_flow_api.g_varchar2_table(43) := '464958237431626F72646572546F7052696768742E706E67293B7D0D0A2E63626F78494536202363626F78426F74746F6D4C6566747B6261636B67726F756E643A75726C2823504C5547494E5F505245464958237431626F72646572426F74746F6D4C65';
wwv_flow_api.g_varchar2_table(44) := '66742E706E67293B7D0D0A2E63626F78494536202363626F78426F74746F6D43656E7465727B6261636B67726F756E643A75726C2823504C5547494E5F505245464958237431626F72646572426F74746F6D43656E7465722E706E67293B7D0D0A2E6362';
wwv_flow_api.g_varchar2_table(45) := '6F78494536202363626F78426F74746F6D52696768747B6261636B67726F756E643A75726C2823504C5547494E5F505245464958237431626F72646572426F74746F6D52696768742E706E67293B7D0D0A2E63626F78494536202363626F784D6964646C';
wwv_flow_api.g_varchar2_table(46) := '654C6566747B6261636B67726F756E643A75726C2823504C5547494E5F505245464958237431626F726465724D6964646C654C6566742E706E67293B7D0D0A2E63626F78494536202363626F784D6964646C6552696768747B6261636B67726F756E643A';
wwv_flow_api.g_varchar2_table(47) := '75726C2823504C5547494E5F505245464958237431626F726465724D6964646C6552696768742E706E67293B7D0D0A0D0A2E63626F78494536202363626F78546F704C6566742C0D0A2E63626F78494536202363626F78546F7043656E7465722C0D0A2E';
wwv_flow_api.g_varchar2_table(48) := '63626F78494536202363626F78546F7052696768742C0D0A2E63626F78494536202363626F78426F74746F6D4C6566742C0D0A2E63626F78494536202363626F78426F74746F6D43656E7465722C0D0A2E63626F78494536202363626F78426F74746F6D';
wwv_flow_api.g_varchar2_table(49) := '52696768742C0D0A2E63626F78494536202363626F784D6964646C654C6566742C0D0A2E63626F78494536202363626F784D6964646C655269676874207B0D0A202020205F6265686176696F723A2065787072657373696F6E28746869732E737263203D';
wwv_flow_api.g_varchar2_table(50) := '20746869732E737263203F20746869732E737263203A20746869732E63757272656E745374796C652E6261636B67726F756E64496D6167652E73706C697428272227295B315D2C20746869732E7374796C652E6261636B67726F756E64203D20226E6F6E';
wwv_flow_api.g_varchar2_table(51) := '65222C20746869732E7374796C652E66696C746572203D202270726F6769643A4458496D6167655472616E73666F726D2E4D6963726F736F66742E416C706861496D6167654C6F61646572287372633D22202B20746869732E737263202B20222C207369';
wwv_flow_api.g_varchar2_table(52) := '7A696E674D6574686F643D277363616C65272922293B0D0A7D0D0A';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16857761278555866 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1colorbox.css'
 ,p_mime_type => 'text/css'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2A0D0A20202020436F6C6F72426F7820436F7265205374796C653A0D0A2020202054686520666F6C6C6F77696E672043535320697320636F6E73697374656E74206265747765656E206578616D706C65207468656D657320616E642073686F756C6420';
wwv_flow_api.g_varchar2_table(2) := '6E6F7420626520616C74657265642E0D0A2A2F0D0A23636F6C6F72626F782C202363626F784F7665726C61792C202363626F78577261707065727B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B207A2D696E646578';
wwv_flow_api.g_varchar2_table(3) := '3A393939393B206F766572666C6F773A68696464656E3B7D0D0A2363626F784F7665726C61797B706F736974696F6E3A66697865643B2077696474683A313030253B206865696768743A313030253B7D0D0A2363626F784D6964646C654C6566742C2023';
wwv_flow_api.g_varchar2_table(4) := '63626F78426F74746F6D4C6566747B636C6561723A6C6566743B7D0D0A2363626F78436F6E74656E747B706F736974696F6E3A72656C61746976653B7D0D0A2363626F784C6F61646564436F6E74656E747B6F766572666C6F773A6175746F3B7D0D0A23';
wwv_flow_api.g_varchar2_table(5) := '63626F785469746C657B6D617267696E3A303B7D0D0A2363626F784C6F6164696E674F7665726C61792C202363626F784C6F6164696E67477261706869637B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B20776964';
wwv_flow_api.g_varchar2_table(6) := '74683A313030253B206865696768743A313030253B7D0D0A2363626F7850726576696F75732C202363626F784E6578742C202363626F78436C6F73652C202363626F78536C69646573686F777B637572736F723A706F696E7465723B7D0D0A2E63626F78';
wwv_flow_api.g_varchar2_table(7) := '50686F746F7B666C6F61743A6C6566743B206D617267696E3A6175746F3B20626F726465723A303B20646973706C61793A626C6F636B3B7D0D0A2E63626F78496672616D657B77696474683A313030253B206865696768743A313030253B20646973706C';
wwv_flow_api.g_varchar2_table(8) := '61793A626C6F636B3B20626F726465723A303B7D0D0A0D0A2F2A200D0A2020202055736572205374796C653A0D0A202020204368616E67652074686520666F6C6C6F77696E67207374796C657320746F206D6F646966792074686520617070656172616E';
wwv_flow_api.g_varchar2_table(9) := '6365206F6620436F6C6F72426F782E202054686579206172650D0A202020206F72646572656420262074616262656420696E206120776179207468617420726570726573656E747320746865206E657374696E67206F66207468652067656E6572617465';
wwv_flow_api.g_varchar2_table(10) := '642048544D4C2E0D0A2A2F0D0A2363626F784F7665726C61797B6261636B67726F756E643A236666663B7D0D0A23636F6C6F72626F787B7D0D0A202020202363626F78436F6E74656E747B6D617267696E2D746F703A333270783B206F766572666C6F77';
wwv_flow_api.g_varchar2_table(11) := '3A76697369626C653B7D0D0A20202020202020202E63626F78496672616D657B6261636B67726F756E643A236666663B7D0D0A20202020202020202363626F784572726F727B70616464696E673A353070783B20626F726465723A31707820736F6C6964';
wwv_flow_api.g_varchar2_table(12) := '20236363633B7D0D0A20202020202020202363626F784C6F61646564436F6E74656E747B6261636B67726F756E643A233030303B2070616464696E673A3170783B7D0D0A20202020202020202363626F784C6F6164696E67477261706869637B6261636B';
wwv_flow_api.g_varchar2_table(13) := '67726F756E643A75726C2823504C5547494E5F5052454649582374326C6F6164696E672E67696629206E6F2D7265706561742063656E7465722063656E7465723B7D0D0A20202020202020202363626F784C6F6164696E674F7665726C61797B6261636B';
wwv_flow_api.g_varchar2_table(14) := '67726F756E643A233030303B7D0D0A20202020202020202363626F785469746C657B706F736974696F6E3A6162736F6C7574653B20746F703A2D323270783B206C6566743A303B20636F6C6F723A233030303B7D0D0A20202020202020202363626F7843';
wwv_flow_api.g_varchar2_table(15) := '757272656E747B706F736974696F6E3A6162736F6C7574653B20746F703A2D323270783B2072696768743A32303570783B20746578742D696E64656E743A2D3939393970783B7D0D0A20202020202020202363626F78536C69646573686F772C20236362';
wwv_flow_api.g_varchar2_table(16) := '6F7850726576696F75732C202363626F784E6578742C202363626F78436C6F73657B746578742D696E64656E743A2D3939393970783B2077696474683A323070783B206865696768743A323070783B20706F736974696F6E3A6162736F6C7574653B2074';
wwv_flow_api.g_varchar2_table(17) := '6F703A2D323070783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237432636F6E74726F6C732E706E6729206E6F2D726570656174203020303B7D0D0A20202020202020202363626F7850726576696F75737B6261636B67';
wwv_flow_api.g_varchar2_table(18) := '726F756E642D706F736974696F6E3A307078203070783B2072696768743A343470783B7D0D0A20202020202020202363626F7850726576696F75733A686F7665727B6261636B67726F756E642D706F736974696F6E3A307078202D323570783B7D0D0A20';
wwv_flow_api.g_varchar2_table(19) := '202020202020202363626F784E6578747B6261636B67726F756E642D706F736974696F6E3A2D32357078203070783B2072696768743A323270783B7D0D0A20202020202020202363626F784E6578743A686F7665727B6261636B67726F756E642D706F73';
wwv_flow_api.g_varchar2_table(20) := '6974696F6E3A2D32357078202D323570783B7D0D0A20202020202020202363626F78436C6F73657B6261636B67726F756E642D706F736974696F6E3A2D35307078203070783B2072696768743A303B7D0D0A20202020202020202363626F78436C6F7365';
wwv_flow_api.g_varchar2_table(21) := '3A686F7665727B6261636B67726F756E642D706F736974696F6E3A2D35307078202D323570783B7D0D0A20202020202020202E63626F78536C69646573686F775F6F6E202363626F7850726576696F75732C202E63626F78536C69646573686F775F6F66';
wwv_flow_api.g_varchar2_table(22) := '66202363626F7850726576696F75737B72696768743A363670783B7D0D0A20202020202020202E63626F78536C69646573686F775F6F6E202363626F78536C69646573686F777B6261636B67726F756E642D706F736974696F6E3A2D37357078202D3235';
wwv_flow_api.g_varchar2_table(23) := '70783B2072696768743A343470783B7D0D0A20202020202020202E63626F78536C69646573686F775F6F6E202363626F78536C69646573686F773A686F7665727B6261636B67726F756E642D706F736974696F6E3A2D3130307078202D323570783B7D0D';
wwv_flow_api.g_varchar2_table(24) := '0A20202020202020202E63626F78536C69646573686F775F6F6666202363626F78536C69646573686F777B6261636B67726F756E642D706F736974696F6E3A2D3130307078203070783B2072696768743A343470783B7D0D0A20202020202020202E6362';
wwv_flow_api.g_varchar2_table(25) := '6F78536C69646573686F775F6F6666202363626F78536C69646573686F773A686F7665727B6261636B67726F756E642D706F736974696F6E3A2D37357078202D323570783B7D0D0A';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16858459337556739 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't2colorbox.css'
 ,p_mime_type => 'text/css'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2A0D0A20202020436F6C6F72426F7820436F7265205374796C653A0D0A2020202054686520666F6C6C6F77696E672043535320697320636F6E73697374656E74206265747765656E206578616D706C65207468656D657320616E642073686F756C6420';
wwv_flow_api.g_varchar2_table(2) := '6E6F7420626520616C74657265642E0D0A2A2F0D0A23636F6C6F72626F782C202363626F784F7665726C61792C202363626F78577261707065727B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B207A2D696E646578';
wwv_flow_api.g_varchar2_table(3) := '3A393939393B206F766572666C6F773A68696464656E3B7D0D0A2363626F784F7665726C61797B706F736974696F6E3A66697865643B2077696474683A313030253B206865696768743A313030253B7D0D0A2363626F784D6964646C654C6566742C2023';
wwv_flow_api.g_varchar2_table(4) := '63626F78426F74746F6D4C6566747B636C6561723A6C6566743B7D0D0A2363626F78436F6E74656E747B706F736974696F6E3A72656C61746976653B7D0D0A2363626F784C6F61646564436F6E74656E747B6F766572666C6F773A6175746F3B7D0D0A23';
wwv_flow_api.g_varchar2_table(5) := '63626F785469746C657B6D617267696E3A303B7D0D0A2363626F784C6F6164696E674F7665726C61792C202363626F784C6F6164696E67477261706869637B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B20776964';
wwv_flow_api.g_varchar2_table(6) := '74683A313030253B206865696768743A313030253B7D0D0A2363626F7850726576696F75732C202363626F784E6578742C202363626F78436C6F73652C202363626F78536C69646573686F777B637572736F723A706F696E7465723B7D0D0A2E63626F78';
wwv_flow_api.g_varchar2_table(7) := '50686F746F7B666C6F61743A6C6566743B206D617267696E3A6175746F3B20626F726465723A303B20646973706C61793A626C6F636B3B7D0D0A2E63626F78496672616D657B77696474683A313030253B206865696768743A313030253B20646973706C';
wwv_flow_api.g_varchar2_table(8) := '61793A626C6F636B3B20626F726465723A303B7D0D0A0D0A2F2A200D0A2020202055736572205374796C653A0D0A202020204368616E67652074686520666F6C6C6F77696E67207374796C657320746F206D6F646966792074686520617070656172616E';
wwv_flow_api.g_varchar2_table(9) := '6365206F6620436F6C6F72426F782E202054686579206172650D0A202020206F72646572656420262074616262656420696E206120776179207468617420726570726573656E747320746865206E657374696E67206F66207468652067656E6572617465';
wwv_flow_api.g_varchar2_table(10) := '642048544D4C2E0D0A2A2F0D0A2363626F784F7665726C61797B6261636B67726F756E643A233030303B7D0D0A23636F6C6F72626F787B7D0D0A202020202363626F78436F6E74656E747B6D617267696E2D746F703A323070783B7D0D0A202020202020';
wwv_flow_api.g_varchar2_table(11) := '20202E63626F78496672616D657B6261636B67726F756E643A236666663B7D0D0A20202020202020202363626F784572726F727B70616464696E673A353070783B20626F726465723A31707820736F6C696420236363633B7D0D0A202020202020202023';
wwv_flow_api.g_varchar2_table(12) := '63626F784C6F61646564436F6E74656E747B626F726465723A35707820736F6C696420233030303B206261636B67726F756E643A236666663B7D0D0A20202020202020202363626F785469746C657B706F736974696F6E3A6162736F6C7574653B20746F';
wwv_flow_api.g_varchar2_table(13) := '703A2D323070783B206C6566743A303B20636F6C6F723A236363633B7D0D0A20202020202020202363626F7843757272656E747B706F736974696F6E3A6162736F6C7574653B20746F703A2D323070783B2072696768743A3070783B20636F6C6F723A23';
wwv_flow_api.g_varchar2_table(14) := '6363633B7D0D0A20202020202020202363626F78536C69646573686F777B706F736974696F6E3A6162736F6C7574653B20746F703A2D323070783B2072696768743A393070783B20636F6C6F723A236666663B7D0D0A20202020202020202363626F7850';
wwv_flow_api.g_varchar2_table(15) := '726576696F75737B706F736974696F6E3A6162736F6C7574653B20746F703A3530253B206C6566743A3570783B206D617267696E2D746F703A2D333270783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237433636F6E74';
wwv_flow_api.g_varchar2_table(16) := '726F6C732E706E6729206E6F2D72657065617420746F70206C6566743B2077696474683A323870783B206865696768743A363570783B20746578742D696E64656E743A2D3939393970783B7D0D0A20202020202020202363626F7850726576696F75733A';
wwv_flow_api.g_varchar2_table(17) := '686F7665727B6261636B67726F756E642D706F736974696F6E3A626F74746F6D206C6566743B7D0D0A20202020202020202363626F784E6578747B706F736974696F6E3A6162736F6C7574653B20746F703A3530253B2072696768743A3570783B206D61';
wwv_flow_api.g_varchar2_table(18) := '7267696E2D746F703A2D333270783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237433636F6E74726F6C732E706E6729206E6F2D72657065617420746F702072696768743B2077696474683A323870783B206865696768';
wwv_flow_api.g_varchar2_table(19) := '743A363570783B20746578742D696E64656E743A2D3939393970783B7D0D0A20202020202020202363626F784E6578743A686F7665727B6261636B67726F756E642D706F736974696F6E3A626F74746F6D2072696768743B7D0D0A202020202020202023';
wwv_flow_api.g_varchar2_table(20) := '63626F784C6F6164696E674F7665726C61797B6261636B67726F756E643A233030303B7D0D0A20202020202020202363626F784C6F6164696E67477261706869637B6261636B67726F756E643A75726C2823504C5547494E5F5052454649582374336C6F';
wwv_flow_api.g_varchar2_table(21) := '6164696E672E67696629206E6F2D7265706561742063656E7465722063656E7465723B7D0D0A20202020202020202363626F78436C6F73657B706F736974696F6E3A6162736F6C7574653B20746F703A3570783B2072696768743A3570783B2064697370';
wwv_flow_api.g_varchar2_table(22) := '6C61793A626C6F636B3B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237433636F6E74726F6C732E706E6729206E6F2D72657065617420746F702063656E7465723B2077696474683A333870783B206865696768743A3139';
wwv_flow_api.g_varchar2_table(23) := '70783B20746578742D696E64656E743A2D3939393970783B7D0D0A20202020202020202363626F78436C6F73653A686F7665727B6261636B67726F756E642D706F736974696F6E3A626F74746F6D2063656E7465723B7D';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16859157612557506 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't3colorbox.css'
 ,p_mime_type => 'text/css'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2A0D0A20202020436F6C6F72426F7820436F7265205374796C653A0D0A2020202054686520666F6C6C6F77696E672043535320697320636F6E73697374656E74206265747765656E206578616D706C65207468656D657320616E642073686F756C6420';
wwv_flow_api.g_varchar2_table(2) := '6E6F7420626520616C74657265642E0D0A2A2F0D0A23636F6C6F72626F782C202363626F784F7665726C61792C202363626F78577261707065727B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B207A2D696E646578';
wwv_flow_api.g_varchar2_table(3) := '3A393939393B206F766572666C6F773A68696464656E3B7D0D0A2363626F784F7665726C61797B706F736974696F6E3A66697865643B2077696474683A313030253B206865696768743A313030253B7D0D0A2363626F784D6964646C654C6566742C2023';
wwv_flow_api.g_varchar2_table(4) := '63626F78426F74746F6D4C6566747B636C6561723A6C6566743B7D0D0A2363626F78436F6E74656E747B706F736974696F6E3A72656C61746976653B7D0D0A2363626F784C6F61646564436F6E74656E747B6F766572666C6F773A6175746F3B7D0D0A23';
wwv_flow_api.g_varchar2_table(5) := '63626F785469746C657B6D617267696E3A303B7D0D0A2363626F784C6F6164696E674F7665726C61792C202363626F784C6F6164696E67477261706869637B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B20776964';
wwv_flow_api.g_varchar2_table(6) := '74683A313030253B206865696768743A313030253B7D0D0A2363626F7850726576696F75732C202363626F784E6578742C202363626F78436C6F73652C202363626F78536C69646573686F777B637572736F723A706F696E7465723B7D0D0A2E63626F78';
wwv_flow_api.g_varchar2_table(7) := '50686F746F7B666C6F61743A6C6566743B206D617267696E3A6175746F3B20626F726465723A303B20646973706C61793A626C6F636B3B7D0D0A2E63626F78496672616D657B77696474683A313030253B206865696768743A313030253B20646973706C';
wwv_flow_api.g_varchar2_table(8) := '61793A626C6F636B3B20626F726465723A303B7D0D0A0D0A2F2A200D0A2020202055736572205374796C653A0D0A202020204368616E67652074686520666F6C6C6F77696E67207374796C657320746F206D6F646966792074686520617070656172616E';
wwv_flow_api.g_varchar2_table(9) := '6365206F6620436F6C6F72426F782E202054686579206172650D0A202020206F72646572656420262074616262656420696E206120776179207468617420726570726573656E747320746865206E657374696E67206F66207468652067656E6572617465';
wwv_flow_api.g_varchar2_table(10) := '642048544D4C2E0D0A2A2F0D0A2363626F784F7665726C61797B6261636B67726F756E643A236666663B7D0D0A23636F6C6F72626F787B7D0D0A202020202363626F78546F704C6566747B77696474683A323570783B206865696768743A323570783B20';
wwv_flow_api.g_varchar2_table(11) := '6261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572312E706E6729206E6F2D726570656174203020303B7D0D0A202020202363626F78546F7043656E7465727B6865696768743A323570783B206261636B6772';
wwv_flow_api.g_varchar2_table(12) := '6F756E643A75726C2823504C5547494E5F505245464958237434626F72646572312E706E6729207265706561742D782030202D353070783B7D0D0A202020202363626F78546F7052696768747B77696474683A323570783B206865696768743A32357078';
wwv_flow_api.g_varchar2_table(13) := '3B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572312E706E6729206E6F2D726570656174202D3235707820303B7D0D0A202020202363626F78426F74746F6D4C6566747B77696474683A323570783B20';
wwv_flow_api.g_varchar2_table(14) := '6865696768743A323570783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572312E706E6729206E6F2D7265706561742030202D323570783B7D0D0A202020202363626F78426F74746F6D43656E746572';
wwv_flow_api.g_varchar2_table(15) := '7B6865696768743A323570783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572312E706E6729207265706561742D782030202D373570783B7D0D0A202020202363626F78426F74746F6D52696768747B';
wwv_flow_api.g_varchar2_table(16) := '77696474683A323570783B206865696768743A323570783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572312E706E6729206E6F2D726570656174202D32357078202D323570783B7D0D0A2020202023';
wwv_flow_api.g_varchar2_table(17) := '63626F784D6964646C654C6566747B77696474683A323570783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572322E706E6729207265706561742D79203020303B7D0D0A202020202363626F784D6964';
wwv_flow_api.g_varchar2_table(18) := '646C6552696768747B77696474683A323570783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572322E706E6729207265706561742D79202D3235707820303B7D0D0A202020202363626F78436F6E7465';
wwv_flow_api.g_varchar2_table(19) := '6E747B6261636B67726F756E643A236666663B206F766572666C6F773A68696464656E3B7D0D0A20202020202020202E63626F78496672616D657B6261636B67726F756E643A236666663B7D0D0A20202020202020202363626F784572726F727B706164';
wwv_flow_api.g_varchar2_table(20) := '64696E673A353070783B20626F726465723A31707820736F6C696420236363633B7D0D0A20202020202020202363626F784C6F61646564436F6E74656E747B6D617267696E2D626F74746F6D3A323070783B7D0D0A20202020202020202363626F785469';
wwv_flow_api.g_varchar2_table(21) := '746C657B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A3070783B206C6566743A303B20746578742D616C69676E3A63656E7465723B2077696474683A313030253B20636F6C6F723A233939393B7D0D0A20202020202020202363626F';
wwv_flow_api.g_varchar2_table(22) := '7843757272656E747B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A3070783B206C6566743A31303070783B20636F6C6F723A233939393B7D0D0A20202020202020202363626F78536C69646573686F777B706F736974696F6E3A6162';
wwv_flow_api.g_varchar2_table(23) := '736F6C7574653B20626F74746F6D3A3070783B2072696768743A343270783B20636F6C6F723A233434343B7D0D0A20202020202020202363626F7850726576696F75737B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A3070783B206C';
wwv_flow_api.g_varchar2_table(24) := '6566743A303B20636F6C6F723A233434343B7D0D0A20202020202020202363626F784E6578747B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A3070783B206C6566743A363370783B20636F6C6F723A233434343B7D0D0A2020202020';
wwv_flow_api.g_varchar2_table(25) := '2020202363626F784C6F6164696E674F7665726C61797B6261636B67726F756E643A236666662075726C2823504C5547494E5F5052454649582374346C6F6164696E672E67696629206E6F2D72657065617420357078203570783B7D0D0A202020202020';
wwv_flow_api.g_varchar2_table(26) := '20202363626F78436C6F73657B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A303B2072696768743A303B20646973706C61793A626C6F636B3B20636F6C6F723A233434343B7D0D0A0D0A2F2A0D0A202054686520666F6C6C6F77696E';
wwv_flow_api.g_varchar2_table(27) := '6720666978657320612070726F626C656D2077686572652049453720616E6420494538207265706C616365206120504E47277320616C706861207472616E73706172656E63792077697468206120626C61636B2066696C6C0D0A20207768656E20616E20';
wwv_flow_api.g_varchar2_table(28) := '616C7068612066696C74657220286F706163697479206368616E67652920697320736574206F6E2074686520656C656D656E74206F7220616E636573746F7220656C656D656E742E202054686973207374796C65206973206E6F74206170706C69656420';
wwv_flow_api.g_varchar2_table(29) := '746F206F72206E656564656420696E204945392E0D0A20205365653A20687474703A2F2F6A61636B6C6D6F6F72652E636F6D2F6E6F7465732F69652D7472616E73706172656E63792D70726F626C656D732F0D0A2A2F0D0A2E63626F784945202363626F';
wwv_flow_api.g_varchar2_table(30) := '78546F704C6566742C0D0A2E63626F784945202363626F78546F7043656E7465722C0D0A2E63626F784945202363626F78546F7052696768742C0D0A2E63626F784945202363626F78426F74746F6D4C6566742C0D0A2E63626F784945202363626F7842';
wwv_flow_api.g_varchar2_table(31) := '6F74746F6D43656E7465722C0D0A2E63626F784945202363626F78426F74746F6D52696768742C0D0A2E63626F784945202363626F784D6964646C654C6566742C0D0A2E63626F784945202363626F784D6964646C655269676874207B0D0A2020202066';
wwv_flow_api.g_varchar2_table(32) := '696C7465723A2070726F6769643A4458496D6167655472616E73666F726D2E4D6963726F736F66742E6772616469656E74287374617274436F6C6F727374723D2330304646464646462C656E64436F6C6F727374723D233030464646464646293B0D0A7D';
wwv_flow_api.g_varchar2_table(33) := '0D0A0D0A2F2A0D0A202054686520666F6C6C6F77696E672070726F766964657320504E47207472616E73706172656E637920737570706F727420666F72204945360D0A20204665656C206672656520746F2072656D6F7665207468697320616E64207468';
wwv_flow_api.g_varchar2_table(34) := '65202F6965362F206469726563746F727920696620796F7520686176652064726F707065642049453620737570706F72742E0D0A2A2F0D0A2E63626F78494536202363626F78546F704C6566747B6261636B67726F756E643A75726C2823504C5547494E';
wwv_flow_api.g_varchar2_table(35) := '5F505245464958237434626F72646572546F704C6566742E706E67293B7D0D0A2E63626F78494536202363626F78546F7043656E7465727B6261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572546F7043656E';
wwv_flow_api.g_varchar2_table(36) := '7465722E706E67293B7D0D0A2E63626F78494536202363626F78546F7052696768747B6261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572546F7052696768742E706E67293B7D0D0A2E63626F784945362023';
wwv_flow_api.g_varchar2_table(37) := '63626F78426F74746F6D4C6566747B6261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572426F74746F6D4C6566742E706E67293B7D0D0A2E63626F78494536202363626F78426F74746F6D43656E7465727B62';
wwv_flow_api.g_varchar2_table(38) := '61636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F72646572426F74746F6D43656E7465722E706E67293B7D0D0A2E63626F78494536202363626F78426F74746F6D52696768747B6261636B67726F756E643A75726C2823';
wwv_flow_api.g_varchar2_table(39) := '504C5547494E5F505245464958237434626F72646572426F74746F6D52696768742E706E67293B7D0D0A2E63626F78494536202363626F784D6964646C654C6566747B6261636B67726F756E643A75726C2823504C5547494E5F50524546495823743462';
wwv_flow_api.g_varchar2_table(40) := '6F726465724D6964646C654C6566742E706E67293B7D0D0A2E63626F78494536202363626F784D6964646C6552696768747B6261636B67726F756E643A75726C2823504C5547494E5F505245464958237434626F726465724D6964646C6552696768742E';
wwv_flow_api.g_varchar2_table(41) := '706E67293B7D0D0A0D0A2E63626F78494536202363626F78546F704C6566742C0D0A2E63626F78494536202363626F78546F7043656E7465722C0D0A2E63626F78494536202363626F78546F7052696768742C0D0A2E63626F78494536202363626F7842';
wwv_flow_api.g_varchar2_table(42) := '6F74746F6D4C6566742C0D0A2E63626F78494536202363626F78426F74746F6D43656E7465722C0D0A2E63626F78494536202363626F78426F74746F6D52696768742C0D0A2E63626F78494536202363626F784D6964646C654C6566742C0D0A2E63626F';
wwv_flow_api.g_varchar2_table(43) := '78494536202363626F784D6964646C655269676874207B0D0A202020205F6265686176696F723A2065787072657373696F6E28746869732E737263203D20746869732E737263203F20746869732E737263203A20746869732E63757272656E745374796C';
wwv_flow_api.g_varchar2_table(44) := '652E6261636B67726F756E64496D6167652E73706C697428272227295B315D2C20746869732E7374796C652E6261636B67726F756E64203D20226E6F6E65222C20746869732E7374796C652E66696C746572203D202270726F6769643A4458496D616765';
wwv_flow_api.g_varchar2_table(45) := '5472616E73666F726D2E4D6963726F736F66742E416C706861496D6167654C6F61646572287372633D22202B20746869732E737263202B20222C2073697A696E674D6574686F643D277363616C65272922293B0D0A7D0D0A';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16859855887558272 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4colorbox.css'
 ,p_mime_type => 'text/css'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2A0D0A20202020436F6C6F72426F7820436F7265205374796C653A0D0A2020202054686520666F6C6C6F77696E672043535320697320636F6E73697374656E74206265747765656E206578616D706C65207468656D657320616E642073686F756C6420';
wwv_flow_api.g_varchar2_table(2) := '6E6F7420626520616C74657265642E0D0A2A2F0D0A23636F6C6F72626F782C202363626F784F7665726C61792C202363626F78577261707065727B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B207A2D696E646578';
wwv_flow_api.g_varchar2_table(3) := '3A393939393B206F766572666C6F773A68696464656E3B7D0D0A2363626F784F7665726C61797B706F736974696F6E3A66697865643B2077696474683A313030253B206865696768743A313030253B7D0D0A2363626F784D6964646C654C6566742C2023';
wwv_flow_api.g_varchar2_table(4) := '63626F78426F74746F6D4C6566747B636C6561723A6C6566743B7D0D0A2363626F78436F6E74656E747B706F736974696F6E3A72656C61746976653B7D0D0A2363626F784C6F61646564436F6E74656E747B6F766572666C6F773A6175746F3B7D0D0A23';
wwv_flow_api.g_varchar2_table(5) := '63626F785469746C657B6D617267696E3A303B7D0D0A2363626F784C6F6164696E674F7665726C61792C202363626F784C6F6164696E67477261706869637B706F736974696F6E3A6162736F6C7574653B20746F703A303B206C6566743A303B20776964';
wwv_flow_api.g_varchar2_table(6) := '74683A313030253B206865696768743A313030253B7D0D0A2363626F7850726576696F75732C202363626F784E6578742C202363626F78436C6F73652C202363626F78536C69646573686F777B637572736F723A706F696E7465723B7D0D0A2E63626F78';
wwv_flow_api.g_varchar2_table(7) := '50686F746F7B666C6F61743A6C6566743B206D617267696E3A6175746F3B20626F726465723A303B20646973706C61793A626C6F636B3B7D0D0A2E63626F78496672616D657B77696474683A313030253B206865696768743A313030253B20646973706C';
wwv_flow_api.g_varchar2_table(8) := '61793A626C6F636B3B20626F726465723A303B7D0D0A0D0A2F2A200D0A2020202055736572205374796C653A0D0A202020204368616E67652074686520666F6C6C6F77696E67207374796C657320746F206D6F646966792074686520617070656172616E';
wwv_flow_api.g_varchar2_table(9) := '6365206F6620436F6C6F72426F782E202054686579206172650D0A202020206F72646572656420262074616262656420696E206120776179207468617420726570726573656E747320746865206E657374696E67206F66207468652067656E6572617465';
wwv_flow_api.g_varchar2_table(10) := '642048544D4C2E0D0A2A2F0D0A2363626F784F7665726C61797B6261636B67726F756E643A233030303B7D0D0A23636F6C6F72626F787B7D0D0A202020202363626F78546F704C6566747B77696474683A313470783B206865696768743A313470783B20';
wwv_flow_api.g_varchar2_table(11) := '6261636B67726F756E643A75726C2823504C5547494E5F505245464958237435636F6E74726F6C732E706E6729206E6F2D726570656174203020303B7D0D0A202020202363626F78546F7043656E7465727B6865696768743A313470783B206261636B67';
wwv_flow_api.g_varchar2_table(12) := '726F756E643A75726C2823504C5547494E5F505245464958237435626F726465722E706E6729207265706561742D7820746F70206C6566743B7D0D0A202020202363626F78546F7052696768747B77696474683A313470783B206865696768743A313470';
wwv_flow_api.g_varchar2_table(13) := '783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237435636F6E74726F6C732E706E6729206E6F2D726570656174202D3336707820303B7D0D0A202020202363626F78426F74746F6D4C6566747B77696474683A31347078';
wwv_flow_api.g_varchar2_table(14) := '3B206865696768743A343370783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237435636F6E74726F6C732E706E6729206E6F2D7265706561742030202D333270783B7D0D0A202020202363626F78426F74746F6D43656E';
wwv_flow_api.g_varchar2_table(15) := '7465727B6865696768743A343370783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237435626F726465722E706E6729207265706561742D7820626F74746F6D206C6566743B7D0D0A202020202363626F78426F74746F6D';
wwv_flow_api.g_varchar2_table(16) := '52696768747B77696474683A313470783B206865696768743A343370783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237435636F6E74726F6C732E706E6729206E6F2D726570656174202D33367078202D333270783B7D';
wwv_flow_api.g_varchar2_table(17) := '0D0A202020202363626F784D6964646C654C6566747B77696474683A313470783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237435636F6E74726F6C732E706E6729207265706561742D79202D313735707820303B7D0D';
wwv_flow_api.g_varchar2_table(18) := '0A202020202363626F784D6964646C6552696768747B77696474683A313470783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237435636F6E74726F6C732E706E6729207265706561742D79202D323131707820303B7D0D';
wwv_flow_api.g_varchar2_table(19) := '0A202020202363626F78436F6E74656E747B6261636B67726F756E643A236666663B206F766572666C6F773A76697369626C653B7D0D0A20202020202020202E63626F78496672616D657B6261636B67726F756E643A236666663B7D0D0A202020202020';
wwv_flow_api.g_varchar2_table(20) := '20202363626F784572726F727B70616464696E673A353070783B20626F726465723A31707820736F6C696420236363633B7D0D0A20202020202020202363626F784C6F61646564436F6E74656E747B6D617267696E2D626F74746F6D3A3570783B7D0D0A';
wwv_flow_api.g_varchar2_table(21) := '20202020202020202363626F784C6F6164696E674F7665726C61797B6261636B67726F756E643A75726C2823504C5547494E5F5052454649582374356C6F6164696E675F6261636B67726F756E642E706E6729206E6F2D7265706561742063656E746572';
wwv_flow_api.g_varchar2_table(22) := '2063656E7465723B7D0D0A20202020202020202363626F784C6F6164696E67477261706869637B6261636B67726F756E643A75726C2823504C5547494E5F5052454649582374356C6F6164696E672E67696629206E6F2D7265706561742063656E746572';
wwv_flow_api.g_varchar2_table(23) := '2063656E7465723B7D0D0A20202020202020202363626F785469746C657B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A2D323570783B206C6566743A303B20746578742D616C69676E3A63656E7465723B2077696474683A31303025';
wwv_flow_api.g_varchar2_table(24) := '3B20666F6E742D7765696768743A626F6C643B20636F6C6F723A233743374337433B7D0D0A20202020202020202363626F7843757272656E747B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A2D323570783B206C6566743A35387078';
wwv_flow_api.g_varchar2_table(25) := '3B20666F6E742D7765696768743A626F6C643B20636F6C6F723A233743374337433B7D0D0A20202020202020200D0A20202020202020202363626F7850726576696F75732C202363626F784E6578742C202363626F78436C6F73652C202363626F78536C';
wwv_flow_api.g_varchar2_table(26) := '69646573686F777B706F736974696F6E3A6162736F6C7574653B20626F74746F6D3A2D323970783B206261636B67726F756E643A75726C2823504C5547494E5F505245464958237435636F6E74726F6C732E706E6729206E6F2D72657065617420307078';
wwv_flow_api.g_varchar2_table(27) := '203070783B2077696474683A323370783B206865696768743A323370783B20746578742D696E64656E743A2D3939393970783B7D0D0A20202020202020202363626F7850726576696F75737B6C6566743A3070783B206261636B67726F756E642D706F73';
wwv_flow_api.g_varchar2_table(28) := '6974696F6E3A202D35317078202D323570783B7D0D0A20202020202020202363626F7850726576696F75733A686F7665727B6261636B67726F756E642D706F736974696F6E3A2D35317078203070783B7D0D0A20202020202020202363626F784E657874';
wwv_flow_api.g_varchar2_table(29) := '7B6C6566743A323770783B206261636B67726F756E642D706F736974696F6E3A2D37357078202D323570783B7D0D0A20202020202020202363626F784E6578743A686F7665727B6261636B67726F756E642D706F736974696F6E3A2D3735707820307078';
wwv_flow_api.g_varchar2_table(30) := '3B7D0D0A20202020202020202363626F78436C6F73657B72696768743A303B206261636B67726F756E642D706F736974696F6E3A2D3130307078202D323570783B7D0D0A20202020202020202363626F78436C6F73653A686F7665727B6261636B67726F';
wwv_flow_api.g_varchar2_table(31) := '756E642D706F736974696F6E3A2D3130307078203070783B7D0D0A20202020202020200D0A20202020202020202E63626F78536C69646573686F775F6F6E202363626F78536C69646573686F777B6261636B67726F756E642D706F736974696F6E3A2D31';
wwv_flow_api.g_varchar2_table(32) := '32357078203070783B2072696768743A323770783B7D0D0A20202020202020202E63626F78536C69646573686F775F6F6E202363626F78536C69646573686F773A686F7665727B6261636B67726F756E642D706F736974696F6E3A2D3135307078203070';
wwv_flow_api.g_varchar2_table(33) := '783B7D0D0A20202020202020202E63626F78536C69646573686F775F6F6666202363626F78536C69646573686F777B6261636B67726F756E642D706F736974696F6E3A2D3135307078202D323570783B2072696768743A323770783B7D0D0A2020202020';
wwv_flow_api.g_varchar2_table(34) := '2020202E63626F78536C69646573686F775F6F6666202363626F78536C69646573686F773A686F7665727B6261636B67726F756E642D706F736974696F6E3A2D3132357078203070783B7D';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16860554377559019 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't5colorbox.css'
 ,p_mime_type => 'text/css'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2866756E6374696F6E2861297B612E776964676574282275692E617065785F6D6F64616C5F70616765222C7B6F7074696F6E733A7B7472616E736974696F6E3A6E756C6C2C6C6F6164696E67496D6167655372633A6E756C6C2C696E697469616C486569';
wwv_flow_api.g_varchar2_table(2) := '6768743A6E756C6C2C696E697469616C57696474683A6E756C6C2C6F7665726C61794F7061636974793A6E756C6C2C7363726F6C6C696E673A6E756C6C2C647261676761626C653A6E756C6C7D2C5F6372656174655072697661746553746F726167653A';
wwv_flow_api.g_varchar2_table(3) := '66756E6374696F6E28297B76617220623D746869733B6966286128222370646562756722292E6C656E677468297B617065782E646562756728274D6F64616C2050616765202D20537461727420225F6372656174655072697661746553746F7261676522';
wwv_flow_api.g_varchar2_table(4) := '27297D622E5F76616C7565733D7B75726C3A6E756C6C2C6469616C6F675469746C653A6E756C6C2C636C6F736553656C6563746F723A6E756C6C2C70726576656E7444656661756C743A6E756C6C2C68656967687457696474684D6F64653A6E756C6C2C';
wwv_flow_api.g_varchar2_table(5) := '6865696768743A6E756C6C2C77696474683A6E756C6C2C636C6F7365456C656D656E7453656C6563746F723A6E756C6C2C6D6F64616C5061676549643A6E756C6C2C6D6F64616C50616765436C6F736556616C75653A6E756C6C2C6469616C6F67546F70';
wwv_flow_api.g_varchar2_table(6) := '3A302C6469616C6F674C6566743A302C696672616D654865696768743A302C696672616D6557696474683A302C686173565363726F6C6C3A66616C73652C686173485363726F6C6C3A66616C73652C6175746F436C6F7365643A66616C73652C64656275';
wwv_flow_api.g_varchar2_table(7) := '673A6128222370646562756722292E6C656E677468213D3D307D3B622E5F656C656D656E74733D7B2477696E646F773A7B7D2C246469616C6F673A7B7D2C24777261707065723A7B7D2C24696672616D653A7B7D7D3B696628622E5F76616C7565732E64';
wwv_flow_api.g_varchar2_table(8) := '65627567297B617065782E646562756728274D6F64616C2050616765202D20456E6420225F6372656174655072697661746553746F726167652227297D7D2C5F6372656174653A66756E6374696F6E28297B76617220633D746869733B76617220623D6E';
wwv_flow_api.g_varchar2_table(9) := '657720496D61676528293B622E7372633D632E6F7074696F6E732E6C6F6164696E67496D6167655372633B6966286128222370646562756722292E6C656E677468297B617065782E646562756728274D6F64616C2050616765202D20537461727420225F';
wwv_flow_api.g_varchar2_table(10) := '6372656174652227293B617065782E646562756728222E2E2E4F7074696F6E7322293B666F72286E616D6520696E20632E6F7074696F6E73297B617065782E646562756728222E2E2E2E2E2E222B6E616D652B273A2022272B632E6F7074696F6E735B6E';
wwv_flow_api.g_varchar2_table(11) := '616D655D2B272227297D7D632E5F6372656174655072697661746553746F7261676528293B632E5F656C656D656E74732E2477696E646F773D612877696E646F77293B696628632E5F76616C7565732E6465627567297B617065782E646562756728274D';
wwv_flow_api.g_varchar2_table(12) := '6F64616C2050616765202D20456E6420225F6372656174652227297D7D2C6F70656E506167653A66756E6374696F6E28642C632C662C652C622C67297B76617220683D746869733B76617220693D7B7469746C653A756E646566696E65642C636C6F7365';
wwv_flow_api.g_varchar2_table(13) := '53656C6563746F723A756E646566696E65642C6D6F64616C5061676549643A756E646566696E65642C6865696768743A756E646566696E65647D3B696628682E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C20506167';
wwv_flow_api.g_varchar2_table(14) := '65202D20537461727420226F70656E506167652227297D682E5F76616C7565732E6175746F436C6F7365643D66616C73653B682E5F76616C7565732E6469616C6F675469746C653D643B682E5F76616C7565732E636C6F7365456C656D656E7453656C65';
wwv_flow_api.g_varchar2_table(15) := '63746F723D633B682E5F76616C7565732E6D6F64616C5061676549643D663B682E5F76616C7565732E68656967687457696474684D6F64653D653B682E5F76616C7565732E6865696768743D623B682E5F76616C7565732E77696474683D673B612E636F';
wwv_flow_api.g_varchar2_table(16) := '6C6F72626F78287B7472616E736974696F6E3A682E6F7074696F6E732E7472616E736974696F6E2C7469746C653A682E5F76616C7565732E6469616C6F675469746C652C6865696768743A682E6F7074696F6E732E696E697469616C4865696768742B22';
wwv_flow_api.g_varchar2_table(17) := '7078222C77696474683A682E6F7074696F6E732E696E697469616C57696474682B227078222C696672616D653A747275652C7363726F6C6C696E673A682E6F7074696F6E732E7363726F6C6C696E672C66617374496672616D653A66616C73652C6F7665';
wwv_flow_api.g_varchar2_table(18) := '726C6179436C6F73653A66616C73652C6F7061636974793A682E6F7074696F6E732E6F7665726C61794F7061636974792C687265663A682E5F76616C7565732E75726C2C6F6E4F70656E3A66756E6374696F6E28297B696628682E6F7074696F6E732E64';
wwv_flow_api.g_varchar2_table(19) := '7261676761626C65297B61282223636F6C6F72626F7822292E647261676761626C6528292E6373732822637572736F72222C226D6F766522297D6128646F63756D656E74292E747269676765722822617065786D6F64616C706167656F70656E22297D2C';
wwv_flow_api.g_varchar2_table(20) := '6F6E436F6D706C6574653A66756E6374696F6E28297B682E5F68616E646C65496672616D654C6F616428293B6128646F63756D656E74292E747269676765722822617065786D6F64616C70616765636F6D706C65746522297D2C6F6E436C65616E75703A';
wwv_flow_api.g_varchar2_table(21) := '66756E6374696F6E28297B682E5F656C656D656E74732E2477696E646F772E756E62696E642822726573697A65222C682E5F636865636B526573697A6554696D6572293B69662821682E5F76616C7565732E6175746F436C6F736564297B6128646F6375';
wwv_flow_api.g_varchar2_table(22) := '6D656E74292E7472696767657228226D6F64616C706167656D616E75616C636C6F7365222C7B6D6F64616C5061676549643A682E5F76616C7565732E6D6F64616C5061676549642C6D6F64616C50616765436C6F736556616C75653A2828682E5F76616C';
wwv_flow_api.g_varchar2_table(23) := '7565732E6D6F64616C50616765436C6F736556616C7565293F682E5F76616C7565732E6D6F64616C50616765436C6F736556616C75653A2222297D297D682E5F76616C7565732E6D6F64616C50616765436C6F736556616C75653D6E756C6C7D2C6F6E43';
wwv_flow_api.g_varchar2_table(24) := '6C6F7365643A66756E6374696F6E28297B6128646F63756D656E74292E747269676765722822617065786D6F64616C70616765636C6F73656422297D7D293B682E5F656C656D656E74732E2477696E646F772E62696E642822726573697A65222C7B7569';
wwv_flow_api.g_varchar2_table(25) := '773A687D2C682E5F636865636B526573697A6554696D6572293B696628682E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20456E6420226F70656E506167652227297D7D2C6F70656E506167654672';
wwv_flow_api.g_varchar2_table(26) := '6F6D41706578546869733A66756E6374696F6E2869297B76617220673D746869733B76617220653D692E616374696F6E2E61747472696275746530323B76617220683D692E616374696F6E2E61747472696275746530333B76617220643D692E61637469';
wwv_flow_api.g_varchar2_table(27) := '6F6E2E61747472696275746530353B76617220633D692E616374696F6E2E61747472696275746530373B76617220623B76617220663B696628672E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D2053';
wwv_flow_api.g_varchar2_table(28) := '7461727420226F70656E5061676546726F6D41706578546869732227297D696628653D3D3D2253544154494322297B672E5F76616C7565732E75726C3D687D656C73657B696628653D3D3D22545249475F454C454D454E545F4154545222297B672E5F76';
wwv_flow_api.g_varchar2_table(29) := '616C7565732E75726C3D6128692E74726967676572696E67456C656D656E74292E617474722864297D7D696628633D3D3D224155544F22297B623D66616C73653B663D66616C73657D656C73657B696628633D3D3D225354415449435F505822297B623D';
wwv_flow_api.g_varchar2_table(30) := '692E616374696F6E2E61747472696275746530382B227078223B663D692E616374696F6E2E61747472696275746530392B227078227D656C73657B696628633D3D3D225354415449435F2522297B623D692E616374696F6E2E6174747269627574653038';
wwv_flow_api.g_varchar2_table(31) := '2B2225223B663D692E616374696F6E2E61747472696275746530392B2225227D7D7D672E6F70656E5061676528692E616374696F6E2E61747472696275746530312C692E616374696F6E2E61747472696275746530362C692E616374696F6E2E61747472';
wwv_flow_api.g_varchar2_table(32) := '696275746531302C632C622C66293B696628672E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20456E6420226F70656E5061676546726F6D41706578546869732227297D7D2C5F68616E646C654966';
wwv_flow_api.g_varchar2_table(33) := '72616D654C6F61643A66756E6374696F6E28297B76617220653D746869733B652E5F656C656D656E74732E24696672616D653D61282223636F6C6F72626F7820696672616D6522293B76617220623D652E5F656C656D656E74732E24696672616D652E63';
wwv_flow_api.g_varchar2_table(34) := '6F6E74656E747328292E66696E6428652E5F76616C7565732E636C6F7365456C656D656E7453656C6563746F72293B76617220643D652E5F656C656D656E74732E24696672616D652E6765742830292E636F6E74656E7457696E646F773B76617220633D';
wwv_flow_api.g_varchar2_table(35) := '642E617065782E6A51756572793B696628652E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20537461727420225F68616E646C65496672616D654C6F61642227297D6328652E5F656C656D656E7473';
wwv_flow_api.g_varchar2_table(36) := '2E24696672616D652E636F6E74656E747328292E676574283029292E62696E642822617065786265666F7265706167657375626D6974222C66756E6374696F6E28297B6128222363626F784C6F61646564436F6E74656E7422292E6869646528293B6128';
wwv_flow_api.g_varchar2_table(37) := '222363626F784C6F6164696E674F7665726C617922292E73686F7728293B6128222363626F784C6F6164696E674772617068696322292E73686F7728297D293B652E5F656C656D656E74732E24696672616D652E636F6E74656E747328292E66696E6428';
wwv_flow_api.g_varchar2_table(38) := '2223617065782D6465762D746F6F6C6261722C2368746D6C6462446576546F6F6C62617222292E72656D6F766528293B696628622E6C656E677468297B652E5F76616C7565732E6175746F436C6F7365643D747275653B6A51756572792E636F6C6F7262';
wwv_flow_api.g_varchar2_table(39) := '6F782E636C6F736528293B6128646F63756D656E74292E7472696767657228226D6F64616C706167656175746F636C6F7365222C7B6D6F64616C5061676549643A652E5F76616C7565732E6D6F64616C5061676549642C22246D6F64616C50616765436C';
wwv_flow_api.g_varchar2_table(40) := '6F73654F626A656374223A622E636C6F6E652874727565297D297D656C73657B652E5F656C656D656E74732E24696672616D652E636F6E74656E747328292E66696E642822626F647922292E63737328226D617267696E222C2230707822293B61282223';
wwv_flow_api.g_varchar2_table(41) := '63626F784C6F6164696E674F7665726C617922292E6869646528293B6128222363626F784C6F6164696E674772617068696322292E6869646528293B6128222363626F784C6F61646564436F6E74656E7422292E73686F7728293B652E5F726573697A65';
wwv_flow_api.g_varchar2_table(42) := '4D6F64616C28293B652E5F656C656D656E74732E24696672616D652E72656D6F7665436C617373282275692D68656C7065722D68696464656E2D61636365737369626C6522293B652E5F656C656D656E74732E24696672616D652E6F6E6528226C6F6164';
wwv_flow_api.g_varchar2_table(43) := '222C66756E6374696F6E28297B652E5F68616E646C65496672616D654C6F616428297D297D696628652E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20456E6420225F68616E646C65496672616D65';
wwv_flow_api.g_varchar2_table(44) := '4C6F61642227297D7D2C5F726573697A654D6F64616C3A66756E6374696F6E2862297B76617220633D746869733B696628632E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20537461727420225F72';
wwv_flow_api.g_varchar2_table(45) := '6573697A654D6F64616C2227297D632E5F656C656D656E74732E2477696E646F772E756E62696E642822726573697A65222C632E5F636865636B526573697A6554696D6572293B69662862297B6A51756572792E636F6C6F72626F782E726573697A6528';
wwv_flow_api.g_varchar2_table(46) := '7B77696474683A622E77696474682C6865696768743A622E6865696768742C696E6E65724865696768743A622E696E6E65724865696768742C696E6E657257696474683A622E696E6E657257696474687D297D656C73657B696628632E5F76616C756573';
wwv_flow_api.g_varchar2_table(47) := '2E68656967687457696474684D6F64653D3D3D224155544F22297B6A51756572792E636F6C6F72626F782E726573697A65287B696E6E65724865696768743A632E5F656C656D656E74732E24696672616D652E636F6E74656E747328292E686569676874';
wwv_flow_api.g_varchar2_table(48) := '28292C696E6E657257696474683A632E5F656C656D656E74732E24696672616D652E636F6E74656E747328292E776964746828297D297D656C73657B6A51756572792E636F6C6F72626F782E726573697A65287B696E6E65724865696768743A632E5F76';
wwv_flow_api.g_varchar2_table(49) := '616C7565732E6865696768742C696E6E657257696474683A632E5F76616C7565732E77696474687D297D7D632E5F656C656D656E74732E2477696E646F772E62696E642822726573697A65222C7B7569773A637D2C632E5F636865636B526573697A6554';
wwv_flow_api.g_varchar2_table(50) := '696D6572293B696628632E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20456E6420225F726573697A654D6F64616C2227297D7D2C5F636865636B526573697A6554696D65723A66756E6374696F6E';
wwv_flow_api.g_varchar2_table(51) := '2863297B76617220623D632E646174612E7569773B696628622E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20537461727420225F636865636B526573697A6554696D65722227297D696628622E5F';
wwv_flow_api.g_varchar2_table(52) := '76616C7565732E74696D6572297B636C65617254696D656F757428622E5F76616C7565732E74696D6572297D622E5F76616C7565732E74696D65723D73657454696D656F75742866756E6374696F6E28297B622E5F68616E646C6557696E646F77526573';
wwv_flow_api.g_varchar2_table(53) := '697A6528297D2C3530293B696628622E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20456E6420225F636865636B526573697A6554696D65722227297D7D2C5F68616E646C6557696E646F77526573';
wwv_flow_api.g_varchar2_table(54) := '697A653A66756E6374696F6E28297B76617220623D746869733B696628622E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20537461727420225F68616E646C6557696E646F77526573697A65222729';
wwv_flow_api.g_varchar2_table(55) := '7D696628622E5F76616C7565732E68656967687457696474684D6F6465213D3D224155544F22297B622E5F726573697A654D6F64616C28297D696628622E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C205061676520';
wwv_flow_api.g_varchar2_table(56) := '2D20456E6420225F68616E646C6557696E646F77526573697A652227297D7D2C636C6F73653A66756E6374696F6E2863297B76617220623D746869733B696628622E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050';
wwv_flow_api.g_varchar2_table(57) := '616765202D2053746172742022636C6F73652227297D622E5F76616C7565732E6D6F64616C50616765436C6F736556616C75653D633B6A51756572792E636F6C6F72626F782E636C6F736528293B696628622E5F76616C7565732E6465627567297B6170';
wwv_flow_api.g_varchar2_table(58) := '65782E646562756728274D6F64616C2050616765202D20456E642022636C6F73652227297D7D2C726573697A653A66756E6374696F6E2862297B7569773D746869733B6966287569772E5F76616C7565732E6465627567297B617065782E646562756728';
wwv_flow_api.g_varchar2_table(59) := '274D6F64616C2050616765202D2053746172742022726573697A652227297D7569772E5F726573697A654D6F64616C2862293B6966287569772E5F76616C7565732E6465627567297B617065782E646562756728274D6F64616C2050616765202D20456E';
wwv_flow_api.g_varchar2_table(60) := '642022726573697A652227297D7D7D297D2928617065782E6A5175657279293B';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16861251574560286 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 'apex_modal_page.min.js'
 ,p_mime_type => 'application/javascript'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000001000000320103000000A73523C900000006504C5445000000FFFFFFA5D99FDD0000000174524E5380AD5E5B460000001849444154785E95C1010D0000008230A31B9D066CFC330F0526820B01E3EC9A99';
wwv_flow_api.g_varchar2_table(2) := '0000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16862644026563788 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1border.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000001000000150103000000BD9C164700000006504C5445000000FFFFFFA5D99FDD0000000174524E5380AD5E5B460000001749444154785E7DC1210100000083B0477F7434866DD7007AAA03813389C49000';
wwv_flow_api.g_varchar2_table(2) := '00000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16863341006565141 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1borderBottomCenter.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000150000001504030000005B39B8A500000027504C5445000000000000000000656565B7B7B7000000000000CFCFCF000000000000000000000000FFFFFF94C88E050000000C74524E538000789FC75830D7';
wwv_flow_api.g_varchar2_table(2) := '386810181AE7B20E0000005349444154785E85CAB10D8020180561125DE05991D83088235830028D5B50390133D0B18503FC4311A289579878D5579C7B32B3EBCB19DEE019763B3CE5E1FF021CE1042FB08755E00AAFE1B51AAC13D6716F1D361416074A';
wwv_flow_api.g_varchar2_table(3) := 'BD57B20000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16864039065566074 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1borderBottomLeft.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000150000001504030000005B39B8A500000027504C5445000000000000000000656565B7B7B7000000000000CFCFCF000000000000000000000000FFFFFF94C88E050000000C74524E538000789FC75830D7';
wwv_flow_api.g_varchar2_table(2) := '386810181AE7B20E0000005549444154785E9DC6B10D80201005D0CB55DA791BD858D938822338026E60C2048EE0086C426179434142E05F2879D523558D54F47FCC0FFC27FCC43D0D5ACD2F7387F2824FE61FCE01DFA57D0EEDFC4AFD764B7E02967416';
wwv_flow_api.g_varchar2_table(3) := '07AA8DD7170000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16864737124566933 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1borderBottomRight.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000150000000101030000000B9E775800000006504C5445000000FFFFFFA5D99FDD0000000174524E5380AD5E5B460000001449444154785E0580B1090000004094FFFF350A6C010200FC69A300E400000000';
wwv_flow_api.g_varchar2_table(2) := '49454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16865468167567747 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1borderMiddleLeft.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000150000000101030000000B9E775800000006504C5445000000FFFFFFA5D99FDD0000000174524E5380AD5E5B460000001449444154785E05C001090000008020FF8F8E100302FE00FFBFDBF57F00000000';
wwv_flow_api.g_varchar2_table(2) := '49454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16866165579568974 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1borderMiddleRight.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000001000000150103000000BD9C164700000006504C5445000000FFFFFFA5D99FDD0000000174524E5380AD5E5B460000001749444154785E7DC1210100000083B0477F742C8A6DE50E18AA0381149316F900';
wwv_flow_api.g_varchar2_table(2) := '00000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16866862991570162 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1borderTopCenter.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000150000001504030000005B39B8A500000027504C5445000000000000000000000000000000000000000000000000656565CFCFCFB7B7B7000000FFFFFF3B8665F90000000C74524E538000783058106838';
wwv_flow_api.g_varchar2_table(2) := '9FD7C7183A2073AD0000005449444154785E9DC6A10D80401044D19104070681D9121014400D0834355007256C091441015B147709D99920F9E63F74A5D950AB3ECA5E6F488F46AFA0777A00EBC59378111BFED5F89DBE22DD067D8A5D1C1F3F3EC015AD';
wwv_flow_api.g_varchar2_table(3) := '86FEAAE00000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16867560403571376 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1borderTopLeft.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000150000001504030000005B39B8A500000027504C5445000000000000000000000000000000000000000000656565000000CFCFCFB7B7B7000000FFFFFF96FF543C0000000C74524E53800078583868109F';
wwv_flow_api.g_varchar2_table(2) := '30D7C718E289AB9F0000005249444154785E8DC6B10D406010C7D17F2EF46E03895263052318E1DBC0086CA0D31A452D379484E27E85C2AB9E1EDDEAEE8D5E36E65597BC7ADC4A5E135EE1866BC107BCD51FB1E371E0171E33BEE1E7C76FFB181607D27D';
wwv_flow_api.g_varchar2_table(3) := '175A0000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16868158031572426 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1borderTopRight.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000B0000000320806000000FCCF518D0000001974455874536F6674776172650041646F626520496D616765526561647971C9653C00000AEF4944415478DAEC5D5B6C14D719FEC137ECD8E035361787C66014';
wwv_flow_api.g_varchar2_table(2) := '1A2EA5126E5A356D95982E455C525AA4A86DA2A65221CB53D4F6A1AA5B449F1A8C1FA884821F705BA9A18E4915A04A534C2319DC848221C9D6A1D4405C2EB5C1C6368ED76137BE81E5CE77D8339C1DCFCCCECCEECCEE2CF349471EEFCECC37FF9E6FFEF3';
wwv_flow_api.g_varchar2_table(3) := '9FCBFC338388F690054C4D4DFD823CD8811912E2ED532595CA68F1397C7D21A95C8B96A0019D4C1934BACECAC5643F8C0A191B1B6365D6AC59ACB80810AE3F05A215E18B5E07BF96162342B60B6921E05BB76ED1F0F0308D8C8C4CFBAEA0A0808A8B8B69';
wwv_flow_api.g_varchar2_table(4) := 'E1C2850F330744F35CD4E3A613F87541CC6F46BDB3B3CD552A430854F6D5AB57E50A2E2C2AA2ECAC2CF9FB7B939314098765412C5DBA9489C02A47494989EC71F3F3F369747454F6C843434349E148821DCA10022209A4D8EB1A0D2D1A9422B63B844899';
wwv_flow_api.g_varchar2_table(5) := '80AF5FBFCE44830A2F292BA782FC5CCAC99A11D3A443587727A768647482866EF7320140844B962C31C581637C3E1F65E5E469724CDE1DA7502824EF6F94E3C6CD9B34D0DF6FDA8E79F3E7D3E7162D8A2760B7885753C41919037361A1128B0A0B256F34';
wwv_flow_api.g_varchar2_table(6) := '47753F16A34A7F8B1EC9A7BCEC290A47224C2C403C81891CC5BEB9EC1C7A1C924F6602CFCEC9B1C461D50E0D11733CE722F18A214543C6C6C0686E8D084B0934B9101880CA8747D56A86458EB2D252C31D355C4B4E56A9698E44ECB82FFC62BD9106B7A1';
wwv_flow_api.g_varchar2_table(7) := '327AED8E74EC663A6D1D624534B7A838A3952E0A0CC7E1781E736A71200CC0BE664719B03F8EC3F1F1386CB6C3EFE2811EC7AEDD5101A397CEBD90E87510479E3C7992156C739C3E73867D86BFA207E3C7F2F3A971141495E876C62E5DBA44E1CF4635BD';
wwv_flow_api.g_varchar2_table(8) := '248E8FC7A1B4432DC4D0F3C43A7654B92C74D01A6ACB2C01A3D985D7C108404C654A4DF0952B57A8ADAD8D8E3737336141B4FF686D659F95F862EB921F8FF3697120D68C77331D7AFD4F31378C087EBC1E87D20E11478F1E95AEFDACEE35E8D85149EE47';
wwv_flow_api.g_varchar2_table(9) := '65C60918BD6F0C31299B7534A91B366E64DBB76FDFA653EFB6D299D3A7D9FFCB972F6745D9CCA389571B6FD5E28060E111798168C0F5C6A143AA9ED20A07176353D321E6E12391700CA7924787C313703A8F42A801BDF167AAAB99D76D6F6F679F959595';
wwv_flow_api.g_varchar2_table(10) := 'D1BAF51B54C565161014BCB912E888EDDCB993B66FDF4E6BD7AE35CC218EF38AA1106E88898909F9666C6A6A92841CA1AEAE2EAAA8A8A0DADA5A231CBE0C10B02336CC4C85655A1557B5660DE5E6E6B20AEFE8E8A095AB5699EE20191520840B8ECECE4E';
wwv_flow_api.g_varchar2_table(11) := '1A1F1FA7FAFA7A6A96C217A3C0E484C8010F2F8A17801DDDDDDD3287870CF0C0F7EEDED5891BFF4267CF3E881BEBF7EFA7952B56989E1953E340D30E3185C3615531AD5FBF9E3646C3182B1C982286076F68B83F043A3838E8A92B534308BE9046443018';
wwv_flow_api.g_varchar2_table(12) := 'A423470EB3ED6DDBB651636323135A5D5D5D4CB3CB8F37CB81E6FBE9A79F91FFBF70E1DFCC33E6E5E54D0B1FAC7254555551201090455C5A5A1AC3A99CE830C26115D275F8A4E297AEC9542C2AD5C335E9FA5BA412F204AC007AEE68BA314120563CBCE3';
wwv_flow_api.g_varchar2_table(13) := 'DEBD7BD9F6B265CB98279C2379DDDF4A9F4164E8D16FDDBA35A6E2F934B4510E880B85430A4D595CBA6BD7AE699D44AB1C9CA7A6A686F64BAD07C2A1E79FFF81EE0DA0C591088E1D3BE6977E434BC35810FC810307025BB66C096EDAB4A9C513B0385C26';
wwv_flow_api.g_varchar2_table(14) := '89123D6E2CA211C3828E8B1769F3E667D97675F57D8FF5B5A79EA2FEBE3EA992C75911C117E1A885169C03D3B57AA147C5E20A76D368AD0EC3F1F138947670600A1A374673F371DDDF43CF8E54885704CE219D8BD25DC48E2FE641A8005859F5C5BD359F';
wwv_flow_api.g_varchar2_table(15) := 'BD123D6A2A38E039710358E540C70F378282038B792CD509C20678CF640A64C78E1D0D09841335762FE6717C1402A202B0F24B6B264C0BD81FC789E789C7A13611114F58463920BE44ECC0F17A1C16049CF4295C3BCEE9EA4E1CBC1506EFF9FADB499D05';
wwv_flow_api.g_varchar2_table(16) := '336AC2E2CB1DF58E5172186DA613E1B0C30E2BF16BB2EBCB8E73BA7E14822F534425A223835810D3AACA477CF8A33FF89E3FE96074ADAEC8212E79D4E21097385AE1B0CB0E0F6928605EF9E8C523D6E453A9A8540095CF8798442F6A36A61539204E14CE';
wwv_flow_api.g_varchar2_table(17) := '2122591C76D9E1210D05CC9B617460F8B36462258B4356893CAF96291C1ED250C01CA8545EB1763D312C72B8D90E0F692860119952E19E709DC14CEF27F0E009D8838787398410C74695E08FC427DA6B7722B1891376784823012B1382888947C48E10DF';
wwv_flow_api.g_varchar2_table(18) := '27194947301EAC9674A4B7B797956470D86187873413303C22046326210804505E5E6ED8531A4D9E8267F2440E33930C4ED8E121CD04CC2BDD6C421034CF380E8857F94E244F71C20E0F69266034B7BCD2AD2604C1F198B2B53BE948BCC42676DB611658';
wwv_flow_api.g_varchar2_table(19) := '8C9EECB50B38A7370A2120D18420109591C4264E244FB1DB0EB3C09314C9AE2F3BCEE95A016B250439FCF776DA77B09595B6F6FB373C961C36FCF99FF2E7FD839F4E3B3691A423E0ECEAFD44D34B268B43CF13EB7158145BA8B9B93969299D70AE747FB4';
wwv_flow_api.g_varchar2_table(20) := '282D129B3CB9FA31EAFCDF002B475BCE33B1BE73EA329DFFB8877DE69B5340F34B1FC49746129B14CED66F967B068669FFEBEFD1E56B7DAADF1BE1D04A6C829BAFB6E11D6A7DBF53F71AF438AC024F502443C43887F74891023CADA8728AB5A27C2E6DF8';
wwv_flow_api.g_varchar2_table(21) := 'C60A3A7EEA22EBA9D7379DA24F863F63DFCD2D7E84BEEB5F3DAD53A45CEFABE4C048800878767E4E00DBE07AB5F15DDABAEE8BF4CDAF3E619A436DAA185EFD0F87DB642EF10601DF9A958F19E24854C4814020E83DD469076156966AC56FAEFE025DBD31';
wwv_flow_api.g_varchar2_table(22) := 'C83C2EAFFCB1897BB4E37B5F9F16631A5963A0DCE7FD0B5DECDCD3BCE99D51FAF5ABCD74E2DC7F69F74F9F35CCA166076E12B420102A076E10D8D17D4BEAF40D7C4A1D6FFFCA941D898413527933D347211CEFC461E2400BDFDFB886FD8D8C8C5367D7A0';
wwv_flow_api.g_varchar2_table(23) := '1436CCA647E7DB33E00FE17E74B9873EFAB89786C363F4D6890BF4F26F0E5BB6E35F1DDDD4F8F60731E2857061C7D9F35D4CBC1E32C003EB2536D9D7F81E7DF89F1B14898A00A27AF1DB4FD213950B12E6B81319A39B7DC334327E8F86240F0F7189F8FC';
wwv_flow_api.g_varchar2_table(24) := '927954F392DF32C7E38BCB68F1A373A5EBEFA621E9E6B8131E95EDF090411E98792695841E07DF3AC7048B4A2F9FF7A0C3F6F22B47A63D346934E988889C9C6C2A9E9D4FE56545B4EAF10554989F2B7FB7F62BCBE8B5DA1762BCBD590E84393FDFE6A7A5';
wwv_flow_api.g_varchar2_table(25) := '1565CCDB72F17E69E5A29862D08E500668CB111BD222B1093A3A75BF3FC1B621AC3FEE7E81F6FCAE854E9EEB6462A895B6C5F8D44AD2919A97D6C5ECF7A39A83F461C74DFAA1E4E195DF59E500709D5F5E55413BF7FD8DFDFFDA9E17756F000D0E8C2556';
wwv_flow_api.g_varchar2_table(26) := 'B95CC08E4C8038EA81F9B8274FE8217BDFBF7E207BA85F06BEC53CE1EE9F6D923FEBE90B514FFF83A1A678894DD43894985D5840AFFC64B3AA7813E5F88E7F351DD9F7E3182F6F92E31AB91F8ED89092C42636250489E100F4567D212CD19A414B566213';
wwv_flow_api.g_varchar2_table(27) := 'DC745A9DD038894DF017BFAF5BD3AC227CA88BEA24B3129B601556321282E03C5A30923C454BBC4693A718B1434BBC06ED6821F7C2B16B777C14021E4B7CB120CD5B60682D012A7D70A04F4E08A2B78ACB89A4230ED8112477BEA9C8D03B945D2B604099';
wwv_flow_api.g_varchar2_table(28) := '100442C1D4AF9A0050E1913BC30925367122798A4D766022C26D2F3A7474F224A5AF9AE5EB6979CF1EC2C28B0631CB8589028CB54218FC31202B8BC0C57816B023E94892EDF05E35EB1601AB09402BDE74C3CBBEF96B67B5A0F37A593D017311A7E3CBBE';
wwv_flow_api.g_varchar2_table(29) := 'C5B041F565DF0F8580951E53395C956C38917424013BD404CC8198D89F46DE3814EDB00575749279EF4AD683130F3B3A9174C4263B828ACE5D650AC41C8A7A5C473B6B5AF8BF00030015B9F633044DE3E40000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16868855443573654 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1controls.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '47494638396120002000F60000FFFFFFFF5500FEFBFAFEE3D6FEE6DAFEFCFCFED0BAFEAA80FEB08AFED4C0FEF8F6FEEFE8FEAF88FEA87EFEBFA0FEEEE6FE9F70FE8B52FEAB82FEECE4FEF6F2FEA77CFEC0A2FEC8AEFE7836FE7B3AFE7F40FE9B6AFEE7DC';
wwv_flow_api.g_varchar2_table(2) := 'FEF7F4FEA67AFEC3A6FEFAF8FEDAC8FE7C3CFE9C6CFEF0EAFEBE9EFEA478FED3BEFEE0D2FE7734FE7A38FEC7ACFED8C6FEDCCCFEF3EEFEE2D4FE7430FECCB4FED2BCFEC4A8FEF4F0FE9E6EFEB692FEE4D8FEEBE2FEAE86FE6012FE5F10FE6C24FE5E0EFE';
wwv_flow_api.g_varchar2_table(3) := '732EFEBB9AFEEAE0FEE8DEFEF2ECFECAB0FEBC9CFEB896FE9662FEB38EFEB794FE8346FE874CFE8A50FE8244FE864AFEB490FEDECEFE8448FE8042FEDFD0FED6C2FE884EFEBA98FE661AFE6F28FE7632FE6316FE6214FECFB8FE905AFE8C54FEC2A4FEA0';
wwv_flow_api.g_varchar2_table(4) := '72FE8F58FE935EFE9764FE925CFE8E56FE6B22FE6A20FE681EFE702AFEDBCAFED7C4FE9A68FECEB6FE9866FE722CFEC6AAFE6418FE9460FE671CFEA274FEA376FECBB2FE6E26FEAC84FE7E3EFEB28CFE5C0C00000000000000000000000000000021FF0B';
wwv_flow_api.g_varchar2_table(5) := '4E45545343415045322E30030100000021FE1A43726561746564207769746820616A61786C6F61642E696E666F0021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B39363493820F17218305353A3B';
wwv_flow_api.g_varchar2_table(6) := '12990A101822168214223B3D359E900B111918190E00141AAD3F820B3740028E02121A1929183200363C3E28004228D12E8F131B1A2A30A300041C8213D12814901C231A223386422F283892242B31C1861D988F0A141D058DFA8B02060C1224941097A8';
wwv_flow_api.g_varchar2_table(7) := '0090010408221A70A041050F2658282201AE5B220208186844D04211B46816111548E0C0C28713201415C0412088C2440A14A4CCD4CF450744145E3A2AC001C58B698548AC0312E95BB4098240CCC4014EE72202D15E60123AE0E64714401D3DF0494210';
wwv_flow_api.g_varchar2_table(8) := '54144401F80A22EF110505836E440B028BA620A62810BABA2D246082DCB978F3EADDCB7752200021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E870F138F8E172A585B938B0A1156595C0599830B312D831D4C9D';
wwv_flow_api.g_varchar2_table(9) := '510AA100200D494A338214A85A512082A08F24464A4C50B20A54565A5DA00B3740BA8C05474B4D514C530055573C5E004228DB2E8F0B264B501A088252A50013DB281493401E4B4A1786422F2838A1423132CB841D3493203AAC6AC42F510B224590AC18';
wwv_flow_api.g_varchar2_table(10) := '88A800900104D825A2E020A10D2752149150C74111882116425AB8A148DBB68E8A80243020E3890045057010082271918082AC1ABAE8808842CD470582A078D1AD10897A40323D5027A9152E0038D4FD64C461DB8B7F4707F03489A2A8A3A32F480822B0';
wwv_flow_api.g_varchar2_table(11) := '2D290064415E4E1238E8C6B620831570864A874248CE860BBCDEDDCBB7AFDFBF800705020021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E86244E3F148F8D123C650C958B1D4B3C664A209B8342322883344D3C';
wwv_flow_api.g_varchar2_table(12) := '674C0AA3002008606343821D54AB50A2001D952E5F61646017B064AB5C050A123340058E054462635D5D2C003F3E681F0036622D282E8F240C625C1148000221218255532828948F1308D23186402F2838A32E2753CE0C75A0B109C42E4601179190B162';
wwv_flow_api.g_varchar2_table(13) := 'C59483870A001940405E2216432EAC98C141110978283A2A7A72A2E4097E898480149988C200142F9A292A808340108B335F3D73D1EB10059CCF82C00C5788843E209B16809C20C8A0201C20812E120A93A0D101BD54C223EAC8C58017240411808714C0';
wwv_flow_api.g_varchar2_table(14) := '821B4104143C7883ECA0843A13014C8027246EC4055CEDEADDCBB7AFDFBD81000021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8624550E148F8D08583E47958B0A63586E5D209B8305374183146458684A0AA3';
wwv_flow_api.g_varchar2_table(15) := '822B5F105B821D5CAB11A2000F1D8F05365F1B1B6C002046AB46050A0D6E11388F171E5F6B6D2D000E19186F00485A3D70538F2E3F1E10620E00052D69826D3D654734950B44E52786475844CF9B142169050C090022AF5201018E023202F182C5141408';
wwv_flow_api.g_varchar2_table(16) := '131500328000254538D68550B34011091420392C9A0012A40B45424A8A542400C78D1B131615C04120C84599AF12BAE87588C24D5F4150BC385988C40B1440367D0419B358441C257F322229549ED11BBD529AAC4461C000128208804C0A6081A9888F04';
wwv_flow_api.g_varchar2_table(17) := 'A0BD3196544E42541085BC3D546001D1B978F3EADDCB576F200021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E864216431D8F8D48512245958B0A6B511971209B84200A831D621A1960A6A3000F444E6A829D1A';
wwv_flow_api.g_varchar2_table(18) := '2A63A2000B2E950908070D090020101A1823000A12294A1C8F4F360C0D1E280033505143005572593A3F8F1D174E391E2B0005524F8223DE3A17952EE3392C8636703B61149B1D282F87200CBC11E2AA510183136EDCC0B1A800900104F6297281A2220A';
wwv_flow_api.g_varchar2_table(19) := '1A8A48587436D1E24545423636C4A170C248024124362C68D005A54314543E2A10C41FAF42245EA000B249634593C30408C2615126A309155F60CC798352C88A371D292030808420021579EABA014468A5020705DDC83A282C4B004851103C5BA80089A8';
wwv_flow_api.g_varchar2_table(20) := '6C08E3CA9D4BB7EEA8400021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E862E2B6C0A8F8D25115433958B2026114D23029B891D739F622082202F0F954F6C28820A7411506BA20B5F6E51528E135E3F48690002';
wwv_flow_api.g_varchar2_table(21) := '0D114974000A5F6567724EBE2B16454E04007560116C003F76CE56758E20536F0E365B00052FB1024666727046148F146A6F25BD8547F046249B2041821CA2F0C68290518D405028D08804010213161568D18240874514506844414311898D1C306EE4A8';
wwv_flow_api.g_varchar2_table(22) := '480848460F6EDC88A8A8000E02402E326288B0510117320D5198B7A94010142F5C1822B10EC8A68F1A5982100500C7469E8E1E687CD191E88D8B26350A7D0482C0007F000868340A60C10D204C2BD1047063ECA0B53514014CD07830AEA10224B6DADDCB';
wwv_flow_api.g_varchar2_table(23) := 'B7AFDFBF7D03010021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E860503038F8E6C236D32948B200C6D6307059A890A779E5F2082203243148F24280FA99D5C740200241E296E478E0A6A31179302476D5C1200';
wwv_flow_api.g_varchar2_table(24) := '0A1530687663B68C1D21AB333800322346990E29CC3C3F8F1C2C062B210005379305236E76651BAD8E20042C5B1C864557656B249A05240B87285CF8E04254231038F831224180C0844513C0D8C960609182172832D25084E4CC151F6D508DC2A8511101';
wwv_flow_api.g_varchar2_table(25) := '360958DC60B4E0C68D878A0AE020004481C19B880AB8E88088023C4A0582A07851B010098C4034BDCA0813C4331C1951FC6CF420E38B8D476FF01412B5683C02371412C89814404B20CF800EBA417650289C821126641402171209AF75F3EADDCBB7AFA8';
wwv_flow_api.g_varchar2_table(26) := '400021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8720028F8E41453F40938C1F155F1F998A023F15100C920002096C1D8F054234820244A3079242775119488F414F213800050E153547052039782A2962A68B';
wwv_flow_api.g_varchar2_table(27) := '022F282D5324002177742D0033B829580E8F402852213782139805741929305FAB8E201CE20B8644293E104299ADAF861D752B5C7C6A0462823E4642081098B0684218371A642C02010D058A7E88F2E8D8984481228A162F2A3AD2A36413108B16DCB8C1';
wwv_flow_api.g_varchar2_table(28) := '50D1030F54A8841808AA59A3022EDE19A240E1538120285E082C44021AA6492442B68C240847C89E8F1E587CF1AAE88D5542420E8547E0063500042C1E5509A480CF4137C40E324B73D0048B070FDB162A4062ABDCBB78F3EADD8B37100021F904090500';
wwv_flow_api.g_varchar2_table(29) := '00002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90870A69210A918B53480C32978905439A3F0582022C321D901D9600021748393602002E47114D258F132F03420005754877B8204E54504C10B28C053728282F14002F3F082F';
wwv_flow_api.g_varchar2_table(30) := '00435D4D4C1A338F40CE280F8224E20512DA7815A88E201CCF2E865E4C781EF090052ED1861D5B75349D8C404CE8C54808010213163D688381099B45020680FB97C8861C2B569480501471A2221B59426A5C64F04642450FC48858F210E0A102149439C2';
wwv_flow_api.g_varchar2_table(31) := 'B7CE10057DF782BC3344E2050A209148803B0942190E70381B3D70F6E25FCF1BA88480B3C78EC00D12820838030A60C10D1CA3228505D0ECE7A0B12E273823E8B2500112540ADBCA9D4BB7AEDDB981000021F90409050000002C00000000200020000007';
wwv_flow_api.g_varchar2_table(32) := 'FF800082838485868788898A8B8C8D8E8F9088240B918C1C433337958A2C170E4383022F6A0A90202082059D251F050034446D631F8F242F03428269174417000225465C5D0DAE8D1C28282F14004075161C0006B25D4BBE8E38C9280F823424824E635D';
wwv_flow_api.g_varchar2_table(33) := '5439A58E20C82F34861764E4EB90052ECC860A275BF09B8A020F4142C689841020306111901A1A5424F992CF908001DA1A1ABA63A7228F2B32121580984C62210466429AB16340910B02370A2A7AB0210A13264E04E83354A083CD47F23A2062314467BC';
wwv_flow_api.g_varchar2_table(34) := '20CA5C182291E04B1BA1B5B4A90421134036290E50407A904C1D005B37740AD196EB110894DF0010480644D0821B3800E21C7483EC20B5FA132624EB3AB350011248EBEADDCBB7AF5FBE81000021F90409050000002C00000000200020000007FF800082';
wwv_flow_api.g_varchar2_table(35) := '838485868788898A8B8C8D8E8F90882002918C424F2C24958A0469322C83051C409120058337690632821D6F1E262D8F422F3742829D5B5300052B26106B0E8F1C28282F1400422D0613006A15C0625B8F38C5280F820A34820E5F6B46480A8F20C42FDB';
wwv_flow_api.g_varchar2_table(36) := '855B1B7136E78F052EC886202C27F19B8A020B4040F6884204049A29E230874A12266250241230C05ABB433952A4C04211C22944041C2ABAE3A66347088A5C10B82130110E084A94509943E09EA1021D625E64F4AEC321104386D8845420883117861C68';
wwv_flow_api.g_varchar2_table(37) := 'D13206E82312D6044E1294068A1E1D31203D28660E00895A368518C0A387082410233501C88882148005322A947487AA98595E2E14074D28762B6EA102248CDADDCBB7AFDFBF9B02010021F90409050000002C00000000200020000007FF800082838485';
wwv_flow_api.g_varchar2_table(38) := '868788898A8B8C8D8E8F908805918D1437040A948A1C28281C8420939005A200049D2F820A094417998E3437374282A75203000532473907288F41A814004203282E0052360C0D0D9F8E389D280B8220AF75CC265EA58C209C2FC3856A07740E1D91052E';
wwv_flow_api.g_varchar2_table(39) := 'E185204F21E79A8B02243838EB882E0404138B40076364BA40C095E854271A8A8E3089C2508307450651204C942783458B0F13512070839FA2091EC8800153E1593C42053A7478D5281DBC420262C478E9A840B017C80A31B022C7484E4724A479042140';
wwv_flow_api.g_varchar2_table(40) := '50981D5AACB081F4001542122F6E9C43A203A90348203892A8D5090800050DDC88F1386AD08DAE831E143D096042275A6C0E0B1520F133AEDDBB78F3EAA514080021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E';
wwv_flow_api.g_varchar2_table(41) := '8F909192840A40400293894028280F9983050583049C1C8205035304901D37374282A42841824F330E0E348F389C2F1D004203031400412B0E45552E8F139C280B820220822C1645477590201C282FC485525579170A91052EDF85023703E59F8905420F';
wwv_flow_api.g_varchar2_table(42) := '0FBF8A140404138B1379356D620D562592854257A21F64BA74891021872282061115694291E21D7B046EE853F4E08E988F3968BDA3A4C05DA373F5D46DD992D2518120DD9615CAC3E3CA86888D4838DB080213002356CED83100E9412F5D245EDCF855C4';
wwv_flow_api.g_varchar2_table(43) := '4A502FDA329288C50908000512B07031656ED08DAA83164C7BD70C05AC91840A909089B6ADDBB77004E3360A040021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840A40380293893828280F99830505';
wwv_flow_api.g_varchar2_table(44) := '83049C1C83241C14901D37374282A4284182402C062190139C2F1D00420303AA242132756C988E0F9C280B820220821CC533B88F021C282FAA8538751F09D090052EDB863841E19F8805342424C889140404138B0B44071E2648408AB12834147DD8B0A6';
wwv_flow_api.g_varchar2_table(45) := '8D4124FE96054CE460CC98300E6D289277A39E221247BE7C99630387BA420A14A46334AE97210A6F2E987C5420483617868EB8C132E7D52312CB2C820828800B0F343EE82878A42C5B40122FBEB0018084078F2B584E3C0241E0060958283C9029A0E04B';
wwv_flow_api.g_varchar2_table(46) := '99A75E22891274030591AD006878C0A264C0275D17148880E270F55301120B467EDCCBB7AFDFBF9002010021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928402130B0593893828280B99839883049C1C';
wwv_flow_api.g_varchar2_table(47) := '83142E911D04374282A3284182132F283890139C2F1D0042030314BC9C2D2F900B9C9D820220B2282D6A4090051C282FC085422D5328A18F052ED68642979F8BA71DDC88140404138B422B454E361FAD89AF28348A31070D15151E5B14DDCB97E8C29783';
wwv_flow_api.g_varchar2_table(48) := '0763285277A39D22214424DCB9E30015394220327673B1CB908B156C3A760B42CD22211B19343430D988C431874F4A29E08245059E0322193DC8950F880A3401ABF8C082018F974720569110F442C58E31054078188A61848068835AF8D841069310083E';
wwv_flow_api.g_varchar2_table(49) := '52FCF8F4E28A8E22A6D884FC44E148959C1708E3CA9D4BB72EA4400021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A3828280B9888049B1C831D1D910A1C044282A0284182132F2F978F';
wwv_flow_api.g_varchar2_table(50) := '0F9B2FA54203031400429BAD900BBF9D000220AFBFAA8F051C282FBC85BE283892052ED08614349E8C0A14C78B140404138B1D532B1F2B528BAC28DB892C554548483FF09FBFF887530CFE0C365C281277A3DCC037486C1061C7AD9000050296B9286588';
wwv_flow_api.g_varchar2_table(51) := '460C190A221508E24C60A11F4D2220D8C788C4AF72025AB802214603142A792836AAE56C5B0E39580C0070204243122A2B1E812070E31205153AE01829004242CF24260A40920A80048CA461A4BAF020228A054F6D92FE1844C100464F138EFC90D9B0AD';
wwv_flow_api.g_varchar2_table(52) := 'DBB77004E3460A040021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A1328280B9888049B1C832020910A1C044282A02841820F2F0334900F9B2F1D0042033714B99B2838900BBF9D0002';
wwv_flow_api.g_varchar2_table(53) := '02829A9BAA8F051C282FBD85429BC191052ED28614B39E8B0220058C14040413DF2F6A092CCC89AC28DD883775431717278BEFF1875216FE16061651E070E39CA20E0666BC8971C95B2101E29AB9C06588860C35A520150802CD85212F63DA54D1D688C4';
wwv_flow_api.g_varchar2_table(54) := 'AF73029E000100E24B042E71AA2878540BDA2C043C44E0FB4025029838311E812070E312053C56CA6C2800228F129F39223A8A280443D236E268DCA1D2E58DA71156789418D421CD94999826D87080D6A1DBB77005E3CA9514080021F90409050000002C';
wwv_flow_api.g_varchar2_table(55) := '00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052442938A0F28280B9888049B1C832005910A1C049700A02841820F2F371D909A282FB34203371400429B280F900BBF9D0002028213BFAA8E051CB6BC85422F283892052E';
wwv_flow_api.g_varchar2_table(56) := 'D1861D349E8C05A58C140404138B0540030340C88AAC28DD890F4F2D6969D6EEBFF1884132FE32AE1451E070C39C22102D4E9C9002C29B217090B0CDDAC6E249C3884150480961E802040F1F263A72B1E9C81C632150183BD0A6069D0F171B697A83C50B';
wwv_flow_api.g_varchar2_table(57) := '00273EF0180030244E9B1173123C02F1420C03011492D88161C25895303F7F4012500C07163B3EDA20A3E0C4489B189816A8C0AA5590828D3123515062C7CD1D8785102EE0A192066EA10724ECEADDCB9750200021F90409050000002C00000000200020';
wwv_flow_api.g_varchar2_table(58) := '000007FF800082838485868788898A8B8C8D8E8F9091928405242E938A0F2828249888049B1C830205910A1C044282A02841820F030420909A282F1D0042033714B99B280B900BBFC100A48213BFAA8F051CB6BD85422F283892052ED0861D349E8CA58D';
wwv_flow_api.g_varchar2_table(59) := '140404138B0540BBD58BAC28DC89C3BFD99FBFED88EF9BF187141C37E48A05412F06A4EB46F05A10018640A0B8811052B322587E1892C1C0C6160590842030B30382B1342F8C39A970E7089B868D6658E901670680221994240060600EC93C2D1EA5C9E0';
wwv_flow_api.g_varchar2_table(60) := '268F800E4B52E0B963CCCB1C0F12D84022F14010092629447C29D5C182893B52303D8D5AE39B801BAE30B9689222830982853C447D8396D082126F0830B69D4BB7AEA0400021F90409050000002C00000000200020000007FF800082838485868788898A';
wwv_flow_api.g_varchar2_table(61) := '8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820F031C02909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BAC48BAB28DC89C2';
wwv_flow_api.g_varchar2_table(62) := '9BB6EABEED8842BEF18A141C37E48A0538043800EB4610480919B20A090882E39BA309497AC829612884831569123AAAB243079C3900043CB92168868D121F5A4032A1234B991500883419C302801A0436887C78F0A88586144E047418136589130005EA';
wwv_flow_api.g_varchar2_table(63) := 'E0240204929074429644A1728014882D3F0C80C014358A920ADF6E79A241C6EB1D8285EE78AD839610890F7508B6B69D4BB7AEA0400021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F';
wwv_flow_api.g_varchar2_table(64) := '2828249888049B1C8305920A1C044282A02841820B374102909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BA9D8BAB28DC89C29B03B28AEBED8842BEF18B141C37E4';
wwv_flow_api.g_varchar2_table(65) := '8A05380870A8D7AD1B0E0727E415227129D20425597858307443068B20DF1A1D8123A74C0500055EB4027062C59629231D799063C6CD10005EB8D47802408A85156CD48078F4040A9E220214ACE962A404C8295E569CD8F9480831002EC2748973849480';
wwv_flow_api.g_varchar2_table(66) := '1709AA617211A74B983C19BBD110E3D546C14247BC1A381BED8201A66C06E3CA9D0B20100021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A0';
wwv_flow_api.g_varchar2_table(67) := '2841820B3740A48F9A282F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28C140404138B0540BAA98BAB28DB8924BE37DE88036A09319D8942EFF1872D614D26B71215C0412008BB451D84ECE34608';
wwv_flow_api.g_varchar2_table(68) := '079121200EB9B814294817336E1C18A215EB11893065AEF89000A000016A0050849082E2C1230721DDA85801E0420D0903000439B192C0230976DCA4C823408189352668A6E429CA919408518ADCA251630D1D8D2581005100C9C538413420AC99438421';
wwv_flow_api.g_varchar2_table(69) := '210A73D67CB160969003B56A0DDA0EA220838500B978F3E60D040021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820B3740A48F9A28';
wwv_flow_api.g_varchar2_table(70) := '2F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28CB937138B0540BA978A42604A3512378A24BE048B24293D3D3B1FE8F18C174C2935D80A15C0412048C0431D5C78E36668828518200EB9380709C8';
wwv_flow_api.g_varchar2_table(71) := '181F2AF215828722D623216D7CA410910700396200800C7BE404C6482875006C9150A5154714A21A81E0922243140705403068E0E484A009D21E3C629041839388142434C8135310058A8D28C838A1C0EA9D060886302404220FD82D63091938E024675A';
wwv_flow_api.g_varchar2_table(72) := '931C07A8BD9D4B976E200021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202';
wwv_flow_api.g_varchar2_table(73) := 'B10013BDBF8E051CB4CA83422F283892052ECF841D349142A88DC68C2B18306B9D890540B9DB8A42183BEF6F8A24BD048B241959597033ECBDA28B439A889883AD50011C0482143CA4C005B851861ECC3000E21085858B70B41101E5822112D2603D1202';
wwv_flow_api.g_varchar2_table(74) := '010F132A555A5D020044D8A32A269570310040CD8F21C384F402E208441B264DBACC28208048911952043D78F1C25B23274D2210A948C346910F2C06755000A9C314355C01742852C48B1A8884047C286201055A42380D2E2458F756D0C3BA78F3D60D04';
wwv_flow_api.g_varchar2_table(75) := '0021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202B10013BDBF8E051CB4CA';
wwv_flow_api.g_varchar2_table(76) := '83422F283892052ECF841D34912EA88DC68C432218239D8905400304D8864278567070178A24BDA28A42516666656FF8F68C627449E2811D251C04821834A48006B85186165C4820E01085858A26CC51C2858D2112D280407251810A99385E04D1502008';
wwv_flow_api.g_varchar2_table(77) := '482F6F8D1C2C211366841A005262A4D925A4D7044720E6D05C13A380802143D45003F0E0C5008C86888469F3A662871943A6DC2305025287102D8C81B83024C1568882580C39310CED2005370A7EBA9D4BB7AE5D4381000021F90409050000002C000000';
wwv_flow_api.g_varchar2_table(78) := '00200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A02841822404400590322D282F1D0042033714B89B28BC8F3910B40B8202B10013BEC08E40505F4FCC83422F283892380EC587';
wwv_flow_api.g_varchar2_table(79) := '1D348F052E2442028DC88A245F1A19221BA88905400304B7895E76763C3C650EE7BEA28933DC0814E84591105FAC1291A0D304CA920697DEE178A56051251211472122C12604394314A4395A70204E8D048648540302890682381BE8D411A400842020BE';
wwv_flow_api.g_varchar2_table(80) := 'DC357A6364C31C094F00047932E0D6C14DDB180990B0E14B8513000AB0A0C512C00379151DCD70CA869C0035B4FE01380649819417C80AA4A1AAB11090272F0D44B6A590B5ADDDBB78F32A0A040021F90409050000002C00000000200020000007FF8000';
wwv_flow_api.g_varchar2_table(81) := '82838485868788898A8B8C8D8E8F9091928405422E938A0F28282498831D0583049B1C9E00694D3F4282A3284182240440A18F733D29061D0042033714BB9B28BF8F123B3D460F8202B413C1C38E38493B654F86422F283892383F6CB4851D348F053496';
wwv_flow_api.g_varchar2_table(82) := '028DDF892C1B4D4C495F9D8905400304BA88204658FB3030488A2482BDC2B7218341830E1409090644518B0D64C88C61100F51011CB2402C022144883853895C2478926E1085678F48389973A7852112D81A3EA25085CE813C090481D0080047B08F8DD8';
wwv_flow_api.g_varchar2_table(83) := '983880E0C70D003007E85AB869C123220718207109A095CC05F578365293A7889A50056E6C1A08A0404946139289DAA40D24215E040D14B82D6476AEDDBB78F31E0A040021F90409050000002C00000000200020000007FF800082838485868788898A8B';
wwv_flow_api.g_varchar2_table(84) := '8C8D8E8F9091928405422E938A0F2828249883144283049B1C9E002D4D294582A328418224044005901E593A56060042033714BB9B28BF8F0C705A3B128202B40013C1C38E385470671786422F28389213255BCC851D348F05344234E08AE9886973644B';
wwv_flow_api.g_varchar2_table(85) := '111EA189054003041D89203551511A1A7888282211EC152201749A2854384391906040144931D1A6CD081BF31015C0210BC422102E5C40337588469A1BEB045118E9C885853C3F6E1822912DE223106F8E54F9804210088F0070041BE70885932A5E623C';
wwv_flow_api.g_varchar2_table(86) := '00407340BE879B3A15AD62E1C200569B6C2EB807B49182136C640228706393C1B129190920C461D30292850E2870E0D015AEDDBB78F3EA5D14080021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405';
wwv_flow_api.g_varchar2_table(87) := '422E938A0F2828249883344283049B1C9E002D50195582A3284182240440059007665665320042033714BB9B28BF8F473C6756398202B40013C1C38E13643C767586422F283892135E32CC851D348F05142E34E08AE988520762617139E389054003040A';
wwv_flow_api.g_varchar2_table(88) := '8902155D5D114B4B2E2822110C88BE3B6312261CA24848414503189830D1C0C13C440570C802B14800051A1D4C29EAF0C2E0210AD01E5188E185CD034324B2997C74E2439D29DB0080E00800C7B3472456D439F1645CCC01211D6EBAE4C8051B19695E02';
wwv_flow_api.g_varchar2_table(89) := '686572C18D200220D9EB04A0C08D4DAF04AD9B1464D30291851404993016ADDBB77005E3CA4514080021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840F172E93840B13845F4D522498005349782582';
wwv_flow_api.g_varchar2_table(90) := '142A4A521CA1156E576E4400141964284182240440058F4E306E766806004E6D3714004228CCC98E0F6130683C158213BD0013CC28CE8E37D13E1686422F2838920F1F1702871D3490EE14D88BF3892F477310104EEF890540030828482420CF9A366DC4';
wwv_flow_api.g_varchar2_table(91) := '1861A388C43620FE907C99389158A265CC2026E2500501022717BA1D2A8063178845023A5018184A91021C42105110E9084488044F2E1522514EE3A317539EA0D80400C4490038B6D1741942E88B773C077450B64D67A3020350BC0005804046410B6EE0';
wwv_flow_api.g_varchar2_table(92) := 'A8C748C102AB3798E11244761210660B0F5A1A1230E19ADCBB78F3EADD8B29100021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B45330A938242172184743B3A479902071822168214783B3D2699';
wwv_flow_api.g_varchar2_table(93) := '345C19292A0E00141AAC4482240440058F0C1A1958183200363C5828004228CE148F131B1A2A301282040F8213CE28D08F1C231A223386422F283892242B3102871D34900A141DBF8CF78A421639121225DF101500328000A644431A54F0E0C144024524';
wwv_flow_api.g_varchar2_table(94) := 'BA0151148381458B2CF44954E4828D03071F4E74505400472F108C1428409969910017230F5108F8A80007142F5C1822816E22246ECE260802C11247379A8C08387B218FE78091CD9E410282930436673E17DC5007A9808B83006E380B32285F4BA328AC';
wwv_flow_api.g_varchar2_table(95) := 'B63424E081DAB57007E3CA9D4B576E20003B000000000000000000';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16869552640574974 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1loading.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000280000002808060000008CFEB86D000000644944415458C3EDD9B10DC0300CC4C01F41237B438FA21198C6459A944114809CE00075AF240950C0029AEFEB63A9DC709B796DA072B4535B1972D6C77387E1';
wwv_flow_api.g_varchar2_table(2) := '09142850A0408102050A142850A0408102050A1428F055600FF6F52F26E0D923FAF437C405F1FDCBC98CD47AF60000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16870243366579234 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1loading_background.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D494844520000001E0000001E0403000000C91EB39100000030504C5445FFFFFF0707070808081414141717170000000000000000000000000000000000000000000000000000000000000000006E6A76E400000041494441';
wwv_flow_api.g_varchar2_table(2) := '54789CECCEA10D002010C5D0AE503620B7C1850DD87F2724F91A8BA979A6B48E75C3D4DA372437C993644996644996E44172F1FF9EFE0E000000FFFF03002A7338C822DD04790000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16870940994580259 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't1overlay.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D494844520000007D000000320803000000465024AE0000004B504C5445BFBFBF9F9F9FEFEFEFFFFFFF8787870F0F0F3F3F3F7F7F7FDFDFDF808080000000CFCFCF979797B7B7B76F6F6FAFAFAFE7E7E7F7F7F72F2F2FA7A7';
wwv_flow_api.g_varchar2_table(2) := 'A78F8F8FC7C7C75F5F5FD7D7D74F4F4F00B3460C000001AA49444154785EEDD5D96AEC300C00502DDE9D7D96F6FFBFF47AC284D2B1CC44507A1F6A3D2460111D142205F87F46D7BB7E9381DBAA03C2225384087C4324495F8728037110F875300F643175';
wwv_flow_api.g_varchar2_table(3) := '126216F5102332C618047D31B1A5C702D54439DD1F0221352AF55CF0888897EFC88C88255175B3BB263F2E8BA0C7CBAAD1211EF1D2F711A3C4C71A3F6A0D745E1F634B7FC72F2CEBD1D0691D7E5E1FCEEB9CDFE959F9E671E5B3FA516C0480974A00E36E';
wwv_flow_api.g_varchar2_table(4) := '48B881E657372B278E86F6C40DA49CB8CC4A9DD7B9A18BE3B398E7B6117A3781B57A7BD3CA9B8BE8B8550AB11804F0C11F00D4FF715DFFEDE87AD7BBDEF5AB0C5C495932CB5470CEF3D5B920E9B42519489BC0D3661F48B675D227147548C9B14B09043D';
wwv_flow_api.g_varchar2_table(5) := 'DBD4D253816AA29CEE0F79213529752C7872CE7D7E47EEE5A824AA6E76D7E2E392053D7D9246F7E98897BE8F98243ED5F8516B0BE7F529B5F4777C66594F369CD6FDCFEBDB799DF19D8ECA37EF88CFEA47B1C97BFF52C9FB693724DCFAE65777574E5CD8';
wwv_flow_api.g_varchar2_table(6) := 'DA13B705E5C4212B75A67B4317C727DBE7B6117AB7C05ABDBD69513C0DE1B8554A603182F733CFDE87BFF88FEB7AD7BBFE0F185E5A60ACCE5D1E0000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16871665998583890 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't2controls.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '47494638396120002000F60000000000E2E2E20303032323232020200101013C3C3C7070706767673737370707071313136868687171715353531515157E7E7E9999996E6E6E1717170A0A0A737373515151474747B1B1B1AEAEAEA9A9A98383831E1E1E';
wwv_flow_api.g_varchar2_table(2) := '0808087575754E4E4E050505303030ACACAC818181111111555555777777383838272727B3B3B3B0B0B04848483131312C2C2C0E0E0E252525B7B7B74141413A3A3A4C4C4C0C0C0C8080806060602121211818186A6A6AD1D1D1D3D3D3C1C1C1D5D5D5B9';
wwv_flow_api.g_varchar2_table(3) := 'B9B95858581A1A1A1C1C1C1010104545455757575C5C5C8A8A8A6363635E5E5EA3A3A39E9E9E9A9A9AA5A5A5A0A0A06161612A2A2AA1A1A1A7A7A72828283535359C9C9C5A5A5ACACACABEBEBEB5B5B5CECECED0D0D03E3E3E9191919797975050507C7C';
wwv_flow_api.g_varchar2_table(4) := '7C9393938E8E8E898989909090959595C3C3C3C5C5C5C7C7C7BCBCBC2E2E2E333333858585404040878787BABABA4A4A4ACCCCCC8C8C8CC9C9C97A7A7A797979434343C0C0C06C6C6CAAAAAA656565D7D7D700000000000000000000000000000021FE1A';
wwv_flow_api.g_varchar2_table(5) := '43726561746564207769746820616A61786C6F61642E696E666F0021F904000500000021FF0B4E45545343415045322E3003010000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B39363493820F17218305353A3B';
wwv_flow_api.g_varchar2_table(6) := '12990A101822168214223B3D359E900B111918190E00141AAD3F820B3740028E02121A1929183200363C3E28004228D12E8F131B1A2A30A300041C8213D12814901C231A223386422F283892242B31C1861D988F0A141D058DFA8B02060C1224941097A8';
wwv_flow_api.g_varchar2_table(7) := '0090010408221A70A041050F2658282201AE5B220208186844D04211B46816111548E0C0C28713201415C0412088C2440A14A4CCD4CF450744145E3A2AC001C58B698548AC0312E95BB4098240CCC4014EE72202D15E60123AE0E64714401D3DF0494210';
wwv_flow_api.g_varchar2_table(8) := '54144401F80A22EF110505836E440B028BA620A62810BABA2D246082DCB978F3EADDCB7752200021F90400050001002C00000000200020000007FF800082838485868788898A8B8C8D8E870F138F8E172A585B938B0A1156595C0599830B312D831D4C9D';
wwv_flow_api.g_varchar2_table(9) := '510AA100200D494A338214A85A512082A08F24464A4C50B20A54565A5DA00B3740BA8C05474B4D514C530055573C5E004228DB2E8F0B264B501A088252A50013DB281493401E4B4A1786422F2838A1423132CB841D3493203AAC6AC42F510B224590AC18';
wwv_flow_api.g_varchar2_table(10) := '88A800900104D825A2E020A10D2752149150C74111882116425AB8A148DBB68E8A80243020E3890045057010082271918082AC1ABAE8808842CD470582A078D1AD10897A40323D5027A9152E0038D4FD64C461DB8B7F4707F03489A2A8A3A32F480822B0';
wwv_flow_api.g_varchar2_table(11) := '2D290064415E4E1238E8C6B620831570864A874248CE860BBCDEDDCBB7AFDFBF800705020021F90400050002002C00000000200020000007FF800082838485868788898A8B8C8D8E86244E3F148F8D123C650C958B1D4B3C664A209B8342322883344D3C';
wwv_flow_api.g_varchar2_table(12) := '674C0AA3002008606343821D54AB50A2001D952E5F61646017B064AB5C050A123340058E054462635D5D2C003F3E681F0036622D282E8F240C625C1148000221218255532828948F1308D23186402F2838A32E2753CE0C75A0B109C42E4601179190B162';
wwv_flow_api.g_varchar2_table(13) := 'C59483870A001940405E2216432EAC98C141110978283A2A7A72A2E4097E898480149988C200142F9A292A808340108B335F3D73D1EB10059CCF82C00C5788843E209B16809C20C8A0201C20812E120A93A0D101BD54C223EAC8C58017240411808714C0';
wwv_flow_api.g_varchar2_table(14) := '821B4104143C7883ECA0843A13014C8027246EC4055CEDEADDCBB7AFDFBD81000021F90400050003002C00000000200020000007FF800082838485868788898A8B8C8D8E8624550E148F8D08583E47958B0A63586E5D209B8305374183146458684A0AA3';
wwv_flow_api.g_varchar2_table(15) := '822B5F105B821D5CAB11A2000F1D8F05365F1B1B6C002046AB46050A0D6E11388F171E5F6B6D2D000E19186F00485A3D70538F2E3F1E10620E00052D69826D3D654734950B44E52786475844CF9B142169050C090022AF5201018E023202F182C5141408';
wwv_flow_api.g_varchar2_table(16) := '131500328000254538D68550B34011091420392C9A0012A40B45424A8A542400C78D1B131615C04120C84599AF12BAE87588C24D5F4150BC385988C40B1440367D0419B358441C257F322229549ED11BBD529AAC4461C000128208804C0A6081A9888F04';
wwv_flow_api.g_varchar2_table(17) := 'A0BD3196544E42541085BC3D546001D1B978F3EADDCB576F200021F90400050004002C00000000200020000007FF800082838485868788898A8B8C8D8E864216431D8F8D48512245958B0A6B511971209B84200A831D621A1960A6A3000F444E6A829D1A';
wwv_flow_api.g_varchar2_table(18) := '2A63A2000B2E950908070D090020101A1823000A12294A1C8F4F360C0D1E280033505143005572593A3F8F1D174E391E2B0005524F8223DE3A17952EE3392C8636703B61149B1D282F87200CBC11E2AA510183136EDCC0B1A800900104F6297281A2220A';
wwv_flow_api.g_varchar2_table(19) := '1A8A48587436D1E24545423636C4A170C248024124362C68D005A54314543E2A10C41FAF42245EA000B249634593C30408C2615126A309155F60CC798352C88A371D292030808420021579EABA014468A5020705DDC83A282C4B004851103C5BA80089A8';
wwv_flow_api.g_varchar2_table(20) := '6C08E3CA9D4BB7EEA8400021F90400050005002C00000000200020000007FF800082838485868788898A8B8C8D8E862E2B6C0A8F8D25115433958B2026114D23029B891D739F622082202F0F954F6C28820A7411506BA20B5F6E51528E135E3F48690002';
wwv_flow_api.g_varchar2_table(21) := '0D114974000A5F6567724EBE2B16454E04007560116C003F76CE56758E20536F0E365B00052FB1024666727046148F146A6F25BD8547F046249B2041821CA2F0C68290518D405028D08804010213161568D18240874514506844414311898D1C306EE4A8';
wwv_flow_api.g_varchar2_table(22) := '480848460F6EDC88A8A8000E02402E326288B0510117320D5198B7A94010142F5C1822B10EC8A68F1A5982100500C7469E8E1E687CD191E88D8B26350A7D0482C0007F000868340A60C10D204C2BD1047063ECA0B53514014CD07830AEA10224B6DADDCB';
wwv_flow_api.g_varchar2_table(23) := 'B7AFDFBF7D03010021F90400050006002C00000000200020000007FF800082838485868788898A8B8C8D8E860503038F8E6C236D32948B200C6D6307059A890A779E5F2082203243148F24280FA99D5C740200241E296E478E0A6A31179302476D5C1200';
wwv_flow_api.g_varchar2_table(24) := '0A1530687663B68C1D21AB333800322346990E29CC3C3F8F1C2C062B210005379305236E76651BAD8E20042C5B1C864557656B249A05240B87285CF8E04254231038F831224180C0844513C0D8C960609182172832D25084E4CC151F6D508DC2A8511101';
wwv_flow_api.g_varchar2_table(25) := '360958DC60B4E0C68D878A0AE020004481C19B880AB8E88088023C4A0582A07851B010098C4034BDCA0813C4331C1951FC6CF420E38B8D476FF01412B5683C02371412C89814404B20CF800EBA417650289C821126641402171209AF75F3EADDCBB7AFA8';
wwv_flow_api.g_varchar2_table(26) := '400021F90400050007002C00000000200020000007FF800082838485868788898A8B8C8D8E8720028F8E41453F40938C1F155F1F998A023F15100C920002096C1D8F054234820244A3079242775119488F414F213800050E153547052039782A2962A68B';
wwv_flow_api.g_varchar2_table(27) := '022F282D5324002177742D0033B829580E8F402852213782139805741929305FAB8E201CE20B8644293E104299ADAF861D752B5C7C6A0462823E4642081098B0684218371A642C02010D058A7E88F2E8D8984481228A162F2A3AD2A36413108B16DCB8C1';
wwv_flow_api.g_varchar2_table(28) := '50D1030F54A8841808AA59A3022EDE19A240E1538120285E082C44021AA6492442B68C240847C89E8F1E587CF1AAE88D5542420E8547E0063500042C1E5509A480CF4137C40E324B73D0048B070FDB162A4062ABDCBB78F3EADD8B37100021F904000500';
wwv_flow_api.g_varchar2_table(29) := '08002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90870A69210A918B53480C32978905439A3F0582022C321D901D9600021748393602002E47114D258F132F03420005754877B8204E54504C10B28C053728282F14002F3F082F';
wwv_flow_api.g_varchar2_table(30) := '00435D4D4C1A338F40CE280F8224E20512DA7815A88E201CCF2E865E4C781EF090052ED1861D5B75349D8C404CE8C54808010213163D688381099B45020680FB97C8861C2B569480501471A2221B59426A5C64F04642450FC48858F210E0A102149439C2';
wwv_flow_api.g_varchar2_table(31) := 'B7CE10057DF782BC3344E2050A209148803B0942190E70381B3D70F6E25FCF1BA88480B3C78EC00D12820838030A60C10D1CA3228505D0ECE7A0B12E273823E8B2500112540ADBCA9D4BB7AEDDB981000021F90400050009002C00000000200020000007';
wwv_flow_api.g_varchar2_table(32) := 'FF800082838485868788898A8B8C8D8E8F9088240B918C1C433337958A2C170E4383022F6A0A90202082059D251F050034446D631F8F242F03428269174417000225465C5D0DAE8D1C28282F14004075161C0006B25D4BBE8E38C9280F823424824E635D';
wwv_flow_api.g_varchar2_table(33) := '5439A58E20C82F34861764E4EB90052ECC860A275BF09B8A020F4142C689841020306111901A1A5424F992CF908001DA1A1ABA63A7228F2B32121580984C62210466429AB16340910B02370A2A7AB0210A13264E04E83354A083CD47F23A2062314467BC';
wwv_flow_api.g_varchar2_table(34) := '20CA5C182291E04B1BA1B5B4A90421134036290E50407A904C1D005B37740AD196EB110894DF0010480644D0821B3800E21C7483EC20B5FA132624EB3AB350011248EBEADDCBB7AF5FBE81000021F9040005000A002C00000000200020000007FF800082';
wwv_flow_api.g_varchar2_table(35) := '838485868788898A8B8C8D8E8F90882002918C424F2C24958A0469322C83051C409120058337690632821D6F1E262D8F422F3742829D5B5300052B26106B0E8F1C28282F1400422D0613006A15C0625B8F38C5280F820A34820E5F6B46480A8F20C42FDB';
wwv_flow_api.g_varchar2_table(36) := '855B1B7136E78F052EC886202C27F19B8A020B4040F6884204049A29E230874A12266250241230C05ABB433952A4C04211C22944041C2ABAE3A66347088A5C10B82130110E084A94509943E09EA1021D625E64F4AEC321104386D8845420883117861C68';
wwv_flow_api.g_varchar2_table(37) := 'D13206E82312D6044E1294068A1E1D31203D28660E00895A368518C0A387082410233501C88882148005322A947487AA98595E2E14074D28762B6EA102248CDADDCBB7AFDFBF9B02010021F9040005000B002C00000000200020000007FF800082838485';
wwv_flow_api.g_varchar2_table(38) := '868788898A8B8C8D8E8F908805918D1437040A948A1C28281C8420939005A200049D2F820A094417998E3437374282A75203000532473907288F41A814004203282E0052360C0D0D9F8E389D280B8220AF75CC265EA58C209C2FC3856A07740E1D91052E';
wwv_flow_api.g_varchar2_table(39) := 'E185204F21E79A8B02243838EB882E0404138B40076364BA40C095E854271A8A8E3089C2508307450651204C942783458B0F13512070839FA2091EC8800153E1593C42053A7478D5281DBC420262C478E9A840B017C80A31B022C7484E4724A479042140';
wwv_flow_api.g_varchar2_table(40) := '50981D5AACB081F4001542122F6E9C43A203A90348203892A8D5090800050DDC88F1386AD08DAE831E143D096042275A6C0E0B1520F133AEDDBB78F3EAA514080021F9040005000C002C00000000200020000007FF800082838485868788898A8B8C8D8E';
wwv_flow_api.g_varchar2_table(41) := '8F909192840A40400293894028280F9983050583049C1C8205035304901D37374282A42841824F330E0E348F389C2F1D004203031400412B0E45552E8F139C280B820220822C1645477590201C282FC485525579170A91052EDF85023703E59F8905420F';
wwv_flow_api.g_varchar2_table(42) := '0FBF8A140404138B1379356D620D562592854257A21F64BA74891021872282061115694291E21D7B046EE853F4E08E988F3968BDA3A4C05DA373F5D46DD992D2518120DD9615CAC3E3CA86888D4838DB080213002356CED83100E9412F5D245EDCF855C4';
wwv_flow_api.g_varchar2_table(43) := '4A502FDA329288C50908000512B07031656ED08DAA83164C7BD70C05AC91840A909089B6ADDBB77004E3360A040021F9040005000D002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840A40380293893828280F99830505';
wwv_flow_api.g_varchar2_table(44) := '83049C1C83241C14901D37374282A4284182402C062190139C2F1D00420303AA242132756C988E0F9C280B820220821CC533B88F021C282FAA8538751F09D090052EDB863841E19F8805342424C889140404138B0B44071E2648408AB12834147DD8B0A6';
wwv_flow_api.g_varchar2_table(45) := '8D4124FE96054CE460CC98300E6D289277A39E221247BE7C99630387BA420A14A46334AE97210A6F2E987C5420483617868EB8C132E7D52312CB2C820828800B0F343EE82878A42C5B40122FBEB0018084078F2B584E3C0241E0060958283C9029A0E04B';
wwv_flow_api.g_varchar2_table(46) := '99A75E22891274030591AD006878C0A264C0275D17148880E270F55301120B467EDCCBB7AFDFBF9002010021F9040005000E002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928402130B0593893828280B99839883049C1C';
wwv_flow_api.g_varchar2_table(47) := '83142E911D04374282A3284182132F283890139C2F1D0042030314BC9C2D2F900B9C9D820220B2282D6A4090051C282FC085422D5328A18F052ED68642979F8BA71DDC88140404138B422B454E361FAD89AF28348A31070D15151E5B14DDCB97E8C29783';
wwv_flow_api.g_varchar2_table(48) := '0763285277A39D22214424DCB9E30015394220327673B1CB908B156C3A760B42CD22211B19343430D988C431874F4A29E08245059E0322193DC8950F880A3401ABF8C082018F974720569110F442C58E31054078188A61848068835AF8D841069310083E';
wwv_flow_api.g_varchar2_table(49) := '52FCF8F4E28A8E22A6D884FC44E148959C1708E3CA9D4BB72EA4400021F9040005000F002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A3828280B9888049B1C831D1D910A1C044282A0284182132F2F978F';
wwv_flow_api.g_varchar2_table(50) := '0F9B2FA54203031400429BAD900BBF9D000220AFBFAA8F051C282FBC85BE283892052ED08614349E8C0A14C78B140404138B1D532B1F2B528BAC28DB892C554548483FF09FBFF887530CFE0C365C281277A3DCC037486C1061C7AD9000050296B9286588';
wwv_flow_api.g_varchar2_table(51) := '460C190A221508E24C60A11F4D2220D8C788C4AF72025AB802214603142A792836AAE56C5B0E39580C0070204243122A2B1E812070E31205153AE01829004242CF24260A40920A80048CA461A4BAF020228A054F6D92FE1844C100464F138EFC90D9B0AD';
wwv_flow_api.g_varchar2_table(52) := 'DBB77004E3460A040021F90400050010002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A1328280B9888049B1C832020910A1C044282A02841820F2F0334900F9B2F1D0042033714B99B2838900BBF9D0002';
wwv_flow_api.g_varchar2_table(53) := '02829A9BAA8F051C282FBD85429BC191052ED28614B39E8B0220058C14040413DF2F6A092CCC89AC28DD883775431717278BEFF1875216FE16061651E070E39CA20E0666BC8971C95B2101E29AB9C06588860C35A520150802CD85212F63DA54D1D688C4';
wwv_flow_api.g_varchar2_table(54) := 'AF73029E000100E24B042E71AA2878540BDA2C043C44E0FB4025029838311E812070E312053C56CA6C2800228F129F39223A8A280443D236E268DCA1D2E58DA71156789418D421CD94999826D87080D6A1DBB77005E3CA9514080021F90400050011002C';
wwv_flow_api.g_varchar2_table(55) := '00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052442938A0F28280B9888049B1C832005910A1C049700A02841820F2F371D909A282FB34203371400429B280F900BBF9D0002028213BFAA8E051CB6BC85422F283892052E';
wwv_flow_api.g_varchar2_table(56) := 'D1861D349E8C05A58C140404138B0540030340C88AAC28DD890F4F2D6969D6EEBFF1884132FE32AE1451E070C39C22102D4E9C9002C29B217090B0CDDAC6E249C3884150480961E802040F1F263A72B1E9C81C632150183BD0A6069D0F171B697A83C50B';
wwv_flow_api.g_varchar2_table(57) := '00273EF0180030244E9B1173123C02F1420C03011492D88161C25895303F7F4012500C07163B3EDA20A3E0C4489B189816A8C0AA5590828D3123515062C7CD1D8785102EE0A192066EA10724ECEADDCB9750200021F90400050012002C00000000200020';
wwv_flow_api.g_varchar2_table(58) := '000007FF800082838485868788898A8B8C8D8E8F9091928405242E938A0F2828249888049B1C830205910A1C044282A02841820F030420909A282F1D0042033714B99B280B900BBFC100A48213BFAA8F051CB6BD85422F283892052ED0861D349E8CA58D';
wwv_flow_api.g_varchar2_table(59) := '140404138B0540BBD58BAC28DC89C3BFD99FBFED88EF9BF187141C37E48A05412F06A4EB46F05A10018640A0B8811052B322587E1892C1C0C6160590842030B30382B1342F8C39A970E7089B868D6658E901670680221994240060600EC93C2D1EA5C9E0';
wwv_flow_api.g_varchar2_table(60) := '268F800E4B52E0B963CCCB1C0F12D84022F14010092629447C29D5C182893B52303D8D5AE39B801BAE30B9689222830982853C447D8396D082126F0830B69D4BB7AEA0400021F90400050013002C00000000200020000007FF800082838485868788898A';
wwv_flow_api.g_varchar2_table(61) := '8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820F031C02909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BAC48BAB28DC89C2';
wwv_flow_api.g_varchar2_table(62) := '9BB6EABEED8842BEF18A141C37E48A0538043800EB4610480919B20A090882E39BA309497AC829612884831569123AAAB243079C3900043CB92168868D121F5A4032A1234B991500883419C302801A0436887C78F0A88586144E047418136589130005EA';
wwv_flow_api.g_varchar2_table(63) := 'E0240204929074429644A1728014882D3F0C80C014358A920ADF6E79A241C6EB1D8285EE78AD839610890F7508B6B69D4BB7AEA0400021F90400050014002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F';
wwv_flow_api.g_varchar2_table(64) := '2828249888049B1C8305920A1C044282A02841820B374102909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BA9D8BAB28DC89C29B03B28AEBED8842BEF18B141C37E4';
wwv_flow_api.g_varchar2_table(65) := '8A05380870A8D7AD1B0E0727E415227129D20425597858307443068B20DF1A1D8123A74C0500055EB4027062C59629231D799063C6CD10005EB8D47802408A85156CD48078F4040A9E220214ACE962A404C8295E569CD8F9480831002EC2748973849480';
wwv_flow_api.g_varchar2_table(66) := '1709AA617211A74B983C19BBD110E3D546C14247BC1A381BED8201A66C06E3CA9D0B20100021F90400050015002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A0';
wwv_flow_api.g_varchar2_table(67) := '2841820B3740A48F9A282F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28C140404138B0540BAA98BAB28DB8924BE37DE88036A09319D8942EFF1872D614D26B71215C0412008BB451D84ECE34608';
wwv_flow_api.g_varchar2_table(68) := '079121200EB9B814294817336E1C18A215EB11893065AEF89000A000016A0050849082E2C1230721DDA85801E0420D0903000439B192C0230976DCA4C823408189352668A6E429CA919408518ADCA251630D1D8D2581005100C9C538413420AC99438421';
wwv_flow_api.g_varchar2_table(69) := '210A73D67CB160969003B56A0DDA0EA220838500B978F3E60D040021F90400050016002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820B3740A48F9A28';
wwv_flow_api.g_varchar2_table(70) := '2F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28CB937138B0540BA978A42604A3512378A24BE048B24293D3D3B1FE8F18C174C2935D80A15C0412048C0431D5C78E36668828518200EB9380709C8';
wwv_flow_api.g_varchar2_table(71) := '181F2AF215828722D623216D7CA410910700396200800C7BE404C6482875006C9150A5154714A21A81E0922243140705403068E0E484A009D21E3C629041839388142434C8135310058A8D28C838A1C0EA9D060886302404220FD82D63091938E024675A';
wwv_flow_api.g_varchar2_table(72) := '931C07A8BD9D4B976E200021F90400050017002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202';
wwv_flow_api.g_varchar2_table(73) := 'B10013BDBF8E051CB4CA83422F283892052ECF841D349142A88DC68C2B18306B9D890540B9DB8A42183BEF6F8A24BD048B241959597033ECBDA28B439A889883AD50011C0482143CA4C005B851861ECC3000E21085858B70B41101E5822112D2603D1202';
wwv_flow_api.g_varchar2_table(74) := '010F132A555A5D020044D8A32A269570310040CD8F21C384F402E208441B264DBACC28208048911952043D78F1C25B23274D2210A948C346910F2C06755000A9C314355C01742852C48B1A8884047C286201055A42380D2E2458F756D0C3BA78F3D60D04';
wwv_flow_api.g_varchar2_table(75) := '0021F90400050018002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202B10013BDBF8E051CB4CA';
wwv_flow_api.g_varchar2_table(76) := '83422F283892052ECF841D34912EA88DC68C432218239D8905400304D8864278567070178A24BDA28A42516666656FF8F68C627449E2811D251C04821834A48006B85186165C4820E01085858A26CC51C2858D2112D280407251810A99385E04D1502008';
wwv_flow_api.g_varchar2_table(77) := '482F6F8D1C2C211366841A005262A4D925A4D7044720E6D05C13A380802143D45003F0E0C5008C86888469F3A662871943A6DC2305025287102D8C81B83024C1568882580C39310CED2005370A7EBA9D4BB7AE5D4381000021F90400050019002C000000';
wwv_flow_api.g_varchar2_table(78) := '00200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A02841822404400590322D282F1D0042033714B89B28BC8F3910B40B8202B10013BEC08E40505F4FCC83422F283892380EC587';
wwv_flow_api.g_varchar2_table(79) := '1D348F052E2442028DC88A245F1A19221BA88905400304B7895E76763C3C650EE7BEA28933DC0814E84591105FAC1291A0D304CA920697DEE178A56051251211472122C12604394314A4395A70204E8D048648540302890682381BE8D411A400842020BE';
wwv_flow_api.g_varchar2_table(80) := 'DC357A6364C31C094F00047932E0D6C14DDB180990B0E14B8513000AB0A0C512C00379151DCD70CA869C0035B4FE01380649819417C80AA4A1AAB11090272F0D44B6A590B5ADDDBB78F32A0A040021F9040005001A002C00000000200020000007FF8000';
wwv_flow_api.g_varchar2_table(81) := '82838485868788898A8B8C8D8E8F9091928405422E938A0F28282498831D0583049B1C9E00694D3F4282A3284182240440A18F733D29061D0042033714BB9B28BF8F123B3D460F8202B413C1C38E38493B654F86422F283892383F6CB4851D348F053496';
wwv_flow_api.g_varchar2_table(82) := '028DDF892C1B4D4C495F9D8905400304BA88204658FB3030488A2482BDC2B7218341830E1409090644518B0D64C88C61100F51011CB2402C022144883853895C2478926E1085678F48389973A7852112D81A3EA25085CE813C090481D0080047B08F8DD8';
wwv_flow_api.g_varchar2_table(83) := '983880E0C70D003007E85AB869C123220718207109A095CC05F578365293A7889A50056E6C1A08A0404946139289DAA40D24215E040D14B82D6476AEDDBB78F31E0A040021F9040005001B002C00000000200020000007FF800082838485868788898A8B';
wwv_flow_api.g_varchar2_table(84) := '8C8D8E8F9091928405422E938A0F2828249883144283049B1C9E002D4D294582A328418224044005901E593A56060042033714BB9B28BF8F0C705A3B128202B40013C1C38E385470671786422F28389213255BCC851D348F05344234E08AE9886973644B';
wwv_flow_api.g_varchar2_table(85) := '111EA189054003041D89203551511A1A7888282211EC152201749A2854384391906040144931D1A6CD081BF31015C0210BC422102E5C40337588469A1BEB045118E9C885853C3F6E1822912DE223106F8E54F9804210088F0070041BE70885932A5E623C';
wwv_flow_api.g_varchar2_table(86) := '00407340BE879B3A15AD62E1C200569B6C2EB807B49182136C640228706393C1B129190920C461D30292850E2870E0D015AEDDBB78F3EA5D14080021F9040005001C002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405';
wwv_flow_api.g_varchar2_table(87) := '422E938A0F2828249883344283049B1C9E002D50195582A3284182240440059007665665320042033714BB9B28BF8F473C6756398202B40013C1C38E13643C767586422F283892135E32CC851D348F05142E34E08AE988520762617139E389054003040A';
wwv_flow_api.g_varchar2_table(88) := '8902155D5D114B4B2E2822110C88BE3B6312261CA24848414503189830D1C0C13C440570C802B14800051A1D4C29EAF0C2E0210AD01E5188E185CD034324B2997C74E2439D29DB0080E00800C7B3472456D439F1645CCC01211D6EBAE4C8051B19695E02';
wwv_flow_api.g_varchar2_table(89) := '686572C18D200220D9EB04A0C08D4DAF04AD9B1464D30291851404993016ADDBB77005E3CA4514080021F9040005001D002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840F172E93840B13845F4D522498005349782582';
wwv_flow_api.g_varchar2_table(90) := '142A4A521CA1156E576E4400141964284182240440058F4E306E766806004E6D3714004228CCC98E0F6130683C158213BD0013CC28CE8E37D13E1686422F2838920F1F1702871D3490EE14D88BF3892F477310104EEF890540030828482420CF9A366DC4';
wwv_flow_api.g_varchar2_table(91) := '1861A388C43620FE907C99389158A265CC2026E2500501022717BA1D2A8063178845023A5018184A91021C42105110E9084488044F2E1522514EE3A317539EA0D80400C4490038B6D1741942E88B773C077450B64D67A3020350BC0005804046410B6EE0';
wwv_flow_api.g_varchar2_table(92) := 'A8C748C102AB3798E11244761210660B0F5A1A1230E19ADCBB78F3EADD8B29100021F9040005001E002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B45330A938242172184743B3A479902071822168214783B3D2699';
wwv_flow_api.g_varchar2_table(93) := '345C19292A0E00141AAC4482240440058F0C1A1958183200363C5828004228CE148F131B1A2A301282040F8213CE28D08F1C231A223386422F283892242B3102871D34900A141DBF8CF78A421639121225DF101500328000A644431A54F0E0C144024524';
wwv_flow_api.g_varchar2_table(94) := 'BA0151148381458B2CF44954E4828D03071F4E74505400472F108C1428409969910017230F5108F8A80007142F5C1822816E22246ECE260802C11247379A8C08387B218FE78091CD9E410282930436673E17DC5007A9808B83006E380B32285F4BA328AC';
wwv_flow_api.g_varchar2_table(95) := 'B63424E081DAB57007E3CA9D4B576E20003B000000000000000000';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16872363195585175 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't2loading.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000620000008208030000008A3FEDBE000000D2504C5445FFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006666664E4F504A4A4A2929';
wwv_flow_api.g_varchar2_table(2) := '2919191A101010080808EFEFEF5A5A5A6B6B6B87898B7F80817B7B7B7677787373736E6F71EAEAEBEAEBEBE6E6E7525252DEDEDF4546474242423A3A3A2D2D2E212121BDBDBDCFD0D2333333C5C5C6D2D3D4ADAFB1A7A8A9A5A5A69999998F90928B8B8B';
wwv_flow_api.g_varchar2_table(3) := 'E2E3E4838384CCCCCCC1C3C4DADBDCB7B9BBD6D6D7B4B5B5F7F7F7FFFFFFE0E1E2D8D9DAC7C8CAA9ABAD939394ADADADA0A2A4A1BA27710000000F74524E5300112233445566778899AABBCCDDEE462AF5990000052F49444154785EEDDA5797B2380080';
wwv_flow_api.g_varchar2_table(4) := 'E1D00795848EBDF73ABDCFD776F7FFFFA50DC62102A36008672F76DE9BB970F43111029E0854703A4956AE20CAA8A6C9B2044EA7822A389FA09D05A00232AA0224838CD4734310B20419016464FE171D8747003F1A83982508060279DE491591AC8E1B0A';
wwv_flow_api.g_varchar2_table(5) := 'A3A68B485AA650432181A09A412844703BED3636EAF7F71D22C02C4185881018A968F1A4B88148F376ABED8E9ACD9E47884A1C90B478150C44443A4339260C6AB41E1F1BFE57F3A418281D214EA5273F0C62B4DB2616D2848E507E821A6962D2E974BA6E';
wwv_flow_api.g_varchar2_table(6) := '8220020B81941431E9F5CC6EB7E1A60805B111469298361A75DFC18C97240C46024971C233CD918F90D3685884880E7609B1126AE2FC5E5858C00686F689748D6124E84488E8ABE80AAA1527C0D55784CC9500B513D3C89110F4040055C089A0C9956340';
wwv_flow_api.g_varchar2_table(7) := '1701478226C987E8EBF32668EC84B3E0412C16A789756FC683589BF334112D419C0873FA25E14F4D7E0436D2846FE1071A6B1EC4DCC4597E92F0ED7A4898B3309795F09C39AE6E868DFC38E159754C60A3D1EB76BB33566256DF6712C3A30411A8C14E4C';
wwv_flow_api.g_varchar2_table(8) := '47D4C0799470ED1125B0C13E8A51CA20846B59A398518048180E215CDBC604C109B22E4E502324D698881BEC84450C8A4CF6843F4B1A05888461F921418C882F4A500337F5A383766E1FF145083B342264460F5A6A90E6ACC4DAA60611288116C786CB4A';
wwv_flow_api.g_varchar2_table(9) := 'B83631F6C822B90CBA7B7FCE65A5DD238BF462EE4EB0E1F0201C3C10DB43690279139B136147424450830BB1B0A7444813C89FF121663E4A12D4F07910FE7F771F553EF14D7C136A5E426526C4BC84C84A5441EEAA8C84949F90D808155C90CA404022E4';
wwv_flow_api.g_varchar2_table(10) := '37606E827EE9BD305187E7888A26C7920053921C4BAB4444550425255609A18312D343A20A4AAD8A09B15C4244400725A703A56C42015AD984068CB20903A09287A12180A054A620414C20A8942728F0B046554A42E4CAF14A5B8DA7319C90A2568D9775';
wwv_flow_api.g_varchar2_table(11) := 'BDD085CB0041BFFCAA57BBC8106A28836036A8C0425C72C668888D80F909C8482039AF207FDF991720BE896FC2BB337910E6DD49C25B0E3A3C88EEE0D98B1354E8F3213A83801849C2791BF6033E4410049B799A70B6C3E12068F2201E83E0E363384F12';
wwv_flow_api.g_varchar2_table(12) := '93D5C3B03F0882F7D7E57269B11293EB3F7FEF7641487CF4A77162F4327E180EFB980F6BB312D7E18B0C08F1E347FD98A8FF7A19FF24C3E0476083128F6F94087811D8F8B8FF245ADBB7B797F1F88118B80E3B11BD4FD22D21BA4FABED6118D8181422C2';
wwv_flow_api.g_varchar2_table(13) := 'A98819CD63E2606064D06527C84C45464008D45A916160638FF48B10641887B0400854C7C4C1089121337143662232EAF4A0B5881122A1528820C680089440D3CDC1D8D763256EA3C9C6C838B145E2EC8D5F4F37B85B8795706E6FAEAFAFDF8621F2324F';
wwv_flow_api.g_varchar2_table(14) := '2D83CF5B8C34782C83AD70204B27BD987BD7ABED960BD1C393F51ADF22A1C68A0F31FEF97A6A8BA4B532F910F7A7EF40BA160F62D4FEBFDDAAE972CEF402A390D41ACA485784A213A5C073404DE2F15948F08C20F0F9B8E508700930FF140C81D7115541';
wwv_flow_api.g_varchar2_table(15) := 'A4F6B3130A7FF5477483A32021C77FDBB8D83C6DB071377C7827022CFEA55848FCD8D5FE8D8DE678FC9EFCB1ABC04AE8E0B31A35F0F571E7A54E4D9D8D80427C938518BF9FF0185284005908288134D1593E6F36769A0012BC9CA8518112BDF7D7DBDD72';
wwv_flow_api.g_varchar2_table(16) := '39A104356A971186AE508012E69FDD9DBFF8F3FE3EA5044DD18DD384A18A7936BC16FFDC347DFCE766779F6BB749548D4F42CBBB58CF5AFE9E6AFB79F7FD3442A8203301B2EEFBA921A1315F73A47CCF048600F2A4B3EEFB09105C817C5D2500A8E47D22';
wwv_flow_api.g_varchar2_table(17) := '9041CE641D52C0D084DCCFFB17EA19E02C7345FE160000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16873059744586798 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't3controls.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '47494638396120002000F60000000000E2E2E20303032323232020200101013C3C3C7070706767673737370707071313136868687171715353531515157E7E7E9999996E6E6E1717170A0A0A737373515151474747B1B1B1AEAEAEA9A9A98383831E1E1E';
wwv_flow_api.g_varchar2_table(2) := '0808087575754E4E4E050505303030ACACAC818181111111555555777777383838272727B3B3B3B0B0B04848483131312C2C2C0E0E0E252525B7B7B74141413A3A3A4C4C4C0C0C0C8080806060602121211818186A6A6AD1D1D1D3D3D3C1C1C1D5D5D5B9';
wwv_flow_api.g_varchar2_table(3) := 'B9B95858581A1A1A1C1C1C1010104545455757575C5C5C8A8A8A6363635E5E5EA3A3A39E9E9E9A9A9AA5A5A5A0A0A06161612A2A2AA1A1A1A7A7A72828283535359C9C9C5A5A5ACACACABEBEBEB5B5B5CECECED0D0D03E3E3E9191919797975050507C7C';
wwv_flow_api.g_varchar2_table(4) := '7C9393938E8E8E898989909090959595C3C3C3C5C5C5C7C7C7BCBCBC2E2E2E333333858585404040878787BABABA4A4A4ACCCCCC8C8C8CC9C9C97A7A7A797979434343C0C0C06C6C6CAAAAAA656565D7D7D700000000000000000000000000000021FE1A';
wwv_flow_api.g_varchar2_table(5) := '43726561746564207769746820616A61786C6F61642E696E666F0021F904000500000021FF0B4E45545343415045322E3003010000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B39363493820F17218305353A3B';
wwv_flow_api.g_varchar2_table(6) := '12990A101822168214223B3D359E900B111918190E00141AAD3F820B3740028E02121A1929183200363C3E28004228D12E8F131B1A2A30A300041C8213D12814901C231A223386422F283892242B31C1861D988F0A141D058DFA8B02060C1224941097A8';
wwv_flow_api.g_varchar2_table(7) := '0090010408221A70A041050F2658282201AE5B220208186844D04211B46816111548E0C0C28713201415C0412088C2440A14A4CCD4CF450744145E3A2AC001C58B698548AC0312E95BB4098240CCC4014EE72202D15E60123AE0E64714401D3DF0494210';
wwv_flow_api.g_varchar2_table(8) := '54144401F80A22EF110505836E440B028BA620A62810BABA2D246082DCB978F3EADDCB7752200021F90400050001002C00000000200020000007FF800082838485868788898A8B8C8D8E870F138F8E172A585B938B0A1156595C0599830B312D831D4C9D';
wwv_flow_api.g_varchar2_table(9) := '510AA100200D494A338214A85A512082A08F24464A4C50B20A54565A5DA00B3740BA8C05474B4D514C530055573C5E004228DB2E8F0B264B501A088252A50013DB281493401E4B4A1786422F2838A1423132CB841D3493203AAC6AC42F510B224590AC18';
wwv_flow_api.g_varchar2_table(10) := '88A800900104D825A2E020A10D2752149150C74111882116425AB8A148DBB68E8A80243020E3890045057010082271918082AC1ABAE8808842CD470582A078D1AD10897A40323D5027A9152E0038D4FD64C461DB8B7F4707F03489A2A8A3A32F480822B0';
wwv_flow_api.g_varchar2_table(11) := '2D290064415E4E1238E8C6B620831570864A874248CE860BBCDEDDCBB7AFDFBF800705020021F90400050002002C00000000200020000007FF800082838485868788898A8B8C8D8E86244E3F148F8D123C650C958B1D4B3C664A209B8342322883344D3C';
wwv_flow_api.g_varchar2_table(12) := '674C0AA3002008606343821D54AB50A2001D952E5F61646017B064AB5C050A123340058E054462635D5D2C003F3E681F0036622D282E8F240C625C1148000221218255532828948F1308D23186402F2838A32E2753CE0C75A0B109C42E4601179190B162';
wwv_flow_api.g_varchar2_table(13) := 'C59483870A001940405E2216432EAC98C141110978283A2A7A72A2E4097E898480149988C200142F9A292A808340108B335F3D73D1EB10059CCF82C00C5788843E209B16809C20C8A0201C20812E120A93A0D101BD54C223EAC8C58017240411808714C0';
wwv_flow_api.g_varchar2_table(14) := '821B4104143C7883ECA0843A13014C8027246EC4055CEDEADDCBB7AFDFBD81000021F90400050003002C00000000200020000007FF800082838485868788898A8B8C8D8E8624550E148F8D08583E47958B0A63586E5D209B8305374183146458684A0AA3';
wwv_flow_api.g_varchar2_table(15) := '822B5F105B821D5CAB11A2000F1D8F05365F1B1B6C002046AB46050A0D6E11388F171E5F6B6D2D000E19186F00485A3D70538F2E3F1E10620E00052D69826D3D654734950B44E52786475844CF9B142169050C090022AF5201018E023202F182C5141408';
wwv_flow_api.g_varchar2_table(16) := '131500328000254538D68550B34011091420392C9A0012A40B45424A8A542400C78D1B131615C04120C84599AF12BAE87588C24D5F4150BC385988C40B1440367D0419B358441C257F322229549ED11BBD529AAC4461C000128208804C0A6081A9888F04';
wwv_flow_api.g_varchar2_table(17) := 'A0BD3196544E42541085BC3D546001D1B978F3EADDCB576F200021F90400050004002C00000000200020000007FF800082838485868788898A8B8C8D8E864216431D8F8D48512245958B0A6B511971209B84200A831D621A1960A6A3000F444E6A829D1A';
wwv_flow_api.g_varchar2_table(18) := '2A63A2000B2E950908070D090020101A1823000A12294A1C8F4F360C0D1E280033505143005572593A3F8F1D174E391E2B0005524F8223DE3A17952EE3392C8636703B61149B1D282F87200CBC11E2AA510183136EDCC0B1A800900104F6297281A2220A';
wwv_flow_api.g_varchar2_table(19) := '1A8A48587436D1E24545423636C4A170C248024124362C68D005A54314543E2A10C41FAF42245EA000B249634593C30408C2615126A309155F60CC798352C88A371D292030808420021579EABA014468A5020705DDC83A282C4B004851103C5BA80089A8';
wwv_flow_api.g_varchar2_table(20) := '6C08E3CA9D4BB7EEA8400021F90400050005002C00000000200020000007FF800082838485868788898A8B8C8D8E862E2B6C0A8F8D25115433958B2026114D23029B891D739F622082202F0F954F6C28820A7411506BA20B5F6E51528E135E3F48690002';
wwv_flow_api.g_varchar2_table(21) := '0D114974000A5F6567724EBE2B16454E04007560116C003F76CE56758E20536F0E365B00052FB1024666727046148F146A6F25BD8547F046249B2041821CA2F0C68290518D405028D08804010213161568D18240874514506844414311898D1C306EE4A8';
wwv_flow_api.g_varchar2_table(22) := '480848460F6EDC88A8A8000E02402E326288B0510117320D5198B7A94010142F5C1822B10EC8A68F1A5982100500C7469E8E1E687CD191E88D8B26350A7D0482C0007F000868340A60C10D204C2BD1047063ECA0B53514014CD07830AEA10224B6DADDCB';
wwv_flow_api.g_varchar2_table(23) := 'B7AFDFBF7D03010021F90400050006002C00000000200020000007FF800082838485868788898A8B8C8D8E860503038F8E6C236D32948B200C6D6307059A890A779E5F2082203243148F24280FA99D5C740200241E296E478E0A6A31179302476D5C1200';
wwv_flow_api.g_varchar2_table(24) := '0A1530687663B68C1D21AB333800322346990E29CC3C3F8F1C2C062B210005379305236E76651BAD8E20042C5B1C864557656B249A05240B87285CF8E04254231038F831224180C0844513C0D8C960609182172832D25084E4CC151F6D508DC2A8511101';
wwv_flow_api.g_varchar2_table(25) := '360958DC60B4E0C68D878A0AE020004481C19B880AB8E88088023C4A0582A07851B010098C4034BDCA0813C4331C1951FC6CF420E38B8D476FF01412B5683C02371412C89814404B20CF800EBA417650289C821126641402171209AF75F3EADDCBB7AFA8';
wwv_flow_api.g_varchar2_table(26) := '400021F90400050007002C00000000200020000007FF800082838485868788898A8B8C8D8E8720028F8E41453F40938C1F155F1F998A023F15100C920002096C1D8F054234820244A3079242775119488F414F213800050E153547052039782A2962A68B';
wwv_flow_api.g_varchar2_table(27) := '022F282D5324002177742D0033B829580E8F402852213782139805741929305FAB8E201CE20B8644293E104299ADAF861D752B5C7C6A0462823E4642081098B0684218371A642C02010D058A7E88F2E8D8984481228A162F2A3AD2A36413108B16DCB8C1';
wwv_flow_api.g_varchar2_table(28) := '50D1030F54A8841808AA59A3022EDE19A240E1538120285E082C44021AA6492442B68C240847C89E8F1E587CF1AAE88D5542420E8547E0063500042C1E5509A480CF4137C40E324B73D0048B070FDB162A4062ABDCBB78F3EADD8B37100021F904000500';
wwv_flow_api.g_varchar2_table(29) := '08002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90870A69210A918B53480C32978905439A3F0582022C321D901D9600021748393602002E47114D258F132F03420005754877B8204E54504C10B28C053728282F14002F3F082F';
wwv_flow_api.g_varchar2_table(30) := '00435D4D4C1A338F40CE280F8224E20512DA7815A88E201CCF2E865E4C781EF090052ED1861D5B75349D8C404CE8C54808010213163D688381099B45020680FB97C8861C2B569480501471A2221B59426A5C64F04642450FC48858F210E0A102149439C2';
wwv_flow_api.g_varchar2_table(31) := 'B7CE10057DF782BC3344E2050A209148803B0942190E70381B3D70F6E25FCF1BA88480B3C78EC00D12820838030A60C10D1CA3228505D0ECE7A0B12E273823E8B2500112540ADBCA9D4BB7AEDDB981000021F90400050009002C00000000200020000007';
wwv_flow_api.g_varchar2_table(32) := 'FF800082838485868788898A8B8C8D8E8F9088240B918C1C433337958A2C170E4383022F6A0A90202082059D251F050034446D631F8F242F03428269174417000225465C5D0DAE8D1C28282F14004075161C0006B25D4BBE8E38C9280F823424824E635D';
wwv_flow_api.g_varchar2_table(33) := '5439A58E20C82F34861764E4EB90052ECC860A275BF09B8A020F4142C689841020306111901A1A5424F992CF908001DA1A1ABA63A7228F2B32121580984C62210466429AB16340910B02370A2A7AB0210A13264E04E83354A083CD47F23A2062314467BC';
wwv_flow_api.g_varchar2_table(34) := '20CA5C182291E04B1BA1B5B4A90421134036290E50407A904C1D005B37740AD196EB110894DF0010480644D0821B3800E21C7483EC20B5FA132624EB3AB350011248EBEADDCBB7AF5FBE81000021F9040005000A002C00000000200020000007FF800082';
wwv_flow_api.g_varchar2_table(35) := '838485868788898A8B8C8D8E8F90882002918C424F2C24958A0469322C83051C409120058337690632821D6F1E262D8F422F3742829D5B5300052B26106B0E8F1C28282F1400422D0613006A15C0625B8F38C5280F820A34820E5F6B46480A8F20C42FDB';
wwv_flow_api.g_varchar2_table(36) := '855B1B7136E78F052EC886202C27F19B8A020B4040F6884204049A29E230874A12266250241230C05ABB433952A4C04211C22944041C2ABAE3A66347088A5C10B82130110E084A94509943E09EA1021D625E64F4AEC321104386D8845420883117861C68';
wwv_flow_api.g_varchar2_table(37) := 'D13206E82312D6044E1294068A1E1D31203D28660E00895A368518C0A387082410233501C88882148005322A947487AA98595E2E14074D28762B6EA102248CDADDCBB7AFDFBF9B02010021F9040005000B002C00000000200020000007FF800082838485';
wwv_flow_api.g_varchar2_table(38) := '868788898A8B8C8D8E8F908805918D1437040A948A1C28281C8420939005A200049D2F820A094417998E3437374282A75203000532473907288F41A814004203282E0052360C0D0D9F8E389D280B8220AF75CC265EA58C209C2FC3856A07740E1D91052E';
wwv_flow_api.g_varchar2_table(39) := 'E185204F21E79A8B02243838EB882E0404138B40076364BA40C095E854271A8A8E3089C2508307450651204C942783458B0F13512070839FA2091EC8800153E1593C42053A7478D5281DBC420262C478E9A840B017C80A31B022C7484E4724A479042140';
wwv_flow_api.g_varchar2_table(40) := '50981D5AACB081F4001542122F6E9C43A203A90348203892A8D5090800050DDC88F1386AD08DAE831E143D096042275A6C0E0B1520F133AEDDBB78F3EAA514080021F9040005000C002C00000000200020000007FF800082838485868788898A8B8C8D8E';
wwv_flow_api.g_varchar2_table(41) := '8F909192840A40400293894028280F9983050583049C1C8205035304901D37374282A42841824F330E0E348F389C2F1D004203031400412B0E45552E8F139C280B820220822C1645477590201C282FC485525579170A91052EDF85023703E59F8905420F';
wwv_flow_api.g_varchar2_table(42) := '0FBF8A140404138B1379356D620D562592854257A21F64BA74891021872282061115694291E21D7B046EE853F4E08E988F3968BDA3A4C05DA373F5D46DD992D2518120DD9615CAC3E3CA86888D4838DB080213002356CED83100E9412F5D245EDCF855C4';
wwv_flow_api.g_varchar2_table(43) := '4A502FDA329288C50908000512B07031656ED08DAA83164C7BD70C05AC91840A909089B6ADDBB77004E3360A040021F9040005000D002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840A40380293893828280F99830505';
wwv_flow_api.g_varchar2_table(44) := '83049C1C83241C14901D37374282A4284182402C062190139C2F1D00420303AA242132756C988E0F9C280B820220821CC533B88F021C282FAA8538751F09D090052EDB863841E19F8805342424C889140404138B0B44071E2648408AB12834147DD8B0A6';
wwv_flow_api.g_varchar2_table(45) := '8D4124FE96054CE460CC98300E6D289277A39E221247BE7C99630387BA420A14A46334AE97210A6F2E987C5420483617868EB8C132E7D52312CB2C820828800B0F343EE82878A42C5B40122FBEB0018084078F2B584E3C0241E0060958283C9029A0E04B';
wwv_flow_api.g_varchar2_table(46) := '99A75E22891274030591AD006878C0A264C0275D17148880E270F55301120B467EDCCBB7AFDFBF9002010021F9040005000E002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928402130B0593893828280B99839883049C1C';
wwv_flow_api.g_varchar2_table(47) := '83142E911D04374282A3284182132F283890139C2F1D0042030314BC9C2D2F900B9C9D820220B2282D6A4090051C282FC085422D5328A18F052ED68642979F8BA71DDC88140404138B422B454E361FAD89AF28348A31070D15151E5B14DDCB97E8C29783';
wwv_flow_api.g_varchar2_table(48) := '0763285277A39D22214424DCB9E30015394220327673B1CB908B156C3A760B42CD22211B19343430D988C431874F4A29E08245059E0322193DC8950F880A3401ABF8C082018F974720569110F442C58E31054078188A61848068835AF8D841069310083E';
wwv_flow_api.g_varchar2_table(49) := '52FCF8F4E28A8E22A6D884FC44E148959C1708E3CA9D4BB72EA4400021F9040005000F002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A3828280B9888049B1C831D1D910A1C044282A0284182132F2F978F';
wwv_flow_api.g_varchar2_table(50) := '0F9B2FA54203031400429BAD900BBF9D000220AFBFAA8F051C282FBC85BE283892052ED08614349E8C0A14C78B140404138B1D532B1F2B528BAC28DB892C554548483FF09FBFF887530CFE0C365C281277A3DCC037486C1061C7AD9000050296B9286588';
wwv_flow_api.g_varchar2_table(51) := '460C190A221508E24C60A11F4D2220D8C788C4AF72025AB802214603142A792836AAE56C5B0E39580C0070204243122A2B1E812070E31205153AE01829004242CF24260A40920A80048CA461A4BAF020228A054F6D92FE1844C100464F138EFC90D9B0AD';
wwv_flow_api.g_varchar2_table(52) := 'DBB77004E3460A040021F90400050010002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A1328280B9888049B1C832020910A1C044282A02841820F2F0334900F9B2F1D0042033714B99B2838900BBF9D0002';
wwv_flow_api.g_varchar2_table(53) := '02829A9BAA8F051C282FBD85429BC191052ED28614B39E8B0220058C14040413DF2F6A092CCC89AC28DD883775431717278BEFF1875216FE16061651E070E39CA20E0666BC8971C95B2101E29AB9C06588860C35A520150802CD85212F63DA54D1D688C4';
wwv_flow_api.g_varchar2_table(54) := 'AF73029E000100E24B042E71AA2878540BDA2C043C44E0FB4025029838311E812070E312053C56CA6C2800228F129F39223A8A280443D236E268DCA1D2E58DA71156789418D421CD94999826D87080D6A1DBB77005E3CA9514080021F90400050011002C';
wwv_flow_api.g_varchar2_table(55) := '00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052442938A0F28280B9888049B1C832005910A1C049700A02841820F2F371D909A282FB34203371400429B280F900BBF9D0002028213BFAA8E051CB6BC85422F283892052E';
wwv_flow_api.g_varchar2_table(56) := 'D1861D349E8C05A58C140404138B0540030340C88AAC28DD890F4F2D6969D6EEBFF1884132FE32AE1451E070C39C22102D4E9C9002C29B217090B0CDDAC6E249C3884150480961E802040F1F263A72B1E9C81C632150183BD0A6069D0F171B697A83C50B';
wwv_flow_api.g_varchar2_table(57) := '00273EF0180030244E9B1173123C02F1420C03011492D88161C25895303F7F4012500C07163B3EDA20A3E0C4489B189816A8C0AA5590828D3123515062C7CD1D8785102EE0A192066EA10724ECEADDCB9750200021F90400050012002C00000000200020';
wwv_flow_api.g_varchar2_table(58) := '000007FF800082838485868788898A8B8C8D8E8F9091928405242E938A0F2828249888049B1C830205910A1C044282A02841820F030420909A282F1D0042033714B99B280B900BBFC100A48213BFAA8F051CB6BD85422F283892052ED0861D349E8CA58D';
wwv_flow_api.g_varchar2_table(59) := '140404138B0540BBD58BAC28DC89C3BFD99FBFED88EF9BF187141C37E48A05412F06A4EB46F05A10018640A0B8811052B322587E1892C1C0C6160590842030B30382B1342F8C39A970E7089B868D6658E901670680221994240060600EC93C2D1EA5C9E0';
wwv_flow_api.g_varchar2_table(60) := '268F800E4B52E0B963CCCB1C0F12D84022F14010092629447C29D5C182893B52303D8D5AE39B801BAE30B9689222830982853C447D8396D082126F0830B69D4BB7AEA0400021F90400050013002C00000000200020000007FF800082838485868788898A';
wwv_flow_api.g_varchar2_table(61) := '8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820F031C02909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BAC48BAB28DC89C2';
wwv_flow_api.g_varchar2_table(62) := '9BB6EABEED8842BEF18A141C37E48A0538043800EB4610480919B20A090882E39BA309497AC829612884831569123AAAB243079C3900043CB92168868D121F5A4032A1234B991500883419C302801A0436887C78F0A88586144E047418136589130005EA';
wwv_flow_api.g_varchar2_table(63) := 'E0240204929074429644A1728014882D3F0C80C014358A920ADF6E79A241C6EB1D8285EE78AD839610890F7508B6B69D4BB7AEA0400021F90400050014002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F';
wwv_flow_api.g_varchar2_table(64) := '2828249888049B1C8305920A1C044282A02841820B374102909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BA9D8BAB28DC89C29B03B28AEBED8842BEF18B141C37E4';
wwv_flow_api.g_varchar2_table(65) := '8A05380870A8D7AD1B0E0727E415227129D20425597858307443068B20DF1A1D8123A74C0500055EB4027062C59629231D799063C6CD10005EB8D47802408A85156CD48078F4040A9E220214ACE962A404C8295E569CD8F9480831002EC2748973849480';
wwv_flow_api.g_varchar2_table(66) := '1709AA617211A74B983C19BBD110E3D546C14247BC1A381BED8201A66C06E3CA9D0B20100021F90400050015002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A0';
wwv_flow_api.g_varchar2_table(67) := '2841820B3740A48F9A282F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28C140404138B0540BAA98BAB28DB8924BE37DE88036A09319D8942EFF1872D614D26B71215C0412008BB451D84ECE34608';
wwv_flow_api.g_varchar2_table(68) := '079121200EB9B814294817336E1C18A215EB11893065AEF89000A000016A0050849082E2C1230721DDA85801E0420D0903000439B192C0230976DCA4C823408189352668A6E429CA919408518ADCA251630D1D8D2581005100C9C538413420AC99438421';
wwv_flow_api.g_varchar2_table(69) := '210A73D67CB160969003B56A0DDA0EA220838500B978F3E60D040021F90400050016002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820B3740A48F9A28';
wwv_flow_api.g_varchar2_table(70) := '2F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28CB937138B0540BA978A42604A3512378A24BE048B24293D3D3B1FE8F18C174C2935D80A15C0412048C0431D5C78E36668828518200EB9380709C8';
wwv_flow_api.g_varchar2_table(71) := '181F2AF215828722D623216D7CA410910700396200800C7BE404C6482875006C9150A5154714A21A81E0922243140705403068E0E484A009D21E3C629041839388142434C8135310058A8D28C838A1C0EA9D060886302404220FD82D63091938E024675A';
wwv_flow_api.g_varchar2_table(72) := '931C07A8BD9D4B976E200021F90400050017002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202';
wwv_flow_api.g_varchar2_table(73) := 'B10013BDBF8E051CB4CA83422F283892052ECF841D349142A88DC68C2B18306B9D890540B9DB8A42183BEF6F8A24BD048B241959597033ECBDA28B439A889883AD50011C0482143CA4C005B851861ECC3000E21085858B70B41101E5822112D2603D1202';
wwv_flow_api.g_varchar2_table(74) := '010F132A555A5D020044D8A32A269570310040CD8F21C384F402E208441B264DBACC28208048911952043D78F1C25B23274D2210A948C346910F2C06755000A9C314355C01742852C48B1A8884047C286201055A42380D2E2458F756D0C3BA78F3D60D04';
wwv_flow_api.g_varchar2_table(75) := '0021F90400050018002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202B10013BDBF8E051CB4CA';
wwv_flow_api.g_varchar2_table(76) := '83422F283892052ECF841D34912EA88DC68C432218239D8905400304D8864278567070178A24BDA28A42516666656FF8F68C627449E2811D251C04821834A48006B85186165C4820E01085858A26CC51C2858D2112D280407251810A99385E04D1502008';
wwv_flow_api.g_varchar2_table(77) := '482F6F8D1C2C211366841A005262A4D925A4D7044720E6D05C13A380802143D45003F0E0C5008C86888469F3A662871943A6DC2305025287102D8C81B83024C1568882580C39310CED2005370A7EBA9D4BB7AE5D4381000021F90400050019002C000000';
wwv_flow_api.g_varchar2_table(78) := '00200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A02841822404400590322D282F1D0042033714B89B28BC8F3910B40B8202B10013BEC08E40505F4FCC83422F283892380EC587';
wwv_flow_api.g_varchar2_table(79) := '1D348F052E2442028DC88A245F1A19221BA88905400304B7895E76763C3C650EE7BEA28933DC0814E84591105FAC1291A0D304CA920697DEE178A56051251211472122C12604394314A4395A70204E8D048648540302890682381BE8D411A400842020BE';
wwv_flow_api.g_varchar2_table(80) := 'DC357A6364C31C094F00047932E0D6C14DDB180990B0E14B8513000AB0A0C512C00379151DCD70CA869C0035B4FE01380649819417C80AA4A1AAB11090272F0D44B6A590B5ADDDBB78F32A0A040021F9040005001A002C00000000200020000007FF8000';
wwv_flow_api.g_varchar2_table(81) := '82838485868788898A8B8C8D8E8F9091928405422E938A0F28282498831D0583049B1C9E00694D3F4282A3284182240440A18F733D29061D0042033714BB9B28BF8F123B3D460F8202B413C1C38E38493B654F86422F283892383F6CB4851D348F053496';
wwv_flow_api.g_varchar2_table(82) := '028DDF892C1B4D4C495F9D8905400304BA88204658FB3030488A2482BDC2B7218341830E1409090644518B0D64C88C61100F51011CB2402C022144883853895C2478926E1085678F48389973A7852112D81A3EA25085CE813C090481D0080047B08F8DD8';
wwv_flow_api.g_varchar2_table(83) := '983880E0C70D003007E85AB869C123220718207109A095CC05F578365293A7889A50056E6C1A08A0404946139289DAA40D24215E040D14B82D6476AEDDBB78F31E0A040021F9040005001B002C00000000200020000007FF800082838485868788898A8B';
wwv_flow_api.g_varchar2_table(84) := '8C8D8E8F9091928405422E938A0F2828249883144283049B1C9E002D4D294582A328418224044005901E593A56060042033714BB9B28BF8F0C705A3B128202B40013C1C38E385470671786422F28389213255BCC851D348F05344234E08AE9886973644B';
wwv_flow_api.g_varchar2_table(85) := '111EA189054003041D89203551511A1A7888282211EC152201749A2854384391906040144931D1A6CD081BF31015C0210BC422102E5C40337588469A1BEB045118E9C885853C3F6E1822912DE223106F8E54F9804210088F0070041BE70885932A5E623C';
wwv_flow_api.g_varchar2_table(86) := '00407340BE879B3A15AD62E1C200569B6C2EB807B49182136C640228706393C1B129190920C461D30292850E2870E0D015AEDDBB78F3EA5D14080021F9040005001C002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405';
wwv_flow_api.g_varchar2_table(87) := '422E938A0F2828249883344283049B1C9E002D50195582A3284182240440059007665665320042033714BB9B28BF8F473C6756398202B40013C1C38E13643C767586422F283892135E32CC851D348F05142E34E08AE988520762617139E389054003040A';
wwv_flow_api.g_varchar2_table(88) := '8902155D5D114B4B2E2822110C88BE3B6312261CA24848414503189830D1C0C13C440570C802B14800051A1D4C29EAF0C2E0210AD01E5188E185CD034324B2997C74E2439D29DB0080E00800C7B3472456D439F1645CCC01211D6EBAE4C8051B19695E02';
wwv_flow_api.g_varchar2_table(89) := '686572C18D200220D9EB04A0C08D4DAF04AD9B1464D30291851404993016ADDBB77005E3CA4514080021F9040005001D002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840F172E93840B13845F4D522498005349782582';
wwv_flow_api.g_varchar2_table(90) := '142A4A521CA1156E576E4400141964284182240440058F4E306E766806004E6D3714004228CCC98E0F6130683C158213BD0013CC28CE8E37D13E1686422F2838920F1F1702871D3490EE14D88BF3892F477310104EEF890540030828482420CF9A366DC4';
wwv_flow_api.g_varchar2_table(91) := '1861A388C43620FE907C99389158A265CC2026E2500501022717BA1D2A8063178845023A5018184A91021C42105110E9084488044F2E1522514EE3A317539EA0D80400C4490038B6D1741942E88B773C077450B64D67A3020350BC0005804046410B6EE0';
wwv_flow_api.g_varchar2_table(92) := 'A8C748C102AB3798E11244761210660B0F5A1A1230E19ADCBB78F3EADD8B29100021F9040005001E002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B45330A938242172184743B3A479902071822168214783B3D2699';
wwv_flow_api.g_varchar2_table(93) := '345C19292A0E00141AAC4482240440058F0C1A1958183200363C5828004228CE148F131B1A2A301282040F8213CE28D08F1C231A223386422F283892242B3102871D34900A141DBF8CF78A421639121225DF101500328000A644431A54F0E0C144024524';
wwv_flow_api.g_varchar2_table(94) := 'BA0151148381458B2CF44954E4828D03071F4E74505400472F108C1428409969910017230F5108F8A80007142F5C1822816E22246ECE260802C11247379A8C08387B218FE78091CD9E410282930436673E17DC5007A9808B83006E380B32285F4BA328AC';
wwv_flow_api.g_varchar2_table(95) := 'B63424E081DAB57007E3CA9D4B576E20003B000000000000000000';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16873757372587930 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't3loading.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D494844520000003200000062080600000012B180460000001974455874536F6674776172650041646F626520496D616765526561647971C9653C000003C34944415478DAEC9AC16EDB300C404547E9760AB0F617761FB0EF';
wwv_flow_api.g_varchar2_table(2) := 'C87DBDF5BA4FDAB5B7EDDEDFD8BE60BF900CD8696B6C695161171A434A942379992A0284950491F44C52A62883B5560180CA2CB10E6DCEC11C832E3C6160002037A0CE3079C8046ED1EFB614080861A46036020129403A110202DFC14C9069D296810009';
wwv_flow_api.g_varchar2_table(3) := '8C9E0101C2B61402B781684761F44C88984A02DA0654111609C26821843FC1CEFBDCA12B0544816035E83AB521E082229090053A4F81688760420066FCFFD4A6029D85D189EE344D7AC5B4E7804C3A785698C448DD4C27C4863FE915A11C0C078221BAF1';
wwv_flow_api.g_varchar2_table(4) := '3AA0B18D245674E479805D6982D0E88A81A6FF29E279E0BBD3E0417404BC25ACE3670756EA5A80AC314DFE2FDD6EB76FEEEFEF3FCD492DEEEEEE3E3E3C3CFC3836FBC022117DB6004A1AB9C0D608623DAADEED769F379BCD5BADF5660E48DFF73F8FF2FD';
wwv_flow_api.g_varchar2_table(5) := 'E6E6E67684398CDA8F3A8C578356B5E7A5FA89C10301C6A57C4BAC7D7510D7D7D7EF7364B0FBFDFEDB087340DA7B2E8861460EFBECC7B1651707B8CE09E1C4F5E5FA24E2AE933C703B417288037DE562C2B953EE4D8CEBD3F51D5809D9C414BB16E55653';
wwv_flow_api.g_varchar2_table(6) := '5C5C4D7ABC735F725A8370B10FC7E6A3A77EBC9CC40AE55A8A587E29AB9416E97329EA5A1059C54A4B17890DE0402031DF2A2D29193528C1DDE592C6252C9274033BE11675496BA48C09A11839B772B244394914ECFFA5CC01B10BCCCB9E0362231DDB85';
wwv_flow_api.g_varchar2_table(7) := '2052C6B4528B70FBEBD262224509D62236B1DAB1A43570C9889C6717E824B4C75EC22226006353823DB4BF2E2D031A33EA0D5D626C3C81B8EDA9DBD9E59EBDEBD3F5CD65B921182A8D574CB1C1DF1D1649E5510A4FED120D51F722D3F8506C0C9EF66E5B';
wwv_flow_api.g_varchar2_table(8) := 'EA06CE0C718BB6B6432456EA2E3E28A6C67BB25F2F580EC24A59C6E0D58B0389ED0E4B14E806EFCE0F4CE5C470EE459D215A66602A2B3D59CDCE2C990E84050C530252D2DA2F556B35C48210839853C436C4F2AB224F7712245430C6D571FF3820C7B182';
wwv_flow_api.g_varchar2_table(9) := '95B892F45821740E81ADD12190DC073D4A986F054FACB8434AE34D94FA2EC7D19BD8121290989B5955E63054A54248403818FC9D52E71D4F73131641484128370B1D52CE7D6140FADB59208A81508CCBE5D8A7177B85831A2076900F89935BF4A51AC9C0';
wwv_flow_api.g_varchar2_table(10) := 'B1F748B26F979F72AD975AD7BA4859BA9E5B4C74036920E540560DE4C240742D20EB5A40AE6A0179D5402E0CE47515B9D66EB7FB5A0588AD248F7FD1E7EC0DA481349006D2401A480369200DA481349006D2401A4803292F3AE77B89FF52DC21CFBB2A2C';
wwv_flow_api.g_varchar2_table(11) := '72D45FB580FC6E201706F2580BC8A11690BE1690A1815C90AC54256F3E54055285FC11600099D96EB6044F96220000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16874452196590298 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4border1.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000320000000108060000009CD1FDB20000001974455874536F6674776172650041646F626520496D616765526561647971C9653C0000004C4944415478DAB4C6DB0980400C44D1597C7E279D58928559929D';
wwv_flow_api.g_varchar2_table(2) := '24DFEB8B3842041BF0C2815B22028501F86A524B1DF534A4D1CC161199F043EEBEAAEACCADB4A59D0E3AE94AF17ABA051800996F19FFA6CE6F580000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16875148961591764 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4border2.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000001000000190806000000F090447F0000001974455874536F6674776172650041646F626520496D616765526561647971C9653C0000003B4944415478DA62FE0F044C0C40401AF1EEDDBB7320863E88FB03';
wwv_flow_api.g_varchar2_table(2) := '44FC8413BF40C46F6620C10C2298400423480C6CD17F10978119682D0340800100F83E11DAD6E5713A0000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16875846373592937 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4borderBottomCenter.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000019000000190806000000C4E985630000001974455874536F6674776172650041646F626520496D616765526561647971C9653C0000017B4944415478DAB4964F4AC43014C6F362FD8F4845A4A2880B5D7A';
wwv_flow_api.g_varchar2_table(2) := '0C773D8F9BAECB78062FE101BC457B0517DD155C77F27C91A63CC3CB246D35F0233030DFD7EF6B5E6614222A5A40E8918C38208E8933E28228883BE291786ADBF60D672C2B3A77E148F2D2DE9763C2B8E0A1944E7C6A8ED15A2F4A820103D10800706D12';
wwv_flow_api.g_varchar2_table(3) := 'DC6160D62489556518DBBEEF3FFFC2044329AC495DD71FC3307CA59F479C924BB372449C12E7C425713DCECB43D3349BD439F14D9CD11EB14F1C1227E350E6C4157143DCDBC1ECBAEE7DEE3062A032C3F62D31388AA278A1E97F8D550736091D493F8D7B';
wwv_flow_api.g_varchar2_table(4) := '5F3C9923F329CB32AFAAEA39CFF35B638CD504BB3B4DC9849BF1F7A43D23BE73F8C3FD68654245E0D56778F2409DAE4ACD4CA656B21D4718BCDD083741CC2068221928211537E115C19224A1FBCC899B80F8546D16B956C013865114BCB446104F328955';
wwv_flow_api.g_varchar2_table(5) := '8782280807246A1232F23F5321835413A93AA9465C6BA202062A50E36213490422BFFBB0D44425FCF9F8756B00BBEAFF6D7D0B3000E71323D3EAA8BF120000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16876543785594176 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4borderBottomLeft.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000019000000190806000000C4E985630000001974455874536F6674776172650041646F626520496D616765526561647971C9653C000001784944415478DAB495CB4AC43014869358C71B83282215415CE872';
wwv_flow_api.g_varchar2_table(2) := '5ECF3728FA0CCE43B8999D6FD1F6115C745770A5D226FE296909E1E4E625F0D19469F24DCEC94998CA684DD33C33C636E01EDC80129C833538022B500061E0183675729A3264B55C892B53916FF22542083D503A92E8EAB2249C73151028DF6A7EBA1219';
wwv_flow_api.g_varchar2_table(3) := '10A95FADA4EFFB373C464B245342962C1986E1BDAAAA574792969BD41AA9EBFA119FDF99FAB80217E0149C8043AA46CCFC6992AEEB5E4C01DE826B7009CE4C111E8303B00FF62CC12211B110A1CA9FCAB27CD0AF16A3152EE909D5F25EB46DBB5DB61A76';
wwv_flow_api.g_varchar2_table(4) := '8FDEA6FAA993AC73B0DBED7A4240E5C5B78DA7256DAC1FED7F373A0CCE33B6CBD41C2E9DA80FE2A8B0078F04D22360D48AB4E493905022AAEF86890C97967C05246E8547C343896C09F31417B58BA4E734F6267E4DC45225120D954E3C37371A0B88627D';
wwv_flow_api.g_varchar2_table(5) := '163AB766C92A70E184268B0A6C4911BAD542959C7215CF129178DDB29CC97D129529CA92F0BF982C2899CEFB7F6EDF020C0055B087FA515FFC4F0000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16877240982595471 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4borderBottomRight.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000190000000408060000007BA194260000001974455874536F6674776172650041646F626520496D616765526561647971C9653C000000364944415478DA62FCFFFF3F032310303030206366286601625620';
wwv_flow_api.g_varchar2_table(2) := '6603627628E678FBF6ED3C2121212306220113031DC0F0B10420C000308407049528EC860000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16877938394596670 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4borderMiddleLeft.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000190000000408060000007BA194260000001974455874536F6674776172650041646F626520496D616765526561647971C9653C0000002D4944415478DA62FC0F040C44024646460D20F50F88FF22E13F48';
wwv_flow_api.g_varchar2_table(2) := 'F41F34B97F40E3FF3131D0010C1F4B00020C008D50140553B6B0B30000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16878668574597801 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4borderMiddleRight.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D494844520000000400000019080600000016B98F3B0000001974455874536F6674776172650041646F626520496D616765526561647971C9653C0000003B4944415478DA62FCFFFF3F03326084623860214F8099A0000BBA';
wwv_flow_api.g_varchar2_table(2) := '002BBA001BBA003B41010E14BFBC7DFBF62C8AC07F34EF3231A081412B0010600015860B0107A9792A0000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16879365986599084 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4borderTopCenter.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000019000000190806000000C4E985630000001974455874536F6674776172650041646F626520496D616765526561647971C9653C000001094944415478DAB496510EC2200C86F9A1FA48E2CEE0093CC70EE8';
wwv_flow_api.g_varchar2_table(2) := 'EBDEF4703BC31423092B941544920E16B6FFA32D65C3B66DE6DF8DC205C0685D64905162D23C0D10862A5C1DE268985343501143E51935A424A219AB2112E0C876205202D2976D726F595F828990DACA6D62288C33103586280A3A61AC8648A054D0154C';
wwv_flow_api.g_varchar2_table(3) := '026510BE457978228058CF61F1BD8F0E29F391AE9EB8CDF37C5996E5DE5AF110BC4941A7D0AFEBFAF0DE5F89C86B20A5A3826FD39D2701304DD3EDA89AAD72EBF264AB01254829F93CE92EE42084487DB2862FE3F7A325D5430CCF39DADB8BA7D60BC913';
wwv_flow_api.g_varchar2_table(4) := '5329C2086E6AB6226E2A474A17048DE7D7CF9E482103ABE42E08943033DA939E3F94ACBD041800AC481BD8CAD99F980000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16880063182600338 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4borderTopLeft.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000019000000190806000000C4E985630000001974455874536F6674776172650041646F626520496D616765526561647971C9653C000001734944415478DAB4964D4EC33010853BE6B7FC2A80A0880A81044B';
wwv_flow_api.g_varchar2_table(2) := '96DC2227621F71072EC1263B0E907D720516D945AC4363C6D1B872078F139732D2AB2D379DAFEFC971025AEBC97F1790DCDA28D598300035B2B9DE042406A06321DB034D75C477226437009146694D844C038031F320C8428E0380210D822CE48C41B83A';
wwv_flow_api.g_varchar2_table(3) := '36DAF92400FC05990900B7399F77239CAD406E0310AB8530F7395B0159C8A307C2015C128C6F8C25E4C9597463E18DBFD9B808C4B774D343AAAA7AB30B4A290D00DA8C4DD37C6659F691E779438DB9B833DF86E821E643ACB66DBFCAB27CA548EF5173D4';
wwv_flow_api.g_varchar2_table(4) := '15EA1C758A3A42EDD30D6D4E8E2D3AA6C08D2B08B155D7F53B81EE5037A84B5442F7D8016A0FB5C320100531458E1E68375EA32EC8CD2173A35C375110135D9AA6CF4E6CAE9BA9145914C45451142F8E9B199D162781C87A888A7900254932779A28963F';
wwv_flow_api.g_varchar2_table(5) := '48BF8B82745D074273083CCEE320681D3CCD5D80EF1D626D2712E8EF7179DE7260E09AB52083FFDA573F020C00D48DB1DF250578C70000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16880760379601599 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4borderTopRight.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '47494638396120002000F60000FFFFFF4D4D4DFBFBFBE2E2E2E4E4E4FCFCFCCECECEA6A6A6ADADADD2D2D2F8F8F8EEEEEEABABABA4A4A4BCBCBCEDEDED9B9B9B868686A7A7A7EBEBEBF5F5F5A3A3A3BDBDBDC6C6C6727272757575797979969696E6E6E6';
wwv_flow_api.g_varchar2_table(2) := 'F7F7F7A2A2A2C0C0C0F9F9F9D8D8D8767676989898F0F0F0BBBBBBA0A0A0D1D1D1DFDFDF717171747474C4C4C4D6D6D6DBDBDBF2F2F2E0E0E06E6E6ECACACAD0D0D0C2C2C2F4F4F4999999B2B2B2E3E3E3EAEAEAAAAAAA5959595858586666665656566D';
wwv_flow_api.g_varchar2_table(3) := '6D6DB8B8B8E9E9E9E7E7E7F1F1F1C7C7C7B9B9B9B5B5B5919191AFAFAFB4B4B47D7D7D8181818484847C7C7C808080B1B1B1DCDCDC7F7F7F7A7A7ADDDDDDD4D4D4838383B6B6B65F5F5F6868686F6F6F5C5C5C5A5A5ACDCDCD8B8B8B878787BFBFBF9C9C';
wwv_flow_api.g_varchar2_table(4) := '9C8A8A8A8E8E8E9292928D8D8D8888886464646363636161616A6A6AD9D9D9D5D5D5959595CBCBCB9494946B6B6BC3C3C35D5D5D8F8F8F6060609D9D9D9F9F9FC9C9C9676767A8A8A8787878AEAEAE55555500000000000000000000000000000021FE1A';
wwv_flow_api.g_varchar2_table(5) := '43726561746564207769746820616A61786C6F61642E696E666F0021F904000500000021FF0B4E45545343415045322E3003010000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B39363493820F17218305353A3B';
wwv_flow_api.g_varchar2_table(6) := '12990A101822168214223B3D359E900B111918190E00141AAD3F820B3740028E02121A1929183200363C3E28004228D12E8F131B1A2A30A300041C8213D12814901C231A223386422F283892242B31C1861D988F0A141D058DFA8B02060C1224941097A8';
wwv_flow_api.g_varchar2_table(7) := '0090010408221A70A041050F2658282201AE5B220208186844D04211B46816111548E0C0C28713201415C0412088C2440A14A4CCD4CF450744145E3A2AC001C58B698548AC0312E95BB4098240CCC4014EE72202D15E60123AE0E64714401D3DF0494210';
wwv_flow_api.g_varchar2_table(8) := '54144401F80A22EF110505836E440B028BA620A62810BABA2D246082DCB978F3EADDCB7752200021F90400050001002C00000000200020000007FF800082838485868788898A8B8C8D8E870F138F8E172A585B938B0A1156595C0599830B312D831D4C9D';
wwv_flow_api.g_varchar2_table(9) := '510AA100200D494A338214A85A512082A08F24464A4C50B20A54565A5DA00B3740BA8C05474B4D514C530055573C5E004228DB2E8F0B264B501A088252A50013DB281493401E4B4A1786422F2838A1423132CB841D3493203AAC6AC42F510B224590AC18';
wwv_flow_api.g_varchar2_table(10) := '88A800900104D825A2E020A10D2752149150C74111882116425AB8A148DBB68E8A80243020E3890045057010082271918082AC1ABAE8808842CD470582A078D1AD10897A40323D5027A9152E0038D4FD64C461DB8B7F4707F03489A2A8A3A32F480822B0';
wwv_flow_api.g_varchar2_table(11) := '2D290064415E4E1238E8C6B620831570864A874248CE860BBCDEDDCBB7AFDFBF800705020021F90400050002002C00000000200020000007FF800082838485868788898A8B8C8D8E86244E3F148F8D123C650C958B1D4B3C664A209B8342322883344D3C';
wwv_flow_api.g_varchar2_table(12) := '674C0AA3002008606343821D54AB50A2001D952E5F61646017B064AB5C050A123340058E054462635D5D2C003F3E681F0036622D282E8F240C625C1148000221218255532828948F1308D23186402F2838A32E2753CE0C75A0B109C42E4601179190B162';
wwv_flow_api.g_varchar2_table(13) := 'C59483870A001940405E2216432EAC98C141110978283A2A7A72A2E4097E898480149988C200142F9A292A808340108B335F3D73D1EB10059CCF82C00C5788843E209B16809C20C8A0201C20812E120A93A0D101BD54C223EAC8C58017240411808714C0';
wwv_flow_api.g_varchar2_table(14) := '821B4104143C7883ECA0843A13014C8027246EC4055CEDEADDCBB7AFDFBD81000021F90400050003002C00000000200020000007FF800082838485868788898A8B8C8D8E8624550E148F8D08583E47958B0A63586E5D209B8305374183146458684A0AA3';
wwv_flow_api.g_varchar2_table(15) := '822B5F105B821D5CAB11A2000F1D8F05365F1B1B6C002046AB46050A0D6E11388F171E5F6B6D2D000E19186F00485A3D70538F2E3F1E10620E00052D69826D3D654734950B44E52786475844CF9B142169050C090022AF5201018E023202F182C5141408';
wwv_flow_api.g_varchar2_table(16) := '131500328000254538D68550B34011091420392C9A0012A40B45424A8A542400C78D1B131615C04120C84599AF12BAE87588C24D5F4150BC385988C40B1440367D0419B358441C257F322229549ED11BBD529AAC4461C000128208804C0A6081A9888F04';
wwv_flow_api.g_varchar2_table(17) := 'A0BD3196544E42541085BC3D546001D1B978F3EADDCB576F200021F90400050004002C00000000200020000007FF800082838485868788898A8B8C8D8E864216431D8F8D48512245958B0A6B511971209B84200A831D621A1960A6A3000F444E6A829D1A';
wwv_flow_api.g_varchar2_table(18) := '2A63A2000B2E950908070D090020101A1823000A12294A1C8F4F360C0D1E280033505143005572593A3F8F1D174E391E2B0005524F8223DE3A17952EE3392C8636703B61149B1D282F87200CBC11E2AA510183136EDCC0B1A800900104F6297281A2220A';
wwv_flow_api.g_varchar2_table(19) := '1A8A48587436D1E24545423636C4A170C248024124362C68D005A54314543E2A10C41FAF42245EA000B249634593C30408C2615126A309155F60CC798352C88A371D292030808420021579EABA014468A5020705DDC83A282C4B004851103C5BA80089A8';
wwv_flow_api.g_varchar2_table(20) := '6C08E3CA9D4BB7EEA8400021F90400050005002C00000000200020000007FF800082838485868788898A8B8C8D8E862E2B6C0A8F8D25115433958B2026114D23029B891D739F622082202F0F954F6C28820A7411506BA20B5F6E51528E135E3F48690002';
wwv_flow_api.g_varchar2_table(21) := '0D114974000A5F6567724EBE2B16454E04007560116C003F76CE56758E20536F0E365B00052FB1024666727046148F146A6F25BD8547F046249B2041821CA2F0C68290518D405028D08804010213161568D18240874514506844414311898D1C306EE4A8';
wwv_flow_api.g_varchar2_table(22) := '480848460F6EDC88A8A8000E02402E326288B0510117320D5198B7A94010142F5C1822B10EC8A68F1A5982100500C7469E8E1E687CD191E88D8B26350A7D0482C0007F000868340A60C10D204C2BD1047063ECA0B53514014CD07830AEA10224B6DADDCB';
wwv_flow_api.g_varchar2_table(23) := 'B7AFDFBF7D03010021F90400050006002C00000000200020000007FF800082838485868788898A8B8C8D8E860503038F8E6C236D32948B200C6D6307059A890A779E5F2082203243148F24280FA99D5C740200241E296E478E0A6A31179302476D5C1200';
wwv_flow_api.g_varchar2_table(24) := '0A1530687663B68C1D21AB333800322346990E29CC3C3F8F1C2C062B210005379305236E76651BAD8E20042C5B1C864557656B249A05240B87285CF8E04254231038F831224180C0844513C0D8C960609182172832D25084E4CC151F6D508DC2A8511101';
wwv_flow_api.g_varchar2_table(25) := '360958DC60B4E0C68D878A0AE020004481C19B880AB8E88088023C4A0582A07851B010098C4034BDCA0813C4331C1951FC6CF420E38B8D476FF01412B5683C02371412C89814404B20CF800EBA417650289C821126641402171209AF75F3EADDCBB7AFA8';
wwv_flow_api.g_varchar2_table(26) := '400021F90400050007002C00000000200020000007FF800082838485868788898A8B8C8D8E8720028F8E41453F40938C1F155F1F998A023F15100C920002096C1D8F054234820244A3079242775119488F414F213800050E153547052039782A2962A68B';
wwv_flow_api.g_varchar2_table(27) := '022F282D5324002177742D0033B829580E8F402852213782139805741929305FAB8E201CE20B8644293E104299ADAF861D752B5C7C6A0462823E4642081098B0684218371A642C02010D058A7E88F2E8D8984481228A162F2A3AD2A36413108B16DCB8C1';
wwv_flow_api.g_varchar2_table(28) := '50D1030F54A8841808AA59A3022EDE19A240E1538120285E082C44021AA6492442B68C240847C89E8F1E587CF1AAE88D5542420E8547E0063500042C1E5509A480CF4137C40E324B73D0048B070FDB162A4062ABDCBB78F3EADD8B37100021F904000500';
wwv_flow_api.g_varchar2_table(29) := '08002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90870A69210A918B53480C32978905439A3F0582022C321D901D9600021748393602002E47114D258F132F03420005754877B8204E54504C10B28C053728282F14002F3F082F';
wwv_flow_api.g_varchar2_table(30) := '00435D4D4C1A338F40CE280F8224E20512DA7815A88E201CCF2E865E4C781EF090052ED1861D5B75349D8C404CE8C54808010213163D688381099B45020680FB97C8861C2B569480501471A2221B59426A5C64F04642450FC48858F210E0A102149439C2';
wwv_flow_api.g_varchar2_table(31) := 'B7CE10057DF782BC3344E2050A209148803B0942190E70381B3D70F6E25FCF1BA88480B3C78EC00D12820838030A60C10D1CA3228505D0ECE7A0B12E273823E8B2500112540ADBCA9D4BB7AEDDB981000021F90400050009002C00000000200020000007';
wwv_flow_api.g_varchar2_table(32) := 'FF800082838485868788898A8B8C8D8E8F9088240B918C1C433337958A2C170E4383022F6A0A90202082059D251F050034446D631F8F242F03428269174417000225465C5D0DAE8D1C28282F14004075161C0006B25D4BBE8E38C9280F823424824E635D';
wwv_flow_api.g_varchar2_table(33) := '5439A58E20C82F34861764E4EB90052ECC860A275BF09B8A020F4142C689841020306111901A1A5424F992CF908001DA1A1ABA63A7228F2B32121580984C62210466429AB16340910B02370A2A7AB0210A13264E04E83354A083CD47F23A2062314467BC';
wwv_flow_api.g_varchar2_table(34) := '20CA5C182291E04B1BA1B5B4A90421134036290E50407A904C1D005B37740AD196EB110894DF0010480644D0821B3800E21C7483EC20B5FA132624EB3AB350011248EBEADDCBB7AF5FBE81000021F9040005000A002C00000000200020000007FF800082';
wwv_flow_api.g_varchar2_table(35) := '838485868788898A8B8C8D8E8F90882002918C424F2C24958A0469322C83051C409120058337690632821D6F1E262D8F422F3742829D5B5300052B26106B0E8F1C28282F1400422D0613006A15C0625B8F38C5280F820A34820E5F6B46480A8F20C42FDB';
wwv_flow_api.g_varchar2_table(36) := '855B1B7136E78F052EC886202C27F19B8A020B4040F6884204049A29E230874A12266250241230C05ABB433952A4C04211C22944041C2ABAE3A66347088A5C10B82130110E084A94509943E09EA1021D625E64F4AEC321104386D8845420883117861C68';
wwv_flow_api.g_varchar2_table(37) := 'D13206E82312D6044E1294068A1E1D31203D28660E00895A368518C0A387082410233501C88882148005322A947487AA98595E2E14074D28762B6EA102248CDADDCBB7AFDFBF9B02010021F9040005000B002C00000000200020000007FF800082838485';
wwv_flow_api.g_varchar2_table(38) := '868788898A8B8C8D8E8F908805918D1437040A948A1C28281C8420939005A200049D2F820A094417998E3437374282A75203000532473907288F41A814004203282E0052360C0D0D9F8E389D280B8220AF75CC265EA58C209C2FC3856A07740E1D91052E';
wwv_flow_api.g_varchar2_table(39) := 'E185204F21E79A8B02243838EB882E0404138B40076364BA40C095E854271A8A8E3089C2508307450651204C942783458B0F13512070839FA2091EC8800153E1593C42053A7478D5281DBC420262C478E9A840B017C80A31B022C7484E4724A479042140';
wwv_flow_api.g_varchar2_table(40) := '50981D5AACB081F4001542122F6E9C43A203A90348203892A8D5090800050DDC88F1386AD08DAE831E143D096042275A6C0E0B1520F133AEDDBB78F3EAA514080021F9040005000C002C00000000200020000007FF800082838485868788898A8B8C8D8E';
wwv_flow_api.g_varchar2_table(41) := '8F909192840A40400293894028280F9983050583049C1C8205035304901D37374282A42841824F330E0E348F389C2F1D004203031400412B0E45552E8F139C280B820220822C1645477590201C282FC485525579170A91052EDF85023703E59F8905420F';
wwv_flow_api.g_varchar2_table(42) := '0FBF8A140404138B1379356D620D562592854257A21F64BA74891021872282061115694291E21D7B046EE853F4E08E988F3968BDA3A4C05DA373F5D46DD992D2518120DD9615CAC3E3CA86888D4838DB080213002356CED83100E9412F5D245EDCF855C4';
wwv_flow_api.g_varchar2_table(43) := '4A502FDA329288C50908000512B07031656ED08DAA83164C7BD70C05AC91840A909089B6ADDBB77004E3360A040021F9040005000D002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840A40380293893828280F99830505';
wwv_flow_api.g_varchar2_table(44) := '83049C1C83241C14901D37374282A4284182402C062190139C2F1D00420303AA242132756C988E0F9C280B820220821CC533B88F021C282FAA8538751F09D090052EDB863841E19F8805342424C889140404138B0B44071E2648408AB12834147DD8B0A6';
wwv_flow_api.g_varchar2_table(45) := '8D4124FE96054CE460CC98300E6D289277A39E221247BE7C99630387BA420A14A46334AE97210A6F2E987C5420483617868EB8C132E7D52312CB2C820828800B0F343EE82878A42C5B40122FBEB0018084078F2B584E3C0241E0060958283C9029A0E04B';
wwv_flow_api.g_varchar2_table(46) := '99A75E22891274030591AD006878C0A264C0275D17148880E270F55301120B467EDCCBB7AFDFBF9002010021F9040005000E002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928402130B0593893828280B99839883049C1C';
wwv_flow_api.g_varchar2_table(47) := '83142E911D04374282A3284182132F283890139C2F1D0042030314BC9C2D2F900B9C9D820220B2282D6A4090051C282FC085422D5328A18F052ED68642979F8BA71DDC88140404138B422B454E361FAD89AF28348A31070D15151E5B14DDCB97E8C29783';
wwv_flow_api.g_varchar2_table(48) := '0763285277A39D22214424DCB9E30015394220327673B1CB908B156C3A760B42CD22211B19343430D988C431874F4A29E08245059E0322193DC8950F880A3401ABF8C082018F974720569110F442C58E31054078188A61848068835AF8D841069310083E';
wwv_flow_api.g_varchar2_table(49) := '52FCF8F4E28A8E22A6D884FC44E148959C1708E3CA9D4BB72EA4400021F9040005000F002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A3828280B9888049B1C831D1D910A1C044282A0284182132F2F978F';
wwv_flow_api.g_varchar2_table(50) := '0F9B2FA54203031400429BAD900BBF9D000220AFBFAA8F051C282FBC85BE283892052ED08614349E8C0A14C78B140404138B1D532B1F2B528BAC28DB892C554548483FF09FBFF887530CFE0C365C281277A3DCC037486C1061C7AD9000050296B9286588';
wwv_flow_api.g_varchar2_table(51) := '460C190A221508E24C60A11F4D2220D8C788C4AF72025AB802214603142A792836AAE56C5B0E39580C0070204243122A2B1E812070E31205153AE01829004242CF24260A40920A80048CA461A4BAF020228A054F6D92FE1844C100464F138EFC90D9B0AD';
wwv_flow_api.g_varchar2_table(52) := 'DBB77004E3460A040021F90400050010002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A1328280B9888049B1C832020910A1C044282A02841820F2F0334900F9B2F1D0042033714B99B2838900BBF9D0002';
wwv_flow_api.g_varchar2_table(53) := '02829A9BAA8F051C282FBD85429BC191052ED28614B39E8B0220058C14040413DF2F6A092CCC89AC28DD883775431717278BEFF1875216FE16061651E070E39CA20E0666BC8971C95B2101E29AB9C06588860C35A520150802CD85212F63DA54D1D688C4';
wwv_flow_api.g_varchar2_table(54) := 'AF73029E000100E24B042E71AA2878540BDA2C043C44E0FB4025029838311E812070E312053C56CA6C2800228F129F39223A8A280443D236E268DCA1D2E58DA71156789418D421CD94999826D87080D6A1DBB77005E3CA9514080021F90400050011002C';
wwv_flow_api.g_varchar2_table(55) := '00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052442938A0F28280B9888049B1C832005910A1C049700A02841820F2F371D909A282FB34203371400429B280F900BBF9D0002028213BFAA8E051CB6BC85422F283892052E';
wwv_flow_api.g_varchar2_table(56) := 'D1861D349E8C05A58C140404138B0540030340C88AAC28DD890F4F2D6969D6EEBFF1884132FE32AE1451E070C39C22102D4E9C9002C29B217090B0CDDAC6E249C3884150480961E802040F1F263A72B1E9C81C632150183BD0A6069D0F171B697A83C50B';
wwv_flow_api.g_varchar2_table(57) := '00273EF0180030244E9B1173123C02F1420C03011492D88161C25895303F7F4012500C07163B3EDA20A3E0C4489B189816A8C0AA5590828D3123515062C7CD1D8785102EE0A192066EA10724ECEADDCB9750200021F90400050012002C00000000200020';
wwv_flow_api.g_varchar2_table(58) := '000007FF800082838485868788898A8B8C8D8E8F9091928405242E938A0F2828249888049B1C830205910A1C044282A02841820F030420909A282F1D0042033714B99B280B900BBFC100A48213BFAA8F051CB6BD85422F283892052ED0861D349E8CA58D';
wwv_flow_api.g_varchar2_table(59) := '140404138B0540BBD58BAC28DC89C3BFD99FBFED88EF9BF187141C37E48A05412F06A4EB46F05A10018640A0B8811052B322587E1892C1C0C6160590842030B30382B1342F8C39A970E7089B868D6658E901670680221994240060600EC93C2D1EA5C9E0';
wwv_flow_api.g_varchar2_table(60) := '268F800E4B52E0B963CCCB1C0F12D84022F14010092629447C29D5C182893B52303D8D5AE39B801BAE30B9689222830982853C447D8396D082126F0830B69D4BB7AEA0400021F90400050013002C00000000200020000007FF800082838485868788898A';
wwv_flow_api.g_varchar2_table(61) := '8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820F031C02909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BAC48BAB28DC89C2';
wwv_flow_api.g_varchar2_table(62) := '9BB6EABEED8842BEF18A141C37E48A0538043800EB4610480919B20A090882E39BA309497AC829612884831569123AAAB243079C3900043CB92168868D121F5A4032A1234B991500883419C302801A0436887C78F0A88586144E047418136589130005EA';
wwv_flow_api.g_varchar2_table(63) := 'E0240204929074429644A1728014882D3F0C80C014358A920ADF6E79A241C6EB1D8285EE78AD839610890F7508B6B69D4BB7AEA0400021F90400050014002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F';
wwv_flow_api.g_varchar2_table(64) := '2828249888049B1C8305920A1C044282A02841820B374102909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BA9D8BAB28DC89C29B03B28AEBED8842BEF18B141C37E4';
wwv_flow_api.g_varchar2_table(65) := '8A05380870A8D7AD1B0E0727E415227129D20425597858307443068B20DF1A1D8123A74C0500055EB4027062C59629231D799063C6CD10005EB8D47802408A85156CD48078F4040A9E220214ACE962A404C8295E569CD8F9480831002EC2748973849480';
wwv_flow_api.g_varchar2_table(66) := '1709AA617211A74B983C19BBD110E3D546C14247BC1A381BED8201A66C06E3CA9D0B20100021F90400050015002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A0';
wwv_flow_api.g_varchar2_table(67) := '2841820B3740A48F9A282F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28C140404138B0540BAA98BAB28DB8924BE37DE88036A09319D8942EFF1872D614D26B71215C0412008BB451D84ECE34608';
wwv_flow_api.g_varchar2_table(68) := '079121200EB9B814294817336E1C18A215EB11893065AEF89000A000016A0050849082E2C1230721DDA85801E0420D0903000439B192C0230976DCA4C823408189352668A6E429CA919408518ADCA251630D1D8D2581005100C9C538413420AC99438421';
wwv_flow_api.g_varchar2_table(69) := '210A73D67CB160969003B56A0DDA0EA220838500B978F3E60D040021F90400050016002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820B3740A48F9A28';
wwv_flow_api.g_varchar2_table(70) := '2F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28CB937138B0540BA978A42604A3512378A24BE048B24293D3D3B1FE8F18C174C2935D80A15C0412048C0431D5C78E36668828518200EB9380709C8';
wwv_flow_api.g_varchar2_table(71) := '181F2AF215828722D623216D7CA410910700396200800C7BE404C6482875006C9150A5154714A21A81E0922243140705403068E0E484A009D21E3C629041839388142434C8135310058A8D28C838A1C0EA9D060886302404220FD82D63091938E024675A';
wwv_flow_api.g_varchar2_table(72) := '931C07A8BD9D4B976E200021F90400050017002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202';
wwv_flow_api.g_varchar2_table(73) := 'B10013BDBF8E051CB4CA83422F283892052ECF841D349142A88DC68C2B18306B9D890540B9DB8A42183BEF6F8A24BD048B241959597033ECBDA28B439A889883AD50011C0482143CA4C005B851861ECC3000E21085858B70B41101E5822112D2603D1202';
wwv_flow_api.g_varchar2_table(74) := '010F132A555A5D020044D8A32A269570310040CD8F21C384F402E208441B264DBACC28208048911952043D78F1C25B23274D2210A948C346910F2C06755000A9C314355C01742852C48B1A8884047C286201055A42380D2E2458F756D0C3BA78F3D60D04';
wwv_flow_api.g_varchar2_table(75) := '0021F90400050018002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202B10013BDBF8E051CB4CA';
wwv_flow_api.g_varchar2_table(76) := '83422F283892052ECF841D34912EA88DC68C432218239D8905400304D8864278567070178A24BDA28A42516666656FF8F68C627449E2811D251C04821834A48006B85186165C4820E01085858A26CC51C2858D2112D280407251810A99385E04D1502008';
wwv_flow_api.g_varchar2_table(77) := '482F6F8D1C2C211366841A005262A4D925A4D7044720E6D05C13A380802143D45003F0E0C5008C86888469F3A662871943A6DC2305025287102D8C81B83024C1568882580C39310CED2005370A7EBA9D4BB7AE5D4381000021F90400050019002C000000';
wwv_flow_api.g_varchar2_table(78) := '00200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A02841822404400590322D282F1D0042033714B89B28BC8F3910B40B8202B10013BEC08E40505F4FCC83422F283892380EC587';
wwv_flow_api.g_varchar2_table(79) := '1D348F052E2442028DC88A245F1A19221BA88905400304B7895E76763C3C650EE7BEA28933DC0814E84591105FAC1291A0D304CA920697DEE178A56051251211472122C12604394314A4395A70204E8D048648540302890682381BE8D411A400842020BE';
wwv_flow_api.g_varchar2_table(80) := 'DC357A6364C31C094F00047932E0D6C14DDB180990B0E14B8513000AB0A0C512C00379151DCD70CA869C0035B4FE01380649819417C80AA4A1AAB11090272F0D44B6A590B5ADDDBB78F32A0A040021F9040005001A002C00000000200020000007FF8000';
wwv_flow_api.g_varchar2_table(81) := '82838485868788898A8B8C8D8E8F9091928405422E938A0F28282498831D0583049B1C9E00694D3F4282A3284182240440A18F733D29061D0042033714BB9B28BF8F123B3D460F8202B413C1C38E38493B654F86422F283892383F6CB4851D348F053496';
wwv_flow_api.g_varchar2_table(82) := '028DDF892C1B4D4C495F9D8905400304BA88204658FB3030488A2482BDC2B7218341830E1409090644518B0D64C88C61100F51011CB2402C022144883853895C2478926E1085678F48389973A7852112D81A3EA25085CE813C090481D0080047B08F8DD8';
wwv_flow_api.g_varchar2_table(83) := '983880E0C70D003007E85AB869C123220718207109A095CC05F578365293A7889A50056E6C1A08A0404946139289DAA40D24215E040D14B82D6476AEDDBB78F31E0A040021F9040005001B002C00000000200020000007FF800082838485868788898A8B';
wwv_flow_api.g_varchar2_table(84) := '8C8D8E8F9091928405422E938A0F2828249883144283049B1C9E002D4D294582A328418224044005901E593A56060042033714BB9B28BF8F0C705A3B128202B40013C1C38E385470671786422F28389213255BCC851D348F05344234E08AE9886973644B';
wwv_flow_api.g_varchar2_table(85) := '111EA189054003041D89203551511A1A7888282211EC152201749A2854384391906040144931D1A6CD081BF31015C0210BC422102E5C40337588469A1BEB045118E9C885853C3F6E1822912DE223106F8E54F9804210088F0070041BE70885932A5E623C';
wwv_flow_api.g_varchar2_table(86) := '00407340BE879B3A15AD62E1C200569B6C2EB807B49182136C640228706393C1B129190920C461D30292850E2870E0D015AEDDBB78F3EA5D14080021F9040005001C002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405';
wwv_flow_api.g_varchar2_table(87) := '422E938A0F2828249883344283049B1C9E002D50195582A3284182240440059007665665320042033714BB9B28BF8F473C6756398202B40013C1C38E13643C767586422F283892135E32CC851D348F05142E34E08AE988520762617139E389054003040A';
wwv_flow_api.g_varchar2_table(88) := '8902155D5D114B4B2E2822110C88BE3B6312261CA24848414503189830D1C0C13C440570C802B14800051A1D4C29EAF0C2E0210AD01E5188E185CD034324B2997C74E2439D29DB0080E00800C7B3472456D439F1645CCC01211D6EBAE4C8051B19695E02';
wwv_flow_api.g_varchar2_table(89) := '686572C18D200220D9EB04A0C08D4DAF04AD9B1464D30291851404993016ADDBB77005E3CA4514080021F9040005001D002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840F172E93840B13845F4D522498005349782582';
wwv_flow_api.g_varchar2_table(90) := '142A4A521CA1156E576E4400141964284182240440058F4E306E766806004E6D3714004228CCC98E0F6130683C158213BD0013CC28CE8E37D13E1686422F2838920F1F1702871D3490EE14D88BF3892F477310104EEF890540030828482420CF9A366DC4';
wwv_flow_api.g_varchar2_table(91) := '1861A388C43620FE907C99389158A265CC2026E2500501022717BA1D2A8063178845023A5018184A91021C42105110E9084488044F2E1522514EE3A317539EA0D80400C4490038B6D1741942E88B773C077450B64D67A3020350BC0005804046410B6EE0';
wwv_flow_api.g_varchar2_table(92) := 'A8C748C102AB3798E11244761210660B0F5A1A1230E19ADCBB78F3EADD8B29100021F9040005001E002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B45330A938242172184743B3A479902071822168214783B3D2699';
wwv_flow_api.g_varchar2_table(93) := '345C19292A0E00141AAC4482240440058F0C1A1958183200363C5828004228CE148F131B1A2A301282040F8213CE28D08F1C231A223386422F283892242B3102871D34900A141DBF8CF78A421639121225DF101500328000A644431A54F0E0C144024524';
wwv_flow_api.g_varchar2_table(94) := 'BA0151148381458B2CF44954E4828D03071F4E74505400472F108C1428409969910017230F5108F8A80007142F5C1822816E22246ECE260802C11247379A8C08387B218FE78091CD9E410282930436673E17DC5007A9808B83006E380B32285F4BA328AC';
wwv_flow_api.g_varchar2_table(95) := 'B63424E081DAB57007E3CA9D4B576E20003B000000000000000000';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16881458006602768 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't4loading.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000010000004B080300000086081DB100000033504C54455252524747474F4F4F4141414B4B4B5050503A3A3A6060608A8A8A333333D2D2D25A5A5A515151F2F2F2898989FFFFFFE6E5E57774AF770000002B';
wwv_flow_api.g_varchar2_table(2) := '49444154785EA5C1850D80401000B09E3C6EFB4FCB0C84D462C661482D94FB93D3E6F969B79A94D0D270BD188803D257F447F70000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16882155203604030 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't5border.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000E10000004B0803000000B1EA10C00000018F504C54454F4F4FDEDEDEDBDBDBD2D2D2BBBABAB9B8B8EAEAEA9999999292925A5A5AD4D4D4E3E3E3C5C5C5AFAFAFA0A0A05B5B5BB7B7B73D3D3DBBBBBBC2C2';
wwv_flow_api.g_varchar2_table(2) := 'C2ACACAC626161AAAAAAB9B9B95B5A5A5E5D5D979797C4C4C49B9A9ABAB9B98D8D8D7C7C7CF2F2F22B2B2B2D2D2D2C2C2C4D4D4D2E2E2E303030CDCDCD393939ECEBEBE5E5E52F2F2FEAE9E92A2A2A4C4C4C434343383838323232363636D9D9D93A3A3A';
wwv_flow_api.g_varchar2_table(3) := 'D8D8D8CCCCCC4B4B4BC0C0C0424242E8E7E74747473131314A4A4A414141EFEEEE373737484848454545515151F1F1F13B3B3B3C3C3C333333494949E9E9E9464646505050EBEAEA5E5E5EEDEDED606060A8A8A8EFEFEF3535358A8A8AE7E6E644444482';
wwv_flow_api.g_varchar2_table(4) := '82825D5D5DE9E8E84E4E4E7575754040403E3E3EA7A7A7EEEDEDBEBEBE5C5C5C525252898989CECECEECECEC535353F6F6F6F0F0F07676765F5F5FE6E5E57878789F9F9F6A6A6AA6A6A6D0D0D08E8E8ECACACAB3B3B3F8F8F8838383ADADADF3F3F33F3F';
wwv_flow_api.g_varchar2_table(5) := '3F343434ABABABBFBFBFCFCFCF747474696969818181F9F9F9F4F3F3686868CFCECEFFFFFFA2A2A211BB09BD0000061D49444154785EC4D7658FE33C1000E0FC144318CACCCCCB8CC7CCCCF7E20FBFB19B6DE26E3655BB9BBBF9504BEE58F2237B1C5BDA';
wwv_flow_api.g_varchar2_table(6) := '593AFE7DFA076367E34E7B2CE5CB35EDBFD078D3CFD4CA7969DCBE2BEDBCD8582E44E1AE31BC04181A4100DBF0C6D862FA6E20661DB1A8CFDA55853064B91084871D13CD534A28DB2905CCD7747B4B9D345AF720BBF0C76100D0FEEB168B877FBB6DFD66';
wwv_flow_api.g_varchar2_table(7) := '84EDE0B84A68A097DB687E7A8768BB80EC79A029A5724064C05CEA1888BEF4B7687259687CC494527CEB9DDBA2EB0A396E7C55CC9C82F01CED3B4E80D0715E338208C4B80144066C600788FEF49FE83C404809211484BCBDB690E9A4B0E04C4158DA320F';
wwv_flow_api.g_varchar2_table(8) := '28C501428CE90F73CB575D1300524A74AD6377349DC0A8EFC8F6A71F985BA54B42A2280A01216FAF29E4BE23598EB1C88B11E321CB8004A22784B9268842688090427F3BE7AB2E239BC2D0A96434A46514188453D98990DECA7586910A992F561D34CBC1';
wwv_flow_api.g_varchar2_table(9) := 'D16C0EAA31991167C2FB68932896652988C7BABB6D7910D69F3843DEE9095B9342B6DADBE8A93086C286F5969CA7D333743F322107C6AACDD15EBC580B8C627C6FD4CC037126AC9B8F01A8AAAAF5606DEDE0F6B169F3CDF8CFED83B5B507BC5F21FB5E75';
wwv_flow_api.g_varchar2_table(10) := '41F52588A55658A8164940457A4237FD31AACF0B2D5768DD8050AE963F848DF8526CB94410B203BFCD80D309B35DF7D560932A3814DC2E4421ACBA3CA26E55921020D419D0135EA4B7CD47A568847C099BFF870F795E6B0D62AEF010151A9449D8843911';
wwv_flow_api.g_varchar2_table(11) := '17A642CCBBDD7EBE19776744AD5B49F6FBFD64A5AB01D027F4D20B20F7848A2B546E42285747AFC285F74EE3E5AA3C151A690713058030DFA4282453F8B49F60C7AB451B3D7185CF902D1C4CBEF4AC1191109630FE2D5CA8654E5A55599AAD21504012BC';
wwv_flow_api.g_varchar2_table(12) := '864916016BA8F23FD4F935F4D2610D23DAA547F972F1DE0261E2746F1003E1DD8B3A9CD51BABC38258871C2ED6A196999D34BA26D6A19BDE4E475687D2517E545B20CCA57A7156882074CF5220FACED2897096565400BE17CE521DE8D3B0145D3C4B797A';
wwv_flow_api.g_varchar2_table(13) := '8467293B68AAAD9345C2ED5EB119634342BE8775C483F7EB9BC2F7304114E8EE3E811F58F484FF7BC8D3C96604DF4341F8693921BFD3E84AC89D46F35D528C740313085D439A4E2070233D77A761E9110BB505C2CF5D41187A2FA581F7520A2B67C36A52';
wwv_flow_api.g_varchar2_table(14) := '18758C6C7F7AF0BD14E420E4ED6F15AEF6B618FBDF1678EE6DB1BFD2DB227AA1F83E0C7DF00151E2C0A79C18C1FB301221C470A5377E76A5377EE4C25FECD8CF4B02411407F0B49A5D7656098A2E1DBE730B413A459151D22F22925AC9835D824208BA45';
wwv_flow_api.g_varchar2_table(15) := '03758CFCC76B67B7DE8E8D0312F216F37B11610E7E90376FDE2321D39E8641C890FF289C0BE7C2F94DD33F158E6E219DDD42FC740B69770BE1EE16C34A9AE17BFED966EAF8B176747CBDF9BBE38B5057F38E5FD50911E9F8481A43A4A9BCE49F4CAFB61A';
wwv_flow_api.g_varchar2_table(16) := 'E010022B866001819468808021D2F19ABA2BA3B0D51501C6085117D6CB3B051A62D3005362B3783C10DD56E984E6B78E1522AC16A727A99111550684961DEBF80D1D9F9A704379B33A221CA818268E8D7066888B13F0372C404E2D4CC03089D560CAC2B5';
wwv_flow_api.g_varchar2_table(17) := '456FD66D615B24C812065F4984D9088B7AFA254416AAAEACFA28A622478448547BBAC2A5276F9649682EFC105622B3898A40A1EA22A203484284F2B15512615F451A5E21517A1691800E217444725E6143025E21A5B8110E00D03DEA1002B231F3FF616F';
wwv_flow_api.g_varchar2_table(18) := 'B6EB5030D7A1FF2EEDCCC85DFAF77EA8E90A72F44356E1E46F9AFEA46F1A6621C3BB9441C8305BB009FDF361A49A13CF87FC42F6199F4158E63DCD673B77EC12310CC571BCC3093A950A7277A24E0776BA402994525A722789C50E42254849879E9B6E4E';
wwv_flow_api.g_varchar2_table(19) := 'E97CFEE3F60959AA2483C3F1E0FDFE830FE9F8BEFDA7F0244321242109494842129290842424210949A87DC2562215DAFB529F70994806C2034A613309AB4BB7F096F7AA462CDCEED8B95B78171B7BE78D51186CEABDBE7101AFB9CCE1561FADB0CB0AD6';
wwv_flow_api.g_varchar2_table(20) := 'A757EFAF43B8BA982D0C8775CFA586DE02A9F0E7332D0B66649C8C8FBF37B63C965A4D4F8858180051552612229D4F081999CA02510A7D6957CED41EC2AEAE79C02B74E779BBBACC20CE832744299C2796DB3FFACACE06963885D6D8381B590022168211';
wwv_flow_api.g_varchar2_table(21) := 'E6EC9C910AEDDE7C43FA4F856FD2C2B9C2643C24B90000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16882851968605503 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't5controls.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '47494638396120002000F60000FFFFFFFF5500FEFBFAFEE3D6FEE6DAFEFCFCFED0BAFEAA80FEB08AFED4C0FEF8F6FEEFE8FEAF88FEA87EFEBFA0FEEEE6FE9F70FE8B52FEAB82FEECE4FEF6F2FEA77CFEC0A2FEC8AEFE7836FE7B3AFE7F40FE9B6AFEE7DC';
wwv_flow_api.g_varchar2_table(2) := 'FEF7F4FEA67AFEC3A6FEFAF8FEDAC8FE7C3CFE9C6CFEF0EAFEBE9EFEA478FED3BEFEE0D2FE7734FE7A38FEC7ACFED8C6FEDCCCFEF3EEFEE2D4FE7430FECCB4FED2BCFEC4A8FEF4F0FE9E6EFEB692FEE4D8FEEBE2FEAE86FE6012FE5F10FE6C24FE5E0EFE';
wwv_flow_api.g_varchar2_table(3) := '732EFEBB9AFEEAE0FEE8DEFEF2ECFECAB0FEBC9CFEB896FE9662FEB38EFEB794FE8346FE874CFE8A50FE8244FE864AFEB490FEDECEFE8448FE8042FEDFD0FED6C2FE884EFEBA98FE661AFE6F28FE7632FE6316FE6214FECFB8FE905AFE8C54FEC2A4FEA0';
wwv_flow_api.g_varchar2_table(4) := '72FE8F58FE935EFE9764FE925CFE8E56FE6B22FE6A20FE681EFE702AFEDBCAFED7C4FE9A68FECEB6FE9866FE722CFEC6AAFE6418FE9460FE671CFEA274FEA376FECBB2FE6E26FEAC84FE7E3EFEB28CFE5C0C00000000000000000000000000000021FF0B';
wwv_flow_api.g_varchar2_table(5) := '4E45545343415045322E30030100000021FE1A43726561746564207769746820616A61786C6F61642E696E666F0021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B39363493820F17218305353A3B';
wwv_flow_api.g_varchar2_table(6) := '12990A101822168214223B3D359E900B111918190E00141AAD3F820B3740028E02121A1929183200363C3E28004228D12E8F131B1A2A30A300041C8213D12814901C231A223386422F283892242B31C1861D988F0A141D058DFA8B02060C1224941097A8';
wwv_flow_api.g_varchar2_table(7) := '0090010408221A70A041050F2658282201AE5B220208186844D04211B46816111548E0C0C28713201415C0412088C2440A14A4CCD4CF450744145E3A2AC001C58B698548AC0312E95BB4098240CCC4014EE72202D15E60123AE0E64714401D3DF0494210';
wwv_flow_api.g_varchar2_table(8) := '54144401F80A22EF110505836E440B028BA620A62810BABA2D246082DCB978F3EADDCB7752200021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E870F138F8E172A585B938B0A1156595C0599830B312D831D4C9D';
wwv_flow_api.g_varchar2_table(9) := '510AA100200D494A338214A85A512082A08F24464A4C50B20A54565A5DA00B3740BA8C05474B4D514C530055573C5E004228DB2E8F0B264B501A088252A50013DB281493401E4B4A1786422F2838A1423132CB841D3493203AAC6AC42F510B224590AC18';
wwv_flow_api.g_varchar2_table(10) := '88A800900104D825A2E020A10D2752149150C74111882116425AB8A148DBB68E8A80243020E3890045057010082271918082AC1ABAE8808842CD470582A078D1AD10897A40323D5027A9152E0038D4FD64C461DB8B7F4707F03489A2A8A3A32F480822B0';
wwv_flow_api.g_varchar2_table(11) := '2D290064415E4E1238E8C6B620831570864A874248CE860BBCDEDDCBB7AFDFBF800705020021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E86244E3F148F8D123C650C958B1D4B3C664A209B8342322883344D3C';
wwv_flow_api.g_varchar2_table(12) := '674C0AA3002008606343821D54AB50A2001D952E5F61646017B064AB5C050A123340058E054462635D5D2C003F3E681F0036622D282E8F240C625C1148000221218255532828948F1308D23186402F2838A32E2753CE0C75A0B109C42E4601179190B162';
wwv_flow_api.g_varchar2_table(13) := 'C59483870A001940405E2216432EAC98C141110978283A2A7A72A2E4097E898480149988C200142F9A292A808340108B335F3D73D1EB10059CCF82C00C5788843E209B16809C20C8A0201C20812E120A93A0D101BD54C223EAC8C58017240411808714C0';
wwv_flow_api.g_varchar2_table(14) := '821B4104143C7883ECA0843A13014C8027246EC4055CEDEADDCBB7AFDFBD81000021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8624550E148F8D08583E47958B0A63586E5D209B8305374183146458684A0AA3';
wwv_flow_api.g_varchar2_table(15) := '822B5F105B821D5CAB11A2000F1D8F05365F1B1B6C002046AB46050A0D6E11388F171E5F6B6D2D000E19186F00485A3D70538F2E3F1E10620E00052D69826D3D654734950B44E52786475844CF9B142169050C090022AF5201018E023202F182C5141408';
wwv_flow_api.g_varchar2_table(16) := '131500328000254538D68550B34011091420392C9A0012A40B45424A8A542400C78D1B131615C04120C84599AF12BAE87588C24D5F4150BC385988C40B1440367D0419B358441C257F322229549ED11BBD529AAC4461C000128208804C0A6081A9888F04';
wwv_flow_api.g_varchar2_table(17) := 'A0BD3196544E42541085BC3D546001D1B978F3EADDCB576F200021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E864216431D8F8D48512245958B0A6B511971209B84200A831D621A1960A6A3000F444E6A829D1A';
wwv_flow_api.g_varchar2_table(18) := '2A63A2000B2E950908070D090020101A1823000A12294A1C8F4F360C0D1E280033505143005572593A3F8F1D174E391E2B0005524F8223DE3A17952EE3392C8636703B61149B1D282F87200CBC11E2AA510183136EDCC0B1A800900104F6297281A2220A';
wwv_flow_api.g_varchar2_table(19) := '1A8A48587436D1E24545423636C4A170C248024124362C68D005A54314543E2A10C41FAF42245EA000B249634593C30408C2615126A309155F60CC798352C88A371D292030808420021579EABA014468A5020705DDC83A282C4B004851103C5BA80089A8';
wwv_flow_api.g_varchar2_table(20) := '6C08E3CA9D4BB7EEA8400021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E862E2B6C0A8F8D25115433958B2026114D23029B891D739F622082202F0F954F6C28820A7411506BA20B5F6E51528E135E3F48690002';
wwv_flow_api.g_varchar2_table(21) := '0D114974000A5F6567724EBE2B16454E04007560116C003F76CE56758E20536F0E365B00052FB1024666727046148F146A6F25BD8547F046249B2041821CA2F0C68290518D405028D08804010213161568D18240874514506844414311898D1C306EE4A8';
wwv_flow_api.g_varchar2_table(22) := '480848460F6EDC88A8A8000E02402E326288B0510117320D5198B7A94010142F5C1822B10EC8A68F1A5982100500C7469E8E1E687CD191E88D8B26350A7D0482C0007F000868340A60C10D204C2BD1047063ECA0B53514014CD07830AEA10224B6DADDCB';
wwv_flow_api.g_varchar2_table(23) := 'B7AFDFBF7D03010021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E860503038F8E6C236D32948B200C6D6307059A890A779E5F2082203243148F24280FA99D5C740200241E296E478E0A6A31179302476D5C1200';
wwv_flow_api.g_varchar2_table(24) := '0A1530687663B68C1D21AB333800322346990E29CC3C3F8F1C2C062B210005379305236E76651BAD8E20042C5B1C864557656B249A05240B87285CF8E04254231038F831224180C0844513C0D8C960609182172832D25084E4CC151F6D508DC2A8511101';
wwv_flow_api.g_varchar2_table(25) := '360958DC60B4E0C68D878A0AE020004481C19B880AB8E88088023C4A0582A07851B010098C4034BDCA0813C4331C1951FC6CF420E38B8D476FF01412B5683C02371412C89814404B20CF800EBA417650289C821126641402171209AF75F3EADDCBB7AFA8';
wwv_flow_api.g_varchar2_table(26) := '400021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8720028F8E41453F40938C1F155F1F998A023F15100C920002096C1D8F054234820244A3079242775119488F414F213800050E153547052039782A2962A68B';
wwv_flow_api.g_varchar2_table(27) := '022F282D5324002177742D0033B829580E8F402852213782139805741929305FAB8E201CE20B8644293E104299ADAF861D752B5C7C6A0462823E4642081098B0684218371A642C02010D058A7E88F2E8D8984481228A162F2A3AD2A36413108B16DCB8C1';
wwv_flow_api.g_varchar2_table(28) := '50D1030F54A8841808AA59A3022EDE19A240E1538120285E082C44021AA6492442B68C240847C89E8F1E587CF1AAE88D5542420E8547E0063500042C1E5509A480CF4137C40E324B73D0048B070FDB162A4062ABDCBB78F3EADD8B37100021F904090500';
wwv_flow_api.g_varchar2_table(29) := '00002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90870A69210A918B53480C32978905439A3F0582022C321D901D9600021748393602002E47114D258F132F03420005754877B8204E54504C10B28C053728282F14002F3F082F';
wwv_flow_api.g_varchar2_table(30) := '00435D4D4C1A338F40CE280F8224E20512DA7815A88E201CCF2E865E4C781EF090052ED1861D5B75349D8C404CE8C54808010213163D688381099B45020680FB97C8861C2B569480501471A2221B59426A5C64F04642450FC48858F210E0A102149439C2';
wwv_flow_api.g_varchar2_table(31) := 'B7CE10057DF782BC3344E2050A209148803B0942190E70381B3D70F6E25FCF1BA88480B3C78EC00D12820838030A60C10D1CA3228505D0ECE7A0B12E273823E8B2500112540ADBCA9D4BB7AEDDB981000021F90409050000002C00000000200020000007';
wwv_flow_api.g_varchar2_table(32) := 'FF800082838485868788898A8B8C8D8E8F9088240B918C1C433337958A2C170E4383022F6A0A90202082059D251F050034446D631F8F242F03428269174417000225465C5D0DAE8D1C28282F14004075161C0006B25D4BBE8E38C9280F823424824E635D';
wwv_flow_api.g_varchar2_table(33) := '5439A58E20C82F34861764E4EB90052ECC860A275BF09B8A020F4142C689841020306111901A1A5424F992CF908001DA1A1ABA63A7228F2B32121580984C62210466429AB16340910B02370A2A7AB0210A13264E04E83354A083CD47F23A2062314467BC';
wwv_flow_api.g_varchar2_table(34) := '20CA5C182291E04B1BA1B5B4A90421134036290E50407A904C1D005B37740AD196EB110894DF0010480644D0821B3800E21C7483EC20B5FA132624EB3AB350011248EBEADDCBB7AF5FBE81000021F90409050000002C00000000200020000007FF800082';
wwv_flow_api.g_varchar2_table(35) := '838485868788898A8B8C8D8E8F90882002918C424F2C24958A0469322C83051C409120058337690632821D6F1E262D8F422F3742829D5B5300052B26106B0E8F1C28282F1400422D0613006A15C0625B8F38C5280F820A34820E5F6B46480A8F20C42FDB';
wwv_flow_api.g_varchar2_table(36) := '855B1B7136E78F052EC886202C27F19B8A020B4040F6884204049A29E230874A12266250241230C05ABB433952A4C04211C22944041C2ABAE3A66347088A5C10B82130110E084A94509943E09EA1021D625E64F4AEC321104386D8845420883117861C68';
wwv_flow_api.g_varchar2_table(37) := 'D13206E82312D6044E1294068A1E1D31203D28660E00895A368518C0A387082410233501C88882148005322A947487AA98595E2E14074D28762B6EA102248CDADDCBB7AFDFBF9B02010021F90409050000002C00000000200020000007FF800082838485';
wwv_flow_api.g_varchar2_table(38) := '868788898A8B8C8D8E8F908805918D1437040A948A1C28281C8420939005A200049D2F820A094417998E3437374282A75203000532473907288F41A814004203282E0052360C0D0D9F8E389D280B8220AF75CC265EA58C209C2FC3856A07740E1D91052E';
wwv_flow_api.g_varchar2_table(39) := 'E185204F21E79A8B02243838EB882E0404138B40076364BA40C095E854271A8A8E3089C2508307450651204C942783458B0F13512070839FA2091EC8800153E1593C42053A7478D5281DBC420262C478E9A840B017C80A31B022C7484E4724A479042140';
wwv_flow_api.g_varchar2_table(40) := '50981D5AACB081F4001542122F6E9C43A203A90348203892A8D5090800050DDC88F1386AD08DAE831E143D096042275A6C0E0B1520F133AEDDBB78F3EAA514080021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E';
wwv_flow_api.g_varchar2_table(41) := '8F909192840A40400293894028280F9983050583049C1C8205035304901D37374282A42841824F330E0E348F389C2F1D004203031400412B0E45552E8F139C280B820220822C1645477590201C282FC485525579170A91052EDF85023703E59F8905420F';
wwv_flow_api.g_varchar2_table(42) := '0FBF8A140404138B1379356D620D562592854257A21F64BA74891021872282061115694291E21D7B046EE853F4E08E988F3968BDA3A4C05DA373F5D46DD992D2518120DD9615CAC3E3CA86888D4838DB080213002356CED83100E9412F5D245EDCF855C4';
wwv_flow_api.g_varchar2_table(43) := '4A502FDA329288C50908000512B07031656ED08DAA83164C7BD70C05AC91840A909089B6ADDBB77004E3360A040021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840A40380293893828280F99830505';
wwv_flow_api.g_varchar2_table(44) := '83049C1C83241C14901D37374282A4284182402C062190139C2F1D00420303AA242132756C988E0F9C280B820220821CC533B88F021C282FAA8538751F09D090052EDB863841E19F8805342424C889140404138B0B44071E2648408AB12834147DD8B0A6';
wwv_flow_api.g_varchar2_table(45) := '8D4124FE96054CE460CC98300E6D289277A39E221247BE7C99630387BA420A14A46334AE97210A6F2E987C5420483617868EB8C132E7D52312CB2C820828800B0F343EE82878A42C5B40122FBEB0018084078F2B584E3C0241E0060958283C9029A0E04B';
wwv_flow_api.g_varchar2_table(46) := '99A75E22891274030591AD006878C0A264C0275D17148880E270F55301120B467EDCCBB7AFDFBF9002010021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928402130B0593893828280B99839883049C1C';
wwv_flow_api.g_varchar2_table(47) := '83142E911D04374282A3284182132F283890139C2F1D0042030314BC9C2D2F900B9C9D820220B2282D6A4090051C282FC085422D5328A18F052ED68642979F8BA71DDC88140404138B422B454E361FAD89AF28348A31070D15151E5B14DDCB97E8C29783';
wwv_flow_api.g_varchar2_table(48) := '0763285277A39D22214424DCB9E30015394220327673B1CB908B156C3A760B42CD22211B19343430D988C431874F4A29E08245059E0322193DC8950F880A3401ABF8C082018F974720569110F442C58E31054078188A61848068835AF8D841069310083E';
wwv_flow_api.g_varchar2_table(49) := '52FCF8F4E28A8E22A6D884FC44E148959C1708E3CA9D4BB72EA4400021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A3828280B9888049B1C831D1D910A1C044282A0284182132F2F978F';
wwv_flow_api.g_varchar2_table(50) := '0F9B2FA54203031400429BAD900BBF9D000220AFBFAA8F051C282FBC85BE283892052ED08614349E8C0A14C78B140404138B1D532B1F2B528BAC28DB892C554548483FF09FBFF887530CFE0C365C281277A3DCC037486C1061C7AD9000050296B9286588';
wwv_flow_api.g_varchar2_table(51) := '460C190A221508E24C60A11F4D2220D8C788C4AF72025AB802214603142A792836AAE56C5B0E39580C0070204243122A2B1E812070E31205153AE01829004242CF24260A40920A80048CA461A4BAF020228A054F6D92FE1844C100464F138EFC90D9B0AD';
wwv_flow_api.g_varchar2_table(52) := 'DBB77004E3460A040021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052424938A1328280B9888049B1C832020910A1C044282A02841820F2F0334900F9B2F1D0042033714B99B2838900BBF9D0002';
wwv_flow_api.g_varchar2_table(53) := '02829A9BAA8F051C282FBD85429BC191052ED28614B39E8B0220058C14040413DF2F6A092CCC89AC28DD883775431717278BEFF1875216FE16061651E070E39CA20E0666BC8971C95B2101E29AB9C06588860C35A520150802CD85212F63DA54D1D688C4';
wwv_flow_api.g_varchar2_table(54) := 'AF73029E000100E24B042E71AA2878540BDA2C043C44E0FB4025029838311E812070E312053C56CA6C2800228F129F39223A8A280443D236E268DCA1D2E58DA71156789418D421CD94999826D87080D6A1DBB77005E3CA9514080021F90409050000002C';
wwv_flow_api.g_varchar2_table(55) := '00000000200020000007FF800082838485868788898A8B8C8D8E8F90919284052442938A0F28280B9888049B1C832005910A1C049700A02841820F2F371D909A282FB34203371400429B280F900BBF9D0002028213BFAA8E051CB6BC85422F283892052E';
wwv_flow_api.g_varchar2_table(56) := 'D1861D349E8C05A58C140404138B0540030340C88AAC28DD890F4F2D6969D6EEBFF1884132FE32AE1451E070C39C22102D4E9C9002C29B217090B0CDDAC6E249C3884150480961E802040F1F263A72B1E9C81C632150183BD0A6069D0F171B697A83C50B';
wwv_flow_api.g_varchar2_table(57) := '00273EF0180030244E9B1173123C02F1420C03011492D88161C25895303F7F4012500C07163B3EDA20A3E0C4489B189816A8C0AA5590828D3123515062C7CD1D8785102EE0A192066EA10724ECEADDCB9750200021F90409050000002C00000000200020';
wwv_flow_api.g_varchar2_table(58) := '000007FF800082838485868788898A8B8C8D8E8F9091928405242E938A0F2828249888049B1C830205910A1C044282A02841820F030420909A282F1D0042033714B99B280B900BBFC100A48213BFAA8F051CB6BD85422F283892052ED0861D349E8CA58D';
wwv_flow_api.g_varchar2_table(59) := '140404138B0540BBD58BAC28DC89C3BFD99FBFED88EF9BF187141C37E48A05412F06A4EB46F05A10018640A0B8811052B322587E1892C1C0C6160590842030B30382B1342F8C39A970E7089B868D6658E901670680221994240060600EC93C2D1EA5C9E0';
wwv_flow_api.g_varchar2_table(60) := '268F800E4B52E0B963CCCB1C0F12D84022F14010092629447C29D5C182893B52303D8D5AE39B801BAE30B9689222830982853C447D8396D082126F0830B69D4BB7AEA0400021F90409050000002C00000000200020000007FF800082838485868788898A';
wwv_flow_api.g_varchar2_table(61) := '8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820F031C02909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BAC48BAB28DC89C2';
wwv_flow_api.g_varchar2_table(62) := '9BB6EABEED8842BEF18A141C37E48A0538043800EB4610480919B20A090882E39BA309497AC829612884831569123AAAB243079C3900043CB92168868D121F5A4032A1234B991500883419C302801A0436887C78F0A88586144E047418136589130005EA';
wwv_flow_api.g_varchar2_table(63) := 'E0240204929074429644A1728014882D3F0C80C014358A920ADF6E79A241C6EB1D8285EE78AD839610890F7508B6B69D4BB7AEA0400021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F';
wwv_flow_api.g_varchar2_table(64) := '2828249888049B1C8305920A1C044282A02841820B374102909A282F1D0042033714B89B28A98F0BBE0B8202A40013BEBC8F051CB5CB84422F283892052ED0851D349E8CC78C140404138B0540BA9D8BAB28DC89C29B03B28AEBED8842BEF18B141C37E4';
wwv_flow_api.g_varchar2_table(65) := '8A05380870A8D7AD1B0E0727E415227129D20425597858307443068B20DF1A1D8123A74C0500055EB4027062C59629231D799063C6CD10005EB8D47802408A85156CD48078F4040A9E220214ACE962A404C8295E569CD8F9480831002EC2748973849480';
wwv_flow_api.g_varchar2_table(66) := '1709AA617211A74B983C19BBD110E3D546C14247BC1A381BED8201A66C06E3CA9D0B20100021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A0';
wwv_flow_api.g_varchar2_table(67) := '2841820B3740A48F9A282F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28C140404138B0540BAA98BAB28DB8924BE37DE88036A09319D8942EFF1872D614D26B71215C0412008BB451D84ECE34608';
wwv_flow_api.g_varchar2_table(68) := '079121200EB9B814294817336E1C18A215EB11893065AEF89000A000016A0050849082E2C1230721DDA85801E0420D0903000439B192C0230976DCA4C823408189352668A6E429CA919408518ADCA251630D1D8D2581005100C9C538413420AC99438421';
wwv_flow_api.g_varchar2_table(69) := '210A73D67CB160969003B56A0DDA0EA220838500B978F3E60D040021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C8305920A1C044282A02841820B3740A48F9A28';
wwv_flow_api.g_varchar2_table(70) := '2F1D0042033714B89B28BC8F0BBE0B8202B213BEC08E051CB5CA83422F283892052ECF841D349E8CB28CB937138B0540BA978A42604A3512378A24BE048B24293D3D3B1FE8F18C174C2935D80A15C0412048C0431D5C78E36668828518200EB9380709C8';
wwv_flow_api.g_varchar2_table(71) := '181F2AF215828722D623216D7CA410910700396200800C7BE404C6482875006C9150A5154714A21A81E0922243140705403068E0E484A009D21E3C629041839388142434C8135310058A8D28C838A1C0EA9D060886302404220FD82D63091938E024675A';
wwv_flow_api.g_varchar2_table(72) := '931C07A8BD9D4B976E200021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202';
wwv_flow_api.g_varchar2_table(73) := 'B10013BDBF8E051CB4CA83422F283892052ECF841D349142A88DC68C2B18306B9D890540B9DB8A42183BEF6F8A24BD048B241959597033ECBDA28B439A889883AD50011C0482143CA4C005B851861ECC3000E21085858B70B41101E5822112D2603D1202';
wwv_flow_api.g_varchar2_table(74) := '010F132A555A5D020044D8A32A269570310040CD8F21C384F402E208441B264DBACC28208048911952043D78F1C25B23274D2210A948C346910F2C06755000A9C314355C01742852C48B1A8884047C286201055A42380D2E2458F756D0C3BA78F3D60D04';
wwv_flow_api.g_varchar2_table(75) := '0021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A028418224044005909A282F1D0042033714B79B28BB8F0BBD0B8202B10013BDBF8E051CB4CA';
wwv_flow_api.g_varchar2_table(76) := '83422F283892052ECF841D34912EA88DC68C432218239D8905400304D8864278567070178A24BDA28A42516666656FF8F68C627449E2811D251C04821834A48006B85186165C4820E01085858A26CC51C2858D2112D280407251810A99385E04D1502008';
wwv_flow_api.g_varchar2_table(77) := '482F6F8D1C2C211366841A005262A4D925A4D7044720E6D05C13A380802143D45003F0E0C5008C86888469F3A662871943A6DC2305025287102D8C81B83024C1568882580C39310CED2005370A7EBA9D4BB7AE5D4381000021F90409050000002C000000';
wwv_flow_api.g_varchar2_table(78) := '00200020000007FF800082838485868788898A8B8C8D8E8F9091928405422E938A0F2828249888049B1C9E000A41044282A02841822404400590322D282F1D0042033714B89B28BC8F3910B40B8202B10013BEC08E40505F4FCC83422F283892380EC587';
wwv_flow_api.g_varchar2_table(79) := '1D348F052E2442028DC88A245F1A19221BA88905400304B7895E76763C3C650EE7BEA28933DC0814E84591105FAC1291A0D304CA920697DEE178A56051251211472122C12604394314A4395A70204E8D048648540302890682381BE8D411A400842020BE';
wwv_flow_api.g_varchar2_table(80) := 'DC357A6364C31C094F00047932E0D6C14DDB180990B0E14B8513000AB0A0C512C00379151DCD70CA869C0035B4FE01380649819417C80AA4A1AAB11090272F0D44B6A590B5ADDDBB78F32A0A040021F90409050000002C00000000200020000007FF8000';
wwv_flow_api.g_varchar2_table(81) := '82838485868788898A8B8C8D8E8F9091928405422E938A0F28282498831D0583049B1C9E00694D3F4282A3284182240440A18F733D29061D0042033714BB9B28BF8F123B3D460F8202B413C1C38E38493B654F86422F283892383F6CB4851D348F053496';
wwv_flow_api.g_varchar2_table(82) := '028DDF892C1B4D4C495F9D8905400304BA88204658FB3030488A2482BDC2B7218341830E1409090644518B0D64C88C61100F51011CB2402C022144883853895C2478926E1085678F48389973A7852112D81A3EA25085CE813C090481D0080047B08F8DD8';
wwv_flow_api.g_varchar2_table(83) := '983880E0C70D003007E85AB869C123220718207109A095CC05F578365293A7889A50056E6C1A08A0404946139289DAA40D24215E040D14B82D6476AEDDBB78F31E0A040021F90409050000002C00000000200020000007FF800082838485868788898A8B';
wwv_flow_api.g_varchar2_table(84) := '8C8D8E8F9091928405422E938A0F2828249883144283049B1C9E002D4D294582A328418224044005901E593A56060042033714BB9B28BF8F0C705A3B128202B40013C1C38E385470671786422F28389213255BCC851D348F05344234E08AE9886973644B';
wwv_flow_api.g_varchar2_table(85) := '111EA189054003041D89203551511A1A7888282211EC152201749A2854384391906040144931D1A6CD081BF31015C0210BC422102E5C40337588469A1BEB045118E9C885853C3F6E1822912DE223106F8E54F9804210088F0070041BE70885932A5E623C';
wwv_flow_api.g_varchar2_table(86) := '00407340BE879B3A15AD62E1C200569B6C2EB807B49182136C640228706393C1B129190920C461D30292850E2870E0D015AEDDBB78F3EA5D14080021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F9091928405';
wwv_flow_api.g_varchar2_table(87) := '422E938A0F2828249883344283049B1C9E002D50195582A3284182240440059007665665320042033714BB9B28BF8F473C6756398202B40013C1C38E13643C767586422F283892135E32CC851D348F05142E34E08AE988520762617139E389054003040A';
wwv_flow_api.g_varchar2_table(88) := '8902155D5D114B4B2E2822110C88BE3B6312261CA24848414503189830D1C0C13C440570C802B14800051A1D4C29EAF0C2E0210AD01E5188E185CD034324B2997C74E2439D29DB0080E00800C7B3472456D439F1645CCC01211D6EBAE4C8051B19695E02';
wwv_flow_api.g_varchar2_table(89) := '686572C18D200220D9EB04A0C08D4DAF04AD9B1464D30291851404993016ADDBB77005E3CA4514080021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840F172E93840B13845F4D522498005349782582';
wwv_flow_api.g_varchar2_table(90) := '142A4A521CA1156E576E4400141964284182240440058F4E306E766806004E6D3714004228CCC98E0F6130683C158213BD0013CC28CE8E37D13E1686422F2838920F1F1702871D3490EE14D88BF3892F477310104EEF890540030828482420CF9A366DC4';
wwv_flow_api.g_varchar2_table(91) := '1861A388C43620FE907C99389158A265CC2026E2500501022717BA1D2A8063178845023A5018184A91021C42105110E9084488044F2E1522514EE3A317539EA0D80400C4490038B6D1741942E88B773C077450B64D67A3020350BC0005804046410B6EE0';
wwv_flow_api.g_varchar2_table(92) := 'A8C748C102AB3798E11244761210660B0F5A1A1230E19ADCBB78F3EADD8B29100021F90409050000002C00000000200020000007FF800082838485868788898A8B8C8D8E8F909192840B45330A938242172184743B3A479902071822168214783B3D2699';
wwv_flow_api.g_varchar2_table(93) := '345C19292A0E00141AAC4482240440058F0C1A1958183200363C5828004228CE148F131B1A2A301282040F8213CE28D08F1C231A223386422F283892242B3102871D34900A141DBF8CF78A421639121225DF101500328000A644431A54F0E0C144024524';
wwv_flow_api.g_varchar2_table(94) := 'BA0151148381458B2CF44954E4828D03071F4E74505400472F108C1428409969910017230F5108F8A80007142F5C1822816E22246ECE260802C11247379A8C08387B218FE78091CD9E410282930436673E17DC5007A9808B83006E380B32285F4BA328AC';
wwv_flow_api.g_varchar2_table(95) := 'B63424E081DAB57007E3CA9D4B576E20003B000000000000000000';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16883548517607135 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't5loading.gif'
 ,p_mime_type => 'image/gif'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D49484452000000280000002804030000007ED0A55E00000012504C5445FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF47D7349F0000000574524E53EF801000CF924B9CD50000003E49444154785EEDD3210100201043D121';
wwv_flow_api.g_varchar2_table(2) := 'F0181240828B400210EB5F05CF1600715F3EBD211A9FCAC0A4B4D0150FAAE2064D9F6062A21DAD9DB73D82BDCC05FAB0061ABD2A80320000000049454E44AE426082';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 16884245929608351 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 't5loading_background.png'
 ,p_mime_type => 'image/png'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

 
begin
 
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2A210A09436F6C6F72626F782076312E352E35202D20323031342D30332D31330A096A5175657279206C69676874626F7820616E64206D6F64616C2077696E646F7720706C7567696E0A092863292032303134204A61636B204D6F6F7265202D206874';
wwv_flow_api.g_varchar2_table(2) := '74703A2F2F7777772E6A61636B6C6D6F6F72652E636F6D2F636F6C6F72626F780A096C6963656E73653A20687474703A2F2F7777772E6F70656E736F757263652E6F72672F6C6963656E7365732F6D69742D6C6963656E73652E7068700A2A2F0A286675';
wwv_flow_api.g_varchar2_table(3) := '6E6374696F6E28742C652C69297B66756E6374696F6E206E28692C6E2C6F297B76617220723D652E637265617465456C656D656E742869293B72657475726E206E262628722E69643D5A2B6E292C6F262628722E7374796C652E637373546578743D6F29';
wwv_flow_api.g_varchar2_table(4) := '2C742872297D66756E6374696F6E206F28297B72657475726E20692E696E6E65724865696768743F692E696E6E65724865696768743A742869292E68656967687428297D66756E6374696F6E207228652C69297B69213D3D4F626A656374286929262628';
wwv_flow_api.g_varchar2_table(5) := '693D7B7D292C746869732E63616368653D7B7D2C746869732E656C3D652C746869732E76616C75653D66756E6374696F6E2865297B766172206E3B72657475726E20766F696420303D3D3D746869732E63616368655B655D2626286E3D7428746869732E';
wwv_flow_api.g_varchar2_table(6) := '656C292E617474722822646174612D63626F782D222B65292C766F69642030213D3D6E3F746869732E63616368655B655D3D6E3A766F69642030213D3D695B655D3F746869732E63616368655B655D3D695B655D3A766F69642030213D3D585B655D2626';
wwv_flow_api.g_varchar2_table(7) := '28746869732E63616368655B655D3D585B655D29292C746869732E63616368655B655D7D2C746869732E6765743D66756E6374696F6E2865297B76617220693D746869732E76616C75652865293B72657475726E20742E697346756E6374696F6E286929';
wwv_flow_api.g_varchar2_table(8) := '3F692E63616C6C28746869732E656C2C74686973293A697D7D66756E6374696F6E20682874297B76617220653D452E6C656E6774682C693D287A2B742925653B72657475726E20303E693F652B693A697D66756E6374696F6E207328742C65297B726574';
wwv_flow_api.g_varchar2_table(9) := '75726E204D6174682E726F756E6428282F252F2E746573742874293F282278223D3D3D653F572E776964746828293A6F2829292F3130303A31292A7061727365496E7428742C313029297D66756E6374696F6E206128742C65297B72657475726E20742E';
wwv_flow_api.g_varchar2_table(10) := '676574282270686F746F22297C7C742E676574282270686F746F526567657822292E746573742865297D66756E6374696F6E206C28742C65297B72657475726E20742E6765742822726574696E6155726C22292626692E646576696365506978656C5261';
wwv_flow_api.g_varchar2_table(11) := '74696F3E313F652E7265706C61636528742E676574282270686F746F526567657822292C742E6765742822726574696E615375666669782229293A657D66756E6374696F6E20642874297B22636F6E7461696E7322696E20785B305D262621785B305D2E';
wwv_flow_api.g_varchar2_table(12) := '636F6E7461696E7328742E746172676574292626742E746172676574213D3D765B305D262628742E73746F7050726F7061676174696F6E28292C782E666F6375732829297D66756E6374696F6E20632874297B632E737472213D3D74262628782E616464';
wwv_flow_api.g_varchar2_table(13) := '2876292E72656D6F7665436C61737328632E737472292E616464436C6173732874292C632E7374723D74297D66756E6374696F6E206728297B7A3D302C72656C2626226E6F666F6C6C6F7722213D3D72656C3F28453D7428222E222B7465292E66696C74';
wwv_flow_api.g_varchar2_table(14) := '65722866756E6374696F6E28297B76617220653D742E6461746128746869732C59292C693D6E6577207228746869732C65293B72657475726E20692E676574282272656C22293D3D3D72656C7D292C7A3D452E696E646578285F2E656C292C2D313D3D3D';
wwv_flow_api.g_varchar2_table(15) := '7A262628453D452E616464285F2E656C292C7A3D452E6C656E6774682D3129293A453D74285F2E656C297D66756E6374696F6E20752869297B742865292E747269676765722869292C73652E7472696767657248616E646C65722869297D66756E637469';
wwv_flow_api.g_varchar2_table(16) := '6F6E20662869297B766172206F3B477C7C286F3D742869292E646174612822636F6C6F72626F7822292C5F3D6E6577207228692C6F292C72656C3D5F2E676574282272656C22292C6728292C247C7C28243D713D21302C63285F2E6765742822636C6173';
wwv_flow_api.g_varchar2_table(17) := '734E616D652229292C782E637373287B7669736962696C6974793A2268696464656E222C646973706C61793A22626C6F636B222C6F7061636974793A22227D292C4C3D6E2861652C224C6F61646564436F6E74656E74222C2277696474683A303B206865';
wwv_flow_api.g_varchar2_table(18) := '696768743A303B206F766572666C6F773A68696464656E3B207669736962696C6974793A68696464656E22292C622E637373287B77696474683A22222C6865696768743A22227D292E617070656E64284C292C443D542E68656967687428292B6B2E6865';
wwv_flow_api.g_varchar2_table(19) := '6967687428292B622E6F75746572486569676874282130292D622E68656967687428292C6A3D432E776964746828292B482E776964746828292B622E6F757465725769647468282130292D622E776964746828292C413D4C2E6F75746572486569676874';
wwv_flow_api.g_varchar2_table(20) := '282130292C4E3D4C2E6F757465725769647468282130292C5F2E773D73285F2E6765742822696E697469616C576964746822292C227822292C5F2E683D73285F2E6765742822696E697469616C48656967687422292C227922292C4C2E637373287B7769';
wwv_flow_api.g_varchar2_table(21) := '6474683A22222C6865696768743A5F2E687D292C4A2E706F736974696F6E28292C75286565292C5F2E67657428226F6E4F70656E22292C4F2E6164642852292E6869646528292C782E666F63757328292C5F2E676574282274726170466F637573222926';
wwv_flow_api.g_varchar2_table(22) := '26652E6164644576656E744C697374656E6572262628652E6164644576656E744C697374656E65722822666F637573222C642C2130292C73652E6F6E652872652C66756E6374696F6E28297B652E72656D6F76654576656E744C697374656E6572282266';
wwv_flow_api.g_varchar2_table(23) := '6F637573222C642C2130297D29292C5F2E676574282272657475726E466F6375732229262673652E6F6E652872652C66756E6374696F6E28297B74285F2E656C292E666F63757328297D29292C762E637373287B6F7061636974793A7061727365466C6F';
wwv_flow_api.g_varchar2_table(24) := '6174285F2E67657428226F7061636974792229297C7C22222C637572736F723A5F2E67657428226F7665726C6179436C6F736522293F22706F696E746572223A22222C7669736962696C6974793A2276697369626C65227D292E73686F7728292C5F2E67';
wwv_flow_api.g_varchar2_table(25) := '65742822636C6F7365427574746F6E22293F422E68746D6C285F2E6765742822636C6F73652229292E617070656E64546F2862293A422E617070656E64546F28223C6469762F3E22292C772829297D66756E6374696F6E207028297B21782626652E626F';
wwv_flow_api.g_varchar2_table(26) := '6479262628563D21312C573D742869292C783D6E286165292E61747472287B69643A592C22636C617373223A742E737570706F72742E6F7061636974793D3D3D21313F5A2B224945223A22222C726F6C653A226469616C6F67222C746162696E6465783A';
wwv_flow_api.g_varchar2_table(27) := '222D31227D292E6869646528292C763D6E2861652C224F7665726C617922292E6869646528292C4D3D74285B6E2861652C224C6F6164696E674F7665726C617922295B305D2C6E2861652C224C6F6164696E674772617068696322295B305D5D292C793D';
wwv_flow_api.g_varchar2_table(28) := '6E2861652C225772617070657222292C623D6E2861652C22436F6E74656E7422292E617070656E6428523D6E2861652C225469746C6522292C463D6E2861652C2243757272656E7422292C503D7428273C627574746F6E20747970653D22627574746F6E';
wwv_flow_api.g_varchar2_table(29) := '222F3E27292E61747472287B69643A5A2B2250726576696F7573227D292C4B3D7428273C627574746F6E20747970653D22627574746F6E222F3E27292E61747472287B69643A5A2B224E657874227D292C493D6E2822627574746F6E222C22536C696465';
wwv_flow_api.g_varchar2_table(30) := '73686F7722292C4D292C423D7428273C627574746F6E20747970653D22627574746F6E222F3E27292E61747472287B69643A5A2B22436C6F7365227D292C792E617070656E64286E286165292E617070656E64286E2861652C22546F704C65667422292C';
wwv_flow_api.g_varchar2_table(31) := '543D6E2861652C22546F7043656E74657222292C6E2861652C22546F7052696768742229292C6E2861652C21312C22636C6561723A6C65667422292E617070656E6428433D6E2861652C224D6964646C654C65667422292C622C483D6E2861652C224D69';
wwv_flow_api.g_varchar2_table(32) := '64646C6552696768742229292C6E2861652C21312C22636C6561723A6C65667422292E617070656E64286E2861652C22426F74746F6D4C65667422292C6B3D6E2861652C22426F74746F6D43656E74657222292C6E2861652C22426F74746F6D52696768';
wwv_flow_api.g_varchar2_table(33) := '74222929292E66696E6428226469762064697622292E637373287B22666C6F6174223A226C656674227D292C533D6E2861652C21312C22706F736974696F6E3A6162736F6C7574653B2077696474683A3939393970783B207669736962696C6974793A68';
wwv_flow_api.g_varchar2_table(34) := '696464656E3B20646973706C61793A6E6F6E653B206D61782D77696474683A6E6F6E653B22292C4F3D4B2E6164642850292E6164642846292E6164642849292C7428652E626F6479292E617070656E6428762C782E617070656E6428792C532929297D66';
wwv_flow_api.g_varchar2_table(35) := '756E6374696F6E206D28297B66756E6374696F6E20692874297B742E77686963683E317C7C742E73686966744B65797C7C742E616C744B65797C7C742E6D6574614B65797C7C742E6374726C4B65797C7C28742E70726576656E7444656661756C742829';
wwv_flow_api.g_varchar2_table(36) := '2C66287468697329297D72657475726E20783F28567C7C28563D21302C4B2E636C69636B2866756E6374696F6E28297B4A2E6E65787428297D292C502E636C69636B2866756E6374696F6E28297B4A2E7072657628297D292C422E636C69636B2866756E';
wwv_flow_api.g_varchar2_table(37) := '6374696F6E28297B4A2E636C6F736528297D292C762E636C69636B2866756E6374696F6E28297B5F2E67657428226F7665726C6179436C6F7365222926264A2E636C6F736528297D292C742865292E62696E6428226B6579646F776E2E222B5A2C66756E';
wwv_flow_api.g_varchar2_table(38) := '6374696F6E2874297B76617220653D742E6B6579436F64653B2426265F2E67657428226573634B65792229262632373D3D3D65262628742E70726576656E7444656661756C7428292C4A2E636C6F73652829292C2426265F2E67657428226172726F774B';
wwv_flow_api.g_varchar2_table(39) := '657922292626455B315D262621742E616C744B657926262833373D3D3D653F28742E70726576656E7444656661756C7428292C502E636C69636B2829293A33393D3D3D65262628742E70726576656E7444656661756C7428292C4B2E636C69636B282929';
wwv_flow_api.g_varchar2_table(40) := '297D292C742E697346756E6374696F6E28742E666E2E6F6E293F742865292E6F6E2822636C69636B2E222B5A2C222E222B74652C69293A7428222E222B7465292E6C6976652822636C69636B2E222B5A2C6929292C2130293A21317D66756E6374696F6E';
wwv_flow_api.g_varchar2_table(41) := '207728297B766172206F2C722C682C643D4A2E707265702C633D2B2B6C653B713D21302C553D21312C75286865292C75286965292C5F2E67657428226F6E4C6F616422292C5F2E683D5F2E676574282268656967687422293F73285F2E67657428226865';
wwv_flow_api.g_varchar2_table(42) := '6967687422292C227922292D412D443A5F2E6765742822696E6E65724865696768742229262673285F2E6765742822696E6E657248656967687422292C227922292C5F2E773D5F2E6765742822776964746822293F73285F2E6765742822776964746822';
wwv_flow_api.g_varchar2_table(43) := '292C227822292D4E2D6A3A5F2E6765742822696E6E657257696474682229262673285F2E6765742822696E6E6572576964746822292C227822292C5F2E6D773D5F2E772C5F2E6D683D5F2E682C5F2E67657428226D6178576964746822292626285F2E6D';
wwv_flow_api.g_varchar2_table(44) := '773D73285F2E67657428226D6178576964746822292C227822292D4E2D6A2C5F2E6D773D5F2E7726265F2E773C5F2E6D773F5F2E773A5F2E6D77292C5F2E67657428226D617848656967687422292626285F2E6D683D73285F2E67657428226D61784865';
wwv_flow_api.g_varchar2_table(45) := '6967687422292C227922292D412D442C5F2E6D683D5F2E6826265F2E683C5F2E6D683F5F2E683A5F2E6D68292C6F3D5F2E67657428226872656622292C513D73657454696D656F75742866756E6374696F6E28297B4D2E73686F7728297D2C313030292C';
wwv_flow_api.g_varchar2_table(46) := '5F2E6765742822696E6C696E6522293F28683D6E286165292E6869646528292E696E736572744265666F72652874286F295B305D292C73652E6F6E652868652C66756E6374696F6E28297B682E7265706C61636557697468284C2E6368696C6472656E28';
wwv_flow_api.g_varchar2_table(47) := '29297D292C642874286F2929293A5F2E6765742822696672616D6522293F6428222022293A5F2E676574282268746D6C22293F64285F2E676574282268746D6C2229293A61285F2C6F293F286F3D6C285F2C6F292C553D652E637265617465456C656D65';
wwv_flow_api.g_varchar2_table(48) := '6E742822696D6722292C742855292E616464436C617373285A2B2250686F746F22292E62696E6428226572726F72222C66756E6374696F6E28297B64286E2861652C224572726F7222292E68746D6C285F2E6765742822696D674572726F72222929297D';
wwv_flow_api.g_varchar2_table(49) := '292E6F6E6528226C6F6164222C66756E6374696F6E28297B76617220653B633D3D3D6C65262628742E65616368285B22616C74222C226C6F6E6764657363222C22617269612D6465736372696265646279225D2C66756E6374696F6E28652C69297B7661';
wwv_flow_api.g_varchar2_table(50) := '72206E3D74285F2E656C292E617474722869297C7C74285F2E656C292E617474722822646174612D222B69293B6E2626552E73657441747472696275746528692C6E297D292C5F2E6765742822726574696E61496D61676522292626692E646576696365';
wwv_flow_api.g_varchar2_table(51) := '506978656C526174696F3E31262628552E6865696768743D552E6865696768742F692E646576696365506978656C526174696F2C552E77696474683D552E77696474682F692E646576696365506978656C526174696F292C5F2E67657428227363616C65';
wwv_flow_api.g_varchar2_table(52) := '50686F746F732229262628723D66756E6374696F6E28297B552E6865696768742D3D552E6865696768742A652C552E77696474682D3D552E77696474682A657D2C5F2E6D772626552E77696474683E5F2E6D77262628653D28552E77696474682D5F2E6D';
wwv_flow_api.g_varchar2_table(53) := '77292F552E77696474682C722829292C5F2E6D682626552E6865696768743E5F2E6D68262628653D28552E6865696768742D5F2E6D68292F552E6865696768742C72282929292C5F2E68262628552E7374796C652E6D617267696E546F703D4D6174682E';
wwv_flow_api.g_varchar2_table(54) := '6D6178285F2E6D682D552E6865696768742C30292F322B22707822292C455B315D2626285F2E67657428226C6F6F7022297C7C455B7A2B315D29262628552E7374796C652E637572736F723D22706F696E746572222C552E6F6E636C69636B3D66756E63';
wwv_flow_api.g_varchar2_table(55) := '74696F6E28297B4A2E6E65787428297D292C552E7374796C652E77696474683D552E77696474682B227078222C552E7374796C652E6865696768743D552E6865696768742B227078222C73657454696D656F75742866756E6374696F6E28297B64285529';
wwv_flow_api.g_varchar2_table(56) := '7D2C3129297D292C73657454696D656F75742866756E6374696F6E28297B552E7372633D6F7D2C3129293A6F2626532E6C6F6164286F2C5F2E67657428226461746122292C66756E6374696F6E28652C69297B633D3D3D6C6526266428226572726F7222';
wwv_flow_api.g_varchar2_table(57) := '3D3D3D693F6E2861652C224572726F7222292E68746D6C285F2E67657428227868724572726F722229293A742874686973292E636F6E74656E74732829297D297D76617220762C782C792C622C542C432C482C6B2C452C572C4C2C532C4D2C522C462C49';
wwv_flow_api.g_varchar2_table(58) := '2C4B2C502C422C4F2C5F2C442C6A2C412C4E2C7A2C552C242C712C472C512C4A2C562C583D7B68746D6C3A21312C70686F746F3A21312C696672616D653A21312C696E6C696E653A21312C7472616E736974696F6E3A22656C6173746963222C73706565';
wwv_flow_api.g_varchar2_table(59) := '643A3330302C666164654F75743A3330302C77696474683A21312C696E697469616C57696474683A22363030222C696E6E657257696474683A21312C6D617857696474683A21312C6865696768743A21312C696E697469616C4865696768743A22343530';
wwv_flow_api.g_varchar2_table(60) := '222C696E6E65724865696768743A21312C6D61784865696768743A21312C7363616C6550686F746F733A21302C7363726F6C6C696E673A21302C6F7061636974793A2E392C7072656C6F6164696E673A21302C636C6173734E616D653A21312C6F766572';
wwv_flow_api.g_varchar2_table(61) := '6C6179436C6F73653A21302C6573634B65793A21302C6172726F774B65793A21302C746F703A21312C626F74746F6D3A21312C6C6566743A21312C72696768743A21312C66697865643A21312C646174613A766F696420302C636C6F7365427574746F6E';
wwv_flow_api.g_varchar2_table(62) := '3A21302C66617374496672616D653A21302C6F70656E3A21312C7265706F736974696F6E3A21302C6C6F6F703A21302C736C69646573686F773A21312C736C69646573686F774175746F3A21302C736C69646573686F7753706565643A323530302C736C';
wwv_flow_api.g_varchar2_table(63) := '69646573686F7753746172743A22737461727420736C69646573686F77222C736C69646573686F7753746F703A2273746F7020736C69646573686F77222C70686F746F52656765783A2F5C2E286769667C706E677C6A7028657C677C6567297C626D707C';
wwv_flow_api.g_varchar2_table(64) := '69636F7C776562707C6A78727C737667292828237C5C3F292E2A293F242F692C726574696E61496D6167653A21312C726574696E6155726C3A21312C726574696E615375666669783A224032782E2431222C63757272656E743A22696D616765207B6375';
wwv_flow_api.g_varchar2_table(65) := '7272656E747D206F66207B746F74616C7D222C70726576696F75733A2270726576696F7573222C6E6578743A226E657874222C636C6F73653A22636C6F7365222C7868724572726F723A225468697320636F6E74656E74206661696C656420746F206C6F';
wwv_flow_api.g_varchar2_table(66) := '61642E222C696D674572726F723A225468697320696D616765206661696C656420746F206C6F61642E222C72657475726E466F6375733A21302C74726170466F6375733A21302C6F6E4F70656E3A21312C6F6E4C6F61643A21312C6F6E436F6D706C6574';
wwv_flow_api.g_varchar2_table(67) := '653A21312C6F6E436C65616E75703A21312C6F6E436C6F7365643A21312C72656C3A66756E6374696F6E28297B72657475726E20746869732E72656C7D2C687265663A66756E6374696F6E28297B72657475726E20742874686973292E61747472282268';
wwv_flow_api.g_varchar2_table(68) := '72656622297D2C7469746C653A66756E6374696F6E28297B72657475726E20746869732E7469746C657D7D2C593D22636F6C6F72626F78222C5A3D2263626F78222C74653D5A2B22456C656D656E74222C65653D5A2B225F6F70656E222C69653D5A2B22';
wwv_flow_api.g_varchar2_table(69) := '5F6C6F6164222C6E653D5A2B225F636F6D706C657465222C6F653D5A2B225F636C65616E7570222C72653D5A2B225F636C6F736564222C68653D5A2B225F7075726765222C73653D7428223C612F3E22292C61653D22646976222C6C653D302C64653D7B';
wwv_flow_api.g_varchar2_table(70) := '7D2C63653D66756E6374696F6E28297B66756E6374696F6E207428297B636C65617254696D656F75742868297D66756E6374696F6E206528297B285F2E67657428226C6F6F7022297C7C455B7A2B315D292626287428292C683D73657454696D656F7574';
wwv_flow_api.g_varchar2_table(71) := '284A2E6E6578742C5F2E6765742822736C69646573686F775370656564222929297D66756E6374696F6E206928297B492E68746D6C285F2E6765742822736C69646573686F7753746F702229292E756E62696E642861292E6F6E6528612C6E292C73652E';
wwv_flow_api.g_varchar2_table(72) := '62696E64286E652C65292E62696E642869652C74292C782E72656D6F7665436C61737328732B226F666622292E616464436C61737328732B226F6E22297D66756E6374696F6E206E28297B7428292C73652E756E62696E64286E652C65292E756E62696E';
wwv_flow_api.g_varchar2_table(73) := '642869652C74292C492E68746D6C285F2E6765742822736C69646573686F7753746172742229292E756E62696E642861292E6F6E6528612C66756E6374696F6E28297B4A2E6E65787428292C6928297D292C782E72656D6F7665436C61737328732B226F';
wwv_flow_api.g_varchar2_table(74) := '6E22292E616464436C61737328732B226F666622297D66756E6374696F6E206F28297B723D21312C492E6869646528292C7428292C73652E756E62696E64286E652C65292E756E62696E642869652C74292C782E72656D6F7665436C61737328732B226F';
wwv_flow_api.g_varchar2_table(75) := '666620222B732B226F6E22297D76617220722C682C733D5A2B22536C69646573686F775F222C613D22636C69636B2E222B5A3B72657475726E2066756E6374696F6E28297B723F5F2E6765742822736C69646573686F7722297C7C2873652E756E62696E';
wwv_flow_api.g_varchar2_table(76) := '64286F652C6F292C6F2829293A5F2E6765742822736C69646573686F7722292626455B315D262628723D21302C73652E6F6E65286F652C6F292C5F2E6765742822736C69646573686F774175746F22293F6928293A6E28292C492E73686F772829297D7D';
wwv_flow_api.g_varchar2_table(77) := '28293B742E636F6C6F72626F787C7C28742870292C4A3D742E666E5B595D3D745B595D3D66756E6374696F6E28652C69297B766172206E2C6F3D746869733B696628653D657C7C7B7D2C742E697346756E6374696F6E286F29296F3D7428223C612F3E22';
wwv_flow_api.g_varchar2_table(78) := '292C652E6F70656E3D21303B656C736520696628216F5B305D2972657475726E206F3B72657475726E206F5B305D3F287028292C6D282926262869262628652E6F6E436F6D706C6574653D69292C6F2E656163682866756E6374696F6E28297B76617220';
wwv_flow_api.g_varchar2_table(79) := '693D742E6461746128746869732C59297C7C7B7D3B742E6461746128746869732C592C742E657874656E6428692C6529297D292E616464436C617373287465292C6E3D6E65772072286F5B305D2C65292C6E2E67657428226F70656E2229262666286F5B';
wwv_flow_api.g_varchar2_table(80) := '305D29292C6F293A6F7D2C4A2E706F736974696F6E3D66756E6374696F6E28652C69297B66756E6374696F6E206E28297B545B305D2E7374796C652E77696474683D6B5B305D2E7374796C652E77696474683D625B305D2E7374796C652E77696474683D';
wwv_flow_api.g_varchar2_table(81) := '7061727365496E7428785B305D2E7374796C652E77696474682C3130292D6A2B227078222C625B305D2E7374796C652E6865696768743D435B305D2E7374796C652E6865696768743D485B305D2E7374796C652E6865696768743D7061727365496E7428';
wwv_flow_api.g_varchar2_table(82) := '785B305D2E7374796C652E6865696768742C3130292D442B227078227D76617220722C682C612C6C3D302C643D302C633D782E6F666673657428293B696628572E756E62696E642822726573697A652E222B5A292C782E637373287B746F703A2D396534';
wwv_flow_api.g_varchar2_table(83) := '2C6C6566743A2D3965347D292C683D572E7363726F6C6C546F7028292C613D572E7363726F6C6C4C65667428292C5F2E6765742822666978656422293F28632E746F702D3D682C632E6C6566742D3D612C782E637373287B706F736974696F6E3A226669';
wwv_flow_api.g_varchar2_table(84) := '786564227D29293A286C3D682C643D612C782E637373287B706F736974696F6E3A226162736F6C757465227D29292C642B3D5F2E676574282272696768742229213D3D21313F4D6174682E6D617828572E776964746828292D5F2E772D4E2D6A2D73285F';
wwv_flow_api.g_varchar2_table(85) := '2E6765742822726967687422292C227822292C30293A5F2E67657428226C6566742229213D3D21313F73285F2E67657428226C65667422292C227822293A4D6174682E726F756E64284D6174682E6D617828572E776964746828292D5F2E772D4E2D6A2C';
wwv_flow_api.g_varchar2_table(86) := '30292F32292C6C2B3D5F2E6765742822626F74746F6D2229213D3D21313F4D6174682E6D6178286F28292D5F2E682D412D442D73285F2E6765742822626F74746F6D22292C227922292C30293A5F2E6765742822746F702229213D3D21313F73285F2E67';
wwv_flow_api.g_varchar2_table(87) := '65742822746F7022292C227922293A4D6174682E726F756E64284D6174682E6D6178286F28292D5F2E682D412D442C30292F32292C782E637373287B746F703A632E746F702C6C6566743A632E6C6566742C7669736962696C6974793A2276697369626C';
wwv_flow_api.g_varchar2_table(88) := '65227D292C795B305D2E7374796C652E77696474683D795B305D2E7374796C652E6865696768743D22393939397078222C723D7B77696474683A5F2E772B4E2B6A2C6865696768743A5F2E682B412B442C746F703A6C2C6C6566743A647D2C65297B7661';
wwv_flow_api.g_varchar2_table(89) := '7220673D303B742E6561636828722C66756E6374696F6E2874297B72657475726E20725B745D213D3D64655B745D3F28673D652C766F69642030293A766F696420307D292C653D677D64653D722C657C7C782E6373732872292C782E6465717565756528';
wwv_flow_api.g_varchar2_table(90) := '292E616E696D61746528722C7B6475726174696F6E3A657C7C302C636F6D706C6574653A66756E6374696F6E28297B6E28292C713D21312C795B305D2E7374796C652E77696474683D5F2E772B4E2B6A2B227078222C795B305D2E7374796C652E686569';
wwv_flow_api.g_varchar2_table(91) := '6768743D5F2E682B412B442B227078222C5F2E67657428227265706F736974696F6E2229262673657454696D656F75742866756E6374696F6E28297B572E62696E642822726573697A652E222B5A2C4A2E706F736974696F6E297D2C31292C6926266928';
wwv_flow_api.g_varchar2_table(92) := '297D2C737465703A6E7D297D2C4A2E726573697A653D66756E6374696F6E2874297B76617220653B24262628743D747C7C7B7D2C742E77696474682626285F2E773D7328742E77696474682C227822292D4E2D6A292C742E696E6E657257696474682626';
wwv_flow_api.g_varchar2_table(93) := '285F2E773D7328742E696E6E657257696474682C22782229292C4C2E637373287B77696474683A5F2E777D292C742E6865696768742626285F2E683D7328742E6865696768742C227922292D412D44292C742E696E6E65724865696768742626285F2E68';
wwv_flow_api.g_varchar2_table(94) := '3D7328742E696E6E65724865696768742C22792229292C742E696E6E65724865696768747C7C742E6865696768747C7C28653D4C2E7363726F6C6C546F7028292C4C2E637373287B6865696768743A226175746F227D292C5F2E683D4C2E686569676874';
wwv_flow_api.g_varchar2_table(95) := '2829292C4C2E637373287B6865696768743A5F2E687D292C6526264C2E7363726F6C6C546F702865292C4A2E706F736974696F6E28226E6F6E65223D3D3D5F2E67657428227472616E736974696F6E22293F303A5F2E6765742822737065656422292929';
wwv_flow_api.g_varchar2_table(96) := '7D2C4A2E707265703D66756E6374696F6E2869297B66756E6374696F6E206F28297B72657475726E205F2E773D5F2E777C7C4C2E776964746828292C5F2E773D5F2E6D7726265F2E6D773C5F2E773F5F2E6D773A5F2E772C5F2E777D66756E6374696F6E';
wwv_flow_api.g_varchar2_table(97) := '207328297B72657475726E205F2E683D5F2E687C7C4C2E68656967687428292C5F2E683D5F2E6D6826265F2E6D683C5F2E683F5F2E6D683A5F2E682C5F2E687D69662824297B76617220642C673D226E6F6E65223D3D3D5F2E67657428227472616E7369';
wwv_flow_api.g_varchar2_table(98) := '74696F6E22293F303A5F2E6765742822737065656422293B4C2E72656D6F766528292C4C3D6E2861652C224C6F61646564436F6E74656E7422292E617070656E642869292C4C2E6869646528292E617070656E64546F28532E73686F772829292E637373';
wwv_flow_api.g_varchar2_table(99) := '287B77696474683A6F28292C6F766572666C6F773A5F2E67657428227363726F6C6C696E6722293F226175746F223A2268696464656E227D292E637373287B6865696768743A7328297D292E70726570656E64546F2862292C532E6869646528292C7428';
wwv_flow_api.g_varchar2_table(100) := '55292E637373287B22666C6F6174223A226E6F6E65227D292C63285F2E6765742822636C6173734E616D652229292C643D66756E6374696F6E28297B66756E6374696F6E206928297B742E737570706F72742E6F7061636974793D3D3D21312626785B30';
wwv_flow_api.g_varchar2_table(101) := '5D2E7374796C652E72656D6F7665417474726962757465282266696C74657222297D766172206E2C6F2C733D452E6C656E6774683B242626286F3D66756E6374696F6E28297B636C65617254696D656F75742851292C4D2E6869646528292C75286E6529';
wwv_flow_api.g_varchar2_table(102) := '2C5F2E67657428226F6E436F6D706C65746522297D2C522E68746D6C285F2E67657428227469746C652229292E73686F7728292C4C2E73686F7728292C733E313F2822737472696E67223D3D747970656F66205F2E676574282263757272656E74222926';
wwv_flow_api.g_varchar2_table(103) := '26462E68746D6C285F2E676574282263757272656E7422292E7265706C61636528227B63757272656E747D222C7A2B31292E7265706C61636528227B746F74616C7D222C7329292E73686F7728292C4B5B5F2E67657428226C6F6F7022297C7C732D313E';
wwv_flow_api.g_varchar2_table(104) := '7A3F2273686F77223A2268696465225D28292E68746D6C285F2E67657428226E6578742229292C505B5F2E67657428226C6F6F7022297C7C7A3F2273686F77223A2268696465225D28292E68746D6C285F2E676574282270726576696F75732229292C63';
wwv_flow_api.g_varchar2_table(105) := '6528292C5F2E67657428227072656C6F6164696E6722292626742E65616368285B68282D31292C682831295D2C66756E6374696F6E28297B76617220692C6E3D455B746869735D2C6F3D6E65772072286E2C742E64617461286E2C5929292C683D6F2E67';
wwv_flow_api.g_varchar2_table(106) := '657428226872656622293B68262661286F2C6829262628683D6C286F2C68292C693D652E637265617465456C656D656E742822696D6722292C692E7372633D68297D29293A4F2E6869646528292C5F2E6765742822696672616D6522293F286E3D652E63';
wwv_flow_api.g_varchar2_table(107) := '7265617465456C656D656E742822696672616D6522292C226672616D65426F7264657222696E206E2626286E2E6672616D65426F726465723D30292C22616C6C6F775472616E73706172656E637922696E206E2626286E2E616C6C6F775472616E737061';
wwv_flow_api.g_varchar2_table(108) := '72656E63793D227472756522292C5F2E67657428227363726F6C6C696E6722297C7C286E2E7363726F6C6C696E673D226E6F22292C74286E292E61747472287B7372633A5F2E67657428226872656622292C6E616D653A286E65772044617465292E6765';
wwv_flow_api.g_varchar2_table(109) := '7454696D6528292C22636C617373223A5A2B22496672616D65222C616C6C6F7746756C6C53637265656E3A21307D292E6F6E6528226C6F6164222C6F292E617070656E64546F284C292C73652E6F6E652868652C66756E6374696F6E28297B6E2E737263';
wwv_flow_api.g_varchar2_table(110) := '3D222F2F61626F75743A626C616E6B227D292C5F2E676574282266617374496672616D652229262674286E292E7472696767657228226C6F61642229293A6F28292C2266616465223D3D3D5F2E67657428227472616E736974696F6E22293F782E666164';
wwv_flow_api.g_varchar2_table(111) := '65546F28672C312C69293A692829297D2C2266616465223D3D3D5F2E67657428227472616E736974696F6E22293F782E66616465546F28672C302C66756E6374696F6E28297B4A2E706F736974696F6E28302C64297D293A4A2E706F736974696F6E2867';
wwv_flow_api.g_varchar2_table(112) := '2C64297D7D2C4A2E6E6578743D66756E6374696F6E28297B21712626455B315D2626285F2E67657428226C6F6F7022297C7C455B7A2B315D292626287A3D682831292C6628455B7A5D29297D2C4A2E707265763D66756E6374696F6E28297B2171262645';
wwv_flow_api.g_varchar2_table(113) := '5B315D2626285F2E67657428226C6F6F7022297C7C7A292626287A3D68282D31292C6628455B7A5D29297D2C4A2E636C6F73653D66756E6374696F6E28297B2426262147262628473D21302C243D21312C75286F65292C5F2E67657428226F6E436C6561';
wwv_flow_api.g_varchar2_table(114) := '6E757022292C572E756E62696E6428222E222B5A292C762E66616465546F285F2E6765742822666164654F757422297C7C302C30292C782E73746F7028292E66616465546F285F2E6765742822666164654F757422297C7C302C302C66756E6374696F6E';
wwv_flow_api.g_varchar2_table(115) := '28297B782E6869646528292C762E6869646528292C75286865292C4C2E72656D6F766528292C73657454696D656F75742866756E6374696F6E28297B473D21312C75287265292C5F2E67657428226F6E436C6F73656422297D2C31297D29297D2C4A2E72';
wwv_flow_api.g_varchar2_table(116) := '656D6F76653D66756E6374696F6E28297B78262628782E73746F7028292C742E636F6C6F72626F782E636C6F736528292C782E73746F7028292E72656D6F766528292C762E72656D6F766528292C473D21312C783D6E756C6C2C7428222E222B7465292E';
wwv_flow_api.g_varchar2_table(117) := '72656D6F7665446174612859292E72656D6F7665436C617373287465292C742865292E756E62696E642822636C69636B2E222B5A29297D2C4A2E656C656D656E743D66756E6374696F6E28297B72657475726E2074285F2E656C297D2C4A2E7365747469';
wwv_flow_api.g_varchar2_table(118) := '6E67733D58297D29286A51756572792C646F63756D656E742C77696E646F77293B';
null;
 
end;
/

 
begin
 
wwv_flow_api.create_plugin_file (
  p_id => 17135325449581898 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_id => 34429813749614992801 + wwv_flow_api.g_id_offset
 ,p_file_name => 'jquery.colorbox-min.js'
 ,p_mime_type => 'application/javascript'
 ,p_file_content => wwv_flow_api.g_varchar2_table
  );
null;
 
end;
/

prompt  ...data loading
--
prompt  ...post import process
 
begin
 
wwv_flow_api.post_import_process(p_flow_id => wwv_flow.g_flow_id);
null;
 
end;
/

--application/end_environment
commit;
commit;
begin
execute immediate 'begin sys.dbms_session.set_nls( param => ''NLS_NUMERIC_CHARACTERS'', value => '''''''' || replace(wwv_flow_api.g_nls_numeric_chars,'''''''','''''''''''') || ''''''''); end;';
end;
/
set verify on
set feedback on
set define on
prompt  ...done
