set define off
set verify off
set feedback off
WHENEVER SQLERROR EXIT SQL.SQLCODE ROLLBACK
begin wwv_flow.g_import_in_progress := true; end;
/
 
 
--application/set_environment
prompt  APPLICATION 102 - fragebogen
--
-- Application Export:
--   Application:     102
--   Name:            fragebogen
--   Date and Time:   10:51 Montag Oktober 26, 2015
--   Exported By:     SYSTEM
--   Flashback:       0
--   Export Type:     Application Export
--   Version:         4.2.5.00.08
--   Instance ID:     63126117280962
--
-- Import:
--   Using Application Builder
--   or
--   Using SQL*Plus as the Oracle user APEX_040200 or as the owner (parsing schema) of the application
 
-- Application Statistics:
--   Pages:                    111
--     Items:                2,086
--     Validations:            238
--     Processes:              734
--     Regions:                293
--     Buttons:                411
--     Dynamic Actions:        101
--   Shared Components:
--     Logic:
--       Items:                 42
--       Processes:             18
--       Build Options:          1
--     Navigation:
--       Parent Tabs:            1
--       Tab Sets:               2
--         Tabs:                30
--       Breadcrumbs:            3
--         Entries:             87
--       NavBar Entries:         1
--     Security:
--       Authentication:         4
--       Authorization:          1
--     User Interface:
--       Themes:                11
--       Templates:
--         Page:                83
--         Region:             193
--         Label:               45
--         List:               127
--         Popup LOV:            9
--         Calendar:            27
--         Breadcrumb:          18
--         Button:              38
--         Report:              65
--       LOVs:                   2
--       Shortcuts:             10
--       Plug-ins:               8
--     Globalization:
--       Messages:              42
--     Reports:
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_040200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>nvl(wwv_flow_application_install.get_workspace_id,2031917327559678));
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2012.01.01');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := nvl(wwv_flow_application_install.get_application_id,102);
   wwv_flow_api.g_id_offset := nvl(wwv_flow_application_install.get_offset,0);
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(nvl(wwv_flow_application_install.get_application_id,102));
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(nvl(wwv_flow_application_install.get_application_id,102));
null;
 
end;
/

prompt  ...ui types
--
 
begin
 
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => nvl(wwv_flow_application_install.get_application_id,102),
  p_display_id=> nvl(wwv_flow_application_install.get_application_id,102),
  p_owner => nvl(wwv_flow_application_install.get_schema,'FRGBG'),
  p_name  => nvl(wwv_flow_application_install.get_application_name,'fragebogen'),
  p_alias => nvl(wwv_flow_application_install.get_application_alias,'F102'),
  p_page_view_logging => 'YES',
  p_page_protection_enabled_y_n=> 'Y',
  p_checksum_salt_last_reset => '20150917143643',
  p_max_session_length_sec=> 28800,
  p_on_max_session_timeout_url=> 'f?p=&APP_ID.:100:',
  p_on_max_idle_timeout_url=> 'f?p=&APP_ID.:100:',
  p_compatibility_mode=> '4.0',
  p_html_escaping_mode=> 'B',
  p_flow_language=> 'de-ch',
  p_flow_language_derived_from=> 'ITEM_PREFERENCE',
  p_allow_feedback_yn=> 'N',
  p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,''),
  p_publish_yn=> 'N',
  p_documentation_banner=> '',
  p_authentication=> 'PLUGIN',
  p_authentication_id=> 4256129844199370 + wwv_flow_api.g_id_offset,
  p_logout_url=> 'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&amp;p_next_flow_page_sess=102:101',
  p_application_tab_set=> 1,
  p_logo_image => '/i/themes/&FAS_THEME_NAME./logo.jpg',
  p_public_url_prefix => '',
  p_public_user=> 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server=> nvl(wwv_flow_application_install.get_proxy,''),
  p_cust_authentication_process=> '',
  p_cust_authentication_page=> '',
  p_flow_version=> 'Release 1.0',
  p_flow_status=> 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'Diese Anwendung ist aktuell nicht verfügbar.',
  p_build_status=> 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_browser_cache=>'Y',
  p_browser_frame=>'A',
  p_deep_linking=>'Y',
  p_vpd=> '',
  p_vpd_teardown_code=> '',
  p_authorize_public_pages_yn=>'Y',
  p_csv_encoding=> 'Y',
  p_auto_time_zone=> 'N',
  p_include_legacy_javascript=> 'Y',
  p_default_error_display_loc=> 'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_last_updated_by => 'OLIVER.LEMM',
  p_last_upd_yyyymmddhh24miss=> '20150917143643',
  p_ui_type_name => null,
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

----------------
--package app map
--
prompt  ...user interfaces
--
 
begin
 
--application/user interface/desktop
wwv_flow_api.create_user_interface (
  p_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_ui_type_name => 'DESKTOP'
 ,p_display_name => 'Desktop'
 ,p_display_seq => 10
 ,p_use_auto_detect => true
 ,p_is_default => true
 ,p_theme_id => 1
 ,p_home_url => 'f?p=&APP_ID.:100:&SESSION.'
 ,p_login_url => 'f?p=&APP_ID.:100:'
 ,p_global_page_id => 0
  );
null;
 
end;
/

prompt  ...plug-in settings
--
 
begin
 
--application/plug-in setting/item_type_native_yes_no
wwv_flow_api.create_plugin_setting (
  p_id => 2628928319874835 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'ITEM TYPE'
 ,p_plugin => 'NATIVE_YES_NO'
 ,p_attribute_01 => 'Y'
 ,p_attribute_03 => 'N'
  );
--application/plug-in setting/dynamic_action_plugin_com_enkitec_clob_load
wwv_flow_api.create_plugin_setting (
  p_id => 64241756396757628 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'DYNAMIC ACTION'
 ,p_plugin => 'PLUGIN_COM_ENKITEC_CLOB_LOAD'
 ,p_attribute_01 => 'Y'
 ,p_attribute_02 => 'Please wait...'
 ,p_attribute_03 => 'DEFAULT'
  );
--application/plug-in setting/dynamic_action_plugin_com_skillbuilders_modal_page
wwv_flow_api.create_plugin_setting (
  p_id => 34420704228053846200 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'DYNAMIC ACTION'
 ,p_plugin => 'PLUGIN_COM_SKILLBUILDERS_MODAL_PAGE'
 ,p_attribute_01 => '1'
 ,p_attribute_02 => '.5'
 ,p_attribute_03 => 'Y'
 ,p_attribute_04 => 'none'
 ,p_attribute_05 => '100'
 ,p_attribute_06 => '300'
 ,p_attribute_07 => 'Y'
  );
--application/plug-in setting/item_type_plugin_com_skillbuilders_super_lov
wwv_flow_api.create_plugin_setting (
  p_id => 35179233361099294447 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_plugin_type => 'ITEM TYPE'
 ,p_plugin => 'PLUGIN_COM_SKILLBUILDERS_SUPER_LOV'
 ,p_attribute_01 => 'CONTAINS_IGNORE'
 ,p_attribute_03 => 'DEFAULT'
 ,p_attribute_04 => 'drip-circle'
 ,p_attribute_06 => '400'
 ,p_attribute_07 => 'Y'
 ,p_attribute_08 => 'Your search returned no results.'
  );
null;
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
--application/shared_components/security/authorization/check_page_access
wwv_flow_api.create_security_scheme (
  p_id => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'check_page_access'
 ,p_scheme_type => 'NATIVE_FUNCTION_BODY'
 ,p_attribute_01 => 'DECLARE'||unistr('\000a')||
'   v_anz           NUMBER;'||unistr('\000a')||
'   v_fehlerseite   NUMBER := 130;'||unistr('\000a')||
'   v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--mel.p(''Check Zugriff 1: %1,%2,%3,%4,%5,%6'',v_prot_id,''Info'',''102/0 dynamic action check_zugriff'',:fas_schema_id,:FAS_LOGIN_PERSONENSTAMM_ID,:FAS_IDENTITAET_PERSSTAMM_ID,:APP_ID,:APP_PAGE_ID,:FAS_AUFGERUFEN_VON);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Gibt es spezielle Zugriffsdefinitionen?'||unistr('\000a')||
'   SELECT count(*) INTO v_anz'||unistr('\000a')||
'   FROM fas_app_menus'||unistr('\000a')||
'   WHERE satz_kennzeichen is null'||unistr('\000a')||
'     AND app_id = :APP_ID'||unistr('\000a')||
'     AND page_id = :APP_PAGE_ID;'||unistr('\000a')||
'   IF v_anz = 0 THEN -- Keine speziellen Berechtigungen definiert => Zugriff möglich, falls Betreuerzugang'||unistr('\000a')||
'      IF :fas_aufgerufen_von = ''BETREUER'' THEN'||unistr('\000a')||
'         RETURN TRUE;'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         RETURN FALSE;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   -- Check spezieller Zugriff'||unistr('\000a')||
'   IF frgbg_t.CHECK_FAS_APP_ZUGRIFF(:FAS_LOGIN_PERSONENSTAMM_ID,'||unistr('\000a')||
'                                    :FAS_IDENTITAET_PERSSTAMM_ID,:APP_ID,:APP_PAGE_ID) >= 1 '||unistr('\000a')||
'   THEN  -- Zugriff erlaubt'||unistr('\000a')||
'      return TRUE;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      return FALSE;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'--mel.p(''Check Zugriff 2: %1,%2,%3,%4,%5,%6'',v_prot_id,''Info'',''102/authorization check_page_access'',:fas_schema_id,:FAS_LOGIN_PERSONENSTAMM_ID,:FAS_IDENTITAET_PERSSTAMM_ID,:APP_ID,:APP_PAGE_ID,:FAS_AUFGERUFEN_VON);'||unistr('\000a')||
''||unistr('\000a')||
'END;'
 ,p_error_message => '&FAS_ZUGRIFF_TEXT.'
 ,p_caching => 'BY_USER_BY_PAGE_VIEW'
  );
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id => 9238720490989214 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_icon_sequence=> 10,
  p_icon_image => '',
  p_icon_subtext=> '&FAS_ABMELDEN_TEXT.',
  p_icon_target=> 'f?p=&APP_ID.:999:&SESSION.::&DEBUG.::P999_LOGIN_PAGE:&FAS_LOGIN_PAGE.:',
  p_icon_image_alt=> '',
  p_icon_height=> null,
  p_icon_width=> null,
  p_icon_height2=> null,
  p_icon_width2=> null,
  p_nav_entry_is_feedback_yn => 'N',
  p_icon_bar_disp_cond=> 'DECLARE'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'RETURN(FALSE); -- Zur Zeit über Menü gelöst'||unistr('\000a')||
'-- 102 Passwort ändern (popup)'||unistr('\000a')||
'-- 134 Logo laden (popup)'||unistr('\000a')||
'IF :APP_PAGE_ID not in (105,104,215,102,134,999) AND :FAS_AUFGERUFEN_VON != ''PIS'' THEN'||unistr('\000a')||
' --  MEL.P (''Navi true page_id:%1, aufruf:%2|'', v_prot_id,''ERROR'',''fas-navi'','||unistr('\000a')||
' --         :APP_PAGE_ID,:fas_AUFGERUFEN_VON);'||unistr('\000a')||
' -- 215: Popup-Drucken, 105 = Registrierung, 104 = Benutzer vergessen,102=Popup PW ändern'||unistr('\000a')||
'  RETURN(TRUE);'||unistr('\000a')||
'ELSE'||unistr('\000a')||
' --  MEL.P (''Navi false page_id:%1, aufruf:%2|'', v_prot_id,''ERROR'',''fas-navi'','||unistr('\000a')||
' --         :APP_PAGE_ID,:fas_AUFGERUFEN_VON);'||unistr('\000a')||
'  RETURN (FALSE);'||unistr('\000a')||
'END IF;'||unistr('\000a')||
'END;',
  p_icon_bar_disp_cond_type=> 'FUNCTION_BODY',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
 
end;
/

prompt  ...application processes
--
--application/shared_components/logic/application_processes/init_scrollregion_height
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_prot_id   NUMBER;'||unistr('\000a')||
'   v_user      personenstamm.user_account%TYPE;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :FAS_SCROLLREGION_HEIGHT_MAX:= frgbg_s.get_pers_option(:APP_USER,4);'||unistr('\000a')||
'   IF :FAS_SCROLLREGION_HEIGHT_MAX IS NULL THEN'||unistr('\000a')||
'      :FAS_SCROLLREGION_HEIGHT_MAX := 500;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'/* MEL.P (''Scrollheigth!''||:FAS_SCROLLREGION_HEIGHT_MAX||'' (user=''||:APP_USER||'' USer:''||:P121_USERNAME||'')! [init_scrollregion,30]'', v_PROT';

p:=p||'_ID, ''ERROR'', ''init_scrollregion,30'');'||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 12151422924614296 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'AFTER_AUTHENTICATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_scrollregion_height',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Fehler beim Setzen der fas_scrollregion_height in Anwendungsprozess init_scrollregion_height!',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/set_fas_texte
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_sprache_id NUMBER := v(''FAS_SPRACHE_ID'');  --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   v_sprache_id := v(''FAS_SPRACHE_ID''); '||unistr('\000a')||
'   :fas_abmelden_text := '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(174,v_sprache_id);'||unistr('\000a')||
'   :fas_keine_daten_text := '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(759,v_sprache_id);'||unistr('\000a')||
'   :FAS_AENDERUNGWARNUNG_TEXT :=  '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(3068,v_sprache_id);'||unistr('\000a')||
'   :FA';

p:=p||'S_LOESCHABFRAGE_TEXT := '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(2195,v_sprache_id);'||unistr('\000a')||
'   :FAS_ZUGRIFF_TEXT :=  '||unistr('\000a')||
'        frgbg_s.holen_uebersetzung(3110,v_sprache_id);'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 2175419584582678 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_fas_texte',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/checkbestelldatum
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_neue_zeile                  varchar2(10) := '' ''; '||unistr('\000a')||
'   v_bestelldatum                DATE;'||unistr('\000a')||
'   v_plandatum                   DATE;'||unistr('\000a')||
'   v_anz_tage                    NUMBER:= 15;'||unistr('\000a')||
'   v_sprache_id                  number := frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'   v_fehlertext                  VARCHAR2(4000)  := NULL;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P (''Datum = %1,%2,%3'', v_PROT_ID, ''ERROR'', ''';

p:=p||'CheckBestelldatum'','||unistr('\000a')||
'--          :P215_BESTELLDATUM,:P215_PLANDATUM);'||unistr('\000a')||
''||unistr('\000a')||
'   IF trim(:P215_BESTELLDATUM)IS NOT NULL  THEN'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         SELECT to_number(parameter) into v_anz_tage'||unistr('\000a')||
'         FROM sysareas_frgbg'||unistr('\000a')||
'         WHERE id = 34;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'         v_anz_tage := 15;'||unistr('\000a')||
'      END;'||unistr('\000a')||
''||unistr('\000a')||
'      -- Check Eingabe ist Datum'||unistr('\000a')||
'      BEGIN '||unistr('\000a')||
'              '||unistr('\000a')||
'         v_bestelldatum :';

p:=p||'= to_date(trim(:P215_BESTELLDATUM),'||unistr('\000a')||
'                                   ''DD.MM.RRRR'');'||unistr('\000a')||
'         v_plandatum    := to_date(trim(:P215_PLANDATUM),'||unistr('\000a')||
'                                   ''DD.MM.RRRR'');'||unistr('\000a')||
'--MEL.P (''Nach konvert Datum = %1,%2,%3'', v_PROT_ID, ''ERROR'','||unistr('\000a')||
'--       ''CheckBestelldatum'',v_bestelldatum ,v_plandatum);'||unistr('\000a')||
''||unistr('\000a')||
'         IF v_plandatum - v_bestelldatum <= v_anz_tage THEN'||unistr('\000a')||
'            v_fehlertext';

p:=p||' := v_fehlertext || v_neue_zeile||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(3084,v_sprache_id,v_anz_tage,:P215_BESTELLDATUM);'||unistr('\000a')||
'         END IF; -- im Wertebereich ?'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'         --o_fehler :=''Kann nicht in eine Zahl konvertiert werden.''; '||unistr('\000a')||
'         /*v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(1792,v_sprache_id,'||unistr('\000a')||
'';

p:=p||'                        v_plandatum); '||unistr('\000a')||
'         */'||unistr('\000a')||
'         -- Falsches Datumsformat wird in der nachfolgenden Validierung erkannt'||unistr('\000a')||
'         -- => keine Reaktion zu diesem Zeitpunkt'||unistr('\000a')||
'         NULL;'||unistr('\000a')||
'      END;'||unistr('\000a')||
'   END IF; -- Wert eingegeben?  '||unistr('\000a')||
''||unistr('\000a')||
'   htp.prn(v_fehlertext);'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN'||unistr('\000a')||
'   MEL.P (''Fehler bei Bestelldatumsprüfung:''||SQLERRM, v_PROT_ID, ''ERROR'', ''CheckBestelldatum'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 2188418706693514 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'checkBestelldatum',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/fill_item_from_item
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'v_anzeige varchar2(5);'||unistr('\000a')||
''||unistr('\000a')||
'begin'||unistr('\000a')||
'select decode(checkbox,''Y'',''ja'',''nein'') into v_anzeige from dual; htp.prn(v_anzeige);'||unistr('\000a')||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 2350705862353429 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'fill_item_from_item',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/init_fas_session
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprachcode app_sprachen.sprachcode%TYPE;'||unistr('\000a')||
'   v_prot_id    NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT s.sprachcode into v_sprachcode'||unistr('\000a')||
'   FROM app_sprachen s, personenstamm p'||unistr('\000a')||
'   WHERE s.id = p.app_sprache_id'||unistr('\000a')||
'     AND p.id = :fas_login_personenstamm_id;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Für die Zahlennotation ,. (Dezimaltrenner)'||unistr('\000a')||
'   :FSP_LANGUAGE_PREFERENCE := v_sprachcode;'||unistr('\000a')||
'--MEL.P (''nachher Sprachcode = %1,%2,%3'', v_PROT_ID, ''Info'', ''';

p:=p||'init_fas_session'',v_sprachcode,:fas_login_personenstamm_id,:FSP_LANGUAGE_PREFERENCE);'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN others THEN'||unistr('\000a')||
'   :FSP_LANGUAGE_PREFERENCE  := ''de-ch'';'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 2887904124092079 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_fas_session',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Sprachcode konnte nicht ermittelt werden!',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/get_next_fb_tab_page_id
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_next_page_id  NUMBER;'||unistr('\000a')||
'   v_gefunden      NUMBER := 0;'||unistr('\000a')||
'   v_prot_id       NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--mel.p(''1 Page:%1,nxt:%2'',v_prot_id,''TEST'',''102/on_demand:get_next_fb_tab_page_id'',:APP_PAGE_ID,:p1_next_page_id);'||unistr('\000a')||
'   v_next_page_id := :APP_PAGE_ID+1;'||unistr('\000a')||
'   v_gefunden := 0;'||unistr('\000a')||
'   WHILE v_gefunden=0 LOOP'||unistr('\000a')||
'      IF v_next_page_id > 10 AND v_next_page_id < 31 THEN -- Lab-Tab-Uebergang '||unistr('\000a')||
'         v_next_page';

p:=p||'_id := 31;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'      IF  v_next_page_id >=1 AND v_next_page_id <= 10 THEN  -- Std-Tabs-Check'||unistr('\000a')||
'         IF  frgbg_s.check_tab_anzeigen (:P1_PERGEBNIS_ID,v(''P1_TAB''||v_next_page_id ||''_KATEGORIE_ID'')) THEN'||unistr('\000a')||
'              v_gefunden := 1;'||unistr('\000a')||
'         ELSE -- nächste Seite prüfen'||unistr('\000a')||
'              v_next_page_id := v_next_page_id + 1;'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      ELSIF v_next_page_id >= 31 AND v_next_page_';

p:=p||'id <= 35 THEN  -- Lab-Tabs-Check'||unistr('\000a')||
'         IF  frgbg_s.check_tab_anzeigen (:P1_PERGEBNIS_ID,v(''P31_TAB''||v_next_page_id ||''_KATEGORIE_ID'')) THEN'||unistr('\000a')||
'              v_gefunden := 1;'||unistr('\000a')||
'         ELSE -- nächste Seite prüfen'||unistr('\000a')||
'              v_next_page_id := v_next_page_id + 1;'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      ELSE  -- unbekanntes Check Intervall oder bisher nichts gefunden'||unistr('\000a')||
'         v_next_page_id := 95;'||unistr('\000a')||
'         v_gefun';

p:=p||'den := 1;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_next_page_id := v_next_page_id; '||unistr('\000a')||
''||unistr('\000a')||
'/*'||unistr('\000a')||
'alter version'||unistr('\000a')||
'*/'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'get_next_fb_tab_page_id',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/get_ort
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'   declare  '||unistr('\000a')||
'     l_counter number;  '||unistr('\000a')||
'     l_o_name  varchar2(2000);  '||unistr('\000a')||
'   begin  '||unistr('\000a')||
'       owa_util.mime_header(''text/xml'', FALSE );  '||unistr('\000a')||
'       htp.p(''Cache-Control: no-cache'');  '||unistr('\000a')||
'       htp.p(''Pragma: no-cache'');  '||unistr('\000a')||
'       owa_util.http_header_close;  '||unistr('\000a')||
'       htp.prn(''<select>'');  '||unistr('\000a')||
'       for rec in (select '||unistr('\000a')||
''||unistr('\000a')||
'             "RANDOMDATA"."CATEGORY" as "CATEGORY",  '||unistr('\000a')||
'             "RANDOMDATA"."NAME" as "NA';

p:=p||'ME",  '||unistr('\000a')||
'             "RANDOMDATA"."ID" as "ID"   '||unistr('\000a')||
'          from "RANDOMDATA" "RANDOMDATA"  '||unistr('\000a')||
'          where "RANDOMDATA"."CATEGORY" = :TEMPORARY_ITEM)  '||unistr('\000a')||
'       loop  '||unistr('\000a')||
'         htp.prn(''<option value="'' || rec.id || ''">'' || rec.name || ''</option>'');  '||unistr('\000a')||
'       end loop;  '||unistr('\000a')||
'       htp.prn(''</select>'');   '||unistr('\000a')||
'   end;  ';

wwv_flow_api.create_flow_process(
  p_id => 4058127780787907 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'get_ort',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/getlanguage
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'/* wird zur Zeit nicht mehr benutzt'||unistr('\000a')||
'declare'||unistr('\000a')||
' v_language varchar2(5);'||unistr('\000a')||
'begin'||unistr('\000a')||
' select to_char(sprache_id) into v_language from app_sprachen '||unistr('\000a')||
' where id = :P1_APP_SPRACHE_ID;'||unistr('\000a')||
' htp.prn(v_language);'||unistr('\000a')||
'end;'||unistr('\000a')||
''||unistr('\000a')||
'/*'||unistr('\000a')||
'In Seiten Header :'||unistr('\000a')||
'<script language="JavaScript1.1" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
'function f_getlanguage()'||unistr('\000a')||
'{ '||unistr('\000a')||
'  var get = new htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=getlanguage'',0);'||unistr('\000a')||
'  get.add(''';

p:=p||'P132_APP_SPRACHE_ID'',html_GetElement(''P132_APP_SPRACHE_ID'').value);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  html_GetElement(''P132_SPRACHE_ID'').value = gReturn  }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  html_GetElement(''P132_SPRACHE_ID'').value = ''null''  }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'||unistr('\000a')||
'*/';

wwv_flow_api.create_flow_process(
  p_id => 4319825676381429 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'getlanguage',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/download_doc
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'begin'||unistr('\000a')||
'  #OWNER#.download_doc('||unistr('\000a')||
'    i_doc_id =>      :FAS_DATEI_ID'||unistr('\000a')||
'    --,p_display => false'||unistr('\000a')||
'  );'||unistr('\000a')||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 4652203075760556 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'download_doc',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/checklaborwerte
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_neue_zeile           varchar2(10) := '' ''; '||unistr('\000a')||
'   v_max_wert             NUMBER;'||unistr('\000a')||
'   v_min_wert             NUMBER;'||unistr('\000a')||
'   v_verarb_bezug_einheit_id    NUMBER;'||unistr('\000a')||
'   v_frage_text                 uebersetzungen.text%TYPE;'||unistr('\000a')||
'   v_wert_input                 varchar2(2000);'||unistr('\000a')||
'   v_zahl                        NUMBER;'||unistr('\000a')||
'   v_min                         NUMBER;'||unistr('\000a')||
'   v_max                         NUMBER;'||unistr('\000a')||
'   v_fo';

p:=p||'rmatmask_1                fantworten.formatmask_1%TYPE;'||unistr('\000a')||
'   v_inhstoff_id                 fragen.inhstoff_id%TYPE;'||unistr('\000a')||
'   v_sprache_id                  number := :fas_sprache_id;'||unistr('\000a')||
'   v_fehlertext                  VARCHAR2(4000)  := NULL;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P (''0 Menge = %1,%2,%3'', v_PROT_ID, ''ERROR'', ''CheckLaborWerte'', :P31_WERT_INPUT,:P31_ID_INPUT,:P31_EINHEIT_ID_INPUT);'||unistr('\000a')||
''||unistr('\000a')||
'   v_wert_input ';

p:=p||':= trim(:P31_WERT_INPUT);'||unistr('\000a')||
'   IF v_wert_input IS NOT NULL  THEN'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         --NEI 21.04.10 Prüfung gegen fantwort-Tabelle'||unistr('\000a')||
'/* '||unistr('\000a')||
'        SELECT fa.max_wert, fa.min_wert,'||unistr('\000a')||
'                f.bezug_einheit_id, f.frage_text,fa.formatmask_1,inhstoff_id'||unistr('\000a')||
'         INTO v_max_wert,v_min_wert,'||unistr('\000a')||
'              v_verarb_bezug_einheit_id,v_frage_text,v_formatmask_1,'||unistr('\000a')||
'              v_inhstoff_id'||unistr('\000a')||
'         FROM ';

p:=p||'fantworten fa, v_fragen f'||unistr('\000a')||
'         WHERE f.frage_id = :P31_id_input'||unistr('\000a')||
'           AND f.frage_id = fa.frage_id'||unistr('\000a')||
'           AND rownum <= 1;-- Es darf zu einem Textfeld auch nur eine Antwort geben'||unistr('\000a')||
'*/'||unistr('\000a')||
'         SELECT fa.max_wert, fa.min_wert,'||unistr('\000a')||
'                f.bezug_einheit_id, frgbg_s.holen_uebersetzung(f.text_id_fragetext,v_sprache_id),fa.formatmask,inhstoff_id'||unistr('\000a')||
'         INTO v_max_wert,v_min_wert,'||unistr('\000a')||
'   ';

p:=p||'           v_verarb_bezug_einheit_id,v_frage_text,v_formatmask_1,'||unistr('\000a')||
'              v_inhstoff_id'||unistr('\000a')||
'         FROM fantworten fa, fragen f'||unistr('\000a')||
'         WHERE f.id = :P31_id_input'||unistr('\000a')||
'           AND f.id = fa.frage_id'||unistr('\000a')||
'           AND rownum <= 1;-- Es darf zu einem Textfeld auch nur eine Antwort geben'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'         --o_fehler :=''Kann nicht in eine Zahl konvertiert werden.''; '||unistr('\000a')||
'     ';

p:=p||'    v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                      frgbg_s.holen_uebersetzung(551,v_sprache_id,'||unistr('\000a')||
'                           v_wert_input,v_frage_text)||SQLERRM; '||unistr('\000a')||
'      END;'||unistr('\000a')||
' '||unistr('\000a')||
'      -- Check Eingabe ist Zahl'||unistr('\000a')||
'      v_zahl := NULL;'||unistr('\000a')||
'      v_zahl := rezepte.convert_to_number(v_wert_input,'||unistr('\000a')||
'                                            ''999G999G999D99999'');'||unistr('\000a')||
'      IF v_zahl is NULL THEN'||unistr('\000a')||
'';

p:=p||'         v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(551,v_sprache_id,'||unistr('\000a')||
'                        v_wert_input,v_frage_text);  '||unistr('\000a')||
'      ELSIF v_zahl is not null AND '||unistr('\000a')||
'            v_max_wert is not null AND v_min_wert is not null '||unistr('\000a')||
'      THEN'||unistr('\000a')||
'         -- Eingabezahl formatieren'||unistr('\000a')||
'--MEL.P (''Menge = %1,%2,%3'', v_PROT_ID, ''ERROR'', ''CheckLaborWerte'',v_formatmask_1';

p:=p||',v_zahl,:P31_EINHEIT_ID_INPUT);'||unistr('\000a')||
'         v_zahl := frgbg_s.fb_format_fant_wert(v_zahl,v_formatmask_1,2);'||unistr('\000a')||
'--MEL.P (''1 Menge = %1,%2,%3'', v_PROT_ID, ''ERROR'', ''CheckLaborWerte'',v_formatmask_1,v_zahl,:P31_EINHEIT_ID_INPUT);'||unistr('\000a')||
'         -- Wertebereichsprüfung'||unistr('\000a')||
'         v_max := rezepte.umrechnen_inh_bez_eh'||unistr('\000a')||
'              (v_max_wert,v_inhstoff_id,         '||unistr('\000a')||
'               v_verarb_bezug_einheit_id,:P31_EINH';

p:=p||'EIT_ID_INPUT);'||unistr('\000a')||
'         v_min := rezepte.umrechnen_inh_bez_eh'||unistr('\000a')||
'              (v_min_wert,v_inhstoff_id,         '||unistr('\000a')||
'               v_verarb_bezug_einheit_id,:P31_EINHEIT_ID_INPUT);'||unistr('\000a')||
'--MEL.P(''2 MIN/MAX Menge = %1,%2,%3'', v_PROT_ID, ''ERROR'', ''CheckLaborWerte'',:P31_wert_INPUT,v_min,v_max);'||unistr('\000a')||
''||unistr('\000a')||
'         IF v_zahl > v_max OR'||unistr('\000a')||
'            v_zahl < v_min'||unistr('\000a')||
'         THEN'||unistr('\000a')||
'            v_fehlertext := v_fehlertext || v';

p:=p||'_neue_zeile||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(550,v_sprache_id,'||unistr('\000a')||
'                      v_wert_input,'||unistr('\000a')||
'                      v_frage_text,'||unistr('\000a')||
'                      trim(to_char(v_min,''FM999G999G990D0999'')),'||unistr('\000a')||
'                      trim(to_char(v_max,''FM999G999G990D0999''))'||unistr('\000a')||
'                          );'||unistr('\000a')||
'         END IF; -- im Wertebereich ?'||unistr('\000a')||
'      END IF; -- Zahl?'||unistr('\000a')||
''||unistr('\000a')||
'   END IF; -- Wert eingegeben?';

p:=p||'  '||unistr('\000a')||
'   htp.prn(v_fehlertext);'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN'||unistr('\000a')||
'   MEL.P (''Fehler =''||SQLERRM, v_PROT_ID, ''ERROR'', ''CheckLaborWerte'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 4844113825056465 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'checkLaborWerte',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/checkmessdatum
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id     number := v(''FAS_SPRACHE_ID'');'||unistr('\000a')||
'   v_fehlertext     varchar2(2000);'||unistr('\000a')||
'   v_datum          date; '||unistr('\000a')||
'   v_prot_id        number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'mel.p(''checkdatum a %1,%2'',v_prot_id,''test'',''checkdatum'',v_fehlertext,:p31_datum);'||unistr('\000a')||
'   BEGIN '||unistr('\000a')||
'      v_datum  := to_date(trim(:p31_datum),''DD.MM.YYYY hh24:mi'');'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN OTHERS THEN'||unistr('\000a')||
'      v_fehlertext :=   '||unistr('\000a')||
'            frgbg_s.holen_u';

p:=p||'ebersetzung(3601,v_sprache_id,'||unistr('\000a')||
'            :p31_datum,:p31_frage_text);'||unistr('\000a')||
'   END ;'||unistr('\000a')||
'mel.p(''checkdatum %1,%2'',v_prot_id,''test'',''checkdatum'',v_fehlertext,:p31_datum);'||unistr('\000a')||
'   htp.prn(v_fehlertext);'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 4965126373354331 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'checkMessdatum',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/checkbestelldatumneu
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_neue_zeile                  varchar2(10) := '' ''; '||unistr('\000a')||
'   v_bestelldatum                DATE;'||unistr('\000a')||
'   v_plandatum                   DATE;'||unistr('\000a')||
'   v_anz_tage                    number:= 15;'||unistr('\000a')||
'   v_sprache_id                  number := frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'   v_fehlertext                  VARCHAR2(4000)  := NULL;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P (''Datum = %1,%2,%3'', v_PROT_ID, ''ERROR'', ''';

p:=p||'CheckBestelldatum'','||unistr('\000a')||
'--          :P215_BESTELLDATUM,:P215_PLANDATUM);'||unistr('\000a')||
''||unistr('\000a')||
'   IF trim(:TEMP_BESTELLDATUM)IS NOT NULL  THEN'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         SELECT to_number(parameter) into v_anz_tage'||unistr('\000a')||
'         FROM sysareas_frgbg'||unistr('\000a')||
'         WHERE id = 34;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'         v_anz_tage := 15;'||unistr('\000a')||
'      END;'||unistr('\000a')||
''||unistr('\000a')||
'      -- Check Eingabe ist Datum'||unistr('\000a')||
'      BEGIN '||unistr('\000a')||
'              '||unistr('\000a')||
'         v_bestelldatum :';

p:=p||'= to_date(trim(:TEMP_BESTELLDATUM),'||unistr('\000a')||
'                                   ''DD.MM.RRRR'');'||unistr('\000a')||
'         v_plandatum    := to_date(trim(:TEMP_PLANDATUM),'||unistr('\000a')||
'                                   ''DD.MM.RRRR'');'||unistr('\000a')||
'--MEL.P (''Nach konvert Datum = %1,%2,%3'', v_PROT_ID, ''ERROR'','||unistr('\000a')||
'--       ''CheckBestelldatum'',v_bestelldatum ,v_plandatum);'||unistr('\000a')||
''||unistr('\000a')||
'         IF v_plandatum - v_bestelldatum <= v_anz_tage  THEN'||unistr('\000a')||
'            v_fehlertex';

p:=p||'t := v_fehlertext || v_neue_zeile||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(3084,v_sprache_id,v_anz_tage ,:TEMP_BESTELLDATUM);'||unistr('\000a')||
'         END IF; -- im Wertebereich ?'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'         --o_fehler :=''Kann nicht in eine Zahl konvertiert werden.''; '||unistr('\000a')||
'         /*v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(1792,v_sprache_id';

p:=p||','||unistr('\000a')||
'                        v_plandatum); '||unistr('\000a')||
'         */'||unistr('\000a')||
'         -- Falsches Datumsformat wird in der nachfolgenden Validierung erkannt'||unistr('\000a')||
'         -- => keine Reaktion zu diesem Zeitpunkt'||unistr('\000a')||
'         NULL;'||unistr('\000a')||
'      END;'||unistr('\000a')||
'   END IF; -- Wert eingegeben?  '||unistr('\000a')||
''||unistr('\000a')||
'   htp.prn(v_fehlertext);'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN'||unistr('\000a')||
'   MEL.P (''Fehler bei Bestelldatumsprüfung:''||SQLERRM, v_PROT_ID, ''ERROR'', ''CheckBestelldatumNeu'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 5564901375570713 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'checkBestelldatumNeu',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/gettextbeschreibunghtml
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'begin'||unistr('\000a')||
''||unistr('\000a')||
'   FRGBG_T.A102_AP_GET_TEXT_BESCHR_HTML('||unistr('\000a')||
'        p_text_id => to_number(:P150_TEXT_ID)'||unistr('\000a')||
'    );'||unistr('\000a')||
''||unistr('\000a')||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 6916408895497451 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'GetTextBeschreibungHTML',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/gettextuebhtml
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'begin'||unistr('\000a')||
'  FRGBG_T.A102_AP_GET_TEXT_UEB_HTML('||unistr('\000a')||
'        p_ueb_id => :P150_UEB_ID'||unistr('\000a')||
'  );'||unistr('\000a')||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 6924710607043698 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'GetTextUebHTML',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/checkmnrdetails
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_mn_menge_tag_max            NUMBER;'||unistr('\000a')||
'   v_mn_menge_tag_min            NUMBER;'||unistr('\000a')||
'   v_mn_einheit_id_tag_max       NUMBER;'||unistr('\000a')||
'   v_mn_einheit_id_tag_min       NUMBER;'||unistr('\000a')||
'   v_bezeichnung                 varchar2(100);'||unistr('\000a')||
'   v_menge_input                 varchar2(2000);'||unistr('\000a')||
'   v_zahl                        NUMBER;'||unistr('\000a')||
'   v_min                         NUMBER;'||unistr('\000a')||
'   v_max                         NUMBER;'||unistr('\000a')||
'   v_spr';

p:=p||'ache_id                  number := frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'   v_fehlertext                  VARCHAR2(4000)  := NULL;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   --FRGBG_JOBS.SLEEP(5000);'||unistr('\000a')||
'-- Liefert einen Fehlertext, die erste Stelle markiert die Gewichtigkeit '||unistr('\000a')||
'-- des Fehlers 1= Warnung, 2= Fehler'||unistr('\000a')||
''||unistr('\000a')||
'--MEL.P (''Menge = %1,%2,%3'', v_PROT_ID, ''ERROR'', ''CheckMnrDetails'','||unistr('\000a')||
'--            :P202_MENGE_INPUT,:P20';

p:=p||'2_ID_INPUT,:P202_EINHEIT_ID_INPUT);'||unistr('\000a')||
''||unistr('\000a')||
'--v_fehlertext:= ''Wert:''||NVL(:P202_MENGE_INPUT,-1)||'' id:''||:P202_ID_INPUT||'||unistr('\000a')||
'-- '' eh-id:''||:P202_EINHEIT_ID_INPUT;'||unistr('\000a')||
'   v_menge_input := trim(:P202_MENGE_INPUT);'||unistr('\000a')||
'   IF v_menge_input IS NOT NULL  THEN'||unistr('\000a')||
'      -- Check Eingabe ist Zahl'||unistr('\000a')||
'      v_zahl := NULL;'||unistr('\000a')||
'      v_zahl := rezepte.convert_to_number(v_menge_input,'||unistr('\000a')||
'                                            ''999G999G';

p:=p||'999D99999'');'||unistr('\000a')||
'      IF v_zahl is NULL THEN'||unistr('\000a')||
'         v_fehlertext := ''2''||frgbg_s.holen_uebersetzung(551,v_sprache_id,'||unistr('\000a')||
'                        v_menge_input,v_bezeichnung);  '||unistr('\000a')||
'      ELSIF v_zahl is not null AND v_zahl <> 0 THEN'||unistr('\000a')||
'         -- Prüfung Eingabe nur max. 1 Nachkommastelle'||unistr('\000a')||
'         IF trunc(v_zahl,1) != v_zahl THEN'||unistr('\000a')||
'            v_fehlertext := ''2''||frgbg_s.holen_uebersetzung(2150,v_sprache_id';

p:=p||','||unistr('\000a')||
'                        v_menge_input,v_bezeichnung);  '||unistr('\000a')||
'         ELSE '||unistr('\000a')||
'            v_fehlertext := rezepte.check_mnr_inhgrenzwert(:P201_mn_rezept_id,'||unistr('\000a')||
'                           :P202_id_input,'||unistr('\000a')||
'                           v_zahl,:P202_EINHEIT_ID_INPUT'||unistr('\000a')||
'                      );'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      '||unistr('\000a')||
'      END IF; -- Zahl?'||unistr('\000a')||
''||unistr('\000a')||
'   END IF; -- Wert eingegeben?  '||unistr('\000a')||
'   htp.prn(trim(v_fehlertext));'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'';

p:=p||'WHEN OTHERS THEN'||unistr('\000a')||
'   MEL.P (''Fehler bei Zugriff aufg_f04 =''||SQLERRM, v_PROT_ID, ''ERROR'', ''CheckMnrDetails'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 7106115549680607 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'checkMnrDetails',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/checkproddetails
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_neue_zeile                  varchar2(10) := '' ''; '||unistr('\000a')||
'   v_bezeichnung                 varchar2(100);'||unistr('\000a')||
'   v_zahl                        NUMBER;'||unistr('\000a')||
'   v_menge_input                 varchar2(2000);'||unistr('\000a')||
'   v_sprache_id                  number := frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'   v_artikel_menge               mengenarts.menge%TYPE;'||unistr('\000a')||
'   v_artikel_einheit_id          mengenarts.menge_einheit_id%TYPE';

p:=p||';'||unistr('\000a')||
'   v_mingrenze_artikelgramm      NUMBER;'||unistr('\000a')||
'   v_mingrenze_artikelanzahl     NUMBER;'||unistr('\000a')||
'   v_anzahl2                     NUMBER;'||unistr('\000a')||
'   v_entnahmeart_id              mengenarts.entnahmeart_id%TYPE;'||unistr('\000a')||
'   v_fehlertext                  VARCHAR2(4000)  := NULL;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.P (''Menge = %1,%2,%3'', v_PROT_ID, ''ERROR'', ''CheckMnrDetails'','||unistr('\000a')||
'--            :P202_MENGE_INPUT,:P202_ID_INPUT,:P202_EINH';

p:=p||'EIT_ID_INPUT);'||unistr('\000a')||
''||unistr('\000a')||
'--v_fehlertext:= ''Wert:''||:P202_MENGE_INPUT||'' id:''||:P202_ID_INPUT||'||unistr('\000a')||
'-- '' eh-id:''||:P202_EINHEIT_ID_INPUT;'||unistr('\000a')||
''||unistr('\000a')||
'NULL;'||unistr('\000a')||
'   v_menge_input := trim(:P202_MENGE_INPUT);'||unistr('\000a')||
'   IF v_menge_input IS NOT NULL  THEN      -- Check Eingabe ist Zahl'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         SELECT mart_kuerzel,mart_menge,mart_menge_einheit_id,entnahmeart_id'||unistr('\000a')||
'         INTO v_bezeichnung,v_artikel_menge, v_artikel_einheit_id,';

p:=p||' v_entnahmeart_id'||unistr('\000a')||
'         FROM v_prodr_details'||unistr('\000a')||
'         WHERE mart_id = :P202_id_input'||unistr('\000a')||
'           AND prodr_id = :p201_prod_rezept_id;'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'         --o_fehler :=''Kann nicht in eine Zahl konvertiert werden.''; '||unistr('\000a')||
'         v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                      frgbg_s.holen_uebersetzung(575,v_sprache_id,'||unistr('\000a')||
'                           v_meng';

p:=p||'e_input,v_bezeichnung); '||unistr('\000a')||
'      END;'||unistr('\000a')||
''||unistr('\000a')||
'      -- Check Fehler'||unistr('\000a')||
'      IF v_fehlertext IS NULL THEN'||unistr('\000a')||
'         v_zahl := NULL;'||unistr('\000a')||
'         v_zahl := rezepte.convert_to_number(v_menge_input,'||unistr('\000a')||
'                                            ''999G999G999D99999'');'||unistr('\000a')||
'         IF v_zahl is NULL THEN'||unistr('\000a')||
'            v_fehlertext := v_fehlertext ||v_neue_zeile||'||unistr('\000a')||
'                   frgbg_s.holen_uebersetzung(575,v_sprache_id,'||unistr('\000a')||
' ';

p:=p||'                       v_menge_input,v_bezeichnung);  '||unistr('\000a')||
'         END IF; -- Zahl?'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
''||unistr('\000a')||
'/*'||unistr('\000a')||
'      -- CHECK Warnungen z.B. Kleinstmengen'||unistr('\000a')||
'      IF v_fehlertext IS NULL THEN'||unistr('\000a')||
'         -- Prüfen auf Kleinstmengen fuer Hinweismeldung'||unistr('\000a')||
'         -- Kleinstartikelmengen: Falls die Artikelanzahl kleiner als diese Grenze ist, erfolgt Hinweismeldung'||unistr('\000a')||
'         BEGIN'||unistr('\000a')||
'            SELECT to_number(parameter,';

p:=p||'''9999999999.999999999999'')        -- Dezimaltrenner ist immer Punkt'||unistr('\000a')||
'            into v_mingrenze_artikelanzahl'||unistr('\000a')||
'            FROM  sysareas'||unistr('\000a')||
'            WHERE id = 10  ;'||unistr('\000a')||
'         EXCEPTION'||unistr('\000a')||
'         WHEN others THEN'||unistr('\000a')||
'            v_mingrenze_artikelanzahl := to_number(''0.01'',''9.99'');   -- Defaultwert, falls Zugriff fehlschlaegt'||unistr('\000a')||
'         END ;'||unistr('\000a')||
'   '||unistr('\000a')||
'         -- Kleinstartikelmengen: Falls die Artikelmenge ';

p:=p||'in Gramm (mÂ¿gliche verwiegbare Menge) kleiner als diese Grenze ist, erfolgt Hinweismeldung'||unistr('\000a')||
'         BEGIN'||unistr('\000a')||
'            SELECT  to_number(parameter,''9999999999.999999999999'')       -- Dezimaltrenner ist immer Punkt'||unistr('\000a')||
'            into v_mingrenze_artikelgramm'||unistr('\000a')||
'            FROM  sysareas'||unistr('\000a')||
'            WHERE id = 11  ;'||unistr('\000a')||
'         EXCEPTION'||unistr('\000a')||
'         WHEN others THEN'||unistr('\000a')||
'            v_mingrenze_artikelgramm := to_';

p:=p||'number(''0.1'',''9.9'');   -- Defaultwert, falls Zugriff fehlschlaegt'||unistr('\000a')||
'         END ;'||unistr('\000a')||
''||unistr('\000a')||
'         IF v_entnahmeart_id in (2,3)         THEN -- Stück-/Teilentnahme Stückeinheit => Anzahl liegt vor'||unistr('\000a')||
'            v_anzahl2 := v_zahl;'||unistr('\000a')||
'         ELSE  -- Bulkentnahme =>Gewichtseinheit'||unistr('\000a')||
'            v_anzahl2 := v_zahl/rezepte.UMRECHNEN_ARTIKEL_EH(v_artikel_menge,:P202_id_input,v_artikel_einheit_id, :P202_EINHEIT_I';

p:=p||'D_INPUT);'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
''||unistr('\000a')||
'         IF v_anzahl2 < v_mingrenze_artikelanzahl THEN'||unistr('\000a')||
'            v_fehlertext := ''Kleinstmenge!''||NVL(v_anzahl2,0);'||unistr('\000a')||
'         ELSIF rezepte.UMRECHNEN_ARTIKEL_EH (v_zahl,:P202_id_input,v_artikel_einheit_id,500) < v_mingrenze_artikelgramm THEN'||unistr('\000a')||
'            v_fehlertext := ''Kleinstmenge!'';   '||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      END IF; '||unistr('\000a')||
'*/      '||unistr('\000a')||
''||unistr('\000a')||
'   END IF; -- Wert eingegeben?  '||unistr('\000a')||
'   htp';

p:=p||'.prn(v_fehlertext);'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN'||unistr('\000a')||
'   MEL.P (''Fehler bei Zugriff aufg_f24 =''||SQLERRM, v_PROT_ID, ''ERROR'', ''CheckProdDetails'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 7747913093428940 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'checkProdDetails',
  p_process_sql_clob=> p,
  p_process_error_message=> '  ',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/get_item_help
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'l_counter number;'||unistr('\000a')||
'l_help varchar2(4000);'||unistr('\000a')||
'v_prot_id   number;'||unistr('\000a')||
'--l_item_id varchar2(4000);'||unistr('\000a')||
'--l_page_id varchar2(4000);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--l_item_id := wwv_flow.g_x01;'||unistr('\000a')||
'--l_page_id := wwv_flow.g_x02;'||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'/*mel.p(''Hilfe zu App:%1, Page:%2, ITEM:%3'',v_prot_id,''INFO'',''get_item_help'',:APP_ID,:TEMPORARY_PAGE_ID,:TEMPORARY_ITEM );'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'      SELECT text  INTO l_help --v_helptext'||unistr('\000a')||
'      FROM hilfen h, v_uebe';

p:=p||'rs_texte t'||unistr('\000a')||
'      WHERE h.text_id =  t.text_id'||unistr('\000a')||
'        AND sprache_id = frgbg_s.get_sprache_id(:APP_USER) --v_sprache_id'||unistr('\000a')||
'        AND h.app_id = :APP_ID'||unistr('\000a')||
'        AND h.page_id = :TEMPORARY_PAGE_ID --l_page_id --:TEMPORARY_PAGE_ID --'||unistr('\000a')||
'        AND h.item_id = :TEMPORARY_ITEM --l_item_id --:TEMPORARY_ITEM --'||unistr('\000a')||
'       ;'||unistr('\000a')||
'/*mel.p(''Hilfe zu App:%1, Page:%2, ITEM:%3, Hilfe:%4'',v_prot_id,''INFO'',''get_item_help'',:';

p:=p||'APP_ID,:TEMPORARY_PAGE_ID,:TEMPORARY_ITEM ,l_help);'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN others THEN'||unistr('\000a')||
'mel.p(''Hilfe zu App:%1, Page:%2, ITEM:%3, Hilfe:%4, %5'',v_prot_id,''INFO'',''get_item_help'',:APP_ID,:TEMPORARY_PAGE_ID,:TEMPORARY_ITEM ,l_help,SQLERRM);'||unistr('\000a')||
'      l_help := null; --v_helptext := NULL;'||unistr('\000a')||
''||unistr('\000a')||
'   END;'||unistr('\000a')||
'/*'||unistr('\000a')||
'select ITEM_HELP_TEXT'||unistr('\000a')||
'into l_help'||unistr('\000a')||
'from APEX_APPLICATION_PAGE_ITEMS'||unistr('\000a')||
'where APPLICATION_ID = &APP_ID.'||unistr('\000a')||
'and PA';

p:=p||'GE_ID = l_page_id'||unistr('\000a')||
'and ITEM_ID = l_item_id;'||unistr('\000a')||
'*/'||unistr('\000a')||
'htp.prn(''<div>'');'||unistr('\000a')||
'htp.prn(l_help);'||unistr('\000a')||
'htp.prn(''</div>'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 7984531420608740 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'get_item_help',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/checknormbereich
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_neue_zeile           varchar2(10) := '' ''; '||unistr('\000a')||
'   v_frage_text                 uebersetzungen.text%TYPE;'||unistr('\000a')||
'   v_wert_input                 varchar2(2000);'||unistr('\000a')||
'   v_normbereich               varchar2(2000);'||unistr('\000a')||
'   v_sprache_id                  number := :fas_sprache_id;'||unistr('\000a')||
'   v_fehlertext                  VARCHAR2(4000)  := NULL;'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'   v_ist_fr_laborbereich        number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--MEL.';

p:=p||'P (''0 Normbereich = %1,%2'', v_PROT_ID, ''ERROR'', ''checkNormbereich'', :P31_NORMBEREICH,:P31_ID_INPUT);'||unistr('\000a')||
''||unistr('\000a')||
'   v_normbereich := trim(:P31_NORMBEREICH);'||unistr('\000a')||
'   v_wert_input := trim(:P31_WERT_INPUT);'||unistr('\000a')||
''||unistr('\000a')||
'   if :P31_ID_INPUT is not null then'||unistr('\000a')||
'    begin'||unistr('\000a')||
'     select frgbg_s.holen_uebersetzung(fr.TEXT_ID_FRAGETEXT,v_sprache_id)'||unistr('\000a')||
'          ,CASE WHEN (select max(NORMIERUNGSTYP)'||unistr('\000a')||
'                    FROM FANTWORTEN'||unistr('\000a')||
'     ';

p:=p||'               where frage_id = fr.ID and satz_kennzeichen is null) = ''LABORBEREICH'''||unistr('\000a')||
'              THEN 1 ELSE 0 END'||unistr('\000a')||
'     into v_frage_text, v_ist_fr_laborbereich'||unistr('\000a')||
'     from fragen fr'||unistr('\000a')||
'     where to_char(id) = replace(:P31_ID_INPUT,''NORMB'','''');'||unistr('\000a')||
'    exception'||unistr('\000a')||
'      when others then'||unistr('\000a')||
'        raise_application_error(-20000,''Fehler beim Abruf des Fragetextes ID:''   || :P31_ID_INPUT || '' SQLERRM:'' || sqle';

p:=p||'rrm);'||unistr('\000a')||
'    end;'||unistr('\000a')||
'   end if;'||unistr('\000a')||
''||unistr('\000a')||
'   IF v_normbereich IS NOT NULL  THEN'||unistr('\000a')||
'        --SAL 09.05.2014 Prüfe ob es ein gültiger Laborbereich ist'||unistr('\000a')||
'        IF FRGBG_T.LAB_IST_NORMBER_SYNTAX_GUELTIG(v_normbereich) = 0 THEN'||unistr('\000a')||
'             --Der Normbereich des Laborwertes %0 ist ungültig. Es darf nur ein personen spezifischer Normbereich eingegeben werden '||unistr('\000a')||
'             v_fehlertext := frgbg_s.HOLEN_UEBERSETZUNG(10018';

p:=p||',v_SPRACHE_ID, v_frage_text);'||unistr('\000a')||
'        end if;'||unistr('\000a')||
'   ELSIF v_wert_input is not null and  v_ist_fr_laborbereich = 1 then'||unistr('\000a')||
'     -- Wenn ein Wert angegeben wurde, muss auch ein Normbereich angegeben werden'||unistr('\000a')||
'     -- Sofern es sich um den Normierungstyp LABORBEREICH handelt'||unistr('\000a')||
'     v_fehlertext := frgbg_s.HOLEN_UEBERSETZUNG(10019,v_SPRACHE_ID, v_frage_text);'||unistr('\000a')||
''||unistr('\000a')||
'   END IF; -- Wert eingegeben?  '||unistr('\000a')||
''||unistr('\000a')||
'   htp.prn(v_fehle';

p:=p||'rtext);'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN'||unistr('\000a')||
'   MEL.P (''Fehler =''||SQLERRM, v_PROT_ID, ''ERROR'', ''checkNormbereich'');'||unistr('\000a')||
'   htp.prn(SQLERRM);'||unistr('\000a')||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 8539708770455208 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'checkNormbereich',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_process_comment=> '');
end;
 
null;
 
end;
/

prompt  ...application items
--
--application/shared_components/logic/application_items/fas_abmelden_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 9025203664961837 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_ABMELDEN_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
 ,p_item_comment => 'Element wird in den Login-Pages direkt beim Anmelden gesetzt oder bei Persmasken'||unistr('\000a')||
''
  );
 
end;
/

--application/shared_components/logic/application_items/fas_aenderungwarnung_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 5467725837048512 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_AENDERUNGWARNUNG_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_aufgerufen_von
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 8991421627188085 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_AUFGERUFEN_VON'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
 ,p_item_comment => 'Element wird in den Login-Pages direkt beim Anmelden gesetzt'||unistr('\000a')||
'101 auf ''KUNDE'' bzw. ''ANONYM'''||unistr('\000a')||
'120 auf ''PIS'''||unistr('\000a')||
'121 auf ''BETREUER'' bzw. ''IDENTITAET'''||unistr('\000a')||
'122 auf ''UEBERSETZER'''||unistr('\000a')||
'123 auf ''ANONYM'''||unistr('\000a')||
'124 auf ''KUNDE'''
  );
 
end;
/

--application/shared_components/logic/application_items/fas_datei_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4654231041137634 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_DATEI_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_identitaet
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 2530001406180781 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_IDENTITAET'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_identitaet_persstamm_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 2530510288249585 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_IDENTITAET_PERSSTAMM_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
 ,p_item_comment => 'aktive Identität'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_infozeile
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 5792924212108315 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_INFOZEILE'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
 ,p_item_comment => 'Ergänzung für die Infozeile entsprechend der Def. im Schema'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_keine_daten_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 10761814007783775 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_KEINE_DATEN_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
 ,p_item_comment => 'Element wird in den Login-Pages direkt beim Anmelden gesetzt oder bei Persmasken'||unistr('\000a')||
''
  );
 
end;
/

--application/shared_components/logic/application_items/fas_loeschabfrage_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 2172800397491973 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOESCHABFRAGE_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_login_page
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 9015814952879970 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOGIN_PAGE'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
 ,p_item_comment => 'wird in den Login-Masken direkt beim Anmelden gesetzt'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_login_personenstamm_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3744329047911043 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_LOGIN_PERSONENSTAMM_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_modus_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4074624205562078 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_MODUS_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
 ,p_item_comment => 'FAS-Modus der DEFAULT-Identität des eingeloggten Betreuers abgeleitet aus dem Optionstyp = 27 (0= normaler Fas-Modus, 1= IABC-Modus,2= eoVital)'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_pers_aenderbar
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4811805750286996 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_PERS_AENDERBAR'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
 ,p_item_comment => 'Legt fest, ob die Daten zu dieser Person geändert werden dürfen.'||unistr('\000a')||
'Falls das Flag personenstamm.aenderbar = N steht und die Rolle "GESCHUETZTE_PERSONENDATEN_AENDERN" nicht gesetzt dürfen die Daten zu dieser Person (Stammdaten, Rezepte etc.) nicht geändert bzw. erweitert werden.'||unistr('\000a')||
'Dieses Flag wird in der Seite P110 gesetzt'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_pers_schema_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 2944402084032776 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_PERS_SCHEMA_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
 ,p_item_comment => 'Schema_id des Kunden; wird ermittelt in Page 110 aus der bevorzugt betreuenden Identitaet des Kunden. Mit diesem Schema wird der Sprachset im Personenstamm eingegrenzt und nicht mit der aktuellen Schema-ID des Betreuers, da dieser theoretisch von einem anderen Schema kommen kann (z.B. wenn Fr. Peter für die Biogena arbeitet). '
  );
 
end;
/

--application/shared_components/logic/application_items/fas_schema_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 2736211515442207 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SCHEMA_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
 ,p_item_comment => 'Schema-Id der eingeloggten Person (Betreuers). Daran hängt die Anzeigesprache und das Anzeige-Theme'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_scrollregion_height_max
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 12150131319597825 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SCROLLREGION_HEIGHT_MAX'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_sortiment_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 2996322999737053 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SORTIMENT_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
 ,p_item_comment => 'Die aktive Identitaet bestimmt über die Identitaetenhierarchie das nächste vorhandene Sortiment über (pers_identitaet_props). Hieraus leiten sich die Preise ab.'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_sprache_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 9316018569975059 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_SPRACHE_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'I'
 ,p_item_comment => 'Anzeigesprache (sprache_id) für FAS abhängig vom eingeloggten Benutzer, d.h. entweder die Betreuer-Sprache beim Betreuer-Login oder sonst ist es die Patientensprache.'||unistr('\000a')||
'Wird gesetzt bei allen Login-Masken und bei den Patientenstamm-Masken 1 und 110, da dort die Sprache geändert werden kann.'
  );
 
end;
/

--application/shared_components/logic/application_items/fas_theme_name
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 6305427699722843 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_THEME_NAME'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
 ,p_item_comment => 'fas_theme plus fas_schema_id '||unistr('\000a')||
'=> i/themes/fas_theme_1 => Hepart'||unistr('\000a')||
'=> i/themes/fas_theme_2 => Biogena'||unistr('\000a')||
'=> i/themes/fas_theme_3 => IABC'||unistr('\000a')||
'=> i/themes/fas_theme_4 => Eovital-Order'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
''
  );
 
end;
/

--application/shared_components/logic/application_items/fas_zugriff_text
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3889402272095431 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FAS_ZUGRIFF_TEXT'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
 ,p_item_comment => 'Element wird in den Login-Pages direkt beim Anmelden gesetzt oder bei Persmasken'||unistr('\000a')||
''
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 7177100137818754 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_AFTER_LOGIN_URL'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'B'
 ,p_item_comment => 'Used by Custom2 authentication for deep linking support'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_language_preference
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 2889416478237598 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_LANGUAGE_PREFERENCE'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_12499800077039507
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 12503818271509404 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_12499800077039507'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_12506311953526517
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 12507404812533984 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_12506311953526517'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_12514721659605017
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 12515705514609804 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_12514721659605017'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3200507964368798
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4438909768059092 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3200507964368798'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3523313843107701
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3546725354792279 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3523313843107701'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'S'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3588803015630386
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3590021374631916 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3588803015630386'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3628627124653251
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3634722505915010 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3628627124653251'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_3930816723866867
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3948824744973282 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_3930816723866867'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_4464902988468273
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4754603252960579 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_4464902988468273'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_4712622536239042
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4715600406261746 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_4712622536239042'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_4742021406781853
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4744024831830167 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_4742021406781853'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_4763703340654143
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4764119963658951 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_4763703340654143'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_5520831490328768
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 5623312190054023 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_5520831490328768'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_6677918974782609
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 3119826309783949 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_6677918974782609'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_7181419624881178
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 4438604302059089 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_7181419624881178'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_7411110273738534
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 7438020388464889 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'FSP_PROCESS_STATE_7411110273738534'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
  );
 
end;
/

--application/shared_components/logic/application_items/temp_bestelldatum
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 5565604978656829 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'TEMP_BESTELLDATUM'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/temporary_item
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 7983701638600170 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'TEMPORARY_ITEM'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/temporary_page_id
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 7983329211598607 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'TEMPORARY_PAGE_ID'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

--application/shared_components/logic/application_items/temp_plandatum
 
begin
 
wwv_flow_api.create_flow_item (
  p_id => 5565432552655346 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_name => 'TEMP_PLANDATUM'
 ,p_scope => 'APP'
 ,p_data_type => 'VARCHAR'
 ,p_is_persistent => 'Y'
 ,p_protection_level => 'N'
  );
 
end;
/

prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/standard/register1
wwv_flow_api.create_tab (
  p_id=> 7167906233739576 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 1,
  p_tab_name=> 'register1',
  p_tab_text => '&P1_TAB1_KATEGORIE_TEXT.',
  p_tab_step => 1,
  p_tab_also_current_for_pages => '1',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab1_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/register2
wwv_flow_api.create_tab (
  p_id=> 7364024661108873 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 2,
  p_tab_name=> 'Register2',
  p_tab_text => '&P1_TAB2_KATEGORIE_TEXT.',
  p_tab_step => 2,
  p_tab_also_current_for_pages => '2',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab2_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/register3
wwv_flow_api.create_tab (
  p_id=> 2285906171982950 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 3,
  p_tab_name=> 'Register3',
  p_tab_text => '&P1_TAB3_KATEGORIE_TEXT.',
  p_tab_step => 3,
  p_tab_also_current_for_pages => '3',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab3_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/register4
wwv_flow_api.create_tab (
  p_id=> 3825506093789421 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 4,
  p_tab_name=> 'Register4',
  p_tab_text => '&P1_TAB4_KATEGORIE_TEXT.',
  p_tab_step => 4,
  p_tab_also_current_for_pages => '4',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab4_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/register5
wwv_flow_api.create_tab (
  p_id=> 3885132721194485 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 5,
  p_tab_name=> 'REGISTER5',
  p_tab_text => '&P1_TAB5_KATEGORIE_TEXT.',
  p_tab_step => 5,
  p_tab_also_current_for_pages => '5',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab5_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/register6
wwv_flow_api.create_tab (
  p_id=> 3911514254681226 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 6,
  p_tab_name=> 'REGISTER6',
  p_tab_text => '&P1_TAB6_KATEGORIE_TEXT.',
  p_tab_step => 6,
  p_tab_also_current_for_pages => '6',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab6_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/register7
wwv_flow_api.create_tab (
  p_id=> 3912326374684759 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 7,
  p_tab_name=> 'REGISTER7',
  p_tab_text => '&P1_TAB7_KATEGORIE_TEXT.',
  p_tab_step => 7,
  p_tab_also_current_for_pages => '7',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab7_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/register8
wwv_flow_api.create_tab (
  p_id=> 3913109883689385 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 8,
  p_tab_name=> 'REGISTER8',
  p_tab_text => '&P1_TAB8_KATEGORIE_TEXT.',
  p_tab_step => 8,
  p_tab_also_current_for_pages => '8',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab8_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/register9
wwv_flow_api.create_tab (
  p_id=> 3913922003692885 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 9,
  p_tab_name=> 'REGISTER9',
  p_tab_text => '&P1_TAB9_KATEGORIE_TEXT.',
  p_tab_step => 9,
  p_tab_also_current_for_pages => '9',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab9_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/register10
wwv_flow_api.create_tab (
  p_id=> 3915313823699960 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 10,
  p_tab_name=> 'REGISTER10',
  p_tab_text => '&P1_TAB10_KATEGORIE_TEXT.',
  p_tab_step => 10,
  p_tab_also_current_for_pages => '10',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab10_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_labortabelle2
wwv_flow_api.create_tab (
  p_id=> 4833225825776025 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 31,
  p_tab_name=> 'T_LABORTABELLE2',
  p_tab_text => '&P31_TAB31_KATEGORIE_TEXT.',
  p_tab_step => 31,
  p_tab_also_current_for_pages => '31',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p31_tab31_kategorie_id));'||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_labor3
wwv_flow_api.create_tab (
  p_id=> 4853002413031668 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 32,
  p_tab_name=> 'T_LABOR3',
  p_tab_text => '&P31_TAB32_KATEGORIE_TEXT.',
  p_tab_step => 32,
  p_tab_also_current_for_pages => '32',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p31_tab32_kategorie_id));'||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_lab
wwv_flow_api.create_tab (
  p_id=> 4862725411045467 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 33,
  p_tab_name=> 'T_LAB',
  p_tab_text => '&P31_TAB33_KATEGORIE_TEXT.',
  p_tab_step => 33,
  p_tab_also_current_for_pages => '33',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p31_tab33_kategorie_id));'||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_p31_tab34_kategorie_text
wwv_flow_api.create_tab (
  p_id=> 4872903091061578 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 34,
  p_tab_name=> 'T_&P31_TAB34_KATEGORIE_TEXT.',
  p_tab_text => '&P31_TAB34_KATEGORIE_TEXT.',
  p_tab_step => 34,
  p_tab_also_current_for_pages => '34',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p31_tab34_kategorie_id));'||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_p31_tab35_kategorie_text
wwv_flow_api.create_tab (
  p_id=> 4881510332066751 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 35,
  p_tab_name=> 'T_&P31_TAB35_KATEGORIE_TEXT.',
  p_tab_text => '&P31_TAB35_KATEGORIE_TEXT.',
  p_tab_step => 35,
  p_tab_also_current_for_pages => '35',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p31_tab35_kategorie_id));'||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/anzeige
wwv_flow_api.create_tab (
  p_id=> 5154713734112979 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 90,
  p_tab_name=> 'Anzeige',
  p_tab_text => '&P1_TAB90_KATEGORIE_TEXT.',
  p_tab_step => 90,
  p_tab_also_current_for_pages => '90',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab90_kategorie_id));'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_tab91kategorietext
wwv_flow_api.create_tab (
  p_id=> 5295910245244575 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 91,
  p_tab_name=> 'T_TAB91KATEGORIETEXT',
  p_tab_text => '&P1_TAB91_KATEGORIE_TEXT.',
  p_tab_step => 91,
  p_tab_also_current_for_pages => '91',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   IF :FAS_AUFGERUFEN_VON != ''BETREUER'' THEN'||unistr('\000a')||
'      RETURN FALSE;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab91_kategorie_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_p1tab95kategorietext
wwv_flow_api.create_tab (
  p_id=> 5822522526212523 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 111,
  p_tab_name=> 'T_P1TAB95KATEGORIETEXT.',
  p_tab_text => '&P1_TAB95_KATEGORIE_TEXT.',
  p_tab_step => 95,
  p_tab_also_current_for_pages => '95',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'BEGIN'||unistr('\000a')||
'   IF :fas_aufgerufen_von = ''PIS'' THEN  -- Kurhaus'||unistr('\000a')||
'      RETURN FALSE;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      RETURN (frgbg_s.check_tab_anzeigen(:p1_pergebnis_id,'||unistr('\000a')||
'                                      :p1_tab95_kategorie_id));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab1_kategorie
wwv_flow_api.create_tab (
  p_id=> 5883227311665310 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 10,
  p_tab_name=> 'TAB1_kategorie',
  p_tab_text => '&P201_TAB1_KATEGORIE_TEXT.',
  p_tab_step => 201,
  p_tab_also_current_for_pages => '201',
  p_tab_parent_tabset=>'',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab2_kategorie
wwv_flow_api.create_tab (
  p_id=> 5890518138700535 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 20,
  p_tab_name=> 'TAB2_kategorie',
  p_tab_text => '&P201_TAB2_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '202',
  p_tab_parent_tabset=>'',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab3_kategorie
wwv_flow_api.create_tab (
  p_id=> 5914617764823404 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 30,
  p_tab_name=> 'TAB3_KATEGORIE',
  p_tab_text => '&P201_TAB3_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB3_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab4_kategorie
wwv_flow_api.create_tab (
  p_id=> 5916715601841662 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 40,
  p_tab_name=> 'TAB4_KATEGORIE',
  p_tab_text => '&P201_TAB4_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB4_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab5_kategorie
wwv_flow_api.create_tab (
  p_id=> 5917521142843293 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 50,
  p_tab_name=> 'TAB5_KATEGORIE',
  p_tab_text => '&P201_TAB5_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB5_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab6_kategorie
wwv_flow_api.create_tab (
  p_id=> 5918326683844901 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 60,
  p_tab_name=> 'TAB6_KATEGORIE',
  p_tab_text => '&P201_TAB6_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB6_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab7_kategorie
wwv_flow_api.create_tab (
  p_id=> 5919100495846784 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 70,
  p_tab_name=> 'TAB7_KATEGORIE',
  p_tab_text => '&P201_TAB7_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB7_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab8_kategorie
wwv_flow_api.create_tab (
  p_id=> 5920106382848520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 80,
  p_tab_name=> 'TAB8_KATEGORIE',
  p_tab_text => '&P201_TAB8_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB8_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab9_kategorie
wwv_flow_api.create_tab (
  p_id=> 5921014347850807 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 90,
  p_tab_name=> 'TAB9_KATEGORIE',
  p_tab_text => '&P201_TAB9_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB9_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab10_kategorie
wwv_flow_api.create_tab (
  p_id=> 5926409892877921 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 100,
  p_tab_name=> 'TAB10_KATEGORIE',
  p_tab_text => '&P201_TAB10_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB10_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/tab90_kategorie
wwv_flow_api.create_tab (
  p_id=> 5927923576919684 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 110,
  p_tab_name=> 'TAB90_KATEGORIE',
  p_tab_text => '&P201_TAB90_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB90_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_p201tab91kategorietext
wwv_flow_api.create_tab (
  p_id=> 6036703862541470 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'T_TS3',
  p_tab_sequence=> 130,
  p_tab_name=> 'T_P201TAB91KATEGORIETEXT.',
  p_tab_text => '&P201_TAB91_KATEGORIE_TEXT.',
  p_tab_step => 202,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_tab_plsql_condition=>'P201_TAB91_KATEGORIE_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_tab_comment  => '');
 
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/parent/t_ts2
wwv_flow_api.create_toplevel_tab (
  p_id=> 5358510427117004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'ts2',
  p_tab_sequence=> 20,
  p_tab_name  => 'T_TS2',
  p_tab_text  => 'ts2',
  p_tab_target=> 'f?p=102:110:&SESSION.:',
  p_current_on_tabset=> 'ts2',
  p_tab_comment=> '');
 
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/lov_therapeuten
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5616022604440135 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOV_THERAPEUTEN',
  p_lov_query=> 'select p.suchname||'', ''||p.suchadresse a,  p.personenstamm_id b'||unistr('\000a')||
'from v_perslisten_betreuer p'||unistr('\000a')||
'where p.personenstamm_id_betreuer = :fas_identitaet_persstamm_id'||unistr('\000a')||
'  and p.personenstamm_id is not null'||unistr('\000a')||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p301_zeile_pro_seite_melden
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2413412763729101 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P301_Zeile pro Seite melden',
  p_lov_query=> '.'||to_char(2413412763729101 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2413714693729106 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2413923492729109 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2414104196729109 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2414325301729109 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2414510834729109 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2414714183729109 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2414925542729109 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2415117257729109 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2415305227729110 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2415525108729110 + wwv_flow_api.g_id_offset,
  p_lov_id=>2413412763729101 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
wwv_flow_api.create_page_group(
  p_id=>3103530937219435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_group_name=>'Alle_Seiten',
  p_group_desc=>'');
 
null;
 
end;
/

 
--application/pages/page_00000
prompt  ...PAGE 0: 0
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 0
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_name => '0'
 ,p_step_title => '0'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20141031145231'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_HINWEISTEXT.'||unistr('\000a')||
'';

wwv_flow_api.create_page_plug (
  p_id=> 2974223555552243 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 0,
  p_plug_name=> '&P1_HINWEISTITEL.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_1',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':APP_PAGE_ID in (1,2,3,4,5,6,7,8,9,10,31,32,33,34,35,90,91,95) AND :P1_HINWEISTEXT is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT x.ID ID,'||unistr('\000a')||
'       x.FAS_APP_MENU_ID PID,'||unistr('\000a')||
'       x.BEZEICHNUNG NAME,'||unistr('\000a')||
'       CASE substr(x.URL,1,4) when ''f?p='''||unistr('\000a')||
'       THEN APEX_UTIL.PREPARE_URL(frgbg_t.replace_var_in_wert(x.URL))'||unistr('\000a')||
'       ELSE ''#'''||unistr('\000a')||
'       END link,'||unistr('\000a')||
'       level'||unistr('\000a')||
'--from fas_app_menus x'||unistr('\000a')||
'--where x.id in'||unistr('\000a')||
'from (select distinct b.id,b.FAS_APP_MENU_ID,'||unistr('\000a')||
'             NVL(frgbg_s.holen_uebersetzung(b.bezeichnung_text_id,:fas_sprache_id),b';

s:=s||'.BEZEICHNUNG ) bezeichnung, '||unistr('\000a')||
'             b.URL,b.sortierung    -- Gesamthierarchie mit Oberelemente mit zugriffbaren Blattelementen: von unten nach oben LOOP'||unistr('\000a')||
'      FROM "FAS_APP_MENUS" b'||unistr('\000a')||
'      WHERE b.app_id = :APP_ID'||unistr('\000a')||
'        and b.aktiv in (1,2)'||unistr('\000a')||
'      START WITH b.ID in (SELECT m.id     -- alle zugreifbaren Blattelemente'||unistr('\000a')||
'                          from fas_app_menus m'||unistr('\000a')||
'                          WH';

s:=s||'ERE m.id not in (SELECT d.fas_app_menu_id       -- Oberelemente'||unistr('\000a')||
'                                             from fas_app_menus d'||unistr('\000a')||
'                                             WHERE d.app_id = :app_id'||unistr('\000a')||
'                                               and d.satz_kennzeichen is null'||unistr('\000a')||
'                                               and d.fas_app_menu_id is not null'||unistr('\000a')||
'                                         ';

s:=s||'   )'||unistr('\000a')||
'                            and m.page_id is not null'||unistr('\000a')||
'                            and m.app_id = :APP_ID'||unistr('\000a')||
'                            and m.SATZ_KENNZEICHEN is null'||unistr('\000a')||
'                            --  Aktuelle Page soll nicht im Menü auftauchen wg. verhindern doppeltem Aufruf'||unistr('\000a')||
'                            and m.page_id != :APP_PAGE_ID --Klappt merkwürdigerweise in APP 118 nicht ohne UNION s.u.'||unistr('\000a')||
'     ';

s:=s||'                       -- Zugriffsberechtigung inkl. Auswertung aktiv-Flag'||unistr('\000a')||
'                            and frgbg_t.CHECK_FAS_APP_ZUGRIFF(:FAS_LOGIN_PERSONENSTAMM_ID,:FAS_IDENTITAET_PERSSTAMM_ID,m.app_id,m.page_id,:FAS_AUFGERUFEN_VON) > 0'||unistr('\000a')||
'                            -- Menüpunkt überhaupt auf akt. Seite anzeigen'||unistr('\000a')||
'                            and (m.menu_visible_page_id is NULL OR instr(m.menu_visible';

s:=s||'_page_id,'';''||:APP_PAGE_ID||'';'') > 0)'||unistr('\000a')||
'                           )'||unistr('\000a')||
'       CONNECT BY PRIOR b.FAS_APP_MENU_ID = b.ID          -- von unten nach oben'||unistr('\000a')||
'              and prior b.app_id = :APP_ID'||unistr('\000a')||
'       UNION -- NEI 25.10.13 muss sein damit "and m.page_id != :APP_PAGE_ID" auch in 118 klappt, das Plugin sein sonst das Menü nicht in allen Fällen richtig aufzubauen'||unistr('\000a')||
'       SELECT -1,null,'''',''#'',9000000'||unistr('\000a')||
'   ';

s:=s||'    from dual'||unistr('\000a')||
'      ) x'||unistr('\000a')||
'START WITH x.FAS_APP_MENU_ID is null'||unistr('\000a')||
'CONNECT BY PRIOR x.ID=x.FAS_APP_MENU_ID        -- von oben nach unten'||unistr('\000a')||
'order siblings by x.SORTIERUNG';

wwv_flow_api.create_page_plug (
  p_id=> 3836307103827346 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 0,
  p_plug_name=> 'Menü',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'PLUGIN_COM.JWILSON.APEX.DROP_MENU',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':APP_PAGE_ID not in (100,101,121,122,123,124  /* Login-Seiten */'||unistr('\000a')||
'                     ,106                     /* PW anfordern vor Login */'||unistr('\000a')||
'                     ,102,103,105,104,215,134,204,306,307,999,98,99,550,995 '||unistr('\000a')||
'                      ,97,328, 403,152 /* Alle Popups */'||unistr('\000a')||
'                    )',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_attribute_01=> '0',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<script type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
'/* Lädt das "Lade-Icon" vor. Dynamic Action hat nicht funktioniert, daher der direkte Eintrag in eine HTML Region */'||unistr('\000a')||
'var iconImage = new Image();'||unistr('\000a')||
'iconImage.src = "#IMAGE_PREFIX#themes/&FAS_THEME_NAME./ajax-loader.gif";'||unistr('\000a')||
'-->'||unistr('\000a')||
'</script>'||unistr('\000a')||
''||unistr('\000a')||
'<style type="text/css">   '||unistr('\000a')||
'    #AjaxLoadingBG .AjaxLoading{'||unistr('\000a')||
'         padding:5px;'||unistr('\000a')||
'         font-size:18px;'||unistr('\000a')||
'         width:200px;'||unistr('\000a')||
'';

s:=s||'         color:black;'||unistr('\000a')||
'         text-align:center;'||unistr('\000a')||
'         position:absolute;'||unistr('\000a')||
'         top:100px;'||unistr('\000a')||
'         left: 300px;'||unistr('\000a')||
'         border:2px solid #666;'||unistr('\000a')||
'         background-color:#FFF;'||unistr('\000a')||
'    }'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'#AjaxLoadingBG.parent { '||unistr('\000a')||
'  position:absolute;'||unistr('\000a')||
'  color: #fff;'||unistr('\000a')||
'  height: 500px;'||unistr('\000a')||
'  width: 500px;'||unistr('\000a')||
'  padding: 20px;'||unistr('\000a')||
'  margin-right: 10px;'||unistr('\000a')||
'  z-index:1000;'||unistr('\000a')||
'  display:none;'||unistr('\000a')||
'  width:100%;'||unistr('\000a')||
'  height:200px;'||unistr('\000a')||
'}'||unistr('\000a')||
''||unistr('\000a')||
'.colorA { ';

s:=s||'background: white; }'||unistr('\000a')||
'.colorB { background: #668; }'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'/* partial opacity hack: configuration */'||unistr('\000a')||
'#AjaxLoadingBG .opacity { '||unistr('\000a')||
'	opacity: 0.5;		/* modern browser */'||unistr('\000a')||
'	-moz-opacity: 0.5;	/* older Mozilla browser */'||unistr('\000a')||
'	-ms-filter:"progid:DXImageTransform.Microsoft.Alpha(Opacity=50)"; /* IE8 in Standard Compliant Mode */'||unistr('\000a')||
'	filter:alpha(opacity=50); /* IE5.x -7.0 */'||unistr('\000a')||
'} '||unistr('\000a')||
''||unistr('\000a')||
'/* partial opacity hack, part I: Don''t ch';

s:=s||'ange the following properties! */'||unistr('\000a')||
'#AjaxLoadingBG.opacity-wrapper * {'||unistr('\000a')||
'	position:relative;'||unistr('\000a')||
'}'||unistr('\000a')||
''||unistr('\000a')||
'#AjaxLoadingBG .opacity { '||unistr('\000a')||
'	/* partial opacity hack, part II: Don''t change the following properties! */'||unistr('\000a')||
'	width: 100%;'||unistr('\000a')||
'	height: 100%;'||unistr('\000a')||
'	position:absolute;'||unistr('\000a')||
'	top:0;'||unistr('\000a')||
'	left:0;'||unistr('\000a')||
'} '||unistr('\000a')||
''||unistr('\000a')||
'/* partial opacity hack, part III: IE6 support */'||unistr('\000a')||
'* html #AjaxLoadingBG.opacity-wrapper { '||unistr('\000a')||
'	overflow:hidden;'||unistr('\000a')||
'}'||unistr('\000a')||
'* html #AjaxLoadingBG .';

s:=s||'opacity { '||unistr('\000a')||
'	width: 2000px; '||unistr('\000a')||
'	height: 2000px;'||unistr('\000a')||
'} '||unistr('\000a')||
'</style>'||unistr('\000a')||
''||unistr('\000a')||
'<div id="AjaxLoadingBGShow"></div>'||unistr('\000a')||
'<div id="AjaxLoadingBG" class="parent opacity-wrapper" style="">'||unistr('\000a')||
'  <div class="colorA opacity"></div>'||unistr('\000a')||
'  <div class="AjaxLoading" style="">...waiting...<br /><img src="#IMAGE_PREFIX#themes/&FAS_THEME_NAME./ajax-loader.gif" id="wait" /></div>'||unistr('\000a')||
'</div>';

wwv_flow_api.create_page_plug (
  p_id=> 7538514655196520 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 0,
  p_plug_name=> 'Loading Icon',
  p_region_name=>'',
  p_region_attributes=> 'style="position:absolute; left:-10px; top:-10px"',
  p_escape_on_http_output=>'Y',
  p_plug_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 80,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_1',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':APP_PAGE_ID in(202)',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<iframe id="jobliste_iframe" scrolling="no" src ="f?p=&APP_ID.:550:&SESSION." style="height:100%; width:100%; border:0px; overflow:hidden; border-radius: 6px;">'||unistr('\000a')||
'</iframe>'||unistr('\000a')||
''||unistr('\000a')||
'';

wwv_flow_api.create_page_plug (
  p_id=> 8613807162770445 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 0,
  p_plug_name=> 'FB App-Jobs',
  p_region_name=>'',
  p_escape_on_http_output=>'Y',
  p_plug_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 110,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'EXISTS',
  p_plug_display_when_condition => 'select  a.ID'||unistr('\000a')||
'from FRGBG.APP_JOBS a'||unistr('\000a')||
'where'||unistr('\000a')||
''||unistr('\000a')||
'  (:APP_PAGE_ID < 100 or :APP_PAGE_ID >= 130) '||unistr('\000a')||
'  and :APP_PAGE_ID not in(215,98,550,97,328,403,152)'||unistr('\000a')||
'  and app_id = :APP_ID'||unistr('\000a')||
'  and USER_ACCOUNT = :APP_USER'||unistr('\000a')||
'  and a.MUTDAT > sysdate - 24/60 -- Maximal 60 Minuten halten'||unistr('\000a')||
'  and a.satz_kennzeichen is null'||unistr('\000a')||
'  and a.visible = 1'||unistr('\000a')||
'  and (a.STATUS_ID = 1 and a.JOB_ID in (select JOB from dba_jobs_running) or a.STATUS_ID <> 1)',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> '<div id="jobliste" style="position:absolute; top:40px; right:10px; width:350px;  background-color:#404040; padding:0px 0px 0px 10px; border-radius: 6px; border:1px solid #000; height:85px;">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8680917818736578 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 0,
  p_plug_name=> 'fragebogen_upload',
  p_region_name=>'',
  p_escape_on_http_output=>'Y',
  p_plug_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 70,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => '(:APP_PAGE_ID >= 2 and :APP_PAGE_ID <= 10)'||unistr('\000a')||
'or '||unistr('\000a')||
'(:APP_PAGE_ID >= 31 and :APP_PAGE_ID <=35)',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> '<div style="display:block">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8681128688736578 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 0,
  p_name=>'P0_FB_UPLOAD_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 8680917818736578+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8681311747736579 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 0,
  p_name=>'P0_FB_UPLOAD_REFESH',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 8680917818736578+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 4000,
  p_cHeight=> 4,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8681506076736580 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 0,
  p_name=>'P0_TIME_PICKER_CONF',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 8680917818736578+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'replace(replace(frgbg_s.holen_uebersetzung(9728,:FAS_SPRACHE_ID),chr(10),''''),chr(13),'''')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8681701812736580 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 0,
  p_name=>'P0_DATE_PICKER_CONF',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 8680917818736578+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'replace(replace(frgbg_s.holen_uebersetzung(9729,:FAS_SPRACHE_ID),chr(10),''''),chr(13),'''')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8681912977736580 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 0,
  p_name=>'P0_FB_UPLOAD_DEL_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 8680917818736578+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select frgbg_s.holen_uebersetzung(9174,:FAS_SPRACHE_ID) from dual',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8682127090736581 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 0,
  p_name=>'P0_FB_UPLOAD_CONFIRM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 8680917818736578+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'0',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8682309658736581 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 0,
  p_name=>'P0_UPLOAD_DOWNLOAD_LINK',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 8680917818736578+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select APEX_UTIL.PREPARE_URL(''f?p='' || :APP_ID || '':98:&SESSION.:DOWNLOAD_FILE:NO::'') as url from dual',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 7638021471825915 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_name => 'Positioniere Ajax Loading Icon'
 ,p_event_sequence => 70
 ,p_triggering_element_type => 'JQUERY_SELECTOR'
 ,p_triggering_element => '#AjaxLoadingBGShow'
 ,p_bind_type => 'bind'
 ,p_bind_event_type => 'click'
  );
wwv_flow_api.create_page_da_action (
  p_id => 7638328765825929 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 7638021471825915 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_JAVASCRIPT_CODE'
 ,p_attribute_01 => '    '||unistr('\000a')||
'$(''#AjaxLoadingBG'').find(".AjaxLoading").css({      '||unistr('\000a')||
'          "left": Math.floor($(window).width() * 0.45) + "px",'||unistr('\000a')||
'          "top": Math.floor($(window).height() * 0.45) + "px"   '||unistr('\000a')||
'     });'||unistr('\000a')||
''||unistr('\000a')||
'$(''#AjaxLoadingBG.parent'').css({      '||unistr('\000a')||
'          "width": ($(window).width() + 10) + "px",'||unistr('\000a')||
'          "height": ($(window).height() + 10) + "px",'||unistr('\000a')||
'          "display": "block",'||unistr('\000a')||
'          "bottom": "0px",'||unistr('\000a')||
'          "right": "0px"'||unistr('\000a')||
'     });'||unistr('\000a')||
'     '||unistr('\000a')||
''||unistr('\000a')||
'$(''#AjaxLoadingBG'').show();'
 ,p_stop_execution_on_error => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 8682527861739477 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_name => 'Merke Fokus auf FB Upload Feld'
 ,p_event_sequence => 80
 ,p_triggering_element_type => 'JQUERY_SELECTOR'
 ,p_triggering_element => '.upl_container'
 ,p_bind_type => 'bind'
 ,p_bind_event_type => 'click'
 ,p_display_when_cond => 'FRGBG_S.CHECK_PAGE_IST_FB_TAB(:APP_PAGE_ID)'||unistr('\000a')||
''
  );
wwv_flow_api.create_page_da_action (
  p_id => 8682822433739478 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8682527861739477 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'Y'
 ,p_action => 'NATIVE_SET_VALUE'
 ,p_affected_elements_type => 'JQUERY_SELECTOR'
 ,p_affected_elements => '#P0_FB_UPLOAD_ID'
 ,p_attribute_01 => 'JAVASCRIPT_EXPRESSION'
 ,p_attribute_05 => '/* liefert den ID-String (Hidden-Feld) der alle Infos bezüglich der FB-Antwort enthält */'||unistr('\000a')||
'$(this.triggeringElement).find(''input[name=\"f01\"][id=\"upl_hi_'' + $(this.triggeringElement).attr(''id'').substr(6) + ''\"]'').val()'||unistr('\000a')||
''
 ,p_attribute_09 => 'N'
 ,p_stop_execution_on_error => 'Y'
 ,p_wait_for_result => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 8682926260748550 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_name => 'Öffne FB Upload Modal Fenster'
 ,p_event_sequence => 90
 ,p_triggering_element_type => 'JQUERY_SELECTOR'
 ,p_triggering_element => '.upl_button'
 ,p_bind_type => 'bind'
 ,p_bind_event_type => 'click'
 ,p_display_when_cond => 'FRGBG_S.CHECK_PAGE_IST_FB_TAB(:APP_PAGE_ID)'||unistr('\000a')||
''
  );
wwv_flow_api.create_page_da_action (
  p_id => 8683608605748551 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8682926260748550 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 5
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_SET_VALUE'
 ,p_affected_elements_type => 'JQUERY_SELECTOR'
 ,p_affected_elements => '#P0_FB_UPLOAD_ID'
 ,p_attribute_01 => 'JAVASCRIPT_EXPRESSION'
 ,p_attribute_05 => '/* liefert den ID-String (Hidden-Feld) der alle Infos bezüglich der FB-Antwort enthält */'||unistr('\000a')||
'/* Das ID Feld muss hier gesetzt werden, da nicht garantiert werden kann, das die Merke Dynamic Action vor dieser hier ausgelöst wird. Grund bisher unbekannt */'||unistr('\000a')||
'$(this.triggeringElement).parent().find(''input[name=\"f01\"][id=\"upl_hi_'' + $(this.triggeringElement).parent().attr(''id'').substr(6) + ''\"]'').val()'
 ,p_attribute_09 => 'N'
 ,p_stop_execution_on_error => 'Y'
 ,p_wait_for_result => 'Y'
 );
wwv_flow_api.create_page_da_action (
  p_id => 8683425168748551 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8682926260748550 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 6
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_EXECUTE_PLSQL_CODE'
 ,p_attribute_01 => 'begin'||unistr('\000a')||
'  :P98_ID := :P0_FB_UPLOAD_ID;'||unistr('\000a')||
'end;'
 ,p_attribute_02 => 'P0_FB_UPLOAD_ID'
 ,p_stop_execution_on_error => 'Y'
 ,p_wait_for_result => 'Y'
 );
wwv_flow_api.create_page_da_action (
  p_id => 8683203024748551 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8682926260748550 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'PLUGIN_COM_SKILLBUILDERS_MODAL_PAGE'
 ,p_attribute_01 => 'Upload'
 ,p_attribute_02 => 'STATIC'
 ,p_attribute_03 => 'f?p=&APP_ID.:98:&APP_SESSION.:::::'
 ,p_attribute_06 => '#MESSAGE.t1success'
 ,p_attribute_07 => 'STATIC_PX'
 ,p_attribute_08 => '200'
 ,p_attribute_09 => '700'
 ,p_stop_execution_on_error => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 8683701111750713 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_name => 'Schließe FB Upload Modal Fenster'
 ,p_event_sequence => 100
 ,p_triggering_element_type => 'DOM_OBJECT'
 ,p_triggering_element => 'document'
 ,p_bind_type => 'bind'
 ,p_bind_event_type => 'PLUGIN_COM_SKILLBUILDERS_MODAL_PAGE|DYNAMIC ACTION|modalpageautoclose'
 ,p_da_event_comment => 'Keine Condition, da das FAS dadurch extrem verlangsamt wird'||unistr('\000a')||
'FRGBG_S.CHECK_PAGE_IST_FB_TAB(:APP_PAGE_ID)'
  );
wwv_flow_api.create_page_da_action (
  p_id => 8684031048750715 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8683701111750713 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_JAVASCRIPT_CODE'
 ,p_attribute_01 => 'v_message = this.data.$modalPageCloseObject;'||unistr('\000a')||
'$(''.t1messages'').after( v_message );'||unistr('\000a')||
'$(''#MESSAGE.t1success'').delay(2000).fadeOut(2000);'
 ,p_stop_execution_on_error => 'Y'
 );
wwv_flow_api.create_page_da_action (
  p_id => 8684201765750716 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8683701111750713 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 20
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_EXECUTE_PLSQL_CODE'
 ,p_attribute_01 => 'declare'||unistr('\000a')||
'begin'||unistr('\000a')||
''||unistr('\000a')||
' -- Hol den Inhalt des Uploadfeldes'||unistr('\000a')||
' :P0_FB_UPLOAD_REFESH := FRGBG_S.ERZEUGEN_FELDER_UPLOAD('||unistr('\000a')||
'      p_pergebnis_id   => :P1_PERGEBNIS_ID'||unistr('\000a')||
'      , p_fantwort_id  => to_number(substr(:P0_FB_UPLOAD_ID,26,8))'||unistr('\000a')||
'      , p_sprache_id   => :FAS_SPRACHE_ID'||unistr('\000a')||
' );'||unistr('\000a')||
'end;'
 ,p_attribute_02 => 'P0_FB_UPLOAD_ID'
 ,p_attribute_03 => 'P0_FB_UPLOAD_REFESH'
 ,p_attribute_04 => 'N'
 ,p_stop_execution_on_error => 'Y'
 ,p_wait_for_result => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 8684307691752615 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_name => 'Lösche FB Upload'
 ,p_event_sequence => 110
 ,p_triggering_element_type => 'JQUERY_SELECTOR'
 ,p_triggering_element => '.upl_delete_link'
 ,p_bind_type => 'live'
 ,p_bind_event_type => 'click'
 ,p_display_when_cond => 'FRGBG_S.CHECK_PAGE_IST_FB_TAB(:APP_PAGE_ID)'||unistr('\000a')||
''
  );
wwv_flow_api.create_page_da_action (
  p_id => 8684811343752615 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8684307691752615 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_SET_VALUE'
 ,p_affected_elements_type => 'JQUERY_SELECTOR'
 ,p_affected_elements => '#P0_FB_UPLOAD_CONFIRM'
 ,p_attribute_01 => 'JAVASCRIPT_EXPRESSION'
 ,p_attribute_05 => 'confirm($v(''P0_FB_UPLOAD_DEL_TEXT'')) ? 1 : 0'
 ,p_attribute_09 => 'N'
 ,p_stop_execution_on_error => 'Y'
 ,p_wait_for_result => 'Y'
 );
wwv_flow_api.create_page_da_action (
  p_id => 8684626950752615 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8684307691752615 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 20
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_EXECUTE_PLSQL_CODE'
 ,p_attribute_01 => 'declare'||unistr('\000a')||
'  v_display_only number;'||unistr('\000a')||
'  v_personenstamm_id number;'||unistr('\000a')||
'  v_fragebogen_id number;'||unistr('\000a')||
'  v_frage_id number;'||unistr('\000a')||
'  v_fantwort_id number;'||unistr('\000a')||
'  v_persantwort_id number;'||unistr('\000a')||
''||unistr('\000a')||
'  v_fehlermeldung varchar2(2000);'||unistr('\000a')||
'  v_fehlernummer number;'||unistr('\000a')||
'  v_fehler exception;'||unistr('\000a')||
'  e_ERROR_D exception;'||unistr('\000a')||
'  PRAGMA EXCEPTION_INIT(e_ERROR_D,-20000);'||unistr('\000a')||
'  v_prod_id number;'||unistr('\000a')||
'begin'||unistr('\000a')||
'  if(:P0_FB_UPLOAD_ID is not null) then'||unistr('\000a')||
''||unistr('\000a')||
'    Mel.P(''lösche FB Upload id: '' || :P0_FB_UPLOAD_ID,v_prod_id,''TEST'');'||unistr('\000a')||
''||unistr('\000a')||
'    FRGBG_S.HOLEN_IDS('||unistr('\000a')||
'     P_ID                 => :P0_FB_UPLOAD_ID'||unistr('\000a')||
'     ,P_PERSONENSTAMM_ID  => v_personenstamm_id'||unistr('\000a')||
'     ,P_FRAGEBOGEN_ID     => v_fragebogen_id'||unistr('\000a')||
'     ,P_FRAGE_ID          => v_frage_id'||unistr('\000a')||
'     ,P_FANTWORT_ID       => v_fantwort_id'||unistr('\000a')||
'     ,P_PERSANTWORT_ID    => v_persantwort_id'||unistr('\000a')||
'    );'||unistr('\000a')||
''||unistr('\000a')||
'    if(:P0_FB_UPLOAD_CONFIRM = ''1'') then'||unistr('\000a')||
''||unistr('\000a')||
'      v_display_only :=  NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY('||unistr('\000a')||
'            p_pergebnis_id                  => :P1_PERGEBNIS_ID,'||unistr('\000a')||
'            p_FANTWORT_ID                   => v_fantwort_id'||unistr('\000a')||
'      ),0);'||unistr('\000a')||
''||unistr('\000a')||
'      if(v_display_only = 1) then'||unistr('\000a')||
'          raise_application_error(-20000,frgbg_s.holen_uebersetzung(9171,:FAS_SPRACHE_ID));'||unistr('\000a')||
'      end if;'||unistr('\000a')||
''||unistr('\000a')||
'      begin'||unistr('\000a')||
'      delete from persantworten '||unistr('\000a')||
'      where'||unistr('\000a')||
'          fantwort_id = v_fantwort_id'||unistr('\000a')||
'          and pergebnis_id = :P1_PERGEBNIS_ID'||unistr('\000a')||
'          and frage_id = v_frage_id'||unistr('\000a')||
'          and fantwort_dokument_fas_id is not null;'||unistr('\000a')||
'      exception'||unistr('\000a')||
'      when others then'||unistr('\000a')||
'          v_fehlermeldung := ''Fehler beim Löschen der FB Antwort-Datei fantwort_id: '' || v_fantwort_id || '' pergebnis_id: '' || sqlerrm '||unistr('\000a')||
'             ||:P1_PERGEBNIS_ID;'||unistr('\000a')||
'          v_fehlernummer := -10;'||unistr('\000a')||
'          raise v_fehler;'||unistr('\000a')||
'      end;'||unistr('\000a')||
'     end if;'||unistr('\000a')||
''||unistr('\000a')||
'     -- Hol den Inhalt des Uploadfeldes'||unistr('\000a')||
'    :P0_FB_UPLOAD_REFESH := FRGBG_S.ERZEUGEN_FELDER_UPLOAD('||unistr('\000a')||
'      p_pergebnis_id   => :P1_PERGEBNIS_ID'||unistr('\000a')||
'      , p_fantwort_id  => v_fantwort_id'||unistr('\000a')||
'      , p_sprache_id   => :FAS_SPRACHE_ID'||unistr('\000a')||
'    );   '||unistr('\000a')||
'  end if;   '||unistr('\000a')||
''||unistr('\000a')||
'      '||unistr('\000a')||
'  '||unistr('\000a')||
'exception '||unistr('\000a')||
'  when v_fehler then'||unistr('\000a')||
'      Mel.P(v_fehlermeldung,v_prod_id,''ERROR'',''dynamic_action lösche DB Upload ['' || v_fehlernummer || ''] '' ||dbms_utility.format_error_backtrace);'||unistr('\000a')||
'      raise_application_error(-20000,frgbg_s.holen_uebersetzung(9173,:FAS_SPRACHE_ID));'||unistr('\000a')||
'  when e_ERROR_D then'||unistr('\000a')||
'      raise;'||unistr('\000a')||
'  when others then'||unistr('\000a')||
'      v_fehlermeldung := ''unbekannter Fehler in Dynamic Action aufgetreten '' || sqlerrm;'||unistr('\000a')||
'      v_fehlernummer := -999;'||unistr('\000a')||
'      Mel.P(v_fehlermeldung,v_prod_id,''ERROR'',''dynamic_action lösche DB Upload ['' || v_fehlernummer || ''] '' ||dbms_utility.format_error_backtrace);'||unistr('\000a')||
'      raise_application_error(-20000,frgbg_s.holen_uebersetzung(9173,:FAS_SPRACHE_ID));'||unistr('\000a')||
'end;'
 ,p_attribute_02 => 'P0_FB_UPLOAD_ID,P0_FB_UPLOAD_CONFIRM'
 ,p_attribute_03 => 'P0_FB_UPLOAD_REFESH'
 ,p_attribute_04 => 'N'
 ,p_stop_execution_on_error => 'Y'
 ,p_wait_for_result => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 8685018080755595 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_name => 'Aktualisiere FB Upload Feld'
 ,p_event_sequence => 120
 ,p_triggering_element_type => 'JQUERY_SELECTOR'
 ,p_triggering_element => '#P0_FB_UPLOAD_REFESH'
 ,p_triggering_condition_type => 'NOT_NULL'
 ,p_bind_type => 'live'
 ,p_bind_event_type => 'change'
  );
wwv_flow_api.create_page_da_action (
  p_id => 8685320480755596 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8685018080755595 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_JAVASCRIPT_CODE'
 ,p_attribute_01 => '/* ersetzt den Inhalt des Uploadfeldes nach dem Button (Enthält Links und Dateinamen) */'||unistr('\000a')||
'if($v(''P0_FB_UPLOAD_ID'') != null && $v(''P0_FB_UPLOAD_REFESH'') != null) {'||unistr('\000a')||
'   $(''div[id$="'' + parseInt($v(''P0_FB_UPLOAD_ID'').substr(26,7).trim()) + '||unistr('\000a')||
'     ''"][class="upl_sub_container"]'').replaceWith($v(''P0_FB_UPLOAD_REFESH''));'||unistr('\000a')||
''||unistr('\000a')||
'} else {'||unistr('\000a')||
' '||unistr('\000a')||
'}'
 ,p_stop_execution_on_error => 'Y'
 );
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_da_event (
  p_id => 8685425353757705 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_name => 'Download FB Upload Datei'
 ,p_event_sequence => 130
 ,p_triggering_element_type => 'JQUERY_SELECTOR'
 ,p_triggering_element => '.upl_download_link'
 ,p_bind_type => 'live'
 ,p_bind_event_type => 'click'
 ,p_display_when_cond => 'FRGBG_S.CHECK_PAGE_IST_FB_TAB(:APP_PAGE_ID)'||unistr('\000a')||
''
  );
wwv_flow_api.create_page_da_action (
  p_id => 8685907732757706 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8685425353757705 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 10
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_EXECUTE_PLSQL_CODE'
 ,p_attribute_01 => 'begin'||unistr('\000a')||
'  :P98_ID := :P0_FB_UPLOAD_ID;'||unistr('\000a')||
'end;'
 ,p_attribute_02 => 'P0_FB_UPLOAD_ID'
 ,p_stop_execution_on_error => 'Y'
 ,p_wait_for_result => 'Y'
 );
wwv_flow_api.create_page_da_action (
  p_id => 8685715951757706 + wwv_flow_api.g_id_offset
 ,p_flow_id => wwv_flow.g_flow_id
 ,p_page_id => 0
 ,p_event_id => 8685425353757705 + wwv_flow_api.g_id_offset
 ,p_event_result => 'TRUE'
 ,p_action_sequence => 20
 ,p_execute_on_page_init => 'N'
 ,p_action => 'NATIVE_JAVASCRIPT_CODE'
 ,p_attribute_01 => 'redirect($v(''P0_UPLOAD_DOWNLOAD_LINK'')); '
 ,p_stop_execution_on_error => 'Y'
 );
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 0
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00001
prompt  ...PAGE 1: PERSONENSTAMM
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 1
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'PERSONENSTAMM'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_welcome_text => '<script language="JavaScript1.1" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
'function check_checkbox(p_itemname,p_text)'||unistr('\000a')||
'{'||unistr('\000a')||
' var ip=document.getElementsByTagName(''INPUT'');'||unistr('\000a')||
' var ret=new Array();'||unistr('\000a')||
' var regexp=new RegExp(''^''+p_itemname+''_'');'||unistr('\000a')||
' var l_exist=0'||unistr('\000a')||
' for (var j=0;j<ip.length;j++) {'||unistr('\000a')||
'   if (ip[j].type=="checkbox" && ip[j].id && ip[j].id.match(regexp)) {'||unistr('\000a')||
'      if (ip[j].checked && ip[j].value==7) {'||unistr('\000a')||
'        alert(p_text);'||unistr('\000a')||
'        l_exist=1;'||unistr('\000a')||
'      }'||unistr('\000a')||
'    }   '||unistr('\000a')||
' }'||unistr('\000a')||
' //alert(''Hallo:''+l_exist);'||unistr('\000a')||
' if (l_exist==1 ) {'||unistr('\000a')||
' for (var j=0;j<ip.length;j++) {'||unistr('\000a')||
'   if (ip[j].type=="checkbox" && ip[j].id && ip[j].id.match(regexp)) {'||unistr('\000a')||
'      if (ip[j].checked && ip[j].value!=7) {'||unistr('\000a')||
'        //alert(''Die Etikettoption uncheck!''+ip[j].value);'||unistr('\000a')||
'        ip[j].checked=false;'||unistr('\000a')||
'       }'||unistr('\000a')||
'   }   '||unistr('\000a')||
' }'||unistr('\000a')||
' }'||unistr('\000a')||
'}'||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'||unistr('\000a')||
''
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'OLIVER.LEMM'
 ,p_last_upd_yyyymmddhh24miss => '20150917143643'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3170917966912078 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5558316633466960 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 7132411261793773 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1,
  p_plug_name=> '&P1_REGION_TITEL_MODUL_AUSW.',
  p_region_name=>'',
  p_escape_on_http_output=>'Y',
  p_plug_template=> 2890106833489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 15,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 7168017465739576 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1,
  p_plug_name=> '&P1_TAB1_KATEGORIE_TEXT.',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2885905427489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 9,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<div style="height: &FAS_SCROLLREGION_HEIGHT_MAX.px;max-width: 550px">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 7168101323739579 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1,
  p_button_sequence=> 10,
  p_button_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'') and 1=2',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4418712080947764 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1,
  p_button_sequence=> 15,
  p_button_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_button_name    => 'P1_PASSWORT_CHANGE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_PASSWORT_CHG.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:popUp2(''&P1_PREPARE_URL_PW.'',700,380);',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'UPPER(:P1_USER_ACCOUNT)= UPPER(:APP_USER) AND :p1_id IS NOT NULL and :fas_aufgerufen_von not in (''ANONYM'',''PIS'') and'||unistr('\000a')||
':fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 6263424651167846 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1,
  p_button_sequence=> 17,
  p_button_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Auswertung',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS'' and 1=2',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3956425705854839 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1,
  p_button_sequence=> 20,
  p_button_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_ID is not null and'||unistr('\000a')||
':fas_pers_aenderbar = 1',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 7168202772739579 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1,
  p_button_sequence=> 20,
  p_button_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(''&FAS_LOESCHABFRAGE_TEXT.'',''DELETE'');',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_ID IS NOT NULL AND :fas_aufgerufen_von not in (''ANONYM'',''PIS'') and'||unistr('\000a')||
':fas_pers_aenderbar = 1    /* Personendaten aenderbar */'||unistr('\000a')||
'/* NEI 18.12.09 abgeschaltet */',
  p_button_condition_type=> 'NEVER',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 7168305288739579 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1,
  p_button_sequence=> 30,
  p_button_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Ändern',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_ID is not null and'||unistr('\000a')||
':fas_pers_aenderbar = 1         /* Personendaten aenderbar */'||unistr('\000a')||
'and 1=2',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 7168415639739579 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1,
  p_button_sequence=> 40,
  p_button_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Erstellen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'P1_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3863110544715062 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1,
  p_button_sequence=> 50,
  p_button_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 7137105991886882 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1,
  p_button_sequence=> 80,
  p_button_plug_id => 7132411261793773+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE_MODUL_AUSW',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SAVE_MODUL_AUSW.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:apex.submit(''SAVE_MODUL_AUSW'');',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'FRGBG_S.FB_CHECK_AUSWERTUNG(:P1_PERGEBNIS_ID) = 0',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>5035532676610206 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:130:&SESSION.::&DEBUG.:1,110,140::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>7168202772739579+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> '/*:p1_satzkennzeichen IS NOT NULL AND :p1_abbrechen_zu_seite = 130 and*/'||unistr('\000a')||
' :fas_aufgerufen_von = ''BETREUER''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 14-SEP-2007 11:13 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>5048429287864750 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:1::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>7168202772739579+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 15,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> '/*:p1_satzkennzeichen IS NOT NULL AND :p1_abbrechen_zu_seite = 101 and*/'||unistr('\000a')||
':fas_aufgerufen_von in  (''KUNDE'',''ANONYM'')',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 14-SEP-2007 11:56 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>7377927488248635 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_ZURUECK_ZUR_SEITE.:&SESSION.::&DEBUG.:1,31,95::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>7168101323739579+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> '/*P1_AUFGERUFEN_VON is null*/ :fas_aufgerufen_von != ''PIS''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>4043121777310196 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:1:&SESSION.:OPT_CHANGE:&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 40,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':request = ''OPT_CHANGE''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 14-DEZ-2009 15:38 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>3864115355763817 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3863110544715062+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 50,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>4068613603679862 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:1:&SESSION.:HRV_MELDUNG:&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>4056729101749365+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 60,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 01-FEB-2013 11:47 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>5045305345829462 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 14-SEP-2007 11:50 by FRGBG');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1355311924442540 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_INFO',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 640,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1359107880649600 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_NULL_VALUE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1020,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => 'Der Regiontitel der FB-Seiten darf nicht leer sein => &P1_NULL_VALUE. mit NULL funktioniert');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2075910330746488 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BETREUER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 351,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'BETREUER',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2733927850382550 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_PREPARE_URL_PW',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 860,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Prepare Url Pw',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2979030067695646 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_FRAGEBOGEN_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 410,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3194309302340800 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB1_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 420,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab1_kategorie_id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3195319691343782 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB2_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 430,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab2_kategorie_id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3290318492507295 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB3_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 440,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab3 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3368016487880300 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB4_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 441,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab4 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3369102073885570 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB5_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 442,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab5 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3370332548894342 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB6_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 443,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab6 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3371113978898500 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB7_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 444,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab7 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3371924367901431 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB8_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 445,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab8 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3373208915906495 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB9_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 446,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab9 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3374021035909971 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB10_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 447,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab10 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3374831425913014 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB4_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 462,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab4 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3375411816916753 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB5_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 463,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab5 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3376219781919104 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB6_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 464,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab6 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3377000865923107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB8_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 466,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab8 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3377814371926946 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB7_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 465,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab7 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'S',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3378624761929954 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB9_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 467,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab9 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3379403767933389 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB10_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 468,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab10 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3498207273831328 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BL_ABBRECHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 560,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Abbrechen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3500412252842275 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BL_PASSWORT_CHG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 580,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> 'Passwort ändern',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Passwort Chg',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3503123727873960 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BL_SPEICHERN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 590,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default=> 'Speichern',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bl Speichern',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3745819296109300 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_FEHLER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 630,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3752310844383992 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_IDENT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 113,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'IDENT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3752520541386787 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TELEFON',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'TELEFON',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1  /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3752727813388867 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_MOBILTELEFON',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 165,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'MOBILTELEFON',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1  /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3752903010391215 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 270,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'BEMERKUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 22,
  p_cMaxlength=> 2000,
  p_cHeight=> 2,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 3,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3863409290724188 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BL_WEITER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 598,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 4000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3865103908959163 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_NEXT_PAGE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1030,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3873904446120082 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_REGION_TITEL_PWD_CHG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 601,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Region Titel Pwd Chg',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3937231409562379 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_FAX',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'FAX',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1   /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3937407299564910 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_URL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 168,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'URL',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1  /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4138806477547415 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_HINWEISTEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 940,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Hinweistext',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4139014442549803 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_HINWEISTITEL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 950,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Hinweistitel',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4215828152551194 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_EXTERN_VERWALTET',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1040,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'EXTERN_VERWALTET',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4824326998618604 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_REGION_TITEL_HILFETEXTE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 600,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Region Titel Hilfetexte',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4863927532683234 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_GEWICHT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 148,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_post_element_text=>'&#160;&#160;',
  p_source=>'GEWICHT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 3,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899910455489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_03 => 'right',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4864107231686897 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_GROESSE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 149,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_pre_element_text=>'&#160;',
  p_post_element_text=>'&#160;&#160;&#160;',
  p_source=>'GROESSE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 3,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899910455489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_03 => 'right',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5065908583464293 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_ERFUSER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 750,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'ERFUSER',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5109226169914171 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BEARB_MODUS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 770,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bearb Modus',
  p_source=>'BEARBEITEN',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5198507431696835 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB90_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 469,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5199223361701429 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB90_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 449,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5275405678063414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_REGION_TITEL_INFOTEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 602,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5287931682133195 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BL_VERWERFEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 592,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5292632708222651 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB91_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 470,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab91 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5294032493232068 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB91_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 450,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab91 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5332530397092546 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_AENDERBAR',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 830,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Aenderbar',
  p_source=>'AENDERBAR',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5342112857115681 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_REGION_TITEL_HRV',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 603,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Region Titel Hilfetexte',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5380021385462532 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BL_HRV_LADEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 597,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Auswertung',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5555801986330264 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_ZURUECK_ZUR_SEITE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1080,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'zurueck',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5626020269094190 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_ABMELDEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 960,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Abmelden',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5626402453565526 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_PERGEBNIS_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 680,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Persergebnis Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5626529020153535 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_MUTUSER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 760,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Mutuser',
  p_source=>'MUTUSER',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5684602003292204 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_PERSON',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 710,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Person',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5777303001656590 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB95_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 451,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab92 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5777513390659593 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB95_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 471,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab92 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5777724818662904 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB95_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 512,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'TAB92_KATEGORIE_ZEILEN',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5782508607837959 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_PAGE_AUSWERTUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1000,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page Auswertung',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5815017662548617 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_USER',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 720,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Pisuser',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => 'Bei externen Aufrufen wie z.B PIS kann hier der User angegeben werden, der die Erfassung durchführt, da externe Aufrufe immer mit einem Standard-User angemeldet  werden und so keine Zuordnung mehr für DB-Operationen möglich wäre. Der User wird beim Speichern der Antworten übergeben, falls dieser NULL ist wird der App-User genommen.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5928312667012412 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB1_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 500,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5928926865016565 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB2_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 501,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5929503794019332 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB3_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 502,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5930113490022110 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB4_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 503,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5931030459027023 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB5_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 504,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5931606002029395 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB6_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 505,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5932212582031343 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB7_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 506,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5934321371043287 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB8_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 507,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5934927604045135 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB9_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 508,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5935502801047410 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB10_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 509,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5936111113049796 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB90_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 510,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5936725658054039 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB91_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 511,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6268921644775642 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_NV_FRAGEBOGEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1010,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nv Fragebogen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6294900682299810 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB1_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 458,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab1 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6295221461305834 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB2_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 459,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab2 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6295430811308540 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_TAB3_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 460,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab3 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7132706543801860 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_REGION_TITEL_MODUL_AUSW',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 613,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 4000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7135827584826862 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_FKAT_MODULE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1100,
  p_item_plug_id => 7132411261793773+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'select LISTAGG(b, '':'') WITHIN GROUP (ORDER BY c) b'||unistr('\000a')||
'from ('||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(fkm.bezeichnung_text_id,:fas_sprache_id) a,'||unistr('\000a')||
'       ow.wert b ,sortierung c'||unistr('\000a')||
'FROM optionswerte ow, optionstypen ot, FKATEGORIE_MODULE fkm, PERGEBNIS_MODUL_AUSWAHL pma'||unistr('\000a')||
'where ow.opttyp_id = ot.id  /* JOIN OT */'||unistr('\000a')||
'  and ow.opttyp_id = 39 /* Zusatzmodule */'||unistr('\000a')||
'  and ow.wert = fkm.ID'||unistr('\000a')||
'  and pma.FKAT_MODUL_ID = ow.wert'||unistr('\000a')||
'  and pma.PERGEBNIS_ID = :P1_PERGEBNIS_ID'||unistr('\000a')||
'order by c'||unistr('\000a')||
')',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_SHUTTLE',
  p_lov=> 'select a, b'||unistr('\000a')||
'from ('||unistr('\000a')||
'SELECT * FROM('||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(fkm.bezeichnung_text_id,:fas_sprache_id) a,'||unistr('\000a')||
'       ow.wert b ,sortierung c'||unistr('\000a')||
'FROM optionswerte ow, pers_optionen po, optionstypen ot, FKATEGORIE_MODULE fkm'||unistr('\000a')||
'where ow.opttyp_id = ot.id  /* JOIN OT */'||unistr('\000a')||
'  and ow.opttyp_id = 39 /* Zusatzmodule */'||unistr('\000a')||
'  and ow.opttyp_id = po.opttyp_id'||unistr('\000a')||
'  and ow.wert = po.wert'||unistr('\000a')||
'  and ow.wert = fkm.ID'||unistr('\000a')||
'   -- Identität des eingeloggten'||unistr('\000a')||
'  and (po.persstamm_id = frgbg_s.GET_PERS_OPT_PERS_ID(:FAS_LOGIN_PERSONENSTAMM_ID,ow.opttyp_id,'||unistr('\000a')||
'          FRGBG_S.GET_IDENTITAET_BETR(:FAS_LOGIN_PERSONENSTAMM_ID)) /*Persid des Subsets sonst null */'||unistr('\000a')||
'   -- Aktive Dientität '||unistr('\000a')||
'   or po.persstamm_id = frgbg_s.GET_PERS_OPT_PERS_ID(:FAS_LOGIN_PERSONENSTAMM_ID,ow.opttyp_id,'||unistr('\000a')||
'          :fas_identitaet_persstamm_id) /*Persid des Subsets sonst null */'||unistr('\000a')||
'  )'||unistr('\000a')||
'  '||unistr('\000a')||
'UNION '||unistr('\000a')||
'SELECT frgbg_s.holen_uebersetzung(fkm.bezeichnung_text_id,:fas_sprache_id) a,'||unistr('\000a')||
'       ow.wert b ,sortierung c'||unistr('\000a')||
'FROM optionswerte ow, optionstypen ot, FKATEGORIE_MODULE fkm, PERGEBNIS_MODUL_AUSWAHL pma'||unistr('\000a')||
'where ow.opttyp_id = ot.id  /* JOIN OT */'||unistr('\000a')||
'  and ow.opttyp_id = 39 /* Zusatzmodule */'||unistr('\000a')||
'  and ow.wert = fkm.ID'||unistr('\000a')||
'  and pma.FKAT_MODUL_ID = ow.wert'||unistr('\000a')||
'  and pma.PERGEBNIS_ID = :P1_PERGEBNIS_ID'||unistr('\000a')||
')'||unistr('\000a')||
'order by c'||unistr('\000a')||
')',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 150,
  p_cMaxlength=> 4000,
  p_cHeight=> 10,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'style="width:300px;"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_display_when=>'FRGBG_S.FB_CHECK_AUSWERTUNG(:P1_PERGEBNIS_ID) = 0',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'MOVE',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7137416988908979 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_BL_SAVE_MODUL_AUSW',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1100,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Auswertung',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7168717072739593 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Id',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Login Benutzer Name ist nicht veränderbar.';

wwv_flow_api.create_page_item(
  p_id=>7168827716739595 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_USER_ACCOUNT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 112,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'USER_ACCOUNT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_display_when=>':fas_aufgerufen_von != ''BETREUER''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_read_only_when=>':P1_ID is not null',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Bis zu 100 Zeichen sind erlaubt.';

wwv_flow_api.create_page_item(
  p_id=>7169410652739603 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_NAME',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1  /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Bis zu 100 Zeichen sind erlaubt.';

wwv_flow_api.create_page_item(
  p_id=>7169627880739603 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_VORNAME',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 122,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'VORNAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1  /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Bis zu 100 Zeichen sind erlaubt.';

wwv_flow_api.create_page_item(
  p_id=>7169815624739603 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_STRASSE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 124,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'STRASSE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1 /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Bis zu 10 Zeichen sind erlaubt.';

wwv_flow_api.create_page_item(
  p_id=>7170018549739603 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_NR',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 126,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'NR',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1 /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Für Orte mit Postleitzahlen in der Schweiz wird die PLZ/Ort-Kombination auf Existenz geprüft.'||unistr('\000a')||
'Bis zu 10 Zeichen sind erlaubt.'||unistr('\000a')||
'';

wwv_flow_api.create_page_item(
  p_id=>7170219852739603 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_PLZ',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 128,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'PLZ',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1  /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Für Orte in der Schweiz wird die PLZ/Ort-Kombination auf Existenz geprüft.'||unistr('\000a')||
'Bis zu 100 beliebige Zeichen sind erlaubt.'||unistr('\000a')||
'';

wwv_flow_api.create_page_item(
  p_id=>7170402514739603 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_ORT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 131,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'ORT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1  /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Datumsangabe der Form TT.MM.JJJJ z.B. 20.11.2001';

wwv_flow_api.create_page_item(
  p_id=>7261332424327634 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_GEBURTSDATUM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 135,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_format_mask=>'DD.MM.RRRR',
  p_source=>'GEBURTSDATUM',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DATE_PICKER_CLASSIC',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7291113610173051 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_FKAT_MODUL_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1090,
  p_item_plug_id => 7132411261793773+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select case when FRGBG_S.FB_CHECK_AUSWERTUNG(:P1_PERGEBNIS_ID) = 0'||unistr('\000a')||
'then'||unistr('\000a')||
'   frgbg_s.holen_uebersetzung(9177,:FAS_SPRACHE_ID)'||unistr('\000a')||
'else'||unistr('\000a')||
'  frgbg_s.holen_uebersetzung(9475,:FAS_SPRACHE_ID)  '||unistr('\000a')||
'end from dual',
  p_source_type=> 'QUERY',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_field_template=> 2899816394489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'N',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Anzeigesprache';

wwv_flow_api.create_page_item(
  p_id=>7327021068748275 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_APP_SPRACHE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 147,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'BEGIN'||unistr('\000a')||
'   IF :fas_aufgerufen_von = ''BETREUER'' THEN'||unistr('\000a')||
'      -- Sprache des Patienten von der Betreuer-Sprache ableiten'||unistr('\000a')||
'      :p1_app_sprache_id := frgbg_s.get_app_sprache_id(:APP_USER);'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      SELECT min(s.id) into :p1_app_sprache_id'||unistr('\000a')||
'      FROM app_sprachen s, fas_schemas fs'||unistr('\000a')||
'      WHERE fs.id = :fas_schema_id'||unistr('\000a')||
'        and fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'        AND s.standard = 1;     -- Defaultsprache       '||unistr('\000a')||
'      IF v_sprache_id is NULL THEN'||unistr('\000a')||
'         SELECT min(s.id) into :p1_app_sprache_id'||unistr('\000a')||
'         FROM app_sprachen s, fas_schemas fs'||unistr('\000a')||
'         WHERE fs.id = :fas_schema_id'||unistr('\000a')||
'           and fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'           AND s.aktiv=1; -- NEI 09.09.2014'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   RETURN (:p1_app_sprache_id);'||unistr('\000a')||
'END;',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'APP_SPRACHE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select s.sprache display_value, s.ID return_value'||unistr('\000a')||
'from app_sprachen s, fas_schemas fs '||unistr('\000a')||
'where fs.id = :fas_pers_schema_id'||unistr('\000a')||
'  and fs.app_sprachenset_id = s.app_sprachenset_id'||unistr('\000a')||
'  AND s.aktiv=1  -- NEI 09.09.2014'||unistr('\000a')||
'  -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'  -- and s.sprache_id in (select sprache_id from uebersetzungen) '||unistr('\000a')||
'order by 1',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7941327369339645 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_MUTDAT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 780,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Mutdat',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>9499730499597006 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_FB_VERSION',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 411,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>10188705467758759 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_PERS_READONLY',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1110,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT-CENTER',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Bis zu 100 Zeichen sind erlaubt.';

wwv_flow_api.create_page_item(
  p_id=>10310212010938304 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_ADRESSZUSATZ',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 123,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'ADRESSZUSATZ',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 40,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1  /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>11331907857486731 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_ANREDE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 117,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'ANREDE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select  '||unistr('\000a')||
' fas_synch.get_tab_uebersetzung(''ANREDEN_FRGBG.CODE'',ID,:fas_sprache_id) a,'||unistr('\000a')||
' id b'||unistr('\000a')||
'from anreden_frgbg',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1  /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2899910455489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Das eingegebene Land wird auf Existenz geprüft. Bis zu 100 Zeichen sind erlaubt.';

wwv_flow_api.create_page_item(
  p_id=>12107010169964262 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_LAND_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 132,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'DECLARE '||unistr('\000a')||
'   v_land_id NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :fas_aufgerufen_von = ''BETREUER'' THEN'||unistr('\000a')||
'      v_land_id := frgbg_s.get_betreuer_land_id(:APP_USER);'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      v_land_id := NULL;   '||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   RETURN v_land_id;'||unistr('\000a')||
'END;',
  p_item_default_type=> 'PLSQL_FUNCTION_BODY',
  p_prompt=>'"SET_ITEM_LABEL"',
  p_source=>'LAND_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_SELECT_LIST',
  p_lov=> 'select substr(fas_synch.get_tab_uebersetzung(''LAND.LAND'',id,:fas_sprache_id),1,27)  a, id b'||unistr('\000a')||
'from v_laender'||unistr('\000a')||
'order by sort',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_read_only_when=>'/*:p1_EXTERN_VERWALTET = 1   /*GUS-Verwalt.*/'||unistr('\000a')||
':P1_PERS_READONLY = 1   /* NEI 04.02.15 WSH Adressen extern_verwaltet=2*/',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_help_text=> h,
  p_attribute_01 => 'NONE',
  p_attribute_02 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12216627490563512 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1,
  p_name=>'P1_HEIGHT_SCROLLREGION',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 800,
  p_item_plug_id => 7168017465739576+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4829714365663865 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P1_LAND_ID',
  p_validation_sequence=> 1,
  p_validation => 'BEGIN'||unistr('\000a')||
'   IF :P1_land_id = ''#NULL#'' THEN'||unistr('\000a')||
'      --RETURN(HTMLDB_LANG.MESSAGE(''FELD_EINGABEPFLICHTIG''));'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(211,:fas_sprache_id)));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'')'||unistr('\000a')||
'and :fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_when_button_pressed=> 7168305288739579 + wwv_flow_api.g_id_offset,
  p_associated_item=> 12107010169964262 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 7179200746837900 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P1_LAND_exists',
  p_validation_sequence=> 23,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_anz       NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :p1_land_id IS NOT NULL THEN'||unistr('\000a')||
'      SELECT count(*) into v_anz'||unistr('\000a')||
'      FROM   v_laender'||unistr('\000a')||
'      --WHERE  UPPER(land) = UPPER(:p1_land);'||unistr('\000a')||
'      WHERE id = :p1_land_id;'||unistr('\000a')||
'      IF v_anz != 1 THEN'||unistr('\000a')||
'         --RETURN(''Ungültige Eingabe im Feld Land!'');'||unistr('\000a')||
'         RETURN(frgbg_s.holen_uebersetzung(223,:fas_sprache_id,'||unistr('\000a')||
'            frgbg_s.holen_uebersetzung(211,:fas_sprache_id)));'||unistr('\000a')||
'      '||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN'||unistr('\000a')||
'   --RETURN(''Land ungültig!'');'||unistr('\000a')||
'   RETURN(frgbg_s.holen_uebersetzung(181,frgbg_s.get_sprache_id(:APP_USER),'||unistr('\000a')||
'          frgbg_s.holen_uebersetzung(223,frgbg_s.get_sprache_id(:APP_USER),'||unistr('\000a')||
'          frgbg_s.holen_uebersetzung(211,frgbg_s.get_sprache_id(:APP_USER))),'||unistr('\000a')||
'                              ''Validierung P1_land_exists'')'||unistr('\000a')||
'          );'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'')'||unistr('\000a')||
'and :fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 12107010169964262 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 7180622563844237 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P1_PLZ_ORT_exists',
  p_validation_sequence=> 33,
  p_validation => 'DECLARE'||unistr('\000a')||
'    v_anz       NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   --IF UPPER(:p1_land) = ''SCHWEIZ'' THEN'||unistr('\000a')||
'   IF :p1_land_id IS NOT NULL AND :p1_ort IS NOT NULL AND :p1_plz IS NOT NULL'||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      IF :p1_land_id = 198   and   -- Schweiz'||unistr('\000a')||
'         :P1_EXTERN_VERWALTET = 0  -- NEI 11.07.13 Nur FAS-Verwaltete Aufträge prüfen, '||unistr('\000a')||
'                                     -- da nur diese PLZ/Ort verändert werden können,'||unistr('\000a')||
'                                     -- sonst ist GUS führend und die Änderungen kommen von dort'||unistr('\000a')||
'      THEN'||unistr('\000a')||
'         select count(*) INTO v_anz'||unistr('\000a')||
'         from v_orte'||unistr('\000a')||
'         where upper(ort) = upper(:p1_ort)'||unistr('\000a')||
'           and plz = :p1_plz;'||unistr('\000a')||
'         IF v_anz = 0 THEN'||unistr('\000a')||
'            --RETURN(''PLZ/Ort-Kombination ist ungültig!'');'||unistr('\000a')||
'            RETURN(frgbg_s.holen_uebersetzung(179,'||unistr('\000a')||
'                   :fas_sprache_id));'||unistr('\000a')||
'         END IF;'||unistr('\000a')||
'      END IF; '||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN'||unistr('\000a')||
'   --RETURN(''Ort bzw. PLZ ungültig!'');'||unistr('\000a')||
'   RETURN(frgbg_s.holen_uebersetzung(181,:fas_sprache_id,'||unistr('\000a')||
'          frgbg_s.holen_uebersetzung(223,:fas_sprache_id,'||unistr('\000a')||
'          frgbg_s.holen_uebersetzung(209,:fas_sprache_id)),'||unistr('\000a')||
'                              ''Validierung P1_plz_ort_exists'')'||unistr('\000a')||
'          );'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'') '||unistr('\000a')||
'and :fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 7170219852739603 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 7262720912343300 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'p1_geburtsdatum_not_null',
  p_validation_sequence=> 43,
  p_validation => 'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'   IF :P1_GEBURTSDATUM IS NULL THEN'||unistr('\000a')||
'      --RETURN(HTMLDB_LANG.MESSAGE(''FELD_EINGABEPFLICHTIG''));'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(212,:fas_sprache_id)));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'*/ NULL; -- optional NEI 05.05.08'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'')'||unistr('\000a')||
'and :fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 7261332424327634 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 7265119789361903 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'p1_geburtdatum_must_be_date',
  p_validation_sequence=> 53,
  p_validation => 'BEGIN'||unistr('\000a')||
'    IF :P1_GEBURTSDATUM IS NOT NULL THEN'||unistr('\000a')||
'      :P1_GEBURTSDATUM := '||unistr('\000a')||
'          to_char(to_date(:P1_GEBURTSDATUM,''DD.MM.RRRR''),''DD.MM.RRRR'');'||unistr('\000a')||
'      IF to_date(:P1_GEBURTSDATUM,''DD.MM.RRRR'') >= trunc(sysdate,''DD'')THEN'||unistr('\000a')||
'         RETURN(frgbg_s.holen_uebersetzung(9430,:fas_sprache_id));'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS THEN'||unistr('\000a')||
'   --RETURN(HTMLDB_LANG.MESSAGE(''DATUM_UNGUELTIG''));'||unistr('\000a')||
'   RETURN(frgbg_s.holen_uebersetzung(223,:fas_sprache_id,'||unistr('\000a')||
'          frgbg_s.holen_uebersetzung(212,:fas_sprache_id)));'||unistr('\000a')||
'   '||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'Ungültiges Datum!',
  p_always_execute=>'N',
  p_validation_condition=> ':p1_geburtsdatum is not null and'||unistr('\000a')||
':request in (''WEITER'',''SAVE'',''CREATE'')'||unistr('\000a')||
'and :fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 7261332424327634 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2034014689456153 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'p1_name_not_null',
  p_validation_sequence=> 93,
  p_validation => 'BEGIN'||unistr('\000a')||
'   IF :P1_NAME IS NULL THEN'||unistr('\000a')||
'      --RETURN(HTMLDB_LANG.MESSAGE(''FELD_EINGABEPFLICHTIG''));'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(206,:fas_sprache_id)));'||unistr('\000a')||
'    END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'Wert muss angegeben werden.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'')'||unistr('\000a')||
'and :fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 7169410652739603 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2035200968461621 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P1_VORNAME_not_null',
  p_validation_sequence=> 103,
  p_validation => 'BEGIN'||unistr('\000a')||
'   IF :P1_VORNAME IS NULL THEN'||unistr('\000a')||
'      --RETURN(HTMLDB_LANG.MESSAGE(''FELD_EINGABEPFLICHTIG''));'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(205,:fas_sprache_id)));'||unistr('\000a')||
''||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'Wert muss angegeben werden.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'')'||unistr('\000a')||
'and :fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 7169627880739603 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2038230750470240 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P1_PLZ_not_null',
  p_validation_sequence=> 133,
  p_validation => 'BEGIN'||unistr('\000a')||
'   IF :P1_PLZ IS NULL THEN'||unistr('\000a')||
'      --RETURN(HTMLDB_LANG.MESSAGE(''FELD_EINGABEPFLICHTIG''));'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(209,:fas_sprache_id)));'||unistr('\000a')||
''||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'-- NULL; -- optional NEI 05.05.08'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'Wert muss angegeben werden.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'')'||unistr('\000a')||
'and :fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 7170219852739603 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2039107332472910 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P1_ORT_not_null',
  p_validation_sequence=> 143,
  p_validation => 'BEGIN'||unistr('\000a')||
'/*'||unistr('\000a')||
'   IF :P1_ORT IS NULL THEN'||unistr('\000a')||
'      --RETURN(HTMLDB_LANG.MESSAGE(''FELD_EINGABEPFLICHTIG''));'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(210,:fas_sprache_id)));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'*/ NULL; -- optional NEI 05.05.08'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'Wert muss angegeben werden.',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'')'||unistr('\000a')||
'and :fas_pers_aenderbar = 1         /* Personendaten aenderbar */',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 7170402514739603 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5177517977783748 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_pflichtige_persfelder',
  p_validation_sequence=> 165,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_pruefbedingung NUMBER;'||unistr('\000a')||
'   v_geburtsdatum   personenstamm.geburtsdatum%TYPE;'||unistr('\000a')||
'   v_anrede_id      personenstamm.anrede_id%TYPE;'||unistr('\000a')||
'   v_text           VARCHAR2(10);'||unistr('\000a')||
'   v_fehlertext     VARCHAR2(2000);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT pruefbedingung INTO v_pruefbedingung'||unistr('\000a')||
'   FROM fragebogen'||unistr('\000a')||
'   WHERE id = :p1_fragebogen_id;'||unistr('\000a')||
'   SELECT geburtsdatum,anrede_id into v_geburtsdatum, v_anrede_id'||unistr('\000a')||
'   from personenstamm'||unistr('\000a')||
'   where id = :p1_id;'||unistr('\000a')||
'   IF v_pruefbedingung = 1 THEN'||unistr('\000a')||
'      IF v_geburtsdatum IS NULL THEN'||unistr('\000a')||
'         v_fehlertext := frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(212,:fas_sprache_id))||'' ''||frgbg_s.holen_uebersetzung(4893,:fas_sprache_id);'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'      IF v_anrede_id is null OR '||unistr('\000a')||
'         v_anrede_id not in (3,4) -- Gültige Werte Mann/Frau'||unistr('\000a')||
'      THEN'||unistr('\000a')||
'         v_text :=   '||unistr('\000a')||
'          fas_synch.get_tab_uebersetzung(''ANREDEN_FRGBG.CODE'',3,:fas_sprache_id)'||unistr('\000a')||
'          ||''/''||'||unistr('\000a')||
'         fas_synch.get_tab_uebersetzung(''ANREDEN_FRGBG.CODE'',4,:fas_sprache_id);'||unistr('\000a')||
'         v_fehlertext := v_fehlertext||''<br/>''||'||unistr('\000a')||
'            frgbg_s.holen_uebersetzung(2973,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(204,:fas_sprache_id),v_text)||'' ''||frgbg_s.holen_uebersetzung(4894,:fas_sprache_id);'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'      IF v_fehlertext is not null THEN'||unistr('\000a')||
'         RETURN(v_fehlertext);'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':p1_pergebnis_id is not null and :request = ''SAVE''',
  p_validation_condition_type=> 'NEVER',
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3614607899709555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_pflichtige_plz',
  p_validation_sequence=> 190,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_fehlertext     VARCHAR2 (2000);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :FAS_AUFGERUFEN_VON = ''ANONYM'' THEN'||unistr('\000a')||
'      -- ''Die Angabe der PLZ ist pflichtig, damit eine sinnvolle Apotheken-Liste ...'';'||unistr('\000a')||
'      v_fehlertext := frgbg_s.holen_uebersetzung(4895,:fas_sprache_id);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'   RETURN v_fehlertext;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':p1_pergebnis_id is not null and :request = ''SAVE'' AND '||unistr('\000a')||
':FAS_AUFGERUFEN_VON = ''ANONYM''',
  p_validation_condition_type=> 'NEVER',
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 3703908339130925 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_pflichtige_antworten',
  p_validation_sequence=> 200,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_anz NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   SELECT count(*) INTO v_anz'||unistr('\000a')||
'   FROM v_alle_fragen'||unistr('\000a')||
'   WHERE pergebnis_id = :p1_pergebnis_id'||unistr('\000a')||
'     and ((frage_eingabepflichtig=1 and status=2) -- unbeantw.pflichtige Fragen'||unistr('\000a')||
'          or'||unistr('\000a')||
'          (frage_eingabepflichtig=1 and status = 0)  -- unvollständig beantwortete pflichtige Fragen'||unistr('\000a')||
'         )'||unistr('\000a')||
'     and frage_fragelevel = 0 /* Keine Metafragen */;'||unistr('\000a')||
'   IF v_anz > 0 THEN'||unistr('\000a')||
'      -- RETURN (''Der Fragebogen ist noch nicht komplett ausgefüllt! Bitte auf der Übersichtsseite kontrollieren!'');'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(1665,:fas_sprache_id,'||unistr('\000a')||
'          frgbg_s.holen_uebersetzung(245,:fas_sprache_id)));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':p1_pergebnis_id is not null and :request = ''SAVE''',
  p_validation_condition_type=> 'NEVER',
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4057425609871331 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_hrv_datei',
  p_validation_sequence=> 210,
  p_validation => 'BEGIN'||unistr('\000a')||
'   IF :P1_hrv_datei is null THEN'||unistr('\000a')||
'      --RETURN(HTMLDB_LANG.MESSAGE(''FELD_EINGABEPFLICHTIG''));'||unistr('\000a')||
'      RETURN(frgbg_s.holen_uebersetzung(164,:fas_sprache_id,'||unistr('\000a')||
'             frgbg_s.holen_uebersetzung(5520,:fas_sprache_id)));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 4056729101749365 + wwv_flow_api.g_id_offset,
  p_only_for_changed_rows=> 'Y',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4866724124136452 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P1_GEWICHT_Bereich',
  p_validation_sequence=> 230,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_zahl   number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :p1_gewicht is not null THEN'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         v_zahl := frgbg_s.FB_FORMAT_FANT_WERT(:P1_GEWICHT,''999D9'',1);'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'         RETURN(frgbg_s.holen_uebersetzung(2151,:fas_sprache_id)||'': ''||'||unistr('\000a')||
'                frgbg_s.holen_uebersetzung(3533,:fas_sprache_id));'||unistr('\000a')||
'      END; '||unistr('\000a')||
'      :p1_gewicht:= v_zahl;'||unistr('\000a')||
'      IF :p1_gewicht < 17 THEN'||unistr('\000a')||
'         RETURN(frgbg_s.holen_uebersetzung(2173,:fas_sprache_id,'||unistr('\000a')||
'                frgbg_s.holen_uebersetzung(2151,:fas_sprache_id),17));      '||unistr('\000a')||
'      ELSIF :p1_gewicht > 150 THEN'||unistr('\000a')||
'         RETURN(frgbg_s.holen_uebersetzung(2174,:fas_sprache_id,'||unistr('\000a')||
'                frgbg_s.holen_uebersetzung(2151,:fas_sprache_id),150));      '||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4866929665138028 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'P1_GROESSE_BEREICH',
  p_validation_sequence=> 240,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_zahl   number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :p1_groesse is not null THEN'||unistr('\000a')||
'      BEGIN'||unistr('\000a')||
'         v_zahl := frgbg_s.FB_FORMAT_FANT_WERT(:P1_groesse ,''999D9'',1);'||unistr('\000a')||
'      EXCEPTION'||unistr('\000a')||
'      WHEN others THEN'||unistr('\000a')||
'         RETURN(frgbg_s.holen_uebersetzung(4,:fas_sprache_id)||'': ''||'||unistr('\000a')||
'                frgbg_s.holen_uebersetzung(3533,:fas_sprache_id));'||unistr('\000a')||
'      END; '||unistr('\000a')||
'      :p1_groesse := v_zahl;'||unistr('\000a')||
'      IF :p1_groesse < 120 THEN'||unistr('\000a')||
'         RETURN(frgbg_s.holen_uebersetzung(2173,:fas_sprache_id,'||unistr('\000a')||
'                frgbg_s.holen_uebersetzung(4,:fas_sprache_id),120));      '||unistr('\000a')||
'      ELSIF :p1_groesse > 230 THEN'||unistr('\000a')||
'         RETURN(frgbg_s.holen_uebersetzung(2174,:fas_sprache_id,'||unistr('\000a')||
'                frgbg_s.holen_uebersetzung(4,:fas_sprache_id),230));      '||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_validation_condition=> ':request in (''WEITER'',''SAVE'',''CREATE'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'    /*:p1_satzkennzeichen := ''GELOESCHT''; */'||unistr('\000a')||
'    NULL;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 7200322618998553 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_satz_delete',
  p_process_sql_clob => p,
  p_process_error_message=> 'Datensatz konnte nicht gelöscht werden!',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>7168202772739579 + wwv_flow_api.g_id_offset,
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> 'Datensatz wurde erfolgreich gelöscht!',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   IF :p1_id IS NULL THEN'||unistr('\000a')||
'      :p1_erfuser := NVL(:p1_user,:APP_USER);'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5069202396490950 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'erfuser_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>7168415639739579 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   :p1_mutuser := NVL(:p1_user,:APP_USER);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5070705990501415 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'mutuser_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SAVE'',''DELETE'')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'IF :p1_land_id = ''#NULL#'' THEN'||unistr('\000a')||
'   :p1_land_id := NULL;'||unistr('\000a')||
'END IF;';

wwv_flow_api.create_page_process(
  p_id     => 3008214546227065 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 52,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_land_id_null',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:PERSONENSTAMM:P1_ID:ID|IU';

wwv_flow_api.create_page_process(
  p_id     => 7171911437739609 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 140,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Zeile von PERSONENSTAMM verarbeiten',
  p_process_sql_clob => p,
  p_process_error_message=> '&P1_FEHLER.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'--:request in (''CREATE'',''DELETE'',''SAVE'')  '||unistr('\000a')||
'(:request in (''WEITER'',''HRV_DATEN_LADEN'',''LÖSCHEN_HRV'') AND'||unistr('\000a')||
' :P1_ID is not null and'||unistr('\000a')||
' :fas_pers_aenderbar = 1         /* Personendaten aenderbar */'||unistr('\000a')||
')',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '&P1_INFO.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_blob        blob;'||unistr('\000a')||
'   v_clob        clob;'||unistr('\000a')||
'   v_dateiname   varchar2(2000);--hrv.DATEN_DATEINAME%type;'||unistr('\000a')||
'   v_mimetype    varchar2(2000);--hrv.DATEN_MIME_TYPE%type;'||unistr('\000a')||
'   v_anz         number;'||unistr('\000a')||
'   '||unistr('\000a')||
'   v_return        number;'||unistr('\000a')||
'   v_fehlermeldung varchar2(2000);'||unistr('\000a')||
'   v_fehlernummer  number;'||unistr('\000a')||
'   v_prot_id       NUMBER;'||unistr('\000a')||
'   v_fehler        EXCEPTION;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :P1_HRV_DATEI IS NULL THEN'||unistr('\000a')||
'      --''Dat';

p:=p||'einame muss angegeben sein!5531'';'||unistr('\000a')||
'      :p1_hrv_meldung:= frgbg_s.holen_uebersetzung(5531,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung;'||unistr('\000a')||
'      v_fehlernummer := -10;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'--mel.p(''Dateiname:%1'',v_prot_id,''TEST'',''102/1: hrv_daten_laden'',:P1_HRV_DATEI);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Holen der Datei'||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      select'||unistr('\000a')||
'         blob_content,'||unistr('\000a')||
'         filename,'||unistr('\000a')||
'         mime_type'||unistr('\000a')||
' ';

p:=p||'     into v_blob, v_dateiname, v_mimetype'||unistr('\000a')||
'      from wwv_flow_files '||unistr('\000a')||
'      where name = :P1_HRV_DATEI;'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN others then '||unistr('\000a')||
'      v_fehlermeldung := SQLERRM;'||unistr('\000a')||
'      -- ''Hochladevorgang der Datei konnte nicht durchgeführt werden!'';'||unistr('\000a')||
'      :p1_hrv_meldung := frgbg_s.holen_uebersetzung(5523,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung ||'' ''||v_fehlermeldung;'||unistr('\000a')||
'      v_fehlernum';

p:=p||'mer := -20;'||unistr('\000a')||
'      RAISE v_fehler;  '||unistr('\000a')||
'   END;'||unistr('\000a')||
'--mel.p(''Dateiname:%1,%2'',v_prot_id,''TEST'',''102/1: hrv_daten_laden'',:P1_HRV_DATEI,v_dateiname);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Der Blob in V_DATEI kann hier weiter verarbeitet werden:'||unistr('\000a')||
'   -- * Umwandeln in ein CLOB'||unistr('\000a')||
'   -- * Bildbearbeitung mit ORDIMAGE-Methoden'||unistr('\000a')||
'   -- * ...'||unistr('\000a')||
''||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'   -- In clob konvertieren inklusive unzip fals erforderlich'||unistr('\000a')||
'   v_return := HRV.HRV_FILE.convert_t';

p:=p||'o_clob('||unistr('\000a')||
'       p_file           => v_blob,'||unistr('\000a')||
'       p_file_name      => v_dateiname,'||unistr('\000a')||
'       p_output         => v_clob,'||unistr('\000a')||
'       p_output_file_name => v_dateiname); -- liefert eventuell einen Dateinamen aus dem Archiv'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'    when others then'||unistr('\000a')||
'      v_fehlermeldung := SQLERRM;'||unistr('\000a')||
'      -- ''Datei konnte nicht ordnungsgemäss validiert werden!5525 HRV-Ladevorgang abgebrochen!5524'';'||unistr('\000a')||
'      :p1_hrv_mel';

p:=p||'dung :=frgbg_s.holen_uebersetzung(5523,:fas_sprache_id)||'' ''||                 '||unistr('\000a')||
'                        frgbg_s.holen_uebersetzung(5524,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung ||'' ''||v_fehlermeldung;'||unistr('\000a')||
'      v_fehlernummer := -24;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   end;'||unistr('\000a')||
''||unistr('\000a')||
'   IF v_return = 0 THEN  -- OK 0: keine Fehler, Datei konnte in CLOB umgewandelt werden'||unistr('\000a')||
'      null;'||unistr('\000a')||
'   ELSIF v_return = -';

p:=p||'1 THEN  -- -1: Zip-Archiv ist leer'||unistr('\000a')||
'      :p1_hrv_meldung := frgbg_s.holen_uebersetzung(5523 /*8425*/,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung;'||unistr('\000a')||
'      v_fehlernummer  :=-25;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   ELSIF v_return = -2 THEN  -- -1: Dateityp ist nicht bekannt 5530'||unistr('\000a')||
'      :p1_hrv_meldung := frgbg_s.holen_uebersetzung(5530,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung;'||unistr('\000a')||
'   ';

p:=p||'   v_fehlernummer  :=-26;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      -- Hochladevorgang der Datei konnte nicht durchgeführt werden!;'||unistr('\000a')||
'      :p1_hrv_meldung := frgbg_s.holen_uebersetzung(5523,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung||''(''||v_return||'')'';'||unistr('\000a')||
'      v_fehlernummer  :=-27;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   END IF;    '||unistr('\000a')||
''||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      -- Speichern in HRV '||unistr('\000a')||
'      SELECT count(*) into v_anz'||unistr('\000a')||
' ';

p:=p||'     FROM hrv.hrv'||unistr('\000a')||
'      WHERE pergebnisse_id = :p1_pergebnis_id;'||unistr('\000a')||
''||unistr('\000a')||
'      IF v_anz = 0 THEN'||unistr('\000a')||
'         hrv_table.insert_hrv( p_pergebnisse_id  => :p1_pergebnis_id,'||unistr('\000a')||
'                               p_daten           => v_clob,'||unistr('\000a')||
'                               p_daten_dateiname => v_dateiname,'||unistr('\000a')||
'                               p_daten_mime_type => v_mimetype,'||unistr('\000a')||
'                               p_daten_ladezeitpunk';

p:=p||'t => sysdate,'||unistr('\000a')||
'                               p_bemerkungen     => NULL);'||unistr('\000a')||
'      ELSE'||unistr('\000a')||
'         hrv_table.update_hrv( p_pergebnisse_id  => :p1_pergebnis_id,'||unistr('\000a')||
'                               p_daten           => v_clob,'||unistr('\000a')||
'                               p_daten_dateiname => v_dateiname,'||unistr('\000a')||
'                               p_daten_mime_type => v_mimetype,'||unistr('\000a')||
'                               p_daten_ladezeitpunkt => s';

p:=p||'ysdate,'||unistr('\000a')||
'                               p_status          => 0,'||unistr('\000a')||
'                               p_bemerkungen     => NULL);'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN others THEN'||unistr('\000a')||
'      v_fehlermeldung := SQLERRM;'||unistr('\000a')||
'      -- ''Datei konnte nicht ordnungsgemäss gespeichert werden! HRV-Ladevorgang abgebrochen!5524'';'||unistr('\000a')||
'      :p1_hrv_meldung :=frgbg_s.holen_uebersetzung(5533,:fas_sprache_id)||'' ''||                 '||unistr('\000a')||
' ';

p:=p||'                       frgbg_s.holen_uebersetzung(5524,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung ||'' ''||v_fehlermeldung;'||unistr('\000a')||
'      v_fehlernummer := -25;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   END;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Wichtig: Die Datei muss aus WWV_FLOW_FILES gelöscht werden;'||unistr('\000a')||
'   -- das passiert nicht automatisch!'||unistr('\000a')||
'   delete from wwv_flow_files where name = :P1_HRV_DATEI;'||unistr('\000a')||
''||unistr('\000a')||
'   -- HRV-Datei validieren'||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'   ';

p:=p||'   v_return := hrv_table.validate_file(:p1_pergebnis_id);'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN others THEN'||unistr('\000a')||
'      v_fehlermeldung := SQLERRM;'||unistr('\000a')||
'      -- ''Datei konnte nicht ordnungsgemäss validiert werden!5525 HRV-Ladevorgang abgebrochen!5524'';'||unistr('\000a')||
'      :p1_hrv_meldung :=frgbg_s.holen_uebersetzung(5523,:fas_sprache_id)||'' ''||                 '||unistr('\000a')||
'                        frgbg_s.holen_uebersetzung(5524,:fas_sprache_id);'||unistr('\000a')||
'   ';

p:=p||'   v_fehlermeldung := :p1_hrv_meldung ||'' ''||v_fehlermeldung;'||unistr('\000a')||
'      v_fehlernummer := -30;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   END;'||unistr('\000a')||
''||unistr('\000a')||
'   IF v_return = 0 THEN  -- OK 0: keine Fehler, Datei ist gültig'||unistr('\000a')||
'      :p1_hrv_meldung := frgbg_s.holen_uebersetzung(5526,:fas_sprache_id);'||unistr('\000a')||
'   ELSIF v_return = -1 THEN  -- -1: Datei ist zur gross 5527'||unistr('\000a')||
'      :p1_hrv_meldung:= frgbg_s.holen_uebersetzung(5527,:fas_sprache_id);'||unistr('\000a')||
'   ';

p:=p||'   v_fehlermeldung := :p1_hrv_meldung;'||unistr('\000a')||
'      v_fehlernummer  :=-41;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   ELSIF v_return = -2 THEN  -- -2: Dateiinhalt ist ungültig 5528'||unistr('\000a')||
'      :p1_hrv_meldung:= frgbg_s.holen_uebersetzung(5528,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung;'||unistr('\000a')||
'      v_fehlernummer  :=-42;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   ELSIF v_return = -3 THEN  -- -3: Dateiname lässt Dateityp nicht erkennen 5';

p:=p||'529'||unistr('\000a')||
'      :p1_hrv_meldung:= frgbg_s.holen_uebersetzung(5529,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung;'||unistr('\000a')||
'      v_fehlernummer  :=-43;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   ELSIF v_return = -4 THEN  -- -4: Dateityp ist nicht bekannt 5530'||unistr('\000a')||
'      :p1_hrv_meldung := frgbg_s.holen_uebersetzung(5530,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung;'||unistr('\000a')||
'      v_fehlernummer  :=-44;'||unistr('\000a')||
'      RAISE v_f';

p:=p||'ehler;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      -- Hochladevorgang der Datei konnte nicht durchgeführt werden!;'||unistr('\000a')||
'      :p1_hrv_meldung := frgbg_s.holen_uebersetzung(5523,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung||''(''||v_return||'')'';'||unistr('\000a')||
'      v_fehlernummer  :=-50;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   END IF;    '||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN v_fehler THEN'||unistr('\000a')||
'   mel.p(v_fehlermeldung,v_prot_id,''ERROR'',''102/1: hrv_daten_laden[''||v_fehlernumme';

p:=p||'r||'']'');'||unistr('\000a')||
'   ROLLBACK;'||unistr('\000a')||
'WHEN others THEN'||unistr('\000a')||
'   v_fehlermeldung := ''Interner FEHLER beim Laden der HRV-Datei! ''||'' ''|| SQLERRM;'||unistr('\000a')||
'   v_fehlernummer:= -9999;'||unistr('\000a')||
'   mel.p(v_fehlermeldung,v_prot_id,''ERROR'',''102/1: hrv_daten_laden[''||v_fehlernummer||'']'');'||unistr('\000a')||
'   :p1_hrv_meldung :=''Hochladevorgang der Datei konnte nicht durchgeführt werden!'';'||unistr('\000a')||
'   ROLLBACK;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4059419993964285 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 142,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hrv_daten_laden',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_when_button_id=>4056729101749365 + wwv_flow_api.g_id_offset,
  p_process_when=>'HRV_TABLE.get_hrv_status(:P1_PERGEBNIS_ID) is null or HRV_TABLE.get_hrv_status(:P1_PERGEBNIS_ID) < 10 or HRV_TABLE.get_hrv_status(:P1_PERGEBNIS_ID) >= 20',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_blob        blob;'||unistr('\000a')||
'   v_clob        clob;'||unistr('\000a')||
'   v_dateiname   varchar2(2000);--hrv.DATEN_DATEINAME%type;'||unistr('\000a')||
'   v_mimetype    varchar2(2000);--hrv.DATEN_MIME_TYPE%type;'||unistr('\000a')||
'   v_anz         number;'||unistr('\000a')||
'   '||unistr('\000a')||
'   v_return        number;'||unistr('\000a')||
'   v_fehlermeldung varchar2(2000);'||unistr('\000a')||
'   v_fehlernummer  number;'||unistr('\000a')||
'   v_prot_id       NUMBER;'||unistr('\000a')||
'   v_fehler        EXCEPTION;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
''||unistr('\000a')||
'--mel.p(''Dateiname:%1'',v_prot_id,''TEST'',''102';

p:=p||'/1: hrv_daten_loeschen'',:P1_HRV_DATEI);'||unistr('\000a')||
'   -- HRV-Daten löschen'||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'      hrv_table.delete_hrv(:p1_pergebnis_id);'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN others THEN'||unistr('\000a')||
'      v_fehlermeldung := SQLERRM;'||unistr('\000a')||
'      -- ''Daten konnten nicht ordnungsgemäss gelöscht werden!5897;'||unistr('\000a')||
'      :p1_hrv_meldung :=frgbg_s.holen_uebersetzung(5897,:fas_sprache_id);'||unistr('\000a')||
'      v_fehlermeldung := :p1_hrv_meldung ||'' ''||v_fehlermeldung;'||unistr('\000a')||
'      v_';

p:=p||'fehlernummer := -30;'||unistr('\000a')||
'      RAISE v_fehler;'||unistr('\000a')||
'   END;'||unistr('\000a')||
''||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN v_fehler THEN'||unistr('\000a')||
'   mel.p(v_fehlermeldung,v_prot_id,''ERROR'',''102/1: hrv_daten_loeschen[''||v_fehlernummer||'']'');'||unistr('\000a')||
'   ROLLBACK;'||unistr('\000a')||
'WHEN others THEN'||unistr('\000a')||
'   v_fehlermeldung := ''Interner FEHLER beim Löschen der HRV-Datei! ''||'' ''|| SQLERRM;'||unistr('\000a')||
'   v_fehlernummer:= -9999;'||unistr('\000a')||
'   mel.p(v_fehlermeldung,v_prot_id,''ERROR'',''102/1: hrv_daten_loeschen[''||v_fehlern';

p:=p||'ummer||'']'');'||unistr('\000a')||
'   :p1_hrv_meldung :=''Hochladevorgang der Datei konnte nicht durchgeführt werden!'';'||unistr('\000a')||
'   ROLLBACK;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 4824126820563240 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 143,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hrv_daten_loeschen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_when_button_id=>4823129582488299 + wwv_flow_api.g_id_offset,
  p_process_when=>'HRV_TABLE.get_hrv_status(:P1_PERGEBNIS_ID) is null',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_only_for_changed_rows=> 'Y',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'-- Da evt. beim Speichern die Patientensprache geändert wird, kann dies '||unistr('\000a')||
'-- auf die FAS-Sprache auswirkungen haben => FAS-Sprache neu bestimmen'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :fas_sprache_id:= frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 9331519617051009 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 145,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'fas_sprache_festlegen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'SAVE DELETE',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'2175419584582678';

wwv_flow_api.create_page_process(
  p_id     => 2175519022592003 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 160,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'set_fas_texte',
  p_process_sql_clob => 2175419584582678 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'SAVE DELETE',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'   v_return        number;'||unistr('\000a')||
'   v_fehlermeldung varchar2(2000);'||unistr('\000a')||
'   v_fehlernummer  number;'||unistr('\000a')||
'   v_prot_id       NUMBER;'||unistr('\000a')||
'   v_fehler        EXCEPTION;'||unistr('\000a')||
'   v_fehler_d      EXCEPTION;'||unistr('\000a')||
''||unistr('\000a')||
'begin'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'   v_return := FRGBG_S.FB_SPEICHER_ZUSATZMODUL_AUSW('||unistr('\000a')||
'       p_pergebnis_id        => :P1_PERGEBNIS_ID,'||unistr('\000a')||
'       p_zusatzmodul_liste   => :P1_FKAT_MODULE'||unistr('\000a')||
'  );'||unistr('\000a')||
''||unistr('\000a')||
'   if v_return = -10 then'||unistr('\000a')||
'        -- Ein Modul das';

p:=p||' bereits eine nicht bearbeitbare Frage hat ist nicht mehr in der '||unistr('\000a')||
'        -- Auswahl enthalten'||unistr('\000a')||
'        v_fehlermeldung := frgbg_s.holen_uebersetzung(9183,:FAS_SPRACHE_ID);'||unistr('\000a')||
'        raise v_fehler_d;'||unistr('\000a')||
'   elsif v_return = -20 then'||unistr('\000a')||
'        -- Es existiert bereits ein Warenkorb der ein Zusatzmodul erfordert,'||unistr('\000a')||
'        -- dieses fehlt aber in der Auswahl'||unistr('\000a')||
'        v_fehlermeldung := frgbg_s.holen_uebersetzun';

p:=p||'g(10024,:FAS_SPRACHE_ID);'||unistr('\000a')||
'        raise v_fehler_d;'||unistr('\000a')||
'   elsif v_return = -30 then'||unistr('\000a')||
'        -- Es wurde mehr als ein Labor-Zusatzmodul ausgewählt'||unistr('\000a')||
'        v_fehlermeldung := frgbg_s.holen_uebersetzung(10017,:FAS_SPRACHE_ID);'||unistr('\000a')||
'        raise v_fehler_d;'||unistr('\000a')||
'   end if;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Die Auswahl der Zusatzmodule wurde gespeichert. '||unistr('\000a')||
'   apex_application.g_print_success_message := frgbg_s.holen_uebersetzung(9126,:FAS_SP';

p:=p||'RACHE_ID);'||unistr('\000a')||
'  '||unistr('\000a')||
'exception '||unistr('\000a')||
'   when v_fehler then'||unistr('\000a')||
'      mel.p(v_fehlermeldung,v_prot_id,''ERROR'',''102/1: Speicher Modulauswahl[''||v_fehlernummer||'']'');'||unistr('\000a')||
'      raise_application_error(-20000,frgbg_s.holen_uebersetzung(9125,:FAS_SPRACHE_ID));'||unistr('\000a')||
'   when v_fehler_d then'||unistr('\000a')||
'     raise_application_error(-20100,v_fehlermeldung);'||unistr('\000a')||
'   WHEN others THEN'||unistr('\000a')||
'      v_fehlermeldung := ''Interner FEHLER beim Speichern der Zusat';

p:=p||'zmodule! ''||'' ''|| SQLERRM;'||unistr('\000a')||
'      v_fehlernummer:= -9999;'||unistr('\000a')||
'      mel.p(v_fehlermeldung,v_prot_id,''ERROR'',''102/1: Speicher Modulauswahl[''||v_fehlernummer||'']'');'||unistr('\000a')||
'      raise_application_error(-20000,frgbg_s.holen_uebersetzung(9125,:FAS_SPRACHE_ID));'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 7138028903997573 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 170,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Speicher Modulauswahl',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_when_button_id=>7137105991886882 + wwv_flow_api.g_id_offset,
  p_process_when=>'FRGBG_S.FB_CHECK_AUSWERTUNG(:P1_PERGEBNIS_ID) = 0',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_only_for_changed_rows=> 'Y',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_prot_id    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   mel.p(''Testmeldung'',v_prot_id,''TEST'',''102/1:test_meldung'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3606130290264124 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'test_meldung',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||unistr('\000a')||
'   -- Prozentsatz der komplette Höhe ausnutzen (% des Maximums)'||unistr('\000a')||
'   :P1_HEIGHT_SCROLLREGION := :FAS_SCROLLREGION_HEIGHT_MAX *0.99; --0.9905;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 12217101648565501 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 5,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'scrollheight_setzen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_sprache_id number := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   IF :p1_person is null THEN  '||unistr('\000a')||
'      RAISE_APPLICATION_ERROR(-20001,frgbg_s.holen_uebersetzung(483,v_sprache_id));   '||unistr('\000a')||
'   ELSE  -- Aufruf via Pis p1_person oder via Fragebogenliste enthält bereits die Personenstamm_id'||unistr('\000a')||
'      :p1_id := :p1_person;'||unistr('\000a')||
'   END IF; '||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 7181419624881178 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 9,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'get_personendaten',
  p_process_sql_clob => p,
  p_process_error_message=> 'Login ungültig!',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'Y',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   --v_preislistentyp              preislisten.typ%TYPE;'||unistr('\000a')||
'   --v_sortiment_id                sortimente.id%TYPE; '||unistr('\000a')||
'   --v_preisliste_id               preislisten.id%TYPE;  '||unistr('\000a')||
'   --v_preislisten_land_id         preislisten.land_id%TYPE;'||unistr('\000a')||
''||unistr('\000a')||
'   v_user       VARCHAR2(100);'||unistr('\000a')||
'   v_sprache_id number := :fas_sprache_id;  --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'   v_prot_id    number;'||unistr('\000a')||
'   v_return     number;';

p:=p||''||unistr('\000a')||
'   v_return2    number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Auswertungsseite initialisieren'||unistr('\000a')||
'   :P1_PAGE_AUSWERTUNG := 95;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Setzte das Flag zurück, das sich die letzten Druckoptionen merkt. '||unistr('\000a')||
'   -- Wenn NULL werden die aus PERS_OPTIONEN verwendeten Standards genommen.'||unistr('\000a')||
'   :P95_DRUCK_OPTIONEN_CHECKED := null;'||unistr('\000a')||
'   -- Setzte die ausgewählten Labor Warenkörbe auf den Standard zurück'||unistr('\000a')||
'   :P95_LABOR_WARENKORB_IDS := null;'||unistr('\000a')||
'  ';

p:=p||' -- Fragebogen initialisieren'||unistr('\000a')||
'   IF :p1_fragebogen_id IS NULL THEN'||unistr('\000a')||
'      :p1_fragebogen_id := 1;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'--MEL.P (''fragebogen_festlegen 0: FB %1, Version %2, Pers %3,%4'', v_PROT_ID, ''TEST'', ''seite 1 fragebogen festlegen'',:p1_fragebogen_id,:p1_fb_version,:p1_id);'||unistr('\000a')||
'   IF :p1_fb_version is not null THEN'||unistr('\000a')||
'      :p1_fragebogen_id := frgbg_s.FB_GEN_ID_VERS_NR(:p1_fragebogen_id,:p1_fb_version);'||unistr('\000a')||
'      :p';

p:=p||'1_fb_version := NULL;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'--MEL.P (''fragebogen_festlegen 1: %1, %2,%3,%4'', v_PROT_ID, ''TEST'', ''seite 1 fragebogen festlegen'',:p1_fragebogen_id,:p1_fb_version,:p1_bearb_modus);'||unistr('\000a')||
''||unistr('\000a')||
'   IF :p1_bearb_modus = ''KOPIEREN'' THEN -- Neue Version erstellen'||unistr('\000a')||
'      -- Kopie erzeugen, da die alte Version bereits ein MNR besitzt '||unistr('\000a')||
'      -- und dann ist die neue Version bearbeitbar'||unistr('\000a')||
'      v_return :=  frgbg_s.pe';

p:=p||'rg_set_kopieren('||unistr('\000a')||
'                              :p1_pergebnis_id,'||unistr('\000a')||
'                              1    -- NEI 15.07.10 alte Antworten übernehmen'||unistr('\000a')||
'                            );'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'      IF v_return > 0 THEN -- Kopie erfolgreich => Neue ID'||unistr('\000a')||
'         :p1_bearb_modus := ''BEARBEITEN''; '||unistr('\000a')||
''||unistr('\000a')||
'         -- Kopiere auch die Modulauswahl'||unistr('\000a')||
'         v_return2 := frgbg_s.FB_KOPIERE_FKAT_MODUL_AUSWAHL('||unistr('\000a')||
'           p_pergeb';

p:=p||'nis_id_alt => :p1_pergebnis_id,'||unistr('\000a')||
'           p_pergebnis_id_neu => v_return,'||unistr('\000a')||
'           p_fas_login_personenstamm_id => :fas_login_personenstamm_id,'||unistr('\000a')||
'           p_fas_identitaet_persstamm_id => :fas_identitaet_persstamm_id --FRGBG_S.GET_IDENTITAET_BETR(:FAS_LOGIN_PERSONENSTAMM_ID)--'||unistr('\000a')||
'         );'||unistr('\000a')||
''||unistr('\000a')||
'         if(v_return2 > 0) then -- Beim Kopieren ist was schief gegangen.'||unistr('\000a')||
'            RAISE_APPLICATION_ER';

p:=p||'ROR (-20000,frgbg_s.holen_uebersetzung(181,v_sprache_id, '||unistr('\000a')||
'                                      to_char(v_return),''perg_set_festlegen''));'||unistr('\000a')||
'         end if;'||unistr('\000a')||
'         :p1_pergebnis_id := v_return;'||unistr('\000a')||
'      ELSIF v_return < 0 THEN -- Fehler beim kopieren'||unistr('\000a')||
'         :p1_bearb_modus := ''ANZEIGEN''; '||unistr('\000a')||
'         RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(181,v_sprache_id, '||unistr('\000a')||
'                        ';

p:=p||'              to_char(v_return),''perg_set_festlegen''));'||unistr('\000a')||
'      ELSE -- p1_pergebnis_id is null'||unistr('\000a')||
'         :p1_bearb_modus := ''ANZEIGEN''; '||unistr('\000a')||
'         RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(181,v_sprache_id, '||unistr('\000a')||
'                                      ''90'',''perg_set_festlegen''));'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   ELSIF :p1_bearb_modus = ''KOPIEREN0'' THEN -- Neue Version erstellen'||unistr('\000a')||
''||unistr('\000a')||
'      -- Kopie erzeugen, d';

p:=p||'a die alte Version bereits ein MNR besitzt '||unistr('\000a')||
'      -- und dann ist die neue Version bearbeitbar'||unistr('\000a')||
'      v_return :=  frgbg_s.perg_set_kopieren('||unistr('\000a')||
'                              :p1_pergebnis_id,'||unistr('\000a')||
'                              0    -- NEI 15.07.10 alte Antworten nicht übernehmen'||unistr('\000a')||
'                            );'||unistr('\000a')||
'      IF v_return > 0 THEN -- Kopie erfolgreich => Neue ID'||unistr('\000a')||
'         :p1_bearb_modus := ''BEARBEITE';

p:=p||'N''; '||unistr('\000a')||
''||unistr('\000a')||
'         -- Kopiere auch die Modulauswahl'||unistr('\000a')||
'         v_return2 := frgbg_s.FB_KOPIERE_FKAT_MODUL_AUSWAHL('||unistr('\000a')||
'           p_pergebnis_id_alt => :p1_pergebnis_id,'||unistr('\000a')||
'           p_pergebnis_id_neu => v_return,'||unistr('\000a')||
'           p_fas_login_personenstamm_id => :fas_login_personenstamm_id,'||unistr('\000a')||
'           p_fas_identitaet_persstamm_id => :fas_identitaet_persstamm_id'||unistr('\000a')||
'         );'||unistr('\000a')||
''||unistr('\000a')||
'         if(v_return2 > 0) then -- Beim';

p:=p||' Kopieren ist was schief gegangen.'||unistr('\000a')||
'            RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(181,v_sprache_id, '||unistr('\000a')||
'                                      to_char(v_return2),''perg_set_festlegen''));'||unistr('\000a')||
'         end if;'||unistr('\000a')||
'         :p1_pergebnis_id := v_return;'||unistr('\000a')||
'      ELSIF v_return < 0 THEN -- Fehler beim kopieren'||unistr('\000a')||
'         :p1_bearb_modus := ''ANZEIGEN''; '||unistr('\000a')||
'         RAISE_APPLICATION_ERROR (-20000,fr';

p:=p||'gbg_s.holen_uebersetzung(181,v_sprache_id, '||unistr('\000a')||
'                                      to_char(v_return),''perg_set_festlegen''));'||unistr('\000a')||
'      ELSE -- p1_pergebnis_id is null'||unistr('\000a')||
'         :p1_bearb_modus := ''ANZEIGEN''; '||unistr('\000a')||
'         RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(181,v_sprache_id, '||unistr('\000a')||
'                                      ''90'',''perg_set_festlegen''));'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Aktuelles E';

p:=p||'rgebnisset festlegen bzw. anlegen'||unistr('\000a')||
'   IF :p1_pergebnis_id IS NULL THEN'||unistr('\000a')||
'      :p1_pergebnis_id := frgbg_s.perg_set_festlegen('||unistr('\000a')||
'                              :P1_FRAGEBOGEN_ID '||unistr('\000a')||
'                             ,:P1_ID '||unistr('\000a')||
'                             ,''LAST''    -- letzte Version holen, ansonsten neue erzeugen'||unistr('\000a')||
'                             ,v_sprache_id'||unistr('\000a')||
'                             ,NULL      -- Kuraufenthalt-';

p:=p||'ID'||unistr('\000a')||
'                            );'||unistr('\000a')||
''||unistr('\000a')||
'      -- Wähle die Standard-Zusatzmodule aus'||unistr('\000a')||
'      v_return :=  frgbg_s.FB_SET_FKAT_MODUL_DEF_AUSWAHL('||unistr('\000a')||
'         p_pergebnis_id                 => :p1_pergebnis_id,'||unistr('\000a')||
'         p_fas_login_personenstamm_id   => :fas_login_personenstamm_id ,'||unistr('\000a')||
'         p_fas_identitaet_persstamm_id  => :fas_identitaet_persstamm_id'||unistr('\000a')||
'       );'||unistr('\000a')||
'      if(v_return < 0) then'||unistr('\000a')||
'        RAISE_APPL';

p:=p||'ICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(9127,v_sprache_id));'||unistr('\000a')||
'      end if;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'  '||unistr('\000a')||
''||unistr('\000a')||
'   -- Defaultwerte festlegen'||unistr('\000a')||
'   IF :p1_bearb_modus = ''BEARBEITEN'' THEN'||unistr('\000a')||
'      v_return := frgbg_s.perg_set_default_ant(:p1_pergebnis_id);'||unistr('\000a')||
'      IF v_return < 0 THEN'||unistr('\000a')||
'         NULL;   -- Keine Fehlerausgabe bei Konvertierungsproblemen => Fehler wird in Protokoll festgehalten '||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'';

p:=p||''||unistr('\000a')||
'/* wird in Page 95 gesetzt'||unistr('\000a')||
''||unistr('\000a')||
'   -- Verrechnungsland setzen'||unistr('\000a')||
'   IF :fas_aufgerufen_von = ''BETREUER'' THEN'||unistr('\000a')||
'      :p1_VERRECHNUNGSLAND := frgbg_s.get_pers_option(:APP_USER,8); -- je nach Betreuereinstellung Kunde/Betreuer'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :p1_VERRECHNUNGSLAND := 1; -- Kunde'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Währungsermittlung abhängig vom Flag Verrechnungsland Betreuer oder Kunde'||unistr('\000a')||
'   :p1_waehrung_id := NVL(rezepte.get_id_';

p:=p||'waehrung_verr(:P1_ID,'||unistr('\000a')||
'                    v(''fas_identitaet_persstamm_id''), -- NEI 14.10.09 :FAS_LOGIN_PERSONENSTAMM_ID,'||unistr('\000a')||
'                    :p1_VERRECHNUNGSLAND),27);-- sonst CHF'||unistr('\000a')||
'   :p1_verrech_land_id := rezepte.get_land_id_verr(:P1_ID,'||unistr('\000a')||
'                    v(''fas_identitaet_persstamm_id''),-- NEI 14.10.09 :FAS_LOGIN_PERSONENSTAMM_ID,   '||unistr('\000a')||
'                    :p1_VERRECHNUNGSLAND) ;'||unistr('\000a')||
''||unistr('\000a')||
'   -- Prüfe Exi';

p:=p||'stenz der passenden Preisliste; ggf. wird die Waehrung an die Stdpreisliste angepasst'||unistr('\000a')||
'   v_preislistentyp := rezepte.get_preislisten_typ; -- z.Z. immer 1  '||unistr('\000a')||
'   v_sortiment_id := NVL(v(''FAS_SORTIMENT_ID''),'||unistr('\000a')||
'                           rezepte.GET_SORTIMENT_STD);  -- Standard-Sortiment der oberste Identitaet'||unistr('\000a')||
'   v_preisliste_id := rezepte.get_preisliste_id(:p1_waehrung_id,:p1_verrech_land_id ,'||unistr('\000a')||
'         ';

p:=p||'                v_preislistentyp,v_sortiment_id); '||unistr('\000a')||
'   :p1_waehrung_zeichen := rezepte.GET_WAEHRUNG_ZEICHEN(:p1_waehrung_id);'||unistr('\000a')||
'   :p1_preisliste_id := v_preisliste_id;'||unistr('\000a')||
'   -- Art_mwst_typ_id für Mischungen ermitteln'||unistr('\000a')||
'   /* NEI 17.04.2015 Ermittlung über Funktion wg. Ausnahmeregelung EU-Export der ApoRichter'||unistr('\000a')||
'   /* SELECT min(art_mwst_typ_id) into :p1_art_mwst_typ_id'||unistr('\000a')||
'   /* FROM laender'||unistr('\000a')||
'   /* WHERE id = ';

p:=p||':p1_verrech_land_id ; '||unistr('\000a')||
'   :p1_art_mwst_typ_id := rezepte.GET_ART_MWST_TYP_ID_MISCHUNG(:p1_verrech_land_id,p_persstamm_id_rechnsteller);'||unistr('\000a')||
''||unistr('\000a')||
'   -- Preisfaktor festlegen'||unistr('\000a')||
'   :p1_preisfaktor := to_number(frgbg_s.get_pers_option(NULL,23,v(''fas_identitaet_persstamm_id''),'||unistr('\000a')||
'                                :FAS_LOGIN_PERSONENSTAMM_ID),''FM0.0999'');'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'--MEL.P (''Pis aufgerufen 1 %1, %2,%3,%4'', v_PROT_ID, ''TEST''';

p:=p||', ''seite 1 fragebogen festlegen'', v(''fas_identitaet_persstamm_id''),:FAS_LOGIN_PERSONENSTAMM_ID,:p1_waehrung_id);'||unistr('\000a')||
''||unistr('\000a')||
'  /* APEX_UTIL.SET_PREFERENCE(        '||unistr('\000a')||
'             p_preference => ''FSP_LANGUAGE_PREFERENCE'','||unistr('\000a')||
'             p_value      => v_sprache,'||unistr('\000a')||
'             p_user       => :APP_USER);'||unistr('\000a')||
'   :p1_text := v_sprache;'||unistr('\000a')||
'  */'||unistr('\000a')||
''||unistr('\000a')||
'/*:p1_text :=  APEX_UTIL.GET_PREFERENCE(      '||unistr('\000a')||
'                   p_preference';

p:=p||' => ''FSP_LANGUAGE_PREFERENCE'','||unistr('\000a')||
'                   p_user       => :APP_USER);'||unistr('\000a')||
'*/'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3523313843107701 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 12,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'fragebogen_festlegen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'begin'||unistr('\000a')||
' /*'||unistr('\000a')||
'  -- Lösche alle augewählten Module, die nicht mehr erlaubt sind. '||unistr('\000a')||
'  delete from PERGEBNIS_MODUL_AUSWAHL where'||unistr('\000a')||
'     pergebnis_id = :P1_PERGEBNIS_ID and'||unistr('\000a')||
'     fkat_modul_id not in ( -- Hole alle erlaubten Module-IDs aus pers_optionen'||unistr('\000a')||
'              SELECT  ow.wert b '||unistr('\000a')||
'              FROM optionswerte ow, pers_optionen po, optionstypen ot, FKATEGORIE_MODULE fkm'||unistr('\000a')||
'              where ow.o';

p:=p||'pttyp_id = ot.id  --JOIN OT '||unistr('\000a')||
'                and ow.opttyp_id = 39 --Zusatzmodule '||unistr('\000a')||
'                and ow.opttyp_id = po.opttyp_id'||unistr('\000a')||
'                and ow.wert = po.wert'||unistr('\000a')||
'                and ow.wert = fkm.ID'||unistr('\000a')||
'                and (po.persstamm_id = frgbg_s.GET_PERS_OPT_PERS_ID(:FAS_LOGIN_PERSONENSTAMM_ID,ow.opttyp_id,'||unistr('\000a')||
'          FRGBG_S.GET_IDENTITAET_BETR(:FAS_LOGIN_PERSONENSTAMM_ID)) '||unistr('\000a')||
'    or po.perss';

p:=p||'tamm_id = frgbg_s.GET_PERS_OPT_PERS_ID(:FAS_LOGIN_PERSONENSTAMM_ID,ow.opttyp_id,'||unistr('\000a')||
'          FRGBG_S.GET_IDENTITAET_BETR(:fas_identitaet_persstamm_id)) '||unistr('\000a')||
'  );'||unistr('\000a')||
'*/'||unistr('\000a')||
'null;'||unistr('\000a')||
''||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 7141028499011230 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 22,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'check_erlaubte_modul_auswahl',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'/* Für nur aus, wenn der FB noch nicht ausgewertet wurde */'||unistr('\000a')||
'FRGBG_S.FB_CHECK_AUSWERTUNG(:P1_PERGEBNIS_ID) = 0',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_only_for_changed_rows=> 'Y',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_prepare_url_pw:= apex_util.prepare_url('||unistr('\000a')||
'   ''f?p=&APP_ID.:102:&SESSION.::&DEBUG.::P102_ID:''||:P1_ID);';

wwv_flow_api.create_page_process(
  p_id     => 2734215168388275 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 81,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_prepare_url_pw',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE '||unistr('\000a')||
'   v_sprache_id NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   :p1_bl_abbrechen := frgbg_s.holen_uebersetzung(161,v_sprache_id);'||unistr('\000a')||
'   :p1_bl_verwerfen := frgbg_s.holen_uebersetzung(510,v_sprache_id);'||unistr('\000a')||
'   --:p1_bl_loeschen  := frgbg_s.holen_uebersetzung(167,v_sprache_id);'||unistr('\000a')||
'   :p1_bl_speichern := frgbg_s.holen_uebersetzung(172,v_sprache_id);'||unistr('\000a')||
'   --:p1_bl_aendern   := fr';

p:=p||'gbg_s.holen_uebersetzung(162,v_sprache_id);'||unistr('\000a')||
'   --:p1_bl_erstellen := frgbg_s.holen_uebersetzung(163,v_sprache_id);'||unistr('\000a')||
'   :p1_bl_passwort_chg := frgbg_s.holen_uebersetzung(171,v_sprache_id);'||unistr('\000a')||
'   :P1_BL_WEITER     := frgbg_s.holen_uebersetzung(485,v_sprache_id); '||unistr('\000a')||
'   :P1_BL_HRV_LADEN := frgbg_s.holen_uebersetzung(5546,v_sprache_id);'||unistr('\000a')||
'   :P1_BL_SAVE_MODUL_AUSW := frgbg_s.holen_uebersetzung(9124,v_sprache_i';

p:=p||'d);'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'   :p1_region_titel_pwd_chg := frgbg_s.holen_uebersetzung(170,v_sprache_id);'||unistr('\000a')||
'   :p1_region_titel_hilfetexte := frgbg_s.holen_uebersetzung(220,v_sprache_id);'||unistr('\000a')||
'   :p1_region_titel_infotext := frgbg_s.holen_uebersetzung(247,v_sprache_id);'||unistr('\000a')||
'   --:p1_region_titel_auswertung := frgbg_s.holen_uebersetzung(3054,v_sprache_id);'||unistr('\000a')||
'   :p1_region_titel_hrv := frgbg_s.holen_uebersetzung(5544,v_sprache_id);'||unistr('\000a')||
'  ';

p:=p||' :P1_REGION_TITEL_MODUL_AUSW := frgbg_s.holen_uebersetzung(9122,v_sprache_id);'||unistr('\000a')||
'   :p1_hinweistitel := frgbg_s.holen_uebersetzung(3516,v_sprache_id);'||unistr('\000a')||
'   --:p1_laborwerte_hinweistext := frgbg_s.holen_uebersetzung(3517,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   :p1_info := frgbg_s.holen_uebersetzung(173,v_sprache_id);'||unistr('\000a')||
'   --:p1_druckopt_info := frgbg_s.holen_uebersetzung(3538,v_sprache_id);'||unistr('\000a')||
'   :p1_fehler := frgbg_s.holen_ueb';

p:=p||'ersetzung(487,v_sprache_id); '||unistr('\000a')||
''||unistr('\000a')||
'   :P1_NV_FRAGEBOGEN := frgbg_s.holen_uebersetzung(3839,v_sprache_id);'||unistr('\000a')||
''||unistr('\000a')||
'   '||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3525802330123303 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 90,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'button_labels_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'    i    number;'||unistr('\000a')||
'    v_sprache_id NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'    CURSOR c_kategorien '||unistr('\000a')||
'    IS'||unistr('\000a')||
'     SELECT k.*,frgbg_s.HOLEN_UEBERSETZUNG (k.tab_text_id   ,v_sprache_id) text --  u.text '||unistr('\000a')||
'     FROM fkategorien k --, uebersetzungen u -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'     WHERE k.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'       AND k.fk';

p:=p||'ategorie_id IS NULL                 -- Unterste Ebene'||unistr('\000a')||
'       --AND k.tab_text_id = u.TEXT_ID'||unistr('\000a')||
'       --AND u.SPRACHE_ID = v_sprache_id'||unistr('\000a')||
'       AND k.art = 1         -- Normale Tabs 1-10 (max. 30)'||unistr('\000a')||
'       AND k.satz_kennzeichen is null'||unistr('\000a')||
'     ORDER BY sort ;  '||unistr('\000a')||
'    CURSOR c_kategorien_labor '||unistr('\000a')||
'    IS'||unistr('\000a')||
'     SELECT k.*,frgbg_s.HOLEN_UEBERSETZUNG (k.tab_text_id   ,v_sprache_id) text --  u.text '||unistr('\000a')||
'     FROM fkate';

p:=p||'gorien k --, uebersetzungen u -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'     WHERE k.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'       AND k.fkategorie_id IS NULL                 -- Unterste Ebene'||unistr('\000a')||
'       --AND k.tab_text_id = u.TEXT_ID'||unistr('\000a')||
'       --AND u.SPRACHE_ID = v_sprache_id'||unistr('\000a')||
'       AND k.art = 2         -- Labor-Tabs 31-40 '||unistr('\000a')||
'       AND k.satz_kennzeichen is null'||unistr('\000a')||
'       AND frgbg_s.CHEC';

p:=p||'K_TAB_ANZEIGEN_N(:P1_PERGEBNIS_ID,k.id) = 1 -- NEI 8.05.14 neues Labortab TEAMW nur ausgewählte Modul-Kategorien'||unistr('\000a')||
'                                                                 -- Zur Zeit gibt es nur 1 Labortab => optimieren des Ladevorgangs; kann nach funktionaler ERmittlung der Apex-Page für Sprung aus der Übersichtsseite in die angezeigte Seite auch für die normalen Fk-Tabs erfolgen; zur Zeit';

p:=p||' aber nur bei Labortab.'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'     ORDER BY sort ;  '||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- AB r_kategorien.sort 90 beginnen Sondertabs, die extra zugeordnet werden'||unistr('\000a')||
'   i := 1;'||unistr('\000a')||
'   FOR r_kategorien IN c_kategorien LOOP'||unistr('\000a')||
'      IF i = 1 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab1_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab1_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P1_TAB1_KATEGORIE_ZEILEN := r_kategorie';

p:=p||'n.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF i = 2 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab2_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab2_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P1_TAB2_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF i = 3 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab3_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab3_kategorie_text := ';

p:=p||'r_kategorien.text;'||unistr('\000a')||
'             :P1_TAB3_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF i = 4 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab4_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab4_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P1_TAB4_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF i = 5 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab5_k';

p:=p||'ategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab5_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P1_TAB5_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF i = 6 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab6_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab6_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P1_TAB6_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
' ';

p:=p||'     ELSIF i = 7 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab7_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab7_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P1_TAB7_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF i = 8 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab8_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab8_kategorie_text := r_kategorien.text;'||unistr('\000a')||
' ';

p:=p||'            :P1_TAB8_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF i = 9 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab9_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab9_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P1_TAB9_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF i = 10 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p1_tab10_kategorie_id := r_k';

p:=p||'ategorien.id;'||unistr('\000a')||
'             :p1_tab10_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P1_TAB10_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF r_kategorien.sort = 90 THEN -- Ubersicht'||unistr('\000a')||
'             :p1_tab90_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab90_kategorie_text := r_kategorien.text;         '||unistr('\000a')||
'             :P1_TAB90_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'  ';

p:=p||'    ELSIF r_kategorien.sort = 91 THEN -- Formular'||unistr('\000a')||
'             :p1_tab91_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab91_kategorie_text := r_kategorien.text;         '||unistr('\000a')||
'             :P1_TAB91_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      ELSIF r_kategorien.sort = 95 THEN -- Auswertung'||unistr('\000a')||
'             :p1_tab95_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p1_tab95_kategorie_text := r';

p:=p||'_kategorien.text;         '||unistr('\000a')||
'             :P1_TAB95_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'      END IF;'||unistr('\000a')||
'      i := i+1;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   i := 1;'||unistr('\000a')||
'   FOR r_kategorien IN c_kategorien_labor LOOP'||unistr('\000a')||
'       IF i = 1 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p31_tab31_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p31_tab31_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P31_TAB31_KATEGORIE';

p:=p||'_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'       ELSIF i = 2 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p31_tab32_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p31_tab32_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P31_TAB32_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'       ELSIF i = 3 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p31_tab33_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'        ';

p:=p||'     :p31_tab33_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P31_TAB33_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'       ELSIF i = 4 AND r_kategorien.sort < 90 THEN'||unistr('\000a')||
'             :p31_tab34_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p31_tab34_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P31_TAB34_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'       ELSIF i = 5 AND r_kateg';

p:=p||'orien.sort < 90 THEN'||unistr('\000a')||
'             :p31_tab35_kategorie_id := r_kategorien.id;'||unistr('\000a')||
'             :p31_tab35_kategorie_text := r_kategorien.text;'||unistr('\000a')||
'             :P31_TAB35_KATEGORIE_ZEILEN := r_kategorien.apex_anz_zeilen;'||unistr('\000a')||
'       END IF;'||unistr('\000a')||
'       i := i+1;'||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3200507964368798 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 91,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Kategorien_laden',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id   number;'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT  frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text -- u.text'||unistr('\000a')||
'   from fkategorien fk -- uebersetzungen u -- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab1_kategorie_id or'||unistr('\000a')||
'          fk.fkatego';

p:=p||'rie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab1_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     --AND u.sprache_id =:fas_sprache_id'||unistr('\000a')||
'     --and fk.HINWEIS_TEXT_ID= u.TEXT_ID'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_hinweis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
'--mel.p(''Kategorie %1 Text --%2''';

p:=p||',v_prot_id,''hinweistext_init'',''test'',:p1_tab1_kategorie_id,:p1_hinweistext );'||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4126001010407220 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 92,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3867030124071646 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 160,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:PERSONENSTAMM:P1_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 7171813520739607 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 170,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Zeile abrufen aus PERSONENSTAMM',
  p_process_sql_clob => p,
  p_process_error_message=> 'Zeile kann nicht abgerufen werden.',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN   -- entsprechende Routine Page 110 '||unistr('\000a')||
' IF :fas_aufgerufen_von = ''PIS'' THEN'||unistr('\000a')||
'   IF   (:p1_aenderbar = ''J'') '||unistr('\000a')||
'     OR (:p1_aenderbar = ''N'' AND'||unistr('\000a')||
'         -- speziell berechtigt'||unistr('\000a')||
'         frgbg_s.check_fas_rolle(:APP_USER,''GESCHUETZTE_PERSONENDATEN_AENDERN'') > 0 '||unistr('\000a')||
'         )'||unistr('\000a')||
'      OR (:p1_aenderbar = ''N'' AND                 -- User hat sich selbst eingeloggt'||unistr('\000a')||
'          :fas_aufgerufen_von != ''BETREUER''';

p:=p||' and'||unistr('\000a')||
'          UPPER(:P1_USER_ACCOUNT)= UPPER(:APP_USER)'||unistr('\000a')||
'         )'||unistr('\000a')||
'   THEN'||unistr('\000a')||
'      :fas_pers_aenderbar := 1;'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'      :fas_pers_aenderbar := 0;'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 5331701953055984 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 180,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'setze_fas_pers_aenderbar',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||unistr('\000a')||
'  v_url varchar2(1000);'||unistr('\000a')||
'begin'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
'  v_url := APEX_UTIL.PREPARE_URL ('||unistr('\000a')||
'    p_url           => ''f?p=&APP_ID.:95:&APP_SESSION.'','||unistr('\000a')||
'    p_checksum_type => ''SESSION'''||unistr('\000a')||
'  );'||unistr('\000a')||
''||unistr('\000a')||
' owa_util.redirect_url(v_url);'||unistr('\000a')||
' apex_application.stop_apex_engine;'||unistr('\000a')||
''||unistr('\000a')||
''||unistr('\000a')||
' raise_application_error(-20000,''test'');'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 7565415690065172 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 210,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Jump zur Auswertung',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>'FRGBG_S.FB_CHECK_AUSWERTUNG(:P1_PERGEBNIS_ID) = 1 and :P140_JUMP_TO_AUSW_PAGE is not null',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_only_for_changed_rows=> 'Y',
  p_process_success_message=> 'test',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||unistr('\000a')||
'   /* z.B. GUS-Adr. darf nicht im FAS verändert werden */'||unistr('\000a')||
'   :p1_pers_readonly:=frgbg_T.check_pers_extern_verwaltet(:p1_EXTERN_VERWALTET ) ; '||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 10188407956752849 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1,
  p_process_sequence=> 220,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set_adr_readonly',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_only_for_changed_rows=> 'Y',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00002
prompt  ...PAGE 2: Aktualisieren FRAGEBOGENANZEIGE 2
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 2
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 2'
 ,p_step_title => 'Aktualisieren Fragebogenanzeige 2'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren Fragebogenanzeige'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20140514134624'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'fkategorie_text,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'WHEN hilfe_text_id is not null '||unistr('\000a')||
'THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'|| hilfe_text_id||'',''||frage_text_id)'||unistr('\000a')||
'|| '''''',700,425)">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '' '''||unistr('\000a')||
'END LINK,'||unistr('\000a')||
'frage_text,'||unistr('\000a')||
'FRGBG_S.ERZEUGEN_FELDER'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    ANZEIGETYP_ID, FR';

s:=s||'AGEBOGEN_ID, FRAGE_ID, PERSONENSTAMM_ID, 1, 1,'||unistr('\000a')||
'    :p1_pergebnis_id,'||unistr('\000a')||
'    :fas_sprache_id --frgbg_s.get_sprache_id(:APP_USER)'||unistr('\000a')||
'  )'||unistr('\000a')||
'Auswahl'||unistr('\000a')||
'from v_fragen'||unistr('\000a')||
'where fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
' -- AND fkategorie_id = :p1_tab2_kategorie_id '||unistr('\000a')||
'  and (fkategorie_fkategorie_id = :p1_tab2_kategorie_id or'||unistr('\000a')||
'       FKATEGORIE_fkategorie_ID is null and fkategorie_id= :p1_tab2_kategorie_id'||unistr('\000a')||
'      )'||unistr('\000a')||
'  AND personens';

s:=s||'tamm_id = :p1_id'||unistr('\000a')||
'  AND sprache_id =:fas_sprache_id /*frgbg_s.get_sprache_id(:APP_USER)*/'||unistr('\000a')||
'  AND fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'  AND visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'order by fkategorie_sort,frage_sort';

wwv_flow_api.create_report_region (
  p_id=> 2936706869150862 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_plug_query_max_columns=> 5,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'GENERIC_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P1_TAB2_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'REPEAT_HEADINGS_ON_BREAK_1',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'MILLIMETERS',
  p_prn_paper_size=> 'A4',
  p_prn_width=> 297,
  p_prn_height=> 210,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_prn_page_header_alignment=> 'LEFT',
  p_prn_page_footer_alignment=> 'LEFT',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3719024819259343 + wwv_flow_api.g_id_offset,
  p_region_id=> 2936706869150862 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COL01',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3719123369259345 + wwv_flow_api.g_id_offset,
  p_region_id=> 2936706869150862 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COL02',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3719224152259345 + wwv_flow_api.g_id_offset,
  p_region_id=> 2936706869150862 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COL03',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3719307273259345 + wwv_flow_api.g_id_offset,
  p_region_id=> 2936706869150862 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COL04',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3719403975259345 + wwv_flow_api.g_id_offset,
  p_region_id=> 2936706869150862 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'COL05',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3171331126915939 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND'||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 3733401186621528 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5563602079737128 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 35,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12571031152805784 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 2,
  p_button_sequence=> 10,
  p_button_plug_id => 2936706869150862+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'') and 1=2',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5379510387440500 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 2,
  p_button_sequence=> 15,
  p_button_plug_id => 2936706869150862+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS'' and 1=2',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2937128050150868 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 2,
  p_button_sequence=> 20,
  p_button_plug_id => 2936706869150862+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:2:&SESSION.:TEST:&DEBUG.:::',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2937307681150870 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 2,
  p_button_sequence=> 30,
  p_button_plug_id => 2936706869150862+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN'' and 1=2',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3869401399214694 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 2,
  p_button_sequence=> 40,
  p_button_plug_id => 2936706869150862+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3869712612227412 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3869401399214694+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>2938031120150876 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPLIC';

p:=p||'ATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
' :P1_FEHLER := null;'||unistr('\000a')||
' FRGBG_S.SPEICHERN'||unistr('\000a')||
'  ( '||unistr('\000a')||
'   v_user,:P1_TAB2_KATEGORIE_ID,:p1_fragebogen_id,:p1_id,:p1_pergebnis_id,'||unistr('\000a')||
'   v_sprache_id , :P1_FEHLER'||unistr('\000a')||
'  );'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung auch in pergebnisse festhal';

p:=p||'ten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 2937727204150873 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT  frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text '||unistr('\000a')||
'   from fkategorien fk '||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab2_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab2_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_hi';

p:=p||'nweis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4122002180066846 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 5082019814628467 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 7943415164355043 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3870513136265410 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 2
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00003
prompt  ...PAGE 3: Aktualisieren FRAGEBOGENANZEIGE 3
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 3
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 3'
 ,p_step_title => 'Aktualisieren Fragebogenanzeige 3'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren Fragebogenanzeige 2'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20131202095029'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'fkategorie_text,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'WHEN hilfe_text_id is not null '||unistr('\000a')||
'THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'|| hilfe_text_id||'',''||frage_text_id)'||unistr('\000a')||
'|| '''''',700,425)">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '' '''||unistr('\000a')||
'END LINK,'||unistr('\000a')||
'frage_text,'||unistr('\000a')||
'FRGBG_S.ERZEUGEN_FELDER'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    ANZEIGETYP_ID, FR';

s:=s||'AGEBOGEN_ID, FRAGE_ID, PERSONENSTAMM_ID, 1, 1,'||unistr('\000a')||
'    :p1_pergebnis_id,'||unistr('\000a')||
'    :fas_sprache_id'||unistr('\000a')||
'  )'||unistr('\000a')||
'Auswahl'||unistr('\000a')||
'from v_fragen'||unistr('\000a')||
'where fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  --AND fkategorie_id = :p1_tab3_kategorie_id '||unistr('\000a')||
'  and (fkategorie_fkategorie_id = :p1_tab3_kategorie_id or'||unistr('\000a')||
'       FKATEGORIE_fkategorie_ID is null and fkategorie_id= :p1_tab3_kategorie_id'||unistr('\000a')||
'      )'||unistr('\000a')||
'  AND personenstamm_id = :p1_id'||unistr('\000a')||
'  AND sprache_id = ';

s:=s||':fas_sprache_id'||unistr('\000a')||
'  AND fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'  AND visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'order by fkategorie_sort,frage_sort';

wwv_flow_api.create_report_region (
  p_id=> 3005614467756332 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P1_TAB3_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'REPEAT_HEADINGS_ON_BREAK_1',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9557819090961017 + wwv_flow_api.g_id_offset,
  p_region_id=> 3005614467756332 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4746432287421034 + wwv_flow_api.g_id_offset,
  p_region_id=> 3005614467756332 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3005919010756342 + wwv_flow_api.g_id_offset,
  p_region_id=> 3005614467756332 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'FRAGEBOGENANZEIGE',
  p_ref_column_name=> 'FRAGE_TEXT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3005809812756340 + wwv_flow_api.g_id_offset,
  p_region_id=> 3005614467756332 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUSWAHL',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3171719829922107 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 3744324706101406 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_FEHLER IS NOT NULL',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5568418449798665 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 35,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12575504533826493 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3,
  p_button_sequence=> 10,
  p_button_plug_id => 3005614467756332+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5380400176475417 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3,
  p_button_sequence=> 15,
  p_button_plug_id => 3005614467756332+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3006003153756342 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3,
  p_button_sequence=> 20,
  p_button_plug_id => 3005614467756332+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3006221404756343 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3,
  p_button_sequence=> 30,
  p_button_plug_id => 3005614467756332+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3873322845486378 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3,
  p_button_sequence=> 40,
  p_button_plug_id => 3005614467756332+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3876132158536415 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3873322845486378+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>3007132213756350 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id;--frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'   v_prot_id     number;'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutda';

p:=p||'t THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
' :P1_FEHLER := null;'||unistr('\000a')||
''||unistr('\000a')||
'--mel.p(''Vor speichern!'',v_prot_id,''TEST'',''102/3:daten_uebernehmen'');'||unistr('\000a')||
' FRGBG_S.SPEICHERN'||unistr('\000a')||
'  ( '||unistr('\000a')||
'   v_user, :P1_TAB3_KATEGORIE_ID, :p1_fragebogen_id, :p1_id,:p1_pergebnis_id,'||unistr('\000a')||
'   frgbg_s.get_sprache_id(:APP_USER), :P1_FEHLER'||unistr('\000a')||
'  );'||unistr('\000a')||
' IF :p1_fehler';

p:=p||' IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung auch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3006824974756348 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT  frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text '||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab3_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab3_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_hin';

p:=p||'weis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4122207028068312 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 5083207132634245 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 7954130074510701 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3881201131612575 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 3
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00004
prompt  ...PAGE 4: Aktualisieren FRAGEBOGENANZEIGE 4
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 4
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 4'
 ,p_step_title => 'Aktualisieren Fragebogenanzeige 4'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren Fragebogenanzeige 4'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20131202095138'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3172129872925039 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 3835719692813473 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5568624682800433 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'fkategorie_text,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'WHEN hilfe_text_id is not null '||unistr('\000a')||
'THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'|| hilfe_text_id||'',''||frage_text_id)'||unistr('\000a')||
'|| '''''',700,425)">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '' '''||unistr('\000a')||
'END LINK, '||unistr('\000a')||
'frage_text,'||unistr('\000a')||
'FRGBG_S.ERZEUGEN_FELDER'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    ANZEIGETYP_ID, F';

s:=s||'RAGEBOGEN_ID, FRAGE_ID, PERSONENSTAMM_ID, 1, 1,'||unistr('\000a')||
'    :p1_pergebnis_id,'||unistr('\000a')||
'    :fas_sprache_id'||unistr('\000a')||
'  )'||unistr('\000a')||
'Auswahl'||unistr('\000a')||
'from v_fragen'||unistr('\000a')||
'where fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  --AND fkategorie_id = :p1_tab4_kategorie_id '||unistr('\000a')||
'  and (fkategorie_fkategorie_id = :p1_tab4_kategorie_id or'||unistr('\000a')||
'       FKATEGORIE_fkategorie_ID is null and fkategorie_id= :p1_tab4_kategorie_id'||unistr('\000a')||
'      )  '||unistr('\000a')||
'  AND personenstamm_id = :p1_id'||unistr('\000a')||
'  AND sprache_id';

s:=s||' = :fas_sprache_id'||unistr('\000a')||
'  AND fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'  AND visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'order by fkategorie_sort,frage_sort';

wwv_flow_api.create_report_region (
  p_id=> 9582321752900017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 35,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;">'||unistr('\000a')||
'',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P1_TAB4_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'REPEAT_HEADINGS_ON_BREAK_1',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9582510461900025 + wwv_flow_api.g_id_offset,
  p_region_id=> 9582321752900017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9582623526900028 + wwv_flow_api.g_id_offset,
  p_region_id=> 9582321752900017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9582717676900028 + wwv_flow_api.g_id_offset,
  p_region_id=> 9582321752900017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'FRAGEBOGENANZEIGE',
  p_ref_column_name=> 'FRAGE_TEXT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9582803587900028 + wwv_flow_api.g_id_offset,
  p_region_id=> 9582321752900017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUSWAHL',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12579028344852339 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 10,
  p_button_plug_id => 9582321752900017+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5380611604478707 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 15,
  p_button_plug_id => 9582321752900017+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 9586832272912500 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 20,
  p_button_plug_id => 9582321752900017+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3836102256813476 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 30,
  p_button_plug_id => 9582321752900017+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3873530464488606 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 40,
  p_button_plug_id => 9582321752900017+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3877220646552042 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3873530464488606+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>3836810384813482 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id;   --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPL';

p:=p||'ICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
' :P1_FEHLER := null;'||unistr('\000a')||
' FRGBG_S.SPEICHERN'||unistr('\000a')||
'  ( '||unistr('\000a')||
'   v_user, :P1_TAB4_KATEGORIE_ID, :p1_fragebogen_id, :p1_id,:p1_pergebnis_id, '||unistr('\000a')||
'   frgbg_s.get_sprache_id(:APP_USER), :P1_FEHLER'||unistr('\000a')||
'  );'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung a';

p:=p||'uch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ; END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3836526042813482 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT  frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text '||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab4_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab4_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_hin';

p:=p||'weis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4123529790368198 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 5083914058636231 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 7955005963513229 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3881427450620149 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 4
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00005
prompt  ...PAGE 5: Aktualisieren FRAGEBOGENANZEIGE 5
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 5
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 5'
 ,p_step_title => 'Aktualisieren Fragebogenanzeige 5'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren Fragebogenanzeige 2'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20131202095125'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 3906129862222779 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5431216663936112 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5568830916802267 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'fkategorie_text,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'WHEN hilfe_text_id is not null '||unistr('\000a')||
'THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'|| hilfe_text_id||'',''||frage_text_id)'||unistr('\000a')||
'|| '''''',700,425)">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '' '''||unistr('\000a')||
'END LINK,'||unistr('\000a')||
'frage_text,'||unistr('\000a')||
'FRGBG_S.ERZEUGEN_FELDER'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    ANZEIGETYP_ID, FR';

s:=s||'AGEBOGEN_ID, FRAGE_ID, PERSONENSTAMM_ID, 1, 1,'||unistr('\000a')||
'    :p1_pergebnis_id,'||unistr('\000a')||
'    :fas_sprache_id'||unistr('\000a')||
'  )'||unistr('\000a')||
'Auswahl'||unistr('\000a')||
'from v_fragen'||unistr('\000a')||
'where fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  --AND fkategorie_id = :p1_tab5_kategorie_id '||unistr('\000a')||
'  and (fkategorie_fkategorie_id = :p1_tab5_kategorie_id or'||unistr('\000a')||
'       FKATEGORIE_fkategorie_ID is null and fkategorie_id= :p1_tab5_kategorie_id'||unistr('\000a')||
'      )  '||unistr('\000a')||
'  AND personenstamm_id = :p1_id'||unistr('\000a')||
'  AND sprache_id ';

s:=s||'= :fas_sprache_id'||unistr('\000a')||
'  AND fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'  AND visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'order by fkategorie_sort,frage_sort';

wwv_flow_api.create_report_region (
  p_id=> 9590010371925151 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 35,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P1_TAB5_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'REPEAT_HEADINGS_ON_BREAK_1',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9590221866925151 + wwv_flow_api.g_id_offset,
  p_region_id=> 9590010371925151 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9590327602925151 + wwv_flow_api.g_id_offset,
  p_region_id=> 9590010371925151 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9590425213925151 + wwv_flow_api.g_id_offset,
  p_region_id=> 9590010371925151 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'FRAGEBOGENANZEIGE',
  p_ref_column_name=> 'FRAGE_TEXT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9590501397925151 + wwv_flow_api.g_id_offset,
  p_region_id=> 9590010371925151 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUSWAHL',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12580416008858190 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 10,
  p_button_plug_id => 9590010371925151+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5380817838480434 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 15,
  p_button_plug_id => 9590010371925151+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3906306992222779 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 20,
  p_button_plug_id => 9590010371925151+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS = ''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3906511648222779 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 30,
  p_button_plug_id => 9590010371925151+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS = ''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3873702891490050 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5,
  p_button_sequence=> 40,
  p_button_plug_id => 9590010371925151+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3877427572554037 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3873702891490050+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>3907225421222779 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id;   --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPL';

p:=p||'ICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
' :P1_FEHLER := null;'||unistr('\000a')||
' FRGBG_S.SPEICHERN'||unistr('\000a')||
'  ( '||unistr('\000a')||
'   v_user, :P1_TAB5_KATEGORIE_ID, :p1_fragebogen_id, :p1_id,:p1_pergebnis_id, '||unistr('\000a')||
'   frgbg_s.get_sprache_id(:APP_USER), :P1_FEHLER'||unistr('\000a')||
'  );'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung a';

p:=p||'uch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3906910336222779 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT  frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text'||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab5_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab5_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_hinw';

p:=p||'eis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4123701871369581 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 5084620292637995 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 7957031936520721 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3881632645621695 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 5
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00006
prompt  ...PAGE 6: Aktualisieren FRAGEBOGENANZEIGE 6
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 6
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 6'
 ,p_step_title => 'Aktualisieren Fragebogenanzeige 6'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren Fragebogenanzeige 6'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20131202095229'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3172507839928123 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 3939516399728028 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5569005074804248 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'fkategorie_text,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'WHEN hilfe_text_id is not null '||unistr('\000a')||
'THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'|| hilfe_text_id||'',''||frage_text_id)'||unistr('\000a')||
'|| '''''',700,425)">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '' '''||unistr('\000a')||
'END LINK,'||unistr('\000a')||
'frage_text,'||unistr('\000a')||
'FRGBG_S.ERZEUGEN_FELDER'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    ANZEIGETYP_ID, FR';

s:=s||'AGEBOGEN_ID, FRAGE_ID, PERSONENSTAMM_ID, 1, 1,'||unistr('\000a')||
'    :p1_pergebnis_id,'||unistr('\000a')||
'    :fas_sprache_id'||unistr('\000a')||
'  )'||unistr('\000a')||
'Auswahl'||unistr('\000a')||
'from v_fragen'||unistr('\000a')||
'where fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  --AND fkategorie_id = :p1_tab6_kategorie_id '||unistr('\000a')||
'  and (fkategorie_fkategorie_id = :p1_tab6_kategorie_id or'||unistr('\000a')||
'       FKATEGORIE_fkategorie_ID is null and fkategorie_id= :p1_tab6_kategorie_id'||unistr('\000a')||
'      )    AND personenstamm_id = :p1_id'||unistr('\000a')||
'  AND sprache_id =';

s:=s||' :fas_sprache_id'||unistr('\000a')||
'  AND fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'  AND visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'order by fkategorie_sort,frage_sort';

wwv_flow_api.create_report_region (
  p_id=> 9595613057944815 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 35,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P1_TAB6_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'REPEAT_HEADINGS_ON_BREAK_1',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9598911492959075 + wwv_flow_api.g_id_offset,
  p_region_id=> 9595613057944815 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9595902733944817 + wwv_flow_api.g_id_offset,
  p_region_id=> 9595613057944815 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9596009849944817 + wwv_flow_api.g_id_offset,
  p_region_id=> 9595613057944815 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'FRAGEBOGENANZEIGE',
  p_ref_column_name=> 'FRAGE_TEXT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9596118476944817 + wwv_flow_api.g_id_offset,
  p_region_id=> 9595613057944815 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUSWAHL',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12581718217868307 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 10,
  p_button_plug_id => 9595613057944815+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5381021993481667 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 15,
  p_button_plug_id => 9595613057944815+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3939725275728028 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 20,
  p_button_plug_id => 9595613057944815+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS = ''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3939915811728028 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 30,
  p_button_plug_id => 9595613057944815+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS = ''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3873907739491488 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6,
  p_button_sequence=> 40,
  p_button_plug_id => 9595613057944815+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3877807617557726 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3873907739491488+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>3940617820728029 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id;   --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPL';

p:=p||'ICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
' :P1_FEHLER := null;'||unistr('\000a')||
' FRGBG_S.SPEICHERN'||unistr('\000a')||
'  ( '||unistr('\000a')||
'   v_user, :P1_TAB6_KATEGORIE_ID, :p1_fragebogen_id, :p1_id,'||unistr('\000a')||
'   :p1_pergebnis_id,frgbg_s.get_sprache_id(:APP_USER), :P1_FEHLER'||unistr('\000a')||
'  );'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung au';

p:=p||'ch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3940308996728029 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT  frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text '||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab6_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab6_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_hin';

p:=p||'weis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4123913645372954 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 5085329642640701 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 7957503324521898 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3881805418623292 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 6
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00007
prompt  ...PAGE 7: Aktualisieren FRAGEBOGENANZEIGE 7
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 7
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 7'
 ,p_step_title => 'Aktualisieren Fragebogenanzeige 7'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren Fragebogenanzeige 7'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20131202095304'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2985128567016939 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 3951519598741157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5569209922805611 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'fkategorie_text,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'WHEN hilfe_text_id is not null '||unistr('\000a')||
'THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'|| hilfe_text_id||'',''||frage_text_id)'||unistr('\000a')||
'|| '''''',700,425)">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '' '''||unistr('\000a')||
'END LINK,'||unistr('\000a')||
'frage_text,'||unistr('\000a')||
'FRGBG_S.ERZEUGEN_FELDER'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    ANZEIGETYP_ID, FR';

s:=s||'AGEBOGEN_ID, FRAGE_ID, PERSONENSTAMM_ID, 1, 1,'||unistr('\000a')||
'    :p1_pergebnis_id,'||unistr('\000a')||
'    :fas_sprache_id'||unistr('\000a')||
'  )'||unistr('\000a')||
'Auswahl'||unistr('\000a')||
'from v_fragen'||unistr('\000a')||
'where fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  --AND fkategorie_id = :p1_tab7_kategorie_id '||unistr('\000a')||
'  and (fkategorie_fkategorie_id = :p1_tab7_kategorie_id or'||unistr('\000a')||
'       FKATEGORIE_fkategorie_ID is null and fkategorie_id= :p1_tab7_kategorie_id'||unistr('\000a')||
'      )   '||unistr('\000a')||
'  and personenstamm_id = :p1_id'||unistr('\000a')||
'  AND sprache_id';

s:=s||' = :fas_sprache_id'||unistr('\000a')||
'  AND fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'  AND visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'order by fkategorie_sort,frage_sort';

wwv_flow_api.create_report_region (
  p_id=> 9604401114979270 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 35,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;">',
  p_footer=> '</div>'||unistr('\000a')||
'',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P1_TAB7_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'REPEAT_HEADINGS_ON_BREAK_1',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_content_disposition=> 'ATTACHMENT',
  p_prn_document_header=> 'APEX',
  p_prn_units=> 'MILLIMETERS',
  p_prn_paper_size=> 'A4',
  p_prn_width_units=> 'PERCENTAGE',
  p_prn_width=> 297,
  p_prn_height=> 210,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_prn_page_header_alignment=> 'LEFT',
  p_prn_page_footer_alignment=> 'LEFT',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9604603498979270 + wwv_flow_api.g_id_offset,
  p_region_id=> 9604401114979270 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9604700226979271 + wwv_flow_api.g_id_offset,
  p_region_id=> 9604401114979270 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9604814956979271 + wwv_flow_api.g_id_offset,
  p_region_id=> 9604401114979270 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'FRAGEBOGENANZEIGE',
  p_ref_column_name=> 'FRAGE_TEXT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9604915865979271 + wwv_flow_api.g_id_offset,
  p_region_id=> 9604401114979270 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUSWAHL',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12582732762872529 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7,
  p_button_sequence=> 10,
  p_button_plug_id => 9604401114979270+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5381225456482721 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7,
  p_button_sequence=> 15,
  p_button_plug_id => 9604401114979270+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3951718400741157 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7,
  p_button_sequence=> 20,
  p_button_plug_id => 9604401114979270+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3951914583741157 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7,
  p_button_sequence=> 30,
  p_button_plug_id => 9604401114979270+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3874113280493109 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7,
  p_button_sequence=> 40,
  p_button_plug_id => 9604401114979270+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3878015236559875 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3874113280493109+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>3952605079741159 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id;   --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPL';

p:=p||'ICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
' :P1_FEHLER := null;'||unistr('\000a')||
' FRGBG_S.SPEICHERN'||unistr('\000a')||
'  ( '||unistr('\000a')||
'   v_user, :P1_TAB7_KATEGORIE_ID, :p1_fragebogen_id, :p1_id, '||unistr('\000a')||
'   :p1_pergebnis_id,frgbg_s.get_sprache_id(:APP_USER), :P1_FEHLER'||unistr('\000a')||
'  );'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung a';

p:=p||'uch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3952305180741159 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT  frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text '||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab7_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab7_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--me';

p:=p||'l.p(''Kategorie %1'',v_prot_id,''hinweistext_init'',''test'',:p1_tab7_kategorie_id);'||unistr('\000a')||
'   FOR r_hinweis in c_hinweis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
'--mel.p(''Kategorie %1 Text --%2'',v_prot_id,''hinweistext_init'',''test'',:p1_tab7_kategorie_id,:p1_hinweistext );'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4120808835974209 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 5086001030641951 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 7958007133523050 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3882013383625559 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 7
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00008
prompt  ...PAGE 8: Aktualisieren FRAGEBOGENANZEIGE 8
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 8
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 8'
 ,p_step_title => 'Aktualisieren Fragebogenanzeige 8'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren Fragebogenanzeige 8'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20131202095332'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 3961120367746315 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5569413385806693 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 55,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5928519472602248 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'fkategorie_text,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'WHEN hilfe_text_id is not null '||unistr('\000a')||
'THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'|| hilfe_text_id||'',''||frage_text_id)'||unistr('\000a')||
'|| '''''',700,425)">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '' '''||unistr('\000a')||
'END LINK,'||unistr('\000a')||
'frage_text,'||unistr('\000a')||
'FRGBG_S.ERZEUGEN_FELDER'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    ANZEIGETYP_ID, FR';

s:=s||'AGEBOGEN_ID, FRAGE_ID, PERSONENSTAMM_ID, 1, 1,'||unistr('\000a')||
'    :p1_pergebnis_id,'||unistr('\000a')||
'    :fas_sprache_id'||unistr('\000a')||
'  )'||unistr('\000a')||
'Auswahl'||unistr('\000a')||
'from v_fragen'||unistr('\000a')||
'where fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  --AND fkategorie_id = :p1_tab8_kategorie_id '||unistr('\000a')||
'  and (fkategorie_fkategorie_id = :p1_tab8_kategorie_id or'||unistr('\000a')||
'       FKATEGORIE_fkategorie_ID is null and fkategorie_id= :p1_tab8_kategorie_id'||unistr('\000a')||
'      )  '||unistr('\000a')||
'  AND personenstamm_id = :p1_id'||unistr('\000a')||
'  AND sprache_id ';

s:=s||'= :fas_sprache_id'||unistr('\000a')||
'  AND fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'  AND visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'order by fkategorie_sort,frage_sort';

wwv_flow_api.create_report_region (
  p_id=> 9610412242010846 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 35,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px; min-width:1000px;">',
  p_footer=> '</div>'||unistr('\000a')||
'',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P1_TAB8_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'REPEAT_HEADINGS_ON_BREAK_1',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9610600885010846 + wwv_flow_api.g_id_offset,
  p_region_id=> 9610412242010846 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9610721546010846 + wwv_flow_api.g_id_offset,
  p_region_id=> 9610412242010846 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9610802121010846 + wwv_flow_api.g_id_offset,
  p_region_id=> 9610412242010846 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'FRAGEBOGENANZEIGE',
  p_ref_column_name=> 'FRAGE_TEXT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9610912324010846 + wwv_flow_api.g_id_offset,
  p_region_id=> 9610412242010846 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUSWAHL',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12583717655877626 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8,
  p_button_sequence=> 10,
  p_button_plug_id => 9610412242010846+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5381429612483871 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8,
  p_button_sequence=> 15,
  p_button_plug_id => 9610412242010846+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3961314671746317 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8,
  p_button_sequence=> 20,
  p_button_plug_id => 9610412242010846+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3961522850746317 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8,
  p_button_sequence=> 30,
  p_button_plug_id => 9610412242010846+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3874318821494686 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8,
  p_button_sequence=> 40,
  p_button_plug_id => 9610412242010846+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3878425625562899 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3874318821494686+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>3962200771746317 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id;   --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPL';

p:=p||'ICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
' :P1_FEHLER := null;'||unistr('\000a')||
' FRGBG_S.SPEICHERN'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    v_user, :P1_TAB8_KATEGORIE_ID, :p1_fragebogen_id, :p1_id, '||unistr('\000a')||
'    :p1_pergebnis_id,frgbg_s.get_sprache_id(:APP_USER), :P1_FEHLER'||unistr('\000a')||
'  );'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung';

p:=p||' auch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3961914921746317 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT  frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text'||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab8_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab8_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_hinw';

p:=p||'eis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4124321956375368 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 5086705532643260 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 7958714059525082 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3882425157628960 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 8
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00009
prompt  ...PAGE 9: Aktualisieren FRAGEBOGENANZEIGE 9
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 9
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 9'
 ,p_step_title => 'Aktualisieren Fragebogenanzeige 9'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren Fragebogenanzeige 9'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_javascript_code => 
'$(document).ready(function() {'||unistr('\000a')||
''||unistr('\000a')||
'   $(''td[headers^="FRAGE_TEXT"]'').css(''vertical-align'',''top'');'||unistr('\000a')||
'   $(''td[headers^="AUSWAHL_"]'').parent().find(''td[headers^="AUSWAHL_"], td[headers^="FRAGE_TEXT"] '').css({'||unistr('\000a')||
'       ''border-bottom'' :''1px solid #E3E3E3'''||unistr('\000a')||
'   });'||unistr('\000a')||
'   /*$(''td[headers="AUSWAHL_004"] label'').css({'||unistr('\000a')||
'       ''width'' :''120px'','||unistr('\000a')||
'       ''display'' : ''inline-block'','||unistr('\000a')||
'       ''vertical-align'' : ''middle'''||unistr('\000a')||
'   }'||
');*/'||unistr('\000a')||
'});'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20140327103623'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 3970710045753250 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5569625506810130 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 55,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5928727437604473 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'fkategorie_text,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'WHEN hilfe_text_id is not null '||unistr('\000a')||
'THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'|| hilfe_text_id||'',''||frage_text_id)'||unistr('\000a')||
'|| '''''',700,425)">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '' '''||unistr('\000a')||
'END LINK,'||unistr('\000a')||
'frage_text,'||unistr('\000a')||
'FRGBG_S.ERZEUGEN_FELDER'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    ANZEIGETYP_ID, FR';

s:=s||'AGEBOGEN_ID, FRAGE_ID, PERSONENSTAMM_ID, 1, 1,'||unistr('\000a')||
'    :p1_pergebnis_id,'||unistr('\000a')||
'    :fas_sprache_id'||unistr('\000a')||
'  )'||unistr('\000a')||
'Auswahl'||unistr('\000a')||
'from v_fragen'||unistr('\000a')||
'where fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  --AND fkategorie_id = :p1_tab9_kategorie_id '||unistr('\000a')||
'  and (fkategorie_fkategorie_id = :p1_tab9_kategorie_id or'||unistr('\000a')||
'       FKATEGORIE_fkategorie_ID is null and fkategorie_id= :p1_tab9_kategorie_id'||unistr('\000a')||
'      )  '||unistr('\000a')||
'  AND personenstamm_id = :p1_id'||unistr('\000a')||
'  AND sprache_id ';

s:=s||'= :fas_sprache_id'||unistr('\000a')||
'  AND fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'  AND visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'order by fkategorie_sort,frage_sort';

wwv_flow_api.create_report_region (
  p_id=> 9615710773029331 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 35,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px; min-width:1400px;">',
  p_footer=> '</div>'||unistr('\000a')||
'',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P1_TAB9_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'REPEAT_HEADINGS_ON_BREAK_1',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9615926524029331 + wwv_flow_api.g_id_offset,
  p_region_id=> 9615710773029331 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9616030294029331 + wwv_flow_api.g_id_offset,
  p_region_id=> 9615710773029331 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9616107154029331 + wwv_flow_api.g_id_offset,
  p_region_id=> 9615710773029331 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'FRAGEBOGENANZEIGE',
  p_ref_column_name=> 'FRAGE_TEXT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9616200918029334 + wwv_flow_api.g_id_offset,
  p_region_id=> 9615710773029331 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUSWAHL',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12589926360908525 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 9,
  p_button_sequence=> 10,
  p_button_plug_id => 9615710773029331+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5381602039485395 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 9,
  p_button_sequence=> 15,
  p_button_plug_id => 9615710773029331+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3970919805753250 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 9,
  p_button_sequence=> 20,
  p_button_plug_id => 9615710773029331+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3971102942753250 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 9,
  p_button_sequence=> 30,
  p_button_plug_id => 9615710773029331+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3874730249497995 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 9,
  p_button_sequence=> 40,
  p_button_plug_id => 9615710773029331+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3878819869570695 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3874730249497995+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>3971812070753251 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id;   --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPL';

p:=p||'ICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
' :P1_FEHLER := null;'||unistr('\000a')||
' FRGBG_S.SPEICHERN'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    v_user, :P1_TAB9_KATEGORIE_ID, :p1_fragebogen_id, :p1_id,:p1_pergebnis_id, '||unistr('\000a')||
'    frgbg_s.get_sprache_id(:APP_USER), :P1_FEHLER'||unistr('\000a')||
'  );'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung';

p:=p||' auch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3971520915753251 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text'||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab9_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab9_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_hinwe';

p:=p||'is LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4124526805376804 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 5087411073644800 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 7959218215526246 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3882630005630343 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 9
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00010
prompt  ...PAGE 10: Aktualisieren FRAGEBOGENANZEIGE 10
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 10
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 10'
 ,p_step_title => 'Aktualisieren Fragebogenanzeige 10'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren Fragebogenanzeige 10'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_javascript_code => 
'  '
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20140630160016'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 3980412090758512 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5569829315811279 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 55,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5929411985609470 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'fkategorie_text,'||unistr('\000a')||
'CASE'||unistr('\000a')||
'WHEN hilfe_text_id is not null '||unistr('\000a')||
'THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'|| hilfe_text_id||'',''||frage_text_id)'||unistr('\000a')||
'|| '''''',700,425)">'''||unistr('\000a')||
'|| ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'|| ''</a>'''||unistr('\000a')||
'ELSE '' '''||unistr('\000a')||
'END LINK,'||unistr('\000a')||
'frage_text,'||unistr('\000a')||
'FRGBG_S.ERZEUGEN_FELDER'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    ANZEIGETYP_ID, FR';

s:=s||'AGEBOGEN_ID, FRAGE_ID, PERSONENSTAMM_ID, 1,1 ,'||unistr('\000a')||
'    :p1_pergebnis_id,'||unistr('\000a')||
'    :fas_sprache_id'||unistr('\000a')||
'  )'||unistr('\000a')||
'Auswahl'||unistr('\000a')||
'from v_fragen'||unistr('\000a')||
'where fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  --AND fkategorie_id = :p1_tab10_kategorie_id '||unistr('\000a')||
'  and (fkategorie_fkategorie_id = :p1_tab10_kategorie_id or'||unistr('\000a')||
'       FKATEGORIE_fkategorie_ID is null and fkategorie_id= :p1_tab10_kategorie_id'||unistr('\000a')||
'      )  '||unistr('\000a')||
'  AND personenstamm_id = :p1_id'||unistr('\000a')||
'  AND sprache_';

s:=s||'id = :fas_sprache_id'||unistr('\000a')||
'  AND fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'  AND visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'order by fkategorie_sort,frage_sort';

wwv_flow_api.create_report_region (
  p_id=> 9621506879047137 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 35,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px; width:800px">',
  p_footer=> '</div>'||unistr('\000a')||
'',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P1_TAB10_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'REPEAT_HEADINGS_ON_BREAK_1',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9621720905047137 + wwv_flow_api.g_id_offset,
  p_region_id=> 9621506879047137 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9621828616047137 + wwv_flow_api.g_id_offset,
  p_region_id=> 9621506879047137 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9621915893047137 + wwv_flow_api.g_id_offset,
  p_region_id=> 9621506879047137 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'FRAGEBOGENANZEIGE',
  p_ref_column_name=> 'FRAGE_TEXT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 9622013855047137 + wwv_flow_api.g_id_offset,
  p_region_id=> 9621506879047137 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUSWAHL',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12591106059912112 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10,
  p_button_sequence=> 10,
  p_button_plug_id => 9621506879047137+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5381810696487834 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10,
  p_button_sequence=> 15,
  p_button_plug_id => 9621506879047137+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3980618524758512 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10,
  p_button_sequence=> 20,
  p_button_plug_id => 9621506879047137+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3980805697758514 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10,
  p_button_sequence=> 30,
  p_button_plug_id => 9621506879047137+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3874901983499304 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10,
  p_button_sequence=> 40,
  p_button_plug_id => 9621506879047137+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3879028527573208 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3874901983499304+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>3981522174758514 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id;   --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPL';

p:=p||'ICATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
' v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
' :P1_FEHLER := null;'||unistr('\000a')||
' FRGBG_S.SPEICHERN'||unistr('\000a')||
'  ( '||unistr('\000a')||
'    v_user, :P1_TAB10_KATEGORIE_ID, :p1_fragebogen_id, :p1_id,:p1_pergebnis_id, '||unistr('\000a')||
'    frgbg_s.get_sprache_id(:APP_USER), :P1_FEHLER'||unistr('\000a')||
'  );'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderun';

p:=p||'g auch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3981218871758514 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text'||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p1_tab10_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p1_tab10_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_hin';

p:=p||'weis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4124905465380078 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 5088116960646479 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 7959722717527507 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3882802778632014 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 10
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00013
prompt  ...PAGE 13: saferpaytest
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 13
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_name => 'saferpaytest'
 ,p_step_title => 'saferpaytest'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'saferpaytest'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'NO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'N'
 ,p_cache_page_yn => 'N'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20110304114752'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 1497927960298194 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13,
  p_plug_name=> 'saferpay',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2885905427489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 1498132630298201 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 13,
  p_button_sequence=> 10,
  p_button_plug_id => 1497927960298194+wwv_flow_api.g_id_offset,
  p_button_name    => 'START',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Start',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 1498319208298205 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 13,
  p_button_sequence=> 20,
  p_button_plug_id => 1497927960298194+wwv_flow_api.g_id_offset,
  p_button_name    => 'CLEAR',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Clear',
  p_button_position=> 'REGION_TEMPLATE_EDIT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1500013901298214 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&FLOW_ID.:13:&SESSION.::&DEBUG.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>1498319208298205+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>1500221885298215 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13,
  p_branch_name=> '',
  p_branch_action=> '&P13_URL.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>1498132630298201+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 22-SEP-2010 10:40 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>1500422005298215 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:215:&SESSION.:WINDOW_CLOSE_PAY_SPEICHERN:&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 90,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':P13_PAYSTATUS = 1 and 1=2',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>1500623762298215 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:215:&SESSION.:WINDOW_CLOSE_PAY_ERROR:&DEBUG.:13::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 100,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':P13_PAYSTATUS in (2,3) and 1=2',
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 27-SEP-2010 11:14 by FRGBG');
 
wwv_flow_api.create_page_branch(
  p_id=>1500830779298217 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:13:&SESSION.::&DEBUG.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 110,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 02-MAR-2011 15:43 by BRIGITTE.NEIDHART');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1498503673298206 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13,
  p_name=>'P13_URL',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 1497927960298194+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Url',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 300,
  p_cMaxlength=> 32767,
  p_cHeight=> 10,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1498722709298209 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13,
  p_name=>'P13_PAYSTATUS',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 1497927960298194+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Paystatus',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1498912963298209 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13,
  p_name=>'P13_RETURNPARAM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 1497927960298194+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Returnparam',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_DISPLAY_ONLY',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'VALUE',
  p_attribute_04 => 'Y',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1499102981298209 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13,
  p_name=>'P13_WARENKORB_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 1497927960298194+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Warenkorb Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'N',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_betrag   NUMBER          ;'||unistr('\000a')||
'   v_waehrung VARCHAR2(5)     ;'||unistr('\000a')||
'   v_bez      VARCHAR2(1000)  ;'||unistr('\000a')||
'   v_lnk_page NUMBER          := :APP_PAGE_ID; -- Nach Saferpay soll wieder zur aktuelle Seite'||unistr('\000a')||
'   v_bestell_nr  VARCHAR2(80) ;'||unistr('\000a')||
'   v_waehrung_id number;'||unistr('\000a')||
'   v_plandatum   date;'||unistr('\000a')||
'   v_prot_id  NUMBER;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'mel.p(''Preis %1, Waehrung %2 (%3), datum %4, wk %5, url %6'',v_prot_id,''test'',''gen_url 102/220';

p:=p||''','||unistr('\000a')||
'          v_betrag,v_waehrung_id, v_waehrung,v_plandatum,:p13_warenkorb_id,:p13_url);'||unistr('\000a')||
'   BEGIN'||unistr('\000a')||
'   SELECT NVL(wk.gesamtpreis,0)+NVL(wk.mwst_betrag_1,0)+NVL(wk.mwst_betrag_2,0),'||unistr('\000a')||
'          wk.waehrung_id,w.code,wk.plandatum, HTMLDB_UTIL.URL_ENCODE(wk.bemerkung),wk.id'||unistr('\000a')||
'   INTO   v_betrag,v_waehrung_id, v_waehrung,v_plandatum ,v_bez,v_bestell_nr'||unistr('\000a')||
'   FROM warenkoerbe wk, waehrungen w'||unistr('\000a')||
'   WHERE wk.id = :';

p:=p||'p13_warenkorb_id'||unistr('\000a')||
'     and wk.waehrung_id = w.id;'||unistr('\000a')||
'   EXCEPTION'||unistr('\000a')||
'   WHEN others THEN NULL; '||unistr('\000a')||
'   END;'||unistr('\000a')||
'   v_bez := replace(replace(replace(replace(replace(replace(replace(v_bez,''Ä'',''Ae'')'||unistr('\000a')||
'                   ,''Ü'',''Ue''),''Ö'',''Oe''),''ä'',''ae''),''ü'',''ue''),''ö'',''oe''),''ß'',''ss'');'||unistr('\000a')||
''||unistr('\000a')||
'   :p13_url := frgbg_s.cc_payinit(v_betrag,v_waehrung,v_bez,v_lnk_page,v_bestell_nr);'||unistr('\000a')||
''||unistr('\000a')||
'mel.p(''Preis %1, Waehrung %2 (%3), datum %4, wk %5';

p:=p||', url %6, %7'',v_prot_id,''test'',''gen_url 102/220'','||unistr('\000a')||
'          v_betrag,v_waehrung_id, v_waehrung,v_plandatum,:p13_warenkorb_id,:p13_url,v_bez);'||unistr('\000a')||
''||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1499304759298211 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 13,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'gen_url',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>1498132630298201 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'l_host VARCHAR2(2000);'||unistr('\000a')||
'v_str  varchar2(2000);'||unistr('\000a')||
'v_prot_id number;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'--l_host := portal.wwctx_api.get_user_id;'||unistr('\000a')||
'--htp.p(''portal.wwctx_api.get_user_id = ''||l_host);htp.br;'||unistr('\000a')||
''||unistr('\000a')||
'--l_host := portal.wwctx_api.get_sessionid;'||unistr('\000a')||
'--htp.p(''portal.wwctx_api.get_sessionid = ''||l_host);htp.br;'||unistr('\000a')||
''||unistr('\000a')||
'--l_host := portal.wwctx_api.get_host;'||unistr('\000a')||
'--htp.p(''portal.wwctx_api.get_host = ''||l_host);htp.br;'||unistr('\000a')||
''||unistr('\000a')||
'--l_host := portal';

p:=p||'.wwctx_api.get_base_url;'||unistr('\000a')||
'--htp.p(''portal.wwctx_api.get_base_url = ''||l_host);htp.br;'||unistr('\000a')||
''||unistr('\000a')||
'l_host := OWA_UTIL.GET_CGI_ENV(''REQUEST_PROTOCOL'');'||unistr('\000a')||
'--htp.p(''OWA_UTIL.GET_CGI_ENV("REQUEST_PROTOCOL") = ''||l_host);htp.br;'||unistr('\000a')||
'v_str := v_str||'',''||''OWA_UTIL.GET_CGI_ENV("REQUEST_PROTOCOL") = ''||l_host;'||unistr('\000a')||
''||unistr('\000a')||
'l_host := OWA_UTIL.GET_CGI_ENV(''HTTP_HOST'');'||unistr('\000a')||
'--htp.p(''OWA_UTIL.GET_CGI_ENV("HTTP_HOST") = ''||l_host);htp.br;'||unistr('\000a')||
'v_str';

p:=p||' := v_str||'',''||''OWA_UTIL.GET_CGI_ENV("HTTP_HOST") = ''||l_host;'||unistr('\000a')||
''||unistr('\000a')||
'--l_host := hiims_r1.hiimsutil.getPortalURLPrefix;'||unistr('\000a')||
'--htp.p(''hiims_r1.hiimsutil.getPortalURLPrefix = ''||l_host);htp.br;'||unistr('\000a')||
''||unistr('\000a')||
'--l_host := portal.wwctx_api.get_query_string;'||unistr('\000a')||
'--htp.p(''portal.wwctx_api.get_query_string = ''||l_host);htp.br;'||unistr('\000a')||
''||unistr('\000a')||
'l_host := owa_util.get_cgi_env(''QUERY_STRING'');'||unistr('\000a')||
'--htp.p(''owa_util.get_cgi_env("QUERY_STRING") = ''||l_ho';

p:=p||'st);htp.br;'||unistr('\000a')||
'v_str := v_str||'',''||''owa_util.get_cgi_env("QUERY_STRING") = ''||l_host;'||unistr('\000a')||
''||unistr('\000a')||
'l_host := owa_util.get_cgi_env(''PATH_INFO'');'||unistr('\000a')||
'--htp.p(''owa_util.get_cgi_env("PATH_INFO") = ''||l_host);htp.br;'||unistr('\000a')||
'v_str := v_str||'',''||''owa_util.get_cgi_env("PATH_INFO") = ''||l_host;'||unistr('\000a')||
''||unistr('\000a')||
'l_host := owa_util.get_cgi_env(''REQUEST_URI'');'||unistr('\000a')||
'--htp.p(''owa_util.get_cgi_env("REQUEST_URI") = ''||l_host);htp.br;'||unistr('\000a')||
'v_str := v_str||'',''||''o';

p:=p||'wa_util.get_cgi_env("REQUEST_URI") = ''||l_host;'||unistr('\000a')||
''||unistr('\000a')||
'l_host := owa_util.get_cgi_env(''DOCUMENT_URI'');'||unistr('\000a')||
'--htp.p(''owa_util.get_cgi_env("DOCUMENT_URI") = ''||l_host);htp.br;'||unistr('\000a')||
'v_str := v_str||'',''||''owa_util.get_cgi_env("DOCUMENT_URI") = ''||l_host;'||unistr('\000a')||
''||unistr('\000a')||
'mel.p(v_str,v_prot_id,''INFO'',''URL'');'||unistr('\000a')||
''||unistr('\000a')||
'htp.p(''Done...'');'||unistr('\000a')||
'EXCEPTION'||unistr('\000a')||
'WHEN OTHERS'||unistr('\000a')||
'THEN'||unistr('\000a')||
'htp.br;'||unistr('\000a')||
'htp.p(''Error!'');'||unistr('\000a')||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1499507036298212 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 13,
  p_process_sequence=> 15,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'get_afterpay_url',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':p13_paystatus in (1)',
  p_process_when_type=>'NEVER',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'220';

wwv_flow_api.create_page_process(
  p_id     => 1499715484298212 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 13,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'cache_clear',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when_button_id=>1498319208298205 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 13
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00014
prompt  ...PAGE 14: Master Detail
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 14
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Master Detail'
 ,p_step_title => 'Master Detail'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_javascript_code => 
'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
 ,p_page_is_public_y_n => 'N'
 ,p_cache_page_yn => 'N'
 ,p_help_text => 
'No help is available for this page.'
 ,p_last_updated_by => 'BRIGITTE.NEIDHART'
 ,p_last_upd_yyyymmddhh24miss => '20150414102544'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 18448613921840312 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14,
  p_plug_name=> 'Edit LABOR_ANALYSEWERTE',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2885905427489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => true,
  p_plug_new_grid_column  => true,
  p_plug_display_column=> null,
  p_plug_display_point=> 'BODY_3',
  p_plug_item_display_point=> 'ABOVE',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||unistr('\000a')||
'"ID",'||unistr('\000a')||
'"WSH_KUNDENAUFTRAG_POS_ID",'||unistr('\000a')||
'"INH_GRENZWERTTYP_WARN",'||unistr('\000a')||
'"MENGENART_MN_REZEPT_ID",'||unistr('\000a')||
'"REICHWEITE",'||unistr('\000a')||
'"PRODKENNZ_ID",'||unistr('\000a')||
'"P_REZEPT_ID",'||unistr('\000a')||
'"MENGENART_ID",'||unistr('\000a')||
'"MENGE",'||unistr('\000a')||
'"VOLUMEN",'||unistr('\000a')||
'"GEWICHT",'||unistr('\000a')||
'"PREIS",'||unistr('\000a')||
'"MWST_BETRAG",'||unistr('\000a')||
'"MWST_SATZ",'||unistr('\000a')||
'"WK_STATUS_ID",'||unistr('\000a')||
'"STATUS_AENDERDATUM",'||unistr('\000a')||
'"STATUS_AENDERVISUM",'||unistr('\000a')||
'"ETIKETTENTYP",'||unistr('\000a')||
'"BEMERKUNG",'||unistr('\000a')||
'"ERFDAT",'||unistr('\000a')||
'"ERFUSER",'||unistr('\000a')||
'"MUTDAT",'||unistr('\000a')||
'"MUTUSER",'||unistr('\000a')||
'"INH_GRENZWERTTYP_ID",'||unistr('\000a')||
'"PROVISIONSPUNKTWERT",'||unistr('\000a')||
'"';

s:=s||'PROVISIONSPUNKTE",'||unistr('\000a')||
'"REZEPT_MENGE",'||unistr('\000a')||
'"REZEPT_GEWICHT",'||unistr('\000a')||
'"REZEPT_MENGENART_ID"'||unistr('\000a')||
'from "#OWNER#"."WARENKORB_DETAILS"'||unistr('\000a')||
'where "ID" = :P14_AUFTRAG_ID_INTERN'||unistr('\000a')||
'';

wwv_flow_api.create_report_region (
  p_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14,
  p_name=> 'WARENKORB_DETAILS Detail',
  p_region_name=>'',
  p_template=> 2885905427489437+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => true,
  p_new_grid_column  => true,
  p_display_column=> null,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_display_when_condition=> 'P14_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_plug_caching=> 'NOT_CACHED',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 2899210279489446+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '10',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_no_data_found=> 'No data found.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '500',
  p_query_asc_image=> 'apex/builder/dup.gif',
  p_query_asc_image_attr=> 'width="16" height="16" alt="" ',
  p_query_desc_image=> 'apex/builder/ddown.gif',
  p_query_desc_image_attr=> 'width="16" height="16" alt="" ',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18470009158840535 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CHECK$01',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Select Row',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'CHECKBOX',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_derived_column=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18458420164840478 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source_type=> 'T',
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18458508982840481 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'WSH_KUNDENAUFTRAG_POS_ID',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Wsh Kundenauftrag Pos Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'WSH_KUNDENAUFTRAG_POS_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18458623345840481 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'INH_GRENZWERTTYP_WARN',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Inh Grenzwerttyp Warn',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'INH_GRENZWERTTYP_WARN',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18458719500840481 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'MENGENART_MN_REZEPT_ID',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Mengenart Mn Rezept Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'MENGENART_MN_REZEPT_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18458831682840481 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'REICHWEITE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Reichweite',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'REICHWEITE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18458929308840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'PRODKENNZ_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Prodkennz Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'PRODKENNZ_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459002346840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'P_REZEPT_ID',
  p_column_display_sequence=> 8,
  p_column_heading=> 'P Rezept Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'P_REZEPT_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459107099840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'MENGENART_ID',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Mengenart Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'MENGENART_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459210217840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'MENGE',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Menge',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'MENGE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459326402840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'VOLUMEN',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Volumen',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'VOLUMEN',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459420084840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'GEWICHT',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Gewicht',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'GEWICHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459507562840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'PREIS',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Preis',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'PREIS',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459631051840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'MWST_BETRAG',
  p_column_display_sequence=> 14,
  p_column_heading=> 'Mwst Betrag',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'MWST_BETRAG',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459712902840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'MWST_SATZ',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Mwst Satz',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'MWST_SATZ',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459801147840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'WK_STATUS_ID',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Wk Status Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'WK_STATUS_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18459900381840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS_AENDERDATUM',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Status Aenderdatum',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'DATE_PICKER',
  p_column_width=> '12',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'STATUS_AENDERDATUM',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460011835840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS_AENDERVISUM',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Status Aendervisum',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'STATUS_AENDERVISUM',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460107799840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'ETIKETTENTYP',
  p_column_display_sequence=> 19,
  p_column_heading=> 'Etikettentyp',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'ETIKETTENTYP',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460212459840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 20,
  p_form_element_id=> null,
  p_column_alias=> 'BEMERKUNG',
  p_column_display_sequence=> 20,
  p_column_heading=> 'Bemerkung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'BEMERKUNG',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460302715840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 21,
  p_form_element_id=> null,
  p_column_alias=> 'ERFDAT',
  p_column_display_sequence=> 21,
  p_column_heading=> 'Erfdat',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'DATE_PICKER',
  p_column_width=> '12',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'ERFDAT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460414554840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 22,
  p_form_element_id=> null,
  p_column_alias=> 'ERFUSER',
  p_column_display_sequence=> 22,
  p_column_heading=> 'Erfuser',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'ERFUSER',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460527212840482 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 23,
  p_form_element_id=> null,
  p_column_alias=> 'MUTDAT',
  p_column_display_sequence=> 23,
  p_column_heading=> 'Mutdat',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'DATE_PICKER',
  p_column_width=> '12',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'MUTDAT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460622428840483 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 24,
  p_form_element_id=> null,
  p_column_alias=> 'MUTUSER',
  p_column_display_sequence=> 24,
  p_column_heading=> 'Mutuser',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'MUTUSER',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460712073840483 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 25,
  p_form_element_id=> null,
  p_column_alias=> 'INH_GRENZWERTTYP_ID',
  p_column_display_sequence=> 25,
  p_column_heading=> 'Inh Grenzwerttyp Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'INH_GRENZWERTTYP_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460827871840483 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 26,
  p_form_element_id=> null,
  p_column_alias=> 'PROVISIONSPUNKTWERT',
  p_column_display_sequence=> 26,
  p_column_heading=> 'Provisionspunktwert',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'PROVISIONSPUNKTWERT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18460927871840483 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 27,
  p_form_element_id=> null,
  p_column_alias=> 'PROVISIONSPUNKTE',
  p_column_display_sequence=> 27,
  p_column_heading=> 'Provisionspunkte',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'PROVISIONSPUNKTE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18461004217840483 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 28,
  p_form_element_id=> null,
  p_column_alias=> 'REZEPT_MENGE',
  p_column_display_sequence=> 28,
  p_column_heading=> 'Rezept Menge',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'REZEPT_MENGE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18461101544840483 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 29,
  p_form_element_id=> null,
  p_column_alias=> 'REZEPT_GEWICHT',
  p_column_display_sequence=> 29,
  p_column_heading=> 'Rezept Gewicht',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'REZEPT_GEWICHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 18461211174840483 + wwv_flow_api.g_id_offset,
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 30,
  p_form_element_id=> null,
  p_column_alias=> 'REZEPT_MENGENART_ID',
  p_column_display_sequence=> 30,
  p_column_heading=> 'Rezept Mengenart Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_column_width=> '16',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_ref_schema=> 'FRGBG',
  p_ref_table_name=> 'WARENKORB_DETAILS',
  p_ref_column_name=> 'REZEPT_MENGENART_ID',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 18448907389840331 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14,
  p_button_sequence=> 30,
  p_button_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Apply Changes',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'P14_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 18461614972840511 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14,
  p_button_sequence=> 40,
  p_button_plug_id => 18458112192840460+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_ADD',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Add Row',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:apex.widget.tabular.addRow();',
  p_button_execute_validations=>'N',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 18449211426840333 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14,
  p_button_sequence=> 10,
  p_button_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Cancel',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:0:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 18448823502840331 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14,
  p_button_sequence=> 40,
  p_button_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Create',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> 'P14_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 18449022870840331 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14,
  p_button_sequence=> 20,
  p_button_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Delete',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:apex.confirm(htmldb_delete_message,''DELETE'');',
  p_button_execute_validations=>'N',
  p_button_condition=> 'P14_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'DELETE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 18461532081840511 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14,
  p_button_sequence=> 20,
  p_button_plug_id => 18458112192840460+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES_MRD',
  p_button_action  => 'REDIRECT_URL',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> 'Delete Checked',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:apex.confirm(htmldb_delete_message,''APPLY_CHANGES_MRD'');',
  p_button_execute_validations=>'N',
  p_button_condition=> 'select 1 '||unistr('\000a')||
'from "#OWNER#"."WARENKORB_DETAILS"'||unistr('\000a')||
'where "ID" = :P14_AUFTRAG_ID_INTERN',
  p_button_condition_type=> 'EXISTS',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>18457908205840452 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:0:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'REQUEST_IN_CONDITION',
  p_branch_condition=> 'SAVE,DELETE,CREATE',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>18470107067840535 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:14:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18449829597840398 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Id',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18450031549840422 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_WARENKORB_DETAIL_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Warenkorb Detail Id',
  p_source=>'WARENKORB_DETAIL_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18450218251840425 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_GEBURTSDATUM',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Geburtsdatum',
  p_source=>'GEBURTSDATUM',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DATE_PICKER',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_04 => 'button',
  p_attribute_05 => 'N',
  p_attribute_07 => 'NONE',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18450427486840427 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_ANALYSEKUERZEL',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Analysekuerzel',
  p_source=>'ANALYSEKUERZEL',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18450621439840428 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_ERGEBNISWERT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Ergebniswert',
  p_source=>'ERGEBNISWERT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18450822538840428 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_EINHEIT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Einheit',
  p_source=>'EINHEIT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18451023305840429 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_WERTEBEREICH',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Wertebereich',
  p_source=>'WERTEBEREICH',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 1000,
  p_cHeight=> 4,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18451223715840430 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_AT_BEARB_DATUM',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'At Bearb Datum',
  p_source=>'AT_BEARB_DATUM',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DATE_PICKER',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_04 => 'button',
  p_attribute_05 => 'N',
  p_attribute_07 => 'NONE',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18451417584840431 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_SATZ_KENNZEICHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Satz Kennzeichen',
  p_source=>'SATZ_KENNZEICHEN',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18451615887840431 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_ERFDAT',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Erfdat',
  p_source=>'ERFDAT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DATE_PICKER',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_04 => 'button',
  p_attribute_05 => 'N',
  p_attribute_07 => 'NONE',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18451818267840434 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_ERFUSER',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Erfuser',
  p_source=>'ERFUSER',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18452015109840434 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_MUTDAT',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Mutdat',
  p_source=>'MUTDAT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_DATE_PICKER',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_04 => 'button',
  p_attribute_05 => 'N',
  p_attribute_07 => 'NONE',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18452202755840435 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_MUTUSER',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Mutuser',
  p_source=>'MUTUSER',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18452421143840435 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_DATEINAME',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Dateiname',
  p_source=>'DATEINAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> 4,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18452619928840436 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_AT_BEMERKUNG',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'At Bemerkung',
  p_source=>'AT_BEMERKUNG',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXTAREA',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> 4,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18452811520840436 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_AT_PERSANTWORT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'At Persantwort Id',
  p_source=>'AT_PERSANTWORT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18453023858840437 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_ERGEBNISWERT_TEXT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Ergebniswert Text Id',
  p_source=>'ERGEBNISWERT_TEXT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18453204784840437 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_ERGEBNISWERT_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 180,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Ergebniswert Text',
  p_source=>'ERGEBNISWERT_TEXT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'N',
  p_attribute_02 => 'N',
  p_attribute_03 => 'N',
  p_attribute_04 => 'TEXT',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18453426043840438 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_LABOR_ANALYSEKUERZEL_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 190,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Labor Analysekuerzel Id',
  p_source=>'LABOR_ANALYSEKUERZEL_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18453607574840438 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_BEZUG_EINHEIT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 200,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Bezug Einheit Id',
  p_source=>'BEZUG_EINHEIT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18453828571840439 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_LABOR_ERSATZWERT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 210,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Labor Ersatzwert Id',
  p_source=>'LABOR_ERSATZWERT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18454004269840439 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_MIN_WERTEBEREICH',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 220,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Min Wertebereich',
  p_source=>'MIN_WERTEBEREICH',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18454203428840440 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_MAX_WERTEBEREICH',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 230,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Max Wertebereich',
  p_source=>'MAX_WERTEBEREICH',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18454400457840440 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_LABOR_FAS_ERSATZWERT_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 240,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Labor Fas Ersatzwert Id',
  p_source=>'LABOR_FAS_ERSATZWERT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>18454602943840441 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14,
  p_name=>'P14_LABOR_AUFTRAG_STATUS_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> true,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 250,
  p_item_plug_id => 18448613921840312+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Labor Auftrag Status Id',
  p_source=>'LABOR_AUFTRAG_STATUS_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'NATIVE_NUMBER_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> null,
  p_rowspan=> null,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900122745489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_03 => 'right',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18462308700840519 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'WSH_KUNDENAUFTRAG_POS_ID must be numeric',
  p_validation_sequence=> 20,
  p_validation => 'WSH_KUNDENAUFTRAG_POS_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'WSH_KUNDENAUFTRAG_POS_ID',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18462509513840522 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'INH_GRENZWERTTYP_WARN must be numeric',
  p_validation_sequence=> 30,
  p_validation => 'INH_GRENZWERTTYP_WARN',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'INH_GRENZWERTTYP_WARN',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18462715519840522 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MENGENART_MN_REZEPT_ID must be numeric',
  p_validation_sequence=> 40,
  p_validation => 'MENGENART_MN_REZEPT_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MENGENART_MN_REZEPT_ID',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18462918137840522 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'REICHWEITE must be numeric',
  p_validation_sequence=> 50,
  p_validation => 'REICHWEITE',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'REICHWEITE',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18463100036840523 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'PRODKENNZ_ID must be numeric',
  p_validation_sequence=> 60,
  p_validation => 'PRODKENNZ_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'PRODKENNZ_ID',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18463330782840523 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'P_REZEPT_ID must be numeric',
  p_validation_sequence=> 70,
  p_validation => 'P_REZEPT_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'P_REZEPT_ID',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18463511678840523 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MENGENART_ID must be numeric',
  p_validation_sequence=> 80,
  p_validation => 'MENGENART_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MENGENART_ID',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18463727656840523 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MENGE not null',
  p_validation_sequence=> 90,
  p_validation => 'MENGE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MENGE',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18463918234840524 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MENGE must be numeric',
  p_validation_sequence=> 90,
  p_validation => 'MENGE',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MENGE',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18464111213840524 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'VOLUMEN must be numeric',
  p_validation_sequence=> 100,
  p_validation => 'VOLUMEN',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'VOLUMEN',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18464322436840524 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'GEWICHT must be numeric',
  p_validation_sequence=> 110,
  p_validation => 'GEWICHT',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'GEWICHT',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18464526756840524 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'PREIS not null',
  p_validation_sequence=> 120,
  p_validation => 'PREIS',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'PREIS',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18464725247840525 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'PREIS must be numeric',
  p_validation_sequence=> 120,
  p_validation => 'PREIS',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'PREIS',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18464927201840525 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MWST_BETRAG not null',
  p_validation_sequence=> 130,
  p_validation => 'MWST_BETRAG',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MWST_BETRAG',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18465115072840525 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MWST_BETRAG must be numeric',
  p_validation_sequence=> 130,
  p_validation => 'MWST_BETRAG',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MWST_BETRAG',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18465331539840525 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MWST_SATZ not null',
  p_validation_sequence=> 140,
  p_validation => 'MWST_SATZ',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MWST_SATZ',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18465514635840525 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MWST_SATZ must be numeric',
  p_validation_sequence=> 140,
  p_validation => 'MWST_SATZ',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MWST_SATZ',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18465727099840526 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'WK_STATUS_ID not null',
  p_validation_sequence=> 150,
  p_validation => 'WK_STATUS_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'WK_STATUS_ID',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18465904273840526 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'WK_STATUS_ID must be numeric',
  p_validation_sequence=> 150,
  p_validation => 'WK_STATUS_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'WK_STATUS_ID',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18466132398840526 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'STATUS_AENDERDATUM not null',
  p_validation_sequence=> 160,
  p_validation => 'STATUS_AENDERDATUM',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'STATUS_AENDERDATUM',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18466315528840526 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'STATUS_AENDERDATUM must be a valid date',
  p_validation_sequence=> 160,
  p_validation => 'STATUS_AENDERDATUM',
  p_validation_type => 'ITEM_IS_DATE',
  p_error_message => '#COLUMN_HEADER# must be a valid date.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'STATUS_AENDERDATUM',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18466500046840526 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'STATUS_AENDERVISUM not null',
  p_validation_sequence=> 170,
  p_validation => 'STATUS_AENDERVISUM',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'STATUS_AENDERVISUM',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18466717196840527 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'ETIKETTENTYP must be numeric',
  p_validation_sequence=> 180,
  p_validation => 'ETIKETTENTYP',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'ETIKETTENTYP',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18466909253840527 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'ERFDAT not null',
  p_validation_sequence=> 200,
  p_validation => 'ERFDAT',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'ERFDAT',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18467118773840527 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'ERFDAT must be a valid date',
  p_validation_sequence=> 200,
  p_validation => 'ERFDAT',
  p_validation_type => 'ITEM_IS_DATE',
  p_error_message => '#COLUMN_HEADER# must be a valid date.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'ERFDAT',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18467301442840528 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'ERFUSER not null',
  p_validation_sequence=> 210,
  p_validation => 'ERFUSER',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'ERFUSER',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18467513466840528 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MUTDAT not null',
  p_validation_sequence=> 220,
  p_validation => 'MUTDAT',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MUTDAT',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18467700024840528 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MUTDAT must be a valid date',
  p_validation_sequence=> 220,
  p_validation => 'MUTDAT',
  p_validation_type => 'ITEM_IS_DATE',
  p_error_message => '#COLUMN_HEADER# must be a valid date.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MUTDAT',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18467921862840528 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'MUTUSER not null',
  p_validation_sequence=> 230,
  p_validation => 'MUTUSER',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'MUTUSER',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18468102292840528 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'INH_GRENZWERTTYP_ID must be numeric',
  p_validation_sequence=> 240,
  p_validation => 'INH_GRENZWERTTYP_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'INH_GRENZWERTTYP_ID',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18468322264840529 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'PROVISIONSPUNKTWERT not null',
  p_validation_sequence=> 250,
  p_validation => 'PROVISIONSPUNKTWERT',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'PROVISIONSPUNKTWERT',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18468525757840529 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'PROVISIONSPUNKTWERT must be numeric',
  p_validation_sequence=> 250,
  p_validation => 'PROVISIONSPUNKTWERT',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'PROVISIONSPUNKTWERT',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18468728800840529 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'PROVISIONSPUNKTE not null',
  p_validation_sequence=> 260,
  p_validation => 'PROVISIONSPUNKTE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '#COLUMN_HEADER# must have a value.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'PROVISIONSPUNKTE',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18468921170840529 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'PROVISIONSPUNKTE must be numeric',
  p_validation_sequence=> 260,
  p_validation => 'PROVISIONSPUNKTE',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'PROVISIONSPUNKTE',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18469104984840529 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'REZEPT_MENGE must be numeric',
  p_validation_sequence=> 270,
  p_validation => 'REZEPT_MENGE',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'REZEPT_MENGE',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18469303455840530 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'REZEPT_GEWICHT must be numeric',
  p_validation_sequence=> 280,
  p_validation => 'REZEPT_GEWICHT',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'REZEPT_GEWICHT',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18469504928840530 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_tabular_form_region_id => 18458112192840460 + wwv_flow_api.g_id_offset,
  p_validation_name => 'REZEPT_MENGENART_ID must be numeric',
  p_validation_sequence=> 290,
  p_validation => 'REZEPT_MENGENART_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '#COLUMN_HEADER# must be numeric.',
  p_validation_condition=> ':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_exec_cond_for_each_row=> 'N',
  p_only_for_changed_rows=> 'Y',
  p_associated_column=> 'REZEPT_MENGENART_ID',
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:LABOR_ANALYSEWERTE:P14_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 18457414115840448 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from LABOR_ANALYSEWERTE',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:LABOR_ANALYSEWERTE:P14_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 18457603499840451 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of LABOR_ANALYSEWERTE',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_success_message=> 'Action Processed.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WARENKORB_DETAILS:ID';

wwv_flow_api.create_page_process(
  p_id     => 18469620386840530 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_UPDATE',
  p_process_name=> 'ApplyMRU',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_when=>':request like (''SAVE'') or :request like ''GET_NEXT%'' or :request like ''GET_PREV%''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '#MRU_COUNT# row(s) updated, #MRI_COUNT# row(s) inserted.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WARENKORB_DETAILS:ID';

wwv_flow_api.create_page_process(
  p_id     => 18469803144840531 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_region_id=> 18458112192840460 + wwv_flow_api.g_id_offset,
  p_process_type=> 'MULTI_ROW_DELETE',
  p_process_name=> 'ApplyMRD',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_when=>'APPLY_CHANGES_MRD',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> '#MRD_COUNT# row(s) deleted.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'14';

wwv_flow_api.create_page_process(
  p_id     => 18457827173840451 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 14,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'INLINE_IN_NOTIFICATION',
  p_process_when_button_id=>18449022870840331 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 14
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00031
prompt  ...PAGE 31: Aktualisieren FRAGEBOGENANZEIGE 31
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 31
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 31'
 ,p_step_title => 'Aktualisieren FRAGEBOGENANZEIGE 31'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren FRAGEBOGENANZEIGE 31'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_welcome_text => '<script language="JavaScript1.1" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
'function f_checklaborwerte (feld_id,wert,eh_id)'||unistr('\000a')||
'{ '||unistr('\000a')||
'  var feld_menge = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkLaborWerte'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  get.add(''P31_EINHEIT_ID_INPUT'',eh_id);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = gReturn ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = '''' ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'function f_checkdatum(feld_id,datum,fragetext)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_datum = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkMessdatum'',0);'||unistr('\000a')||
'  get.add(''P31_DATUM'',datum);'||unistr('\000a')||
'  get.add(''P31_FRAGE_TEXT'',fragetext);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
''||unistr('\000a')||
'function f_checknormbereich(feld_id,normbereich,wert)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_normbereich = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkNormbereich'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_NORMBEREICH'',normbereich);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20141022144358'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||''||unistr('\000a')||
'select'||unistr('\000a')||
'   f.fkategorie_text fkategorie_text,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'   WHEN hilfe_text_id is not null'||unistr('\000a')||
'   THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'   ||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'   || f.hilfe_text_id||'',''||f.frage_text_id)'||unistr('\000a')||
'   || '''''',700,425)">'''||unistr('\000a')||
'   || ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'   || ''</a>'''||unistr('\000a')||
'   ELSE '' '''||unistr('\000a')||
'   END LINK,'||unistr('\000a')||
'   apex_';

s:=s||'item.hidden(2,f.frage_id) ||'||unistr('\000a')||
'   apex_item.hidden(3,p.ID) ||'||unistr('\000a')||
'   f.FRAGE_TEXT FRAGE_TEXT,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder => Wert */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id =';

s:=s||' f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_2'||unistr('\000a')||
'                           and satz_kennzeichen is null)))||'||unistr('\000a')||
'         apex_item.text(8,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id = f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_';

s:=s||'2'||unistr('\000a')||
'                           and satz_kennzeichen is null)),'||unistr('\000a')||
'                        10,15,''tabindex="1" autocomplete="off"'||unistr('\000a')||
'   onchange="javascript:f_checklaborwerte('''''' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'''||unistr('\000a')||
'    || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0';

s:=s||') = 1 then '' disabled'' else '''' end , f.frage_ID'||unistr('\000a')||
'                       )'||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => ID der Fantwort */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,p.FANTWORT_ID)||'||unistr('\000a')||
'         apex_item.select_list_from_query(8,p.FANTWORT_ID,'||unistr('\000a')||
'            ''select frgbg_s.HOLEN_UEBERSETZUNG(fant.text_id,:fas_sprache_id), fant.id from fantworten fant where f';

s:=s||'ant.frage_id*1000000 = ''||'||unistr('\000a')||
'                                          f.frage_ID*1000000||'||unistr('\000a')||
''' and fant.satz_kennzeichen is null order by fant.sort asc '','||unistr('\000a')||
'            NULL,''NO'',NULL,NULL)'||unistr('\000a')||
'      END fantwort_zahl_eingabe,'||unistr('\000a')||
''||unistr('\000a')||
'   CASE /* Eingabefeld EH */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5  AND f.bezug_einheit_id != 181 THEN  /* Textfelder => EH-Eingabe LOV*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,';

s:=s||''||unistr('\000a')||
'               rezepte.get_inh_def_bezug_eh(f.inhstoff_id)))||'||unistr('\000a')||
'         apex_item.select_list_from_query(10,NVL(p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'                       rezepte.get_inh_def_bezug_eh(f.inhstoff_id)),'||unistr('\000a')||
'''select rezepte.get_bezug_eh_bez(u.bezug_einheit_id,:fas_sprache_id), u.bezug_einheit_id from inh_eh_disps u, bezug_einheiten be, einheiten e where u.inhstoff_id = ''||f.inhstoff_id||'' and u.satz_kenn';

s:=s||'zeichen is null and u.bezug_einheit_id = be.id and be.satz_kennzeichen is null and be.einheit_id = e.id and e.physeh_id in (SELECT e.physeh_id FROM inh_eh_umrs i, einheiten e WHERE i.inhstoff_id = ''||f.inhstoff_id||'' and i.satz_kennzeichen is null and i.einheit_id = e.id and e.satz_kennzeichen is null) order by u.sort asc'','||unistr('\000a')||
'''onchange="javascript:f_checklaborwerte('''''' || f.frage_ID || '''''',html_GetE';

s:=s||'lement('''''' || f.frage_ID || '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'' || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1'||unistr('\000a')||
'    /* OR FRGBG_T.LAB_MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 */ then '' disabled'' else '''' end,'||unistr('\000a')||
'''NO'',NULL,NULL,''EH''||f.frage_ID'||unistr('\000a')||
')'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND f.bezug_einheit_id = 1';

s:=s||'81 THEN  /* Textfelder ohne EH-Eingabe z.B. pH-Werte immer bezug_einheit 181*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,181))||'||unistr('\000a')||
'         apex_item.hidden(10,NVL(p.FANTWORT_ZAHL_2,181),NULL,''EH''||f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => Keine EH-Eingabe */'||unistr('\000a')||
'         apex_item.hidden(9,NULL)||'||unistr('\000a')||
'         apex_item.hidden(10,NULL)||'||unistr('\000a')||
'         '''''||unistr('\000a')||
'      END fantwort_eh_eingabe ,'||unistr('\000a')||
'   ';

s:=s||'apex_item.hidden(11,'||unistr('\000a')||
'                     to_char(NVL(p.messdatum,sysdate),''DD.MM.RRRR hh24:mi''))||'||unistr('\000a')||
'   apex_item.text(12,to_char(NVL(p.messdatum,sysdate),''DD.MM.YYYY hh24:mi'')'||unistr('\000a')||
',20,20,''tabindex="1" autocomplete="off" onchange="javascript:f_checkdatum(''''DAT''||f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''DAT'' || f.frage_ID || '''''').value, ''''''|| f.frage_text||'''''')"'' || case when decode(NVL(FRGBG_S.FB_CHECK_F';

s:=s||'ANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end, ''DAT''||f.frage_ID'||unistr('\000a')||
') messdatum,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         apex_item.hidden(16,NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                             WHERE frage_id = f.frage_id'||unistr('\000a')||
'                               and satz_kennzeichen is null)))||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
' ';

s:=s||'     ELSE         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         apex_item.hidden(16,p.FANTWORT_ID)||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
'      END fantwort_id,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                                           WHERE frage_id = f.frage_id'||unistr('\000a')||
'                                             and satz_kennzeichen is null))'||unistr('\000a')||
'      EL';

s:=s||'SE         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         p.FANTWORT_ID'||unistr('\000a')||
'      END fantwort_id_disp,'||unistr('\000a')||
'   p.id persantwort_id, f.frage_id frage_id,p.FANTWORT_ZAHL,p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'   CASE WHEN p.fantwort_text is NULL THEN'||unistr('\000a')||
'     CASE WHEN p.LABOR_FAS_ERSATZWERT_ID is not null THEN'||unistr('\000a')||
'        (SELECT frgbg_s.HOLEN_UEBERSETZUNG(KUERZEL_TEXT_ID,:fas_sprache_id) FROM LABOR_FAS_ERSATZWERTE WHERE ID = p.LABOR_FAS_ERSATZWER';

s:=s||'T_ID)'||unistr('\000a')||
'     ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id)'||unistr('\000a')||
'     END'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id,p.fantwort_text )'||unistr('\000a')||
'   END ersatzwert_text,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND (select max(NORMIERUNGSTYP) from FANTWORTEN where FRAGE_Id = f.FRAGE_ID) = ''LABORBEREICH'' THEN'||unistr('\000a')||
'         CASE WHEN FRGBG_T.LAB';

s:=s||'_MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 THEN'||unistr('\000a')||
'           -- Wenn Labor mehrere Normbereiche geliefert hat, dürfen diese hier nicht bearbeitet werden,'||unistr('\000a')||
'           -- da über die Maske nur personenspezifische Normbereiche eingegeben werden dürfen'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
' ';

s:=s||'          apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT))'||unistr('\000a')||
'         ELSE'||unistr('\000a')||
'           apex_item.hidden(17,CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                    CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,';

s:=s||'p.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standardnormbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                   ELSE';

s:=s||' NULL END'||unistr('\000a')||
'                END'||unistr('\000a')||
'                   ) ||'||unistr('\000a')||
'           apex_item.text(18, CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                  CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standar';

s:=s||'dnormbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                  ELSE NULL END'||unistr('\000a')||
'                END, 10,15,''tabindex="1" autocomplete="off"';

s:=s||' onblur="javascript:f_checknormbereich(''''NORMB'' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''NORMB'' ||f.frage_ID || '''''').value, html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value)"'''||unistr('\000a')||
'              || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end'||unistr('\000a')||
'            , ''NORMB'' || f.frage_ID'||unistr('\000a')||
'         )'||unistr('\000a')||
'        END'||unistr('\000a')||
'     ELSE -- Bei';

s:=s||' anderen Anzeigetypen auch keine Eingabe möglich'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
'           apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT),''NORMB'' || f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'     END fantwort_normbereich'||unistr('\000a')||
'from v_fragen f, persantworten p --, uebersetzungen u ';

s:=s||'-- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'where f.fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  and (f.fkategorie_fkategorie_id = :p31_tab31_kategorie_id or'||unistr('\000a')||
'       f.FKATEGORIE_fkategorie_ID is null and f.fkategorie_id='||unistr('\000a')||
'                                              :p31_tab31_kategorie_id'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and f.personenstamm_id = :p1_id'||unistr('\000a')||
'  AND f.sprache_id = :fas_sprache_id'||unistr('\000a')||
'  AND f.fragelevel = ';

s:=s||'0 /* keine Metafragen */'||unistr('\000a')||
'  AND f.visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'  AND f.anzeigetyp_id in (3,4,5) /* Radio, Text */'||unistr('\000a')||
'  and f.frage_id = p.frage_id(+)'||unistr('\000a')||
'  and p.pergebnis_id(+) = :p1_pergebnis_id'||unistr('\000a')||
'  and p.satz_kennzeichen (+) is null'||unistr('\000a')||
'  --and f.such_text_id = u.text_id (+)'||unistr('\000a')||
'  --and u.sprache_id (+) = :fas_sprache_id'||unistr('\000a')||
'  and (:p31_suchbemerkung_NOSAVE is null OR'||unistr('\000a')||
'       --UPPER(u.text) lik';

s:=s||'e ''%''||UPPER(:p31_suchbemerkung_NOSAVE)||''%'' OR   -- NEI 20.11.13'||unistr('\000a')||
'       UPPER(frgbg_s.HOLEN_UEBERSETZUNG(f.such_text_id,:fas_sprache_id)) like ''%''||UPPER(:p31_suchbemerkung_NOSAVE)||''%'' OR'||unistr('\000a')||
'       UPPER(f.FRAGE_TEXT) like ''%''||UPPER(:p31_suchbemerkung_NOSAVE)||''%'''||unistr('\000a')||
'      )'||unistr('\000a')||
'--  and f.frage_id > 0   -- Nur zu Testzwecken'||unistr('\000a')||
'--order by f.fkategorie_sort,f.frage_sort'||unistr('\000a')||
'--order by f.fkategorie_sort,CASE WHEN';

s:=s||' p.id is null THEN 0 ELSE 1 END desc ,f.frage_text'||unistr('\000a')||
'order by f.fkategorie_sort,f.frage_text';

wwv_flow_api.create_report_region (
  p_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;margin:10px">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P31_TAB31_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '300',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'MILLIMETERS',
  p_prn_paper_size=> 'A4',
  p_prn_height=> 210,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4989403377394618 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4842828058974037 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4828832649764078 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5072518542411431 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_EINGABE',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5080223573533448 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_EH_EINGABE',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5080324684533448 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'MESSDATUM',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5080419818533448 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5080512596533448 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID_DISP',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4828622147764078 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'PERSANTWORT_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4928606581427196 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4945200065689817 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4946522205693039 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_2',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5502304367099145 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'ERSATZWERT_TEXT',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8516818906930485 + wwv_flow_api.g_id_offset,
  p_region_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_NORMBEREICH',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 4829507157764079 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5570022136865979 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5931822074640831 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 35,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 4830528575764081 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31,
  p_button_sequence=> 10,
  p_button_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4830311255764079 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31,
  p_button_sequence=> 15,
  p_button_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4829931062764079 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31,
  p_button_sequence=> 20,
  p_button_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:31:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4830119779764079 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31,
  p_button_sequence=> 30,
  p_button_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3875203499509227 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31,
  p_button_sequence=> 40,
  p_button_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3879310650577445 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3875203499509227+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>4832800546764085 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:31:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4831112599764084 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_ID_INPUT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 500,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Inhstoff Id Input',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4831316153764084 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_WERT_INPUT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 600,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Einheit Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4831511735764084 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_EINHEIT_ID_INPUT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 700,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Einheit Id Input',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4833432536787445 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB31_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab31 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4833626780795289 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB31_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab31 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4833805093798414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB31_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab31 Kategorie Zeilen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2899703987489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4837908959903687 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB32_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 101,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab32 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4838123504907884 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB33_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 102,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab33 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4838332507910462 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB34_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 103,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab34 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4838507358912667 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB35_KATEGORIE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 104,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab35 Kategorie Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4838719825916276 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB32_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 131,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab32 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4838930214919223 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB33_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 132,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab33 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4839107836922250 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB34_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 133,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab34 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4839317186924926 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB35_KATEGORIE_ID',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 134,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab35 Kategorie Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4839526190927542 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB32_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 151,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab32 Kategorie Zeilen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4839711776932892 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB33_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 152,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'TAB33_KATEGORIE_ZEILEN',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4839920780935409 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB34_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 153,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab34 Kategorie Zeilen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4840128745937712 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_TAB35_KATEGORIE_ZEILEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 154,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tab35 Kategorie Zeilen',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4936313552776279 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_ICON_SUCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'SUCHEN',
  p_source=>'SUCHEN',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_button_image => '24find.gif',
  p_button_image_attr=> 'onclick="xwoher=2"',
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'N',
  p_button_execute_validations=>'Y',
  p_button_action => 'SUBMIT',
  p_button_is_hot=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4947105832971756 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_SUCHBEMERKUNG_NOSAVE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onclick="xwoher=2"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4965301223356551 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_DATUM',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 710,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Datum',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4968013531473665 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_FRAGE_TEXT',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 720,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Frage Text',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8539325000431503 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31,
  p_name=>'P31_NORMBEREICH',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 730,
  p_item_plug_id => 4828404131764076+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_HIDDEN',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 4000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'Y',
  p_attribute_01 => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 4831807374764084 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_eingabe',
  p_validation_sequence=> 50,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_change  NUMBER := 0;'||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'   v_sprache_id number := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Check wurde ausgelagert, da Code zu lang'||unistr('\000a')||
'   v_change := frgbg_s.fb_check_labor_eing(v_fehlertext);'||unistr('\000a')||
'   -- Fehler wird erst vor Speichern ausgewertet und mit Raise angezeigt'||unistr('\000a')||
'   :p1_fehler := v_fehlertext;'||unistr('\000a')||
'   IF v_change = 0 THEN  -- Keine Daten geändert'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(2020,v_sprache_id ));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 4830119779764079 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPLIC';

p:=p||'ATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
'  v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
'  IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
'  END IF; '||unistr('\000a')||
'  FRGBG_S.SPEICHERN_LABOR'||unistr('\000a')||
'     ( '||unistr('\000a')||
'      v_user,:p31_tab31_kategorie_id/* 71,116:P1_TAB2_KATEGORIE_ID*/,'||unistr('\000a')||
'     :p1_fragebogen_id,:p1_id,:p1_pergebnis_id,'||unistr('\000a')||
'      v_sprache_id , :P1_FEHLER'||unistr('\000a')||
'     )';

p:=p||';'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung auch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 4831917332764085 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'',''SUCHEN'',''P31_SUCHBEMERKUNG_NOSAVE'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text'||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p31_tab31_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p31_tab31_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_h';

p:=p||'inweis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 4832500737764085 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 4832127334764085 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 4832306321764085 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 3883008319633574 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 31
--
 
begin
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6440416011039150 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 1,
  p_query_column_name=> 'FKATEGORIE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6440513995039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 2,
  p_query_column_name=> 'LINK',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6440609584039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 3,
  p_query_column_name=> 'FRAGE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6440712134039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 4,
  p_query_column_name=> 'FANTWORT_ZAHL_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6440831351039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 5,
  p_query_column_name=> 'FANTWORT_EH_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6440917728039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 6,
  p_query_column_name=> 'MESSDATUM',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6441031946039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 7,
  p_query_column_name=> 'FANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6441109710039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 8,
  p_query_column_name=> 'FANTWORT_ID_DISP',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6441214015039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 9,
  p_query_column_name=> 'PERSANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6441319122039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 10,
  p_query_column_name=> 'FRAGE_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6441432264039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 11,
  p_query_column_name=> 'FANTWORT_ZAHL',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6441519932039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 12,
  p_query_column_name=> 'FANTWORT_ZAHL_2',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6441614844039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 13,
  p_query_column_name=> 'ERSATZWERT_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6441710387039157 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 4828404131764076 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 14,
  p_query_column_name=> 'FANTWORT_NORMBEREICH',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00032
prompt  ...PAGE 32: Aktualisieren FRAGEBOGENANZEIGE 32
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 32
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 32'
 ,p_step_title => 'Aktualisieren FRAGEBOGENANZEIGE 32'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren FRAGEBOGENANZEIGE 31'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_welcome_text => '<script language="JavaScript1.1" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
'function f_checklaborwerte (feld_id,wert,eh_id)'||unistr('\000a')||
'{ '||unistr('\000a')||
'  var feld_menge = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkLaborWerte'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  get.add(''P31_EINHEIT_ID_INPUT'',eh_id);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = gReturn ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = '''' ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'function f_checkdatum(feld_id,datum,fragetext)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_datum = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkMessdatum'',0);'||unistr('\000a')||
'  get.add(''P31_DATUM'',datum);'||unistr('\000a')||
'  get.add(''P31_FRAGE_TEXT'',fragetext);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
''||unistr('\000a')||
'function f_checknormbereich(feld_id,normbereich,wert)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_normbereich = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkNormbereich'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_NORMBEREICH'',normbereich);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20141022144849'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8665919016602940 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||''||unistr('\000a')||
'select'||unistr('\000a')||
'   f.fkategorie_text fkategorie_text,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'   WHEN hilfe_text_id is not null'||unistr('\000a')||
'   THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'   ||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'   || f.hilfe_text_id||'',''||f.frage_text_id)'||unistr('\000a')||
'   || '''''',700,425)">'''||unistr('\000a')||
'   || ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'   || ''</a>'''||unistr('\000a')||
'   ELSE '' '''||unistr('\000a')||
'   END LINK,'||unistr('\000a')||
'   apex_';

s:=s||'item.hidden(2,f.frage_id) ||'||unistr('\000a')||
'   apex_item.hidden(3,p.ID) ||'||unistr('\000a')||
'   f.FRAGE_TEXT FRAGE_TEXT,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder => Wert */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id =';

s:=s||' f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_2'||unistr('\000a')||
'                           and satz_kennzeichen is null)))||'||unistr('\000a')||
'         apex_item.text(8,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id = f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_';

s:=s||'2'||unistr('\000a')||
'                           and satz_kennzeichen is null)),'||unistr('\000a')||
'                        10,15,''tabindex="1" autocomplete="off"'||unistr('\000a')||
'   onchange="javascript:f_checklaborwerte('''''' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'''||unistr('\000a')||
'    || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0';

s:=s||') = 1 then '' disabled'' else '''' end , f.frage_ID'||unistr('\000a')||
'                       )'||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => ID der Fantwort */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,p.FANTWORT_ID)||'||unistr('\000a')||
'         apex_item.select_list_from_query(8,p.FANTWORT_ID,'||unistr('\000a')||
'            ''select frgbg_s.HOLEN_UEBERSETZUNG(fant.text_id,:fas_sprache_id), fant.id from fantworten fant where f';

s:=s||'ant.frage_id*1000000 = ''||'||unistr('\000a')||
'                                          f.frage_ID*1000000||'||unistr('\000a')||
''' and fant.satz_kennzeichen is null order by fant.sort asc '','||unistr('\000a')||
'            NULL,''NO'',NULL,NULL)'||unistr('\000a')||
'      END fantwort_zahl_eingabe,'||unistr('\000a')||
''||unistr('\000a')||
'   CASE /* Eingabefeld EH */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5  AND f.bezug_einheit_id != 181 THEN  /* Textfelder => EH-Eingabe LOV*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,';

s:=s||''||unistr('\000a')||
'               rezepte.get_inh_def_bezug_eh(f.inhstoff_id)))||'||unistr('\000a')||
'         apex_item.select_list_from_query(10,NVL(p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'                       rezepte.get_inh_def_bezug_eh(f.inhstoff_id)),'||unistr('\000a')||
'''select rezepte.get_bezug_eh_bez(u.bezug_einheit_id,:fas_sprache_id), u.bezug_einheit_id from inh_eh_disps u, bezug_einheiten be, einheiten e where u.inhstoff_id = ''||f.inhstoff_id||'' and u.satz_kenn';

s:=s||'zeichen is null and u.bezug_einheit_id = be.id and be.satz_kennzeichen is null and be.einheit_id = e.id and e.physeh_id in (SELECT e.physeh_id FROM inh_eh_umrs i, einheiten e WHERE i.inhstoff_id = ''||f.inhstoff_id||'' and i.satz_kennzeichen is null and i.einheit_id = e.id and e.satz_kennzeichen is null) order by u.sort asc'','||unistr('\000a')||
'''onchange="javascript:f_checklaborwerte('''''' || f.frage_ID || '''''',html_GetE';

s:=s||'lement('''''' || f.frage_ID || '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'' || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1'||unistr('\000a')||
'    /* OR FRGBG_T.LAB_MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 */ then '' disabled'' else '''' end,'||unistr('\000a')||
'''NO'',NULL,NULL,''EH''||f.frage_ID'||unistr('\000a')||
')'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND f.bezug_einheit_id = 1';

s:=s||'81 THEN  /* Textfelder ohne EH-Eingabe z.B. pH-Werte immer bezug_einheit 181*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,181))||'||unistr('\000a')||
'         apex_item.hidden(10,NVL(p.FANTWORT_ZAHL_2,181),NULL,''EH''||f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => Keine EH-Eingabe */'||unistr('\000a')||
'         apex_item.hidden(9,NULL)||'||unistr('\000a')||
'         apex_item.hidden(10,NULL)||'||unistr('\000a')||
'         '''''||unistr('\000a')||
'      END fantwort_eh_eingabe ,'||unistr('\000a')||
'   ';

s:=s||'apex_item.hidden(11,'||unistr('\000a')||
'                     to_char(NVL(p.messdatum,sysdate),''DD.MM.RRRR hh24:mi''))||'||unistr('\000a')||
'   apex_item.text(12,to_char(NVL(p.messdatum,sysdate),''DD.MM.YYYY hh24:mi'')'||unistr('\000a')||
',20,20,''tabindex="1" autocomplete="off" onchange="javascript:f_checkdatum(''''DAT''||f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''DAT'' || f.frage_ID || '''''').value, ''''''|| f.frage_text||'''''')"'' || case when decode(NVL(FRGBG_S.FB_CHECK_F';

s:=s||'ANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end, ''DAT''||f.frage_ID'||unistr('\000a')||
') messdatum,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         apex_item.hidden(16,NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                             WHERE frage_id = f.frage_id'||unistr('\000a')||
'                               and satz_kennzeichen is null)))||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
' ';

s:=s||'     ELSE         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         apex_item.hidden(16,p.FANTWORT_ID)||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
'      END fantwort_id,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                                           WHERE frage_id = f.frage_id'||unistr('\000a')||
'                                             and satz_kennzeichen is null))'||unistr('\000a')||
'      EL';

s:=s||'SE         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         p.FANTWORT_ID'||unistr('\000a')||
'      END fantwort_id_disp,'||unistr('\000a')||
'   p.id persantwort_id, f.frage_id frage_id,p.FANTWORT_ZAHL,p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'   CASE WHEN p.fantwort_text is NULL THEN'||unistr('\000a')||
'     CASE WHEN p.LABOR_FAS_ERSATZWERT_ID is not null THEN'||unistr('\000a')||
'        (SELECT frgbg_s.HOLEN_UEBERSETZUNG(KUERZEL_TEXT_ID,:fas_sprache_id) FROM LABOR_FAS_ERSATZWERTE WHERE ID = p.LABOR_FAS_ERSATZWER';

s:=s||'T_ID)'||unistr('\000a')||
'     ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id)'||unistr('\000a')||
'     END'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id,p.fantwort_text )'||unistr('\000a')||
'   END ersatzwert_text,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND (select max(NORMIERUNGSTYP) from FANTWORTEN where FRAGE_Id = f.FRAGE_ID) = ''LABORBEREICH'' THEN'||unistr('\000a')||
'         CASE WHEN FRGBG_T.LAB';

s:=s||'_MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 THEN'||unistr('\000a')||
'           -- Wenn Labor mehrere Normbereiche geliefert hat, dürfen diese hier nicht bearbeitet werden,'||unistr('\000a')||
'           -- da über die Maske nur personenspezifische Normbereiche eingegeben werden dürfen'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
' ';

s:=s||'          apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT))'||unistr('\000a')||
'         ELSE'||unistr('\000a')||
'           apex_item.hidden(17,CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                    CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,';

s:=s||'p.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standardnormbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                   ELSE';

s:=s||' NULL END'||unistr('\000a')||
'                END'||unistr('\000a')||
'                   ) ||'||unistr('\000a')||
'           apex_item.text(18, CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                  CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standar';

s:=s||'dnormbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                  ELSE NULL END'||unistr('\000a')||
'                END, 10,15,''tabindex="1" autocomplete="off"';

s:=s||' onblur="javascript:f_checknormbereich(''''NORMB'' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''NORMB'' ||f.frage_ID || '''''').value, html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value)"'''||unistr('\000a')||
'              || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end'||unistr('\000a')||
'            , ''NORMB'' || f.frage_ID'||unistr('\000a')||
'         )'||unistr('\000a')||
'        END'||unistr('\000a')||
'     ELSE -- Bei';

s:=s||' anderen Anzeigetypen auch keine Eingabe möglich'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
'           apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT),''NORMB'' || f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'     END fantwort_normbereich'||unistr('\000a')||
'from v_fragen f, persantworten p --, uebersetzungen u ';

s:=s||'-- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'where f.fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  and (f.fkategorie_fkategorie_id = :p31_tab32_kategorie_id or'||unistr('\000a')||
'       f.FKATEGORIE_fkategorie_ID is null and f.fkategorie_id='||unistr('\000a')||
'                                              :p31_tab32_kategorie_id'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and f.personenstamm_id = :p1_id'||unistr('\000a')||
'  AND f.sprache_id = :fas_sprache_id'||unistr('\000a')||
'  AND f.fragelevel = ';

s:=s||'0 /* keine Metafragen */'||unistr('\000a')||
'  AND f.visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'  AND f.anzeigetyp_id in (3,4,5) /* Radio, Text */'||unistr('\000a')||
'  and f.frage_id = p.frage_id(+)'||unistr('\000a')||
'  and p.pergebnis_id(+) = :p1_pergebnis_id'||unistr('\000a')||
'  and p.satz_kennzeichen (+) is null'||unistr('\000a')||
'  --and f.such_text_id = u.text_id (+)'||unistr('\000a')||
'  --and u.sprache_id (+) = :fas_sprache_id'||unistr('\000a')||
'  and (:p32_suchbemerkung_NOSAVE is null OR'||unistr('\000a')||
'       --UPPER(u.text) lik';

s:=s||'e ''%''||UPPER(:p32_suchbemerkung_NOSAVE)||''%'' OR   -- NEI 20.11.13'||unistr('\000a')||
'       UPPER(frgbg_s.HOLEN_UEBERSETZUNG(f.such_text_id,:fas_sprache_id)) like ''%''||UPPER(:p32_suchbemerkung_NOSAVE)||''%'' OR'||unistr('\000a')||
'       UPPER(f.FRAGE_TEXT) like ''%''||UPPER(:p32_suchbemerkung_NOSAVE)||''%'''||unistr('\000a')||
'      )'||unistr('\000a')||
'--  and f.frage_id > 0   -- Nur zu Testzwecken'||unistr('\000a')||
'--order by f.fkategorie_sort,f.frage_sort'||unistr('\000a')||
'--order by f.fkategorie_sort,CASE WHEN';

s:=s||' p.id is null THEN 0 ELSE 1 END desc ,f.frage_text'||unistr('\000a')||
'order by f.fkategorie_sort,f.frage_text';

wwv_flow_api.create_report_region (
  p_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;margin:10px">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P31_TAB32_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '300',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'MILLIMETERS',
  p_prn_paper_size=> 'A4',
  p_prn_height=> 210,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8666510023602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8666615416602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8666701304602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8666822683602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_EINGABE',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8666919908602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_EH_EINGABE',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8667024054602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'MESSDATUM',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8667126755602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8667215914602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID_DISP',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8667330904602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'PERSANTWORT_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8667424511602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8667529837602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8667617998602947 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_2',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8666419604602946 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'ERSATZWERT_TEXT',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8666331107602946 + wwv_flow_api.g_id_offset,
  p_region_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_NORMBEREICH',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 8673314527602956 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8673509113602957 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 35,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 8667724932602947 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 10,
  p_button_plug_id => 8666125852602945+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8667912149602948 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 15,
  p_button_plug_id => 8666125852602945+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8668102907602948 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 20,
  p_button_plug_id => 8666125852602945+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8668308053602948 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 30,
  p_button_plug_id => 8666125852602945+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8668519050602948 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32,
  p_button_sequence=> 40,
  p_button_plug_id => 8666125852602945+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>8675008534602959 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>8668519050602948+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>8675204754602959 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8668701785602948 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_ICON_SUCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 8666125852602945+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'SUCHEN',
  p_source=>'SUCHEN',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_button_image => '24find.gif',
  p_button_image_attr=> 'onclick="xwoher=2"',
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'N',
  p_button_execute_validations=>'Y',
  p_button_action => 'SUBMIT',
  p_button_is_hot=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8672527679602955 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32,
  p_name=>'P32_SUCHBEMERKUNG_NOSAVE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 8666125852602945+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onclick="xwoher=2"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 8673824688602957 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_eingabe',
  p_validation_sequence=> 50,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_change  NUMBER := 0;'||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'   v_sprache_id number := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Check wurde ausgelagert, da Code zu lang'||unistr('\000a')||
'   v_change := frgbg_s.fb_check_labor_eing(v_fehlertext);'||unistr('\000a')||
'   -- Fehler wird erst vor Speichern ausgewertet und mit Raise angezeigt'||unistr('\000a')||
'   :p1_fehler := v_fehlertext;'||unistr('\000a')||
'   IF v_change = 0 THEN  -- Keine Daten geändert'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(2020,v_sprache_id ));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 8668308053602948 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPLIC';

p:=p||'ATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
'  v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
'  IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
'  END IF; '||unistr('\000a')||
'  FRGBG_S.SPEICHERN_LABOR'||unistr('\000a')||
'     ( '||unistr('\000a')||
'      v_user,:p31_tab32_kategorie_id/* 71,116:P1_TAB2_KATEGORIE_ID*/,'||unistr('\000a')||
'     :p1_fragebogen_id,:p1_id,:p1_pergebnis_id,'||unistr('\000a')||
'      v_sprache_id , :P1_FEHLER'||unistr('\000a')||
'     )';

p:=p||';'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung auch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 8673902477602958 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'',''SUCHEN'',''P32_SUCHBEMERKUNG_NOSAVE'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text'||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p31_tab32_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p31_tab32_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_h';

p:=p||'inweis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 8674115987602958 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 8674317898602958 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 8674519439602958 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 8674720273602958 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 32,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 32
--
 
begin
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6443417028114619 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 1,
  p_query_column_name=> 'FKATEGORIE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6443515159114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 2,
  p_query_column_name=> 'LINK',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6443612411114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 3,
  p_query_column_name=> 'FRAGE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6443726693114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 4,
  p_query_column_name=> 'FANTWORT_ZAHL_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6443812241114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 5,
  p_query_column_name=> 'FANTWORT_EH_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6443931483114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 6,
  p_query_column_name=> 'MESSDATUM',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6444012249114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 7,
  p_query_column_name=> 'FANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6444107832114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 8,
  p_query_column_name=> 'FANTWORT_ID_DISP',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6444227694114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 9,
  p_query_column_name=> 'PERSANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6444328850114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 10,
  p_query_column_name=> 'FRAGE_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6444431436114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 11,
  p_query_column_name=> 'FANTWORT_ZAHL',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6444514735114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 12,
  p_query_column_name=> 'FANTWORT_ZAHL_2',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6444610907114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 13,
  p_query_column_name=> 'ERSATZWERT_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6444707487114621 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8666125852602945 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 14,
  p_query_column_name=> 'FANTWORT_NORMBEREICH',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00033
prompt  ...PAGE 33: Aktualisieren FRAGEBOGENANZEIGE 33
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 33
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 33'
 ,p_step_title => 'Aktualisieren FRAGEBOGENANZEIGE 33'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren FRAGEBOGENANZEIGE 31'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_welcome_text => '<script language="JavaScript1.1" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
'function f_checklaborwerte (feld_id,wert,eh_id)'||unistr('\000a')||
'{ '||unistr('\000a')||
'  var feld_menge = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkLaborWerte'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  get.add(''P31_EINHEIT_ID_INPUT'',eh_id);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = gReturn ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = '''' ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'function f_checkdatum(feld_id,datum,fragetext)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_datum = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkMessdatum'',0);'||unistr('\000a')||
'  get.add(''P31_DATUM'',datum);'||unistr('\000a')||
'  get.add(''P31_FRAGE_TEXT'',fragetext);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
''||unistr('\000a')||
'function f_checknormbereich(feld_id,normbereich,wert)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_normbereich = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkNormbereich'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_NORMBEREICH'',normbereich);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20141022144933'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select'||unistr('\000a')||
'   f.fkategorie_text fkategorie_text,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'   WHEN hilfe_text_id is not null'||unistr('\000a')||
'   THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'   ||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'   || f.hilfe_text_id||'',''||f.frage_text_id)'||unistr('\000a')||
'   || '''''',700,425)">'''||unistr('\000a')||
'   || ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'   || ''</a>'''||unistr('\000a')||
'   ELSE '' '''||unistr('\000a')||
'   END LINK,'||unistr('\000a')||
'   apex_i';

s:=s||'tem.hidden(2,f.frage_id) ||'||unistr('\000a')||
'   apex_item.hidden(3,p.ID) ||'||unistr('\000a')||
'   f.FRAGE_TEXT FRAGE_TEXT,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder => Wert */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id = ';

s:=s||'f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_2'||unistr('\000a')||
'                           and satz_kennzeichen is null)))||'||unistr('\000a')||
'         apex_item.text(8,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id = f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_2';

s:=s||''||unistr('\000a')||
'                           and satz_kennzeichen is null)),'||unistr('\000a')||
'                        10,15,''tabindex="1" autocomplete="off"'||unistr('\000a')||
'   onchange="javascript:f_checklaborwerte('''''' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'''||unistr('\000a')||
'    || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0)';

s:=s||' = 1 then '' disabled'' else '''' end , f.frage_ID'||unistr('\000a')||
'                       )'||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => ID der Fantwort */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,p.FANTWORT_ID)||'||unistr('\000a')||
'         apex_item.select_list_from_query(8,p.FANTWORT_ID,'||unistr('\000a')||
'            ''select frgbg_s.HOLEN_UEBERSETZUNG(fant.text_id,:fas_sprache_id), fant.id from fantworten fant where fa';

s:=s||'nt.frage_id*1000000 = ''||'||unistr('\000a')||
'                                          f.frage_ID*1000000||'||unistr('\000a')||
''' and fant.satz_kennzeichen is null order by fant.sort asc '','||unistr('\000a')||
'            NULL,''NO'',NULL,NULL)'||unistr('\000a')||
'      END fantwort_zahl_eingabe,'||unistr('\000a')||
''||unistr('\000a')||
'   CASE /* Eingabefeld EH */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5  AND f.bezug_einheit_id != 181 THEN  /* Textfelder => EH-Eingabe LOV*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'';

s:=s||'               rezepte.get_inh_def_bezug_eh(f.inhstoff_id)))||'||unistr('\000a')||
'         apex_item.select_list_from_query(10,NVL(p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'                       rezepte.get_inh_def_bezug_eh(f.inhstoff_id)),'||unistr('\000a')||
'''select rezepte.get_bezug_eh_bez(u.bezug_einheit_id,:fas_sprache_id), u.bezug_einheit_id from inh_eh_disps u, bezug_einheiten be, einheiten e where u.inhstoff_id = ''||f.inhstoff_id||'' and u.satz_kennz';

s:=s||'eichen is null and u.bezug_einheit_id = be.id and be.satz_kennzeichen is null and be.einheit_id = e.id and e.physeh_id in (SELECT e.physeh_id FROM inh_eh_umrs i, einheiten e WHERE i.inhstoff_id = ''||f.inhstoff_id||'' and i.satz_kennzeichen is null and i.einheit_id = e.id and e.satz_kennzeichen is null) order by u.sort asc'','||unistr('\000a')||
'''onchange="javascript:f_checklaborwerte('''''' || f.frage_ID || '''''',html_GetEl';

s:=s||'ement('''''' || f.frage_ID || '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'' || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1'||unistr('\000a')||
'    /* OR FRGBG_T.LAB_MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 */ then '' disabled'' else '''' end,'||unistr('\000a')||
'''NO'',NULL,NULL,''EH''||f.frage_ID'||unistr('\000a')||
')'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND f.bezug_einheit_id = 18';

s:=s||'1 THEN  /* Textfelder ohne EH-Eingabe z.B. pH-Werte immer bezug_einheit 181*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,181))||'||unistr('\000a')||
'         apex_item.hidden(10,NVL(p.FANTWORT_ZAHL_2,181),NULL,''EH''||f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => Keine EH-Eingabe */'||unistr('\000a')||
'         apex_item.hidden(9,NULL)||'||unistr('\000a')||
'         apex_item.hidden(10,NULL)||'||unistr('\000a')||
'         '''''||unistr('\000a')||
'      END fantwort_eh_eingabe ,'||unistr('\000a')||
'   a';

s:=s||'pex_item.hidden(11,'||unistr('\000a')||
'                     to_char(NVL(p.messdatum,sysdate),''DD.MM.RRRR hh24:mi''))||'||unistr('\000a')||
'   apex_item.text(12,to_char(NVL(p.messdatum,sysdate),''DD.MM.YYYY hh24:mi'')'||unistr('\000a')||
',20,20,''tabindex="1" autocomplete="off" onchange="javascript:f_checkdatum(''''DAT''||f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''DAT'' || f.frage_ID || '''''').value, ''''''|| f.frage_text||'''''')"'' || case when decode(NVL(FRGBG_S.FB_CHECK_FA';

s:=s||'NT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end, ''DAT''||f.frage_ID'||unistr('\000a')||
') messdatum,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         apex_item.hidden(16,NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                             WHERE frage_id = f.frage_id'||unistr('\000a')||
'                               and satz_kennzeichen is null)))||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
'  ';

s:=s||'    ELSE         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         apex_item.hidden(16,p.FANTWORT_ID)||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
'      END fantwort_id,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                                           WHERE frage_id = f.frage_id'||unistr('\000a')||
'                                             and satz_kennzeichen is null))'||unistr('\000a')||
'      ELS';

s:=s||'E         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         p.FANTWORT_ID'||unistr('\000a')||
'      END fantwort_id_disp,'||unistr('\000a')||
'   p.id persantwort_id, f.frage_id frage_id,p.FANTWORT_ZAHL,p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'   CASE WHEN p.fantwort_text is NULL THEN'||unistr('\000a')||
'     CASE WHEN p.LABOR_FAS_ERSATZWERT_ID is not null THEN'||unistr('\000a')||
'        (SELECT frgbg_s.HOLEN_UEBERSETZUNG(KUERZEL_TEXT_ID,:fas_sprache_id) FROM LABOR_FAS_ERSATZWERTE WHERE ID = p.LABOR_FAS_ERSATZWERT';

s:=s||'_ID)'||unistr('\000a')||
'     ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id)'||unistr('\000a')||
'     END'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id,p.fantwort_text )'||unistr('\000a')||
'   END ersatzwert_text,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND (select max(NORMIERUNGSTYP) from FANTWORTEN where FRAGE_Id = f.FRAGE_ID) = ''LABORBEREICH'' THEN'||unistr('\000a')||
'         CASE WHEN FRGBG_T.LAB_';

s:=s||'MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 THEN'||unistr('\000a')||
'           -- Wenn Labor mehrere Normbereiche geliefert hat, dürfen diese hier nicht bearbeitet werden,'||unistr('\000a')||
'           -- da über die Maske nur personenspezifische Normbereiche eingegeben werden dürfen'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
'  ';

s:=s||'         apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT))'||unistr('\000a')||
'         ELSE'||unistr('\000a')||
'           apex_item.hidden(17,CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                    CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p';

s:=s||'.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standardnormbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                   ELSE ';

s:=s||'NULL END'||unistr('\000a')||
'                END'||unistr('\000a')||
'                   ) ||'||unistr('\000a')||
'           apex_item.text(18, CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                  CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standard';

s:=s||'normbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                  ELSE NULL END'||unistr('\000a')||
'                END, 10,15,''tabindex="1" autocomplete="off" ';

s:=s||'onblur="javascript:f_checknormbereich(''''NORMB'' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''NORMB'' ||f.frage_ID || '''''').value, html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value)"'''||unistr('\000a')||
'              || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end'||unistr('\000a')||
'            , ''NORMB'' || f.frage_ID'||unistr('\000a')||
'         )'||unistr('\000a')||
'        END'||unistr('\000a')||
'     ELSE -- Bei ';

s:=s||'anderen Anzeigetypen auch keine Eingabe möglich'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
'           apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT),''NORMB'' || f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'     END fantwort_normbereich'||unistr('\000a')||
'from v_fragen f, persantworten p --, uebersetzungen u -';

s:=s||'- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'where f.fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  and (f.fkategorie_fkategorie_id = :p31_tab33_kategorie_id or'||unistr('\000a')||
'       f.FKATEGORIE_fkategorie_ID is null and f.fkategorie_id='||unistr('\000a')||
'                                              :p31_tab33_kategorie_id'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and f.personenstamm_id = :p1_id'||unistr('\000a')||
'  AND f.sprache_id = :fas_sprache_id'||unistr('\000a')||
'  AND f.fragelevel = 0';

s:=s||' /* keine Metafragen */'||unistr('\000a')||
'  AND f.visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'  AND f.anzeigetyp_id in (3,4,5) /* Radio, Text */'||unistr('\000a')||
'  and f.frage_id = p.frage_id(+)'||unistr('\000a')||
'  and p.pergebnis_id(+) = :p1_pergebnis_id'||unistr('\000a')||
'  and p.satz_kennzeichen (+) is null'||unistr('\000a')||
'  --and f.such_text_id = u.text_id (+)'||unistr('\000a')||
'  --and u.sprache_id (+) = :fas_sprache_id'||unistr('\000a')||
'  and (:p33_suchbemerkung_NOSAVE is null OR'||unistr('\000a')||
'       --UPPER(u.text) like';

s:=s||' ''%''||UPPER(:p33_suchbemerkung_NOSAVE)||''%'' OR   -- NEI 20.11.13'||unistr('\000a')||
'       UPPER(frgbg_s.HOLEN_UEBERSETZUNG(f.such_text_id,:fas_sprache_id)) like ''%''||UPPER(:p33_suchbemerkung_NOSAVE)||''%'' OR'||unistr('\000a')||
'       UPPER(f.FRAGE_TEXT) like ''%''||UPPER(:p33_suchbemerkung_NOSAVE)||''%'''||unistr('\000a')||
'      )'||unistr('\000a')||
'--  and f.frage_id > 0   -- Nur zu Testzwecken'||unistr('\000a')||
'--order by f.fkategorie_sort,f.frage_sort'||unistr('\000a')||
'--order by f.fkategorie_sort,CASE WHEN ';

s:=s||'p.id is null THEN 0 ELSE 1 END desc ,f.frage_text'||unistr('\000a')||
'order by f.fkategorie_sort,f.frage_text';

wwv_flow_api.create_report_region (
  p_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;margin:10px">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P31_TAB33_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '300',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'MILLIMETERS',
  p_prn_paper_size=> 'A4',
  p_prn_height=> 210,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8692813970826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8692913225826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8693024095826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8693128136826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_EINGABE',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8693227139826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_EH_EINGABE',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8693325613826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'MESSDATUM',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8693404675826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8692113298826303 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID_DISP',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8692209387826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'PERSANTWORT_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8692304682826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8692421384826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8692508000826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_2',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8692706826826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'ERSATZWERT_TEXT',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8692607425826304 + wwv_flow_api.g_id_offset,
  p_region_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_NORMBEREICH',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 8694918132826307 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8700925493842892 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 35,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8701129649844115 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 8693509420826305 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 10,
  p_button_plug_id => 8691913781826302+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8693715554826305 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 15,
  p_button_plug_id => 8691913781826302+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8693917505826305 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 20,
  p_button_plug_id => 8691913781826302+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8694112164826305 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 30,
  p_button_plug_id => 8691913781826302+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8694330310826305 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 33,
  p_button_sequence=> 40,
  p_button_plug_id => 8691913781826302+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>8697409934826313 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>8694330310826305+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>8697619186826313 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8694507014826306 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_ICON_SUCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 8691913781826302+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'SUCHEN',
  p_source=>'SUCHEN',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_button_image => '24find.gif',
  p_button_image_attr=> 'onclick="xwoher=2"',
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'N',
  p_button_execute_validations=>'Y',
  p_button_action => 'SUBMIT',
  p_button_is_hot=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8694711314826306 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33,
  p_name=>'P33_SUCHBEMERKUNG_NOSAVE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 8691913781826302+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onclick="xwoher=2"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 8696215070826311 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_eingabe',
  p_validation_sequence=> 50,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_change  NUMBER := 0;'||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'   v_sprache_id number := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Check wurde ausgelagert, da Code zu lang'||unistr('\000a')||
'   v_change := frgbg_s.fb_check_labor_eing(v_fehlertext);'||unistr('\000a')||
'   -- Fehler wird erst vor Speichern ausgewertet und mit Raise angezeigt'||unistr('\000a')||
'   :p1_fehler := v_fehlertext;'||unistr('\000a')||
'   IF v_change = 0 THEN  -- Keine Daten geändert'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(2020,v_sprache_id ));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 8694112164826305 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPLIC';

p:=p||'ATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
'  v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
'  IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
'  END IF; '||unistr('\000a')||
'  FRGBG_S.SPEICHERN_LABOR'||unistr('\000a')||
'     ( '||unistr('\000a')||
'      v_user,:p31_tab33_kategorie_id/* 71,116:P1_TAB2_KATEGORIE_ID*/,'||unistr('\000a')||
'     :p1_fragebogen_id,:p1_id,:p1_pergebnis_id,'||unistr('\000a')||
'      v_sprache_id , :P1_FEHLER'||unistr('\000a')||
'     )';

p:=p||';'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung auch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 8696917459826312 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'',''SUCHEN'',''P33_SUCHBEMERKUNG_NOSAVE'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text'||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p31_tab33_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p31_tab32_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_h';

p:=p||'inweis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 8697107240826312 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 8696300818826311 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 8696511678826312 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 8696717996826312 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 33
--
 
begin
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6444907539118975 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 1,
  p_query_column_name=> 'FKATEGORIE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445001122118975 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 2,
  p_query_column_name=> 'LINK',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445103158118975 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 3,
  p_query_column_name=> 'FRAGE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445200069118975 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 4,
  p_query_column_name=> 'FANTWORT_ZAHL_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445309131118975 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 5,
  p_query_column_name=> 'FANTWORT_EH_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445400992118975 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 6,
  p_query_column_name=> 'MESSDATUM',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445511839118975 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 7,
  p_query_column_name=> 'FANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445614407118977 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 8,
  p_query_column_name=> 'FANTWORT_ID_DISP',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445727059118977 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 9,
  p_query_column_name=> 'PERSANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445805763118978 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 10,
  p_query_column_name=> 'FRAGE_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6445913679118978 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 11,
  p_query_column_name=> 'FANTWORT_ZAHL',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6446022809118978 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 12,
  p_query_column_name=> 'FANTWORT_ZAHL_2',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6446108508118978 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 13,
  p_query_column_name=> 'ERSATZWERT_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6446211050118978 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8691913781826302 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 14,
  p_query_column_name=> 'FANTWORT_NORMBEREICH',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00034
prompt  ...PAGE 34: Aktualisieren FRAGEBOGENANZEIGE 34
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 34
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 34'
 ,p_step_title => 'Aktualisieren FRAGEBOGENANZEIGE 34'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren FRAGEBOGENANZEIGE 34'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_welcome_text => '<script language="JavaScript1.1" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
'function f_checklaborwerte (feld_id,wert,eh_id)'||unistr('\000a')||
'{ '||unistr('\000a')||
'  var feld_menge = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkLaborWerte'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  get.add(''P31_EINHEIT_ID_INPUT'',eh_id);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = gReturn ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = '''' ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'function f_checkdatum(feld_id,datum,fragetext)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_datum = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkMessdatum'',0);'||unistr('\000a')||
'  get.add(''P31_DATUM'',datum);'||unistr('\000a')||
'  get.add(''P31_FRAGE_TEXT'',fragetext);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
''||unistr('\000a')||
'function f_checknormbereich(feld_id,normbereich,wert)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_normbereich = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkNormbereich'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_NORMBEREICH'',normbereich);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20141022145001'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select'||unistr('\000a')||
'   f.fkategorie_text fkategorie_text,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'   WHEN hilfe_text_id is not null'||unistr('\000a')||
'   THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'   ||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'   || f.hilfe_text_id||'',''||f.frage_text_id)'||unistr('\000a')||
'   || '''''',700,425)">'''||unistr('\000a')||
'   || ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'   || ''</a>'''||unistr('\000a')||
'   ELSE '' '''||unistr('\000a')||
'   END LINK,'||unistr('\000a')||
'   apex_i';

s:=s||'tem.hidden(2,f.frage_id) ||'||unistr('\000a')||
'   apex_item.hidden(3,p.ID) ||'||unistr('\000a')||
'   f.FRAGE_TEXT FRAGE_TEXT,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder => Wert */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id = ';

s:=s||'f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_2'||unistr('\000a')||
'                           and satz_kennzeichen is null)))||'||unistr('\000a')||
'         apex_item.text(8,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id = f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_2';

s:=s||''||unistr('\000a')||
'                           and satz_kennzeichen is null)),'||unistr('\000a')||
'                        10,15,''tabindex="1" autocomplete="off"'||unistr('\000a')||
'   onchange="javascript:f_checklaborwerte('''''' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'''||unistr('\000a')||
'    || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0)';

s:=s||' = 1 then '' disabled'' else '''' end , f.frage_ID'||unistr('\000a')||
'                       )'||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => ID der Fantwort */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,p.FANTWORT_ID)||'||unistr('\000a')||
'         apex_item.select_list_from_query(8,p.FANTWORT_ID,'||unistr('\000a')||
'            ''select frgbg_s.HOLEN_UEBERSETZUNG(fant.text_id,:fas_sprache_id), fant.id from fantworten fant where fa';

s:=s||'nt.frage_id*1000000 = ''||'||unistr('\000a')||
'                                          f.frage_ID*1000000||'||unistr('\000a')||
''' and fant.satz_kennzeichen is null order by fant.sort asc '','||unistr('\000a')||
'            NULL,''NO'',NULL,NULL)'||unistr('\000a')||
'      END fantwort_zahl_eingabe,'||unistr('\000a')||
''||unistr('\000a')||
'   CASE /* Eingabefeld EH */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5  AND f.bezug_einheit_id != 181 THEN  /* Textfelder => EH-Eingabe LOV*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'';

s:=s||'               rezepte.get_inh_def_bezug_eh(f.inhstoff_id)))||'||unistr('\000a')||
'         apex_item.select_list_from_query(10,NVL(p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'                       rezepte.get_inh_def_bezug_eh(f.inhstoff_id)),'||unistr('\000a')||
'''select rezepte.get_bezug_eh_bez(u.bezug_einheit_id,:fas_sprache_id), u.bezug_einheit_id from inh_eh_disps u, bezug_einheiten be, einheiten e where u.inhstoff_id = ''||f.inhstoff_id||'' and u.satz_kennz';

s:=s||'eichen is null and u.bezug_einheit_id = be.id and be.satz_kennzeichen is null and be.einheit_id = e.id and e.physeh_id in (SELECT e.physeh_id FROM inh_eh_umrs i, einheiten e WHERE i.inhstoff_id = ''||f.inhstoff_id||'' and i.satz_kennzeichen is null and i.einheit_id = e.id and e.satz_kennzeichen is null) order by u.sort asc'','||unistr('\000a')||
'''onchange="javascript:f_checklaborwerte('''''' || f.frage_ID || '''''',html_GetEl';

s:=s||'ement('''''' || f.frage_ID || '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'' || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1'||unistr('\000a')||
'    /* OR FRGBG_T.LAB_MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 */ then '' disabled'' else '''' end,'||unistr('\000a')||
'''NO'',NULL,NULL,''EH''||f.frage_ID'||unistr('\000a')||
')'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND f.bezug_einheit_id = 18';

s:=s||'1 THEN  /* Textfelder ohne EH-Eingabe z.B. pH-Werte immer bezug_einheit 181*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,181))||'||unistr('\000a')||
'         apex_item.hidden(10,NVL(p.FANTWORT_ZAHL_2,181),NULL,''EH''||f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => Keine EH-Eingabe */'||unistr('\000a')||
'         apex_item.hidden(9,NULL)||'||unistr('\000a')||
'         apex_item.hidden(10,NULL)||'||unistr('\000a')||
'         '''''||unistr('\000a')||
'      END fantwort_eh_eingabe ,'||unistr('\000a')||
'   a';

s:=s||'pex_item.hidden(11,'||unistr('\000a')||
'                     to_char(NVL(p.messdatum,sysdate),''DD.MM.RRRR hh24:mi''))||'||unistr('\000a')||
'   apex_item.text(12,to_char(NVL(p.messdatum,sysdate),''DD.MM.YYYY hh24:mi'')'||unistr('\000a')||
',20,20,''tabindex="1" autocomplete="off" onchange="javascript:f_checkdatum(''''DAT''||f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''DAT'' || f.frage_ID || '''''').value, ''''''|| f.frage_text||'''''')"'' || case when decode(NVL(FRGBG_S.FB_CHECK_FA';

s:=s||'NT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end, ''DAT''||f.frage_ID'||unistr('\000a')||
') messdatum,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         apex_item.hidden(16,NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                             WHERE frage_id = f.frage_id'||unistr('\000a')||
'                               and satz_kennzeichen is null)))||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
'  ';

s:=s||'    ELSE         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         apex_item.hidden(16,p.FANTWORT_ID)||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
'      END fantwort_id,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                                           WHERE frage_id = f.frage_id'||unistr('\000a')||
'                                             and satz_kennzeichen is null))'||unistr('\000a')||
'      ELS';

s:=s||'E         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         p.FANTWORT_ID'||unistr('\000a')||
'      END fantwort_id_disp,'||unistr('\000a')||
'   p.id persantwort_id, f.frage_id frage_id,p.FANTWORT_ZAHL,p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'   CASE WHEN p.fantwort_text is NULL THEN'||unistr('\000a')||
'     CASE WHEN p.LABOR_FAS_ERSATZWERT_ID is not null THEN'||unistr('\000a')||
'        (SELECT frgbg_s.HOLEN_UEBERSETZUNG(KUERZEL_TEXT_ID,:fas_sprache_id) FROM LABOR_FAS_ERSATZWERTE WHERE ID = p.LABOR_FAS_ERSATZWERT';

s:=s||'_ID)'||unistr('\000a')||
'     ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id)'||unistr('\000a')||
'     END'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id,p.fantwort_text )'||unistr('\000a')||
'   END ersatzwert_text,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND (select max(NORMIERUNGSTYP) from FANTWORTEN where FRAGE_Id = f.FRAGE_ID) = ''LABORBEREICH'' THEN'||unistr('\000a')||
'         CASE WHEN FRGBG_T.LAB_';

s:=s||'MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 THEN'||unistr('\000a')||
'           -- Wenn Labor mehrere Normbereiche geliefert hat, dürfen diese hier nicht bearbeitet werden,'||unistr('\000a')||
'           -- da über die Maske nur personenspezifische Normbereiche eingegeben werden dürfen'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
'  ';

s:=s||'         apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT))'||unistr('\000a')||
'         ELSE'||unistr('\000a')||
'           apex_item.hidden(17,CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                    CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p';

s:=s||'.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standardnormbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                   ELSE ';

s:=s||'NULL END'||unistr('\000a')||
'                END'||unistr('\000a')||
'                   ) ||'||unistr('\000a')||
'           apex_item.text(18, CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                  CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standard';

s:=s||'normbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                  ELSE NULL END'||unistr('\000a')||
'                END, 10,15,''tabindex="1" autocomplete="off" ';

s:=s||'onblur="javascript:f_checknormbereich(''''NORMB'' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''NORMB'' ||f.frage_ID || '''''').value, html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value)"'''||unistr('\000a')||
'              || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end'||unistr('\000a')||
'            , ''NORMB'' || f.frage_ID'||unistr('\000a')||
'         )'||unistr('\000a')||
'        END'||unistr('\000a')||
'     ELSE -- Bei ';

s:=s||'anderen Anzeigetypen auch keine Eingabe möglich'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
'           apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT),''NORMB'' || f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'     END fantwort_normbereich'||unistr('\000a')||
'from v_fragen f, persantworten p --, uebersetzungen u -';

s:=s||'- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'where f.fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  and (f.fkategorie_fkategorie_id = :p31_tab34_kategorie_id or'||unistr('\000a')||
'       f.FKATEGORIE_fkategorie_ID is null and f.fkategorie_id='||unistr('\000a')||
'                                              :p31_tab34_kategorie_id'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and f.personenstamm_id = :p1_id'||unistr('\000a')||
'  AND f.sprache_id = :fas_sprache_id'||unistr('\000a')||
'  AND f.fragelevel = 0';

s:=s||' /* keine Metafragen */'||unistr('\000a')||
'  AND f.visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'  AND f.anzeigetyp_id in (3,4,5) /* Radio, Text */'||unistr('\000a')||
'  and f.frage_id = p.frage_id(+)'||unistr('\000a')||
'  and p.pergebnis_id(+) = :p1_pergebnis_id'||unistr('\000a')||
'  and p.satz_kennzeichen (+) is null'||unistr('\000a')||
'  --and f.such_text_id = u.text_id (+)'||unistr('\000a')||
'  --and u.sprache_id (+) = :fas_sprache_id'||unistr('\000a')||
'  and (:p34_suchbemerkung_NOSAVE is null OR'||unistr('\000a')||
'       --UPPER(u.text) like';

s:=s||' ''%''||UPPER(:p34_suchbemerkung_NOSAVE)||''%'' OR   -- NEI 20.11.13'||unistr('\000a')||
'       UPPER(frgbg_s.HOLEN_UEBERSETZUNG(f.such_text_id,:fas_sprache_id)) like ''%''||UPPER(:p34_suchbemerkung_NOSAVE)||''%'' OR'||unistr('\000a')||
'       UPPER(f.FRAGE_TEXT) like ''%''||UPPER(:p34_suchbemerkung_NOSAVE)||''%'''||unistr('\000a')||
'      )'||unistr('\000a')||
'--  and f.frage_id > 0   -- Nur zu Testzwecken'||unistr('\000a')||
'--order by f.fkategorie_sort,f.frage_sort'||unistr('\000a')||
'--order by f.fkategorie_sort,CASE WHEN ';

s:=s||'p.id is null THEN 0 ELSE 1 END desc ,f.frage_text'||unistr('\000a')||
'order by f.fkategorie_sort,f.frage_text';

wwv_flow_api.create_report_region (
  p_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;margin:10px">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P31_TAB34_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '300',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'MILLIMETERS',
  p_prn_paper_size=> 'A4',
  p_prn_height=> 210,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703623531858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703726674858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703803310858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703900205858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_EINGABE',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8704027816858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_EH_EINGABE',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8704131404858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'MESSDATUM',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8704227330858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8702916540858393 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID_DISP',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703025907858393 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'PERSANTWORT_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703122208858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703209698858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703323627858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_2',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703510385858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'ERSATZWERT_TEXT',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8703406236858394 + wwv_flow_api.g_id_offset,
  p_region_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_NORMBEREICH',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 8705710769858397 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8705913395858397 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 35,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8706131478858398 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 8704300956858394 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 34,
  p_button_sequence=> 10,
  p_button_plug_id => 8702723825858392+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8704525031858395 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 34,
  p_button_sequence=> 15,
  p_button_plug_id => 8702723825858392+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8704727750858395 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 34,
  p_button_sequence=> 20,
  p_button_plug_id => 8702723825858392+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:34:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8704922016858395 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 34,
  p_button_sequence=> 30,
  p_button_plug_id => 8702723825858392+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8705108749858395 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 34,
  p_button_sequence=> 40,
  p_button_plug_id => 8702723825858392+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>8707612128858400 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 34,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>8705108749858395+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>8707822159858401 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 34,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:34:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8705321112858396 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 34,
  p_name=>'P34_ICON_SUCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 8702723825858392+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'SUCHEN',
  p_source=>'SUCHEN',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_button_image => '24find.gif',
  p_button_image_attr=> 'onclick="xwoher=2"',
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'N',
  p_button_execute_validations=>'Y',
  p_button_action => 'SUBMIT',
  p_button_is_hot=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8705529977858396 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 34,
  p_name=>'P34_SUCHBEMERKUNG_NOSAVE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 8702723825858392+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onclick="xwoher=2"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 8706413191858398 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 34,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_eingabe',
  p_validation_sequence=> 50,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_change  NUMBER := 0;'||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'   v_sprache_id number := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Check wurde ausgelagert, da Code zu lang'||unistr('\000a')||
'   v_change := frgbg_s.fb_check_labor_eing(v_fehlertext);'||unistr('\000a')||
'   -- Fehler wird erst vor Speichern ausgewertet und mit Raise angezeigt'||unistr('\000a')||
'   :p1_fehler := v_fehlertext;'||unistr('\000a')||
'   IF v_change = 0 THEN  -- Keine Daten geändert'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(2020,v_sprache_id ));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 8704922016858395 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPLIC';

p:=p||'ATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
'  v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
'  IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
'  END IF; '||unistr('\000a')||
'  FRGBG_S.SPEICHERN_LABOR'||unistr('\000a')||
'     ( '||unistr('\000a')||
'      v_user,:p31_tab34_kategorie_id/* 71,116:P1_TAB4_KATEGORIE_ID*/,'||unistr('\000a')||
'     :p1_fragebogen_id,:p1_id,:p1_pergebnis_id,'||unistr('\000a')||
'      v_sprache_id , :P1_FEHLER'||unistr('\000a')||
'     )';

p:=p||';'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung auch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 8707115545858400 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 34,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'',''SUCHEN'',''P34_SUCHBEMERKUNG_NOSAVE'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text'||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p31_tab34_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p31_tab34_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_h';

p:=p||'inweis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 8707310700858400 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 34,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 8706526824858399 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 34,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 8706726080858399 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 34,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 8706909814858399 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 34,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 34
--
 
begin
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6446401500121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 1,
  p_query_column_name=> 'FKATEGORIE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6446510062121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 2,
  p_query_column_name=> 'LINK',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6446621101121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 3,
  p_query_column_name=> 'FRAGE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6446700999121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 4,
  p_query_column_name=> 'FANTWORT_ZAHL_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6446813110121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 5,
  p_query_column_name=> 'FANTWORT_EH_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6446932231121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 6,
  p_query_column_name=> 'MESSDATUM',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6447026472121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 7,
  p_query_column_name=> 'FANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6447118591121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 8,
  p_query_column_name=> 'FANTWORT_ID_DISP',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6447226655121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 9,
  p_query_column_name=> 'PERSANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6447308945121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 10,
  p_query_column_name=> 'FRAGE_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6447405359121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 11,
  p_query_column_name=> 'FANTWORT_ZAHL',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6447510073121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 12,
  p_query_column_name=> 'FANTWORT_ZAHL_2',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6447624854121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 13,
  p_query_column_name=> 'ERSATZWERT_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6447719276121858 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8702723825858392 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 14,
  p_query_column_name=> 'FANTWORT_NORMBEREICH',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00035
prompt  ...PAGE 35: Aktualisieren FRAGEBOGENANZEIGE 35
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 35
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Aktualisieren FRAGEBOGENANZEIGE 35'
 ,p_step_title => 'Aktualisieren FRAGEBOGENANZEIGE 35'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_html_page_onload => 'onBeforeUnload="return WarnSave();"'
 ,p_step_sub_title => 'Aktualisieren FRAGEBOGENANZEIGE 35'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_welcome_text => '<script language="JavaScript1.1" type="text/javascript">'||unistr('\000a')||
'<!--'||unistr('\000a')||
'function f_checklaborwerte (feld_id,wert,eh_id)'||unistr('\000a')||
'{ '||unistr('\000a')||
'  var feld_menge = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkLaborWerte'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  get.add(''P31_EINHEIT_ID_INPUT'',eh_id);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = gReturn ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  /*html_GetElement(''P202_FEHLERTEXT'').value = '''' ;*/'||unistr('\000a')||
'       html_GetElement(feld_menge).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'function f_checkdatum(feld_id,datum,fragetext)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_datum = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkMessdatum'',0);'||unistr('\000a')||
'  get.add(''P31_DATUM'',datum);'||unistr('\000a')||
'  get.add(''P31_FRAGE_TEXT'',fragetext);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_datum).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
''||unistr('\000a')||
'function f_checknormbereich(feld_id,normbereich,wert)'||unistr('\000a')||
'{'||unistr('\000a')||
'  var feld_normbereich = document.getElementById(feld_id);'||unistr('\000a')||
'  var get = new  htmldb_Get(null,&APP_ID.,''APPLICATION_PROCESS=checkNormbereich'',0);'||unistr('\000a')||
'  get.add(''P31_ID_INPUT'',feld_id);'||unistr('\000a')||
'  get.add(''P31_NORMBEREICH'',normbereich);'||unistr('\000a')||
'  get.add(''P31_WERT_INPUT'',wert);'||unistr('\000a')||
'  gReturn = get.get();'||unistr('\000a')||
'  if(gReturn)'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="red";'||unistr('\000a')||
'       alert(gReturn);'||unistr('\000a')||
'    }'||unistr('\000a')||
'    else'||unistr('\000a')||
'    {  '||unistr('\000a')||
'       html_GetElement(feld_normbereich).style.color="black";'||unistr('\000a')||
'    }'||unistr('\000a')||
'  get = null; '||unistr('\000a')||
'}'||unistr('\000a')||
'//-->'||unistr('\000a')||
'</script>'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20141022145033'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select'||unistr('\000a')||
'   f.fkategorie_text fkategorie_text,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'   WHEN hilfe_text_id is not null'||unistr('\000a')||
'   THEN ''<a href="javascript:popUp2('''''''||unistr('\000a')||
'   ||APEX_UTIL.PREPARE_URL('||unistr('\000a')||
'   ''f?p=&APP_ID.:103:&SESSION.::&DEBUG.::P103_hilfe_text_id,P103_frage_text_id:'''||unistr('\000a')||
'   || f.hilfe_text_id||'',''||f.frage_text_id)'||unistr('\000a')||
'   || '''''',700,425)">'''||unistr('\000a')||
'   || ''<img src="#IMAGE_PREFIX#wwv_help_ff.gif">'''||unistr('\000a')||
'   || ''</a>'''||unistr('\000a')||
'   ELSE '' '''||unistr('\000a')||
'   END LINK,'||unistr('\000a')||
'   apex_i';

s:=s||'tem.hidden(2,f.frage_id) ||'||unistr('\000a')||
'   apex_item.hidden(3,p.ID) ||'||unistr('\000a')||
'   f.FRAGE_TEXT FRAGE_TEXT,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder => Wert */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id = ';

s:=s||'f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_2'||unistr('\000a')||
'                           and satz_kennzeichen is null)))||'||unistr('\000a')||
'         apex_item.text(8,FRGBG_T.LAB_TO_CHAR(p.FANTWORT_ZAHL_1,'||unistr('\000a')||
'                        (select min(formatmask) FROM inh_eh_disps'||unistr('\000a')||
'                         WHERE inhstoff_id = f.inhstoff_id'||unistr('\000a')||
'                           and bezug_einheit_id = p.fantwort_zahl_2';

s:=s||''||unistr('\000a')||
'                           and satz_kennzeichen is null)),'||unistr('\000a')||
'                        10,15,''tabindex="1" autocomplete="off"'||unistr('\000a')||
'   onchange="javascript:f_checklaborwerte('''''' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'''||unistr('\000a')||
'    || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0)';

s:=s||' = 1 then '' disabled'' else '''' end , f.frage_ID'||unistr('\000a')||
'                       )'||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => ID der Fantwort */'||unistr('\000a')||
'         apex_item.hidden(6,p.FANTWORT_ZAHL)||'||unistr('\000a')||
'         apex_item.hidden(7,p.FANTWORT_ID)||'||unistr('\000a')||
'         apex_item.select_list_from_query(8,p.FANTWORT_ID,'||unistr('\000a')||
'            ''select frgbg_s.HOLEN_UEBERSETZUNG(fant.text_id,:fas_sprache_id), fant.id from fantworten fant where fa';

s:=s||'nt.frage_id*1000000 = ''||'||unistr('\000a')||
'                                          f.frage_ID*1000000||'||unistr('\000a')||
''' and fant.satz_kennzeichen is null order by fant.sort asc '','||unistr('\000a')||
'            NULL,''NO'',NULL,NULL)'||unistr('\000a')||
'      END fantwort_zahl_eingabe,'||unistr('\000a')||
''||unistr('\000a')||
'   CASE /* Eingabefeld EH */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5  AND f.bezug_einheit_id != 181 THEN  /* Textfelder => EH-Eingabe LOV*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'';

s:=s||'               rezepte.get_inh_def_bezug_eh(f.inhstoff_id)))||'||unistr('\000a')||
'         apex_item.select_list_from_query(10,NVL(p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'                       rezepte.get_inh_def_bezug_eh(f.inhstoff_id)),'||unistr('\000a')||
'''select rezepte.get_bezug_eh_bez(u.bezug_einheit_id,:fas_sprache_id), u.bezug_einheit_id from inh_eh_disps u, bezug_einheiten be, einheiten e where u.inhstoff_id = ''||f.inhstoff_id||'' and u.satz_kennz';

s:=s||'eichen is null and u.bezug_einheit_id = be.id and be.satz_kennzeichen is null and be.einheit_id = e.id and e.physeh_id in (SELECT e.physeh_id FROM inh_eh_umrs i, einheiten e WHERE i.inhstoff_id = ''||f.inhstoff_id||'' and i.satz_kennzeichen is null and i.einheit_id = e.id and e.satz_kennzeichen is null) order by u.sort asc'','||unistr('\000a')||
'''onchange="javascript:f_checklaborwerte('''''' || f.frage_ID || '''''',html_GetEl';

s:=s||'ement('''''' || f.frage_ID || '''''').value, html_GetElement(''''EH'' || f.frage_ID || '''''').value)"'' || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1'||unistr('\000a')||
'    /* OR FRGBG_T.LAB_MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 */ then '' disabled'' else '''' end,'||unistr('\000a')||
'''NO'',NULL,NULL,''EH''||f.frage_ID'||unistr('\000a')||
')'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND f.bezug_einheit_id = 18';

s:=s||'1 THEN  /* Textfelder ohne EH-Eingabe z.B. pH-Werte immer bezug_einheit 181*/'||unistr('\000a')||
'         apex_item.hidden(9,NVL(p.FANTWORT_ZAHL_2,181))||'||unistr('\000a')||
'         apex_item.hidden(10,NVL(p.FANTWORT_ZAHL_2,181),NULL,''EH''||f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'      ELSE         /* LOV-Auswahl Radio => Keine EH-Eingabe */'||unistr('\000a')||
'         apex_item.hidden(9,NULL)||'||unistr('\000a')||
'         apex_item.hidden(10,NULL)||'||unistr('\000a')||
'         '''''||unistr('\000a')||
'      END fantwort_eh_eingabe ,'||unistr('\000a')||
'   a';

s:=s||'pex_item.hidden(11,'||unistr('\000a')||
'                     to_char(NVL(p.messdatum,sysdate),''DD.MM.RRRR hh24:mi''))||'||unistr('\000a')||
'   apex_item.text(12,to_char(NVL(p.messdatum,sysdate),''DD.MM.YYYY hh24:mi'')'||unistr('\000a')||
',20,20,''tabindex="1" autocomplete="off" onchange="javascript:f_checkdatum(''''DAT''||f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''DAT'' || f.frage_ID || '''''').value, ''''''|| f.frage_text||'''''')"'' || case when decode(NVL(FRGBG_S.FB_CHECK_FA';

s:=s||'NT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end, ''DAT''||f.frage_ID'||unistr('\000a')||
') messdatum,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         apex_item.hidden(16,NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                             WHERE frage_id = f.frage_id'||unistr('\000a')||
'                               and satz_kennzeichen is null)))||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
'  ';

s:=s||'    ELSE         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         apex_item.hidden(16,p.FANTWORT_ID)||'||unistr('\000a')||
'         '' '''||unistr('\000a')||
'      END fantwort_id,'||unistr('\000a')||
'   CASE'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 THEN  /* Textfelder */'||unistr('\000a')||
'         NVL(p.fantwort_id,(select min(id) FROM fantworten'||unistr('\000a')||
'                                           WHERE frage_id = f.frage_id'||unistr('\000a')||
'                                             and satz_kennzeichen is null))'||unistr('\000a')||
'      ELS';

s:=s||'E         /* LOV-Auswahl Radio */'||unistr('\000a')||
'         p.FANTWORT_ID'||unistr('\000a')||
'      END fantwort_id_disp,'||unistr('\000a')||
'   p.id persantwort_id, f.frage_id frage_id,p.FANTWORT_ZAHL,p.FANTWORT_ZAHL_2,'||unistr('\000a')||
'   CASE WHEN p.fantwort_text is NULL THEN'||unistr('\000a')||
'     CASE WHEN p.LABOR_FAS_ERSATZWERT_ID is not null THEN'||unistr('\000a')||
'        (SELECT frgbg_s.HOLEN_UEBERSETZUNG(KUERZEL_TEXT_ID,:fas_sprache_id) FROM LABOR_FAS_ERSATZWERTE WHERE ID = p.LABOR_FAS_ERSATZWERT';

s:=s||'_ID)'||unistr('\000a')||
'     ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id)'||unistr('\000a')||
'     END'||unistr('\000a')||
'   ELSE'||unistr('\000a')||
'       frgbg_s.HOLEN_UEBERSETZUNG(p.fantwort_text_id,:fas_sprache_id,p.fantwort_text )'||unistr('\000a')||
'   END ersatzwert_text,'||unistr('\000a')||
'   CASE /* Eingabefeld */'||unistr('\000a')||
'      WHEN f.ANZEIGETYP_ID = 5 AND (select max(NORMIERUNGSTYP) from FANTWORTEN where FRAGE_Id = f.FRAGE_ID) = ''LABORBEREICH'' THEN'||unistr('\000a')||
'         CASE WHEN FRGBG_T.LAB_';

s:=s||'MEHRERE_NORMBEREICHE_VORH(p.LABOR_NORMBEREICHE_TEXT) = 1 THEN'||unistr('\000a')||
'           -- Wenn Labor mehrere Normbereiche geliefert hat, dürfen diese hier nicht bearbeitet werden,'||unistr('\000a')||
'           -- da über die Maske nur personenspezifische Normbereiche eingegeben werden dürfen'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
'  ';

s:=s||'         apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT))'||unistr('\000a')||
'         ELSE'||unistr('\000a')||
'           apex_item.hidden(17,CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                    CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p';

s:=s||'.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standardnormbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                   ELSE ';

s:=s||'NULL END'||unistr('\000a')||
'                END'||unistr('\000a')||
'                   ) ||'||unistr('\000a')||
'           apex_item.text(18, CASE WHEN p.LABOR_NORMBEREICHE_TEXT IS NOT NULL THEN'||unistr('\000a')||
'                    FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)'||unistr('\000a')||
'                ELSE'||unistr('\000a')||
'                  CASE WHEN decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 0 THEN'||unistr('\000a')||
'                    -- Nur Standard';

s:=s||'normbereich anzeigen, wenn auch Wert eingegeben werden kann'||unistr('\000a')||
'                    FRGBG_T.LAB_GET_DEF_NORMBEREICH_TXT('||unistr('\000a')||
'                        p_inhstoff_id => f.INHSTOFF_ID,'||unistr('\000a')||
'                        p_bezug_einheit_id => NVL(p.FANTWORT_ZAHL_2,rezepte.get_inh_def_bezug_eh(f.inhstoff_id))'||unistr('\000a')||
'                    )'||unistr('\000a')||
'                  ELSE NULL END'||unistr('\000a')||
'                END, 10,15,''tabindex="1" autocomplete="off" ';

s:=s||'onblur="javascript:f_checknormbereich(''''NORMB'' || f.frage_ID ||'||unistr('\000a')||
'   '''''',html_GetElement(''''NORMB'' ||f.frage_ID || '''''').value, html_GetElement('''''' ||f.frage_ID ||'||unistr('\000a')||
'   '''''').value)"'''||unistr('\000a')||
'              || case when decode(NVL(FRGBG_S.FB_CHECK_FANT_DISPLAYONLY(:p1_pergebnis_id,p.fantwort_id),0),1,1,0) = 1 then '' disabled'' else '''' end'||unistr('\000a')||
'            , ''NORMB'' || f.frage_ID'||unistr('\000a')||
'         )'||unistr('\000a')||
'        END'||unistr('\000a')||
'     ELSE -- Bei ';

s:=s||'anderen Anzeigetypen auch keine Eingabe möglich'||unistr('\000a')||
'           apex_item.hidden(17,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT)) || -- Zum Abgleich ob Wert geändert wurde'||unistr('\000a')||
'           apex_item.display_and_save(18,FRGBG_T.LAB_NORMBEREICH_DISPL_FORMAT(p.LABOR_NORMBEREICHE_TEXT),''NORMB'' || f.frage_ID)'||unistr('\000a')||
''||unistr('\000a')||
'     END fantwort_normbereich'||unistr('\000a')||
'from v_fragen f, persantworten p --, uebersetzungen u -';

s:=s||'- NEI 20.11.13 Umstellung Zugriff uebersetzungen auf Fallback'||unistr('\000a')||
'where f.fragebogen_id =:p1_fragebogen_id'||unistr('\000a')||
'  and (f.fkategorie_fkategorie_id = :p31_tab35_kategorie_id or'||unistr('\000a')||
'       f.FKATEGORIE_fkategorie_ID is null and f.fkategorie_id='||unistr('\000a')||
'                                              :p31_tab35_kategorie_id'||unistr('\000a')||
'      )'||unistr('\000a')||
'  and f.personenstamm_id = :p1_id'||unistr('\000a')||
'  AND f.sprache_id = :fas_sprache_id'||unistr('\000a')||
'  AND f.fragelevel = 0';

s:=s||' /* keine Metafragen */'||unistr('\000a')||
'  AND f.visible = 1    /* nur sichtbare Fragen anzeigen */'||unistr('\000a')||
'  AND f.anzeigetyp_id in (3,4,5) /* Radio, Text */'||unistr('\000a')||
'  and f.frage_id = p.frage_id(+)'||unistr('\000a')||
'  and p.pergebnis_id(+) = :p1_pergebnis_id'||unistr('\000a')||
'  and p.satz_kennzeichen (+) is null'||unistr('\000a')||
'  --and f.such_text_id = u.text_id (+)'||unistr('\000a')||
'  --and u.sprache_id (+) = :fas_sprache_id'||unistr('\000a')||
'  and (:p35_suchbemerkung_NOSAVE is null OR'||unistr('\000a')||
'       --UPPER(u.text) like';

s:=s||' ''%''||UPPER(:p35_suchbemerkung_NOSAVE)||''%'' OR   -- NEI 20.11.13'||unistr('\000a')||
'       UPPER(frgbg_s.HOLEN_UEBERSETZUNG(f.such_text_id,:fas_sprache_id)) like ''%''||UPPER(:p35_suchbemerkung_NOSAVE)||''%'' OR'||unistr('\000a')||
'       UPPER(f.FRAGE_TEXT) like ''%''||UPPER(:p35_suchbemerkung_NOSAVE)||''%'''||unistr('\000a')||
'      )'||unistr('\000a')||
'--  and f.frage_id > 0   -- Nur zu Testzwecken'||unistr('\000a')||
'--order by f.fkategorie_sort,f.frage_sort'||unistr('\000a')||
'--order by f.fkategorie_sort,CASE WHEN ';

s:=s||'p.id is null THEN 0 ELSE 1 END desc ,f.frage_text'||unistr('\000a')||
'order by f.fkategorie_sort,f.frage_text';

wwv_flow_api.create_report_region (
  p_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 35,
  p_name=> '&P1_NULL_VALUE.',
  p_region_name=>'',
  p_template=> 2888300769489439+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_new_grid         => false,
  p_new_grid_row     => false,
  p_new_grid_column  => false,
  p_display_column=> 1,
  p_display_point=> 'BODY_3',
  p_item_display_point=> 'ABOVE',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div style="overflow: auto; height: &P1_HEIGHT_SCROLLREGION.px;margin:10px">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 1,
  p_query_headings_type=> 'NO_HEADINGS',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P31_TAB32_KATEGORIE_ZEILEN',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '300',
  p_pagination_display_position=> 'TOP_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'MILLIMETERS',
  p_prn_paper_size=> 'A4',
  p_prn_height=> 210,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709427542860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FKATEGORIE_TEXT',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_css_class=>'t1RegionHeader',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709501691860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709623537860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_TEXT',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709724162860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_EINGABE',
  p_column_display_sequence=> 8,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709816435860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_EH_EINGABE',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709929099860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'MESSDATUM',
  p_column_display_sequence=> 10,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8710030319860932 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID',
  p_column_display_sequence=> 11,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8708731390860930 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ID_DISP',
  p_column_display_sequence=> 12,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8708827908860930 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'PERSANTWORT_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8708907036860930 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'FRAGE_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709009502860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL',
  p_column_display_sequence=> 5,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709106265860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_ZAHL_2',
  p_column_display_sequence=> 6,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709318216860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'ERSATZWERT_TEXT',
  p_column_display_sequence=> 13,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8709226355860931 + wwv_flow_api.g_id_offset,
  p_region_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'FANTWORT_NORMBEREICH',
  p_column_display_sequence=> 14,
  p_column_heading=> '',
  p_use_as_row_header=> 'N',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_is_required=> false,
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&P1_FEHLER.';

wwv_flow_api.create_page_plug (
  p_id=> 8711515504860934 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 35,
  p_plug_name=> 'Fehler',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2891922013489440+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':p1_fehler is not null',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8711719070860934 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 35,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 35,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8711901752860934 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 35,
  p_plug_name=> 'navi_labor',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(5557414378428469 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':P1_ZURUECK_ZUR_SEITE = 323',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 8710109382860932 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 35,
  p_button_sequence=> 10,
  p_button_plug_id => 8708500209860928+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_ABBRECHEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:1,31,95::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8710316888860932 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 35,
  p_button_sequence=> 15,
  p_button_plug_id => 8708500209860928+wwv_flow_api.g_id_offset,
  p_button_name    => 'Auswertung',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(2885332167489437+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_AUSWERTUNG.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P1_PAGE_AUSWERTUNG.:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':fas_aufgerufen_von != ''PIS''',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8710526813860932 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 35,
  p_button_sequence=> 20,
  p_button_plug_id => 8708500209860928+wwv_flow_api.g_id_offset,
  p_button_name    => 'VERWERFEN',
  p_button_action  => 'REDIRECT_PAGE',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_VERWERFEN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:35:&SESSION.::&DEBUG.:::',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8710708288860932 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 35,
  p_button_sequence=> 30,
  p_button_plug_id => 8708500209860928+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_SPEICHERN.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_button_condition=> ':P1_BEARB_MODUS=''BEARBEITEN''',
  p_button_condition2=> 'BEARBEITEN',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8710918503860933 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 35,
  p_button_sequence=> 40,
  p_button_plug_id => 8708500209860928+wwv_flow_api.g_id_offset,
  p_button_name    => 'WEITER',
  p_button_action  => 'SUBMIT',
  p_button_image   => 'template:'||to_char(5444705864405057+wwv_flow_api.g_id_offset),
  p_button_is_hot=>'N',
  p_button_image_alt=> '&P1_BL_WEITER.',
  p_button_position=> 'TOP_AND_BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_execute_validations=>'Y',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>8713421002860936 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 35,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:&P1_NEXT_PAGE_ID.:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>8710918503860933+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'Y',
  p_branch_comment=> 'Created 31-OCT-2011 11:10 by BRIGITTE.NEIDHART');
 
wwv_flow_api.create_page_branch(
  p_id=>8713617196860937 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 35,
  p_branch_name=> '',
  p_branch_action=> 'f?p=&APP_ID.:35:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8711104652860933 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 35,
  p_name=>'P35_ICON_SUCHEN',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 8708500209860928+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default=> 'SUCHEN',
  p_source=>'SUCHEN',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_new_grid=> false,
  p_begin_on_new_line=> 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_button_image => '24find.gif',
  p_button_image_attr=> 'onclick="xwoher=2"',
  p_label_alignment=> 'LEFT',
  p_field_alignment=> 'LEFT',
  p_is_persistent=> 'N',
  p_button_execute_validations=>'Y',
  p_button_action => 'SUBMIT',
  p_button_is_hot=>'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8711303256860933 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 35,
  p_name=>'P35_SUCHBEMERKUNG_NOSAVE',
  p_data_type=> 'VARCHAR',
  p_is_required=> false,
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 8708500209860928+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type=> 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'NATIVE_TEXT_FIELD',
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onclick="xwoher=2"',
  p_new_grid=> false,
  p_begin_on_new_line=> 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan=> 1,
  p_rowspan=> 1,
  p_grid_column=> null,
  p_label_alignment=> 'RIGHT',
  p_field_alignment=> 'LEFT',
  p_field_template=> 2900025213489446+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_output => 'Y',
  p_attribute_01 => 'Y',
  p_attribute_02 => 'N',
  p_attribute_04 => 'TEXT',
  p_show_quick_picks=>'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 8712219464860935 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 35,
  p_tabular_form_region_id => null + wwv_flow_api.g_id_offset,
  p_validation_name => 'check_eingabe',
  p_validation_sequence=> 50,
  p_validation => 'DECLARE'||unistr('\000a')||
'   v_change  NUMBER := 0;'||unistr('\000a')||
'   v_fehlertext  VARCHAR2(4000);'||unistr('\000a')||
'   v_prot_id NUMBER;'||unistr('\000a')||
'   v_sprache_id number := :fas_sprache_id;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   -- Check wurde ausgelagert, da Code zu lang'||unistr('\000a')||
'   v_change := frgbg_s.fb_check_labor_eing(v_fehlertext);'||unistr('\000a')||
'   -- Fehler wird erst vor Speichern ausgewertet und mit Raise angezeigt'||unistr('\000a')||
'   :p1_fehler := v_fehlertext;'||unistr('\000a')||
'   IF v_change = 0 THEN  -- Keine Daten geändert'||unistr('\000a')||
'      RETURN (frgbg_s.holen_uebersetzung(2020,v_sprache_id ));'||unistr('\000a')||
'   END IF;'||unistr('\000a')||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => '',
  p_always_execute=>'N',
  p_when_button_pressed=> 8710708288860932 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_user   VARCHAR2(100);'||unistr('\000a')||
'   v_mutdat VARCHAR2(50);'||unistr('\000a')||
'   v_sprache_id  NUMBER := :fas_sprache_id; --frgbg_s.get_sprache_id(:APP_USER);'||unistr('\000a')||
'begin'||unistr('\000a')||
'  -- Prüfen, ob Antwortset für Fragebogen (pergebnisse) zwischenzeitlich geändert wurde'||unistr('\000a')||
'  SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO v_mutdat'||unistr('\000a')||
'  FROM pergebnisse'||unistr('\000a')||
'  WHERE  id = :p1_pergebnis_id;'||unistr('\000a')||
'  IF v_mutdat != :p1_mutdat THEN'||unistr('\000a')||
'     RAISE_APPLIC';

p:=p||'ATION_ERROR (-20000,frgbg_s.holen_uebersetzung(549,v_sprache_id));'||unistr('\000a')||
'  END IF;'||unistr('\000a')||
''||unistr('\000a')||
'  v_user := NVL(:P1_USER,:APP_USER);'||unistr('\000a')||
'  IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
'  END IF; '||unistr('\000a')||
'  FRGBG_S.SPEICHERN_LABOR'||unistr('\000a')||
'     ( '||unistr('\000a')||
'      v_user,:p31_tab35_kategorie_id/* 71,116:P1_TAB2_KATEGORIE_ID*/,'||unistr('\000a')||
'     :p1_fragebogen_id,:p1_id,:p1_pergebnis_id,'||unistr('\000a')||
'      v_sprache_id , :P1_FEHLER'||unistr('\000a')||
'     )';

p:=p||';'||unistr('\000a')||
' IF :p1_fehler IS NOT NULL THEN'||unistr('\000a')||
'     RAISE_APPLICATION_ERROR (-20000,:p1_fehler );'||unistr('\000a')||
' ELSE'||unistr('\000a')||
'    -- Änderung auch in pergebnisse festhalten durch Aktualisierung von mutdat'||unistr('\000a')||
'    UPDATE pergebnisse'||unistr('\000a')||
'       SET mutdat = SYSDATE'||unistr('\000a')||
'    WHERE id = :p1_pergebnis_id ;'||unistr('\000a')||
' END IF;'||unistr('\000a')||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 8712930342860936 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 35,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Daten_uebernehmen',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_when=>':request in (''SUBMIT'',''WEITER'',''SUCHEN'',''P35_SUCHBEMERKUNG_NOSAVE'') AND :P1_BEARB_MODUS=''BEARBEITEN''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||unistr('\000a')||
'   v_hinweis VARCHAR2(4000);'||unistr('\000a')||
'   cursor c_hinweis is '||unistr('\000a')||
'   SELECT frgbg_s.HOLEN_UEBERSETZUNG (fk.HINWEIS_TEXT_ID,:fas_sprache_id) text'||unistr('\000a')||
'   from fkategorien fk'||unistr('\000a')||
'   where fk.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'     and (fk.fkategorie_id = :p31_tab35_kategorie_id or'||unistr('\000a')||
'          fk.fkategorie_ID is null and'||unistr('\000a')||
'                  fk.id= :p31_tab35_kategorie_id'||unistr('\000a')||
'         )'||unistr('\000a')||
'     ;'||unistr('\000a')||
'BEGIN'||unistr('\000a')||
'   FOR r_hinweis in c_h';

p:=p||'inweis LOOP'||unistr('\000a')||
'       IF r_hinweis.text is not null THEN'||unistr('\000a')||
'          v_hinweis := v_hinweis||'' '' || r_hinweis.text;'||unistr('\000a')||
'       END IF; '||unistr('\000a')||
'   END LOOP;'||unistr('\000a')||
'   :p1_hinweistext := v_hinweis;'||unistr('\000a')||
''||unistr('\000a')||
'END ;';

wwv_flow_api.create_page_process(
  p_id     => 8713102067860936 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 35,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'hinweistext_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':p1_fehler := NULL;';

wwv_flow_api.create_page_process(
  p_id     => 8712326948860935 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 35,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p1_fehler_init',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'SELECT to_char(mutdat,''DD.MM.YYYY HH24:MI:SS'') INTO :p1_mutdat'||unistr('\000a')||
'FROM pergebnisse'||unistr('\000a')||
'WHERE ID = :p1_pergebnis_id;';

wwv_flow_api.create_page_process(
  p_id     => 8712520914860935 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 35,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'init_mutdat',
  p_process_sql_clob => p,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3865911106055915';

wwv_flow_api.create_page_process(
  p_id     => 8712723683860936 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 35,
  p_process_sequence=> 70,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'ON_DEMAND',
  p_process_name=> 'get_next_tab_page_id',
  p_process_sql_clob => 3865911106055915 + wwv_flow_api.g_id_offset,
  p_process_error_message=> '',
  p_error_display_location=> 'ON_ERROR_PAGE',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 35
--
 
begin
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6447927367125058 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 1,
  p_query_column_name=> 'FKATEGORIE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448029642125058 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 2,
  p_query_column_name=> 'LINK',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448132245125058 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 3,
  p_query_column_name=> 'FRAGE_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448211425125058 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 4,
  p_query_column_name=> 'FANTWORT_ZAHL_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448331700125058 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 5,
  p_query_column_name=> 'FANTWORT_EH_EINGABE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448407077125058 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 6,
  p_query_column_name=> 'MESSDATUM',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448529153125059 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 7,
  p_query_column_name=> 'FANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448623372125059 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 8,
  p_query_column_name=> 'FANTWORT_ID_DISP',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448726193125059 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 9,
  p_query_column_name=> 'PERSANTWORT_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448821943125059 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 10,
  p_query_column_name=> 'FRAGE_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6448919256125059 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 11,
  p_query_column_name=> 'FANTWORT_ZAHL',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6449018924125059 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 12,
  p_query_column_name=> 'FANTWORT_ZAHL_2',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6449120130125059 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 13,
  p_query_column_name=> 'ERSATZWERT_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6449209952125059 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 8708500209860928 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 14,
  p_query_column_name=> 'FANTWORT_NORMBEREICH',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00090
prompt  ...PAGE 90: Fragebogenüberprüfung
--
 
begin
 
wwv_flow_api.create_page (
  p_flow_id => wwv_flow.g_flow_id
 ,p_id => 90
 ,p_user_interface_id => 64716079194770 + wwv_flow_api.g_id_offset
 ,p_tab_set => 'TS1'
 ,p_name => 'Fragebogenüberprüfung'
 ,p_step_title => '&P1_TAB90_KATEGORIE_TEXT.'
 ,p_allow_duplicate_submissions => 'Y'
 ,p_step_sub_title => 'Fragebogenüberprüfung'
 ,p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS'
 ,p_first_item => 'AUTO_FIRST_ITEM'
 ,p_include_apex_css_js_yn => 'Y'
 ,p_autocomplete_on_off => 'ON'
 ,p_required_role => 3842620454521302 + wwv_flow_api.g_id_offset
 ,p_page_is_public_y_n => 'N'
 ,p_protection_level => 'C'
 ,p_cache_page_yn => 'N'
 ,p_cache_timeout_seconds => 21600
 ,p_cache_by_user_yn => 'N'
 ,p_help_text => 
'Für diese Seite ist keine Hilfe verfügbar.'
 ,p_last_updated_by => 'SASCHA.LENZ'
 ,p_last_upd_yyyymmddhh24miss => '20141007165808'
  );
null;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3172928617934117 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 90,
  p_plug_name=> 'Navigationspfad',
  p_region_name=>'',
  p_escape_on_http_output=>'N',
  p_plug_template=> 2886213363489437+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_new_grid         => false,
  p_plug_new_grid_row     => false,
  p_plug_new_grid_column  => false,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_item_display_point=> 'BELOW',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6313313272633459 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 2900231998489446+ wwv_flow_api.g_id_offset,
  p_translate_title=> 'Y',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => ':FAS_AUFGERUFEN_VON not in (''PIS'',''ANONYM'',''KUNDE'')'||unistr('\000a')||
'AND '||unistr('\000a')||
':P1_ZURUECK_ZUR_SEITE = 140',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Select   /* Fragen mit Antworten */ '||unistr('\000a')||
'    frgbg_s.holen_uebersetzung(fk.text_id,f.sprache_id) kategorie_text,'||unistr('\000a')||
'    f.frage_text,'||unistr('\000a')||
'    CASE /* Prüfen, ob Eingaben vollständig */'||unistr('\000a')||
'    WHEN( '||unistr('\000a')||
'         ((FLAG = ''NUM1'' OR instr(FLAG,''N1'') > 0) AND pa.fantwort_zahl IS NULL) OR'||unistr('\000a')||
'        ((FLAG = ''TEXT1'' OR instr(FLAG,''T1'') > 0) AND pa.fantwort_text IS NULL) OR'||unistr('\000a')||
'        ((FLAG in(''DATE1'',''DATETIME1'',''TIME1'') OR';

s:=s||' regexp_instr(FLAG,''(D1)|(DT1)|(TI1)'') > 0) AND'||unistr('\000a')||
'          pa.fantwort_datum IS NULL) OR'||unistr('\000a')||
'        ((FLAG = ''NUM2'' OR instr(FLAG,''N2'') > 0) AND'||unistr('\000a')||
'        (pa.fantwort_zahl IS NULL OR pa.fantwort_zahl_1 IS NULL )) OR'||unistr('\000a')||
'        ((FLAG = ''TEXT2'' OR instr(FLAG,''T2'') > 0) AND'||unistr('\000a')||
'        (pa.fantwort_text IS NULL OR pa.fantwort_text_1 IS NULL)) OR'||unistr('\000a')||
'        ((FLAG in(''DATE2'',''DATETIME2'',''TIME2'') OR regexp_instr(FLA';

s:=s||'G,''(D2)|(DT2)|(TI2)'') > 0) AND'||unistr('\000a')||
'        (pa.fantwort_datum IS NULL OR pa.fantwort_datum_1 IS NULL)) OR'||unistr('\000a')||
'        ((FLAG = ''NUM3'' OR instr(FLAG,''N3'') > 0) AND'||unistr('\000a')||
'        (pa.fantwort_zahl IS NULL OR pa.fantwort_zahl_1 IS NULL OR'||unistr('\000a')||
'         pa.fantwort_zahl_2 IS NULL )) OR'||unistr('\000a')||
'        ((FLAG = ''TEXT3'' OR instr(FLAG,''T3'') > 0) AND'||unistr('\000a')||
'        (pa.fantwort_text IS NULL OR pa.fantwort_text_1 IS NULL OR'||unistr('\000a')||
'         pa.fan';

s:=s||'twort_text_2 IS NULL)) OR'||unistr('\000a')||
'        ((FLAG in(''DATE3'',''DATETIME3'',''TIME3'') OR regexp_instr(FLAG,''(D3)|(DT3)|(TI3)'') > 0) AND'||unistr('\000a')||
'        (pa.fantwort_datum IS NULL OR pa.fantwort_datum_1 IS NULL OR'||unistr('\000a')||
'         pa.fantwort_datum_2 IS NULL)) OR'||unistr('\000a')||
'         (f.ANZEIGETYP_ID = 17 and pa.fantwort_dokument_fas_id is null)'||unistr('\000a')||
'        )'||unistr('\000a')||
'       and f.eingabepflichtig = 1'||unistr('\000a')||
'    THEN ''<a href="'''||unistr('\000a')||
'         ||''f?p=&APP_ID.:''||t';

s:=s||'o_char(fk.apex_seiten_nr)'||unistr('\000a')||
'         ||'':&SESSION.::&DEBUG.:::'''||unistr('\000a')||
'         ||''">'''||unistr('\000a')||
'         || ''<img src="#IMAGE_PREFIX#ed-item.gif">'''||unistr('\000a')||
'         || ''</a>'''||unistr('\000a')||
'    ELSE '' '''||unistr('\000a')||
'    END  LINK,'||unistr('\000a')||
'    CASE /* Darstellung des Ergebnisses, bei Radio/Checkbox erst Text dann Wert,'||unistr('\000a')||
'            sonst Wert dann Text dann Verarb. EH */'||unistr('\000a')||
'    WHEN FLAG = ''NUM1'' AND f.anzeigetyp_id in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(NVL(frgbg_s.ho';

s:=s||'len_uebersetzung(fa.text_id,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''|| pa.fantwort_zahl)'||unistr('\000a')||
'    WHEN FLAG = ''NUM1'' AND f.anzeigetyp_id not in (1,2,3,4) and '||unistr('\000a')||
'         fk.art = 1 THEN -- Std.erf'||unistr('\000a')||
'         Ltrim(pa.fantwort_zahl||'' ''|| '||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')) '||unistr('\000a')||
'    WHEN FLAG = ''NUM1'' AND f.anzeigetyp_id not in (1,2,3,4) and '||unistr('\000a')||
'         fk.art = 2 THEN --';

s:=s||' Laborerf.'||unistr('\000a')||
'         Ltrim(pa.fantwort_zahl_1||'' ''|| '||unistr('\000a')||
'               --NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')) '||unistr('\000a')||
'               rezepte.get_eh(pa.fantwort_zahl_2,f.sprache_id))'||unistr('\000a')||
'    WHEN FLAG = ''TEXT1'' AND f.anzeigetyp_id in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_text)'||unistr('\000a')||
'    WHEN FLAG = ''TEXT1'' ';

s:=s||'AND f.anzeigetyp_id not in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(pa.fantwort_text||'' ''|| '||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' ''))'||unistr('\000a')||
'    WHEN FLAG in(''DATE1'',''DATETIME1'',''TIME1'')   AND f.anzeigetyp_id in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''|| to_char(pa.fantwort_datum,NVL(fa.FORMATMASK,''DD.MM.RRRR';

s:=s||' hh24:mi'')))'||unistr('\000a')||
'    WHEN FLAG in(''DATE1'',''DATETIME1'',''TIME1'')  AND f.anzeigetyp_id not in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(to_char(pa.fantwort_datum,NVL(fa.FORMATMASK,''DD.MM.RRRR hh24:mi''))||'' ''|| '||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' ''))'||unistr('\000a')||
'    WHEN FLAG = ''NUM2'' AND f.anzeigetyp_id in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id)';

s:=s||','' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_zahl||''<br>''||'||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_zahl_1)'||unistr('\000a')||
'    WHEN FLAG = ''NUM2'' AND f.anzeigetyp_id not in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(pa.fantwort_zahl||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')||''<br>''||'||unistr('\000a')||
'               pa.fantwort_zahl_1||'' ''';

s:=s||'||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' ''))'||unistr('\000a')||
'    WHEN FLAG = ''TEXT2'' AND f.anzeigetyp_id in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_text||''<br>''||'||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_text_1 )'||unistr('\000a')||
'    WHEN FLAG';

s:=s||' = ''TEXT2'' AND f.anzeigetyp_id not in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(pa.fantwort_text||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')||''<br>''||'||unistr('\000a')||
'               pa.fantwort_text_1||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' ''))'||unistr('\000a')||
'    WHEN FLAG in(''DATE2'',''DATETIME2'',''TIME2'')  AND f.anzeigetyp_id in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(NVL(frgbg_s.';

s:=s||'holen_uebersetzung(fa.text_id,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||to_char(pa.fantwort_datum,NVL(fa.FORMATMASK,''DD.MM.RRRR hh24:mi'')) ||''<br>''||'||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||to_char(pa.fantwort_datum_1,NVL(fa.FORMATMASK_1,''DD.MM.RRRR hh24:mi'')) )'||unistr('\000a')||
'    WHEN FLAG in(''DATE2'',''DATETIME2'',''TIME2'')  AND f.anzeigetyp_id not in (1';

s:=s||',2,3,4) THEN'||unistr('\000a')||
'         Ltrim(to_char(pa.fantwort_datum,NVL(fa.FORMATMASK,''DD.MM.RRRR hh24:mi''))||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')||''<br>''||'||unistr('\000a')||
'               to_char(pa.fantwort_datum_1,NVL(fa.FORMATMASK_1,''DD.MM.RRRR hh24:mi''))||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' ''))'||unistr('\000a')||
'    WHEN FLAG = ''NUM3'' AND f.anzeigetyp_id in (1,2';

s:=s||',3,4) THEN'||unistr('\000a')||
'         Ltrim(NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_zahl ||''<br>''||'||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_zahl_1 ||''<br>''||'||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id_2,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_zahl_2 )'||unistr('\000a')||
'    WHEN ';

s:=s||'FLAG = ''NUM3'' AND f.anzeigetyp_id not in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(pa.fantwort_zahl||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')||''<br>''||'||unistr('\000a')||
'               pa.fantwort_zahl_1||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' '')||'||unistr('\000a')||
'              ''<br>''||pa.fantwort_zahl_2||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id_2,f.spra';

s:=s||'che_id),'' ''))'||unistr('\000a')||
'    WHEN FLAG = ''TEXT3'' AND f.anzeigetyp_id in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_text ||''<br>''||'||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_text_1 ||''<br>''||'||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id_2,f.sprac';

s:=s||'he_id),'' '')'||unistr('\000a')||
'               ||'': ''||pa.fantwort_text_2 )'||unistr('\000a')||
'    WHEN FLAG = ''TEXT3'' AND f.anzeigetyp_id not in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(pa.fantwort_text||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')||''<br>''||'||unistr('\000a')||
'               pa.fantwort_text_1||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' '')||'||unistr('\000a')||
'              ''<br>''||pa.fantwort_text_2||';

s:=s||''' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id_2,f.sprache_id),'' ''))'||unistr('\000a')||
'    WHEN FLAG in(''DATE3'',''DATETIME3'',''TIME3'')  AND f.anzeigetyp_id in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim(NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||to_char(pa.fantwort_datum,NVL(fa.FORMATMASK,''DD.MM.RRRR hh24:mi''))||''<br>''||'||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,';

s:=s||'f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||to_char(pa.fantwort_datum_1,NVL(fa.FORMATMASK_1,''DD.MM.RRRR hh24:mi'')) ||''<br>''||'||unistr('\000a')||
'               NVL(frgbg_s.holen_uebersetzung(fa.text_id_2,f.sprache_id),'' '')'||unistr('\000a')||
'               ||'': ''||to_char(pa.fantwort_datum_2,NVL(fa.FORMATMASK_2,''DD.MM.RRRR hh24:mi'')) )'||unistr('\000a')||
'    WHEN FLAG in(''DATE3'',''DATETIME3'',''TIME3'') AND f.anzeigetyp_id not in (1,2,3,4) THEN'||unistr('\000a')||
'         Ltrim';

s:=s||'(to_char(pa.fantwort_datum,NVL(fa.FORMATMASK,''DD.MM.RRRR hh24:mi''))||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id),'' '')||''<br>''||'||unistr('\000a')||
'               to_char(pa.fantwort_datum_1,NVL(fa.FORMATMASK_1,''DD.MM.RRRR hh24:mi''))||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id_1,f.sprache_id),'' '')||'||unistr('\000a')||
'              ''<br>''||to_char(pa.fantwort_datum_2,NVL(fa.FORMATMASK_2,''DD.MM';

s:=s||'.RRRR hh24:mi''))||'' ''||'||unistr('\000a')||
'          NVL(frgbg_s.holen_uebersetzung(fa.text_id_2,f.sprache_id),'' ''))'||unistr('\000a')||
'    WHEN f.anzeigetyp_id in(17) AND pa.FANTWORT_DOKUMENT_FAS_ID is not null then'||unistr('\000a')||
'       (select BESCHREIBUNG from DOKUMENTE_FAS where id = pa.FANTWORT_DOKUMENT_FAS_ID)'||unistr('\000a')||
'    WHEN FLAG = ''TI2,T1'' THEN -- Tätigkeitsprotokoll'||unistr('\000a')||
'       to_char(pa.FANTWORT_DATUM,''HH24:MI'') || CASE WHEN pa.FANTWORT_DATUM_1 <> p';

s:=s||'a.FANTWORT_DATUM THEN '' - '' || to_char(pa.FANTWORT_DATUM_1,''HH24:MI'') ELSE null END || '' : '' || pa.FANTWORT_TEXT'||unistr('\000a')||
'    ELSE'||unistr('\000a')||
'       frgbg_s.holen_uebersetzung(fa.text_id,f.sprache_id)'||unistr('\000a')||
'    END antwort_text,'||unistr('\000a')||
'    f.frage_sort,f.fkategorie_sort'||unistr('\000a')||
'from v_fragen f, persantworten  pa , fantworten    fa,'||unistr('\000a')||
'     personenstamm p, --app_sprachen s,'||unistr('\000a')||
'     fkategorien fk '||unistr('\000a')||
'where f.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'and ';

s:=s||'f.personenstamm_id= :p1_id'||unistr('\000a')||
'and pa.FRAGE_ID  = f.frage_id'||unistr('\000a')||
'and pa.FRAGEBOGEN_ID  = f.FRAGEBOGEN_ID'||unistr('\000a')||
'and pa.personenstamm_ID  = f.PERSONENSTAMM_ID'||unistr('\000a')||
'and pa.pergebnis_id = :p1_pergebnis_id'||unistr('\000a')||
'and pa.satz_kennzeichen is null   -- NEI 22.04.10'||unistr('\000a')||
'and fa.ID = pa.FANTWORT_ID'||unistr('\000a')||
'and p.id =f.personenstamm_id       '||unistr('\000a')||
'--and p.app_sprache_id = s.id     -- Sprachfestlegung aus Personenstamm'||unistr('\000a')||
'and f.sprache_id = :fas_sprache_i';

s:=s||'d'||unistr('\000a')||
'and f.FKATEGORIE_ID = fk.ID'||unistr('\000a')||
'/*and (fk.kategorietyp_id = 1 AND p.geschlecht = ''W'' '||unistr('\000a')||
'     OR fk.kategorietyp_id is NULL  OR fk.kategorietyp_id <> 1 )'||unistr('\000a')||
'*/'||unistr('\000a')||
'and (frgbg_s.CHECK_TAB_ANZEIGEN_N(:p1_pergebnis_id,f.fkategorie_id)=1 )'||unistr('\000a')||
'AND f.fragelevel = 0 /* keine Metafragen */'||unistr('\000a')||
'and f.visible = 1 /* nur sichtbare Frage */'||unistr('\000a')||
'and fk.art = 1       /* nur Fragen aus Std.tabs, keine Labor-tabs */'||unistr('\000a')||
'and fk.satz_kennzei';

s:=s||'chen is null --NEI 19.05.10'||unistr('\000a')||
'and fa.satz_kennzeichen is null --NEI 19.05.10'||unistr('\000a')||
'UNION    /* Fragen ohne Antworten */'||unistr('\000a')||
'Select '||unistr('\000a')||
'    frgbg_s.holen_uebersetzung(fk.text_id,f.sprache_id) , '||unistr('\000a')||
'    f.frage_text,'||unistr('\000a')||
'    CASE'||unistr('\000a')||
'    WHEN f.eingabepflichtig = 1 '||unistr('\000a')||
'    THEN ''<a href="'''||unistr('\000a')||
'         ||''f?p=&APP_ID.:''||to_char(fk.apex_seiten_nr)'||unistr('\000a')||
'         ||'':&SESSION.::&DEBUG.:::'''||unistr('\000a')||
'         ||''">'''||unistr('\000a')||
'         || ''<img src="#IMAGE_PRE';

s:=s||'FIX#ed-item.gif">'''||unistr('\000a')||
'         || ''</a>'''||unistr('\000a')||
'    ELSE '' '''||unistr('\000a')||
'    END,'||unistr('\000a')||
'    NULL,'||unistr('\000a')||
'    f.frage_sort,f.fkategorie_sort'||unistr('\000a')||
'from v_fragen f , personenstamm p, --app_sprachen s,'||unistr('\000a')||
'     fkategorien fk '||unistr('\000a')||
'where f.fragebogen_id = :p1_fragebogen_id'||unistr('\000a')||
'and f.personenstamm_id= :p1_id'||unistr('\000a')||
'AND ( :p1_pergebnis_id is NULL OR frage_id not in ('||unistr('\000a')||
'           Select pa1.frage_id /* Fragen zu denen es mögliche Antworten gibt */ '||unistr('\000a')||
'           from';

s:=s||' persantworten pa1, fantworten fa1'||unistr('\000a')||
'           where pa1.pergebnis_id = :p1_pergebnis_id '||unistr('\000a')||
'             and pa1.satz_kennzeichen is null'||unistr('\000a')||
'             and pa1.fantwort_id = fa1.id'||unistr('\000a')||
'             and fa1.satz_kennzeichen is null  -- NEI 19.05.10'