/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetLCFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterLCFixed";
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Mon_Aug_29_23:34:29_PDT_2011";
    public static final boolean TRACE = false;

    CharacterSetLCFixed(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
        this.m_leadingCodes = jdbcCharacterConverters.getLeadingCodes();
    }

    static CharacterSetLCFixed getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 3) {
            return new CharacterSetLCFixed(n2, jdbcCharacterConverters);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        if (characterWalker.bytes.length - characterWalker.next < 4) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = characterWalker.bytes[characterWalker.next] << 8 | characterWalker.bytes[characterWalker.next + 1];
        for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
            if (n2 != this.m_leadingCodes[i2]) continue;
            int n3 = 0;
            for (int i3 = 0; i3 < 4; ++i3) {
                n3 = n3 << 8 | characterWalker.bytes[characterWalker.next++];
            }
            return n3;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 181, "Leading code invalid");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = n2 >> 16;
        for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
            if (n3 != this.m_leadingCodes[i2]) continue;
            CharacterSetLCFixed.need(characterBuffer, 4);
            for (int i3 = 3; i3 >= 0; --i3) {
                characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> 8 * i3 & 0xFF);
            }
            return;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 181, "Leading code invalid");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

