/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.lang.reflect.Constructor;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;
import net.sf.jasperreports.engine.virtualization.VirtualizationSerializable;

public class SerializableSerializer<T extends VirtualizationSerializable>
implements ObjectSerializer<T> {
    private static final Class<?>[] NO_ARGS_TYPES = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private final int typeValue;
    private final Class<T> type;
    private final Constructor<T> constructor;

    public SerializableSerializer(int typeValue, Class<T> type) {
        this.typeValue = typeValue;
        this.type = type;
        this.constructor = this.initConstructor();
    }

    private Constructor<T> initConstructor() {
        try {
            return this.type.getConstructor(NO_ARGS_TYPES);
        }
        catch (NoSuchMethodException e) {
            throw new JRRuntimeException("Failed to initialize virtualization serializable class " + this.type.getName(), e);
        }
        catch (SecurityException e) {
            throw new JRRuntimeException("Failed to initialize virtualization serializable class " + this.type.getName(), e);
        }
    }

    @Override
    public int typeValue() {
        return this.typeValue;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.IDENTITY;
    }

    @Override
    public boolean defaultStoreReference() {
        return false;
    }

    @Override
    public void write(T value, VirtualizationOutput out) throws IOException {
        if (!this.type.isInstance(value)) {
            throw new JRRuntimeException("Unexpected value " + value + " of type " + value.getClass().getName() + ", expecting " + this.type.getName());
        }
        value.writeVirtualized(out);
    }

    @Override
    public T read(VirtualizationInput in) throws IOException {
        VirtualizationSerializable object;
        try {
            object = (VirtualizationSerializable)this.constructor.newInstance(NO_ARGS);
        }
        catch (Exception e) {
            throw new JRRuntimeException("Failed to instantiate class " + this.type.getName(), e);
        }
        object.readVirtualized(in);
        return (T)object;
    }
}

