/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Random;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.ObjectUtils;

public abstract class JRTemplateElement
implements JRCommonElement,
Serializable,
JRPropertiesHolder,
Deduplicable {
    private static final long serialVersionUID = 10200L;
    private static final Random randomId = new Random();
    private String key;
    private ModeEnum modeValue;
    private Color forecolor;
    private Color backcolor;
    protected JROrigin origin;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;
    private final String id;
    private JRPropertiesMap propertiesMap;
    private int PSEUDO_SERIAL_VERSION_UID = 50004;
    private Byte mode;

    protected JRTemplateElement(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        this.origin = origin;
        this.defaultStyleProvider = defaultStyleProvider;
        this.id = this.createId();
    }

    protected JRTemplateElement(JROrigin origin, JRElement element) {
        this.origin = origin;
        this.setElement(element);
        this.id = this.createId();
    }

    protected JRTemplateElement(String id) {
        this.id = id;
    }

    private String createId() {
        return System.identityHashCode(this) + "_" + System.currentTimeMillis() + "_" + randomId.nextInt();
    }

    public void setElement(JRElement element) {
        this.parentStyle = element.getStyle();
        this.key = element.getKey();
        this.modeValue = element.getOwnModeValue();
        this.forecolor = element.getOwnForecolor();
        this.backcolor = element.getOwnBackcolor();
    }

    public JROrigin getOrigin() {
        return this.origin;
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }

    protected JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    @Override
    public int getWidth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHeight() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.OPAQUE);
    }

    @Override
    public ModeEnum getOwnModeValue() {
        return this.modeValue;
    }

    @Override
    public void setMode(ModeEnum modeValue) {
        this.modeValue = modeValue;
    }

    @Override
    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.forecolor;
    }

    @Override
    public void setForecolor(Color forecolor) {
        this.forecolor = forecolor;
    }

    @Override
    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    @Override
    public void setBackcolor(Color backcolor) {
        this.backcolor = backcolor;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getStyleNameReference() {
        return null;
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    public void setStyle(JRStyle style) {
        this.parentStyle = style;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.modeValue = ModeEnum.getByValue(this.mode);
            this.mode = null;
        }
    }

    protected void addTemplateHash(ObjectUtils.HashCode hash) {
        hash.addIdentity(this.defaultStyleProvider == null ? null : this.defaultStyleProvider.getDefaultStyle());
        hash.addIdentity(this.parentStyle);
        hash.add(this.origin);
        hash.add(this.key);
        hash.add(this.modeValue);
        hash.add(this.forecolor);
        hash.add(this.backcolor);
        hash.add(this.propertiesMap);
    }

    protected boolean templateIdentical(JRTemplateElement template) {
        return (this.defaultStyleProvider == null ? template.defaultStyleProvider == null : template.defaultStyleProvider != null && ObjectUtils.equalsIdentity(this.defaultStyleProvider.getDefaultStyle(), template.defaultStyleProvider.getDefaultStyle())) && ObjectUtils.equalsIdentity(this.parentStyle, template.parentStyle) && ObjectUtils.equals(this.origin, template.origin) && ObjectUtils.equals(this.key, template.key) && ObjectUtils.equals(this.modeValue, template.modeValue) && ObjectUtils.equals(this.forecolor, template.forecolor) && ObjectUtils.equals(this.backcolor, template.backcolor) && ObjectUtils.equals(this.propertiesMap, template.propertiesMap);
    }
}

