/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import com.lowagie.text.pdf.PdfWriter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.GenericElementPdfHandler;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterContext;

public class IconLabelElementPdfHandler
implements GenericElementPdfHandler {
    private String fieldNameParameter;
    private String textParameter;
    private String defaultTextParameter;

    @Override
    public void exportElement(JRPdfExporterContext exporterContext, JRGenericPrintElement element) {
        PdfWriter writer = exporterContext.getPdfWriter();
        JasperPrint jasperPrint = exporterContext.getExportedReport();
        JRPrintText labelPrintText = (JRPrintText)element.getParameterValue("labelTextElement");
        if (labelPrintText == null) {
            return;
        }
        JRPdfExporter exporter = (JRPdfExporter)exporterContext.getExporter();
        labelPrintText.setX(element.getX());
        labelPrintText.setY(element.getY());
        try {
            exporter.exportText(labelPrintText);
        }
        catch (Exception e) {
            throw new JRRuntimeException(e);
        }
        JRGenericPrintElement iconGenericElement = (JRGenericPrintElement)element.getParameterValue("iconGenericElement");
        JRPrintText iconPrintText = (JRPrintText)iconGenericElement.getParameterValue("iconTextElement");
        if (iconPrintText != null) {
            iconPrintText.setX(element.getX() + iconPrintText.getX());
            iconPrintText.setY(element.getY() + iconPrintText.getY());
            try {
                exporter.exportText(iconPrintText);
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public String getFieldNameParameter() {
        return this.fieldNameParameter;
    }

    public String getFieldName(JRGenericPrintElement element) {
        return (String)element.getParameterValue(this.fieldNameParameter);
    }

    public void setFieldNameParameter(String fieldNameParameter) {
        this.fieldNameParameter = fieldNameParameter;
    }

    public String getDefaultTextParameter() {
        return this.defaultTextParameter;
    }

    public String getDefaultText(JRGenericPrintElement element) {
        return element.getParameterValue(this.defaultTextParameter) == null ? null : element.getParameterValue(this.defaultTextParameter).toString();
    }

    public void setDefaultTextParameter(String defaultTextParameter) {
        this.defaultTextParameter = defaultTextParameter;
    }

    public String getTextParameter() {
        return this.textParameter;
    }

    public String getText(JRGenericPrintElement element) {
        return element.getParameterValue(this.textParameter) == null ? null : element.getParameterValue(this.textParameter).toString();
    }

    public void setTextParameter(String textParameter) {
        this.textParameter = textParameter;
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

