/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import rex.graphics.CubeExplorer2;
import rex.graphics.IViewer;
import rex.graphics.MDXViewer;
import rex.graphics.Page;
import rex.graphics.RexTabbedPane;
import rex.graphics.StatusBar;
import rex.graphics.Toolbar;
import rex.graphics.TupleMemberLabelPopUpActions;
import rex.graphics.charts.Chart;
import rex.graphics.charts.ChartPickerDialog;
import rex.graphics.dimensiontree.DimensionTree;
import rex.graphics.dimensiontree.DimensionTreeModel;
import rex.graphics.dimensiontree.dnd.TreeDragSource;
import rex.graphics.dimensiontree.elements.DimensionElement;
import rex.graphics.filtertree.FilterTree;
import rex.graphics.filtertree.FilterTreeModel;
import rex.graphics.filtertree.elements.FilterTreeRootElement;
import rex.metadata.CubeSlicer;
import rex.metadata.ExecuteResult;
import rex.metadata.ExecuteResultParseException;
import rex.metadata.Query;
import rex.metadata.QueryElement;
import rex.metadata.ServerMetadata;
import rex.metadata.resultelements.Member;
import rex.metadata.resultelements.Tuple;
import rex.utils.I18n;
import rex.utils.S;
import rex.utils.UIPropertyManager;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAExecuteProperties;
import rex.xmla.XMLAObjectsFactory;

public class Viewer
extends JPanel
implements IViewer {
    private Toolbar toolbar;
    private DimensionTree dimTree;
    private JSplitPane splitPane;
    private JPanel rightPane;
    private JPanel leftPane;
    private LinkedList filterTrees;
    private LinkedList chartTabs;
    private TreeDragSource ds;
    private Query q;
    private LinkedList chapters;
    private StatusBar statusBar;
    private XMLADiscoverRestrictions restrictions;
    private XMLADiscoverProperties properties;
    private XMLAExecuteProperties execProperties;
    private ServerMetadata smd;
    private Document d;
    private ExecuteResult er;
    private static int MAX_CHAPTER_COUNT = 10;
    private boolean errorOccured;
    private String errorMessage;
    private RexTabbedPane parentTabbedPane;
    private MDXViewer mdxViewer;
    private CubeExplorer2 cubeExplorer;
    private static ImageIcon tableIcon = S.getAppIcon("table.gif");
    private static ImageIcon chartIcon = S.getAppIcon("chart.gif");

    public Viewer(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd, JTabbedPane _parentTabbedPane) {
        this(_restrictions, _properties, _smd);
        this.parentTabbedPane = (RexTabbedPane)_parentTabbedPane;
    }

    public Viewer(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd) {
        this.restrictions = _restrictions;
        this.properties = _properties;
        this.smd = _smd;
        this.execProperties = XMLAObjectsFactory.newXMLAExecuteProperties();
        this.execProperties.setCatalog(this.properties.getCatalog());
        this.execProperties.setDataSourceInfo(this.properties.getDataSourceInfo());
        this.q = new Query(_restrictions.getCubeName(), this);
        this.dimTree = new DimensionTree(_restrictions, _properties, _smd, this.q);
        this.ds = new TreeDragSource(this.dimTree.getTree(), 3);
        this.rightPane = new JPanel(){
            {
                this.setOpaque(false);
            }

            public void paintComponent(Graphics g) {
                S.paintBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.rightPane.setLayout(new BoxLayout(this.rightPane, 1));
        this.rightPane.setBackground(Color.BLACK);
        this.chapters = new LinkedList();
        Page c = new Page(this.dimTree.getTree(), this.q);
        c.setCurrent(true);
        this.chapters.add(c);
        this.rightPane.add(c);
        this.leftPane = new JPanel();
        this.leftPane.setLayout(new BorderLayout());
        this.leftPane.add((Component)this.dimTree, "Center");
        this.splitPane = new JSplitPane(1, this.leftPane, this.rightPane);
        this.splitPane.setContinuousLayout(false);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(8);
        this.splitPane.setDividerLocation((int)this.dimTree.getMinimumSize().getWidth());
        this.setLayout(new BorderLayout());
        this.toolbar = new Toolbar(this);
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.splitPane, "Center");
        this.statusBar = new StatusBar();
        this.add((Component)this.statusBar, "South");
    }

    public void refreshQuery() {
        if (this.q.canExecute()) {
            this.statusBar.startServerClock();
            this.statusBar.setStatus(I18n.getString("statusBar.execQuery"));
            this.errorOccured = false;
            this.statusBar.progressJob(new Runnable(){

                public void run() {
                    try {
                        Viewer.this.d = Viewer.this.smd.execute(Viewer.this.q.getQuery(), Viewer.this.execProperties);
                    }
                    catch (Exception e) {
                        Viewer.this.errorOccured = true;
                        Viewer.this.errorMessage = e.getMessage();
                        e.printStackTrace();
                        return;
                    }
                }
            }, StatusBar.JOB_TYPE_CRITICAL);
            this.statusBar.stopServerClock();
            if (!this.errorOccured) {
                this.statusBar.setStatus(I18n.getString("statusBar.resultDisplay"));
                this.statusBar.startClientClock();
                this.statusBar.progressJob(new Runnable(){

                    public void run() {
                        int chapterCount;
                        try {
                            Viewer.this.er = new ExecuteResult(Viewer.this.d, Viewer.this.q);
                        }
                        catch (ExecuteResultParseException e) {
                            Viewer.this.statusBar.setStatus(I18n.getString("statusBar.errorOccured"));
                            Viewer.this.errorOccured = true;
                            Viewer.this.errorMessage = e.getMessage();
                            e.printStackTrace();
                            return;
                        }
                        if (!Viewer.this.er.isValid()) {
                            if (Viewer.this.er.getAxis("Axis1").getTupleCount() == 0) {
                                Viewer.this.statusBar.setStatus(I18n.getString("statusBar.errAxis1"));
                                Viewer.this.q.clearRowAxis();
                            } else if (Viewer.this.er.getAxis("Axis0").getTupleCount() == 0) {
                                Viewer.this.statusBar.setStatus(I18n.getString("statusBar.errAxis0"));
                                Viewer.this.q.clearColumnAxis();
                            }
                            return;
                        }
                        Viewer.this.q.updateQueryWithResults(Viewer.this.er);
                        Viewer.this.rightPane.removeAll();
                        if (Viewer.this.er.getAxis("Axis2") != null) {
                            chapterCount = Viewer.this.er.getAxis("Axis2").getTupleCount();
                            Viewer.this.chapters.clear();
                            JTabbedPane jtp = new JTabbedPane(1);
                            for (int cc = 0; cc < chapterCount && cc < MAX_CHAPTER_COUNT; ++cc) {
                                CubeSlicer cs = new CubeSlicer(1, 0, new short[]{2}, new Tuple[]{Viewer.this.er.getAxis("Axis2").getTupleAt(cc)});
                                Viewer.this.cubeExplorer = new CubeExplorer2(Viewer.this.er, cs, Viewer.this.toolbar.isShowColumnTotalsOn(), Viewer.this.toolbar.isShowRowTotalsOn());
                                Viewer.this.cubeExplorer.setMaximumSize(new Dimension(Short.MAX_VALUE, Viewer.this.cubeExplorer.getPrefferedHeight()));
                                Page c = new Page(Viewer.this.dimTree.getTree(), Viewer.this.q, Viewer.this.cubeExplorer);
                                c.setMaximumSize(new Dimension(Short.MAX_VALUE, Page.getAdditionalHeight() + Viewer.this.cubeExplorer.getPrefferedHeight()));
                                Viewer.this.chapters.add(c);
                                if (Viewer.this.chartTabs != null && Viewer.this.chartTabs.size() > 0) {
                                    JTabbedPane chartTabbedPane = new JTabbedPane(4);
                                    chartTabbedPane.addTab(null, tableIcon, c);
                                    Iterator it = Viewer.this.chartTabs.iterator();
                                    while (it.hasNext()) {
                                        Integer type = (Integer)it.next();
                                        Chart pageChart = new Chart(Viewer.this.er, cs, type);
                                        chartTabbedPane.addTab(null, pageChart.getIcon(), pageChart);
                                    }
                                    jtp.addTab(Viewer.this.er.getAxis("Axis2").getTupleAt(cc).getShortCaption(), null, chartTabbedPane, Viewer.this.er.getAxis("Axis2").getTupleAt(cc).getToolTip());
                                    continue;
                                }
                                JPanel holder = new JPanel(){
                                    {
                                        this.setOpaque(false);
                                    }

                                    public void paintComponent(Graphics g) {
                                        S.paintBackground(g, this);
                                        super.paintComponent(g);
                                    }
                                };
                                holder.setLayout(new BoxLayout(holder, 1));
                                holder.add(c);
                                jtp.addTab(Viewer.this.er.getAxis("Axis2").getTupleAt(cc).getShortCaption(), null, holder, Viewer.this.er.getAxis("Axis2").getTupleAt(cc).getToolTip());
                            }
                            jtp.addMouseListener(new PageLabelPopUpListener(jtp));
                            Viewer.this.rightPane.add(jtp);
                        } else {
                            chapterCount = 1;
                            Viewer.this.chapters.clear();
                            CubeSlicer cs = new CubeSlicer(1, 0);
                            Viewer.this.cubeExplorer = new CubeExplorer2(Viewer.this.er, cs, Viewer.this.toolbar.isShowColumnTotalsOn(), Viewer.this.toolbar.isShowRowTotalsOn());
                            Viewer.this.cubeExplorer.setMaximumSize(new Dimension(Short.MAX_VALUE, Viewer.this.cubeExplorer.getPrefferedHeight()));
                            Page c = new Page(Viewer.this.dimTree.getTree(), Viewer.this.q, Viewer.this.cubeExplorer);
                            c.setMaximumSize(new Dimension(Short.MAX_VALUE, Page.getAdditionalHeight() + Viewer.this.cubeExplorer.getPrefferedHeight()));
                            c.setCurrent(true);
                            Viewer.this.chapters.add(c);
                            if (Viewer.this.chartTabs != null && Viewer.this.chartTabs.size() > 0) {
                                JTabbedPane chartTabbedPane = new JTabbedPane(4);
                                chartTabbedPane.addTab(null, tableIcon, c);
                                Iterator it = Viewer.this.chartTabs.iterator();
                                while (it.hasNext()) {
                                    Integer type = (Integer)it.next();
                                    Chart chart = new Chart(Viewer.this.er, cs, type);
                                    chartTabbedPane.addTab(null, chart.getIcon(), chart);
                                }
                                Viewer.this.rightPane.add(chartTabbedPane);
                            } else {
                                Viewer.this.rightPane.add(c);
                            }
                        }
                        Viewer.this.rightPane.repaint();
                        Viewer.this.rightPane.invalidate();
                        Viewer.this.rightPane.revalidate();
                        ListIterator it = Viewer.this.chapters.listIterator();
                        while (it.hasNext()) {
                            if (!((Page)it.next()).isCurrent()) continue;
                            ((Page)it.previous()).getCubeExplorer().setPrefferedDividerLocation();
                            break;
                        }
                        if (Viewer.this.toolbar.isShowMDXOn()) {
                            if (Viewer.this.mdxViewer != null) {
                                Viewer.this.mdxViewer.addQuery(Viewer.this.q.getLastQueryGenerated());
                            } else {
                                S.out("assert: trying to call getLastQueryGenerated() on a NULL object(mdxViewer)");
                            }
                        }
                    }
                }, StatusBar.JOB_TYPE_NORMAL);
            }
            if (!this.errorOccured) {
                this.statusBar.setDataCellsNumber(this.er.getAxis("Axis1").getTupleCount(), this.er.getAxis("Axis0").getTupleCount());
                this.statusBar.stopClientClock();
                this.statusBar.setStatus(I18n.getString("statusBar.ready"));
            } else {
                JOptionPane.showMessageDialog(null, I18n.getString("msgText.errQueryExec") + this.errorMessage, I18n.getString("msgTitle.execQuery"), 0);
                this.statusBar.setStatus(I18n.getString("statusBar.errorExec"));
            }
        } else {
            ((Page)this.chapters.getFirst()).refreshDisplay();
        }
    }

    public void enableTreeElements(QueryElement elementToEnable) {
        ((DimensionTreeModel)this.dimTree.getTree().getModel()).enableTreeElements(elementToEnable);
    }

    public FilterTreeModel addMemberToFilter(Member filterMember) {
        if (this.filterTrees == null) {
            this.filterTrees = new LinkedList();
        }
        LinkedList<Member> eml = new LinkedList<Member>();
        eml.add(filterMember);
        FilterTree filterTree = new FilterTree(this.smd, this.q, ((DimensionTreeModel)this.dimTree.getTree().getModel()).getDimensionTreeElement(filterMember.getDimensionUniqueName()), eml, this);
        this.filterTrees.add(filterTree);
        this.refreshLeftPane();
        return (FilterTreeModel)filterTree.getTree().getModel();
    }

    public void dropFilterTree(FilterTree filterToDrop) {
        ListIterator it = this.filterTrees.listIterator();
        while (it.hasNext()) {
            if ((FilterTree)it.next() != filterToDrop) continue;
            it.previous();
            it.remove();
            this.refreshLeftPane();
            return;
        }
        S.out("assert: Viewer:dropFilterTree:Couldn't find filter to drop!");
    }

    public void refreshFilterDisplay() {
        this.refreshLeftPane();
    }

    private void refreshLeftPane() {
        if (this.filterTrees != null && this.filterTrees.size() > 0) {
            this.leftPane.removeAll();
            if (!((FilterTree)this.filterTrees.getFirst()).isDisplayedInTab()) {
                JPanel filtersPane = new JPanel();
                filtersPane.setLayout(new BoxLayout(filtersPane, 1));
                Iterator it = this.filterTrees.iterator();
                while (it.hasNext()) {
                    filtersPane.add((JPanel)it.next());
                }
                JSplitPane dimFilterSplitPane = new JSplitPane(1, this.dimTree, new JScrollPane(filtersPane));
                dimFilterSplitPane.setContinuousLayout(false);
                dimFilterSplitPane.setOneTouchExpandable(true);
                dimFilterSplitPane.setDividerSize(8);
                dimFilterSplitPane.setDividerLocation((int)this.dimTree.getMinimumSize().getWidth());
                this.leftPane.add(dimFilterSplitPane);
                this.splitPane.setDividerLocation((int)this.dimTree.getMinimumSize().getWidth() + (int)filtersPane.getMinimumSize().getWidth());
            } else {
                JTabbedPane dimFilterTabbedPane = new JTabbedPane(2);
                dimFilterTabbedPane.addTab(null, DimensionElement.getDimensionIcon(), this.dimTree, "Dimension tree used for browsing and generating queries.");
                Iterator it = this.filterTrees.iterator();
                int i = 1;
                while (it.hasNext()) {
                    FilterTree ft = (FilterTree)it.next();
                    dimFilterTabbedPane.addTab(null, FilterTreeRootElement.getFilterIcon(), ft, ft.getCaption());
                    ++i;
                }
                this.leftPane.add(dimFilterTabbedPane);
            }
        } else {
            this.leftPane.removeAll();
            this.leftPane.add((Component)this.dimTree, "Center");
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    void makeMDXViewer() {
        if (this.mdxViewer == null) {
            this.mdxViewer = new MDXViewer();
            this.parentTabbedPane.addMDXViewer(this.mdxViewer, this.restrictions.getCubeName());
        }
    }

    void closeViewer() {
        if (0 == JOptionPane.showConfirmDialog(null, I18n.getString("msgText.closeTab"), I18n.getString("msgTitle.closeTab"), 0)) {
            this.removeMDXViewer();
            this.parentTabbedPane.closeViewer(this);
        }
    }

    void removeMDXViewer() {
        if (this.mdxViewer != null) {
            this.parentTabbedPane.removeMDXViewer(this.mdxViewer);
            this.mdxViewer = null;
        }
    }

    void setShowColumnTotalsOn(boolean _showColumnTotalsOn) {
        if (this.cubeExplorer != null) {
            this.cubeExplorer.setShowColumnTotalsOn(_showColumnTotalsOn);
        }
    }

    void setShowRowTotalsOn(boolean _showRowTotalsOn) {
        if (this.cubeExplorer != null) {
            this.cubeExplorer.setShowRowTotalsOn(_showRowTotalsOn);
        }
    }

    void newQuery() {
        if (this.filterTrees != null) {
            this.filterTrees = null;
            this.refreshFilterDisplay();
        }
        this.chartTabs = null;
        this.chapters = new LinkedList();
        this.q = new Query(this.restrictions.getCubeName(), this);
        ((DimensionTreeModel)this.dimTree.getTree().getModel()).enableAllTreeElements();
        this.dimTree.setQuery(this.q);
        Page c = new Page(this.dimTree.getTree(), this.q);
        c.setCurrent(true);
        this.chapters.add(c);
        this.rightPane.removeAll();
        this.rightPane.add(c);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void addChart() {
        int[] selectedCharts = null;
        if (this.chartTabs == null) {
            this.chartTabs = new LinkedList();
        } else {
            selectedCharts = new int[this.chartTabs.size()];
            Iterator it = this.chartTabs.iterator();
            int i = 0;
            while (it.hasNext()) {
                selectedCharts[i] = (Integer)it.next();
                ++i;
            }
            this.chartTabs.clear();
        }
        ChartPickerDialog chartPicker = new ChartPickerDialog((JFrame)this.getRootPane().getParent(), selectedCharts);
        chartPicker.pack();
        chartPicker.setVisible(true);
        Integer[] chartsToSpawn = chartPicker.getSelectedChartTypes();
        for (int i = 0; i < chartsToSpawn.length; ++i) {
            this.chartTabs.addLast(new Integer(chartsToSpawn[i]));
        }
        this.refreshQuery();
    }

    public static void main(String[] args) {
        ServerMetadata svm = new ServerMetadata("http://localhost:8080/xmla/msxisapi.dll");
        XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
        restrictions.setCatalog("Foodmart 2000");
        restrictions.setCubeName("Sales");
        properties.setDataSourceInfo("Local Analysis Server");
        properties.setCatalog("Sales");
        properties.setFormat("Tabular");
        properties.setContent("SchemaData");
        UIPropertyManager pm = new UIPropertyManager();
        pm.setSystemUI();
        Viewer v = new Viewer(restrictions, properties, svm);
        JFrame frame2 = new JFrame("Test viewer");
        frame2.getContentPane().add((Component)v, "Center");
        frame2.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame2.pack();
        frame2.setExtendedState(6);
        frame2.setVisible(true);
    }

    class PageLabelPopUpListener
    extends MouseAdapter
    implements ActionListener {
        JTabbedPane jtp;
        JPopupMenu popup;
        JMenuItem menuItem;
        int idx;

        PageLabelPopUpListener(JTabbedPane _jtp) {
            this.jtp = _jtp;
            this.popup = new JPopupMenu();
            this.menuItem = new JMenuItem((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.KEEP_THIS_MEMBER_ONLY));
            this.menuItem.addActionListener(this);
            this.popup.add(this.menuItem);
            this.menuItem = new JMenuItem((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_MEMBER_FROM_QUERY));
            this.menuItem.addActionListener(this);
            this.popup.add(this.menuItem);
            this.menuItem = new JMenuItem((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_DIMENSION_FROM_QUERY));
            this.menuItem.addActionListener(this);
            this.popup.add(this.menuItem);
            this.menuItem = new JMenuItem((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.SEND_MEMBER_TO_FILTER));
            this.menuItem.addActionListener(this);
            this.popup.add(this.menuItem);
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                S.out("idx=" + this.jtp.indexAtLocation(e.getX(), e.getY()));
                this.idx = this.jtp.indexAtLocation(e.getX(), e.getY());
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            if (e.isPopupTrigger()) {
                S.out("e.getX()=" + e.getX() + "e.getY()=" + e.getY() + "point = " + e.getPoint() + " E = " + e);
            }
        }

        public void actionPerformed(ActionEvent e) {
            boolean i = false;
            if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_DIMENSION_FROM_QUERY))) {
                Viewer.this.q.removePageDimensionFromQuery(Viewer.this.er.getAxis("Axis2").getTupleAt(this.idx).getMemberAt(0));
            } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_MEMBER_FROM_QUERY))) {
                Viewer.this.q.removePageMemberFromQuery(Viewer.this.er.getAxis("Axis2").getTupleAt(this.idx).getMemberAt(0));
            } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.KEEP_THIS_MEMBER_ONLY))) {
                Viewer.this.q.keepThisMemberOnlyOnPages(Viewer.this.er.getAxis("Axis2").getTupleAt(this.idx).getMemberAt(0));
            } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.SEND_MEMBER_TO_FILTER))) {
                Viewer.this.q.addPageMemberToFilter(Viewer.this.er.getAxis("Axis2").getTupleAt(this.idx).getMemberAt(0));
            }
        }
    }
}

