/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.nodes;

import java.awt.datatransfer.DataFlavor;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.mdxbuilder.dnd.TransferableMdxBuilderTreeNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTArgNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTCalculatedMemberNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTFunctionNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNamedSetNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTPopUpActions;
import rex.graphics.mdxeditor.mdxfunctions.MdxFunction;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MBTArgStringNode
extends DefaultMBTArgNode
implements LanguageChangedListener {
    protected String value;
    static ImageIcon icon = S.getAppIcon("MBTArgStringNode.gif");

    public MBTArgStringNode() {
        I18n.addOnLanguageChangedListener(this);
    }

    public MBTArgStringNode(String _argName) {
        super(false, _argName, false);
        I18n.addOnLanguageChangedListener(this);
    }

    public MBTArgStringNode(String _argName, boolean _respawnArg) {
        super(false, _argName, _respawnArg);
        I18n.addOnLanguageChangedListener(this);
    }

    public MBTArgStringNode(boolean _isHeadArg, String _argName) {
        super(_isHeadArg, _argName, false);
        I18n.addOnLanguageChangedListener(this);
    }

    public MBTArgStringNode(boolean _isHeadArg, String _argName, boolean _respawnArg, boolean _optionalArg) {
        super(_isHeadArg, _argName, _respawnArg, _optionalArg);
        I18n.addOnLanguageChangedListener(this);
    }

    @Override
    public String getMdx(String indent) {
        if (this.value != null) {
            return indent + this.value;
        }
        if (this.getChildren() == null) {
            return "";
        }
        return this.getChild(0).getMdx(indent);
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return super.toString();
        }
        if (this.isOptionalArg()) {
            return "<html><i>" + this.value + "</i></html>";
        }
        return this.value;
    }

    @Override
    void setAcceptableFlavorsArray() {
        this.acceptableFlavorsMimeTypes = new String[]{TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_LEVEL_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_DIMENSION_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_HIERARCHY_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_MEASURE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_MEMBER_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_SET_FUNCTION_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_NAMED_SET_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_CALCULATED_MEMBER_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_STRING_FUNCTION_NODE_FLAVOR_STRING};
    }

    @Override
    public ImageIcon getIcon() {
        return icon;
    }

    @Override
    public boolean acceptDrop(DataFlavor flavor) {
        return this.acceptDropOnlyOneChild(flavor);
    }

    @Override
    public void handleDrop(Object droppedData, DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel) {
        if (droppedData instanceof DimensionTreeElement) {
            this.value = ((DimensionTreeElement)droppedData).getUniqueName();
        } else if (droppedData instanceof MBTCalculatedMemberNode) {
            this.value = ((MBTCalculatedMemberNode)droppedData).getName();
        } else if (droppedData instanceof MBTNamedSetNode) {
            this.value = ((MBTNamedSetNode)droppedData).getName();
        } else if (droppedData instanceof MdxFunction) {
            this.value = null;
            this.addMdxFunctionChild((MdxFunction)droppedData, containerNode, treeModel);
        } else if (droppedData instanceof MBTFunctionNode) {
            this.moveMBTFunctionNode((MBTFunctionNode)droppedData, containerNode, treeModel);
        }
        this.maybeRespawnOnDrop(containerNode, treeModel);
    }

    void setValue(String formula) {
        if (formula != null) {
            this.value = formula;
        }
    }

    void setValue() {
        this.value = JOptionPane.showInputDialog(I18n.getString("msgText.stringExpr"), (Object)"");
    }

    void editValue() {
        String newValue = JOptionPane.showInputDialog(I18n.getString("msgText.stringExpr"), (Object)this.value);
        if (newValue != null && newValue.trim().length() > 0) {
            this.value = newValue;
        }
    }

    @Override
    public String[] getPopUpActionList() {
        if (this.getChildren() == null) {
            return new String[]{MBTPopUpActions.CLEAR_VALUE, MBTPopUpActions.INSERT_VALUE, MBTPopUpActions.EDIT};
        }
        return new String[]{MBTPopUpActions.DELETE_CHILDREN};
    }

    @Override
    public void handlePopUpAction(String action, DefaultMutableTreeNode actionNode, DefaultTreeModel treeModel) {
        if (action.equals(MBTPopUpActions.CLEAR_VALUE)) {
            this.value = null;
        } else if (action.equals(MBTPopUpActions.INSERT_VALUE)) {
            this.setValue();
            this.maybeRespawnOnDrop(actionNode, treeModel);
        } else if (action.equals(MBTPopUpActions.EDIT)) {
            this.editValue();
        } else if (action.equals(MBTPopUpActions.DELETE_CHILDREN)) {
            this.removeAllChildrenFromTheTree(actionNode, treeModel);
        }
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.INSERT_VALUE, I18n.getString("menu.insertValue"));
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.CLEAR_VALUE, I18n.getString("menu.clearValue"));
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.EDIT, I18n.getString("menu.editValue"));
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.DELETE_CHILDREN, I18n.getString("menu.deleteChildren"));
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }
}

