/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.functions.standard;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.jasperreports.functions.annotations.Function;
import net.sf.jasperreports.functions.annotations.FunctionCategories;
import net.sf.jasperreports.functions.annotations.FunctionParameter;
import net.sf.jasperreports.functions.annotations.FunctionParameters;
import net.sf.jasperreports.functions.standard.DateTimeCategory;
import net.sf.jasperreports.types.date.DateRange;
import net.sf.jasperreports.types.date.DateRangeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalTime;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@FunctionCategories(value={DateTimeCategory.class})
public final class DateTimeFunctions {
    private static final Log log = LogFactory.getLog(DateTimeFunctions.class);

    @Function(value="TODAY")
    public static Date TODAY() {
        return new Date();
    }

    @Function(value="NOW")
    public static Date NOW() {
        return new Date();
    }

    @Function(value="YEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public static Integer YEAR(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 1);
    }

    @Function(value="MONTH")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public static Integer MONTH(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 2) + 1;
    }

    @Function(value="DAY")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public static Integer DAY(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 5);
    }

    @Function(value="WEEKDAY")
    @FunctionParameters(value={@FunctionParameter(value="dateObject"), @FunctionParameter(value="isSundayFirstDay")})
    public static Integer WEEKDAY(Object dateObject) {
        return DateTimeFunctions.WEEKDAY(dateObject, false);
    }

    public static Integer WEEKDAY(Object dateObject, Boolean isSundayFirstDay) {
        Integer dayOfWeek = DateTimeFunctions.getCalendarFieldFromDate(dateObject, 7);
        if (dayOfWeek == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to get the correct day of the week.");
            }
            return null;
        }
        if (isSundayFirstDay.booleanValue()) {
            return dayOfWeek;
        }
        if (dayOfWeek == 1) {
            return 7;
        }
        return dayOfWeek - 1;
    }

    @Function(value="HOUR")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public static Integer HOUR(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 11);
    }

    @Function(value="MINUTE")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public static Integer MINUTE(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 12);
    }

    @Function(value="SECOND")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public static Integer SECOND(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 13);
    }

    @Function(value="DATE")
    @FunctionParameters(value={@FunctionParameter(value="year"), @FunctionParameter(value="month"), @FunctionParameter(value="dayOfMonth")})
    public static Date DATE(Integer year, Integer month, Integer dayOfMonth) {
        if (year == null || month == null || dayOfMonth == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"None of the arguments can be null.");
            }
            return null;
        }
        DateTime dt = new DateTime(year.intValue(), month.intValue(), dayOfMonth.intValue(), 0, 0, 0);
        return dt.toDate();
    }

    @Function(value="DATEVALUE")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public static Long DATEVALUE(Object dateObject) {
        Date convertedDate = DateTimeFunctions.convertDateObject(dateObject);
        if (convertedDate != null) {
            return convertedDate.getTime();
        }
        DateTimeFunctions.logCannotConvertToDate();
        return null;
    }

    @Function(value="TIME")
    @FunctionParameters(value={@FunctionParameter(value="hours"), @FunctionParameter(value="minutes"), @FunctionParameter(value="seconds"), @FunctionParameter(value="timePattern")})
    public static String TIME(Integer hours, Integer minutes, Integer seconds) {
        return DateTimeFunctions.TIME(hours, minutes, seconds, null);
    }

    public static String TIME(Integer hours, Integer minutes, Integer seconds, String timePattern) {
        if (hours == null || minutes == null || seconds == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"None of the arguments can be null.");
            }
            return null;
        }
        LocalTime lt = new LocalTime(hours.intValue(), minutes.intValue(), seconds.intValue());
        if (timePattern == null) {
            return lt.toString(DateTimeFormat.longTime());
        }
        try {
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)timePattern);
            return lt.toString(dtf);
        }
        catch (IllegalArgumentException ex) {
            return lt.toString(DateTimeFormat.longTime());
        }
    }

    @Function(value="EDATE")
    @FunctionParameters(value={@FunctionParameter(value="dateObject"), @FunctionParameter(value="months")})
    public static Date EDATE(Object dateObject, Integer months) {
        Date convertedDate = DateTimeFunctions.convertDateObject(dateObject);
        if (convertedDate == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)convertedDate);
        dt = dt.plusMonths(months.intValue());
        return dt.toDate();
    }

    @Function(value="WORKDAY")
    @FunctionParameters(value={@FunctionParameter(value="dateObject"), @FunctionParameter(value="workdays")})
    public static Date WORKDAY(Object dateObject, Integer workdays) {
        Date convertedDate = DateTimeFunctions.convertDateObject(dateObject);
        if (convertedDate == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime cursorDT = new DateTime((Object)convertedDate);
        int remainingDays = workdays;
        while (remainingDays > 0) {
            int dayOfWeek = cursorDT.getDayOfWeek();
            if (dayOfWeek != 6 && dayOfWeek != 7) {
                --remainingDays;
            }
            cursorDT = dayOfWeek == 5 ? cursorDT.plusDays(3) : cursorDT.plusDays(1);
        }
        return cursorDT.toDate();
    }

    @Function(value="NETWORKDAYS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public static Integer NETWORKDAYS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime cursorDateTime = new DateTime((Object)startDateObj);
        DateTime endDateTime = new DateTime((Object)endDateObj);
        int workingDays = 0;
        if (cursorDateTime.isAfter((ReadableInstant)endDateTime)) {
            DateTime tmp = cursorDateTime;
            cursorDateTime = endDateTime;
            endDateTime = tmp;
        }
        while (Days.daysBetween((ReadableInstant)cursorDateTime, (ReadableInstant)endDateTime).getDays() > 0) {
            int dayOfWeek = cursorDateTime.getDayOfWeek();
            if (dayOfWeek != 6 && dayOfWeek != 7) {
                ++workingDays;
            }
            cursorDateTime = cursorDateTime.plusDays(1);
        }
        return workingDays;
    }

    @Function(value="DAYS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public static Integer DAYS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt1 = new DateTime((Object)startDateObj);
        DateTime dt2 = new DateTime((Object)endDateObj);
        return Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
    }

    @Function(value="DAYSINMONTH")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public static Integer DAYSINMONTH(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.dayOfMonth().getMaximumValue();
    }

    @Function(value="DAYSINYEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public static Integer DAYSINYEAR(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.dayOfYear().getMaximumValue();
    }

    @Function(value="WEEKS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public static Integer WEEKS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt1 = new DateTime((Object)startDateObj);
        DateTime dt2 = new DateTime((Object)endDateObj);
        return Weeks.weeksBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getWeeks();
    }

    @Function(value="WEEKSINYEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public static Integer WEEKSINYEAR(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.weekOfWeekyear().getMaximumValue();
    }

    @Function(value="WEEKNUM")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public static Integer WEEKNUM(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.getWeekOfWeekyear();
    }

    @Function(value="MONTHS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public static Integer MONTHS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt1 = new DateTime((Object)startDateObj);
        DateTime dt2 = new DateTime((Object)endDateObj);
        return Months.monthsBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getMonths();
    }

    @Function(value="YEARS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public static Integer YEARS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt1 = new DateTime((Object)startDateObj);
        DateTime dt2 = new DateTime((Object)endDateObj);
        return Years.yearsBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getYears();
    }

    @Function(value="ISLEAPYEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public static Boolean ISLEAPYEAR(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.year().isLeap();
    }

    @Function(value="DATEFORMAT")
    @FunctionParameters(value={@FunctionParameter(value="dateObj"), @FunctionParameter(value="formatPattern")})
    public static String DATEFORMAT(Date dateObj, String formatPattern) {
        if (dateObj == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)formatPattern);
        DateTime dt = new DateTime((Object)dateObj);
        return dt.toString(formatter);
    }

    @Function(value="DATERANGE")
    @FunctionParameters(value={@FunctionParameter(value="dateExprObj")})
    public static DateRange DATERANGE(Object dateExprObj) {
        DateRangeBuilder dateRangeBuilder = null;
        if (dateExprObj instanceof String) {
            dateRangeBuilder = new DateRangeBuilder((String)dateExprObj);
        } else if (dateExprObj instanceof Date) {
            dateRangeBuilder = new DateRangeBuilder((Date)dateExprObj);
        } else {
            throw new IllegalArgumentException("The input parameter for DATERANGE function can be only a String or a Date object");
        }
        return dateRangeBuilder.toDateRange();
    }

    private static Date convertDateObject(Object dateObject) {
        if (dateObject == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The date object can not be null.");
            }
            return null;
        }
        if (dateObject instanceof String) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat();
            try {
                return simpleFormat.parse((String)dateObject);
            }
            catch (ParseException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to parse the string as Date using the standard SimpleDateFormat.");
                }
                return null;
            }
        }
        if (dateObject instanceof Long) {
            return new Date((Long)dateObject);
        }
        if (dateObject instanceof Date) {
            return (Date)dateObject;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"The specified object is not among the allowed types for Date conversion.");
        }
        return null;
    }

    private static Integer getCalendarFieldFromDate(Object dateObject, int field) {
        Date convertedDate = DateTimeFunctions.convertDateObject(dateObject);
        if (convertedDate == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(convertedDate);
        return cal.get(field);
    }

    private static void logCannotConvertToDate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unable to convert to a valid Date instance.");
        }
    }
}

