/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.CharConvBuilder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.util.CharConvBuilder.MappingSetter;
import oracle.sql.converter.CharacterConverter1Byte;
import oracle.sql.converter.CharacterConverters;

public class SingleByteMapSetterJDBC
extends MappingSetter {
    CharacterConverter1Byte m_charConv = null;

    SingleByteMapSetterJDBC(CharacterConverters characterConverters, CharacterConverter1Byte characterConverter1Byte, int n) throws IOException {
        super(n);
        this.m_charConv = characterConverter1Byte;
        this.m_charConv.m_ucsChar = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.m_charConv.m_ucsChar[i] = -1;
        }
        if (characterConverters != null) {
            Vector vector = new Vector(65535, 28671);
            characterConverters.extractCodepoints(vector);
            for (int i = 0; i < vector.size(); ++i) {
                int[] nArray = (int[])vector.elementAt(i);
                this.set(nArray[0], nArray[1]);
            }
        }
    }

    boolean set(int n, int n2) throws IOException {
        if (n >= 256) {
            this.printErrorMsg("***** Error: source code point " + SingleByteMapSetterJDBC.intToHex8(n) + " is too big for 1 byte converter");
        }
        this.m_charConv.m_ucsChar[n] = n2 = (int)SingleByteMapSetterJDBC.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL);
        return true;
    }

    void finish() {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        for (int i = 0; i <= 255; ++i) {
            int n = this.m_charConv.m_ucsChar[i];
            if (n == -1) continue;
            if (hashtable.get(new Integer(n)) == null) {
                hashtable.put(new Integer(n), new Integer(i));
                continue;
            }
            hashtable2.put(new Integer(n), hashtable.get(new Integer(n)));
        }
        this.setDuplicateMapping(hashtable2);
    }

    void setDuplicateMapping(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.m_charConv.extraUnicodeToOracleMapping = new int[hashtable.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.m_charConv.extraUnicodeToOracleMapping[n][0] = (Integer)k;
            this.m_charConv.extraUnicodeToOracleMapping[n++][1] = (Integer)hashtable.get(k);
        }
    }
}

