/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.CharConversionException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverter12Byte
extends CharacterConverterOGS {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int BYTEWIDTH = 8;
    static final int BELOW_CJK = 12287;
    static final short MAX_7BIT = 127;
    protected static int MAXLIMIT = 42000;
    public char[] m_ucsCharLevel1 = null;
    public int[] m_ucsCharLevel2 = null;
    public int m_ucsCharReplacement = 0;
    public int[] m_oraCharLevel1 = null;
    public int[] m_oraCharSurrogateLevel = null;
    public char[] m_oraCharLevel2 = null;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';

    public CharacterConverter12Byte() {
        this.m_groupId = 1;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 2.0f;
    }

    int toUnicode(int n) throws SQLException {
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        if (this.m_ucsCharLevel1[n2] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        int n4 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3];
        return n4;
    }

    int toUnicodeWithReplacement(int n) {
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        int n4 = this.m_ucsCharLevel1[n2] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] : this.m_ucsCharReplacement;
        return n4;
    }

    private int toUnicodeNoException(int n) {
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        if (this.m_ucsCharLevel1[n2] != '\uffff') {
            return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3];
        }
        return -1;
    }

    char toOracleCharacter(char c, char c2) throws SQLException {
        char c3 = '\uffff';
        if (c2 != '\u0000') {
            int n = c >>> 8 & 0xFF;
            int n2 = c & 0xFF;
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] != -1 && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4] != '\uffff') {
                c3 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4];
            }
        } else {
            int n = c >>> 8 & 0xFF;
            int n5 = c & 0xFF;
            if (this.m_oraCharLevel1[n] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n5] != '\uffff') {
                c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n5];
            }
        }
        if (c3 == '\uffff') {
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        return c3;
    }

    char toOracleCharacterWithReplacement(char c, char c2) {
        char c3 = '\uffff';
        if (c2 != '\u0000') {
            int n = c >>> 8 & 0xFF;
            int n2 = c & 0xFF;
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] != -1 && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4] != '\uffff') {
                c3 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4];
            }
        } else {
            int n = c >>> 8 & 0xFF;
            int n5 = c & 0xFF;
            if (this.m_oraCharLevel1[n] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n5] != '\uffff') {
                c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n5];
            }
        }
        if (c3 == '\uffff') {
            if (c > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return c3;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = n; i < n3; ++i) {
            int n4;
            int n5 = byArray[i] & 0xFF;
            if (n5 > 127) {
                if (i < n3 - 1) {
                    n5 = byArray[i] << 8 & 0xFF00 | byArray[i + 1] & 0xFF;
                    ++i;
                } else {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
            }
            if (((long)(n4 = this.toUnicode(n5)) & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n4 >>> 16));
                stringBuffer.append((char)(n4 & 0xFFFF));
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = n; i < n3; ++i) {
            int n4;
            int n5 = byArray[i] & 0xFF;
            if (n5 > 127) {
                if (n3 - i < 2) break;
                n5 = byArray[i] << 8 & 0xFF00 | byArray[i + 1] & 0xFF;
                ++i;
            }
            if (((long)(n4 = this.toUnicodeWithReplacement(n5)) & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n4 >>> 16));
                stringBuffer.append((char)(n4 & 0xFFFF));
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c;
            if (cArray[i] >= '\ud800' && cArray[i] < '\udc00') {
                if (i + 1 >= n || cArray[i + 1] < '\udc00' || cArray[i + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                c = this.toOracleCharacterWithReplacement(cArray[i], cArray[i + 1]);
                ++i;
            } else {
                c = this.toOracleCharacter(cArray[i], '\u0000');
            }
            if (c >> 8 != 0) {
                byArray[n2++] = (byte)(c >> 8);
                byArray[n2++] = (byte)c;
                continue;
            }
            byArray[n2++] = (byte)c;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 65535;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            block7: {
                if (cArray[i] >= '\ud800' && cArray[i] < '\udc00') {
                    if (i + 1 < n && cArray[i + 1] >= '\udc00' && cArray[i + 1] <= '\udfff') {
                        n2 = this.toOracleCharacterWithReplacement(cArray[i], cArray[i + 1]);
                        ++i;
                        break block7;
                    } else {
                        byArray[n3++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n3++] = (byte)this.m_2ByteOraCharReplacement;
                        continue;
                    }
                }
                n2 = this.toOracleCharacterWithReplacement(cArray[i], '\u0000');
            }
            if (n2 >> 8 != 0) {
                byArray[n3++] = (byte)(n2 >> 8);
                byArray[n3++] = (byte)n2;
                continue;
            }
            byArray[n3++] = (byte)n2;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    protected boolean isOraCharacterReplacement(char c, char c2) {
        char c3 = this.toOracleCharacterWithReplacement(c, c2);
        return c3 == this.getOraChar1ByteRep() || c3 == this.getOraChar2ByteRep();
    }

    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        char[] cArray;
        int n6;
        int n7;
        Object object;
        int n8;
        this.m_oraCharLevel1 = new int[256];
        this.m_oraCharSurrogateLevel = null;
        this.m_oraCharLevel2 = null;
        Vector<int[]> vector = new Vector<int[]>(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n9 = 0;
        int n10 = 0;
        for (n8 = 0; n8 < 256; ++n8) {
            this.m_oraCharLevel1[n8] = -1;
        }
        for (n8 = 0; n8 < 65535; ++n8) {
            int n11 = this.toUnicodeNoException(n8);
            if (n11 == -1) continue;
            object = new int[]{n11, n8};
            vector.addElement((int[])object);
            this.storeMappingRange(n11, hashtable, hashtable2);
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            for (n8 = 0; n8 < n7; ++n8) {
                n6 = this.extraUnicodeToOracleMapping[n8][0];
                this.storeMappingRange(n6, hashtable, hashtable2);
            }
        }
        Enumeration enumeration = hashtable.keys();
        int n12 = 0;
        int n13 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n12 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n13 += 256;
        }
        if (n12 != 0) {
            this.m_oraCharSurrogateLevel = new int[n12];
        }
        if (n13 != 0) {
            this.m_oraCharLevel2 = new char[n13];
        }
        for (n5 = 0; n5 < n12; ++n5) {
            this.m_oraCharSurrogateLevel[n5] = -1;
        }
        for (n5 = 0; n5 < n13; ++n5) {
            this.m_oraCharLevel2[n5] = 65535;
        }
        for (n5 = 0; n5 < vector.size(); ++n5) {
            int[] nArray = (int[])vector.elementAt(n5);
            n4 = nArray[0] >> 24 & 0xFF;
            n3 = nArray[0] >> 16 & 0xFF;
            n2 = nArray[0] >> 8 & 0xFF;
            n = nArray[0] & 0xFF;
            if (n4 >= 216 && n4 < 220) {
                if (this.m_oraCharLevel1[n4] == -1) {
                    this.m_oraCharLevel1[n4] = n10;
                    n10 += 256;
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] == -1) {
                    this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] = n10;
                    n10 += 256;
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] == -1) {
                    this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] = n9;
                    n9 += 256;
                }
                if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] + n] != '\uffff') continue;
                this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] + n] = (char)(nArray[1] & 0xFFFF);
                continue;
            }
            if (this.m_oraCharLevel1[n2] == -1) {
                this.m_oraCharLevel1[n2] = n9;
                n9 += 256;
            }
            if (this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n] != '\uffff') continue;
            this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n] = (char)(nArray[1] & 0xFFFF);
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            for (n5 = 0; n5 < n7; ++n5) {
                n6 = this.extraUnicodeToOracleMapping[n5][0];
                n4 = n6 >>> 24 & 0xFF;
                n3 = n6 >>> 16 & 0xFF;
                n2 = n6 >>> 8 & 0xFF;
                n = n6 & 0xFF;
                if (n4 >= 216 && n4 < 220) {
                    if (this.m_oraCharLevel1[n4] == -1) {
                        this.m_oraCharLevel1[n4] = n10;
                        n10 += 256;
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] == -1) {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] = n10;
                        n10 += 256;
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] == -1) {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] = n9;
                        n9 += 256;
                    }
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] + n] = (char)(this.extraUnicodeToOracleMapping[n5][1] & 0xFFFF);
                    continue;
                }
                if (this.m_oraCharLevel1[n2] == -1) {
                    this.m_oraCharLevel1[n2] = n9;
                    n9 += 256;
                }
                this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n] = (char)(this.extraUnicodeToOracleMapping[n5][1] & 0xFFFF);
            }
        }
    }

    public void extractCodepoints(Vector vector) {
        int n = 0;
        int n2 = 65535;
        for (int i = n; i <= n2; ++i) {
            try {
                int[] nArray = new int[]{i, this.toUnicode(i)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        for (int i = 0; i < this.extraUnicodeToOracleMapping.length; ++i) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[i][0], this.extraUnicodeToOracleMapping[i][1]};
            vector.addElement(nArray);
        }
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public int ByteToCharConvert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    public int CharToByteConvert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }
}

