/*
 * Decompiled with CFR 0.152.
 */
package de.oc.integration.jasper.webapp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;

public class ReportWrapper
extends HttpServlet {
    private static final long serialVersionUID = 3232059099842063441L;
    private OutputStream _out = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    Map filterInternalParameters(Map requestParams) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        Iterator iter = requestParams.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry n = iter.next();
            if (n.getKey().toString().startsWith("_")) continue;
            String key = n.getKey().toString();
            String[] values = (String[])n.getValue();
            reportParams.put(key, values[0].toString());
        }
        return reportParams;
    }

    String nvl(String p, String defaultValue) {
        if (p == null) {
            return defaultValue;
        }
        if (p.equals("")) {
            return defaultValue;
        }
        return p;
    }

    void showError(String msg) throws IOException {
        this._out.write("<h3>Error: ".getBytes());
        this._out.write(msg.getBytes());
        this._out.write("</h3>".getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JasperPrint jasperPrint = null;
        ServletOutputStream out = response.getOutputStream();
        Connection conn = null;
        JRPdfExporter exporter = null;
        this._out = out;
        response.setContentType("text/html");
        String repName = request.getParameter("_repName");
        String repFormat = request.getParameter("_repFormat");
        String dataSource = request.getParameter("_dataSource");
        String outFilename = request.getParameter("_outFilename");
        String repLocale = request.getParameter("_repLocale");
        String repEncoding = request.getParameter("_repEncoding");
        String contentType = "";
        dataSource = this.nvl(dataSource, "default");
        repName = this.nvl(repName, "test");
        repFormat = this.nvl(repFormat, "pdf");
        repLocale = this.nvl(repLocale, "de_DE");
        repEncoding = this.nvl(repEncoding, "UTF-8");
        outFilename = this.nvl(outFilename, null);
        if (!(repFormat.equals("pdf") || repFormat.equals("rtf") || repFormat.equals("html") || repFormat.equals("xls") || repFormat.equals("html") || repFormat.equals("docx") || repFormat.equals("html") || repFormat.equals("pptx") || repFormat.equals("jxl") || repFormat.equals("csv"))) {
            this.showError("Unknown _repFormat: " + repFormat);
            return;
        }
        String reportFileNameBase = this.getServletContext().getRealPath("/reports/" + repName);
        File jasperFile = new File(reportFileNameBase + ".jasper");
        if (!jasperFile.exists()) {
            this.showError("File " + reportFileNameBase + ".jasper not found.");
            return;
        }
        String reportsDir = jasperFile.getParentFile().getAbsolutePath();
        String baseDir = this.getServletContext().getRealPath("/reports");
        Map<String, String> reportParams = new HashMap();
        reportParams = this.filterInternalParameters(request.getParameterMap());
        reportParams.put("BaseDir", reportsDir);
        reportParams.put("SUBREPORT_DIR", reportsDir + File.separator);
        reportParams.put("REPORT_LOCALE", (String)((Object)new Locale(repLocale.substring(0, 2), repLocale.substring(3, 5))));
        if (repFormat.equals("pdf")) {
            contentType = "application/pdf";
            exporter = new JRPdfExporter();
        }
        if (repFormat.equals("docx")) {
            contentType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            exporter = new JRDocxExporter();
        }
        if (repFormat.equals("pptx")) {
            contentType = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            exporter = new JRPptxExporter();
        }
        if (repFormat.equals("rtf")) {
            contentType = "application/msword";
            exporter = new JRRtfExporter();
        }
        if (repFormat.equals("html")) {
            contentType = "text/html";
            exporter = new JRHtmlExporter();
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)(baseDir + File.separator + "tmp"));
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"/JasperReportsIntegration/reports/tmp/");
            reportParams.put("IS_IGNORE_PAGINATION", (String)((Object)Boolean.TRUE));
        }
        if (repFormat.equals("xls")) {
            contentType = "application/vnd.ms-excel";
            exporter = new JRXlsExporter();
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter(JRXlsExporterParameter.IGNORE_PAGE_MARGINS, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            reportParams.put("IS_IGNORE_PAGINATION", (String)((Object)Boolean.TRUE));
        }
        if (repFormat.equals("jxl")) {
            contentType = "application/vnd.ms-excel";
            exporter = new JExcelApiExporter();
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter(JRXlsExporterParameter.IGNORE_PAGE_MARGINS, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            reportParams.put("IS_IGNORE_PAGINATION", (String)((Object)Boolean.TRUE));
        }
        if (repFormat.equals("csv")) {
            contentType = "application/vnd.ms-excel";
            exporter = new JRCsvExporter();
            exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)"\t");
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter(JRXlsExporterParameter.IGNORE_PAGE_MARGINS, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            reportParams.put("IS_IGNORE_PAGINATION", (String)((Object)Boolean.TRUE));
        }
        response.setContentType(contentType + "; charset=" + repEncoding);
        response.setLocale(new Locale(repLocale));
        response.setHeader("content-type", contentType + "; charset=" + repEncoding);
        if (outFilename != null && !"".equals(outFilename)) {
            response.setHeader("Content-Disposition", "attachment; filename=" + outFilename);
        }
        try {
            InitialContext initContext = new InitialContext();
            DataSource ds = (DataSource)initContext.lookup("java:comp/env/jdbc/" + dataSource);
            conn = ds.getConnection();
            jasperPrint = JasperFillManager.fillReport((String)(reportFileNameBase + ".jasper"), reportParams, (Connection)conn);
            conn.close();
            ds = null;
            initContext.close();
        }
        catch (NamingException e) {
            this.showError("Datasource not found:" + dataSource);
            return;
        }
        catch (SQLException e) {
            this.showError(e.getMessage());
            return;
        }
        catch (JRException e) {
            this.showError(e.getMessage());
            return;
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace(new PrintWriter((OutputStream)out));
            }
        }
        try {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)repEncoding);
            exporter.exportReport();
        }
        catch (JRException e) {
            e.printStackTrace();
            throw new JRRuntimeException(e.getMessage());
        }
        out.close();
    }
}

