/*
 * Decompiled with CFR 0.152.
 */
package de.oc.integration.jasper.webapp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.w3c.dom.Document;

public class Apex
extends HttpServlet {
    private static final long serialVersionUID = 3232059099842053441L;
    HttpServletRequest _request = null;
    HttpServletResponse _response = null;
    private OutputStream _out = null;
    String _baseDir = null;
    String _reportsDir = null;
    String _xml = null;
    String _template = null;
    String _repName = null;
    String _repJRXMLFileName = null;
    File _repJRXMLFile = null;
    String _repFormat = null;
    String _xmlFileName = null;
    String _repEncoding = "UTF-8";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    String nvl(String p, String defaultValue) {
        if (p == null) {
            return defaultValue;
        }
        if (p.equals("")) {
            return defaultValue;
        }
        return p;
    }

    void saveToFile(String val, String filename) {
        if (val != null && filename != null) {
            try {
                File file = new File(filename);
                FileOutputStream fstream = new FileOutputStream(file);
                fstream.write(val.getBytes("UTF-8"));
                fstream.close();
            }
            catch (IOException e) {
                e.printStackTrace(new PrintWriter(this._out));
            }
        }
    }

    void getUrlParameters(HttpServletRequest request) {
        this._xml = request.getParameter("xml");
        this._template = request.getParameter("template");
        this._repFormat = this.nvl(request.getParameter("_xf"), "pdf");
        if (this._repFormat.equals("Excel")) {
            this._repFormat = "xls";
        }
    }

    void showError(String msg) throws IOException {
        this._out.write("<h3>Error: ".getBytes());
        this._out.write(msg.getBytes());
        this._out.write("</h3>".getBytes());
    }

    void generateReport() throws IOException, ServletException {
        JasperReport jasperReport = null;
        JasperPrint jasperPrint = null;
        JRPdfExporter exporter = null;
        String reportsDir = this._repJRXMLFile.getParentFile().getAbsolutePath();
        try {
            jasperReport = JasperCompileManager.compileReport((String)this._repJRXMLFileName);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("BaseDir", reportsDir);
        if (this._repFormat.equals("pdf")) {
            exporter = new JRPdfExporter();
        }
        if (this._repFormat.equals("rtf")) {
            exporter = new JRRtfExporter();
        }
        if (this._repFormat.equals("html")) {
            exporter = new JRHtmlExporter();
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)(this._baseDir + File.separator + "tmp"));
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"/JasperReportsIntegration/tmp/");
            reportParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        }
        if (this._repFormat.equals("xls")) {
            exporter = new JRXlsExporter();
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter(JRXlsExporterParameter.IGNORE_PAGE_MARGINS, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            reportParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        }
        try {
            ByteArrayInputStream str = new ByteArrayInputStream(this._xml.getBytes("UTF-8"));
            Document document = JRXmlUtils.parse((InputStream)str);
            reportParams.put("XML_DATA_DOCUMENT", document);
            reportParams.put("XML_DATE_PATTERN", "yyyy-MM-dd");
            reportParams.put("XML_NUMBER_PATTERN", "#,##0.##");
            reportParams.put("XML_LOCALE", Locale.ENGLISH);
            reportParams.put("REPORT_LOCALE", Locale.US);
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, reportParams);
        }
        catch (JRException e) {
            e.printStackTrace(new PrintWriter(this._out));
        }
        try {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)this._out);
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)this._repEncoding);
            exporter.exportReport();
        }
        catch (JRException e) {
            e.printStackTrace(new PrintWriter(this._out));
        }
    }

    void init(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        this._baseDir = this.getServletContext().getRealPath("/");
        this._reportsDir = this._baseDir + "/reports";
        this._request = request;
        this._response = response;
        this._out = out;
        this.getUrlParameters(request);
        this._repName = "template";
        this._xmlFileName = this._baseDir + "/reports/" + "xml.dat";
        this._repJRXMLFileName = this._baseDir + "/reports/tmp/" + this._repName + ".jrxml";
        this.saveToFile(this._xml, this._xmlFileName);
        this.saveToFile(this._template, this._repJRXMLFileName);
        this._repJRXMLFile = new File(this._xmlFileName);
    }

    void assertState() throws ServletException {
        if (this._xml == null) {
            throw new ServletException("xml feed is empty");
        }
        if (this._template == null) {
            throw new ServletException("template feed is empty");
        }
        if (!this._template.contains("<jasperReport")) {
            throw new ServletException("template feed is not valid for JasperReports");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        request.setCharacterEncoding("UTF-8");
        this.init(request, response);
        this.assertState();
        this.generateReport();
    }
}

