set define off
set verify off
set serveroutput on size 1000000
set feedback off
WHENEVER SQLERROR EXIT SQL.SQLCODE ROLLBACK
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 860 - Jasper Reports Integration Test
--
-- Application Export:
--   Application:     860
--   Name:            Jasper Reports Integration Test
--   Date and Time:   01:03 Donnerstag Januar 14, 2010
--   Exported By:     DIETMAR.AUST
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.1.2.00.02
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user FLOWS_030100 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                 4
--     Items:              16
--     Computations:        2
--     Validations:         0
--     Processes:           6
--     Regions:            16
--     Buttons:             1
--   Shared Components
--     Breadcrumbs:         1
--        Entries           3
--     Items:               1
--     Computations:        0
--     Processes:           2
--     Parent Tabs:         0
--     Tab Sets:            1
--        Tabs:             3
--     NavBars:             1
--     Lists:               0
--     Shortcuts:           0
--     Themes:              2
--     Templates:
--        Page:            22
--        List:            24
--        Report:          22
--        Label:           12
--        Region:          50
--     Messages:            0
--     Build Options:       1
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user FLOWS_030100 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>2113106081920973);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'de'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2007.01.08');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 860;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(860);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(860);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 860,
  p_display_id=> 860,
  p_owner => 'XLIB3',
  p_name  => 'Jasper Reports Integration Test',
  p_alias => 'F121',
  p_page_view_logging => 'YES',
  p_default_page_template=> 34037339482929843 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 34037225447929843 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 34039539107929871 + wwv_flow_api.g_id_offset,
  p_error_template    => 34037829195929848 + wwv_flow_api.g_id_offset,
  p_checksum_salt_last_reset => '20100114010350',
  p_home_link         => 'f?p=&APP_ID.:1:&SESSION.',
  p_flow_language     => 'de',
  p_flow_language_derived_from=> 'FLOW_PRIMARY_LANGUAGE',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => '',
  p_logout_url        => '',
  p_application_tab_set=> 1,
  p_public_url_prefix => '',
  p_public_user       => '',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(34044139611929965 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '0.8.0.0',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'Diese Anwendung ist aktuell nicht verfügbar.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_theme_id => 15,
  p_default_label_template => 34042926358929906 + wwv_flow_api.g_id_offset,
  p_default_report_template => 34041847879929884 + wwv_flow_api.g_id_offset,
  p_default_list_template => 34041325458929884 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 34043156317929917 + wwv_flow_api.g_id_offset,
  p_default_button_template => 34038127947929857 + wwv_flow_api.g_id_offset,
  p_default_chart_template => 34039626797929871 + wwv_flow_api.g_id_offset,
  p_default_form_template => 34040148901929871 + wwv_flow_api.g_id_offset,
  p_default_wizard_template => 34039228025929871 + wwv_flow_api.g_id_offset,
  p_default_tabform_template => 34039539107929871 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>34039539107929871 + wwv_flow_api.g_id_offset,
  p_default_menur_template => 34038947853929871 + wwv_flow_api.g_id_offset,
  p_default_listr_template => 34039539107929871 + wwv_flow_api.g_id_offset,
  p_last_updated_by => 'DIETMAR.AUST',
  p_last_upd_yyyymmddhh24miss=> '20100114010350',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 34044341396929965 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 200,
  p_icon_image     => '',
  p_icon_subtext   => 'Abmelden',
  p_icon_target    => '&LOGOUT_URL.',
  p_icon_image_alt => 'Abmelden',
  p_icon_height    => 32,
  p_icon_width     => 32,
  p_icon_height2   => 24,
  p_icon_width2    => 24,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => 'CURRENT_LOOK_IS_1',
  p_begins_on_new_line=> '',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
 
end;
/

prompt  ...application processes
--
--application/shared_components/logic/application_processes/prc_show_url
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  xlog(''prc_show_url'', ''url (orig):'' || :f_tmp_1);'||chr(10)||
''||chr(10)||
'  :f_tmp_1 := xlib_utl.unescape_url(:f_tmp_1, ''|'');'||chr(10)||
'  xlog(''prc_show_url'', ''url (unescape):'' || :f_tmp_1);'||chr(10)||
''||chr(10)||
'  xlib_http.display_url_raw(p_url => :f_tmp_1);'||chr(10)||
''||chr(10)||
'exception'||chr(10)||
'when others then '||chr(10)||
'  xlog(''prc_show_url'', sqlerrm, ''ERROR'');'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 9248609441248809 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'prc_show_url',
  p_process_sql_clob=> p,
  p_process_error_message=> '#SQLERRM#',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/prc_show_report
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
'   l_base_url   VARCHAR2 (2000)'||chr(10)||
'      :=    xlib_conf.get_value (''JASPER_INTEGRATION.REPORT_URL'')'||chr(10)||
'         || ''?_repName=demo~Departments'';'||chr(10)||
'BEGIN'||chr(10)||
'   xlib_http.display_url_raw (p_url      =>    l_base_url'||chr(10)||
'                                            || ''&p_deptno='''||chr(10)||
'                                            || v (''F_TMP_1'')'||chr(10)||
'                             );'||chr(10)||
'EXCEPTION'||chr(10)||
'   WHEN OTHERS'||chr(10)||
'   THEN'||chr(10)||
'  ';

p:=p||'    HTP.p (SQLERRM);'||chr(10)||
'END;';

wwv_flow_api.create_flow_process(
  p_id => 34053135254782409 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'prc_show_report',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

prompt  ...application items
--
--application/shared_components/logic/application_items/f_tmp_1
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 34054144735794660 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F_TMP_1',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/standard/t_home
wwv_flow_api.create_tab (
  p_id=> 34045729509930082 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 10,
  p_tab_name=> 'T_HOME',
  p_tab_text => 'Home',
  p_tab_step => 1,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_installation
wwv_flow_api.create_tab (
  p_id=> 3794929184450662 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 20,
  p_tab_name=> 'T_INSTALLATION',
  p_tab_text => 'Installation',
  p_tab_step => 4,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment  => '');
 
--application/shared_components/navigation/tabs/standard/t_usage
wwv_flow_api.create_tab (
  p_id=> 3797403658455831 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 50,
  p_tab_name=> 'T_USAGE',
  p_tab_text => 'Report Tester',
  p_tab_step => 5,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment  => '');
 
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

--application/comments
prompt  ...comments: requires application express 2.2 or higher
--
 
--application/pages/page_00001
prompt  ...PAGE 1: Home
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'Für diese Seite ist keine Hilfe verfügbar.';

ph:=ph||'<script>'||chr(10)||
'function myEscape(pStr){'||chr(10)||
'alert(escape(pStr));'||chr(10)||
'return escape(pStr);'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function showUrl(pUrl){'||chr(10)||
'var win = window.open( ''http://daust3.opal-consulting.de:7777/pls/apex/f?p=&APP_ID.:0:&APP_SESSION.:APPLICATION_PROCESS=prc_show_url:::F_TMP_1:''  + myEscape(pUrl));'||chr(10)||
'}'||chr(10)||
'</script>'||chr(10)||
''||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_page(
  p_id     => 1,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_name   => 'Home',
  p_step_title=> 'Home',
  p_step_sub_title => 'Home',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_welcome_text=> '<style>'||chr(10)||
'.t15ReportsRegion{width: 500px;}'||chr(10)||
'</style>',
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => 'DIETMAR.AUST',
  p_last_upd_yyyymmddhh24miss => '20100106185949',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||''||chr(10)||
'<p>This is the test application for the <a href="http://www.opal-consulting.de/apex/f?p=20090928:4" target="_blank">Jasper Reports Integration</a> kit provided by <a href="http://www.opal-consulting.de/" target="_blank">Opal-Consulting</a>. </p>'||chr(10)||
'<p>It will help you with the installation, troubleshooting and serves as a report tester.</p>'||chr(10)||
'<p>Using these functionalities you can can integrate your u';

s:=s||'ser defined reports (using iReport Designer to create an JasperReports .jasper file) in an APEX application. </p>'||chr(10)||
'<p>Regarding the Jasper Reports Integration you can reach me at <a href="mailto:freetools@opal-consulting.de?subject=Jasper Reports Integration">freetools@opal-consulting.de</a></p>'||chr(10)||
'<p>Have fun, <br />'||chr(10)||
'~Dietmar. </p>'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 9258906857361681 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1,
  p_plug_name=> 'Jasper Reports Integration',
  p_region_name=>'',
  p_plug_template=> 34039539107929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 21,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign=top',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 34045951718930106 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1,
  p_plug_name=> 'Navigationspfade',
  p_region_name=>'',
  p_plug_template=> 34038947853929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(34045446868930053 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 34043156317929917+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> 'Anzeigen von Navigationspfad nicht möglich.',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00004
prompt  ...PAGE 4: INSTALLATION
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 4,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_name   => 'INSTALLATION',
  p_step_title=> 'Installation',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_welcome_text=> '<style>'||chr(10)||
'.t15ReportsRegion{width: 500px;}'||chr(10)||
'</style>',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => 'DIETMAR.AUST',
  p_last_upd_yyyymmddhh24miss => '20100113234659',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3795126743450662 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Installation',
  p_region_name=>'',
  p_plug_template=> 34038947853929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(34045446868930053 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 34043156317929917+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT   *'||chr(10)||
'    FROM (SELECT 1 step, ''Step 1: Grant execute on utl_http'' step_name,'||chr(10)||
'                 status, ''*'' required'||chr(10)||
'            FROM (SELECT DECODE (installed,'||chr(10)||
'                                 1, ''/i/Fndokay1.gif'','||chr(10)||
'                                 ''/i/FNDCANCE.gif'''||chr(10)||
'                                ) status'||chr(10)||
'                    FROM (SELECT SUM (CASE'||chr(10)||
'                                         WHEN';

s:=s||' owner = ''SYS'''||chr(10)||
'                                         AND grantee = ''#OWNER#'''||chr(10)||
'                                         AND table_name = ''UTL_HTTP'''||chr(10)||
'                                         AND PRIVILEGE = ''EXECUTE'''||chr(10)||
'                                            THEN 1'||chr(10)||
'                                         ELSE 0'||chr(10)||
'                                      END'||chr(10)||
'                                     ) inst';

s:=s||'alled'||chr(10)||
'                            FROM user_tab_privs))'||chr(10)||
'          UNION'||chr(10)||
'          SELECT 2 step, ''Step 2: Install XLIB packages'' step_name, status,'||chr(10)||
'                 ''*'' required'||chr(10)||
'            FROM (SELECT DECODE (installed,'||chr(10)||
'                                 2, ''/i/Fndokay1.gif'','||chr(10)||
'                                 ''/i/FNDCANCE.gif'''||chr(10)||
'                                ) status'||chr(10)||
'                    FROM (SELEC';

s:=s||'T SUM'||chr(10)||
'                                    (CASE'||chr(10)||
'                                        WHEN comp_name IN'||chr(10)||
'                                                   (''XLIB_BASE'', ''XLIB_HTTP'')'||chr(10)||
'                                           THEN 1'||chr(10)||
'                                        ELSE 0'||chr(10)||
'                                     END'||chr(10)||
'                                    ) installed'||chr(10)||
'                            FR';

s:=s||'OM xlib_components))'||chr(10)||
'          UNION'||chr(10)||
'          SELECT 3 step, ''Step 3: Install Tomcat'' step_name, status,'||chr(10)||
'                 ''*'' required'||chr(10)||
'            FROM (SELECT DECODE (installed,'||chr(10)||
'                                 1, ''/i/Fndokay1.gif'','||chr(10)||
'                                 ''/i/FNDCANCE.gif'''||chr(10)||
'                                ) status'||chr(10)||
'                    FROM (SELECT xlib_http.check_get_request'||chr(10)||
'            ';

s:=s||'                                     (:p4_tomcat_url || '''''||chr(10)||
'                                                 ) installed'||chr(10)||
'                            FROM DUAL))'||chr(10)||
'          UNION'||chr(10)||
'          SELECT 4 step, ''Step 4: Install JasperReportsIntegration'' step_name,'||chr(10)||
'                 status, ''*'' required'||chr(10)||
'            FROM (SELECT DECODE (installed,'||chr(10)||
'                                 1, ''/i/Fndokay1.gif'','||chr(10)||
'        ';

s:=s||'                         ''/i/FNDCANCE.gif'''||chr(10)||
'                                ) status'||chr(10)||
'                    FROM (SELECT xlib_http.check_get_request'||chr(10)||
'                                       (   :p4_tomcat_url'||chr(10)||
'                                        || ''/JasperReportsIntegration'''||chr(10)||
'                                       ) installed'||chr(10)||
'                            FROM DUAL))'||chr(10)||
'          UNION'||chr(10)||
'          SELECT 6 ';

s:=s||'step, ''Step 6: Install sample application'' step_name,'||chr(10)||
'                 status, ''&nbsp;'' required'||chr(10)||
'            FROM (SELECT DECODE (installed,'||chr(10)||
'                                 2, ''/i/Fndokay1.gif'','||chr(10)||
'                                 ''/i/FNDCANCE.gif'''||chr(10)||
'                                ) status'||chr(10)||
'                    FROM (SELECT SUM'||chr(10)||
'                                    (CASE'||chr(10)||
'                                 ';

s:=s||'       WHEN object_name IN'||chr(10)||
'                                               (''DEMO_ORDERS'','||chr(10)||
'                                                ''DEMO_CUSTOMERS'')'||chr(10)||
'                                           THEN 1'||chr(10)||
'                                        ELSE 0'||chr(10)||
'                                     END'||chr(10)||
'                                    ) installed'||chr(10)||
'                            FROM user_objects))'||chr(10)||
'          ';

s:=s||')'||chr(10)||
'ORDER BY step';

wwv_flow_api.create_report_region (
  p_id=> 3817525552909128 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_name=> 'Installation status',
  p_region_name=>'',
  p_template=> 34038855332929870+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 41,
  p_display_column=> 2,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_customized=> '0',
  p_translate_title=> 'Y',
  p_query_row_template=> 34041847879929884+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_csv_output=> 'N',
  p_sort_null=> 'F',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
 
-- maintain plug_column_width attribute for 2.2 and greater
begin
execute immediate 'begin wwv_flow_api.set_region_column_width (
  p_id=>3817525552909128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_page_id=>4,
  p_plug_column_width=>''valign=top''); end;';
exception when others then null;
end;
/
 
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3817818118909131 + wwv_flow_api.g_id_offset,
  p_region_id=> 3817525552909128 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'STEP',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Step id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3817906069909132 + wwv_flow_api.g_id_offset,
  p_region_id=> 3817525552909128 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'STEP_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Step',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3818012010909132 + wwv_flow_api.g_id_offset,
  p_region_id=> 3817525552909128 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Status',
  p_column_html_expression=>'<img src="#STATUS#" />',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3824723577040989 + wwv_flow_api.g_id_offset,
  p_region_id=> 3817525552909128 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'REQUIRED',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Required',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>The supporting objects need to be installed in your application schema (#OWNER#). </p>'||chr(10)||
'<div class="space"></div>';

wwv_flow_api.create_page_plug (
  p_id=> 3822508414942009 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Step 2: Install XLIB packages',
  p_region_name=>'',
  p_plug_template=> 34039539107929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 21,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>In order to call the JasperReportsIntegration from the database, you need execute privileges on sys.utl_http. </p>'||chr(10)||
'<div class="space"></div>';

wwv_flow_api.create_page_plug (
  p_id=> 3826707216055201 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Step 1: Grant execute on utl_http',
  p_region_name=>'',
  p_plug_template=> 34039539107929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 11,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign=top',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<div class="space"></div>';

wwv_flow_api.create_page_plug (
  p_id=> 3832313768180089 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Step 3: Install Tomcat - configure URL',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 61,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p><a href="http://tomcat.apache.org/" target="_blank">Download Apache Tomcat</a>, install and start it. Enter the target Tomcat URL here:</p>'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 3838906532480776 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Step 3: Install Tomcat',
  p_region_name=>'',
  p_plug_template=> 34039539107929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 51,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>The Oracle libraries need to be installed in the Tomcat and the J2EE application JasperReportsIntegration.war needs to be installed.</p>'||chr(10)||
'<div class="space"></div>';

wwv_flow_api.create_page_plug (
  p_id=> 3846824858609142 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Step 4: Install JasperReportsIntegration',
  p_region_name=>'',
  p_plug_template=> 34039539107929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 71,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||''||chr(10)||
'<p>Edit the file <span class="code">%TOMCAT_HOME%\conf\Catalina\localhost\JasperReportsIntegration.xml</span> and configure the data source, especially the default data source. This will be used for testing.</p>'||chr(10)||
'<p><strong>This test is not functional yet. </strong></p>'||chr(10)||
'<div class="space"></div>'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 3848018756616843 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Step 5: Configure default data source',
  p_region_name=>'',
  p_plug_template=> 34039539107929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 81,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Install the APEX demo application in your workspace (create &gt; demo application &gt; sample application).</p>'||chr(10)||
'<p>This is not a required step for the base functionality but you need it to run some of the demos. </p>'||chr(10)||
'<div class="space"></div>'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 3854830193695798 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'Step 6: Install sample application',
  p_region_name=>'',
  p_plug_template=> 34039539107929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 91,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<div class="space"></div>';

wwv_flow_api.create_page_plug (
  p_id=> 3862029463742915 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4,
  p_plug_name=> 'end of story',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 121,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3867929987780920 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4,
  p_button_sequence=> 30,
  p_button_plug_id => 3817525552909128+wwv_flow_api.g_id_offset,
  p_button_name    => 'BTN_REFRESH',
  p_button_image_alt=> 'Refresh',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'LEFT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3868205768780920 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_branch_action=> 'f?p=&FLOW_ID.:4:&SESSION.::&DEBUG.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3867929987780920+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>3843323613575082 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_branch_action=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3837128434468195 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_TOMCAT_URL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3832313768180089+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tomcat URL',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3843105419575081 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_name=>'P4_BTN_SET_TOMCAT_URL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 3832313768180089+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'P4_BTN_SET_TOMCAT_URL',
  p_prompt=>'set url',
  p_source=>'P4_BTN_SET_TOMCAT_URL',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 7609204711957337 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4,
  p_computation_sequence => 10,
  p_computation_item=> 'P4_TOMCAT_URL',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '''http://localhost:8080''',
  p_compute_when => 'P4_TOMCAT_URL',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 4
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00005
prompt  ...PAGE 5: USAGE
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph:=ph||'<script>'||chr(10)||
''||chr(10)||
'function setValue(pItemName, pValue){'||chr(10)||
'  $x(pItemName).value = pValue;'||chr(10)||
'  xlibJasperDemo_makeDemoUrl();'||chr(10)||
''||chr(10)||
'  return false;'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function xlibJasperDemo_generateUrl(pBaseUrl, pRepName, pRepFormat, pDataSource, pOutFilename, pRepLocale, pRepEncoding, pAdditionalParams){'||chr(10)||
'  var url;'||chr(10)||
''||chr(10)||
'  url = pBaseUrl;'||chr(10)||
'  url = url + "?_repName=" + pRepName;'||chr(10)||
'  url = url + "&_repFormat=" + pRepFormat;'||chr(10)||
'  url = url + "';

ph:=ph||'&_dataSource=" + pDataSource;'||chr(10)||
'  url = url + "&_outFilename=" + pOutFilename;'||chr(10)||
'  url = url + "&_repLocale=" + pRepLocale;'||chr(10)||
'  url = url + "&_repEncoding=" + pRepEncoding;'||chr(10)||
'  if (pAdditionalParams)  url = url + "&" + pAdditionalParams;'||chr(10)||
''||chr(10)||
'  return url;'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function xlibJasperDemo_makeDemoUrl(){ '||chr(10)||
'  $x(''P5_REPORT_URL'').value=xlibJasperDemo_generateUrl($x(''P5_JASPER_REPORT_URL'').value, $x(''P5_REP_NAME'').value';

ph:=ph||', $x(''P5_REP_FORMAT'').value, $x(''P5_DATA_SOURCE'').value, $x(''P5_OUT_FILENAME'').value, $x(''P5_REP_LOCALE'').value, $x(''P5_REP_ENCODING'').value, $x(''P5_ADDITIONAL_PARAMS'').value );'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function xlibShowUrl(pUrl){'||chr(10)||
'  window.open(pUrl);'||chr(10)||
'  '||chr(10)||
'  return false; '||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function xlibShowUrlTunnel(pUrl){'||chr(10)||
'  var newUrl;'||chr(10)||
''||chr(10)||
'  alert(pUrl);'||chr(10)||
'   // !!! use encodeURIComponent, not escape !!!'||chr(10)||
'  newUrl = encodeURIComponent(pUrl';

ph:=ph||'.replace(/:/gi,''|''));'||chr(10)||
'  alert(newUrl);'||chr(10)||
'  newUrl = ''f?p=&APP_ID.:0:&APP_SESSION.:APPLICATION_PROCESS=prc_show_url:::F_TMP_1:'' + newUrl;'||chr(10)||
''||chr(10)||
'  alert(newUrl);'||chr(10)||
'  window.open(newUrl);'||chr(10)||
'  '||chr(10)||
'  return false; '||chr(10)||
'}'||chr(10)||
''||chr(10)||
''||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 5,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_name   => 'USAGE',
  p_step_title=> 'Usage',
  p_html_page_onload=>'onLoad="xlibJasperDemo_makeDemoUrl();"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_welcome_text=> '<style type="text/css">'||chr(10)||
'<!--'||chr(10)||
'.myTable {'||chr(10)||
'	margin: 0px;'||chr(10)||
'	/*border: thin solid #000000;*/'||chr(10)||
'	border-collapse:collapse;'||chr(10)||
'}'||chr(10)||
'.myTable td, .myTable th{ '||chr(10)||
'    border: 1px solid black;'||chr(10)||
'	padding: 2px;'||chr(10)||
'}'||chr(10)||
'.myTable th{ '||chr(10)||
'    background-color:#CCCCCC;'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'-->'||chr(10)||
'</style>',
  p_help_text => '',
  p_html_page_header => ' ',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => 'DIETMAR.AUST',
  p_last_upd_yyyymmddhh24miss => '20100114010329',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>5,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3797603892455831 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_plug_name=> 'Usage',
  p_region_name=>'',
  p_plug_template=> 34038947853929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(34045446868930053 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 34043156317929917+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3912224614441745 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_plug_name=> 'Report tester',
  p_region_name=>'',
  p_plug_template=> 34039539107929871+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 21,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<div style="height:30px;"> </div>';

wwv_flow_api.create_page_plug (
  p_id=> 3965216853754748 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5,
  p_plug_name=> 'end of story',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 31,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3961422853264432 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_branch_action=> 'f?p=&APP_ID.:5:&SESSION.:REQ_SHOW_REPORT_TUNNEL:&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'REQ_SHOW_REPORT_TUNNEL',
  p_branch_comment=> 'Created 07-AUG-2008 16:32 by ADMIN');
 
wwv_flow_api.create_page_branch(
  p_id=>7634713909539653 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_branch_action=> 'f?p=&APP_ID.:5:&SESSION.:REQ_GET_REPORT_TUNNEL:&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 20,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'REQ_GET_REPORT_TUNNEL',
  p_branch_comment=> 'Created 07-AUG-2008 16:32 by ADMIN');
 
wwv_flow_api.create_page_branch(
  p_id=>3958406661240828 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_branch_action=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 999,
  p_branch_comment=> 'Created 07-AUG-2008 16:28 by ADMIN');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3913509854446953 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_REP_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'test',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'_repName',
  p_post_element_text=>'&nbsp;&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''test'');">[test]</a>&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''demo/orders'');">[demo/orders]</a>&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''demo/top_orders'');">[demo/top_orders]</a>',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onChange="xlibJasperDemo_makeDemoUrl();"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3914119550449751 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_REP_FORMAT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 4,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'PDF',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'_repFormat',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:pdf;pdf,rtf;rtf,xls;xls,html;html,csv;csv',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onChange="xlibJasperDemo_makeDemoUrl();"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3915317604458584 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_DATA_SOURCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'default',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'_dataSource',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onChange="xlibJasperDemo_makeDemoUrl();"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3916809077465646 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_OUT_FILENAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 6,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'_outFilename',
  p_post_element_text=>'&nbsp;&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''myTest.pdf'');">[myTest.pdf]</a>&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''myTest.rtf'');">[myTest.rtf]</a>       ',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onChange="xlibJasperDemo_makeDemoUrl();"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3917620159468853 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_REP_LOCALE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 7,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'de_DE',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'_repLocale',
  p_post_element_text=>'&nbsp;&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''de_DE'');">[de_DE]</a>&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''en_US'');">[en_US]</a>',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onChange="xlibJasperDemo_makeDemoUrl();"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3922008824522298 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_REP_ENCODING',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 8,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'UTF-8',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'_repEncoding',
  p_post_element_text=>'&nbsp;&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''ISO-8859-1'');">[ISO-8859-1]</a>&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''ISO-8859-15'');">[ISO-8859-15]</a>&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''UTF-8'');">[UTF-8]</a>&nbsp;<a href="" onClick="return setValue(''#CURRENT_ITEM_NAME#'', ''Windows-1252'');">[Windows-1252]</a>',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onChange="xlibJasperDemo_makeDemoUrl();"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3925622031554521 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_REPORT_URL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Report URL',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3927313251618218 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_ADDITIONAL_PARAMS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 9,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'additional url parameters',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 80,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onChange="xlibJasperDemo_makeDemoUrl();"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3936130491717803 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_JASPER_REPORT_URL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'JasperReportIntegration URL',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3944311023806820 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_BTNS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 11,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'<input type="button" value="Show report (directly)" onClick="return xlibShowUrl($x(''P5_REPORT_URL'').value);" />'||chr(10)||
'&nbsp;&nbsp;<input type="button" value="Show report (through tunnel)" onClick="doSubmit(''REQ_SHOW_REPORT_TUNNEL'');" />'||chr(10)||
'&nbsp;&nbsp;<input type="button" value="Get report as BLOB, then display" onClick="doSubmit(''REQ_GET_REPORT_TUNNEL'');" />',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042554730929893+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7626811487148528 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_name=>'P5_BTN_SET_TOMCAT_URL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 3912224614441745+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'P4_BTN_SET_TOMCAT_URL',
  p_prompt=>'set url',
  p_source=>'P5_BTN_SET_TOMCAT_URL',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'NO',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 7625831826097618 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5,
  p_computation_sequence => 20,
  p_computation_item=> 'P5_JASPER_REPORT_URL',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'http://localhost:8080/JasperReportsIntegration/report',
  p_compute_when => 'P5_JASPER_REPORT_URL',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  xlog(''PRC_SHOW_REPORT_TUNNEL'', ''url (orig):'' || :p5_report_url);'||chr(10)||
''||chr(10)||
'  xlib_jasperreports.set_report_url(:P5_JASPER_REPORT_URL);'||chr(10)||
'  xlib_jasperreports.show_report (p_rep_name                   => :p5_rep_name,'||chr(10)||
'                                   p_rep_format                 => :p5_rep_format,'||chr(10)||
'                                   p_data_source                => :p5_data_source,'||chr(10)||
'                   ';

p:=p||'                p_out_filename               => :p5_out_filename,'||chr(10)||
'                                   p_rep_locale                 => :p5_rep_locale,'||chr(10)||
'                                   p_rep_encoding               => :p5_rep_encoding,'||chr(10)||
'                                   p_additional_params          => :p5_additional_params'||chr(10)||
'                                  );'||chr(10)||
''||chr(10)||
''||chr(10)||
'  apex_application.g_unrecoverable_err';

p:=p||'or := true;'||chr(10)||
''||chr(10)||
'exception'||chr(10)||
'  when others then '||chr(10)||
'    xlog(''PRC_SHOW_REPORT_TUNNEL'', sqlerrm, ''ERROR'');'||chr(10)||
'    raise;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3959605061249815 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'PRC_SHOW_REPORT_TUNNEL',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'REQ_SHOW_REPORT_TUNNEL',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
'   l_blob        BLOB;'||chr(10)||
'   l_mime_type   VARCHAR2 (100);'||chr(10)||
'BEGIN'||chr(10)||
'   xlog (''PRC_GET_REPORT_TUNNEL'', ''url (orig):'' || :p5_report_url);'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   -- generate the report and return in BLOB'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   xlib_jasperreports.set_report_url (:p5_jasper_report_url);'||chr(10)||
'   ';

p:=p||'xlib_jasperreports.get_report'||chr(10)||
'                                (p_rep_name               => :p5_rep_name,'||chr(10)||
'                                 p_rep_format             => :p5_rep_format,'||chr(10)||
'                                 p_data_source            => :p5_data_source,'||chr(10)||
'                                 p_rep_locale             => :p5_rep_locale,'||chr(10)||
'                                 p_rep_encoding           => :p';

p:=p||'5_rep_encoding,'||chr(10)||
'                                 p_additional_params      => :p5_additional_params,'||chr(10)||
'                                 p_out_blob               => l_blob,'||chr(10)||
'                                 p_out_mime_type          => l_mime_type'||chr(10)||
'                                );'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   -- set mime header'||chr(10)||
'   ----------------------';

p:=p||'--------------------------------------------------'||chr(10)||
'   OWA_UTIL.mime_header (ccontent_type      => l_mime_type,'||chr(10)||
'                         bclose_header      => FALSE);'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   -- set content length'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   HTP.p (''Content-length: '' || DBMS_LOB.getlength (l_blo';

p:=p||'b));'||chr(10)||
'   OWA_UTIL.http_header_close;'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   -- download the file and display in browser'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   WPG_DOCLOAD.download_file (l_blob);'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   -- release resources'||chr(10)||
'   -----------------------';

p:=p||'-------------------------------------------------'||chr(10)||
'   DBMS_LOB.freetemporary (l_blob);'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   -- stop rendering of APEX page'||chr(10)||
'   ------------------------------------------------------------------------'||chr(10)||
'   apex_application.g_unrecoverable_error := TRUE;'||chr(10)||
'EXCEPTION'||chr(10)||
'   WHEN OTHERS'||chr(10)||
'   THEN'||chr(10)||
'      xlog (''PRC_GET_REPORT_TUNNEL'', SQLERRM';

p:=p||', ''ERROR'');'||chr(10)||
'      RAISE;'||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 7633532207440846 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'PRC_GET_REPORT_TUNNEL',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'REQ_GET_REPORT_TUNNEL',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 5
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_00101
prompt  ...PAGE 101: Anmelden
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 101,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Anmelden',
  p_alias  => 'LOGIN',
  p_step_title=> 'Anmelden',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 34037829195929848+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20080129193105',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 34044649086929992 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 101,
  p_plug_name=> 'Anmelden',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>34044749780930021 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_USERNAME',
  p_data_type=> '',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 34044649086929992+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> '',
  p_prompt=>'Benutzername',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 2,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>34044846258930035 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_PASSWORD',
  p_data_type=> '',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 34044649086929992+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> '',
  p_prompt=>'Kennwort',
  p_display_as=> 'PASSWORD_WITH_ENTER_SUBMIT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 100,
  p_cHeight=> null,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 34042926358929906+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>34044939542930035 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 101,
  p_name=>'P101_LOGIN',
  p_data_type=> '',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 34044649086929992+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> '',
  p_item_default => 'Anmelden',
  p_prompt=>'Anmelden',
  p_source=>'LOGIN',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_tag_attributes  => 'template:'||to_char(34038127947929857 + wwv_flow_api.g_id_offset),
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'owa_util.mime_header(''text/html'', FALSE);'||chr(10)||
'owa_cookie.send('||chr(10)||
'    name=>''LOGIN_USERNAME_COOKIE'','||chr(10)||
'    value=>lower(:P101_USERNAME));'||chr(10)||
'exception when others then null;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 34045153882930051 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Benutzername-Cookie festlegen',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_custom_auth_std.login('||chr(10)||
'    P_UNAME       => :P101_USERNAME,'||chr(10)||
'    P_PASSWORD    => :P101_PASSWORD,'||chr(10)||
'    P_SESSION_ID  => v(''APP_SESSION''),'||chr(10)||
'    P_FLOW_PAGE   => :APP_ID||'':1'''||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 34045028993930042 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Login',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'101';

wwv_flow_api.create_page_process(
  p_id     => 34045337094930053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'Seiten-Cache-Inhalt löschen',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'    v varchar2(255) := null;'||chr(10)||
'    c owa_cookie.cookie;'||chr(10)||
'begin'||chr(10)||
'   c := owa_cookie.get(''LOGIN_USERNAME_COOKIE'');'||chr(10)||
'   :P101_USERNAME := c.vals(1);'||chr(10)||
'exception when others then null;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 34045257503930053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 101,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Benutzername-Cookie abrufen',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 101
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
 
begin
 
wwv_flow_api.create_menu (
  p_id=> 34045446868930053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> ' Navigationspfad');
 
wwv_flow_api.create_menu_option (
  p_id=>3795424477450665 + wwv_flow_api.g_id_offset,
  p_menu_id=>34045446868930053 + wwv_flow_api.g_id_offset,
  p_parent_id=>0,
  p_option_sequence=>10,
  p_short_name=>'Installation',
  p_long_name=>'',
  p_link=>'f?p=&FLOW_ID.:4:&SESSION.',
  p_page_id=>4,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>3797916843455831 + wwv_flow_api.g_id_offset,
  p_menu_id=>34045446868930053 + wwv_flow_api.g_id_offset,
  p_parent_id=>0,
  p_option_sequence=>10,
  p_short_name=>'Usage',
  p_long_name=>'',
  p_link=>'f?p=&FLOW_ID.:5:&SESSION.',
  p_page_id=>5,
  p_also_current_for_pages=> '');
 
wwv_flow_api.create_menu_option (
  p_id=>34045839521930089 + wwv_flow_api.g_id_offset,
  p_menu_id=>34045446868930053 + wwv_flow_api.g_id_offset,
  p_parent_id=>0,
  p_option_sequence=>10,
  p_short_name=>'Home',
  p_long_name=>'',
  p_link=>'f?p=&APP_ID.:1:&SESSION.',
  p_page_id=>1,
  p_also_current_for_pages=> '');
 
null;
 
end;
/

prompt  ...page templates for application: 860
--
--application/shared_components/user_interface/templates/page/no_tabs_with_sidebar
prompt  ......Page template 34037036688929829
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'#HEAD#'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<hr />'||chr(10)||
'<div class="t15customize">#CUSTOMIZE#</div>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td><div class="t15logo">#LOGO#</div><br />#REGION_POSITION_06#</td>'||chr(10)||
'<td width="100%" valign="top">#REGION_POSITION_07#</td>'||chr(10)||
'<td><div class="t15NavBar"><span class="t15NavBarItem">&USER.</span>#NAVIGATION_BAR#</div><br />#REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<br style="clear:both;"/>'||chr(10)||
'<table summary="" cellpadding="0';

c3:=c3||'" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" class="t15pagelinecenter"><img src="#IMAGE_PREFIX#themes/theme_15/page_line_center.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr class="t15PageTopLine">'||chr(10)||
'<td>#REGION_POSITION_01#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'<table width="100%" summary="" height="70%" cellspacing="0" cellpadding="0" border="0">'||chr(10)||
'	<tr>'||chr(10)||
'        <td valign="top"><table cellspacing="0" cell';

c3:=c3||'padding="0" border="0" class="t15Sidebar" summary="">'||chr(10)||
'<td class="L"><img src="#IMAGE_PREFIX#themes/theme_15/left_curve.gif" alt=""/></td>'||chr(10)||
'<td class="C" width="100%"><br /></td>'||chr(10)||
'<td class="R" align="right"><img src="#IMAGE_PREFIX#themes/theme_15/right_curve.gif" alt=""/></td>'||chr(10)||
'<tr><td colspan="3" class="B">#REGION_POSITION_02#</td></tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="L"><img src="#IMAGE_PREFIX#themes/theme_15/left';

c3:=c3||'_curve_bottom.gif" alt=""/></td>'||chr(10)||
'<td class="C" width="100%"><br /></td>'||chr(10)||
'<td class="R" align="right"><img src="#IMAGE_PREFIX#themes/theme_15/right_curve_bottom.gif" alt=""/></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'	<td align="right" valign="top"><img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" /></td>'||chr(10)||
'	<td class="t15PageBody"><div class="t15Messages" align="center">#GLOBAL_NOTIFICATION##NOTIFICA';

c3:=c3||'TION_MESSAGE##SUCCESS_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'	<td align="right" valign="top"><img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" /></td>'||chr(10)||
'	<td class="t15RightBar" align="right" valign="top">#REGION_POSITION_03#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 34037036688929829 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs With Sidebar',
  p_body_title=> '#BODY_TITLE#',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t15Success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t15Notification">#MESSAGE#</div>'||chr(10)||
'',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="t15NavBarItem">#TEXT#</a>'||chr(10)||
'',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%"  summary=""',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 15,
  p_theme_class_id => 17,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs
prompt  ......Page template 34037156461929843
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'#HEAD#'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<hr />'||chr(10)||
'<div class="t15customize">#CUSTOMIZE#</div>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" cellspacing="0" border="0" width="97%" align="center">'||chr(10)||
'<tr>'||chr(10)||
'<td><div class="t15logo">#LOGO#</div><br />#REGION_POSITION_06#</td>'||chr(10)||
'<td width="100%" valign="top">#REGION_POSITION_07#</td>'||chr(10)||
'<td><div class="t15NavBar"><span class="t15NavBarItem">&USER.</span>#NAVIGATION_BAR#</div><br />#REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<br style="clear:both;"/>'||chr(10)||
'<table summary="" ';

c3:=c3||'cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td><table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr><td width="100%"><br /></td>#PARENT_TAB_CELLS#</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" style="background-color:#336699">#TAB_CELLS#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr class="t15PageTopLine"><td>#REGION_POSITION_01#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'<table width="100%" summary';

c3:=c3||'="" height="70%" cellspacing="0" cellpadding="0" border="0">'||chr(10)||
'	<tr>'||chr(10)||
'	<td align="right" valign="top"><img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" /></td>'||chr(10)||
'	<td class="t15PageBody"><div class="t15Messages" align="center">#GLOBAL_NOTIFICATION##NOTIFICATION_MESSAGE##SUCCESS_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'	<td align="right" valign="top"><img sr';

c3:=c3||'c="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" /></td>'||chr(10)||
'	<td class="t15RightBar" align="right" valign="top">#REGION_POSITION_03#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 34037156461929843 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs',
  p_body_title=> '<!--#BODY_TITLE#-->',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t15Success">#SUCCESS_MESSAGE#</div>'||chr(10)||
'',
  p_current_tab=> '<a class="t15ChildTabCurrent" href="#TAB_LINK#">#TAB_LABEL#</a>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a class="t15ChildTab" href="#TAB_LINK#">#TAB_LABEL#</a>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_open_c.gif" alt="" /></td>'||chr(10)||
'<td class="t15CurrentTabCenter"><a href="#TAB_LINK#">#TAB_LABEL#</a></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_close_c.gif" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_open.gif" alt="" /></td>'||chr(10)||
'<td class="t15TabCenter"><a href="#TAB_LINK#">#TAB_LABEL#</a></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_close.gif" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t15Notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="t15NavBarItem">#TEXT#</a>'||chr(10)||
'',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%" summary=""',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 15,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/printer_friendly
prompt  ......Page template 34037225447929843
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'#HEAD#'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td valign="top">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'<td width="100%" valign="top">#REGION_POSITION_07#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_08#</td>'||chr(10)||
'</table>'||chr(10)||
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top">'||chr(10)||
'<div style="border:1px solid black;">#SUCCESS_MESSAG';

c3:=c3||'E##NOTIFICATION_MESSAGE#</div>'||chr(10)||
'#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'#REGION_POSITION_05#';

wwv_flow_api.create_template(
  p_id=> 34037225447929843 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Printer Friendly',
  p_body_title=> '<!--#BODY_TITLE#-->',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t15Success">#SUCCESS_MESSAGE#</div>'||chr(10)||
'',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t15Notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="t15NavBarItem">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%"',
  p_theme_id  => 15,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs
prompt  ......Page template 34037339482929843
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<style type="text/css">'||chr(10)||
'<!--'||chr(10)||
'.space{ height:5px; }'||chr(10)||
'.code {'||chr(10)||
'	font-family: "Courier New", Courier, monospace;'||chr(10)||
'	background-color: #CFE0F1;'||chr(10)||
'	font-size: 12px;'||chr(10)||
'}'||chr(10)||
'-->'||chr(10)||
'</style>'||chr(10)||
'#HEAD#'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_';

c1:=c1||'OPEN#';

c2:=c2||'<hr />'||chr(10)||
'Version #APP_VERSION# / Dietmar Aust (<a href="http://www.opal-consulting.de" target="_blank">www.opal-consulting.de</a>)'||chr(10)||
'<div class="t15customize">#CUSTOMIZE#</div>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td><div class="t15logo">#LOGO#</div><br />#REGION_POSITION_06#</td>'||chr(10)||
'<td width="100%" valign="top">#REGION_POSITION_07#</td>'||chr(10)||
'<td><div class="t15NavBar"><span class="t15NavBarItem">&USER.</span>#NAVIGATION_BAR#</div><br />#REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<br style="clear:both;"/>'||chr(10)||
'<table summary="" cellpadding="0';

c3:=c3||'" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td><table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr><td width="100%"><br /></td>#TAB_CELLS#</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" class="t15pagelinecenter"><img src="#IMAGE_PREFIX#themes/theme_15/page_line_center.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr class="t15PageTopLine"><td>#REGION_POSITION_01#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'<b';

c3:=c3||'r />'||chr(10)||
'<table width="100%" summary="" height="70%" cellspacing="0" cellpadding="0" border="0">'||chr(10)||
'	<tr>'||chr(10)||
'	<td class="t15PageBody"><div class="t15Messages" align="center">#GLOBAL_NOTIFICATION##NOTIFICATION_MESSAGE##SUCCESS_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'	<td align="right" valign="top"><img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" /></td>'||chr(10)||
'	<td cl';

c3:=c3||'ass="t15RightBar" align="right" valign="top">#REGION_POSITION_03#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 34037339482929843 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs',
  p_body_title=> '#BODY_TITLE#',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t15Success">#SUCCESS_MESSAGE#</div>'||chr(10)||
'',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_open_c.gif" alt="" /></td>'||chr(10)||
'<td class="t15CurrentTabCenter"><a href="#TAB_LINK#">#TAB_LABEL#</a></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_close_c.gif" alt="" /></td>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_open.gif" alt="" /></td>'||chr(10)||
'<td class="t15TabCenter"><a href="#TAB_LINK#">#TAB_LABEL#</a></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_close.gif" alt="" /></td>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t15Notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="t15NavBarItem">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%" summary=""',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 15,
  p_theme_class_id => 1,
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs
prompt  ......Page template 34037449891929843
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'#HEAD#'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<hr />'||chr(10)||
'<div class="t15customize">#CUSTOMIZE#</div>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td><div class="t15logo">#LOGO#</div><br />#REGION_POSITION_06#</td>'||chr(10)||
'<td width="100%" valign="top">#REGION_POSITION_07#</td>'||chr(10)||
'<td><div class="t15NavBar"><span class="t15NavBarItem">&USER.</span>#NAVIGATION_BAR#</div><br />#REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<br style="clear:both;"/>'||chr(10)||
'<table summary="" cellpadding="0';

c3:=c3||'" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" class="t15pagelinecenter"><img src="#IMAGE_PREFIX#themes/theme_15/page_line_center.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr class="t15PageTopLine">'||chr(10)||
'<td>#REGION_POSITION_01#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'<table width="100%" summary="" height="70%" cellspacing="0" cellpadding="0" border="0">'||chr(10)||
'	<tr>'||chr(10)||
'	<td class="t15PageBody"><div class="t15Messages" al';

c3:=c3||'ign="center">#GLOBAL_NOTIFICATION##NOTIFICATION_MESSAGE##SUCCESS_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'	<td align="right" valign="top"><img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" /></td>'||chr(10)||
'	<td class="t15RightBar" align="right" valign="top">#REGION_POSITION_03#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 34037449891929843 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs',
  p_body_title=> '#BODY_TITLE#',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t15Success">#SUCCESS_MESSAGE#</div>'||chr(10)||
'',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t15Notification">#MESSAGE#</div>'||chr(10)||
'',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="t15NavBarItem">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%" summary=""',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 15,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_with_sidebar
prompt  ......Page template 34037554270929843
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'#HEAD#'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<hr />'||chr(10)||
'<div class="t15customize">#CUSTOMIZE#</div>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" cellspacing="0" border="0" width="97%" align="center">'||chr(10)||
'<tr>'||chr(10)||
'<td><div class="t15logo">#LOGO#</div><br />#REGION_POSITION_06#</td>'||chr(10)||
'<td width="100%" valign="top">#REGION_POSITION_07#</td>'||chr(10)||
'<td><div class="t15NavBar"><span class="t15NavBarItem">&USER.</span>#NAVIGATION_BAR#</div><br />#REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<br style="clear:both;"/>'||chr(10)||
'<table summary="" ';

c3:=c3||'cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td><table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr><td width="100%"><br /></td>#TAB_CELLS#</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" class="t15pagelinecenter"><img src="#IMAGE_PREFIX#themes/theme_15/page_line_center.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr class="t15PageTopLine"><td>#REGION_POSITION_01#</td></t';

c3:=c3||'r>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'<table width="100%" summary="" height="70%" cellspacing="0" cellpadding="0" border="0">'||chr(10)||
'	<tr>'||chr(10)||
'        <td valign="top">'||chr(10)||
'<table cellspacing="0" cellpadding="0" border="0" class="t15Sidebar" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="L"><img src="#IMAGE_PREFIX#themes/theme_15/left_curve.gif" alt=""/></td>'||chr(10)||
'<td class="C" width="100%"><br /></td>'||chr(10)||
'<td class="R" align="right"><img src="#IMAGE_PREFIX#';

c3:=c3||'themes/theme_15/right_curve.gif" alt=""/></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr><td colspan="3" class="B">#REGION_POSITION_02#</td></tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="L"><img src="#IMAGE_PREFIX#themes/theme_15/left_curve_bottom.gif" alt=""/></td>'||chr(10)||
'<td class="C" width="100%"><br /></td>'||chr(10)||
'<td class="R" align="right"><img src="#IMAGE_PREFIX#themes/theme_15/right_curve_bottom.gif" alt=""/></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'</td>'||chr(10)||
'	<td align="right" valig';

c3:=c3||'n="top"><img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" /></td>'||chr(10)||
'	<td class="t15PageBody"><div class="t15Messages" align="center">#GLOBAL_NOTIFICATION##NOTIFICATION_MESSAGE##SUCCESS_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'	<td align="right" valign="top"><img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" /></td>'||chr(10)||
'	<td class="t15RightBar" align="right" vali';

c3:=c3||'gn="top">#REGION_POSITION_03#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 34037554270929843 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs with Sidebar',
  p_body_title=> '#BODY_TITLE#',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t15Success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_open_c.gif" alt="" /></td>'||chr(10)||
'<td class="t15CurrentTabCenter"><a href="#TAB_LINK#">#TAB_LABEL#</a></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_close_c.gif" alt="" /></td>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_open.gif" alt="" /></td>'||chr(10)||
'<td class="t15TabCenter"><a href="#TAB_LINK#">#TAB_LABEL#</a></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_close.gif" alt="" /></td>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t15Notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="t15NavBarItem">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%"  summary=""',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 15,
  p_theme_class_id => 16,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_with_side_bar
prompt  ......Page template 34037633964929848
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'#HEAD#'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<hr />'||chr(10)||
'<div class="t15customize">#CUSTOMIZE#</div>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" cellspacing="0" border="0" width="97%" align="center">'||chr(10)||
'<tr>'||chr(10)||
'<td><div class="t15logo">#LOGO#</div><br />#REGION_POSITION_06#</td>'||chr(10)||
'<td width="100%" valign="top">#REGION_POSITION_07#</td>'||chr(10)||
'<td><div class="t15NavBar"><span class="t15NavBarItem">&USER.</span>#NAVIGATION_BAR#</div><br />#REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<br style="clear:both;"/>'||chr(10)||
'<table summary="" ';

c3:=c3||'cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td><table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr><td width="100%"><br /></td>#PARENT_TAB_CELLS#</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" style="background-color:#336699">#TAB_CELLS#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr class="t15PageTopLine"><td>#REGION_POSITION_01#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'<table width="100%" summary';

c3:=c3||'="" height="70%" cellspacing="0" cellpadding="0" border="0">'||chr(10)||
'	<tr>'||chr(10)||
'        <td valign="top">'||chr(10)||
'<table cellspacing="0" cellpadding="0" border="0" class="t15Sidebar" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="L"><img src="#IMAGE_PREFIX#themes/theme_15/left_curve.gif" alt=""/></td>'||chr(10)||
'<td class="C" width="100%"><br /></td>'||chr(10)||
'<td class="R" align="right"><img src="#IMAGE_PREFIX#themes/theme_15/right_curve.gif" alt=""/></td>';

c3:=c3||''||chr(10)||
'</tr>'||chr(10)||
'<tr><td colspan="3" class="B">#REGION_POSITION_02#</td></tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="L"><img src="#IMAGE_PREFIX#themes/theme_15/left_curve_bottom.gif" alt=""/></td>'||chr(10)||
'<td class="C" width="100%"><br /></td>'||chr(10)||
'<td class="R" align="right"><img src="#IMAGE_PREFIX#themes/theme_15/right_curve_bottom.gif" alt=""/></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'</td>'||chr(10)||
'	<td align="right" valign="top"><img src="#IMAGE_PREFIX#f_spacer.gif" ';

c3:=c3||'width="15" height="3" alt="" /></td>'||chr(10)||
'	<td class="t15PageBody"><div class="t15Messages" align="center">#GLOBAL_NOTIFICATION##NOTIFICATION_MESSAGE##SUCCESS_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'	<td align="right" valign="top"><img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" /></td>'||chr(10)||
'	<td class="t15RightBar" align="right" valign="top">#REGION_POSITION_03#</td>'||chr(10)||
'</tr>'||chr(10)||
'</tab';

c3:=c3||'le>';

wwv_flow_api.create_template(
  p_id=> 34037633964929848 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs with Side Bar',
  p_body_title=> '<!--#BODY_TITLE#-->',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t15Success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<a class="t15ChildTabCurrent" href="#TAB_LINK#">#TAB_LABEL#</a>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a class="t15ChildTab" href="#TAB_LINK#">#TAB_LABEL#</a>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_open_c.gif" alt="" /></td>'||chr(10)||
'<td class="t15CurrentTabCenter"><a href="#TAB_LINK#">#TAB_LABEL#</a></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_close_c.gif" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_open.gif" alt="" /></td>'||chr(10)||
'<td class="t15TabCenter"><a href="#TAB_LINK#">#TAB_LABEL#</a></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_15/tab_close.gif" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t15Notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="t15NavBarItem">#TEXT#</a>'||chr(10)||
'',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%" summary=""',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 15,
  p_theme_class_id => 18,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/popup
prompt  ......Page template 34037745008929848
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'#HEAD#'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#'||chr(10)||
''||chr(10)||
'</body> '||chr(10)||
'</html>'||chr(10)||
'';

c3:=c3||'<div style="padding:10px;text-align:left;" valign="top">#BOX_BODY#</div>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 34037745008929848 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Popup',
  p_body_title=> '#BODY_TITLE#',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t15Success">#SUCCESS_MESSAGE#</div>'||chr(10)||
''||chr(10)||
'',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t15Notification">#MESSAGE#</b>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="t15NavBarItem">#TEXT#</a>'||chr(10)||
'',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%"',
  p_theme_id  => 15,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/login
prompt  ......Page template 34037829195929848
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'#HEAD#'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#'||chr(10)||
'</body>'||chr(10)||
'</html>'||chr(10)||
'';

c3:=c3||'#NOTIFICATION_MESSAGE##SUCCESS_MESSAGE#'||chr(10)||
'<table border="0" summary="" align="center" style="margin:100px auto;width:50%;">'||chr(10)||
'<tr>'||chr(10)||
'<td>#BOX_BODY#'||chr(10)||
'#REGION_POSITION_01#'||chr(10)||
'#REGION_POSITION_02#'||chr(10)||
'#REGION_POSITION_03#'||chr(10)||
'#REGION_POSITION_04#'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#REGION_POSITION_06#'||chr(10)||
'#REGION_POSITION_07#'||chr(10)||
'#REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 34037829195929848 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Login',
  p_body_title=> '#BODY_TITLE#',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t15Notification">#MESSAGE#</div>'||chr(10)||
'',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%"',
  p_theme_id  => 15,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_o_branding_o_registerkarten_o_kopf_leiste
prompt  ......Page template 431640656395640239
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </hea';

c1:=c1||'d>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal8">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="p';

c2:=c2||'adding-right:5px">'||chr(10)||
'       <div class="blackTextNormal8">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'';

c3:=c3||'     <tr>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <tr><td class="obenlinks">#BOX_BODY#</td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'  ';

c3:=c3||'          <td style="width:340px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_05#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSI';

c3:=c3||'TION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;t';

c3:=c3||'ext-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 431640656395640239 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (o. Branding, o. Registerkarten, o.Kopf-Leiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 10,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_o_branding_m_1_ebene_registerkarten_m_navi_leiste
prompt  ......Page template 439627288789806198
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'<!--  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"> '||chr(10)||
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> -->'||chr(10)||
'  <title>Wohnungsvermittlung</title>'||chr(10)||
''||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link re';

c1:=c1||'l="stylesheet" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
'<style type="text/css">'||chr(10)||
'table #navibar {'||chr(10)||
'  background-color:#B5B2B5;'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'#navibar td {'||chr(10)||
'  border-right: 1px solid #FFF;'||chr(10)||
'  border-top:1px solid #FFF;'||chr(10)||
'  padding-left: 15px;'||chr(10)||
'  padding-right: 15px;'||chr(10)||
'}'||chr(10)||
'.htmldbUlErr { color:red; }'||chr(10)||
'</style>'||chr(10)||
''||chr(10)||
' </head';

c1:=c1||'>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal10">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="';

c2:=c2||'padding-right:5px">'||chr(10)||
'       <div class="blackTextNormal10">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
'<div style="background-color:#FFF;height:100px;">'||chr(10)||
'  <div style="float: left;background-color:#FFF;">'||chr(10)||
'    <img src="#WORKSPACE_IMAGES#wohver_V4.gif" border="0" alt="Logo"/>'||chr(10)||
'  </div>'||chr(10)||
'  <div style="float: right;background-color:#FFF;margin-top:21px;margin-right:21px;">'||chr(10)||
'    <img src="#WORKSPACE_IMAGES#audi_logo.gif" border="0" alt="Audi"/>'||chr(10)||
'  </div>'||chr(10)||
'</div>'||chr(10)||
'<div style="clear:';

c3:=c3||'both;font-size:1px;height:0pt; line-height:0pt;margin:0pt;padding:0pt;">'||chr(10)||
'</div>'||chr(10)||
''||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td>'||chr(10)||
''||chr(10)||
'    <table cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:29px;border-bottom:1px solid #FFF;background-color:#D6DBD6;">'||chr(10)||
'   ';

c3:=c3||'  <tr>'||chr(10)||
'      <td class="mitterechts" style="text-align:left;">#NAVIGATION_BAR#</td>'||chr(10)||
'      <td class="mittelinks">&nbsp;</td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
''||chr(10)||
'    <table cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:24px;border-bottom:1px solid #FFF;background-color:#B4BAAD;">'||chr(10)||
'    <tr>'||chr(10)||
'      <td class="audi-anwendungstitel" style="width:20%;padding-right:5px">#TITLE#<';

c3:=c3||'/td>'||chr(10)||
'      <td colspan="2">&nbsp;#GLOBAL_NOTIFICATION# #NOTIFICATION_MESSAGE# #SUCCESS_MESSAGE# </td>'||chr(10)||
''||chr(10)||
'    </tr> '||chr(10)||
'    </table>'||chr(10)||
''||chr(10)||
''||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     ';

c3:=c3||'<tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td width="120" class="audi-portlet-navigation">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" width="120" >'||chr(10)||
'        <tr>'||chr(10)||
'         <td>#REGION_POSITION_07#</td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td><table>#PARENT_TAB_CELLS#</table></td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td style="padding-bottom:5px;font-weight:bold;">&CURRENT_PARENT_TAB_TEXT.'||chr(10)||
'        ';

c3:=c3||' </td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td style="padding-left:20px;">  '||chr(10)||
'            <table>#TAB_CELLS#</table></td></tr>'||chr(10)||
'        <tr><td style="height:28px;">&nbsp;</td></tr>'||chr(10)||
'        <tr><td>#REGION_POSITION_08#</td></tr>'||chr(10)||
'        <tr><td>&nbsp;</td></tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" class="audi-portlet-b';

c3:=c3||'ody" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <tr><td class="obenlinks">#BOX_BODY#</td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:340px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITIO';

c3:=c3||'N_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_05#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks"';

c3:=c3||'>'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'';

c3:=c3||'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>';

wwv_flow_api.create_template(
  p_id=> 439627288789806198 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (o. Branding, m. 1 Ebene Registerkarten, m. Navi-Leiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0" id="navibar" style="height:100%;"><tr>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_o_branding_m_1_ebene_registerkarten_m_randleiste
prompt  ......Page template 439629778193819667
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'<!--  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"> '||chr(10)||
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> -->'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
''||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="styleshee';

c1:=c1||'t" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </head>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal10">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="';

c2:=c2||'padding-right:5px">'||chr(10)||
'       <div class="blackTextNormal10">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="audi-portlet-header">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:29px">'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="audi-anwendungstitel">&ANWENDUNG_TITEL.</td>'||chr(10)||
'      <td cl';

c3:=c3||'ass="mittelinks" style="width:50%">&nbsp;#GLOBAL_NOTIFICATION# #SUCCESS_MESSAGE# </td>'||chr(10)||
'      <td class="mitterechts" style="width:20%;padding-right:5px"><span class="AudiNavBar">#NAVIGATION_BAR#</span></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'    <t';

c3:=c3||'able cellpadding="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td width="120" class="audi-portlet-navigation">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" width="120">'||chr(10)||
'        <tr>'||chr(10)||
'         <td>#REGION_POSITION_07#</td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td><table>#TAB_CELLS#</table></td></tr>'||chr(10)||
'        <tr';

c3:=c3||'><td style="height:28px">&nbsp;</td></tr>'||chr(10)||
'        <tr><td>#REGION_POSITION_08#</td></tr>'||chr(10)||
'        <tr><td>#NOTIFICATION_MESSAGE#</td></tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <tr>';

c3:=c3||'<td class="obenlinks">#BOX_BODY#</td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:340px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="audi';

c3:=c3||'-portlet-content">#REGION_POSITION_05#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;padding-r';

c3:=c3||'ight:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 439629778193819667 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (o. Branding, m. 1 Ebene Registerkarten, m. Randleiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 16,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_o_branding_m_registerkarten_m_randleiste
prompt  ......Page template 439632700458836560
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'<!--  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"> '||chr(10)||
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> -->'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
''||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="styleshee';

c1:=c1||'t" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </head>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal10">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="';

c2:=c2||'padding-right:5px">'||chr(10)||
'       <div class="blackTextNormal10">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="audi-portlet-header">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:29px">'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="audi-anwendungstitel">&ANWENDUNG_TITEL.</td>'||chr(10)||
'      <td cl';

c3:=c3||'ass="mittelinks" style="width:50%">&nbsp;#GLOBAL_NOTIFICATION# #SUCCESS_MESSAGE# </td>'||chr(10)||
'      <td class="mitterechts" style="width:20%;padding-right:5px"><span class="AudiNavBar">#NAVIGATION_BAR#</span></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'    <t';

c3:=c3||'able cellpadding="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td width="120" class="audi-portlet-navigation">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" width="120">'||chr(10)||
'        <tr>'||chr(10)||
'         <td>#REGION_POSITION_07#</td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td><table>#PARENT_TAB_CELLS#</table></td><tr>'||chr(10)||
'     ';

c3:=c3||'   <tr>'||chr(10)||
'         <td style="height:30px">&nbsp;<hr></td>'||chr(10)||
'<!--          <img src="#IMAGE_PREFIX#dotted_dbl_line.gif" width="136" height="3" border="0" alt="" /></td> -->'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td style="padding-bottom:5px;font-weight:bold">&CURRENT_PARENT_TAB_TEXT.'||chr(10)||
'         </td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td style="padding-left:20px"><table>#TAB_CELLS#</table></td></tr>'||chr(10)||
'        <tr><';

c3:=c3||'td style="height:28px">&nbsp;</td></tr>'||chr(10)||
'        <tr><td>#REGION_POSITION_08#</td></tr>'||chr(10)||
'        <tr><td>#NOTIFICATION_MESSAGE#</td></tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <tr><t';

c3:=c3||'d class="obenlinks">#BOX_BODY#</td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:340px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="audi-p';

c3:=c3||'ortlet-content">#REGION_POSITION_05#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;padding-rig';

c3:=c3||'ht:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 439632700458836560 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (o. Branding, m. Registerkarten, m. Randleiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 18,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_o_branding_o_registerkarten_m_randleiste
prompt  ......Page template 439659685949914372
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'<!--  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"> '||chr(10)||
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> -->'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
''||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="styleshee';

c1:=c1||'t" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </head>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal10">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="';

c2:=c2||'padding-right:5px">'||chr(10)||
'       <div class="blackTextNormal10">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="audi-portlet-header">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:29px">'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="audi-anwendungstitel">&ANWENDUNG_TITEL.</td>'||chr(10)||
'      <td cl';

c3:=c3||'ass="mittelinks" style="width:50%">&nbsp;#GLOBAL_NOTIFICATION# #SUCCESS_MESSAGE# </td>'||chr(10)||
'      <td class="mitterechts" style="width:20%;padding-right:5px"><span class="AudiNavBar">#NAVIGATION_BAR#</span></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'    <t';

c3:=c3||'able cellpadding="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td width="150" class="audi-portlet-navigation">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" width="150">'||chr(10)||
'        <tr>'||chr(10)||
'         <td>#REGION_POSITION_07#</td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td style="height:28px">&nbsp;</td></tr>'||chr(10)||
'        <tr';

c3:=c3||'><td>#REGION_POSITION_08#</td></tr>'||chr(10)||
'        <tr><td>#NOTIFICATION_MESSAGE#</td></tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <tr><td class="obenlinks">#BOX_BODY#</td></tr>'||chr(10)||
'        <t';

c3:=c3||'r>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:340px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_05#</td>'||chr(10)||
'         ';

c3:=c3||'   <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;padding-right:30px;vertical-align:top;text-align:left" class="';

c3:=c3||'audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 439659685949914372 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (o. Branding, o. Registerkarten, m. Randleiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 17,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_o_branding_m_registerkarten_m_navi_leiste
prompt  ......Page template 442257886958646093
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'<!--  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"> '||chr(10)||
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> -->'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
''||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="styleshee';

c1:=c1||'t" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </head>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal8">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="p';

c2:=c2||'adding-right:5px">'||chr(10)||
'       <div class="blackTextNormal10">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td>'||chr(10)||
'    <table cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:29px">'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="audi-anwendungstitel">&ANWENDUNG_TITEL.</td>'||chr(10)||
'      <td class="mittelinks" style="widt';

c3:=c3||'h:50%">&nbsp;#GLOBAL_NOTIFICATION# #SUCCESS_MESSAGE# </td>'||chr(10)||
'      <td class="mitterechts" style="width:20%;padding-right:5px"><span class="AudiNavBar">#NAVIGATION_BAR#</span></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'    <table cellpadding="0" cellspa';

c3:=c3||'cing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td width="120" class="audi-portlet-navigation">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" width="120">'||chr(10)||
'        <tr>'||chr(10)||
'         <td>#REGION_POSITION_07#</td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td><table>#PARENT_TAB_CELLS#</table></td><tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td style="';

c3:=c3||'height:30px">&nbsp;<hr></td>'||chr(10)||
'<!--          <img src="#IMAGE_PREFIX#dotted_dbl_line.gif" width="136" height="3" border="0" alt="" /></td> -->'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td style="padding-bottom:5px;font-weight:bold">&CURRENT_PARENT_TAB_TEXT.'||chr(10)||
'         </td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td style="padding-left:20px"><table>#TAB_CELLS#</table></td></tr>'||chr(10)||
'        <tr><td style="height:28px">&nbsp';

c3:=c3||';</td></tr>'||chr(10)||
'        <tr><td>#REGION_POSITION_08#</td></tr>'||chr(10)||
'        <tr><td>#NOTIFICATION_MESSAGE#</td></tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <tr><td class="obenlinks">#BOX_BOD';

c3:=c3||'Y#</td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:340px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSI';

c3:=c3||'TION_05#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;padding-right:30px;vertical-align:top;t';

c3:=c3||'ext-align:left" class="audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 442257886958646093 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (o. Branding, m. Registerkarten, m. Navi-Leiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_o_branding_o_registerkarten_m_navi_leiste
prompt  ......Page template 442293097033822768
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </hea';

c1:=c1||'d>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal10">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="';

c2:=c2||'padding-right:5px">'||chr(10)||
'       <div class="blackTextNormal10">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="audi-portlet-header">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:29px">'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="audi-anwendungstitel">&ANWENDUNG_TITEL.</td>'||chr(10)||
'      <td cl';

c3:=c3||'ass="mittelinks" style="width:50%">&nbsp;#GLOBAL_NOTIFICATION# #SUCCESS_MESSAGE# </td>'||chr(10)||
'      <td class="mitterechts" style="width:20%;padding-right:5px"><span class="AudiNavBar">&nbsp;#NAVIGATION_BAR#</span></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'';

c3:=c3||'    <table cellpadding="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <tr><td ';

c3:=c3||'class="obenlinks">#BOX_BODY#</td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:340px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="audi-por';

c3:=c3||'tlet-content">#REGION_POSITION_05#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;padding-right';

c3:=c3||':30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 442293097033822768 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (o. Branding, o. Registerkarten, m. Navi-Leiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_m_branding_o_registerkarten_m_navi_leiste
prompt  ......Page template 443944813478465894
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
''||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </he';

c1:=c1||'ad>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal10">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="';

c2:=c2||'padding-right:5px">'||chr(10)||
'       <div class="blackTextNormal10">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Globalnavigation + Username ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td>'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr class="mittelinks">'||chr(10)||
'      <td class="audi-globalnavigation">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'        <tr>'||chr(10)||
' ';

c3:=c3||'        <td><a class="audi-globalnavigation-href" '||chr(10)||
'           href="http://www.audi.com" target="_blank">Audi</a>'||chr(10)||
'         </td>'||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="AudiUserName"><div style="padding-left:15px">&APP_USER.</div></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Branding Area ************ -->'||chr(10)||
'  <tr class="hdg-branding-area">'||chr(10)||
'   ';

c3:=c3||'<td>'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr>'||chr(10)||
'      <td style="width:40%">&nbsp;</td>'||chr(10)||
'      <td style="width:20%">&nbsp;</td>'||chr(10)||
'      <td style="text-align:right;width:40%" class="AudiApplicationLogo">#LOGO#</td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="audi-portlet-header">'||chr(10)||
'    <table ';

c3:=c3||'cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:29px">'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="audi-anwendungstitel">&ANWENDUNG_TITEL.</td>'||chr(10)||
'      <td class="mittelinks" style="width:50%">&nbsp;#GLOBAL_NOTIFICATION# #SUCCESS_MESSAGE# </td>'||chr(10)||
'      <td class="mitterechts" style="width:20%;padding-right:5px"><span class="AudiNavBar">#NAVIGATION_BAR#</span></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </';

c3:=c3||'table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:475px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table';

c3:=c3||' cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <tr><td class="obenlinks">#BOX_BODY#</td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:340px;padding-right:30px;vertical-align:top;text-al';

c3:=c3||'ign:left" class="audi-portlet-content">#REGION_POSITION_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_05#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'   ';

c3:=c3||'     </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>'||chr(10)||
'       ';

c3:=c3||'    </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 443944813478465894 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (m. Branding, o. Registerkarten, m. Navi-Leiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 9,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_o_branding_o_registerkarten_o_navi_leiste
prompt  ......Page template 444266483925774362
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </hea';

c1:=c1||'d>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal10">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="';

c2:=c2||'padding-right:5px">'||chr(10)||
'       <div class="blackTextNormal10">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="audi-portlet-header">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:29px">'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="audi-anwendungstitel">&ANWENDUNG_TITEL.</td>'||chr(10)||
'      <td cl';

c3:=c3||'ass="mittelinks" style="width:50%">&nbsp;#GLOBAL_NOTIFICATION# #SUCCESS_MESSAGE# </td>'||chr(10)||
'      <td class="mitterechts" style="width:20%;padding-right:5px"><span class="AudiNavBar">&nbsp;<!--#NAVIGATION_BAR#--></span></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:';

c3:=c3||'left">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <';

c3:=c3||'tr><td class="obenlinks">#BOX_BODY#</td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:340px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="a';

c3:=c3||'udi-portlet-content">#REGION_POSITION_05#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;paddin';

c3:=c3||'g-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 444266483925774362 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (o. Branding, o. Registerkarten, o. Navi-Leiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 10,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_popup
prompt  ......Page template 446843948116172959
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </hea';

c1:=c1||'d>'||chr(10)||
'';

c2:=c2||' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="audi-portlet-header">&nbsp;</td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'    <table cellpadding';

c3:=c3||'="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          #BOX_BODY#'||chr(10)||
'         </td>'||chr(10)||
'        </tr>'||chr(10)||
'       <';

c3:=c3||'/table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 446843948116172959 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi Popup',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t12success"><img src="#IMAGE_PREFIX#themes/theme_12/success_w.gif" width="24" height="23" alt="" class="success" />#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t12notification">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td><br /></td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%" border="0" cellpadding="0" cellspacing="0" summary="" ',
  p_theme_id  => 101,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_login
prompt  ......Page template 446844752913172965
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_12/theme.css" type="text/css" />'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css" />'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </head>'||chr(10)||
' <body class="audi-portlet-body" #ONLOAD#>#FORM_OPEN#';

c2:=c2||' #FORM_CLOSE#'||chr(10)||
' </body>'||chr(10)||
'</html>'||chr(10)||
'';

c3:=c3||'  #NOTIFICATION_MESSAGE#'||chr(10)||
'  <table class="AudiLogin" align="center" summary="">'||chr(10)||
'   <tr><td class="AudiBody">#BOX_BODY#</td></tr>'||chr(10)||
'  </table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 446844752913172965 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi Login',
  p_body_title=> '#BODY_TITLE#',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t12notification">#MESSAGE#</div>',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%" border="0" cellpadding="0" cellspacing="0" summary="" ',
  p_theme_id  => 101,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_m_branding_m_registerkarten_m_navi_leiste
prompt  ......Page template 446956043994546600
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'||chr(10)||
'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'<!--  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"> '||chr(10)||
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> -->'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
''||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme.css" type="text/css" />'||chr(10)||
'  <link rel="styleshee';

c1:=c1||'t" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <script src="#IMAGE_PREFIX#audi/js/core-audi.js" type="text/javascript"></script>'||chr(10)||
' </head>'||chr(10)||
'';

c2:=c2||'  <tr>'||chr(10)||
'   <td class="audi-portlet-footer">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr style="height:20px">'||chr(10)||
'      <td class="mittelinks" style="padding-left:5px">'||chr(10)||
'       <div class="blackTextNormal10">&ANSPRECHPARTNER.&nbsp;&AP_TELEFON.&nbsp;&AP_FAX.&nbsp;<a style="font-size:1.0em" href="mailto:&AP_EMAIL.">&AP_EMAIL.</a></div>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="mitterechts" style="';

c2:=c2||'padding-right:5px">'||chr(10)||
'       <div class="blackTextNormal10">&HINWEIS.</div>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
' #FORM_CLOSE# '||chr(10)||
' <table  cellpadding="0" cellspacing="0">'||chr(10)||
'  <tr>'||chr(10)||
'   <td style="text-align:right" class="tiny">#CUSTOMIZE#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<body #ONLOAD#> #FORM_OPEN#'||chr(10)||
' <table class="AudiPageBody" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'  <!-- ************ Tabellenzeile = Globalnavigation + Username ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td>'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr class="mittelinks">'||chr(10)||
'      <td class="audi-globalnavigation">'||chr(10)||
'       <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'        <tr>'||chr(10)||
' ';

c3:=c3||'        <td><a class="audi-globalnavigation-href" '||chr(10)||
'           href="http://www.audi.com" target="_blank">Audi</a>'||chr(10)||
'         </td>'||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="AudiUserName"><div style="padding-left:15px">&APP_USER.</div></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Branding Area ************ -->'||chr(10)||
'  <tr class="hdg-branding-area">'||chr(10)||
'   ';

c3:=c3||'<td>'||chr(10)||
'    <table cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'     <tr>'||chr(10)||
'      <td style="width:40%">&nbsp;</td>'||chr(10)||
'      <td style="width:20%">&nbsp;</td>'||chr(10)||
'      <td style="text-align:right;width:40%" class="AudiApplicationLogo">#LOGO#</td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Titel ************ -->'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="audi-portlet-header">'||chr(10)||
'    <table ';

c3:=c3||'cellpadding="0" cellspacing="0" class="audi-portlet-header" style="width:100%;height:29px">'||chr(10)||
'     <tr>'||chr(10)||
'      <td class="audi-anwendungstitel">&ANWENDUNG_TITEL.</td>'||chr(10)||
'      <td class="mittelinks" style="width:50%">&nbsp;#GLOBAL_NOTIFICATION# #SUCCESS_MESSAGE# </td>'||chr(10)||
'      <td class="mitterechts" style="width:20%;padding-right:5px"><span class="AudiNavBar">#NAVIGATION_BAR#</span></td>'||chr(10)||
'     </tr>'||chr(10)||
'    </';

c3:=c3||'table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
''||chr(10)||
'  <!-- ************ Tabellenzeile = Portlet-Body ************ -->'||chr(10)||
'  <tr style="height:400px">'||chr(10)||
'   <td style="vertical-align:top;text-align:left">'||chr(10)||
'    <table cellpadding="0" cellspacing="0" style="height:100%" class="audi-portlet-body" width="100%">'||chr(10)||
'     <tr style="height:12px"><td>&nbsp;</td><tr>'||chr(10)||
'     <tr>'||chr(10)||
'      <td width="120" class="audi-portlet-navigation">'||chr(10)||
'       <table';

c3:=c3||' cellpadding="0" cellspacing="0" width="120">'||chr(10)||
'        <tr>'||chr(10)||
'         <td>#REGION_POSITION_07#</td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td><table>#PARENT_TAB_CELLS#</table></td><tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td style="height:30px">&nbsp;<hr></td>'||chr(10)||
'<!--          <img src="#IMAGE_PREFIX#dotted_dbl_line.gif" width="136" height="3" border="0" alt="" /></td> -->'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td style="padding-';

c3:=c3||'bottom:5px;font-weight:bold">&CURRENT_PARENT_TAB_TEXT.'||chr(10)||
'         </td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr><td style="padding-left:20px"><table>#TAB_CELLS#</table></td></tr>'||chr(10)||
'        <tr><td style="height:28px">&nbsp;</td></tr>'||chr(10)||
'        <tr><td>#REGION_POSITION_08#</td></tr>'||chr(10)||
'        <tr><td>#NOTIFICATION_MESSAGE#</td></tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'      <td class="obenlinks" style="padding-left:20px">'||chr(10)||
'     ';

c3:=c3||'  <table cellpadding="0" cellspacing="0" class="audi-portlet-body" style="vertical-align:left;">'||chr(10)||
'        <tr><td class="obenlinks">#REGION_POSITION_01#</td></tr>'||chr(10)||
'        <tr><td class="obenlinks">#BOX_BODY#</td></tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:340px;padding-right:30px;vertical-align:top';

c3:=c3||';text-align:left" class="audi-portlet-content">#REGION_POSITION_04#</td>'||chr(10)||
'            <td style="width:200px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_05#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_06#</td>'||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>      ';

c3:=c3||'    '||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'         <td class="obenlinks">'||chr(10)||
'          <table cellpadding="0" cellspacing="0">'||chr(10)||
'           <tr>'||chr(10)||
'            <td style="width:570px;padding-right:30px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_02#</td>'||chr(10)||
'            <td style="width:170px;vertical-align:top;text-align:left" class="audi-portlet-content">#REGION_POSITION_03#</td>';

c3:=c3||''||chr(10)||
'           </tr>'||chr(10)||
'          </table>'||chr(10)||
'         </td>          '||chr(10)||
'        </tr>'||chr(10)||
'       </table>'||chr(10)||
'      </td>'||chr(10)||
'     </tr>'||chr(10)||
'    </table>'||chr(10)||
'   </td>'||chr(10)||
'  </tr>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 446956043994546600 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi (m. Branding, m. Registerkarten, m. Navi-Leiste)',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<span class="AudiErfolg">#SUCCESS_MESSAGE#</span>',
  p_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_child.gif" alt="" /></td><td><a class="Audistandardtabcurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_child.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a></td></tr>',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_selected_mother.gif" alt="" /></td><td><a class="Audistandardtabcurrent" href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<tr><td width="15"><img src="#IMAGE_PREFIX#audi/funktionselemente/jumper_mother.gif" alt="" /></td><td><a class="Audistandardtabnoncurrent"  href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td></tr>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="AudiBenachrichtigung">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td>#BAR_BODY#</tr></table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'border="0" cellpadding="0" cellspacing="0"',
  p_theme_id  => 101,
  p_theme_class_id => 8,
  p_translate_this_template => 'N',
  p_template_comment => 'Auf Basis von TWO LEVEL TABS erstellt');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/audi_druckerausgabe
prompt  ......Page template 447074751071065133
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
' <head>'||chr(10)||
'  #HEAD#'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_12/theme.css" type="text/css" />'||chr(10)||
'  <link rel="stylesheet" href="#IMAGE_PREFIX#audi/css/theme-audi.css" type="text/css">'||chr(10)||
'  <title>#TITLE#</title>'||chr(10)||
' </head>'||chr(10)||
' <body class="drucken" onLoad="window.print()" #ONLOAD#>#FORM_OPEN#'||chr(10)||
'';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||' <table cellpadding="0" cellspacing="0" style="width:18cm">'||chr(10)||
'   <tr>'||chr(10)||
'    <td>'||chr(10)||
'     <table cellpadding="0" cellspacing="0" style="width:100%;border-bottom:1px solid black; border-left:none; border-right:none; border-top:none">'||chr(10)||
'      <tr>'||chr(10)||
'       <td class="AudiApplicationLogo" style="vertical-align:middle; text-align:right">#LOGO#'||chr(10)||
'       </td>'||chr(10)||
'      </tr>'||chr(10)||
'     </table>'||chr(10)||
'    </td>'||chr(10)||
'   </tr>'||chr(10)||
'   <tr><td>#';

c3:=c3||'REGION_POSITION_01#</td></tr>'||chr(10)||
'   <tr><td>#REGION_POSITION_02#</td></tr>'||chr(10)||
'   <tr><td>#REGION_POSITION_03#</td></tr>'||chr(10)||
'   <tr><td>#REGION_POSITION_04#</td></tr>'||chr(10)||
'   <tr><td>#REGION_POSITION_05#</td></tr>'||chr(10)||
'   <tr><td>#REGION_POSITION_06#</td></tr>'||chr(10)||
'   <tr><td>#BOX_BODY#</td></tr>'||chr(10)||
'  </table>';

wwv_flow_api.create_template(
  p_id=> 447074751071065133 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Audi Druckerausgabe',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="success"><img src="#IMAGE_PREFIX#themes/theme_12/success_w.gif" width="24" height="23" alt="" class="t12success" />#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t12notification">#MESSAGE#</div>',
  p_navigation_bar=> '<table cellpadding="0" cellspacing="0" border="0">'||chr(10)||
'<tr><td>&nbsp;&nbsp;</td>'||chr(10)||
'#BAR_BODY#'||chr(10)||
'</tr>'||chr(10)||
'</table>',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'width="100%" border="0" cellpadding="0" cellspacing="0" summary="" ',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
--application/shared_components/user_interface/templates/button/button_alternative_2
prompt  ......Button Template 34037954188929848
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t15Button2">#LABEL#</a>';

wwv_flow_api.create_button_templates (
  p_id=>34037954188929848 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Button, Alternative 2',
  p_translate_this_template => 'N',
  p_theme_id  => 15,
  p_theme_class_id => 5,
  p_template_comment       => '');
end;
/
--application/shared_components/user_interface/templates/button/button_alternative_1
prompt  ......Button Template 34038034262929857
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<table class="t15Button1" cellspacing="0" cellpadding="0" border="0"  summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_15/button_left.gif" alt="" width="4" height="24" /></a></td>'||chr(10)||
'<td class="t15C"><a href="#LINK#">#LABEL#</a></td>'||chr(10)||
'<td class="t15R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_15/button_right.gif" width="4" height="24" alt="" /></a></t';

t:=t||'d>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_button_templates (
  p_id=>34038034262929857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Button, Alternative 1',
  p_translate_this_template => 'N',
  p_theme_id  => 15,
  p_theme_class_id => 4,
  p_template_comment       => 'BLAF style, rounded on left side only. Uses classes in platform2.css or /css/einstein.css');
end;
/
--application/shared_components/user_interface/templates/button/button
prompt  ......Button Template 34038127947929857
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<table class="t15Button" cellspacing="0" cellpadding="0" border="0"  summary=""><tr>'||chr(10)||
'<td class="t15L"><img src="#IMAGE_PREFIX#themes/theme_15/button-l.gif" alt="" /></td>'||chr(10)||
'<td class="t15C"><a href="#LINK#">#LABEL#</a></td>'||chr(10)||
'<td class="t15R"><img src="#IMAGE_PREFIX#themes/theme_15/button-r.gif" alt="" /></td>'||chr(10)||
'</tr></table>';

wwv_flow_api.create_button_templates (
  p_id=>34038127947929857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Button',
  p_translate_this_template => 'N',
  p_theme_id  => 15,
  p_theme_class_id => 1,
  p_template_comment       => '');
end;
/
--application/shared_components/user_interface/templates/button/button_alternative_3
prompt  ......Button Template 34038242293929857
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t15Button3">#LABEL#</a>';

wwv_flow_api.create_button_templates (
  p_id=>34038242293929857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Button, Alternative 3',
  p_translate_this_template => 'N',
  p_theme_id  => 15,
  p_theme_class_id => 2,
  p_template_comment       => 'Standard Button');
end;
/
--application/shared_components/user_interface/templates/button/audi_button_mit_jumper
prompt  ......Button Template 444216010174109308
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<span class="audi-button-mit-jumper">&nbsp;</span><a style="padding-right:10px" href="#LINK#">#LABEL#</a>';

wwv_flow_api.create_button_templates (
  p_id=>444216010174109308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Audi Button mit Jumper',
  p_translate_this_template => 'N',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_template_comment       => '');
end;
/
--application/shared_components/user_interface/templates/button/audi_button_mit_action_jumper
prompt  ......Button Template 444225500933284897
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<a style="padding-right:0px" href="#LINK#">#LABEL#</a><a class="audi-button-mit-action-jumper" href="#LINK#"></a>';

wwv_flow_api.create_button_templates (
  p_id=>444225500933284897 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Audi Button mit Action Jumper',
  p_translate_this_template => 'N',
  p_theme_id  => 101,
  p_theme_class_id => 4,
  p_template_comment       => '');
end;
/
--application/shared_components/user_interface/templates/button/audi_button_alternative_3
prompt  ......Button Template 446844924181172965
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" class="t12ButtonAlternative3" summary="">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="t12ButtonAlternative3Left" width="3"><br /></td>'||chr(10)||
'  <td style="padding-left: 10px; padding-right: 10px;"><a href="#LINK#">#LABEL#</a></td>'||chr(10)||
'  <td class="t12ButtonAlternative3Right" width="3"><br /></td>'||chr(10)||
' </tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_button_templates (
  p_id=>446844924181172965 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Audi Button, Alternative 3',
  p_translate_this_template => 'N',
  p_theme_id  => 101,
  p_theme_class_id => 2,
  p_template_comment       => '');
end;
/
--application/shared_components/user_interface/templates/button/audi_button
prompt  ......Button Template 446845141049172966
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="AudiButton">#LABEL#</a>';

wwv_flow_api.create_button_templates (
  p_id=>446845141049172966 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Audi Button',
  p_translate_this_template => 'N',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_template_comment       => '');
end;
/
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/button_region_without_title
prompt  ......region template 34038337398929857
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" border="0" summary="" class="t15ButtonRegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'#BODY#';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34038337398929857 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 17,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34038337398929857 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/borderless_region
prompt  ......region template 34038452334929870
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t15BorderlessRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15RegionHeader">#TITLE#</td>'||chr(10)||
'<td align="right" class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34038452334929870 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Borderless Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 7,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34038452334929870 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region_alternative_1
prompt  ......region template 34038525823929870
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t15SidebarRegionAlt1" summary="" id="#REGION_ID#">'||chr(10)||
'<tr class="t15RegionHeader">'||chr(10)||
'<th class="L" valign="top"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="10" alt="" /></th>'||chr(10)||
'<th class="C">#TITLE#</th>'||chr(10)||
'<th class="R" valign="top"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="10" alt="" /></th>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" c';

t:=t||'lass="t15Body">#BODY#<img src="#IMAGE_PREFIX#1px_trans.gif" width="200" height="1" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34038525823929870 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region, Alternative 1',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 3,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34038525823929870 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region
prompt  ......region template 34038640563929870
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t15NavigationRegion" id="#REGION_ID#">#BODY#<img src="#IMAGE_PREFIX#1px_trans.gif" width="200" height="1" alt="" class="vsp" /></div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34038640563929870 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 5,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34038640563929870 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region
prompt  ......region template 34038730989929870
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t15SidebarRegion" summary="" id="#REGION_ID#">'||chr(10)||
'<tr class="t15RegionHeader">'||chr(10)||
'<th class="L" valign="top"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="10" alt="" /></th>'||chr(10)||
'<th class="C">#TITLE#</th>'||chr(10)||
'<th class="R" valign="top"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="10" alt="" /></th>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class';

t:=t||'="t15Body">#BODY#<img src="#IMAGE_PREFIX#1px_trans.gif" width="200" height="1" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34038730989929870 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 15,
  p_theme_class_id => 2,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34038730989929870 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/bracketed_region
prompt  ......region template 34038855332929870
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t15BracketedRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'    <td class="t15RegionHeader">#TITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'    <td class="t15Bracket"><table summary=""><tr><td class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr><td class="t15Body">#B';

t:=t||'ODY#</td></tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34038855332929870 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Bracketed Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 18,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34038855332929870 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/breadcrumb_region
prompt  ......region template 34038947853929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div id="#REGION_ID#" class="t15breadcrumb">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34038947853929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Breadcrumb Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 6,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34038947853929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/list_region_with_icon_chart_list
prompt  ......region template 34039026763929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t15ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15RegionHeader">#TITLE#</td>'||chr(10)||
''||chr(10)||
'<td align="right" class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td></tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summ';

t:=t||'ary="" ><tr><td valign="top"><img src="#IMAGE_PREFIX#themes/theme_15/monitor_icons_graph.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039026763929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'List Region with Icon - Chart List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 15,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039026763929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_title
prompt  ......region template 34039127446929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table summary="" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td align="right">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td align="left" class="t15instructiontext">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039127446929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 11,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039127446929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region
prompt  ......region template 34039228025929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="t15WizardRegion" id="#REGION_ID#" summary="">'||chr(10)||
'<thead class="t15RegionHeader">'||chr(10)||
'<tr>'||chr(10)||
'<th class="t15RegionTitle">#TITLE#</th>'||chr(10)||
'<td align="right" class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</thead>'||chr(10)||
'<tbody>'||chr(10)||
'<tr><td colspan="2" class="t15Body">#BODY#</td></tr>'||chr(10)||
'</tbody>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039228025929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039228025929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region_alternative_1
prompt  ......region template 34039325180929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t15NavigationRegionAlternative1" id="#REGION_ID#"><h2 class="t15RegionHeader">#TITLE#</h2><div class="t15Body">#BODY#<img src="#IMAGE_PREFIX#1px_trans.gif" width="200" height="1" alt="" class="vsp" /></div></div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039325180929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region, Alternative 1',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 16,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039325180929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_buttons_and_titles
prompt  ......region template 34039441030929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table summary="" cellpadding="0" cellspacing="0" border="0" class="t15RegionwithoutButtonsandTitles" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
''||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039441030929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Buttons and Titles',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 19,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039441030929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region
prompt  ......region template 34039539107929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table width="100%" border="0" cellspacing="0" cellpadding="0" id="#REGION_ID#" class="t15ReportsRegion" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td valign="bottom" class="t15RegionHeader">#TITLE#</td>'||chr(10)||
'<td align="right" class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td></tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="2" valign="top" class="t15Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'';

t:=t||'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039539107929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 9,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039539107929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_region
prompt  ......region template 34039626797929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t15ChartRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15RegionHeader">#TITLE#</td>'||chr(10)||
'<td align="right" class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td></tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039626797929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 15,
  p_theme_class_id => 30,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039626797929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/list_region_with_icon_report_list
prompt  ......region template 34039745078929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t15ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15RegionHeader">#TITLE#</td>'||chr(10)||
''||chr(10)||
'<td align="right" class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td></tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summ';

t:=t||'ary="" ><tr>'||chr(10)||
'<td valign="top"><img src="#IMAGE_PREFIX#themes/theme_15/provisioning_reports.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039745078929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'List Region with Icon - Report List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 15,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039745078929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/hide_and_show_region
prompt  ......region template 34039825591929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t15HideandShowRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15RegionHeader"><a style="margin-left:5px;" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#themes/theme_15/rollup_plus_dgray.gif'',''#IMAGE_PR';

t:=t||'EFIX#themes/theme_15/rollup_minus_dgray.gif'');" class="t15HideandShowRegionLink"><img src="#IMAGE_PREFIX#themes/theme_15/rollup_plus_dgray.gif" '||chr(10)||
'  id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a>#TITLE#</td>'||chr(10)||
'<td class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15Body"><div class=';

t:=t||'"t15Hide" id="region#REGION_SEQUENCE_ID#">#BODY#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039825591929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Hide and Show Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 1,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Gray Head, white body');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039825591929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region_with_icon
prompt  ......region template 34039949005929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="t15WizardRegion" id="#REGION_ID#" summary="">'||chr(10)||
'<thead class="t15RegionHeader">'||chr(10)||
'<tr>'||chr(10)||
'<th class="t15RegionTitle">#TITLE#</th>'||chr(10)||
'<td align="right" class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</thead>'||chr(10)||
'<tbody>'||chr(10)||
'<tr><td colspan="2" class="t15Body">#BODY#</td></tr>'||chr(10)||
'</tbody>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34039949005929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region with Icon',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 20,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34039949005929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_100_width
prompt  ......region template 34040050411929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" width="100%" class="t15ReportsRegion100Width" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15RegionHeader">#TITLE#</td>'||chr(10)||
'<td align="right" class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34040050411929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region 100% Width',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 15,
  p_theme_class_id => 13,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34040050411929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/form_region
prompt  ......region template 34040148901929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="t15FormRegion" cellspacing="0"  border="0" summary="layout" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15RegionHeader">#TITLE#</td>'||chr(10)||
'<td align="right" class="t15ButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr class="t15Body">'||chr(10)||
'<td colspan="2" class="t15Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34040148901929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Form Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 8,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34040148901929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_alternative_1
prompt  ......region template 34040238217929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t15ReportsRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td></tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34040238217929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region, Alternative 1',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 15,
  p_theme_class_id => 10,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34040238217929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_with_title
prompt  ......region template 34040329109929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t15ButtonRegionwithTitle" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15RegionHeader">#TITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>#BODY#';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 34040329109929871 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region with Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 15,
  p_theme_class_id => 4,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 34040329109929871 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_randleiste_alternative_1
prompt  ......region template 439671386687977791
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionRandleiste" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 439671386687977791 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Randleiste, Alternative 1',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 101,
  p_theme_class_id => 3,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 439671386687977791 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_wizard_assistent_mit_icon
prompt  ......region template 439674607689990101
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionWizard" id="#REGION_ID#" summary="">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiHeader">#TITLE#</td>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE#&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td colspan="2" class="AudiBody">'||chr(10)||
'   <table width="100%" summary="">'||chr(10)||
'    <tr>'||chr(10)||
'      <td><img src="#IMAGE_PREFIX#themes/theme_12/WizardIcon.gif" alt="" />&nbsp;</td>'||chr(10)||
'      <';

t:=t||'td>#BODY#</td>'||chr(10)||
'    </tr>'||chr(10)||
'   </table>'||chr(10)||
'  </td>'||chr(10)||
' </tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 439674607689990101 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Wizard (Assistent) (mit Icon)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 20,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 439674607689990101 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_ohne_titel_und_mit_buttons
prompt  ......region template 439685895817081890
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionUniversal" id="#REGION_ID#" summary="">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 439685895817081890 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region ohne Titel und mit Buttons',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 17,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 439685895817081890 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_bericht
prompt  ......region template 439690681454123642
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionUniversal" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 439690681454123642 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Bericht',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 9,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 439690681454123642 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_ohne_titel_und_mit_buttons_unten
prompt  ......region template 439693693077153851
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionUniversal" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 439693693077153851 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region ohne Titel und mit Buttons unten',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 11,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 439693693077153851 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_diagramm
prompt  ......region template 439703189505183150
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionUniversal" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 439703189505183150 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Diagramm',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 30,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 439703189505183150 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_bericht_100_breite
prompt  ......region template 439707392416209634
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionUniversal" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 439707392416209634 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Bericht (100% Breite)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 13,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 439707392416209634 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_infobox
prompt  ......region template 442239604901204495
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div style="width:100%;text-align:center;padding-right:5px;">'||chr(10)||
' <table class="AudiRegionInfobox" id="#REGION_ID#" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="AudiHeader">#TITLE#</td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="AudiBody"><img src="#IMAGE_PREFIX#FNDINFSM.gif" alt="" style="float:left; margin-right:20px;margin-bottom:10px" />#BODY#</td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'   <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DEL';

t:=t||'ETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'  </tr>'||chr(10)||
' </table>'||chr(10)||
'</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 442239604901204495 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Infobox',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 101,
  p_theme_class_id => 22,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 442239604901204495 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_hinweis
prompt  ......region template 442554696182546061
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionHinweis" id="#REGION_ID#" summary="">'||chr(10)||
' <tr>'||chr(10)||
'   <td class="AudiBody"><span style="font-weight:bold">Hinweis: </span>&nbsp;#BODY#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 442554696182546061 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Hinweis',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 101,
  p_theme_class_id => 21,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 442554696182546061 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_max_570_mit_titel
prompt  ......region template 444440401785009607
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionUniversal" id="#REGION_ID#" style="width:570px;padding-right:30px">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 444440401785009607 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region MAX 570 mit Titel',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 25,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 444440401785009607 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_max_370_mit_titel
prompt  ......region template 444444910760036082
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" class="AudiRegionUniversal" id="#REGION_ID#" style="width:370px">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiBody">#BODY#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 444444910760036082 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region MAX 370 mit Titel',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 23,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 444444910760036082 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_mit_titel_und_mit_buttons_unten
prompt  ......region template 444476992248547167
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionUniversal" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 444476992248547167 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region mit Titel und mit Buttons unten',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 7,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 444476992248547167 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_mit_rahmen_f¿r_tab_reiter
prompt  ......region template 444766481713515125
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" class="AudiRegionTabReiter" id="#REGION_ID#" summary="">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiBody">#BODY#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 444766481713515125 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region mit Rahmen f¿r Tab-Reiter',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 101,
  p_theme_class_id => 8,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 444766481713515125 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_mit_titel_und_mit_buttons
prompt  ......region template 445470003442667631
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionUniversal" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 445470003442667631 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region mit Titel und mit Buttons',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 4,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 445470003442667631 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_wizard_assistent_mit_titel_mit_buttons
prompt  ......region template 446845331948172966
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionWizard" id="#REGION_ID#" summary="">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiHeader">#TITLE#</td>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE#&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
' <td colspan="2" class="AudiBody">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446845331948172966 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Wizard (Assistent) (mit Titel, mit Buttons)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446845331948172966 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_mit_rahmen_und_mit_titelbalken
prompt  ......region template 446845445735172967
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiFormularRegion" id="#REGION_ID#" summary="">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiHeader">#TITLE#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiBody">#BODY#</td>'||chr(10)||
' </tr>'||chr(10)||
'<!-- <tr>'||chr(10)||
'  <td><img src="#IMAGE_PREFIX#themes/theme_12/t.gif" width="400" height="1"></td>'||chr(10)||
' </tr> -->'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446845445735172967 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region mit Rahmen und mit Titelbalken',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 101,
  p_theme_class_id => 8,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446845445735172967 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_randleiste
prompt  ......region template 446845525642172967
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionRandleiste" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446845525642172967 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Randleiste',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 101,
  p_theme_class_id => 2,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446845525642172967 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_mit_doppeltem_horizontalen_rahmen
prompt  ......region template 446845727671172967
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionMitHorizontalemRahmen" id="#REGION_ID#" summary="">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiHeader">#TITLE#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiBody">#BODY#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446845727671172967 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region mit doppeltem horizontalen Rahmen',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 101,
  p_theme_class_id => 10,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446845727671172967 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_navigation_mit_titel_ohne_buttons
prompt  ......region template 446845832549172968
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionNavigation1" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446845832549172968 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Navigation (mit Titel, ohne Buttons)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 16,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446845832549172968 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_mit_report_icon
prompt  ......region template 446845924380172968
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionMitIcon" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td>'||chr(10)||
'   <table cellspacing="0" cellpadding="0" width="100%">'||chr(10)||
'    <tr>'||chr(10)||
'     <td style="vertical-align:top"><img src="#IMAGE_PREFIX#themes/theme_12/provisioning_reports.gif" alt';

t:=t||'="" width="75" height="57" /></td><td class="AudiBody">#BODY#</td>'||chr(10)||
'    </tr>'||chr(10)||
'   </table>'||chr(10)||
'  </td>'||chr(10)||
' </tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446845924380172968 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region mit Report-Icon',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 101,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446845924380172968 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_hinweispfad_breadcrumb
prompt  ......region template 446846240200172969
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="AudiBreadcrumbRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446846240200172969 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Hinweispfad (breadcrumb)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 6,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446846240200172969 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_navigation_ohne_titel_mit_buttons
prompt  ......region template 446846333224172969
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionNavigation" id="#REGION_ID#" summary="">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446846333224172969 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Navigation (ohne Titel, mit Buttons)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446846333224172969 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_chart_liste
prompt  ......region template 446846948079172971
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionMitIcon" id="#REGION_ID#" summary="">'||chr(10)||
'<tr><td colspan="2" class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
'<tr><td colspan="2" class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td></tr>'||chr(10)||
'<tr>'||chr(10)||
'  <td valign="top"><span class="chart-gif">&nbsp;</span></td>'||chr(10)||
'  <td valign="top" class="AudiBody">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446846948079172971 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Chart Liste',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 101,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446846948079172971 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_mit_klammer_mit_titel_mit_buttons_unten
prompt  ......region template 446847145242172971
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionKlammer" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td align="center">'||chr(10)||
'   <table width="100%" class="AudiButtonHolder" summary="">'||chr(10)||
'    <tr><td><br /></td></tr>'||chr(10)||
'   </table>'||chr(10)||
'  </td>'||chr(10)||
' </tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
' <tr><td class="AudiBody">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td></tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446847145242172971 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region mit Klammer (mit Titel, mit Buttons unten)',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 101,
  p_theme_class_id => 18,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446847145242172971 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_hide_show
prompt  ......region template 446847231106172971
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table width="100%" cellpadding="0" cellspacing="0" border="0"  class="AudiRegionHideAndShow" id="#REGION_ID#" summary="">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiHeader">#TITLE# <a style="padding-left:10px" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif'',''#IMAGE_PREFIX#htmldb/builder/rollup_minus_dgray.gif'');" class="htmldbHid';

t:=t||'eShowMinLink"><img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" align"left center" id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a></td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td>'||chr(10)||
'   <div class="AudiHide" id="region#REGION_SEQUENCE_ID#">'||chr(10)||
'    <div class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</div>'||chr(10)||
'    <div class="AudiBody">#BODY#</div>'||chr(10)||
'   </div>'||chr(10)||
'  </td>'||chr(10)||
' </tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446847231106172971 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region Hide/Show',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446847231106172971 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_mit_info_icon
prompt  ......region template 446847344251172972
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionMitIcon" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiHeader">#TITLE#</td></tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td valign="top" class="AudiBody"><img src="#IMAGE_PREFIX#fb_new.gif" alt="" style="float:left; margin-right:20px;margin-bottom:10px" />#BODY#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 446847344251172972 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region mit Info-Icon',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 101,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 446847344251172972 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_ohne_titel_und_ohne_buttons
prompt  ......region template 447023949857222082
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table  cellpadding="0" cellspacing="0" width="100%" class="AudiRegionUniversal" id="#REGION_ID#" summary="">'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 447023949857222082 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region ohne Titel und ohne Buttons',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 19,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 447023949857222082 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_max_370_ohne_titel
prompt  ......region template 447099540440976752
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" class="AudiRegionUniversal" id="#REGION_ID#" style="width:370px">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiBody">#BODY#</td>'||chr(10)||
' </tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 447099540440976752 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region MAX 370 ohne Titel',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 24,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 447099540440976752 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/audi_region_max_570_ohne_titel
prompt  ......region template 447110030489043906
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="AudiRegionUniversal" id="#REGION_ID#" style="width:570px;padding-right:30px">'||chr(10)||
' <tr>'||chr(10)||
'  <td class="AudiButtonHolder">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr><td class="AudiBody">#BODY#</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 447110030489043906 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Audi Region MAX 570 ohne Titel',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 26,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 447110030489043906 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/dhtml_menu_with_sublist
prompt  ......list template 34040441907929871
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t6:=t6||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#themes/theme_13/menu_open_right.gif" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#themes/theme_13/menu_open_right.gif" /></a></li>';

wwv_flow_api.create_list_template (
  p_id=>34040441907929871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Menu with Sublist',
  p_theme_id  => 15,
  p_theme_class_id => 20,
  p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_tree
prompt  ......list template 34040557710929881
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  alt="" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" /><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" alt="" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" /><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>34040557710929881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Tree',
  p_theme_id  => 15,
  p_theme_class_id => 22,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist
prompt  ......list template 34040655630929881
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t2:=t2||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t3:=t3||'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t6:=t6||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>';

wwv_flow_api.create_list_template (
  p_id=>34040655630929881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML List (Image) with Sublist',
  p_theme_id  => 15,
  p_theme_class_id => 21,
  p_list_template_before_rows=>'<div class="dhtmlMenuLG">',
  p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_without_bullet
prompt  ......list template 34040749501929881
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t15current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34040749501929881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List without Bullet',
  p_theme_id  => 15,
  p_theme_class_id => 18,
  p_list_template_before_rows=>'<ul class="t15VerticalUnorderedListwithoutBullet">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_images_with_label_list
prompt  ......list template 34040857481929881
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="t15current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" /><br />#TEXT#</td>';

t2:=t2||'<td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" /></a><br /><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34040857481929881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Images with Label List',
  p_theme_id  => 15,
  p_theme_class_id => 4,
  p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="t15HorizontalImageswithLabelList" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_links_list
prompt  ......list template 34040939821929881
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t15Current">&gt;#TEXT#&lt;</a>';

t2:=t2||'<a href="#LINK#">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34040939821929881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Links List',
  p_theme_id  => 15,
  p_theme_class_id => 3,
  p_list_template_before_rows=>'<div class="t15HorizontalLinksList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_images_list
prompt  ......list template 34041033477929882
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="t15current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" /></td></tr>';

t2:=t2||'<tr><td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" /></a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34041033477929882 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Images List',
  p_theme_id  => 15,
  p_theme_class_id => 5,
  p_list_template_before_rows=>'<table cellpadding="0" cellspacing="0" border="0" summary="0" class="t15VerticalImagesList">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_ordered_list
prompt  ......list template 34041126913929884
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t15current"><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34041126913929884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Ordered List',
  p_theme_id  => 15,
  p_theme_class_id => 2,
  p_list_template_before_rows=>'<ol class="t15VerticalOrderedList">',
  p_list_template_after_rows=>'</ol>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/tabbed_navigation_list
prompt  ......list template 34041231964929884
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td valign="bottom" class="t15SepL"><img src="#IMAGE_PREFIX#themes/theme_15/tab_list_left_cap.gif" /></td>'||chr(10)||
'<td class="t15CurrentListTab"><a class="t15CurrentListTab" href="#LINK#">#TEXT#</a></td>'||chr(10)||
'<td valign="bottom" class="t15SepR"><img src="#IMAGE_PREFIX#themes/theme_15/tab_list_right_cap.gif" /></td>';

t2:=t2||'<td><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34041231964929884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Tabbed Navigation List',
  p_theme_id  => 15,
  p_theme_class_id => 7,
  p_list_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0"  summary="" width="100%" class="t15TabbedNavigationList"><tbody><tr><td class="t15LeftTabList">&nbsp;&nbsp;&nbsp;&nbsp;</td>',
  p_list_template_after_rows=>'<td class="t14EndCap" width="100%">&nbsp;</td></tr></tbody></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
prompt  ......list template 34041325458929884
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34041325458929884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List with Bullets',
  p_theme_id  => 15,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="t15noIndent">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/button_list
prompt  ......list template 34041453932929884
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<table class="t15Button" cellspacing="0" cellpadding="0" border="0"  summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15L"><img src="#IMAGE_PREFIX#themes/theme_15/button-l.gif" alt="" /></td>'||chr(10)||
'<td class="t15C"><a href="#LINK#" style="font-weight:bold;">>#TEXT#<</a></td>'||chr(10)||
'<td class="t15R"><img src="#IMAGE_PREFIX#themes/theme_15/button-r.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2:=t2||'<table class="t15Button" cellspacing="0" cellpadding="0" border="0"  summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t15L"><img src="#IMAGE_PREFIX#themes/theme_15/button-l.gif" alt="" /></td>'||chr(10)||
'<td class="t15C"><a href="#LINK#">#TEXT#</a></td>'||chr(10)||
'<td class="t15R"><img src="#IMAGE_PREFIX#themes/theme_15/button-r.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34041453932929884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Button List',
  p_theme_id  => 15,
  p_theme_class_id => 6,
  p_list_template_before_rows=>'<div class="t15ButtonList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/wizard_progress_list
prompt  ......list template 34041553691929884
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="t15Current">#TEXT#</td></tr>'||chr(10)||
'<tr><td class="t15CurrentImage"><img src="#IMAGE_PREFIX#arrow_down.gif" width="7" height="6" alt="" /></td></tr>';

t2:=t2||'<tr><td>#TEXT#</td></tr>'||chr(10)||
'<tr><td class="t15Image"><img src="#IMAGE_PREFIX#arrow_down.gif" width="7" height="6" alt="" /></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34041553691929884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Wizard Progress List',
  p_theme_id  => 15,
  p_theme_class_id => 17,
  p_list_template_before_rows=>'<table class="t15WizardProgressList" cellpadding="0" cellspacing="0" border="0" summary="">',
  p_list_template_after_rows=>'<tr><td align="center">Done</td></tr>'||chr(10)||
'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/tree_list
prompt  ......list template 34041628729929884
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>34041628729929884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Tree List',
  p_theme_id  => 15,
  p_theme_class_id => 23,
  p_list_template_before_rows=>'<ul class="htmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_sidebar_list
prompt  ......list template 34041741499929884
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#" class="t15Current">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>34041741499929884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Sidebar List',
  p_theme_id  => 15,
  p_theme_class_id => 19,
  p_list_template_before_rows=>'<ul class="t15VerticalSidebarList">'||chr(10)||
'',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_vertikale_randleistenliste
prompt  ......list template 439717799620675308
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td><a class="audi-aktuell" href="#LINK#">#TEXT#</a></td></tr>';

t2:=t2||'<tr><td><a class="audi-nicht-aktuell" href="#LINK#">#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>439717799620675308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi vertikale Randleistenliste',
  p_theme_id  => 101,
  p_theme_class_id => 19,
  p_list_template_before_rows=>'<table class="audi-vertikale-liste" cellpadding="0" cellspacing="0" width="100%" summary="">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_horizontale_liste_mit_jumper
prompt  ......list template 444200006493720110
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="audi-aktuell"></td><td><a href="#LINK#">#TEXT#</a></td>'||chr(10)||
'';

t2:=t2||'<td class="audi-nicht-aktuell"></td><td><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>444200006493720110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi horizontale Liste mit Jumper',
  p_theme_id  => 101,
  p_theme_class_id => 3,
  p_list_template_before_rows=>'<table class="audi-horizontale-liste" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_button_liste
prompt  ......list template 446847429028172972
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="AudiButton">#TEXT#</a>';

t2:=t2||'<a href="#LINK#" class="AudiButton">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>446847429028172972 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi Button-Liste',
  p_theme_id  => 101,
  p_theme_class_id => 6,
  p_list_template_before_rows=>'<div class="audi-button-liste">',
  p_list_template_after_rows=>'</div><br />',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_horizontale_liste_mit_icons
prompt  ......list template 446847531624172972
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="audi-aktuell"><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" border="0" #IMAGE_ATTR#/></a><br /><a href="#LINK#">#TEXT#</a></td>';

t2:=t2||'<td class="audi-nicht-aktuell"><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" border="0" #IMAGE_ATTR#/></a><br /><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>446847531624172972 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi horizontale Liste mit Icons',
  p_theme_id  => 101,
  p_theme_class_id => 4,
  p_list_template_before_rows=>'<table class="audi-horizontale-liste-icons" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_vertikale_bild_liste
prompt  ......list template 446847649749172973
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td align="center" class="audi-aktuell"><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a></td></tr>';

t2:=t2||'<tr><td align="center" class="audi-nicht-aktuell"><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>446847649749172973 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi vertikale Bild-Liste',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_list_template_before_rows=>'<table class="audi-vertikale-liste-icons" summary="">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_vertikale_liste_nummeriert
prompt  ......list template 446847723296172973
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a class="audi-aktuell" href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>446847723296172973 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi vertikale Liste (nummeriert)',
  p_theme_id  => 101,
  p_theme_class_id => 2,
  p_list_template_before_rows=>'<ol class="audi-vertikale-liste-nummeriert">',
  p_list_template_after_rows=>'</ol>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_fortschrittsanzeige
prompt  ......list template 446848036122172974
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<img src="#IMAGE_PREFIX#themes/theme_12/WizardDownArrow.gif" width="7" height="12" alt="Down" /><br />'||chr(10)||
'<div class="aktuell">#TEXT#</div>';

t2:=t2||'<img src="#IMAGE_PREFIX#themes/theme_12/WizardDownArrow.gif" width="7" height="12" alt="Down" /><br />'||chr(10)||
'<div class="nicht-aktuell">#TEXT#</div>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>446848036122172974 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi Fortschrittsanzeige',
  p_theme_id  => 101,
  p_theme_class_id => 17,
  p_list_template_before_rows=>'<div class="audi-liste-fortschritt">'||chr(10)||
'<div class="nicht-aktuell">Start</div>',
  p_list_template_after_rows=>'<div style="padding-top:10px">&DONE.</div>'||chr(10)||
'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_vertikale_liste_ohne_aufz¿ungszeichen
prompt  ......list template 446848147062172975
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td><a class="audi-aktuell" href="#LINK#">#TEXT#</a></td></tr>';

t2:=t2||'<tr><td><a href="#LINK#">#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>446848147062172975 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi vertikale Liste ohne Aufz¿ungszeichen',
  p_theme_id  => 101,
  p_theme_class_id => 18,
  p_list_template_before_rows=>'<table class="audi-vertikale-liste-ohne-bullets" summary="">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_navigationsliste_mit_tab_reiter
prompt  ......list template 446848351509172976
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td style="background-color:#5e5e5e;padding-right:0px"><img src="#IMAGE_PREFIX#audi/funktionselemente/slant.gif" alt="" /></td>'||chr(10)||
'<td style="background-color:#5e5e5e;padding-right:0px"><a class="audi-aktuell" href="#LINK#">#TEXT#</a></td>'||chr(10)||
'<td style="background-color:#5e5e5e;padding-right:0px"><img src="#IMAGE_PREFIX#audi/funktionselemente/rightcurve.gif" alt="" /></td>';

t2:=t2||'<td style="padding-right:0px"><img src="#IMAGE_PREFIX#audi/funktionselemente/slant.gif" alt="" /></td>'||chr(10)||
'<td style="padding-right:0px"><a class="audi-nicht-aktuell" href="#LINK#">#TEXT#</a></td>'||chr(10)||
'<td style="padding-right:0px"><img src="#IMAGE_PREFIX#audi/funktionselemente/rightcurve.gif" alt="" /></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>446848351509172976 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi Navigationsliste mit Tab-Reiter',
  p_theme_id  => 101,
  p_theme_class_id => 7,
  p_list_template_before_rows=>'<table class="audi-liste-tabreiter" cellspacing="0" cellpadding="0" summary=""><tr style="background-color:#9FA796;height:15px;">',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/audi_vertikale_liste_mit_jumper
prompt  ......list template 447051837019414091
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="audi-aktuell"><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li class="audi-nicht-aktuell"><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>447051837019414091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Audi vertikale Liste mit Jumper',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<div class="audi-vertikale-liste"><ul>',
  p_list_template_after_rows=>'</ul></div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
--application/shared_components/user_interface/templates/report/standard_report
prompt  ......report template 34041847879929884
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="t15data" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 34041847879929884 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard Report',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table class="t15standard" summary="Report">',
  p_row_template_after_rows =>'<tr>'||chr(10)||
'    <td colspan="99" class="t15afterrows">'||chr(10)||
'        <span class="left">#EXTERNAL_LINK##CSV_LINK#</span>'||chr(10)||
'        <table style="float:right;text-align:right;" summary="pagination">#PAGINATION#</table>'||chr(10)||
'    </td>'||chr(10)||
'</tr></table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t15header" #ALIGNMENT#>#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_row_style_mouse_over=>'#cfe0f1',
  p_row_style_checked=>'#cfe0f1',
  p_theme_id  => 15,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 34041847879929884 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/borderless
prompt  ......report template 34041936374929892
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t15data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 34041936374929892 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Borderless',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr><td><table class="t15borderless" cellpadding="0" border="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'#PAGINATION#'||chr(10)||
'</table><span class="left">#EXTERNAL_LINK##CSV_LINK#</span></td></tr></table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t15header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_row_style_mouse_over=>'#cfe0f1',
  p_row_style_checked=>'#cfe0f1',
  p_theme_id  => 15,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_row_template_comment=> '.t1reportborderless{ }'||chr(10)||
'.t1reportborderless .t1reportheader{ }'||chr(10)||
'.t1reportborderless .t1reportdata{ }');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 34041936374929892 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/horizontal_border
prompt  ......report template 34042043184929892
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t15data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 34042043184929892 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Horizontal Border',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" border="0" class="t15horizontalborder" summary="">',
  p_row_template_after_rows =>'<tr>'||chr(10)||
'    <td colspan="99" class="t15afterrows">'||chr(10)||
'        <span class="left">#EXTERNAL_LINK##CSV_LINK#</span>'||chr(10)||
'        <table style="float:right;text-align:right;" summary="pagination"><tr><td></td></tr>#PAGINATION#</table>'||chr(10)||
'    </td>'||chr(10)||
'</tr></table></td></tr></table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t15header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_row_style_mouse_over=>'#cfe0f1',
  p_row_style_checked=>'#cfe0f1',
  p_theme_id  => 15,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 34042043184929892 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/value_attribute_pairs
prompt  ......report template 34042145523929892
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<tr><th class="t15header">#COLUMN_HEADER#</th><td class="t15data">#COLUMN_VALUE#</td></tr>'||chr(10)||
'';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 34042145523929892 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Value Attribute Pairs',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table cellpadding="0" cellspacing="0" border="0" summary="" class="t15ValueAttributePairs">',
  p_row_template_after_rows =>'</table>#EXTERNAL_LINK#</td></tr>#PAGINATION#</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_theme_id  => 15,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 34042145523929892 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'<tr><td colspan="2" class="t15seperate"><hr /></td></tr>'||chr(10)||
'');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_report_with_alt_row_colors
prompt  ......report template 34042236847929892
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="t15data"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="t15dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c3:=c3||'<td bgcolor="red" class="alt"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 34042236847929892 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard Report (with alt row colors)',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table class="t15standardalternatingrowcolors" cellpadding="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'<tr>'||chr(10)||
'    <td colspan="99" class="t15afterrows">'||chr(10)||
'        <span class="left">#EXTERNAL_LINK##CSV_LINK#</span>'||chr(10)||
'        <table style="float:right;text-align:right;" summary="pagination">#PAGINATION#</table>'||chr(10)||
'    </td>'||chr(10)||
'</tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t15header" #ALIGNMENT#>#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'EVEN_ROW_NUMBERS',
  p_row_template_display_cond2=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'EVEN_ROW_NUMBERS',
  p_row_style_mouse_over=>'#cfe0f1',
  p_row_style_checked=>'#cfe0f1',
  p_theme_id  => 15,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 34042236847929892 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/one_column_unordered_list
prompt  ......report template 34042343729929892
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<li>#COLUMN_VALUE#</li>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 34042343729929892 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'One Column Unordered List',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><ul class="t1OneColumnUnorderedList">',
  p_row_template_after_rows =>'</ul>#EXTERNAL_LINK##CSV_LINK#</td></tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'NOT_CONDITIONAL',
  p_row_template_display_cond2=>'NOT_CONDITIONAL',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'NOT_CONDITIONAL',
  p_theme_id  => 15,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 34042343729929892 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'OMIT');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_report_ppr
prompt  ......report template 34042451079929892
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="t15data" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 34042451079929892 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard Report (PPR)',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table summary="" border="0" cellpadding="0" border="0"><tr><td colspan="2"><table class="t15standard" summary="" border="0" cellpadding="0" border="0">',
  p_row_template_after_rows =>'</tr></table></td></tr>'||chr(10)||
'<tr>'||chr(10)||
'	<td valign="top">#EXTERNAL_LINK##CSV_LINK#</td>'||chr(10)||
'	<td valign="top" align="right"><table summary="" align="right">#PAGINATION#</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
''||chr(10)||
'<script language=JavaScript type=text/javascript>'||chr(10)||
'<!--'||chr(10)||
'init_htmlPPRReport(''#REGION_ID#'');'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>'||chr(10)||
'</htmldb:#REGION_ID#>'||chr(10)||
'</div>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t15header" #ALIGNMENT#>#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="/i/jtfunexe.gif" alt="" /></a>',
  p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="/i/jtfupree.gif" alt=""/></a>',
  p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="/i/jtfunexe.gif" alt="" /></a>',
  p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="/i/jtfupree.gif" alt=""/></a>',
  p_row_style_mouse_over=>'#cfe0f1',
  p_row_style_checked=>'#cfe0f1',
  p_theme_id  => 15,
  p_theme_class_id => 7,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 34042451079929892 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_rahmen_und_zeilenumbruch
prompt  ......report template 436451687028432854
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" style="white-space:normal" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 436451687028432854 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit Rahmen und Zeilenumbruch',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="audi-rahmen">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="audi-bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header" #ALIGNMENT#>#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 436451687028432854 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_horizontalem_rand_und_zeilenumbruch
prompt  ......report template 436451872396432855
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" style="white-space:normal" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 436451872396432855 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit horizontalem Rand und Zeilenumbruch',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div class="audi-contentcollapse"><table cellpadding="0" border="0" cellspacing="0" summary="" width="100%">#TOP_PAGINATION#</table><table class="audi-nur-rand-unten" border="0" cellpadding="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'#PAGINATION#'||chr(10)||
'<tr><td class="audi-bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header"  id="#COLUMN_HEADER_NAME#" #ALIGNMENT#>#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 436451872396432855 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_ohne_rahmen_mit_zeilenumbruch
prompt  ......report template 436452191199432855
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" style="white-space:normal" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 436452191199432855 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht ohne Rahmen mit Zeilenumbruch',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="audi-rahmenloas">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="audi-bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header" #ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 436452191199432855 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_alternierender_zeilenfarbe_und_zeilenumbruch
prompt  ......report template 436452686921432857
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" style="white-space:normal" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="audi-data-alt" style="white-space:normal" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 436452686921432857 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit alternierender Zeilenfarbe und Zeilenumbruch',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" class="audi-standard-alt-zeilenfarbe">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="t12bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'EVEN_ROW_NUMBERS',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 436452686921432857 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_heller_zeilenfarbe
prompt  ......report template 436582772783505087
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="audi-data" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 436582772783505087 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit heller Zeilenfarbe',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" class="audi-standard-alt-zeilenfarbe">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="t12bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'EVEN_ROW_NUMBERS',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 436582772783505087 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_heller_zeilenfarbe_und_zeilenumbruch
prompt  ......report template 436582990811505087
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" style="white-space:normal" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="audi-data" style="white-space:normal" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 436582990811505087 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit heller Zeilenfarbe und Zeilenumbruch',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" class="audi-standard-alt-zeilenfarbe">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="t12bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'EVEN_ROW_NUMBERS',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 436582990811505087 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_heller_zeilenfarbe_und_leerzeile
prompt  ......report template 436586399803539209
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="audi-data" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 436586399803539209 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit heller Zeilenfarbe und Leerzeile',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" class="audi-standard-alt-zeilenfarbe">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="t12bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'EVEN_ROW_NUMBERS',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 436586399803539209 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'<tr><td></td></tr></tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_heller_zeilenfarbe_zeilenumbruch_und_leerzeile
prompt  ......report template 436586574268539209
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" style="white-space:normal" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="audi-data" style="white-space:normal" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 436586574268539209 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit heller Zeilenfarbe, Zeilenumbruch und Leerzeile',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" class="audi-standard-alt-zeilenfarbe">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="t12bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'EVEN_ROW_NUMBERS',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 436586574268539209 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'<tr><td></td></tr></tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_ohne_rahmen
prompt  ......report template 446848447566172976
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 446848447566172976 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht ohne Rahmen',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="audi-rahmenloas">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="audi-bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header" #ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_row_style_checked=>'#6CAAD9',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 446848447566172976 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/value_attribute_pairs
prompt  ......report template 446848546984172977
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<tr><th class="t12header">#COLUMN_HEADER#</th><td class="t12data">#COLUMN_VALUE#</td></tr>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 446848546984172977 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Value Attribute Pairs',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t12valueattributepairs">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="t12bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'<span class="t12Pagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_12/NextPage.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_12/PreviousPage.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_12/NextSet.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_12/PreviousSet.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 446848546984172977 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'<tr><td colspan="2">&nbsp;</td></tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_horizontalem_rand
prompt  ......report template 446848633322172977
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 446848633322172977 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit horizontalem Rand',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div class="audi-contentcollapse"><table cellpadding="0" border="0" cellspacing="0" summary="" width="100%">#TOP_PAGINATION#</table><table class="audi-nur-rand-unten" border="0" cellpadding="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'#PAGINATION#'||chr(10)||
'<tr><td class="audi-bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header"  id="#COLUMN_HEADER_NAME#" #ALIGNMENT#>#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_row_style_checked=>'#6CAAD9',
  p_theme_id  => 101,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 446848633322172977 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/one_column_unordered_list
prompt  ......report template 446848731530172977
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<li>#COLUMN_VALUE#</li>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 446848731530172977 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'One Column Unordered List',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellspacing="0" cellpadding="0" width="100%" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><ul class="t12OneColumnUnorderedList">',
  p_row_template_after_rows =>'</ul></td></tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="t12bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'NOT_CONDITIONAL',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_pagination_template=>'<span class="t12Pagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_12/NextPage.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_12/PreviousPage.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_12/NextSet.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_12/PreviousSet.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_rahmen
prompt  ......report template 446848945189172984
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 446848945189172984 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit Rahmen',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="audi-rahmen">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="audi-bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header" #ALIGNMENT#>#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_row_style_mouse_over=>'#6CAAFF',
  p_row_style_checked=>'#6CAAD9',
  p_theme_id  => 101,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 446848945189172984 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/audi_bericht_mit_alternierender_zeilenfarbe
prompt  ......report template 447030927203611080
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-data" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="audi-data-alt" #ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 447030927203611080 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Audi Bericht mit alternierender Zeilenfarbe',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" class="audi-standard-alt-zeilenfarbe">',
  p_row_template_after_rows =>'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'<tr><td class="t12bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="audi-header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'EVEN_ROW_NUMBERS',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_pagination_template=>'<span class="AudiPagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#"><img src="#WORKSPACE_IMAGES#jumper_grau_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#"><img src="#WORKSPACE_IMAGES#jumper_grau_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#"><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 447030927203611080 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/einspaltige_liste_mit_jumper
prompt  ......report template 447139645532138005
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="audi-jumper"></td><td>#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 447139645532138005 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Einspaltige Liste mit Jumper',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellspacing="0" cellpadding="0" width="100%" style="font-weight:bold">'||chr(10)||
'#TOP_PAGINATION#',
  p_row_template_after_rows =>'</table>'||chr(10)||
'<table>#PAGINATION#</table>'||chr(10)||
''||chr(10)||
'<table><tr><td class="audi-bottom" colspan="99">#CSV_LINK#</td></tr>'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'EVEN_ROW_NUMBERS',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'0',
  p_pagination_template=>'<span class="t12Pagination">#TEXT#</span>',
  p_next_page_template=>'<a href="#LINK#" ><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_rechts.gif"></a>',
  p_previous_page_template=>'<a href="#LINK#" ><img src="#IMAGE_PREFIX#audi/funktionselemente/pfeil_links.gif"></a>',
  p_next_set_template=>'<a href="#LINK#" ><img src="#IMAGE_PREFIX#audi/funktionselemente/set_rechts.gif"></a>',
  p_previous_set_template=>'<a href="#LINK#" ><img src="#IMAGE_PREFIX#audi/funktionselemente/set_links.gif"></a>',
  p_theme_id  => 101,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 447139645532138005 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/no_label
prompt  ......label template 34042554730929893
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 34042554730929893 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'No Label',
  p_template_body1=>'<span class="t15NoLabel">',
  p_template_body2=>'</span>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 15,
  p_theme_class_id => 13,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required
prompt  ......label template 34042653981929904
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 34042653981929904 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><img src="#IMAGE_PREFIX#themes/theme_15/requiredicon_status2.gif" alt="" /><span class="t15required">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 15,
  p_theme_class_id => 4,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required_label_with_help
prompt  ......label template 34042727895929906
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 34042727895929906 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required Label with Help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><img src="#IMAGE_PREFIX#themes/theme_15/requiredicon_status2.gif" alt="" /><a class="t15requiredwithhelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 15,
  p_theme_class_id => 2,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optional
prompt  ......label template 34042826142929906
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 34042826142929906 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><span class="t15Optional">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 15,
  p_theme_class_id => 3,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optional_label_with_help
prompt  ......label template 34042926358929906
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 34042926358929906 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional Label with Help',
  p_template_body1=>'<a class="t15optionalwithhelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 15,
  p_theme_class_id => 1,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/schwaches_label_mit_hilfe
prompt  ......label template 431649566962681131
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 431649566962681131 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Schwaches Label mit Hilfe',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="AudiSchwachesLabelMitHilfe" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/schwaches_label_ohne_hilfe
prompt  ......label template 431650849432685515
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 431650849432685515 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Schwaches Label ohne Hilfe',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><span class="AudiSchwachesLabelOhneHilfe">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 101,
  p_theme_class_id => 3,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/erforderliches_label_mit_hilfe
prompt  ......label template 446849039995172985
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 446849039995172985 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Erforderliches Label mit Hilfe',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><img src="#IMAGE_PREFIX#audi/funktionselemente/required-icon.gif" alt="Erforderliches Feld" /><a class="AudiErforderlichesLabelMitHilfe" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 101,
  p_theme_class_id => 2,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/erforderliches_label_ohne_hilfe
prompt  ......label template 446849131644172985
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 446849131644172985 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Erforderliches Label ohne Hilfe',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><span class="AudiErforderlichesLabelOhneHilfe">',
  p_template_body2=>'</span><img src="#IMAGE_PREFIX#audi/funktionselemente/required-icon.gif" alt="Erforderliches Feld" /></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 101,
  p_theme_class_id => 4,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/kein_label
prompt  ......label template 446849234614172985
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 446849234614172985 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Kein Label',
  p_template_body1=>'<span class="AudiKeinLabel">',
  p_template_body2=>'</span>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 101,
  p_theme_class_id => 13,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optionales_label_ohne_hilfe
prompt  ......label template 446849321355172985
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 446849321355172985 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optionales Label ohne Hilfe',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><span class="AudiOptionalesLabelOhneHilfe">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 101,
  p_theme_class_id => 3,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optionales_label_mit_hilfe
prompt  ......label template 446849435730172985
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 446849435730172985 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optionales Label mit Hilfe',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="AudiOptionalesLabelMitHilfe" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
prompt  ......template 34043033848929906
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 34043033848929906 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Hierarchical Menu',
  p_before_first=>'<ul class="t15HierarchicalMenu">',
  p_current_page_option=>'<li class="t15current"><a href="#LINK#">#NAME#</a></li>',
  p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>',
  p_menu_link_attributes=>'',
  p_between_levels=>'',
  p_after_last=>'</ul>',
  p_max_levels=>11,
  p_start_with_node=>'CHILD_MENU',
  p_theme_id  => 15,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/breadcrumb/breadcrumbs
prompt  ......template 34043156317929917
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 34043156317929917 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Breadcrumbs',
  p_before_first=>'<ul>',
  p_current_page_option=>'<li class="t15Current"><span>#NAME#</span></li>',
  p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>',
  p_menu_link_attributes=>'',
  p_between_levels=>'<li><span>></span></li>',
  p_after_last=>'</ul>',
  p_max_levels=>12,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 15,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
prompt  ......template 446849546423172985
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 446849546423172985 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Hierarchical Menu',
  p_before_first=>'<ul class="t12HierarchicalMenu">',
  p_current_page_option=>'<li><a style="font-weight:bold;" href="#LINK#">#NAME#</a></li>',
  p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>',
  p_menu_link_attributes=>'',
  p_between_levels=>'',
  p_after_last=>'</ul>',
  p_max_levels=>11,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 101,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
prompt  ......template 446849625239172985
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 446849625239172985 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Breadcrumb Menu',
  p_before_first=>'<div class="t12BreadcrumbMenu">',
  p_current_page_option=>'#NAME#',
  p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>',
  p_menu_link_attributes=>'',
  p_between_levels=>'&nbsp;&gt;&nbsp;',
  p_after_last=>'</div>',
  p_max_levels=>12,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 34043825455929926
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 34043825455929926 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif',
  p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'Popup LOV',
  p_page_title=>'Search Dialog',
  p_page_html_head=>'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_15/theme_V2.css" type="text/css" />'||chr(10)||
'',
  p_page_body_attr=>'onload="first_field()" style="margin:0;"',
  p_before_field_text=>'<div class="t15PopupHead">',
  p_page_heading_text=>'',
  p_page_footer_text =>'',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'Search',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'Close',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'Next &gt;',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'&lt; Previous',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'450',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>',
  p_result_rows_per_pg=>500,
  p_before_result_set=>'<div class="t15PopupBody">',
  p_theme_id  => 15,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ......template 446850335130172986
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 446850335130172986 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif',
  p_popup_icon_attr=>'width="13" height="13" alt="Popup Werteliste"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'Search Dialog',
  p_page_html_head=>'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_12/theme.css" type="text/css">'||chr(10)||
'',
  p_page_body_attr=>'OnLoad="first_field()" style="margin:0;"',
  p_before_field_text=>'<div class="t12PopupHead">',
  p_page_heading_text=>'',
  p_page_footer_text =>'',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'Suchen',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'Schliessen',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'Weiter >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< Zur¿ck',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'450',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:0.8em;">Zeile(n) #FIRST_ROW# - #LAST_ROW#</div>',
  p_result_rows_per_pg=>10,
  p_before_result_set=>'<div class="t12PopupBody">',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
--application/shared_components/user_interface/templates/calendar/calendar
prompt  ......template 34043228450929917
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 34043228450929917 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar',
  p_translate_this_template=> 'Y',
  p_day_of_week_format=> '<th class="t15DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t15StandardCalHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t15MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t15StandardCal">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t15DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t15Day" valign="top">',
  p_day_close_format=> '</td><!--CAN YOU SEE THIS? #4-->',
  p_today_open_format=> '<td valign="top" class="t15Today">',
  p_weekend_title_format=> '<div class="t15WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t15WeekendDay">',
  p_weekend_close_format => '</td><!--CAN YOU SEE THIS? #3-->',
  p_nonday_title_format => '<div class="t15NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t15NonDay" valign="top">',
  p_nonday_close_format => '</td><!--CAN YOU SEE THIS? #2-->',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> <!--CAN YOU SEE THIS? #1-->',
  p_daily_title_format => '<th width="14%" class="calheader">#IDAY#</th>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '',
  p_weekly_day_of_week_format => '',
  p_weekly_month_open_format => '',
  p_weekly_month_close_format => '',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '',
  p_weekly_day_close_format => '',
  p_weekly_today_open_format => '',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '',
  p_weekly_weekend_close_format => '',
  p_weekly_time_open_format => '',
  p_weekly_time_close_format => '',
  p_weekly_time_title_format => '',
  p_weekly_hour_open_format => '',
  p_weekly_hour_close_format => '',
  p_daily_day_of_week_format => '',
  p_daily_month_title_format => '',
  p_daily_month_open_format => '',
  p_daily_month_close_format => '',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '',
  p_daily_day_close_format => '',
  p_daily_today_open_format => '',
  p_daily_time_open_format => '',
  p_daily_time_close_format => '',
  p_daily_time_title_format => '',
  p_daily_hour_open_format => '',
  p_daily_hour_close_format => '',
  p_theme_id  => 15,
  p_theme_class_id => 1,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar_alternative_1
prompt  ......template 34043442782929925
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 34043442782929925 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar, Alternative 1',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t15DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t15CalendarAlternative1Holder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t15MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t15CalendarAlternative1">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t15DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t15Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t15Today">',
  p_weekend_title_format=> '<div class="t15WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t15WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t15NonDayTitle">#DD#</div></td>',
  p_nonday_open_format => '<td class="t15NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '',
  p_daily_open_format => '',
  p_daily_close_format => '',
  p_weekly_title_format => '',
  p_weekly_day_of_week_format => '',
  p_weekly_month_open_format => '',
  p_weekly_month_close_format => '',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '',
  p_weekly_day_close_format => '',
  p_weekly_today_open_format => '',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '',
  p_weekly_weekend_close_format => '',
  p_weekly_time_open_format => '',
  p_weekly_time_close_format => '',
  p_weekly_time_title_format => '',
  p_weekly_hour_open_format => '',
  p_weekly_hour_close_format => '',
  p_daily_day_of_week_format => '',
  p_daily_month_title_format => '',
  p_daily_month_open_format => '',
  p_daily_month_close_format => '',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '',
  p_daily_day_close_format => '',
  p_daily_today_open_format => '',
  p_daily_time_open_format => '',
  p_daily_time_close_format => '',
  p_daily_time_title_format => '',
  p_daily_hour_open_format => '',
  p_daily_hour_close_format => '',
  p_theme_id  => 15,
  p_theme_class_id => 2,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/small_calendar
prompt  ......template 34043655286929925
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 34043655286929925 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Small Calendar',
  p_translate_this_template=> 'Y',
  p_day_of_week_format=> '',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t15SmallCalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t15MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t15SmallCalendar">',
  p_month_close_format=> '</tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t15DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t15Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t15Today">',
  p_weekend_title_format=> '<div class="t15WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t15WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t15NonDayTitle">#DD#</div></td>',
  p_nonday_open_format => '<td class="t15NonDay" valign="top">',
  p_nonday_close_format => '',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<th width="14%" class="calheader">#IDAY#</th>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '',
  p_weekly_day_of_week_format => '',
  p_weekly_month_open_format => '',
  p_weekly_month_close_format => '',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '',
  p_weekly_day_close_format => '',
  p_weekly_today_open_format => '',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '',
  p_weekly_weekend_close_format => '',
  p_weekly_time_open_format => '',
  p_weekly_time_close_format => '',
  p_weekly_time_title_format => '',
  p_weekly_hour_open_format => '',
  p_weekly_hour_close_format => '',
  p_daily_day_of_week_format => '',
  p_daily_month_title_format => '',
  p_daily_month_open_format => '',
  p_daily_month_close_format => '',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '',
  p_daily_day_close_format => '',
  p_daily_today_open_format => '',
  p_daily_time_open_format => '',
  p_daily_time_close_format => '',
  p_daily_time_title_format => '',
  p_daily_hour_open_format => '',
  p_daily_hour_close_format => '',
  p_theme_id  => 15,
  p_theme_class_id => 3,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/small_calendar
prompt  ......template 446849750992172985
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 446849750992172985 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Small Calendar',
  p_translate_this_template=> 'Y',
  p_day_of_week_format=> '<td width="40" class="simpleHeadings">#IDY#</td>',
  p_month_title_format=> '<table class="t12SimpleCalendar" width="100%" cellpadding="0" cellspacing="0" border="0" cellspacing="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td align="middle" class="simpleHeader">#IMONTH#&nbsp;#YYYY#</td>'||chr(10)||
'  </tr>'||chr(10)||
'',
  p_month_open_format=> '  <tr>'||chr(10)||
'    <td align="center" class="simpleHeader"><table cellspacing="0" cellpadding="0" class="simpleTable">',
  p_month_close_format=> '    </table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>',
  p_day_title_format=> '<span style="font-weight:bold;font-size:0.8em">#DD#</span><br/>',
  p_day_open_format=> '<td valign="top" class="simpleBody">'||chr(10)||
'',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="simpleBodyCurrent">',
  p_weekend_title_format=> '<span style="font-weight:bold;font-size:0.8em">#DD#</span><br/>',
  p_weekend_open_format => '<td valign="top" class="simpleBodyWE">'||chr(10)||
'',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div>&nbsp;</div>',
  p_nonday_open_format => '<td valign="top" class="simpleBody">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr class="formRegionHeader">',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<th width="14%" class="calheader">#IDAY#</th>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '',
  p_weekly_day_of_week_format => '',
  p_weekly_month_open_format => '',
  p_weekly_month_close_format => '',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '',
  p_weekly_day_close_format => '',
  p_weekly_today_open_format => '',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '',
  p_weekly_weekend_close_format => '',
  p_weekly_time_open_format => '',
  p_weekly_time_close_format => '',
  p_weekly_time_title_format => '',
  p_weekly_hour_open_format => '',
  p_weekly_hour_close_format => '',
  p_daily_day_of_week_format => '',
  p_daily_month_title_format => '',
  p_daily_month_open_format => '',
  p_daily_month_close_format => '',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '',
  p_daily_day_close_format => '',
  p_daily_today_open_format => '',
  p_daily_time_open_format => '',
  p_daily_time_close_format => '',
  p_daily_time_title_format => '',
  p_daily_hour_open_format => '',
  p_daily_hour_close_format => '',
  p_theme_id  => 101,
  p_theme_class_id => 3,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar
prompt  ......template 446849933386172986
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 446849933386172986 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar',
  p_translate_this_template=> 'Y',
  p_day_of_week_format=> '<td width="100">#IDAY#</td>',
  p_month_title_format=> '<table class="t12StandardCalendar" width="100%" cellpadding="0" cellspacing="0" border="0" cellspacing="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td align="middle" class="formRegionHeader">#IMONTH#&nbsp;#YYYY#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>',
  p_month_open_format=> '<table class="t12StandardCalendar" width="100%" cellpadding="0" cellspacing="0" border="0" cellspacing="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td align="center"  class="formRegionHeader"><table cellspacing="2" cellpadding="2">',
  p_month_close_format=> '    </table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>',
  p_day_title_format=> '<span style="font-weight:bold;font-size:0.8em">#DD#</span><br/>',
  p_day_open_format=> '<td valign="top" width="100" class="formRegionBody">'||chr(10)||
'',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="formRegionBodyCurrent">',
  p_weekend_title_format=> '<span style="font-weight:bold;font-size:0.8em">#DD#</span><br/>',
  p_weekend_open_format => '<td valign="top" class="formRegionBodyWE">'||chr(10)||
'',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div>&nbsp;</div>',
  p_nonday_open_format => '<td valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr class="formRegionHeader">',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<th width="14%" class="calheader">#IDAY#</th>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '',
  p_weekly_day_of_week_format => '',
  p_weekly_month_open_format => '',
  p_weekly_month_close_format => '',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '',
  p_weekly_day_close_format => '',
  p_weekly_today_open_format => '',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '',
  p_weekly_weekend_close_format => '',
  p_weekly_time_open_format => '',
  p_weekly_time_close_format => '',
  p_weekly_time_title_format => '',
  p_weekly_hour_open_format => '',
  p_weekly_hour_close_format => '',
  p_daily_day_of_week_format => '',
  p_daily_month_title_format => '',
  p_daily_month_open_format => '',
  p_daily_month_close_format => '',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '',
  p_daily_day_close_format => '',
  p_daily_today_open_format => '',
  p_daily_time_open_format => '',
  p_daily_time_close_format => '',
  p_daily_time_title_format => '',
  p_daily_hour_open_format => '',
  p_daily_hour_close_format => '',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar_alternative_1
prompt  ......template 446850146482172986
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 446850146482172986 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar, Alternative 1',
  p_translate_this_template=> 'Y',
  p_day_of_week_format=> '<td width="60">#IDY#</td>',
  p_month_title_format=> '<table class="t12StandardCalendar" width="100%" cellpadding="0" cellspacing="0" border="0" cellspacing="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td align="middle" class="formRegionHeader">#IMONTH#&nbsp;#YYYY#</td>'||chr(10)||
'  </tr>',
  p_month_open_format=> '  <tr>'||chr(10)||
'    <td align="center"  class="formRegionHeader"><table cellspacing="0" cellpadding="0" class="condensedTable">',
  p_month_close_format=> '    </table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>',
  p_day_title_format=> '<span style="font-weight:bold;font-size:0.8em">#DD#</span><br/>',
  p_day_open_format=> '<td valign="top"  width="60" class="formRegionBody">'||chr(10)||
'',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="formRegionBodyCurrent">',
  p_weekend_title_format=> '<span style="font-weight:bold;font-size:0.8em">#DD#</span><br/>',
  p_weekend_open_format => '<td valign="top" class="formRegionBodyWE">'||chr(10)||
'',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div>&nbsp;</div>',
  p_nonday_open_format => '<td valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr class="formRegionHeader">',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<th width="14%" class="calheader">#IDAY#</th>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '',
  p_weekly_day_of_week_format => '',
  p_weekly_month_open_format => '',
  p_weekly_month_close_format => '',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '',
  p_weekly_day_close_format => '',
  p_weekly_today_open_format => '',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '',
  p_weekly_weekend_close_format => '',
  p_weekly_time_open_format => '',
  p_weekly_time_close_format => '',
  p_weekly_time_title_format => '',
  p_weekly_hour_open_format => '',
  p_weekly_hour_close_format => '',
  p_daily_day_of_week_format => '',
  p_daily_month_title_format => '',
  p_daily_month_open_format => '',
  p_daily_month_close_format => '',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '',
  p_daily_day_close_format => '',
  p_daily_today_open_format => '',
  p_daily_time_open_format => '',
  p_daily_time_close_format => '',
  p_daily_time_title_format => '',
  p_daily_hour_open_format => '',
  p_daily_hour_close_format => '',
  p_theme_id  => 101,
  p_theme_class_id => 2,
  p_reference_id=> null);
end;
null;
 
end;
/

prompt  ...application themes
--
--application/shared_components/user_interface/themes/light_blue
prompt  ......theme 34043938194929932
begin
wwv_flow_api.create_theme (
  p_id =>34043938194929932 + wwv_flow_api.g_id_offset,
  p_flow_id =>wwv_flow.g_flow_id,
  p_theme_id  => 15,
  p_theme_name=>'Light Blue',
  p_default_page_template=>34037339482929843 + wwv_flow_api.g_id_offset,
  p_error_template=>34037829195929848 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=>34037225447929843 + wwv_flow_api.g_id_offset,
  p_breadcrumb_display_point=>'REGION_POSITION_01',
  p_sidebar_display_point=>'REGION_POSITION_02',
  p_login_template=>34037829195929848 + wwv_flow_api.g_id_offset,
  p_default_button_template=>34038127947929857 + wwv_flow_api.g_id_offset,
  p_default_region_template=>34039539107929871 + wwv_flow_api.g_id_offset,
  p_default_chart_template =>34039626797929871 + wwv_flow_api.g_id_offset,
  p_default_form_template  =>34040148901929871 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>34039539107929871 + wwv_flow_api.g_id_offset,
  p_default_tabform_template=>34039539107929871 + wwv_flow_api.g_id_offset,
  p_default_wizard_template=>34039228025929871 + wwv_flow_api.g_id_offset,
  p_default_menur_template=>34038947853929871 + wwv_flow_api.g_id_offset,
  p_default_listr_template=>34039539107929871 + wwv_flow_api.g_id_offset,
  p_default_report_template   =>34041847879929884 + wwv_flow_api.g_id_offset,
  p_default_label_template=>34042926358929906 + wwv_flow_api.g_id_offset,
  p_default_menu_template=>34043156317929917 + wwv_flow_api.g_id_offset,
  p_default_calendar_template=>34043228450929917 + wwv_flow_api.g_id_offset,
  p_default_list_template=>34041325458929884 + wwv_flow_api.g_id_offset,
  p_default_option_label=>34042926358929906 + wwv_flow_api.g_id_offset,
  p_default_required_label=>34042727895929906 + wwv_flow_api.g_id_offset);
end;
/
 
--application/shared_components/user_interface/themes/audi
prompt  ......theme 446850451517172986
begin
wwv_flow_api.create_theme (
  p_id =>446850451517172986 + wwv_flow_api.g_id_offset,
  p_flow_id =>wwv_flow.g_flow_id,
  p_theme_id  => 101,
  p_theme_name=>'Audi',
  p_default_page_template=>439627288789806198 + wwv_flow_api.g_id_offset,
  p_error_template=>444266483925774362 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=>447074751071065133 + wwv_flow_api.g_id_offset,
  p_breadcrumb_display_point=>'REGION_POSITION_01',
  p_sidebar_display_point=>'REGION_POSITION_02',
  p_login_template=>446844752913172965 + wwv_flow_api.g_id_offset,
  p_default_button_template=>444216010174109308 + wwv_flow_api.g_id_offset,
  p_default_region_template=>445470003442667631 + wwv_flow_api.g_id_offset,
  p_default_chart_template =>444476992248547167 + wwv_flow_api.g_id_offset,
  p_default_form_template  =>446845445735172967 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>439690681454123642 + wwv_flow_api.g_id_offset,
  p_default_tabform_template=>446845445735172967 + wwv_flow_api.g_id_offset,
  p_default_wizard_template=>446845331948172966 + wwv_flow_api.g_id_offset,
  p_default_menur_template=>446846240200172969 + wwv_flow_api.g_id_offset,
  p_default_listr_template=>447023949857222082 + wwv_flow_api.g_id_offset,
  p_default_report_template   =>447030927203611080 + wwv_flow_api.g_id_offset,
  p_default_label_template=>446849435730172985 + wwv_flow_api.g_id_offset,
  p_default_menu_template=>446849625239172985 + wwv_flow_api.g_id_offset,
  p_default_calendar_template=>446849933386172986 + wwv_flow_api.g_id_offset,
  p_default_list_template=>447051837019414091 + wwv_flow_api.g_id_offset,
  p_default_option_label=>446849435730172985 + wwv_flow_api.g_id_offset,
  p_default_required_label=>446849039995172985 + wwv_flow_api.g_id_offset);
end;
/
 
prompt  ...build options used by application 860
--
 
begin
 
--application/shared_components/logic/build_options/disabled
wwv_flow_api.create_build_option (
  p_id=> 7633807058443087 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_build_option_name=> 'DISABLED',
  p_build_option_status=> 'EXCLUDE',
  p_default_on_export=>'EXCLUDE',
  p_build_option_comment=> '');
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 860
--
--application/shared_components/globalization/dyntranslations
prompt  ...dynamic translations used by application: 860
--
--application/shared_components/globalization/language
prompt  ...Language Maps for Application 860
--
 
begin
 
null;
 
end;
/

prompt  ...Shortcuts
--
prompt  ...web services (9iR2 or better)
--
prompt  ...shared queries
--
prompt  ...report layouts
--
prompt  ...authentication schemes
--
--application/shared_components/security/authentication/html_db
prompt  ......scheme 34044050782929964
 
begin
 
declare
  s1 varchar2(32767) := null;
  s2 varchar2(32767) := null;
  s3 varchar2(32767) := null;
  s4 varchar2(32767) := null;
  s5 varchar2(32767) := null;
begin
s1 := null;
s2 := null;
s3 := null;
s4:=s4||'-BUILTIN-';

s5 := null;
wwv_flow_api.create_auth_setup (
  p_id=> 34044050782929964 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'HTML DB',
  p_description=>'ID-Daten von internem Application Express Account und Anmeldeseite in dieser Anwendung verwenden.',
  p_page_sentry_function=> s1,
  p_sess_verify_function=> s2,
  p_pre_auth_process=> s3,
  p_auth_function=> s4,
  p_post_auth_process=> s5,
  p_invalid_session_page=>'101',
  p_invalid_session_url=>'',
  p_cookie_name=>'',
  p_cookie_path=>'',
  p_cookie_domain=>'',
  p_ldap_host=>'',
  p_ldap_port=>'',
  p_ldap_string=>'',
  p_attribute_01=>'',
  p_attribute_02=>'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&amp;p_next_flow_page_sess=&APP_ID.:1',
  p_attribute_03=>'',
  p_attribute_04=>'',
  p_attribute_05=>'',
  p_attribute_06=>'',
  p_attribute_07=>'',
  p_attribute_08=>'',
  p_required_patch=>'');
end;
null;
 
end;
/

--application/shared_components/security/authentication/database
prompt  ......scheme 34044139611929965
 
begin
 
declare
  s1 varchar2(32767) := null;
  s2 varchar2(32767) := null;
  s3 varchar2(32767) := null;
  s4 varchar2(32767) := null;
  s5 varchar2(32767) := null;
begin
s1:=s1||'-DATABASE-';

s2 := null;
s3 := null;
s4 := null;
s5 := null;
wwv_flow_api.create_auth_setup (
  p_id=> 34044139611929965 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'DATABASE',
  p_description=>'Datenbank-Authentifizierung verwenden (Benutzer von DAD identifiziert).',
  p_page_sentry_function=> s1,
  p_sess_verify_function=> s2,
  p_pre_auth_process=> s3,
  p_auth_function=> s4,
  p_post_auth_process=> s5,
  p_invalid_session_page=>'',
  p_invalid_session_url=>'',
  p_cookie_name=>'',
  p_cookie_path=>'',
  p_cookie_domain=>'',
  p_ldap_host=>'',
  p_ldap_port=>'',
  p_ldap_string=>'',
  p_attribute_01=>'',
  p_attribute_02=>'',
  p_attribute_03=>'',
  p_attribute_04=>'',
  p_attribute_05=>'',
  p_attribute_06=>'',
  p_attribute_07=>'',
  p_attribute_08=>'',
  p_required_patch=>'');
end;
null;
 
end;
/

--application/shared_components/security/authentication/database_account
prompt  ......scheme 34044229216929965
 
begin
 
declare
  s1 varchar2(32767) := null;
  s2 varchar2(32767) := null;
  s3 varchar2(32767) := null;
  s4 varchar2(32767) := null;
  s5 varchar2(32767) := null;
begin
s1 := null;
s2 := null;
s3 := null;
s4:=s4||'return false; end;--';

s5 := null;
wwv_flow_api.create_auth_setup (
  p_id=> 34044229216929965 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'DATABASE ACCOUNT',
  p_description=>'Verwenden Sie Datenbank-Account-ID-Daten.',
  p_page_sentry_function=> s1,
  p_sess_verify_function=> s2,
  p_pre_auth_process=> s3,
  p_auth_function=> s4,
  p_post_auth_process=> s5,
  p_invalid_session_page=>'101',
  p_invalid_session_url=>'',
  p_cookie_name=>'',
  p_cookie_path=>'',
  p_cookie_domain=>'',
  p_ldap_host=>'',
  p_ldap_port=>'',
  p_ldap_string=>'',
  p_attribute_01=>'',
  p_attribute_02=>'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&amp;p_next_flow_page_sess=&APP_ID.:1',
  p_attribute_03=>'',
  p_attribute_04=>'',
  p_attribute_05=>'',
  p_attribute_06=>'',
  p_attribute_07=>'',
  p_attribute_08=>'',
  p_required_patch=>'');
end;
null;
 
end;
/

--application/deployment/definition
prompt  ...application deployment
--
 
begin
 
declare
    s varchar2(32767) := null;
    l_clob clob;
begin
s := null;
wwv_flow_api.create_install (
  p_id => 9323703140467700 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_include_in_export_yn => 'Y',
  p_deinstall_script_clob => s,
  p_required_free_kb => 100,
  p_required_sys_privs => 'CREATE PROCEDURE:CREATE TABLE:CREATE TRIGGER:CREATE VIEW',
  p_deinstall_message=> '');
end;
 
 
end;
/

--application/deployment/install
prompt  ...application install scripts
--
--application/deployment/checks
prompt  ...application deployment checks
--
 
begin
 
null;
 
end;
/

--application/deployment/buildoptions
prompt  ...application deployment build options
--
 
begin
 
null;
 
end;
/

--application/end_environment
commit;
commit;
begin 
execute immediate 'alter session set nls_numeric_characters='''||wwv_flow_api.g_nls_numeric_chars||'''';
end;
/
set verify on
set feedback on
prompt  ...done
