/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.localesource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import oracle.i18n.servlet.ApplicationContext;
import oracle.i18n.servlet.ServletHelper;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.util.OraLocaleInfo;

public class HttpAcceptLanguage
extends LocaleSource {
    private static final Class OBJECT_KEY = class$oracle$i18n$servlet$localesource$HttpAcceptLanguage == null ? (class$oracle$i18n$servlet$localesource$HttpAcceptLanguage = HttpAcceptLanguage.class$("oracle.i18n.servlet.localesource.HttpAcceptLanguage")) : class$oracle$i18n$servlet$localesource$HttpAcceptLanguage;
    private static final String C_TAGNAME = "Accept-Language";
    private static final Comparator m_cmp_locales = new Comparator(){

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            return ((Float)objectArray2[0]).compareTo((Float)objectArray[0]);
        }
    };
    static /* synthetic */ Class class$oracle$i18n$servlet$localesource$HttpAcceptLanguage;

    private HttpAcceptLanguage(String string, ApplicationContext applicationContext) {
        super(OBJECT_KEY, false, true, false);
        this.setLocale(HttpAcceptLanguage.selectLocale(string, applicationContext));
    }

    public static LocaleSource getInstance(HttpServletRequest httpServletRequest) {
        LocaleSource localeSource = (LocaleSource)httpServletRequest.getAttribute(OBJECT_KEY.getName());
        if (localeSource != null) {
            return localeSource;
        }
        ApplicationContext applicationContext = ServletHelper.getApplicationContextInstance(httpServletRequest);
        String string = httpServletRequest.getHeader(C_TAGNAME);
        if (string != null) {
            HttpAcceptLanguage httpAcceptLanguage = new HttpAcceptLanguage(string, applicationContext);
            if (httpAcceptLanguage.getLocale() == null) {
                return null;
            }
            httpServletRequest.setAttribute(OBJECT_KEY.getName(), (Object)httpAcceptLanguage);
            return httpAcceptLanguage;
        }
        return null;
    }

    private static Locale selectLocale(String string, ApplicationContext applicationContext) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (stringTokenizer.hasMoreTokens()) {
            Float f;
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(59);
            if (n != -1) {
                f = Float.valueOf(string2.substring(n + 3));
                string2 = string2.substring(0, n);
            } else {
                f = new Float(1.0f);
            }
            arrayList.add(new Object[]{f, string2});
        }
        Collections.sort(arrayList, m_cmp_locales);
        Object[] objectArray = arrayList.iterator();
        while (objectArray.hasNext()) {
            Object[] objectArray2 = (Object[])objectArray.next();
            Locale locale = OraLocaleInfo.getLocaleFromString((String)objectArray2[1]);
            if (!applicationContext.fallbackLocale(locale).equals(locale)) continue;
            return locale;
        }
        if (arrayList.size() > 0) {
            objectArray = (Object[])arrayList.get(0);
            return applicationContext.fallbackLocale(OraLocaleInfo.getLocaleFromString((String)objectArray[1]));
        }
        return null;
    }

    public boolean store() {
        return true;
    }

    public boolean load() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

