/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.JsonExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleJsonReportConfiguration;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import net.sf.jasperreports.web.util.ReportExecutionHyperlinkProducerFactory;

public class ReportJiveComponentsServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.setNoExpire(response);
        response.setContentType("application/json; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String contextId = request.getParameter("jr_ctxid");
        if (contextId != null && request.getHeader("accept").indexOf("application/json") >= 0) {
            WebReportContext webReportContext = WebReportContext.getInstance(request, false);
            if (webReportContext == null) {
                response.setStatus(404);
                out.println("{\"msg\": \"Resource with id '" + contextId + "' not found!\"}");
                return;
            }
            try {
                this.getReportComponents(request, webReportContext, out);
                return;
            }
            catch (JRException e) {
                response.setStatus(404);
                out.println("{\"msg\": \"JasperReports encountered an error!\"}");
                return;
            }
        }
        response.setStatus(400);
        out.println("{\"msg\": \"Wrong parameters!\"}");
    }

    public void getReportComponents(HttpServletRequest request, WebReportContext webReportContext, PrintWriter writer) throws JRException {
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        ReportExecutionStatus reportStatus = jasperPrintAccessor.getReportStatus();
        if (reportStatus.getStatus() == ReportExecutionStatus.Status.ERROR) {
            throw new JRRuntimeException("web.servlets.report.generation.error", null, reportStatus.getError());
        }
        boolean hasPages = jasperPrintAccessor.pageStatus(0, null).pageExists();
        JsonExporter exporter = new JsonExporter(this.getJasperReportsContext());
        SimpleJsonReportConfiguration configuration = new SimpleJsonReportConfiguration();
        if (hasPages) {
            String pageTimestamp;
            Long timestamp;
            String reportPage = request.getParameter("jr_page");
            int pageIdx = reportPage == null ? 0 : Integer.parseInt(reportPage);
            ReportPageStatus pageStatus = jasperPrintAccessor.pageStatus(pageIdx, timestamp = (pageTimestamp = request.getParameter("jr_page_timestamp")) == null ? null : Long.valueOf(pageTimestamp));
            if (!pageStatus.pageExists()) {
                throw new JRRuntimeException("web.servlets.page.not.found", new Object[]{pageIdx});
            }
            configuration.setPageIndex(pageIdx);
        } else {
            ReportPageStatus pageStatus = ReportPageStatus.PAGE_FINAL;
        }
        exporter.setReportContext(webReportContext);
        exporter.setExporterInput(new SimpleExporterInput(jasperPrintAccessor.getJasperPrint()));
        exporter.setExporterOutput(new SimpleWriterExporterOutput(writer));
        configuration.setHyperlinkProducerFactory(ReportExecutionHyperlinkProducerFactory.getInstance(this.getJasperReportsContext(), request));
        exporter.setConfiguration(configuration);
        exporter.exportReport();
    }

    protected String getHeader(HttpServletRequest request, WebReportContext webReportContext, boolean hasPages, ReportPageStatus pageStatus) {
        return null;
    }

    protected String getBetweenPages(HttpServletRequest request, WebReportContext webReportContext) {
        return null;
    }

    protected String getFooter(HttpServletRequest request, WebReportContext webReportContext, boolean hasPages, ReportPageStatus pageStatus) {
        return null;
    }
}

