/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRClassGenerator;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRJavacCompiler;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.functions.FunctionsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class JRJdtCompiler
extends JRAbstractJavaCompiler {
    private static final String JDT_PROPERTIES_PREFIX = "org.eclipse.jdt.core.";
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_LOADING_ERROR = "compilers.jdt.class.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_NAME_ENVIRONMENT_ANSWER_INSTANCE_ERROR = "compilers.jdt.name.environment.answer.instance.error";
    static final Log log = LogFactory.getLog(JRJdtCompiler.class);
    private final ClassLoader classLoader = this.getClassLoader();
    Constructor<?> constrNameEnvAnsBin;
    Constructor<?> constrNameEnvAnsCompUnit;
    boolean is2ArgsConstr;
    Constructor<?> constrNameEnvAnsBin2Args;
    Constructor<?> constrNameEnvAnsCompUnit2Args;

    public JRJdtCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, false);
        boolean success;
        try {
            Class<?> classAccessRestriction = this.loadClass("org.eclipse.jdt.internal.compiler.env.AccessRestriction");
            this.constrNameEnvAnsBin2Args = NameEnvironmentAnswer.class.getConstructor(IBinaryType.class, classAccessRestriction);
            this.constrNameEnvAnsCompUnit2Args = NameEnvironmentAnswer.class.getConstructor(ICompilationUnit.class, classAccessRestriction);
            this.is2ArgsConstr = true;
            success = true;
        }
        catch (NoSuchMethodException e) {
            success = false;
        }
        catch (ClassNotFoundException ex) {
            success = false;
        }
        if (!success) {
            try {
                this.constrNameEnvAnsBin = NameEnvironmentAnswer.class.getConstructor(IBinaryType.class);
                this.constrNameEnvAnsCompUnit = NameEnvironmentAnswer.class.getConstructor(ICompilationUnit.class);
                this.is2ArgsConstr = false;
            }
            catch (NoSuchMethodException ex) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CLASS_LOADING_ERROR, null, ex);
            }
        }
    }

    public JRJdtCompiler() {
        this(DefaultJasperReportsContext.getInstance());
    }

    @Override
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) {
        INameEnvironment env = this.getNameEnvironment(units);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        Map<String, String> settings = this.getJdtSettings();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        CompilerRequestor requestor = this.getCompilerRequestor(units);
        Compiler compiler = new Compiler(env, policy, settings, (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        do {
            ICompilationUnit[] compilationUnits = requestor.processCompilationUnits();
            compiler.compile(compilationUnits);
        } while (requestor.hasMissingMethods());
        requestor.processProblems();
        return requestor.getFormattedProblems();
    }

    protected INameEnvironment getNameEnvironment(final JRCompilationUnit[] units) {
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuffer result = new StringBuffer();
                String sep = "";
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    result.append(sep);
                    result.append(compoundTypeName[i]);
                    sep = ".";
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuffer result = new StringBuffer();
                String sep = "";
                for (int i = 0; i < packageName.length; ++i) {
                    result.append(sep);
                    result.append(packageName[i]);
                    sep = ".";
                }
                result.append(sep);
                result.append(typeName);
                return this.findType(result.toString());
            }

            private int getClassIndex(String className) {
                int classIdx;
                for (classIdx = 0; classIdx < units.length && !className.equals(units[classIdx].getName()); ++classIdx) {
                }
                if (classIdx >= units.length) {
                    classIdx = -1;
                }
                return classIdx;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private NameEnvironmentAnswer findType(String className) {
                try {
                    int classIdx = this.getClassIndex(className);
                    if (classIdx >= 0) {
                        CompilationUnit compilationUnit = new CompilationUnit(units[classIdx].getSourceCode(), className);
                        if (JRJdtCompiler.this.is2ArgsConstr) {
                            return (NameEnvironmentAnswer)JRJdtCompiler.this.constrNameEnvAnsCompUnit2Args.newInstance(compilationUnit, null);
                        }
                        return (NameEnvironmentAnswer)JRJdtCompiler.this.constrNameEnvAnsCompUnit.newInstance(compilationUnit);
                    }
                    String resourceName = className.replace('.', '/') + ".class";
                    InputStream is = JRJdtCompiler.this.getResource(resourceName);
                    if (is == null) return null;
                    try {
                        byte[] classBytes = JRLoader.loadBytes(is);
                        char[] fileName = className.toCharArray();
                        ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                        if (JRJdtCompiler.this.is2ArgsConstr) {
                            NameEnvironmentAnswer nameEnvironmentAnswer = (NameEnvironmentAnswer)JRJdtCompiler.this.constrNameEnvAnsBin2Args.newInstance(classFileReader, null);
                            return nameEnvironmentAnswer;
                        }
                        NameEnvironmentAnswer nameEnvironmentAnswer = (NameEnvironmentAnswer)JRJdtCompiler.this.constrNameEnvAnsBin.newInstance(classFileReader);
                        return nameEnvironmentAnswer;
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (JRException e) {
                    log.error((Object)"Compilation error", (Throwable)e);
                    return null;
                }
                catch (ClassFormatException exc) {
                    log.error((Object)"Compilation error", (Throwable)exc);
                    return null;
                }
                catch (InvocationTargetException e) {
                    throw new JRRuntimeException(JRJdtCompiler.EXCEPTION_MESSAGE_KEY_NAME_ENVIRONMENT_ANSWER_INSTANCE_ERROR, null, e);
                }
                catch (IllegalArgumentException e) {
                    throw new JRRuntimeException(JRJdtCompiler.EXCEPTION_MESSAGE_KEY_NAME_ENVIRONMENT_ANSWER_INSTANCE_ERROR, null, e);
                }
                catch (InstantiationException e) {
                    throw new JRRuntimeException(JRJdtCompiler.EXCEPTION_MESSAGE_KEY_NAME_ENVIRONMENT_ANSWER_INSTANCE_ERROR, null, e);
                }
                catch (IllegalAccessException e) {
                    throw new JRRuntimeException(JRJdtCompiler.EXCEPTION_MESSAGE_KEY_NAME_ENVIRONMENT_ANSWER_INSTANCE_ERROR, null, e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isPackage(String result) {
                int classIdx = this.getClassIndex(result);
                if (classIdx >= 0) {
                    return false;
                }
                String resourceName = result.replace('.', '/') + ".class";
                boolean isPackage = true;
                InputStream is = JRJdtCompiler.this.getResource(resourceName);
                if (is != null) {
                    try {
                        isPackage = is.read() > 0;
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return isPackage;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuffer result = new StringBuffer();
                String sep = "";
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        result.append(sep);
                        result.append(parentPackageName[i]);
                        sep = ".";
                    }
                }
                if (Character.isUpperCase(packageName[0]) && !this.isPackage(result.toString())) {
                    return false;
                }
                result.append(sep);
                result.append(packageName);
                return this.isPackage(result.toString());
            }

            public void cleanup() {
            }
        };
        return env;
    }

    protected CompilerRequestor getCompilerRequestor(JRCompilationUnit[] units) {
        return new CompilerRequestor(this.jasperReportsContext, this, units);
    }

    protected Map<String, String> getJdtSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperties(JDT_PROPERTIES_PREFIX);
        for (JRPropertiesUtil.PropertySuffix property : properties) {
            String propVal = property.getValue();
            if (propVal == null || propVal.length() <= 0) continue;
            settings.put(property.getKey(), propVal);
        }
        Properties systemProps = System.getProperties();
        Enumeration<?> it = systemProps.propertyNames();
        while (it.hasMoreElements()) {
            String propVal;
            String propName = (String)it.nextElement();
            if (!propName.startsWith(JDT_PROPERTIES_PREFIX) || (propVal = systemProps.getProperty(propName)) == null || propVal.length() <= 0) continue;
            settings.put(propName, propVal);
        }
        return settings;
    }

    private ClassLoader getClassLoader() {
        ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
        if (clsLoader != null) {
            try {
                Class.forName(JRJdtCompiler.class.getName(), true, clsLoader);
            }
            catch (ClassNotFoundException e) {
                clsLoader = null;
            }
        }
        if (clsLoader == null) {
            clsLoader = JRClassLoader.class.getClassLoader();
        }
        return clsLoader;
    }

    protected InputStream getResource(String resourceName) {
        if (this.classLoader == null) {
            return JRJdtCompiler.class.getResourceAsStream("/" + resourceName);
        }
        return this.classLoader.getResourceAsStream(resourceName);
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.classLoader == null) {
            return Class.forName(className);
        }
        return this.classLoader.loadClass(className);
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
        if (!"java".equals(language)) {
            throw new JRException("compilers.language.expected.java", new Object[]{language, "java"});
        }
    }

    protected JRCompilationUnit recreateCompileUnit(JRCompilationUnit compilationUnit, Set<Method> missingMethods) {
        String unitName = compilationUnit.getName();
        JRSourceCompileTask sourceTask = compilationUnit.getCompileTask();
        JRCompilationSourceCode sourceCode = JRClassGenerator.modifySource(sourceTask, missingMethods, compilationUnit.getSourceCode());
        File sourceFile = compilationUnit.getSourceFile();
        File saveSourceDir = sourceFile == null ? null : sourceFile.getParentFile();
        sourceFile = this.getSourceFile(saveSourceDir, unitName, sourceCode);
        return new JRCompilationUnit(unitName, sourceCode, sourceFile, compilationUnit.getExpressions(), sourceTask);
    }

    @Override
    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return JRClassGenerator.generateClass(sourceTask);
    }

    @Override
    protected String getSourceFileName(String unitName) {
        return unitName + ".java";
    }

    @Override
    protected String getCompilerClass() {
        return JRJavacCompiler.class.getName();
    }

    public static class CompilationUnitResult {
        private Set<Method> resolvedMethods;
        private Set<Method> missingMethods;
        private IProblem[] problems;

        public boolean hasMissingMethods() {
            return this.missingMethods != null && this.missingMethods.size() > 0;
        }

        public Set<Method> getMissingMethods() {
            return this.missingMethods;
        }

        public void addMissingMethod(Method missingMethod) {
            if (this.resolvedMethods == null || !this.resolvedMethods.contains(missingMethod)) {
                if (this.missingMethods == null) {
                    this.missingMethods = new HashSet<Method>();
                }
                this.missingMethods.add(missingMethod);
            }
        }

        public IProblem[] getProblems() {
            return this.problems;
        }

        public void setProblems(IProblem[] problems) {
            this.problems = problems;
        }

        public void resolveMissingMethods() {
            if (this.missingMethods != null && this.missingMethods.size() > 0) {
                if (this.resolvedMethods == null) {
                    this.resolvedMethods = new HashSet<Method>();
                }
                this.resolvedMethods.addAll(this.missingMethods);
            }
        }

        public void reset() {
            this.missingMethods = null;
            this.problems = null;
        }

        static /* synthetic */ IProblem[] access$002(CompilationUnitResult x0, IProblem[] x1) {
            x0.problems = x1;
            return x1;
        }
    }

    public static class CompilationUnit
    implements ICompilationUnit {
        protected String srcCode;
        protected String className;

        public CompilationUnit(String srcCode, String className) {
            this.srcCode = srcCode;
            this.className = className;
        }

        public char[] getFileName() {
            return this.className.toCharArray();
        }

        public char[] getContents() {
            return this.srcCode.toCharArray();
        }

        public char[] getMainTypeName() {
            return this.className.toCharArray();
        }

        public char[][] getPackageName() {
            return new char[0][0];
        }

        public boolean ignoreOptionalProblems() {
            return false;
        }
    }

    public static class CompilerRequestor
    implements ICompilerRequestor {
        public static final String EXCEPTION_MESSAGE_KEY_METHOD_INVOKING_ERROR = "compilers.jdt.method.invoking.error";
        public static final String EXCEPTION_MESSAGE_KEY_METHOD_RESOLVING_ERROR = "compilers.jdt.method.resolving.error";
        private final JasperReportsContext jasperReportsContext;
        protected final JRJdtCompiler compiler;
        protected final JRCompilationUnit[] units;
        protected final CompilationUnitResult[] unitResults;

        public CompilerRequestor(JasperReportsContext jasperReportsContext, JRJdtCompiler compiler, JRCompilationUnit[] units) {
            this.jasperReportsContext = jasperReportsContext;
            this.compiler = compiler;
            this.units = units;
            this.unitResults = new CompilationUnitResult[units.length];
            this.reset();
        }

        public void acceptResult(CompilationResult result) {
            int classIdx;
            String className = ((CompilationUnit)result.getCompilationUnit()).className;
            for (classIdx = 0; classIdx < this.units.length && !className.equals(this.units[classIdx].getName()); ++classIdx) {
            }
            if (result.hasErrors()) {
                IProblem[] problems = this.getJavaCompilationErrors(result);
                CompilationUnitResult.access$002(this.unitResults[classIdx], problems);
                String sourceCode = this.units[classIdx].getSourceCode();
                for (int i = 0; i < problems.length; ++i) {
                    IProblem problem = problems[i];
                    if (0x4000064 != problem.getID() || problem.getSourceStart() < 0 || problem.getSourceEnd() < 0) continue;
                    String methodName = sourceCode.substring(problem.getSourceStart(), problem.getSourceEnd() + 1);
                    Method method = FunctionsUtil.getInstance(this.jasperReportsContext).getMethod4Function(methodName);
                    if (method == null) continue;
                    this.unitResults[classIdx].addMissingMethod(method);
                }
            } else {
                ClassFile[] resultClassFiles = result.getClassFiles();
                for (int i = 0; i < resultClassFiles.length; ++i) {
                    this.units[classIdx].setCompileData((Serializable)resultClassFiles[i].getBytes());
                }
            }
        }

        public void processProblems() {
        }

        public String getFormattedProblems() {
            StringBuffer problemBuffer = new StringBuffer();
            for (int u = 0; u < this.units.length; ++u) {
                String sourceCode = this.units[u].getSourceCode();
                IProblem[] problems = this.unitResults[u].problems;
                if (problems == null || problems.length <= 0) continue;
                for (int i = 0; i < problems.length; ++i) {
                    int j;
                    IProblem problem = problems[i];
                    problemBuffer.append(i + 1);
                    problemBuffer.append(". ");
                    problemBuffer.append(problem.getMessage());
                    if (problem.getSourceStart() < 0 || problem.getSourceEnd() < 0) continue;
                    int problemStartIndex = sourceCode.lastIndexOf("\n", problem.getSourceStart()) + 1;
                    int problemEndIndex = sourceCode.indexOf("\n", problem.getSourceEnd());
                    if (problemEndIndex < 0) {
                        problemEndIndex = sourceCode.length();
                    }
                    problemBuffer.append("\n");
                    problemBuffer.append(sourceCode.substring(problemStartIndex, problemEndIndex));
                    problemBuffer.append("\n");
                    for (j = problemStartIndex; j < problem.getSourceStart(); ++j) {
                        problemBuffer.append(" ");
                    }
                    if (problem.getSourceStart() == problem.getSourceEnd()) {
                        problemBuffer.append("^");
                    } else {
                        problemBuffer.append("<");
                        for (j = problem.getSourceStart() + 1; j < problem.getSourceEnd(); ++j) {
                            problemBuffer.append("-");
                        }
                        problemBuffer.append(">");
                    }
                    problemBuffer.append("\n");
                }
                problemBuffer.append(problems.length);
                problemBuffer.append(" errors\n");
            }
            return problemBuffer.length() > 0 ? problemBuffer.toString() : null;
        }

        public boolean hasMissingMethods() {
            for (CompilationUnitResult unitResult : this.unitResults) {
                if (!unitResult.hasMissingMethods()) continue;
                return true;
            }
            return false;
        }

        public CompilationUnit[] processCompilationUnits() {
            CompilationUnit[] compilationUnits = new CompilationUnit[this.units.length];
            for (int i = 0; i < compilationUnits.length; ++i) {
                if (this.unitResults[i].hasMissingMethods()) {
                    this.units[i] = this.compiler.recreateCompileUnit(this.units[i], this.unitResults[i].getMissingMethods());
                    this.unitResults[i].resolveMissingMethods();
                }
                compilationUnits[i] = new CompilationUnit(this.units[i].getSourceCode(), this.units[i].getName());
            }
            this.reset();
            return compilationUnits;
        }

        protected void reset() {
            for (int i = 0; i < this.unitResults.length; ++i) {
                if (this.unitResults[i] == null) {
                    this.unitResults[i] = new CompilationUnitResult();
                }
                this.unitResults[i].reset();
            }
        }

        protected IProblem[] getJavaCompilationErrors(CompilationResult result) {
            try {
                Method getErrorsMethod = result.getClass().getMethod("getErrors", null);
                return (IProblem[])getErrorsMethod.invoke((Object)result, (Object[])null);
            }
            catch (SecurityException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_RESOLVING_ERROR, null, e);
            }
            catch (NoSuchMethodException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_RESOLVING_ERROR, null, e);
            }
            catch (IllegalArgumentException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_INVOKING_ERROR, null, e);
            }
            catch (IllegalAccessException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_INVOKING_ERROR, null, e);
            }
            catch (InvocationTargetException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_INVOKING_ERROR, null, e);
            }
        }
    }
}

