/*
 * Decompiled with CFR 0.152.
 */
package main;

import de.oc.integration.jasper.webapp.AppConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CommandLine {
    private static final Logger logger = Logger.getLogger(CommandLine.class);

    public static void main(String[] stringArray) {
        String string;
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.ERROR);
        logger.info((Object)"CommandLine called ...");
        logger.debug((Object)("#arguments passed: " + stringArray.length));
        int n = stringArray.length;
        String string2 = n > 0 ? stringArray[0] : "";
        String string3 = n > 1 ? stringArray[1] : "";
        String string4 = string = n > 2 ? stringArray[2] : "";
        if (n == 0) {
            CommandLine.showHelpJavaCall();
        } else if (string2.toLowerCase().equals("encryptpasswords")) {
            if (n < 2) {
                System.err.println("Please specify the application.properties file.");
                CommandLine.showHelp(string2);
                System.exit(-1);
            }
            CommandLine.encryptPasswords(string3);
        } else if (string2.toLowerCase().equals("setconfigdir")) {
            if (n < 3) {
                System.err.println("Please specify the path to the JasperReportsIntegration.war file and the configuration directory.");
                CommandLine.showHelp(string2);
                System.exit(-1);
            }
            CommandLine.setConfigDir(string3, string);
        } else if (string2.toLowerCase().equals("getconfigdir")) {
            if (n < 2) {
                System.err.println("Please specify the path to the JasperReportsIntegration.war.");
                CommandLine.showHelp(string2);
                System.exit(-1);
            }
            System.out.println("ConfigDir: " + CommandLine.getConfigDir(string3));
        } else if (stringArray[0].toLowerCase().equals("validate")) {
            CommandLine.validateConfigFile(string3);
        } else {
            logger.error((Object)("unknown command: " + stringArray[0].toLowerCase()));
            System.exit(-1);
        }
    }

    public static void validateConfigFile(String string) {
        HierarchicalINIConfiguration hierarchicalINIConfiguration = new HierarchicalINIConfiguration();
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("File " + string + " cannot be found.");
        }
        logger.info((Object)("Using file: " + string));
        hierarchicalINIConfiguration = AppConfig.getInstance().loadApplicationProperties(string);
        AppConfig.getInstance().logApplicationProperties();
        for (String string2 : hierarchicalINIConfiguration.getSections()) {
            logger.trace((Object)("process section=" + string2));
            if (!string2.startsWith("datasource:")) continue;
            logger.trace((Object)("datasource section found=" + string2));
            String string3 = string2.split(":")[1];
            String string4 = hierarchicalINIConfiguration.getString(string2 + ".username");
            logger.info((Object)("dsName: " + string3));
            logger.info((Object)("dsUsername: " + string4));
        }
    }

    public static void encryptPasswords(String string) {
        String string2 = string + ".tmp.properties";
        logger.info((Object)("encryptPasswords(" + string + ")"));
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("Configuration file could not be found: " + string);
            System.exit(-1);
        }
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            String string3;
            bufferedReader = new BufferedReader(new FileReader(string));
            printWriter = new PrintWriter(new FileWriter(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.trim().startsWith("password")) {
                    String string4 = string3.substring(string3.indexOf("=") + 1);
                    logger.debug((Object)("pwd=" + string4));
                    string3 = "password=" + AppConfig.getInstance().encryptPWD(string4);
                }
                printWriter.println(string3);
            }
            bufferedReader.close();
            printWriter.close();
            new File(string).delete();
            new File(string2).renameTo(new File(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setConfigDir(String string, String string2) {
        logger.info((Object)("setConfigDir(" + string2 + ") for war file: " + string));
        File file = new File(string2);
        File file2 = new File(string);
        File file3 = new File(string + ".tmp.war");
        if (!file.exists()) {
            System.err.println("WARNING: Configuration directory could not be found: " + string2);
        }
        if (!file2.exists()) {
            System.err.println("War file (JasperReportsIntegration.war) could not be found: " + string);
            System.exit(-1);
        }
        try {
            CommandLine.updateWebXML(string, string + ".tmp.war", string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        file2.delete();
        file3.renameTo(new File(string));
    }

    public static void updateWebXML(String string, String string2, String string3) throws IOException {
        ZipFile zipFile = new ZipFile(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
        logger.info((Object)("create new war file: " + string2));
        String string4 = string3.replaceAll("\\\\", "/");
        logger.info((Object)("canonical path for config dir: " + string4));
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            byte[] byArray;
            InputStream inputStream;
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().contains("web.xml")) {
                zipOutputStream.putNextEntry(zipEntry);
                inputStream = zipFile.getInputStream(zipEntry);
                byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
            } else {
                System.out.println("process web.xml");
                zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                inputStream = zipFile.getInputStream(zipEntry);
                byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) > 0) {
                    String string5 = new String(byArray);
                    if (string5.contains("oc.jasper.config.home")) {
                        System.out.println("replace config.home");
                        byArray = string5.replaceAll("(?ms)<context-param>.*<param-name>oc.jasper.config.home</param-name>.*?</context-param>", "<context-param><param-name>oc.jasper.config.home</param-name><param-value>" + string4 + "</param-value></context-param>").getBytes();
                    }
                    zipOutputStream.write(byArray, 0, n < byArray.length ? n : byArray.length);
                }
            }
            zipOutputStream.closeEntry();
        }
        zipOutputStream.close();
        zipFile.close();
        logger.info((Object)"done!");
    }

    public static String getConfigDir(String string) {
        String string2 = "";
        logger.info((Object)("getConfigDir for war file: " + string));
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("War file could not be found: " + string);
            System.exit(-1);
        }
        try {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().contains("web.xml")) continue;
                logger.info((Object)"process web.xml");
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Scanner scanner = new Scanner(inputStream, "UTF-8");
                Pattern pattern = Pattern.compile("<context-param>.*<param-name>oc.jasper.config.home</param-name>.*?<param-value>(.*?)</param-value></context-param>");
                while (scanner.findWithinHorizon(pattern, 0) != null) {
                    MatchResult matchResult = scanner.match();
                    string2 = matchResult.group(1);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        logger.info((Object)"done!");
        return string2;
    }

    public static void showHelp(String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        System.out.println("");
        logger.info((Object)("operating system: " + string2));
        if (string2.indexOf("win") >= 0) {
            if (string.toLowerCase().equals("encryptpasswords")) {
                System.out.println("encryptPasswords.cmd <path to application.properties file>");
                System.out.println("  e.g.: encryptPasswords.cmd ..\\conf\\application.properties");
                System.out.println("");
            } else if (string.toLowerCase().equals("setconfigdir")) {
                System.out.println("setConfigDir.cmd <path to .war file> <path to config directory>");
                System.out.println("  e.g.: setConfigDir.cmd ..\\webapp\\JasperReportsIntegration.war c:\\app\\JasperReportsIntegration");
                System.out.println("");
            } else if (string.toLowerCase().equals("getconfigdir")) {
                System.out.println("getConfigDir.sh <path to .war file>");
                System.out.println("  e.g.: getConfigDir.cmd ..\\webapp\\JasperReportsIntegration.war");
                System.out.println("");
            } else {
                logger.error((Object)("unknown command: " + string.toLowerCase()));
                System.exit(-1);
            }
        } else if (string.toLowerCase().equals("encryptpasswords")) {
            System.out.println("encryptPasswords.sh <path to application.properties file>");
            System.out.println("  e.g.: encryptPasswords.sh ../conf/application.properties");
            System.out.println("");
        } else if (string.toLowerCase().equals("setconfigdir")) {
            System.out.println("setConfigDir.sh <path to .war file> <path to config directory>");
            System.out.println("  e.g.: setConfigDir.sh ../webapp/JasperReportsIntegration.war /Users/daust/oc-jasper");
            System.out.println("");
        } else if (string.toLowerCase().equals("getconfigdir")) {
            System.out.println("getConfigDir.sh <path to .war file>");
            System.out.println("  e.g.: getConfigDir.sh ../webapp/JasperReportsIntegration.war");
            System.out.println("");
        } else {
            logger.error((Object)("unknown command: " + string.toLowerCase()));
            System.exit(-1);
        }
    }

    public static void showHelpJavaCall() {
        System.out.println("");
        System.out.println("Usage: java -jar JasperReportsIntegration.war <COMMAND> [arguments] \n");
        System.out.println("The following commands are available: \n");
        System.out.println("getConfigDir <path to JasperReportsIntegration.war file>  : This will return the config directory as specified in the web.xml file \n");
        System.out.println("   example: java -jar JasperReportsIntegration.war getConfigDir ./JasperReportsIntegration.war\n");
        System.out.println("setConfigDir     : This will set the config directory and update the web.xml file \n");
        System.out.println("   example: java -jar JasperReportsIntegration.war setConfigDir JasperReportsIntegration.war /jri");
        System.out.println("   example: java -jar JasperReportsIntegration.war setConfigDir JasperReportsIntegration.war d:\\jri\n");
        System.out.println("encryptPasswords <path to application.properties file> \n");
        System.out.println("   example: java -jar JasperReportsIntegration.war encryptPasswords /jri/conf/application.properties");
        System.out.println("   example: java -jar JasperReportsIntegration.war encryptPasswords d:\\jri\\conf\\application.properties\n");
    }

    public static void showHelpOldOneJAR() {
        System.out.println("");
        System.out.println("Usage: java -jar JasperReportsIntegration.war <COMMAND> [arguments] \n");
        System.out.println("The following commands are available: \n");
        System.out.println("getConfigDir <path to JasperReportsIntegration.war file>  : This will return the config directory as specified in the web.xml file \n");
        System.out.println("   example: java -jar JasperReportsIntegration.war getConfigDir ./JasperReportsIntegration.war\n");
        System.out.println("setConfigDir     : This will set the config directory and update the web.xml file \n");
        System.out.println("   example: java -jar JasperReportsIntegration.war setConfigDir JasperReportsIntegration.war /jri");
        System.out.println("   example: java -jar JasperReportsIntegration.war setConfigDir JasperReportsIntegration.war d:\\jri\n");
        System.out.println("encryptPasswords <path to application.properties file> \n");
        System.out.println("   example: java -jar JasperReportsIntegration.war encryptPasswords /jri/conf/application.properties");
        System.out.println("   example: java -jar JasperReportsIntegration.war encryptPasswords d:\\jri\\conf\\application.properties\n");
        System.out.println("You can suppress all info messages by using -Done-jar.silent=true, \n e.g. java -Done-jar.silent=true -jar JasperReportsIntegration.war getConfigDir JasperReportsIntegration.war\n");
    }
}

