/*
 * Decompiled with CFR 0.152.
 */
package de.oc.print;

import de.oc.integration.jasper.webapp.AppConfig;
import de.oc.utils.Utils;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.log4j.Logger;

public class PrinterUtilities {
    private ArrayList printers = new ArrayList();
    private static Logger logger = Logger.getLogger(PrinterUtilities.class);

    public PrinterUtilities() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            this.printers.add(printServiceArray[i]);
        }
    }

    public ArrayList getInstalledPrinters() {
        return this.printers;
    }

    public PrintService lookupPrintService(String string) {
        PrintService printService;
        int n;
        PrintService printService2 = null;
        for (n = 0; n < this.printers.size(); ++n) {
            printService = (PrintService)this.printers.get(n);
            if (!printService.getName().equals(string)) continue;
            printService2 = printService;
        }
        if (printService2 == null) {
            for (n = 0; n < this.printers.size(); ++n) {
                printService = (PrintService)this.printers.get(n);
                if (!printService.getName().contains(string)) continue;
                printService2 = printService;
            }
        }
        return printService2;
    }

    public Media lookupMedia(PrintService printService, String string) {
        int n;
        Media[] mediaArray = (Media[])printService.getSupportedAttributeValues(Media.class, null, null);
        Media media = null;
        for (n = 0; n < mediaArray.length; ++n) {
            if (!mediaArray[n].toString().trim().equals(string)) continue;
            media = mediaArray[n];
        }
        if (media == null) {
            for (n = 0; n < mediaArray.length; ++n) {
                if (!mediaArray[n].toString().trim().contains(string)) continue;
                media = mediaArray[n];
            }
        }
        if (media != null) {
            logger.trace((Object)("Media selected:" + media.getValue()));
            logger.trace((Object)("Media selected:" + media.getCategory().getName()));
            logger.trace((Object)("Media selected:" + media.getName()));
            logger.trace((Object)("Media selected:" + media.getClass().toString()));
            logger.trace((Object)("Media selected:" + media.toString()));
        }
        return media;
    }

    public void print(JasperPrint jasperPrint, String string, String string2, int n, boolean bl, boolean bl2) {
        logger.info((Object)("lookup printer by name: " + string));
        PrintService printService = this.lookupPrintService(string);
        if (printService == null) {
            Utils.throwRuntimeException("printer not found:" + string);
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        logger.debug((Object)"setPrintService()");
        try {
            printerJob.setPrintService(printService);
        }
        catch (PrinterException printerException) {
            Utils.throwRuntimeException("Could not set printService");
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        logger.debug((Object)("lookupMedia(" + string2 + ")"));
        Media media = this.lookupMedia(printService, string2);
        if (media == null) {
            Utils.throwRuntimeException("media not found:" + string2);
        }
        if (!this.validateAttribute(printerJob, media, null)) {
            logger.warn((Object)("tray not validated: " + string2));
        }
        logger.debug((Object)("set media to: " + string2));
        hashPrintRequestAttributeSet.add(media);
        logger.trace((Object)("set copies: " + n));
        if (!this.validateAttribute(printerJob, new Copies(n), null)) {
            logger.warn((Object)("copies not validated: " + n));
        }
        hashPrintRequestAttributeSet.add(new Copies(n));
        logger.trace((Object)("set duplex: " + bl));
        if (bl) {
            if (!this.validateAttribute(printerJob, Sides.DUPLEX, null)) {
                logger.info((Object)"Sides.DUPLEX *NOT* validated");
            }
            hashPrintRequestAttributeSet.add(Sides.DUPLEX);
        }
        logger.trace((Object)("set collated: " + bl2));
        if (bl2) {
            if (!this.validateAttribute(printerJob, SheetCollate.COLLATED, null)) {
                logger.info((Object)"SheetCollate.COLLATED *NOT* validated");
            }
            hashPrintRequestAttributeSet.add(SheetCollate.COLLATED);
        }
        logger.trace((Object)"create JRPrintServiceExporter()");
        JRPrintServiceExporter jRPrintServiceExporter = new JRPrintServiceExporter();
        SimplePrintServiceExporterConfiguration simplePrintServiceExporterConfiguration = new SimplePrintServiceExporterConfiguration();
        ArrayList<JasperPrint> arrayList = new ArrayList<JasperPrint>();
        arrayList.add(jasperPrint);
        jRPrintServiceExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        simplePrintServiceExporterConfiguration.setPrintService(printService);
        simplePrintServiceExporterConfiguration.setPrintServiceAttributeSet(printService.getAttributes());
        simplePrintServiceExporterConfiguration.setPrintRequestAttributeSet((PrintRequestAttributeSet)hashPrintRequestAttributeSet);
        simplePrintServiceExporterConfiguration.setDisplayPageDialog(Boolean.FALSE);
        if (AppConfig.getInstance().displayPrintDialog) {
            simplePrintServiceExporterConfiguration.setDisplayPageDialog(Boolean.TRUE);
        } else {
            simplePrintServiceExporterConfiguration.setDisplayPageDialog(Boolean.FALSE);
        }
        jRPrintServiceExporter.setConfiguration((ExporterConfiguration)simplePrintServiceExporterConfiguration);
        logger.trace((Object)"exportReport()");
        try {
            jRPrintServiceExporter.exportReport();
        }
        catch (JRException jRException) {
            Utils.throwRuntimeException(jRException.getMessage());
        }
    }

    private boolean validateAttribute(PrinterJob printerJob, Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        return printerJob.getPrintService().isAttributeValueSupported(attribute, null, null);
    }
}

