/*
 * Decompiled with CFR 0.152.
 */
package de.oc.integration.jasper.webapp;

import de.oc.db.DBUtils;
import de.oc.servlet.ServletUtilities;
import de.oc.utils.Utils;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class URLCallInterface {
    public String repName;
    public String repFormat;
    public String dataSource;
    public String outFilename;
    public String repLocale;
    public String repEncoding;
    public String imagesURI;
    public Boolean printIsEnabled;
    public String printPrinterName;
    public String printPrinterTray;
    public Integer printCopies;
    public Boolean printDuplex;
    public Boolean printCollate;
    public Boolean saveIsEnabled;
    public String saveFileName;
    private static Logger logger = Logger.getLogger((String)URLCallInterface.class.getName());

    private Boolean parseBoolean(String string) {
        Boolean bl = string == null || string.isEmpty() ? null : Boolean.valueOf(string);
        return bl;
    }

    private Integer parseInteger(String string) {
        Integer n = string == null || string.isEmpty() ? null : Integer.valueOf(string);
        return n;
    }

    public URLCallInterface(HttpServletRequest httpServletRequest) {
        logger.debug((Object)"read variables from url call interface");
        ServletUtilities.logRequestParameters(httpServletRequest);
        this.repName = httpServletRequest.getParameter("_repName");
        this.repFormat = httpServletRequest.getParameter("_repFormat");
        this.dataSource = httpServletRequest.getParameter("_dataSource");
        this.outFilename = httpServletRequest.getParameter("_outFilename");
        this.repLocale = httpServletRequest.getParameter("_repLocale");
        this.repEncoding = httpServletRequest.getParameter("_repEncoding");
        this.imagesURI = httpServletRequest.getParameter("_imagesURI");
        this.printIsEnabled = this.parseBoolean(httpServletRequest.getParameter("_printIsEnabled"));
        this.printPrinterName = httpServletRequest.getParameter("_printPrinterName");
        this.printPrinterTray = httpServletRequest.getParameter("_printPrinterTray");
        this.printCopies = this.parseInteger(httpServletRequest.getParameter("_printCopies"));
        this.printDuplex = this.parseBoolean(httpServletRequest.getParameter("_printDuplex"));
        this.printCollate = this.parseBoolean(httpServletRequest.getParameter("_printCollate"));
        this.saveIsEnabled = this.parseBoolean(httpServletRequest.getParameter("_saveIsEnabled"));
        this.saveFileName = httpServletRequest.getParameter("_saveFileName");
        this.repName = DBUtils.nvl(this.repName, "test");
        this.repFormat = DBUtils.nvl(this.repFormat, "pdf");
        this.dataSource = DBUtils.nvl(this.dataSource, "default");
        this.outFilename = DBUtils.nvl(this.outFilename, null);
        this.repLocale = DBUtils.nvl(this.repLocale, "de_DE");
        this.repEncoding = DBUtils.nvl(this.repEncoding, "UTF-8");
        this.imagesURI = DBUtils.nvl(this.imagesURI, "report_image?image={0}");
        this.printIsEnabled = DBUtils.nvl(this.printIsEnabled, Boolean.FALSE);
        this.printCopies = DBUtils.nvl(this.printCopies, new Integer(1));
        this.printDuplex = DBUtils.nvl(this.printDuplex, Boolean.FALSE);
        this.printCollate = DBUtils.nvl(this.printCollate, Boolean.FALSE);
        this.saveIsEnabled = DBUtils.nvl(this.saveIsEnabled, Boolean.FALSE);
        logger.debug((Object)"URL parameters including defaults:");
        logger.debug((Object)("\tdataSource=" + this.dataSource));
        logger.debug((Object)("\trepName=" + this.repName));
        logger.debug((Object)("\trepFormat=" + this.repFormat));
        logger.debug((Object)("\trepLocale=" + this.repLocale));
        logger.debug((Object)("\trepEncoding=" + this.repEncoding));
        logger.debug((Object)("\toutFilename=" + this.outFilename));
        logger.debug((Object)("\tprintUsePrinter=" + this.printIsEnabled));
        logger.debug((Object)("\tprintPrinterName=" + this.printPrinterName));
        logger.debug((Object)("\tprintPrinterTray=" + this.printPrinterTray));
        logger.debug((Object)("\tprintCopies=" + this.printCopies));
        logger.debug((Object)("\tprintDuplex=" + this.printDuplex));
        logger.debug((Object)("\tprintCollate=" + this.printCollate));
        logger.debug((Object)("\tsaveIsEnabled=" + this.saveIsEnabled));
        logger.debug((Object)("\tsaveFileName=" + this.saveFileName));
        if (!(this.repFormat.equals("pdf") || this.repFormat.equals("rtf") || this.repFormat.equals("html") || this.repFormat.equals("xls") || this.repFormat.equals("xlsx") || this.repFormat.equals("docx") || this.repFormat.equals("html") || this.repFormat.equals("pptx") || this.repFormat.equals("jxl") || this.repFormat.equals("csv") || this.repFormat.equals("html2"))) {
            Utils.throwRuntimeException("Unknown _repFormat: " + this.repFormat);
        }
        logger.debug((Object)"input values asserted");
    }
}

