/*
 * Decompiled with CFR 0.152.
 */
package de.oc.integration.jasper.webapp;

import de.oc.db.DBUtils;
import de.oc.integration.jasper.webapp.AppConfig;
import de.oc.integration.jasper.webapp.URLCallInterface;
import de.oc.utils.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class Test
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE = "text/html; charset=windows-1252";
    private static Logger logger = Logger.getLogger((String)Test.class.getName());

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        logger.info((Object)"doGet() - start");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        AppConfig appConfig = AppConfig.getInstance();
        appConfig.validateConfiguration(this.getServletContext());
        if (!appConfig.infoPageIsEnabled) {
            httpServletResponse.sendError(403, "This page is protected.");
        }
        URLCallInterface uRLCallInterface = new URLCallInterface(httpServletRequest);
        httpServletResponse.setContentType(CONTENT_TYPE);
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<link rel=StyleSheet href=\"JasperReportsIntegration.css\" type=\"text/css\">");
        printWriter.println("<head><title>test</title></head>");
        printWriter.println("<body>");
        printWriter.println("<h1>Basic connectivity test for dataSource=" + uRLCallInterface.dataSource + "</h1>");
        try {
            connection = appConfig.getConnection(uRLCallInterface.dataSource);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select sys_context('userenv', 'session_user') session_user,        sys_context('userenv', 'current_user') parsing_user,       sys_context('userenv', 'instance_name') instance_name,       sys_context('userenv', 'db_name') db_name,       sys_context('userenv', 'server_host') server_host,       to_char(sysdate, 'dd.mm.yyyy hh24:mi:ss') curr_time  from dual");
            printWriter.write("<h3>Session Info</h3><BR />");
            printWriter.write("<table class=\"newspaper-b\">");
            printWriter.write("<tr><th>Session User</th><th>Parsing User</th><th>Instance Name</th><th>DB Name</th><th>Server Host</th><th>Current Time</th></tr>");
            while (resultSet.next()) {
                printWriter.write("<tr>");
                printWriter.write("<td>" + resultSet.getString("SESSION_USER") + "</td>" + "<td>" + resultSet.getString("PARSING_USER") + "</td>" + "<td>" + resultSet.getString("INSTANCE_NAME") + "</td>" + "<td>" + resultSet.getString("DB_NAME") + "</td>" + "<td>" + resultSet.getString("SERVER_HOST") + "</td>" + "<td>" + resultSet.getString("CURR_TIME") + "</td>");
                printWriter.write("</tr>");
            }
            printWriter.write("</table>");
            statement.close();
            resultSet.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            try {
                Utils.throwRuntimeException("Error while selecting user objects: " + sQLException.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
            DBUtils.closeQuietly(connection, statement, resultSet);
        }
        DBUtils.closeQuietly(connection, statement, resultSet);
        printWriter.println("</body></html>");
        printWriter.close();
        logger.info((Object)"doGet() - end");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

