/*
 * Decompiled with CFR 0.152.
 */
package de.oc.integration.jasper.webapp;

import de.oc.db.DBUtils;
import de.oc.integration.jasper.webapp.AppConfig;
import de.oc.integration.jasper.webapp.URLCallInterface;
import de.oc.jasper.ReportDefinitionFile;
import de.oc.jasper.ReportUtilities;
import de.oc.print.PrinterUtilities;
import de.oc.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.engine.util.SimpleFileResolver;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.web.util.WebHtmlResourceHandler;
import org.apache.log4j.Logger;

public class ReportWrapper
extends HttpServlet {
    private static final long serialVersionUID = 3232059099842063441L;
    private static Logger logger = Logger.getLogger((String)ReportWrapper.class.getName());

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    Map<String, Object> filterInternalParameters(Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey().toString().startsWith("_")) continue;
            String string = entry.getKey().toString();
            String[] stringArray = (String[])entry.getValue();
            hashMap.put(string, stringArray[0].toString());
        }
        return hashMap;
    }

    String nvl(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string.equals("")) {
            return string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        Object object;
        Object object2;
        logger.info((Object)"service() start");
        String string2 = "";
        AppConfig appConfig = AppConfig.getInstance();
        appConfig.validateConfiguration(this.getServletContext());
        JasperPrint jasperPrint = null;
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        Connection connection = null;
        JRPdfExporter jRPdfExporter = null;
        URLCallInterface uRLCallInterface = new URLCallInterface(httpServletRequest);
        ReportDefinitionFile reportDefinitionFile = ReportUtilities.getReportDefinitionFile(uRLCallInterface.repName);
        logger.info((Object)("report definition file found for report:" + uRLCallInterface.repName));
        logger.debug((Object)("reportFileDir: " + reportDefinitionFile.reportFileDir));
        Map<Object, Object> map = new HashMap();
        map = this.filterInternalParameters(httpServletRequest.getParameterMap());
        map.put("BaseDir", reportDefinitionFile.reportFileDir);
        logger.debug((Object)("set parameter baseDir:" + reportDefinitionFile.reportFileDir));
        map.put("SUBREPORT_DIR", reportDefinitionFile.reportFileDir + File.separator);
        logger.debug((Object)("set parameter SUBREPORT_DIR:" + reportDefinitionFile.reportFileDir + File.separator));
        try {
            map.put("REPORT_LOCALE", new Locale(uRLCallInterface.repLocale.substring(0, 2), uRLCallInterface.repLocale.substring(3, 5)));
            logger.debug((Object)("set parameter REPORT_LOCALE:" + new Locale(uRLCallInterface.repLocale.substring(0, 2), uRLCallInterface.repLocale.substring(3, 5))));
        }
        catch (Exception exception) {
            Utils.throwRuntimeException("Report locale invalid: " + uRLCallInterface.repLocale);
        }
        LocalJasperReportsContext localJasperReportsContext = new LocalJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
        localJasperReportsContext.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        localJasperReportsContext.setFileResolver((FileResolver)new SimpleFileResolver(new File(reportDefinitionFile.reportFileDir)));
        try {
            connection = appConfig.getConnection(uRLCallInterface.dataSource);
            logger.info((Object)"fill report");
            object2 = JasperFillManager.getInstance((JasperReportsContext)localJasperReportsContext);
            jasperPrint = object2.fill(reportDefinitionFile.reportFile.getPath(), map, connection);
            connection.close();
        }
        catch (SQLException sQLException) {
            Utils.throwRuntimeException(sQLException.getMessage());
            DBUtils.closeQuietly(connection);
        }
        catch (JRException jRException) {
            Utils.throwRuntimeException(jRException.getMessage());
            {
                catch (Throwable throwable) {
                    DBUtils.closeQuietly(connection);
                    throw throwable;
                }
            }
            DBUtils.closeQuietly(connection);
        }
        DBUtils.closeQuietly(connection);
        if (uRLCallInterface.repFormat.equals("pdf")) {
            string2 = "application/pdf";
            jRPdfExporter = new JRPdfExporter();
            jRPdfExporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)servletOutputStream));
        }
        if (uRLCallInterface.repFormat.equals("docx")) {
            string2 = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            jRPdfExporter = new JRDocxExporter();
            jRPdfExporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)servletOutputStream));
        }
        if (uRLCallInterface.repFormat.equals("pptx")) {
            string2 = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            jRPdfExporter = new JRPptxExporter();
            jRPdfExporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)servletOutputStream));
        }
        if (uRLCallInterface.repFormat.equals("xlsx")) {
            string2 = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            jRPdfExporter = new JRXlsxExporter();
            jRPdfExporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)servletOutputStream));
        }
        if (uRLCallInterface.repFormat.equals("rtf")) {
            string2 = "application/rtf";
            jRPdfExporter = new JRRtfExporter();
            jRPdfExporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)servletOutputStream));
        }
        if (uRLCallInterface.repFormat.equals("html") || uRLCallInterface.repFormat.equals("html2")) {
            string2 = "text/html";
            jRPdfExporter = new HtmlExporter();
            object2 = new SimpleHtmlExporterOutput((OutputStream)servletOutputStream);
            jRPdfExporter.setExporterOutput((ExporterOutput)object2);
            object = new SimpleHtmlReportConfiguration();
            string = uRLCallInterface.imagesURI.replace("#IMAGE_NAME#", "{0}") + "&uuid=" + UUID.randomUUID().toString();
            string = string.replace("#J2EE_CONTEXT_PATH#", httpServletRequest.getContextPath());
            object2.setImageHandler((HtmlResourceHandler)new WebHtmlResourceHandler(string));
            logger.debug((Object)(" IMAGES_URI=" + string));
            jRPdfExporter.setConfiguration((ReportExportConfiguration)object);
            httpServletRequest.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
        }
        if (uRLCallInterface.repFormat.equals("xls")) {
            string2 = "application/vnd.ms-excel";
            jRPdfExporter = new JRXlsExporter();
            jRPdfExporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)servletOutputStream));
        }
        if (uRLCallInterface.repFormat.equals("csv")) {
            string2 = "application/vnd.ms-excel";
            jRPdfExporter = new JRCsvExporter();
            jRPdfExporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)servletOutputStream));
        }
        logger.debug((Object)("set contentType=" + string2));
        httpServletResponse.setContentType(string2 + "; charset=" + uRLCallInterface.repEncoding);
        httpServletResponse.setLocale(new Locale(uRLCallInterface.repLocale));
        httpServletResponse.setHeader("content-type", string2 + "; charset=" + uRLCallInterface.repEncoding);
        if (uRLCallInterface.outFilename != null && !"".equals(uRLCallInterface.outFilename)) {
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + uRLCallInterface.outFilename);
        }
        if (uRLCallInterface.saveIsEnabled.booleanValue()) {
            logger.info((Object)("user wants to save file to " + uRLCallInterface.saveFileName));
            if (appConfig.saveFileIsEnabled) {
                logger.trace((Object)"saveFile is enabled in the configuration file");
                object2 = new File(uRLCallInterface.saveFileName);
                object = ((File)object2).getName();
                string = ((File)object2).getParent();
                logger.trace((Object)("dirName: " + string));
                logger.trace((Object)("filename: " + (String)object));
                if (!appConfig.isWhitelistDirectory(string)) {
                    Utils.throwRuntimeException("Directory " + string + " is not specified as a whitelist target directory in application.properties.");
                }
                if (!((File)object2).getParentFile().exists()) {
                    Utils.throwRuntimeException("Directory " + string + " does not exist.");
                }
                logger.info((Object)("export report to file: " + uRLCallInterface.saveFileName));
                try {
                    SimpleOutputStreamExporterOutput simpleOutputStreamExporterOutput = new SimpleOutputStreamExporterOutput((File)object2);
                    jRPdfExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    jRPdfExporter.setExporterOutput((ExporterOutput)simpleOutputStreamExporterOutput);
                    jRPdfExporter.exportReport();
                }
                catch (JRException jRException) {
                    Utils.throwRuntimeException(jRException.getMessage());
                }
            } else {
                Utils.throwRuntimeException("saveFile is not enabled in application.properties.");
            }
        }
        if (uRLCallInterface.printIsEnabled.booleanValue()) {
            logger.debug((Object)"user wants to use printer directly ...  ");
            if (appConfig.printIsEnabled) {
                logger.trace((Object)"printing is enabled in the configuration file");
                object2 = new PrinterUtilities();
                ((PrinterUtilities)object2).print(jasperPrint, uRLCallInterface.printPrinterName, uRLCallInterface.printPrinterTray, uRLCallInterface.printCopies, uRLCallInterface.printDuplex, uRLCallInterface.printCollate);
            } else {
                Utils.throwRuntimeException("direct printing is not enabled in application.properties.");
            }
        }
        logger.info((Object)"export report");
        try {
            jRPdfExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
            jRPdfExporter.exportReport();
        }
        catch (JRException jRException) {
            Utils.throwRuntimeException(jRException.getMessage());
        }
        servletOutputStream.close();
        logger.info((Object)"service() end");
    }
}

