/*
 * Decompiled with CFR 0.152.
 */
package de.oc.integration.jasper.webapp;

import de.oc.utils.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PrinterServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)PrinterServlet.class.getName());
    private static final String CONTENT_TYPE = "text/html; charset=windows-1252";

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        logger.info((Object)"doGet() - start");
        httpServletResponse.setContentType(CONTENT_TYPE);
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<head><title>Printer diagnostics</title></head>");
        printWriter.println("<body>");
        printWriter.println("<h3>Printer Diagnostics</h3>");
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, hashPrintRequestAttributeSet);
        if (printServiceArray.length == 0) {
            Utils.throwRuntimeException("No printer service available");
        }
        logger.info((Object)"Available printer:");
        for (int i = 0; i < printServiceArray.length; ++i) {
            printWriter.println("available printers: " + printServiceArray[i] + " / " + printServiceArray[i].getName());
            printWriter.println("<br>ID: " + i);
            logger.info((Object)(" - " + printServiceArray[i].getName()));
            this.printPrintServiceAttributesAndDocFlavors(printServiceArray[i]);
        }
        printWriter.println("</body></html>");
        printWriter.close();
        logger.info((Object)"doGet() - end");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private void printPrintServiceAttributesAndDocFlavors(PrintService printService) {
        String string;
        int n;
        String string2 = null;
        Attribute[] attributeArray = printService.getAttributes().toArray();
        DocFlavor[] docFlavorArray = printService.getSupportedDocFlavors();
        Class<?>[] classArray = printService.getSupportedAttributeCategories();
        if (null != attributeArray && 0 < attributeArray.length) {
            for (n = 0; n < attributeArray.length; ++n) {
                string = "      PrintService-Attribute[" + n + "]: " + attributeArray[n].getName() + " = " + attributeArray[n];
                logger.info((Object)("   - " + string));
            }
        }
        if (null != attributeArray && 0 < attributeArray.length) {
            for (n = 0; n < attributeArray.length; ++n) {
                string = "      PrintService-Attribute[" + n + "]: " + attributeArray[n].getName() + " = " + attributeArray[n];
                logger.info((Object)("   - " + string));
            }
        }
        if (null != docFlavorArray && 0 < docFlavorArray.length) {
            for (n = 0; n < docFlavorArray.length; ++n) {
                String string3 = docFlavorArray[n].getMimeType();
                if (null != string3 && !string3.equals(string2)) {
                    string = "      PrintService-DocFlavor-Mime[" + n + "]: " + string3;
                    logger.info((Object)("   - " + string));
                }
                string2 = string3;
            }
        }
        for (n = 0; n < classArray.length; ++n) {
            string = "      Category[" + n + "]: " + classArray[n].getName() + " = " + classArray[n] + "; DEFAULT: " + printService.getDefaultAttributeValue(classArray[n]);
            logger.info((Object)("   - " + string));
            Object object = printService.getSupportedAttributeValues(classArray[n], null, null);
            if (object.getClass().isArray()) {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    logger.info((Object)("     supported value(s): " + objectArray[i].toString()));
                }
                continue;
            }
            logger.info((Object)("     supported values: " + object.toString()));
        }
    }
}

