/*
 * Decompiled with CFR 0.152.
 */
package de.oc.integration.jasper.webapp;

import de.oc.db.ConnectionUtility;
import de.oc.db.DataSourceDefinition;
import de.oc.utils.Encryptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class AppConfig {
    public static final String OC_JASPER_CONFIG_HOME_INIT = "oc.jasper.config.home";
    public static final String OC_JASPER_CONFIG_HOME_ENV = "OC_JASPER_CONFIG_HOME";
    public static final String OC_JASPER_WEBAPP_HOME = "oc.jasper.webapp.home";
    public static final String APPLICATION_PROPERTIES_FILE = "application.properties";
    public static final String key2 = "ThisIsASecretKet";
    public boolean enablePasswordOverURL = false;
    public boolean displayPrintDialog = false;
    public String configFileVersion = null;
    private HashMap<String, DataSourceDefinition> _dataSourceDefinitions = new HashMap();
    public boolean infoPageIsEnabled = false;
    public boolean printIsEnabled = false;
    public boolean saveFileIsEnabled = false;
    private String[] _directoryWhitelist = null;
    private static Logger _logger = Logger.getLogger(AppConfig.class);
    private static AppConfig _instance = null;
    private static String _configHomeDir;
    private static String _webappHomeDir;
    private static String _initParameterConfigHomeDir;
    private static String _envVariableConfigHomeDir;
    private static String _applicationPropertiesFileName;
    private HierarchicalINIConfiguration _applicationProperties = new HierarchicalINIConfiguration();
    private static ConnectionUtility _connectionUtility;
    private String _jndiPrefix = "java:comp/env/jdbc/";

    public static AppConfig getInstance() {
        if (_instance == null) {
            _instance = new AppConfig();
        }
        return _instance;
    }

    private AppConfig() {
    }

    public void initialize(ServletContext servletContext) {
        _logger.info((Object)"initialize AppConfig()");
        _webappHomeDir = servletContext.getRealPath("/");
        if (_webappHomeDir.endsWith("/")) {
            _webappHomeDir = _webappHomeDir.substring(0, _webappHomeDir.length() - 1);
        }
        _initParameterConfigHomeDir = servletContext.getInitParameter(OC_JASPER_CONFIG_HOME_INIT);
        _envVariableConfigHomeDir = System.getenv(OC_JASPER_CONFIG_HOME_ENV);
        _logger.debug((Object)"determine the location of the config file");
        _configHomeDir = this.nvl(_initParameterConfigHomeDir, _envVariableConfigHomeDir);
        _configHomeDir = this.nvl(_configHomeDir, _webappHomeDir + File.separator + "WEB-INF");
        _applicationPropertiesFileName = this.getConfigHomeDir() + File.separator + "conf" + File.separator + APPLICATION_PROPERTIES_FILE;
        _logger.info((Object)("** webappHomeDir:" + _webappHomeDir));
        _logger.info((Object)("** InitParameter oc.jasper.config.home:" + _initParameterConfigHomeDir));
        _logger.info((Object)("** Environment variable OC_JASPER_CONFIG_HOME:" + _envVariableConfigHomeDir));
        _logger.info((Object)("** configHomeDir:" + _configHomeDir));
        _logger.info((Object)("** configFile:" + _applicationPropertiesFileName));
        _logger.info((Object)("set system property oc.jasper.config.home=" + _configHomeDir));
        System.setProperty(OC_JASPER_CONFIG_HOME_INIT, _configHomeDir);
        _logger.info((Object)("set system property oc.jasper.webapp.home=" + _webappHomeDir));
        System.setProperty(OC_JASPER_WEBAPP_HOME, _webappHomeDir);
        String string = servletContext.getInitParameter("log4j-init-file");
        _logger.info((Object)("** log4j-init-file:" + string));
        String string2 = this.getConfigHomeDir() + File.separator + "conf" + File.separator + string;
        if (string != null) {
            _logger = Logger.getLogger(this.getClass());
            _logger.info((Object)("Load log4j configuration from file: " + string2));
            PropertyConfigurator.configure((String)string2);
        }
        this.configureLogger();
        this._applicationProperties = this.loadApplicationProperties(_applicationPropertiesFileName);
        if (_logger.isDebugEnabled()) {
            this.logApplicationProperties();
        }
        this.processConfigFile(this._applicationProperties);
        _connectionUtility = ConnectionUtility.getInstance(this._jndiPrefix);
    }

    public void validateConfiguration(ServletContext servletContext) {
    }

    private void configureLogger() {
        _logger = Logger.getLogger(this.getClass());
    }

    public HierarchicalINIConfiguration loadApplicationProperties(String string) {
        HierarchicalINIConfiguration hierarchicalINIConfiguration = new HierarchicalINIConfiguration();
        String string2 = "";
        File file = new File(string);
        if (!file.exists()) {
            string2 = "File " + file + " not found.";
            _logger.error((Object)string2);
            throw new JRRuntimeException(string2);
        }
        try {
            hierarchicalINIConfiguration.load((InputStream)new FileInputStream(string));
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
            string2 = "Error during processing of application properties file: " + file + ": " + configurationException.getMessage();
            _logger.error((Object)string2);
            throw new JRRuntimeException(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            string2 = "File " + file + " not found.";
            _logger.error((Object)string2);
            throw new JRRuntimeException(string2);
        }
        _logger.info((Object)("application properties loaded from file: " + string));
        return hierarchicalINIConfiguration;
    }

    private void processConfigFile(HierarchicalINIConfiguration hierarchicalINIConfiguration) {
        _logger.debug((Object)"process properties file...");
        this.enablePasswordOverURL = Boolean.parseBoolean(hierarchicalINIConfiguration.getString("application.passUserPwdOverURL"));
        this._jndiPrefix = hierarchicalINIConfiguration.getString("application.jndiPrefix");
        this.configFileVersion = hierarchicalINIConfiguration.getString("application.configFileVersion");
        this.infoPageIsEnabled = Boolean.parseBoolean(hierarchicalINIConfiguration.getString("application.infoPageIsEnabled", "true"));
        this.printIsEnabled = Boolean.parseBoolean(hierarchicalINIConfiguration.getString("directPrinting.isEnabled"));
        this.displayPrintDialog = Boolean.parseBoolean(hierarchicalINIConfiguration.getString("directPrinting.displayPrintDialog"));
        this.saveFileIsEnabled = Boolean.parseBoolean(hierarchicalINIConfiguration.getString("saveFileOnServer.isEnabled"));
        this._directoryWhitelist = hierarchicalINIConfiguration.getStringArray("saveFileOnServer.directoryWhitelist");
        for (String string : hierarchicalINIConfiguration.getSections()) {
            _logger.trace((Object)("process section=" + string));
            if (!string.startsWith("datasource:")) continue;
            _logger.trace((Object)("datasource section found=" + string));
            String string2 = string.split(":")[1];
            DataSourceDefinition dataSourceDefinition = new DataSourceDefinition(hierarchicalINIConfiguration.getString(string + ".type"), string2, hierarchicalINIConfiguration.getString(string + ".url"), hierarchicalINIConfiguration.getString(string + ".username"), this.decryptPWD(hierarchicalINIConfiguration.getString(string + ".password")));
            this._dataSourceDefinitions.put(string2, dataSourceDefinition);
            dataSourceDefinition.dump();
        }
    }

    public String getConfigHomeDir() {
        return _configHomeDir;
    }

    public String getConfigDir() {
        return _configHomeDir + File.separator + "conf";
    }

    public String getReportsDir() {
        return _configHomeDir + File.separator + "reports";
    }

    public String getLogsDir() {
        return _configHomeDir + File.separator + "logs";
    }

    public String getTmpDir() {
        return _webappHomeDir + File.separator + "report_tmp";
    }

    public String getApplicationPropertiesFileName() {
        return _applicationPropertiesFileName;
    }

    public boolean isWhitelistDirectory(String string) {
        for (int i = 0; i < this._directoryWhitelist.length; ++i) {
            if (!this._directoryWhitelist[i].toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String nvl(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string.equals("")) {
            return string2;
        }
        return string;
    }

    public void logApplicationProperties() {
        Iterator iterator = this._applicationProperties.getKeys();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (((String)e).endsWith(".password")) continue;
            _logger.debug((Object)((String)e + "=" + this._applicationProperties.getString((String)e)));
        }
    }

    public DataSourceDefinition getDataSourceDefinition(String string) {
        return this._dataSourceDefinitions.get(string);
    }

    public HashMap<String, DataSourceDefinition> getDataSources() {
        return this._dataSourceDefinitions;
    }

    public Connection getConnection(String string) {
        return _connectionUtility.getConnection(string);
    }

    public void close() {
    }

    public static String padRight(String string, int n) {
        return String.format("%1$-" + n + "s", string);
    }

    public static String padLeft(String string, int n) {
        return String.format("%1$" + n + "s", string);
    }

    public static String getKey1() {
        String string = "";
        String string2 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string2.length() > 16) {
            string2 = string2.substring(0, 16);
        }
        string = AppConfig.padRight(string2, 16).replace(" ", "|");
        return string;
    }

    public String encryptPWD(String string) {
        if (!(string = string.trim()).startsWith("1:")) {
            string = "1:" + Encryptor.encrypt(AppConfig.getKey1(), key2, string);
        }
        return string;
    }

    public String decryptPWD(String string) {
        if (string.startsWith("1:")) {
            String string2 = string.substring("1:".length());
            string = Encryptor.decrypt(AppConfig.getKey1(), key2, string2);
        }
        return string;
    }

    static {
        _connectionUtility = null;
    }
}

