/*
 * Decompiled with CFR 0.152.
 */
package de.oc.integration.jasper.webapp;

import de.oc.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class Apex
extends HttpServlet {
    private static final long serialVersionUID = 3232059099842053441L;
    HttpServletRequest _request = null;
    HttpServletResponse _response = null;
    private OutputStream _out = null;
    String _baseDir = null;
    String _reportsDir = null;
    String _xml = null;
    String _template = null;
    String _repName = null;
    String _repJRXMLFileName = null;
    File _repJRXMLFile = null;
    String _repFormat = null;
    String _xmlFileName = null;
    String _repEncoding = "UTF-8";
    private static Logger logger = Logger.getLogger((String)Apex.class.getName());

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    String nvl(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string.equals("")) {
            return string2;
        }
        return string;
    }

    void saveToFile(String string, String string2) {
        if (string != null && string2 != null) {
            try {
                File file = new File(string2);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(string.getBytes("UTF-8"));
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(new PrintWriter(this._out));
            }
        }
    }

    void getUrlParameters(HttpServletRequest httpServletRequest) {
        this._xml = httpServletRequest.getParameter("xml");
        this._template = httpServletRequest.getParameter("template");
        this._repFormat = this.nvl(httpServletRequest.getParameter("_xf"), "pdf");
        if (this._repFormat.equals("Excel")) {
            this._repFormat = "xls";
        }
    }

    void showError(String string) throws IOException {
        this._out.write("<h3>Error: ".getBytes());
        this._out.write(string.getBytes());
        this._out.write("</h3>".getBytes());
    }

    void generateReport() throws IOException, ServletException {
        Object object;
        JasperReport jasperReport = null;
        JasperPrint jasperPrint = null;
        JRPdfExporter jRPdfExporter = null;
        String string = this._repJRXMLFile.getParentFile().getAbsolutePath();
        try {
            jasperReport = JasperCompileManager.compileReport((String)this._repJRXMLFileName);
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("BaseDir", string);
        if (this._repFormat.equals("pdf")) {
            jRPdfExporter = new JRPdfExporter();
        }
        if (this._repFormat.equals("rtf")) {
            jRPdfExporter = new JRRtfExporter();
        }
        if (this._repFormat.equals("html")) {
            jRPdfExporter = new HtmlExporter();
            object = new SimpleHtmlReportConfiguration();
            jRPdfExporter.setConfiguration((ReportExportConfiguration)object);
            hashMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        }
        if (this._repFormat.equals("xls")) {
            jRPdfExporter = new JRXlsExporter();
            object = new SimpleXlsReportConfiguration();
            object.setOnePagePerSheet(Boolean.FALSE);
            object.setIgnorePageMargins(Boolean.TRUE);
            object.setWhitePageBackground(Boolean.FALSE);
            object.setRemoveEmptySpaceBetweenRows(Boolean.TRUE);
            jRPdfExporter.setConfiguration((ReportExportConfiguration)object);
            hashMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        }
        try {
            object = new ByteArrayInputStream(this._xml.getBytes("UTF-8"));
            Document document = JRXmlUtils.parse((InputStream)object);
            hashMap.put("XML_DATA_DOCUMENT", document);
            hashMap.put("XML_DATE_PATTERN", "yyyy-MM-dd");
            hashMap.put("XML_NUMBER_PATTERN", "#,##0.##");
            hashMap.put("XML_LOCALE", Locale.ENGLISH);
            hashMap.put("REPORT_LOCALE", Locale.US);
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap);
        }
        catch (JRException jRException) {
            jRException.printStackTrace(new PrintWriter(this._out));
        }
        logger.info((Object)"export report");
        try {
            object = new SimpleOutputStreamExporterOutput(this._out);
            jRPdfExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
            jRPdfExporter.setExporterOutput((ExporterOutput)object);
            jRPdfExporter.exportReport();
        }
        catch (JRException jRException) {
            Utils.throwRuntimeException(jRException.getMessage());
        }
        this._out.close();
    }

    void init(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        this._baseDir = this.getServletContext().getRealPath("/");
        this._reportsDir = this._baseDir + "/reports";
        this._request = httpServletRequest;
        this._response = httpServletResponse;
        this._out = servletOutputStream;
        this.getUrlParameters(httpServletRequest);
        this._repName = "template";
        this._xmlFileName = this._baseDir + "/reports/" + "xml.dat";
        this._repJRXMLFileName = this._baseDir + "/reports/tmp/" + this._repName + ".jrxml";
        this.saveToFile(this._xml, this._xmlFileName);
        this.saveToFile(this._template, this._repJRXMLFileName);
        this._repJRXMLFile = new File(this._xmlFileName);
    }

    void assertState() throws ServletException {
        if (this._xml == null) {
            throw new ServletException("xml feed is empty");
        }
        if (this._template == null) {
            throw new ServletException("template feed is empty");
        }
        if (!this._template.contains("<jasperReport")) {
            throw new ServletException("template feed is not valid for JasperReports");
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        httpServletRequest.setCharacterEncoding("UTF-8");
        this.init(httpServletRequest, httpServletResponse);
        this.assertState();
        this.generateReport();
    }
}

