/*
 * Decompiled with CFR 0.152.
 */
package de.oc.db;

import de.oc.db.DataSourceDefinition;
import de.oc.integration.jasper.webapp.AppConfig;
import de.oc.utils.Utils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import org.apache.log4j.Logger;

public class ConnectionUtility {
    private static ConnectionUtility instance;
    private HashMap<String, OracleConnectionPoolDataSource> dataSources = new HashMap();
    private static Logger logger;
    private String jndiPrefix = "";
    private Context initialContext = null;

    private ConnectionUtility(String string) {
        this.jndiPrefix = string;
        try {
            this.initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            logger.warn((Object)"naming context could not be established");
        }
    }

    public static synchronized ConnectionUtility getInstance(String string) {
        if (instance == null) {
            instance = new ConnectionUtility(string);
        }
        return instance;
    }

    public Connection getConnection(String string) {
        logger.trace((Object)("lookup dataSource:" + string));
        DataSourceDefinition dataSourceDefinition = AppConfig.getInstance().getDataSourceDefinition(string);
        Connection connection = null;
        if (dataSourceDefinition == null) {
            Utils.throwRuntimeException("Datasource " + string + " could not be found.");
        }
        if (dataSourceDefinition.type.equals("jndi")) {
            if (this.initialContext != null) {
                String string2 = this.jndiPrefix + string;
                logger.debug((Object)("use JNDI to lookup dataSource:" + string2));
                try {
                    DataSource dataSource = (DataSource)this.initialContext.lookup(string2);
                    if (dataSource != null) {
                        connection = dataSource.getConnection();
                    }
                }
                catch (Exception exception) {
                    logger.info((Object)("JNDI lookup failed for " + string2 + ", trying JDBC now..."));
                }
            }
        } else if (dataSourceDefinition.type.equals("jdbc") && connection == null) {
            logger.debug((Object)("use JDBC to lookup dataSource:" + string));
            try {
                logger.trace((Object)"retrieve connectionPoolDataSource from HashMap first");
                OracleConnectionPoolDataSource oracleConnectionPoolDataSource = this.dataSources.get(string);
                if (oracleConnectionPoolDataSource == null) {
                    logger.trace((Object)"dataSource not found in HashMap, initialize a new connection pool and store in HashMap");
                    Properties properties = new Properties();
                    properties.setProperty("InitialLimit", "3");
                    properties.setProperty("MinLimit", "3");
                    properties.setProperty("MaxLimit", "50");
                    oracleConnectionPoolDataSource = new OracleConnectionPoolDataSource();
                    oracleConnectionPoolDataSource.setURL(dataSourceDefinition.url);
                    oracleConnectionPoolDataSource.setUser(dataSourceDefinition.username);
                    oracleConnectionPoolDataSource.setPassword(dataSourceDefinition.password);
                    oracleConnectionPoolDataSource.setConnectionProperties(properties);
                    this.dataSources.put(string, oracleConnectionPoolDataSource);
                }
                PooledConnection pooledConnection = oracleConnectionPoolDataSource.getPooledConnection();
                connection = pooledConnection.getConnection();
                logger.info((Object)("successfully connected to " + dataSourceDefinition.url + " with user: " + dataSourceDefinition.username));
            }
            catch (SQLException sQLException) {
                Utils.throwRuntimeException("Could not connect via JDBC: " + sQLException.getMessage());
            }
        }
        if (connection != null) {
            logger.info((Object)("dataSource loaded:" + string));
        }
        return connection;
    }

    static {
        logger = Logger.getLogger((String)ConnectionUtility.class.getName());
    }
}

