/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public abstract class PoolingHttpDestination<C extends Connection>
extends HttpDestination
implements Promise<Connection> {
    private final ConnectionPool connectionPool;

    public PoolingHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
        this.connectionPool = this.newConnectionPool(client);
    }

    protected ConnectionPool newConnectionPool(HttpClient client) {
        return new ConnectionPool(this, client.getMaxConnectionsPerDestination(), this);
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void succeeded(Connection connection) {
        this.send(true);
    }

    public void failed(final Throwable x) {
        this.getHttpClient().getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                PoolingHttpDestination.this.abort(x);
            }
        });
    }

    @Override
    protected void send() {
        this.send(false);
    }

    private void send(boolean dispatch) {
        if (this.getHttpExchanges().isEmpty()) {
            return;
        }
        C connection = this.acquire();
        if (connection != null) {
            this.process(connection, dispatch);
        }
    }

    public C acquire() {
        return (C)this.connectionPool.acquire();
    }

    public void process(C connection, boolean dispatch) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", new Object[]{exchange, connection, this});
        }
        if (exchange == null) {
            if (!this.connectionPool.release((Connection)connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", new Object[]{client});
                }
                connection.close();
            }
        } else {
            HttpRequest request = exchange.getRequest();
            Throwable cause = request.getAbortCause();
            if (cause != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Aborted before processing {}: {}", new Object[]{exchange, cause});
                }
                exchange.abort(cause);
            } else if (dispatch) {
                client.getExecutor().execute(new Runnable((Connection)connection, exchange){
                    final /* synthetic */ Connection val$connection;
                    final /* synthetic */ HttpExchange val$exchange;
                    {
                        this.val$connection = connection;
                        this.val$exchange = httpExchange;
                    }

                    @Override
                    public void run() {
                        PoolingHttpDestination.this.send(this.val$connection, this.val$exchange);
                    }
                });
            } else {
                this.send(connection, exchange);
            }
        }
    }

    protected abstract void send(C var1, HttpExchange var2);

    @Override
    public void release(Connection c) {
        HttpClient client;
        Connection connection = c;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} released", new Object[]{connection});
        }
        if ((client = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                this.process(connection, false);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{} explicit", new Object[]{connection});
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is stopped", new Object[]{client});
            }
            connection.close();
        }
    }

    @Override
    public void close(Connection oldConnection) {
        super.close(oldConnection);
        this.connectionPool.remove(oldConnection);
        if (this.getHttpExchanges().isEmpty()) {
            if (this.getHttpClient().isRemoveIdleDestinations() && this.connectionPool.isEmpty()) {
                this.getHttpClient().removeDestination(this);
            }
        } else {
            C newConnection = this.acquire();
            if (newConnection != null) {
                this.process(newConnection, false);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.connectionPool.close();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList(this.connectionPool)});
    }

    @Override
    public String toString() {
        return String.format("%s,pool=%s", super.toString(), this.connectionPool);
    }
}

