/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.proxy;

import java.io.IOException;
import java.net.CookieStore;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public abstract class AbstractProxyServlet
extends HttpServlet {
    protected static final Set<String> HOP_HEADERS;
    private final Set<String> _whiteList = new HashSet<String>();
    private final Set<String> _blackList = new HashSet<String>();
    protected Logger _log;
    private String _hostHeader;
    private String _viaHost;
    private HttpClient _client;
    private long _timeout;

    public void init() throws ServletException {
        this._log = this.createLogger();
        ServletConfig config = this.getServletConfig();
        this._hostHeader = config.getInitParameter("hostHeader");
        this._viaHost = config.getInitParameter("viaHost");
        if (this._viaHost == null) {
            this._viaHost = AbstractProxyServlet.viaHost();
        }
        try {
            String blackList;
            this._client = this.createHttpClient();
            this.getServletContext().setAttribute(config.getServletName() + ".HttpClient", (Object)this._client);
            String whiteList = config.getInitParameter("whiteList");
            if (whiteList != null) {
                this.getWhiteListHosts().addAll(this.parseList(whiteList));
            }
            if ((blackList = config.getInitParameter("blackList")) != null) {
                this.getBlackListHosts().addAll(this.parseList(blackList));
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        block2: {
            try {
                this._client.stop();
            }
            catch (Exception x) {
                if (!this._log.isDebugEnabled()) break block2;
                this._log.debug((Throwable)x);
            }
        }
    }

    public String getHostHeader() {
        return this._hostHeader;
    }

    public String getViaHost() {
        return this._viaHost;
    }

    private static String viaHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException x) {
            return "localhost";
        }
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public Set<String> getWhiteListHosts() {
        return this._whiteList;
    }

    public Set<String> getBlackListHosts() {
        return this._blackList;
    }

    protected Logger createLogger() {
        String servletName = this.getServletConfig().getServletName();
        servletName = servletName.replace('-', '.');
        if (((Object)((Object)this)).getClass().getPackage() != null && !servletName.startsWith(((Object)((Object)this)).getClass().getPackage().getName())) {
            servletName = ((Object)((Object)this)).getClass().getName() + "." + servletName;
        }
        return Log.getLogger((String)servletName);
    }

    protected HttpClient createHttpClient() throws ServletException {
        Executor executor;
        ServletConfig config = this.getServletConfig();
        HttpClient client = this.newHttpClient();
        client.setFollowRedirects(false);
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        String value = config.getInitParameter("maxThreads");
        if (value == null || "-".equals(value)) {
            executor = (Executor)this.getServletContext().getAttribute("org.eclipse.jetty.server.Executor");
            if (executor == null) {
                throw new IllegalStateException("No server executor for proxy");
            }
        } else {
            QueuedThreadPool qtp = new QueuedThreadPool(Integer.parseInt(value));
            String servletName = config.getServletName();
            int dot = servletName.lastIndexOf(46);
            if (dot >= 0) {
                servletName = servletName.substring(dot + 1);
            }
            qtp.setName(servletName);
            executor = qtp;
        }
        client.setExecutor(executor);
        value = config.getInitParameter("maxConnections");
        if (value == null) {
            value = "256";
        }
        client.setMaxConnectionsPerDestination(Integer.parseInt(value));
        value = config.getInitParameter("idleTimeout");
        if (value == null) {
            value = "30000";
        }
        client.setIdleTimeout(Long.parseLong(value));
        value = config.getInitParameter("timeout");
        if (value == null) {
            value = "60000";
        }
        this._timeout = Long.parseLong(value);
        value = config.getInitParameter("requestBufferSize");
        if (value != null) {
            client.setRequestBufferSize(Integer.parseInt(value));
        }
        if ((value = config.getInitParameter("responseBufferSize")) != null) {
            client.setResponseBufferSize(Integer.parseInt(value));
        }
        try {
            client.start();
            client.getContentDecoderFactories().clear();
            return client;
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected HttpClient newHttpClient() {
        return new HttpClient();
    }

    protected HttpClient getHttpClient() {
        return this._client;
    }

    private Set<String> parseList(String list) {
        String[] hosts;
        HashSet<String> result = new HashSet<String>();
        for (String host : hosts = list.split(",")) {
            if ((host = host.trim()).length() == 0) continue;
            result.add(host);
        }
        return result;
    }

    public boolean validateDestination(String host, int port) {
        String hostPort = host + ":" + port;
        if (!this._whiteList.isEmpty() && !this._whiteList.contains(hostPort)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Host {}:{} not whitelisted", new Object[]{host, port});
            }
            return false;
        }
        if (!this._blackList.isEmpty() && this._blackList.contains(hostPort)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Host {}:{} blacklisted", new Object[]{host, port});
            }
            return false;
        }
        return true;
    }

    protected String rewriteTarget(HttpServletRequest clientRequest) {
        if (!this.validateDestination(clientRequest.getServerName(), clientRequest.getServerPort())) {
            return null;
        }
        StringBuffer target = clientRequest.getRequestURL();
        String query = clientRequest.getQueryString();
        if (query != null) {
            target.append("?").append(query);
        }
        return target.toString();
    }

    protected void onProxyRewriteFailed(HttpServletRequest clientRequest, HttpServletResponse clientResponse) {
        clientResponse.setStatus(403);
    }

    protected boolean hasContent(HttpServletRequest clientRequest) {
        return clientRequest.getContentLength() > 0 || clientRequest.getContentType() != null || clientRequest.getHeader(HttpHeader.TRANSFER_ENCODING.asString()) != null;
    }

    protected void copyRequestHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        proxyRequest.getHeaders().clear();
        Set<String> headersToRemove = this.findConnectionHeaders(clientRequest);
        Enumeration headerNames = clientRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String lowerHeaderName = headerName.toLowerCase(Locale.ENGLISH);
            if (HttpHeader.HOST.is(headerName) || HOP_HEADERS.contains(lowerHeaderName) || headersToRemove != null && headersToRemove.contains(lowerHeaderName)) continue;
            Enumeration headerValues = clientRequest.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                if (headerValue == null) continue;
                proxyRequest.header(headerName, headerValue);
            }
        }
        if (this._hostHeader != null) {
            proxyRequest.header(HttpHeader.HOST, this._hostHeader);
        }
    }

    protected Set<String> findConnectionHeaders(HttpServletRequest clientRequest) {
        HashSet<String> hopHeaders = null;
        Enumeration connectionHeaders = clientRequest.getHeaders(HttpHeader.CONNECTION.asString());
        while (connectionHeaders.hasMoreElements()) {
            String[] values;
            String value = (String)connectionHeaders.nextElement();
            for (String name : values = value.split(",")) {
                name = name.trim().toLowerCase(Locale.ENGLISH);
                if (hopHeaders == null) {
                    hopHeaders = new HashSet<String>();
                }
                hopHeaders.add(name);
            }
        }
        return hopHeaders;
    }

    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        this.addViaHeader(proxyRequest);
        this.addXForwardedHeaders(clientRequest, proxyRequest);
    }

    protected void addViaHeader(Request proxyRequest) {
        proxyRequest.header(HttpHeader.VIA, "http/1.1 " + this.getViaHost());
    }

    protected void addXForwardedHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        proxyRequest.header(HttpHeader.X_FORWARDED_FOR, clientRequest.getRemoteAddr());
        proxyRequest.header(HttpHeader.X_FORWARDED_PROTO, clientRequest.getScheme());
        proxyRequest.header(HttpHeader.X_FORWARDED_HOST, clientRequest.getHeader(HttpHeader.HOST.asString()));
        proxyRequest.header(HttpHeader.X_FORWARDED_SERVER, clientRequest.getLocalName());
    }

    protected void sendProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
        if (this._log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(clientRequest.getMethod());
            builder.append(" ").append(clientRequest.getRequestURI());
            String query = clientRequest.getQueryString();
            if (query != null) {
                builder.append("?").append(query);
            }
            builder.append(" ").append(clientRequest.getProtocol()).append(System.lineSeparator());
            Enumeration headerNames = clientRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                builder.append(headerName).append(": ");
                Enumeration headerValues = clientRequest.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    if (headerValue != null) {
                        builder.append(headerValue);
                    }
                    if (!headerValues.hasMoreElements()) continue;
                    builder.append(",");
                }
                builder.append(System.lineSeparator());
            }
            builder.append(System.lineSeparator());
            this._log.debug("{} proxying to upstream:{}{}{}{}", new Object[]{this.getRequestId(clientRequest), System.lineSeparator(), builder, proxyRequest, System.lineSeparator(), proxyRequest.getHeaders().toString().trim()});
        }
        proxyRequest.send(this.newProxyResponseListener(clientRequest, proxyResponse));
    }

    protected abstract Response.CompleteListener newProxyResponseListener(HttpServletRequest var1, HttpServletResponse var2);

    protected void onClientRequestFailure(HttpServletRequest clientRequest, Request proxyRequest, HttpServletResponse proxyResponse, Throwable failure) {
        boolean aborted = proxyRequest.abort(failure);
        if (!aborted) {
            proxyResponse.setStatus(500);
            clientRequest.getAsyncContext().complete();
        }
    }

    protected void onServerResponseHeaders(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Response serverResponse) {
        for (HttpField field : serverResponse.getHeaders()) {
            String newHeaderValue;
            String headerName = field.getName();
            String lowerHeaderName = headerName.toLowerCase(Locale.ENGLISH);
            if (HOP_HEADERS.contains(lowerHeaderName) || (newHeaderValue = this.filterServerResponseHeader(clientRequest, serverResponse, headerName, field.getValue())) == null || newHeaderValue.trim().length() == 0) continue;
            proxyResponse.addHeader(headerName, newHeaderValue);
        }
        if (this._log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(System.lineSeparator());
            builder.append(clientRequest.getProtocol()).append(" ").append(proxyResponse.getStatus()).append(" ").append(serverResponse.getReason()).append(System.lineSeparator());
            for (String headerName : proxyResponse.getHeaderNames()) {
                builder.append(headerName).append(": ");
                Iterator headerValues = proxyResponse.getHeaders(headerName).iterator();
                while (headerValues.hasNext()) {
                    String headerValue = (String)headerValues.next();
                    if (headerValue != null) {
                        builder.append(headerValue);
                    }
                    if (!headerValues.hasNext()) continue;
                    builder.append(",");
                }
                builder.append(System.lineSeparator());
            }
            this._log.debug("{} proxying to downstream:{}{}{}{}{}", new Object[]{this.getRequestId(clientRequest), System.lineSeparator(), serverResponse, System.lineSeparator(), serverResponse.getHeaders().toString().trim(), System.lineSeparator(), builder});
        }
    }

    protected String filterServerResponseHeader(HttpServletRequest clientRequest, Response serverResponse, String headerName, String headerValue) {
        return headerValue;
    }

    protected void onProxyResponseSuccess(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Response serverResponse) {
        if (this._log.isDebugEnabled()) {
            this._log.debug("{} proxying successful", (long)this.getRequestId(clientRequest));
        }
        AsyncContext asyncContext = clientRequest.getAsyncContext();
        asyncContext.complete();
    }

    protected void onProxyResponseFailure(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Response serverResponse, Throwable failure) {
        if (this._log.isDebugEnabled()) {
            this._log.debug(this.getRequestId(clientRequest) + " proxying failed", failure);
        }
        if (proxyResponse.isCommitted()) {
            try {
                proxyResponse.sendError(-1);
                AsyncContext asyncContext = clientRequest.getAsyncContext();
                asyncContext.complete();
            }
            catch (IOException x) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug(this.getRequestId(clientRequest) + " could not close the connection", failure);
                }
            }
        } else {
            proxyResponse.resetBuffer();
            if (failure instanceof TimeoutException) {
                proxyResponse.setStatus(504);
            } else {
                proxyResponse.setStatus(502);
            }
            proxyResponse.setHeader(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
            AsyncContext asyncContext = clientRequest.getAsyncContext();
            asyncContext.complete();
        }
    }

    protected int getRequestId(HttpServletRequest clientRequest) {
        return System.identityHashCode(clientRequest);
    }

    static {
        HashSet<String> hopHeaders = new HashSet<String>();
        hopHeaders.add("connection");
        hopHeaders.add("keep-alive");
        hopHeaders.add("proxy-authorization");
        hopHeaders.add("proxy-authenticate");
        hopHeaders.add("proxy-connection");
        hopHeaders.add("transfer-encoding");
        hopHeaders.add("te");
        hopHeaders.add("trailer");
        hopHeaders.add("upgrade");
        HOP_HEADERS = Collections.unmodifiableSet(hopHeaders);
    }
}

