/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.nio.file.TFileSystemProvider;
import de.schlichtherle.truezip.nio.file.TPath;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.FilteringIterator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TFileSystem
extends FileSystem {
    private final FsController<?> controller;
    private final TFileSystemProvider provider;

    TFileSystem(TPath path) {
        assert (null != path);
        this.controller = TConfig.get().getFsManager().getController(path.getMountPoint(), path.getArchiveDetector());
        this.provider = TFileSystemProvider.get(path.getName());
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.getController());
        assert (null != this.provider());
        return true;
    }

    public static boolean isLenient() {
        return TConfig.get().isLenient();
    }

    public static void setLenient(boolean lenient) {
        TConfig.get().setLenient(lenient);
    }

    private FsController<?> getController() {
        return this.controller;
    }

    FsMountPoint getMountPoint() {
        return ((FsModel)this.getController().getModel()).getMountPoint();
    }

    @Override
    public TFileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws FsSyncException {
        this.sync(FsSyncOptions.UMOUNT);
    }

    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        TVFS.sync(this.getMountPoint(), options);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(new TPath(this.getMountPoint().toHierarchicalUri().resolve("/")));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Collections.singleton("basic");
    }

    @Override
    public TPath getPath(String first, String ... more) {
        return new TPath(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    SeekableByteChannel newByteChannel(TPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FsEntryName name = path.getEntryName();
        FsController<?> controller = this.getController();
        if (options.isEmpty() || options.contains(StandardOpenOption.READ)) {
            BitField<FsInputOption> o = path.mapInput(options).set(FsInputOption.CACHE);
            return controller.getInputSocket(name, o).newSeekableByteChannel();
        }
        BitField<FsOutputOption> o = path.mapOutput(options).set(FsOutputOption.CACHE);
        try {
            return controller.getOutputSocket(name, o, null).newSeekableByteChannel();
        }
        catch (IOException ex) {
            if (o.get(FsOutputOption.EXCLUSIVE) && null != controller.getEntry(name)) {
                throw (IOException)new FileAlreadyExistsException(path.toString()).initCause(ex);
            }
            throw ex;
        }
    }

    InputStream newInputStream(TPath path, OpenOption ... options) throws IOException {
        return this.getController().getInputSocket(path.getEntryName(), path.mapInput(options)).newInputStream();
    }

    OutputStream newOutputStream(TPath path, OpenOption ... options) throws IOException {
        return this.getController().getOutputSocket(path.getEntryName(), path.mapOutput(options), null).newOutputStream();
    }

    DirectoryStream<Path> newDirectoryStream(final TPath path, final DirectoryStream.Filter<? super Path> filter) throws IOException {
        Set<String> set;
        FsEntry entry = this.getEntry(path);
        if (null == entry || null == (set = entry.getMembers())) {
            throw new NotDirectoryException(path.toString());
        }
        @NotThreadSafe
        class FilterIterator
        extends FilteringIterator<Path> {
            FilterIterator() {
                @NotThreadSafe
                class Adapter
                implements Iterator<Path> {
                    final Iterator<String> it;
                    final /* synthetic */ Set val$set;
                    final /* synthetic */ TPath val$path;

                    Adapter() {
                        this.val$set = set;
                        this.val$path = tPath;
                        this.it = this.val$set.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Path next() {
                        return this.val$path.resolve(this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
                super(new Adapter(TFileSystem.this, set2, tPath));
            }

            @Override
            protected boolean accept(Path element) {
                try {
                    return filter.accept(element);
                }
                catch (IOException ex) {
                    throw new DirectoryIteratorException(ex);
                }
            }
        }
        return new Stream(new FilterIterator());
    }

    void createDirectory(TPath path, FileAttribute<?> ... attrs) throws IOException {
        if (0 < attrs.length) {
            throw new UnsupportedOperationException();
        }
        FsController<?> controller = this.getController();
        FsEntryName name = path.getEntryName();
        try {
            controller.mknod(name, Entry.Type.DIRECTORY, path.getOutputPreferences(), null);
        }
        catch (IOException ex) {
            if (null != controller.getEntry(name)) {
                throw (IOException)new FileAlreadyExistsException(path.toString()).initCause(ex);
            }
            throw ex;
        }
    }

    void delete(TPath path) throws IOException {
        this.getController().unlink(path.getEntryName(), path.getOutputPreferences());
    }

    FsEntry getEntry(TPath path) throws IOException {
        return this.getController().getEntry(path.getEntryName());
    }

    InputSocket<?> getInputSocket(TPath path, BitField<FsInputOption> options) {
        return this.getController().getInputSocket(path.getEntryName(), options);
    }

    OutputSocket<?> getOutputSocket(TPath path, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return this.getController().getOutputSocket(path.getEntryName(), options, template);
    }

    void checkAccess(TPath path, AccessMode ... modes) throws IOException {
        FsEntryName name = path.getEntryName();
        FsController<?> controller = this.getController();
        if (null == controller.getEntry(name)) {
            throw new NoSuchFileException(path.toString());
        }
        block5: for (AccessMode m : modes) {
            switch (m) {
                case READ: {
                    if (controller.isReadable(name)) continue block5;
                    throw new AccessDeniedException(path.toString());
                }
                case WRITE: {
                    if (controller.isWritable(name)) continue block5;
                    throw new AccessDeniedException(path.toString());
                }
                case EXECUTE: {
                    if (controller.isExecutable(name)) continue block5;
                    throw new AccessDeniedException(path.toString());
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    @Nullable
    <V extends FileAttributeView> V getFileAttributeView(TPath path, Class<V> type, LinkOption ... options) {
        if (type.isAssignableFrom(BasicFileAttributeView.class)) {
            return (V)((FileAttributeView)type.cast(new FsEntryAttributeView(path)));
        }
        return null;
    }

    <A extends BasicFileAttributes> A readAttributes(TPath path, Class<A> type, LinkOption ... options) throws IOException {
        if (type.isAssignableFrom(BasicFileAttributes.class)) {
            return (A)((BasicFileAttributes)type.cast(new FsEntryAttributes(path)));
        }
        throw new UnsupportedOperationException();
    }

    private final class FsEntryAttributes
    implements BasicFileAttributes {
        private final FsEntry entry;

        FsEntryAttributes(TPath path) throws IOException {
            this.entry = TFileSystem.this.getController().getEntry(path.getEntryName());
            if (null == this.entry) {
                throw new NoSuchFileException(path.toString());
            }
        }

        @Override
        public FileTime lastModifiedTime() {
            return FileTime.fromMillis(this.entry.getTime(Entry.Access.WRITE));
        }

        @Override
        public FileTime lastAccessTime() {
            return FileTime.fromMillis(this.entry.getTime(Entry.Access.READ));
        }

        @Override
        public FileTime creationTime() {
            return FileTime.fromMillis(this.entry.getTime(Entry.Access.CREATE));
        }

        @Override
        public boolean isRegularFile() {
            return this.entry.isType(Entry.Type.FILE);
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isType(Entry.Type.DIRECTORY);
        }

        @Override
        public boolean isSymbolicLink() {
            return this.entry.isType(Entry.Type.SYMLINK);
        }

        @Override
        public boolean isOther() {
            return this.entry.isType(Entry.Type.SPECIAL);
        }

        @Override
        public long size() {
            long size = this.entry.getSize(Entry.Size.DATA);
            return -1L == size ? 0L : size;
        }

        @Override
        public Object fileKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final class FsEntryAttributeView
    implements BasicFileAttributeView {
        private final TPath path;

        FsEntryAttributeView(TPath path) {
            this.path = path;
        }

        @Override
        public String name() {
            return "basic";
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            return new FsEntryAttributes(this.path);
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            FsController controller = TFileSystem.this.getController();
            EnumMap<Entry.Access, Long> times = new EnumMap<Entry.Access, Long>(Entry.Access.class);
            if (null != lastModifiedTime) {
                times.put(Entry.Access.WRITE, lastModifiedTime.toMillis());
            }
            if (null != lastAccessTime) {
                times.put(Entry.Access.READ, lastAccessTime.toMillis());
            }
            if (null != createTime) {
                times.put(Entry.Access.CREATE, createTime.toMillis());
            }
            controller.setTime(this.path.getEntryName(), times, this.path.getOutputPreferences());
        }
    }

    @NotThreadSafe
    private static final class Stream
    implements DirectoryStream<Path> {
        final Iterator<Path> it;
        boolean consumed;

        Stream(Iterator<Path> it) {
            this.it = it;
        }

        @Override
        public Iterator<Path> iterator() {
            if (this.consumed) {
                throw new IllegalStateException();
            }
            this.consumed = true;
            return this.it;
        }

        @Override
        public void close() {
            this.consumed = true;
        }
    }
}

